(function (factory) {
    typeof define === 'function' && define.amd ? define(factory) :
    factory();
})((function () { 'use strict';

    const BUILD = {
        allRenderFn: false,
        cmpDidLoad: true,
        cmpDidUnload: false,
        cmpDidUpdate: true,
        cmpDidRender: true,
        cmpWillLoad: true,
        cmpWillUpdate: true,
        cmpWillRender: true,
        connectedCallback: true,
        disconnectedCallback: true,
        element: true,
        event: true,
        hasRenderFn: true,
        lifecycle: true,
        hostListener: true,
        hostListenerTargetWindow: true,
        hostListenerTargetDocument: true,
        hostListenerTargetBody: true,
        hostListenerTargetParent: false,
        hostListenerTarget: true,
        member: true,
        method: true,
        mode: true,
        observeAttribute: true,
        prop: true,
        propMutable: true,
        reflect: true,
        scoped: true,
        shadowDom: true,
        slot: true,
        cssAnnotations: true,
        state: true,
        style: true,
        svg: true,
        updatable: true,
        vdomAttribute: true,
        vdomXlink: true,
        vdomClass: true,
        vdomFunctional: true,
        vdomKey: true,
        vdomListener: true,
        vdomRef: true,
        vdomPropOrAttr: true,
        vdomRender: true,
        vdomStyle: true,
        vdomText: true,
        watchCallback: true,
        taskQueue: true,
        hotModuleReplacement: false,
        isDebug: false,
        isDev: false,
        isTesting: false,
        hydrateServerSide: false,
        hydrateClientSide: false,
        lifecycleDOMEvents: false,
        lazyLoad: false,
        profile: false,
        slotRelocation: true,
        appendChildSlotFix: false,
        cloneNodeFix: false,
        hydratedAttribute: false,
        hydratedClass: true,
        safari10: false,
        scriptDataOpts: false,
        scopedSlotTextContentFix: false,
        shadowDomShim: false,
        slotChildNodesFix: false,
        invisiblePrehydration: true,
        propBoolean: true,
        propNumber: true,
        propString: true,
        cssVarShim: false,
        constructableCSS: true,
        cmpShouldUpdate: true,
        devTools: false,
        dynamicImportShim: false,
        shadowDelegatesFocus: true,
        initializeNextTick: false,
        asyncLoading: false,
        asyncQueue: false,
        transformTagName: false,
        attachStyles: true,
    };

    let scopeId;
    let contentRef;
    let hostTagName;
    let useNativeShadowDom = false;
    let checkSlotFallbackVisibility = false;
    let checkSlotRelocate = false;
    let isSvgMode = false;
    let renderingRef = null;
    let queuePending = false;
    const win = typeof window !== 'undefined' ? window : {};
    BUILD.cssVarShim ? win.CSS : null;
    const doc = win.document || { head: {} };
    const H = (win.HTMLElement || class {
    });
    const plt = {
        $flags$: 0,
        $resourcesUrl$: '',
        jmp: (h) => h(),
        raf: (h) => requestAnimationFrame(h),
        ael: (el, eventName, listener, opts) => el.addEventListener(eventName, listener, opts),
        rel: (el, eventName, listener, opts) => el.removeEventListener(eventName, listener, opts),
        ce: (eventName, opts) => new CustomEvent(eventName, opts),
    };
    const supportsShadow = BUILD.shadowDomShim && BUILD.shadowDom
        ? /*@__PURE__*/ (() => (doc.head.attachShadow + '').indexOf('[native') > -1)()
        : true;
    const supportsListenerOptions = /*@__PURE__*/ (() => {
        let supportsListenerOptions = false;
        try {
            doc.addEventListener('e', null, Object.defineProperty({}, 'passive', {
                get() {
                    supportsListenerOptions = true;
                },
            }));
        }
        catch (e) { }
        return supportsListenerOptions;
    })();
    const promiseResolve = (v) => Promise.resolve(v);
    const supportsConstructibleStylesheets = BUILD.constructableCSS
        ? /*@__PURE__*/ (() => {
            try {
                new CSSStyleSheet();
                return typeof new CSSStyleSheet().replace === 'function';
            }
            catch (e) { }
            return false;
        })()
        : false;
    const addHostEventListeners = (elm, hostRef, listeners, attachParentListeners) => {
        if (listeners) {
            listeners.map(([flags, name, method]) => {
                const target = getHostListenerTarget(elm, flags) ;
                const handler = hostListenerProxy(hostRef, method);
                const opts = hostListenerOpts(flags);
                plt.ael(target, name, handler, opts);
                (hostRef.$rmListeners$ = hostRef.$rmListeners$ || []).push(() => plt.rel(target, name, handler, opts));
            });
        }
    };
    const hostListenerProxy = (hostRef, methodName) => (ev) => {
        try {
            if (BUILD.lazyLoad) ;
            else {
                hostRef.$hostElement$[methodName](ev);
            }
        }
        catch (e) {
            consoleError(e);
        }
    };
    const getHostListenerTarget = (elm, flags) => {
        if (flags & 4 /* TargetDocument */)
            return doc;
        if (flags & 8 /* TargetWindow */)
            return win;
        if (flags & 16 /* TargetBody */)
            return doc.body;
        return elm;
    };
    // prettier-ignore
    const hostListenerOpts = (flags) => supportsListenerOptions
        ? ({
            passive: (flags & 1 /* Passive */) !== 0,
            capture: (flags & 2 /* Capture */) !== 0,
        })
        : (flags & 2 /* Capture */) !== 0;
    const XLINK_NS = 'http://www.w3.org/1999/xlink';
    const createTime = (fnName, tagName = '') => {
        {
            return () => {
                return;
            };
        }
    };
    const rootAppliedStyles = new WeakMap();
    const registerStyle = (scopeId, cssText, allowCS) => {
        let style = styles.get(scopeId);
        if (supportsConstructibleStylesheets && allowCS) {
            style = (style || new CSSStyleSheet());
            style.replace(cssText);
        }
        else {
            style = cssText;
        }
        styles.set(scopeId, style);
    };
    const addStyle = (styleContainerNode, cmpMeta, mode, hostElm) => {
        let scopeId = getScopeId(cmpMeta, mode);
        const style = styles.get(scopeId);
        // if an element is NOT connected then getRootNode() will return the wrong root node
        // so the fallback is to always use the document for the root node in those cases
        styleContainerNode = styleContainerNode.nodeType === 11 /* DocumentFragment */ ? styleContainerNode : doc;
        if (style) {
            if (typeof style === 'string') {
                styleContainerNode = styleContainerNode.head || styleContainerNode;
                let appliedStyles = rootAppliedStyles.get(styleContainerNode);
                let styleElm;
                if (!appliedStyles) {
                    rootAppliedStyles.set(styleContainerNode, (appliedStyles = new Set()));
                }
                if (!appliedStyles.has(scopeId)) {
                    {
                        {
                            styleElm = doc.createElement('style');
                            styleElm.innerHTML = style;
                        }
                        styleContainerNode.insertBefore(styleElm, styleContainerNode.querySelector('link'));
                    }
                    if (appliedStyles) {
                        appliedStyles.add(scopeId);
                    }
                }
            }
            else if (!styleContainerNode.adoptedStyleSheets.includes(style)) {
                styleContainerNode.adoptedStyleSheets = [...styleContainerNode.adoptedStyleSheets, style];
            }
        }
        return scopeId;
    };
    const attachStyles = (hostRef) => {
        const cmpMeta = hostRef.$cmpMeta$;
        const elm = hostRef.$hostElement$;
        const flags = cmpMeta.$flags$;
        const endAttachStyles = createTime('attachStyles', cmpMeta.$tagName$);
        const scopeId = addStyle(supportsShadow && elm.shadowRoot ? elm.shadowRoot : elm.getRootNode(), cmpMeta, hostRef.$modeName$);
        if (flags & 10 /* needsScopedEncapsulation */) {
            // only required when we're NOT using native shadow dom (slot)
            // or this browser doesn't support native shadow dom
            // and this host element was NOT created with SSR
            // let's pick out the inner content for slot projection
            // create a node to represent where the original
            // content was first placed, which is useful later on
            // DOM WRITE!!
            elm['s-sc'] = scopeId;
            elm.classList.add(scopeId + '-h');
            if (flags & 2 /* scopedCssEncapsulation */) {
                elm.classList.add(scopeId + '-s');
            }
        }
        endAttachStyles();
    };
    const getScopeId = (cmp, mode) => 'sc-' + (mode && cmp.$flags$ & 32 /* hasMode */ ? cmp.$tagName$ + '-' + mode : cmp.$tagName$);
    // Private
    const computeMode = (elm) => modeResolutionChain.map((h) => h(elm)).find((m) => !!m);
    /**
     * Default style mode id
     */
    /**
     * Reusable empty obj/array
     * Don't add values to these!!
     */
    const EMPTY_OBJ = {};
    /**
     * Namespaces
     */
    const SVG_NS = 'http://www.w3.org/2000/svg';
    const HTML_NS = 'http://www.w3.org/1999/xhtml';
    const isDef = (v) => v != null;
    const isComplexType = (o) => {
        // https://jsperf.com/typeof-fn-object/5
        o = typeof o;
        return o === 'object' || o === 'function';
    };
    /**
     * Production h() function based on Preact by
     * Jason Miller (@developit)
     * Licensed under the MIT License
     * https://github.com/developit/preact/blob/master/LICENSE
     *
     * Modified for Stencil's compiler and vdom
     */
    // const stack: any[] = [];
    // export function h(nodeName: string | d.FunctionalComponent, vnodeData: d.PropsType, child?: d.ChildType): d.VNode;
    // export function h(nodeName: string | d.FunctionalComponent, vnodeData: d.PropsType, ...children: d.ChildType[]): d.VNode;
    const h = (nodeName, vnodeData, ...children) => {
        let child = null;
        let key = null;
        let slotName = null;
        let simple = false;
        let lastSimple = false;
        const vNodeChildren = [];
        const walk = (c) => {
            for (let i = 0; i < c.length; i++) {
                child = c[i];
                if (Array.isArray(child)) {
                    walk(child);
                }
                else if (child != null && typeof child !== 'boolean') {
                    if ((simple = typeof nodeName !== 'function' && !isComplexType(child))) {
                        child = String(child);
                    }
                    if (simple && lastSimple) {
                        // If the previous child was simple (string), we merge both
                        vNodeChildren[vNodeChildren.length - 1].$text$ += child;
                    }
                    else {
                        // Append a new vNode, if it's text, we create a text vNode
                        vNodeChildren.push(simple ? newVNode(null, child) : child);
                    }
                    lastSimple = simple;
                }
            }
        };
        walk(children);
        if (vnodeData) {
            if (BUILD.isDev && nodeName === 'input') {
                validateInputProperties(vnodeData);
            }
            // normalize class / classname attributes
            if (BUILD.vdomKey && vnodeData.key) {
                key = vnodeData.key;
            }
            if (BUILD.slotRelocation && vnodeData.name) {
                slotName = vnodeData.name;
            }
            if (BUILD.vdomClass) {
                const classData = vnodeData.className || vnodeData.class;
                if (classData) {
                    vnodeData.class =
                        typeof classData !== 'object'
                            ? classData
                            : Object.keys(classData)
                                .filter((k) => classData[k])
                                .join(' ');
                }
            }
        }
        if (BUILD.isDev && vNodeChildren.some(isHost)) {
            consoleDevError(`The <Host> must be the single root component. Make sure:
- You are NOT using hostData() and <Host> in the same component.
- <Host> is used once, and it's the single root component of the render() function.`);
        }
        if (BUILD.vdomFunctional && typeof nodeName === 'function') {
            // nodeName is a functional component
            return nodeName(vnodeData === null ? {} : vnodeData, vNodeChildren, vdomFnUtils);
        }
        const vnode = newVNode(nodeName, null);
        vnode.$attrs$ = vnodeData;
        if (vNodeChildren.length > 0) {
            vnode.$children$ = vNodeChildren;
        }
        if (BUILD.vdomKey) {
            vnode.$key$ = key;
        }
        if (BUILD.slotRelocation) {
            vnode.$name$ = slotName;
        }
        return vnode;
    };
    const newVNode = (tag, text) => {
        const vnode = {
            $flags$: 0,
            $tag$: tag,
            $text$: text,
            $elm$: null,
            $children$: null,
        };
        if (BUILD.vdomAttribute) {
            vnode.$attrs$ = null;
        }
        if (BUILD.vdomKey) {
            vnode.$key$ = null;
        }
        if (BUILD.slotRelocation) {
            vnode.$name$ = null;
        }
        return vnode;
    };
    const Host = {};
    const isHost = (node) => node && node.$tag$ === Host;
    const vdomFnUtils = {
        forEach: (children, cb) => children.map(convertToPublic).forEach(cb),
        map: (children, cb) => children.map(convertToPublic).map(cb).map(convertToPrivate),
    };
    const convertToPublic = (node) => ({
        vattrs: node.$attrs$,
        vchildren: node.$children$,
        vkey: node.$key$,
        vname: node.$name$,
        vtag: node.$tag$,
        vtext: node.$text$,
    });
    const convertToPrivate = (node) => {
        if (typeof node.vtag === 'function') {
            const vnodeData = Object.assign({}, node.vattrs);
            if (node.vkey) {
                vnodeData.key = node.vkey;
            }
            if (node.vname) {
                vnodeData.name = node.vname;
            }
            return h(node.vtag, vnodeData, ...(node.vchildren || []));
        }
        const vnode = newVNode(node.vtag, node.vtext);
        vnode.$attrs$ = node.vattrs;
        vnode.$children$ = node.vchildren;
        vnode.$key$ = node.vkey;
        vnode.$name$ = node.vname;
        return vnode;
    };
    /**
     * Validates the ordering of attributes on an input element
     * @param inputElm the element to validate
     */
    const validateInputProperties = (inputElm) => {
        const props = Object.keys(inputElm);
        const value = props.indexOf('value');
        if (value === -1) {
            return;
        }
        const typeIndex = props.indexOf('type');
        const minIndex = props.indexOf('min');
        const maxIndex = props.indexOf('max');
        const stepIndex = props.indexOf('step');
        if (value < typeIndex || value < minIndex || value < maxIndex || value < stepIndex) {
            consoleDevWarn(`The "value" prop of <input> should be set after "min", "max", "type" and "step"`);
        }
    };
    /**
     * Production setAccessor() function based on Preact by
     * Jason Miller (@developit)
     * Licensed under the MIT License
     * https://github.com/developit/preact/blob/master/LICENSE
     *
     * Modified for Stencil's compiler and vdom
     */
    const setAccessor = (elm, memberName, oldValue, newValue, isSvg, flags) => {
        if (oldValue !== newValue) {
            let isProp = isMemberInElement(elm, memberName);
            let ln = memberName.toLowerCase();
            if (memberName === 'class') {
                const classList = elm.classList;
                const oldClasses = parseClassList(oldValue);
                const newClasses = parseClassList(newValue);
                classList.remove(...oldClasses.filter((c) => c && !newClasses.includes(c)));
                classList.add(...newClasses.filter((c) => c && !oldClasses.includes(c)));
            }
            else if (memberName === 'style') {
                // update style attribute, css properties and values
                {
                    for (const prop in oldValue) {
                        if (!newValue || newValue[prop] == null) {
                            if (prop.includes('-')) {
                                elm.style.removeProperty(prop);
                            }
                            else {
                                elm.style[prop] = '';
                            }
                        }
                    }
                }
                for (const prop in newValue) {
                    if (!oldValue || newValue[prop] !== oldValue[prop]) {
                        if (prop.includes('-')) {
                            elm.style.setProperty(prop, newValue[prop]);
                        }
                        else {
                            elm.style[prop] = newValue[prop];
                        }
                    }
                }
            }
            else if (memberName === 'key')
                ;
            else if (memberName === 'ref') {
                // minifier will clean this up
                if (newValue) {
                    newValue(elm);
                }
            }
            else if ((!elm.__lookupSetter__(memberName)) &&
                memberName[0] === 'o' &&
                memberName[1] === 'n') {
                // Event Handlers
                // so if the member name starts with "on" and the 3rd characters is
                // a capital letter, and it's not already a member on the element,
                // then we're assuming it's an event listener
                if (memberName[2] === '-') {
                    // on- prefixed events
                    // allows to be explicit about the dom event to listen without any magic
                    // under the hood:
                    // <my-cmp on-click> // listens for "click"
                    // <my-cmp on-Click> // listens for "Click"
                    // <my-cmp on-ionChange> // listens for "ionChange"
                    // <my-cmp on-EVENTS> // listens for "EVENTS"
                    memberName = memberName.slice(3);
                }
                else if (isMemberInElement(win, ln)) {
                    // standard event
                    // the JSX attribute could have been "onMouseOver" and the
                    // member name "onmouseover" is on the window's prototype
                    // so let's add the listener "mouseover", which is all lowercased
                    memberName = ln.slice(2);
                }
                else {
                    // custom event
                    // the JSX attribute could have been "onMyCustomEvent"
                    // so let's trim off the "on" prefix and lowercase the first character
                    // and add the listener "myCustomEvent"
                    // except for the first character, we keep the event name case
                    memberName = ln[2] + memberName.slice(3);
                }
                if (oldValue) {
                    plt.rel(elm, memberName, oldValue, false);
                }
                if (newValue) {
                    plt.ael(elm, memberName, newValue, false);
                }
            }
            else {
                // Set property if it exists and it's not a SVG
                const isComplex = isComplexType(newValue);
                if ((isProp || (isComplex && newValue !== null)) && !isSvg) {
                    try {
                        if (!elm.tagName.includes('-')) {
                            const n = newValue == null ? '' : newValue;
                            // Workaround for Safari, moving the <input> caret when re-assigning the same valued
                            if (memberName === 'list') {
                                isProp = false;
                            }
                            else if (oldValue == null || elm[memberName] != n) {
                                elm[memberName] = n;
                            }
                        }
                        else {
                            elm[memberName] = newValue;
                        }
                    }
                    catch (e) { }
                }
                /**
                 * Need to manually update attribute if:
                 * - memberName is not an attribute
                 * - if we are rendering the host element in order to reflect attribute
                 * - if it's a SVG, since properties might not work in <svg>
                 * - if the newValue is null/undefined or 'false'.
                 */
                let xlink = false;
                {
                    if (ln !== (ln = ln.replace(/^xlink\:?/, ''))) {
                        memberName = ln;
                        xlink = true;
                    }
                }
                if (newValue == null || newValue === false) {
                    if (newValue !== false || elm.getAttribute(memberName) === '') {
                        if (xlink) {
                            elm.removeAttributeNS(XLINK_NS, memberName);
                        }
                        else {
                            elm.removeAttribute(memberName);
                        }
                    }
                }
                else if ((!isProp || flags & 4 /* isHost */ || isSvg) && !isComplex) {
                    newValue = newValue === true ? '' : newValue;
                    if (xlink) {
                        elm.setAttributeNS(XLINK_NS, memberName, newValue);
                    }
                    else {
                        elm.setAttribute(memberName, newValue);
                    }
                }
            }
        }
    };
    const parseClassListRegex = /\s/;
    const parseClassList = (value) => (!value ? [] : value.split(parseClassListRegex));
    const updateElement = (oldVnode, newVnode, isSvgMode, memberName) => {
        // if the element passed in is a shadow root, which is a document fragment
        // then we want to be adding attrs/props to the shadow root's "host" element
        // if it's not a shadow root, then we add attrs/props to the same element
        const elm = newVnode.$elm$.nodeType === 11 /* DocumentFragment */ && newVnode.$elm$.host
            ? newVnode.$elm$.host
            : newVnode.$elm$;
        const oldVnodeAttrs = (oldVnode && oldVnode.$attrs$) || EMPTY_OBJ;
        const newVnodeAttrs = newVnode.$attrs$ || EMPTY_OBJ;
        {
            // remove attributes no longer present on the vnode by setting them to undefined
            for (memberName in oldVnodeAttrs) {
                if (!(memberName in newVnodeAttrs)) {
                    setAccessor(elm, memberName, oldVnodeAttrs[memberName], undefined, isSvgMode, newVnode.$flags$);
                }
            }
        }
        // add new & update changed attributes
        for (memberName in newVnodeAttrs) {
            setAccessor(elm, memberName, oldVnodeAttrs[memberName], newVnodeAttrs[memberName], isSvgMode, newVnode.$flags$);
        }
    };
    const createElm = (oldParentVNode, newParentVNode, childIndex, parentElm) => {
        // tslint:disable-next-line: prefer-const
        const newVNode = newParentVNode.$children$[childIndex];
        let i = 0;
        let elm;
        let childNode;
        let oldVNode;
        if (!useNativeShadowDom) {
            // remember for later we need to check to relocate nodes
            checkSlotRelocate = true;
            if (newVNode.$tag$ === 'slot') {
                if (scopeId) {
                    // scoped css needs to add its scoped id to the parent element
                    parentElm.classList.add(scopeId + '-s');
                }
                newVNode.$flags$ |= newVNode.$children$
                    ? // slot element has fallback content
                        2 /* isSlotFallback */
                    : // slot element does not have fallback content
                        1 /* isSlotReference */;
            }
        }
        if (newVNode.$text$ !== null) {
            // create text node
            elm = newVNode.$elm$ = doc.createTextNode(newVNode.$text$);
        }
        else if (newVNode.$flags$ & 1 /* isSlotReference */) {
            // create a slot reference node
            elm = newVNode.$elm$ =
                doc.createTextNode('');
        }
        else {
            if (!isSvgMode) {
                isSvgMode = newVNode.$tag$ === 'svg';
            }
            // create element
            elm = newVNode.$elm$ = (doc.createElementNS(isSvgMode ? SVG_NS : HTML_NS, newVNode.$flags$ & 2 /* isSlotFallback */
                    ? 'slot-fb'
                    : newVNode.$tag$)
                );
            if (isSvgMode && newVNode.$tag$ === 'foreignObject') {
                isSvgMode = false;
            }
            // add css classes, attrs, props, listeners, etc.
            {
                updateElement(null, newVNode, isSvgMode);
            }
            if (isDef(scopeId) && elm['s-si'] !== scopeId) {
                // if there is a scopeId and this is the initial render
                // then let's add the scopeId as a css class
                elm.classList.add((elm['s-si'] = scopeId));
            }
            if (newVNode.$children$) {
                for (i = 0; i < newVNode.$children$.length; ++i) {
                    // create the node
                    childNode = createElm(oldParentVNode, newVNode, i, elm);
                    // return node could have been null
                    if (childNode) {
                        // append our new node
                        elm.appendChild(childNode);
                    }
                }
            }
            {
                if (newVNode.$tag$ === 'svg') {
                    // Only reset the SVG context when we're exiting <svg> element
                    isSvgMode = false;
                }
                else if (elm.tagName === 'foreignObject') {
                    // Reenter SVG context when we're exiting <foreignObject> element
                    isSvgMode = true;
                }
            }
        }
        {
            elm['s-hn'] = hostTagName;
            if (newVNode.$flags$ & (2 /* isSlotFallback */ | 1 /* isSlotReference */)) {
                // remember the content reference comment
                elm['s-sr'] = true;
                // remember the content reference comment
                elm['s-cr'] = contentRef;
                // remember the slot name, or empty string for default slot
                elm['s-sn'] = newVNode.$name$ || '';
                // check if we've got an old vnode for this slot
                oldVNode = oldParentVNode && oldParentVNode.$children$ && oldParentVNode.$children$[childIndex];
                if (oldVNode && oldVNode.$tag$ === newVNode.$tag$ && oldParentVNode.$elm$) {
                    // we've got an old slot vnode and the wrapper is being replaced
                    // so let's move the old slot content back to it's original location
                    putBackInOriginalLocation(oldParentVNode.$elm$, false);
                }
            }
        }
        return elm;
    };
    const putBackInOriginalLocation = (parentElm, recursive) => {
        plt.$flags$ |= 1 /* isTmpDisconnected */;
        const oldSlotChildNodes = parentElm.childNodes;
        for (let i = oldSlotChildNodes.length - 1; i >= 0; i--) {
            const childNode = oldSlotChildNodes[i];
            if (childNode['s-hn'] !== hostTagName && childNode['s-ol']) {
                // // this child node in the old element is from another component
                // // remove this node from the old slot's parent
                // childNode.remove();
                // and relocate it back to it's original location
                parentReferenceNode(childNode).insertBefore(childNode, referenceNode(childNode));
                // remove the old original location comment entirely
                // later on the patch function will know what to do
                // and move this to the correct spot in need be
                childNode['s-ol'].remove();
                childNode['s-ol'] = undefined;
                checkSlotRelocate = true;
            }
            if (recursive) {
                putBackInOriginalLocation(childNode, recursive);
            }
        }
        plt.$flags$ &= ~1 /* isTmpDisconnected */;
    };
    const addVnodes = (parentElm, before, parentVNode, vnodes, startIdx, endIdx) => {
        let containerElm = ((parentElm['s-cr'] && parentElm['s-cr'].parentNode) || parentElm);
        let childNode;
        if (containerElm.shadowRoot && containerElm.tagName === hostTagName) {
            containerElm = containerElm.shadowRoot;
        }
        for (; startIdx <= endIdx; ++startIdx) {
            if (vnodes[startIdx]) {
                childNode = createElm(null, parentVNode, startIdx, parentElm);
                if (childNode) {
                    vnodes[startIdx].$elm$ = childNode;
                    containerElm.insertBefore(childNode, referenceNode(before) );
                }
            }
        }
    };
    const removeVnodes = (vnodes, startIdx, endIdx, vnode, elm) => {
        for (; startIdx <= endIdx; ++startIdx) {
            if ((vnode = vnodes[startIdx])) {
                elm = vnode.$elm$;
                callNodeRefs(vnode);
                {
                    // we're removing this element
                    // so it's possible we need to show slot fallback content now
                    checkSlotFallbackVisibility = true;
                    if (elm['s-ol']) {
                        // remove the original location comment
                        elm['s-ol'].remove();
                    }
                    else {
                        // it's possible that child nodes of the node
                        // that's being removed are slot nodes
                        putBackInOriginalLocation(elm, true);
                    }
                }
                // remove the vnode's element from the dom
                elm.remove();
            }
        }
    };
    const updateChildren = (parentElm, oldCh, newVNode, newCh) => {
        let oldStartIdx = 0;
        let newStartIdx = 0;
        let idxInOld = 0;
        let i = 0;
        let oldEndIdx = oldCh.length - 1;
        let oldStartVnode = oldCh[0];
        let oldEndVnode = oldCh[oldEndIdx];
        let newEndIdx = newCh.length - 1;
        let newStartVnode = newCh[0];
        let newEndVnode = newCh[newEndIdx];
        let node;
        let elmToMove;
        while (oldStartIdx <= oldEndIdx && newStartIdx <= newEndIdx) {
            if (oldStartVnode == null) {
                // Vnode might have been moved left
                oldStartVnode = oldCh[++oldStartIdx];
            }
            else if (oldEndVnode == null) {
                oldEndVnode = oldCh[--oldEndIdx];
            }
            else if (newStartVnode == null) {
                newStartVnode = newCh[++newStartIdx];
            }
            else if (newEndVnode == null) {
                newEndVnode = newCh[--newEndIdx];
            }
            else if (isSameVnode(oldStartVnode, newStartVnode)) {
                patch(oldStartVnode, newStartVnode);
                oldStartVnode = oldCh[++oldStartIdx];
                newStartVnode = newCh[++newStartIdx];
            }
            else if (isSameVnode(oldEndVnode, newEndVnode)) {
                patch(oldEndVnode, newEndVnode);
                oldEndVnode = oldCh[--oldEndIdx];
                newEndVnode = newCh[--newEndIdx];
            }
            else if (isSameVnode(oldStartVnode, newEndVnode)) {
                // Vnode moved right
                if ((oldStartVnode.$tag$ === 'slot' || newEndVnode.$tag$ === 'slot')) {
                    putBackInOriginalLocation(oldStartVnode.$elm$.parentNode, false);
                }
                patch(oldStartVnode, newEndVnode);
                parentElm.insertBefore(oldStartVnode.$elm$, oldEndVnode.$elm$.nextSibling);
                oldStartVnode = oldCh[++oldStartIdx];
                newEndVnode = newCh[--newEndIdx];
            }
            else if (isSameVnode(oldEndVnode, newStartVnode)) {
                // Vnode moved left
                if ((oldStartVnode.$tag$ === 'slot' || newEndVnode.$tag$ === 'slot')) {
                    putBackInOriginalLocation(oldEndVnode.$elm$.parentNode, false);
                }
                patch(oldEndVnode, newStartVnode);
                parentElm.insertBefore(oldEndVnode.$elm$, oldStartVnode.$elm$);
                oldEndVnode = oldCh[--oldEndIdx];
                newStartVnode = newCh[++newStartIdx];
            }
            else {
                // createKeyToOldIdx
                idxInOld = -1;
                {
                    for (i = oldStartIdx; i <= oldEndIdx; ++i) {
                        if (oldCh[i] && oldCh[i].$key$ !== null && oldCh[i].$key$ === newStartVnode.$key$) {
                            idxInOld = i;
                            break;
                        }
                    }
                }
                if (idxInOld >= 0) {
                    elmToMove = oldCh[idxInOld];
                    if (elmToMove.$tag$ !== newStartVnode.$tag$) {
                        node = createElm(oldCh && oldCh[newStartIdx], newVNode, idxInOld, parentElm);
                    }
                    else {
                        patch(elmToMove, newStartVnode);
                        oldCh[idxInOld] = undefined;
                        node = elmToMove.$elm$;
                    }
                    newStartVnode = newCh[++newStartIdx];
                }
                else {
                    // new element
                    node = createElm(oldCh && oldCh[newStartIdx], newVNode, newStartIdx, parentElm);
                    newStartVnode = newCh[++newStartIdx];
                }
                if (node) {
                    {
                        parentReferenceNode(oldStartVnode.$elm$).insertBefore(node, referenceNode(oldStartVnode.$elm$));
                    }
                }
            }
        }
        if (oldStartIdx > oldEndIdx) {
            addVnodes(parentElm, newCh[newEndIdx + 1] == null ? null : newCh[newEndIdx + 1].$elm$, newVNode, newCh, newStartIdx, newEndIdx);
        }
        else if (newStartIdx > newEndIdx) {
            removeVnodes(oldCh, oldStartIdx, oldEndIdx);
        }
    };
    const isSameVnode = (vnode1, vnode2) => {
        // compare if two vnode to see if they're "technically" the same
        // need to have the same element tag, and same key to be the same
        if (vnode1.$tag$ === vnode2.$tag$) {
            if (vnode1.$tag$ === 'slot') {
                return vnode1.$name$ === vnode2.$name$;
            }
            {
                return vnode1.$key$ === vnode2.$key$;
            }
        }
        return false;
    };
    const referenceNode = (node) => {
        // this node was relocated to a new location in the dom
        // because of some other component's slot
        // but we still have an html comment in place of where
        // it's original location was according to it's original vdom
        return (node && node['s-ol']) || node;
    };
    const parentReferenceNode = (node) => (node['s-ol'] ? node['s-ol'] : node).parentNode;
    const patch = (oldVNode, newVNode) => {
        const elm = (newVNode.$elm$ = oldVNode.$elm$);
        const oldChildren = oldVNode.$children$;
        const newChildren = newVNode.$children$;
        const tag = newVNode.$tag$;
        const text = newVNode.$text$;
        let defaultHolder;
        if (text === null) {
            {
                // test if we're rendering an svg element, or still rendering nodes inside of one
                // only add this to the when the compiler sees we're using an svg somewhere
                isSvgMode = tag === 'svg' ? true : tag === 'foreignObject' ? false : isSvgMode;
            }
            // element node
            {
                if (tag === 'slot')
                    ;
                else {
                    // either this is the first render of an element OR it's an update
                    // AND we already know it's possible it could have changed
                    // this updates the element's css classes, attrs, props, listeners, etc.
                    updateElement(oldVNode, newVNode, isSvgMode);
                }
            }
            if (oldChildren !== null && newChildren !== null) {
                // looks like there's child vnodes for both the old and new vnodes
                updateChildren(elm, oldChildren, newVNode, newChildren);
            }
            else if (newChildren !== null) {
                // no old child vnodes, but there are new child vnodes to add
                if (oldVNode.$text$ !== null) {
                    // the old vnode was text, so be sure to clear it out
                    elm.textContent = '';
                }
                // add the new vnode children
                addVnodes(elm, null, newVNode, newChildren, 0, newChildren.length - 1);
            }
            else if (oldChildren !== null) {
                // no new child vnodes, but there are old child vnodes to remove
                removeVnodes(oldChildren, 0, oldChildren.length - 1);
            }
            if (isSvgMode && tag === 'svg') {
                isSvgMode = false;
            }
        }
        else if ((defaultHolder = elm['s-cr'])) {
            // this element has slotted content
            defaultHolder.parentNode.textContent = text;
        }
        else if (oldVNode.$text$ !== text) {
            // update the text content for the text only vnode
            // and also only if the text is different than before
            elm.data = text;
        }
    };
    const updateFallbackSlotVisibility = (elm) => {
        // tslint:disable-next-line: prefer-const
        const childNodes = elm.childNodes;
        let childNode;
        let i;
        let ilen;
        let j;
        let slotNameAttr;
        let nodeType;
        for (i = 0, ilen = childNodes.length; i < ilen; i++) {
            childNode = childNodes[i];
            if (childNode.nodeType === 1 /* ElementNode */) {
                if (childNode['s-sr']) {
                    // this is a slot fallback node
                    // get the slot name for this slot reference node
                    slotNameAttr = childNode['s-sn'];
                    // by default always show a fallback slot node
                    // then hide it if there are other slots in the light dom
                    childNode.hidden = false;
                    for (j = 0; j < ilen; j++) {
                        nodeType = childNodes[j].nodeType;
                        if (childNodes[j]['s-hn'] !== childNode['s-hn'] || slotNameAttr !== '') {
                            // this sibling node is from a different component OR is a named fallback slot node
                            if (nodeType === 1 /* ElementNode */ && slotNameAttr === childNodes[j].getAttribute('slot')) {
                                childNode.hidden = true;
                                break;
                            }
                        }
                        else {
                            // this is a default fallback slot node
                            // any element or text node (with content)
                            // should hide the default fallback slot node
                            if (nodeType === 1 /* ElementNode */ ||
                                (nodeType === 3 /* TextNode */ && childNodes[j].textContent.trim() !== '')) {
                                childNode.hidden = true;
                                break;
                            }
                        }
                    }
                }
                // keep drilling down
                updateFallbackSlotVisibility(childNode);
            }
        }
    };
    const relocateNodes = [];
    const relocateSlotContent = (elm) => {
        // tslint:disable-next-line: prefer-const
        let childNode;
        let node;
        let hostContentNodes;
        let slotNameAttr;
        let relocateNodeData;
        let j;
        let i = 0;
        const childNodes = elm.childNodes;
        const ilen = childNodes.length;
        for (; i < ilen; i++) {
            childNode = childNodes[i];
            if (childNode['s-sr'] && (node = childNode['s-cr']) && node.parentNode) {
                // first got the content reference comment node
                // then we got it's parent, which is where all the host content is in now
                hostContentNodes = node.parentNode.childNodes;
                slotNameAttr = childNode['s-sn'];
                for (j = hostContentNodes.length - 1; j >= 0; j--) {
                    node = hostContentNodes[j];
                    if (!node['s-cn'] && !node['s-nr'] && node['s-hn'] !== childNode['s-hn']) {
                        // let's do some relocating to its new home
                        // but never relocate a content reference node
                        // that is suppose to always represent the original content location
                        if (isNodeLocatedInSlot(node, slotNameAttr)) {
                            // it's possible we've already decided to relocate this node
                            relocateNodeData = relocateNodes.find((r) => r.$nodeToRelocate$ === node);
                            // made some changes to slots
                            // let's make sure we also double check
                            // fallbacks are correctly hidden or shown
                            checkSlotFallbackVisibility = true;
                            node['s-sn'] = node['s-sn'] || slotNameAttr;
                            if (relocateNodeData) {
                                // previously we never found a slot home for this node
                                // but turns out we did, so let's remember it now
                                relocateNodeData.$slotRefNode$ = childNode;
                            }
                            else {
                                // add to our list of nodes to relocate
                                relocateNodes.push({
                                    $slotRefNode$: childNode,
                                    $nodeToRelocate$: node,
                                });
                            }
                            if (node['s-sr']) {
                                relocateNodes.map((relocateNode) => {
                                    if (isNodeLocatedInSlot(relocateNode.$nodeToRelocate$, node['s-sn'])) {
                                        relocateNodeData = relocateNodes.find((r) => r.$nodeToRelocate$ === node);
                                        if (relocateNodeData && !relocateNode.$slotRefNode$) {
                                            relocateNode.$slotRefNode$ = relocateNodeData.$slotRefNode$;
                                        }
                                    }
                                });
                            }
                        }
                        else if (!relocateNodes.some((r) => r.$nodeToRelocate$ === node)) {
                            // so far this element does not have a slot home, not setting slotRefNode on purpose
                            // if we never find a home for this element then we'll need to hide it
                            relocateNodes.push({
                                $nodeToRelocate$: node,
                            });
                        }
                    }
                }
            }
            if (childNode.nodeType === 1 /* ElementNode */) {
                relocateSlotContent(childNode);
            }
        }
    };
    const isNodeLocatedInSlot = (nodeToRelocate, slotNameAttr) => {
        if (nodeToRelocate.nodeType === 1 /* ElementNode */) {
            if (nodeToRelocate.getAttribute('slot') === null && slotNameAttr === '') {
                return true;
            }
            if (nodeToRelocate.getAttribute('slot') === slotNameAttr) {
                return true;
            }
            return false;
        }
        if (nodeToRelocate['s-sn'] === slotNameAttr) {
            return true;
        }
        return slotNameAttr === '';
    };
    const callNodeRefs = (vNode) => {
        {
            vNode.$attrs$ && vNode.$attrs$.ref && vNode.$attrs$.ref(null);
            vNode.$children$ && vNode.$children$.map(callNodeRefs);
        }
    };
    const renderVdom = (hostRef, renderFnResults) => {
        const hostElm = hostRef.$hostElement$;
        const cmpMeta = hostRef.$cmpMeta$;
        const oldVNode = hostRef.$vnode$ || newVNode(null, null);
        const rootVnode = isHost(renderFnResults) ? renderFnResults : h(null, null, renderFnResults);
        hostTagName = hostElm.tagName;
        if (cmpMeta.$attrsToReflect$) {
            rootVnode.$attrs$ = rootVnode.$attrs$ || {};
            cmpMeta.$attrsToReflect$.map(([propName, attribute]) => (rootVnode.$attrs$[attribute] = hostElm[propName]));
        }
        rootVnode.$tag$ = null;
        rootVnode.$flags$ |= 4 /* isHost */;
        hostRef.$vnode$ = rootVnode;
        rootVnode.$elm$ = oldVNode.$elm$ = (hostElm.shadowRoot || hostElm );
        {
            scopeId = hostElm['s-sc'];
        }
        {
            contentRef = hostElm['s-cr'];
            useNativeShadowDom = supportsShadow && (cmpMeta.$flags$ & 1 /* shadowDomEncapsulation */) !== 0;
            // always reset
            checkSlotFallbackVisibility = false;
        }
        // synchronous patch
        patch(oldVNode, rootVnode);
        {
            // while we're moving nodes around existing nodes, temporarily disable
            // the disconnectCallback from working
            plt.$flags$ |= 1 /* isTmpDisconnected */;
            if (checkSlotRelocate) {
                relocateSlotContent(rootVnode.$elm$);
                let relocateData;
                let nodeToRelocate;
                let orgLocationNode;
                let parentNodeRef;
                let insertBeforeNode;
                let refNode;
                let i = 0;
                for (; i < relocateNodes.length; i++) {
                    relocateData = relocateNodes[i];
                    nodeToRelocate = relocateData.$nodeToRelocate$;
                    if (!nodeToRelocate['s-ol']) {
                        // add a reference node marking this node's original location
                        // keep a reference to this node for later lookups
                        orgLocationNode =
                            doc.createTextNode('');
                        orgLocationNode['s-nr'] = nodeToRelocate;
                        nodeToRelocate.parentNode.insertBefore((nodeToRelocate['s-ol'] = orgLocationNode), nodeToRelocate);
                    }
                }
                for (i = 0; i < relocateNodes.length; i++) {
                    relocateData = relocateNodes[i];
                    nodeToRelocate = relocateData.$nodeToRelocate$;
                    if (relocateData.$slotRefNode$) {
                        // by default we're just going to insert it directly
                        // after the slot reference node
                        parentNodeRef = relocateData.$slotRefNode$.parentNode;
                        insertBeforeNode = relocateData.$slotRefNode$.nextSibling;
                        orgLocationNode = nodeToRelocate['s-ol'];
                        while ((orgLocationNode = orgLocationNode.previousSibling)) {
                            refNode = orgLocationNode['s-nr'];
                            if (refNode && refNode['s-sn'] === nodeToRelocate['s-sn'] && parentNodeRef === refNode.parentNode) {
                                refNode = refNode.nextSibling;
                                if (!refNode || !refNode['s-nr']) {
                                    insertBeforeNode = refNode;
                                    break;
                                }
                            }
                        }
                        if ((!insertBeforeNode && parentNodeRef !== nodeToRelocate.parentNode) ||
                            nodeToRelocate.nextSibling !== insertBeforeNode) {
                            // we've checked that it's worth while to relocate
                            // since that the node to relocate
                            // has a different next sibling or parent relocated
                            if (nodeToRelocate !== insertBeforeNode) {
                                if (!nodeToRelocate['s-hn'] && nodeToRelocate['s-ol']) {
                                    // probably a component in the index.html that doesn't have it's hostname set
                                    nodeToRelocate['s-hn'] = nodeToRelocate['s-ol'].parentNode.nodeName;
                                }
                                // add it back to the dom but in its new home
                                parentNodeRef.insertBefore(nodeToRelocate, insertBeforeNode);
                            }
                        }
                    }
                    else {
                        // this node doesn't have a slot home to go to, so let's hide it
                        if (nodeToRelocate.nodeType === 1 /* ElementNode */) {
                            nodeToRelocate.hidden = true;
                        }
                    }
                }
            }
            if (checkSlotFallbackVisibility) {
                updateFallbackSlotVisibility(rootVnode.$elm$);
            }
            // done moving nodes around
            // allow the disconnect callback to work again
            plt.$flags$ &= ~1 /* isTmpDisconnected */;
            // always reset
            relocateNodes.length = 0;
        }
    };
    const getElement = (ref) => (BUILD.lazyLoad ? getHostRef(ref).$hostElement$ : ref);
    const createEvent = (ref, name, flags) => {
        const elm = getElement(ref);
        return {
            emit: (detail) => {
                if (BUILD.isDev && !elm.isConnected) {
                    consoleDevWarn(`The "${name}" event was emitted, but the dispatcher node is no longer connected to the dom.`);
                }
                return emitEvent(elm, name, {
                    bubbles: !!(flags & 4 /* Bubbles */),
                    composed: !!(flags & 2 /* Composed */),
                    cancelable: !!(flags & 1 /* Cancellable */),
                    detail,
                });
            },
        };
    };
    /**
     * Helper function to create & dispatch a custom Event on a provided target
     * @param elm the target of the Event
     * @param name the name to give the custom Event
     * @param opts options for configuring a custom Event
     * @returns the custom Event
     */
    const emitEvent = (elm, name, opts) => {
        const ev = plt.ce(name, opts);
        elm.dispatchEvent(ev);
        return ev;
    };
    const attachToAncestor = (hostRef, ancestorComponent) => {
    };
    const scheduleUpdate = (hostRef, isInitialLoad) => {
        if (BUILD.taskQueue && BUILD.updatable) {
            hostRef.$flags$ |= 16 /* isQueuedForUpdate */;
        }
        attachToAncestor(hostRef, hostRef.$ancestorComponent$);
        // there is no ancestor component or the ancestor component
        // has already fired off its lifecycle update then
        // fire off the initial update
        const dispatch = () => dispatchHooks(hostRef, isInitialLoad);
        return BUILD.taskQueue ? writeTask(dispatch) : dispatch();
    };
    const dispatchHooks = (hostRef, isInitialLoad) => {
        const elm = hostRef.$hostElement$;
        const endSchedule = createTime('scheduleUpdate', hostRef.$cmpMeta$.$tagName$);
        const instance = elm;
        let promise;
        if (isInitialLoad) {
            {
                promise = safeCall(instance, 'componentWillLoad');
            }
        }
        else {
            {
                promise = safeCall(instance, 'componentWillUpdate');
            }
        }
        {
            promise = then(promise, () => safeCall(instance, 'componentWillRender'));
        }
        endSchedule();
        return then(promise, () => updateComponent(hostRef, instance, isInitialLoad));
    };
    const updateComponent = async (hostRef, instance, isInitialLoad) => {
        // updateComponent
        const elm = hostRef.$hostElement$;
        const endUpdate = createTime('update', hostRef.$cmpMeta$.$tagName$);
        elm['s-rc'];
        if (isInitialLoad) {
            // DOM WRITE!
            attachStyles(hostRef);
        }
        const endRender = createTime('render', hostRef.$cmpMeta$.$tagName$);
        {
            callRender(hostRef, instance, elm);
        }
        endRender();
        endUpdate();
        {
            postUpdateComponent(hostRef);
        }
    };
    const callRender = (hostRef, instance, elm) => {
        // in order for bundlers to correctly treeshake the BUILD object
        // we need to ensure BUILD is not deoptimized within a try/catch
        // https://rollupjs.org/guide/en/#treeshake tryCatchDeoptimization
        const allRenderFn = false;
        const lazyLoad = false;
        const taskQueue = true ;
        const updatable = true ;
        try {
            renderingRef = instance;
            instance = allRenderFn ? instance.render() : instance.render && instance.render();
            if (updatable && taskQueue) {
                hostRef.$flags$ &= ~16 /* isQueuedForUpdate */;
            }
            if (updatable || lazyLoad) {
                hostRef.$flags$ |= 2 /* hasRendered */;
            }
            if (BUILD.hasRenderFn || BUILD.reflect) {
                if (BUILD.vdomRender || BUILD.reflect) {
                    // looks like we've got child nodes to render into this host element
                    // or we need to update the css class/attrs on the host element
                    // DOM WRITE!
                    if (BUILD.hydrateServerSide) ;
                    else {
                        renderVdom(hostRef, instance);
                    }
                }
            }
        }
        catch (e) {
            consoleError(e, hostRef.$hostElement$);
        }
        renderingRef = null;
        return null;
    };
    const getRenderingRef = () => renderingRef;
    const postUpdateComponent = (hostRef) => {
        const tagName = hostRef.$cmpMeta$.$tagName$;
        const elm = hostRef.$hostElement$;
        const endPostUpdate = createTime('postUpdate', tagName);
        const instance = elm;
        hostRef.$ancestorComponent$;
        {
            safeCall(instance, 'componentDidRender');
        }
        if (!(hostRef.$flags$ & 64 /* hasLoadedComponent */)) {
            hostRef.$flags$ |= 64 /* hasLoadedComponent */;
            {
                safeCall(instance, 'componentDidLoad');
            }
            endPostUpdate();
        }
        else {
            {
                safeCall(instance, 'componentDidUpdate');
            }
            endPostUpdate();
        }
        // ( •_•)
        // ( •_•)>⌐■-■
        // (⌐■_■)
    };
    const forceUpdate = (ref) => {
        if (BUILD.updatable) {
            const hostRef = getHostRef(ref);
            const isConnected = hostRef.$hostElement$.isConnected;
            if (isConnected &&
                (hostRef.$flags$ & (2 /* hasRendered */ | 16 /* isQueuedForUpdate */)) === 2 /* hasRendered */) {
                scheduleUpdate(hostRef, false);
            }
            // Returns "true" when the forced update was successfully scheduled
            return isConnected;
        }
        return false;
    };
    const safeCall = (instance, method, arg) => {
        if (instance && instance[method]) {
            try {
                return instance[method](arg);
            }
            catch (e) {
                consoleError(e);
            }
        }
        return undefined;
    };
    const then = (promise, thenFn) => {
        return promise && promise.then ? promise.then(thenFn) : thenFn();
    };
    /**
     * Parse a new property value for a given property type.
     *
     * While the prop value can reasonably be expected to be of `any` type as far as TypeScript's type checker is concerned,
     * it is not safe to assume that the string returned by evaluating `typeof propValue` matches:
     *   1. `any`, the type given to `propValue` in the function signature
     *   2. the type stored from `propType`.
     *
     * This function provides the capability to parse/coerce a property's value to potentially any other JavaScript type.
     *
     * Property values represented in TSX preserve their type information. In the example below, the number 0 is passed to
     * a component. This `propValue` will preserve its type information (`typeof propValue === 'number'`). Note that is
     * based on the type of the value being passed in, not the type declared of the class member decorated with `@Prop`.
     * ```tsx
     * <my-cmp prop-val={0}></my-cmp>
     * ```
     *
     * HTML prop values on the other hand, will always a string
     *
     * @param propValue the new value to coerce to some type
     * @param propType the type of the prop, expressed as a binary number
     * @returns the parsed/coerced value
     */
    const parsePropertyValue = (propValue, propType) => {
        // ensure this value is of the correct prop type
        if (propValue != null && !isComplexType(propValue)) {
            if (propType & 4 /* Boolean */) {
                // per the HTML spec, any string value means it is a boolean true value
                // but we'll cheat here and say that the string "false" is the boolean false
                return propValue === 'false' ? false : propValue === '' || !!propValue;
            }
            if (propType & 2 /* Number */) {
                // force it to be a number
                return parseFloat(propValue);
            }
            if (propType & 1 /* String */) {
                // could have been passed as a number or boolean
                // but we still want it as a string
                return String(propValue);
            }
            // redundant return here for better minification
            return propValue;
        }
        // not sure exactly what type we want
        // so no need to change to a different type
        return propValue;
    };
    const getValue = (ref, propName) => getHostRef(ref).$instanceValues$.get(propName);
    const setValue = (ref, propName, newVal, cmpMeta) => {
        // check our new property value against our internal value
        const hostRef = getHostRef(ref);
        const elm = ref;
        const oldVal = hostRef.$instanceValues$.get(propName);
        const flags = hostRef.$flags$;
        const instance = elm;
        newVal = parsePropertyValue(newVal, cmpMeta.$members$[propName][0]);
        // explicitly check for NaN on both sides, as `NaN === NaN` is always false
        const areBothNaN = Number.isNaN(oldVal) && Number.isNaN(newVal);
        const didValueChange = newVal !== oldVal && !areBothNaN;
        if (didValueChange) {
            // gadzooks! the property's value has changed!!
            // set our new value!
            hostRef.$instanceValues$.set(propName, newVal);
            {
                // get an array of method names of watch functions to call
                if (cmpMeta.$watchers$ && flags & 128 /* isWatchReady */) {
                    const watchMethods = cmpMeta.$watchers$[propName];
                    if (watchMethods) {
                        // this instance is watching for when this property changed
                        watchMethods.map((watchMethodName) => {
                            try {
                                // fire off each of the watch methods that are watching this property
                                instance[watchMethodName](newVal, oldVal, propName);
                            }
                            catch (e) {
                                consoleError(e, elm);
                            }
                        });
                    }
                }
                if ((flags & (2 /* hasRendered */ | 16 /* isQueuedForUpdate */)) === 2 /* hasRendered */) {
                    if (instance.componentShouldUpdate) {
                        if (instance.componentShouldUpdate(newVal, oldVal, propName) === false) {
                            return;
                        }
                    }
                    // looks like this value actually changed, so we've got work to do!
                    // but only if we've already rendered, otherwise just chill out
                    // queue that we need to do an update, but don't worry about queuing
                    // up millions cuz this function ensures it only runs once
                    scheduleUpdate(hostRef, false);
                }
            }
        }
    };
    const proxyComponent = (Cstr, cmpMeta, flags) => {
        if (cmpMeta.$members$) {
            if (Cstr.watchers) {
                cmpMeta.$watchers$ = Cstr.watchers;
            }
            // It's better to have a const than two Object.entries()
            const members = Object.entries(cmpMeta.$members$);
            const prototype = Cstr.prototype;
            members.map(([memberName, [memberFlags]]) => {
                if ((memberFlags & 31 /* Prop */ ||
                        (memberFlags & 32 /* State */))) {
                    // proxyComponent - prop
                    Object.defineProperty(prototype, memberName, {
                        get() {
                            // proxyComponent, get value
                            return getValue(this, memberName);
                        },
                        set(newValue) {
                            // proxyComponent, set value
                            setValue(this, memberName, newValue, cmpMeta);
                        },
                        configurable: true,
                        enumerable: true,
                    });
                }
            });
            {
                const attrNameToPropName = new Map();
                prototype.attributeChangedCallback = function (attrName, _oldValue, newValue) {
                    plt.jmp(() => {
                        const propName = attrNameToPropName.get(attrName);
                        //  In a web component lifecycle the attributeChangedCallback runs prior to connectedCallback
                        //  in the case where an attribute was set inline.
                        //  ```html
                        //    <my-component some-attribute="some-value"></my-component>
                        //  ```
                        //
                        //  There is an edge case where a developer sets the attribute inline on a custom element and then
                        //  programmatically changes it before it has been upgraded as shown below:
                        //
                        //  ```html
                        //    <!-- this component has _not_ been upgraded yet -->
                        //    <my-component id="test" some-attribute="some-value"></my-component>
                        //    <script>
                        //      // grab non-upgraded component
                        //      el = document.querySelector("#test");
                        //      el.someAttribute = "another-value";
                        //      // upgrade component
                        //      customElements.define('my-component', MyComponent);
                        //    </script>
                        //  ```
                        //  In this case if we do not unshadow here and use the value of the shadowing property, attributeChangedCallback
                        //  will be called with `newValue = "some-value"` and will set the shadowed property (this.someAttribute = "another-value")
                        //  to the value that was set inline i.e. "some-value" from above example. When
                        //  the connectedCallback attempts to unshadow it will use "some-value" as the initial value rather than "another-value"
                        //
                        //  The case where the attribute was NOT set inline but was not set programmatically shall be handled/unshadowed
                        //  by connectedCallback as this attributeChangedCallback will not fire.
                        //
                        //  https://developers.google.com/web/fundamentals/web-components/best-practices#lazy-properties
                        //
                        //  TODO(STENCIL-16) we should think about whether or not we actually want to be reflecting the attributes to
                        //  properties here given that this goes against best practices outlined here
                        //  https://developers.google.com/web/fundamentals/web-components/best-practices#avoid-reentrancy
                        if (this.hasOwnProperty(propName)) {
                            newValue = this[propName];
                            delete this[propName];
                        }
                        else if (prototype.hasOwnProperty(propName) &&
                            typeof this[propName] === 'number' &&
                            this[propName] == newValue) {
                            // if the propName exists on the prototype of `Cstr`, this update may be a result of Stencil using native
                            // APIs to reflect props as attributes. Calls to `setAttribute(someElement, propName)` will result in
                            // `propName` to be converted to a `DOMString`, which may not be what we want for other primitive props.
                            return;
                        }
                        this[propName] = newValue === null && typeof this[propName] === 'boolean' ? false : newValue;
                    });
                };
                // create an array of attributes to observe
                // and also create a map of html attribute name to js property name
                Cstr.observedAttributes = members
                    .filter(([_, m]) => m[0] & 15 /* HasAttribute */) // filter to only keep props that should match attributes
                    .map(([propName, m]) => {
                    const attrName = m[1] || propName;
                    attrNameToPropName.set(attrName, propName);
                    if (m[0] & 512 /* ReflectAttr */) {
                        cmpMeta.$attrsToReflect$.push([propName, attrName]);
                    }
                    return attrName;
                });
            }
        }
        return Cstr;
    };
    const initializeComponent = async (elm, hostRef, cmpMeta, hmrVersionId, Cstr) => {
        // initializeComponent
        if ((hostRef.$flags$ & 32 /* hasInitializedComponent */) === 0) {
            {
                // sync constructor component
                Cstr = elm.constructor;
                hostRef.$flags$ |= 32 /* hasInitializedComponent */;
                // wait for the CustomElementRegistry to mark the component as ready before setting `isWatchReady`. Otherwise,
                // watchers may fire prematurely if `customElements.get()`/`customElements.whenDefined()` resolves _before_
                // Stencil has completed instantiating the component.
                customElements.whenDefined(cmpMeta.$tagName$).then(() => (hostRef.$flags$ |= 128 /* isWatchReady */));
            }
            if (Cstr.style) {
                // this component has styles but we haven't registered them yet
                let style = Cstr.style;
                if (typeof style !== 'string') {
                    style = style[(hostRef.$modeName$ = computeMode(elm))];
                }
                const scopeId = getScopeId(cmpMeta, hostRef.$modeName$);
                if (!styles.has(scopeId)) {
                    const endRegisterStyles = createTime('registerStyles', cmpMeta.$tagName$);
                    registerStyle(scopeId, style, !!(cmpMeta.$flags$ & 1 /* shadowDomEncapsulation */));
                    endRegisterStyles();
                }
            }
        }
        // we've successfully created a lazy instance
        hostRef.$ancestorComponent$;
        const schedule = () => scheduleUpdate(hostRef, true);
        {
            schedule();
        }
    };
    const fireConnectedCallback = (instance) => {
    };
    const connectedCallback = (elm) => {
        if ((plt.$flags$ & 1 /* isTmpDisconnected */) === 0) {
            const hostRef = getHostRef(elm);
            const cmpMeta = hostRef.$cmpMeta$;
            const endConnected = createTime('connectedCallback', cmpMeta.$tagName$);
            if (!(hostRef.$flags$ & 1 /* hasConnected */)) {
                // first time this component has connected
                hostRef.$flags$ |= 1 /* hasConnected */;
                {
                    // initUpdate
                    // if the slot polyfill is required we'll need to put some nodes
                    // in here to act as original content anchors as we move nodes around
                    // host element has been connected to the DOM
                    if ((cmpMeta.$flags$ & (4 /* hasSlotRelocation */ | 8 /* needsShadowDomShim */))) {
                        setContentReference(elm);
                    }
                }
                // Lazy properties
                // https://developers.google.com/web/fundamentals/web-components/best-practices#lazy-properties
                if (cmpMeta.$members$) {
                    Object.entries(cmpMeta.$members$).map(([memberName, [memberFlags]]) => {
                        if (memberFlags & 31 /* Prop */ && elm.hasOwnProperty(memberName)) {
                            const value = elm[memberName];
                            delete elm[memberName];
                            elm[memberName] = value;
                        }
                    });
                }
                {
                    initializeComponent(elm, hostRef, cmpMeta);
                }
            }
            else {
                // not the first time this has connected
                // reattach any event listeners to the host
                // since they would have been removed when disconnected
                addHostEventListeners(elm, hostRef, cmpMeta.$listeners$);
                // fire off connectedCallback() on component instance
                fireConnectedCallback(hostRef.$lazyInstance$);
            }
            endConnected();
        }
    };
    const setContentReference = (elm) => {
        // only required when we're NOT using native shadow dom (slot)
        // or this browser doesn't support native shadow dom
        // and this host element was NOT created with SSR
        // let's pick out the inner content for slot projection
        // create a node to represent where the original
        // content was first placed, which is useful later on
        const contentRefElm = (elm['s-cr'] = doc.createComment(''));
        contentRefElm['s-cn'] = true;
        elm.insertBefore(contentRefElm, elm.firstChild);
    };
    const disconnectedCallback = (elm) => {
        if ((plt.$flags$ & 1 /* isTmpDisconnected */) === 0) {
            const hostRef = getHostRef(elm);
            {
                if (hostRef.$rmListeners$) {
                    hostRef.$rmListeners$.map((rmListener) => rmListener());
                    hostRef.$rmListeners$ = undefined;
                }
            }
        }
    };
    const proxyCustomElement = (Cstr, compactMeta) => {
        const cmpMeta = {
            $flags$: compactMeta[0],
            $tagName$: compactMeta[1],
        };
        {
            cmpMeta.$members$ = compactMeta[2];
        }
        {
            cmpMeta.$listeners$ = compactMeta[3];
        }
        {
            cmpMeta.$watchers$ = Cstr.$watchers$;
        }
        {
            cmpMeta.$attrsToReflect$ = [];
        }
        if (!supportsShadow && cmpMeta.$flags$ & 1 /* shadowDomEncapsulation */) {
            cmpMeta.$flags$ |= 8 /* needsShadowDomShim */;
        }
        const originalConnectedCallback = Cstr.prototype.connectedCallback;
        const originalDisconnectedCallback = Cstr.prototype.disconnectedCallback;
        Object.assign(Cstr.prototype, {
            __registerHost() {
                registerHost(this, cmpMeta);
            },
            connectedCallback() {
                connectedCallback(this);
                if (originalConnectedCallback) {
                    originalConnectedCallback.call(this);
                }
            },
            disconnectedCallback() {
                disconnectedCallback(this);
                if (originalDisconnectedCallback) {
                    originalDisconnectedCallback.call(this);
                }
            },
            __attachShadow() {
                if (supportsShadow) {
                    {
                        this.attachShadow({
                            mode: 'open',
                            delegatesFocus: !!(cmpMeta.$flags$ & 16 /* shadowDelegatesFocus */),
                        });
                    }
                }
                else {
                    this.shadowRoot = this;
                }
            },
        });
        Cstr.is = cmpMeta.$tagName$;
        return proxyComponent(Cstr, cmpMeta);
    };
    const getAssetPath = (path) => {
        const assetUrl = new URL(path, plt.$resourcesUrl$);
        return assetUrl.origin !== win.location.origin ? assetUrl.href : assetUrl.pathname;
    };
    const setAssetPath = (path) => (plt.$resourcesUrl$ = path);
    const hostRefs = new WeakMap();
    const getHostRef = (ref) => hostRefs.get(ref);
    const registerHost = (elm, cmpMeta) => {
        const hostRef = {
            $flags$: 0,
            $hostElement$: elm,
            $cmpMeta$: cmpMeta,
            $instanceValues$: new Map(),
        };
        addHostEventListeners(elm, hostRef, cmpMeta.$listeners$);
        return hostRefs.set(elm, hostRef);
    };
    const isMemberInElement = (elm, memberName) => memberName in elm;
    const consoleError = (e, el) => (0, console.error)(e, el);
    const STENCIL_DEV_MODE = BUILD.isTesting
        ? ['STENCIL:'] // E2E testing
        : [
            '%cstencil',
            'color: white;background:#4c47ff;font-weight: bold; font-size:10px; padding:2px 6px; border-radius: 5px',
        ];
    const consoleDevError = (...m) => console.error(...STENCIL_DEV_MODE, ...m);
    const consoleDevWarn = (...m) => console.warn(...STENCIL_DEV_MODE, ...m);
    const styles = new Map();
    const modeResolutionChain = [];
    const queueDomReads = [];
    const queueDomWrites = [];
    const queueTask = (queue, write) => (cb) => {
        queue.push(cb);
        if (!queuePending) {
            queuePending = true;
            if (write && plt.$flags$ & 4 /* queueSync */) {
                nextTick(flush);
            }
            else {
                plt.raf(flush);
            }
        }
    };
    const consume = (queue) => {
        for (let i = 0; i < queue.length; i++) {
            try {
                queue[i](performance.now());
            }
            catch (e) {
                consoleError(e);
            }
        }
        queue.length = 0;
    };
    const flush = () => {
        // always force a bunch of medium callbacks to run, but still have
        // a throttle on how many can run in a certain time
        // DOM READS!!!
        consume(queueDomReads);
        // DOM WRITES!!!
        {
            consume(queueDomWrites);
            if ((queuePending = queueDomReads.length > 0)) {
                // still more to do yet, but we've run out of time
                // let's let this thing cool off and try again in the next tick
                plt.raf(flush);
            }
        }
    };
    const nextTick =  (cb) => promiseResolve().then(cb);
    const writeTask = /*@__PURE__*/ queueTask(queueDomWrites, true);
    ({
        isDev: BUILD.isDev ? true : false,
        isBrowser: true,
        isServer: false,
        isTesting: BUILD.isTesting ? true : false,
    });

    /** Detect free variable `global` from Node.js. */
    var freeGlobal$1 = typeof global == 'object' && global && global.Object === Object && global;

    /** Detect free variable `self`. */
    var freeSelf$1 = typeof self == 'object' && self && self.Object === Object && self;

    /** Used as a reference to the global object. */
    var root$1 = freeGlobal$1 || freeSelf$1 || Function('return this')();

    /** Built-in value references. */
    var Symbol$1 = root$1.Symbol;

    /** Used for built-in method references. */
    var objectProto$4 = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty$3 = objectProto$4.hasOwnProperty;

    /**
     * Used to resolve the
     * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
     * of values.
     */
    var nativeObjectToString$3 = objectProto$4.toString;

    /** Built-in value references. */
    var symToStringTag$3 = Symbol$1 ? Symbol$1.toStringTag : undefined;

    /**
     * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the raw `toStringTag`.
     */
    function getRawTag$1(value) {
      var isOwn = hasOwnProperty$3.call(value, symToStringTag$3),
          tag = value[symToStringTag$3];

      try {
        value[symToStringTag$3] = undefined;
        var unmasked = true;
      } catch (e) {}

      var result = nativeObjectToString$3.call(value);
      if (unmasked) {
        if (isOwn) {
          value[symToStringTag$3] = tag;
        } else {
          delete value[symToStringTag$3];
        }
      }
      return result;
    }

    /** Used for built-in method references. */
    var objectProto$3 = Object.prototype;

    /**
     * Used to resolve the
     * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
     * of values.
     */
    var nativeObjectToString$2 = objectProto$3.toString;

    /**
     * Converts `value` to a string using `Object.prototype.toString`.
     *
     * @private
     * @param {*} value The value to convert.
     * @returns {string} Returns the converted string.
     */
    function objectToString$1(value) {
      return nativeObjectToString$2.call(value);
    }

    /** `Object#toString` result references. */
    var nullTag$1 = '[object Null]',
        undefinedTag$1 = '[object Undefined]';

    /** Built-in value references. */
    var symToStringTag$2 = Symbol$1 ? Symbol$1.toStringTag : undefined;

    /**
     * The base implementation of `getTag` without fallbacks for buggy environments.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the `toStringTag`.
     */
    function baseGetTag$1(value) {
      if (value == null) {
        return value === undefined ? undefinedTag$1 : nullTag$1;
      }
      return (symToStringTag$2 && symToStringTag$2 in Object(value))
        ? getRawTag$1(value)
        : objectToString$1(value);
    }

    /**
     * Checks if `value` is object-like. A value is object-like if it's not `null`
     * and has a `typeof` result of "object".
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
     * @example
     *
     * _.isObjectLike({});
     * // => true
     *
     * _.isObjectLike([1, 2, 3]);
     * // => true
     *
     * _.isObjectLike(_.noop);
     * // => false
     *
     * _.isObjectLike(null);
     * // => false
     */
    function isObjectLike$2(value) {
      return value != null && typeof value == 'object';
    }

    /** `Object#toString` result references. */
    var symbolTag$1 = '[object Symbol]';

    /**
     * Checks if `value` is classified as a `Symbol` primitive or object.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
     * @example
     *
     * _.isSymbol(Symbol.iterator);
     * // => true
     *
     * _.isSymbol('abc');
     * // => false
     */
    function isSymbol$1(value) {
      return typeof value == 'symbol' ||
        (isObjectLike$2(value) && baseGetTag$1(value) == symbolTag$1);
    }

    /**
     * A specialized version of `_.map` for arrays without support for iteratee
     * shorthands.
     *
     * @private
     * @param {Array} [array] The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns the new mapped array.
     */
    function arrayMap$1(array, iteratee) {
      var index = -1,
          length = array == null ? 0 : array.length,
          result = Array(length);

      while (++index < length) {
        result[index] = iteratee(array[index], index, array);
      }
      return result;
    }

    /**
     * Checks if `value` is classified as an `Array` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an array, else `false`.
     * @example
     *
     * _.isArray([1, 2, 3]);
     * // => true
     *
     * _.isArray(document.body.children);
     * // => false
     *
     * _.isArray('abc');
     * // => false
     *
     * _.isArray(_.noop);
     * // => false
     */
    var isArray$2 = Array.isArray;

    /** Used as references for various `Number` constants. */
    var INFINITY$3 = 1 / 0;

    /** Used to convert symbols to primitives and strings. */
    var symbolProto$1 = Symbol$1 ? Symbol$1.prototype : undefined,
        symbolToString$1 = symbolProto$1 ? symbolProto$1.toString : undefined;

    /**
     * The base implementation of `_.toString` which doesn't convert nullish
     * values to empty strings.
     *
     * @private
     * @param {*} value The value to process.
     * @returns {string} Returns the string.
     */
    function baseToString$2(value) {
      // Exit early for strings to avoid a performance hit in some environments.
      if (typeof value == 'string') {
        return value;
      }
      if (isArray$2(value)) {
        // Recursively convert values (susceptible to call stack limits).
        return arrayMap$1(value, baseToString$2) + '';
      }
      if (isSymbol$1(value)) {
        return symbolToString$1 ? symbolToString$1.call(value) : '';
      }
      var result = (value + '');
      return (result == '0' && (1 / value) == -INFINITY$3) ? '-0' : result;
    }

    /** Used to match a single whitespace character. */
    var reWhitespace$1 = /\s/;

    /**
     * Used by `_.trim` and `_.trimEnd` to get the index of the last non-whitespace
     * character of `string`.
     *
     * @private
     * @param {string} string The string to inspect.
     * @returns {number} Returns the index of the last non-whitespace character.
     */
    function trimmedEndIndex$1(string) {
      var index = string.length;

      while (index-- && reWhitespace$1.test(string.charAt(index))) {}
      return index;
    }

    /** Used to match leading whitespace. */
    var reTrimStart$1 = /^\s+/;

    /**
     * The base implementation of `_.trim`.
     *
     * @private
     * @param {string} string The string to trim.
     * @returns {string} Returns the trimmed string.
     */
    function baseTrim$1(string) {
      return string
        ? string.slice(0, trimmedEndIndex$1(string) + 1).replace(reTrimStart$1, '')
        : string;
    }

    /**
     * Checks if `value` is the
     * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
     * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an object, else `false`.
     * @example
     *
     * _.isObject({});
     * // => true
     *
     * _.isObject([1, 2, 3]);
     * // => true
     *
     * _.isObject(_.noop);
     * // => true
     *
     * _.isObject(null);
     * // => false
     */
    function isObject$2(value) {
      var type = typeof value;
      return value != null && (type == 'object' || type == 'function');
    }

    /** Used as references for various `Number` constants. */
    var NAN$1 = 0 / 0;

    /** Used to detect bad signed hexadecimal string values. */
    var reIsBadHex$1 = /^[-+]0x[0-9a-f]+$/i;

    /** Used to detect binary string values. */
    var reIsBinary$1 = /^0b[01]+$/i;

    /** Used to detect octal string values. */
    var reIsOctal$1 = /^0o[0-7]+$/i;

    /** Built-in method references without a dependency on `root`. */
    var freeParseInt$1 = parseInt;

    /**
     * Converts `value` to a number.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to process.
     * @returns {number} Returns the number.
     * @example
     *
     * _.toNumber(3.2);
     * // => 3.2
     *
     * _.toNumber(Number.MIN_VALUE);
     * // => 5e-324
     *
     * _.toNumber(Infinity);
     * // => Infinity
     *
     * _.toNumber('3.2');
     * // => 3.2
     */
    function toNumber$1(value) {
      if (typeof value == 'number') {
        return value;
      }
      if (isSymbol$1(value)) {
        return NAN$1;
      }
      if (isObject$2(value)) {
        var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
        value = isObject$2(other) ? (other + '') : other;
      }
      if (typeof value != 'string') {
        return value === 0 ? value : +value;
      }
      value = baseTrim$1(value);
      var isBinary = reIsBinary$1.test(value);
      return (isBinary || reIsOctal$1.test(value))
        ? freeParseInt$1(value.slice(2), isBinary ? 2 : 8)
        : (reIsBadHex$1.test(value) ? NAN$1 : +value);
    }

    /**
     * Converts `value` to a string. An empty string is returned for `null`
     * and `undefined` values. The sign of `-0` is preserved.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {string} Returns the converted string.
     * @example
     *
     * _.toString(null);
     * // => ''
     *
     * _.toString(-0);
     * // => '-0'
     *
     * _.toString([1, 2, 3]);
     * // => '1,2,3'
     */
    function toString$3(value) {
      return value == null ? '' : baseToString$2(value);
    }

    /**
     * The base implementation of `_.propertyOf` without support for deep paths.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Function} Returns the new accessor function.
     */
    function basePropertyOf$1(object) {
      return function(key) {
        return object == null ? undefined : object[key];
      };
    }

    /**
     * Gets the timestamp of the number of milliseconds that have elapsed since
     * the Unix epoch (1 January 1970 00:00:00 UTC).
     *
     * @static
     * @memberOf _
     * @since 2.4.0
     * @category Date
     * @returns {number} Returns the timestamp.
     * @example
     *
     * _.defer(function(stamp) {
     *   console.log(_.now() - stamp);
     * }, _.now());
     * // => Logs the number of milliseconds it took for the deferred invocation.
     */
    var now = function() {
      return root$1.Date.now();
    };

    /** Error message constants. */
    var FUNC_ERROR_TEXT = 'Expected a function';

    /* Built-in method references for those with the same name as other `lodash` methods. */
    var nativeMax = Math.max,
        nativeMin = Math.min;

    /**
     * Creates a debounced function that delays invoking `func` until after `wait`
     * milliseconds have elapsed since the last time the debounced function was
     * invoked. The debounced function comes with a `cancel` method to cancel
     * delayed `func` invocations and a `flush` method to immediately invoke them.
     * Provide `options` to indicate whether `func` should be invoked on the
     * leading and/or trailing edge of the `wait` timeout. The `func` is invoked
     * with the last arguments provided to the debounced function. Subsequent
     * calls to the debounced function return the result of the last `func`
     * invocation.
     *
     * **Note:** If `leading` and `trailing` options are `true`, `func` is
     * invoked on the trailing edge of the timeout only if the debounced function
     * is invoked more than once during the `wait` timeout.
     *
     * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
     * until to the next tick, similar to `setTimeout` with a timeout of `0`.
     *
     * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
     * for details over the differences between `_.debounce` and `_.throttle`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Function
     * @param {Function} func The function to debounce.
     * @param {number} [wait=0] The number of milliseconds to delay.
     * @param {Object} [options={}] The options object.
     * @param {boolean} [options.leading=false]
     *  Specify invoking on the leading edge of the timeout.
     * @param {number} [options.maxWait]
     *  The maximum time `func` is allowed to be delayed before it's invoked.
     * @param {boolean} [options.trailing=true]
     *  Specify invoking on the trailing edge of the timeout.
     * @returns {Function} Returns the new debounced function.
     * @example
     *
     * // Avoid costly calculations while the window size is in flux.
     * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
     *
     * // Invoke `sendMail` when clicked, debouncing subsequent calls.
     * jQuery(element).on('click', _.debounce(sendMail, 300, {
     *   'leading': true,
     *   'trailing': false
     * }));
     *
     * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
     * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });
     * var source = new EventSource('/stream');
     * jQuery(source).on('message', debounced);
     *
     * // Cancel the trailing debounced invocation.
     * jQuery(window).on('popstate', debounced.cancel);
     */
    function debounce$1(func, wait, options) {
      var lastArgs,
          lastThis,
          maxWait,
          result,
          timerId,
          lastCallTime,
          lastInvokeTime = 0,
          leading = false,
          maxing = false,
          trailing = true;

      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      wait = toNumber$1(wait) || 0;
      if (isObject$2(options)) {
        leading = !!options.leading;
        maxing = 'maxWait' in options;
        maxWait = maxing ? nativeMax(toNumber$1(options.maxWait) || 0, wait) : maxWait;
        trailing = 'trailing' in options ? !!options.trailing : trailing;
      }

      function invokeFunc(time) {
        var args = lastArgs,
            thisArg = lastThis;

        lastArgs = lastThis = undefined;
        lastInvokeTime = time;
        result = func.apply(thisArg, args);
        return result;
      }

      function leadingEdge(time) {
        // Reset any `maxWait` timer.
        lastInvokeTime = time;
        // Start the timer for the trailing edge.
        timerId = setTimeout(timerExpired, wait);
        // Invoke the leading edge.
        return leading ? invokeFunc(time) : result;
      }

      function remainingWait(time) {
        var timeSinceLastCall = time - lastCallTime,
            timeSinceLastInvoke = time - lastInvokeTime,
            timeWaiting = wait - timeSinceLastCall;

        return maxing
          ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke)
          : timeWaiting;
      }

      function shouldInvoke(time) {
        var timeSinceLastCall = time - lastCallTime,
            timeSinceLastInvoke = time - lastInvokeTime;

        // Either this is the first call, activity has stopped and we're at the
        // trailing edge, the system time has gone backwards and we're treating
        // it as the trailing edge, or we've hit the `maxWait` limit.
        return (lastCallTime === undefined || (timeSinceLastCall >= wait) ||
          (timeSinceLastCall < 0) || (maxing && timeSinceLastInvoke >= maxWait));
      }

      function timerExpired() {
        var time = now();
        if (shouldInvoke(time)) {
          return trailingEdge(time);
        }
        // Restart the timer.
        timerId = setTimeout(timerExpired, remainingWait(time));
      }

      function trailingEdge(time) {
        timerId = undefined;

        // Only invoke if we have `lastArgs` which means `func` has been
        // debounced at least once.
        if (trailing && lastArgs) {
          return invokeFunc(time);
        }
        lastArgs = lastThis = undefined;
        return result;
      }

      function cancel() {
        if (timerId !== undefined) {
          clearTimeout(timerId);
        }
        lastInvokeTime = 0;
        lastArgs = lastCallTime = lastThis = timerId = undefined;
      }

      function flush() {
        return timerId === undefined ? result : trailingEdge(now());
      }

      function debounced() {
        var time = now(),
            isInvoking = shouldInvoke(time);

        lastArgs = arguments;
        lastThis = this;
        lastCallTime = time;

        if (isInvoking) {
          if (timerId === undefined) {
            return leadingEdge(lastCallTime);
          }
          if (maxing) {
            // Handle invocations in a tight loop.
            clearTimeout(timerId);
            timerId = setTimeout(timerExpired, wait);
            return invokeFunc(lastCallTime);
          }
        }
        if (timerId === undefined) {
          timerId = setTimeout(timerExpired, wait);
        }
        return result;
      }
      debounced.cancel = cancel;
      debounced.flush = flush;
      return debounced;
    }

    /** Used to map characters to HTML entities. */
    var htmlEscapes = {
      '&': '&amp;',
      '<': '&lt;',
      '>': '&gt;',
      '"': '&quot;',
      "'": '&#39;'
    };

    /**
     * Used by `_.escape` to convert characters to HTML entities.
     *
     * @private
     * @param {string} chr The matched character to escape.
     * @returns {string} Returns the escaped character.
     */
    var escapeHtmlChar = basePropertyOf$1(htmlEscapes);

    /** Used to match HTML entities and HTML characters. */
    var reUnescapedHtml = /[&<>"']/g,
        reHasUnescapedHtml = RegExp(reUnescapedHtml.source);

    /**
     * Converts the characters "&", "<", ">", '"', and "'" in `string` to their
     * corresponding HTML entities.
     *
     * **Note:** No other characters are escaped. To escape additional
     * characters use a third-party library like [_he_](https://mths.be/he).
     *
     * Though the ">" character is escaped for symmetry, characters like
     * ">" and "/" don't need escaping in HTML and have no special meaning
     * unless they're part of a tag or unquoted attribute value. See
     * [Mathias Bynens's article](https://mathiasbynens.be/notes/ambiguous-ampersands)
     * (under "semi-related fun fact") for more details.
     *
     * When working with HTML you should always
     * [quote attribute values](http://wonko.com/post/html-escaping) to reduce
     * XSS vectors.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to escape.
     * @returns {string} Returns the escaped string.
     * @example
     *
     * _.escape('fred, barney, & pebbles');
     * // => 'fred, barney, &amp; pebbles'
     */
    function escape(string) {
      string = toString$3(string);
      return (string && reHasUnescapedHtml.test(string))
        ? string.replace(reUnescapedHtml, escapeHtmlChar)
        : string;
    }

    /** Used to map HTML entities to characters. */
    var htmlUnescapes = {
      '&amp;': '&',
      '&lt;': '<',
      '&gt;': '>',
      '&quot;': '"',
      '&#39;': "'"
    };

    /**
     * Used by `_.unescape` to convert HTML entities to characters.
     *
     * @private
     * @param {string} chr The matched character to unescape.
     * @returns {string} Returns the unescaped character.
     */
    var unescapeHtmlChar = basePropertyOf$1(htmlUnescapes);

    /** Used to match HTML entities and HTML characters. */
    var reEscapedHtml = /&(?:amp|lt|gt|quot|#39);/g,
        reHasEscapedHtml = RegExp(reEscapedHtml.source);

    /**
     * The inverse of `_.escape`; this method converts the HTML entities
     * `&amp;`, `&lt;`, `&gt;`, `&quot;`, and `&#39;` in `string` to
     * their corresponding characters.
     *
     * **Note:** No other HTML entities are unescaped. To unescape additional
     * HTML entities use a third-party library like [_he_](https://mths.be/he).
     *
     * @static
     * @memberOf _
     * @since 0.6.0
     * @category String
     * @param {string} [string=''] The string to unescape.
     * @returns {string} Returns the unescaped string.
     * @example
     *
     * _.unescape('fred, barney, &amp; pebbles');
     * // => 'fred, barney, & pebbles'
     */
    function unescape(string) {
      string = toString$3(string);
      return (string && reHasEscapedHtml.test(string))
        ? string.replace(reEscapedHtml, unescapeHtmlChar)
        : string;
    }

    const cpAppCss = "";

    const CpApp$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        /**
         * When true, make whole thing clickable to favorite, otherwise link to the application.
         */
        this.editMode = false;
        /**
         * The optional target window. Defaults to `_self`.
         */
        this.target = "_self";
      }
      /**
       * Set the edit mode for the control.
       *
       * @param mode - The mode, true when editing is enabled, false otherwise.
       */
      async setEditMode(mode) {
        this.editMode = mode;
      }
      /**
       * Event handler for the click event, this allows the whole link to trigger the cp-favorite-selector 'click' event
       * which helps with users having trouble precision clicking the star.
       */
      handleClick() {
        if (this.editMode) {
          const selector = document.querySelector("cp-favorite-selector[name=" + escape(this.name) + "]");
          if (selector) {
            selector.click();
          }
        }
      }
      render() {
        return (h(Host, null, h("a", { href: !this.editMode ? this.url : "javascript:void(0)", target: !this.editMode ? this.target : "_self", id: `tools-${this.uniquekey}` }, h("img", { class: "cp-app__image", src: this.iconurl, role: "presentation" }), h("span", null, this.description))));
      }
      static get style() { return cpAppCss; }
    };

    const cpConsentPrivacyImageCss = "";

    const CpConsentPrivacyImage$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.consentPrivacyImg = (h("svg", { xmlns: "http://www.w3.org/2000/svg", "data-name": "Layer 1", width: "942.54724", height: "631.43903", viewBox: "0 0 942.54724 631.43903" }, h("path", { d: "M879.59026,413.72015l2.79791-22.42655a30.28454,30.28454,0,0,1,60.10315,7.4984l-2.79791,22.42654a4.07267,4.07267,0,0,1-4.5404,3.53316l-52.02959-6.49115A4.07266,4.07266,0,0,1,879.59026,413.72015Z", transform: "translate(-128.72638 -134.28048)", fill: "#2f2e41" }), h("circle", { cx: "775.78648", cy: "263.92678", r: "22.20356", fill: "#ffb8b8" }), h("path", { d: "M875.05486,392.20076a23.98352,23.98352,0,0,1,26.73792-20.80636l4.48553.55961a23.98334,23.98334,0,0,1,20.80614,26.73789l-.056.44853-9.47894-1.18258-2.10358-9.45631L913.67,397.47385l-4.8988-.61117-1.06132-4.77116-.89618,4.52695-31.81482-3.96918Z", transform: "translate(-128.72638 -134.28048)", fill: "#2f2e41" }), h("path", { d: "M795.91611,477.41149a10.22784,10.22784,0,0,0,15.28426,3.51477L831.3673,492.74l10.16823-10.50441-28.71392-16.28326a10.28328,10.28328,0,0,0-16.9055,11.45917Z", transform: "translate(-128.72638 -134.28048)", fill: "#ffb8b8" }), h("path", { d: "M862.01251,498.63944c-14.87549,0-41.052-6.65918-42.50146-7.03125l-.45777-.11719,4.11988-20.85889,39.98193,7.897,21.7207-30.58692,24.93726-2.53515-.69605.916c-.32422.42676-32.46972,42.74317-37.47241,49.8418C870.38214,497.95585,866.77618,498.63944,862.01251,498.63944Z", transform: "translate(-128.72638 -134.28048)", fill: "#3f3d56" }), h("path", { d: "M866.00055,576.92752l-.59522-.28417c-.12671-.06055-12.76513-6.208-19.31128-18.209-6.51489-11.94434,23.98316-62.6123,26.1167-66.12793l.031-16.09082L883.213,446.59452l13.9917-7.90821L885.19171,466.7161Z", transform: "translate(-128.72638 -134.28048)", fill: "#3f3d56" }), h("polygon", { points: "723.257 615.591 709.885 615.59 703.523 564.011 723.259 564.012 723.257 615.591", fill: "#ffb8b8" }), h("path", { d: "M855.39347,762.83333l-43.11785-.00159v-.54537A16.78359,16.78359,0,0,1,829.05829,745.504h.00107l26.33491.00107Z", transform: "translate(-128.72638 -134.28048)", fill: "#2f2e41" }), h("polygon", { points: "866.891 603.872 854.184 608.035 832.077 561.002 850.832 554.857 866.891 603.872", fill: "#ffb8b8" }), h("path", { d: "M1002.89464,749.40842,961.92,762.83333l-.16982-.51825a16.78358,16.78358,0,0,1,10.72241-21.174l.001-.00033,25.02593-8.1994Z", transform: "translate(-128.72638 -134.28048)", fill: "#2f2e41" }), h("path", { d: "M969.72638,729.71952l-38.1205-63.64087L899.4256,598.08573l-28.95826,60.06054-11.50366,77.78809-40.343.56055.15893-.63086L880.51715,490.5535l48.352,7.22363-2.20093,31.916,1.31079,1.86426c10.92261,15.5166,22.21607,31.55957,15.73877,48.85351l18.36231,54.52246,40.64624,90.78614Z", transform: "translate(-128.72638 -134.28048)", fill: "#2f2e41" }), h("path", { d: "M882.72638,543.71952c-7.00635,0-15-8-10.853-21.65821l-.26855-.19433,9.96069-44.00781c-8.69263-12.43165,2.76807-22.69141,3.842-23.60791l5.4707-9.84717,24.1377-15.30811L927.22882,530.5701l-.18066.17285C918.2276,539.18241,888.60358,543.71952,882.72638,543.71952Z", transform: "translate(-128.72638 -134.28048)", fill: "var(--cp-graphic-color)" }), h("path", { d: "M932.15948,566.617a11.88134,11.88134,0,0,1-2.85131-.30176c-.93873-.23535-2.4585-1.43066-4.80689-9.07715-9.33618-30.39746-20.35913-121.86035-12.35083-130.81055l.18335-.20507,13.14893,2.1914c1.093-.80664,6.82861-4.81054,12.12133-4.11425a8.033,8.033,0,0,1,5.49659,3.249l.09057.11865,4.189,59.59424,15.34619,70.13086-.36792.167C961.46564,557.96561,942.303,566.617,932.15948,566.617Z", transform: "translate(-128.72638 -134.28048)", fill: "#3f3d56" }), h("path", { d: "M923.31655,543.32446a10.22788,10.22788,0,0,0,9.66238-12.35317l19.24856-13.25752-5.20361-13.66228-26.91975,19.104a10.28328,10.28328,0,0,0,3.21242,20.169Z", transform: "translate(-128.72638 -134.28048)", fill: "#ffb8b8" }), h("path", { d: "M945.876,528.3367l-17.14551-12.57324,24.10083-32.86426L934.33624,450.261l8.27466-23.66113.53467,1.019c.249.47461,24.94824,47.52686,29.25683,55.06738,4.48267,7.84375-24.97,43.76075-26.22583,45.28516Z", transform: "translate(-128.72638 -134.28048)", fill: "#3f3d56" }), h("path", { d: "M560.20614,676.255l-14.5923-6.1443-10.01026-73.15138H402.299L391.4486,669.81186l-13.05511,6.52746a3.10016,3.10016,0,0,0,1.38657,5.873H559.00349A3.1,3.1,0,0,0,560.20614,676.255Z", transform: "translate(-128.72638 -134.28048)", fill: "#e6e6e6" }), h("path", { d: "M797.09757,606.69181H142.26837a12.97344,12.97344,0,0,1-12.9443-12.97332V501.379h680.7178v92.33952A12.97357,12.97357,0,0,1,797.09757,606.69181Z", transform: "translate(-128.72638 -134.28048)", fill: "#ccc" }), h("path", { d: "M810.72638,545.02084h-682V149.91957A15.65719,15.65719,0,0,1,144.366,134.28048H795.08655a15.65736,15.65736,0,0,1,15.63983,15.63909Z", transform: "translate(-128.72638 -134.28048)", fill: "#3f3d56" }), h("path", { d: "M769.99322,516.34435H169.45954a12.07024,12.07024,0,0,1-12.057-12.05667v-329.274a12.07088,12.07088,0,0,1,12.057-12.05741H769.99322a12.07088,12.07088,0,0,1,12.057,12.05741v329.274A12.07024,12.07024,0,0,1,769.99322,516.34435Z", transform: "translate(-128.72638 -134.28048)", fill: "#fff" }), h("path", { d: "M638.14638,682.97542l-337.44822,0a1.56681,1.56681,0,0,1-1.53908-1.13363,1.52911,1.52911,0,0,1,1.47725-1.91893l337.385,0a1.61535,1.61535,0,0,1,1.61617,1.19368A1.52819,1.52819,0,0,1,638.14638,682.97542Z", transform: "translate(-128.72638 -134.28048)", fill: "#ccc" }), h("rect", { x: "489.85973", y: "81.90943", width: "144.99594", height: "110.7733", fill: "#f2f2f2" }), h("rect", { x: "497.0645", y: "87.41369", width: "130.58641", height: "99.76477", fill: "#fff" }), h("path", { d: "M693.37738,295.69477q.02592.00028.05185-.00109a34.81675,34.81675,0,0,0,.779-69.48892.79424.79424,0,0,0-.60112.20836.78592.78592,0,0,0-.25678.57553l-.7612,67.902a.79707.79707,0,0,0,.78826.80412Z", transform: "translate(-128.72638 -134.28048)", fill: "#3f3d56" }), h("path", { d: "M666.072,237.43291a1.02524,1.02524,0,0,1,.71962.30735l23.37584,23.90588a1.01418,1.01418,0,0,1,.29094.72511l-.36424,32.49143a1.01059,1.01059,0,0,1-.33018.73985,1.026,1.026,0,0,1-.77126.26782,35.04446,35.04446,0,0,1-23.69951-58.09062,1.02636,1.02636,0,0,1,.74091-.34658Q666.05306,237.4327,666.072,237.43291Z", transform: "translate(-128.72638 -134.28048)", fill: "#e6e6e6" }), h("path", { d: "M689.84193,225.9272a1.02931,1.02931,0,0,1,.69948.28585,1.01135,1.01135,0,0,1,.31394.74786l-.32864,29.31578a1.02077,1.02077,0,0,1-1.75041.70223L668.378,236.11808a1.02291,1.02291,0,0,1,.05493-1.48163,35.11806,35.11806,0,0,1,21.34564-8.708C689.79961,225.92739,689.82088,225.927,689.84193,225.9272Z", transform: "translate(-128.72638 -134.28048)", fill: "var(--cp-graphic-color)" }), h("path", { d: "M679.33353,309.77539a6.25343,6.25343,0,1,1-6.18294-6.32313A6.26054,6.26054,0,0,1,679.33353,309.77539Z", transform: "translate(-128.72638 -134.28048)", fill: "var(--cp-graphic-color)" }), h("path", { d: "M697.19935,309.97567a6.25343,6.25343,0,1,1-6.18294-6.32313A6.26056,6.26056,0,0,1,697.19935,309.97567Z", transform: "translate(-128.72638 -134.28048)", fill: "#3f3d56" }), h("path", { d: "M715.06516,310.176a6.25343,6.25343,0,1,1-6.18294-6.32314A6.26054,6.26054,0,0,1,715.06516,310.176Z", transform: "translate(-128.72638 -134.28048)", fill: "#e6e6e6" }), h("rect", { x: "488.33346", y: "210.11637", width: "144.99594", height: "110.7733", fill: "#f2f2f2" }), h("rect", { x: "495.53823", y: "215.62063", width: "130.58641", height: "99.76477", fill: "#fff" }), h("circle", { cx: "517.69473", cy: "242.98812", r: "5.42203", fill: "#3f3d56" }), h("path", { d: "M733.53881,373.0493a3.67713,3.67713,0,1,1,0,7.35425H676.51323a3.67712,3.67712,0,1,1,0-7.35425h57.02558m0-.9006H676.51323a4.57773,4.57773,0,1,0,0,9.15545h57.02558a4.57773,4.57773,0,1,0,0-9.15545Z", transform: "translate(-128.72638 -134.28048)", fill: "#3f3d56" }), h("path", { d: "M711.03754,381.30414h-42.9283a4.57772,4.57772,0,1,1,0-9.15544h42.9283a4.57772,4.57772,0,0,1,0,9.15544Z", transform: "translate(-128.72638 -134.28048)", fill: "var(--cp-graphic-color)" }), h("circle", { cx: "517.69473", cy: "265.50302", r: "5.42203", fill: "#3f3d56" }), h("path", { d: "M733.53881,395.5642a3.67713,3.67713,0,1,1,0,7.35425H676.51323a3.67712,3.67712,0,1,1,0-7.35425h57.02558m0-.9006H676.51323a4.57772,4.57772,0,1,0,0,9.15545h57.02558a4.57772,4.57772,0,1,0,0-9.15545Z", transform: "translate(-128.72638 -134.28048)", fill: "#3f3d56" }), h("path", { d: "M727.24826,403.819h-59.139a4.57772,4.57772,0,1,1,0-9.15544h59.139a4.57772,4.57772,0,0,1,0,9.15544Z", transform: "translate(-128.72638 -134.28048)", fill: "var(--cp-graphic-color)" }), h("circle", { cx: "517.69473", cy: "288.01792", r: "5.42203", fill: "#3f3d56" }), h("path", { d: "M733.53881,418.0791a3.67713,3.67713,0,1,1,0,7.35425H676.51323a3.67712,3.67712,0,1,1,0-7.35425h57.02558m0-.9006H676.51323a4.57772,4.57772,0,1,0,0,9.15545h57.02558a4.57772,4.57772,0,1,0,0-9.15545Z", transform: "translate(-128.72638 -134.28048)", fill: "#3f3d56" }), h("path", { d: "M692.125,426.33393H668.10924a4.57772,4.57772,0,1,1,0-9.15543H692.125a4.57772,4.57772,0,0,1,0,9.15543Z", transform: "translate(-128.72638 -134.28048)", fill: "var(--cp-graphic-color)" }), h("rect", { x: "51.18842", y: "101.50782", width: "405.09331", height: "207.61032", fill: "#f2f2f2" }), h("rect", { x: "64.69153", y: "111.82386", width: "378.08709", height: "186.97824", fill: "#fff" }), h("path", { d: "M524.61425,404.55724H248.996a.8626.8626,0,0,1-.86256-.86256V271.59086a.86256.86256,0,1,1,1.72512,0V402.83212H524.61425a.86256.86256,0,0,1,0,1.72512Z", transform: "translate(-128.72638 -134.28048)", fill: "#3f3d56" }), h("path", { d: "M307.88363,395.06909H282.81508a2.56336,2.56336,0,0,1-2.56051-2.5603V357.95166a2.56337,2.56337,0,0,1,2.56051-2.5603h25.06855a2.56337,2.56337,0,0,1,2.56051,2.5603v34.55713A2.56336,2.56336,0,0,1,307.88363,395.06909Z", transform: "translate(-128.72638 -134.28048)", fill: "var(--cp-graphic-color)" }), h("path", { d: "M353.59927,395.06909H328.53072a2.56336,2.56336,0,0,1-2.56051-2.5603V325.17441a2.56336,2.56336,0,0,1,2.56051-2.5603h25.06855a2.56336,2.56336,0,0,1,2.56051,2.5603v67.33438A2.56336,2.56336,0,0,1,353.59927,395.06909Z", transform: "translate(-128.72638 -134.28048)", fill: "var(--cp-graphic-color)" }), h("path", { d: "M399.31491,395.06909H374.24636a2.56337,2.56337,0,0,1-2.56051-2.5603V357.95166a2.56337,2.56337,0,0,1,2.56051-2.5603h25.06855a2.56337,2.56337,0,0,1,2.56052,2.5603v34.55713A2.56337,2.56337,0,0,1,399.31491,395.06909Z", transform: "translate(-128.72638 -134.28048)", fill: "var(--cp-graphic-color)" }), h("path", { d: "M445.03056,395.06909H419.962a2.50734,2.50734,0,0,1-2.56052-2.44431V312.12a2.50734,2.50734,0,0,1,2.56052-2.44431h25.06855a2.50734,2.50734,0,0,1,2.56051,2.44431v80.50475A2.50734,2.50734,0,0,1,445.03056,395.06909Z", transform: "translate(-128.72638 -134.28048)", fill: "var(--cp-graphic-color)" }), h("path", { d: "M490.7462,395.06909H465.67765a2.56336,2.56336,0,0,1-2.56051-2.5603V288.94692a2.56336,2.56336,0,0,1,2.56051-2.5603H490.7462a2.56336,2.56336,0,0,1,2.56051,2.5603V392.50879A2.56336,2.56336,0,0,1,490.7462,395.06909Z", transform: "translate(-128.72638 -134.28048)", fill: "var(--cp-graphic-color)" }), h("circle", { cx: "166.62298", cy: "205.58481", r: "5.17536", fill: "#3f3d56" }), h("circle", { cx: "212.33862", cy: "171.945", r: "5.17536", fill: "#3f3d56" }), h("circle", { cx: "258.05426", cy: "205.58481", r: "5.17536", fill: "#3f3d56" }), h("circle", { cx: "303.7699", cy: "155.55637", r: "5.17536", fill: "#3f3d56" }), h("circle", { cx: "349.48555", cy: "136.58007", r: "5.17536", fill: "#3f3d56" }), h("polygon", { points: "258.163 206.744 212.339 172.421 167.14 206.275 166.106 204.895 212.339 170.265 257.945 204.425 303.266 154.83 303.447 154.756 349.163 136.337 349.808 137.937 304.274 156.283 258.163 206.744", fill: "#3f3d56" }), h("path", { d: "M1070.27362,765.71952h-381a1,1,0,0,1,0-2h381a1,1,0,0,1,0,2Z", transform: "translate(-128.72638 -134.28048)", fill: "#ccc" })));
      }
      render() {
        return this.consentPrivacyImg;
      }
      static get style() { return cpConsentPrivacyImageCss; }
    };

    var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

    function createCommonjsModule(fn, basedir, module) {
    	return module = {
    		path: basedir,
    		exports: {},
    		require: function (path, base) {
    			return commonjsRequire();
    		}
    	}, fn(module, module.exports), module.exports;
    }

    function commonjsRequire () {
    	throw new Error('Dynamic requires are not currently supported by @rollup/plugin-commonjs');
    }

    var Html = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.htmlEscape = exports.entityMap = void 0;
    exports.entityMap = {
        "&": `&amp;`,
        "<": `&lt;`,
        ">": "&gt;",
        '"': "&quot;",
        "'": "&#39;",
        "/": "&#x2F;",
    };
    /**
     * Escape a string with html entities.
     * @example
     *      htmlEscape("<cPanel & WHM>") // => &lt;cPanel &amp; WHM&gt;
     *
     * @param {string} text plain text value
     * @returns {string} html escaped string
     */
    function htmlEscape(text) {
        // eslint-disable-next-line no-useless-escape -- this is a regex, not a string
        return String(text).replace(/[&<>"'\/]/g, (key) => exports.entityMap[key]);
    }
    exports.htmlEscape = htmlEscape;

    });

    var listToObject_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.listToObject = void 0;
    /**
     * Validates associative list can be converted into object
     * @example
     *      validate(['a', 1, 'b', 2]) // => {a:1, b:2}
     * @return {boolean} if associative list can be converted into object.
     */
    function validate(keyValues) {
        const len = keyValues.length;
        if (len % 2 > 0) {
            throw new Error("An associative list must have an even number of parts: {name1}, {value1}, {name2}, {value2} ...");
        }
        for (let i = 0, l = keyValues.length; i < l; i = i + 2) {
            const name = keyValues[i];
            if (typeof name !== "string" || name === "") {
                throw new Error("An associative list must provide non-empty string names in the 1st, 3rd, ... positions.");
            }
        }
        return true;
    }
    /**
     * Retrieve the object representation of the associative list
     * @example
     *      arrayToObject(['a', 1, 'b', 2]) // => {a:1, b:2}
     * @return {Object} with the name/value pairs setup.
     */
    function arrayToObject(keyValues) {
        const len = keyValues.length;
        const obj = {};
        let pos = 0, key, value;
        while (pos < len) {
            key = keyValues[pos];
            value = keyValues[++pos];
            obj[key] = value;
            pos++;
        }
        return obj;
    }
    /**
     * converts associative list to object
     * @example
     *     listToObject('a', 1, 'b', 2) // => {a:1, b:2}
     *
     * @param {string} text plain text value
     * @returns {string} html escaped string
     */
    function listToObject(...nameValues) {
        let obj = {};
        if (validate(nameValues)) {
            obj = arrayToObject(nameValues);
        }
        return obj;
    }
    exports.listToObject = listToObject;

    });

    var output_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.functions = exports.output = void 0;


    /**
     * Output operator for bracket notation. Acts as "dispatch" function for the
     * output methods below.
     * @example
     *      output({args:["chr",65]}) // => "A"
     * @param  {string} func     Name of the output function to process
     * @param  {any[]}    rest     Any additional arguments to pass to the transform
     * @return {string}          Processed output.
     */
    function output({ args: [func, ...rest], }) {
        // Implementation of the chr() and amp() embeddable methods
        // [output,strong,cat amp() dog] => <strong>cat &amp; dog</strong>
        // [output,strong,cat chr(38) dog] => <strong>cat &amp; dog</strong>
        if (rest && typeof rest[0] === "string") {
            rest[0] = rest[0].replace(/chr\((\d+)\)/g, function (template, p1) {
                return exports.functions.chr(Number(p1));
            });
            rest[0] = rest[0].replace(/amp\(\)/g, function (template) {
                return exports.functions.amp();
            });
        }
        if (typeof exports.functions[func] === "function") {
            return exports.functions[func](...rest);
        }
        else {
            throw new Error(`Locale output function '${func}' is not implemented.`);
        }
    }
    exports.output = output;
    exports.functions = {
        /**
         * Output the HTML escaped version of an ampersand.
         * @example
         *      amp() // => "&amp;"
         * @return {string} HTML safe value of &
         */
        amp() {
            return Html.htmlEscape("&");
        },
        /**
         * Output an HTML safe apostrophe
         * @example
         *      apos() // => "&#39;"
         * @return {string} HTML safe apostrophe
         */
        apos() {
            return Html.htmlEscape("'");
        },
        /**
         * Output an HTML safe quote mark
         * @example
         *      quot() // => "&quot;"
         * @return {string} HTML safe quote
         */
        quot() {
            return Html.htmlEscape('"');
        },
        /**
         * Output the string wrapped in a <u> HTML tag
         * @example
         *      underline("text") //=> <u>text</u>
         * @param  {string} str
         * @return {string} string wrapped in <u> HTML tag
         */
        underline(str) {
            return `<u>${str}</u>`;
        },
        /**
         * Output the string wrapped in a <strong> HTML tag
         * @example
         *      strong("text") // => <strong>text</strong>
         * @param  {string} str
         * @return {string} string wrapped in <strong> HTML tag
         */
        strong(str) {
            return `<strong>${str}</strong>`;
        },
        /**
         * Output the string wrapped in a <em> HTML tag
         * @example
         *      em("text") // => <em>text</em>
         * @param  {string} str
         * @return {string} string wrapped in <em> HTML tag
         */
        em(str) {
            return `<em>${str}</em>`;
        },
        /**
         * Output the string wrapped in a <abbr> HTML tag
         *
         * @example
         *      abbr("WHO", "World Health Organization"); // => <abbr title="World Health Organization">WHO</abbr>
         * @param  {string} abbr Abbreviation
         * @param  {string} full Full version of the abbreviation
         * @return {string} string wrapped in <abbr> HTML tag
         */
        abbr(abbr, full) {
            return `<abbr title="${full}">${abbr}</abbr>`;
        },
        /**
         * Output the string wrapped in a <abbr> HTML tag with special markings
         * @example
         *      acronym("WHO", "World Health Organization"); // => <abbr title="World Health Organization" class="initialism">WHO</abbr>
         * @param  {string} abbr Acronym
         * @param  {string} full Full version of the acronym
         * @return {string} string wrapped in <abbr>
         */
        acronym(abbr, full) {
            return `<abbr title="${full}" class="initialism">${abbr}</abbr>`;
        },
        /**
         * Output the string wrapped in a <span> HTML tag with the provided classes
         * @example
         *      class("text","text-bold","text-underline") // => <span class="text-bold text-underline">text</span>
         * @param {string} str String to embed in the span.
         * @param {...string} classes class names as arguments.
         * @return {string} span with classnames
         */
        class(str, ...classes) {
            const classNames = classes.join(" ");
            return `<span class="${classNames}">${str}</span>`;
        },
        /**
         * Output the requested character encoded as an HTML character.
         * @example
         *      chr(65) // => "A"
         * @param  {number|string} num Character code to output.
         * @return {string} requested character encoded as an HTML character.
         */
        chr(num) {
            if (typeof num === "string") {
                num = Number(num);
            }
            if (typeof num !== "number" || isNaN(num)) {
                throw new Error("chr needs a number as argument");
            }
            return Html.htmlEscape(String.fromCharCode(num));
        },
        /**
         * Output HTML anchor link based on input provided.
         * Note: The special key/value _type,offsite can be used to make an offsite link.
         *
         * @example
         *  url("https://somewhere.tld") // => <a href="https://somewhere.tld">https://somewhere.tld</a>
         *  url("https://somewhere.tld", "Click Here") // => <a href="https://somewhere.tld">Click Here</a>
         *  url("https://somewhere.tld", "Click Here", { "_type": "offsite" }) // => <a href="https://somewhere.tld" class="offsite" target="_blank">Click Here</a>
         *  url("https://somewhere.tld", "Click Here", "class", "class1 class2"]) // => <a href="https://somewhere.tld" class="class1 class2">Click Here</a>
         *  url("https://somewhere.tld", { html: "Click Here" }) // => <a href="https://somewhere.tld">Click Here</a>
         *
         * @param {string} dest href value.
         * @param {...any} [rest] additional parameters
         * @return {string} HTML anchor link
         */
        url(dest, ...rest) {
            let config, text;
            if (typeof rest[rest.length - 1] === "object") {
                // when config object is provided as parameter
                config = rest[rest.length - 1]; // config object is the last item in arguments
                if (rest.length === 2) {
                    // addresses url( dest, text, { "class": "class1 class2" } )
                    if (config.html) {
                        throw new Error("Cannot provide both text and configuration with html attribute");
                    }
                    text = rest[0];
                }
                else if (config && config.html) {
                    // addresses url( dest, { "html": "text", "class": "class1 class2" } )
                    text = config.html;
                    delete config.html;
                }
                else {
                    // addresses url( dest, { "class": "class1 class2" } )
                    text = dest;
                }
            }
            else if (rest.length % 2 === 0) {
                // when no object is provided. example: url(dest,"html", "Click Here")
                config = listToObject_1.listToObject(...rest);
                if (config && "html" in config && config.html !== "") {
                    // url(dest,"html", "Click Here")
                    text = config.html;
                    delete config.html;
                }
                else {
                    // url(dest,"class", "class1 class2")
                    text = dest;
                }
            }
            else {
                // addresses url(dest, "Click Here", "class", "class1 class2")
                text = rest.shift();
                config = listToObject_1.listToObject(...rest);
            }
            // Special handle offsite links
            if ("_type" in config && config._type === "offsite") {
                config["class"] = "offsite";
                config.target = "_blank";
                delete config._type;
            }
            // Generates anchor tag
            let html = `<a href="${dest}"`;
            if (typeof config === "object") {
                for (const key in config) {
                    if (Object.prototype.hasOwnProperty.call(config, key)) {
                        html += ` ${key}="${config[key]}"`;
                    }
                }
            }
            html += `>${text}</a>`;
            return html;
        },
    };

    });

    var asis_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.asis = void 0;

    /**
     * Returns a string asis without any translation.
     * NOTE: asis function only takes one non translatable string
     * @example
     *      asis({args:["cPanel"]}); // => cPanel
     * @param {string} nonTranslatableString The string that should not be translated.
     * @returns {string} string that should not be translated.
     */
    function asis({ args: [nonTranslatableString, ...rejectedArgs], }) {
        if (!nonTranslatableString ||
            rejectedArgs.length > 0 ||
            typeof nonTranslatableString !== "string") {
            throw new Error("asis function accepts one non translatable string.");
        }
        // Implementation of embeddable methods chr()
        // [asis,cat chr(38) dog] => cat &amp; dog
        nonTranslatableString = nonTranslatableString.replace(/chr\((\d+)\)/g, function (template, p1) {
            return output_1.functions.chr(Number(p1));
        });
        // Implementation of embeddable method amp()
        // [asis,cat amp() dog] => cat &amp; dog
        nonTranslatableString = nonTranslatableString.replace(/amp\(\)/g, function (template) {
            return output_1.functions.amp();
        });
        return nonTranslatableString;
    }
    exports.asis = asis;

    });

    var comment_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.comment = void 0;
    /**
     * Ensures comments are not translated
     *
     * @example
     *      comment({args:["some random comment"]}) // => ""
     * @param {string} [commentText] Comment
     * @returns {string} empty string
     */
    function comment({ args: [commentText] }) {
        return "";
    }
    exports.comment = comment;

    });

    var boolean_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.boolean = void 0;
    /**
     * Returns a string based on the truthy value of a condition.
     *
     * Perl has undef, but JavaScript has both null *and* undefined.
     * Let's treat null as undefined since JSON doesn't know what
     * undefined is, so serializers use null instead.
     *
     * @example
     *      boolean({args: [true,"yes","no", "maybe"]}); // => "yes"
     *      boolean({args: [false,"yes","no"]}) // => "no"
     *      boolean({args: [null,"yes","no", "maybe"]}); // => "maybe"
     * @param {any} condition      The value to test.
     * @param {string} whenTrue    The string to return when the condition is true.
     * @param {string} whenFalse   The string to return when the condition is false.
     * @param {string} [whenNull]   The string to return when the condition is null or undefined.
     */
    function boolean({ args: [condition, whenTrue, whenFalse, whenNull], }) {
        if (whenTrue == null ||
            whenTrue.length === 0 ||
            whenFalse == null ||
            whenFalse.length === 0) {
            throw new Error("boolean function needs a valid whenTrue, whenFalse arguments.");
        }
        if (typeof condition !== "undefined" && condition) {
            return String(whenTrue);
        }
        else if (whenNull && condition == null) {
            return String(whenNull);
        }
        return String(whenFalse);
    }
    exports.boolean = boolean;

    });

    var cldr = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CLDR = void 0;
    class CLDR {
        /**
         * Creates a new instance of cldr object.
         */
        constructor(cldr) {
            this.rawData = cldr;
            this.validateCLDR(this.rawData);
        }
        /**
         * validates CLDR data passed in
         * @param {RawCLDR} rawCLDR CLDR passed
         * @returns {boolean} returns true if cldr is valid.
         *                    Throws exception when cldr is missing required data
         */
        validateCLDR(rawCLDR) {
            const validCLDR = true;
            if (rawCLDR) {
                if (!rawCLDR.locale) {
                    throw new Error("CLDR data is missing locale information");
                }
                if (!Object.prototype.hasOwnProperty.call(rawCLDR, "functions") ||
                    Object.prototype.hasOwnProperty.call(rawCLDR, "get_plural_form") ||
                    typeof rawCLDR.functions.get_plural_form !== "function") {
                    throw new Error("CLDR data is missing function get_plural_form");
                }
                if (!Object.prototype.hasOwnProperty.call(rawCLDR, "datetime_info")) {
                    throw new Error("CLDR data is missing datetime_info");
                }
                if (Object.prototype.hasOwnProperty.call(rawCLDR, "misc_info")) {
                    if (!Object.prototype.hasOwnProperty.call(rawCLDR.misc_info, "cldr_formats")) {
                        throw new Error("CLDR data is missing cldr_formats");
                    }
                    if (!Object.prototype.hasOwnProperty.call(rawCLDR.misc_info, "orientation") ||
                        !Object.prototype.hasOwnProperty.call(rawCLDR.misc_info.orientation, "characters")) {
                        throw new Error("CLDR data is missing orientation information");
                    }
                    if (!Object.prototype.hasOwnProperty.call(rawCLDR.misc_info, "delimiters")) {
                        throw new Error("CLDR data is missing delimiter information");
                    }
                }
                else {
                    throw new Error("CLDR data is missing misc_info");
                }
            }
            else {
                throw new Error("CLDR data cannot be null");
            }
            return validCLDR;
        }
        /**
         * Gets the locale associated with CLDR
         *
         * @returns {string} the locale associated with CLDR
         */
        getLocale() {
            return this.rawData.locale;
        }
        /**
         * Choose the correct string variation based on the number provided
         *
         * @example
         *      getPluralForm(2, "bottle", "bottles") // => ["bottles",0]
         *      getPluralForm(0) // => ['other',0]
         *
         * @param {Number} num number based on which the string variation is determined
         * @param {...string} stringVariations string variations
         * @returns {any[] | undefined } The plural form of the statement.
         */
        getPluralForm(num, ...stringVariations) {
            const fn = this.rawData.functions.get_plural_form;
            return fn(num, ...stringVariations);
        }
        /**
         * Gets the datetime information from the CLDR data. Includes date format presets and abbriviations
         *
         * @returns {Object} Date time information
         */
        getDateTimeInfo() {
            return this.rawData.datetime_info;
        }
        /**
         * Gets the CLDR formats from the CLDR data.
         * Provides locale specific list and decimal.
         *
         * @returns {Object} cldr formats
         */
        getFormats() {
            return this.rawData.misc_info.cldr_formats;
        }
        /**
         * Gets the locale specific delimites from the CLDR data.
         * Provides quotation marks for the locale
         *
         * @returns {Object} delimiters
         */
        getDelimiters() {
            return this.rawData.misc_info.delimiters;
        }
        /**
         * Checks if the locale is right to left oriented.
         *
         * @returns {boolean} orientation
         */
        isRtl() {
            return this.rawData.misc_info.orientation.characters === "right-to-left";
        }
        /**
         * Checks if the locale is left to right oriented.
         *
         * @returns {boolean} orientation
         */
        isLtr() {
            return this.rawData.misc_info.orientation.characters === "left-to-right";
        }
    }
    exports.CLDR = CLDR;

    });

    var quant_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.format_bytes = exports.numf = exports.quant = exports.numerate = void 0;

    /**
     * This returns the given noun form which is appropriate for the quantity according to this language's conventions.
     * numerate is used internally by quant to quantify nouns.
     *
     * @example
     *   numerate({cldr: cldr, args: [-1,"have one banana", "have many bananas", "owe you a banana"]}) // => owe you a banana
     *   numerate({cldr: cldr, args: [1,"have one banana", "have many bananas", "owe you a banana"]}) // => I have one banana
     *   numerate({cldr: cldr, args: [1,"have one banana", "have many bananas", "owe you a banana"]}) // => I have many bananas
     *
     * @param  {CLDR} cldr CLDR data
     * @param  {number} number quantity
     * @param  {string[]} rest Singular, Plural and Negative string
     * @return {string} formatted string
     */
    function numerate({ cldr: cldr$1, args: [num, ...rest], }) {
        if (!(cldr$1 instanceof cldr.CLDR)) {
            throw new Error("`numerate` function requires a valid CLDR instance for the `cldr` parameter.");
        }
        const pluralForms = cldr$1.getPluralForm(num, ...rest);
        const numerated = pluralForms ? pluralForms[0] : rest[rest.length - 1];
        return numerated;
    }
    exports.numerate = numerate;
    /**
     * Used for quantifying a noun.
     * Provides a variant of the string based on the absolute value of the number provided.
     *
     * @example
     *      quant({cldr: cldr, args:[10000, "test","tests"]}) // => "10,000 tests"
     *      quant({cldr: cldr, args:[0, "singular","plural", "nothing"]}) // => "nothing"
     *      quant({cldr: cldr, args:[[13.45789,2], "unit", "units"}) // => "13.46 units"
     * @param {CLDR} cldr cldr data
     * @param  {number|number[]} num Quantity on which the output depends.
     * @param  {string[]} rest singular, plural, zero string
     * @return {string} formatted string
     */
    function quant({ cldr: cldr$1, args: [num, ...rest], }) {
        if (!(cldr$1 instanceof cldr.CLDR)) {
            throw new Error("`quant` function requires a valid CLDR instance for the `cldr` parameter.");
        }
        let quantity, decimalPlaces = 3;
        if (num instanceof Array) {
            decimalPlaces = num[1];
            quantity = num[0];
        }
        else {
            quantity = num;
        }
        const pluralForms = cldr$1.getPluralForm(quantity, ...rest);
        // If there's a mismatch between the actual number of forms
        // (singular, plural, etc.) and the real number, this can be
        // undefined, which can break code.  We pick the rightmost, or
        // "most plural," form as a fallback.
        const numerated = pluralForms
            ? pluralForms[0]
            : rest[rest.length - 1];
        const isSpecialZero = pluralForms && pluralForms.length >= 2 ? pluralForms[1] : 0;
        if (isSpecialZero) {
            return numerated;
        }
        const formatted = numf({ cldr: cldr$1, args: [quantity, decimalPlaces] });
        if (numerated.indexOf("%s") !== -1) {
            return numerated.replace(/%s/g, formatted);
        }
        return cldr$1.isRtl()
            ? numerated + " " + formatted
            : formatted + " " + numerated;
    }
    exports.quant = quant;
    /**
     * Gets CLDR Decimal Format information
     *
     * @param {CLDR} cldr cldr information
     */
    function getCLDRDecimalFormatInfo(cldr) {
        const decimalFormatInfo = {};
        const formats = cldr.getFormats();
        if (Object.prototype.hasOwnProperty.call(formats, "decimal")) {
            decimalFormatInfo.decimalFormat = formats.decimal;
        }
        if (Object.prototype.hasOwnProperty.call(formats, "_decimal_format_group")) {
            decimalFormatInfo.decimalGroup = formats._decimal_format_group;
        }
        if (Object.prototype.hasOwnProperty.call(formats, "_decimal_format_decimal")) {
            decimalFormatInfo.decimalDecimal = formats._decimal_format_decimal;
        }
        return decimalFormatInfo;
    }
    /**
     * Returns the given number formatted nicely according to this language's conventions.
     * Does not localize exponential formats
     *  @example
     *      numf({cldr, args:[1000.0012,3]}) // => 1,000.001
     *      numf({cldr, args:[6.022e23]}) // => "6.022e+23"
     *
     * @param {CLDR} cldr CLDR data
     * @param {number} num number to be formatted
     * @param {number} [decimalPlaces=6] decimal places
     * @return {string} formatted string
     */
    function numf({ cldr: cldr$1, args: [num, decimalPlaces = 6], }) {
        if (!(cldr$1 instanceof cldr.CLDR)) {
            throw new Error("`numf` function requires a valid CLDR instance for the `cldr` parameter.");
        }
        // exponential -> don't know how to deal
        if (/e/.test(num.toString())) {
            return String(num);
        }
        const { decimalFormat, decimalGroup, decimalDecimal, } = getCLDRDecimalFormatInfo(cldr$1);
        if (!decimalFormat || !decimalGroup || !decimalDecimal) {
            throw new Error("CLDR Data is missing information related to formatting decimals.");
        }
        const isNegative = num < 0;
        num = Math.abs(num);
        // Trim the decimal part and round
        let whole = Math.floor(num);
        let fraction;
        if (/(?!')\.(?!')/.test(num.toString())) {
            // This weirdness is necessary to avoid floating-point
            // errors that can crop up with large-ish numbers.
            // Convert to a simple fraction.
            fraction = String(num).replace(/^[^.]+/, "0");
            // Now round to the desired precision.
            fraction = Number(fraction).toFixed(decimalPlaces);
            // e.g., 1.9999 when only 3 decimal places are desired.
            if (/^1/.test(fraction)) {
                whole++;
                num = whole;
                fraction = undefined;
            }
            else {
                // removes trailing 0's and returns fraction
                fraction = fraction.replace(/^.*\./, "").replace(/0+$/, "");
            }
        }
        let patternWithOutsideSymbols;
        // If language uses different formats for negative numbers than just adding "-" at the front,
        // you can put in two patterns, separated by a semicolon.
        // The first will be used for zero and positive values, while the second will be used for negative values.
        // http://cldr.unicode.org/translation/number-patterns
        if (/(?!');(?!')/.test(decimalFormat)) {
            patternWithOutsideSymbols = decimalFormat.split(/(?!');(?!')/)[isNegative ? 1 : 0];
        }
        else {
            patternWithOutsideSymbols = (isNegative ? "-" : "") + decimalFormat;
        }
        const innerPattern = patternWithOutsideSymbols.match(/[0#].*[0#]/)[0];
        // Applying the integer part of the pattern is much easier if it's
        // done with the strings reversed.
        const patternSplit = innerPattern.split(/(?!')\.(?!')/);
        const intPatternSplit = patternSplit[0]
            .split("")
            .reverse()
            .join("")
            .split(/(?!'),(?!')/);
        // If there is only one part of the int pattern, then set the "joiner"
        // to empty string. (http://unicode.org/cldr/trac/ticket/4094)
        let groupJoiner;
        if (intPatternSplit.length === 1) {
            groupJoiner = "";
        }
        else {
            // Most patterns look like #,##0.###, for which the leftmost # is
            // just a placeholder so we know where to put the group separator.
            intPatternSplit.pop();
            groupJoiner = decimalGroup;
        }
        const wholeReverse = String(whole).split("").reverse();
        const wholeAssembled = []; // reversed
        let pattern;
        const replacer = function (chr) {
            switch (chr) {
                case "#":
                    return wholeReverse.shift() || "";
                case "0":
                    return wholeReverse.shift() || "0";
            }
        };
        while (wholeReverse.length) {
            if (intPatternSplit.length) {
                pattern = intPatternSplit.shift();
            }
            // Since this is reversed, we can just replace a character
            // at a time, in regular forward order. Make sure we leave quoted
            // stuff alone while paying attention to stuff *by* quoted stuff.
            const assembleChunk = pattern
                .replace(/(?!')[0#]|[0#](?!')/g, replacer)
                .replace(/'([.,0#;¤%E])'$/, "")
                .replace(/'([.,0#;¤%E])'/, "$1");
            wholeAssembled.push(assembleChunk);
        }
        const formattedNumber = wholeAssembled.join(groupJoiner).split("").reverse().join("") +
            (fraction ? decimalDecimal + fraction : "");
        return patternWithOutsideSymbols.replace(/[0#].*[0#]/, formattedNumber);
    }
    exports.numf = numf;
    /**
     * Formats bytes with the specific decimal places.
     * This depends on locale-specific overrides of base functionality
     * but should not itself need an override.
     *
     * @example
     * format_bytes({cldr, args: [22]}) // => 22 bytes
     * format_bytes({cldr, args: [1045, 2]}) // => 1.02 KB
     *
     * @param {number} bytes
     * @param {number} [decimalPlaces] Number of decimal places. Defaults to 2.
     * @return {string}
     */
    function format_bytes({ cldr: cldr$1, args: [bytes, decimalPlaces = 2], }) {
        if (!(cldr$1 instanceof cldr.CLDR)) {
            throw new Error("`format_bytes` function requires a valid CLDR instance for the `cldr` parameter.");
        }
        // NOTE: There is no widely accepted consensus of exactly how to measure data
        // and which units to use for it. For example, some bodies define "B" to mean
        // bytes, while others don't. (NB: SI defines "B" to mean bels.) Some folks
        // use k for kilo; others use K. Some say kilo should be 1,024; others say
        // it's 1,000 (and "kibi" would be 1,024). What we do here is at least in
        // longstanding use at cPanel.
        const dataAbbreviations = [
            "KB",
            "MB",
            "GB",
            "TB",
            "PB",
            "EB",
            "ZB",
            "YB",
        ];
        const NBSP = "\u00a0";
        const exponent = bytes &&
            Math.min(Math.floor(Math.log(bytes) / Math.log(1024)), dataAbbreviations.length);
        if (!exponent) {
            return quant({ cldr: cldr$1, args: [bytes, "%s\u00a0byte", "%s\u00a0bytes"] }); // \u00a0 is a non breaking space
        }
        else {
            const quantity = bytes / Math.pow(1024, exponent);
            const formattedNumber = numf({
                cldr: cldr$1,
                args: [quantity, decimalPlaces],
            });
            return formattedNumber + NBSP + dataAbbreviations[exponent - 1];
        }
    }
    exports.format_bytes = format_bytes;

    });

    var datetime_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.local_datetime = exports.datetime = exports.dateToLocalDayNum = void 0;

    /**
     * Given a date object, this function returns the index needed for days-of-the-week
     * lookups in CLDR arrays. CLDR arrays start with Monday, not Sunday.
     *
     * @param  {Date} date   The date to look up.
     * @return {number}   The CLDR index corresponding to the date provided.
     */
    const getCldrDayIndex = function (date) {
        // getUTCDay() starts from Sunday, but CLDR starts from Monday.
        const num = date.getUTCDay() - 1;
        return num < 0 ? 6 : num;
    };
    /**
     * This is a simple map from the return value of date.getUTCDay() to the standard
     * CLDR day of the week.
     *
     * UTC day numbers of the week start with Sunday and range 0-6.
     * CLDR day numbers of the week start with Monday and range from 1-7:
     *
     *     Mon   Tue   Wed   Thu   Fri   Sat   Sun
     *      1     2     3     4     5     6     7
     */
    const utcToCldrMap = [7, 1, 2, 3, 4, 5, 6];
    /**
     * Given a date object and the first day of the locale's week, this function
     * will return the CLDR numerical day of the week for the date.
     *
     * When referring to days of the week, CLDR uses the numbers 1-7, with 1 being
     * the first day of the week and 7 being the last.
     *
     * @example
     *   const tuesdayDate = new Date('Tue Dec 19 1995 00:00:00 UTC');
     *
     *   // When Sunday is the first day of week => Sun, Mon, Tue (3)
     *   dateToLocalDayNum( tuesdayDate, 7 ) // => 3
     *
     *   // When Monday is the first day of week => Mon, Tue (2)
     *   dateToLocalDayNum( tuesdayDate, 1 ) // => 2
     *
     * @example
     *   const sundayDate = new Date('Sun Dec 17 1995 00:00:00 UTC');
     *
     *   // When Sunday is the first day of week => Sun (1)
     *   dateToLocalDayNum( sundayDate, 7 ) // => 1
     *
     *   // When Monday is the first day of week => Mon, Tue, Wed, Thu, Fri, Sat, Sun (7)
     *   dateToLocalDayNum( sundayDate, 1 ) // => 7
     *
     * @export
     * @param {Date}   targetDate       The date we want to process.
     * @param {number} firstDayOfWeek   The locale's first day of the week, in CLDR's 1-7 notation (Mon = 1, Sun = 7).
     * @returns {number} The numerical day of the week for the date, in CLDR notation (1-7).
     */
    function dateToLocalDayNum(targetDate, firstDayOfWeek) {
        // Convert the targetDate to the CLDR day number (1-7) to get it and firstDayOfWeek on the same scale.
        const targetDay = utcToCldrMap[targetDate.getUTCDay()];
        // Add a week to targetDay for simpler math. We normalize back down using the modulus.
        const offset = (targetDay + 7 - firstDayOfWeek) % 7;
        // We add 1 to the offset, because CLDR days of the week are numbered 1-7.
        return offset + 1;
    }
    exports.dateToLocalDayNum = dateToLocalDayNum;
    /**
     * Given a string, this function will ensure that it reaches the specified length
     * with the specified filler character.
     *
     * @param {string} originalString   String that needs padding
     * @param {number} len              Required length of string
     * @param {string} fillerChar       Filler character
     * @returns {string} padded string
     */
    const padStart = function (originalString, len, fillerChar) {
        let fill = "", toFill = 0;
        len = len || 0;
        fillerChar = String(fillerChar === undefined ? " " : fillerChar);
        toFill = len - String(originalString).length;
        if (toFill > 0) {
            fill = [...Array(toFill)]
                .map(String.prototype.valueOf, fillerChar)
                .join("");
        }
        return fill + originalString;
    };
    /**
     * The maketext datetime operator implementation. This function takes in a date or
     * unix timestamp (as an integer) along with an optional format string and returns
     * the given date and/or the current time in the format specified. If no format is
     * provided, the default long format date for the locale is used.
     *
     * The format string can use various presets or provide a custom string that uses
     * patterns for replacement. You can find a list of patterns at the following link,
     * though not all of them are implemented:
     *
     * https://unicode.org/reports/tr35/tr35-dates.html#Date_Field_Symbol_Table
     *
     * Note: All times are in UTC. If you need localized time, use the local_datetime
     * function instead.
     *
     * @example
     *   // Format the current date using the default date format
     *   datetime({ cldr, args: [] })
     *
     * @example
     *   // Format the given unix timestamp (December 1, 1995 00:00:00 UTC) using the datetime_format_short preset
     *   datetime({ cldr, args: [817776000, 'datetime_format_short'] })
     *
     * @example
     *   // Format the given Date instance (December 1, 1995 00:00:00 UTC) using a custom pattern
     *   datetime({ cldr, args: [new Date(817776000 * 1000), 'MM/dd - HH:mm'] }) // => 12/1 - 00:00
     *
     * @param {CLDR}        cldr                  The CLDR data to be used.
     * @param {any[]}       args                  The array of args for the function.
     * @param {Date|number} args.[date]           The date to be formatted. If using a number, it should be the unix timestamp in seconds.
     * @param {string}      args.[formatString=date_format_long]   The format preset or template to follow.
     * @param {string}      [tzString]            An optional time zone string, mainly used by local_datetime(). Defaults to 'UTC', since
     *                                            all of the underlying JS time/date functions used by this method are the UTC variants.
     * @returns {string}   The formatted datetime.
     */
    function datetime({ cldr: cldr$1, args: [date = new Date(), formatString], tzString = "UTC", }) {
        // Accept unix timestamps as well (integers only)
        if (typeof date === "number" && /^-?\d+$/.test(date.toString())) {
            date = new Date(date * 1000);
        }
        if (!(date instanceof Date)) {
            throw new Error("The datetime function only accepts Date instances or integer values (unix timestamps) for the `date` parameter.");
        }
        if (!(cldr$1 instanceof cldr.CLDR)) {
            throw new Error("The datetime function requires a valid CLDR instance for the `cldr` parameter.");
        }
        const dateTimeInfo = cldr$1.getDateTimeInfo();
        // Make sure we don't just grab any random CLDR datetime key.
        if (typeof formatString === "string" &&
            /^(?:date|time|datetime|special)_format_/.test(formatString)) {
            formatString = dateTimeInfo[formatString];
        }
        // Use the default format if one wasn't provided or the preset didn't exist.
        if (!formatString) {
            formatString = dateTimeInfo.date_format_long;
        }
        return formatString.replace(/('[^']+')|(([a-zA-Z])\3*)/g, 
        /**
         * A replacement function that will replace quoted strings and pattern strings in the formatString.
         * Each match will have either a quotedString or patternString defined.
         *
         * @param {string} substring       The substring of the main string that matched. Unused by this function.
         * @param {string} quotedString    The value of the first capture group. This capture group checks for
         *                                 strings enclosed in single quotes so they are passed through without
         *                                 transformation via pattern substitution.
         * @param {string} patternString   The value of the second capture group. This capture group checks for
         *                                 alphabetic characters for replacement patterns.
         * @returns {string}   The replacement string.
         */
        function (substring, quotedString, patternString) {
            if (quotedString) {
                return quoteSubstituter(quotedString);
            }
            else {
                return patternSubstituter(date, dateTimeInfo, patternString, tzString);
            }
        });
    }
    exports.datetime = datetime;
    /**
     * This function strips quotation marks and returns the contained string as-is.
     * It is meant for ensuring that text within the quotes are not tested for pattern
     * substitutions.
     *
     * @param {string} quotedString   The quoted string to be processed.
     * @returns {string}   The contained string.
     */
    function quoteSubstituter(quotedString) {
        return quotedString.substr(1, quotedString.length - 2);
    }
    /**
     * This function checks the matched patternString against all known patterns
     * and substitutes them for their datetime equivalents, following CLDR conventions.
     *
     * Pattern references:
     *   https://unicode.org/reports/tr35/tr35-dates.html#Date_Field_Symbol_Table
     *   https://metacpan.org/pod/DateTime#CLDR-Patterns
     *
     * @param {Date}   date           The date being processed.
     * @param {Object} dateTimeInfo   The dateTimeInfo from the locale's CLDR data.
     * @param {string} patternString  The pattern that has been matched.
     * @returns {string}   Substitution string
     */
    function patternSubstituter(date, dateTimeInfo, patternString, tzString) {
        switch (patternString) {
            case "yy":
                // 2 digit year
                return Math.abs(date.getUTCFullYear()).toString().slice(-2);
            case "y":
            case "yyy":
            case "yyyy":
                // Year
                return String(Math.abs(date.getUTCFullYear()));
            case "MMMMM":
                // Narrow month
                return dateTimeInfo.month_format_narrow[date.getUTCMonth()];
            case "LLLLL":
                // Narrow standalone month
                return dateTimeInfo.month_stand_alone_narrow[date.getUTCMonth()];
            case "MMMM":
                // Wide month
                return dateTimeInfo.month_format_wide[date.getUTCMonth()];
            case "LLLL":
                // Wide standalone month
                return dateTimeInfo.month_stand_alone_wide[date.getUTCMonth()];
            case "MMM":
                // Abbreviated month
                return dateTimeInfo.month_format_abbreviated[date.getUTCMonth()];
            case "LLL":
                // Abbreviated standalone month
                return dateTimeInfo.month_stand_alone_abbreviated[date.getUTCMonth()];
            case "MM":
            case "LL":
                // 2 digit, padded numeric month
                return padStart((date.getUTCMonth() + 1).toString(), 2, "0");
            case "M":
            case "L":
                // Unpadded numeric month
                return String(date.getUTCMonth() + 1);
            case "EEEE":
                // Wide day of the week
                return dateTimeInfo.day_format_wide[getCldrDayIndex(date)];
            case "EEE":
            case "EE":
            case "E":
                // Abbreviated day of the week
                return dateTimeInfo.day_format_abbreviated[getCldrDayIndex(date)];
            case "EEEEE":
                // Narrow day of the week
                return dateTimeInfo.day_format_narrow[getCldrDayIndex(date)];
            case "cccc":
                // Wide day of the week
                return dateTimeInfo.day_stand_alone_wide[getCldrDayIndex(date)];
            case "ccc":
                // Abbreviated day of the week
                return dateTimeInfo.day_stand_alone_abbreviated[getCldrDayIndex(date)];
            case "cc":
            case "c":
                // Numeric day of the week (1-7)
                return String(dateToLocalDayNum(date, Number(dateTimeInfo.first_day_of_week)));
            case "ccccc":
                // Narrow day of the week
                return dateTimeInfo.day_stand_alone_narrow[getCldrDayIndex(date)];
            case "dd":
                // 2 digit, padded numeric day of the month
                return padStart(date.getUTCDate().toString(), 2, "0");
            case "d":
                // Unpadded numeric day of the month
                return String(date.getUTCDate());
            case "h":
            case "hh": {
                // Padded and unpadded hours on the 12 hour clock
                let twelve_hours = date.getUTCHours();
                if (twelve_hours > 12) {
                    twelve_hours -= 12;
                }
                // The midnight hour is represented as 12:XX in 12 hour format
                if (twelve_hours === 0) {
                    twelve_hours = 12;
                }
                const result = patternString === "hh"
                    ? padStart(twelve_hours.toString(), 2, "0")
                    : twelve_hours;
                return String(result);
            }
            case "H":
                // Unpadded hours on the 24 hour clock
                return String(date.getUTCHours());
            case "HH":
                // 2 digit, padded hours on the 24 hour clock
                return padStart(date.getUTCHours().toString(), 2, "0");
            case "m":
                // Unpadded minutes
                return String(date.getUTCMinutes());
            case "mm":
                // 2 digit, padded minutes
                return padStart(date.getUTCMinutes().toString(), 2, "0");
            case "s":
                // Unpadded seconds
                return String(date.getUTCSeconds());
            case "ss":
                // 2 digit, padded seconds
                return padStart(date.getUTCSeconds().toString(), 2, "0");
            case "a": {
                // AM/PM
                const hours = date.getUTCHours();
                if (hours < 12) {
                    return dateTimeInfo.am_pm_abbreviated[0];
                }
                else if (hours > 12) {
                    return dateTimeInfo.am_pm_abbreviated[1];
                }
                // CLDR defines "noon", but CPAN DateTime::Locale doesn't have it, so we just use PM.
                return dateTimeInfo.am_pm_abbreviated[1];
            }
            case "z":
            case "zzzz":
            case "v":
            case "vvvv":
                // Time zone string. Defaults to UTC, unless you're coming through local_datetime.
                return tzString;
            case "G":
            case "GG":
            case "GGG":
                // Abbreviated era (AD/BC)
                return dateTimeInfo.era_abbreviated[date.getUTCFullYear() < 0 ? 0 : 1];
            case "GGGGG":
                // Narrow era
                return dateTimeInfo.era_narrow[date.getUTCFullYear() < 0 ? 0 : 1];
            case "GGGG":
                // Wide era
                return dateTimeInfo.era_wide[date.getUTCFullYear() < 0 ? 0 : 1];
        }
        return patternString;
    }
    /**
     * The maketext local_datetime operator implementation. This function mimics the
     * datetime operator, except that it also takes into account the local time zone.
     *
     * See datetime for more information on its usage.
     *
     * @example
     *   // Format the given Date instance using a custom pattern in the local time zone.
     *   // Fri Dec 1 1995 00:00:00 UTC => Thu Nov 30 1995 18:00:00 CST
     *   datetime({ cldr, args: [new Date(817776000 * 1000), 'MM/dd - HH:mm'] }) // => 11/30 - 18:00
     *
     * @param {CLDR}        cldr                  The CLDR data to be used.
     * @param {any[]}       args                  The array of args for the function.
     * @param {Date|number} args.[date]           The date to be formatted. If using a number, it should be the unix timestamp in seconds.
     * @param {string}      args.[formatString]   The format preset or template to follow.
     * @returns {string}   The formatted datetime in the local time zone.
     */
    function local_datetime({ cldr: cldr$1, args: [date = new Date(), formatString], }) {
        // Accept unix timestamps as well (integers only)
        if (typeof date === "number" && /^-?\d+$/.test(date.toString())) {
            date = new Date(date * 1000);
        }
        if (!(date instanceof Date)) {
            throw new Error("The datetime function only accepts Date instances or integer values (unix timestamps) for the `date` parameter.");
        }
        if (!(cldr$1 instanceof cldr.CLDR)) {
            throw new Error("The datetime function requires a valid CLDR instance for the `cldr` parameter.");
        }
        /**
         * Because all of the datetime substitutions rely on UTC time functions,
         * we need to manually adjust the base UTC time of the date object by the
         * local offset to get the final results in local time.
         *
         * (This has to happen on the passed-in object because of the tests’
         * use of spyOn().)
         */
        const tzOffset = date.getTimezoneOffset();
        // Now that we’ve grabbed the TZ offset, clone the date so that we
        // don’t affect the caller.
        date = new Date(date);
        date.setMinutes(date.getMinutes() - tzOffset);
        // Process the time zone string that datetime() will use in place of 'UTC'
        const offsetSign = tzOffset > 0 ? "-" : "+";
        const offsetHours = Math.floor(Math.abs(tzOffset) / 60);
        const offsetMinutes = Math.abs(tzOffset % 60);
        const tzString = "GMT" +
            offsetSign +
            padStart(offsetHours.toString(), 2, "0") +
            padStart(offsetMinutes.toString(), 2, "0");
        return datetime({
            cldr: cldr$1,
            args: [date, formatString],
            tzString,
        });
    }
    exports.local_datetime = local_datetime;

    });

    var list = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.list_or = exports.list_and = exports.list_or_quoted = exports.list_and_quoted = void 0;
    /**
     * Quote a string based on CLDR quoting rules
     *
     * @private
     * @param {CLDR} cldr cldr data
     * @param {string} str string to be quoted
     * @returns {string}
     */
    function _quote(cldr, str) {
        const delimiters = cldr.getDelimiters();
        if (delimiters &&
            Object.prototype.hasOwnProperty.call(delimiters, "quotation_start") &&
            Object.prototype.hasOwnProperty.call(delimiters, "quotation_end")) {
            return delimiters.quotation_start + str + delimiters.quotation_end;
        }
        return str;
    }
    /**
     * Helper to build a quoted list via the list_and or list_or functions.
     *
     * @param {CLDR} cldr
     * @param {string} joinFnName Name of the method used to join the elements of the args.
     * @param {...any} args List of arguments.
     * @returns {string}
     */
    function _list_quoted(cldr, joinFnName, ...args) {
        let list = args.slice();
        if (list.length === 1 && Array.isArray(list[0])) {
            list = list[0].slice();
        }
        // Emulate Locales.pm _quote_get_list_items() list_quote_mode 'all'.
        // list_or(), currently not implemented in JS (no reason for it not to be), will need to behave the same
        if (typeof list === "undefined" || list.length === 0) {
            list = [""];
        }
        list = list.map((el) => {
            return _quote(cldr, el);
        });
        switch (joinFnName) {
            case "list_and":
                return list_and({ cldr: cldr, args: list });
            case "list_or":
                return list_or({ cldr: cldr, args: list });
            default:
                throw new Error("Did you mean list_and_quoted or list_or_quoted?");
        }
    }
    /**
     * Quotes each value and then returns a localized “and”-list of them.
     *
     * @example
     *  list_and_quoted({cldr, args:["foo"]}) // => “foo”
     *  list_and_quoted({cldr, args:["foo", "bar"]}) // => “foo” and “bar”
     *  list_and_quoted({cldr, args:["foo", "bar", "baz"]}) // => “foo”, “bar”, and “baz”
     *
     * @param {string[]} list list of items to generated from.
     * @return {string} The localized list of quoted items.
     */
    function list_and_quoted({ cldr, args: [...list], }) {
        return _list_quoted(cldr, "list_and", ...list);
    }
    exports.list_and_quoted = list_and_quoted;
    /**
     * Quotes each value and then returns a localized “or”-list of them.
     *
     * @example
     *  list_or_quoted({cldr, args:["foo"]}) // => “foo”
     *  list_or_quoted({cldr, args:["foo", "bar"]}) // => “foo” or “bar”
     *  list_or_quoted({cldr, args:["foo", "bar", "baz"]}) // => “foo”, “bar”, or “baz”
     *
     * @param {string[]} list list of items to generated from.
     * @return {string} The localized list of quoted items.
     */
    function list_or_quoted({ cldr, args: [...list], }) {
        return _list_quoted(cldr, "list_or", ...list);
    }
    exports.list_or_quoted = list_or_quoted;
    /**
     * Joins list based on cldr rules
     *
     * @param {CLDR} cldr
     * @param {string} templateName
     * @param {...string} args
     *
     * @returns {string} Returned joined list
     */
    function _list_join_cldr(cldr, templateName, ...args) {
        let list = args.slice();
        if (list.length === 1 && Array.isArray(list[0])) {
            list = list[0].slice();
        }
        const len = list.length;
        let cldr_list, pattern, text, i;
        try {
            cldr_list = cldr.getFormats()[templateName];
        }
        catch (e) {
            throw new Error("CLDR Data is missing information related to formatting list.");
        }
        const replacer = function (str, p1) {
            switch (p1) {
                case "0":
                    return text;
                case "1":
                    return list[i++];
            }
        };
        switch (len) {
            case 0:
                return "";
            case 1:
                return String(list[0]);
            default:
                if (len === 2) {
                    text = cldr_list["2"];
                }
                else {
                    text = cldr_list.start;
                }
                text = text.replace(/\{([01])\}/g, function (all, bit) {
                    return list[bit];
                });
                if (len === 2) {
                    return text;
                }
                i = 2;
                while (i < len) {
                    pattern = cldr_list[i === len - 1 ? "end" : "middle"];
                    text = pattern.replace(/\{([01])\}/g, replacer);
                }
                return text;
        }
    }
    /**
     * Generates an and style string from the list.
     *
     * @example
     *  list_and({cldr, args:["foo"]}) // => "foo"
     *  list_and({cldr, args:["foo", "bar"]}) // => "foo and bar"
     *  list_and({cldr, arg:["foo", "bar", "baz"]}) // => "foo, bar, and baz"
     *
     * @param {CLDR} cldr
     * @param {string[]} list
     * @return {string} Generates an and style string from the list.
     */
    function list_and({ cldr, args: [...list], }) {
        return _list_join_cldr(cldr, "list", ...list);
    }
    exports.list_and = list_and;
    /**
     * Generates an or style string from the list.
     *
     * @example
     *  list_or({cldr, args:["foo"]}) // => "foo"
     *  list_or({cldr, args:["foo", "bar"]}) // => "foo or bar"
     *  list_or({cldr, arg:["foo", "bar", "baz"]}) // => "foo, bar, or baz"
     *
     * @param {CLDR} cldr
     * @param {string[]} list
     * @return {string} Generates an or style string from the list.
     */
    function list_or({ cldr, args: [...list], }) {
        return _list_join_cldr(cldr, "list_or", ...list);
    }
    exports.list_or = list_or;

    });

    var functions = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.functions = void 0;







    exports.functions = {
        asis: asis_1.asis,
        output: output_1.output,
        comment: comment_1.comment,
        boolean: boolean_1.boolean,
        numf: quant_1.numf,
        numerate: quant_1.numerate,
        quant: quant_1.quant,
        format_bytes: quant_1.format_bytes,
        datetime: datetime_1.datetime,
        local_datetime: datetime_1.local_datetime,
        list_and: list.list_and,
        list_or: list.list_or,
        list_or_quoted: list.list_or_quoted,
        list_and_quoted: list.list_and_quoted,
    };

    });

    var maketext_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.maketext = exports.functions = exports.config = void 0;

    const fauxComma = "\x07";
    exports.config = {
        // eslint-disable-next-line no-useless-escape -- ignore for regex
        bracketRe: /([^~\[\]]+|~.|\[|\]|~)/g,
        underscoreDigitRe: /^_(\d+)$/,
        // This character (the bell) will be used as a replacement for escaped
        // commas so we can split out the string of bracket args by commas.
        fauxComma: fauxComma,
        fauxCommaRe: new RegExp(fauxComma, "g"),
        // These are the only characters that will be escaped by a tilde outside
        // of a bracket group.
        tildeChars: new Set(["[", "]", "~"]),
    };
    exports.functions = {
        ...functions.functions,
    };
    /**
     * Generate a string using the template and the arguments in the current locale.
     *
     * @param {CLDR} cldr CLDR data
     * @param {Lexicon} lexicon   The set of translated strings to use in place of the ones used by the original template.
     * @param {string} template   The string template to process.
     * @param {any[]} params      The arguments to use during template processing.
     */
    function maketext({ cldr, lexicon, template, args: params, }) {
        if (typeof template !== "string") {
            throw "You must pass a string template to the maketext function.";
        }
        // Use the translated version of the template, if available.
        template = (lexicon && lexicon[template]) || template;
        // No bracket notation in the template, so there's no need to parse it.
        if (template.indexOf("[") === -1) {
            return template;
        }
        /**
         * Split the template string into chunks that are ready for parsing and
         * executing bracket notation, substituting variables, and heeding escape
         * characters.
         *
         * @example
         *   const template = 'Setting applied to [numf,_1] files.';
         *   // pieces => [ 'Setting applied to ', '[', 'numf,_1', ']', ' files.' ]
         *
         * @example
         *   const template = 'The files were [boolean,_1,found,lost~, corrupted~, or deleted].';
         *   // pieces => [ 'The files were ', '[', 'boolean,_1,found,lost', '~,', ' corrupted', '~,', 'or deleted', ']', '.' ]
         *
         *   // Note: This is a contrived example, and you should use list_or
         *   // instead of hard-coding the commas in the boolean bracket function.
         */
        const pieces = template.match(exports.config.bracketRe) || [];
        // The finalized string pieces that will be joined together to form the ultimate string.
        const processedStringPieces = [];
        let inBracketGroup = false;
        let bracketArgs = "";
        pieces.forEach((currentPiece) => {
            if (currentPiece === "[") {
                // This should be the start of a bracket group.
                if (inBracketGroup) {
                    throw Error(`Invalid maketext string: ${template} \nThe string contains nested brackets.`);
                }
                inBracketGroup = true;
            }
            else if (currentPiece === "]") {
                // This should be the end of a bracket group.
                if (!inBracketGroup) {
                    throw Error(`Invalid maketext string: ${template} \nThe string contains an unmatched closing bracket character (]).`);
                }
                if (!bracketArgs) {
                    throw Error(`Invalid maketext string: ${template} \nThe string contains empty brackets. Use the escape character (~) if the bracket characters were meant to be printed literally.`);
                }
                inBracketGroup = false;
                /**
                 * Since we're at the end of the bracket and have transformed any
                 * escaped characters, we will finally proceed with processing the
                 * bracket function.
                 */
                let processedBracket;
                try {
                    processedBracket = processBracket(cldr, bracketArgs, params);
                }
                catch (error) {
                    throw Error(`Invalid maketext string: ${template} \n${error}`);
                }
                bracketArgs = "";
                processedStringPieces.push(processedBracket);
            }
            else if (currentPiece.charAt(0) === "~") {
                // Tilde is our escape character.
                const realChar = currentPiece.charAt(1) || "~"; // The fallback handles tildes at the ends of strings.
                if (inBracketGroup) {
                    if (realChar === ",") {
                        // Commas are a special case because we will split the bracketArgs string by
                        // commas later. To avoid that conflict, we will use a stand-in character instead.
                        bracketArgs += exports.config.fauxComma;
                    }
                    else {
                        // All other escaped characters are inserted as-is.
                        bracketArgs += realChar;
                    }
                }
                else if (exports.config.tildeChars.has(realChar)) {
                    // We only escape certain characters outside of brackets.
                    processedStringPieces.push(realChar);
                }
                else {
                    processedStringPieces.push(currentPiece);
                }
            }
            else if (inBracketGroup) {
                bracketArgs += currentPiece;
            }
            else {
                processedStringPieces.push(currentPiece);
            }
        });
        if (inBracketGroup) {
            throw Error(`Invalid maketext string: ${template} \nThe string contains an unmatched opening bracket character ([).`);
        }
        return processedStringPieces.join("");
    }
    exports.maketext = maketext;
    /**
     * Executes the function or substitution expressed by the bracketString. This string can
     * be comma-delimited to use arguments, so any literal commas must be replaced by the
     * fuaxComma stand-in.
     *
     * @param {CLDR}   cldr            The CLDR data for the locale.
     * @param {string} bracketString   The contents of the bracket as a single string.
     * @param {any[]}  maketextArgs    The array of arguments that were passed to the maketext function. These values
                                       will be used for any substitions specified by the bracketString.
     * @returns {string}   The resulting string from executing the substitution or bracket function.
     */
    function processBracket(cldr, bracketString, maketextArgs) {
        let bracketArgs = bracketString.split(",");
        // Change our placeholders for escaped commas back to actual commas, now that we've performed our split.
        bracketArgs = bracketArgs.map((currentBracketArg) => currentBracketArg.replace(exports.config.fauxCommaRe, ","));
        // If there is only one item in the bracket, it must be a basic arg substitution.
        if (bracketArgs.length === 1) {
            if (!exports.config.underscoreDigitRe.test(bracketArgs[0])) {
                throw "A bracket must contain more than one argument, unless it is a pure substition.\n Example: Number of accounts: [_1]";
            }
            const [result] = substituteBracketArgs(bracketArgs, maketextArgs);
            return String(result);
        }
        // Otherwise, we are using a function, so get the function name first.
        const fnName = bracketArgs.shift();
        if (!fnName || typeof exports.functions[fnName] !== "function") {
            throw `Invalid function "${fnName}" in maketext string.`;
        }
        const finalBracketArgs = substituteBracketArgs(bracketArgs, maketextArgs);
        return exports.functions[fnName]({
            cldr,
            args: finalBracketArgs,
        });
    }
    /**
     * Takes an array of arguments to a bracket function and substitutes in any values
     * from the arguments that were passed to the maketext function for _N or _* bracket
     * arguments.
     *
     * Note: Bracket functions do not accept both _N and _* arguments for the same call.
     *
     * @param {string[]} bracketArgs    The arguments for the bracket function.
     * @param {any[]}    maketextArgs   The array of arguments that were passed to the maketext function.
     * @returns {any[]}   The same list of bracketArgs, with any variable substitutions performed.
     */
    function substituteBracketArgs(bracketArgs, maketextArgs) {
        const finalBracketArgs = [];
        let hasWildcardSubs = false;
        let hasNumericSubs = false;
        bracketArgs.forEach((currentBracketArg, currentBracketArgIndex) => {
            if (currentBracketArg.charAt(0) === "_") {
                if (currentBracketArg === "_*") {
                    if (hasNumericSubs) {
                        throw `You cannot combine wildcard substitution (_*) with a numeric substitution (e.g. _1) in the same bracket.`;
                    }
                    // _* takes all arguments and passes them straight through. The _* substitution will always be the last one.
                    finalBracketArgs.push(...maketextArgs);
                    hasWildcardSubs = true;
                }
                else {
                    // Try to match _1, _2, etc.
                    const match = currentBracketArg.match(exports.config.underscoreDigitRe);
                    if (match) {
                        if (hasWildcardSubs) {
                            throw `You cannot combine wildcard substitution (_*) with a numeric substitution (e.g. _1) in the same bracket.`;
                        }
                        const [substitionText, maketextArgNumber] = match;
                        const maketextArgIndex = Number(maketextArgNumber) - 1; // Maketext numeric substitutions are 1-based instead of 0-based.
                        // Check to make sure that the arg we want was actually passed.
                        if (maketextArgIndex in maketextArgs) {
                            // Sub out the values.
                            finalBracketArgs.push(maketextArgs[maketextArgIndex]);
                            hasNumericSubs = true;
                        }
                        else {
                            throw `The "${substitionText}" substitution argument was not passed to the maketext function.`;
                        }
                    }
                }
            }
            else {
                finalBracketArgs.push(currentBracketArg);
            }
        });
        return finalBracketArgs;
    }

    });

    var locale$B = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Locale = void 0;





    class Locale {
        /**
         * Create a new locale object based on some external environments.
         *
         * @param {RawCLDR}    rawCLDR locale specific CLDR functions and data
         * @param {Lexicon}    [lexicon]  Strings in the current locale for the application. Stored as a hash/object. Defaults to an empty hash/object.
         */
        constructor(rawCLDR, lexicon = {}) {
            this.lexicon = lexicon;
            this._cldr = new cldr.CLDR(rawCLDR);
        }
        /**
         * Generate a string using the template and the arguments in the current locale.
         *
         * @param {string} template maketext template
         * @param {any[]} params any additional arguments needed by maketext template
         * @returns {string} Generated string based on maketext template
         */
        maketext(template, ...params) {
            const localeData = {
                cldr: this._cldr,
                lexicon: this.lexicon,
                template: template,
                args: params,
            };
            return maketext_1.maketext(localeData);
        }
        /**
         * Localizes a date to the local timezone. Equivalent to (but cleaner than)
         * `maketext('[local_datetime,_1,my_fave_format]', date)`.
         *
         * @param {Date|number} [date=new Date()]            The date to be formatted. If using a number, it should be the unix timestamp in seconds.
         * @param {string}      [formatString=date_format_long]    The format preset (e.g., `datetime_format_medium`) or template to follow. Should be one of the string format options documented for Perl’s Locale::Maketext::Utils’s [datetime()](https://metacpan.org/dist/Locale-Maketext-Utils/view/lib/Locale/Maketext/Utils.pod#datetime%28%29) method.
         *
         * @returns {string} The localized date in the user’s timezone.
         */
        localDatetime(date, formatString) {
            return this._datetimeWrapper(datetime_1.local_datetime, date, formatString);
        }
        /**
         * **STOP!** Are you sure you don’t want `local_datetime`?
         *
         * Like `localDatetime()` but localizes a date to UTC rather than
         * the user’s timezone.
         *
         * If you use this function, be sure to tell the user that the
         * time displayed is UTC, not local time. Since most users will
         * expect local time, it’s generally better to use `local_datetime`
         * than to use this function. (Some users won’t know what UTC is!)
         *
         * @param {Date|number} [date=new Date()]            The date to be formatted. If using a number, it should be the unix timestamp in seconds.
         * @param {string}      [formatString=date_format_long]    The format preset (e.g., `datetime_format_medium`) or template to follow. See `localDatetime()` for more details.
         *
         * @returns {string} The localized date in UTC timezone.
         */
        datetime(date, formatString) {
            return this._datetimeWrapper(datetime_1.datetime, date, formatString);
        }
        _datetimeWrapper(datetimeFunc, date, formatString) {
            const localeData = {
                cldr: this._cldr,
                args: [date, formatString],
            };
            return datetimeFunc(localeData);
        }
        /**
         * Returns current locale
         *
         * @returns {string} Current locale
         */
        getCurrentLocale() {
            return this._cldr.getLocale();
        }
        /**
         * Returns true if the locale is right to left based. Returns false otherwise.
         */
        get isRtl() {
            return this._cldr.isRtl();
        }
        /**
         * Returns true if the locale is left to right based. Returns false otherwise.
         */
        get isLtr() {
            return this._cldr.isLtr();
        }
        /**
         * Returns the current cldr object for the locale.
         */
        get cldr() {
            return this._cldr;
        }
        /**
         * Returns the given number formatted nicely according to this language's conventions.
         * Does not localize exponential formats
         *  @example
         *      numf(1000.0012,3) // => 1,000.001
         *      numf(6.022e23) // => "6.022e+23"
         *
         * @param {number} num number to be formatted
         * @param {number} [decimalPlaces=6] decimal places
         * @return {string} formatted string
         */
        numf(num, decimalPlaces) {
            return this._formatNumber(quant_1.numf, num, decimalPlaces);
        }
        /**
         * Formats bytes with the specific decimal places.
         * This depends on locale-specific overrides of base functionality
         * but should not itself need an override.
         *
         * @example
         * format_bytes(22) // => 22 bytes
         * format_bytes(1045, 2) // => 1.02 KB
         *
         * @param {number} bytes
         * @param {number} [decimalPlaces] Number of decimal places. Defaults to 2.
         * @return {string}
         */
        format_bytes(num, decimalPlaces) {
            return this._formatNumber(quant_1.format_bytes, num, decimalPlaces);
        }
        _formatNumber(func, ...args) {
            return this._callCLDRFunc(func, args);
        }
        /**
         * Generates an and style string from the list.
         *
         * @example
         *  list_and("foo") // => "foo"
         *  list_and("foo", "bar") // => "foo and bar"
         *  list_and("foo", "bar", "baz") // => "foo, bar, and baz"
         *
         * @param {...string} list
         * @return {string} The localized output.
         */
        list_and(...args) {
            return this._callCLDRFunc(list.list_and, args);
        }
        /**
         * Like `list_and()` but quotes each list item.
         *
         * @param {...string} list
         * @return {string} The localized output.
         */
        list_and_quoted(...args) {
            return this._callCLDRFunc(list.list_and_quoted, args);
        }
        /**
         * Like `list_and()` but expresses an “or” instead of “and”.
         *
         * @param {...string} list
         * @return {string} The localized output.
         */
        list_or(...args) {
            return this._callCLDRFunc(list.list_or, args);
        }
        /**
         * Like `list_or()` but quotes each list item.
         *
         * @param {...string} list
         * @return {string} The localized output.
         */
        list_or_quoted(...args) {
            return this._callCLDRFunc(list.list_or_quoted, args);
        }
        _callCLDRFunc(func, args) {
            return func({
                cldr: this._cldr,
                args: args,
            });
        }
    }
    exports.Locale = Locale;

    });

    var dist = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Locale = void 0;

    Object.defineProperty(exports, "Locale", { enumerable: true, get: function () { return locale$B.Locale; } });

    });

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    let localeInstance;
    function getLocaleInstance() {
      if (typeof localeInstance !== "undefined") {
        return localeInstance;
      }
      const { LEXICON, CLDR } = window;
      if (!LEXICON || !CLDR) {
        throw new Error("The window object is missing keys required for localization!");
      }
      localeInstance = new dist.Locale(CLDR, LEXICON);
      return localeInstance;
    }
    /**
     * Ideally we might give the Locale object’s locale ID (e.g., `de`) to
     * .toLocaleLowerCase() in order to ensure parity between the browser’s
     * localization and our own. This is here so that, if we make that
     * change in the future, we’ll just have to update one place rather
     * than everywhere that we do this.
     */
    function toLocaleLowerCase(input) {
      return input.toLocaleLowerCase();
    }

    const cpConsentPrivacySettingsCss = ".container,.container-fluid,.container-xxl,.container-xl,.container-lg,.container-md,.container-sm{--cp-gutter-x:1.5rem;--cp-gutter-y:0;width:100%;padding-right:calc(var(--cp-gutter-x) * 0.5);padding-left:calc(var(--cp-gutter-x) * 0.5);margin-right:auto;margin-left:auto}@media (min-width: 576px){.container-sm,.container{max-width:540px}}@media (min-width: 768px){.container-md,.container-sm,.container{max-width:720px}}@media (min-width: 992px){.container-lg,.container-md,.container-sm,.container{max-width:960px}}@media (min-width: 1200px){.container-xl,.container-lg,.container-md,.container-sm,.container{max-width:1140px}}@media (min-width: 1400px){.container-xxl,.container-xl,.container-lg,.container-md,.container-sm,.container{max-width:1320px}}.row{--cp-gutter-x:1.5rem;--cp-gutter-y:0;display:flex;flex-wrap:wrap;margin-top:calc(-1 * var(--cp-gutter-y));margin-right:calc(-0.5 * var(--cp-gutter-x));margin-left:calc(-0.5 * var(--cp-gutter-x))}.row>*{flex-shrink:0;width:100%;max-width:100%;padding-right:calc(var(--cp-gutter-x) * 0.5);padding-left:calc(var(--cp-gutter-x) * 0.5);margin-top:var(--cp-gutter-y)}.col{flex:1 0 0%}.row-cols-auto>*{flex:0 0 auto;width:auto}.row-cols-1>*{flex:0 0 auto;width:100%}.row-cols-2>*{flex:0 0 auto;width:50%}.row-cols-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-4>*{flex:0 0 auto;width:25%}.row-cols-5>*{flex:0 0 auto;width:20%}.row-cols-6>*{flex:0 0 auto;width:16.6666666667%}.col-auto{flex:0 0 auto;width:auto}.col-1{flex:0 0 auto;width:8.33333333%}.col-2{flex:0 0 auto;width:16.66666667%}.col-3{flex:0 0 auto;width:25%}.col-4{flex:0 0 auto;width:33.33333333%}.col-5{flex:0 0 auto;width:41.66666667%}.col-6{flex:0 0 auto;width:50%}.col-7{flex:0 0 auto;width:58.33333333%}.col-8{flex:0 0 auto;width:66.66666667%}.col-9{flex:0 0 auto;width:75%}.col-10{flex:0 0 auto;width:83.33333333%}.col-11{flex:0 0 auto;width:91.66666667%}.col-12{flex:0 0 auto;width:100%}[dir=\"ltr\"] .offset-1{margin-left:8.33333333%}[dir=\"rtl\"] .offset-1{margin-right:8.33333333%}[dir=\"ltr\"] .offset-2{margin-left:16.66666667%}[dir=\"rtl\"] .offset-2{margin-right:16.66666667%}[dir=\"ltr\"] .offset-3{margin-left:25%}[dir=\"rtl\"] .offset-3{margin-right:25%}[dir=\"ltr\"] .offset-4{margin-left:33.33333333%}[dir=\"rtl\"] .offset-4{margin-right:33.33333333%}[dir=\"ltr\"] .offset-5{margin-left:41.66666667%}[dir=\"rtl\"] .offset-5{margin-right:41.66666667%}[dir=\"ltr\"] .offset-6{margin-left:50%}[dir=\"rtl\"] .offset-6{margin-right:50%}[dir=\"ltr\"] .offset-7{margin-left:58.33333333%}[dir=\"rtl\"] .offset-7{margin-right:58.33333333%}[dir=\"ltr\"] .offset-8{margin-left:66.66666667%}[dir=\"rtl\"] .offset-8{margin-right:66.66666667%}[dir=\"ltr\"] .offset-9{margin-left:75%}[dir=\"rtl\"] .offset-9{margin-right:75%}[dir=\"ltr\"] .offset-10{margin-left:83.33333333%}[dir=\"rtl\"] .offset-10{margin-right:83.33333333%}[dir=\"ltr\"] .offset-11{margin-left:91.66666667%}[dir=\"rtl\"] .offset-11{margin-right:91.66666667%}.g-0,.gx-0{--cp-gutter-x:0}.g-0,.gy-0{--cp-gutter-y:0}.g-1,.gx-1{--cp-gutter-x:0.25rem}.g-1,.gy-1{--cp-gutter-y:0.25rem}.g-2,.gx-2{--cp-gutter-x:0.5rem}.g-2,.gy-2{--cp-gutter-y:0.5rem}.g-3,.gx-3{--cp-gutter-x:0.75rem}.g-3,.gy-3{--cp-gutter-y:0.75rem}.g-4,.gx-4{--cp-gutter-x:1rem}.g-4,.gy-4{--cp-gutter-y:1rem}.g-5,.gx-5{--cp-gutter-x:1.25rem}.g-5,.gy-5{--cp-gutter-y:1.25rem}.g-6,.gx-6{--cp-gutter-x:1.5rem}.g-6,.gy-6{--cp-gutter-y:1.5rem}.g-7,.gx-7{--cp-gutter-x:1.75rem}.g-7,.gy-7{--cp-gutter-y:1.75rem}.g-8,.gx-8{--cp-gutter-x:2rem}.g-8,.gy-8{--cp-gutter-y:2rem}.g-9,.gx-9{--cp-gutter-x:2.5rem}.g-9,.gy-9{--cp-gutter-y:2.5rem}.g-10,.gx-10{--cp-gutter-x:3rem}.g-10,.gy-10{--cp-gutter-y:3rem}@media (min-width: 576px){.col-sm{flex:1 0 0%}.row-cols-sm-auto>*{flex:0 0 auto;width:auto}.row-cols-sm-1>*{flex:0 0 auto;width:100%}.row-cols-sm-2>*{flex:0 0 auto;width:50%}.row-cols-sm-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-sm-4>*{flex:0 0 auto;width:25%}.row-cols-sm-5>*{flex:0 0 auto;width:20%}.row-cols-sm-6>*{flex:0 0 auto;width:16.6666666667%}.col-sm-auto{flex:0 0 auto;width:auto}.col-sm-1{flex:0 0 auto;width:8.33333333%}.col-sm-2{flex:0 0 auto;width:16.66666667%}.col-sm-3{flex:0 0 auto;width:25%}.col-sm-4{flex:0 0 auto;width:33.33333333%}.col-sm-5{flex:0 0 auto;width:41.66666667%}.col-sm-6{flex:0 0 auto;width:50%}.col-sm-7{flex:0 0 auto;width:58.33333333%}.col-sm-8{flex:0 0 auto;width:66.66666667%}.col-sm-9{flex:0 0 auto;width:75%}.col-sm-10{flex:0 0 auto;width:83.33333333%}.col-sm-11{flex:0 0 auto;width:91.66666667%}.col-sm-12{flex:0 0 auto;width:100%}[dir=\"ltr\"] .offset-sm-0{margin-left:0}[dir=\"rtl\"] .offset-sm-0{margin-right:0}[dir=\"ltr\"] .offset-sm-1{margin-left:8.33333333%}[dir=\"rtl\"] .offset-sm-1{margin-right:8.33333333%}[dir=\"ltr\"] .offset-sm-2{margin-left:16.66666667%}[dir=\"rtl\"] .offset-sm-2{margin-right:16.66666667%}[dir=\"ltr\"] .offset-sm-3{margin-left:25%}[dir=\"rtl\"] .offset-sm-3{margin-right:25%}[dir=\"ltr\"] .offset-sm-4{margin-left:33.33333333%}[dir=\"rtl\"] .offset-sm-4{margin-right:33.33333333%}[dir=\"ltr\"] .offset-sm-5{margin-left:41.66666667%}[dir=\"rtl\"] .offset-sm-5{margin-right:41.66666667%}[dir=\"ltr\"] .offset-sm-6{margin-left:50%}[dir=\"rtl\"] .offset-sm-6{margin-right:50%}[dir=\"ltr\"] .offset-sm-7{margin-left:58.33333333%}[dir=\"rtl\"] .offset-sm-7{margin-right:58.33333333%}[dir=\"ltr\"] .offset-sm-8{margin-left:66.66666667%}[dir=\"rtl\"] .offset-sm-8{margin-right:66.66666667%}[dir=\"ltr\"] .offset-sm-9{margin-left:75%}[dir=\"rtl\"] .offset-sm-9{margin-right:75%}[dir=\"ltr\"] .offset-sm-10{margin-left:83.33333333%}[dir=\"rtl\"] .offset-sm-10{margin-right:83.33333333%}[dir=\"ltr\"] .offset-sm-11{margin-left:91.66666667%}[dir=\"rtl\"] .offset-sm-11{margin-right:91.66666667%}.g-sm-0,.gx-sm-0{--cp-gutter-x:0}.g-sm-0,.gy-sm-0{--cp-gutter-y:0}.g-sm-1,.gx-sm-1{--cp-gutter-x:0.25rem}.g-sm-1,.gy-sm-1{--cp-gutter-y:0.25rem}.g-sm-2,.gx-sm-2{--cp-gutter-x:0.5rem}.g-sm-2,.gy-sm-2{--cp-gutter-y:0.5rem}.g-sm-3,.gx-sm-3{--cp-gutter-x:0.75rem}.g-sm-3,.gy-sm-3{--cp-gutter-y:0.75rem}.g-sm-4,.gx-sm-4{--cp-gutter-x:1rem}.g-sm-4,.gy-sm-4{--cp-gutter-y:1rem}.g-sm-5,.gx-sm-5{--cp-gutter-x:1.25rem}.g-sm-5,.gy-sm-5{--cp-gutter-y:1.25rem}.g-sm-6,.gx-sm-6{--cp-gutter-x:1.5rem}.g-sm-6,.gy-sm-6{--cp-gutter-y:1.5rem}.g-sm-7,.gx-sm-7{--cp-gutter-x:1.75rem}.g-sm-7,.gy-sm-7{--cp-gutter-y:1.75rem}.g-sm-8,.gx-sm-8{--cp-gutter-x:2rem}.g-sm-8,.gy-sm-8{--cp-gutter-y:2rem}.g-sm-9,.gx-sm-9{--cp-gutter-x:2.5rem}.g-sm-9,.gy-sm-9{--cp-gutter-y:2.5rem}.g-sm-10,.gx-sm-10{--cp-gutter-x:3rem}.g-sm-10,.gy-sm-10{--cp-gutter-y:3rem}}@media (min-width: 768px){.col-md{flex:1 0 0%}.row-cols-md-auto>*{flex:0 0 auto;width:auto}.row-cols-md-1>*{flex:0 0 auto;width:100%}.row-cols-md-2>*{flex:0 0 auto;width:50%}.row-cols-md-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-md-4>*{flex:0 0 auto;width:25%}.row-cols-md-5>*{flex:0 0 auto;width:20%}.row-cols-md-6>*{flex:0 0 auto;width:16.6666666667%}.col-md-auto{flex:0 0 auto;width:auto}.col-md-1{flex:0 0 auto;width:8.33333333%}.col-md-2{flex:0 0 auto;width:16.66666667%}.col-md-3{flex:0 0 auto;width:25%}.col-md-4{flex:0 0 auto;width:33.33333333%}.col-md-5{flex:0 0 auto;width:41.66666667%}.col-md-6{flex:0 0 auto;width:50%}.col-md-7{flex:0 0 auto;width:58.33333333%}.col-md-8{flex:0 0 auto;width:66.66666667%}.col-md-9{flex:0 0 auto;width:75%}.col-md-10{flex:0 0 auto;width:83.33333333%}.col-md-11{flex:0 0 auto;width:91.66666667%}.col-md-12{flex:0 0 auto;width:100%}[dir=\"ltr\"] .offset-md-0{margin-left:0}[dir=\"rtl\"] .offset-md-0{margin-right:0}[dir=\"ltr\"] .offset-md-1{margin-left:8.33333333%}[dir=\"rtl\"] .offset-md-1{margin-right:8.33333333%}[dir=\"ltr\"] .offset-md-2{margin-left:16.66666667%}[dir=\"rtl\"] .offset-md-2{margin-right:16.66666667%}[dir=\"ltr\"] .offset-md-3{margin-left:25%}[dir=\"rtl\"] .offset-md-3{margin-right:25%}[dir=\"ltr\"] .offset-md-4{margin-left:33.33333333%}[dir=\"rtl\"] .offset-md-4{margin-right:33.33333333%}[dir=\"ltr\"] .offset-md-5{margin-left:41.66666667%}[dir=\"rtl\"] .offset-md-5{margin-right:41.66666667%}[dir=\"ltr\"] .offset-md-6{margin-left:50%}[dir=\"rtl\"] .offset-md-6{margin-right:50%}[dir=\"ltr\"] .offset-md-7{margin-left:58.33333333%}[dir=\"rtl\"] .offset-md-7{margin-right:58.33333333%}[dir=\"ltr\"] .offset-md-8{margin-left:66.66666667%}[dir=\"rtl\"] .offset-md-8{margin-right:66.66666667%}[dir=\"ltr\"] .offset-md-9{margin-left:75%}[dir=\"rtl\"] .offset-md-9{margin-right:75%}[dir=\"ltr\"] .offset-md-10{margin-left:83.33333333%}[dir=\"rtl\"] .offset-md-10{margin-right:83.33333333%}[dir=\"ltr\"] .offset-md-11{margin-left:91.66666667%}[dir=\"rtl\"] .offset-md-11{margin-right:91.66666667%}.g-md-0,.gx-md-0{--cp-gutter-x:0}.g-md-0,.gy-md-0{--cp-gutter-y:0}.g-md-1,.gx-md-1{--cp-gutter-x:0.25rem}.g-md-1,.gy-md-1{--cp-gutter-y:0.25rem}.g-md-2,.gx-md-2{--cp-gutter-x:0.5rem}.g-md-2,.gy-md-2{--cp-gutter-y:0.5rem}.g-md-3,.gx-md-3{--cp-gutter-x:0.75rem}.g-md-3,.gy-md-3{--cp-gutter-y:0.75rem}.g-md-4,.gx-md-4{--cp-gutter-x:1rem}.g-md-4,.gy-md-4{--cp-gutter-y:1rem}.g-md-5,.gx-md-5{--cp-gutter-x:1.25rem}.g-md-5,.gy-md-5{--cp-gutter-y:1.25rem}.g-md-6,.gx-md-6{--cp-gutter-x:1.5rem}.g-md-6,.gy-md-6{--cp-gutter-y:1.5rem}.g-md-7,.gx-md-7{--cp-gutter-x:1.75rem}.g-md-7,.gy-md-7{--cp-gutter-y:1.75rem}.g-md-8,.gx-md-8{--cp-gutter-x:2rem}.g-md-8,.gy-md-8{--cp-gutter-y:2rem}.g-md-9,.gx-md-9{--cp-gutter-x:2.5rem}.g-md-9,.gy-md-9{--cp-gutter-y:2.5rem}.g-md-10,.gx-md-10{--cp-gutter-x:3rem}.g-md-10,.gy-md-10{--cp-gutter-y:3rem}}@media (min-width: 992px){.col-lg{flex:1 0 0%}.row-cols-lg-auto>*{flex:0 0 auto;width:auto}.row-cols-lg-1>*{flex:0 0 auto;width:100%}.row-cols-lg-2>*{flex:0 0 auto;width:50%}.row-cols-lg-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-lg-4>*{flex:0 0 auto;width:25%}.row-cols-lg-5>*{flex:0 0 auto;width:20%}.row-cols-lg-6>*{flex:0 0 auto;width:16.6666666667%}.col-lg-auto{flex:0 0 auto;width:auto}.col-lg-1{flex:0 0 auto;width:8.33333333%}.col-lg-2{flex:0 0 auto;width:16.66666667%}.col-lg-3{flex:0 0 auto;width:25%}.col-lg-4{flex:0 0 auto;width:33.33333333%}.col-lg-5{flex:0 0 auto;width:41.66666667%}.col-lg-6{flex:0 0 auto;width:50%}.col-lg-7{flex:0 0 auto;width:58.33333333%}.col-lg-8{flex:0 0 auto;width:66.66666667%}.col-lg-9{flex:0 0 auto;width:75%}.col-lg-10{flex:0 0 auto;width:83.33333333%}.col-lg-11{flex:0 0 auto;width:91.66666667%}.col-lg-12{flex:0 0 auto;width:100%}[dir=\"ltr\"] .offset-lg-0{margin-left:0}[dir=\"rtl\"] .offset-lg-0{margin-right:0}[dir=\"ltr\"] .offset-lg-1{margin-left:8.33333333%}[dir=\"rtl\"] .offset-lg-1{margin-right:8.33333333%}[dir=\"ltr\"] .offset-lg-2{margin-left:16.66666667%}[dir=\"rtl\"] .offset-lg-2{margin-right:16.66666667%}[dir=\"ltr\"] .offset-lg-3{margin-left:25%}[dir=\"rtl\"] .offset-lg-3{margin-right:25%}[dir=\"ltr\"] .offset-lg-4{margin-left:33.33333333%}[dir=\"rtl\"] .offset-lg-4{margin-right:33.33333333%}[dir=\"ltr\"] .offset-lg-5{margin-left:41.66666667%}[dir=\"rtl\"] .offset-lg-5{margin-right:41.66666667%}[dir=\"ltr\"] .offset-lg-6{margin-left:50%}[dir=\"rtl\"] .offset-lg-6{margin-right:50%}[dir=\"ltr\"] .offset-lg-7{margin-left:58.33333333%}[dir=\"rtl\"] .offset-lg-7{margin-right:58.33333333%}[dir=\"ltr\"] .offset-lg-8{margin-left:66.66666667%}[dir=\"rtl\"] .offset-lg-8{margin-right:66.66666667%}[dir=\"ltr\"] .offset-lg-9{margin-left:75%}[dir=\"rtl\"] .offset-lg-9{margin-right:75%}[dir=\"ltr\"] .offset-lg-10{margin-left:83.33333333%}[dir=\"rtl\"] .offset-lg-10{margin-right:83.33333333%}[dir=\"ltr\"] .offset-lg-11{margin-left:91.66666667%}[dir=\"rtl\"] .offset-lg-11{margin-right:91.66666667%}.g-lg-0,.gx-lg-0{--cp-gutter-x:0}.g-lg-0,.gy-lg-0{--cp-gutter-y:0}.g-lg-1,.gx-lg-1{--cp-gutter-x:0.25rem}.g-lg-1,.gy-lg-1{--cp-gutter-y:0.25rem}.g-lg-2,.gx-lg-2{--cp-gutter-x:0.5rem}.g-lg-2,.gy-lg-2{--cp-gutter-y:0.5rem}.g-lg-3,.gx-lg-3{--cp-gutter-x:0.75rem}.g-lg-3,.gy-lg-3{--cp-gutter-y:0.75rem}.g-lg-4,.gx-lg-4{--cp-gutter-x:1rem}.g-lg-4,.gy-lg-4{--cp-gutter-y:1rem}.g-lg-5,.gx-lg-5{--cp-gutter-x:1.25rem}.g-lg-5,.gy-lg-5{--cp-gutter-y:1.25rem}.g-lg-6,.gx-lg-6{--cp-gutter-x:1.5rem}.g-lg-6,.gy-lg-6{--cp-gutter-y:1.5rem}.g-lg-7,.gx-lg-7{--cp-gutter-x:1.75rem}.g-lg-7,.gy-lg-7{--cp-gutter-y:1.75rem}.g-lg-8,.gx-lg-8{--cp-gutter-x:2rem}.g-lg-8,.gy-lg-8{--cp-gutter-y:2rem}.g-lg-9,.gx-lg-9{--cp-gutter-x:2.5rem}.g-lg-9,.gy-lg-9{--cp-gutter-y:2.5rem}.g-lg-10,.gx-lg-10{--cp-gutter-x:3rem}.g-lg-10,.gy-lg-10{--cp-gutter-y:3rem}}@media (min-width: 1200px){.col-xl{flex:1 0 0%}.row-cols-xl-auto>*{flex:0 0 auto;width:auto}.row-cols-xl-1>*{flex:0 0 auto;width:100%}.row-cols-xl-2>*{flex:0 0 auto;width:50%}.row-cols-xl-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-xl-4>*{flex:0 0 auto;width:25%}.row-cols-xl-5>*{flex:0 0 auto;width:20%}.row-cols-xl-6>*{flex:0 0 auto;width:16.6666666667%}.col-xl-auto{flex:0 0 auto;width:auto}.col-xl-1{flex:0 0 auto;width:8.33333333%}.col-xl-2{flex:0 0 auto;width:16.66666667%}.col-xl-3{flex:0 0 auto;width:25%}.col-xl-4{flex:0 0 auto;width:33.33333333%}.col-xl-5{flex:0 0 auto;width:41.66666667%}.col-xl-6{flex:0 0 auto;width:50%}.col-xl-7{flex:0 0 auto;width:58.33333333%}.col-xl-8{flex:0 0 auto;width:66.66666667%}.col-xl-9{flex:0 0 auto;width:75%}.col-xl-10{flex:0 0 auto;width:83.33333333%}.col-xl-11{flex:0 0 auto;width:91.66666667%}.col-xl-12{flex:0 0 auto;width:100%}[dir=\"ltr\"] .offset-xl-0{margin-left:0}[dir=\"rtl\"] .offset-xl-0{margin-right:0}[dir=\"ltr\"] .offset-xl-1{margin-left:8.33333333%}[dir=\"rtl\"] .offset-xl-1{margin-right:8.33333333%}[dir=\"ltr\"] .offset-xl-2{margin-left:16.66666667%}[dir=\"rtl\"] .offset-xl-2{margin-right:16.66666667%}[dir=\"ltr\"] .offset-xl-3{margin-left:25%}[dir=\"rtl\"] .offset-xl-3{margin-right:25%}[dir=\"ltr\"] .offset-xl-4{margin-left:33.33333333%}[dir=\"rtl\"] .offset-xl-4{margin-right:33.33333333%}[dir=\"ltr\"] .offset-xl-5{margin-left:41.66666667%}[dir=\"rtl\"] .offset-xl-5{margin-right:41.66666667%}[dir=\"ltr\"] .offset-xl-6{margin-left:50%}[dir=\"rtl\"] .offset-xl-6{margin-right:50%}[dir=\"ltr\"] .offset-xl-7{margin-left:58.33333333%}[dir=\"rtl\"] .offset-xl-7{margin-right:58.33333333%}[dir=\"ltr\"] .offset-xl-8{margin-left:66.66666667%}[dir=\"rtl\"] .offset-xl-8{margin-right:66.66666667%}[dir=\"ltr\"] .offset-xl-9{margin-left:75%}[dir=\"rtl\"] .offset-xl-9{margin-right:75%}[dir=\"ltr\"] .offset-xl-10{margin-left:83.33333333%}[dir=\"rtl\"] .offset-xl-10{margin-right:83.33333333%}[dir=\"ltr\"] .offset-xl-11{margin-left:91.66666667%}[dir=\"rtl\"] .offset-xl-11{margin-right:91.66666667%}.g-xl-0,.gx-xl-0{--cp-gutter-x:0}.g-xl-0,.gy-xl-0{--cp-gutter-y:0}.g-xl-1,.gx-xl-1{--cp-gutter-x:0.25rem}.g-xl-1,.gy-xl-1{--cp-gutter-y:0.25rem}.g-xl-2,.gx-xl-2{--cp-gutter-x:0.5rem}.g-xl-2,.gy-xl-2{--cp-gutter-y:0.5rem}.g-xl-3,.gx-xl-3{--cp-gutter-x:0.75rem}.g-xl-3,.gy-xl-3{--cp-gutter-y:0.75rem}.g-xl-4,.gx-xl-4{--cp-gutter-x:1rem}.g-xl-4,.gy-xl-4{--cp-gutter-y:1rem}.g-xl-5,.gx-xl-5{--cp-gutter-x:1.25rem}.g-xl-5,.gy-xl-5{--cp-gutter-y:1.25rem}.g-xl-6,.gx-xl-6{--cp-gutter-x:1.5rem}.g-xl-6,.gy-xl-6{--cp-gutter-y:1.5rem}.g-xl-7,.gx-xl-7{--cp-gutter-x:1.75rem}.g-xl-7,.gy-xl-7{--cp-gutter-y:1.75rem}.g-xl-8,.gx-xl-8{--cp-gutter-x:2rem}.g-xl-8,.gy-xl-8{--cp-gutter-y:2rem}.g-xl-9,.gx-xl-9{--cp-gutter-x:2.5rem}.g-xl-9,.gy-xl-9{--cp-gutter-y:2.5rem}.g-xl-10,.gx-xl-10{--cp-gutter-x:3rem}.g-xl-10,.gy-xl-10{--cp-gutter-y:3rem}}@media (min-width: 1400px){.col-xxl{flex:1 0 0%}.row-cols-xxl-auto>*{flex:0 0 auto;width:auto}.row-cols-xxl-1>*{flex:0 0 auto;width:100%}.row-cols-xxl-2>*{flex:0 0 auto;width:50%}.row-cols-xxl-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-xxl-4>*{flex:0 0 auto;width:25%}.row-cols-xxl-5>*{flex:0 0 auto;width:20%}.row-cols-xxl-6>*{flex:0 0 auto;width:16.6666666667%}.col-xxl-auto{flex:0 0 auto;width:auto}.col-xxl-1{flex:0 0 auto;width:8.33333333%}.col-xxl-2{flex:0 0 auto;width:16.66666667%}.col-xxl-3{flex:0 0 auto;width:25%}.col-xxl-4{flex:0 0 auto;width:33.33333333%}.col-xxl-5{flex:0 0 auto;width:41.66666667%}.col-xxl-6{flex:0 0 auto;width:50%}.col-xxl-7{flex:0 0 auto;width:58.33333333%}.col-xxl-8{flex:0 0 auto;width:66.66666667%}.col-xxl-9{flex:0 0 auto;width:75%}.col-xxl-10{flex:0 0 auto;width:83.33333333%}.col-xxl-11{flex:0 0 auto;width:91.66666667%}.col-xxl-12{flex:0 0 auto;width:100%}[dir=\"ltr\"] .offset-xxl-0{margin-left:0}[dir=\"rtl\"] .offset-xxl-0{margin-right:0}[dir=\"ltr\"] .offset-xxl-1{margin-left:8.33333333%}[dir=\"rtl\"] .offset-xxl-1{margin-right:8.33333333%}[dir=\"ltr\"] .offset-xxl-2{margin-left:16.66666667%}[dir=\"rtl\"] .offset-xxl-2{margin-right:16.66666667%}[dir=\"ltr\"] .offset-xxl-3{margin-left:25%}[dir=\"rtl\"] .offset-xxl-3{margin-right:25%}[dir=\"ltr\"] .offset-xxl-4{margin-left:33.33333333%}[dir=\"rtl\"] .offset-xxl-4{margin-right:33.33333333%}[dir=\"ltr\"] .offset-xxl-5{margin-left:41.66666667%}[dir=\"rtl\"] .offset-xxl-5{margin-right:41.66666667%}[dir=\"ltr\"] .offset-xxl-6{margin-left:50%}[dir=\"rtl\"] .offset-xxl-6{margin-right:50%}[dir=\"ltr\"] .offset-xxl-7{margin-left:58.33333333%}[dir=\"rtl\"] .offset-xxl-7{margin-right:58.33333333%}[dir=\"ltr\"] .offset-xxl-8{margin-left:66.66666667%}[dir=\"rtl\"] .offset-xxl-8{margin-right:66.66666667%}[dir=\"ltr\"] .offset-xxl-9{margin-left:75%}[dir=\"rtl\"] .offset-xxl-9{margin-right:75%}[dir=\"ltr\"] .offset-xxl-10{margin-left:83.33333333%}[dir=\"rtl\"] .offset-xxl-10{margin-right:83.33333333%}[dir=\"ltr\"] .offset-xxl-11{margin-left:91.66666667%}[dir=\"rtl\"] .offset-xxl-11{margin-right:91.66666667%}.g-xxl-0,.gx-xxl-0{--cp-gutter-x:0}.g-xxl-0,.gy-xxl-0{--cp-gutter-y:0}.g-xxl-1,.gx-xxl-1{--cp-gutter-x:0.25rem}.g-xxl-1,.gy-xxl-1{--cp-gutter-y:0.25rem}.g-xxl-2,.gx-xxl-2{--cp-gutter-x:0.5rem}.g-xxl-2,.gy-xxl-2{--cp-gutter-y:0.5rem}.g-xxl-3,.gx-xxl-3{--cp-gutter-x:0.75rem}.g-xxl-3,.gy-xxl-3{--cp-gutter-y:0.75rem}.g-xxl-4,.gx-xxl-4{--cp-gutter-x:1rem}.g-xxl-4,.gy-xxl-4{--cp-gutter-y:1rem}.g-xxl-5,.gx-xxl-5{--cp-gutter-x:1.25rem}.g-xxl-5,.gy-xxl-5{--cp-gutter-y:1.25rem}.g-xxl-6,.gx-xxl-6{--cp-gutter-x:1.5rem}.g-xxl-6,.gy-xxl-6{--cp-gutter-y:1.5rem}.g-xxl-7,.gx-xxl-7{--cp-gutter-x:1.75rem}.g-xxl-7,.gy-xxl-7{--cp-gutter-y:1.75rem}.g-xxl-8,.gx-xxl-8{--cp-gutter-x:2rem}.g-xxl-8,.gy-xxl-8{--cp-gutter-y:2rem}.g-xxl-9,.gx-xxl-9{--cp-gutter-x:2.5rem}.g-xxl-9,.gy-xxl-9{--cp-gutter-y:2.5rem}.g-xxl-10,.gx-xxl-10{--cp-gutter-x:3rem}.g-xxl-10,.gy-xxl-10{--cp-gutter-y:3rem}}.external-link::after{font-family:remixicon;content:\" \\ecaf\"}:host{display:block}.cp-consent-privacy__container-text{margin-bottom:var(--cp-spacer-4);padding:0 var(--cp-spacer-3)}.cp-consent-privacy__container{padding:0 var(--cp-spacer-3)}[dir=\"ltr\"] .form-input-checkbox{margin-right:var(--cp-spacer-1)}[dir=\"rtl\"] .form-input-checkbox{margin-left:var(--cp-spacer-1)}.form-input-select{margin-top:var(--cp-spacer-2);margin-bottom:var(--cp-spacer-2);padding:var(--cp-spacer-1);border-radius:var(--cp-spacer-1);display:block}";

    const locale$A = getLocaleInstance();
    const CpConsentPrivacySettings$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.consentValueChanged = createEvent(this, "consentValueChanged", 7);
        this.personhoodValueChanged = createEvent(this, "personhoodValueChanged", 7);
      }
      /**
       * Handles checkbox change event.
       */
      captureCheckedState(event) {
        const el = event.target;
        this.consentValueChanged.emit(el.checked);
      }
      /**
       * Handles personhood dropdown change event.
       */
      handlePersonhoodChange(event) {
        const el = event.target;
        this.personhoodValueChanged.emit(el.value);
      }
      componentDidLoad() {
        if (this.personhoodSelectInput) {
          this.personhoodSelectInput.value = this.personhoodSetting || "individual";
        }
        if (this.consentCheckboxInput) {
          this.consentCheckboxInput.checked = this.analyticsConsent === "on" ? true : false;
        }
      }
      render() {
        return (h("div", { class: "cp-consent-privacy__container" }, h("div", { class: "row" }, h("div", { class: "col-xs-12 cp-consent-privacy__container-text", innerHTML: locale$A.maketext("WebPros International, LLC d.b.a cPanel is asking for your consent to participate in user activity tracking using third-party software for the purpose of understanding the performance of Webpros products. Information will be used pursuant to the [output,url,_1,cPanel and WHM Privacy Policy,title,cPanel and WHM Privacy Policy,data-testid,_2,target,_3,class,_4] and may be shared internally within the Webpros group. You can update your preferences at any time from the analytics slideout.", "https://go.cpanel.net/privacy", "privacy-policy", "privacy-policy", "external-link") }), h("div", { class: "col-xs-12 cp-consent-privacy__container-text" }, h("label", { htmlFor: "personhood-setting", innerHTML: locale$A.maketext("Select which account type best describes how you will use this product.") }), h("select", { name: "personhood_setting", id: "personhood-setting", class: "form-input-select", "data-testid": "ddlPersonhoodSettings", onChange: e => this.handlePersonhoodChange(e), ref: input => {
            this.personhoodSelectInput = input;
          } }, h("option", { value: "individual" }, locale$A.maketext("This account is for an individual.")), h("option", { value: "business" }, locale$A.maketext("This account is for a business.")))), h("div", { class: "col-xs-12" }, h("div", { class: "checkbox" }, h("label", null, h("input", { type: "checkbox", name: "consent_setting", id: "consent-setting", class: "form-input-checkbox", "data-testid": "chkConsentSetting", onChange: e => this.captureCheckedState(e), ref: input => {
            this.consentCheckboxInput = input;
          } }), h("span", { innerHTML: locale$A.maketext("By checking this box, you agree that we may collect your usage statistics. [output,url,_1,Learn more here.,title,cPanel Analytics Documentation,class,_2,target,_3,id,_4,data-testid,_5]", "https://go.cpanel.net/analytics", "external-link", "analytics", "learnLink", "learnAnalyticsLink") })))))));
      }
      static get style() { return cpConsentPrivacySettingsCss; }
    };

    const CpDir$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
      }
      /**
       * Stencil lifecycle component.
       */
      componentWillLoad() {
        this.documentDirection = document.dir;
        this.documentLanguage = document.documentElement.lang;
      }
      render() {
        return (h(Host, null, h("span", { dir: this.documentDirection, lang: this.documentLanguage }, h("slot", null))));
      }
    };

    const cpDnsOnlyCss = ":host{display:block}.dns-only__text{color:inherit;font-size:0.875rem;font-style:italic;font-weight:700}[dir=\"ltr\"] .dns-only__text{margin-right:var(--cp-spacer-2)}[dir=\"rtl\"] .dns-only__text{margin-left:var(--cp-spacer-2)}";

    const CpDnsOnly$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
      }
      render() {
        return (h(Host, null, h("small", { class: "dns-only__text" }, "DNSOnly\u00AE")));
      }
      static get style() { return cpDnsOnlyCss; }
    };

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    class CpToolIdentifier {
      /**
       * Constructor for the CpToolIdentifer.
       *
       * @param group The category for the tool.
       * @param key The application key for the tool.
       */
      constructor(group, key) {
        this.group = group;
        this.key = key;
      }
      /**
       * Build a string representation fo the unique id.
       *
       * @returns The unique key for the tool.
       */
      toString() {
        return this.group + "$" + this.key;
      }
    }

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    var IconMode;
    (function (IconMode) {
      IconMode[IconMode["Inline"] = 0] = "Inline";
      IconMode[IconMode["Centered"] = 1] = "Centered";
    })(IconMode || (IconMode = {}));

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    var IconSize;
    (function (IconSize) {
      IconSize["inherit"] = "";
      IconSize["xs"] = "ri-xs";
      IconSize["sm"] = "ri-sm";
      IconSize["lg"] = "ri-lg";
      IconSize["xl"] = "ri-xl";
    })(IconSize || (IconSize = {}));

    const cpFavoriteCss = ":host{display:block}.cp-app__compressed{align-items:center}.cp-app__compressed .cp-app__details-title{margin-bottom:0}.card{height:100%}.move{cursor:move}.remove-button{cursor:default}[dir=\"ltr\"] .remove-button{margin-left:auto}[dir=\"rtl\"] .remove-button{margin-right:auto}@media (max-width: 992px){.mobile-card-link{width:100%}}";

    const CpFavorite$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.removeFavorite = createEvent(this, "removeFavorite", 7);
        /**
         * When true show the edit controls, otherwise, hide the edit controls.
         */
        this.editMode = false;
        /**
         * Close button title.
         */
        this.removeDescription = "Remove";
        /**
         * The optional target window. Defaults to `_self`.
         */
        this.target = "_self";
        /**
         * The optional description of the tool.
         */
        this.description = "";
        /**
         * When true, the description will show, when false, the description will be hidden.
         */
        this.showDescription = true;
      }
      /**
       * Raise the remove event to the parent application so they can remove the item from the list.
       *
       * @param id - the unique identifier for the selected element.
       */
      removeHandler(id) {
        this.removeFavorite.emit(id);
      }
      /**
       * Set the edit mode for the control.
       *
       * @param mode - The mode, true when editing is enabled, false otherwise.
       */
      async setEditMode(mode) {
        this.editMode = mode;
      }
      render() {
        return (h(Host, null, h("div", { class: "card card-raised" }, h("a", { class: {
            "mobile-card-link": true,
            "move": this.editMode,
          }, href: !this.editMode ? this.url : "javascript:void(0)", target: !this.editMode ? this.target : "_self" }, h("div", { class: `cp-card cp-app ${!this.showDescription ? "cp-app__compressed" : ""}` }, h("img", { src: this.icon, alt: "", class: "cp-card__image-top-tools" }), h("div", { class: "cp-app__details" }, h("span", { class: "cp-app__details-title" }, this.displayName, h("button", { onClick: () => this.removeHandler(new CpToolIdentifier(this.group, this.name)), class: "close remove-button " + (this.editMode ? "" : "hidden") }, h("cp-icon", { name: "close-line", mode: IconMode.Centered, size: IconSize.lg }))), this.showDescription ? (h("span", { class: "cp-app__details-description" }, this.description)) : ("")))))));
      }
      static get style() { return cpFavoriteCss; }
    };

    const cpFavoriteListCss = ":host{display:block}";

    const CpFavoriteList$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.favoritesLoaded = createEvent(this, "favoritesLoaded", 7);
        /**
         * The list of favorites to show in the list.
         */
        this.favorites = [];
      }
      /**
       * Update the options when in edit mode.
       */
      async updateOptions(options) {
        this.showDescriptions = options.showDescriptions;
      }
      componentDidLoad() {
        this.favoritesLoaded.emit();
      }
      componentDidUpdate() {
        this.favoritesLoaded.emit();
      }
      render() {
        return (h(Host, { class: "card-list" }, this.favorites.map(favorite => (h("cp-favorite", { group: favorite.group, name: favorite.key, url: favorite.url, target: favorite.target || "_self", icon: favorite.iconUrl, displayName: favorite.name, description: favorite.description, showDescription: this.showDescriptions })))));
      }
      static get style() { return cpFavoriteListCss; }
    };

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    class CpToolSelect extends CpToolIdentifier {
      /**
       * Constructor for the CpToolSelect.
       *
       * @param group The category for the tool.
       * @param key The application key for the tool.
       * @param selected true if the tool is selected, false otherwise.
       */
      constructor(group, key, selected) {
        super(group, key);
        this.selected = selected;
      }
    }

    const cpFavoriteSelectorCss = ":host{display:inline-block;width:1rem;height:1rem}.hidden{display:none}.cp-favorite-selector--selected svg{fill:#de5c2e}.cp-favorite-selector--unselected svg{fill:#de5c2e}";

    const CpFavoriteSelector$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.changeFavorite = createEvent(this, "changeFavorite", 7);
        /**
         * Whether the favorite is selected or not.
         */
        this.checked = false;
        /**
         * When true show the edit controls, otherwise, hide the edit controls.
         */
        this.showEditControls = false;
      }
      /**
       * Set the edit mode for the control.
       *
       * @param mode - The mode, true when editing is enabled, false otherwise.
       */
      async setEditMode(mode) {
        this.showEditControls = mode;
      }
      /**
       * Event handler for the click event
       *
       * @param e
       */
      handleClick() {
        this.checked = !this.checked;
        this.changeFavorite.emit(new CpToolSelect(this.group, this.name, this.checked));
      }
      /**
       * Getter/setter for the current selected state.
       *
       * @param checked - If defined, allows you to set the selected state of the element.
       * @returns The current value of the checked state for the component.
       */
      async selected(checked) {
        if (checked === true || checked === false) {
          this.checked = checked;
        }
        return this.checked;
      }
      /**
       * Get the unique id set on the item.
       *
       * @returns The unique id use to coorelate the control to one of the applications.
       */
      async uniqueId() {
        return new CpToolIdentifier(this.group, this.name);
      }
      // cp-favorite-selector--selected: remixicon.com ri-star-solid
      // cp-favorite-selector--unselected: remixicon.com ri-star-line
      render() {
        return (h(Host, null, h("label", { class: this.showEditControls ? "" : "hidden" }, h("i", { class: "cp-favorite-selector--selected" + (this.checked ? "" : " hidden") }, h("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", width: "24", height: "24" }, h("path", { fill: "none", d: "M0 0h24v24H0z" }), h("path", { d: "M12 18.26l-7.053 3.948 1.575-7.928L.587 8.792l8.027-.952L12 .5l3.386 7.34 8.027.952-5.935 5.488 1.575 7.928z" }))), h("i", { class: "cp-favorite-selector--unselected" + (!this.checked ? "" : " hidden") }, h("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", width: "24", height: "24" }, h("path", { fill: "none", d: "M0 0h24v24H0z" }), h("path", { d: "M12 18.26l-7.053 3.948 1.575-7.928L.587 8.792l8.027-.952L12 .5l3.386 7.34 8.027.952-5.935 5.488 1.575 7.928L12 18.26zm0-2.292l4.247 2.377-.949-4.773 3.573-3.305-4.833-.573L12 5.275l-2.038 4.42-4.833.572 3.573 3.305-.949 4.773L12 15.968z" }))))));
      }
      static get style() { return cpFavoriteSelectorCss; }
    };

    // MIT License
    //
    // Copyright 2021 cPanel L.L.C.
    //
    // Permission is hereby granted, free of charge, to any person obtaining a copy
    //  of this software and associated documentation files (the "Software"), to deal
    // in the Software without restriction, including without limitation the
    // rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
    // sell copies of the Software, and to permit persons to whom the Software is
    // furnished to do so, subject to the following conditions:
    //
    // The above copyright notice and this permission notice shall be included in
    // all copies or substantial portions of the Software.
    //
    // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    // IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    // FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    // AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    // LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    // FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    // DEALINGS IN THE SOFTWARE.
    /**
     * Common http verbs
     */
    var HttpVerb;
    (function (HttpVerb) {
        /**
         * Get request
         */
        HttpVerb[HttpVerb["GET"] = 0] = "GET";
        /**
         * Head request
         */
        HttpVerb[HttpVerb["HEAD"] = 1] = "HEAD";
        /**
         * Post request
         */
        HttpVerb[HttpVerb["POST"] = 2] = "POST";
        /**
         * Put request
         */
        HttpVerb[HttpVerb["PUT"] = 3] = "PUT";
        /**
         * Delete request
         */
        HttpVerb[HttpVerb["DELETE"] = 4] = "DELETE";
        /**
         * Connect request
         */
        HttpVerb[HttpVerb["CONNECT"] = 5] = "CONNECT";
        /**
         * Options request
         */
        HttpVerb[HttpVerb["OPTIONS"] = 6] = "OPTIONS";
        /**
         * Trace request
         */
        HttpVerb[HttpVerb["TRACE"] = 7] = "TRACE";
        /**
         * Patch request
         */
        HttpVerb[HttpVerb["PATCH"] = 8] = "PATCH";
    })(HttpVerb || (HttpVerb = {}));

    // MIT License
    /**
     * Default argument serialization rules for each well known HTTP verb.
     */
    class DefaultArgumentSerializationRules {
        /**
         * Construct the lookup table for well know verbs.
         */
        constructor() {
            this.map = {};
            // fallback rule if the verb is not defined.
            this.map["DEFAULT"] = {
                verb: "DEFAULT",
                dataInBody: true,
            };
            [HttpVerb.GET, HttpVerb.DELETE, HttpVerb.HEAD].forEach((verb) => {
                const label = HttpVerb[verb].toString();
                this.map[label] = {
                    verb: label,
                    dataInBody: false,
                };
            });
            [HttpVerb.POST, HttpVerb.PUT, HttpVerb.PATCH].forEach((verb) => {
                const label = HttpVerb[verb].toString();
                this.map[label] = {
                    verb: label,
                    dataInBody: true,
                };
            });
        }
        /**
         * Get a rule for serialization of arguments. This tells the generators where
         * argument data is packaged in a request. Arguments can be located in one of
         * the following:
         *
         *   Body,
         *   Url
         *
         * @param verb verb to lookup.
         */
        getRule(verb) {
            const name = typeof verb === "string" ? verb : HttpVerb[verb].toString();
            let rule = this.map[name];
            if (!rule) {
                rule = this.map["DEFAULT"];
            }
            return rule;
        }
    }
    /**
     * Singleton with the default argument serialization rules in it.
     */
    const argumentSerializationRules = new DefaultArgumentSerializationRules();

    // MIT License
    //
    // Copyright 2021 cPanel L.L.C.
    //
    // Permission is hereby granted, free of charge, to any person obtaining a copy
    //  of this software and associated documentation files (the "Software"), to deal
    // in the Software without restriction, including without limitation the
    // rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
    // sell copies of the Software, and to permit persons to whom the Software is
    // furnished to do so, subject to the following conditions:
    //
    // The above copyright notice and this permission notice shall be included in
    // all copies or substantial portions of the Software.
    //
    // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    // IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    // FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    // AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    // LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    // FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    // DEALINGS IN THE SOFTWARE.
    /**
     * Convert from a JavaScript boolean to a Perl boolean.
     */
    function fromBoolean(value) {
        return value ? "1" : "0";
    }
    const perlFalse = new Set(["", "0", 0]);
    /**
     * Convert from a Perl boolean to a JavaScript boolean
     */
    function toBoolean(value) {
        if (perlFalse.has(value)) {
            return false;
        }
        return true;
    }

    // MIT License
    /**
     * An name/value pair argument
     */
    class Argument {
        /**
         * Build a new Argument.
         *
         * @param name Name of the argument
         * @param value Value of the argument.
         */
        constructor(name, value) {
            if (!name) {
                throw new Error("You must provide a name when creating a name/value argument");
            }
            this.name = name;
            this.value = value;
        }
    }

    // MIT License
    //
    // Copyright 2021 cPanel L.L.C.
    //
    // Permission is hereby granted, free of charge, to any person obtaining a copy
    //  of this software and associated documentation files (the "Software"), to deal
    // in the Software without restriction, including without limitation the
    // rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
    // sell copies of the Software, and to permit persons to whom the Software is
    // furnished to do so, subject to the following conditions:
    //
    // The above copyright notice and this permission notice shall be included in
    // all copies or substantial portions of the Software.
    //
    // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    // IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    // FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    // AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    // LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    // FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    // DEALINGS IN THE SOFTWARE.
    /**
     * The filter operator defines the rule used to compare data in a column with the passed-in value. It
     * behaves something like:
     *
     *   const value = 1;
     *   data.map(item => item[column])
     *       .filter(itemValue => operator(itemValue, value));
     *
     * where item is the data from the column
     */
    var FilterOperator;
    (function (FilterOperator) {
        /**
         * String contains value
         */
        FilterOperator[FilterOperator["Contains"] = 0] = "Contains";
        /**
         * String begins with value
         */
        FilterOperator[FilterOperator["Begins"] = 1] = "Begins";
        /**
         * String ends with value
         */
        FilterOperator[FilterOperator["Ends"] = 2] = "Ends";
        /**
         * String matches pattern in value
         */
        FilterOperator[FilterOperator["Matches"] = 3] = "Matches";
        /**
         * Column value equals value
         */
        FilterOperator[FilterOperator["Equal"] = 4] = "Equal";
        /**
         * Column value not equal value
         */
        FilterOperator[FilterOperator["NotEqual"] = 5] = "NotEqual";
        /**
         * Column value is less than value
         */
        FilterOperator[FilterOperator["LessThan"] = 6] = "LessThan";
        /**
         * Column value is less than value using unlimited rules.
         */
        FilterOperator[FilterOperator["LessThanUnlimited"] = 7] = "LessThanUnlimited";
        /**
         * Column value is greater than value.
         */
        FilterOperator[FilterOperator["GreaterThan"] = 8] = "GreaterThan";
        /**
         * Column value is greater than value using unlimited rules.
         */
        FilterOperator[FilterOperator["GreaterThanUnlimited"] = 9] = "GreaterThanUnlimited";
        /**
         * Column value is defined. Value is ignored in this case.
         */
        FilterOperator[FilterOperator["Defined"] = 10] = "Defined";
        /**
         * Column value is undefined. Value is ignored in this case.
         */
        FilterOperator[FilterOperator["Undefined"] = 11] = "Undefined";
    })(FilterOperator || (FilterOperator = {}));
    /**
     * Defines a filter request for a Api call.
     */
    class Filter {
        /**
         * Construct a new Filter object.
         *
         * @param column Column name requests. Must be non-empty and exist on the related backend collection.
         * @param operator Comparison operator to use when applying the filter.
         * @param value Value to compare the columns value too.
         */
        constructor(column, operator, value) {
            if (!column) {
                throw new Error("You must define a non-empty column name.");
            }
            this.column = column;
            this.operator = operator;
            this.value = value;
        }
    }

    // MIT License
    //
    // Copyright 2021 cPanel L.L.C.
    //
    // Permission is hereby granted, free of charge, to any person obtaining a copy
    //  of this software and associated documentation files (the "Software"), to deal
    // in the Software without restriction, including without limitation the
    // rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
    // sell copies of the Software, and to permit persons to whom the Software is
    // furnished to do so, subject to the following conditions:
    //
    // The above copyright notice and this permission notice shall be included in
    // all copies or substantial portions of the Software.
    //
    // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    // IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    // FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    // AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    // LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    // FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    // DEALINGS IN THE SOFTWARE.
    const DEFAULT_PAGE_SIZE = 20;
    /**
     * When passed in the pageSize, will request all available records in a single page. Note: The backend process may not honor this request.
     */
    const ALL = Number.POSITIVE_INFINITY;
    /**
     * Defines a pagination request for an API.
     */
    class Pager {
        /**
         * Create a new pagination object.
         *
         * @param page Page to request. From 1 .. n where n is the set.length % pageSize. Defaults to 1.
         * @param pageSize Number of records to request in a page of data. Defaults to DEFAULT_PAGE_SIZE.
         *                          If the string 'all' is passed, then all the records are requested. Note: The backend
         *                          system may still impose page size limits in this case.
         */
        constructor(page = 1, pageSize = DEFAULT_PAGE_SIZE) {
            if (page <= 0) {
                throw new Error("The page must be 1 or greater. This is the logical page, not a programming index.");
            }
            if (pageSize <= 0) {
                throw new Error("The pageSize must be set to 'ALL' or a number > 0");
            }
            this.page = page;
            this.pageSize = pageSize;
        }
        /**
         * Check if the pagesize is set to ALL.
         *
         * @return true if requesting all records, false otherwise.
         */
        all() {
            return this.pageSize === ALL;
        }
    }

    // MIT License
    //
    // Copyright 2021 cPanel L.L.C.
    //
    // Permission is hereby granted, free of charge, to any person obtaining a copy
    //  of this software and associated documentation files (the "Software"), to deal
    // in the Software without restriction, including without limitation the
    // rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
    // sell copies of the Software, and to permit persons to whom the Software is
    // furnished to do so, subject to the following conditions:
    //
    // The above copyright notice and this permission notice shall be included in
    // all copies or substantial portions of the Software.
    //
    // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    // IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    // FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    // AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    // LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    // FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    // DEALINGS IN THE SOFTWARE.
    /**
     * Sorting direction. The SortType and SortDirection combine to define the sorting for collections returned.
     */
    var SortDirection;
    (function (SortDirection) {
        /**
         * Records are sorted from low value to high value based on the SortType
         */
        SortDirection[SortDirection["Ascending"] = 0] = "Ascending";
        /**
         * Records are sorted from high value to low value based on the SortType
         */
        SortDirection[SortDirection["Descending"] = 1] = "Descending";
    })(SortDirection || (SortDirection = {}));
    /**
     * Sorting type. Defines how values are compared.
     */
    var SortType;
    (function (SortType) {
        /**
         * Uses character-by-character comparison.
         */
        SortType[SortType["Lexicographic"] = 0] = "Lexicographic";
        /**
         * Special rule for handing IPv4 comparison. This takes into account the segments.
         */
        SortType[SortType["Ipv4"] = 1] = "Ipv4";
        /**
         * Assumes the values are numeric and compares them using number rules.
         */
        SortType[SortType["Numeric"] = 2] = "Numeric";
        /**
         * Special rule for certain data where 0 is considered unlimited.
         */
        SortType[SortType["NumericZeroAsMax"] = 3] = "NumericZeroAsMax";
    })(SortType || (SortType = {}));
    /**
     * Defines a sort rule. These can be combined into a list to define a complex sort for a list dataset.
     */
    class Sort {
        /**
         * Create a new instance of a Sort
         *
         * @param column Column to sort
         * @param direction Optional sort direction. Defaults to Ascending
         * @param type Optional sort type. Defaults to Lexicographic
         */
        constructor(column, direction = SortDirection.Ascending, type = SortType.Lexicographic) {
            if (!column) {
                throw new Error("You must provide a non-empty column name for a Sort rule.");
            }
            this.column = column;
            this.direction = direction;
            this.type = type;
        }
    }

    // MIT License
    //
    // Copyright 2021 cPanel L.L.C.
    //
    // Permission is hereby granted, free of charge, to any person obtaining a copy
    //  of this software and associated documentation files (the "Software"), to deal
    // in the Software without restriction, including without limitation the
    // rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
    // sell copies of the Software, and to permit persons to whom the Software is
    // furnished to do so, subject to the following conditions:
    //
    // The above copyright notice and this permission notice shall be included in
    // all copies or substantial portions of the Software.
    //
    // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    // IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    // FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    // AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    // LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    // FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    // DEALINGS IN THE SOFTWARE.
    /**
     * HTTP Headers Collection Abstraction
     *
     * The abstraction is an adapter to allow easy transformation of the headers array
     * into various formats for external HTTP libraries.
     */
    class Headers {
        /**
         * Create the adapter.
         *
         * @param headers - List of headers.
         */
        constructor(headers = []) {
            this.headers = headers;
        }
        /**
         * Push a header into the collection.
         *
         * @param header - A header to add to the collection
         */
        push(header) {
            this.headers.push(header);
        }
        /**
         * Iterator for the headers collection.
         *
         * @param fn - Transform for the forEach
         * @param thisArg - Optional reference to `this` to apply to the transform function.
         */
        forEach(fn, thisArg) {
            this.headers.forEach(fn, thisArg);
        }
        /**
         * Retrieve the headers as an array of Headers
         */
        toArray() {
            const copy = [];
            this.headers.forEach((h) => copy.push({ name: h.name, value: h.value }));
            return copy;
        }
        /**
         * Retrieve the headers as an object
         */
        toObject() {
            return this.headers.reduce((o, header) => {
                o[header.name] = header.value;
                return o;
            }, {});
        }
    }
    class CustomHeader {
        constructor(_header) {
            this._header = _header;
        }
        get name() {
            return this._header.name;
        }
        get value() {
            return this._header.value;
        }
    }
    class CpanelApiTokenInvalidError extends Error {
        constructor(m) {
            super(m);
            this.name = "CpanelApiTokenInvalidError";
            // Set the prototype explicitly. This fixes unit tests.
            Object.setPrototypeOf(this, CpanelApiTokenInvalidError.prototype);
        }
    }
    class CpanelApiTokenMismatchError extends Error {
        constructor(m) {
            super(m);
            this.name = "CpanelApiTokenMismatchError";
            // Set the prototype explicitly. This fixes unit tests.
            Object.setPrototypeOf(this, CpanelApiTokenMismatchError.prototype);
        }
    }
    class CpanelApiTokenHeader extends CustomHeader {
        constructor(token, user) {
            if (!token) {
                throw new CpanelApiTokenInvalidError("You must pass a valid token to the constructor.");
            }
            if (!user && !/^.+[:]/.test(token)) {
                throw new CpanelApiTokenInvalidError("You must pass a cPanel username associated with the cPanel API token.");
            }
            if (!user && !/[:].+$/.test(token)) {
                throw new CpanelApiTokenInvalidError("You must pass a valid cPanel API token.");
            }
            super({
                name: "Authorization",
                value: `cpanel ${user ? user + ":" : ""}${token}`,
            });
        }
    }
    class WhmApiTokenInvalidError extends Error {
        constructor(m) {
            super(m);
            this.name = "WhmApiTokenInvalidError";
            // Set the prototype explicitly. This fixes unit tests.
            Object.setPrototypeOf(this, WhmApiTokenInvalidError.prototype);
        }
    }
    class WhmApiTokenMismatchError extends Error {
        constructor(m) {
            super(m);
            this.name = "WhmApiTokenMismatchError";
            // Set the prototype explicitly. This fixes unit tests.
            Object.setPrototypeOf(this, WhmApiTokenMismatchError.prototype);
        }
    }
    class WhmApiTokenHeader extends CustomHeader {
        constructor(token, user) {
            if (!token) {
                throw new WhmApiTokenInvalidError("You must pass a valid token to the constructor.");
            }
            if (!user && !/^.+:/.test(token)) {
                throw new WhmApiTokenInvalidError("You must pass a WHM username associated with the WHM API token.");
            }
            if (!user && !/:.+$/.test(token)) {
                throw new WhmApiTokenInvalidError("You must pass a valid WHM API token.");
            }
            super({
                name: "Authorization",
                value: `whm ${user ? user + ":" : ""}${token}`,
            });
        }
    }

    // MIT License
    /**
     * Abstract base class for all Request objects. Developers should
     * create a subclass of this that implements the generate() method.
     */
    class Request$1 {
        /**
         * Create a new request.
         *
         * @param init   Optional request object used to initialize this object.
         */
        constructor(init) {
            /**
             * Namespace where the API call lives
             * @type {string}
             */
            this.namespace = "";
            /**
             * Method name of the API call.
             * @type {string}
             */
            this.method = "";
            /**
             * Optional list of arguments for the API call.
             * @type {IArgument[]}
             */
            this.arguments = [];
            /**
             * Optional list of sorting rules to pass to the API call.
             */
            this.sorts = [];
            /**
             * Optional list of filter rules to pass to the API call.
             */
            this.filters = [];
            /**
             * Optional list of columns to include with the response to the API call.
             */
            this.columns = [];
            /**
             * Optional pager rule to pass to the API.
             */
            this.pager = new Pager();
            /**
             * Optional custom headers collection
             */
            this.headers = new Headers();
            this._usePager = false;
            /**
             * Default configuration object.
             */
            this.defaultConfig = {
                analytics: false,
                json: false,
            };
            /**
             * Optional configuration information
             */
            this.config = this.defaultConfig;
            if (init) {
                this.method = init.method;
                if (init.namespace) {
                    this.namespace = init.namespace;
                }
                if (init.arguments) {
                    init.arguments.forEach((argument) => {
                        this.addArgument(argument);
                    });
                }
                if (init.sorts) {
                    init.sorts.forEach((sort) => {
                        this.addSort(sort);
                    });
                }
                if (init.filters) {
                    init.filters.forEach((filter) => {
                        this.addFilter(filter);
                    });
                }
                if (init.columns) {
                    init.columns.forEach((column) => this.addColumn(column));
                }
                if (init.pager) {
                    this.paginate(init.pager);
                }
                if (init.config) {
                    this.config = init.config;
                }
                else {
                    this.config = this.defaultConfig;
                }
                if (init.headers) {
                    init.headers.forEach((header) => {
                        this.addHeader(header);
                    });
                }
            }
        }
        /**
         * Use the pager only if true.
         */
        get usePager() {
            return this._usePager;
        }
        /**
         * Add an argument to the request.
         *
         * @param argument
         * @return Updated Request object.
         */
        addArgument(argument) {
            if (argument instanceof Argument) {
                this.arguments.push(argument);
            }
            else {
                this.arguments.push(new Argument(argument.name, argument.value));
            }
            return this;
        }
        /**
         * Add sorting rule to the request.
         *
         * @param sort Sort object with sorting information.
         * @return Updated Request object.
         */
        addSort(sort) {
            if (sort instanceof Sort) {
                this.sorts.push(sort);
            }
            else {
                this.sorts.push(new Sort(sort.column, sort.direction, sort.type));
            }
            return this;
        }
        /**
         * Add a filter to the request.
         *
         * @param filter Filter object with filter information.
         * @return Updated Request object.
         */
        addFilter(filter) {
            if (filter instanceof Filter) {
                this.filters.push(filter);
            }
            else {
                this.filters.push(new Filter(filter.column, filter.operator, filter.value));
            }
            return this;
        }
        /**
         * Add a column to include in the request. If no columns are specified, all columns are retrieved.
         *
         * @param name Name of a column
         * @return Updated Request object.
         */
        addColumn(column) {
            this.columns.push(column);
            return this;
        }
        /**
         * Add a custom http header to the request
         *
         * @param name Name of a column
         * @return Updated Request object.
         */
        addHeader(header) {
            if (header instanceof CustomHeader) {
                this.headers.push(header);
            }
            else {
                this.headers.push(new CustomHeader(header));
            }
            return this;
        }
        /**
         * Set the pager setting for the request.
         *
         * @param pager Pager object with pagination information.
         * @return Updated Request object.
         */
        paginate(pager) {
            if (pager instanceof Pager) {
                this.pager = pager;
            }
            else {
                this.pager = new Pager(pager.page, pager.pageSize || 20);
            }
            this._usePager = true;
            return this;
        }
    }

    /**
     * Checks if `value` is `undefined`.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is `undefined`, else `false`.
     * @example
     *
     * _.isUndefined(void 0);
     * // => true
     *
     * _.isUndefined(null);
     * // => false
     */
    function isUndefined(value) {
      return value === undefined;
    }

    var isUndefined_1 = isUndefined;

    /**
     * Checks if `value` is `null`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is `null`, else `false`.
     * @example
     *
     * _.isNull(null);
     * // => true
     *
     * _.isNull(void 0);
     * // => false
     */
    function isNull(value) {
      return value === null;
    }

    var isNull_1 = isNull;

    // MIT License
    /**
     * Types of message that can be in a response.
     */
    var MessageType;
    (function (MessageType) {
        /**
         * Message is an error.
         */
        MessageType[MessageType["Error"] = 0] = "Error";
        /**
         * Message is a warning.
         */
        MessageType[MessageType["Warning"] = 1] = "Warning";
        /**
         * Message is informational.
         */
        MessageType[MessageType["Information"] = 2] = "Information";
        /**
         * The message type is unknown.
         */
        MessageType[MessageType["Unknown"] = 3] = "Unknown";
    })(MessageType || (MessageType = {}));
    const DefaultMetaData = {
        isPaged: false,
        isFiltered: false,
        record: 0,
        page: 0,
        pageSize: 0,
        totalRecords: 0,
        totalPages: 0,
        recordsBeforeFilter: 0,
        batch: false,
        properties: {},
    };
    /**
     * Deep cloning of a object to avoid reference overwritting.
     *
     * @param data Metadata object to be cloned.
     * @returns Cloned Metadata object.
     */
    function clone(data) {
        return JSON.parse(JSON.stringify(data));
    }
    /**
     * Base class for all response. Must be sub-classed by a real implementation.
     */
    class Response {
        /**
         * Build a new response object from the response. Note, this class should not be called
         * directly.
         * @param response Complete data passed from the server. Probably it's been parsed using JSON.parse().
         * @param options for how to handle the processing of the response data.
         */
        constructor(response, options) {
            /**
             * The status code returned by the API. Usually 1 for success, 0 for failure.
             */
            this.status = 0;
            /**
             * List of messages related to the response.
             */
            this.messages = [];
            /**
             * Additional data returned about the request. Paging, filtering, and maybe other custom properties.
             */
            this.meta = clone(DefaultMetaData);
            /**
             * Options about how to handle the response processing.
             */
            this.options = {
                keepUnprocessedResponse: false,
            };
            if (isUndefined_1(response) || isNull_1(response)) {
                throw new Error("The response was unexpectedly undefined or null");
            }
            if (options) {
                this.options = options;
            }
            if (this.options.keepUnprocessedResponse) {
                this.raw = JSON.parse(JSON.stringify(response)); // deep clone
            }
        }
        /**
         * Checks if the API was successful.
         *
         * @return true if successful, false if failure.
         */
        get success() {
            return this.status > 0;
        }
        /**
         * Checks if the api failed.
         *
         * @return true if the API reports failure, false otherwise.
         */
        get failed() {
            return this.status === 0;
        }
        /**
         * Get the list of messages based on the requested type.
         *
         * @param type Type of the message to look up.
         * @return List of messages that match the filter.
         */
        _getMessages(type) {
            return this.messages.filter((message) => message.type === type);
        }
        /**
         * Get the list of error messages.
         *
         * @return List of errors.
         */
        get errors() {
            return this._getMessages(MessageType.Error);
        }
        /**
         * Get the list of warning messages.
         *
         * @return List of warnings.
         */
        get warnings() {
            return this._getMessages(MessageType.Warning);
        }
        /**
         * Get the list of informational messages.
         *
         * @return List of informational messages.
         */
        get infoMessages() {
            return this._getMessages(MessageType.Information);
        }
        /**
         * Checks if there are any messages of a given type.
         * @param type Type of the message to check for.
         * @return true if there are messages of the requested type. false otherwise.
         */
        _hasMessages(type) {
            return this.messages.filter((message) => message.type === type).length > 0;
        }
        /**
         * Checks if there are any error messages in the response.
         *
         * @return true if there are error messages, false otherwise.
         */
        get hasErrors() {
            return this._hasMessages(MessageType.Error);
        }
        /**
         * Checks if there are any warnings in the response.
         *
         * @return true if there are warnings, false otherwise.
         */
        get hasWarnings() {
            return this._hasMessages(MessageType.Warning);
        }
        /**
         * Checks if there are any informational messages in the response.
         *
         * @return true if there are informational messages, false otherwise.
         */
        get hasInfoMessages() {
            return this._hasMessages(MessageType.Information);
        }
        /**
         * Check if the response was paginated by the backend.
         *
         * @return true if the backend returned a page of the total records.
         */
        get isPaged() {
            return this.meta.isPaged;
        }
        /**
         * Check if the response was filtered by the backend.
         *
         * @return true if the backend filtered the records.
         */
        get isFiltered() {
            return this.meta.isFiltered;
        }
    }

    /** Detect free variable `global` from Node.js. */
    var freeGlobal = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;

    var _freeGlobal = freeGlobal;

    /** Detect free variable `self`. */
    var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

    /** Used as a reference to the global object. */
    var root = _freeGlobal || freeSelf || Function('return this')();

    var _root = root;

    /** Built-in value references. */
    var Symbol = _root.Symbol;

    var _Symbol = Symbol;

    /** Used for built-in method references. */
    var objectProto$2 = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty$2 = objectProto$2.hasOwnProperty;

    /**
     * Used to resolve the
     * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
     * of values.
     */
    var nativeObjectToString$1 = objectProto$2.toString;

    /** Built-in value references. */
    var symToStringTag$1 = _Symbol ? _Symbol.toStringTag : undefined;

    /**
     * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the raw `toStringTag`.
     */
    function getRawTag(value) {
      var isOwn = hasOwnProperty$2.call(value, symToStringTag$1),
          tag = value[symToStringTag$1];

      try {
        value[symToStringTag$1] = undefined;
        var unmasked = true;
      } catch (e) {}

      var result = nativeObjectToString$1.call(value);
      if (unmasked) {
        if (isOwn) {
          value[symToStringTag$1] = tag;
        } else {
          delete value[symToStringTag$1];
        }
      }
      return result;
    }

    var _getRawTag = getRawTag;

    /** Used for built-in method references. */
    var objectProto$1 = Object.prototype;

    /**
     * Used to resolve the
     * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
     * of values.
     */
    var nativeObjectToString = objectProto$1.toString;

    /**
     * Converts `value` to a string using `Object.prototype.toString`.
     *
     * @private
     * @param {*} value The value to convert.
     * @returns {string} Returns the converted string.
     */
    function objectToString(value) {
      return nativeObjectToString.call(value);
    }

    var _objectToString = objectToString;

    /** `Object#toString` result references. */
    var nullTag = '[object Null]',
        undefinedTag = '[object Undefined]';

    /** Built-in value references. */
    var symToStringTag = _Symbol ? _Symbol.toStringTag : undefined;

    /**
     * The base implementation of `getTag` without fallbacks for buggy environments.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the `toStringTag`.
     */
    function baseGetTag(value) {
      if (value == null) {
        return value === undefined ? undefinedTag : nullTag;
      }
      return (symToStringTag && symToStringTag in Object(value))
        ? _getRawTag(value)
        : _objectToString(value);
    }

    var _baseGetTag = baseGetTag;

    /**
     * Checks if `value` is object-like. A value is object-like if it's not `null`
     * and has a `typeof` result of "object".
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
     * @example
     *
     * _.isObjectLike({});
     * // => true
     *
     * _.isObjectLike([1, 2, 3]);
     * // => true
     *
     * _.isObjectLike(_.noop);
     * // => false
     *
     * _.isObjectLike(null);
     * // => false
     */
    function isObjectLike$1(value) {
      return value != null && typeof value == 'object';
    }

    var isObjectLike_1 = isObjectLike$1;

    /** `Object#toString` result references. */
    var boolTag = '[object Boolean]';

    /**
     * Checks if `value` is classified as a boolean primitive or object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a boolean, else `false`.
     * @example
     *
     * _.isBoolean(false);
     * // => true
     *
     * _.isBoolean(null);
     * // => false
     */
    function isBoolean$1(value) {
      return value === true || value === false ||
        (isObjectLike_1(value) && _baseGetTag(value) == boolTag);
    }

    var isBoolean_1 = isBoolean$1;

    /** `Object#toString` result references. */
    var numberTag = '[object Number]';

    /**
     * Checks if `value` is classified as a `Number` primitive or object.
     *
     * **Note:** To exclude `Infinity`, `-Infinity`, and `NaN`, which are
     * classified as numbers, use the `_.isFinite` method.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a number, else `false`.
     * @example
     *
     * _.isNumber(3);
     * // => true
     *
     * _.isNumber(Number.MIN_VALUE);
     * // => true
     *
     * _.isNumber(Infinity);
     * // => true
     *
     * _.isNumber('3');
     * // => false
     */
    function isNumber$1(value) {
      return typeof value == 'number' ||
        (isObjectLike_1(value) && _baseGetTag(value) == numberTag);
    }

    var isNumber_1 = isNumber$1;

    /**
     * Checks if `value` is classified as an `Array` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an array, else `false`.
     * @example
     *
     * _.isArray([1, 2, 3]);
     * // => true
     *
     * _.isArray(document.body.children);
     * // => false
     *
     * _.isArray('abc');
     * // => false
     *
     * _.isArray(_.noop);
     * // => false
     */
    var isArray$1 = Array.isArray;

    var isArray_1 = isArray$1;

    /** `Object#toString` result references. */
    var stringTag = '[object String]';

    /**
     * Checks if `value` is classified as a `String` primitive or object.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a string, else `false`.
     * @example
     *
     * _.isString('abc');
     * // => true
     *
     * _.isString(1);
     * // => false
     */
    function isString$1(value) {
      return typeof value == 'string' ||
        (!isArray_1(value) && isObjectLike_1(value) && _baseGetTag(value) == stringTag);
    }

    var isString_1 = isString$1;

    /**
     * Creates a unary function that invokes `func` with its argument transformed.
     *
     * @private
     * @param {Function} func The function to wrap.
     * @param {Function} transform The argument transform.
     * @returns {Function} Returns the new function.
     */
    function overArg(func, transform) {
      return function(arg) {
        return func(transform(arg));
      };
    }

    var _overArg = overArg;

    /** Built-in value references. */
    var getPrototype = _overArg(Object.getPrototypeOf, Object);

    var _getPrototype = getPrototype;

    /** `Object#toString` result references. */
    var objectTag = '[object Object]';

    /** Used for built-in method references. */
    var funcProto = Function.prototype,
        objectProto = Object.prototype;

    /** Used to resolve the decompiled source of functions. */
    var funcToString = funcProto.toString;

    /** Used to check objects for own properties. */
    var hasOwnProperty$1 = objectProto.hasOwnProperty;

    /** Used to infer the `Object` constructor. */
    var objectCtorString = funcToString.call(Object);

    /**
     * Checks if `value` is a plain object, that is, an object created by the
     * `Object` constructor or one with a `[[Prototype]]` of `null`.
     *
     * @static
     * @memberOf _
     * @since 0.8.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     * }
     *
     * _.isPlainObject(new Foo);
     * // => false
     *
     * _.isPlainObject([1, 2, 3]);
     * // => false
     *
     * _.isPlainObject({ 'x': 0, 'y': 0 });
     * // => true
     *
     * _.isPlainObject(Object.create(null));
     * // => true
     */
    function isPlainObject(value) {
      if (!isObjectLike_1(value) || _baseGetTag(value) != objectTag) {
        return false;
      }
      var proto = _getPrototype(value);
      if (proto === null) {
        return true;
      }
      var Ctor = hasOwnProperty$1.call(proto, 'constructor') && proto.constructor;
      return typeof Ctor == 'function' && Ctor instanceof Ctor &&
        funcToString.call(Ctor) == objectCtorString;
    }

    var isPlainObject_1 = isPlainObject;

    // MIT License
    /**
     * Verify if the value can be serialized to JSON
     *
     * @param value Value to check.
     * @source https://stackoverflow.com/questions/30579940/reliable-way-to-check-if-objects-is-serializable-in-javascript#answer-30712764
     */
    function isSerializable(value) {
        if (isUndefined_1(value) ||
            isNull_1(value) ||
            isBoolean_1(value) ||
            isNumber_1(value) ||
            isString_1(value)) {
            return true;
        }
        if (!isPlainObject_1(value) && !isArray_1(value)) {
            return false;
        }
        for (const key in value) {
            if (!isSerializable(value[key])) {
                return false;
            }
        }
        return true;
    }

    // MIT License
    /**
     * Encode parameters using application/x-www-form-urlencoded
     */
    class WwwFormUrlArgumentEncoder {
        constructor() {
            this.contentType = "application/x-www-form-urlencoded";
            this.separatorStart = "";
            this.separatorEnd = "";
            this.recordSeparator = "&";
        }
        /**
         * Encode a given value into the application/x-www-form-urlencoded.
         *
         * @param name Name of the field, may be empty string.
         * @param value Value to serialize
         * @param last True if this is the last argument being serialized.
         * @return Encoded version of the argument.
         */
        encode(name, value, last) {
            if (!name) {
                throw new Error("Name must have a non-empty value");
            }
            return (`${name}=${encodeURIComponent(value.toString())}` +
                (!last ? this.recordSeparator : ""));
        }
    }
    /**
     * Encode the parameter into JSON
     */
    class JsonArgumentEncoder {
        constructor() {
            this.contentType = "application/json";
            this.separatorStart = "{";
            this.separatorEnd = "}";
            this.recordSeparator = ",";
        }
        /**
         * Encode a given value into the JSON application/json body.
         *
         * @param name Name of the field.
         * @param value Value to serialize
         * @param last True if this is the last argument being serialized.
         * @return {string}        Encoded version of the argument.
         */
        encode(name, value, last) {
            if (!name) {
                throw new Error("Name must have a non-empty value");
            }
            if (!isSerializable(value)) {
                throw new Error("The passed in value can not be serialized to JSON");
            }
            return (JSON.stringify(name) +
                ":" +
                JSON.stringify(value) +
                (!last ? this.recordSeparator : ""));
        }
    }

    // MIT License
    //
    // Copyright 2021 cPanel L.L.C.
    //
    // Permission is hereby granted, free of charge, to any person obtaining a copy
    //  of this software and associated documentation files (the "Software"), to deal
    // in the Software without restriction, including without limitation the
    // rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
    // sell copies of the Software, and to permit persons to whom the Software is
    // furnished to do so, subject to the following conditions:
    //
    // The above copyright notice and this permission notice shall be included in
    // all copies or substantial portions of the Software.
    //
    // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    // IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    // FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    // AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    // LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    // FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    // DEALINGS IN THE SOFTWARE.
    /**
     * Check if the protocol is https.
     * @param  protocol Protocol to test
     * @return true if its https: in any case, false otherwise.
     */
    function isHttps(protocol) {
        return /^https:$/i.test(protocol);
    }
    /**
     * Check if the protocol is http.
     * @param  protocol Protocol to test
     * @return true if its http: in any case, false otherwise.
     */
    function isHttp(protocol) {
        return /^http:$/i.test(protocol);
    }
    /**
     * Strip any trailing slashes from a string.
     *
     * @method stripTrailingSlash
     * @param  path The path string to process.
     * @return The path string without a trailing slash.
     */
    function stripTrailingSlash(path) {
        return path && path.replace(/\/?$/, "");
    }
    // This will work in any context except a proxy URL to cPanel or Webmail
    // that accesses a URL outside /frontend (cPanel) or /webmail (Webmail),
    // but URLs like that are non-production by definition.
    const PortToApplicationMap = {
        "80": "other",
        "443": "other",
        "2082": "cpanel",
        "2083": "cpanel",
        "2086": "whostmgr",
        "2087": "whostmgr",
        "2095": "webmail",
        "2096": "webmail",
        "9876": "unittest",
        "9877": "unittest",
        "9878": "unittest",
        "9879": "unittest",
        frontend: "cpanel",
        webmail: "webmail",
    };
    /**
     * Helper class used to calculate paths within cPanel applications.
     */
    class ApplicationPath {
        /**
         * Create the PathHelper. This class is used to help generate paths
         * within an application. It has special knowledge about how paths are
         * constructed in the cPanel family of applications.
         *
         * @param location Abstraction for the window.location object to aid in unit testing this module.
         */
        constructor(location) {
            this.unprotectedPaths = ["/resetpass", "/invitation"];
            this.protocol = location.protocol;
            let port = location.port;
            if (!port) {
                // Since some browsers won't fill this in, we have to derive it from
                // the protocol if it's not provided in the window.location object.
                if (isHttps(this.protocol)) {
                    port = "443";
                }
                else if (isHttp(this.protocol)) {
                    port = "80";
                }
            }
            this.domain = location.hostname;
            this.port = parseInt(port, 10);
            this.path = location.pathname;
            const pathMatch = 
            // eslint-disable-next-line no-useless-escape -- regex, not a string
            this.path.match(/((?:\/cpsess\d+)?)(?:\/([^\/]+))?/) || [];
            // For proxy subdomains, we look at the first subdomain to identify the application.
            if (/^whm\./.test(this.domain)) {
                this.applicationName = PortToApplicationMap["2087"];
            }
            else if (/^cpanel\./.test(this.domain)) {
                this.applicationName = PortToApplicationMap["2083"];
            }
            else if (/^webmail\./.test(this.domain)) {
                this.applicationName = PortToApplicationMap["2095"];
            }
            else {
                this.applicationName =
                    PortToApplicationMap[port.toString()] ||
                        PortToApplicationMap[pathMatch[2]] ||
                        "whostmgr";
            }
            this.securityToken = pathMatch[1] || "";
            this.applicationPath = this.securityToken
                ? this.path.replace(this.securityToken, "")
                : this.path;
            this.theme = "";
            if (!this.isUnprotected && (this.isCpanel || this.isWebmail)) {
                const folders = this.path.split("/");
                this.theme = folders[3];
            }
            this.themePath = "";
            let themePath = this.securityToken + "/";
            if (this.isUnprotected) {
                themePath = "/";
            }
            else if (this.isCpanel) {
                themePath += "frontend/" + this.theme + "/";
            }
            else if (this.isWebmail) {
                themePath += "webmail/" + this.theme + "/";
            }
            else if (this.isOther) {
                // For unrecognized applications, use the path passed in PAGE.THEME_PATH
                themePath = "/";
            }
            this.themePath = themePath;
            this.rootUrl = this.protocol + "//" + this.domain + ":" + this.port;
        }
        /**
         * Return whether we are running inside some other framework or application
         *
         * @return true if this is an unrecognized application or framework; false otherwise
         */
        get isOther() {
            return /other/i.test(this.applicationName);
        }
        /**
         * Return whether we are running inside an unprotected path
         *
         * @return true if this is unprotected; false otherwise
         */
        get isUnprotected() {
            return (!this.securityToken &&
                this.unprotectedPaths.indexOf(stripTrailingSlash(this.applicationPath)) !== -1);
        }
        /**
         * Return whether we are running inside cPanel or something else (e.g., WHM)
         *
         * @return true if this is cPanel; false otherwise
         */
        get isCpanel() {
            return /cpanel/i.test(this.applicationName);
        }
        /**
         * Return whether we are running inside WHM or something else (e.g., WHM)
         *
         * @return true if this is WHM; false otherwise
         */
        get isWhm() {
            return /whostmgr/i.test(this.applicationName);
        }
        /**
         * Return whether we are running inside WHM or something else (e.g., WHM)
         *
         * @return true if this is Webmail; false otherwise
         */
        get isWebmail() {
            return /webmail/i.test(this.applicationName);
        }
        /**
         * Get the domain relative path for the relative URL path.
         *
         * @param relative Relative path to the resource.
         * @return Domain relative URL path including theme, if applicable, for the application to the file.
         */
        buildPath(relative) {
            return this.themePath + relative;
        }
        /**
         * Get the full url path for the relative URL path.
         *
         * @param relative Relative path to the resource.
         * @return Full URL path including theme, if applicable, for the application to the file.
         */
        buildFullPath(relative) {
            return (this.protocol +
                "//" +
                this.domain +
                ":" +
                this.port +
                this.buildPath(relative));
        }
        /**
         * Build a path relative to the security token
         *
         * @param relative Relative path to the resource.
         * @return Full path to the token relative resource.
         */
        buildTokenPath(relative) {
            return (this.protocol +
                "//" +
                this.domain +
                ":" +
                this.port +
                this.securityToken +
                relative);
        }
    }

    // MIT License
    //
    // Copyright 2021 cPanel L.L.C.
    //
    // Permission is hereby granted, free of charge, to any person obtaining a copy
    //  of this software and associated documentation files (the "Software"), to deal
    // in the Software without restriction, including without limitation the
    // rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
    // sell copies of the Software, and to permit persons to whom the Software is
    // furnished to do so, subject to the following conditions:
    //
    // The above copyright notice and this permission notice shall be included in
    // all copies or substantial portions of the Software.
    //
    // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    // IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    // FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    // AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    // LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    // FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    // DEALINGS IN THE SOFTWARE.
    /**
     * Provides a mockable layer between the tools below and window.location.
     */
    class LocationService {
        /**
         * The pathname part of the URL.
         */
        get pathname() {
            return window.location.pathname;
        }
        /**
         * The port part of the URL.
         */
        get port() {
            return window.location.port;
        }
        /**
         * The hostname part of the URL.
         */
        get hostname() {
            return window.location.hostname;
        }
        /**
         * The protocol part of the URL.
         */
        get protocol() {
            return window.location.protocol;
        }
    }

    /**
     * A specialized version of `_.reduce` for arrays without support for
     * iteratee shorthands.
     *
     * @private
     * @param {Array} [array] The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {*} [accumulator] The initial value.
     * @param {boolean} [initAccum] Specify using the first element of `array` as
     *  the initial value.
     * @returns {*} Returns the accumulated value.
     */
    function arrayReduce(array, iteratee, accumulator, initAccum) {
      var index = -1,
          length = array == null ? 0 : array.length;

      if (initAccum && length) {
        accumulator = array[++index];
      }
      while (++index < length) {
        accumulator = iteratee(accumulator, array[index], index, array);
      }
      return accumulator;
    }

    var _arrayReduce = arrayReduce;

    /**
     * The base implementation of `_.propertyOf` without support for deep paths.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Function} Returns the new accessor function.
     */
    function basePropertyOf(object) {
      return function(key) {
        return object == null ? undefined : object[key];
      };
    }

    var _basePropertyOf = basePropertyOf;

    /** Used to map Latin Unicode letters to basic Latin letters. */
    var deburredLetters = {
      // Latin-1 Supplement block.
      '\xc0': 'A',  '\xc1': 'A', '\xc2': 'A', '\xc3': 'A', '\xc4': 'A', '\xc5': 'A',
      '\xe0': 'a',  '\xe1': 'a', '\xe2': 'a', '\xe3': 'a', '\xe4': 'a', '\xe5': 'a',
      '\xc7': 'C',  '\xe7': 'c',
      '\xd0': 'D',  '\xf0': 'd',
      '\xc8': 'E',  '\xc9': 'E', '\xca': 'E', '\xcb': 'E',
      '\xe8': 'e',  '\xe9': 'e', '\xea': 'e', '\xeb': 'e',
      '\xcc': 'I',  '\xcd': 'I', '\xce': 'I', '\xcf': 'I',
      '\xec': 'i',  '\xed': 'i', '\xee': 'i', '\xef': 'i',
      '\xd1': 'N',  '\xf1': 'n',
      '\xd2': 'O',  '\xd3': 'O', '\xd4': 'O', '\xd5': 'O', '\xd6': 'O', '\xd8': 'O',
      '\xf2': 'o',  '\xf3': 'o', '\xf4': 'o', '\xf5': 'o', '\xf6': 'o', '\xf8': 'o',
      '\xd9': 'U',  '\xda': 'U', '\xdb': 'U', '\xdc': 'U',
      '\xf9': 'u',  '\xfa': 'u', '\xfb': 'u', '\xfc': 'u',
      '\xdd': 'Y',  '\xfd': 'y', '\xff': 'y',
      '\xc6': 'Ae', '\xe6': 'ae',
      '\xde': 'Th', '\xfe': 'th',
      '\xdf': 'ss',
      // Latin Extended-A block.
      '\u0100': 'A',  '\u0102': 'A', '\u0104': 'A',
      '\u0101': 'a',  '\u0103': 'a', '\u0105': 'a',
      '\u0106': 'C',  '\u0108': 'C', '\u010a': 'C', '\u010c': 'C',
      '\u0107': 'c',  '\u0109': 'c', '\u010b': 'c', '\u010d': 'c',
      '\u010e': 'D',  '\u0110': 'D', '\u010f': 'd', '\u0111': 'd',
      '\u0112': 'E',  '\u0114': 'E', '\u0116': 'E', '\u0118': 'E', '\u011a': 'E',
      '\u0113': 'e',  '\u0115': 'e', '\u0117': 'e', '\u0119': 'e', '\u011b': 'e',
      '\u011c': 'G',  '\u011e': 'G', '\u0120': 'G', '\u0122': 'G',
      '\u011d': 'g',  '\u011f': 'g', '\u0121': 'g', '\u0123': 'g',
      '\u0124': 'H',  '\u0126': 'H', '\u0125': 'h', '\u0127': 'h',
      '\u0128': 'I',  '\u012a': 'I', '\u012c': 'I', '\u012e': 'I', '\u0130': 'I',
      '\u0129': 'i',  '\u012b': 'i', '\u012d': 'i', '\u012f': 'i', '\u0131': 'i',
      '\u0134': 'J',  '\u0135': 'j',
      '\u0136': 'K',  '\u0137': 'k', '\u0138': 'k',
      '\u0139': 'L',  '\u013b': 'L', '\u013d': 'L', '\u013f': 'L', '\u0141': 'L',
      '\u013a': 'l',  '\u013c': 'l', '\u013e': 'l', '\u0140': 'l', '\u0142': 'l',
      '\u0143': 'N',  '\u0145': 'N', '\u0147': 'N', '\u014a': 'N',
      '\u0144': 'n',  '\u0146': 'n', '\u0148': 'n', '\u014b': 'n',
      '\u014c': 'O',  '\u014e': 'O', '\u0150': 'O',
      '\u014d': 'o',  '\u014f': 'o', '\u0151': 'o',
      '\u0154': 'R',  '\u0156': 'R', '\u0158': 'R',
      '\u0155': 'r',  '\u0157': 'r', '\u0159': 'r',
      '\u015a': 'S',  '\u015c': 'S', '\u015e': 'S', '\u0160': 'S',
      '\u015b': 's',  '\u015d': 's', '\u015f': 's', '\u0161': 's',
      '\u0162': 'T',  '\u0164': 'T', '\u0166': 'T',
      '\u0163': 't',  '\u0165': 't', '\u0167': 't',
      '\u0168': 'U',  '\u016a': 'U', '\u016c': 'U', '\u016e': 'U', '\u0170': 'U', '\u0172': 'U',
      '\u0169': 'u',  '\u016b': 'u', '\u016d': 'u', '\u016f': 'u', '\u0171': 'u', '\u0173': 'u',
      '\u0174': 'W',  '\u0175': 'w',
      '\u0176': 'Y',  '\u0177': 'y', '\u0178': 'Y',
      '\u0179': 'Z',  '\u017b': 'Z', '\u017d': 'Z',
      '\u017a': 'z',  '\u017c': 'z', '\u017e': 'z',
      '\u0132': 'IJ', '\u0133': 'ij',
      '\u0152': 'Oe', '\u0153': 'oe',
      '\u0149': "'n", '\u017f': 's'
    };

    /**
     * Used by `_.deburr` to convert Latin-1 Supplement and Latin Extended-A
     * letters to basic Latin letters.
     *
     * @private
     * @param {string} letter The matched letter to deburr.
     * @returns {string} Returns the deburred letter.
     */
    var deburrLetter = _basePropertyOf(deburredLetters);

    var _deburrLetter = deburrLetter;

    /**
     * A specialized version of `_.map` for arrays without support for iteratee
     * shorthands.
     *
     * @private
     * @param {Array} [array] The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns the new mapped array.
     */
    function arrayMap(array, iteratee) {
      var index = -1,
          length = array == null ? 0 : array.length,
          result = Array(length);

      while (++index < length) {
        result[index] = iteratee(array[index], index, array);
      }
      return result;
    }

    var _arrayMap = arrayMap;

    /** `Object#toString` result references. */
    var symbolTag = '[object Symbol]';

    /**
     * Checks if `value` is classified as a `Symbol` primitive or object.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
     * @example
     *
     * _.isSymbol(Symbol.iterator);
     * // => true
     *
     * _.isSymbol('abc');
     * // => false
     */
    function isSymbol(value) {
      return typeof value == 'symbol' ||
        (isObjectLike_1(value) && _baseGetTag(value) == symbolTag);
    }

    var isSymbol_1 = isSymbol;

    /** Used as references for various `Number` constants. */
    var INFINITY$2 = 1 / 0;

    /** Used to convert symbols to primitives and strings. */
    var symbolProto = _Symbol ? _Symbol.prototype : undefined,
        symbolToString = symbolProto ? symbolProto.toString : undefined;

    /**
     * The base implementation of `_.toString` which doesn't convert nullish
     * values to empty strings.
     *
     * @private
     * @param {*} value The value to process.
     * @returns {string} Returns the string.
     */
    function baseToString$1(value) {
      // Exit early for strings to avoid a performance hit in some environments.
      if (typeof value == 'string') {
        return value;
      }
      if (isArray_1(value)) {
        // Recursively convert values (susceptible to call stack limits).
        return _arrayMap(value, baseToString$1) + '';
      }
      if (isSymbol_1(value)) {
        return symbolToString ? symbolToString.call(value) : '';
      }
      var result = (value + '');
      return (result == '0' && (1 / value) == -INFINITY$2) ? '-0' : result;
    }

    var _baseToString = baseToString$1;

    /**
     * Converts `value` to a string. An empty string is returned for `null`
     * and `undefined` values. The sign of `-0` is preserved.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {string} Returns the converted string.
     * @example
     *
     * _.toString(null);
     * // => ''
     *
     * _.toString(-0);
     * // => '-0'
     *
     * _.toString([1, 2, 3]);
     * // => '1,2,3'
     */
    function toString$2(value) {
      return value == null ? '' : _baseToString(value);
    }

    var toString_1 = toString$2;

    /** Used to match Latin Unicode letters (excluding mathematical operators). */
    var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;

    /** Used to compose unicode character classes. */
    var rsComboMarksRange$4 = '\\u0300-\\u036f',
        reComboHalfMarksRange$4 = '\\ufe20-\\ufe2f',
        rsComboSymbolsRange$4 = '\\u20d0-\\u20ff',
        rsComboRange$4 = rsComboMarksRange$4 + reComboHalfMarksRange$4 + rsComboSymbolsRange$4;

    /** Used to compose unicode capture groups. */
    var rsCombo$3 = '[' + rsComboRange$4 + ']';

    /**
     * Used to match [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks) and
     * [combining diacritical marks for symbols](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks_for_Symbols).
     */
    var reComboMark = RegExp(rsCombo$3, 'g');

    /**
     * Deburrs `string` by converting
     * [Latin-1 Supplement](https://en.wikipedia.org/wiki/Latin-1_Supplement_(Unicode_block)#Character_table)
     * and [Latin Extended-A](https://en.wikipedia.org/wiki/Latin_Extended-A)
     * letters to basic Latin letters and removing
     * [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks).
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to deburr.
     * @returns {string} Returns the deburred string.
     * @example
     *
     * _.deburr('déjà vu');
     * // => 'deja vu'
     */
    function deburr(string) {
      string = toString_1(string);
      return string && string.replace(reLatin, _deburrLetter).replace(reComboMark, '');
    }

    var deburr_1 = deburr;

    /** Used to match words composed of alphanumeric characters. */
    var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;

    /**
     * Splits an ASCII `string` into an array of its words.
     *
     * @private
     * @param {string} The string to inspect.
     * @returns {Array} Returns the words of `string`.
     */
    function asciiWords(string) {
      return string.match(reAsciiWord) || [];
    }

    var _asciiWords = asciiWords;

    /** Used to detect strings that need a more robust regexp to match words. */
    var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;

    /**
     * Checks if `string` contains a word composed of Unicode symbols.
     *
     * @private
     * @param {string} string The string to inspect.
     * @returns {boolean} Returns `true` if a word is found, else `false`.
     */
    function hasUnicodeWord(string) {
      return reHasUnicodeWord.test(string);
    }

    var _hasUnicodeWord = hasUnicodeWord;

    /** Used to compose unicode character classes. */
    var rsAstralRange$3 = '\\ud800-\\udfff',
        rsComboMarksRange$3 = '\\u0300-\\u036f',
        reComboHalfMarksRange$3 = '\\ufe20-\\ufe2f',
        rsComboSymbolsRange$3 = '\\u20d0-\\u20ff',
        rsComboRange$3 = rsComboMarksRange$3 + reComboHalfMarksRange$3 + rsComboSymbolsRange$3,
        rsDingbatRange = '\\u2700-\\u27bf',
        rsLowerRange = 'a-z\\xdf-\\xf6\\xf8-\\xff',
        rsMathOpRange = '\\xac\\xb1\\xd7\\xf7',
        rsNonCharRange = '\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf',
        rsPunctuationRange = '\\u2000-\\u206f',
        rsSpaceRange = ' \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000',
        rsUpperRange = 'A-Z\\xc0-\\xd6\\xd8-\\xde',
        rsVarRange$3 = '\\ufe0e\\ufe0f',
        rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;

    /** Used to compose unicode capture groups. */
    var rsApos$1 = "['\u2019]",
        rsBreak = '[' + rsBreakRange + ']',
        rsCombo$2 = '[' + rsComboRange$3 + ']',
        rsDigits = '\\d+',
        rsDingbat = '[' + rsDingbatRange + ']',
        rsLower = '[' + rsLowerRange + ']',
        rsMisc = '[^' + rsAstralRange$3 + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + ']',
        rsFitz$2 = '\\ud83c[\\udffb-\\udfff]',
        rsModifier$2 = '(?:' + rsCombo$2 + '|' + rsFitz$2 + ')',
        rsNonAstral$2 = '[^' + rsAstralRange$3 + ']',
        rsRegional$2 = '(?:\\ud83c[\\udde6-\\uddff]){2}',
        rsSurrPair$2 = '[\\ud800-\\udbff][\\udc00-\\udfff]',
        rsUpper = '[' + rsUpperRange + ']',
        rsZWJ$3 = '\\u200d';

    /** Used to compose unicode regexes. */
    var rsMiscLower = '(?:' + rsLower + '|' + rsMisc + ')',
        rsMiscUpper = '(?:' + rsUpper + '|' + rsMisc + ')',
        rsOptContrLower = '(?:' + rsApos$1 + '(?:d|ll|m|re|s|t|ve))?',
        rsOptContrUpper = '(?:' + rsApos$1 + '(?:D|LL|M|RE|S|T|VE))?',
        reOptMod$2 = rsModifier$2 + '?',
        rsOptVar$2 = '[' + rsVarRange$3 + ']?',
        rsOptJoin$2 = '(?:' + rsZWJ$3 + '(?:' + [rsNonAstral$2, rsRegional$2, rsSurrPair$2].join('|') + ')' + rsOptVar$2 + reOptMod$2 + ')*',
        rsOrdLower = '\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])',
        rsOrdUpper = '\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])',
        rsSeq$2 = rsOptVar$2 + reOptMod$2 + rsOptJoin$2,
        rsEmoji = '(?:' + [rsDingbat, rsRegional$2, rsSurrPair$2].join('|') + ')' + rsSeq$2;

    /** Used to match complex or compound words. */
    var reUnicodeWord = RegExp([
      rsUpper + '?' + rsLower + '+' + rsOptContrLower + '(?=' + [rsBreak, rsUpper, '$'].join('|') + ')',
      rsMiscUpper + '+' + rsOptContrUpper + '(?=' + [rsBreak, rsUpper + rsMiscLower, '$'].join('|') + ')',
      rsUpper + '?' + rsMiscLower + '+' + rsOptContrLower,
      rsUpper + '+' + rsOptContrUpper,
      rsOrdUpper,
      rsOrdLower,
      rsDigits,
      rsEmoji
    ].join('|'), 'g');

    /**
     * Splits a Unicode `string` into an array of its words.
     *
     * @private
     * @param {string} The string to inspect.
     * @returns {Array} Returns the words of `string`.
     */
    function unicodeWords(string) {
      return string.match(reUnicodeWord) || [];
    }

    var _unicodeWords = unicodeWords;

    /**
     * Splits `string` into an array of its words.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to inspect.
     * @param {RegExp|string} [pattern] The pattern to match words.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {Array} Returns the words of `string`.
     * @example
     *
     * _.words('fred, barney, & pebbles');
     * // => ['fred', 'barney', 'pebbles']
     *
     * _.words('fred, barney, & pebbles', /[^, ]+/g);
     * // => ['fred', 'barney', '&', 'pebbles']
     */
    function words(string, pattern, guard) {
      string = toString_1(string);
      pattern = guard ? undefined : pattern;

      if (pattern === undefined) {
        return _hasUnicodeWord(string) ? _unicodeWords(string) : _asciiWords(string);
      }
      return string.match(pattern) || [];
    }

    var words_1 = words;

    /** Used to compose unicode capture groups. */
    var rsApos = "['\u2019]";

    /** Used to match apostrophes. */
    var reApos = RegExp(rsApos, 'g');

    /**
     * Creates a function like `_.camelCase`.
     *
     * @private
     * @param {Function} callback The function to combine each word.
     * @returns {Function} Returns the new compounder function.
     */
    function createCompounder(callback) {
      return function(string) {
        return _arrayReduce(words_1(deburr_1(string).replace(reApos, '')), callback, '');
      };
    }

    var _createCompounder = createCompounder;

    /**
     * Converts `string` to
     * [snake case](https://en.wikipedia.org/wiki/Snake_case).
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the snake cased string.
     * @example
     *
     * _.snakeCase('Foo Bar');
     * // => 'foo_bar'
     *
     * _.snakeCase('fooBar');
     * // => 'foo_bar'
     *
     * _.snakeCase('--FOO-BAR--');
     * // => 'foo_bar'
     */
    var snakeCase = _createCompounder(function(result, word, index) {
      return result + (index ? '_' : '') + word.toLowerCase();
    });

    var snakeCase_1 = snakeCase;

    // MIT License
    class UapiRequest extends Request$1 {
        /**
         * Add a custom HTTP header to the request
         *
         * @param name Name of a column
         * @return Updated Request object.
         */
        addHeader(header) {
            if (header instanceof WhmApiTokenHeader) {
                throw new WhmApiTokenMismatchError("A WhmApiTokenHeader cannot be used on a CpanelApiRequest");
            }
            super.addHeader(header);
            return this;
        }
        /**
         * Build a fragment of the parameter list based on the list of name/value pairs.
         *
         * @param params  Parameters to serialize.
         * @param encoder Encoder to use to serialize the each parameter.
         * @return Fragment with the serialized parameters
         */
        _build(params, encoder) {
            let fragment = "";
            params.forEach((arg, index, array) => {
                const isLast = index === array.length - 1;
                fragment += encoder.encode(arg.name, arg.value, isLast);
            });
            return encoder.separatorStart + fragment + encoder.separatorEnd;
        }
        /**
         * Generates the arguments for the request.
         *
         * @param params List of parameters to adjust based on the sort rules in the Request.
         */
        _generateArguments(params) {
            this.arguments.forEach((argument) => params.push(argument));
        }
        /**
         * Generates the sort parameters for the request.
         *
         * @param params List of parameters to adjust based on the sort rules in the Request.
         */
        _generateSorts(params) {
            this.sorts.forEach((sort, index) => {
                if (index === 0) {
                    params.push({ name: "api.sort", value: fromBoolean(true) });
                }
                params.push({ name: "api.sort_column_" + index, value: sort.column });
                params.push({
                    name: "api.sort_reverse_" + index,
                    value: fromBoolean(sort.direction !== SortDirection.Ascending),
                });
                params.push({
                    name: "api.sort_method_" + index,
                    value: snakeCase_1(SortType[sort.type]),
                });
            });
        }
        /**
         * Look up the correct name for the filter operator
         *
         * @param operator Type of filter operator to use to filter the items
         * @returns The string counter part for the filter operator.
         * @throws Will throw an error if an unrecognized FilterOperator is provided.
         */
        _lookupFilterOperator(operator) {
            switch (operator) {
                case FilterOperator.GreaterThanUnlimited:
                    return "gt_handle_unlimited";
                case FilterOperator.GreaterThan:
                    return "gt";
                case FilterOperator.LessThanUnlimited:
                    return "lt_handle_unlimited";
                case FilterOperator.LessThan:
                    return "lt";
                case FilterOperator.NotEqual:
                    return "ne";
                case FilterOperator.Equal:
                    return "eq";
                case FilterOperator.Defined:
                    return "defined";
                case FilterOperator.Undefined:
                    return "undefined";
                case FilterOperator.Matches:
                    return "matches";
                case FilterOperator.Ends:
                    return "ends";
                case FilterOperator.Begins:
                    return "begins";
                case FilterOperator.Contains:
                    return "contains";
                default:
                    // eslint-disable-next-line no-case-declarations -- just used for readability
                    const key = FilterOperator[operator];
                    throw new Error(`Unrecognized FilterOperator ${key} for UAPI`);
            }
        }
        /**
         * Generate the filter parameters if any.
         *
         * @param params List of parameters to adjust based on the filter rules provided.
         */
        _generateFilters(params) {
            this.filters.forEach((filter, index) => {
                params.push({ name: "api.filter_column_" + index, value: filter.column });
                params.push({
                    name: "api.filter_type_" + index,
                    value: this._lookupFilterOperator(filter.operator),
                });
                params.push({ name: "api.filter_term_" + index, value: filter.value });
            });
        }
        /**
         * In UAPI, we request the starting record, not the starting page. This translates
         * the page and page size into the correct starting record.
         */
        _traslatePageToStart(pager) {
            return (pager.page - 1) * pager.pageSize + 1;
        }
        /**
         * Generate the pager request parameters, if any.
         *
         * @param params List of parameters to adjust based on the pagination rules.
         */
        _generatePagination(params) {
            if (!this.usePager) {
                return;
            }
            const allPages = this.pager.all();
            params.push({
                name: "api.paginate",
                value: fromBoolean(true),
            });
            params.push({
                name: "api.paginate_start",
                value: allPages ? -1 : this._traslatePageToStart(this.pager),
            });
            if (!allPages) {
                params.push({
                    name: "api.paginate_size",
                    value: this.pager.pageSize,
                });
            }
        }
        /**
         * Generate any additional parameters from the configuration data.
         *
         * @param params List of parameters to adjust based on the configuration.
         */
        _generateConfiguration(params) {
            if (this.config && this.config["analytics"]) {
                params.push({
                    name: "api.analytics",
                    value: fromBoolean(this.config.analytics),
                });
            }
        }
        /**
         * Create a new uapi request.
         *
         * @param init  Optional request objects used to initialize this object.
         */
        constructor(init) {
            super(init);
        }
        /**
         * Generate the interchange object that has the pre-encoded
         * request using UAPI formatting.
         *
         * @param rule Optional parameter to specify a specific Rule we want the Request to be generated for.
         * @return Request information ready to be used by a remoting layer
         */
        generate(rule) {
            // Needed for pure JS clients, since they don't get the compiler checks
            if (!this.namespace) {
                throw new Error("You must define a namespace for the UAPI call before you generate a request");
            }
            if (!this.method) {
                throw new Error("You must define a method for the UAPI call before you generate a request");
            }
            if (!rule) {
                rule = {
                    verb: HttpVerb.POST,
                    encoder: this.config.json
                        ? new JsonArgumentEncoder()
                        : new WwwFormUrlArgumentEncoder(),
                };
            }
            if (!rule.encoder) {
                rule.encoder = this.config.json
                    ? new JsonArgumentEncoder()
                    : new WwwFormUrlArgumentEncoder();
            }
            const argumentRule = argumentSerializationRules.getRule(rule.verb);
            const info = {
                headers: new Headers([
                    {
                        name: "Content-Type",
                        value: rule.encoder.contentType,
                    },
                ]),
                url: ["", "execute", this.namespace, this.method]
                    .map(encodeURIComponent)
                    .join("/"),
                body: "",
            };
            const params = [];
            this._generateArguments(params);
            this._generateSorts(params);
            this._generateFilters(params);
            this._generatePagination(params);
            this._generateConfiguration(params);
            const encoded = this._build(params, rule.encoder);
            if (argumentRule.dataInBody) {
                info["body"] = encoded;
            }
            else {
                if (rule.verb === HttpVerb.GET) {
                    info["url"] += `?${encoded}`;
                }
                else {
                    info["url"] += encoded;
                }
            }
            this.headers.forEach((header) => {
                info.headers.push({
                    name: header.name,
                    value: header.value,
                });
            });
            return info;
        }
    }

    // MIT License
    /**
     * This class will extract the available metadata from the UAPI format into a standard format for JavaScript developers.
     */
    class UapiMetaData {
        /**
         * Build a new MetaData object from the metadata response from the server.
         *
         * @param meta UAPI metadata object.
         */
        constructor(meta) {
            /**
             * Indicates if the data is paged.
             */
            this.isPaged = false;
            /**
             * The record number of the first record of a page.
             */
            this.record = 0;
            /**
             * The current page.
             */
            this.page = 0;
            /**
             * The page size of the returned set.
             */
            this.pageSize = 0;
            /**
             * The total number of records available on the backend.
             */
            this.totalRecords = 0;
            /**
             * The total number of pages of records on the backend.
             */
            this.totalPages = 0;
            /**
             * Indicates if the data set if filtered.
             */
            this.isFiltered = false;
            /**
             * Number of records available before the filter was processed.
             */
            this.recordsBeforeFilter = 0;
            /**
             * Indicates the response was the result of a batch API.
             */
            this.batch = false;
            /**
             * A collection of the other less common or custom UAPI metadata properties.
             */
            this.properties = {};
            // Handle pagination
            if (meta.paginate) {
                this.isPaged = true;
                this.record = parseInt(meta.paginate.start_result, 10) || 0;
                this.page = parseInt(meta.paginate.current_page, 10) || 0;
                this.pageSize = parseInt(meta.paginate.results_per_page, 10) || 0;
                this.totalPages = parseInt(meta.paginate.total_pages, 10) || 0;
                this.totalRecords = parseInt(meta.paginate.total_results, 10) || 0;
            }
            // Handle filtering
            if (meta.filter) {
                this.isFiltered = true;
                this.recordsBeforeFilter =
                    parseInt(meta.filter.records_before_filter, 10) || 0;
            }
            // Get any other custom metadata properties off the object
            const builtinSet = new Set(["paginate", "filter"]);
            Object.keys(meta)
                .filter((key) => !builtinSet.has(key))
                .forEach((key) => {
                this.properties[key] = meta[key];
            });
        }
    }
    /**
     * Parser that will convert a UAPI wire-formated object into a standard response object for JavaScript developers.
     */
    class UapiResponse extends Response {
        /**
         * Parse out the status from the response.
         *
         * @param  response Raw response object from the backend. Already passed through JSON.parse().
         * @return Number indicating success or failure. > 1 success, 0 failure.
         */
        _parseStatus(response) {
            this.status = 0; // Assume it failed.
            if (typeof response.status === "undefined") {
                throw new Error("The response should have a numeric status property indicating the API succeeded (>0) or failed (=0)");
            }
            this.status = parseInt(response.status, 10);
        }
        /**
         * Parse out the messages from the response.
         *
         * @param response The response object sent by the API method.
         */
        _parseMessages(response) {
            if ("errors" in response) {
                const errors = response.errors;
                if (errors && errors.length) {
                    errors.forEach((error) => {
                        this.messages.push({
                            type: MessageType.Error,
                            message: error,
                        });
                    });
                }
            }
            if ("messages" in response) {
                const messages = response.messages;
                if (messages) {
                    messages.forEach((message) => {
                        this.messages.push({
                            type: MessageType.Information,
                            message: message,
                        });
                    });
                }
            }
        }
        /**
         * Parse out the status, data and metadata from a UAPI response into the abstract Response and IMetaData structures.
         *
         * @param response  Raw response from the server. It's just been JSON.parse() at this point.
         * @param Options on how to handle parsing of the response.
         */
        constructor(response, options) {
            super(response, options);
            this._parseStatus(response);
            this._parseMessages(response);
            if (!response || !Object.prototype.hasOwnProperty.call(response, "data")) {
                throw new Error("Expected response to contain a data property, but it is missing");
            }
            // TODO: Add parsing by specific types to take care of renames and type coercion.
            this.data = response.data;
            if (response.metadata) {
                this.meta = new UapiMetaData(response.metadata);
            }
        }
    }

    /** Used as references for various `Number` constants. */
    var MAX_SAFE_INTEGER = 9007199254740991;

    /* Built-in method references for those with the same name as other `lodash` methods. */
    var nativeFloor = Math.floor;

    /**
     * The base implementation of `_.repeat` which doesn't coerce arguments.
     *
     * @private
     * @param {string} string The string to repeat.
     * @param {number} n The number of times to repeat the string.
     * @returns {string} Returns the repeated string.
     */
    function baseRepeat(string, n) {
      var result = '';
      if (!string || n < 1 || n > MAX_SAFE_INTEGER) {
        return result;
      }
      // Leverage the exponentiation by squaring algorithm for a faster repeat.
      // See https://en.wikipedia.org/wiki/Exponentiation_by_squaring for more details.
      do {
        if (n % 2) {
          result += string;
        }
        n = nativeFloor(n / 2);
        if (n) {
          string += string;
        }
      } while (n);

      return result;
    }

    var _baseRepeat = baseRepeat;

    /**
     * The base implementation of `_.slice` without an iteratee call guard.
     *
     * @private
     * @param {Array} array The array to slice.
     * @param {number} [start=0] The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns the slice of `array`.
     */
    function baseSlice(array, start, end) {
      var index = -1,
          length = array.length;

      if (start < 0) {
        start = -start > length ? 0 : (length + start);
      }
      end = end > length ? length : end;
      if (end < 0) {
        end += length;
      }
      length = start > end ? 0 : ((end - start) >>> 0);
      start >>>= 0;

      var result = Array(length);
      while (++index < length) {
        result[index] = array[index + start];
      }
      return result;
    }

    var _baseSlice = baseSlice;

    /**
     * Casts `array` to a slice if it's needed.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {number} start The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns the cast slice.
     */
    function castSlice(array, start, end) {
      var length = array.length;
      end = end === undefined ? length : end;
      return (!start && end >= length) ? array : _baseSlice(array, start, end);
    }

    var _castSlice = castSlice;

    /** Used to compose unicode character classes. */
    var rsAstralRange$2 = '\\ud800-\\udfff',
        rsComboMarksRange$2 = '\\u0300-\\u036f',
        reComboHalfMarksRange$2 = '\\ufe20-\\ufe2f',
        rsComboSymbolsRange$2 = '\\u20d0-\\u20ff',
        rsComboRange$2 = rsComboMarksRange$2 + reComboHalfMarksRange$2 + rsComboSymbolsRange$2,
        rsVarRange$2 = '\\ufe0e\\ufe0f';

    /** Used to compose unicode capture groups. */
    var rsZWJ$2 = '\\u200d';

    /** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
    var reHasUnicode = RegExp('[' + rsZWJ$2 + rsAstralRange$2  + rsComboRange$2 + rsVarRange$2 + ']');

    /**
     * Checks if `string` contains Unicode symbols.
     *
     * @private
     * @param {string} string The string to inspect.
     * @returns {boolean} Returns `true` if a symbol is found, else `false`.
     */
    function hasUnicode(string) {
      return reHasUnicode.test(string);
    }

    var _hasUnicode = hasUnicode;

    /**
     * The base implementation of `_.property` without support for deep paths.
     *
     * @private
     * @param {string} key The key of the property to get.
     * @returns {Function} Returns the new accessor function.
     */
    function baseProperty(key) {
      return function(object) {
        return object == null ? undefined : object[key];
      };
    }

    var _baseProperty = baseProperty;

    /**
     * Gets the size of an ASCII `string`.
     *
     * @private
     * @param {string} string The string inspect.
     * @returns {number} Returns the string size.
     */
    var asciiSize = _baseProperty('length');

    var _asciiSize = asciiSize;

    /** Used to compose unicode character classes. */
    var rsAstralRange$1 = '\\ud800-\\udfff',
        rsComboMarksRange$1 = '\\u0300-\\u036f',
        reComboHalfMarksRange$1 = '\\ufe20-\\ufe2f',
        rsComboSymbolsRange$1 = '\\u20d0-\\u20ff',
        rsComboRange$1 = rsComboMarksRange$1 + reComboHalfMarksRange$1 + rsComboSymbolsRange$1,
        rsVarRange$1 = '\\ufe0e\\ufe0f';

    /** Used to compose unicode capture groups. */
    var rsAstral$1 = '[' + rsAstralRange$1 + ']',
        rsCombo$1 = '[' + rsComboRange$1 + ']',
        rsFitz$1 = '\\ud83c[\\udffb-\\udfff]',
        rsModifier$1 = '(?:' + rsCombo$1 + '|' + rsFitz$1 + ')',
        rsNonAstral$1 = '[^' + rsAstralRange$1 + ']',
        rsRegional$1 = '(?:\\ud83c[\\udde6-\\uddff]){2}',
        rsSurrPair$1 = '[\\ud800-\\udbff][\\udc00-\\udfff]',
        rsZWJ$1 = '\\u200d';

    /** Used to compose unicode regexes. */
    var reOptMod$1 = rsModifier$1 + '?',
        rsOptVar$1 = '[' + rsVarRange$1 + ']?',
        rsOptJoin$1 = '(?:' + rsZWJ$1 + '(?:' + [rsNonAstral$1, rsRegional$1, rsSurrPair$1].join('|') + ')' + rsOptVar$1 + reOptMod$1 + ')*',
        rsSeq$1 = rsOptVar$1 + reOptMod$1 + rsOptJoin$1,
        rsSymbol$1 = '(?:' + [rsNonAstral$1 + rsCombo$1 + '?', rsCombo$1, rsRegional$1, rsSurrPair$1, rsAstral$1].join('|') + ')';

    /** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
    var reUnicode$1 = RegExp(rsFitz$1 + '(?=' + rsFitz$1 + ')|' + rsSymbol$1 + rsSeq$1, 'g');

    /**
     * Gets the size of a Unicode `string`.
     *
     * @private
     * @param {string} string The string inspect.
     * @returns {number} Returns the string size.
     */
    function unicodeSize(string) {
      var result = reUnicode$1.lastIndex = 0;
      while (reUnicode$1.test(string)) {
        ++result;
      }
      return result;
    }

    var _unicodeSize = unicodeSize;

    /**
     * Gets the number of symbols in `string`.
     *
     * @private
     * @param {string} string The string to inspect.
     * @returns {number} Returns the string size.
     */
    function stringSize(string) {
      return _hasUnicode(string)
        ? _unicodeSize(string)
        : _asciiSize(string);
    }

    var _stringSize = stringSize;

    /**
     * Converts an ASCII `string` to an array.
     *
     * @private
     * @param {string} string The string to convert.
     * @returns {Array} Returns the converted array.
     */
    function asciiToArray(string) {
      return string.split('');
    }

    var _asciiToArray = asciiToArray;

    /** Used to compose unicode character classes. */
    var rsAstralRange = '\\ud800-\\udfff',
        rsComboMarksRange = '\\u0300-\\u036f',
        reComboHalfMarksRange = '\\ufe20-\\ufe2f',
        rsComboSymbolsRange = '\\u20d0-\\u20ff',
        rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
        rsVarRange = '\\ufe0e\\ufe0f';

    /** Used to compose unicode capture groups. */
    var rsAstral = '[' + rsAstralRange + ']',
        rsCombo = '[' + rsComboRange + ']',
        rsFitz = '\\ud83c[\\udffb-\\udfff]',
        rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')',
        rsNonAstral = '[^' + rsAstralRange + ']',
        rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}',
        rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]',
        rsZWJ = '\\u200d';

    /** Used to compose unicode regexes. */
    var reOptMod = rsModifier + '?',
        rsOptVar = '[' + rsVarRange + ']?',
        rsOptJoin = '(?:' + rsZWJ + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*',
        rsSeq = rsOptVar + reOptMod + rsOptJoin,
        rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';

    /** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
    var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');

    /**
     * Converts a Unicode `string` to an array.
     *
     * @private
     * @param {string} string The string to convert.
     * @returns {Array} Returns the converted array.
     */
    function unicodeToArray(string) {
      return string.match(reUnicode) || [];
    }

    var _unicodeToArray = unicodeToArray;

    /**
     * Converts `string` to an array.
     *
     * @private
     * @param {string} string The string to convert.
     * @returns {Array} Returns the converted array.
     */
    function stringToArray(string) {
      return _hasUnicode(string)
        ? _unicodeToArray(string)
        : _asciiToArray(string);
    }

    var _stringToArray = stringToArray;

    /* Built-in method references for those with the same name as other `lodash` methods. */
    var nativeCeil = Math.ceil;

    /**
     * Creates the padding for `string` based on `length`. The `chars` string
     * is truncated if the number of characters exceeds `length`.
     *
     * @private
     * @param {number} length The padding length.
     * @param {string} [chars=' '] The string used as padding.
     * @returns {string} Returns the padding for `string`.
     */
    function createPadding(length, chars) {
      chars = chars === undefined ? ' ' : _baseToString(chars);

      var charsLength = chars.length;
      if (charsLength < 2) {
        return charsLength ? _baseRepeat(chars, length) : chars;
      }
      var result = _baseRepeat(chars, nativeCeil(length / _stringSize(chars)));
      return _hasUnicode(chars)
        ? _castSlice(_stringToArray(result), 0, length).join('')
        : result.slice(0, length);
    }

    var _createPadding = createPadding;

    /** Used to match a single whitespace character. */
    var reWhitespace = /\s/;

    /**
     * Used by `_.trim` and `_.trimEnd` to get the index of the last non-whitespace
     * character of `string`.
     *
     * @private
     * @param {string} string The string to inspect.
     * @returns {number} Returns the index of the last non-whitespace character.
     */
    function trimmedEndIndex(string) {
      var index = string.length;

      while (index-- && reWhitespace.test(string.charAt(index))) {}
      return index;
    }

    var _trimmedEndIndex = trimmedEndIndex;

    /** Used to match leading whitespace. */
    var reTrimStart = /^\s+/;

    /**
     * The base implementation of `_.trim`.
     *
     * @private
     * @param {string} string The string to trim.
     * @returns {string} Returns the trimmed string.
     */
    function baseTrim(string) {
      return string
        ? string.slice(0, _trimmedEndIndex(string) + 1).replace(reTrimStart, '')
        : string;
    }

    var _baseTrim = baseTrim;

    /**
     * Checks if `value` is the
     * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
     * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an object, else `false`.
     * @example
     *
     * _.isObject({});
     * // => true
     *
     * _.isObject([1, 2, 3]);
     * // => true
     *
     * _.isObject(_.noop);
     * // => true
     *
     * _.isObject(null);
     * // => false
     */
    function isObject$1(value) {
      var type = typeof value;
      return value != null && (type == 'object' || type == 'function');
    }

    var isObject_1 = isObject$1;

    /** Used as references for various `Number` constants. */
    var NAN = 0 / 0;

    /** Used to detect bad signed hexadecimal string values. */
    var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

    /** Used to detect binary string values. */
    var reIsBinary = /^0b[01]+$/i;

    /** Used to detect octal string values. */
    var reIsOctal = /^0o[0-7]+$/i;

    /** Built-in method references without a dependency on `root`. */
    var freeParseInt = parseInt;

    /**
     * Converts `value` to a number.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to process.
     * @returns {number} Returns the number.
     * @example
     *
     * _.toNumber(3.2);
     * // => 3.2
     *
     * _.toNumber(Number.MIN_VALUE);
     * // => 5e-324
     *
     * _.toNumber(Infinity);
     * // => Infinity
     *
     * _.toNumber('3.2');
     * // => 3.2
     */
    function toNumber(value) {
      if (typeof value == 'number') {
        return value;
      }
      if (isSymbol_1(value)) {
        return NAN;
      }
      if (isObject_1(value)) {
        var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
        value = isObject_1(other) ? (other + '') : other;
      }
      if (typeof value != 'string') {
        return value === 0 ? value : +value;
      }
      value = _baseTrim(value);
      var isBinary = reIsBinary.test(value);
      return (isBinary || reIsOctal.test(value))
        ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
        : (reIsBadHex.test(value) ? NAN : +value);
    }

    var toNumber_1 = toNumber;

    /** Used as references for various `Number` constants. */
    var INFINITY$1 = 1 / 0,
        MAX_INTEGER = 1.7976931348623157e+308;

    /**
     * Converts `value` to a finite number.
     *
     * @static
     * @memberOf _
     * @since 4.12.0
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {number} Returns the converted number.
     * @example
     *
     * _.toFinite(3.2);
     * // => 3.2
     *
     * _.toFinite(Number.MIN_VALUE);
     * // => 5e-324
     *
     * _.toFinite(Infinity);
     * // => 1.7976931348623157e+308
     *
     * _.toFinite('3.2');
     * // => 3.2
     */
    function toFinite(value) {
      if (!value) {
        return value === 0 ? value : 0;
      }
      value = toNumber_1(value);
      if (value === INFINITY$1 || value === -INFINITY$1) {
        var sign = (value < 0 ? -1 : 1);
        return sign * MAX_INTEGER;
      }
      return value === value ? value : 0;
    }

    var toFinite_1 = toFinite;

    /**
     * Converts `value` to an integer.
     *
     * **Note:** This method is loosely based on
     * [`ToInteger`](http://www.ecma-international.org/ecma-262/7.0/#sec-tointeger).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {number} Returns the converted integer.
     * @example
     *
     * _.toInteger(3.2);
     * // => 3
     *
     * _.toInteger(Number.MIN_VALUE);
     * // => 0
     *
     * _.toInteger(Infinity);
     * // => 1.7976931348623157e+308
     *
     * _.toInteger('3.2');
     * // => 3
     */
    function toInteger(value) {
      var result = toFinite_1(value),
          remainder = result % 1;

      return result === result ? (remainder ? result - remainder : result) : 0;
    }

    var toInteger_1 = toInteger;

    /**
     * Pads `string` on the left side if it's shorter than `length`. Padding
     * characters are truncated if they exceed `length`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to pad.
     * @param {number} [length=0] The padding length.
     * @param {string} [chars=' '] The string used as padding.
     * @returns {string} Returns the padded string.
     * @example
     *
     * _.padStart('abc', 6);
     * // => '   abc'
     *
     * _.padStart('abc', 6, '_-');
     * // => '_-_abc'
     *
     * _.padStart('abc', 3);
     * // => 'abc'
     */
    function padStart(string, length, chars) {
      string = toString_1(string);
      length = toInteger_1(length);

      var strLength = length ? _stringSize(string) : 0;
      return (length && strLength < length)
        ? (_createPadding(length - strLength, chars) + string)
        : string;
    }

    var padStart_1 = padStart;

    // MIT License
    /**
     * Type of response format for WHM API 1. The data can be requested to be sent back
     * either in JSON format or XML format.
     */
    var WhmApiType;
    (function (WhmApiType) {
        /**
         * Json-Api request
         */
        WhmApiType["JsonApi"] = "json-api";
        /**
         * Xml-Api request
         */
        WhmApiType["XmlApi"] = "xml-api";
    })(WhmApiType || (WhmApiType = {}));
    class WhmApiRequest extends Request$1 {
        /**
         * Create a new UAPI request.
         *
         * @param init Optional request object used to initialize this object.
         */
        constructor(apiType, init) {
            super(init);
            /**
             * The API output format the request should be generated for.
             */
            this.apiType = WhmApiType.JsonApi;
            // Needed for or pure js clients since they don't get the compiler checks
            if (apiType != WhmApiType.JsonApi && apiType != WhmApiType.XmlApi) {
                throw new Error("You must define the API type for the whmapi call before you generate a request.");
            }
            else {
                this.apiType = apiType;
            }
            if (!this.method) {
                throw new Error("You must define a method for the WHM API call before you generate a request");
            }
        }
        /**
         * Add a custom HTTP header to the request
         *
         * @param name Name of a column
         * @return Updated Request object.
         */
        addHeader(header) {
            if (header instanceof CpanelApiTokenHeader) {
                throw new CpanelApiTokenMismatchError("A CpanelApiTokenHeader cannot be used on a WhmApiRequest");
            }
            super.addHeader(header);
            return this;
        }
        /**
         * Build a fragment of the parameter list based on the list of name/value pairs.
         *
         * @param params  Parameters to serialize.
         * @param encoder Encoder to use to serialize the each parameter.
         * @return Fragment with the serialized parameters
         */
        _build(params, encoder) {
            let fragment = "";
            params.forEach((arg, index, array) => {
                const isLast = index === array.length - 1;
                fragment += encoder.encode(arg.name, arg.value, isLast);
            });
            return encoder.separatorStart + fragment + encoder.separatorEnd;
        }
        /**
         * Convert from a number into a string that WHM API 1 will sort
         * in the same order as the numbers; e.g.: 26=>"za", 52=>"zza", ...
         * @method  _make_whm_api_fieldspec_from_number
         * @private
         * @param num Index of sort item
         * @return letter combination for the index of the sort item.
         */
        _make_whm_api_fieldspec_from_number(num) {
            const left = padStart_1("", Math.floor(num / 26), "z");
            return left + "abcdefghijklmnopqrstuvwxyz".charAt(num % 26);
        }
        /**
         * Generates the arguments for the request.
         *
         * @param params List of parameters to adjust based on the sort rules in the Request.
         */
        _generateArguments(params) {
            // For any WHM API call, the API version must be specified as an argument. It is required.
            // Adding it first before everything.
            const apiVersionParam = { name: "api.version", value: 1 };
            params.push(apiVersionParam);
            this.arguments.forEach((argument) => params.push(argument));
        }
        /**
         * Generates the sort parameters for the request.
         *
         * @param params List of parameters to adjust based on the sort rules in the Request.
         */
        _generateSorts(params) {
            this.sorts.forEach((sort, index) => {
                if (index === 0) {
                    params.push({ name: "api.sort.enable", value: fromBoolean(true) });
                }
                const sortPrefix = `api.sort.${this._make_whm_api_fieldspec_from_number(index)}`;
                params.push({ name: `${sortPrefix}.field`, value: sort.column });
                params.push({
                    name: `${sortPrefix}.reverse`,
                    value: fromBoolean(sort.direction !== SortDirection.Ascending),
                });
                params.push({
                    name: `${sortPrefix}.method`,
                    value: snakeCase_1(SortType[sort.type]),
                });
            });
        }
        /**
         * Look up the correct name for the filter operator
         *
         * @param operator Type of filter operator to use to filter the items
         * @returns The string counter part for the filter operator.
         * @throws Will throw an error if an unrecognized FilterOperator is provided.
         */
        _lookupFilterOperator(operator) {
            switch (operator) {
                case FilterOperator.GreaterThanUnlimited:
                    return "gt_handle_unlimited";
                case FilterOperator.GreaterThan:
                    return "gt";
                case FilterOperator.LessThanUnlimited:
                    return "lt_handle_unlimited";
                case FilterOperator.LessThan:
                    return "lt";
                case FilterOperator.Equal:
                    return "eq";
                case FilterOperator.Begins:
                    return "begins";
                case FilterOperator.Contains:
                    return "contains";
                default:
                    // eslint-disable-next-line no-case-declarations -- improves readability
                    const key = FilterOperator[operator];
                    throw new Error(`Unrecoginzed FilterOperator ${key} for WHM API 1`);
            }
        }
        /**
         * Generate the filter parameters, if any.
         *
         * @param params List of parameters to adjust based on the filter rules provided.
         */
        _generateFilters(params) {
            this.filters.forEach((filter, index) => {
                if (index === 0) {
                    params.push({
                        name: "api.filter.enable",
                        value: fromBoolean(true),
                    });
                    params.push({
                        name: "api.filter.verbose",
                        value: fromBoolean(true),
                    });
                }
                const filterPrefix = `api.filter.${this._make_whm_api_fieldspec_from_number(index)}`;
                params.push({ name: `${filterPrefix}.field`, value: filter.column });
                params.push({
                    name: `${filterPrefix}.type`,
                    value: this._lookupFilterOperator(filter.operator),
                });
                params.push({ name: `${filterPrefix}.arg0`, value: filter.value });
            });
        }
        /**
         * In UAPI, we request the starting record, not the starting page. This translates
         * the page and page size into the correct starting record.
         *
         * @param pager Object containing pager settings.
         */
        _translatePageToStart(pager) {
            return (pager.page - 1) * pager.pageSize + 1;
        }
        /**
         * Generate the pager request parameters, if any.
         *
         * @param params List of parameters to adjust based on the pagination rules.
         */
        _generatePagination(params) {
            if (!this.usePager) {
                return;
            }
            const allPages = this.pager.all();
            params.push({ name: "api.chunk.enable", value: fromBoolean(true) });
            params.push({ name: "api.chunk.verbose", value: fromBoolean(true) });
            params.push({
                name: "api.chunk.start",
                value: allPages ? -1 : this._translatePageToStart(this.pager),
            });
            if (!allPages) {
                params.push({
                    name: "api.chunk.size",
                    value: this.pager.pageSize,
                });
            }
        }
        /**
         * Generate the interchange object that has the pre-encoded
         * request using UAPI formatting.
         *
         * @param rule Optional parameter to specify a specific Rule we want the Request to be generated for.
         * @return {RequestInfo} Request information ready to be used by a remoting layer
         */
        generate(rule) {
            if (!rule) {
                rule = {
                    verb: HttpVerb.POST,
                    encoder: this.config.json
                        ? new JsonArgumentEncoder()
                        : new WwwFormUrlArgumentEncoder(),
                };
            }
            if (!rule.encoder) {
                rule.encoder = this.config.json
                    ? new JsonArgumentEncoder()
                    : new WwwFormUrlArgumentEncoder();
            }
            const argumentRule = argumentSerializationRules.getRule(rule.verb);
            const info = {
                headers: new Headers([
                    {
                        name: "Content-Type",
                        value: rule.encoder.contentType,
                    },
                ]),
                url: ["", this.apiType, this.method].map(encodeURIComponent).join("/"),
                body: "",
            };
            const params = [];
            this._generateArguments(params);
            this._generateSorts(params);
            this._generateFilters(params);
            this._generatePagination(params);
            const encoded = this._build(params, rule.encoder);
            if (argumentRule.dataInBody) {
                info["body"] = encoded;
            }
            else {
                if (rule.verb === HttpVerb.GET) {
                    info["url"] += `?${encoded}`;
                }
                else {
                    info["url"] += encoded;
                }
            }
            this.headers.forEach((header) => {
                info.headers.push({
                    name: header.name,
                    value: header.value,
                });
            });
            return info;
        }
    }

    // Copyright 2022 cPanel, L.L.C. - All rights reserved.
    class UapiServiceController {
      constructor() { }
      /**
       * Package up the api url into a full url for the current application.
       *
       * @param info [description]
       */
      packageUrl(info) {
        const appPath = new ApplicationPath(new LocationService());
        return appPath.buildTokenPath(info.url);
      }
      /**
       * Build a response handler for the request
       *
       * @param url [description]
       */
      packageResponseHandler(response, url) {
        const uapiResponse = new UapiResponse(response);
        uapiResponse.meta.properties["url"] = url ? url : "";
        return uapiResponse;
      }
      /**
       * Start an async GET request
       *
       * @param request - UapiRequest object with details of the API call.
       * @returns response object of type Promise
       */
      get(request) {
        const info = request.generate({
          verb: HttpVerb.GET,
          encoder: new WwwFormUrlArgumentEncoder(),
        });
        const url = this.packageUrl(info);
        return fetch(url, {
          method: "GET",
          headers: info.headers.toObject(),
        })
          .then(response => response.json())
          .then(response => {
          response = this.packageResponseHandler(response);
          if (response.hasErrors) {
            return Promise.reject(response.errors);
          }
          else {
            return Promise.resolve(response);
          }
        });
      }
      /**
       * Start an async POST request
       *
       * @param request - UapiRequest object with details of the API call.
       * @returns response object of type Promise
       */
      post(request) {
        const info = request.generate();
        const url = this.packageUrl(info);
        return fetch(url, {
          method: "POST",
          headers: info.headers.toObject(),
          body: info.body,
        })
          .then(response => response.json())
          .then(response => {
          response = this.packageResponseHandler(response);
          if (response.hasErrors) {
            return Promise.reject(response.errors);
          }
          else {
            return Promise.resolve(response);
          }
        });
      }
    }
    const UapiService = new UapiServiceController();

    const appendToMap = (map, propName, value) => {
        const items = map.get(propName);
        if (!items) {
            map.set(propName, [value]);
        }
        else if (!items.includes(value)) {
            items.push(value);
        }
    };
    const debounce = (fn, ms) => {
        let timeoutId;
        return (...args) => {
            if (timeoutId) {
                clearTimeout(timeoutId);
            }
            timeoutId = setTimeout(() => {
                timeoutId = 0;
                fn(...args);
            }, ms);
        };
    };

    /**
     * Check if a possible element isConnected.
     * The property might not be there, so we check for it.
     *
     * We want it to return true if isConnected is not a property,
     * otherwise we would remove these elements and would not update.
     *
     * Better leak in Edge than to be useless.
     */
    const isConnected = (maybeElement) => !('isConnected' in maybeElement) || maybeElement.isConnected;
    const cleanupElements = debounce((map) => {
        for (let key of map.keys()) {
            map.set(key, map.get(key).filter(isConnected));
        }
    }, 2000);
    const stencilSubscription = () => {
        if (typeof getRenderingRef !== 'function') {
            // If we are not in a stencil project, we do nothing.
            // This function is not really exported by @stencil/core.
            return {};
        }
        const elmsToUpdate = new Map();
        return {
            dispose: () => elmsToUpdate.clear(),
            get: (propName) => {
                const elm = getRenderingRef();
                if (elm) {
                    appendToMap(elmsToUpdate, propName, elm);
                }
            },
            set: (propName) => {
                const elements = elmsToUpdate.get(propName);
                if (elements) {
                    elmsToUpdate.set(propName, elements.filter(forceUpdate));
                }
                cleanupElements(elmsToUpdate);
            },
            reset: () => {
                elmsToUpdate.forEach((elms) => elms.forEach(forceUpdate));
                cleanupElements(elmsToUpdate);
            },
        };
    };

    const createObservableMap = (defaultState, shouldUpdate = (a, b) => a !== b) => {
        let states = new Map(Object.entries(defaultState !== null && defaultState !== void 0 ? defaultState : {}));
        const handlers = {
            dispose: [],
            get: [],
            set: [],
            reset: [],
        };
        const reset = () => {
            states = new Map(Object.entries(defaultState !== null && defaultState !== void 0 ? defaultState : {}));
            handlers.reset.forEach((cb) => cb());
        };
        const dispose = () => {
            // Call first dispose as resetting the state would
            // cause less updates ;)
            handlers.dispose.forEach((cb) => cb());
            reset();
        };
        const get = (propName) => {
            handlers.get.forEach((cb) => cb(propName));
            return states.get(propName);
        };
        const set = (propName, value) => {
            const oldValue = states.get(propName);
            if (shouldUpdate(value, oldValue, propName)) {
                states.set(propName, value);
                handlers.set.forEach((cb) => cb(propName, value, oldValue));
            }
        };
        const state = (typeof Proxy === 'undefined'
            ? {}
            : new Proxy(defaultState, {
                get(_, propName) {
                    return get(propName);
                },
                ownKeys(_) {
                    return Array.from(states.keys());
                },
                getOwnPropertyDescriptor() {
                    return {
                        enumerable: true,
                        configurable: true,
                    };
                },
                has(_, propName) {
                    return states.has(propName);
                },
                set(_, propName, value) {
                    set(propName, value);
                    return true;
                },
            }));
        const on = (eventName, callback) => {
            handlers[eventName].push(callback);
            return () => {
                removeFromArray(handlers[eventName], callback);
            };
        };
        const onChange = (propName, cb) => {
            const unSet = on('set', (key, newValue) => {
                if (key === propName) {
                    cb(newValue);
                }
            });
            const unReset = on('reset', () => cb(defaultState[propName]));
            return () => {
                unSet();
                unReset();
            };
        };
        const use = (...subscriptions) => {
            const unsubs = subscriptions.reduce((unsubs, subscription) => {
                if (subscription.set) {
                    unsubs.push(on('set', subscription.set));
                }
                if (subscription.get) {
                    unsubs.push(on('get', subscription.get));
                }
                if (subscription.reset) {
                    unsubs.push(on('reset', subscription.reset));
                }
                if (subscription.dispose) {
                    unsubs.push(on('dispose', subscription.dispose));
                }
                return unsubs;
            }, []);
            return () => unsubs.forEach((unsub) => unsub());
        };
        const forceUpdate = (key) => {
            const oldValue = states.get(key);
            handlers.set.forEach((cb) => cb(key, oldValue, oldValue));
        };
        return {
            state,
            get,
            set,
            on,
            onChange,
            use,
            dispose,
            reset,
            forceUpdate,
        };
    };
    const removeFromArray = (array, item) => {
        const index = array.indexOf(item);
        if (index >= 0) {
            array[index] = array[array.length - 1];
            array.length--;
        }
    };

    const createStore = (defaultState, shouldUpdate) => {
        const map = createObservableMap(defaultState, shouldUpdate);
        map.use(stencilSubscription());
        return map;
    };

    /**
    # cpanel - ui/web-components/src/components/header/cp-header-search/account-access-tweak-setting.enum.ts
    #                                                  Copyright 2022 cPanel, L.L.C.
    #                                                           All rights reserved.
    # copyright@cpanel.net                                         http://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
     */
    var AccountAccessTweakSetting;
    (function (AccountAccessTweakSetting) {
      AccountAccessTweakSetting["OWNER_ROOT"] = "owner_root";
      AccountAccessTweakSetting["OWNER_ONLY"] = "owner";
      AccountAccessTweakSetting["USER"] = "user";
      // This is here just as a dummy value to set in cPanel,
      // which doesn’t actually need the account-access check logic.
      AccountAccessTweakSetting["NONE"] = "";
    })(AccountAccessTweakSetting || (AccountAccessTweakSetting = {}));

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    class Permissions {
      constructor(permissions) {
        this.basicWHMFunctions = (permissions === null || permissions === void 0 ? void 0 : permissions.basicWHMFunctions) ? toBoolean(permissions.basicWHMFunctions) : false;
        this.listAccounts = (permissions === null || permissions === void 0 ? void 0 : permissions.listAccounts) ? toBoolean(permissions.listAccounts) : false;
        this.modifyAccount = (permissions === null || permissions === void 0 ? void 0 : permissions.modifyAccount) ? toBoolean(permissions.modifyAccount) : false;
        this.all = (permissions === null || permissions === void 0 ? void 0 : permissions.all) ? toBoolean(permissions.all) : false;
        this.impersonateAccountTweakSettingValue = (permissions === null || permissions === void 0 ? void 0 : permissions.impersonateAccountTweakSettingValue)
          ? permissions.impersonateAccountTweakSettingValue
          : AccountAccessTweakSetting.NONE;
      }
    }

    /**
    # cpanel - ui/web-components/src/components/header/ui-overlay.ts
    #                                                  Copyright 2022 cPanel, L.L.C.
    #                                                           All rights reserved.
    # copyright@cpanel.net                                         http://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
     */
    // This is the class that marks the overlay as “shown”.
    const CP_OVERLAY_ACTIVE_CLASS = "page-overlay--cover-content-area";
    /**
     * @class
     *
     * This class manages a document overlay element for multiple components.
     * Having a class that manages the overlay prevents one component from
     * “stepping on” another component’s use of the overlay; consider:
     *
     * - Component A shows overlay
     * - Component B shows overlay (no visible change)
     * - Component A hides overlay
     *
     * At this time the overlay is hidden, despite that component B still
     * wants it shown.
     *
     * This module implements logic whereby the overlay is shown if and only
     * if at least 1 caller has “claimed” the overlay.
     */
    class UIOverlay {
      /**
       * @constructor
       * @param {overlayEl} - The overlay element
       */
      constructor(overlayEl) {
        this.element = overlayEl;
        this.claims = {};
      }
      /**
       * “Claims” the overlay for the `name`d component. The overlay will
       * be shown if it’s not already.
       *
       * **IMPORTANT:** Nothing prevents two components from giving the
       * same `name`. The integrity of this, though, depends on each
       * caller/component giving a _different_ name.
       */
      claim(name) {
        this.claims[name] = true;
        this.element.classList.add(CP_OVERLAY_ACTIVE_CLASS);
      }
      /**
       * Releases the `name`d component’s “claim” on the overlay.
       * If no “claims” are left, then this hides the overlay.
       */
      release(name) {
        delete this.claims[name];
        if (!Object.keys(this.claims).length) {
          this.element.classList.remove(CP_OVERLAY_ACTIVE_CLASS);
        }
      }
    }

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    const { state, dispose } = createStore({
      // directory prefix for cpanel code base
      directoryPrefix: "",
      // cpanel and whm application list
      appList: [],
      mainMenuLinks: [],
      // if the app is cpanel, whm or webmail
      appName: "",
      categoryList: [],
      hostName: "",
      serverEnvironment: "",
      user: "",
      favorites: [],
      /**
       * Display friendly cpanel version.
       */
      version: "",
      /**
       * The full version of cPanel.
       */
      cpanelFullVersion: "",
      plugins: [],
      whmNotifications: [],
      licenseType: "",
      // cPanel users primary domain
      primaryDomain: "",
      permissions: new Permissions(),
      appSearchResultsLimit: 0,
      /**
       * A dummy object, to be replaced at DOMContentLoaded time.
       */
      uiOverlay: new UIOverlay(document.documentElement),
      initialNavUrl: "",
      /**
       * The logo name (cf. Whostmgr::UI::Logos) and its URL path.
       * (MagicRevision is applied.)
       */
      whmLogos: {},
      /**
       * The company id as provided by the cPanel license.
       */
      companyId: "",
      /**
       * The application key
       */
      cpanelAppKey: "",
    });

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    /**
     * Checks the state's appList for the existence of apps. This is used as a feature check until a better method can be implemented.
     * @param appNames List of appNames. The appName comes from the "file" key in dynamicui.conf
     * @returns AppEntry[]. Given a list of appNames, returns the AppEntry for those strings if the user has access to the feature.
     */
    function appFeatureCheck(appNames) {
      return state.appList.filter(app => appNames.includes(app.key));
    }

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    var SitejetInfo;
    (function (SitejetInfo) {
      SitejetInfo["Key"] = "cpanel-sitejet-plugin";
      SitejetInfo["Url"] = "sitejet/index.html#";
    })(SitejetInfo || (SitejetInfo = {}));

    const cpFeatureShowcaseCss = ".container,.container-fluid,.container-xxl,.container-xl,.container-lg,.container-md,.container-sm{--cp-gutter-x:1.5rem;--cp-gutter-y:0;width:100%;padding-right:calc(var(--cp-gutter-x) * 0.5);padding-left:calc(var(--cp-gutter-x) * 0.5);margin-right:auto;margin-left:auto}@media (min-width: 576px){.container-sm,.container{max-width:540px}}@media (min-width: 768px){.container-md,.container-sm,.container{max-width:720px}}@media (min-width: 992px){.container-lg,.container-md,.container-sm,.container{max-width:960px}}@media (min-width: 1200px){.container-xl,.container-lg,.container-md,.container-sm,.container{max-width:1140px}}@media (min-width: 1400px){.container-xxl,.container-xl,.container-lg,.container-md,.container-sm,.container{max-width:1320px}}.row{--cp-gutter-x:1.5rem;--cp-gutter-y:0;display:flex;flex-wrap:wrap;margin-top:calc(-1 * var(--cp-gutter-y));margin-right:calc(-0.5 * var(--cp-gutter-x));margin-left:calc(-0.5 * var(--cp-gutter-x))}.row>*{flex-shrink:0;width:100%;max-width:100%;padding-right:calc(var(--cp-gutter-x) * 0.5);padding-left:calc(var(--cp-gutter-x) * 0.5);margin-top:var(--cp-gutter-y)}.col{flex:1 0 0%}.row-cols-auto>*{flex:0 0 auto;width:auto}.row-cols-1>*{flex:0 0 auto;width:100%}.row-cols-2>*{flex:0 0 auto;width:50%}.row-cols-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-4>*{flex:0 0 auto;width:25%}.row-cols-5>*{flex:0 0 auto;width:20%}.row-cols-6>*{flex:0 0 auto;width:16.6666666667%}.col-auto{flex:0 0 auto;width:auto}.col-1{flex:0 0 auto;width:8.33333333%}.col-2{flex:0 0 auto;width:16.66666667%}.col-3{flex:0 0 auto;width:25%}.col-4{flex:0 0 auto;width:33.33333333%}.col-5{flex:0 0 auto;width:41.66666667%}.col-6{flex:0 0 auto;width:50%}.col-7{flex:0 0 auto;width:58.33333333%}.col-8{flex:0 0 auto;width:66.66666667%}.col-9{flex:0 0 auto;width:75%}.col-10{flex:0 0 auto;width:83.33333333%}.col-11{flex:0 0 auto;width:91.66666667%}.col-12{flex:0 0 auto;width:100%}[dir=\"ltr\"] .offset-1{margin-left:8.33333333%}[dir=\"rtl\"] .offset-1{margin-right:8.33333333%}[dir=\"ltr\"] .offset-2{margin-left:16.66666667%}[dir=\"rtl\"] .offset-2{margin-right:16.66666667%}[dir=\"ltr\"] .offset-3{margin-left:25%}[dir=\"rtl\"] .offset-3{margin-right:25%}[dir=\"ltr\"] .offset-4{margin-left:33.33333333%}[dir=\"rtl\"] .offset-4{margin-right:33.33333333%}[dir=\"ltr\"] .offset-5{margin-left:41.66666667%}[dir=\"rtl\"] .offset-5{margin-right:41.66666667%}[dir=\"ltr\"] .offset-6{margin-left:50%}[dir=\"rtl\"] .offset-6{margin-right:50%}[dir=\"ltr\"] .offset-7{margin-left:58.33333333%}[dir=\"rtl\"] .offset-7{margin-right:58.33333333%}[dir=\"ltr\"] .offset-8{margin-left:66.66666667%}[dir=\"rtl\"] .offset-8{margin-right:66.66666667%}[dir=\"ltr\"] .offset-9{margin-left:75%}[dir=\"rtl\"] .offset-9{margin-right:75%}[dir=\"ltr\"] .offset-10{margin-left:83.33333333%}[dir=\"rtl\"] .offset-10{margin-right:83.33333333%}[dir=\"ltr\"] .offset-11{margin-left:91.66666667%}[dir=\"rtl\"] .offset-11{margin-right:91.66666667%}.g-0,.gx-0{--cp-gutter-x:0}.g-0,.gy-0{--cp-gutter-y:0}.g-1,.gx-1{--cp-gutter-x:0.25rem}.g-1,.gy-1{--cp-gutter-y:0.25rem}.g-2,.gx-2{--cp-gutter-x:0.5rem}.g-2,.gy-2{--cp-gutter-y:0.5rem}.g-3,.gx-3{--cp-gutter-x:0.75rem}.g-3,.gy-3{--cp-gutter-y:0.75rem}.g-4,.gx-4{--cp-gutter-x:1rem}.g-4,.gy-4{--cp-gutter-y:1rem}.g-5,.gx-5{--cp-gutter-x:1.25rem}.g-5,.gy-5{--cp-gutter-y:1.25rem}.g-6,.gx-6{--cp-gutter-x:1.5rem}.g-6,.gy-6{--cp-gutter-y:1.5rem}.g-7,.gx-7{--cp-gutter-x:1.75rem}.g-7,.gy-7{--cp-gutter-y:1.75rem}.g-8,.gx-8{--cp-gutter-x:2rem}.g-8,.gy-8{--cp-gutter-y:2rem}.g-9,.gx-9{--cp-gutter-x:2.5rem}.g-9,.gy-9{--cp-gutter-y:2.5rem}.g-10,.gx-10{--cp-gutter-x:3rem}.g-10,.gy-10{--cp-gutter-y:3rem}@media (min-width: 576px){.col-sm{flex:1 0 0%}.row-cols-sm-auto>*{flex:0 0 auto;width:auto}.row-cols-sm-1>*{flex:0 0 auto;width:100%}.row-cols-sm-2>*{flex:0 0 auto;width:50%}.row-cols-sm-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-sm-4>*{flex:0 0 auto;width:25%}.row-cols-sm-5>*{flex:0 0 auto;width:20%}.row-cols-sm-6>*{flex:0 0 auto;width:16.6666666667%}.col-sm-auto{flex:0 0 auto;width:auto}.col-sm-1{flex:0 0 auto;width:8.33333333%}.col-sm-2{flex:0 0 auto;width:16.66666667%}.col-sm-3{flex:0 0 auto;width:25%}.col-sm-4{flex:0 0 auto;width:33.33333333%}.col-sm-5{flex:0 0 auto;width:41.66666667%}.col-sm-6{flex:0 0 auto;width:50%}.col-sm-7{flex:0 0 auto;width:58.33333333%}.col-sm-8{flex:0 0 auto;width:66.66666667%}.col-sm-9{flex:0 0 auto;width:75%}.col-sm-10{flex:0 0 auto;width:83.33333333%}.col-sm-11{flex:0 0 auto;width:91.66666667%}.col-sm-12{flex:0 0 auto;width:100%}[dir=\"ltr\"] .offset-sm-0{margin-left:0}[dir=\"rtl\"] .offset-sm-0{margin-right:0}[dir=\"ltr\"] .offset-sm-1{margin-left:8.33333333%}[dir=\"rtl\"] .offset-sm-1{margin-right:8.33333333%}[dir=\"ltr\"] .offset-sm-2{margin-left:16.66666667%}[dir=\"rtl\"] .offset-sm-2{margin-right:16.66666667%}[dir=\"ltr\"] .offset-sm-3{margin-left:25%}[dir=\"rtl\"] .offset-sm-3{margin-right:25%}[dir=\"ltr\"] .offset-sm-4{margin-left:33.33333333%}[dir=\"rtl\"] .offset-sm-4{margin-right:33.33333333%}[dir=\"ltr\"] .offset-sm-5{margin-left:41.66666667%}[dir=\"rtl\"] .offset-sm-5{margin-right:41.66666667%}[dir=\"ltr\"] .offset-sm-6{margin-left:50%}[dir=\"rtl\"] .offset-sm-6{margin-right:50%}[dir=\"ltr\"] .offset-sm-7{margin-left:58.33333333%}[dir=\"rtl\"] .offset-sm-7{margin-right:58.33333333%}[dir=\"ltr\"] .offset-sm-8{margin-left:66.66666667%}[dir=\"rtl\"] .offset-sm-8{margin-right:66.66666667%}[dir=\"ltr\"] .offset-sm-9{margin-left:75%}[dir=\"rtl\"] .offset-sm-9{margin-right:75%}[dir=\"ltr\"] .offset-sm-10{margin-left:83.33333333%}[dir=\"rtl\"] .offset-sm-10{margin-right:83.33333333%}[dir=\"ltr\"] .offset-sm-11{margin-left:91.66666667%}[dir=\"rtl\"] .offset-sm-11{margin-right:91.66666667%}.g-sm-0,.gx-sm-0{--cp-gutter-x:0}.g-sm-0,.gy-sm-0{--cp-gutter-y:0}.g-sm-1,.gx-sm-1{--cp-gutter-x:0.25rem}.g-sm-1,.gy-sm-1{--cp-gutter-y:0.25rem}.g-sm-2,.gx-sm-2{--cp-gutter-x:0.5rem}.g-sm-2,.gy-sm-2{--cp-gutter-y:0.5rem}.g-sm-3,.gx-sm-3{--cp-gutter-x:0.75rem}.g-sm-3,.gy-sm-3{--cp-gutter-y:0.75rem}.g-sm-4,.gx-sm-4{--cp-gutter-x:1rem}.g-sm-4,.gy-sm-4{--cp-gutter-y:1rem}.g-sm-5,.gx-sm-5{--cp-gutter-x:1.25rem}.g-sm-5,.gy-sm-5{--cp-gutter-y:1.25rem}.g-sm-6,.gx-sm-6{--cp-gutter-x:1.5rem}.g-sm-6,.gy-sm-6{--cp-gutter-y:1.5rem}.g-sm-7,.gx-sm-7{--cp-gutter-x:1.75rem}.g-sm-7,.gy-sm-7{--cp-gutter-y:1.75rem}.g-sm-8,.gx-sm-8{--cp-gutter-x:2rem}.g-sm-8,.gy-sm-8{--cp-gutter-y:2rem}.g-sm-9,.gx-sm-9{--cp-gutter-x:2.5rem}.g-sm-9,.gy-sm-9{--cp-gutter-y:2.5rem}.g-sm-10,.gx-sm-10{--cp-gutter-x:3rem}.g-sm-10,.gy-sm-10{--cp-gutter-y:3rem}}@media (min-width: 768px){.col-md{flex:1 0 0%}.row-cols-md-auto>*{flex:0 0 auto;width:auto}.row-cols-md-1>*{flex:0 0 auto;width:100%}.row-cols-md-2>*{flex:0 0 auto;width:50%}.row-cols-md-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-md-4>*{flex:0 0 auto;width:25%}.row-cols-md-5>*{flex:0 0 auto;width:20%}.row-cols-md-6>*{flex:0 0 auto;width:16.6666666667%}.col-md-auto{flex:0 0 auto;width:auto}.col-md-1{flex:0 0 auto;width:8.33333333%}.col-md-2{flex:0 0 auto;width:16.66666667%}.col-md-3{flex:0 0 auto;width:25%}.col-md-4{flex:0 0 auto;width:33.33333333%}.col-md-5{flex:0 0 auto;width:41.66666667%}.col-md-6{flex:0 0 auto;width:50%}.col-md-7{flex:0 0 auto;width:58.33333333%}.col-md-8{flex:0 0 auto;width:66.66666667%}.col-md-9{flex:0 0 auto;width:75%}.col-md-10{flex:0 0 auto;width:83.33333333%}.col-md-11{flex:0 0 auto;width:91.66666667%}.col-md-12{flex:0 0 auto;width:100%}[dir=\"ltr\"] .offset-md-0{margin-left:0}[dir=\"rtl\"] .offset-md-0{margin-right:0}[dir=\"ltr\"] .offset-md-1{margin-left:8.33333333%}[dir=\"rtl\"] .offset-md-1{margin-right:8.33333333%}[dir=\"ltr\"] .offset-md-2{margin-left:16.66666667%}[dir=\"rtl\"] .offset-md-2{margin-right:16.66666667%}[dir=\"ltr\"] .offset-md-3{margin-left:25%}[dir=\"rtl\"] .offset-md-3{margin-right:25%}[dir=\"ltr\"] .offset-md-4{margin-left:33.33333333%}[dir=\"rtl\"] .offset-md-4{margin-right:33.33333333%}[dir=\"ltr\"] .offset-md-5{margin-left:41.66666667%}[dir=\"rtl\"] .offset-md-5{margin-right:41.66666667%}[dir=\"ltr\"] .offset-md-6{margin-left:50%}[dir=\"rtl\"] .offset-md-6{margin-right:50%}[dir=\"ltr\"] .offset-md-7{margin-left:58.33333333%}[dir=\"rtl\"] .offset-md-7{margin-right:58.33333333%}[dir=\"ltr\"] .offset-md-8{margin-left:66.66666667%}[dir=\"rtl\"] .offset-md-8{margin-right:66.66666667%}[dir=\"ltr\"] .offset-md-9{margin-left:75%}[dir=\"rtl\"] .offset-md-9{margin-right:75%}[dir=\"ltr\"] .offset-md-10{margin-left:83.33333333%}[dir=\"rtl\"] .offset-md-10{margin-right:83.33333333%}[dir=\"ltr\"] .offset-md-11{margin-left:91.66666667%}[dir=\"rtl\"] .offset-md-11{margin-right:91.66666667%}.g-md-0,.gx-md-0{--cp-gutter-x:0}.g-md-0,.gy-md-0{--cp-gutter-y:0}.g-md-1,.gx-md-1{--cp-gutter-x:0.25rem}.g-md-1,.gy-md-1{--cp-gutter-y:0.25rem}.g-md-2,.gx-md-2{--cp-gutter-x:0.5rem}.g-md-2,.gy-md-2{--cp-gutter-y:0.5rem}.g-md-3,.gx-md-3{--cp-gutter-x:0.75rem}.g-md-3,.gy-md-3{--cp-gutter-y:0.75rem}.g-md-4,.gx-md-4{--cp-gutter-x:1rem}.g-md-4,.gy-md-4{--cp-gutter-y:1rem}.g-md-5,.gx-md-5{--cp-gutter-x:1.25rem}.g-md-5,.gy-md-5{--cp-gutter-y:1.25rem}.g-md-6,.gx-md-6{--cp-gutter-x:1.5rem}.g-md-6,.gy-md-6{--cp-gutter-y:1.5rem}.g-md-7,.gx-md-7{--cp-gutter-x:1.75rem}.g-md-7,.gy-md-7{--cp-gutter-y:1.75rem}.g-md-8,.gx-md-8{--cp-gutter-x:2rem}.g-md-8,.gy-md-8{--cp-gutter-y:2rem}.g-md-9,.gx-md-9{--cp-gutter-x:2.5rem}.g-md-9,.gy-md-9{--cp-gutter-y:2.5rem}.g-md-10,.gx-md-10{--cp-gutter-x:3rem}.g-md-10,.gy-md-10{--cp-gutter-y:3rem}}@media (min-width: 992px){.col-lg{flex:1 0 0%}.row-cols-lg-auto>*{flex:0 0 auto;width:auto}.row-cols-lg-1>*{flex:0 0 auto;width:100%}.row-cols-lg-2>*{flex:0 0 auto;width:50%}.row-cols-lg-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-lg-4>*{flex:0 0 auto;width:25%}.row-cols-lg-5>*{flex:0 0 auto;width:20%}.row-cols-lg-6>*{flex:0 0 auto;width:16.6666666667%}.col-lg-auto{flex:0 0 auto;width:auto}.col-lg-1{flex:0 0 auto;width:8.33333333%}.col-lg-2{flex:0 0 auto;width:16.66666667%}.col-lg-3{flex:0 0 auto;width:25%}.col-lg-4{flex:0 0 auto;width:33.33333333%}.col-lg-5{flex:0 0 auto;width:41.66666667%}.col-lg-6{flex:0 0 auto;width:50%}.col-lg-7{flex:0 0 auto;width:58.33333333%}.col-lg-8{flex:0 0 auto;width:66.66666667%}.col-lg-9{flex:0 0 auto;width:75%}.col-lg-10{flex:0 0 auto;width:83.33333333%}.col-lg-11{flex:0 0 auto;width:91.66666667%}.col-lg-12{flex:0 0 auto;width:100%}[dir=\"ltr\"] .offset-lg-0{margin-left:0}[dir=\"rtl\"] .offset-lg-0{margin-right:0}[dir=\"ltr\"] .offset-lg-1{margin-left:8.33333333%}[dir=\"rtl\"] .offset-lg-1{margin-right:8.33333333%}[dir=\"ltr\"] .offset-lg-2{margin-left:16.66666667%}[dir=\"rtl\"] .offset-lg-2{margin-right:16.66666667%}[dir=\"ltr\"] .offset-lg-3{margin-left:25%}[dir=\"rtl\"] .offset-lg-3{margin-right:25%}[dir=\"ltr\"] .offset-lg-4{margin-left:33.33333333%}[dir=\"rtl\"] .offset-lg-4{margin-right:33.33333333%}[dir=\"ltr\"] .offset-lg-5{margin-left:41.66666667%}[dir=\"rtl\"] .offset-lg-5{margin-right:41.66666667%}[dir=\"ltr\"] .offset-lg-6{margin-left:50%}[dir=\"rtl\"] .offset-lg-6{margin-right:50%}[dir=\"ltr\"] .offset-lg-7{margin-left:58.33333333%}[dir=\"rtl\"] .offset-lg-7{margin-right:58.33333333%}[dir=\"ltr\"] .offset-lg-8{margin-left:66.66666667%}[dir=\"rtl\"] .offset-lg-8{margin-right:66.66666667%}[dir=\"ltr\"] .offset-lg-9{margin-left:75%}[dir=\"rtl\"] .offset-lg-9{margin-right:75%}[dir=\"ltr\"] .offset-lg-10{margin-left:83.33333333%}[dir=\"rtl\"] .offset-lg-10{margin-right:83.33333333%}[dir=\"ltr\"] .offset-lg-11{margin-left:91.66666667%}[dir=\"rtl\"] .offset-lg-11{margin-right:91.66666667%}.g-lg-0,.gx-lg-0{--cp-gutter-x:0}.g-lg-0,.gy-lg-0{--cp-gutter-y:0}.g-lg-1,.gx-lg-1{--cp-gutter-x:0.25rem}.g-lg-1,.gy-lg-1{--cp-gutter-y:0.25rem}.g-lg-2,.gx-lg-2{--cp-gutter-x:0.5rem}.g-lg-2,.gy-lg-2{--cp-gutter-y:0.5rem}.g-lg-3,.gx-lg-3{--cp-gutter-x:0.75rem}.g-lg-3,.gy-lg-3{--cp-gutter-y:0.75rem}.g-lg-4,.gx-lg-4{--cp-gutter-x:1rem}.g-lg-4,.gy-lg-4{--cp-gutter-y:1rem}.g-lg-5,.gx-lg-5{--cp-gutter-x:1.25rem}.g-lg-5,.gy-lg-5{--cp-gutter-y:1.25rem}.g-lg-6,.gx-lg-6{--cp-gutter-x:1.5rem}.g-lg-6,.gy-lg-6{--cp-gutter-y:1.5rem}.g-lg-7,.gx-lg-7{--cp-gutter-x:1.75rem}.g-lg-7,.gy-lg-7{--cp-gutter-y:1.75rem}.g-lg-8,.gx-lg-8{--cp-gutter-x:2rem}.g-lg-8,.gy-lg-8{--cp-gutter-y:2rem}.g-lg-9,.gx-lg-9{--cp-gutter-x:2.5rem}.g-lg-9,.gy-lg-9{--cp-gutter-y:2.5rem}.g-lg-10,.gx-lg-10{--cp-gutter-x:3rem}.g-lg-10,.gy-lg-10{--cp-gutter-y:3rem}}@media (min-width: 1200px){.col-xl{flex:1 0 0%}.row-cols-xl-auto>*{flex:0 0 auto;width:auto}.row-cols-xl-1>*{flex:0 0 auto;width:100%}.row-cols-xl-2>*{flex:0 0 auto;width:50%}.row-cols-xl-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-xl-4>*{flex:0 0 auto;width:25%}.row-cols-xl-5>*{flex:0 0 auto;width:20%}.row-cols-xl-6>*{flex:0 0 auto;width:16.6666666667%}.col-xl-auto{flex:0 0 auto;width:auto}.col-xl-1{flex:0 0 auto;width:8.33333333%}.col-xl-2{flex:0 0 auto;width:16.66666667%}.col-xl-3{flex:0 0 auto;width:25%}.col-xl-4{flex:0 0 auto;width:33.33333333%}.col-xl-5{flex:0 0 auto;width:41.66666667%}.col-xl-6{flex:0 0 auto;width:50%}.col-xl-7{flex:0 0 auto;width:58.33333333%}.col-xl-8{flex:0 0 auto;width:66.66666667%}.col-xl-9{flex:0 0 auto;width:75%}.col-xl-10{flex:0 0 auto;width:83.33333333%}.col-xl-11{flex:0 0 auto;width:91.66666667%}.col-xl-12{flex:0 0 auto;width:100%}[dir=\"ltr\"] .offset-xl-0{margin-left:0}[dir=\"rtl\"] .offset-xl-0{margin-right:0}[dir=\"ltr\"] .offset-xl-1{margin-left:8.33333333%}[dir=\"rtl\"] .offset-xl-1{margin-right:8.33333333%}[dir=\"ltr\"] .offset-xl-2{margin-left:16.66666667%}[dir=\"rtl\"] .offset-xl-2{margin-right:16.66666667%}[dir=\"ltr\"] .offset-xl-3{margin-left:25%}[dir=\"rtl\"] .offset-xl-3{margin-right:25%}[dir=\"ltr\"] .offset-xl-4{margin-left:33.33333333%}[dir=\"rtl\"] .offset-xl-4{margin-right:33.33333333%}[dir=\"ltr\"] .offset-xl-5{margin-left:41.66666667%}[dir=\"rtl\"] .offset-xl-5{margin-right:41.66666667%}[dir=\"ltr\"] .offset-xl-6{margin-left:50%}[dir=\"rtl\"] .offset-xl-6{margin-right:50%}[dir=\"ltr\"] .offset-xl-7{margin-left:58.33333333%}[dir=\"rtl\"] .offset-xl-7{margin-right:58.33333333%}[dir=\"ltr\"] .offset-xl-8{margin-left:66.66666667%}[dir=\"rtl\"] .offset-xl-8{margin-right:66.66666667%}[dir=\"ltr\"] .offset-xl-9{margin-left:75%}[dir=\"rtl\"] .offset-xl-9{margin-right:75%}[dir=\"ltr\"] .offset-xl-10{margin-left:83.33333333%}[dir=\"rtl\"] .offset-xl-10{margin-right:83.33333333%}[dir=\"ltr\"] .offset-xl-11{margin-left:91.66666667%}[dir=\"rtl\"] .offset-xl-11{margin-right:91.66666667%}.g-xl-0,.gx-xl-0{--cp-gutter-x:0}.g-xl-0,.gy-xl-0{--cp-gutter-y:0}.g-xl-1,.gx-xl-1{--cp-gutter-x:0.25rem}.g-xl-1,.gy-xl-1{--cp-gutter-y:0.25rem}.g-xl-2,.gx-xl-2{--cp-gutter-x:0.5rem}.g-xl-2,.gy-xl-2{--cp-gutter-y:0.5rem}.g-xl-3,.gx-xl-3{--cp-gutter-x:0.75rem}.g-xl-3,.gy-xl-3{--cp-gutter-y:0.75rem}.g-xl-4,.gx-xl-4{--cp-gutter-x:1rem}.g-xl-4,.gy-xl-4{--cp-gutter-y:1rem}.g-xl-5,.gx-xl-5{--cp-gutter-x:1.25rem}.g-xl-5,.gy-xl-5{--cp-gutter-y:1.25rem}.g-xl-6,.gx-xl-6{--cp-gutter-x:1.5rem}.g-xl-6,.gy-xl-6{--cp-gutter-y:1.5rem}.g-xl-7,.gx-xl-7{--cp-gutter-x:1.75rem}.g-xl-7,.gy-xl-7{--cp-gutter-y:1.75rem}.g-xl-8,.gx-xl-8{--cp-gutter-x:2rem}.g-xl-8,.gy-xl-8{--cp-gutter-y:2rem}.g-xl-9,.gx-xl-9{--cp-gutter-x:2.5rem}.g-xl-9,.gy-xl-9{--cp-gutter-y:2.5rem}.g-xl-10,.gx-xl-10{--cp-gutter-x:3rem}.g-xl-10,.gy-xl-10{--cp-gutter-y:3rem}}@media (min-width: 1400px){.col-xxl{flex:1 0 0%}.row-cols-xxl-auto>*{flex:0 0 auto;width:auto}.row-cols-xxl-1>*{flex:0 0 auto;width:100%}.row-cols-xxl-2>*{flex:0 0 auto;width:50%}.row-cols-xxl-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-xxl-4>*{flex:0 0 auto;width:25%}.row-cols-xxl-5>*{flex:0 0 auto;width:20%}.row-cols-xxl-6>*{flex:0 0 auto;width:16.6666666667%}.col-xxl-auto{flex:0 0 auto;width:auto}.col-xxl-1{flex:0 0 auto;width:8.33333333%}.col-xxl-2{flex:0 0 auto;width:16.66666667%}.col-xxl-3{flex:0 0 auto;width:25%}.col-xxl-4{flex:0 0 auto;width:33.33333333%}.col-xxl-5{flex:0 0 auto;width:41.66666667%}.col-xxl-6{flex:0 0 auto;width:50%}.col-xxl-7{flex:0 0 auto;width:58.33333333%}.col-xxl-8{flex:0 0 auto;width:66.66666667%}.col-xxl-9{flex:0 0 auto;width:75%}.col-xxl-10{flex:0 0 auto;width:83.33333333%}.col-xxl-11{flex:0 0 auto;width:91.66666667%}.col-xxl-12{flex:0 0 auto;width:100%}[dir=\"ltr\"] .offset-xxl-0{margin-left:0}[dir=\"rtl\"] .offset-xxl-0{margin-right:0}[dir=\"ltr\"] .offset-xxl-1{margin-left:8.33333333%}[dir=\"rtl\"] .offset-xxl-1{margin-right:8.33333333%}[dir=\"ltr\"] .offset-xxl-2{margin-left:16.66666667%}[dir=\"rtl\"] .offset-xxl-2{margin-right:16.66666667%}[dir=\"ltr\"] .offset-xxl-3{margin-left:25%}[dir=\"rtl\"] .offset-xxl-3{margin-right:25%}[dir=\"ltr\"] .offset-xxl-4{margin-left:33.33333333%}[dir=\"rtl\"] .offset-xxl-4{margin-right:33.33333333%}[dir=\"ltr\"] .offset-xxl-5{margin-left:41.66666667%}[dir=\"rtl\"] .offset-xxl-5{margin-right:41.66666667%}[dir=\"ltr\"] .offset-xxl-6{margin-left:50%}[dir=\"rtl\"] .offset-xxl-6{margin-right:50%}[dir=\"ltr\"] .offset-xxl-7{margin-left:58.33333333%}[dir=\"rtl\"] .offset-xxl-7{margin-right:58.33333333%}[dir=\"ltr\"] .offset-xxl-8{margin-left:66.66666667%}[dir=\"rtl\"] .offset-xxl-8{margin-right:66.66666667%}[dir=\"ltr\"] .offset-xxl-9{margin-left:75%}[dir=\"rtl\"] .offset-xxl-9{margin-right:75%}[dir=\"ltr\"] .offset-xxl-10{margin-left:83.33333333%}[dir=\"rtl\"] .offset-xxl-10{margin-right:83.33333333%}[dir=\"ltr\"] .offset-xxl-11{margin-left:91.66666667%}[dir=\"rtl\"] .offset-xxl-11{margin-right:91.66666667%}.g-xxl-0,.gx-xxl-0{--cp-gutter-x:0}.g-xxl-0,.gy-xxl-0{--cp-gutter-y:0}.g-xxl-1,.gx-xxl-1{--cp-gutter-x:0.25rem}.g-xxl-1,.gy-xxl-1{--cp-gutter-y:0.25rem}.g-xxl-2,.gx-xxl-2{--cp-gutter-x:0.5rem}.g-xxl-2,.gy-xxl-2{--cp-gutter-y:0.5rem}.g-xxl-3,.gx-xxl-3{--cp-gutter-x:0.75rem}.g-xxl-3,.gy-xxl-3{--cp-gutter-y:0.75rem}.g-xxl-4,.gx-xxl-4{--cp-gutter-x:1rem}.g-xxl-4,.gy-xxl-4{--cp-gutter-y:1rem}.g-xxl-5,.gx-xxl-5{--cp-gutter-x:1.25rem}.g-xxl-5,.gy-xxl-5{--cp-gutter-y:1.25rem}.g-xxl-6,.gx-xxl-6{--cp-gutter-x:1.5rem}.g-xxl-6,.gy-xxl-6{--cp-gutter-y:1.5rem}.g-xxl-7,.gx-xxl-7{--cp-gutter-x:1.75rem}.g-xxl-7,.gy-xxl-7{--cp-gutter-y:1.75rem}.g-xxl-8,.gx-xxl-8{--cp-gutter-x:2rem}.g-xxl-8,.gy-xxl-8{--cp-gutter-y:2rem}.g-xxl-9,.gx-xxl-9{--cp-gutter-x:2.5rem}.g-xxl-9,.gy-xxl-9{--cp-gutter-y:2.5rem}.g-xxl-10,.gx-xxl-10{--cp-gutter-x:3rem}.g-xxl-10,.gy-xxl-10{--cp-gutter-y:3rem}}.card{--cp-card-spacer-y:1rem;--cp-card-spacer-x:1rem;--cp-card-title-spacer-y:0.5rem;--cp-card-border-width:1px;--cp-card-border-color:var(--cp-border-color-translucent);--cp-card-border-radius:0.25rem;--cp-card-inner-border-radius:calc(0.25rem - 1px);--cp-card-cap-padding-y:0.5rem;--cp-card-cap-padding-x:1rem;--cp-card-cap-bg:rgba(0, 0, 0, 0.03);--cp-card-bg:#fff;--cp-card-img-overlay-padding:1rem;--cp-card-group-margin:0.75rem;position:relative;display:flex;flex-direction:column;min-width:0;height:var(--cp-card-height);word-wrap:break-word;background-color:var(--cp-card-bg);background-clip:border-box;border:var(--cp-card-border-width) solid var(--cp-card-border-color);border-radius:var(--cp-card-border-radius)}.card>hr{margin-right:0;margin-left:0}.card>.list-group{border-top:inherit;border-bottom:inherit}.card>.list-group:first-child{border-top-width:0;border-top-left-radius:var(--cp-card-inner-border-radius);border-top-right-radius:var(--cp-card-inner-border-radius)}.card>.list-group:last-child{border-bottom-width:0;border-bottom-right-radius:var(--cp-card-inner-border-radius);border-bottom-left-radius:var(--cp-card-inner-border-radius)}.card>.card-header+.list-group,.card>.list-group+.card-footer{border-top:0}.card-body{flex:1 1 auto;padding:var(--cp-card-spacer-y) var(--cp-card-spacer-x);color:var(--cp-card-color)}.card-title{margin-bottom:var(--cp-card-title-spacer-y)}.card-subtitle{margin-top:calc(-0.5 * var(--cp-card-title-spacer-y));margin-bottom:0}.card-text:last-child{margin-bottom:0}[dir=\"ltr\"] .card-link+.card-link{margin-left:var(--cp-card-spacer-x)}[dir=\"rtl\"] .card-link+.card-link{margin-right:var(--cp-card-spacer-x)}.card-header{padding:var(--cp-card-cap-padding-y) var(--cp-card-cap-padding-x);margin-bottom:0;color:var(--cp-card-cap-color);background-color:var(--cp-card-cap-bg);border-bottom:var(--cp-card-border-width) solid var(--cp-card-border-color)}.card-header:first-child{border-radius:var(--cp-card-inner-border-radius) var(--cp-card-inner-border-radius) 0 0}.card-footer{padding:var(--cp-card-cap-padding-y) var(--cp-card-cap-padding-x);color:var(--cp-card-cap-color);background-color:var(--cp-card-cap-bg);border-top:var(--cp-card-border-width) solid var(--cp-card-border-color)}.card-footer:last-child{border-radius:0 0 var(--cp-card-inner-border-radius) var(--cp-card-inner-border-radius)}.card-header-tabs{margin-right:calc(-0.5 * var(--cp-card-cap-padding-x));margin-bottom:calc(-1 * var(--cp-card-cap-padding-y));margin-left:calc(-0.5 * var(--cp-card-cap-padding-x));border-bottom:0}.card-header-tabs .nav-link.active{background-color:var(--cp-card-bg);border-bottom-color:var(--cp-card-bg)}.card-header-pills{margin-right:calc(-0.5 * var(--cp-card-cap-padding-x));margin-left:calc(-0.5 * var(--cp-card-cap-padding-x))}.card-img-overlay{position:absolute;top:0;right:0;bottom:0;left:0;padding:var(--cp-card-img-overlay-padding);border-radius:var(--cp-card-inner-border-radius)}.card-img,.card-img-top,.card-img-bottom{width:100%}.card-img,.card-img-top{border-top-left-radius:var(--cp-card-inner-border-radius);border-top-right-radius:var(--cp-card-inner-border-radius)}.card-img,.card-img-bottom{border-bottom-right-radius:var(--cp-card-inner-border-radius);border-bottom-left-radius:var(--cp-card-inner-border-radius)}.card-group>.card{margin-bottom:var(--cp-card-group-margin)}@media (min-width: 576px){.card-group{display:flex;flex-flow:row wrap}.card-group>.card{flex:1 0 0%;margin-bottom:0}[dir=\"ltr\"] .card-group>.card+.card{margin-left:0;border-left:0}[dir=\"rtl\"] .card-group>.card+.card{margin-right:0;border-right:0}[dir=\"ltr\"] .card-group>.card:not(:last-child){border-top-right-radius:0;border-bottom-right-radius:0}[dir=\"rtl\"] .card-group>.card:not(:last-child){border-top-left-radius:0;border-bottom-left-radius:0}[dir=\"ltr\"] .card-group>.card:not(:last-child) .card-img-top,[dir=\"ltr\"] .card-group>.card:not(:last-child) .card-header{border-top-right-radius:0}[dir=\"rtl\"] .card-group>.card:not(:last-child) .card-img-top,[dir=\"rtl\"] .card-group>.card:not(:last-child) .card-header{border-top-left-radius:0}[dir=\"ltr\"] .card-group>.card:not(:last-child) .card-img-bottom,[dir=\"ltr\"] .card-group>.card:not(:last-child) .card-footer{border-bottom-right-radius:0}[dir=\"rtl\"] .card-group>.card:not(:last-child) .card-img-bottom,[dir=\"rtl\"] .card-group>.card:not(:last-child) .card-footer{border-bottom-left-radius:0}[dir=\"ltr\"] .card-group>.card:not(:first-child){border-top-left-radius:0;border-bottom-left-radius:0}[dir=\"rtl\"] .card-group>.card:not(:first-child){border-top-right-radius:0;border-bottom-right-radius:0}[dir=\"ltr\"] .card-group>.card:not(:first-child) .card-img-top,[dir=\"ltr\"] .card-group>.card:not(:first-child) .card-header{border-top-left-radius:0}[dir=\"rtl\"] .card-group>.card:not(:first-child) .card-img-top,[dir=\"rtl\"] .card-group>.card:not(:first-child) .card-header{border-top-right-radius:0}[dir=\"ltr\"] .card-group>.card:not(:first-child) .card-img-bottom,[dir=\"ltr\"] .card-group>.card:not(:first-child) .card-footer{border-bottom-left-radius:0}[dir=\"rtl\"] .card-group>.card:not(:first-child) .card-img-bottom,[dir=\"rtl\"] .card-group>.card:not(:first-child) .card-footer{border-bottom-right-radius:0}}.card{border-radius:0.125rem}.card-raised{box-shadow:0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);transition:all 0.15s ease-in;border-color:transparent}.card-raised:active,.card-raised:focus,.card-raised:hover{box-shadow:0 0.5rem 1rem rgba(0, 0, 0, 0.15)}.card-list .card{display:flex;flex-direction:column;justify-content:space-between;height:100%}.btn{--cp-btn-padding-x:0.75rem;--cp-btn-padding-y:0.375rem;--cp-btn-font-size:1rem;--cp-btn-font-weight:400;--cp-btn-line-height:1.5;--cp-btn-color:#243746;--cp-btn-bg:transparent;--cp-btn-border-width:1px;--cp-btn-border-color:transparent;--cp-btn-border-radius:0.25rem;--cp-btn-hover-border-color:transparent;--cp-btn-box-shadow:inset 0 1px 0 rgba(255, 255, 255, 0.15), 0 1px 1px rgba(0, 0, 0, 0.075);--cp-btn-disabled-opacity:0.65;--cp-btn-focus-box-shadow:0 0 0 0.25rem rgba(var(--cp-btn-focus-shadow-rgb), .5);display:inline-block;padding:var(--cp-btn-padding-y) var(--cp-btn-padding-x);font-family:var(--cp-btn-font-family);font-size:var(--cp-btn-font-size);font-weight:var(--cp-btn-font-weight);line-height:var(--cp-btn-line-height);color:var(--cp-btn-color);text-align:center;text-decoration:none;vertical-align:middle;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;border:var(--cp-btn-border-width) solid var(--cp-btn-border-color);border-radius:var(--cp-btn-border-radius);background-color:var(--cp-btn-bg);transition:color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out}@media (prefers-reduced-motion: reduce){.btn{transition:none}}.btn:hover{color:var(--cp-btn-hover-color);background-color:var(--cp-btn-hover-bg);border-color:var(--cp-btn-hover-border-color)}.btn-check+.btn:hover{color:var(--cp-btn-color);background-color:var(--cp-btn-bg);border-color:var(--cp-btn-border-color)}.btn:focus-visible{color:var(--cp-btn-hover-color);background-color:var(--cp-btn-hover-bg);border-color:var(--cp-btn-hover-border-color);outline:0;box-shadow:var(--cp-btn-focus-box-shadow)}.btn-check:focus-visible+.btn{border-color:var(--cp-btn-hover-border-color);outline:0;box-shadow:var(--cp-btn-focus-box-shadow)}.btn-check:checked+.btn,:not(.btn-check)+.btn:active,.btn:first-child:active,.btn.active,.btn.show{color:var(--cp-btn-active-color);background-color:var(--cp-btn-active-bg);border-color:var(--cp-btn-active-border-color)}.btn-check:checked+.btn:focus-visible,:not(.btn-check)+.btn:active:focus-visible,.btn:first-child:active:focus-visible,.btn.active:focus-visible,.btn.show:focus-visible{box-shadow:var(--cp-btn-focus-box-shadow)}.btn:disabled,.btn.disabled,fieldset:disabled .btn{color:var(--cp-btn-disabled-color);pointer-events:none;background-color:var(--cp-btn-disabled-bg);border-color:var(--cp-btn-disabled-border-color);opacity:var(--cp-btn-disabled-opacity)}.btn-primary{--cp-btn-color:#fff;--cp-btn-bg:#003da6;--cp-btn-border-color:#003da6;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#00348d;--cp-btn-hover-border-color:#003185;--cp-btn-focus-shadow-rgb:38, 90, 179;--cp-btn-active-color:#fff;--cp-btn-active-bg:#003185;--cp-btn-active-border-color:#002e7d;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#003da6;--cp-btn-disabled-border-color:#003da6}.btn-success{--cp-btn-color:#fff;--cp-btn-bg:#198754;--cp-btn-border-color:#198754;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#157347;--cp-btn-hover-border-color:#146c43;--cp-btn-focus-shadow-rgb:60, 153, 110;--cp-btn-active-color:#fff;--cp-btn-active-bg:#146c43;--cp-btn-active-border-color:#13653f;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#198754;--cp-btn-disabled-border-color:#198754}.btn-info{--cp-btn-color:#000;--cp-btn-bg:#0dcaf0;--cp-btn-border-color:#0dcaf0;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#31d2f2;--cp-btn-hover-border-color:#25cff2;--cp-btn-focus-shadow-rgb:11, 172, 204;--cp-btn-active-color:#000;--cp-btn-active-bg:#3dd5f3;--cp-btn-active-border-color:#25cff2;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#000;--cp-btn-disabled-bg:#0dcaf0;--cp-btn-disabled-border-color:#0dcaf0}.btn-warning{--cp-btn-color:#000;--cp-btn-bg:#ffc107;--cp-btn-border-color:#ffc107;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#ffca2c;--cp-btn-hover-border-color:#ffc720;--cp-btn-focus-shadow-rgb:217, 164, 6;--cp-btn-active-color:#000;--cp-btn-active-bg:#ffcd39;--cp-btn-active-border-color:#ffc720;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#000;--cp-btn-disabled-bg:#ffc107;--cp-btn-disabled-border-color:#ffc107}.btn-danger{--cp-btn-color:#fff;--cp-btn-bg:#dc3545;--cp-btn-border-color:#dc3545;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#bb2d3b;--cp-btn-hover-border-color:#b02a37;--cp-btn-focus-shadow-rgb:225, 83, 97;--cp-btn-active-color:#fff;--cp-btn-active-bg:#b02a37;--cp-btn-active-border-color:#a52834;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#dc3545;--cp-btn-disabled-border-color:#dc3545}.btn-light{--cp-btn-color:#000;--cp-btn-bg:#fafafa;--cp-btn-border-color:#fafafa;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#d5d5d5;--cp-btn-hover-border-color:#c8c8c8;--cp-btn-focus-shadow-rgb:213, 213, 213;--cp-btn-active-color:#000;--cp-btn-active-bg:#c8c8c8;--cp-btn-active-border-color:#bcbcbc;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#000;--cp-btn-disabled-bg:#fafafa;--cp-btn-disabled-border-color:#fafafa}.btn-dark{--cp-btn-color:#fff;--cp-btn-bg:#243746;--cp-btn-border-color:#243746;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#455562;--cp-btn-hover-border-color:#3a4b59;--cp-btn-focus-shadow-rgb:69, 85, 98;--cp-btn-active-color:#fff;--cp-btn-active-bg:#505f6b;--cp-btn-active-border-color:#3a4b59;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#243746;--cp-btn-disabled-border-color:#243746}.btn-accent{--cp-btn-color:#000;--cp-btn-bg:#de5c2e;--cp-btn-border-color:#de5c2e;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#e3744d;--cp-btn-hover-border-color:#e16c43;--cp-btn-focus-shadow-rgb:189, 78, 39;--cp-btn-active-color:#000;--cp-btn-active-bg:#e57d58;--cp-btn-active-border-color:#e16c43;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#000;--cp-btn-disabled-bg:#de5c2e;--cp-btn-disabled-border-color:#de5c2e}.btn-tertiary{--cp-btn-color:#fff;--cp-btn-bg:#202654;--cp-btn-border-color:#202654;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#1b2047;--cp-btn-hover-border-color:#1a1e43;--cp-btn-focus-shadow-rgb:65, 71, 110;--cp-btn-active-color:#fff;--cp-btn-active-bg:#1a1e43;--cp-btn-active-border-color:#181d3f;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#202654;--cp-btn-disabled-border-color:#202654}.btn-outline-primary{--cp-btn-color:#003da6;--cp-btn-border-color:#003da6;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#003da6;--cp-btn-hover-border-color:#003da6;--cp-btn-focus-shadow-rgb:0, 61, 166;--cp-btn-active-color:#fff;--cp-btn-active-bg:#003da6;--cp-btn-active-border-color:#003da6;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#003da6;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#003da6;--cp-gradient:none}.btn-outline-success{--cp-btn-color:#198754;--cp-btn-border-color:#198754;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#198754;--cp-btn-hover-border-color:#198754;--cp-btn-focus-shadow-rgb:25, 135, 84;--cp-btn-active-color:#fff;--cp-btn-active-bg:#198754;--cp-btn-active-border-color:#198754;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#198754;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#198754;--cp-gradient:none}.btn-outline-info{--cp-btn-color:#0dcaf0;--cp-btn-border-color:#0dcaf0;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#0dcaf0;--cp-btn-hover-border-color:#0dcaf0;--cp-btn-focus-shadow-rgb:13, 202, 240;--cp-btn-active-color:#000;--cp-btn-active-bg:#0dcaf0;--cp-btn-active-border-color:#0dcaf0;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#0dcaf0;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#0dcaf0;--cp-gradient:none}.btn-outline-warning{--cp-btn-color:#ffc107;--cp-btn-border-color:#ffc107;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#ffc107;--cp-btn-hover-border-color:#ffc107;--cp-btn-focus-shadow-rgb:255, 193, 7;--cp-btn-active-color:#000;--cp-btn-active-bg:#ffc107;--cp-btn-active-border-color:#ffc107;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#ffc107;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#ffc107;--cp-gradient:none}.btn-outline-danger{--cp-btn-color:#dc3545;--cp-btn-border-color:#dc3545;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#dc3545;--cp-btn-hover-border-color:#dc3545;--cp-btn-focus-shadow-rgb:220, 53, 69;--cp-btn-active-color:#fff;--cp-btn-active-bg:#dc3545;--cp-btn-active-border-color:#dc3545;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#dc3545;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#dc3545;--cp-gradient:none}.btn-outline-light{--cp-btn-color:#fafafa;--cp-btn-border-color:#fafafa;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#fafafa;--cp-btn-hover-border-color:#fafafa;--cp-btn-focus-shadow-rgb:250, 250, 250;--cp-btn-active-color:#000;--cp-btn-active-bg:#fafafa;--cp-btn-active-border-color:#fafafa;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fafafa;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#fafafa;--cp-gradient:none}.btn-outline-dark{--cp-btn-color:#243746;--cp-btn-border-color:#243746;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#243746;--cp-btn-hover-border-color:#243746;--cp-btn-focus-shadow-rgb:36, 55, 70;--cp-btn-active-color:#fff;--cp-btn-active-bg:#243746;--cp-btn-active-border-color:#243746;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#243746;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#243746;--cp-gradient:none}.btn-outline-accent{--cp-btn-color:#de5c2e;--cp-btn-border-color:#de5c2e;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#de5c2e;--cp-btn-hover-border-color:#de5c2e;--cp-btn-focus-shadow-rgb:222, 92, 46;--cp-btn-active-color:#000;--cp-btn-active-bg:#de5c2e;--cp-btn-active-border-color:#de5c2e;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#de5c2e;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#de5c2e;--cp-gradient:none}.btn-outline-tertiary{--cp-btn-color:#202654;--cp-btn-border-color:#202654;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#202654;--cp-btn-hover-border-color:#202654;--cp-btn-focus-shadow-rgb:32, 38, 84;--cp-btn-active-color:#fff;--cp-btn-active-bg:#202654;--cp-btn-active-border-color:#202654;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#202654;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#202654;--cp-gradient:none}.btn-link,.btn.icon-btn-link{--cp-btn-font-weight:400;--cp-btn-color:var(--cp-link-color);--cp-btn-bg:transparent;--cp-btn-border-color:transparent;--cp-btn-hover-color:var(--cp-link-hover-color);--cp-btn-hover-border-color:transparent;--cp-btn-active-color:var(--cp-link-hover-color);--cp-btn-active-border-color:transparent;--cp-btn-disabled-color:#6d7983;--cp-btn-disabled-border-color:transparent;--cp-btn-box-shadow:none;--cp-btn-focus-shadow-rgb:38, 90, 179;text-decoration:underline}.btn-link:focus-visible,.btn.icon-btn-link:focus-visible{color:var(--cp-btn-color)}.btn-link:hover,.btn.icon-btn-link:hover{color:var(--cp-btn-hover-color)}.btn-lg{--cp-btn-padding-y:0.5rem;--cp-btn-padding-x:1rem;--cp-btn-font-size:1.25rem;--cp-btn-border-radius:0.5rem}.btn-sm{--cp-btn-padding-y:0.25rem;--cp-btn-padding-x:0.5rem;--cp-btn-font-size:0.875rem;--cp-btn-border-radius:0.125rem}.btn{min-width:160px}.btn.btn-round{display:flex;align-items:center;justify-content:center;text-decoration:none;cursor:pointer;padding:var(--cp-spacer-2);border-radius:100%;border:1px solid var(--cp-tertiary, #202654);width:40px;height:40px;min-width:40px;min-height:40px;background:var(--cp-component-bg, #fff);color:var(--cp-tertiary, #202654)}.btn.btn-round:hover,.btn.btn-round:focus,.btn.btn-round:active{background:var(--cp-tertiary, #202654);color:#fff}.btn.btn-link,.btn.icon-btn-link{min-width:initial}.btn.btn-shrink{min-width:unset}.btn.icon-btn-link{display:inline-flex;align-items:center;text-decoration:none}.btn .ri-lg{font-size:1.3333em;line-height:0.75em;vertical-align:-0.18em}.btn-sm .ri-sm{vertical-align:-1px}.btn.disabled,.btn[disabled]{pointer-events:all;cursor:not-allowed}.icon-btn-link-text{text-decoration:underline}:host{display:block}.showcase-container{min-height:250px;margin-bottom:var(--cp-spacer-3);padding:0}.cp-banner-header__btn-close{position:absolute;top:0;font-size:1.25rem;color:#000;text-decoration:none;padding:0;z-index:2}[dir=\"ltr\"] .cp-banner-header__btn-close{right:5px}[dir=\"rtl\"] .cp-banner-header__btn-close{left:5px}";

    const locale$z = getLocaleInstance();
    const CpFeatureShowcase$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        /**
         * State of the banner.
         */
        this.isOpen = true;
        /**
         * Sends banner dismissal event to Mixpanel
         */
        this.trackDismiss = (feature) => {
          var _a;
          (_a = window["mixpanel"]) === null || _a === void 0 ? void 0 : _a.track(`Feature-Showcase-Dismissed`, {
            campaign: `${feature}`,
          });
        };
      }
      /**
       * Calls all the functions and sets all the variables needed to close the banner.
       */
      async closeShowcaseBanner() {
        this.trackDismiss("Sitejet");
        const request = new UapiRequest({
          namespace: "Personalization",
          method: "set",
          arguments: [
            new Argument("personalization", {
              "cp-feature-showcase_dismissed": 1,
            }),
          ],
          config: {
            json: true,
          },
        });
        await UapiService.post(request)
          .then(uapiResponse => {
          if (uapiResponse.hasErrors) {
            throw uapiResponse.errors;
          }
          else {
            this.isOpen = false;
          }
          return uapiResponse;
        })
          .catch(errors => {
          if (!Array.isArray(errors)) {
            errors = [errors];
          }
          errors.forEach(error => console.error(`Error while saving dismissal preference: ${error.message}`));
        });
      }
      /**
       * Gets the showcase items to display only if they are enabled in the feature list.
       */
      getAvailableShowcaseItems() {
        return appFeatureCheck([SitejetInfo.Key]);
      }
      render() {
        if (this.isOpen && this.getAvailableShowcaseItems().length) {
          return (h(Host, null, h("cp-style-reset", null, h("cp-dir", null, h("div", { class: "card showcase-container" }, h("button", { id: "cp-bannerClose", type: "button", class: "btn btn-link cp-banner-header__btn-close", "aria-label": locale$z.maketext("Close"), onClick: () => this.closeShowcaseBanner() }, h("cp-icon", { name: "close-line", size: IconSize.lg, mode: IconMode.Centered })), h("div", { class: "content-body" }, h("cp-feature-showcase-content", null)))))));
        }
      }
      static get style() { return cpFeatureShowcaseCss; }
    };

    const cpFeatureShowcaseContentCss = ".btn{--cp-btn-padding-x:0.75rem;--cp-btn-padding-y:0.375rem;--cp-btn-font-size:1rem;--cp-btn-font-weight:400;--cp-btn-line-height:1.5;--cp-btn-color:#243746;--cp-btn-bg:transparent;--cp-btn-border-width:1px;--cp-btn-border-color:transparent;--cp-btn-border-radius:0.25rem;--cp-btn-hover-border-color:transparent;--cp-btn-box-shadow:inset 0 1px 0 rgba(255, 255, 255, 0.15), 0 1px 1px rgba(0, 0, 0, 0.075);--cp-btn-disabled-opacity:0.65;--cp-btn-focus-box-shadow:0 0 0 0.25rem rgba(var(--cp-btn-focus-shadow-rgb), .5);display:inline-block;padding:var(--cp-btn-padding-y) var(--cp-btn-padding-x);font-family:var(--cp-btn-font-family);font-size:var(--cp-btn-font-size);font-weight:var(--cp-btn-font-weight);line-height:var(--cp-btn-line-height);color:var(--cp-btn-color);text-align:center;text-decoration:none;vertical-align:middle;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;border:var(--cp-btn-border-width) solid var(--cp-btn-border-color);border-radius:var(--cp-btn-border-radius);background-color:var(--cp-btn-bg);transition:color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out}@media (prefers-reduced-motion: reduce){.btn{transition:none}}.btn:hover{color:var(--cp-btn-hover-color);background-color:var(--cp-btn-hover-bg);border-color:var(--cp-btn-hover-border-color)}.btn-check+.btn:hover{color:var(--cp-btn-color);background-color:var(--cp-btn-bg);border-color:var(--cp-btn-border-color)}.btn:focus-visible{color:var(--cp-btn-hover-color);background-color:var(--cp-btn-hover-bg);border-color:var(--cp-btn-hover-border-color);outline:0;box-shadow:var(--cp-btn-focus-box-shadow)}.btn-check:focus-visible+.btn{border-color:var(--cp-btn-hover-border-color);outline:0;box-shadow:var(--cp-btn-focus-box-shadow)}.btn-check:checked+.btn,:not(.btn-check)+.btn:active,.btn:first-child:active,.btn.active,.btn.show{color:var(--cp-btn-active-color);background-color:var(--cp-btn-active-bg);border-color:var(--cp-btn-active-border-color)}.btn-check:checked+.btn:focus-visible,:not(.btn-check)+.btn:active:focus-visible,.btn:first-child:active:focus-visible,.btn.active:focus-visible,.btn.show:focus-visible{box-shadow:var(--cp-btn-focus-box-shadow)}.btn:disabled,.btn.disabled,fieldset:disabled .btn{color:var(--cp-btn-disabled-color);pointer-events:none;background-color:var(--cp-btn-disabled-bg);border-color:var(--cp-btn-disabled-border-color);opacity:var(--cp-btn-disabled-opacity)}.btn-primary{--cp-btn-color:#fff;--cp-btn-bg:#003da6;--cp-btn-border-color:#003da6;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#00348d;--cp-btn-hover-border-color:#003185;--cp-btn-focus-shadow-rgb:38, 90, 179;--cp-btn-active-color:#fff;--cp-btn-active-bg:#003185;--cp-btn-active-border-color:#002e7d;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#003da6;--cp-btn-disabled-border-color:#003da6}.btn-success{--cp-btn-color:#fff;--cp-btn-bg:#198754;--cp-btn-border-color:#198754;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#157347;--cp-btn-hover-border-color:#146c43;--cp-btn-focus-shadow-rgb:60, 153, 110;--cp-btn-active-color:#fff;--cp-btn-active-bg:#146c43;--cp-btn-active-border-color:#13653f;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#198754;--cp-btn-disabled-border-color:#198754}.btn-info{--cp-btn-color:#000;--cp-btn-bg:#0dcaf0;--cp-btn-border-color:#0dcaf0;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#31d2f2;--cp-btn-hover-border-color:#25cff2;--cp-btn-focus-shadow-rgb:11, 172, 204;--cp-btn-active-color:#000;--cp-btn-active-bg:#3dd5f3;--cp-btn-active-border-color:#25cff2;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#000;--cp-btn-disabled-bg:#0dcaf0;--cp-btn-disabled-border-color:#0dcaf0}.btn-warning{--cp-btn-color:#000;--cp-btn-bg:#ffc107;--cp-btn-border-color:#ffc107;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#ffca2c;--cp-btn-hover-border-color:#ffc720;--cp-btn-focus-shadow-rgb:217, 164, 6;--cp-btn-active-color:#000;--cp-btn-active-bg:#ffcd39;--cp-btn-active-border-color:#ffc720;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#000;--cp-btn-disabled-bg:#ffc107;--cp-btn-disabled-border-color:#ffc107}.btn-danger{--cp-btn-color:#fff;--cp-btn-bg:#dc3545;--cp-btn-border-color:#dc3545;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#bb2d3b;--cp-btn-hover-border-color:#b02a37;--cp-btn-focus-shadow-rgb:225, 83, 97;--cp-btn-active-color:#fff;--cp-btn-active-bg:#b02a37;--cp-btn-active-border-color:#a52834;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#dc3545;--cp-btn-disabled-border-color:#dc3545}.btn-light{--cp-btn-color:#000;--cp-btn-bg:#fafafa;--cp-btn-border-color:#fafafa;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#d5d5d5;--cp-btn-hover-border-color:#c8c8c8;--cp-btn-focus-shadow-rgb:213, 213, 213;--cp-btn-active-color:#000;--cp-btn-active-bg:#c8c8c8;--cp-btn-active-border-color:#bcbcbc;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#000;--cp-btn-disabled-bg:#fafafa;--cp-btn-disabled-border-color:#fafafa}.btn-dark{--cp-btn-color:#fff;--cp-btn-bg:#243746;--cp-btn-border-color:#243746;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#455562;--cp-btn-hover-border-color:#3a4b59;--cp-btn-focus-shadow-rgb:69, 85, 98;--cp-btn-active-color:#fff;--cp-btn-active-bg:#505f6b;--cp-btn-active-border-color:#3a4b59;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#243746;--cp-btn-disabled-border-color:#243746}.btn-accent{--cp-btn-color:#000;--cp-btn-bg:#de5c2e;--cp-btn-border-color:#de5c2e;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#e3744d;--cp-btn-hover-border-color:#e16c43;--cp-btn-focus-shadow-rgb:189, 78, 39;--cp-btn-active-color:#000;--cp-btn-active-bg:#e57d58;--cp-btn-active-border-color:#e16c43;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#000;--cp-btn-disabled-bg:#de5c2e;--cp-btn-disabled-border-color:#de5c2e}.btn-tertiary{--cp-btn-color:#fff;--cp-btn-bg:#202654;--cp-btn-border-color:#202654;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#1b2047;--cp-btn-hover-border-color:#1a1e43;--cp-btn-focus-shadow-rgb:65, 71, 110;--cp-btn-active-color:#fff;--cp-btn-active-bg:#1a1e43;--cp-btn-active-border-color:#181d3f;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#202654;--cp-btn-disabled-border-color:#202654}.btn-outline-primary{--cp-btn-color:#003da6;--cp-btn-border-color:#003da6;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#003da6;--cp-btn-hover-border-color:#003da6;--cp-btn-focus-shadow-rgb:0, 61, 166;--cp-btn-active-color:#fff;--cp-btn-active-bg:#003da6;--cp-btn-active-border-color:#003da6;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#003da6;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#003da6;--cp-gradient:none}.btn-outline-success{--cp-btn-color:#198754;--cp-btn-border-color:#198754;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#198754;--cp-btn-hover-border-color:#198754;--cp-btn-focus-shadow-rgb:25, 135, 84;--cp-btn-active-color:#fff;--cp-btn-active-bg:#198754;--cp-btn-active-border-color:#198754;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#198754;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#198754;--cp-gradient:none}.btn-outline-info{--cp-btn-color:#0dcaf0;--cp-btn-border-color:#0dcaf0;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#0dcaf0;--cp-btn-hover-border-color:#0dcaf0;--cp-btn-focus-shadow-rgb:13, 202, 240;--cp-btn-active-color:#000;--cp-btn-active-bg:#0dcaf0;--cp-btn-active-border-color:#0dcaf0;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#0dcaf0;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#0dcaf0;--cp-gradient:none}.btn-outline-warning{--cp-btn-color:#ffc107;--cp-btn-border-color:#ffc107;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#ffc107;--cp-btn-hover-border-color:#ffc107;--cp-btn-focus-shadow-rgb:255, 193, 7;--cp-btn-active-color:#000;--cp-btn-active-bg:#ffc107;--cp-btn-active-border-color:#ffc107;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#ffc107;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#ffc107;--cp-gradient:none}.btn-outline-danger{--cp-btn-color:#dc3545;--cp-btn-border-color:#dc3545;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#dc3545;--cp-btn-hover-border-color:#dc3545;--cp-btn-focus-shadow-rgb:220, 53, 69;--cp-btn-active-color:#fff;--cp-btn-active-bg:#dc3545;--cp-btn-active-border-color:#dc3545;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#dc3545;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#dc3545;--cp-gradient:none}.btn-outline-light{--cp-btn-color:#fafafa;--cp-btn-border-color:#fafafa;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#fafafa;--cp-btn-hover-border-color:#fafafa;--cp-btn-focus-shadow-rgb:250, 250, 250;--cp-btn-active-color:#000;--cp-btn-active-bg:#fafafa;--cp-btn-active-border-color:#fafafa;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fafafa;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#fafafa;--cp-gradient:none}.btn-outline-dark{--cp-btn-color:#243746;--cp-btn-border-color:#243746;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#243746;--cp-btn-hover-border-color:#243746;--cp-btn-focus-shadow-rgb:36, 55, 70;--cp-btn-active-color:#fff;--cp-btn-active-bg:#243746;--cp-btn-active-border-color:#243746;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#243746;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#243746;--cp-gradient:none}.btn-outline-accent{--cp-btn-color:#de5c2e;--cp-btn-border-color:#de5c2e;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#de5c2e;--cp-btn-hover-border-color:#de5c2e;--cp-btn-focus-shadow-rgb:222, 92, 46;--cp-btn-active-color:#000;--cp-btn-active-bg:#de5c2e;--cp-btn-active-border-color:#de5c2e;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#de5c2e;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#de5c2e;--cp-gradient:none}.btn-outline-tertiary{--cp-btn-color:#202654;--cp-btn-border-color:#202654;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#202654;--cp-btn-hover-border-color:#202654;--cp-btn-focus-shadow-rgb:32, 38, 84;--cp-btn-active-color:#fff;--cp-btn-active-bg:#202654;--cp-btn-active-border-color:#202654;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#202654;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#202654;--cp-gradient:none}.btn-link,.btn.icon-btn-link{--cp-btn-font-weight:400;--cp-btn-color:var(--cp-link-color);--cp-btn-bg:transparent;--cp-btn-border-color:transparent;--cp-btn-hover-color:var(--cp-link-hover-color);--cp-btn-hover-border-color:transparent;--cp-btn-active-color:var(--cp-link-hover-color);--cp-btn-active-border-color:transparent;--cp-btn-disabled-color:#6d7983;--cp-btn-disabled-border-color:transparent;--cp-btn-box-shadow:none;--cp-btn-focus-shadow-rgb:38, 90, 179;text-decoration:underline}.btn-link:focus-visible,.btn.icon-btn-link:focus-visible{color:var(--cp-btn-color)}.btn-link:hover,.btn.icon-btn-link:hover{color:var(--cp-btn-hover-color)}.btn-lg{--cp-btn-padding-y:0.5rem;--cp-btn-padding-x:1rem;--cp-btn-font-size:1.25rem;--cp-btn-border-radius:0.5rem}.btn-sm{--cp-btn-padding-y:0.25rem;--cp-btn-padding-x:0.5rem;--cp-btn-font-size:0.875rem;--cp-btn-border-radius:0.125rem}.btn{min-width:160px}.btn.btn-round{display:flex;align-items:center;justify-content:center;text-decoration:none;cursor:pointer;padding:var(--cp-spacer-2);border-radius:100%;border:1px solid var(--cp-tertiary, #202654);width:40px;height:40px;min-width:40px;min-height:40px;background:var(--cp-component-bg, #fff);color:var(--cp-tertiary, #202654)}.btn.btn-round:hover,.btn.btn-round:focus,.btn.btn-round:active{background:var(--cp-tertiary, #202654);color:#fff}.btn.btn-link,.btn.icon-btn-link{min-width:initial}.btn.btn-shrink{min-width:unset}.btn.icon-btn-link{display:inline-flex;align-items:center;text-decoration:none}.btn .ri-lg{font-size:1.3333em;line-height:0.75em;vertical-align:-0.18em}.btn-sm .ri-sm{vertical-align:-1px}.btn.disabled,.btn[disabled]{pointer-events:all;cursor:not-allowed}.icon-btn-link-text{text-decoration:underline}:host{display:block}.grid-content-container{display:grid;min-height:250px;width:100%;grid-template-columns:repeat(3, 1fr);grid-template-areas:\"area1 area2a area2b\"}.grid-item-1{grid-area:area1;display:flex;align-items:center;justify-content:center}[dir=\"ltr\"] .grid-item-1{padding-left:var(--cp-spacer-5)}[dir=\"rtl\"] .grid-item-1{padding-right:var(--cp-spacer-5)}.grid-item-1 img{width:377px;height:auto;border-radius:0.25rem}.grid-item-2a{display:flex;flex-direction:column;flex-wrap:nowrap;align-content:center;justify-content:space-between;grid-area:area2a;padding:var(--cp-spacer-5)}.grid-item-2b{grid-area:area2b;padding:0;display:flex;align-items:flex-start;justify-content:space-between;overflow:hidden}.grid-item-2b img{opacity:0.6;height:250px;-o-object-fit:cover;object-fit:cover}@media (max-width: 1199.98px){.grid-content-container{grid-template-columns:1fr 1fr;grid-template-areas:\"area2a area2b\" \"area1 area1\"}.grid-item-2a{grid-area:area2a}.grid-item-2b{grid-area:area2b}.grid-item-1{grid-area:area1}#interface-photo-container{padding:var(--cp-spacer-5)}}@media (max-width: 575.98px){.grid-item-1 img{width:100%;height:auto}}.cta-heading{text-align:center;font-size:1rem;font-weight:700;line-height:normal;margin:0}.cta-sjb-logo{max-width:185px;align-self:center}.cta-bullet-points{font-size:0.75rem;margin:0;padding:0}.cta-button{width:251px;align-self:center}";

    const locale$y = getLocaleInstance();
    const CpFeatureShowcaseContent$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        /**
         * Builds path to production asset location
         */
        this.getImagePath = (imgKey, imgExt) => {
          return getAssetPath(`./assets/sitejet-promo/${imgKey}.${imgExt}`);
        };
        /**
         * Sends banner 'click-through' event to Mixpanel
         */
        this.sitejetCtaClick = (feature) => {
          var _a, _b;
          (_a = window["mixpanel"]) === null || _a === void 0 ? void 0 : _a.track(`Feature-Showcase-Click-Through`, {
            campaign: `${feature}`,
          });
          if (!this.sitejetAppEntry) {
            // this should never happen since sitejet should be available in cp-feature-showcase.tsx to render this.
            console.error("Sitejet is not available.");
            return;
          }
          window.location.href = `${state.directoryPrefix}${(_b = this.sitejetAppEntry) === null || _b === void 0 ? void 0 : _b.url}`;
        };
        /**
         * Sends banner 'seen' event to Mixpanel
         */
        this.promoViewed = (feature) => {
          var _a;
          (_a = window["mixpanel"]) === null || _a === void 0 ? void 0 : _a.track(`Feature-Showcase-Seen`, {
            campaign: `${feature}`,
          });
        };
        /**
         * Sitejet builder svg logo
         */
        this.sitejetBuilderLogo = (h("svg", { xmlns: "http://www.w3.org/2000/svg", "data-name": "Layer 2", viewBox: "0 0 908.6 257.5", class: "cta-sjb-logo" }, h("g", { "data-name": "Layer 2" }, h("g", { "data-name": "Layer 1-2" }, h("path", { d: "M465.1 27.3V1.9H355.8v143h109.3v-25.4h-84.2V86.2h64.2V60.8h-64.2V27.3h84.2zM149.3 1.9h24.8v142.9h-24.8zm179.8 0H200.8v25.4h51.6v117.6h25.1V27.3h51.6V1.9zM95.4 35.6l14.5-20.8S90.8 0 61.5 0C26.7 0 3.4 18.9 3.4 42.8c0 52.5 85 36.7 85 62.6 0 9.8-8.8 16.6-29.4 16.6-25.6 0-45.1-18-45.1-18L0 124.3s20.8 22.8 59.8 22.8c34.4 0 56.1-19.7 56.1-42.6 0-51.1-85-35.9-85-62.9 0-9.8 10.9-16.5 28.3-16.5 20 0 36.2 10.5 36.2 10.5ZM908.6 1.9H780.3v25.4h51.6v117.6H857V27.3h51.6V1.9zM753.7 27.3V1.9H644.3v143h109.4v-25.4h-84.2V86.2h64.2V60.8h-64.2V27.3h84.2zM604.5 1.9h-95.9v25.5h70.6v62c0 20-8.4 32.6-34.5 32.6-21.2 0-39.5-18-39.5-18l-13.9 20.3s22.3 22.8 55.4 22.8c36.4 0 57.5-20.5 57.5-54.3l.3-90.9Z", style: { fill: "#ff6c2c", strokeWidth: "0" } }), h("path", { d: "M427.5 256.2v-69.3H460c6.3 0 11.2 1.6 14.9 4.9 3.7 3.3 5.5 7.5 5.5 12.8 0 4.2-1.2 7.7-3.7 10.5s-5.5 4.7-9.1 5.4c3.9.6 7.2 2.5 10 5.8s4.2 7.1 4.2 11.2c0 5.6-1.9 10.1-5.6 13.6s-8.9 5.1-15.5 5.1h-33.2Zm9.1-39.2h21.9c4 0 7.1-1 9.3-3.1s3.3-4.7 3.3-8-1.1-5.9-3.3-8.1-5.3-3.2-9.2-3.2h-21.9V217h-.1Zm0 31.5h22.3c4.2 0 7.5-1.1 10-3.2s3.6-5.1 3.6-8.7c0-3.4-1.2-6.2-3.5-8.5-2.4-2.3-5.7-3.4-10-3.4h-22.3v23.8h-.1Zm65.1-61.6h9.1v42.2c0 6.4 1.8 11.5 5.4 15.2s8.7 5.5 15.3 5.5 11.7-1.8 15.3-5.5 5.4-8.7 5.4-15.2V187h9.1v42.3c0 8.8-2.5 15.7-7.6 20.7s-12.5 7.5-22.1 7.5-17.1-2.5-22.1-7.5c-5.1-5-7.6-11.9-7.6-20.6l-.2-42.5Zm82.1 69.3v-69.3h9.1v69.3h-9.1Zm31.6 0v-69.3h9.1v61.6h33.9v7.7h-43Zm61.2 0v-69.3h24.9c11.2 0 20.2 3.3 27.1 9.9s10.3 14.9 10.3 24.8-3.4 18.3-10.3 24.8-15.9 9.8-27.1 9.8h-24.9Zm9.1-7.7h15.9c8.6 0 15.4-2.6 20.5-7.7s7.5-11.5 7.5-19.2-2.5-14.2-7.4-19.3c-5-5.1-11.8-7.7-20.6-7.7h-15.9v53.9Zm72.9 7.7v-69.3h47.8v7.7h-38.7V217h38v7.7h-38v23.9h38.7v7.7l-47.8-.1Zm109.9 0-18.6-27.5h-14.5v27.5h-9.1v-69.3h29.3c6.8 0 12.3 1.9 16.5 5.7s6.3 8.9 6.3 15.2-1.8 10.7-5.5 14.2-8.1 5.5-13.5 5.9l19.7 28.3h-10.6Zm-3.5-57.9c-2.7-2.5-6.2-3.7-10.5-3.7h-19.1v26.5h19.1c4.3 0 7.8-1.2 10.5-3.7s4-5.7 4-9.6-1.3-7-4-9.5Z", style: { strokeWidth: "0", fill: "#221f1f" } })))));
      }
      componentWillLoad() {
        const appInfo = appFeatureCheck([SitejetInfo.Key]);
        this.sitejetAppEntry = appInfo.length ? appInfo[0] : undefined;
      }
      componentDidLoad() {
        this.promoViewed("Sitejet");
      }
      render() {
        return (h(Host, null, h("cp-style-reset", null, h("cp-dir", null, h("div", { class: "grid-content-container" }, h("div", { class: "grid-item-1", id: "interface-photo-container" }, h("img", { src: this.getImagePath("sj-editor", "png"), alt: locale$y.maketext("Sitejet main interface") })), h("div", { class: "grid-item-2a" }, h("p", { class: "cta-heading" }, locale$y.maketext("Create your website with")), this.sitejetBuilderLogo, h("ul", { class: "cta-bullet-points" }, h("li", null, locale$y.maketext("Ready-made templates")), h("li", null, locale$y.maketext("Drag-and-drop functionality")), h("li", null, locale$y.maketext("Add your own code")), h("li", null, locale$y.maketext("Customize everything"))), h("a", { role: "button", class: "cta-button btn btn-primary", onClick: () => this.sitejetCtaClick("Sitejet") }, locale$y.maketext("Click to get started"))), h("div", { class: "grid-item-2b" }, h("img", { src: this.getImagePath("sj-templates", "png"), alt: locale$y.maketext("Collection of sitejet templates") })))))));
      }
      static get style() { return cpFeatureShowcaseContentCss; }
    };

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    var AppName;
    (function (AppName) {
      AppName["Cpanel"] = "cpanel";
      AppName["Whm"] = "whm";
      AppName["Webmail"] = "webmail";
    })(AppName || (AppName = {}));

    /*
    # Copyright 2022 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    const locale$x = getLocaleInstance();
    class SharedUtilsService {
      /**
       * Constructs a url that can be used by the users of the cPanel interface to give feedback.
       * Returns the url including it's associated data.
       */
      getFeedbackLinkDataForCpanel(cpanelFullVersion, companyId, cpanelAppKey) {
        const url = "https://webpros.typeform.com/to/QNd7MgTZ", source = "cpanel-feedback";
        return {
          url: `${url}?utm_source=${source}&cpanel_productversion=${cpanelFullVersion}&companyid=${companyId}&cpanel_appkey=${cpanelAppKey}`,
          target: source,
          title: locale$x.maketext("Give Feedback"),
        };
      }
    }
    const sharedUtils = new SharedUtilsService();

    /**
    # cpanel - ui/web-components/src/components/footer/footer-links.ts
    #                                                  Copyright 2022 cPanel, L.L.C.
    #                                                           All rights reserved.
    # copyright@cpanel.net                                         http://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
     */
    const locale$w = getLocaleInstance();
    function getFooterLinks(appName, directoryPrefix, docLink, helpLink) {
      return appName === AppName.Cpanel
        ? getcPanelLinks(directoryPrefix, docLink, helpLink)
        : getWHMLinks(directoryPrefix);
    }
    function getLogoTitle(appName) {
      return appName === AppName.Cpanel ? locale$w.maketext("cPanel") : locale$w.maketext("WHM");
    }
    const COMMON_LINKS = [
      {
        id: "lnkFooterPrivacy",
        href: "https://go.cpanel.net/privacy",
        target: "privacyPolicy",
        title: locale$w.maketext("Privacy Policy"),
      },
    ];
    function getcPanelLinks(prefix, docLink, helpLink) {
      const feedbackLinkData = sharedUtils.getFeedbackLinkDataForCpanel(state.cpanelFullVersion, state.companyId, state.cpanelAppKey);
      let links = [
        {
          id: "lnkFooterHome",
          href: prefix + "index.html",
          title: locale$w.maketext("Home"),
          target: "_self",
        },
        {
          id: "lnkFooterTrademark",
          href: prefix + "trademarks.html",
          title: locale$w.maketext("Trademarks"),
          target: "_self",
        },
        ...COMMON_LINKS,
        {
          id: "lnkFooterDocs",
          href: docLink || "https://go.cpanel.net/cpaneldocsHome",
          target: "docs",
          title: locale$w.maketext("Documentation"),
        },
        {
          id: "lnkFooterFeedback",
          href: feedbackLinkData.url,
          target: feedbackLinkData.target,
          title: feedbackLinkData.title,
        },
      ];
      if (helpLink) {
        links.push({
          id: "lnkFooterHelp",
          href: helpLink,
          target: "help",
          title: locale$w.maketext("Help"),
        });
      }
      return links;
    }
    function getWHMLinks(prefix) {
      return [
        {
          id: "lnkFooterHome",
          href: prefix,
          title: locale$w.maketext("Home"),
          target: "_self",
        },
        {
          id: "lnkFooterTrademark",
          href: `${prefix}/scripts10/trademarks`,
          title: locale$w.maketext("Trademarks"),
          target: "_self",
        },
        ...COMMON_LINKS,
        {
          id: "lnkFooterNews",
          href: `${prefix}/cgi/news.cgi`,
          target: "_self",
          title: locale$w.maketext("News"),
        },
        {
          id: "lnkFooterDocs",
          href: "https://go.cpanel.net/whmdocs",
          target: "docs",
          title: locale$w.maketext("Documentation"),
        },
        {
          id: "lnkFooterFaq",
          href: "https://go.cpanel.net/allfaq",
          target: "support_faq",
          title: locale$w.maketext("[asis,cPanel amp() WHM] FAQ[comment,footer link text]"),
        },
        {
          id: "lnkFooterSupport",
          href: "https://go.cpanel.net/cpforum",
          target: "support_forums",
          title: locale$w.maketext("Support Forums"),
        },
        {
          id: "lnkFootercPUniversity",
          href: "https://university.cpanel.net/",
          target: "cp_university",
          title: locale$w.maketext("[asis,cPanel] University"),
        },
      ];
    }

    const cpFooterCss = ":host{display:block}.footer__version{font-size:0.875rem;color:var(--cp-gray-dark, #3c4d5a)}.footer__logo-section{display:flex;flex-direction:row;align-items:center}[dir=\"ltr\"] .footer__logo-section{padding:0 var(--cp-spacer-3) var(--cp-spacer-2) 0}[dir=\"rtl\"] .footer__logo-section{padding:0 0 var(--cp-spacer-2) var(--cp-spacer-3)}.footer{display:flex;justify-content:space-between;align-items:center;flex-wrap:wrap}.footer-links{display:flex;list-style:none;padding:0;flex-wrap:wrap}@media (max-width: 767.98px){.footer-links{flex-wrap:wrap}}.footer-links li{margin-bottom:var(--cp-spacer-2)}@media (max-width: 767.98px){.footer-links li{margin-bottom:var(--cp-spacer-2)}}.footer-links__item{display:inline-block;white-space:nowrap;text-decoration:none}[dir=\"ltr\"] .footer-links__item{padding:var(--cp-spacer-2) var(--cp-spacer-3) var(--cp-spacer-2) 0}[dir=\"rtl\"] .footer-links__item{padding:var(--cp-spacer-2) 0 var(--cp-spacer-2) var(--cp-spacer-3)}.footer-links__item:hover,.footer-links__item:active,.footer-links__item:focus{text-decoration:underline}";

    const CpFooter$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        /**
         * Source of the logo to be passed into the cp-logo component.
         */
        this.logoSrc = "";
      }
      componentWillLoad() {
        this._appName = state.appName;
        this._directoryPrefix = state.directoryPrefix;
        this._footerLinks = getFooterLinks(this._appName, this._directoryPrefix, this.docLink, this.helpLink);
        this._logoTitle = getLogoTitle(this._appName);
        if (this._appName === AppName.Whm) {
          this.logoSrc = state.whmLogos.WhmDarkLg;
        }
      }
      render() {
        return (h(Host, null, h("cp-style-reset", null, h("cp-dir", null, h("div", { class: "footer" }, h("div", { class: "footer__logo-section" }, h("cp-logo", { id: "cp-logo", class: "footer__logo", "link-target": "_blank", "logo-src": this.logoSrc, "logo-link-href": "https://www.cpanel.net", "logo-id": "imgPoweredByCpanel", "logo-title": this._logoTitle }), h("span", { class: "footer__version", id: "txtCpanelVersion" }, this.version)), h("div", null, h("ul", { class: "footer-links" }, this._footerLinks.map(footerLink => (h("li", null, h("a", { id: footerLink.id, href: footerLink.href, class: "footer-links__item", target: footerLink.target, innerHTML: footerLink.title })))))))))));
      }
      static get style() { return cpFooterCss; }
    };

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    /**
     * Returns true if it is a DNS only cPanel installation and the app being accessed is WHM.
     */
    function isDnsOnly() {
      var _a;
      return ((_a = window["COMMON"]) === null || _a === void 0 ? void 0 : _a.isDnsOnly) && state.appName === AppName.Whm;
    }

    const cpHeaderCss = ".header{background:var(--cp-header-bg, #fff);box-shadow:0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);height:60px;display:flex;justify-content:flex-end;align-items:center;padding:0 var(--cp-spacer-7)}@media (max-width: 767.98px){.header{justify-content:space-between;padding:0 var(--cp-spacer-5)}}@media (max-width: 575.98px){.header{padding:0 var(--cp-spacer-2)}}.header--with-logo{justify-content:space-between}.header__logo-section{display:none}@media (max-width: 767.98px){.header__logo-section{display:flex;align-items:baseline;padding:var(--cp-spacer-2);gap:var(--cp-spacer-3)}}.header__logo-section--full-width{display:flex;align-items:baseline}.header__controls,.header__controls--whm{display:flex;width:100%;min-width:315px;justify-content:flex-end;gap:var(--cp-spacer-3)}@media (max-width: 575.98px){.header__controls,.header__controls--whm{min-width:140px}}@media (max-width: 575.98px){.header__controls--whm{min-width:175px}}.header-controls__search{max-width:400px}.header-controls__button{border:1px solid var(--cp-tertiary, #202654);text-decoration:none;cursor:pointer;color:inherit;background:transparent;height:100%;width:100%;padding:var(--cp-spacer-2);display:flex;align-items:center;justify-content:center;box-sizing:border-box;border-radius:50%}[dir=\"ltr\"] .cp-header__dns-only{margin-left:calc(-1 * var(--cp-spacer-3))}[dir=\"rtl\"] .cp-header__dns-only{margin-right:calc(-1 * var(--cp-spacer-3))}@media (max-width: 575.98px){.hide-on-sm{display:none}[dir=\"ltr\"] .hide-on-sm{margin-right:0}[dir=\"rtl\"] .hide-on-sm{margin-left:0}}@media (min-width: 576px){.only-show-sm{display:none}}@media (max-width: 767.98px){.hide-on-md{display:none}[dir=\"ltr\"] .hide-on-md{margin-right:0}[dir=\"rtl\"] .hide-on-md{margin-left:0}}.mobile-search-flex{flex-grow:1;justify-content:flex-start;gap:0}[dir=\"ltr\"] .header__more-controls{text-align:right}[dir=\"rtl\"] .header__more-controls{text-align:left}.header__more-controls .header__whm__load-average__link{text-decoration:none;color:#003da6}";

    const locale$v = getLocaleInstance();
    const CpHeader$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        /**
         * Flags if the header should display the input for searching. Only used in mobile displays
         */
        this.isMobileSearch = false;
        /**
         * base64-encoded SVG or an url
         */
        this.logoSrc = "";
        /**
         * Optional logo description. This is needed because the logo can be custom and the alt
         * text needs to accurately describe the logo displayed.
         * Note: header only displays logo on mobile.
         */
        this.logoAltText = "";
        /**
         * Show the mobile search elements and hide the rest of the header.
         */
        this.showMobileSearch = () => {
          this.isMobileSearch = true;
          this.focusSearch = true;
        };
      }
      componentWillLoad() {
        this._appName = state.appName;
        if (this._appName === AppName.Whm) {
          this.logoSrc = state.whmLogos.WhmDarkLg;
        }
      }
      /**
       * Update the state of the header on mobile, and triggers search input focus, if required.
       */
      toggleMobileSearch() {
        this.isMobileSearch = !this.isMobileSearch;
        if (this.isMobileSearch) {
          this.focusSearch = true;
        }
      }
      /**
       * Clear out the focus trigger when necessary.
       */
      searchInputFocusChange(e) {
        // If the search input is focused, we no longer need to trigger the focus
        if (e.detail.isFocused) {
          this.focusSearch = false;
        }
      }
      /**
       * CSS class to append to a DOM element for mobile search functionality.
       */
      get mobileSearchClass() {
        return this.isMobileSearch ? "hide-on-sm" : "";
      }
      /**
       * CSS classes to append to search control that change based on the viewport.
       */
      get mobileSearchControlClass() {
        return (this.isMobileSearch ? "" : "hide-on-sm") + " mobile-search-flex header-controls__search";
      }
      /**
       * CSS classes for the header control section
       */
      get headerControlClasses() {
        const mobileSearchClass = this.isMobileSearch ? "mobile-search-flex" : "";
        const headerControls = `header__controls${this._appName === AppName.Whm ? "--whm" : ""}`;
        return `${mobileSearchClass} ${headerControls}`;
      }
      /**
       * Get the product specific header body components
       */
      get headerBodyProductComponent() {
        return this._appName === AppName.Cpanel ? (h("cpanel-header", { "is-mobile-search": this.isMobileSearch, "integrations-info": this.integrationsInfo })) : (h("whm-header", { "is-mobile-search": this.isMobileSearch }));
      }
      render() {
        return (h(Host, null, h("cp-style-reset", null, h("cp-dir", null, h("div", { class: "header" }, h("div", { class: this.mobileSearchClass + " header__logo-section" }, h("cp-main-menu-header-control", null)), h("div", { class: this.mobileSearchClass + " header__logo-section" }, h("cp-logo", { "logo-link-href": this._appName === AppName.Whm ? "/" : null, "logo-src": this.logoSrc, "logo-alt-text": this.logoAltText }), isDnsOnly() && h("cp-dns-only", { class: "cp-header__dns-only hide-on-sm" })), h("div", { class: this.headerControlClasses }, h("cp-header-control", { class: this.mobileSearchClass + " only-show-sm header-controls" }, h("button", { id: "search-button", class: "header-controls__button", "aria-label": locale$v.maketext("Search"), onClick: this.showMobileSearch }, h("cp-icon", { name: "search-line", size: IconSize.sm, mode: IconMode.Centered }))), h("cp-header-search-control", { "focus-search": this.focusSearch, "is-mobile-search": this.isMobileSearch, class: this.mobileSearchControlClass }), this.headerBodyProductComponent))))));
      }
      get el() { return this; }
      static get style() { return cpHeaderCss; }
    };

    const cpHeaderControlCss = ".cp-header-control{display:block;color:var(--cp-tertiary, #202654);background:#fff;border-radius:50%;position:relative;min-width:32px;min-height:32px;width:32px;height:32px}.cp-header-control:hover,.cp-header-control:focus,.cp-header-control:active{background:var(--cp-tertiary, #202654);color:var(--cp--tertiary-contrast, #e5e7e9)}.notification-badge{width:0.5rem;height:0.5rem;position:absolute;top:0;border-radius:50%;border:1px solid var(--cp-header-bg, #fff);background:var(--cp-danger, #dc3545)}[dir=\"ltr\"] .notification-badge{right:0}[dir=\"rtl\"] .notification-badge{left:0}.notification-badge.show{display:block}";

    const CpHeaderControl$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        /**
         * Set to true if we need to draw the user's attention
         */
        this.showBadge = false;
      }
      render() {
        return (h(Host, { class: "cp-header-control" }, h("slot", null), this.showBadge && h("div", { class: "notification-badge" })));
      }
      static get style() { return cpHeaderControlCss; }
    };

    /**
     * Get the current notification count for the logged in user.
     * @returns A promise that resolves with the number of notifications for the logged in user.
     */
    async function fetchNotificationCount() {
      const request = new UapiRequest({
        namespace: "Notifications",
        method: "get_notifications_count",
      }).generate();
      const pathBuilder = new ApplicationPath(new LocationService());
      const fullRequestUrl = pathBuilder.buildTokenPath(request.url);
      return fetch(fullRequestUrl)
        .then(response => response.json())
        .then(response => {
        const resp = new UapiResponse(response);
        if (!resp.status) {
          throw resp.messages.map(message => message.message);
        }
        return resp.data;
      })
        .catch(errors => {
        if (!Array.isArray(errors)) {
          errors = [errors];
        }
        errors.forEach(message => console.warn(`Error loading notifications: ${message}`));
      });
    }

    const cpHeaderNotificationsControlCss = ".cp-header-notifications-control{display:block}.cp-header-notifications-control a{border:1px solid var(--cp-tertiary, #202654);text-decoration:none;cursor:pointer;color:inherit;background:transparent;height:100%;width:100%;padding:var(--cp-spacer-2);display:flex;align-items:center;justify-content:center;box-sizing:border-box;border-radius:50%}";

    const locale$u = getLocaleInstance();
    const CpNotificationsHeaderControl = class extends H {
      constructor() {
        super();
        this.__registerHost();
        /**
         * Used to determine if the badge appears on the "Notifications" badge
         */
        this.hasNotifications = false;
      }
      componentWillRender() {
        this.directoryPrefix = state.directoryPrefix;
      }
      render() {
        return (h(Host, { class: "cp-header-notifications-control" }, h("cp-header-control", { "show-badge": this.hasNotifications }, h("a", { id: "notifications-link", href: this.directoryPrefix + "notifications/index.html.tt", "aria-label": locale$u.maketext("Notifications") }, h("cp-icon", { name: "notification-3-line", size: IconSize.sm, mode: IconMode.Centered })))));
      }
      // We are intentionally not returning the promise or using async/await because
      // either case will trigger Stencil to wait until the promise has resolved before
      // rendering. There is no need to delay component rendering and we will add the
      // badge once the information is available.
      componentWillLoad() {
        var _a;
        this.pendingForcePasswordChange = ((_a = window["PAGE"]) === null || _a === void 0 ? void 0 : _a.skipNotificationsCheck) || false;
        if (this.pendingForcePasswordChange)
          return;
        fetchNotificationCount().then(notificationCount => (this.hasNotifications = !!notificationCount));
      }
      static get style() { return cpHeaderNotificationsControlCss; }
    };

    /**
     * Fuse.js v6.6.2 - Lightweight fuzzy-search (http://fusejs.io)
     *
     * Copyright (c) 2022 Kiro Risk (http://kiro.me)
     * All Rights Reserved. Apache Software License 2.0
     *
     * http://www.apache.org/licenses/LICENSE-2.0
     */

    function isArray(value) {
      return !Array.isArray
        ? getTag(value) === '[object Array]'
        : Array.isArray(value)
    }

    // Adapted from: https://github.com/lodash/lodash/blob/master/.internal/baseToString.js
    const INFINITY = 1 / 0;
    function baseToString(value) {
      // Exit early for strings to avoid a performance hit in some environments.
      if (typeof value == 'string') {
        return value
      }
      let result = value + '';
      return result == '0' && 1 / value == -INFINITY ? '-0' : result
    }

    function toString$1(value) {
      return value == null ? '' : baseToString(value)
    }

    function isString(value) {
      return typeof value === 'string'
    }

    function isNumber(value) {
      return typeof value === 'number'
    }

    // Adapted from: https://github.com/lodash/lodash/blob/master/isBoolean.js
    function isBoolean(value) {
      return (
        value === true ||
        value === false ||
        (isObjectLike(value) && getTag(value) == '[object Boolean]')
      )
    }

    function isObject(value) {
      return typeof value === 'object'
    }

    // Checks if `value` is object-like.
    function isObjectLike(value) {
      return isObject(value) && value !== null
    }

    function isDefined(value) {
      return value !== undefined && value !== null
    }

    function isBlank(value) {
      return !value.trim().length
    }

    // Gets the `toStringTag` of `value`.
    // Adapted from: https://github.com/lodash/lodash/blob/master/.internal/getTag.js
    function getTag(value) {
      return value == null
        ? value === undefined
          ? '[object Undefined]'
          : '[object Null]'
        : Object.prototype.toString.call(value)
    }

    const EXTENDED_SEARCH_UNAVAILABLE = 'Extended search is not available';

    const INCORRECT_INDEX_TYPE = "Incorrect 'index' type";

    const LOGICAL_SEARCH_INVALID_QUERY_FOR_KEY = (key) =>
      `Invalid value for key ${key}`;

    const PATTERN_LENGTH_TOO_LARGE = (max) =>
      `Pattern length exceeds max of ${max}.`;

    const MISSING_KEY_PROPERTY = (name) => `Missing ${name} property in key`;

    const INVALID_KEY_WEIGHT_VALUE = (key) =>
      `Property 'weight' in key '${key}' must be a positive integer`;

    const hasOwn = Object.prototype.hasOwnProperty;

    class KeyStore {
      constructor(keys) {
        this._keys = [];
        this._keyMap = {};

        let totalWeight = 0;

        keys.forEach((key) => {
          let obj = createKey(key);

          totalWeight += obj.weight;

          this._keys.push(obj);
          this._keyMap[obj.id] = obj;

          totalWeight += obj.weight;
        });

        // Normalize weights so that their sum is equal to 1
        this._keys.forEach((key) => {
          key.weight /= totalWeight;
        });
      }
      get(keyId) {
        return this._keyMap[keyId]
      }
      keys() {
        return this._keys
      }
      toJSON() {
        return JSON.stringify(this._keys)
      }
    }

    function createKey(key) {
      let path = null;
      let id = null;
      let src = null;
      let weight = 1;
      let getFn = null;

      if (isString(key) || isArray(key)) {
        src = key;
        path = createKeyPath(key);
        id = createKeyId(key);
      } else {
        if (!hasOwn.call(key, 'name')) {
          throw new Error(MISSING_KEY_PROPERTY('name'))
        }

        const name = key.name;
        src = name;

        if (hasOwn.call(key, 'weight')) {
          weight = key.weight;

          if (weight <= 0) {
            throw new Error(INVALID_KEY_WEIGHT_VALUE(name))
          }
        }

        path = createKeyPath(name);
        id = createKeyId(name);
        getFn = key.getFn;
      }

      return { path, id, weight, src, getFn }
    }

    function createKeyPath(key) {
      return isArray(key) ? key : key.split('.')
    }

    function createKeyId(key) {
      return isArray(key) ? key.join('.') : key
    }

    function get$1(obj, path) {
      let list = [];
      let arr = false;

      const deepGet = (obj, path, index) => {
        if (!isDefined(obj)) {
          return
        }
        if (!path[index]) {
          // If there's no path left, we've arrived at the object we care about.
          list.push(obj);
        } else {
          let key = path[index];

          const value = obj[key];

          if (!isDefined(value)) {
            return
          }

          // If we're at the last value in the path, and if it's a string/number/bool,
          // add it to the list
          if (
            index === path.length - 1 &&
            (isString(value) || isNumber(value) || isBoolean(value))
          ) {
            list.push(toString$1(value));
          } else if (isArray(value)) {
            arr = true;
            // Search each item in the array.
            for (let i = 0, len = value.length; i < len; i += 1) {
              deepGet(value[i], path, index + 1);
            }
          } else if (path.length) {
            // An object. Recurse further.
            deepGet(value, path, index + 1);
          }
        }
      };

      // Backwards compatibility (since path used to be a string)
      deepGet(obj, isString(path) ? path.split('.') : path, 0);

      return arr ? list : list[0]
    }

    const MatchOptions = {
      // Whether the matches should be included in the result set. When `true`, each record in the result
      // set will include the indices of the matched characters.
      // These can consequently be used for highlighting purposes.
      includeMatches: false,
      // When `true`, the matching function will continue to the end of a search pattern even if
      // a perfect match has already been located in the string.
      findAllMatches: false,
      // Minimum number of characters that must be matched before a result is considered a match
      minMatchCharLength: 1
    };

    const BasicOptions = {
      // When `true`, the algorithm continues searching to the end of the input even if a perfect
      // match is found before the end of the same input.
      isCaseSensitive: false,
      // When true, the matching function will continue to the end of a search pattern even if
      includeScore: false,
      // List of properties that will be searched. This also supports nested properties.
      keys: [],
      // Whether to sort the result list, by score
      shouldSort: true,
      // Default sort function: sort by ascending score, ascending index
      sortFn: (a, b) =>
        a.score === b.score ? (a.idx < b.idx ? -1 : 1) : a.score < b.score ? -1 : 1
    };

    const FuzzyOptions = {
      // Approximately where in the text is the pattern expected to be found?
      location: 0,
      // At what point does the match algorithm give up. A threshold of '0.0' requires a perfect match
      // (of both letters and location), a threshold of '1.0' would match anything.
      threshold: 0.6,
      // Determines how close the match must be to the fuzzy location (specified above).
      // An exact letter match which is 'distance' characters away from the fuzzy location
      // would score as a complete mismatch. A distance of '0' requires the match be at
      // the exact location specified, a threshold of '1000' would require a perfect match
      // to be within 800 characters of the fuzzy location to be found using a 0.8 threshold.
      distance: 100
    };

    const AdvancedOptions = {
      // When `true`, it enables the use of unix-like search commands
      useExtendedSearch: false,
      // The get function to use when fetching an object's properties.
      // The default will search nested paths *ie foo.bar.baz*
      getFn: get$1,
      // When `true`, search will ignore `location` and `distance`, so it won't matter
      // where in the string the pattern appears.
      // More info: https://fusejs.io/concepts/scoring-theory.html#fuzziness-score
      ignoreLocation: false,
      // When `true`, the calculation for the relevance score (used for sorting) will
      // ignore the field-length norm.
      // More info: https://fusejs.io/concepts/scoring-theory.html#field-length-norm
      ignoreFieldNorm: false,
      // The weight to determine how much field length norm effects scoring.
      fieldNormWeight: 1
    };

    var Config$1 = {
      ...BasicOptions,
      ...MatchOptions,
      ...FuzzyOptions,
      ...AdvancedOptions
    };

    const SPACE = /[^ ]+/g;

    // Field-length norm: the shorter the field, the higher the weight.
    // Set to 3 decimals to reduce index size.
    function norm(weight = 1, mantissa = 3) {
      const cache = new Map();
      const m = Math.pow(10, mantissa);

      return {
        get(value) {
          const numTokens = value.match(SPACE).length;

          if (cache.has(numTokens)) {
            return cache.get(numTokens)
          }

          // Default function is 1/sqrt(x), weight makes that variable
          const norm = 1 / Math.pow(numTokens, 0.5 * weight);

          // In place of `toFixed(mantissa)`, for faster computation
          const n = parseFloat(Math.round(norm * m) / m);

          cache.set(numTokens, n);

          return n
        },
        clear() {
          cache.clear();
        }
      }
    }

    class FuseIndex {
      constructor({
        getFn = Config$1.getFn,
        fieldNormWeight = Config$1.fieldNormWeight
      } = {}) {
        this.norm = norm(fieldNormWeight, 3);
        this.getFn = getFn;
        this.isCreated = false;

        this.setIndexRecords();
      }
      setSources(docs = []) {
        this.docs = docs;
      }
      setIndexRecords(records = []) {
        this.records = records;
      }
      setKeys(keys = []) {
        this.keys = keys;
        this._keysMap = {};
        keys.forEach((key, idx) => {
          this._keysMap[key.id] = idx;
        });
      }
      create() {
        if (this.isCreated || !this.docs.length) {
          return
        }

        this.isCreated = true;

        // List is Array<String>
        if (isString(this.docs[0])) {
          this.docs.forEach((doc, docIndex) => {
            this._addString(doc, docIndex);
          });
        } else {
          // List is Array<Object>
          this.docs.forEach((doc, docIndex) => {
            this._addObject(doc, docIndex);
          });
        }

        this.norm.clear();
      }
      // Adds a doc to the end of the index
      add(doc) {
        const idx = this.size();

        if (isString(doc)) {
          this._addString(doc, idx);
        } else {
          this._addObject(doc, idx);
        }
      }
      // Removes the doc at the specified index of the index
      removeAt(idx) {
        this.records.splice(idx, 1);

        // Change ref index of every subsquent doc
        for (let i = idx, len = this.size(); i < len; i += 1) {
          this.records[i].i -= 1;
        }
      }
      getValueForItemAtKeyId(item, keyId) {
        return item[this._keysMap[keyId]]
      }
      size() {
        return this.records.length
      }
      _addString(doc, docIndex) {
        if (!isDefined(doc) || isBlank(doc)) {
          return
        }

        let record = {
          v: doc,
          i: docIndex,
          n: this.norm.get(doc)
        };

        this.records.push(record);
      }
      _addObject(doc, docIndex) {
        let record = { i: docIndex, $: {} };

        // Iterate over every key (i.e, path), and fetch the value at that key
        this.keys.forEach((key, keyIndex) => {
          let value = key.getFn ? key.getFn(doc) : this.getFn(doc, key.path);

          if (!isDefined(value)) {
            return
          }

          if (isArray(value)) {
            let subRecords = [];
            const stack = [{ nestedArrIndex: -1, value }];

            while (stack.length) {
              const { nestedArrIndex, value } = stack.pop();

              if (!isDefined(value)) {
                continue
              }

              if (isString(value) && !isBlank(value)) {
                let subRecord = {
                  v: value,
                  i: nestedArrIndex,
                  n: this.norm.get(value)
                };

                subRecords.push(subRecord);
              } else if (isArray(value)) {
                value.forEach((item, k) => {
                  stack.push({
                    nestedArrIndex: k,
                    value: item
                  });
                });
              } else ;
            }
            record.$[keyIndex] = subRecords;
          } else if (isString(value) && !isBlank(value)) {
            let subRecord = {
              v: value,
              n: this.norm.get(value)
            };

            record.$[keyIndex] = subRecord;
          }
        });

        this.records.push(record);
      }
      toJSON() {
        return {
          keys: this.keys,
          records: this.records
        }
      }
    }

    function createIndex(
      keys,
      docs,
      { getFn = Config$1.getFn, fieldNormWeight = Config$1.fieldNormWeight } = {}
    ) {
      const myIndex = new FuseIndex({ getFn, fieldNormWeight });
      myIndex.setKeys(keys.map(createKey));
      myIndex.setSources(docs);
      myIndex.create();
      return myIndex
    }

    function parseIndex(
      data,
      { getFn = Config$1.getFn, fieldNormWeight = Config$1.fieldNormWeight } = {}
    ) {
      const { keys, records } = data;
      const myIndex = new FuseIndex({ getFn, fieldNormWeight });
      myIndex.setKeys(keys);
      myIndex.setIndexRecords(records);
      return myIndex
    }

    function computeScore$1(
      pattern,
      {
        errors = 0,
        currentLocation = 0,
        expectedLocation = 0,
        distance = Config$1.distance,
        ignoreLocation = Config$1.ignoreLocation
      } = {}
    ) {
      const accuracy = errors / pattern.length;

      if (ignoreLocation) {
        return accuracy
      }

      const proximity = Math.abs(expectedLocation - currentLocation);

      if (!distance) {
        // Dodge divide by zero error.
        return proximity ? 1.0 : accuracy
      }

      return accuracy + proximity / distance
    }

    function convertMaskToIndices(
      matchmask = [],
      minMatchCharLength = Config$1.minMatchCharLength
    ) {
      let indices = [];
      let start = -1;
      let end = -1;
      let i = 0;

      for (let len = matchmask.length; i < len; i += 1) {
        let match = matchmask[i];
        if (match && start === -1) {
          start = i;
        } else if (!match && start !== -1) {
          end = i - 1;
          if (end - start + 1 >= minMatchCharLength) {
            indices.push([start, end]);
          }
          start = -1;
        }
      }

      // (i-1 - start) + 1 => i - start
      if (matchmask[i - 1] && i - start >= minMatchCharLength) {
        indices.push([start, i - 1]);
      }

      return indices
    }

    // Machine word size
    const MAX_BITS = 32;

    function search(
      text,
      pattern,
      patternAlphabet,
      {
        location = Config$1.location,
        distance = Config$1.distance,
        threshold = Config$1.threshold,
        findAllMatches = Config$1.findAllMatches,
        minMatchCharLength = Config$1.minMatchCharLength,
        includeMatches = Config$1.includeMatches,
        ignoreLocation = Config$1.ignoreLocation
      } = {}
    ) {
      if (pattern.length > MAX_BITS) {
        throw new Error(PATTERN_LENGTH_TOO_LARGE(MAX_BITS))
      }

      const patternLen = pattern.length;
      // Set starting location at beginning text and initialize the alphabet.
      const textLen = text.length;
      // Handle the case when location > text.length
      const expectedLocation = Math.max(0, Math.min(location, textLen));
      // Highest score beyond which we give up.
      let currentThreshold = threshold;
      // Is there a nearby exact match? (speedup)
      let bestLocation = expectedLocation;

      // Performance: only computer matches when the minMatchCharLength > 1
      // OR if `includeMatches` is true.
      const computeMatches = minMatchCharLength > 1 || includeMatches;
      // A mask of the matches, used for building the indices
      const matchMask = computeMatches ? Array(textLen) : [];

      let index;

      // Get all exact matches, here for speed up
      while ((index = text.indexOf(pattern, bestLocation)) > -1) {
        let score = computeScore$1(pattern, {
          currentLocation: index,
          expectedLocation,
          distance,
          ignoreLocation
        });

        currentThreshold = Math.min(score, currentThreshold);
        bestLocation = index + patternLen;

        if (computeMatches) {
          let i = 0;
          while (i < patternLen) {
            matchMask[index + i] = 1;
            i += 1;
          }
        }
      }

      // Reset the best location
      bestLocation = -1;

      let lastBitArr = [];
      let finalScore = 1;
      let binMax = patternLen + textLen;

      const mask = 1 << (patternLen - 1);

      for (let i = 0; i < patternLen; i += 1) {
        // Scan for the best match; each iteration allows for one more error.
        // Run a binary search to determine how far from the match location we can stray
        // at this error level.
        let binMin = 0;
        let binMid = binMax;

        while (binMin < binMid) {
          const score = computeScore$1(pattern, {
            errors: i,
            currentLocation: expectedLocation + binMid,
            expectedLocation,
            distance,
            ignoreLocation
          });

          if (score <= currentThreshold) {
            binMin = binMid;
          } else {
            binMax = binMid;
          }

          binMid = Math.floor((binMax - binMin) / 2 + binMin);
        }

        // Use the result from this iteration as the maximum for the next.
        binMax = binMid;

        let start = Math.max(1, expectedLocation - binMid + 1);
        let finish = findAllMatches
          ? textLen
          : Math.min(expectedLocation + binMid, textLen) + patternLen;

        // Initialize the bit array
        let bitArr = Array(finish + 2);

        bitArr[finish + 1] = (1 << i) - 1;

        for (let j = finish; j >= start; j -= 1) {
          let currentLocation = j - 1;
          let charMatch = patternAlphabet[text.charAt(currentLocation)];

          if (computeMatches) {
            // Speed up: quick bool to int conversion (i.e, `charMatch ? 1 : 0`)
            matchMask[currentLocation] = +!!charMatch;
          }

          // First pass: exact match
          bitArr[j] = ((bitArr[j + 1] << 1) | 1) & charMatch;

          // Subsequent passes: fuzzy match
          if (i) {
            bitArr[j] |=
              ((lastBitArr[j + 1] | lastBitArr[j]) << 1) | 1 | lastBitArr[j + 1];
          }

          if (bitArr[j] & mask) {
            finalScore = computeScore$1(pattern, {
              errors: i,
              currentLocation,
              expectedLocation,
              distance,
              ignoreLocation
            });

            // This match will almost certainly be better than any existing match.
            // But check anyway.
            if (finalScore <= currentThreshold) {
              // Indeed it is
              currentThreshold = finalScore;
              bestLocation = currentLocation;

              // Already passed `loc`, downhill from here on in.
              if (bestLocation <= expectedLocation) {
                break
              }

              // When passing `bestLocation`, don't exceed our current distance from `expectedLocation`.
              start = Math.max(1, 2 * expectedLocation - bestLocation);
            }
          }
        }

        // No hope for a (better) match at greater error levels.
        const score = computeScore$1(pattern, {
          errors: i + 1,
          currentLocation: expectedLocation,
          expectedLocation,
          distance,
          ignoreLocation
        });

        if (score > currentThreshold) {
          break
        }

        lastBitArr = bitArr;
      }

      const result = {
        isMatch: bestLocation >= 0,
        // Count exact matches (those with a score of 0) to be "almost" exact
        score: Math.max(0.001, finalScore)
      };

      if (computeMatches) {
        const indices = convertMaskToIndices(matchMask, minMatchCharLength);
        if (!indices.length) {
          result.isMatch = false;
        } else if (includeMatches) {
          result.indices = indices;
        }
      }

      return result
    }

    function createPatternAlphabet(pattern) {
      let mask = {};

      for (let i = 0, len = pattern.length; i < len; i += 1) {
        const char = pattern.charAt(i);
        mask[char] = (mask[char] || 0) | (1 << (len - i - 1));
      }

      return mask
    }

    class BitapSearch {
      constructor(
        pattern,
        {
          location = Config$1.location,
          threshold = Config$1.threshold,
          distance = Config$1.distance,
          includeMatches = Config$1.includeMatches,
          findAllMatches = Config$1.findAllMatches,
          minMatchCharLength = Config$1.minMatchCharLength,
          isCaseSensitive = Config$1.isCaseSensitive,
          ignoreLocation = Config$1.ignoreLocation
        } = {}
      ) {
        this.options = {
          location,
          threshold,
          distance,
          includeMatches,
          findAllMatches,
          minMatchCharLength,
          isCaseSensitive,
          ignoreLocation
        };

        this.pattern = isCaseSensitive ? pattern : pattern.toLowerCase();

        this.chunks = [];

        if (!this.pattern.length) {
          return
        }

        const addChunk = (pattern, startIndex) => {
          this.chunks.push({
            pattern,
            alphabet: createPatternAlphabet(pattern),
            startIndex
          });
        };

        const len = this.pattern.length;

        if (len > MAX_BITS) {
          let i = 0;
          const remainder = len % MAX_BITS;
          const end = len - remainder;

          while (i < end) {
            addChunk(this.pattern.substr(i, MAX_BITS), i);
            i += MAX_BITS;
          }

          if (remainder) {
            const startIndex = len - MAX_BITS;
            addChunk(this.pattern.substr(startIndex), startIndex);
          }
        } else {
          addChunk(this.pattern, 0);
        }
      }

      searchIn(text) {
        const { isCaseSensitive, includeMatches } = this.options;

        if (!isCaseSensitive) {
          text = text.toLowerCase();
        }

        // Exact match
        if (this.pattern === text) {
          let result = {
            isMatch: true,
            score: 0
          };

          if (includeMatches) {
            result.indices = [[0, text.length - 1]];
          }

          return result
        }

        // Otherwise, use Bitap algorithm
        const {
          location,
          distance,
          threshold,
          findAllMatches,
          minMatchCharLength,
          ignoreLocation
        } = this.options;

        let allIndices = [];
        let totalScore = 0;
        let hasMatches = false;

        this.chunks.forEach(({ pattern, alphabet, startIndex }) => {
          const { isMatch, score, indices } = search(text, pattern, alphabet, {
            location: location + startIndex,
            distance,
            threshold,
            findAllMatches,
            minMatchCharLength,
            includeMatches,
            ignoreLocation
          });

          if (isMatch) {
            hasMatches = true;
          }

          totalScore += score;

          if (isMatch && indices) {
            allIndices = [...allIndices, ...indices];
          }
        });

        let result = {
          isMatch: hasMatches,
          score: hasMatches ? totalScore / this.chunks.length : 1
        };

        if (hasMatches && includeMatches) {
          result.indices = allIndices;
        }

        return result
      }
    }

    class BaseMatch {
      constructor(pattern) {
        this.pattern = pattern;
      }
      static isMultiMatch(pattern) {
        return getMatch(pattern, this.multiRegex)
      }
      static isSingleMatch(pattern) {
        return getMatch(pattern, this.singleRegex)
      }
      search(/*text*/) {}
    }

    function getMatch(pattern, exp) {
      const matches = pattern.match(exp);
      return matches ? matches[1] : null
    }

    // Token: 'file

    class ExactMatch extends BaseMatch {
      constructor(pattern) {
        super(pattern);
      }
      static get type() {
        return 'exact'
      }
      static get multiRegex() {
        return /^="(.*)"$/
      }
      static get singleRegex() {
        return /^=(.*)$/
      }
      search(text) {
        const isMatch = text === this.pattern;

        return {
          isMatch,
          score: isMatch ? 0 : 1,
          indices: [0, this.pattern.length - 1]
        }
      }
    }

    // Token: !fire

    class InverseExactMatch extends BaseMatch {
      constructor(pattern) {
        super(pattern);
      }
      static get type() {
        return 'inverse-exact'
      }
      static get multiRegex() {
        return /^!"(.*)"$/
      }
      static get singleRegex() {
        return /^!(.*)$/
      }
      search(text) {
        const index = text.indexOf(this.pattern);
        const isMatch = index === -1;

        return {
          isMatch,
          score: isMatch ? 0 : 1,
          indices: [0, text.length - 1]
        }
      }
    }

    // Token: ^file

    class PrefixExactMatch extends BaseMatch {
      constructor(pattern) {
        super(pattern);
      }
      static get type() {
        return 'prefix-exact'
      }
      static get multiRegex() {
        return /^\^"(.*)"$/
      }
      static get singleRegex() {
        return /^\^(.*)$/
      }
      search(text) {
        const isMatch = text.startsWith(this.pattern);

        return {
          isMatch,
          score: isMatch ? 0 : 1,
          indices: [0, this.pattern.length - 1]
        }
      }
    }

    // Token: !^fire

    class InversePrefixExactMatch extends BaseMatch {
      constructor(pattern) {
        super(pattern);
      }
      static get type() {
        return 'inverse-prefix-exact'
      }
      static get multiRegex() {
        return /^!\^"(.*)"$/
      }
      static get singleRegex() {
        return /^!\^(.*)$/
      }
      search(text) {
        const isMatch = !text.startsWith(this.pattern);

        return {
          isMatch,
          score: isMatch ? 0 : 1,
          indices: [0, text.length - 1]
        }
      }
    }

    // Token: .file$

    class SuffixExactMatch extends BaseMatch {
      constructor(pattern) {
        super(pattern);
      }
      static get type() {
        return 'suffix-exact'
      }
      static get multiRegex() {
        return /^"(.*)"\$$/
      }
      static get singleRegex() {
        return /^(.*)\$$/
      }
      search(text) {
        const isMatch = text.endsWith(this.pattern);

        return {
          isMatch,
          score: isMatch ? 0 : 1,
          indices: [text.length - this.pattern.length, text.length - 1]
        }
      }
    }

    // Token: !.file$

    class InverseSuffixExactMatch extends BaseMatch {
      constructor(pattern) {
        super(pattern);
      }
      static get type() {
        return 'inverse-suffix-exact'
      }
      static get multiRegex() {
        return /^!"(.*)"\$$/
      }
      static get singleRegex() {
        return /^!(.*)\$$/
      }
      search(text) {
        const isMatch = !text.endsWith(this.pattern);
        return {
          isMatch,
          score: isMatch ? 0 : 1,
          indices: [0, text.length - 1]
        }
      }
    }

    class FuzzyMatch extends BaseMatch {
      constructor(
        pattern,
        {
          location = Config$1.location,
          threshold = Config$1.threshold,
          distance = Config$1.distance,
          includeMatches = Config$1.includeMatches,
          findAllMatches = Config$1.findAllMatches,
          minMatchCharLength = Config$1.minMatchCharLength,
          isCaseSensitive = Config$1.isCaseSensitive,
          ignoreLocation = Config$1.ignoreLocation
        } = {}
      ) {
        super(pattern);
        this._bitapSearch = new BitapSearch(pattern, {
          location,
          threshold,
          distance,
          includeMatches,
          findAllMatches,
          minMatchCharLength,
          isCaseSensitive,
          ignoreLocation
        });
      }
      static get type() {
        return 'fuzzy'
      }
      static get multiRegex() {
        return /^"(.*)"$/
      }
      static get singleRegex() {
        return /^(.*)$/
      }
      search(text) {
        return this._bitapSearch.searchIn(text)
      }
    }

    // Token: 'file

    class IncludeMatch extends BaseMatch {
      constructor(pattern) {
        super(pattern);
      }
      static get type() {
        return 'include'
      }
      static get multiRegex() {
        return /^'"(.*)"$/
      }
      static get singleRegex() {
        return /^'(.*)$/
      }
      search(text) {
        let location = 0;
        let index;

        const indices = [];
        const patternLen = this.pattern.length;

        // Get all exact matches
        while ((index = text.indexOf(this.pattern, location)) > -1) {
          location = index + patternLen;
          indices.push([index, location - 1]);
        }

        const isMatch = !!indices.length;

        return {
          isMatch,
          score: isMatch ? 0 : 1,
          indices
        }
      }
    }

    // ❗Order is important. DO NOT CHANGE.
    const searchers = [
      ExactMatch,
      IncludeMatch,
      PrefixExactMatch,
      InversePrefixExactMatch,
      InverseSuffixExactMatch,
      SuffixExactMatch,
      InverseExactMatch,
      FuzzyMatch
    ];

    const searchersLen = searchers.length;

    // Regex to split by spaces, but keep anything in quotes together
    const SPACE_RE = / +(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)/;
    const OR_TOKEN = '|';

    // Return a 2D array representation of the query, for simpler parsing.
    // Example:
    // "^core go$ | rb$ | py$ xy$" => [["^core", "go$"], ["rb$"], ["py$", "xy$"]]
    function parseQuery(pattern, options = {}) {
      return pattern.split(OR_TOKEN).map((item) => {
        let query = item
          .trim()
          .split(SPACE_RE)
          .filter((item) => item && !!item.trim());

        let results = [];
        for (let i = 0, len = query.length; i < len; i += 1) {
          const queryItem = query[i];

          // 1. Handle multiple query match (i.e, once that are quoted, like `"hello world"`)
          let found = false;
          let idx = -1;
          while (!found && ++idx < searchersLen) {
            const searcher = searchers[idx];
            let token = searcher.isMultiMatch(queryItem);
            if (token) {
              results.push(new searcher(token, options));
              found = true;
            }
          }

          if (found) {
            continue
          }

          // 2. Handle single query matches (i.e, once that are *not* quoted)
          idx = -1;
          while (++idx < searchersLen) {
            const searcher = searchers[idx];
            let token = searcher.isSingleMatch(queryItem);
            if (token) {
              results.push(new searcher(token, options));
              break
            }
          }
        }

        return results
      })
    }

    // These extended matchers can return an array of matches, as opposed
    // to a singl match
    const MultiMatchSet = new Set([FuzzyMatch.type, IncludeMatch.type]);

    /**
     * Command-like searching
     * ======================
     *
     * Given multiple search terms delimited by spaces.e.g. `^jscript .python$ ruby !java`,
     * search in a given text.
     *
     * Search syntax:
     *
     * | Token       | Match type                 | Description                            |
     * | ----------- | -------------------------- | -------------------------------------- |
     * | `jscript`   | fuzzy-match                | Items that fuzzy match `jscript`       |
     * | `=scheme`   | exact-match                | Items that are `scheme`                |
     * | `'python`   | include-match              | Items that include `python`            |
     * | `!ruby`     | inverse-exact-match        | Items that do not include `ruby`       |
     * | `^java`     | prefix-exact-match         | Items that start with `java`           |
     * | `!^earlang` | inverse-prefix-exact-match | Items that do not start with `earlang` |
     * | `.js$`      | suffix-exact-match         | Items that end with `.js`              |
     * | `!.go$`     | inverse-suffix-exact-match | Items that do not end with `.go`       |
     *
     * A single pipe character acts as an OR operator. For example, the following
     * query matches entries that start with `core` and end with either`go`, `rb`,
     * or`py`.
     *
     * ```
     * ^core go$ | rb$ | py$
     * ```
     */
    class ExtendedSearch {
      constructor(
        pattern,
        {
          isCaseSensitive = Config$1.isCaseSensitive,
          includeMatches = Config$1.includeMatches,
          minMatchCharLength = Config$1.minMatchCharLength,
          ignoreLocation = Config$1.ignoreLocation,
          findAllMatches = Config$1.findAllMatches,
          location = Config$1.location,
          threshold = Config$1.threshold,
          distance = Config$1.distance
        } = {}
      ) {
        this.query = null;
        this.options = {
          isCaseSensitive,
          includeMatches,
          minMatchCharLength,
          findAllMatches,
          ignoreLocation,
          location,
          threshold,
          distance
        };

        this.pattern = isCaseSensitive ? pattern : pattern.toLowerCase();
        this.query = parseQuery(this.pattern, this.options);
      }

      static condition(_, options) {
        return options.useExtendedSearch
      }

      searchIn(text) {
        const query = this.query;

        if (!query) {
          return {
            isMatch: false,
            score: 1
          }
        }

        const { includeMatches, isCaseSensitive } = this.options;

        text = isCaseSensitive ? text : text.toLowerCase();

        let numMatches = 0;
        let allIndices = [];
        let totalScore = 0;

        // ORs
        for (let i = 0, qLen = query.length; i < qLen; i += 1) {
          const searchers = query[i];

          // Reset indices
          allIndices.length = 0;
          numMatches = 0;

          // ANDs
          for (let j = 0, pLen = searchers.length; j < pLen; j += 1) {
            const searcher = searchers[j];
            const { isMatch, indices, score } = searcher.search(text);

            if (isMatch) {
              numMatches += 1;
              totalScore += score;
              if (includeMatches) {
                const type = searcher.constructor.type;
                if (MultiMatchSet.has(type)) {
                  allIndices = [...allIndices, ...indices];
                } else {
                  allIndices.push(indices);
                }
              }
            } else {
              totalScore = 0;
              numMatches = 0;
              allIndices.length = 0;
              break
            }
          }

          // OR condition, so if TRUE, return
          if (numMatches) {
            let result = {
              isMatch: true,
              score: totalScore / numMatches
            };

            if (includeMatches) {
              result.indices = allIndices;
            }

            return result
          }
        }

        // Nothing was matched
        return {
          isMatch: false,
          score: 1
        }
      }
    }

    const registeredSearchers = [];

    function register(...args) {
      registeredSearchers.push(...args);
    }

    function createSearcher(pattern, options) {
      for (let i = 0, len = registeredSearchers.length; i < len; i += 1) {
        let searcherClass = registeredSearchers[i];
        if (searcherClass.condition(pattern, options)) {
          return new searcherClass(pattern, options)
        }
      }

      return new BitapSearch(pattern, options)
    }

    const LogicalOperator = {
      AND: '$and',
      OR: '$or'
    };

    const KeyType = {
      PATH: '$path',
      PATTERN: '$val'
    };

    const isExpression = (query) =>
      !!(query[LogicalOperator.AND] || query[LogicalOperator.OR]);

    const isPath = (query) => !!query[KeyType.PATH];

    const isLeaf = (query) =>
      !isArray(query) && isObject(query) && !isExpression(query);

    const convertToExplicit = (query) => ({
      [LogicalOperator.AND]: Object.keys(query).map((key) => ({
        [key]: query[key]
      }))
    });

    // When `auto` is `true`, the parse function will infer and initialize and add
    // the appropriate `Searcher` instance
    function parse(query, options, { auto = true } = {}) {
      const next = (query) => {
        let keys = Object.keys(query);

        const isQueryPath = isPath(query);

        if (!isQueryPath && keys.length > 1 && !isExpression(query)) {
          return next(convertToExplicit(query))
        }

        if (isLeaf(query)) {
          const key = isQueryPath ? query[KeyType.PATH] : keys[0];

          const pattern = isQueryPath ? query[KeyType.PATTERN] : query[key];

          if (!isString(pattern)) {
            throw new Error(LOGICAL_SEARCH_INVALID_QUERY_FOR_KEY(key))
          }

          const obj = {
            keyId: createKeyId(key),
            pattern
          };

          if (auto) {
            obj.searcher = createSearcher(pattern, options);
          }

          return obj
        }

        let node = {
          children: [],
          operator: keys[0]
        };

        keys.forEach((key) => {
          const value = query[key];

          if (isArray(value)) {
            value.forEach((item) => {
              node.children.push(next(item));
            });
          }
        });

        return node
      };

      if (!isExpression(query)) {
        query = convertToExplicit(query);
      }

      return next(query)
    }

    // Practical scoring function
    function computeScore(
      results,
      { ignoreFieldNorm = Config$1.ignoreFieldNorm }
    ) {
      results.forEach((result) => {
        let totalScore = 1;

        result.matches.forEach(({ key, norm, score }) => {
          const weight = key ? key.weight : null;

          totalScore *= Math.pow(
            score === 0 && weight ? Number.EPSILON : score,
            (weight || 1) * (ignoreFieldNorm ? 1 : norm)
          );
        });

        result.score = totalScore;
      });
    }

    function transformMatches(result, data) {
      const matches = result.matches;
      data.matches = [];

      if (!isDefined(matches)) {
        return
      }

      matches.forEach((match) => {
        if (!isDefined(match.indices) || !match.indices.length) {
          return
        }

        const { indices, value } = match;

        let obj = {
          indices,
          value
        };

        if (match.key) {
          obj.key = match.key.src;
        }

        if (match.idx > -1) {
          obj.refIndex = match.idx;
        }

        data.matches.push(obj);
      });
    }

    function transformScore(result, data) {
      data.score = result.score;
    }

    function format(
      results,
      docs,
      {
        includeMatches = Config$1.includeMatches,
        includeScore = Config$1.includeScore
      } = {}
    ) {
      const transformers = [];

      if (includeMatches) transformers.push(transformMatches);
      if (includeScore) transformers.push(transformScore);

      return results.map((result) => {
        const { idx } = result;

        const data = {
          item: docs[idx],
          refIndex: idx
        };

        if (transformers.length) {
          transformers.forEach((transformer) => {
            transformer(result, data);
          });
        }

        return data
      })
    }

    class Fuse {
      constructor(docs, options = {}, index) {
        this.options = { ...Config$1, ...options };

        if (
          this.options.useExtendedSearch &&
          !true
        ) {
          throw new Error(EXTENDED_SEARCH_UNAVAILABLE)
        }

        this._keyStore = new KeyStore(this.options.keys);

        this.setCollection(docs, index);
      }

      setCollection(docs, index) {
        this._docs = docs;

        if (index && !(index instanceof FuseIndex)) {
          throw new Error(INCORRECT_INDEX_TYPE)
        }

        this._myIndex =
          index ||
          createIndex(this.options.keys, this._docs, {
            getFn: this.options.getFn,
            fieldNormWeight: this.options.fieldNormWeight
          });
      }

      add(doc) {
        if (!isDefined(doc)) {
          return
        }

        this._docs.push(doc);
        this._myIndex.add(doc);
      }

      remove(predicate = (/* doc, idx */) => false) {
        const results = [];

        for (let i = 0, len = this._docs.length; i < len; i += 1) {
          const doc = this._docs[i];
          if (predicate(doc, i)) {
            this.removeAt(i);
            i -= 1;
            len -= 1;

            results.push(doc);
          }
        }

        return results
      }

      removeAt(idx) {
        this._docs.splice(idx, 1);
        this._myIndex.removeAt(idx);
      }

      getIndex() {
        return this._myIndex
      }

      search(query, { limit = -1 } = {}) {
        const {
          includeMatches,
          includeScore,
          shouldSort,
          sortFn,
          ignoreFieldNorm
        } = this.options;

        let results = isString(query)
          ? isString(this._docs[0])
            ? this._searchStringList(query)
            : this._searchObjectList(query)
          : this._searchLogical(query);

        computeScore(results, { ignoreFieldNorm });

        if (shouldSort) {
          results.sort(sortFn);
        }

        if (isNumber(limit) && limit > -1) {
          results = results.slice(0, limit);
        }

        return format(results, this._docs, {
          includeMatches,
          includeScore
        })
      }

      _searchStringList(query) {
        const searcher = createSearcher(query, this.options);
        const { records } = this._myIndex;
        const results = [];

        // Iterate over every string in the index
        records.forEach(({ v: text, i: idx, n: norm }) => {
          if (!isDefined(text)) {
            return
          }

          const { isMatch, score, indices } = searcher.searchIn(text);

          if (isMatch) {
            results.push({
              item: text,
              idx,
              matches: [{ score, value: text, norm, indices }]
            });
          }
        });

        return results
      }

      _searchLogical(query) {

        const expression = parse(query, this.options);

        const evaluate = (node, item, idx) => {
          if (!node.children) {
            const { keyId, searcher } = node;

            const matches = this._findMatches({
              key: this._keyStore.get(keyId),
              value: this._myIndex.getValueForItemAtKeyId(item, keyId),
              searcher
            });

            if (matches && matches.length) {
              return [
                {
                  idx,
                  item,
                  matches
                }
              ]
            }

            return []
          }

          const res = [];
          for (let i = 0, len = node.children.length; i < len; i += 1) {
            const child = node.children[i];
            const result = evaluate(child, item, idx);
            if (result.length) {
              res.push(...result);
            } else if (node.operator === LogicalOperator.AND) {
              return []
            }
          }
          return res
        };

        const records = this._myIndex.records;
        const resultMap = {};
        const results = [];

        records.forEach(({ $: item, i: idx }) => {
          if (isDefined(item)) {
            let expResults = evaluate(expression, item, idx);

            if (expResults.length) {
              // Dedupe when adding
              if (!resultMap[idx]) {
                resultMap[idx] = { idx, item, matches: [] };
                results.push(resultMap[idx]);
              }
              expResults.forEach(({ matches }) => {
                resultMap[idx].matches.push(...matches);
              });
            }
          }
        });

        return results
      }

      _searchObjectList(query) {
        const searcher = createSearcher(query, this.options);
        const { keys, records } = this._myIndex;
        const results = [];

        // List is Array<Object>
        records.forEach(({ $: item, i: idx }) => {
          if (!isDefined(item)) {
            return
          }

          let matches = [];

          // Iterate over every key (i.e, path), and fetch the value at that key
          keys.forEach((key, keyIndex) => {
            matches.push(
              ...this._findMatches({
                key,
                value: item[keyIndex],
                searcher
              })
            );
          });

          if (matches.length) {
            results.push({
              idx,
              item,
              matches
            });
          }
        });

        return results
      }
      _findMatches({ key, value, searcher }) {
        if (!isDefined(value)) {
          return []
        }

        let matches = [];

        if (isArray(value)) {
          value.forEach(({ v: text, i: idx, n: norm }) => {
            if (!isDefined(text)) {
              return
            }

            const { isMatch, score, indices } = searcher.searchIn(text);

            if (isMatch) {
              matches.push({
                score,
                key,
                value: text,
                idx,
                norm,
                indices
              });
            }
          });
        } else {
          const { v: text, n: norm } = value;

          const { isMatch, score, indices } = searcher.searchIn(text);

          if (isMatch) {
            matches.push({ score, key, value: text, norm, indices });
          }
        }

        return matches
      }
    }

    Fuse.version = '6.6.2';
    Fuse.createIndex = createIndex;
    Fuse.parseIndex = parseIndex;
    Fuse.config = Config$1;

    {
      Fuse.parseQuery = parse;
    }

    {
      register(ExtendedSearch);
    }

    // Copyright 2023 cPanel, L.L.C. - All rights reserved.
    /* NOTE: tabindex attribute is required for Safari otherwise
        the links do not work and clicking one dismisses the dropdown. */
    const toolSearchResult = (appEntry, index, directoryPrefix) => (h("li", null,
      h("a", { id: appEntry.key + "-search-menu", role: "row", class: "list-group-item list-group-item-action tool-result__container", "data-search-result": true, href: appEntry.url_is_absolute ? appEntry.url : directoryPrefix + appEntry.url, target: appEntry.target, tabindex: "-1" },
        h("div", { id: "app-result" + index + "x0", role: "gridcell", class: "tool-result__main" },
          h("span", { class: "tool-result__heading", innerHTML: appEntry.name }),
          h("p", { class: "tool-result__description" }, appEntry.description)),
        h("p", { class: "tool-result__category" },
          h("span", { id: "app-result" + index + "x1", role: "gridcell" }, appEntry.category)))));

    // Copyright 2023 cPanel, L.L.C. - All rights reserved.
    /* NOTE: tabindex attribute is required for Safari otherwise
    the links do not work and clicking one dismisses the dropdown. */
    const accountSearchResult = (account, cpSecurityToken, permissions, whmUser) => {
      let canWhmUserAccessAccount = false;
      if (whmUser) {
        if ((permissions === null || permissions === void 0 ? void 0 : permissions.impersonateAccountTweakSettingValue) === "owner_root" &&
          (whmUser === "root" || whmUser === account.owner)) {
          canWhmUserAccessAccount = true;
        }
        else if ((permissions === null || permissions === void 0 ? void 0 : permissions.impersonateAccountTweakSettingValue) === "owner" && whmUser === account.owner) {
          canWhmUserAccessAccount = true;
        }
      }
      return (h("li", { role: "row", class: "list-group-item account-result__container" },
        h("div", { class: "account-result__main_section" },
          h("p", { class: "account-result__username" }, account.user),
          h("a", { tabindex: "0", class: "account-result__domain", "data-search-result": true, target: "_blank", href: "https://" + account.domain }, account.domain)),
        h("div", { class: "account-result__action-section" },
          (permissions === null || permissions === void 0 ? void 0 : permissions.modifyAccount) && (h("form", { tabindex: "-1", class: "text-center", method: "GET", action: cpSecurityToken + "/scripts/edituser" },
            h("input", { type: "hidden", name: "user", value: account.user }),
            h("input", { type: "hidden", name: "domain", value: account.domain }),
            h("button", { tabindex: "0", id: "account-result__modify-" + account.user, class: "btn btn-round button--account-action", "data-search-result": true, role: "gridcell" },
              h("cp-icon", { class: "button__pencil-icon", name: "pencil-fill", size: IconSize.xl, mode: IconMode.Centered })))),
          canWhmUserAccessAccount && (h("form", { tabindex: "-1", class: "text-center", method: "POST", target: "_blank", action: "/xfercpanel" },
            h("input", { type: "hidden", name: "token", value: cpSecurityToken.replace(/\/+$/, "") }),
            h("input", { type: "hidden", name: "user", value: account.user }),
            h("button", { tabindex: "0", id: "account-result__impersonate" + account.user, type: "submit", class: "btn btn-round button--account-action button__image-container", "data-search-result": true, role: "gridcell" },
              h("img", { class: "button__image", src: getAssetPath("./assets/cp-logo.svg"), alt: "cpanel logo" })))))));
    };

    // Copyright 2023 cPanel, L.L.C. - All rights reserved.
    // copyright@cpanel.net
    // https://cpanel.net
    // This code is subject to the cPanel license. Unauthorized copying is prohibited
    const SEARCH_OPTIONS = {
      keys: [
        {
          name: "name",
          weight: 3,
        },
        {
          name: "searchText",
          weight: 3,
        },
        {
          name: "category",
          weight: 1,
        },
        {
          name: "description",
          weight: 1,
        },
      ],
      includeMatches: true,
    };
    const WHM_MAIN_MENU_SEARCH_OPTIONS = Object.assign(Object.assign({}, SEARCH_OPTIONS), { 
      // Reduce threshold to tighten up the search relevance. This helps in reducing the number of
      // non-relevant matches.
      threshold: 0.3 });

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    const LIST_ACCOUNTS_FN = "listaccts";
    const DEFAULT_MAX_RESULTS = 5;
    const SEARCH_ARGUMENT_NAME = "search";
    const LIST_ACCOUNTS_PATH = "scripts4/listaccts";
    const WANT_ARGUMENT = new Argument("want", "user,domain,owner");
    const SEARCH_TYPE_ARGUMENT = new Argument("searchtype", "domain_and_user");
    /**
     * Can be used to fetch Account data and generate a path to the list account page.
     */
    const ListAccountsService = {
      /**
       * Fetches the accounts for the search value provided.
       */
      getAccounts(searchValue, resultsToDisplayCount = DEFAULT_MAX_RESULTS) {
        const pager = new Pager(1, resultsToDisplayCount);
        const request = new WhmApiRequest(WhmApiType.JsonApi, {
          method: LIST_ACCOUNTS_FN,
          arguments: [SEARCH_TYPE_ARGUMENT, WANT_ARGUMENT, new Argument(SEARCH_ARGUMENT_NAME, searchValue)],
          pager,
        });
        const requestInfo = request.generate({
          verb: HttpVerb.GET,
          encoder: new WwwFormUrlArgumentEncoder(),
        });
        const pathBuilder = new ApplicationPath(new LocationService());
        const requestUrl = pathBuilder.buildTokenPath(requestInfo.url);
        let resultP = fetch(requestUrl)
          .then(response => response.json())
          .then(data => {
          var _a, _b, _c;
          if (!data.metadata.result) {
            throw data.metadata.reason;
          }
          let accounts = (_a = data === null || data === void 0 ? void 0 : data.data) === null || _a === void 0 ? void 0 : _a.acct.map(a => {
            return Object.assign(Object.assign({}, a), { name: a.user });
          });
          return {
            accounts: accounts || [],
            records: (_c = (_b = data === null || data === void 0 ? void 0 : data.metadata) === null || _b === void 0 ? void 0 : _b.chunk) === null || _c === void 0 ? void 0 : _c.records,
          };
        });
        resultP.catch(console.error);
        return resultP;
      },
      /**
       * The link to the list accounts page with the user's query preselected.
       */
      getRelativePathToListAccountsPage(searchValue) {
        const pathBuilder = new ApplicationPath(new LocationService());
        const searchParams = new URLSearchParams({
          [SEARCH_ARGUMENT_NAME]: searchValue,
          [SEARCH_TYPE_ARGUMENT.name]: SEARCH_TYPE_ARGUMENT.value,
        }).toString();
        return `${pathBuilder.securityToken}/${LIST_ACCOUNTS_PATH}?${searchParams}`;
      },
    };

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    class Combobox {
      constructor(el) {
        this.el = el;
      }
      get elements() {
        return Array.from(this.el.querySelectorAll("[role=row], [role=gridcell]"));
      }
      get activeElementId() {
        return this.el.getAttribute("aria-activedecendant");
      }
      get currentIndex() {
        return this.elements.findIndex(el => el.id == this.activeElementId);
      }
      get currentRow() {
        if (!this.currentGridcell) {
          return;
        }
        return this.previous(is_row);
      }
      render() {
        var _a, _b;
        (_a = this.currentGridcell) === null || _a === void 0 ? void 0 : _a.classList.add("active");
        (_b = this.currentRow) === null || _b === void 0 ? void 0 : _b.classList.add("active");
      }
      clearActive() {
        var _a, _b;
        (_a = this.currentGridcell) === null || _a === void 0 ? void 0 : _a.classList.remove("active");
        (_b = this.currentRow) === null || _b === void 0 ? void 0 : _b.classList.remove("active");
      }
      /**
       * Sets the element as the focused element for the grid popup
       * and updates the DOM to reflect the changes. If the element has
       * a role of row, it will search for the first gridcell and set that
       * as the focused element.
       * @param element HTMLElement
       */
      goTo(element) {
        this.clearActive();
        if (!element) {
          this.el.removeAttribute("aria-activedecendant");
        }
        if (is_row(element)) {
          const gridcell = element.querySelector("[role=gridcell]");
          this.el.setAttribute("aria-activedecendant", gridcell.id);
        }
        if (is_gridcell(element)) {
          this.el.setAttribute("aria-activedecendant", element.id);
        }
        this.render();
      }
      /**
       * returns the currently focused gridcell
       * or undefined if you havent specified a row or gridcell
       * with the goTo function
       * @returns HTMLElement | undefined
       */
      get currentGridcell() {
        return this.elements.find(el => el.id == this.activeElementId);
      }
      next(predicate) {
        const element = this.elements.slice(this.currentIndex + 1).find(predicate);
        if (element) {
          return element;
        }
        return this.elements.find(predicate);
      }
      previous(predicate) {
        const element = this.elements.slice(0, this.currentIndex).reverse().find(predicate);
        if (element) {
          return element;
        }
        return this.elements.reverse().find(predicate);
      }
      /**
       * return the next gridcell element of the grid popup
       * based on the currently focused gridcell.
       * If the currenlty focused gridcell is the last one, it then
       * returns the first one.
       * @returns HTMLElement
       */
      get nextGridcell() {
        return this.next(is_gridcell);
      }
      /**
       * return the previous gridcell element of the grid popup
       * based on the currently focused gridcell.
       * If the currenlty focused gridcell is the first one, it then
       * returns the last one.
       * @returns HTMLElement
       */
      get previousGridcell() {
        return this.previous(is_gridcell);
      }
      /**
       * return the next row element of the grid popup
       * based on the currently focused gridcell.
       * If the currenlty focused row is the first one, it then
       * returns the last one.
       * @returns HTMLElement
       */
      get nextRow() {
        return this.next(is_row);
      }
      /**
       * return the previous row element of the grid popup
       * based on the currently focused gridcell.
       * If the currenlty focused row is the last one, it then
       * returns the first one.
       * @returns HTMLElement
       */
      get previousRow() {
        return this.previous(e => is_row(e) && this.currentRow != e);
      }
      /**
       * return the first element of the grid popup, usually
       * an element with a role of 'row'
       * @returns HTMLElement
       */
      get firstElement() {
        return this.elements[0];
      }
    }
    /**
     * Checks whether the element passed contains the
     * attribute role set to 'row'
     * @param element HTMLElement
     * @returns boolean
     */
    function is_row(element) {
      return (element === null || element === void 0 ? void 0 : element.getAttribute("role")) == "row";
    }
    /**
     * Checks whether the element passed contains the
     * attribute role set to 'gridcell'
     * @param element HTMLElement
     * @returns boolean
     */
    function is_gridcell(element) {
      return (element === null || element === void 0 ? void 0 : element.getAttribute("role")) == "gridcell";
    }

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    /**
     * A recursive funtion that will return the internal element that has focus, even if it's inside a shadow root.
     *
     * Note: Due to how active element is retargeted in shadow DOM, it becomes difficult to access the actual element that is focussed at any instant.
     * So we had to use the recursive function to traverse through the element DOM to find the right one.
     * Reference URL: https://www.abeautifulsite.net/posts/finding-the-active-element-in-a-shadow-root/
     */
    function getActiveElement(root = document) {
      const activeEl = root.activeElement;
      if (!activeEl) {
        return null;
      }
      if (activeEl.shadowRoot) {
        return getActiveElement(activeEl.shadowRoot);
      }
      else {
        return activeEl;
      }
    }

    const cpHeaderSearchCss = "@charset \"UTF-8\";input[type=search].hide-browser-clear-button::-ms-clear{display:none;width:0;height:0}input[type=search].hide-browser-clear-button::-ms-reveal{display:none;width:0;height:0}input[type=search].hide-browser-clear-button::-webkit-search-decoration,input[type=search].hide-browser-clear-button::-webkit-search-cancel-button,input[type=search].hide-browser-clear-button::-webkit-search-results-button,input[type=search].hide-browser-clear-button::-webkit-search-results-decoration{display:none}.btn{--cp-btn-padding-x:0.75rem;--cp-btn-padding-y:0.375rem;--cp-btn-font-size:1rem;--cp-btn-font-weight:400;--cp-btn-line-height:1.5;--cp-btn-color:#243746;--cp-btn-bg:transparent;--cp-btn-border-width:1px;--cp-btn-border-color:transparent;--cp-btn-border-radius:0.25rem;--cp-btn-hover-border-color:transparent;--cp-btn-box-shadow:inset 0 1px 0 rgba(255, 255, 255, 0.15), 0 1px 1px rgba(0, 0, 0, 0.075);--cp-btn-disabled-opacity:0.65;--cp-btn-focus-box-shadow:0 0 0 0.25rem rgba(var(--cp-btn-focus-shadow-rgb), .5);display:inline-block;padding:var(--cp-btn-padding-y) var(--cp-btn-padding-x);font-family:var(--cp-btn-font-family);font-size:var(--cp-btn-font-size);font-weight:var(--cp-btn-font-weight);line-height:var(--cp-btn-line-height);color:var(--cp-btn-color);text-align:center;text-decoration:none;vertical-align:middle;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;border:var(--cp-btn-border-width) solid var(--cp-btn-border-color);border-radius:var(--cp-btn-border-radius);background-color:var(--cp-btn-bg);transition:color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out}@media (prefers-reduced-motion: reduce){.btn{transition:none}}.btn:hover{color:var(--cp-btn-hover-color);background-color:var(--cp-btn-hover-bg);border-color:var(--cp-btn-hover-border-color)}.btn-check+.btn:hover{color:var(--cp-btn-color);background-color:var(--cp-btn-bg);border-color:var(--cp-btn-border-color)}.btn:focus-visible{color:var(--cp-btn-hover-color);background-color:var(--cp-btn-hover-bg);border-color:var(--cp-btn-hover-border-color);outline:0;box-shadow:var(--cp-btn-focus-box-shadow)}.btn-check:focus-visible+.btn{border-color:var(--cp-btn-hover-border-color);outline:0;box-shadow:var(--cp-btn-focus-box-shadow)}.btn-check:checked+.btn,:not(.btn-check)+.btn:active,.btn:first-child:active,.btn.active,.btn.show{color:var(--cp-btn-active-color);background-color:var(--cp-btn-active-bg);border-color:var(--cp-btn-active-border-color)}.btn-check:checked+.btn:focus-visible,:not(.btn-check)+.btn:active:focus-visible,.btn:first-child:active:focus-visible,.btn.active:focus-visible,.btn.show:focus-visible{box-shadow:var(--cp-btn-focus-box-shadow)}.btn:disabled,.btn.disabled,fieldset:disabled .btn{color:var(--cp-btn-disabled-color);pointer-events:none;background-color:var(--cp-btn-disabled-bg);border-color:var(--cp-btn-disabled-border-color);opacity:var(--cp-btn-disabled-opacity)}.btn-primary{--cp-btn-color:#fff;--cp-btn-bg:#003da6;--cp-btn-border-color:#003da6;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#00348d;--cp-btn-hover-border-color:#003185;--cp-btn-focus-shadow-rgb:38, 90, 179;--cp-btn-active-color:#fff;--cp-btn-active-bg:#003185;--cp-btn-active-border-color:#002e7d;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#003da6;--cp-btn-disabled-border-color:#003da6}.btn-success{--cp-btn-color:#fff;--cp-btn-bg:#198754;--cp-btn-border-color:#198754;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#157347;--cp-btn-hover-border-color:#146c43;--cp-btn-focus-shadow-rgb:60, 153, 110;--cp-btn-active-color:#fff;--cp-btn-active-bg:#146c43;--cp-btn-active-border-color:#13653f;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#198754;--cp-btn-disabled-border-color:#198754}.btn-info{--cp-btn-color:#000;--cp-btn-bg:#0dcaf0;--cp-btn-border-color:#0dcaf0;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#31d2f2;--cp-btn-hover-border-color:#25cff2;--cp-btn-focus-shadow-rgb:11, 172, 204;--cp-btn-active-color:#000;--cp-btn-active-bg:#3dd5f3;--cp-btn-active-border-color:#25cff2;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#000;--cp-btn-disabled-bg:#0dcaf0;--cp-btn-disabled-border-color:#0dcaf0}.btn-warning{--cp-btn-color:#000;--cp-btn-bg:#ffc107;--cp-btn-border-color:#ffc107;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#ffca2c;--cp-btn-hover-border-color:#ffc720;--cp-btn-focus-shadow-rgb:217, 164, 6;--cp-btn-active-color:#000;--cp-btn-active-bg:#ffcd39;--cp-btn-active-border-color:#ffc720;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#000;--cp-btn-disabled-bg:#ffc107;--cp-btn-disabled-border-color:#ffc107}.btn-danger{--cp-btn-color:#fff;--cp-btn-bg:#dc3545;--cp-btn-border-color:#dc3545;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#bb2d3b;--cp-btn-hover-border-color:#b02a37;--cp-btn-focus-shadow-rgb:225, 83, 97;--cp-btn-active-color:#fff;--cp-btn-active-bg:#b02a37;--cp-btn-active-border-color:#a52834;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#dc3545;--cp-btn-disabled-border-color:#dc3545}.btn-light{--cp-btn-color:#000;--cp-btn-bg:#fafafa;--cp-btn-border-color:#fafafa;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#d5d5d5;--cp-btn-hover-border-color:#c8c8c8;--cp-btn-focus-shadow-rgb:213, 213, 213;--cp-btn-active-color:#000;--cp-btn-active-bg:#c8c8c8;--cp-btn-active-border-color:#bcbcbc;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#000;--cp-btn-disabled-bg:#fafafa;--cp-btn-disabled-border-color:#fafafa}.btn-dark{--cp-btn-color:#fff;--cp-btn-bg:#243746;--cp-btn-border-color:#243746;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#455562;--cp-btn-hover-border-color:#3a4b59;--cp-btn-focus-shadow-rgb:69, 85, 98;--cp-btn-active-color:#fff;--cp-btn-active-bg:#505f6b;--cp-btn-active-border-color:#3a4b59;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#243746;--cp-btn-disabled-border-color:#243746}.btn-accent{--cp-btn-color:#000;--cp-btn-bg:#de5c2e;--cp-btn-border-color:#de5c2e;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#e3744d;--cp-btn-hover-border-color:#e16c43;--cp-btn-focus-shadow-rgb:189, 78, 39;--cp-btn-active-color:#000;--cp-btn-active-bg:#e57d58;--cp-btn-active-border-color:#e16c43;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#000;--cp-btn-disabled-bg:#de5c2e;--cp-btn-disabled-border-color:#de5c2e}.btn-tertiary{--cp-btn-color:#fff;--cp-btn-bg:#202654;--cp-btn-border-color:#202654;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#1b2047;--cp-btn-hover-border-color:#1a1e43;--cp-btn-focus-shadow-rgb:65, 71, 110;--cp-btn-active-color:#fff;--cp-btn-active-bg:#1a1e43;--cp-btn-active-border-color:#181d3f;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fff;--cp-btn-disabled-bg:#202654;--cp-btn-disabled-border-color:#202654}.btn-outline-primary{--cp-btn-color:#003da6;--cp-btn-border-color:#003da6;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#003da6;--cp-btn-hover-border-color:#003da6;--cp-btn-focus-shadow-rgb:0, 61, 166;--cp-btn-active-color:#fff;--cp-btn-active-bg:#003da6;--cp-btn-active-border-color:#003da6;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#003da6;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#003da6;--cp-gradient:none}.btn-outline-success{--cp-btn-color:#198754;--cp-btn-border-color:#198754;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#198754;--cp-btn-hover-border-color:#198754;--cp-btn-focus-shadow-rgb:25, 135, 84;--cp-btn-active-color:#fff;--cp-btn-active-bg:#198754;--cp-btn-active-border-color:#198754;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#198754;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#198754;--cp-gradient:none}.btn-outline-info{--cp-btn-color:#0dcaf0;--cp-btn-border-color:#0dcaf0;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#0dcaf0;--cp-btn-hover-border-color:#0dcaf0;--cp-btn-focus-shadow-rgb:13, 202, 240;--cp-btn-active-color:#000;--cp-btn-active-bg:#0dcaf0;--cp-btn-active-border-color:#0dcaf0;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#0dcaf0;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#0dcaf0;--cp-gradient:none}.btn-outline-warning{--cp-btn-color:#ffc107;--cp-btn-border-color:#ffc107;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#ffc107;--cp-btn-hover-border-color:#ffc107;--cp-btn-focus-shadow-rgb:255, 193, 7;--cp-btn-active-color:#000;--cp-btn-active-bg:#ffc107;--cp-btn-active-border-color:#ffc107;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#ffc107;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#ffc107;--cp-gradient:none}.btn-outline-danger{--cp-btn-color:#dc3545;--cp-btn-border-color:#dc3545;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#dc3545;--cp-btn-hover-border-color:#dc3545;--cp-btn-focus-shadow-rgb:220, 53, 69;--cp-btn-active-color:#fff;--cp-btn-active-bg:#dc3545;--cp-btn-active-border-color:#dc3545;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#dc3545;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#dc3545;--cp-gradient:none}.btn-outline-light{--cp-btn-color:#fafafa;--cp-btn-border-color:#fafafa;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#fafafa;--cp-btn-hover-border-color:#fafafa;--cp-btn-focus-shadow-rgb:250, 250, 250;--cp-btn-active-color:#000;--cp-btn-active-bg:#fafafa;--cp-btn-active-border-color:#fafafa;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#fafafa;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#fafafa;--cp-gradient:none}.btn-outline-dark{--cp-btn-color:#243746;--cp-btn-border-color:#243746;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#243746;--cp-btn-hover-border-color:#243746;--cp-btn-focus-shadow-rgb:36, 55, 70;--cp-btn-active-color:#fff;--cp-btn-active-bg:#243746;--cp-btn-active-border-color:#243746;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#243746;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#243746;--cp-gradient:none}.btn-outline-accent{--cp-btn-color:#de5c2e;--cp-btn-border-color:#de5c2e;--cp-btn-hover-color:#000;--cp-btn-hover-bg:#de5c2e;--cp-btn-hover-border-color:#de5c2e;--cp-btn-focus-shadow-rgb:222, 92, 46;--cp-btn-active-color:#000;--cp-btn-active-bg:#de5c2e;--cp-btn-active-border-color:#de5c2e;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#de5c2e;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#de5c2e;--cp-gradient:none}.btn-outline-tertiary{--cp-btn-color:#202654;--cp-btn-border-color:#202654;--cp-btn-hover-color:#fff;--cp-btn-hover-bg:#202654;--cp-btn-hover-border-color:#202654;--cp-btn-focus-shadow-rgb:32, 38, 84;--cp-btn-active-color:#fff;--cp-btn-active-bg:#202654;--cp-btn-active-border-color:#202654;--cp-btn-active-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);--cp-btn-disabled-color:#202654;--cp-btn-disabled-bg:transparent;--cp-btn-disabled-border-color:#202654;--cp-gradient:none}.btn-link,.btn.icon-btn-link{--cp-btn-font-weight:400;--cp-btn-color:var(--cp-link-color);--cp-btn-bg:transparent;--cp-btn-border-color:transparent;--cp-btn-hover-color:var(--cp-link-hover-color);--cp-btn-hover-border-color:transparent;--cp-btn-active-color:var(--cp-link-hover-color);--cp-btn-active-border-color:transparent;--cp-btn-disabled-color:#6d7983;--cp-btn-disabled-border-color:transparent;--cp-btn-box-shadow:none;--cp-btn-focus-shadow-rgb:38, 90, 179;text-decoration:underline}.btn-link:focus-visible,.btn.icon-btn-link:focus-visible{color:var(--cp-btn-color)}.btn-link:hover,.btn.icon-btn-link:hover{color:var(--cp-btn-hover-color)}.btn-lg{--cp-btn-padding-y:0.5rem;--cp-btn-padding-x:1rem;--cp-btn-font-size:1.25rem;--cp-btn-border-radius:0.5rem}.btn-sm{--cp-btn-padding-y:0.25rem;--cp-btn-padding-x:0.5rem;--cp-btn-font-size:0.875rem;--cp-btn-border-radius:0.125rem}.btn{min-width:160px}.btn.btn-round{display:flex;align-items:center;justify-content:center;text-decoration:none;cursor:pointer;padding:var(--cp-spacer-2);border-radius:100%;border:1px solid var(--cp-tertiary, #202654);width:40px;height:40px;min-width:40px;min-height:40px;background:var(--cp-component-bg, #fff);color:var(--cp-tertiary, #202654)}.btn.btn-round:hover,.btn.btn-round:focus,.btn.btn-round:active{background:var(--cp-tertiary, #202654);color:#fff}.btn.btn-link,.btn.icon-btn-link{min-width:initial}.btn.btn-shrink{min-width:unset}.btn.icon-btn-link{display:inline-flex;align-items:center;text-decoration:none}.btn .ri-lg{font-size:1.3333em;line-height:0.75em;vertical-align:-0.18em}.btn-sm .ri-sm{vertical-align:-1px}.btn.disabled,.btn[disabled]{pointer-events:all;cursor:not-allowed}.icon-btn-link-text{text-decoration:underline}.list-group{--cp-list-group-color:#243746;--cp-list-group-bg:var(--cp-component-bg, #fff);--cp-list-group-border-color:rgba(0, 0, 0, 0.125);--cp-list-group-border-width:1px;--cp-list-group-border-radius:0.25rem;--cp-list-group-item-padding-x:1rem;--cp-list-group-item-padding-y:0.5rem;--cp-list-group-action-color:#54636f;--cp-list-group-action-hover-color:var(--cp-body-color, #243746);--cp-list-group-action-hover-bg:#fafafa;--cp-list-group-action-active-color:#243746;--cp-list-group-action-active-bg:var(--cp-body-bg, #fafafa);--cp-list-group-disabled-color:#6d7983;--cp-list-group-disabled-bg:#fff;--cp-list-group-active-color:#fff;--cp-list-group-active-bg:#003da6;--cp-list-group-active-border-color:#003da6;display:flex;flex-direction:column;margin-bottom:0;border-radius:var(--cp-list-group-border-radius)}[dir=\"ltr\"] .list-group{padding-left:0}[dir=\"rtl\"] .list-group{padding-right:0}.list-group-numbered{list-style-type:none;counter-reset:section}.list-group-numbered>.list-group-item::before{content:counters(section, \".\") \". \";counter-increment:section}.list-group-item-action{width:100%;color:var(--cp-list-group-action-color);text-align:inherit}.list-group-item-action:hover,.list-group-item-action:focus{z-index:1;color:var(--cp-list-group-action-hover-color);text-decoration:none;background-color:var(--cp-list-group-action-hover-bg)}.list-group-item-action:active{color:var(--cp-list-group-action-active-color);background-color:var(--cp-list-group-action-active-bg)}.list-group-item{position:relative;display:block;padding:var(--cp-list-group-item-padding-y) var(--cp-list-group-item-padding-x);color:var(--cp-list-group-color);text-decoration:none;background-color:var(--cp-list-group-bg);border:var(--cp-list-group-border-width) solid var(--cp-list-group-border-color)}.list-group-item:first-child{border-top-left-radius:inherit;border-top-right-radius:inherit}.list-group-item:last-child{border-bottom-right-radius:inherit;border-bottom-left-radius:inherit}.list-group-item.disabled,.list-group-item:disabled{color:var(--cp-list-group-disabled-color);pointer-events:none;background-color:var(--cp-list-group-disabled-bg)}.list-group-item.active{z-index:2;color:var(--cp-list-group-active-color);background-color:var(--cp-list-group-active-bg);border-color:var(--cp-list-group-active-border-color)}.list-group-item+.list-group-item{border-top-width:0}.list-group-item+.list-group-item.active{margin-top:calc(-1 * var(--cp-list-group-border-width));border-top-width:var(--cp-list-group-border-width)}.list-group-horizontal{flex-direction:row}[dir=\"ltr\"] .list-group-horizontal>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--cp-list-group-border-radius);border-top-right-radius:0}[dir=\"rtl\"] .list-group-horizontal>.list-group-item:first-child:not(:last-child){border-bottom-right-radius:var(--cp-list-group-border-radius);border-top-left-radius:0}[dir=\"ltr\"] .list-group-horizontal>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--cp-list-group-border-radius);border-bottom-left-radius:0}[dir=\"rtl\"] .list-group-horizontal>.list-group-item:last-child:not(:first-child){border-top-left-radius:var(--cp-list-group-border-radius);border-bottom-right-radius:0}.list-group-horizontal>.list-group-item.active{margin-top:0}.list-group-horizontal>.list-group-item+.list-group-item{border-top-width:var(--cp-list-group-border-width)}[dir=\"ltr\"] .list-group-horizontal>.list-group-item+.list-group-item{border-left-width:0}[dir=\"rtl\"] .list-group-horizontal>.list-group-item+.list-group-item{border-right-width:0}[dir=\"ltr\"] .list-group-horizontal>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--cp-list-group-border-width));border-left-width:var(--cp-list-group-border-width)}[dir=\"rtl\"] .list-group-horizontal>.list-group-item+.list-group-item.active{margin-right:calc(-1 * var(--cp-list-group-border-width));border-right-width:var(--cp-list-group-border-width)}@media (min-width: 576px){.list-group-horizontal-sm{flex-direction:row}[dir=\"ltr\"] .list-group-horizontal-sm>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--cp-list-group-border-radius);border-top-right-radius:0}[dir=\"rtl\"] .list-group-horizontal-sm>.list-group-item:first-child:not(:last-child){border-bottom-right-radius:var(--cp-list-group-border-radius);border-top-left-radius:0}[dir=\"ltr\"] .list-group-horizontal-sm>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--cp-list-group-border-radius);border-bottom-left-radius:0}[dir=\"rtl\"] .list-group-horizontal-sm>.list-group-item:last-child:not(:first-child){border-top-left-radius:var(--cp-list-group-border-radius);border-bottom-right-radius:0}.list-group-horizontal-sm>.list-group-item.active{margin-top:0}.list-group-horizontal-sm>.list-group-item+.list-group-item{border-top-width:var(--cp-list-group-border-width)}[dir=\"ltr\"] .list-group-horizontal-sm>.list-group-item+.list-group-item{border-left-width:0}[dir=\"rtl\"] .list-group-horizontal-sm>.list-group-item+.list-group-item{border-right-width:0}[dir=\"ltr\"] .list-group-horizontal-sm>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--cp-list-group-border-width));border-left-width:var(--cp-list-group-border-width)}[dir=\"rtl\"] .list-group-horizontal-sm>.list-group-item+.list-group-item.active{margin-right:calc(-1 * var(--cp-list-group-border-width));border-right-width:var(--cp-list-group-border-width)}}@media (min-width: 768px){.list-group-horizontal-md{flex-direction:row}[dir=\"ltr\"] .list-group-horizontal-md>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--cp-list-group-border-radius);border-top-right-radius:0}[dir=\"rtl\"] .list-group-horizontal-md>.list-group-item:first-child:not(:last-child){border-bottom-right-radius:var(--cp-list-group-border-radius);border-top-left-radius:0}[dir=\"ltr\"] .list-group-horizontal-md>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--cp-list-group-border-radius);border-bottom-left-radius:0}[dir=\"rtl\"] .list-group-horizontal-md>.list-group-item:last-child:not(:first-child){border-top-left-radius:var(--cp-list-group-border-radius);border-bottom-right-radius:0}.list-group-horizontal-md>.list-group-item.active{margin-top:0}.list-group-horizontal-md>.list-group-item+.list-group-item{border-top-width:var(--cp-list-group-border-width)}[dir=\"ltr\"] .list-group-horizontal-md>.list-group-item+.list-group-item{border-left-width:0}[dir=\"rtl\"] .list-group-horizontal-md>.list-group-item+.list-group-item{border-right-width:0}[dir=\"ltr\"] .list-group-horizontal-md>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--cp-list-group-border-width));border-left-width:var(--cp-list-group-border-width)}[dir=\"rtl\"] .list-group-horizontal-md>.list-group-item+.list-group-item.active{margin-right:calc(-1 * var(--cp-list-group-border-width));border-right-width:var(--cp-list-group-border-width)}}@media (min-width: 992px){.list-group-horizontal-lg{flex-direction:row}[dir=\"ltr\"] .list-group-horizontal-lg>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--cp-list-group-border-radius);border-top-right-radius:0}[dir=\"rtl\"] .list-group-horizontal-lg>.list-group-item:first-child:not(:last-child){border-bottom-right-radius:var(--cp-list-group-border-radius);border-top-left-radius:0}[dir=\"ltr\"] .list-group-horizontal-lg>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--cp-list-group-border-radius);border-bottom-left-radius:0}[dir=\"rtl\"] .list-group-horizontal-lg>.list-group-item:last-child:not(:first-child){border-top-left-radius:var(--cp-list-group-border-radius);border-bottom-right-radius:0}.list-group-horizontal-lg>.list-group-item.active{margin-top:0}.list-group-horizontal-lg>.list-group-item+.list-group-item{border-top-width:var(--cp-list-group-border-width)}[dir=\"ltr\"] .list-group-horizontal-lg>.list-group-item+.list-group-item{border-left-width:0}[dir=\"rtl\"] .list-group-horizontal-lg>.list-group-item+.list-group-item{border-right-width:0}[dir=\"ltr\"] .list-group-horizontal-lg>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--cp-list-group-border-width));border-left-width:var(--cp-list-group-border-width)}[dir=\"rtl\"] .list-group-horizontal-lg>.list-group-item+.list-group-item.active{margin-right:calc(-1 * var(--cp-list-group-border-width));border-right-width:var(--cp-list-group-border-width)}}@media (min-width: 1200px){.list-group-horizontal-xl{flex-direction:row}[dir=\"ltr\"] .list-group-horizontal-xl>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--cp-list-group-border-radius);border-top-right-radius:0}[dir=\"rtl\"] .list-group-horizontal-xl>.list-group-item:first-child:not(:last-child){border-bottom-right-radius:var(--cp-list-group-border-radius);border-top-left-radius:0}[dir=\"ltr\"] .list-group-horizontal-xl>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--cp-list-group-border-radius);border-bottom-left-radius:0}[dir=\"rtl\"] .list-group-horizontal-xl>.list-group-item:last-child:not(:first-child){border-top-left-radius:var(--cp-list-group-border-radius);border-bottom-right-radius:0}.list-group-horizontal-xl>.list-group-item.active{margin-top:0}.list-group-horizontal-xl>.list-group-item+.list-group-item{border-top-width:var(--cp-list-group-border-width)}[dir=\"ltr\"] .list-group-horizontal-xl>.list-group-item+.list-group-item{border-left-width:0}[dir=\"rtl\"] .list-group-horizontal-xl>.list-group-item+.list-group-item{border-right-width:0}[dir=\"ltr\"] .list-group-horizontal-xl>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--cp-list-group-border-width));border-left-width:var(--cp-list-group-border-width)}[dir=\"rtl\"] .list-group-horizontal-xl>.list-group-item+.list-group-item.active{margin-right:calc(-1 * var(--cp-list-group-border-width));border-right-width:var(--cp-list-group-border-width)}}@media (min-width: 1400px){.list-group-horizontal-xxl{flex-direction:row}[dir=\"ltr\"] .list-group-horizontal-xxl>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--cp-list-group-border-radius);border-top-right-radius:0}[dir=\"rtl\"] .list-group-horizontal-xxl>.list-group-item:first-child:not(:last-child){border-bottom-right-radius:var(--cp-list-group-border-radius);border-top-left-radius:0}[dir=\"ltr\"] .list-group-horizontal-xxl>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--cp-list-group-border-radius);border-bottom-left-radius:0}[dir=\"rtl\"] .list-group-horizontal-xxl>.list-group-item:last-child:not(:first-child){border-top-left-radius:var(--cp-list-group-border-radius);border-bottom-right-radius:0}.list-group-horizontal-xxl>.list-group-item.active{margin-top:0}.list-group-horizontal-xxl>.list-group-item+.list-group-item{border-top-width:var(--cp-list-group-border-width)}[dir=\"ltr\"] .list-group-horizontal-xxl>.list-group-item+.list-group-item{border-left-width:0}[dir=\"rtl\"] .list-group-horizontal-xxl>.list-group-item+.list-group-item{border-right-width:0}[dir=\"ltr\"] .list-group-horizontal-xxl>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--cp-list-group-border-width));border-left-width:var(--cp-list-group-border-width)}[dir=\"rtl\"] .list-group-horizontal-xxl>.list-group-item+.list-group-item.active{margin-right:calc(-1 * var(--cp-list-group-border-width));border-right-width:var(--cp-list-group-border-width)}}.list-group-flush{border-radius:0}.list-group-flush>.list-group-item{border-width:0 0 var(--cp-list-group-border-width)}.list-group-flush>.list-group-item:last-child{border-bottom-width:0}.list-group-item-primary{color:#002564;background-color:#ccd8ed}.list-group-item-primary.list-group-item-action:hover,.list-group-item-primary.list-group-item-action:focus{color:#002564;background-color:#b8c2d5}.list-group-item-primary.list-group-item-action.active{color:#fff;background-color:#002564;border-color:#002564}.list-group-item-success{color:#0f5132;background-color:#d1e7dd}.list-group-item-success.list-group-item-action:hover,.list-group-item-success.list-group-item-action:focus{color:#0f5132;background-color:#bcd0c7}.list-group-item-success.list-group-item-action.active{color:#fff;background-color:#0f5132;border-color:#0f5132}.list-group-item-info{color:#055160;background-color:#cff4fc}.list-group-item-info.list-group-item-action:hover,.list-group-item-info.list-group-item-action:focus{color:#055160;background-color:#badce3}.list-group-item-info.list-group-item-action.active{color:#fff;background-color:#055160;border-color:#055160}.list-group-item-warning{color:#664d03;background-color:#fff3cd}.list-group-item-warning.list-group-item-action:hover,.list-group-item-warning.list-group-item-action:focus{color:#664d03;background-color:#e6dbb9}.list-group-item-warning.list-group-item-action.active{color:#fff;background-color:#664d03;border-color:#664d03}.list-group-item-danger{color:#842029;background-color:#f8d7da}.list-group-item-danger.list-group-item-action:hover,.list-group-item-danger.list-group-item-action:focus{color:#842029;background-color:#dfc2c4}.list-group-item-danger.list-group-item-action.active{color:#fff;background-color:#842029;border-color:#842029}.list-group-item-light{color:#646464;background-color:#fefefe}.list-group-item-light.list-group-item-action:hover,.list-group-item-light.list-group-item-action:focus{color:#646464;background-color:#e5e5e5}.list-group-item-light.list-group-item-action.active{color:#fff;background-color:#646464;border-color:#646464}.list-group-item-dark{color:#16212a;background-color:#d3d7da}.list-group-item-dark.list-group-item-action:hover,.list-group-item-dark.list-group-item-action:focus{color:#16212a;background-color:#bec2c4}.list-group-item-dark.list-group-item-action.active{color:#fff;background-color:#16212a;border-color:#16212a}.list-group-item-accent{color:#85371c;background-color:#f8ded5}.list-group-item-accent.list-group-item-action:hover,.list-group-item-accent.list-group-item-action:focus{color:#85371c;background-color:#dfc8c0}.list-group-item-accent.list-group-item-action.active{color:#fff;background-color:#85371c;border-color:#85371c}.list-group-item-tertiary{color:#131732;background-color:#d2d4dd}.list-group-item-tertiary.list-group-item-action:hover,.list-group-item-tertiary.list-group-item-action:focus{color:#131732;background-color:#bdbfc7}.list-group-item-tertiary.list-group-item-action.active{color:#fff;background-color:#131732;border-color:#131732}.list-group{background-color:var(--cp-component-bg, #fff)}.list-group-item,.list-group-item-action{box-sizing:border-box;border:0 solid transparent}.list-group-item.active,.list-group-item-action.active{background-color:var(--cp-body-bg, #fafafa);color:var(--cp-body-color, #243746);border:0 solid transparent}.list-group-item-action:focus,.list-group-item-action:hover,.list-group-item-action:active,.list-group-item.active,.list-group-item-action.active{background-color:#e5e7e9}.cp-header-search{display:block;}.cp-header-search .header__search-wrapper,.cp-header-search .header__search-input{background:transparent;position:relative;height:2rem}@media (max-width: 575.98px){.cp-header-search .header__search-input::-ms-clear{display:none;width:0;height:0}.cp-header-search .header__search-input::-ms-reveal{display:none;width:0;height:0}.cp-header-search .header__search-input::-webkit-search-decoration,.cp-header-search .header__search-input::-webkit-search-cancel-button,.cp-header-search .header__search-input::-webkit-search-results-button,.cp-header-search .header__search-input::-webkit-search-results-decoration{display:none}}.cp-header-search [role=gridcell]:not(button){border:1px dashed transparent}.cp-header-search [role=gridcell].active{border:1px dashed var(--cp-tertiary, #202654)}.cp-header-search .header__search-wrapper{width:100%}@media (max-width: 575.98px){.cp-header-search .header__search-wrapper{display:flex;flex-direction:row;position:relative}}.cp-header-search .header__search-clear-search-button{display:none}@media (max-width: 575.98px){.cp-header-search .header__search-clear-search-button{display:initial;border:none;background-color:transparent;color:var(--cp-gray-dark, #3c4d5a);position:absolute;cursor:pointer;height:100%;width:var(--cp-spacer-5);padding:0 var(--cp-spacer-4)}[dir=\"ltr\"] .cp-header-search .header__search-clear-search-button{right:0}[dir=\"rtl\"] .cp-header-search .header__search-clear-search-button{left:0}}.cp-header-search .header__search-input{padding:var(--cp-spacer-1) var(--cp-spacer-2);background-color:transparent;border:1px solid rgba(var(--cp-tertiary-rgb, 32, 38, 84), 0.3);border-radius:0.25rem;width:100%;box-sizing:border-box}@media (max-width: 575.98px){.cp-header-search .header__search-input{flex-grow:1}}.cp-header-search .header__search-wrapper.empty::after{font-family:\"remixicon\" !important;color:var(--cp-dark, #243746);content:\"\\f0d1\";position:absolute;top:50%;transform:translateY(-50%)}[dir=\"ltr\"] .cp-header-search .header__search-wrapper.empty::after{right:var(--cp-spacer-2)}[dir=\"rtl\"] .cp-header-search .header__search-wrapper.empty::after{left:var(--cp-spacer-2)}@media (max-width: 575.98px){.cp-header-search .header__search-wrapper.empty::after{display:none}}.cp-header-search .header__search-input:focus{border:1px solid var(--cp-tertiary, #202654);outline:var(--cp-tertiary, #202654)}.cp-header-search .header__search-list{width:100%;min-width:30rem;position:absolute;top:48px;max-height:calc(100vh - 60px - 40px);overflow-y:auto;z-index:1032;background:#fff}[dir=\"ltr\"] .cp-header-search .header__search-list{right:0}[dir=\"rtl\"] .cp-header-search .header__search-list{left:0}@media (max-width: 575.98px){.cp-header-search .header__search-list{width:98vw;min-width:15rem}}.cp-header-search figure{margin:0;padding:0}.cp-header-search figcaption{font-weight:700;font-size:1rem;padding:var(--cp-spacer-3) var(--cp-spacer-3) var(--cp-spacer-1) var(--cp-spacer-3);border-bottom:1px solid var(--cp-light, #fafafa);margin-bottom:var(--cp-spacer-1)}.cp-header-search .tool-result__container{position:relative;display:grid;grid-template-columns:2.5fr 1fr;grid-template-rows:2fr;gap:0 0;grid-template-areas:\"main category\"}.cp-header-search .tool-result__main{grid-area:main;display:flex;flex-direction:column}.cp-header-search .tool-result__heading{grid-area:heading;color:black}.cp-header-search .tool-result__heading:hover{color:inherit;text-decoration:none}.cp-header-search .tool-result__heading::before{content:\" \";position:absolute;top:0;width:100%;height:100%}[dir=\"ltr\"] .cp-header-search .tool-result__heading::before{left:0}[dir=\"rtl\"] .cp-header-search .tool-result__heading::before{right:0}.cp-header-search .tool-result__description{font-size:0.875rem;margin:0}.cp-header-search .tool-result__category{font-size:0.875rem;margin:0;text-align:end}.cp-header-search .account-result__container{position:relative;display:flex;justify-content:space-between}.cp-header-search .account-result__main_section{display:flex;flex-direction:column}.cp-header-search .account-result__action-section{display:flex}.cp-header-search .account-result__domain{font-size:0.875rem}.cp-header-search .account-result__username{margin:0}.cp-header-search .accounts__show-more-link{display:block;font-size:0.875rem}[dir=\"ltr\"] .cp-header-search .accounts__show-more-link{padding:var(--cp-spacer-3) 0 var(--cp-spacer-3) var(--cp-spacer-3)}[dir=\"rtl\"] .cp-header-search .accounts__show-more-link{padding:var(--cp-spacer-3) var(--cp-spacer-3) var(--cp-spacer-3) 0}[dir=\"ltr\"] .cp-header-search .button--account-action{margin-left:var(--cp-spacer-3)}[dir=\"rtl\"] .cp-header-search .button--account-action{margin-right:var(--cp-spacer-3)}.cp-header-search .button__image-container{display:flex;align-items:center;justify-content:center}.cp-header-search .button__image{width:90%;height:90%}";

    const locale$t = getLocaleInstance();
    const UI_OVERLAY_CLAIM_NAME$2 = "cp-header-search";
    const MINIMUM_SEARCH_STRING_LENGTH = 2;
    const RESULTS_TO_DISPLAY_COUNT = 5;
    const CpHeaderSearch$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.searchInputFocusChange = createEvent(this, "searchInputFocusChange", 7);
        /**
         * List of sorted applications when the user is searching.
         */
        this.matchedApplicationList = [];
        /**
         * If the search menu is open
         */
        this.menuIsOpen = false;
        /**
         * The list account service used for fetching account data.
         */
        this.listAccountsService = ListAccountsService;
        /**
         * The fetched account results from the list accounts API.
         */
        this.accountResults = [];
        /**
         * Handles input from user into the input element. Calls helper functions to update properties.
         * @param event Event from input
         */
        this.handleInputChange = (event) => {
          var _a;
          this.inputText = event.target.value.trim();
          const result = this.searchService.search(this.inputText, { limit: state.appSearchResultsLimit });
          this.matchedApplicationList = result.map(app => {
            return app.item;
          });
          (_a = this.combobox) === null || _a === void 0 ? void 0 : _a.goTo(undefined);
          // This is not ideal but this is the current logic of checking if the menu is open during input handling, just exposing it here.
          this.menuIsOpen = this.inputText.length > 0;
        };
        /**
         * Clears previous account search results, for better UX.
         */
        this.clearPreviousAccountSearchResults = () => {
          this.accountResults = [];
          this.listAccountsPageLink = null;
        };
        /**
         *  Fetches list accounts based on the input text and updates the local variables for accountResults and listAccountsPageLink.
         */
        this.fetchListAccounts = () => {
          if (!state.permissions.listAccounts)
            return;
          this.clearPreviousAccountSearchResults();
          if (this.inputText.length < MINIMUM_SEARCH_STRING_LENGTH)
            return;
          this.listAccountsService
            .getAccounts(this.inputText, RESULTS_TO_DISPLAY_COUNT)
            .then((data) => {
            this.accountResults = data.accounts;
            if (data.records > RESULTS_TO_DISPLAY_COUNT) {
              this.listAccountsPageLink = this.listAccountsService.getRelativePathToListAccountsPage(this.inputText);
            }
          });
        };
        /**
         * Handles keyboard navigation on the list of items.
         * @param event keyboard event from the user input
         * @returns void
         */
        this.delegateHotKeyHandling = (event) => {
          var _a, _b, _c, _d, _e, _f, _g;
          if (!((_a = this.combobox) === null || _a === void 0 ? void 0 : _a.currentGridcell) && ["ArrowRight", "ArrowLeft"].includes(event.key)) {
            return;
          }
          switch (event.key) {
            case "ArrowDown":
              (_b = this.combobox) === null || _b === void 0 ? void 0 : _b.goTo(this.combobox.nextRow);
              break;
            case "ArrowUp":
              (_c = this.combobox) === null || _c === void 0 ? void 0 : _c.goTo(this.combobox.previousRow);
              break;
            case "ArrowRight":
              (_d = this.combobox) === null || _d === void 0 ? void 0 : _d.goTo(this.combobox.nextGridcell);
              break;
            case "ArrowLeft":
              (_e = this.combobox) === null || _e === void 0 ? void 0 : _e.goTo(this.combobox.previousGridcell);
              break;
            case "Enter":
              (_g = (_f = this.combobox) === null || _f === void 0 ? void 0 : _f.currentGridcell) === null || _g === void 0 ? void 0 : _g.click();
              break;
            case "Esc": // IE/Edge specific value
            case "Escape":
              this.inputText = "";
              this.closeMenu();
              break;
            default:
              return; // Quit when this doesn't handle the key event.
          }
          event.preventDefault();
        };
        /**
         * Closes the list group and resets necessary properties.
         */
        this.closeMenu = () => {
          this.matchedApplicationList = [];
          this.menuIsOpen = false;
        };
        /**
         * Focuses the search input.
         */
        this.focusSearchInput = () => {
          // timeout needed to focus the search on load in Safari.
          // https://stackoverflow.com/questions/54229359/why-does-select-not-work-on-safari-with-reactjs
          setTimeout(() => { var _a; return (_a = this.searchInput) === null || _a === void 0 ? void 0 : _a.focus(); }, 0);
        };
        this.handleSearchInputFocus = (event) => {
          this.searchInputFocusChange.emit({ isFocused: true });
          this.handleInputChange(event);
        };
        /**
         * Focuses the search when the wrapper div is clicked. This is needed due to the search icon being a dead area when clicking on the input element.
         * This ensures the input will get focused even if the search icon is clicked.
         * On mobile viewports, the function will return as the icon is not present on mobile and will allow
         * the X icon to reset inputText's state.
         */
        this.onWrapperClick = () => {
          var _a;
          const viewportSize = getComputedStyle(document.documentElement).getPropertyValue("--cp-current-viewport");
          if (/xs/.test(viewportSize)) {
            return;
          }
          else {
            (_a = this.searchInput) === null || _a === void 0 ? void 0 : _a.focus();
          }
        };
        /**
         * When mobile styles are present, handles the click input for the 'X' on the input.
         */
        this.clearMobileSearch = () => {
          this.inputText = "";
          if (this.searchInput) {
            this.searchInput.value = this.inputText;
          }
          this.closeMenu();
        };
        this.fetchListAccounts = debounce$1(this.fetchListAccounts, 500).bind(this);
      }
      /**
       * Listens for the keyboard shortcut to focus the search input.
       */
      handleKeydown(event) {
        // Firefox listens to the "/" and "Cmd + F" to trigger the browser search.
        // We are overriding the "/" here to focus our search.
        // To do that, we must listen on the keydown instead of the keyup event.
        const tag = event.target.tagName.toLowerCase();
        if (tag === "input" || tag === "select" || tag === "textarea") {
          return;
        }
        // Listen for either numberpad or left of shift / key
        // Don't focus this element if the control key and / is pressed.
        // Control + / focuses the main menu filter
        // Ignore if '/' is pressed inside the main menu navigation. That allows the user to use / inside that search box as part of their search string.
        if (!(event.key === "/" && event.ctrlKey) &&
          (event.key === "/" || event.key === "Divide") &&
          !this._searchIsFocused() &&
          !this._mainMenuSearchIsFocused()) {
          event.preventDefault();
          this.focusSearchInput();
        }
      }
      /**
       * Handles when a user moves away from the search component to another item inside the header,
       * either via click-out or keyboard navigation
       */
      handleFocusOut(event) {
        // For the focusout event, the event.relatedTarget is the new element receiving focus.
        // If this element is an item in the search list, we leave the list open.
        const relTarget = event.relatedTarget;
        if (relTarget === null || relTarget === void 0 ? void 0 : relTarget.hasAttribute("data-search-result")) {
          return;
        }
        this.closeMenu();
        this.searchInputFocusChange.emit({ isFocused: false });
      }
      /**
       * StencilJS lifecycle. Gets values from state.
       */
      componentWillLoad() {
        this.directoryPrefix = state.appName === AppName.Whm ? state.directoryPrefix + "/" : state.directoryPrefix;
        this.applicationList = state.appList;
        this.searchService = new Fuse(this.applicationList, SEARCH_OPTIONS);
      }
      /**
       * StencilJS lifecycle. Initializes all needed variables.
       */
      componentDidLoad() {
        var _a;
        (_a = this.searchInput) === null || _a === void 0 ? void 0 : _a.addEventListener("input", e => {
          this.handleInputChange(e);
          this.fetchListAccounts();
        });
      }
      /**
       * StencilJS lifecycle. Called after a render.
       */
      componentDidRender() {
        var _a;
        if (this.focusSearch) {
          this.focusSearchInput();
        }
        if (!this.combobox) {
          this.combobox = this.getCombobox();
        }
        // Track search link clicks from cPanel Jupiter search menu.
        const searchLinkEls = (_a = this.searchLinkList) === null || _a === void 0 ? void 0 : _a.querySelectorAll("li>a");
        if (searchLinkEls === null || searchLinkEls === void 0 ? void 0 : searchLinkEls.length) {
          searchLinkEls.forEach(linkEl => {
            linkEl.addEventListener("click", this.trackSearchLinkClicks);
          });
        }
      }
      trackSearchLinkClicks(event) {
        var _a;
        const linkEl = event.currentTarget;
        (_a = window["mixpanel"]) === null || _a === void 0 ? void 0 : _a.track(state.appName + "-Search-Menu-Nav-Link", { "nav-link-id": linkEl.id });
      }
      /**
       * StencilJS lifecycle. Handles the overlay.
       */
      componentWillUpdate() {
        this.updateOverlay();
      }
      getCombobox() {
        const el = this.el.querySelector("#search-combobox");
        if (el === null || el === undefined) {
          return;
        }
        return new Combobox(el);
      }
      /**
       * Adds and removes the overlay based on the list of available items in search list.
       * If there are no items in the list, the overlay will not be present.
       * @returns void
       */
      updateOverlay() {
        if (this.inputText && this._searchIsFocused()) {
          state.uiOverlay.claim(UI_OVERLAY_CLAIM_NAME$2);
        }
        else {
          state.uiOverlay.release(UI_OVERLAY_CLAIM_NAME$2);
        }
      }
      _searchIsFocused() {
        const activeElement = getActiveElement(document);
        return this.searchInput === activeElement;
      }
      /**
       * This function finds the search input in the main menu navigation and checks if it is the current active element.
       */
      _mainMenuSearchIsFocused() {
        var _a, _b;
        const activeElement = getActiveElement(document);
        const mainMenuSearchEl = (_b = (_a = document
          .querySelector("cp-main-menu")) === null || _a === void 0 ? void 0 : _a.querySelector("cp-main-menu-nav-whm")) === null || _b === void 0 ? void 0 : _b.querySelector(".cp-main-menu__filter-input");
        return activeElement === mainMenuSearchEl;
      }
      /**
       * Whether the search results component should display the 'No results found' element. The array of results must be empty and a search input must exist
       */
      get showNoSearchResults() {
        return !this.matchedApplicationList.length && !!this.inputText && this._searchIsFocused();
      }
      showAccountResults() {
        return state.appName === AppName.Whm && this.accountResults.length > 0;
      }
      /**
       * The DOM element that will be visible based on whether there are search results visible or not. When there are no results to display an element that shows 'No results found.' is visible. When there are results to display a list of applications is shown, with the top of list highlighted and focused. If a URL exists for the application object then an anchor tag is used for the list element.
       */
      get searchResultsDisplay() {
        return this.showNoSearchResults ? (
        /* NOTE: tabindex attribute is required on <a> tags to make them focusable in Safari.
        Without this attribute, the links do not work and clicking one dismisses the dropdown. */
        h("div", { tabindex: "0", class: "list-group-item list-group-item-action active", "aria-current": "true", key: "no-results-option", role: "row" }, locale$t.maketext("No results found."))) : (this.matchedApplicationList.map((app, i) => {
          return toolSearchResult(app, i, this.directoryPrefix);
        }));
      }
      _wrapperClass() {
        return "header__search-wrapper " + (this.inputText ? "" : "empty");
      }
      /**
       * Takes as input the appname and returns the correct placeholder text for the text.
       * Cpanel does not support account searching whereas WHM does.
       * @returns string
       */
      getSearchPlaceholder(appName) {
        if (appName === AppName.Cpanel || isDnsOnly()) {
          return locale$t.maketext("Search Tools (/)[comment,placeholder text]");
        }
        if (appName === AppName.Whm) {
          return locale$t.maketext("Search Tools and Accounts (/)[comment,placeholder text]");
        }
        return locale$t.maketext("Search");
      }
      render() {
        return (h(Host, { class: "cp-header-search" }, h("div", { class: this._wrapperClass(), role: "combobox", id: "search-combobox", "aria-expanded": this.menuIsOpen ? "true" : "false", "aria-haspopup": "grid", "aria-owns": "search-results", onClick: this.onWrapperClick }, h("input", { id: "search-input", "aria-autocomplete": "list", "aria-controls": "search-results", class: "header__search-input", type: "search", autocomplete: "off", spellcheck: false, placeholder: this.getSearchPlaceholder(state.appName), "aria-label": this.getSearchPlaceholder(state.appName), value: this.inputText || "", onFocus: ev => this.handleSearchInputFocus(ev), onKeyDown: this.delegateHotKeyHandling, ref: input => {
            this.searchInput = input;
          } }), h("button", { onClick: this.clearMobileSearch, class: "header__search-clear-search-button" }, h("cp-icon", { name: "close-line", mode: IconMode.Centered })), h("div", Object.assign({ id: "search-results", class: "list-group header__search-list" }, (this.menuIsOpen ? { role: "grid" } : {})), this.menuIsOpen && (h("div", null, h("figure", null, h("figcaption", null, locale$t.maketext("Tools")), h("ul", { class: "list-group", ref: el => (this.searchLinkList = el) }, this.searchResultsDisplay)), this.showAccountResults() && (h("figure", null, h("figcaption", null, locale$t.maketext("Accounts")), h("ul", { class: "list-group" }, this.accountResults.map(account => accountSearchResult(account, state.directoryPrefix, state.permissions, state.user))), this.listAccountsPageLink && (h("a", { tabindex: "0", class: "accounts__show-more-link", "data-search-result": true, href: this.listAccountsPageLink }, locale$t.maketext("See more account results for “[_1]”.", this.inputText)))))))))));
      }
      get el() { return this; }
      static get style() { return cpHeaderSearchCss; }
    };

    // Copyright 2022 cPanel, L.L.C. - All rights reserved.
    // copyright@cpanel.net
    // https://cpanel.net
    // This code is subject to the cPanel license. Unauthorized copying is prohibited
    /**
     * Viewport sizes as defined by Bootstrap
     */
    var ViewportSize;
    (function (ViewportSize) {
      ViewportSize["xs"] = "xs";
      ViewportSize["sm"] = "sm";
      ViewportSize["md"] = "md";
      ViewportSize["lg"] = "lg";
      ViewportSize["xl"] = "xl";
    })(ViewportSize || (ViewportSize = {}));

    const cpHeaderSearchControlCss = ".cp-header-search-control{display:block}.header-controls__search-component{flex-grow:1}[dir=\"ltr\"] .header-controls__search-component{margin-left:var(--cp-spacer-3)}[dir=\"rtl\"] .header-controls__search-component{margin-right:var(--cp-spacer-3)}.search-controls{display:flex;flex-direction:row;flex-wrap:nowrap;justify-content:space-between;align-items:center}.search-controls__back-button{display:none}.search-controls__back-button:hover{cursor:pointer}@media (max-width: 575.98px){.search-controls__back-button{display:initial;background-color:transparent;border:none;color:var(--cp-gray-dark, #3c4d5a);width:var(--cp-spacer-5)}[dir=\"ltr\"] .search-controls__back-button{padding-left:0}[dir=\"rtl\"] .search-controls__back-button{padding-right:0}}@media (max-width: 575.98px){.hide-on-mobile{display:none}}";

    const locale$s = getLocaleInstance();
    const CpSearchHeaderControl = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.toggleMobileSearch = createEvent(this, "toggleMobileSearch", 7);
        /**
         * Emits an a custom event outside the component.
         * @param e Event
         */
        this.toggleMobileSearchHandler = (e) => {
          this.toggleMobileSearch.emit(e);
          this.focusSearch = false;
        };
        /**
         * Gets the current viewport size.
         */
        this.getViewportSize = () => {
          const viewportSize = getComputedStyle(document.documentElement).getPropertyValue("--cp-current-viewport");
          return ViewportSize[viewportSize];
        };
        /**
         * Determines if the current viewport is a mobile view.
         * @param viewportSize ViewportSize
         */
        this.isMobileViewport = (viewportSize) => {
          const isMobile = /xs|sm/.test(viewportSize);
          return isMobile;
        };
      }
      onResize(event) {
        const isMobile = this.isMobileViewport(this.getViewportSize());
        if (this.isMobileSearch && !isMobile) {
          this.toggleMobileSearchHandler(event);
        }
      }
      render() {
        return (h(Host, { class: "cp-header-search-control" }, h("div", { class: (!this.isMobileSearch ? "hide-on-mobile" : "") + " search-controls" }, h("button", { class: "search-controls__back-button", "aria-label": locale$s.maketext("Back to header"), onClick: this.toggleMobileSearchHandler }, h("cp-icon", { name: "arrow-left-line", size: IconSize.xl, mode: IconMode.Inline, class: "search-controls__back-arrow" })), h("cp-header-search", { class: "header-controls__search-component", "focus-search": this.focusSearch, isVisible: this.isMobileSearch }))));
      }
      get el() { return this; }
      static get style() { return cpHeaderSearchControlCss; }
    };

    const cpHeaderUserAccountControlCss = ".cp-header-user-account-control{display:block}.cp-header-user-account-control .user-menu{border:1px solid var(--cp-tertiary, #202654);text-decoration:none;cursor:pointer;color:inherit;background:transparent;height:100%;width:100%;padding:var(--cp-spacer-2);display:flex;align-items:center;justify-content:center;box-sizing:border-box;border-radius:50%}.cp-header-user-account-control .user-menu--expanded{background-color:var(--cp-tertiary, #202654);color:var(--cp--tertiary-contrast, #e5e7e9)}";

    const locale$r = getLocaleInstance();
    const CpUserAccountHeaderControl = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.toggleExpand = createEvent(this, "toggleExpand", 7);
      }
      /**
       * Listens for clicks and flips the menu expanded state.
       */
      toggleMenu(e) {
        e.stopPropagation();
        this.toggleExpand.emit(!this.isMenuExpanded);
      }
      /**
       * Handles when a user moves away from the account menu component.
       */
      handleFocusOut() {
        this.toggleExpand.emit(false);
      }
      render() {
        return (h(Host, { class: "cp-header-user-account-control" }, h("cp-header-control", { "show-badge": false }, h("button", { tabindex: "0", id: "user-menu-button", class: this.isMenuExpanded ? "user-menu user-menu--expanded" : "user-menu", title: locale$r.maketext("User Menu"), "aria-label": locale$r.maketext("User Menu") }, h("cp-icon", { name: "user-line", size: IconSize.sm, mode: IconMode.Centered }))), this.isMenuExpanded && (h("cp-header-user-account-dropdown", { menuItems: this.menuItems }))));
      }
      get el() { return this; }
      static get style() { return cpHeaderUserAccountControlCss; }
    };

    const cpHeaderUserAccountDropdownCss = ".list-group{--cp-list-group-color:#243746;--cp-list-group-bg:var(--cp-component-bg, #fff);--cp-list-group-border-color:rgba(0, 0, 0, 0.125);--cp-list-group-border-width:1px;--cp-list-group-border-radius:0.25rem;--cp-list-group-item-padding-x:1rem;--cp-list-group-item-padding-y:0.5rem;--cp-list-group-action-color:#54636f;--cp-list-group-action-hover-color:var(--cp-body-color, #243746);--cp-list-group-action-hover-bg:#fafafa;--cp-list-group-action-active-color:#243746;--cp-list-group-action-active-bg:var(--cp-body-bg, #fafafa);--cp-list-group-disabled-color:#6d7983;--cp-list-group-disabled-bg:#fff;--cp-list-group-active-color:#fff;--cp-list-group-active-bg:#003da6;--cp-list-group-active-border-color:#003da6;display:flex;flex-direction:column;margin-bottom:0;border-radius:var(--cp-list-group-border-radius)}[dir=\"ltr\"] .list-group{padding-left:0}[dir=\"rtl\"] .list-group{padding-right:0}.list-group-numbered{list-style-type:none;counter-reset:section}.list-group-numbered>.list-group-item::before{content:counters(section, \".\") \". \";counter-increment:section}.list-group-item-action{width:100%;color:var(--cp-list-group-action-color);text-align:inherit}.list-group-item-action:hover,.list-group-item-action:focus{z-index:1;color:var(--cp-list-group-action-hover-color);text-decoration:none;background-color:var(--cp-list-group-action-hover-bg)}.list-group-item-action:active{color:var(--cp-list-group-action-active-color);background-color:var(--cp-list-group-action-active-bg)}.list-group-item{position:relative;display:block;padding:var(--cp-list-group-item-padding-y) var(--cp-list-group-item-padding-x);color:var(--cp-list-group-color);text-decoration:none;background-color:var(--cp-list-group-bg);border:var(--cp-list-group-border-width) solid var(--cp-list-group-border-color)}.list-group-item:first-child{border-top-left-radius:inherit;border-top-right-radius:inherit}.list-group-item:last-child{border-bottom-right-radius:inherit;border-bottom-left-radius:inherit}.list-group-item.disabled,.list-group-item:disabled{color:var(--cp-list-group-disabled-color);pointer-events:none;background-color:var(--cp-list-group-disabled-bg)}.list-group-item.active{z-index:2;color:var(--cp-list-group-active-color);background-color:var(--cp-list-group-active-bg);border-color:var(--cp-list-group-active-border-color)}.list-group-item+.list-group-item{border-top-width:0}.list-group-item+.list-group-item.active{margin-top:calc(-1 * var(--cp-list-group-border-width));border-top-width:var(--cp-list-group-border-width)}.list-group-horizontal{flex-direction:row}[dir=\"ltr\"] .list-group-horizontal>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--cp-list-group-border-radius);border-top-right-radius:0}[dir=\"rtl\"] .list-group-horizontal>.list-group-item:first-child:not(:last-child){border-bottom-right-radius:var(--cp-list-group-border-radius);border-top-left-radius:0}[dir=\"ltr\"] .list-group-horizontal>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--cp-list-group-border-radius);border-bottom-left-radius:0}[dir=\"rtl\"] .list-group-horizontal>.list-group-item:last-child:not(:first-child){border-top-left-radius:var(--cp-list-group-border-radius);border-bottom-right-radius:0}.list-group-horizontal>.list-group-item.active{margin-top:0}.list-group-horizontal>.list-group-item+.list-group-item{border-top-width:var(--cp-list-group-border-width)}[dir=\"ltr\"] .list-group-horizontal>.list-group-item+.list-group-item{border-left-width:0}[dir=\"rtl\"] .list-group-horizontal>.list-group-item+.list-group-item{border-right-width:0}[dir=\"ltr\"] .list-group-horizontal>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--cp-list-group-border-width));border-left-width:var(--cp-list-group-border-width)}[dir=\"rtl\"] .list-group-horizontal>.list-group-item+.list-group-item.active{margin-right:calc(-1 * var(--cp-list-group-border-width));border-right-width:var(--cp-list-group-border-width)}@media (min-width: 576px){.list-group-horizontal-sm{flex-direction:row}[dir=\"ltr\"] .list-group-horizontal-sm>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--cp-list-group-border-radius);border-top-right-radius:0}[dir=\"rtl\"] .list-group-horizontal-sm>.list-group-item:first-child:not(:last-child){border-bottom-right-radius:var(--cp-list-group-border-radius);border-top-left-radius:0}[dir=\"ltr\"] .list-group-horizontal-sm>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--cp-list-group-border-radius);border-bottom-left-radius:0}[dir=\"rtl\"] .list-group-horizontal-sm>.list-group-item:last-child:not(:first-child){border-top-left-radius:var(--cp-list-group-border-radius);border-bottom-right-radius:0}.list-group-horizontal-sm>.list-group-item.active{margin-top:0}.list-group-horizontal-sm>.list-group-item+.list-group-item{border-top-width:var(--cp-list-group-border-width)}[dir=\"ltr\"] .list-group-horizontal-sm>.list-group-item+.list-group-item{border-left-width:0}[dir=\"rtl\"] .list-group-horizontal-sm>.list-group-item+.list-group-item{border-right-width:0}[dir=\"ltr\"] .list-group-horizontal-sm>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--cp-list-group-border-width));border-left-width:var(--cp-list-group-border-width)}[dir=\"rtl\"] .list-group-horizontal-sm>.list-group-item+.list-group-item.active{margin-right:calc(-1 * var(--cp-list-group-border-width));border-right-width:var(--cp-list-group-border-width)}}@media (min-width: 768px){.list-group-horizontal-md{flex-direction:row}[dir=\"ltr\"] .list-group-horizontal-md>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--cp-list-group-border-radius);border-top-right-radius:0}[dir=\"rtl\"] .list-group-horizontal-md>.list-group-item:first-child:not(:last-child){border-bottom-right-radius:var(--cp-list-group-border-radius);border-top-left-radius:0}[dir=\"ltr\"] .list-group-horizontal-md>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--cp-list-group-border-radius);border-bottom-left-radius:0}[dir=\"rtl\"] .list-group-horizontal-md>.list-group-item:last-child:not(:first-child){border-top-left-radius:var(--cp-list-group-border-radius);border-bottom-right-radius:0}.list-group-horizontal-md>.list-group-item.active{margin-top:0}.list-group-horizontal-md>.list-group-item+.list-group-item{border-top-width:var(--cp-list-group-border-width)}[dir=\"ltr\"] .list-group-horizontal-md>.list-group-item+.list-group-item{border-left-width:0}[dir=\"rtl\"] .list-group-horizontal-md>.list-group-item+.list-group-item{border-right-width:0}[dir=\"ltr\"] .list-group-horizontal-md>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--cp-list-group-border-width));border-left-width:var(--cp-list-group-border-width)}[dir=\"rtl\"] .list-group-horizontal-md>.list-group-item+.list-group-item.active{margin-right:calc(-1 * var(--cp-list-group-border-width));border-right-width:var(--cp-list-group-border-width)}}@media (min-width: 992px){.list-group-horizontal-lg{flex-direction:row}[dir=\"ltr\"] .list-group-horizontal-lg>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--cp-list-group-border-radius);border-top-right-radius:0}[dir=\"rtl\"] .list-group-horizontal-lg>.list-group-item:first-child:not(:last-child){border-bottom-right-radius:var(--cp-list-group-border-radius);border-top-left-radius:0}[dir=\"ltr\"] .list-group-horizontal-lg>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--cp-list-group-border-radius);border-bottom-left-radius:0}[dir=\"rtl\"] .list-group-horizontal-lg>.list-group-item:last-child:not(:first-child){border-top-left-radius:var(--cp-list-group-border-radius);border-bottom-right-radius:0}.list-group-horizontal-lg>.list-group-item.active{margin-top:0}.list-group-horizontal-lg>.list-group-item+.list-group-item{border-top-width:var(--cp-list-group-border-width)}[dir=\"ltr\"] .list-group-horizontal-lg>.list-group-item+.list-group-item{border-left-width:0}[dir=\"rtl\"] .list-group-horizontal-lg>.list-group-item+.list-group-item{border-right-width:0}[dir=\"ltr\"] .list-group-horizontal-lg>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--cp-list-group-border-width));border-left-width:var(--cp-list-group-border-width)}[dir=\"rtl\"] .list-group-horizontal-lg>.list-group-item+.list-group-item.active{margin-right:calc(-1 * var(--cp-list-group-border-width));border-right-width:var(--cp-list-group-border-width)}}@media (min-width: 1200px){.list-group-horizontal-xl{flex-direction:row}[dir=\"ltr\"] .list-group-horizontal-xl>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--cp-list-group-border-radius);border-top-right-radius:0}[dir=\"rtl\"] .list-group-horizontal-xl>.list-group-item:first-child:not(:last-child){border-bottom-right-radius:var(--cp-list-group-border-radius);border-top-left-radius:0}[dir=\"ltr\"] .list-group-horizontal-xl>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--cp-list-group-border-radius);border-bottom-left-radius:0}[dir=\"rtl\"] .list-group-horizontal-xl>.list-group-item:last-child:not(:first-child){border-top-left-radius:var(--cp-list-group-border-radius);border-bottom-right-radius:0}.list-group-horizontal-xl>.list-group-item.active{margin-top:0}.list-group-horizontal-xl>.list-group-item+.list-group-item{border-top-width:var(--cp-list-group-border-width)}[dir=\"ltr\"] .list-group-horizontal-xl>.list-group-item+.list-group-item{border-left-width:0}[dir=\"rtl\"] .list-group-horizontal-xl>.list-group-item+.list-group-item{border-right-width:0}[dir=\"ltr\"] .list-group-horizontal-xl>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--cp-list-group-border-width));border-left-width:var(--cp-list-group-border-width)}[dir=\"rtl\"] .list-group-horizontal-xl>.list-group-item+.list-group-item.active{margin-right:calc(-1 * var(--cp-list-group-border-width));border-right-width:var(--cp-list-group-border-width)}}@media (min-width: 1400px){.list-group-horizontal-xxl{flex-direction:row}[dir=\"ltr\"] .list-group-horizontal-xxl>.list-group-item:first-child:not(:last-child){border-bottom-left-radius:var(--cp-list-group-border-radius);border-top-right-radius:0}[dir=\"rtl\"] .list-group-horizontal-xxl>.list-group-item:first-child:not(:last-child){border-bottom-right-radius:var(--cp-list-group-border-radius);border-top-left-radius:0}[dir=\"ltr\"] .list-group-horizontal-xxl>.list-group-item:last-child:not(:first-child){border-top-right-radius:var(--cp-list-group-border-radius);border-bottom-left-radius:0}[dir=\"rtl\"] .list-group-horizontal-xxl>.list-group-item:last-child:not(:first-child){border-top-left-radius:var(--cp-list-group-border-radius);border-bottom-right-radius:0}.list-group-horizontal-xxl>.list-group-item.active{margin-top:0}.list-group-horizontal-xxl>.list-group-item+.list-group-item{border-top-width:var(--cp-list-group-border-width)}[dir=\"ltr\"] .list-group-horizontal-xxl>.list-group-item+.list-group-item{border-left-width:0}[dir=\"rtl\"] .list-group-horizontal-xxl>.list-group-item+.list-group-item{border-right-width:0}[dir=\"ltr\"] .list-group-horizontal-xxl>.list-group-item+.list-group-item.active{margin-left:calc(-1 * var(--cp-list-group-border-width));border-left-width:var(--cp-list-group-border-width)}[dir=\"rtl\"] .list-group-horizontal-xxl>.list-group-item+.list-group-item.active{margin-right:calc(-1 * var(--cp-list-group-border-width));border-right-width:var(--cp-list-group-border-width)}}.list-group-flush{border-radius:0}.list-group-flush>.list-group-item{border-width:0 0 var(--cp-list-group-border-width)}.list-group-flush>.list-group-item:last-child{border-bottom-width:0}.list-group-item-primary{color:#002564;background-color:#ccd8ed}.list-group-item-primary.list-group-item-action:hover,.list-group-item-primary.list-group-item-action:focus{color:#002564;background-color:#b8c2d5}.list-group-item-primary.list-group-item-action.active{color:#fff;background-color:#002564;border-color:#002564}.list-group-item-success{color:#0f5132;background-color:#d1e7dd}.list-group-item-success.list-group-item-action:hover,.list-group-item-success.list-group-item-action:focus{color:#0f5132;background-color:#bcd0c7}.list-group-item-success.list-group-item-action.active{color:#fff;background-color:#0f5132;border-color:#0f5132}.list-group-item-info{color:#055160;background-color:#cff4fc}.list-group-item-info.list-group-item-action:hover,.list-group-item-info.list-group-item-action:focus{color:#055160;background-color:#badce3}.list-group-item-info.list-group-item-action.active{color:#fff;background-color:#055160;border-color:#055160}.list-group-item-warning{color:#664d03;background-color:#fff3cd}.list-group-item-warning.list-group-item-action:hover,.list-group-item-warning.list-group-item-action:focus{color:#664d03;background-color:#e6dbb9}.list-group-item-warning.list-group-item-action.active{color:#fff;background-color:#664d03;border-color:#664d03}.list-group-item-danger{color:#842029;background-color:#f8d7da}.list-group-item-danger.list-group-item-action:hover,.list-group-item-danger.list-group-item-action:focus{color:#842029;background-color:#dfc2c4}.list-group-item-danger.list-group-item-action.active{color:#fff;background-color:#842029;border-color:#842029}.list-group-item-light{color:#646464;background-color:#fefefe}.list-group-item-light.list-group-item-action:hover,.list-group-item-light.list-group-item-action:focus{color:#646464;background-color:#e5e5e5}.list-group-item-light.list-group-item-action.active{color:#fff;background-color:#646464;border-color:#646464}.list-group-item-dark{color:#16212a;background-color:#d3d7da}.list-group-item-dark.list-group-item-action:hover,.list-group-item-dark.list-group-item-action:focus{color:#16212a;background-color:#bec2c4}.list-group-item-dark.list-group-item-action.active{color:#fff;background-color:#16212a;border-color:#16212a}.list-group-item-accent{color:#85371c;background-color:#f8ded5}.list-group-item-accent.list-group-item-action:hover,.list-group-item-accent.list-group-item-action:focus{color:#85371c;background-color:#dfc8c0}.list-group-item-accent.list-group-item-action.active{color:#fff;background-color:#85371c;border-color:#85371c}.list-group-item-tertiary{color:#131732;background-color:#d2d4dd}.list-group-item-tertiary.list-group-item-action:hover,.list-group-item-tertiary.list-group-item-action:focus{color:#131732;background-color:#bdbfc7}.list-group-item-tertiary.list-group-item-action.active{color:#fff;background-color:#131732;border-color:#131732}.list-group{background-color:var(--cp-component-bg, #fff)}.list-group-item,.list-group-item-action{box-sizing:border-box;border:0 solid transparent}.list-group-item.active,.list-group-item-action.active{background-color:var(--cp-body-bg, #fafafa);color:var(--cp-body-color, #243746);border:0 solid transparent}.list-group-item-action:focus,.list-group-item-action:hover,.list-group-item-action:active,.list-group-item.active,.list-group-item-action.active{background-color:#e5e7e9}.cp-header-user-account-dropdown{display:block;z-index:1030;position:relative}@media (max-width: 575.98px){.cp-header-user-account-dropdown{position:unset}}.cp-header-user-account-dropdown .user-account-menu__list{position:absolute;top:0.8rem;border-radius:0.25rem;border:1px solid var(--cp-light, #fafafa);box-shadow:0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);overflow:hidden;list-style-type:none;padding:0;margin:var(--cp-spacer-1);background:var(--cp-header-bg, #fff);min-width:248px;overflow-y:auto;max-height:calc(100vh - 60px)}[dir=\"ltr\"] .cp-header-user-account-dropdown .user-account-menu__list{right:0}[dir=\"rtl\"] .cp-header-user-account-dropdown .user-account-menu__list{left:0}@media (max-width: 575.98px){.cp-header-user-account-dropdown .user-account-menu__list{width:98vw;border:none;box-shadow:none}[dir=\"ltr\"] .cp-header-user-account-dropdown .user-account-menu__list{left:0;right:unset}[dir=\"rtl\"] .cp-header-user-account-dropdown .user-account-menu__list{right:0;left:unset}.cp-header-user-account-dropdown .user-account-menu__list.user-account-menu__list--whm{top:calc(60px + 40px)}.cp-header-user-account-dropdown .user-account-menu__list.user-account-menu__list--cpanel{top:60px}}.cp-header-user-account-dropdown .user-account-menu__list-item{padding:var(--cp-spacer-3);border-top:none;border-left:none;border-right:none;border-bottom:1px solid var(--cp-gray-200, #e5e7e9);width:unset;display:flex;align-items:center}.cp-header-user-account-dropdown li:nth-last-child(2) .user-account-menu__list-item{border-bottom:1px solid var(--cp-gray-500, #858f98)}.cp-header-user-account-dropdown .user-account-menu__list-icons{text-decoration:none;vertical-align:middle}[dir=\"ltr\"] .cp-header-user-account-dropdown .user-account-menu__list-icons{padding:0 var(--cp-spacer-3) 0 0}[dir=\"rtl\"] .cp-header-user-account-dropdown .user-account-menu__list-icons{padding:0 0 0 var(--cp-spacer-3)}.cp-header-user-account-dropdown .user-account-menu__list-icons:focus,.cp-header-user-account-dropdown .user-account-menu__list-icons:hover{text-decoration:none}";

    const CpHeaderUserDropdown = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.menuItemPress = createEvent(this, "menuItemPress", 7);
      }
      componentWillLoad() {
        this.appName = state.appName;
      }
      /**
       * Handles the menu item click event.
       * @param menuItem The menu item pressed
       */
      menuItemPressHandler(menuItem) {
        this.menuItemPress.emit(menuItem);
        this.clearSessionOnLogout(menuItem);
      }
      /**
       * Check if the logout menu item is selected and clear sessionStorage.
       * @param menuItem
       */
      clearSessionOnLogout(menuItem) {
        if (menuItem.id === "menu-logout-link") {
          sessionStorage.clear();
        }
      }
      /**
       * CSS class to append to the menu depending on the app where it's used
       */
      get appClass() {
        return this.appName === AppName.Whm ? "user-account-menu__list--whm" : "user-account-menu__list--cpanel";
      }
      render() {
        return (h(Host, { class: "cp-header-user-account-dropdown" }, h("ul", { class: this.appClass + " user-account-menu__list list-group" }, this.menuItems &&
          this.menuItems.map(item => (h("li", null, h("a", { id: `user-account-menu__link--${item.id}`, href: item.href, target: item.target, "aria-label": item.title, title: item.title, class: "list-group-item list-group-item-action user-account-menu__list-item", onClick: _ => this.menuItemPressHandler(item) }, item.icon && (h("cp-icon", { name: item.icon, size: IconSize.xl, class: "user-account-menu__list-icons" })), h("span", { class: "user-account-menu__list-text" }, item.title))))))));
      }
      static get style() { return cpHeaderUserAccountDropdownCss; }
    };

    const cpIconCss = "[class^=ri-],[class*=\" ri-\"]{font-family:\"remixicon\" !important;font-style:normal;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.ri-lg{font-size:1.3333em;line-height:0.75em;vertical-align:-0.0667em}.ri-xl{font-size:1.5em;line-height:0.6666em;vertical-align:-0.075em}.ri-xxs{font-size:0.5em}.ri-xs{font-size:0.75em}.ri-sm{font-size:0.875em}.ri-1x{font-size:1em}.ri-2x{font-size:2em}.ri-3x{font-size:3em}.ri-4x{font-size:4em}.ri-5x{font-size:5em}.ri-6x{font-size:6em}.ri-7x{font-size:7em}.ri-8x{font-size:8em}.ri-9x{font-size:9em}.ri-10x{font-size:10em}.ri-fw{text-align:center;width:1.25em}.ri-24-hours-fill:before{content:\"\\ea01\"}.ri-24-hours-line:before{content:\"\\ea02\"}.ri-4k-fill:before{content:\"\\ea03\"}.ri-4k-line:before{content:\"\\ea04\"}.ri-a-b:before{content:\"\\ea05\"}.ri-account-box-fill:before{content:\"\\ea06\"}.ri-account-box-line:before{content:\"\\ea07\"}.ri-account-circle-fill:before{content:\"\\ea08\"}.ri-account-circle-line:before{content:\"\\ea09\"}.ri-account-pin-box-fill:before{content:\"\\ea0a\"}.ri-account-pin-box-line:before{content:\"\\ea0b\"}.ri-account-pin-circle-fill:before{content:\"\\ea0c\"}.ri-account-pin-circle-line:before{content:\"\\ea0d\"}.ri-add-box-fill:before{content:\"\\ea0e\"}.ri-add-box-line:before{content:\"\\ea0f\"}.ri-add-circle-fill:before{content:\"\\ea10\"}.ri-add-circle-line:before{content:\"\\ea11\"}.ri-add-fill:before{content:\"\\ea12\"}.ri-add-line:before{content:\"\\ea13\"}.ri-admin-fill:before{content:\"\\ea14\"}.ri-admin-line:before{content:\"\\ea15\"}.ri-advertisement-fill:before{content:\"\\ea16\"}.ri-advertisement-line:before{content:\"\\ea17\"}.ri-airplay-fill:before{content:\"\\ea18\"}.ri-airplay-line:before{content:\"\\ea19\"}.ri-alarm-fill:before{content:\"\\ea1a\"}.ri-alarm-line:before{content:\"\\ea1b\"}.ri-alarm-warning-fill:before{content:\"\\ea1c\"}.ri-alarm-warning-line:before{content:\"\\ea1d\"}.ri-album-fill:before{content:\"\\ea1e\"}.ri-album-line:before{content:\"\\ea1f\"}.ri-alert-fill:before{content:\"\\ea20\"}.ri-alert-line:before{content:\"\\ea21\"}.ri-aliens-fill:before{content:\"\\ea22\"}.ri-aliens-line:before{content:\"\\ea23\"}.ri-align-bottom:before{content:\"\\ea24\"}.ri-align-center:before{content:\"\\ea25\"}.ri-align-justify:before{content:\"\\ea26\"}.ri-align-left:before{content:\"\\ea27\"}.ri-align-right:before{content:\"\\ea28\"}.ri-align-top:before{content:\"\\ea29\"}.ri-align-vertically:before{content:\"\\ea2a\"}.ri-alipay-fill:before{content:\"\\ea2b\"}.ri-alipay-line:before{content:\"\\ea2c\"}.ri-amazon-fill:before{content:\"\\ea2d\"}.ri-amazon-line:before{content:\"\\ea2e\"}.ri-anchor-fill:before{content:\"\\ea2f\"}.ri-anchor-line:before{content:\"\\ea30\"}.ri-ancient-gate-fill:before{content:\"\\ea31\"}.ri-ancient-gate-line:before{content:\"\\ea32\"}.ri-ancient-pavilion-fill:before{content:\"\\ea33\"}.ri-ancient-pavilion-line:before{content:\"\\ea34\"}.ri-android-fill:before{content:\"\\ea35\"}.ri-android-line:before{content:\"\\ea36\"}.ri-angularjs-fill:before{content:\"\\ea37\"}.ri-angularjs-line:before{content:\"\\ea38\"}.ri-anticlockwise-2-fill:before{content:\"\\ea39\"}.ri-anticlockwise-2-line:before{content:\"\\ea3a\"}.ri-anticlockwise-fill:before{content:\"\\ea3b\"}.ri-anticlockwise-line:before{content:\"\\ea3c\"}.ri-app-store-fill:before{content:\"\\ea3d\"}.ri-app-store-line:before{content:\"\\ea3e\"}.ri-apple-fill:before{content:\"\\ea3f\"}.ri-apple-line:before{content:\"\\ea40\"}.ri-apps-2-fill:before{content:\"\\ea41\"}.ri-apps-2-line:before{content:\"\\ea42\"}.ri-apps-fill:before{content:\"\\ea43\"}.ri-apps-line:before{content:\"\\ea44\"}.ri-archive-drawer-fill:before{content:\"\\ea45\"}.ri-archive-drawer-line:before{content:\"\\ea46\"}.ri-archive-fill:before{content:\"\\ea47\"}.ri-archive-line:before{content:\"\\ea48\"}.ri-arrow-down-circle-fill:before{content:\"\\ea49\"}.ri-arrow-down-circle-line:before{content:\"\\ea4a\"}.ri-arrow-down-fill:before{content:\"\\ea4b\"}.ri-arrow-down-line:before{content:\"\\ea4c\"}.ri-arrow-down-s-fill:before{content:\"\\ea4d\"}.ri-arrow-down-s-line:before{content:\"\\ea4e\"}.ri-arrow-drop-down-fill:before{content:\"\\ea4f\"}.ri-arrow-drop-down-line:before{content:\"\\ea50\"}.ri-arrow-drop-left-fill:before{content:\"\\ea51\"}.ri-arrow-drop-left-line:before{content:\"\\ea52\"}.ri-arrow-drop-right-fill:before{content:\"\\ea53\"}.ri-arrow-drop-right-line:before{content:\"\\ea54\"}.ri-arrow-drop-up-fill:before{content:\"\\ea55\"}.ri-arrow-drop-up-line:before{content:\"\\ea56\"}.ri-arrow-go-back-fill:before{content:\"\\ea57\"}.ri-arrow-go-back-line:before{content:\"\\ea58\"}.ri-arrow-go-forward-fill:before{content:\"\\ea59\"}.ri-arrow-go-forward-line:before{content:\"\\ea5a\"}.ri-arrow-left-circle-fill:before{content:\"\\ea5b\"}.ri-arrow-left-circle-line:before{content:\"\\ea5c\"}.ri-arrow-left-down-fill:before{content:\"\\ea5d\"}.ri-arrow-left-down-line:before{content:\"\\ea5e\"}.ri-arrow-left-fill:before{content:\"\\ea5f\"}.ri-arrow-left-line:before{content:\"\\ea60\"}.ri-arrow-left-right-fill:before{content:\"\\ea61\"}.ri-arrow-left-right-line:before{content:\"\\ea62\"}.ri-arrow-left-s-fill:before{content:\"\\ea63\"}.ri-arrow-left-s-line:before{content:\"\\ea64\"}.ri-arrow-left-up-fill:before{content:\"\\ea65\"}.ri-arrow-left-up-line:before{content:\"\\ea66\"}.ri-arrow-right-circle-fill:before{content:\"\\ea67\"}.ri-arrow-right-circle-line:before{content:\"\\ea68\"}.ri-arrow-right-down-fill:before{content:\"\\ea69\"}.ri-arrow-right-down-line:before{content:\"\\ea6a\"}.ri-arrow-right-fill:before{content:\"\\ea6b\"}.ri-arrow-right-line:before{content:\"\\ea6c\"}.ri-arrow-right-s-fill:before{content:\"\\ea6d\"}.ri-arrow-right-s-line:before{content:\"\\ea6e\"}.ri-arrow-right-up-fill:before{content:\"\\ea6f\"}.ri-arrow-right-up-line:before{content:\"\\ea70\"}.ri-arrow-up-circle-fill:before{content:\"\\ea71\"}.ri-arrow-up-circle-line:before{content:\"\\ea72\"}.ri-arrow-up-down-fill:before{content:\"\\ea73\"}.ri-arrow-up-down-line:before{content:\"\\ea74\"}.ri-arrow-up-fill:before{content:\"\\ea75\"}.ri-arrow-up-line:before{content:\"\\ea76\"}.ri-arrow-up-s-fill:before{content:\"\\ea77\"}.ri-arrow-up-s-line:before{content:\"\\ea78\"}.ri-artboard-2-fill:before{content:\"\\ea79\"}.ri-artboard-2-line:before{content:\"\\ea7a\"}.ri-artboard-fill:before{content:\"\\ea7b\"}.ri-artboard-line:before{content:\"\\ea7c\"}.ri-article-fill:before{content:\"\\ea7d\"}.ri-article-line:before{content:\"\\ea7e\"}.ri-aspect-ratio-fill:before{content:\"\\ea7f\"}.ri-aspect-ratio-line:before{content:\"\\ea80\"}.ri-asterisk:before{content:\"\\ea81\"}.ri-at-fill:before{content:\"\\ea82\"}.ri-at-line:before{content:\"\\ea83\"}.ri-attachment-2:before{content:\"\\ea84\"}.ri-attachment-fill:before{content:\"\\ea85\"}.ri-attachment-line:before{content:\"\\ea86\"}.ri-auction-fill:before{content:\"\\ea87\"}.ri-auction-line:before{content:\"\\ea88\"}.ri-award-fill:before{content:\"\\ea89\"}.ri-award-line:before{content:\"\\ea8a\"}.ri-baidu-fill:before{content:\"\\ea8b\"}.ri-baidu-line:before{content:\"\\ea8c\"}.ri-ball-pen-fill:before{content:\"\\ea8d\"}.ri-ball-pen-line:before{content:\"\\ea8e\"}.ri-bank-card-2-fill:before{content:\"\\ea8f\"}.ri-bank-card-2-line:before{content:\"\\ea90\"}.ri-bank-card-fill:before{content:\"\\ea91\"}.ri-bank-card-line:before{content:\"\\ea92\"}.ri-bank-fill:before{content:\"\\ea93\"}.ri-bank-line:before{content:\"\\ea94\"}.ri-bar-chart-2-fill:before{content:\"\\ea95\"}.ri-bar-chart-2-line:before{content:\"\\ea96\"}.ri-bar-chart-box-fill:before{content:\"\\ea97\"}.ri-bar-chart-box-line:before{content:\"\\ea98\"}.ri-bar-chart-fill:before{content:\"\\ea99\"}.ri-bar-chart-grouped-fill:before{content:\"\\ea9a\"}.ri-bar-chart-grouped-line:before{content:\"\\ea9b\"}.ri-bar-chart-horizontal-fill:before{content:\"\\ea9c\"}.ri-bar-chart-horizontal-line:before{content:\"\\ea9d\"}.ri-bar-chart-line:before{content:\"\\ea9e\"}.ri-barcode-box-fill:before{content:\"\\ea9f\"}.ri-barcode-box-line:before{content:\"\\eaa0\"}.ri-barcode-fill:before{content:\"\\eaa1\"}.ri-barcode-line:before{content:\"\\eaa2\"}.ri-barricade-fill:before{content:\"\\eaa3\"}.ri-barricade-line:before{content:\"\\eaa4\"}.ri-base-station-fill:before{content:\"\\eaa5\"}.ri-base-station-line:before{content:\"\\eaa6\"}.ri-basketball-fill:before{content:\"\\eaa7\"}.ri-basketball-line:before{content:\"\\eaa8\"}.ri-battery-2-charge-fill:before{content:\"\\eaa9\"}.ri-battery-2-charge-line:before{content:\"\\eaaa\"}.ri-battery-2-fill:before{content:\"\\eaab\"}.ri-battery-2-line:before{content:\"\\eaac\"}.ri-battery-charge-fill:before{content:\"\\eaad\"}.ri-battery-charge-line:before{content:\"\\eaae\"}.ri-battery-fill:before{content:\"\\eaaf\"}.ri-battery-line:before{content:\"\\eab0\"}.ri-battery-low-fill:before{content:\"\\eab1\"}.ri-battery-low-line:before{content:\"\\eab2\"}.ri-battery-saver-fill:before{content:\"\\eab3\"}.ri-battery-saver-line:before{content:\"\\eab4\"}.ri-battery-share-fill:before{content:\"\\eab5\"}.ri-battery-share-line:before{content:\"\\eab6\"}.ri-bear-smile-fill:before{content:\"\\eab7\"}.ri-bear-smile-line:before{content:\"\\eab8\"}.ri-behance-fill:before{content:\"\\eab9\"}.ri-behance-line:before{content:\"\\eaba\"}.ri-bell-fill:before{content:\"\\eabb\"}.ri-bell-line:before{content:\"\\eabc\"}.ri-bike-fill:before{content:\"\\eabd\"}.ri-bike-line:before{content:\"\\eabe\"}.ri-bilibili-fill:before{content:\"\\eabf\"}.ri-bilibili-line:before{content:\"\\eac0\"}.ri-bill-fill:before{content:\"\\eac1\"}.ri-bill-line:before{content:\"\\eac2\"}.ri-billiards-fill:before{content:\"\\eac3\"}.ri-billiards-line:before{content:\"\\eac4\"}.ri-bit-coin-fill:before{content:\"\\eac5\"}.ri-bit-coin-line:before{content:\"\\eac6\"}.ri-blaze-fill:before{content:\"\\eac7\"}.ri-blaze-line:before{content:\"\\eac8\"}.ri-bluetooth-connect-fill:before{content:\"\\eac9\"}.ri-bluetooth-connect-line:before{content:\"\\eaca\"}.ri-bluetooth-fill:before{content:\"\\eacb\"}.ri-bluetooth-line:before{content:\"\\eacc\"}.ri-blur-off-fill:before{content:\"\\eacd\"}.ri-blur-off-line:before{content:\"\\eace\"}.ri-body-scan-fill:before{content:\"\\eacf\"}.ri-body-scan-line:before{content:\"\\ead0\"}.ri-bold:before{content:\"\\ead1\"}.ri-book-2-fill:before{content:\"\\ead2\"}.ri-book-2-line:before{content:\"\\ead3\"}.ri-book-3-fill:before{content:\"\\ead4\"}.ri-book-3-line:before{content:\"\\ead5\"}.ri-book-fill:before{content:\"\\ead6\"}.ri-book-line:before{content:\"\\ead7\"}.ri-book-mark-fill:before{content:\"\\ead8\"}.ri-book-mark-line:before{content:\"\\ead9\"}.ri-book-open-fill:before{content:\"\\eada\"}.ri-book-open-line:before{content:\"\\eadb\"}.ri-book-read-fill:before{content:\"\\eadc\"}.ri-book-read-line:before{content:\"\\eadd\"}.ri-booklet-fill:before{content:\"\\eade\"}.ri-booklet-line:before{content:\"\\eadf\"}.ri-bookmark-2-fill:before{content:\"\\eae0\"}.ri-bookmark-2-line:before{content:\"\\eae1\"}.ri-bookmark-3-fill:before{content:\"\\eae2\"}.ri-bookmark-3-line:before{content:\"\\eae3\"}.ri-bookmark-fill:before{content:\"\\eae4\"}.ri-bookmark-line:before{content:\"\\eae5\"}.ri-boxing-fill:before{content:\"\\eae6\"}.ri-boxing-line:before{content:\"\\eae7\"}.ri-braces-fill:before{content:\"\\eae8\"}.ri-braces-line:before{content:\"\\eae9\"}.ri-brackets-fill:before{content:\"\\eaea\"}.ri-brackets-line:before{content:\"\\eaeb\"}.ri-briefcase-2-fill:before{content:\"\\eaec\"}.ri-briefcase-2-line:before{content:\"\\eaed\"}.ri-briefcase-3-fill:before{content:\"\\eaee\"}.ri-briefcase-3-line:before{content:\"\\eaef\"}.ri-briefcase-4-fill:before{content:\"\\eaf0\"}.ri-briefcase-4-line:before{content:\"\\eaf1\"}.ri-briefcase-5-fill:before{content:\"\\eaf2\"}.ri-briefcase-5-line:before{content:\"\\eaf3\"}.ri-briefcase-fill:before{content:\"\\eaf4\"}.ri-briefcase-line:before{content:\"\\eaf5\"}.ri-bring-forward:before{content:\"\\eaf6\"}.ri-bring-to-front:before{content:\"\\eaf7\"}.ri-broadcast-fill:before{content:\"\\eaf8\"}.ri-broadcast-line:before{content:\"\\eaf9\"}.ri-brush-2-fill:before{content:\"\\eafa\"}.ri-brush-2-line:before{content:\"\\eafb\"}.ri-brush-3-fill:before{content:\"\\eafc\"}.ri-brush-3-line:before{content:\"\\eafd\"}.ri-brush-4-fill:before{content:\"\\eafe\"}.ri-brush-4-line:before{content:\"\\eaff\"}.ri-brush-fill:before{content:\"\\eb00\"}.ri-brush-line:before{content:\"\\eb01\"}.ri-bubble-chart-fill:before{content:\"\\eb02\"}.ri-bubble-chart-line:before{content:\"\\eb03\"}.ri-bug-2-fill:before{content:\"\\eb04\"}.ri-bug-2-line:before{content:\"\\eb05\"}.ri-bug-fill:before{content:\"\\eb06\"}.ri-bug-line:before{content:\"\\eb07\"}.ri-building-2-fill:before{content:\"\\eb08\"}.ri-building-2-line:before{content:\"\\eb09\"}.ri-building-3-fill:before{content:\"\\eb0a\"}.ri-building-3-line:before{content:\"\\eb0b\"}.ri-building-4-fill:before{content:\"\\eb0c\"}.ri-building-4-line:before{content:\"\\eb0d\"}.ri-building-fill:before{content:\"\\eb0e\"}.ri-building-line:before{content:\"\\eb0f\"}.ri-bus-2-fill:before{content:\"\\eb10\"}.ri-bus-2-line:before{content:\"\\eb11\"}.ri-bus-fill:before{content:\"\\eb12\"}.ri-bus-line:before{content:\"\\eb13\"}.ri-bus-wifi-fill:before{content:\"\\eb14\"}.ri-bus-wifi-line:before{content:\"\\eb15\"}.ri-cactus-fill:before{content:\"\\eb16\"}.ri-cactus-line:before{content:\"\\eb17\"}.ri-cake-2-fill:before{content:\"\\eb18\"}.ri-cake-2-line:before{content:\"\\eb19\"}.ri-cake-3-fill:before{content:\"\\eb1a\"}.ri-cake-3-line:before{content:\"\\eb1b\"}.ri-cake-fill:before{content:\"\\eb1c\"}.ri-cake-line:before{content:\"\\eb1d\"}.ri-calculator-fill:before{content:\"\\eb1e\"}.ri-calculator-line:before{content:\"\\eb1f\"}.ri-calendar-2-fill:before{content:\"\\eb20\"}.ri-calendar-2-line:before{content:\"\\eb21\"}.ri-calendar-check-fill:before{content:\"\\eb22\"}.ri-calendar-check-line:before{content:\"\\eb23\"}.ri-calendar-event-fill:before{content:\"\\eb24\"}.ri-calendar-event-line:before{content:\"\\eb25\"}.ri-calendar-fill:before{content:\"\\eb26\"}.ri-calendar-line:before{content:\"\\eb27\"}.ri-calendar-todo-fill:before{content:\"\\eb28\"}.ri-calendar-todo-line:before{content:\"\\eb29\"}.ri-camera-2-fill:before{content:\"\\eb2a\"}.ri-camera-2-line:before{content:\"\\eb2b\"}.ri-camera-3-fill:before{content:\"\\eb2c\"}.ri-camera-3-line:before{content:\"\\eb2d\"}.ri-camera-fill:before{content:\"\\eb2e\"}.ri-camera-lens-fill:before{content:\"\\eb2f\"}.ri-camera-lens-line:before{content:\"\\eb30\"}.ri-camera-line:before{content:\"\\eb31\"}.ri-camera-off-fill:before{content:\"\\eb32\"}.ri-camera-off-line:before{content:\"\\eb33\"}.ri-camera-switch-fill:before{content:\"\\eb34\"}.ri-camera-switch-line:before{content:\"\\eb35\"}.ri-capsule-fill:before{content:\"\\eb36\"}.ri-capsule-line:before{content:\"\\eb37\"}.ri-car-fill:before{content:\"\\eb38\"}.ri-car-line:before{content:\"\\eb39\"}.ri-car-washing-fill:before{content:\"\\eb3a\"}.ri-car-washing-line:before{content:\"\\eb3b\"}.ri-caravan-fill:before{content:\"\\eb3c\"}.ri-caravan-line:before{content:\"\\eb3d\"}.ri-cast-fill:before{content:\"\\eb3e\"}.ri-cast-line:before{content:\"\\eb3f\"}.ri-cellphone-fill:before{content:\"\\eb40\"}.ri-cellphone-line:before{content:\"\\eb41\"}.ri-celsius-fill:before{content:\"\\eb42\"}.ri-celsius-line:before{content:\"\\eb43\"}.ri-centos-fill:before{content:\"\\eb44\"}.ri-centos-line:before{content:\"\\eb45\"}.ri-character-recognition-fill:before{content:\"\\eb46\"}.ri-character-recognition-line:before{content:\"\\eb47\"}.ri-charging-pile-2-fill:before{content:\"\\eb48\"}.ri-charging-pile-2-line:before{content:\"\\eb49\"}.ri-charging-pile-fill:before{content:\"\\eb4a\"}.ri-charging-pile-line:before{content:\"\\eb4b\"}.ri-chat-1-fill:before{content:\"\\eb4c\"}.ri-chat-1-line:before{content:\"\\eb4d\"}.ri-chat-2-fill:before{content:\"\\eb4e\"}.ri-chat-2-line:before{content:\"\\eb4f\"}.ri-chat-3-fill:before{content:\"\\eb50\"}.ri-chat-3-line:before{content:\"\\eb51\"}.ri-chat-4-fill:before{content:\"\\eb52\"}.ri-chat-4-line:before{content:\"\\eb53\"}.ri-chat-check-fill:before{content:\"\\eb54\"}.ri-chat-check-line:before{content:\"\\eb55\"}.ri-chat-delete-fill:before{content:\"\\eb56\"}.ri-chat-delete-line:before{content:\"\\eb57\"}.ri-chat-download-fill:before{content:\"\\eb58\"}.ri-chat-download-line:before{content:\"\\eb59\"}.ri-chat-follow-up-fill:before{content:\"\\eb5a\"}.ri-chat-follow-up-line:before{content:\"\\eb5b\"}.ri-chat-forward-fill:before{content:\"\\eb5c\"}.ri-chat-forward-line:before{content:\"\\eb5d\"}.ri-chat-heart-fill:before{content:\"\\eb5e\"}.ri-chat-heart-line:before{content:\"\\eb5f\"}.ri-chat-history-fill:before{content:\"\\eb60\"}.ri-chat-history-line:before{content:\"\\eb61\"}.ri-chat-new-fill:before{content:\"\\eb62\"}.ri-chat-new-line:before{content:\"\\eb63\"}.ri-chat-off-fill:before{content:\"\\eb64\"}.ri-chat-off-line:before{content:\"\\eb65\"}.ri-chat-poll-fill:before{content:\"\\eb66\"}.ri-chat-poll-line:before{content:\"\\eb67\"}.ri-chat-private-fill:before{content:\"\\eb68\"}.ri-chat-private-line:before{content:\"\\eb69\"}.ri-chat-quote-fill:before{content:\"\\eb6a\"}.ri-chat-quote-line:before{content:\"\\eb6b\"}.ri-chat-settings-fill:before{content:\"\\eb6c\"}.ri-chat-settings-line:before{content:\"\\eb6d\"}.ri-chat-smile-2-fill:before{content:\"\\eb6e\"}.ri-chat-smile-2-line:before{content:\"\\eb6f\"}.ri-chat-smile-3-fill:before{content:\"\\eb70\"}.ri-chat-smile-3-line:before{content:\"\\eb71\"}.ri-chat-smile-fill:before{content:\"\\eb72\"}.ri-chat-smile-line:before{content:\"\\eb73\"}.ri-chat-upload-fill:before{content:\"\\eb74\"}.ri-chat-upload-line:before{content:\"\\eb75\"}.ri-chat-voice-fill:before{content:\"\\eb76\"}.ri-chat-voice-line:before{content:\"\\eb77\"}.ri-check-double-fill:before{content:\"\\eb78\"}.ri-check-double-line:before{content:\"\\eb79\"}.ri-check-fill:before{content:\"\\eb7a\"}.ri-check-line:before{content:\"\\eb7b\"}.ri-checkbox-blank-circle-fill:before{content:\"\\eb7c\"}.ri-checkbox-blank-circle-line:before{content:\"\\eb7d\"}.ri-checkbox-blank-fill:before{content:\"\\eb7e\"}.ri-checkbox-blank-line:before{content:\"\\eb7f\"}.ri-checkbox-circle-fill:before{content:\"\\eb80\"}.ri-checkbox-circle-line:before{content:\"\\eb81\"}.ri-checkbox-fill:before{content:\"\\eb82\"}.ri-checkbox-indeterminate-fill:before{content:\"\\eb83\"}.ri-checkbox-indeterminate-line:before{content:\"\\eb84\"}.ri-checkbox-line:before{content:\"\\eb85\"}.ri-checkbox-multiple-blank-fill:before{content:\"\\eb86\"}.ri-checkbox-multiple-blank-line:before{content:\"\\eb87\"}.ri-checkbox-multiple-fill:before{content:\"\\eb88\"}.ri-checkbox-multiple-line:before{content:\"\\eb89\"}.ri-china-railway-fill:before{content:\"\\eb8a\"}.ri-china-railway-line:before{content:\"\\eb8b\"}.ri-chrome-fill:before{content:\"\\eb8c\"}.ri-chrome-line:before{content:\"\\eb8d\"}.ri-clapperboard-fill:before{content:\"\\eb8e\"}.ri-clapperboard-line:before{content:\"\\eb8f\"}.ri-clipboard-fill:before{content:\"\\eb90\"}.ri-clipboard-line:before{content:\"\\eb91\"}.ri-clockwise-2-fill:before{content:\"\\eb92\"}.ri-clockwise-2-line:before{content:\"\\eb93\"}.ri-clockwise-fill:before{content:\"\\eb94\"}.ri-clockwise-line:before{content:\"\\eb95\"}.ri-close-circle-fill:before{content:\"\\eb96\"}.ri-close-circle-line:before{content:\"\\eb97\"}.ri-close-fill:before{content:\"\\eb98\"}.ri-close-line:before{content:\"\\eb99\"}.ri-closed-captioning-fill:before{content:\"\\eb9a\"}.ri-closed-captioning-line:before{content:\"\\eb9b\"}.ri-cloud-fill:before{content:\"\\eb9c\"}.ri-cloud-line:before{content:\"\\eb9d\"}.ri-cloud-off-fill:before{content:\"\\eb9e\"}.ri-cloud-off-line:before{content:\"\\eb9f\"}.ri-cloud-windy-fill:before{content:\"\\eba0\"}.ri-cloud-windy-line:before{content:\"\\eba1\"}.ri-cloudy-2-fill:before{content:\"\\eba2\"}.ri-cloudy-2-line:before{content:\"\\eba3\"}.ri-cloudy-fill:before{content:\"\\eba4\"}.ri-cloudy-line:before{content:\"\\eba5\"}.ri-code-box-fill:before{content:\"\\eba6\"}.ri-code-box-line:before{content:\"\\eba7\"}.ri-code-fill:before{content:\"\\eba8\"}.ri-code-line:before{content:\"\\eba9\"}.ri-code-s-fill:before{content:\"\\ebaa\"}.ri-code-s-line:before{content:\"\\ebab\"}.ri-code-s-slash-fill:before{content:\"\\ebac\"}.ri-code-s-slash-line:before{content:\"\\ebad\"}.ri-code-view:before{content:\"\\ebae\"}.ri-codepen-fill:before{content:\"\\ebaf\"}.ri-codepen-line:before{content:\"\\ebb0\"}.ri-coin-fill:before{content:\"\\ebb1\"}.ri-coin-line:before{content:\"\\ebb2\"}.ri-coins-fill:before{content:\"\\ebb3\"}.ri-coins-line:before{content:\"\\ebb4\"}.ri-collage-fill:before{content:\"\\ebb5\"}.ri-collage-line:before{content:\"\\ebb6\"}.ri-command-fill:before{content:\"\\ebb7\"}.ri-command-line:before{content:\"\\ebb8\"}.ri-community-fill:before{content:\"\\ebb9\"}.ri-community-line:before{content:\"\\ebba\"}.ri-compass-2-fill:before{content:\"\\ebbb\"}.ri-compass-2-line:before{content:\"\\ebbc\"}.ri-compass-3-fill:before{content:\"\\ebbd\"}.ri-compass-3-line:before{content:\"\\ebbe\"}.ri-compass-4-fill:before{content:\"\\ebbf\"}.ri-compass-4-line:before{content:\"\\ebc0\"}.ri-compass-discover-fill:before{content:\"\\ebc1\"}.ri-compass-discover-line:before{content:\"\\ebc2\"}.ri-compass-fill:before{content:\"\\ebc3\"}.ri-compass-line:before{content:\"\\ebc4\"}.ri-compasses-2-fill:before{content:\"\\ebc5\"}.ri-compasses-2-line:before{content:\"\\ebc6\"}.ri-compasses-fill:before{content:\"\\ebc7\"}.ri-compasses-line:before{content:\"\\ebc8\"}.ri-computer-fill:before{content:\"\\ebc9\"}.ri-computer-line:before{content:\"\\ebca\"}.ri-contacts-book-2-fill:before{content:\"\\ebcb\"}.ri-contacts-book-2-line:before{content:\"\\ebcc\"}.ri-contacts-book-fill:before{content:\"\\ebcd\"}.ri-contacts-book-line:before{content:\"\\ebce\"}.ri-contacts-book-upload-fill:before{content:\"\\ebcf\"}.ri-contacts-book-upload-line:before{content:\"\\ebd0\"}.ri-contacts-fill:before{content:\"\\ebd1\"}.ri-contacts-line:before{content:\"\\ebd2\"}.ri-contrast-2-fill:before{content:\"\\ebd3\"}.ri-contrast-2-line:before{content:\"\\ebd4\"}.ri-contrast-drop-2-fill:before{content:\"\\ebd5\"}.ri-contrast-drop-2-line:before{content:\"\\ebd6\"}.ri-contrast-drop-fill:before{content:\"\\ebd7\"}.ri-contrast-drop-line:before{content:\"\\ebd8\"}.ri-contrast-fill:before{content:\"\\ebd9\"}.ri-contrast-line:before{content:\"\\ebda\"}.ri-copper-coin-fill:before{content:\"\\ebdb\"}.ri-copper-coin-line:before{content:\"\\ebdc\"}.ri-copper-diamond-fill:before{content:\"\\ebdd\"}.ri-copper-diamond-line:before{content:\"\\ebde\"}.ri-copyleft-fill:before{content:\"\\ebdf\"}.ri-copyleft-line:before{content:\"\\ebe0\"}.ri-copyright-fill:before{content:\"\\ebe1\"}.ri-copyright-line:before{content:\"\\ebe2\"}.ri-coreos-fill:before{content:\"\\ebe3\"}.ri-coreos-line:before{content:\"\\ebe4\"}.ri-coupon-2-fill:before{content:\"\\ebe5\"}.ri-coupon-2-line:before{content:\"\\ebe6\"}.ri-coupon-3-fill:before{content:\"\\ebe7\"}.ri-coupon-3-line:before{content:\"\\ebe8\"}.ri-coupon-4-fill:before{content:\"\\ebe9\"}.ri-coupon-4-line:before{content:\"\\ebea\"}.ri-coupon-5-fill:before{content:\"\\ebeb\"}.ri-coupon-5-line:before{content:\"\\ebec\"}.ri-coupon-fill:before{content:\"\\ebed\"}.ri-coupon-line:before{content:\"\\ebee\"}.ri-cpu-fill:before{content:\"\\ebef\"}.ri-cpu-line:before{content:\"\\ebf0\"}.ri-creative-commons-by-fill:before{content:\"\\ebf1\"}.ri-creative-commons-by-line:before{content:\"\\ebf2\"}.ri-creative-commons-fill:before{content:\"\\ebf3\"}.ri-creative-commons-line:before{content:\"\\ebf4\"}.ri-creative-commons-nc-fill:before{content:\"\\ebf5\"}.ri-creative-commons-nc-line:before{content:\"\\ebf6\"}.ri-creative-commons-nd-fill:before{content:\"\\ebf7\"}.ri-creative-commons-nd-line:before{content:\"\\ebf8\"}.ri-creative-commons-sa-fill:before{content:\"\\ebf9\"}.ri-creative-commons-sa-line:before{content:\"\\ebfa\"}.ri-creative-commons-zero-fill:before{content:\"\\ebfb\"}.ri-creative-commons-zero-line:before{content:\"\\ebfc\"}.ri-criminal-fill:before{content:\"\\ebfd\"}.ri-criminal-line:before{content:\"\\ebfe\"}.ri-crop-2-fill:before{content:\"\\ebff\"}.ri-crop-2-line:before{content:\"\\ec00\"}.ri-crop-fill:before{content:\"\\ec01\"}.ri-crop-line:before{content:\"\\ec02\"}.ri-css3-fill:before{content:\"\\ec03\"}.ri-css3-line:before{content:\"\\ec04\"}.ri-cup-fill:before{content:\"\\ec05\"}.ri-cup-line:before{content:\"\\ec06\"}.ri-currency-fill:before{content:\"\\ec07\"}.ri-currency-line:before{content:\"\\ec08\"}.ri-cursor-fill:before{content:\"\\ec09\"}.ri-cursor-line:before{content:\"\\ec0a\"}.ri-customer-service-2-fill:before{content:\"\\ec0b\"}.ri-customer-service-2-line:before{content:\"\\ec0c\"}.ri-customer-service-fill:before{content:\"\\ec0d\"}.ri-customer-service-line:before{content:\"\\ec0e\"}.ri-dashboard-2-fill:before{content:\"\\ec0f\"}.ri-dashboard-2-line:before{content:\"\\ec10\"}.ri-dashboard-3-fill:before{content:\"\\ec11\"}.ri-dashboard-3-line:before{content:\"\\ec12\"}.ri-dashboard-fill:before{content:\"\\ec13\"}.ri-dashboard-line:before{content:\"\\ec14\"}.ri-database-2-fill:before{content:\"\\ec15\"}.ri-database-2-line:before{content:\"\\ec16\"}.ri-database-fill:before{content:\"\\ec17\"}.ri-database-line:before{content:\"\\ec18\"}.ri-delete-back-2-fill:before{content:\"\\ec19\"}.ri-delete-back-2-line:before{content:\"\\ec1a\"}.ri-delete-back-fill:before{content:\"\\ec1b\"}.ri-delete-back-line:before{content:\"\\ec1c\"}.ri-delete-bin-2-fill:before{content:\"\\ec1d\"}.ri-delete-bin-2-line:before{content:\"\\ec1e\"}.ri-delete-bin-3-fill:before{content:\"\\ec1f\"}.ri-delete-bin-3-line:before{content:\"\\ec20\"}.ri-delete-bin-4-fill:before{content:\"\\ec21\"}.ri-delete-bin-4-line:before{content:\"\\ec22\"}.ri-delete-bin-5-fill:before{content:\"\\ec23\"}.ri-delete-bin-5-line:before{content:\"\\ec24\"}.ri-delete-bin-6-fill:before{content:\"\\ec25\"}.ri-delete-bin-6-line:before{content:\"\\ec26\"}.ri-delete-bin-7-fill:before{content:\"\\ec27\"}.ri-delete-bin-7-line:before{content:\"\\ec28\"}.ri-delete-bin-fill:before{content:\"\\ec29\"}.ri-delete-bin-line:before{content:\"\\ec2a\"}.ri-delete-column:before{content:\"\\ec2b\"}.ri-delete-row:before{content:\"\\ec2c\"}.ri-device-fill:before{content:\"\\ec2d\"}.ri-device-line:before{content:\"\\ec2e\"}.ri-device-recover-fill:before{content:\"\\ec2f\"}.ri-device-recover-line:before{content:\"\\ec30\"}.ri-dingding-fill:before{content:\"\\ec31\"}.ri-dingding-line:before{content:\"\\ec32\"}.ri-direction-fill:before{content:\"\\ec33\"}.ri-direction-line:before{content:\"\\ec34\"}.ri-disc-fill:before{content:\"\\ec35\"}.ri-disc-line:before{content:\"\\ec36\"}.ri-discord-fill:before{content:\"\\ec37\"}.ri-discord-line:before{content:\"\\ec38\"}.ri-discuss-fill:before{content:\"\\ec39\"}.ri-discuss-line:before{content:\"\\ec3a\"}.ri-dislike-fill:before{content:\"\\ec3b\"}.ri-dislike-line:before{content:\"\\ec3c\"}.ri-disqus-fill:before{content:\"\\ec3d\"}.ri-disqus-line:before{content:\"\\ec3e\"}.ri-divide-fill:before{content:\"\\ec3f\"}.ri-divide-line:before{content:\"\\ec40\"}.ri-donut-chart-fill:before{content:\"\\ec41\"}.ri-donut-chart-line:before{content:\"\\ec42\"}.ri-door-closed-fill:before{content:\"\\ec43\"}.ri-door-closed-line:before{content:\"\\ec44\"}.ri-door-fill:before{content:\"\\ec45\"}.ri-door-line:before{content:\"\\ec46\"}.ri-door-lock-box-fill:before{content:\"\\ec47\"}.ri-door-lock-box-line:before{content:\"\\ec48\"}.ri-door-lock-fill:before{content:\"\\ec49\"}.ri-door-lock-line:before{content:\"\\ec4a\"}.ri-door-open-fill:before{content:\"\\ec4b\"}.ri-door-open-line:before{content:\"\\ec4c\"}.ri-dossier-fill:before{content:\"\\ec4d\"}.ri-dossier-line:before{content:\"\\ec4e\"}.ri-douban-fill:before{content:\"\\ec4f\"}.ri-douban-line:before{content:\"\\ec50\"}.ri-double-quotes-l:before{content:\"\\ec51\"}.ri-double-quotes-r:before{content:\"\\ec52\"}.ri-download-2-fill:before{content:\"\\ec53\"}.ri-download-2-line:before{content:\"\\ec54\"}.ri-download-cloud-2-fill:before{content:\"\\ec55\"}.ri-download-cloud-2-line:before{content:\"\\ec56\"}.ri-download-cloud-fill:before{content:\"\\ec57\"}.ri-download-cloud-line:before{content:\"\\ec58\"}.ri-download-fill:before{content:\"\\ec59\"}.ri-download-line:before{content:\"\\ec5a\"}.ri-draft-fill:before{content:\"\\ec5b\"}.ri-draft-line:before{content:\"\\ec5c\"}.ri-drag-drop-fill:before{content:\"\\ec5d\"}.ri-drag-drop-line:before{content:\"\\ec5e\"}.ri-drag-move-2-fill:before{content:\"\\ec5f\"}.ri-drag-move-2-line:before{content:\"\\ec60\"}.ri-drag-move-fill:before{content:\"\\ec61\"}.ri-drag-move-line:before{content:\"\\ec62\"}.ri-dribbble-fill:before{content:\"\\ec63\"}.ri-dribbble-line:before{content:\"\\ec64\"}.ri-drive-fill:before{content:\"\\ec65\"}.ri-drive-line:before{content:\"\\ec66\"}.ri-drizzle-fill:before{content:\"\\ec67\"}.ri-drizzle-line:before{content:\"\\ec68\"}.ri-drop-fill:before{content:\"\\ec69\"}.ri-drop-line:before{content:\"\\ec6a\"}.ri-dropbox-fill:before{content:\"\\ec6b\"}.ri-dropbox-line:before{content:\"\\ec6c\"}.ri-dual-sim-1-fill:before{content:\"\\ec6d\"}.ri-dual-sim-1-line:before{content:\"\\ec6e\"}.ri-dual-sim-2-fill:before{content:\"\\ec6f\"}.ri-dual-sim-2-line:before{content:\"\\ec70\"}.ri-dv-fill:before{content:\"\\ec71\"}.ri-dv-line:before{content:\"\\ec72\"}.ri-dvd-fill:before{content:\"\\ec73\"}.ri-dvd-line:before{content:\"\\ec74\"}.ri-e-bike-2-fill:before{content:\"\\ec75\"}.ri-e-bike-2-line:before{content:\"\\ec76\"}.ri-e-bike-fill:before{content:\"\\ec77\"}.ri-e-bike-line:before{content:\"\\ec78\"}.ri-earth-fill:before{content:\"\\ec79\"}.ri-earth-line:before{content:\"\\ec7a\"}.ri-earthquake-fill:before{content:\"\\ec7b\"}.ri-earthquake-line:before{content:\"\\ec7c\"}.ri-edge-fill:before{content:\"\\ec7d\"}.ri-edge-line:before{content:\"\\ec7e\"}.ri-edit-2-fill:before{content:\"\\ec7f\"}.ri-edit-2-line:before{content:\"\\ec80\"}.ri-edit-box-fill:before{content:\"\\ec81\"}.ri-edit-box-line:before{content:\"\\ec82\"}.ri-edit-circle-fill:before{content:\"\\ec83\"}.ri-edit-circle-line:before{content:\"\\ec84\"}.ri-edit-fill:before{content:\"\\ec85\"}.ri-edit-line:before{content:\"\\ec86\"}.ri-eject-fill:before{content:\"\\ec87\"}.ri-eject-line:before{content:\"\\ec88\"}.ri-emotion-2-fill:before{content:\"\\ec89\"}.ri-emotion-2-line:before{content:\"\\ec8a\"}.ri-emotion-fill:before{content:\"\\ec8b\"}.ri-emotion-happy-fill:before{content:\"\\ec8c\"}.ri-emotion-happy-line:before{content:\"\\ec8d\"}.ri-emotion-laugh-fill:before{content:\"\\ec8e\"}.ri-emotion-laugh-line:before{content:\"\\ec8f\"}.ri-emotion-line:before{content:\"\\ec90\"}.ri-emotion-normal-fill:before{content:\"\\ec91\"}.ri-emotion-normal-line:before{content:\"\\ec92\"}.ri-emotion-sad-fill:before{content:\"\\ec93\"}.ri-emotion-sad-line:before{content:\"\\ec94\"}.ri-emotion-unhappy-fill:before{content:\"\\ec95\"}.ri-emotion-unhappy-line:before{content:\"\\ec96\"}.ri-empathize-fill:before{content:\"\\ec97\"}.ri-empathize-line:before{content:\"\\ec98\"}.ri-emphasis-cn:before{content:\"\\ec99\"}.ri-emphasis:before{content:\"\\ec9a\"}.ri-english-input:before{content:\"\\ec9b\"}.ri-equalizer-fill:before{content:\"\\ec9c\"}.ri-equalizer-line:before{content:\"\\ec9d\"}.ri-eraser-fill:before{content:\"\\ec9e\"}.ri-eraser-line:before{content:\"\\ec9f\"}.ri-error-warning-fill:before{content:\"\\eca0\"}.ri-error-warning-line:before{content:\"\\eca1\"}.ri-evernote-fill:before{content:\"\\eca2\"}.ri-evernote-line:before{content:\"\\eca3\"}.ri-exchange-box-fill:before{content:\"\\eca4\"}.ri-exchange-box-line:before{content:\"\\eca5\"}.ri-exchange-cny-fill:before{content:\"\\eca6\"}.ri-exchange-cny-line:before{content:\"\\eca7\"}.ri-exchange-dollar-fill:before{content:\"\\eca8\"}.ri-exchange-dollar-line:before{content:\"\\eca9\"}.ri-exchange-fill:before{content:\"\\ecaa\"}.ri-exchange-funds-fill:before{content:\"\\ecab\"}.ri-exchange-funds-line:before{content:\"\\ecac\"}.ri-exchange-line:before{content:\"\\ecad\"}.ri-external-link-fill:before{content:\"\\ecae\"}.ri-external-link-line:before{content:\"\\ecaf\"}.ri-eye-2-fill:before{content:\"\\ecb0\"}.ri-eye-2-line:before{content:\"\\ecb1\"}.ri-eye-close-fill:before{content:\"\\ecb2\"}.ri-eye-close-line:before{content:\"\\ecb3\"}.ri-eye-fill:before{content:\"\\ecb4\"}.ri-eye-line:before{content:\"\\ecb5\"}.ri-eye-off-fill:before{content:\"\\ecb6\"}.ri-eye-off-line:before{content:\"\\ecb7\"}.ri-facebook-box-fill:before{content:\"\\ecb8\"}.ri-facebook-box-line:before{content:\"\\ecb9\"}.ri-facebook-circle-fill:before{content:\"\\ecba\"}.ri-facebook-circle-line:before{content:\"\\ecbb\"}.ri-facebook-fill:before{content:\"\\ecbc\"}.ri-facebook-line:before{content:\"\\ecbd\"}.ri-fahrenheit-fill:before{content:\"\\ecbe\"}.ri-fahrenheit-line:before{content:\"\\ecbf\"}.ri-feedback-fill:before{content:\"\\ecc0\"}.ri-feedback-line:before{content:\"\\ecc1\"}.ri-file-2-fill:before{content:\"\\ecc2\"}.ri-file-2-line:before{content:\"\\ecc3\"}.ri-file-3-fill:before{content:\"\\ecc4\"}.ri-file-3-line:before{content:\"\\ecc5\"}.ri-file-4-fill:before{content:\"\\ecc6\"}.ri-file-4-line:before{content:\"\\ecc7\"}.ri-file-add-fill:before{content:\"\\ecc8\"}.ri-file-add-line:before{content:\"\\ecc9\"}.ri-file-chart-2-fill:before{content:\"\\ecca\"}.ri-file-chart-2-line:before{content:\"\\eccb\"}.ri-file-chart-fill:before{content:\"\\eccc\"}.ri-file-chart-line:before{content:\"\\eccd\"}.ri-file-cloud-fill:before{content:\"\\ecce\"}.ri-file-cloud-line:before{content:\"\\eccf\"}.ri-file-code-fill:before{content:\"\\ecd0\"}.ri-file-code-line:before{content:\"\\ecd1\"}.ri-file-copy-2-fill:before{content:\"\\ecd2\"}.ri-file-copy-2-line:before{content:\"\\ecd3\"}.ri-file-copy-fill:before{content:\"\\ecd4\"}.ri-file-copy-line:before{content:\"\\ecd5\"}.ri-file-damage-fill:before{content:\"\\ecd6\"}.ri-file-damage-line:before{content:\"\\ecd7\"}.ri-file-download-fill:before{content:\"\\ecd8\"}.ri-file-download-line:before{content:\"\\ecd9\"}.ri-file-edit-fill:before{content:\"\\ecda\"}.ri-file-edit-line:before{content:\"\\ecdb\"}.ri-file-excel-2-fill:before{content:\"\\ecdc\"}.ri-file-excel-2-line:before{content:\"\\ecdd\"}.ri-file-excel-fill:before{content:\"\\ecde\"}.ri-file-excel-line:before{content:\"\\ecdf\"}.ri-file-fill:before{content:\"\\ece0\"}.ri-file-forbid-fill:before{content:\"\\ece1\"}.ri-file-forbid-line:before{content:\"\\ece2\"}.ri-file-gif-fill:before{content:\"\\ece3\"}.ri-file-gif-line:before{content:\"\\ece4\"}.ri-file-history-fill:before{content:\"\\ece5\"}.ri-file-history-line:before{content:\"\\ece6\"}.ri-file-hwp-fill:before{content:\"\\ece7\"}.ri-file-hwp-line:before{content:\"\\ece8\"}.ri-file-info-fill:before{content:\"\\ece9\"}.ri-file-info-line:before{content:\"\\ecea\"}.ri-file-line:before{content:\"\\eceb\"}.ri-file-list-2-fill:before{content:\"\\ecec\"}.ri-file-list-2-line:before{content:\"\\eced\"}.ri-file-list-3-fill:before{content:\"\\ecee\"}.ri-file-list-3-line:before{content:\"\\ecef\"}.ri-file-list-fill:before{content:\"\\ecf0\"}.ri-file-list-line:before{content:\"\\ecf1\"}.ri-file-lock-fill:before{content:\"\\ecf2\"}.ri-file-lock-line:before{content:\"\\ecf3\"}.ri-file-mark-fill:before{content:\"\\ecf4\"}.ri-file-mark-line:before{content:\"\\ecf5\"}.ri-file-music-fill:before{content:\"\\ecf6\"}.ri-file-music-line:before{content:\"\\ecf7\"}.ri-file-paper-2-fill:before{content:\"\\ecf8\"}.ri-file-paper-2-line:before{content:\"\\ecf9\"}.ri-file-paper-fill:before{content:\"\\ecfa\"}.ri-file-paper-line:before{content:\"\\ecfb\"}.ri-file-pdf-fill:before{content:\"\\ecfc\"}.ri-file-pdf-line:before{content:\"\\ecfd\"}.ri-file-ppt-2-fill:before{content:\"\\ecfe\"}.ri-file-ppt-2-line:before{content:\"\\ecff\"}.ri-file-ppt-fill:before{content:\"\\ed00\"}.ri-file-ppt-line:before{content:\"\\ed01\"}.ri-file-reduce-fill:before{content:\"\\ed02\"}.ri-file-reduce-line:before{content:\"\\ed03\"}.ri-file-search-fill:before{content:\"\\ed04\"}.ri-file-search-line:before{content:\"\\ed05\"}.ri-file-settings-fill:before{content:\"\\ed06\"}.ri-file-settings-line:before{content:\"\\ed07\"}.ri-file-shield-2-fill:before{content:\"\\ed08\"}.ri-file-shield-2-line:before{content:\"\\ed09\"}.ri-file-shield-fill:before{content:\"\\ed0a\"}.ri-file-shield-line:before{content:\"\\ed0b\"}.ri-file-shred-fill:before{content:\"\\ed0c\"}.ri-file-shred-line:before{content:\"\\ed0d\"}.ri-file-text-fill:before{content:\"\\ed0e\"}.ri-file-text-line:before{content:\"\\ed0f\"}.ri-file-transfer-fill:before{content:\"\\ed10\"}.ri-file-transfer-line:before{content:\"\\ed11\"}.ri-file-unknow-fill:before{content:\"\\ed12\"}.ri-file-unknow-line:before{content:\"\\ed13\"}.ri-file-upload-fill:before{content:\"\\ed14\"}.ri-file-upload-line:before{content:\"\\ed15\"}.ri-file-user-fill:before{content:\"\\ed16\"}.ri-file-user-line:before{content:\"\\ed17\"}.ri-file-warning-fill:before{content:\"\\ed18\"}.ri-file-warning-line:before{content:\"\\ed19\"}.ri-file-word-2-fill:before{content:\"\\ed1a\"}.ri-file-word-2-line:before{content:\"\\ed1b\"}.ri-file-word-fill:before{content:\"\\ed1c\"}.ri-file-word-line:before{content:\"\\ed1d\"}.ri-file-zip-fill:before{content:\"\\ed1e\"}.ri-file-zip-line:before{content:\"\\ed1f\"}.ri-film-fill:before{content:\"\\ed20\"}.ri-film-line:before{content:\"\\ed21\"}.ri-filter-2-fill:before{content:\"\\ed22\"}.ri-filter-2-line:before{content:\"\\ed23\"}.ri-filter-3-fill:before{content:\"\\ed24\"}.ri-filter-3-line:before{content:\"\\ed25\"}.ri-filter-fill:before{content:\"\\ed26\"}.ri-filter-line:before{content:\"\\ed27\"}.ri-filter-off-fill:before{content:\"\\ed28\"}.ri-filter-off-line:before{content:\"\\ed29\"}.ri-find-replace-fill:before{content:\"\\ed2a\"}.ri-find-replace-line:before{content:\"\\ed2b\"}.ri-finder-fill:before{content:\"\\ed2c\"}.ri-finder-line:before{content:\"\\ed2d\"}.ri-fingerprint-2-fill:before{content:\"\\ed2e\"}.ri-fingerprint-2-line:before{content:\"\\ed2f\"}.ri-fingerprint-fill:before{content:\"\\ed30\"}.ri-fingerprint-line:before{content:\"\\ed31\"}.ri-fire-fill:before{content:\"\\ed32\"}.ri-fire-line:before{content:\"\\ed33\"}.ri-firefox-fill:before{content:\"\\ed34\"}.ri-firefox-line:before{content:\"\\ed35\"}.ri-first-aid-kit-fill:before{content:\"\\ed36\"}.ri-first-aid-kit-line:before{content:\"\\ed37\"}.ri-flag-2-fill:before{content:\"\\ed38\"}.ri-flag-2-line:before{content:\"\\ed39\"}.ri-flag-fill:before{content:\"\\ed3a\"}.ri-flag-line:before{content:\"\\ed3b\"}.ri-flashlight-fill:before{content:\"\\ed3c\"}.ri-flashlight-line:before{content:\"\\ed3d\"}.ri-flask-fill:before{content:\"\\ed3e\"}.ri-flask-line:before{content:\"\\ed3f\"}.ri-flight-land-fill:before{content:\"\\ed40\"}.ri-flight-land-line:before{content:\"\\ed41\"}.ri-flight-takeoff-fill:before{content:\"\\ed42\"}.ri-flight-takeoff-line:before{content:\"\\ed43\"}.ri-flood-fill:before{content:\"\\ed44\"}.ri-flood-line:before{content:\"\\ed45\"}.ri-flow-chart:before{content:\"\\ed46\"}.ri-flutter-fill:before{content:\"\\ed47\"}.ri-flutter-line:before{content:\"\\ed48\"}.ri-focus-2-fill:before{content:\"\\ed49\"}.ri-focus-2-line:before{content:\"\\ed4a\"}.ri-focus-3-fill:before{content:\"\\ed4b\"}.ri-focus-3-line:before{content:\"\\ed4c\"}.ri-focus-fill:before{content:\"\\ed4d\"}.ri-focus-line:before{content:\"\\ed4e\"}.ri-foggy-fill:before{content:\"\\ed4f\"}.ri-foggy-line:before{content:\"\\ed50\"}.ri-folder-2-fill:before{content:\"\\ed51\"}.ri-folder-2-line:before{content:\"\\ed52\"}.ri-folder-3-fill:before{content:\"\\ed53\"}.ri-folder-3-line:before{content:\"\\ed54\"}.ri-folder-4-fill:before{content:\"\\ed55\"}.ri-folder-4-line:before{content:\"\\ed56\"}.ri-folder-5-fill:before{content:\"\\ed57\"}.ri-folder-5-line:before{content:\"\\ed58\"}.ri-folder-add-fill:before{content:\"\\ed59\"}.ri-folder-add-line:before{content:\"\\ed5a\"}.ri-folder-chart-2-fill:before{content:\"\\ed5b\"}.ri-folder-chart-2-line:before{content:\"\\ed5c\"}.ri-folder-chart-fill:before{content:\"\\ed5d\"}.ri-folder-chart-line:before{content:\"\\ed5e\"}.ri-folder-download-fill:before{content:\"\\ed5f\"}.ri-folder-download-line:before{content:\"\\ed60\"}.ri-folder-fill:before{content:\"\\ed61\"}.ri-folder-forbid-fill:before{content:\"\\ed62\"}.ri-folder-forbid-line:before{content:\"\\ed63\"}.ri-folder-history-fill:before{content:\"\\ed64\"}.ri-folder-history-line:before{content:\"\\ed65\"}.ri-folder-info-fill:before{content:\"\\ed66\"}.ri-folder-info-line:before{content:\"\\ed67\"}.ri-folder-keyhole-fill:before{content:\"\\ed68\"}.ri-folder-keyhole-line:before{content:\"\\ed69\"}.ri-folder-line:before{content:\"\\ed6a\"}.ri-folder-lock-fill:before{content:\"\\ed6b\"}.ri-folder-lock-line:before{content:\"\\ed6c\"}.ri-folder-music-fill:before{content:\"\\ed6d\"}.ri-folder-music-line:before{content:\"\\ed6e\"}.ri-folder-open-fill:before{content:\"\\ed6f\"}.ri-folder-open-line:before{content:\"\\ed70\"}.ri-folder-received-fill:before{content:\"\\ed71\"}.ri-folder-received-line:before{content:\"\\ed72\"}.ri-folder-reduce-fill:before{content:\"\\ed73\"}.ri-folder-reduce-line:before{content:\"\\ed74\"}.ri-folder-settings-fill:before{content:\"\\ed75\"}.ri-folder-settings-line:before{content:\"\\ed76\"}.ri-folder-shared-fill:before{content:\"\\ed77\"}.ri-folder-shared-line:before{content:\"\\ed78\"}.ri-folder-shield-2-fill:before{content:\"\\ed79\"}.ri-folder-shield-2-line:before{content:\"\\ed7a\"}.ri-folder-shield-fill:before{content:\"\\ed7b\"}.ri-folder-shield-line:before{content:\"\\ed7c\"}.ri-folder-transfer-fill:before{content:\"\\ed7d\"}.ri-folder-transfer-line:before{content:\"\\ed7e\"}.ri-folder-unknow-fill:before{content:\"\\ed7f\"}.ri-folder-unknow-line:before{content:\"\\ed80\"}.ri-folder-upload-fill:before{content:\"\\ed81\"}.ri-folder-upload-line:before{content:\"\\ed82\"}.ri-folder-user-fill:before{content:\"\\ed83\"}.ri-folder-user-line:before{content:\"\\ed84\"}.ri-folder-warning-fill:before{content:\"\\ed85\"}.ri-folder-warning-line:before{content:\"\\ed86\"}.ri-folder-zip-fill:before{content:\"\\ed87\"}.ri-folder-zip-line:before{content:\"\\ed88\"}.ri-folders-fill:before{content:\"\\ed89\"}.ri-folders-line:before{content:\"\\ed8a\"}.ri-font-color:before{content:\"\\ed8b\"}.ri-font-size-2:before{content:\"\\ed8c\"}.ri-font-size:before{content:\"\\ed8d\"}.ri-football-fill:before{content:\"\\ed8e\"}.ri-football-line:before{content:\"\\ed8f\"}.ri-footprint-fill:before{content:\"\\ed90\"}.ri-footprint-line:before{content:\"\\ed91\"}.ri-forbid-2-fill:before{content:\"\\ed92\"}.ri-forbid-2-line:before{content:\"\\ed93\"}.ri-forbid-fill:before{content:\"\\ed94\"}.ri-forbid-line:before{content:\"\\ed95\"}.ri-format-clear:before{content:\"\\ed96\"}.ri-fridge-fill:before{content:\"\\ed97\"}.ri-fridge-line:before{content:\"\\ed98\"}.ri-fullscreen-exit-fill:before{content:\"\\ed99\"}.ri-fullscreen-exit-line:before{content:\"\\ed9a\"}.ri-fullscreen-fill:before{content:\"\\ed9b\"}.ri-fullscreen-line:before{content:\"\\ed9c\"}.ri-function-fill:before{content:\"\\ed9d\"}.ri-function-line:before{content:\"\\ed9e\"}.ri-functions:before{content:\"\\ed9f\"}.ri-funds-box-fill:before{content:\"\\eda0\"}.ri-funds-box-line:before{content:\"\\eda1\"}.ri-funds-fill:before{content:\"\\eda2\"}.ri-funds-line:before{content:\"\\eda3\"}.ri-gallery-fill:before{content:\"\\eda4\"}.ri-gallery-line:before{content:\"\\eda5\"}.ri-gallery-upload-fill:before{content:\"\\eda6\"}.ri-gallery-upload-line:before{content:\"\\eda7\"}.ri-game-fill:before{content:\"\\eda8\"}.ri-game-line:before{content:\"\\eda9\"}.ri-gamepad-fill:before{content:\"\\edaa\"}.ri-gamepad-line:before{content:\"\\edab\"}.ri-gas-station-fill:before{content:\"\\edac\"}.ri-gas-station-line:before{content:\"\\edad\"}.ri-gatsby-fill:before{content:\"\\edae\"}.ri-gatsby-line:before{content:\"\\edaf\"}.ri-genderless-fill:before{content:\"\\edb0\"}.ri-genderless-line:before{content:\"\\edb1\"}.ri-ghost-2-fill:before{content:\"\\edb2\"}.ri-ghost-2-line:before{content:\"\\edb3\"}.ri-ghost-fill:before{content:\"\\edb4\"}.ri-ghost-line:before{content:\"\\edb5\"}.ri-ghost-smile-fill:before{content:\"\\edb6\"}.ri-ghost-smile-line:before{content:\"\\edb7\"}.ri-gift-2-fill:before{content:\"\\edb8\"}.ri-gift-2-line:before{content:\"\\edb9\"}.ri-gift-fill:before{content:\"\\edba\"}.ri-gift-line:before{content:\"\\edbb\"}.ri-git-branch-fill:before{content:\"\\edbc\"}.ri-git-branch-line:before{content:\"\\edbd\"}.ri-git-commit-fill:before{content:\"\\edbe\"}.ri-git-commit-line:before{content:\"\\edbf\"}.ri-git-merge-fill:before{content:\"\\edc0\"}.ri-git-merge-line:before{content:\"\\edc1\"}.ri-git-pull-request-fill:before{content:\"\\edc2\"}.ri-git-pull-request-line:before{content:\"\\edc3\"}.ri-git-repository-commits-fill:before{content:\"\\edc4\"}.ri-git-repository-commits-line:before{content:\"\\edc5\"}.ri-git-repository-fill:before{content:\"\\edc6\"}.ri-git-repository-line:before{content:\"\\edc7\"}.ri-git-repository-private-fill:before{content:\"\\edc8\"}.ri-git-repository-private-line:before{content:\"\\edc9\"}.ri-github-fill:before{content:\"\\edca\"}.ri-github-line:before{content:\"\\edcb\"}.ri-gitlab-fill:before{content:\"\\edcc\"}.ri-gitlab-line:before{content:\"\\edcd\"}.ri-global-fill:before{content:\"\\edce\"}.ri-global-line:before{content:\"\\edcf\"}.ri-globe-fill:before{content:\"\\edd0\"}.ri-globe-line:before{content:\"\\edd1\"}.ri-goblet-fill:before{content:\"\\edd2\"}.ri-goblet-line:before{content:\"\\edd3\"}.ri-google-fill:before{content:\"\\edd4\"}.ri-google-line:before{content:\"\\edd5\"}.ri-google-play-fill:before{content:\"\\edd6\"}.ri-google-play-line:before{content:\"\\edd7\"}.ri-government-fill:before{content:\"\\edd8\"}.ri-government-line:before{content:\"\\edd9\"}.ri-gps-fill:before{content:\"\\edda\"}.ri-gps-line:before{content:\"\\eddb\"}.ri-gradienter-fill:before{content:\"\\eddc\"}.ri-gradienter-line:before{content:\"\\eddd\"}.ri-grid-fill:before{content:\"\\edde\"}.ri-grid-line:before{content:\"\\eddf\"}.ri-group-2-fill:before{content:\"\\ede0\"}.ri-group-2-line:before{content:\"\\ede1\"}.ri-group-fill:before{content:\"\\ede2\"}.ri-group-line:before{content:\"\\ede3\"}.ri-guide-fill:before{content:\"\\ede4\"}.ri-guide-line:before{content:\"\\ede5\"}.ri-h-1:before{content:\"\\ede6\"}.ri-h-2:before{content:\"\\ede7\"}.ri-h-3:before{content:\"\\ede8\"}.ri-h-4:before{content:\"\\ede9\"}.ri-h-5:before{content:\"\\edea\"}.ri-h-6:before{content:\"\\edeb\"}.ri-hail-fill:before{content:\"\\edec\"}.ri-hail-line:before{content:\"\\eded\"}.ri-hammer-fill:before{content:\"\\edee\"}.ri-hammer-line:before{content:\"\\edef\"}.ri-hand-coin-fill:before{content:\"\\edf0\"}.ri-hand-coin-line:before{content:\"\\edf1\"}.ri-hand-heart-fill:before{content:\"\\edf2\"}.ri-hand-heart-line:before{content:\"\\edf3\"}.ri-hand-sanitizer-fill:before{content:\"\\edf4\"}.ri-hand-sanitizer-line:before{content:\"\\edf5\"}.ri-handbag-fill:before{content:\"\\edf6\"}.ri-handbag-line:before{content:\"\\edf7\"}.ri-hard-drive-2-fill:before{content:\"\\edf8\"}.ri-hard-drive-2-line:before{content:\"\\edf9\"}.ri-hard-drive-fill:before{content:\"\\edfa\"}.ri-hard-drive-line:before{content:\"\\edfb\"}.ri-hashtag:before{content:\"\\edfc\"}.ri-haze-2-fill:before{content:\"\\edfd\"}.ri-haze-2-line:before{content:\"\\edfe\"}.ri-haze-fill:before{content:\"\\edff\"}.ri-haze-line:before{content:\"\\ee00\"}.ri-hd-fill:before{content:\"\\ee01\"}.ri-hd-line:before{content:\"\\ee02\"}.ri-heading:before{content:\"\\ee03\"}.ri-headphone-fill:before{content:\"\\ee04\"}.ri-headphone-line:before{content:\"\\ee05\"}.ri-health-book-fill:before{content:\"\\ee06\"}.ri-health-book-line:before{content:\"\\ee07\"}.ri-heart-2-fill:before{content:\"\\ee08\"}.ri-heart-2-line:before{content:\"\\ee09\"}.ri-heart-3-fill:before{content:\"\\ee0a\"}.ri-heart-3-line:before{content:\"\\ee0b\"}.ri-heart-add-fill:before{content:\"\\ee0c\"}.ri-heart-add-line:before{content:\"\\ee0d\"}.ri-heart-fill:before{content:\"\\ee0e\"}.ri-heart-line:before{content:\"\\ee0f\"}.ri-heart-pulse-fill:before{content:\"\\ee10\"}.ri-heart-pulse-line:before{content:\"\\ee11\"}.ri-hearts-fill:before{content:\"\\ee12\"}.ri-hearts-line:before{content:\"\\ee13\"}.ri-heavy-showers-fill:before{content:\"\\ee14\"}.ri-heavy-showers-line:before{content:\"\\ee15\"}.ri-history-fill:before{content:\"\\ee16\"}.ri-history-line:before{content:\"\\ee17\"}.ri-home-2-fill:before{content:\"\\ee18\"}.ri-home-2-line:before{content:\"\\ee19\"}.ri-home-3-fill:before{content:\"\\ee1a\"}.ri-home-3-line:before{content:\"\\ee1b\"}.ri-home-4-fill:before{content:\"\\ee1c\"}.ri-home-4-line:before{content:\"\\ee1d\"}.ri-home-5-fill:before{content:\"\\ee1e\"}.ri-home-5-line:before{content:\"\\ee1f\"}.ri-home-6-fill:before{content:\"\\ee20\"}.ri-home-6-line:before{content:\"\\ee21\"}.ri-home-7-fill:before{content:\"\\ee22\"}.ri-home-7-line:before{content:\"\\ee23\"}.ri-home-8-fill:before{content:\"\\ee24\"}.ri-home-8-line:before{content:\"\\ee25\"}.ri-home-fill:before{content:\"\\ee26\"}.ri-home-gear-fill:before{content:\"\\ee27\"}.ri-home-gear-line:before{content:\"\\ee28\"}.ri-home-heart-fill:before{content:\"\\ee29\"}.ri-home-heart-line:before{content:\"\\ee2a\"}.ri-home-line:before{content:\"\\ee2b\"}.ri-home-smile-2-fill:before{content:\"\\ee2c\"}.ri-home-smile-2-line:before{content:\"\\ee2d\"}.ri-home-smile-fill:before{content:\"\\ee2e\"}.ri-home-smile-line:before{content:\"\\ee2f\"}.ri-home-wifi-fill:before{content:\"\\ee30\"}.ri-home-wifi-line:before{content:\"\\ee31\"}.ri-honor-of-kings-fill:before{content:\"\\ee32\"}.ri-honor-of-kings-line:before{content:\"\\ee33\"}.ri-honour-fill:before{content:\"\\ee34\"}.ri-honour-line:before{content:\"\\ee35\"}.ri-hospital-fill:before{content:\"\\ee36\"}.ri-hospital-line:before{content:\"\\ee37\"}.ri-hotel-bed-fill:before{content:\"\\ee38\"}.ri-hotel-bed-line:before{content:\"\\ee39\"}.ri-hotel-fill:before{content:\"\\ee3a\"}.ri-hotel-line:before{content:\"\\ee3b\"}.ri-hotspot-fill:before{content:\"\\ee3c\"}.ri-hotspot-line:before{content:\"\\ee3d\"}.ri-hq-fill:before{content:\"\\ee3e\"}.ri-hq-line:before{content:\"\\ee3f\"}.ri-html5-fill:before{content:\"\\ee40\"}.ri-html5-line:before{content:\"\\ee41\"}.ri-ie-fill:before{content:\"\\ee42\"}.ri-ie-line:before{content:\"\\ee43\"}.ri-image-2-fill:before{content:\"\\ee44\"}.ri-image-2-line:before{content:\"\\ee45\"}.ri-image-add-fill:before{content:\"\\ee46\"}.ri-image-add-line:before{content:\"\\ee47\"}.ri-image-edit-fill:before{content:\"\\ee48\"}.ri-image-edit-line:before{content:\"\\ee49\"}.ri-image-fill:before{content:\"\\ee4a\"}.ri-image-line:before{content:\"\\ee4b\"}.ri-inbox-archive-fill:before{content:\"\\ee4c\"}.ri-inbox-archive-line:before{content:\"\\ee4d\"}.ri-inbox-fill:before{content:\"\\ee4e\"}.ri-inbox-line:before{content:\"\\ee4f\"}.ri-inbox-unarchive-fill:before{content:\"\\ee50\"}.ri-inbox-unarchive-line:before{content:\"\\ee51\"}.ri-increase-decrease-fill:before{content:\"\\ee52\"}.ri-increase-decrease-line:before{content:\"\\ee53\"}.ri-indent-decrease:before{content:\"\\ee54\"}.ri-indent-increase:before{content:\"\\ee55\"}.ri-indeterminate-circle-fill:before{content:\"\\ee56\"}.ri-indeterminate-circle-line:before{content:\"\\ee57\"}.ri-information-fill:before{content:\"\\ee58\"}.ri-information-line:before{content:\"\\ee59\"}.ri-infrared-thermometer-fill:before{content:\"\\ee5a\"}.ri-infrared-thermometer-line:before{content:\"\\ee5b\"}.ri-ink-bottle-fill:before{content:\"\\ee5c\"}.ri-ink-bottle-line:before{content:\"\\ee5d\"}.ri-input-cursor-move:before{content:\"\\ee5e\"}.ri-input-method-fill:before{content:\"\\ee5f\"}.ri-input-method-line:before{content:\"\\ee60\"}.ri-insert-column-left:before{content:\"\\ee61\"}.ri-insert-column-right:before{content:\"\\ee62\"}.ri-insert-row-bottom:before{content:\"\\ee63\"}.ri-insert-row-top:before{content:\"\\ee64\"}.ri-instagram-fill:before{content:\"\\ee65\"}.ri-instagram-line:before{content:\"\\ee66\"}.ri-install-fill:before{content:\"\\ee67\"}.ri-install-line:before{content:\"\\ee68\"}.ri-invision-fill:before{content:\"\\ee69\"}.ri-invision-line:before{content:\"\\ee6a\"}.ri-italic:before{content:\"\\ee6b\"}.ri-kakao-talk-fill:before{content:\"\\ee6c\"}.ri-kakao-talk-line:before{content:\"\\ee6d\"}.ri-key-2-fill:before{content:\"\\ee6e\"}.ri-key-2-line:before{content:\"\\ee6f\"}.ri-key-fill:before{content:\"\\ee70\"}.ri-key-line:before{content:\"\\ee71\"}.ri-keyboard-box-fill:before{content:\"\\ee72\"}.ri-keyboard-box-line:before{content:\"\\ee73\"}.ri-keyboard-fill:before{content:\"\\ee74\"}.ri-keyboard-line:before{content:\"\\ee75\"}.ri-keynote-fill:before{content:\"\\ee76\"}.ri-keynote-line:before{content:\"\\ee77\"}.ri-knife-blood-fill:before{content:\"\\ee78\"}.ri-knife-blood-line:before{content:\"\\ee79\"}.ri-knife-fill:before{content:\"\\ee7a\"}.ri-knife-line:before{content:\"\\ee7b\"}.ri-landscape-fill:before{content:\"\\ee7c\"}.ri-landscape-line:before{content:\"\\ee7d\"}.ri-layout-2-fill:before{content:\"\\ee7e\"}.ri-layout-2-line:before{content:\"\\ee7f\"}.ri-layout-3-fill:before{content:\"\\ee80\"}.ri-layout-3-line:before{content:\"\\ee81\"}.ri-layout-4-fill:before{content:\"\\ee82\"}.ri-layout-4-line:before{content:\"\\ee83\"}.ri-layout-5-fill:before{content:\"\\ee84\"}.ri-layout-5-line:before{content:\"\\ee85\"}.ri-layout-6-fill:before{content:\"\\ee86\"}.ri-layout-6-line:before{content:\"\\ee87\"}.ri-layout-bottom-2-fill:before{content:\"\\ee88\"}.ri-layout-bottom-2-line:before{content:\"\\ee89\"}.ri-layout-bottom-fill:before{content:\"\\ee8a\"}.ri-layout-bottom-line:before{content:\"\\ee8b\"}.ri-layout-column-fill:before{content:\"\\ee8c\"}.ri-layout-column-line:before{content:\"\\ee8d\"}.ri-layout-fill:before{content:\"\\ee8e\"}.ri-layout-grid-fill:before{content:\"\\ee8f\"}.ri-layout-grid-line:before{content:\"\\ee90\"}.ri-layout-left-2-fill:before{content:\"\\ee91\"}.ri-layout-left-2-line:before{content:\"\\ee92\"}.ri-layout-left-fill:before{content:\"\\ee93\"}.ri-layout-left-line:before{content:\"\\ee94\"}.ri-layout-line:before{content:\"\\ee95\"}.ri-layout-masonry-fill:before{content:\"\\ee96\"}.ri-layout-masonry-line:before{content:\"\\ee97\"}.ri-layout-right-2-fill:before{content:\"\\ee98\"}.ri-layout-right-2-line:before{content:\"\\ee99\"}.ri-layout-right-fill:before{content:\"\\ee9a\"}.ri-layout-right-line:before{content:\"\\ee9b\"}.ri-layout-row-fill:before{content:\"\\ee9c\"}.ri-layout-row-line:before{content:\"\\ee9d\"}.ri-layout-top-2-fill:before{content:\"\\ee9e\"}.ri-layout-top-2-line:before{content:\"\\ee9f\"}.ri-layout-top-fill:before{content:\"\\eea0\"}.ri-layout-top-line:before{content:\"\\eea1\"}.ri-leaf-fill:before{content:\"\\eea2\"}.ri-leaf-line:before{content:\"\\eea3\"}.ri-lifebuoy-fill:before{content:\"\\eea4\"}.ri-lifebuoy-line:before{content:\"\\eea5\"}.ri-lightbulb-fill:before{content:\"\\eea6\"}.ri-lightbulb-flash-fill:before{content:\"\\eea7\"}.ri-lightbulb-flash-line:before{content:\"\\eea8\"}.ri-lightbulb-line:before{content:\"\\eea9\"}.ri-line-chart-fill:before{content:\"\\eeaa\"}.ri-line-chart-line:before{content:\"\\eeab\"}.ri-line-fill:before{content:\"\\eeac\"}.ri-line-height:before{content:\"\\eead\"}.ri-line-line:before{content:\"\\eeae\"}.ri-link-m:before{content:\"\\eeaf\"}.ri-link-unlink-m:before{content:\"\\eeb0\"}.ri-link-unlink:before{content:\"\\eeb1\"}.ri-link:before{content:\"\\eeb2\"}.ri-linkedin-box-fill:before{content:\"\\eeb3\"}.ri-linkedin-box-line:before{content:\"\\eeb4\"}.ri-linkedin-fill:before{content:\"\\eeb5\"}.ri-linkedin-line:before{content:\"\\eeb6\"}.ri-links-fill:before{content:\"\\eeb7\"}.ri-links-line:before{content:\"\\eeb8\"}.ri-list-check-2:before{content:\"\\eeb9\"}.ri-list-check:before{content:\"\\eeba\"}.ri-list-ordered:before{content:\"\\eebb\"}.ri-list-settings-fill:before{content:\"\\eebc\"}.ri-list-settings-line:before{content:\"\\eebd\"}.ri-list-unordered:before{content:\"\\eebe\"}.ri-live-fill:before{content:\"\\eebf\"}.ri-live-line:before{content:\"\\eec0\"}.ri-loader-2-fill:before{content:\"\\eec1\"}.ri-loader-2-line:before{content:\"\\eec2\"}.ri-loader-3-fill:before{content:\"\\eec3\"}.ri-loader-3-line:before{content:\"\\eec4\"}.ri-loader-4-fill:before{content:\"\\eec5\"}.ri-loader-4-line:before{content:\"\\eec6\"}.ri-loader-5-fill:before{content:\"\\eec7\"}.ri-loader-5-line:before{content:\"\\eec8\"}.ri-loader-fill:before{content:\"\\eec9\"}.ri-loader-line:before{content:\"\\eeca\"}.ri-lock-2-fill:before{content:\"\\eecb\"}.ri-lock-2-line:before{content:\"\\eecc\"}.ri-lock-fill:before{content:\"\\eecd\"}.ri-lock-line:before{content:\"\\eece\"}.ri-lock-password-fill:before{content:\"\\eecf\"}.ri-lock-password-line:before{content:\"\\eed0\"}.ri-lock-unlock-fill:before{content:\"\\eed1\"}.ri-lock-unlock-line:before{content:\"\\eed2\"}.ri-login-box-fill:before{content:\"\\eed3\"}.ri-login-box-line:before{content:\"\\eed4\"}.ri-login-circle-fill:before{content:\"\\eed5\"}.ri-login-circle-line:before{content:\"\\eed6\"}.ri-logout-box-fill:before{content:\"\\eed7\"}.ri-logout-box-line:before{content:\"\\eed8\"}.ri-logout-box-r-fill:before{content:\"\\eed9\"}.ri-logout-box-r-line:before{content:\"\\eeda\"}.ri-logout-circle-fill:before{content:\"\\eedb\"}.ri-logout-circle-line:before{content:\"\\eedc\"}.ri-logout-circle-r-fill:before{content:\"\\eedd\"}.ri-logout-circle-r-line:before{content:\"\\eede\"}.ri-luggage-cart-fill:before{content:\"\\eedf\"}.ri-luggage-cart-line:before{content:\"\\eee0\"}.ri-luggage-deposit-fill:before{content:\"\\eee1\"}.ri-luggage-deposit-line:before{content:\"\\eee2\"}.ri-lungs-fill:before{content:\"\\eee3\"}.ri-lungs-line:before{content:\"\\eee4\"}.ri-mac-fill:before{content:\"\\eee5\"}.ri-mac-line:before{content:\"\\eee6\"}.ri-macbook-fill:before{content:\"\\eee7\"}.ri-macbook-line:before{content:\"\\eee8\"}.ri-magic-fill:before{content:\"\\eee9\"}.ri-magic-line:before{content:\"\\eeea\"}.ri-mail-add-fill:before{content:\"\\eeeb\"}.ri-mail-add-line:before{content:\"\\eeec\"}.ri-mail-check-fill:before{content:\"\\eeed\"}.ri-mail-check-line:before{content:\"\\eeee\"}.ri-mail-close-fill:before{content:\"\\eeef\"}.ri-mail-close-line:before{content:\"\\eef0\"}.ri-mail-download-fill:before{content:\"\\eef1\"}.ri-mail-download-line:before{content:\"\\eef2\"}.ri-mail-fill:before{content:\"\\eef3\"}.ri-mail-forbid-fill:before{content:\"\\eef4\"}.ri-mail-forbid-line:before{content:\"\\eef5\"}.ri-mail-line:before{content:\"\\eef6\"}.ri-mail-lock-fill:before{content:\"\\eef7\"}.ri-mail-lock-line:before{content:\"\\eef8\"}.ri-mail-open-fill:before{content:\"\\eef9\"}.ri-mail-open-line:before{content:\"\\eefa\"}.ri-mail-send-fill:before{content:\"\\eefb\"}.ri-mail-send-line:before{content:\"\\eefc\"}.ri-mail-settings-fill:before{content:\"\\eefd\"}.ri-mail-settings-line:before{content:\"\\eefe\"}.ri-mail-star-fill:before{content:\"\\eeff\"}.ri-mail-star-line:before{content:\"\\ef00\"}.ri-mail-unread-fill:before{content:\"\\ef01\"}.ri-mail-unread-line:before{content:\"\\ef02\"}.ri-mail-volume-fill:before{content:\"\\ef03\"}.ri-mail-volume-line:before{content:\"\\ef04\"}.ri-map-2-fill:before{content:\"\\ef05\"}.ri-map-2-line:before{content:\"\\ef06\"}.ri-map-fill:before{content:\"\\ef07\"}.ri-map-line:before{content:\"\\ef08\"}.ri-map-pin-2-fill:before{content:\"\\ef09\"}.ri-map-pin-2-line:before{content:\"\\ef0a\"}.ri-map-pin-3-fill:before{content:\"\\ef0b\"}.ri-map-pin-3-line:before{content:\"\\ef0c\"}.ri-map-pin-4-fill:before{content:\"\\ef0d\"}.ri-map-pin-4-line:before{content:\"\\ef0e\"}.ri-map-pin-5-fill:before{content:\"\\ef0f\"}.ri-map-pin-5-line:before{content:\"\\ef10\"}.ri-map-pin-add-fill:before{content:\"\\ef11\"}.ri-map-pin-add-line:before{content:\"\\ef12\"}.ri-map-pin-fill:before{content:\"\\ef13\"}.ri-map-pin-line:before{content:\"\\ef14\"}.ri-map-pin-range-fill:before{content:\"\\ef15\"}.ri-map-pin-range-line:before{content:\"\\ef16\"}.ri-map-pin-time-fill:before{content:\"\\ef17\"}.ri-map-pin-time-line:before{content:\"\\ef18\"}.ri-map-pin-user-fill:before{content:\"\\ef19\"}.ri-map-pin-user-line:before{content:\"\\ef1a\"}.ri-mark-pen-fill:before{content:\"\\ef1b\"}.ri-mark-pen-line:before{content:\"\\ef1c\"}.ri-markdown-fill:before{content:\"\\ef1d\"}.ri-markdown-line:before{content:\"\\ef1e\"}.ri-markup-fill:before{content:\"\\ef1f\"}.ri-markup-line:before{content:\"\\ef20\"}.ri-mastercard-fill:before{content:\"\\ef21\"}.ri-mastercard-line:before{content:\"\\ef22\"}.ri-mastodon-fill:before{content:\"\\ef23\"}.ri-mastodon-line:before{content:\"\\ef24\"}.ri-medal-2-fill:before{content:\"\\ef25\"}.ri-medal-2-line:before{content:\"\\ef26\"}.ri-medal-fill:before{content:\"\\ef27\"}.ri-medal-line:before{content:\"\\ef28\"}.ri-medicine-bottle-fill:before{content:\"\\ef29\"}.ri-medicine-bottle-line:before{content:\"\\ef2a\"}.ri-medium-fill:before{content:\"\\ef2b\"}.ri-medium-line:before{content:\"\\ef2c\"}.ri-men-fill:before{content:\"\\ef2d\"}.ri-men-line:before{content:\"\\ef2e\"}.ri-mental-health-fill:before{content:\"\\ef2f\"}.ri-mental-health-line:before{content:\"\\ef30\"}.ri-menu-2-fill:before{content:\"\\ef31\"}.ri-menu-2-line:before{content:\"\\ef32\"}.ri-menu-3-fill:before{content:\"\\ef33\"}.ri-menu-3-line:before{content:\"\\ef34\"}.ri-menu-4-fill:before{content:\"\\ef35\"}.ri-menu-4-line:before{content:\"\\ef36\"}.ri-menu-5-fill:before{content:\"\\ef37\"}.ri-menu-5-line:before{content:\"\\ef38\"}.ri-menu-add-fill:before{content:\"\\ef39\"}.ri-menu-add-line:before{content:\"\\ef3a\"}.ri-menu-fill:before{content:\"\\ef3b\"}.ri-menu-fold-fill:before{content:\"\\ef3c\"}.ri-menu-fold-line:before{content:\"\\ef3d\"}.ri-menu-line:before{content:\"\\ef3e\"}.ri-menu-unfold-fill:before{content:\"\\ef3f\"}.ri-menu-unfold-line:before{content:\"\\ef40\"}.ri-merge-cells-horizontal:before{content:\"\\ef41\"}.ri-merge-cells-vertical:before{content:\"\\ef42\"}.ri-message-2-fill:before{content:\"\\ef43\"}.ri-message-2-line:before{content:\"\\ef44\"}.ri-message-3-fill:before{content:\"\\ef45\"}.ri-message-3-line:before{content:\"\\ef46\"}.ri-message-fill:before{content:\"\\ef47\"}.ri-message-line:before{content:\"\\ef48\"}.ri-messenger-fill:before{content:\"\\ef49\"}.ri-messenger-line:before{content:\"\\ef4a\"}.ri-meteor-fill:before{content:\"\\ef4b\"}.ri-meteor-line:before{content:\"\\ef4c\"}.ri-mic-2-fill:before{content:\"\\ef4d\"}.ri-mic-2-line:before{content:\"\\ef4e\"}.ri-mic-fill:before{content:\"\\ef4f\"}.ri-mic-line:before{content:\"\\ef50\"}.ri-mic-off-fill:before{content:\"\\ef51\"}.ri-mic-off-line:before{content:\"\\ef52\"}.ri-mickey-fill:before{content:\"\\ef53\"}.ri-mickey-line:before{content:\"\\ef54\"}.ri-microscope-fill:before{content:\"\\ef55\"}.ri-microscope-line:before{content:\"\\ef56\"}.ri-microsoft-fill:before{content:\"\\ef57\"}.ri-microsoft-line:before{content:\"\\ef58\"}.ri-mind-map:before{content:\"\\ef59\"}.ri-mini-program-fill:before{content:\"\\ef5a\"}.ri-mini-program-line:before{content:\"\\ef5b\"}.ri-mist-fill:before{content:\"\\ef5c\"}.ri-mist-line:before{content:\"\\ef5d\"}.ri-money-cny-box-fill:before{content:\"\\ef5e\"}.ri-money-cny-box-line:before{content:\"\\ef5f\"}.ri-money-cny-circle-fill:before{content:\"\\ef60\"}.ri-money-cny-circle-line:before{content:\"\\ef61\"}.ri-money-dollar-box-fill:before{content:\"\\ef62\"}.ri-money-dollar-box-line:before{content:\"\\ef63\"}.ri-money-dollar-circle-fill:before{content:\"\\ef64\"}.ri-money-dollar-circle-line:before{content:\"\\ef65\"}.ri-money-euro-box-fill:before{content:\"\\ef66\"}.ri-money-euro-box-line:before{content:\"\\ef67\"}.ri-money-euro-circle-fill:before{content:\"\\ef68\"}.ri-money-euro-circle-line:before{content:\"\\ef69\"}.ri-money-pound-box-fill:before{content:\"\\ef6a\"}.ri-money-pound-box-line:before{content:\"\\ef6b\"}.ri-money-pound-circle-fill:before{content:\"\\ef6c\"}.ri-money-pound-circle-line:before{content:\"\\ef6d\"}.ri-moon-clear-fill:before{content:\"\\ef6e\"}.ri-moon-clear-line:before{content:\"\\ef6f\"}.ri-moon-cloudy-fill:before{content:\"\\ef70\"}.ri-moon-cloudy-line:before{content:\"\\ef71\"}.ri-moon-fill:before{content:\"\\ef72\"}.ri-moon-foggy-fill:before{content:\"\\ef73\"}.ri-moon-foggy-line:before{content:\"\\ef74\"}.ri-moon-line:before{content:\"\\ef75\"}.ri-more-2-fill:before{content:\"\\ef76\"}.ri-more-2-line:before{content:\"\\ef77\"}.ri-more-fill:before{content:\"\\ef78\"}.ri-more-line:before{content:\"\\ef79\"}.ri-motorbike-fill:before{content:\"\\ef7a\"}.ri-motorbike-line:before{content:\"\\ef7b\"}.ri-mouse-fill:before{content:\"\\ef7c\"}.ri-mouse-line:before{content:\"\\ef7d\"}.ri-movie-2-fill:before{content:\"\\ef7e\"}.ri-movie-2-line:before{content:\"\\ef7f\"}.ri-movie-fill:before{content:\"\\ef80\"}.ri-movie-line:before{content:\"\\ef81\"}.ri-music-2-fill:before{content:\"\\ef82\"}.ri-music-2-line:before{content:\"\\ef83\"}.ri-music-fill:before{content:\"\\ef84\"}.ri-music-line:before{content:\"\\ef85\"}.ri-mv-fill:before{content:\"\\ef86\"}.ri-mv-line:before{content:\"\\ef87\"}.ri-navigation-fill:before{content:\"\\ef88\"}.ri-navigation-line:before{content:\"\\ef89\"}.ri-netease-cloud-music-fill:before{content:\"\\ef8a\"}.ri-netease-cloud-music-line:before{content:\"\\ef8b\"}.ri-netflix-fill:before{content:\"\\ef8c\"}.ri-netflix-line:before{content:\"\\ef8d\"}.ri-newspaper-fill:before{content:\"\\ef8e\"}.ri-newspaper-line:before{content:\"\\ef8f\"}.ri-node-tree:before{content:\"\\ef90\"}.ri-notification-2-fill:before{content:\"\\ef91\"}.ri-notification-2-line:before{content:\"\\ef92\"}.ri-notification-3-fill:before{content:\"\\ef93\"}.ri-notification-3-line:before{content:\"\\ef94\"}.ri-notification-4-fill:before{content:\"\\ef95\"}.ri-notification-4-line:before{content:\"\\ef96\"}.ri-notification-badge-fill:before{content:\"\\ef97\"}.ri-notification-badge-line:before{content:\"\\ef98\"}.ri-notification-fill:before{content:\"\\ef99\"}.ri-notification-line:before{content:\"\\ef9a\"}.ri-notification-off-fill:before{content:\"\\ef9b\"}.ri-notification-off-line:before{content:\"\\ef9c\"}.ri-npmjs-fill:before{content:\"\\ef9d\"}.ri-npmjs-line:before{content:\"\\ef9e\"}.ri-number-0:before{content:\"\\ef9f\"}.ri-number-1:before{content:\"\\efa0\"}.ri-number-2:before{content:\"\\efa1\"}.ri-number-3:before{content:\"\\efa2\"}.ri-number-4:before{content:\"\\efa3\"}.ri-number-5:before{content:\"\\efa4\"}.ri-number-6:before{content:\"\\efa5\"}.ri-number-7:before{content:\"\\efa6\"}.ri-number-8:before{content:\"\\efa7\"}.ri-number-9:before{content:\"\\efa8\"}.ri-numbers-fill:before{content:\"\\efa9\"}.ri-numbers-line:before{content:\"\\efaa\"}.ri-nurse-fill:before{content:\"\\efab\"}.ri-nurse-line:before{content:\"\\efac\"}.ri-oil-fill:before{content:\"\\efad\"}.ri-oil-line:before{content:\"\\efae\"}.ri-omega:before{content:\"\\efaf\"}.ri-open-arm-fill:before{content:\"\\efb0\"}.ri-open-arm-line:before{content:\"\\efb1\"}.ri-open-source-fill:before{content:\"\\efb2\"}.ri-open-source-line:before{content:\"\\efb3\"}.ri-opera-fill:before{content:\"\\efb4\"}.ri-opera-line:before{content:\"\\efb5\"}.ri-order-play-fill:before{content:\"\\efb6\"}.ri-order-play-line:before{content:\"\\efb7\"}.ri-organization-chart:before{content:\"\\efb8\"}.ri-outlet-2-fill:before{content:\"\\efb9\"}.ri-outlet-2-line:before{content:\"\\efba\"}.ri-outlet-fill:before{content:\"\\efbb\"}.ri-outlet-line:before{content:\"\\efbc\"}.ri-page-separator:before{content:\"\\efbd\"}.ri-pages-fill:before{content:\"\\efbe\"}.ri-pages-line:before{content:\"\\efbf\"}.ri-paint-brush-fill:before{content:\"\\efc0\"}.ri-paint-brush-line:before{content:\"\\efc1\"}.ri-paint-fill:before{content:\"\\efc2\"}.ri-paint-line:before{content:\"\\efc3\"}.ri-palette-fill:before{content:\"\\efc4\"}.ri-palette-line:before{content:\"\\efc5\"}.ri-pantone-fill:before{content:\"\\efc6\"}.ri-pantone-line:before{content:\"\\efc7\"}.ri-paragraph:before{content:\"\\efc8\"}.ri-parent-fill:before{content:\"\\efc9\"}.ri-parent-line:before{content:\"\\efca\"}.ri-parentheses-fill:before{content:\"\\efcb\"}.ri-parentheses-line:before{content:\"\\efcc\"}.ri-parking-box-fill:before{content:\"\\efcd\"}.ri-parking-box-line:before{content:\"\\efce\"}.ri-parking-fill:before{content:\"\\efcf\"}.ri-parking-line:before{content:\"\\efd0\"}.ri-passport-fill:before{content:\"\\efd1\"}.ri-passport-line:before{content:\"\\efd2\"}.ri-patreon-fill:before{content:\"\\efd3\"}.ri-patreon-line:before{content:\"\\efd4\"}.ri-pause-circle-fill:before{content:\"\\efd5\"}.ri-pause-circle-line:before{content:\"\\efd6\"}.ri-pause-fill:before{content:\"\\efd7\"}.ri-pause-line:before{content:\"\\efd8\"}.ri-pause-mini-fill:before{content:\"\\efd9\"}.ri-pause-mini-line:before{content:\"\\efda\"}.ri-paypal-fill:before{content:\"\\efdb\"}.ri-paypal-line:before{content:\"\\efdc\"}.ri-pen-nib-fill:before{content:\"\\efdd\"}.ri-pen-nib-line:before{content:\"\\efde\"}.ri-pencil-fill:before{content:\"\\efdf\"}.ri-pencil-line:before{content:\"\\efe0\"}.ri-pencil-ruler-2-fill:before{content:\"\\efe1\"}.ri-pencil-ruler-2-line:before{content:\"\\efe2\"}.ri-pencil-ruler-fill:before{content:\"\\efe3\"}.ri-pencil-ruler-line:before{content:\"\\efe4\"}.ri-percent-fill:before{content:\"\\efe5\"}.ri-percent-line:before{content:\"\\efe6\"}.ri-phone-camera-fill:before{content:\"\\efe7\"}.ri-phone-camera-line:before{content:\"\\efe8\"}.ri-phone-fill:before{content:\"\\efe9\"}.ri-phone-find-fill:before{content:\"\\efea\"}.ri-phone-find-line:before{content:\"\\efeb\"}.ri-phone-line:before{content:\"\\efec\"}.ri-phone-lock-fill:before{content:\"\\efed\"}.ri-phone-lock-line:before{content:\"\\efee\"}.ri-picture-in-picture-2-fill:before{content:\"\\efef\"}.ri-picture-in-picture-2-line:before{content:\"\\eff0\"}.ri-picture-in-picture-exit-fill:before{content:\"\\eff1\"}.ri-picture-in-picture-exit-line:before{content:\"\\eff2\"}.ri-picture-in-picture-fill:before{content:\"\\eff3\"}.ri-picture-in-picture-line:before{content:\"\\eff4\"}.ri-pie-chart-2-fill:before{content:\"\\eff5\"}.ri-pie-chart-2-line:before{content:\"\\eff6\"}.ri-pie-chart-box-fill:before{content:\"\\eff7\"}.ri-pie-chart-box-line:before{content:\"\\eff8\"}.ri-pie-chart-fill:before{content:\"\\eff9\"}.ri-pie-chart-line:before{content:\"\\effa\"}.ri-pin-distance-fill:before{content:\"\\effb\"}.ri-pin-distance-line:before{content:\"\\effc\"}.ri-ping-pong-fill:before{content:\"\\effd\"}.ri-ping-pong-line:before{content:\"\\effe\"}.ri-pinterest-fill:before{content:\"\\efff\"}.ri-pinterest-line:before{content:\"\\f000\"}.ri-pinyin-input:before{content:\"\\f001\"}.ri-pixelfed-fill:before{content:\"\\f002\"}.ri-pixelfed-line:before{content:\"\\f003\"}.ri-plane-fill:before{content:\"\\f004\"}.ri-plane-line:before{content:\"\\f005\"}.ri-plant-fill:before{content:\"\\f006\"}.ri-plant-line:before{content:\"\\f007\"}.ri-play-circle-fill:before{content:\"\\f008\"}.ri-play-circle-line:before{content:\"\\f009\"}.ri-play-fill:before{content:\"\\f00a\"}.ri-play-line:before{content:\"\\f00b\"}.ri-play-list-2-fill:before{content:\"\\f00c\"}.ri-play-list-2-line:before{content:\"\\f00d\"}.ri-play-list-add-fill:before{content:\"\\f00e\"}.ri-play-list-add-line:before{content:\"\\f00f\"}.ri-play-list-fill:before{content:\"\\f010\"}.ri-play-list-line:before{content:\"\\f011\"}.ri-play-mini-fill:before{content:\"\\f012\"}.ri-play-mini-line:before{content:\"\\f013\"}.ri-playstation-fill:before{content:\"\\f014\"}.ri-playstation-line:before{content:\"\\f015\"}.ri-plug-2-fill:before{content:\"\\f016\"}.ri-plug-2-line:before{content:\"\\f017\"}.ri-plug-fill:before{content:\"\\f018\"}.ri-plug-line:before{content:\"\\f019\"}.ri-polaroid-2-fill:before{content:\"\\f01a\"}.ri-polaroid-2-line:before{content:\"\\f01b\"}.ri-polaroid-fill:before{content:\"\\f01c\"}.ri-polaroid-line:before{content:\"\\f01d\"}.ri-police-car-fill:before{content:\"\\f01e\"}.ri-police-car-line:before{content:\"\\f01f\"}.ri-price-tag-2-fill:before{content:\"\\f020\"}.ri-price-tag-2-line:before{content:\"\\f021\"}.ri-price-tag-3-fill:before{content:\"\\f022\"}.ri-price-tag-3-line:before{content:\"\\f023\"}.ri-price-tag-fill:before{content:\"\\f024\"}.ri-price-tag-line:before{content:\"\\f025\"}.ri-printer-cloud-fill:before{content:\"\\f026\"}.ri-printer-cloud-line:before{content:\"\\f027\"}.ri-printer-fill:before{content:\"\\f028\"}.ri-printer-line:before{content:\"\\f029\"}.ri-product-hunt-fill:before{content:\"\\f02a\"}.ri-product-hunt-line:before{content:\"\\f02b\"}.ri-profile-fill:before{content:\"\\f02c\"}.ri-profile-line:before{content:\"\\f02d\"}.ri-projector-2-fill:before{content:\"\\f02e\"}.ri-projector-2-line:before{content:\"\\f02f\"}.ri-projector-fill:before{content:\"\\f030\"}.ri-projector-line:before{content:\"\\f031\"}.ri-psychotherapy-fill:before{content:\"\\f032\"}.ri-psychotherapy-line:before{content:\"\\f033\"}.ri-pulse-fill:before{content:\"\\f034\"}.ri-pulse-line:before{content:\"\\f035\"}.ri-pushpin-2-fill:before{content:\"\\f036\"}.ri-pushpin-2-line:before{content:\"\\f037\"}.ri-pushpin-fill:before{content:\"\\f038\"}.ri-pushpin-line:before{content:\"\\f039\"}.ri-qq-fill:before{content:\"\\f03a\"}.ri-qq-line:before{content:\"\\f03b\"}.ri-qr-code-fill:before{content:\"\\f03c\"}.ri-qr-code-line:before{content:\"\\f03d\"}.ri-qr-scan-2-fill:before{content:\"\\f03e\"}.ri-qr-scan-2-line:before{content:\"\\f03f\"}.ri-qr-scan-fill:before{content:\"\\f040\"}.ri-qr-scan-line:before{content:\"\\f041\"}.ri-question-answer-fill:before{content:\"\\f042\"}.ri-question-answer-line:before{content:\"\\f043\"}.ri-question-fill:before{content:\"\\f044\"}.ri-question-line:before{content:\"\\f045\"}.ri-question-mark:before{content:\"\\f046\"}.ri-questionnaire-fill:before{content:\"\\f047\"}.ri-questionnaire-line:before{content:\"\\f048\"}.ri-quill-pen-fill:before{content:\"\\f049\"}.ri-quill-pen-line:before{content:\"\\f04a\"}.ri-radar-fill:before{content:\"\\f04b\"}.ri-radar-line:before{content:\"\\f04c\"}.ri-radio-2-fill:before{content:\"\\f04d\"}.ri-radio-2-line:before{content:\"\\f04e\"}.ri-radio-button-fill:before{content:\"\\f04f\"}.ri-radio-button-line:before{content:\"\\f050\"}.ri-radio-fill:before{content:\"\\f051\"}.ri-radio-line:before{content:\"\\f052\"}.ri-rainbow-fill:before{content:\"\\f053\"}.ri-rainbow-line:before{content:\"\\f054\"}.ri-rainy-fill:before{content:\"\\f055\"}.ri-rainy-line:before{content:\"\\f056\"}.ri-reactjs-fill:before{content:\"\\f057\"}.ri-reactjs-line:before{content:\"\\f058\"}.ri-record-circle-fill:before{content:\"\\f059\"}.ri-record-circle-line:before{content:\"\\f05a\"}.ri-record-mail-fill:before{content:\"\\f05b\"}.ri-record-mail-line:before{content:\"\\f05c\"}.ri-recycle-fill:before{content:\"\\f05d\"}.ri-recycle-line:before{content:\"\\f05e\"}.ri-red-packet-fill:before{content:\"\\f05f\"}.ri-red-packet-line:before{content:\"\\f060\"}.ri-reddit-fill:before{content:\"\\f061\"}.ri-reddit-line:before{content:\"\\f062\"}.ri-refresh-fill:before{content:\"\\f063\"}.ri-refresh-line:before{content:\"\\f064\"}.ri-refund-2-fill:before{content:\"\\f065\"}.ri-refund-2-line:before{content:\"\\f066\"}.ri-refund-fill:before{content:\"\\f067\"}.ri-refund-line:before{content:\"\\f068\"}.ri-registered-fill:before{content:\"\\f069\"}.ri-registered-line:before{content:\"\\f06a\"}.ri-remixicon-fill:before{content:\"\\f06b\"}.ri-remixicon-line:before{content:\"\\f06c\"}.ri-remote-control-2-fill:before{content:\"\\f06d\"}.ri-remote-control-2-line:before{content:\"\\f06e\"}.ri-remote-control-fill:before{content:\"\\f06f\"}.ri-remote-control-line:before{content:\"\\f070\"}.ri-repeat-2-fill:before{content:\"\\f071\"}.ri-repeat-2-line:before{content:\"\\f072\"}.ri-repeat-fill:before{content:\"\\f073\"}.ri-repeat-line:before{content:\"\\f074\"}.ri-repeat-one-fill:before{content:\"\\f075\"}.ri-repeat-one-line:before{content:\"\\f076\"}.ri-reply-all-fill:before{content:\"\\f077\"}.ri-reply-all-line:before{content:\"\\f078\"}.ri-reply-fill:before{content:\"\\f079\"}.ri-reply-line:before{content:\"\\f07a\"}.ri-reserved-fill:before{content:\"\\f07b\"}.ri-reserved-line:before{content:\"\\f07c\"}.ri-rest-time-fill:before{content:\"\\f07d\"}.ri-rest-time-line:before{content:\"\\f07e\"}.ri-restart-fill:before{content:\"\\f07f\"}.ri-restart-line:before{content:\"\\f080\"}.ri-restaurant-2-fill:before{content:\"\\f081\"}.ri-restaurant-2-line:before{content:\"\\f082\"}.ri-restaurant-fill:before{content:\"\\f083\"}.ri-restaurant-line:before{content:\"\\f084\"}.ri-rewind-fill:before{content:\"\\f085\"}.ri-rewind-line:before{content:\"\\f086\"}.ri-rewind-mini-fill:before{content:\"\\f087\"}.ri-rewind-mini-line:before{content:\"\\f088\"}.ri-rhythm-fill:before{content:\"\\f089\"}.ri-rhythm-line:before{content:\"\\f08a\"}.ri-riding-fill:before{content:\"\\f08b\"}.ri-riding-line:before{content:\"\\f08c\"}.ri-road-map-fill:before{content:\"\\f08d\"}.ri-road-map-line:before{content:\"\\f08e\"}.ri-roadster-fill:before{content:\"\\f08f\"}.ri-roadster-line:before{content:\"\\f090\"}.ri-robot-fill:before{content:\"\\f091\"}.ri-robot-line:before{content:\"\\f092\"}.ri-rocket-2-fill:before{content:\"\\f093\"}.ri-rocket-2-line:before{content:\"\\f094\"}.ri-rocket-fill:before{content:\"\\f095\"}.ri-rocket-line:before{content:\"\\f096\"}.ri-rotate-lock-fill:before{content:\"\\f097\"}.ri-rotate-lock-line:before{content:\"\\f098\"}.ri-rounded-corner:before{content:\"\\f099\"}.ri-route-fill:before{content:\"\\f09a\"}.ri-route-line:before{content:\"\\f09b\"}.ri-router-fill:before{content:\"\\f09c\"}.ri-router-line:before{content:\"\\f09d\"}.ri-rss-fill:before{content:\"\\f09e\"}.ri-rss-line:before{content:\"\\f09f\"}.ri-ruler-2-fill:before{content:\"\\f0a0\"}.ri-ruler-2-line:before{content:\"\\f0a1\"}.ri-ruler-fill:before{content:\"\\f0a2\"}.ri-ruler-line:before{content:\"\\f0a3\"}.ri-run-fill:before{content:\"\\f0a4\"}.ri-run-line:before{content:\"\\f0a5\"}.ri-safari-fill:before{content:\"\\f0a6\"}.ri-safari-line:before{content:\"\\f0a7\"}.ri-safe-2-fill:before{content:\"\\f0a8\"}.ri-safe-2-line:before{content:\"\\f0a9\"}.ri-safe-fill:before{content:\"\\f0aa\"}.ri-safe-line:before{content:\"\\f0ab\"}.ri-sailboat-fill:before{content:\"\\f0ac\"}.ri-sailboat-line:before{content:\"\\f0ad\"}.ri-save-2-fill:before{content:\"\\f0ae\"}.ri-save-2-line:before{content:\"\\f0af\"}.ri-save-3-fill:before{content:\"\\f0b0\"}.ri-save-3-line:before{content:\"\\f0b1\"}.ri-save-fill:before{content:\"\\f0b2\"}.ri-save-line:before{content:\"\\f0b3\"}.ri-scales-2-fill:before{content:\"\\f0b4\"}.ri-scales-2-line:before{content:\"\\f0b5\"}.ri-scales-3-fill:before{content:\"\\f0b6\"}.ri-scales-3-line:before{content:\"\\f0b7\"}.ri-scales-fill:before{content:\"\\f0b8\"}.ri-scales-line:before{content:\"\\f0b9\"}.ri-scan-2-fill:before{content:\"\\f0ba\"}.ri-scan-2-line:before{content:\"\\f0bb\"}.ri-scan-fill:before{content:\"\\f0bc\"}.ri-scan-line:before{content:\"\\f0bd\"}.ri-scissors-2-fill:before{content:\"\\f0be\"}.ri-scissors-2-line:before{content:\"\\f0bf\"}.ri-scissors-cut-fill:before{content:\"\\f0c0\"}.ri-scissors-cut-line:before{content:\"\\f0c1\"}.ri-scissors-fill:before{content:\"\\f0c2\"}.ri-scissors-line:before{content:\"\\f0c3\"}.ri-screenshot-2-fill:before{content:\"\\f0c4\"}.ri-screenshot-2-line:before{content:\"\\f0c5\"}.ri-screenshot-fill:before{content:\"\\f0c6\"}.ri-screenshot-line:before{content:\"\\f0c7\"}.ri-sd-card-fill:before{content:\"\\f0c8\"}.ri-sd-card-line:before{content:\"\\f0c9\"}.ri-sd-card-mini-fill:before{content:\"\\f0ca\"}.ri-sd-card-mini-line:before{content:\"\\f0cb\"}.ri-search-2-fill:before{content:\"\\f0cc\"}.ri-search-2-line:before{content:\"\\f0cd\"}.ri-search-eye-fill:before{content:\"\\f0ce\"}.ri-search-eye-line:before{content:\"\\f0cf\"}.ri-search-fill:before{content:\"\\f0d0\"}.ri-search-line:before{content:\"\\f0d1\"}.ri-secure-payment-fill:before{content:\"\\f0d2\"}.ri-secure-payment-line:before{content:\"\\f0d3\"}.ri-seedling-fill:before{content:\"\\f0d4\"}.ri-seedling-line:before{content:\"\\f0d5\"}.ri-send-backward:before{content:\"\\f0d6\"}.ri-send-plane-2-fill:before{content:\"\\f0d7\"}.ri-send-plane-2-line:before{content:\"\\f0d8\"}.ri-send-plane-fill:before{content:\"\\f0d9\"}.ri-send-plane-line:before{content:\"\\f0da\"}.ri-send-to-back:before{content:\"\\f0db\"}.ri-sensor-fill:before{content:\"\\f0dc\"}.ri-sensor-line:before{content:\"\\f0dd\"}.ri-separator:before{content:\"\\f0de\"}.ri-server-fill:before{content:\"\\f0df\"}.ri-server-line:before{content:\"\\f0e0\"}.ri-service-fill:before{content:\"\\f0e1\"}.ri-service-line:before{content:\"\\f0e2\"}.ri-settings-2-fill:before{content:\"\\f0e3\"}.ri-settings-2-line:before{content:\"\\f0e4\"}.ri-settings-3-fill:before{content:\"\\f0e5\"}.ri-settings-3-line:before{content:\"\\f0e6\"}.ri-settings-4-fill:before{content:\"\\f0e7\"}.ri-settings-4-line:before{content:\"\\f0e8\"}.ri-settings-5-fill:before{content:\"\\f0e9\"}.ri-settings-5-line:before{content:\"\\f0ea\"}.ri-settings-6-fill:before{content:\"\\f0eb\"}.ri-settings-6-line:before{content:\"\\f0ec\"}.ri-settings-fill:before{content:\"\\f0ed\"}.ri-settings-line:before{content:\"\\f0ee\"}.ri-shape-2-fill:before{content:\"\\f0ef\"}.ri-shape-2-line:before{content:\"\\f0f0\"}.ri-shape-fill:before{content:\"\\f0f1\"}.ri-shape-line:before{content:\"\\f0f2\"}.ri-share-box-fill:before{content:\"\\f0f3\"}.ri-share-box-line:before{content:\"\\f0f4\"}.ri-share-circle-fill:before{content:\"\\f0f5\"}.ri-share-circle-line:before{content:\"\\f0f6\"}.ri-share-fill:before{content:\"\\f0f7\"}.ri-share-forward-2-fill:before{content:\"\\f0f8\"}.ri-share-forward-2-line:before{content:\"\\f0f9\"}.ri-share-forward-box-fill:before{content:\"\\f0fa\"}.ri-share-forward-box-line:before{content:\"\\f0fb\"}.ri-share-forward-fill:before{content:\"\\f0fc\"}.ri-share-forward-line:before{content:\"\\f0fd\"}.ri-share-line:before{content:\"\\f0fe\"}.ri-shield-check-fill:before{content:\"\\f0ff\"}.ri-shield-check-line:before{content:\"\\f100\"}.ri-shield-cross-fill:before{content:\"\\f101\"}.ri-shield-cross-line:before{content:\"\\f102\"}.ri-shield-fill:before{content:\"\\f103\"}.ri-shield-flash-fill:before{content:\"\\f104\"}.ri-shield-flash-line:before{content:\"\\f105\"}.ri-shield-keyhole-fill:before{content:\"\\f106\"}.ri-shield-keyhole-line:before{content:\"\\f107\"}.ri-shield-line:before{content:\"\\f108\"}.ri-shield-star-fill:before{content:\"\\f109\"}.ri-shield-star-line:before{content:\"\\f10a\"}.ri-shield-user-fill:before{content:\"\\f10b\"}.ri-shield-user-line:before{content:\"\\f10c\"}.ri-ship-2-fill:before{content:\"\\f10d\"}.ri-ship-2-line:before{content:\"\\f10e\"}.ri-ship-fill:before{content:\"\\f10f\"}.ri-ship-line:before{content:\"\\f110\"}.ri-shirt-fill:before{content:\"\\f111\"}.ri-shirt-line:before{content:\"\\f112\"}.ri-shopping-bag-2-fill:before{content:\"\\f113\"}.ri-shopping-bag-2-line:before{content:\"\\f114\"}.ri-shopping-bag-3-fill:before{content:\"\\f115\"}.ri-shopping-bag-3-line:before{content:\"\\f116\"}.ri-shopping-bag-fill:before{content:\"\\f117\"}.ri-shopping-bag-line:before{content:\"\\f118\"}.ri-shopping-basket-2-fill:before{content:\"\\f119\"}.ri-shopping-basket-2-line:before{content:\"\\f11a\"}.ri-shopping-basket-fill:before{content:\"\\f11b\"}.ri-shopping-basket-line:before{content:\"\\f11c\"}.ri-shopping-cart-2-fill:before{content:\"\\f11d\"}.ri-shopping-cart-2-line:before{content:\"\\f11e\"}.ri-shopping-cart-fill:before{content:\"\\f11f\"}.ri-shopping-cart-line:before{content:\"\\f120\"}.ri-showers-fill:before{content:\"\\f121\"}.ri-showers-line:before{content:\"\\f122\"}.ri-shuffle-fill:before{content:\"\\f123\"}.ri-shuffle-line:before{content:\"\\f124\"}.ri-shut-down-fill:before{content:\"\\f125\"}.ri-shut-down-line:before{content:\"\\f126\"}.ri-side-bar-fill:before{content:\"\\f127\"}.ri-side-bar-line:before{content:\"\\f128\"}.ri-signal-tower-fill:before{content:\"\\f129\"}.ri-signal-tower-line:before{content:\"\\f12a\"}.ri-signal-wifi-1-fill:before{content:\"\\f12b\"}.ri-signal-wifi-1-line:before{content:\"\\f12c\"}.ri-signal-wifi-2-fill:before{content:\"\\f12d\"}.ri-signal-wifi-2-line:before{content:\"\\f12e\"}.ri-signal-wifi-3-fill:before{content:\"\\f12f\"}.ri-signal-wifi-3-line:before{content:\"\\f130\"}.ri-signal-wifi-error-fill:before{content:\"\\f131\"}.ri-signal-wifi-error-line:before{content:\"\\f132\"}.ri-signal-wifi-fill:before{content:\"\\f133\"}.ri-signal-wifi-line:before{content:\"\\f134\"}.ri-signal-wifi-off-fill:before{content:\"\\f135\"}.ri-signal-wifi-off-line:before{content:\"\\f136\"}.ri-sim-card-2-fill:before{content:\"\\f137\"}.ri-sim-card-2-line:before{content:\"\\f138\"}.ri-sim-card-fill:before{content:\"\\f139\"}.ri-sim-card-line:before{content:\"\\f13a\"}.ri-single-quotes-l:before{content:\"\\f13b\"}.ri-single-quotes-r:before{content:\"\\f13c\"}.ri-sip-fill:before{content:\"\\f13d\"}.ri-sip-line:before{content:\"\\f13e\"}.ri-skip-back-fill:before{content:\"\\f13f\"}.ri-skip-back-line:before{content:\"\\f140\"}.ri-skip-back-mini-fill:before{content:\"\\f141\"}.ri-skip-back-mini-line:before{content:\"\\f142\"}.ri-skip-forward-fill:before{content:\"\\f143\"}.ri-skip-forward-line:before{content:\"\\f144\"}.ri-skip-forward-mini-fill:before{content:\"\\f145\"}.ri-skip-forward-mini-line:before{content:\"\\f146\"}.ri-skull-2-fill:before{content:\"\\f147\"}.ri-skull-2-line:before{content:\"\\f148\"}.ri-skull-fill:before{content:\"\\f149\"}.ri-skull-line:before{content:\"\\f14a\"}.ri-skype-fill:before{content:\"\\f14b\"}.ri-skype-line:before{content:\"\\f14c\"}.ri-slack-fill:before{content:\"\\f14d\"}.ri-slack-line:before{content:\"\\f14e\"}.ri-slice-fill:before{content:\"\\f14f\"}.ri-slice-line:before{content:\"\\f150\"}.ri-slideshow-2-fill:before{content:\"\\f151\"}.ri-slideshow-2-line:before{content:\"\\f152\"}.ri-slideshow-3-fill:before{content:\"\\f153\"}.ri-slideshow-3-line:before{content:\"\\f154\"}.ri-slideshow-4-fill:before{content:\"\\f155\"}.ri-slideshow-4-line:before{content:\"\\f156\"}.ri-slideshow-fill:before{content:\"\\f157\"}.ri-slideshow-line:before{content:\"\\f158\"}.ri-smartphone-fill:before{content:\"\\f159\"}.ri-smartphone-line:before{content:\"\\f15a\"}.ri-snapchat-fill:before{content:\"\\f15b\"}.ri-snapchat-line:before{content:\"\\f15c\"}.ri-snowy-fill:before{content:\"\\f15d\"}.ri-snowy-line:before{content:\"\\f15e\"}.ri-sort-asc:before{content:\"\\f15f\"}.ri-sort-desc:before{content:\"\\f160\"}.ri-sound-module-fill:before{content:\"\\f161\"}.ri-sound-module-line:before{content:\"\\f162\"}.ri-soundcloud-fill:before{content:\"\\f163\"}.ri-soundcloud-line:before{content:\"\\f164\"}.ri-space-ship-fill:before{content:\"\\f165\"}.ri-space-ship-line:before{content:\"\\f166\"}.ri-space:before{content:\"\\f167\"}.ri-spam-2-fill:before{content:\"\\f168\"}.ri-spam-2-line:before{content:\"\\f169\"}.ri-spam-3-fill:before{content:\"\\f16a\"}.ri-spam-3-line:before{content:\"\\f16b\"}.ri-spam-fill:before{content:\"\\f16c\"}.ri-spam-line:before{content:\"\\f16d\"}.ri-speaker-2-fill:before{content:\"\\f16e\"}.ri-speaker-2-line:before{content:\"\\f16f\"}.ri-speaker-3-fill:before{content:\"\\f170\"}.ri-speaker-3-line:before{content:\"\\f171\"}.ri-speaker-fill:before{content:\"\\f172\"}.ri-speaker-line:before{content:\"\\f173\"}.ri-spectrum-fill:before{content:\"\\f174\"}.ri-spectrum-line:before{content:\"\\f175\"}.ri-speed-fill:before{content:\"\\f176\"}.ri-speed-line:before{content:\"\\f177\"}.ri-speed-mini-fill:before{content:\"\\f178\"}.ri-speed-mini-line:before{content:\"\\f179\"}.ri-split-cells-horizontal:before{content:\"\\f17a\"}.ri-split-cells-vertical:before{content:\"\\f17b\"}.ri-spotify-fill:before{content:\"\\f17c\"}.ri-spotify-line:before{content:\"\\f17d\"}.ri-spy-fill:before{content:\"\\f17e\"}.ri-spy-line:before{content:\"\\f17f\"}.ri-stack-fill:before{content:\"\\f180\"}.ri-stack-line:before{content:\"\\f181\"}.ri-stack-overflow-fill:before{content:\"\\f182\"}.ri-stack-overflow-line:before{content:\"\\f183\"}.ri-stackshare-fill:before{content:\"\\f184\"}.ri-stackshare-line:before{content:\"\\f185\"}.ri-star-fill:before{content:\"\\f186\"}.ri-star-half-fill:before{content:\"\\f187\"}.ri-star-half-line:before{content:\"\\f188\"}.ri-star-half-s-fill:before{content:\"\\f189\"}.ri-star-half-s-line:before{content:\"\\f18a\"}.ri-star-line:before{content:\"\\f18b\"}.ri-star-s-fill:before{content:\"\\f18c\"}.ri-star-s-line:before{content:\"\\f18d\"}.ri-star-smile-fill:before{content:\"\\f18e\"}.ri-star-smile-line:before{content:\"\\f18f\"}.ri-steam-fill:before{content:\"\\f190\"}.ri-steam-line:before{content:\"\\f191\"}.ri-steering-2-fill:before{content:\"\\f192\"}.ri-steering-2-line:before{content:\"\\f193\"}.ri-steering-fill:before{content:\"\\f194\"}.ri-steering-line:before{content:\"\\f195\"}.ri-stethoscope-fill:before{content:\"\\f196\"}.ri-stethoscope-line:before{content:\"\\f197\"}.ri-sticky-note-2-fill:before{content:\"\\f198\"}.ri-sticky-note-2-line:before{content:\"\\f199\"}.ri-sticky-note-fill:before{content:\"\\f19a\"}.ri-sticky-note-line:before{content:\"\\f19b\"}.ri-stock-fill:before{content:\"\\f19c\"}.ri-stock-line:before{content:\"\\f19d\"}.ri-stop-circle-fill:before{content:\"\\f19e\"}.ri-stop-circle-line:before{content:\"\\f19f\"}.ri-stop-fill:before{content:\"\\f1a0\"}.ri-stop-line:before{content:\"\\f1a1\"}.ri-stop-mini-fill:before{content:\"\\f1a2\"}.ri-stop-mini-line:before{content:\"\\f1a3\"}.ri-store-2-fill:before{content:\"\\f1a4\"}.ri-store-2-line:before{content:\"\\f1a5\"}.ri-store-3-fill:before{content:\"\\f1a6\"}.ri-store-3-line:before{content:\"\\f1a7\"}.ri-store-fill:before{content:\"\\f1a8\"}.ri-store-line:before{content:\"\\f1a9\"}.ri-strikethrough-2:before{content:\"\\f1aa\"}.ri-strikethrough:before{content:\"\\f1ab\"}.ri-subscript-2:before{content:\"\\f1ac\"}.ri-subscript:before{content:\"\\f1ad\"}.ri-subtract-fill:before{content:\"\\f1ae\"}.ri-subtract-line:before{content:\"\\f1af\"}.ri-subway-fill:before{content:\"\\f1b0\"}.ri-subway-line:before{content:\"\\f1b1\"}.ri-subway-wifi-fill:before{content:\"\\f1b2\"}.ri-subway-wifi-line:before{content:\"\\f1b3\"}.ri-suitcase-2-fill:before{content:\"\\f1b4\"}.ri-suitcase-2-line:before{content:\"\\f1b5\"}.ri-suitcase-3-fill:before{content:\"\\f1b6\"}.ri-suitcase-3-line:before{content:\"\\f1b7\"}.ri-suitcase-fill:before{content:\"\\f1b8\"}.ri-suitcase-line:before{content:\"\\f1b9\"}.ri-sun-cloudy-fill:before{content:\"\\f1ba\"}.ri-sun-cloudy-line:before{content:\"\\f1bb\"}.ri-sun-fill:before{content:\"\\f1bc\"}.ri-sun-foggy-fill:before{content:\"\\f1bd\"}.ri-sun-foggy-line:before{content:\"\\f1be\"}.ri-sun-line:before{content:\"\\f1bf\"}.ri-superscript-2:before{content:\"\\f1c0\"}.ri-superscript:before{content:\"\\f1c1\"}.ri-surgical-mask-fill:before{content:\"\\f1c2\"}.ri-surgical-mask-line:before{content:\"\\f1c3\"}.ri-surround-sound-fill:before{content:\"\\f1c4\"}.ri-surround-sound-line:before{content:\"\\f1c5\"}.ri-survey-fill:before{content:\"\\f1c6\"}.ri-survey-line:before{content:\"\\f1c7\"}.ri-swap-box-fill:before{content:\"\\f1c8\"}.ri-swap-box-line:before{content:\"\\f1c9\"}.ri-swap-fill:before{content:\"\\f1ca\"}.ri-swap-line:before{content:\"\\f1cb\"}.ri-switch-fill:before{content:\"\\f1cc\"}.ri-switch-line:before{content:\"\\f1cd\"}.ri-sword-fill:before{content:\"\\f1ce\"}.ri-sword-line:before{content:\"\\f1cf\"}.ri-syringe-fill:before{content:\"\\f1d0\"}.ri-syringe-line:before{content:\"\\f1d1\"}.ri-t-box-fill:before{content:\"\\f1d2\"}.ri-t-box-line:before{content:\"\\f1d3\"}.ri-t-shirt-2-fill:before{content:\"\\f1d4\"}.ri-t-shirt-2-line:before{content:\"\\f1d5\"}.ri-t-shirt-air-fill:before{content:\"\\f1d6\"}.ri-t-shirt-air-line:before{content:\"\\f1d7\"}.ri-t-shirt-fill:before{content:\"\\f1d8\"}.ri-t-shirt-line:before{content:\"\\f1d9\"}.ri-table-2:before{content:\"\\f1da\"}.ri-table-alt-fill:before{content:\"\\f1db\"}.ri-table-alt-line:before{content:\"\\f1dc\"}.ri-table-fill:before{content:\"\\f1dd\"}.ri-table-line:before{content:\"\\f1de\"}.ri-tablet-fill:before{content:\"\\f1df\"}.ri-tablet-line:before{content:\"\\f1e0\"}.ri-takeaway-fill:before{content:\"\\f1e1\"}.ri-takeaway-line:before{content:\"\\f1e2\"}.ri-taobao-fill:before{content:\"\\f1e3\"}.ri-taobao-line:before{content:\"\\f1e4\"}.ri-tape-fill:before{content:\"\\f1e5\"}.ri-tape-line:before{content:\"\\f1e6\"}.ri-task-fill:before{content:\"\\f1e7\"}.ri-task-line:before{content:\"\\f1e8\"}.ri-taxi-fill:before{content:\"\\f1e9\"}.ri-taxi-line:before{content:\"\\f1ea\"}.ri-taxi-wifi-fill:before{content:\"\\f1eb\"}.ri-taxi-wifi-line:before{content:\"\\f1ec\"}.ri-team-fill:before{content:\"\\f1ed\"}.ri-team-line:before{content:\"\\f1ee\"}.ri-telegram-fill:before{content:\"\\f1ef\"}.ri-telegram-line:before{content:\"\\f1f0\"}.ri-temp-cold-fill:before{content:\"\\f1f1\"}.ri-temp-cold-line:before{content:\"\\f1f2\"}.ri-temp-hot-fill:before{content:\"\\f1f3\"}.ri-temp-hot-line:before{content:\"\\f1f4\"}.ri-terminal-box-fill:before{content:\"\\f1f5\"}.ri-terminal-box-line:before{content:\"\\f1f6\"}.ri-terminal-fill:before{content:\"\\f1f7\"}.ri-terminal-line:before{content:\"\\f1f8\"}.ri-terminal-window-fill:before{content:\"\\f1f9\"}.ri-terminal-window-line:before{content:\"\\f1fa\"}.ri-test-tube-fill:before{content:\"\\f1fb\"}.ri-test-tube-line:before{content:\"\\f1fc\"}.ri-text-direction-l:before{content:\"\\f1fd\"}.ri-text-direction-r:before{content:\"\\f1fe\"}.ri-text-spacing:before{content:\"\\f1ff\"}.ri-text-wrap:before{content:\"\\f200\"}.ri-text:before{content:\"\\f201\"}.ri-thermometer-fill:before{content:\"\\f202\"}.ri-thermometer-line:before{content:\"\\f203\"}.ri-thumb-down-fill:before{content:\"\\f204\"}.ri-thumb-down-line:before{content:\"\\f205\"}.ri-thumb-up-fill:before{content:\"\\f206\"}.ri-thumb-up-line:before{content:\"\\f207\"}.ri-thunderstorms-fill:before{content:\"\\f208\"}.ri-thunderstorms-line:before{content:\"\\f209\"}.ri-ticket-2-fill:before{content:\"\\f20a\"}.ri-ticket-2-line:before{content:\"\\f20b\"}.ri-ticket-fill:before{content:\"\\f20c\"}.ri-ticket-line:before{content:\"\\f20d\"}.ri-time-fill:before{content:\"\\f20e\"}.ri-time-line:before{content:\"\\f20f\"}.ri-timer-2-fill:before{content:\"\\f210\"}.ri-timer-2-line:before{content:\"\\f211\"}.ri-timer-fill:before{content:\"\\f212\"}.ri-timer-flash-fill:before{content:\"\\f213\"}.ri-timer-flash-line:before{content:\"\\f214\"}.ri-timer-line:before{content:\"\\f215\"}.ri-todo-fill:before{content:\"\\f216\"}.ri-todo-line:before{content:\"\\f217\"}.ri-toggle-fill:before{content:\"\\f218\"}.ri-toggle-line:before{content:\"\\f219\"}.ri-tools-fill:before{content:\"\\f21a\"}.ri-tools-line:before{content:\"\\f21b\"}.ri-tornado-fill:before{content:\"\\f21c\"}.ri-tornado-line:before{content:\"\\f21d\"}.ri-trademark-fill:before{content:\"\\f21e\"}.ri-trademark-line:before{content:\"\\f21f\"}.ri-traffic-light-fill:before{content:\"\\f220\"}.ri-traffic-light-line:before{content:\"\\f221\"}.ri-train-fill:before{content:\"\\f222\"}.ri-train-line:before{content:\"\\f223\"}.ri-train-wifi-fill:before{content:\"\\f224\"}.ri-train-wifi-line:before{content:\"\\f225\"}.ri-translate-2:before{content:\"\\f226\"}.ri-translate:before{content:\"\\f227\"}.ri-travesti-fill:before{content:\"\\f228\"}.ri-travesti-line:before{content:\"\\f229\"}.ri-treasure-map-fill:before{content:\"\\f22a\"}.ri-treasure-map-line:before{content:\"\\f22b\"}.ri-trello-fill:before{content:\"\\f22c\"}.ri-trello-line:before{content:\"\\f22d\"}.ri-trophy-fill:before{content:\"\\f22e\"}.ri-trophy-line:before{content:\"\\f22f\"}.ri-truck-fill:before{content:\"\\f230\"}.ri-truck-line:before{content:\"\\f231\"}.ri-tumblr-fill:before{content:\"\\f232\"}.ri-tumblr-line:before{content:\"\\f233\"}.ri-tv-2-fill:before{content:\"\\f234\"}.ri-tv-2-line:before{content:\"\\f235\"}.ri-tv-fill:before{content:\"\\f236\"}.ri-tv-line:before{content:\"\\f237\"}.ri-twitch-fill:before{content:\"\\f238\"}.ri-twitch-line:before{content:\"\\f239\"}.ri-twitter-fill:before{content:\"\\f23a\"}.ri-twitter-line:before{content:\"\\f23b\"}.ri-typhoon-fill:before{content:\"\\f23c\"}.ri-typhoon-line:before{content:\"\\f23d\"}.ri-u-disk-fill:before{content:\"\\f23e\"}.ri-u-disk-line:before{content:\"\\f23f\"}.ri-ubuntu-fill:before{content:\"\\f240\"}.ri-ubuntu-line:before{content:\"\\f241\"}.ri-umbrella-fill:before{content:\"\\f242\"}.ri-umbrella-line:before{content:\"\\f243\"}.ri-underline:before{content:\"\\f244\"}.ri-uninstall-fill:before{content:\"\\f245\"}.ri-uninstall-line:before{content:\"\\f246\"}.ri-unsplash-fill:before{content:\"\\f247\"}.ri-unsplash-line:before{content:\"\\f248\"}.ri-upload-2-fill:before{content:\"\\f249\"}.ri-upload-2-line:before{content:\"\\f24a\"}.ri-upload-cloud-2-fill:before{content:\"\\f24b\"}.ri-upload-cloud-2-line:before{content:\"\\f24c\"}.ri-upload-cloud-fill:before{content:\"\\f24d\"}.ri-upload-cloud-line:before{content:\"\\f24e\"}.ri-upload-fill:before{content:\"\\f24f\"}.ri-upload-line:before{content:\"\\f250\"}.ri-usb-fill:before{content:\"\\f251\"}.ri-usb-line:before{content:\"\\f252\"}.ri-user-2-fill:before{content:\"\\f253\"}.ri-user-2-line:before{content:\"\\f254\"}.ri-user-3-fill:before{content:\"\\f255\"}.ri-user-3-line:before{content:\"\\f256\"}.ri-user-4-fill:before{content:\"\\f257\"}.ri-user-4-line:before{content:\"\\f258\"}.ri-user-5-fill:before{content:\"\\f259\"}.ri-user-5-line:before{content:\"\\f25a\"}.ri-user-6-fill:before{content:\"\\f25b\"}.ri-user-6-line:before{content:\"\\f25c\"}.ri-user-add-fill:before{content:\"\\f25d\"}.ri-user-add-line:before{content:\"\\f25e\"}.ri-user-fill:before{content:\"\\f25f\"}.ri-user-follow-fill:before{content:\"\\f260\"}.ri-user-follow-line:before{content:\"\\f261\"}.ri-user-heart-fill:before{content:\"\\f262\"}.ri-user-heart-line:before{content:\"\\f263\"}.ri-user-line:before{content:\"\\f264\"}.ri-user-location-fill:before{content:\"\\f265\"}.ri-user-location-line:before{content:\"\\f266\"}.ri-user-received-2-fill:before{content:\"\\f267\"}.ri-user-received-2-line:before{content:\"\\f268\"}.ri-user-received-fill:before{content:\"\\f269\"}.ri-user-received-line:before{content:\"\\f26a\"}.ri-user-search-fill:before{content:\"\\f26b\"}.ri-user-search-line:before{content:\"\\f26c\"}.ri-user-settings-fill:before{content:\"\\f26d\"}.ri-user-settings-line:before{content:\"\\f26e\"}.ri-user-shared-2-fill:before{content:\"\\f26f\"}.ri-user-shared-2-line:before{content:\"\\f270\"}.ri-user-shared-fill:before{content:\"\\f271\"}.ri-user-shared-line:before{content:\"\\f272\"}.ri-user-smile-fill:before{content:\"\\f273\"}.ri-user-smile-line:before{content:\"\\f274\"}.ri-user-star-fill:before{content:\"\\f275\"}.ri-user-star-line:before{content:\"\\f276\"}.ri-user-unfollow-fill:before{content:\"\\f277\"}.ri-user-unfollow-line:before{content:\"\\f278\"}.ri-user-voice-fill:before{content:\"\\f279\"}.ri-user-voice-line:before{content:\"\\f27a\"}.ri-video-add-fill:before{content:\"\\f27b\"}.ri-video-add-line:before{content:\"\\f27c\"}.ri-video-chat-fill:before{content:\"\\f27d\"}.ri-video-chat-line:before{content:\"\\f27e\"}.ri-video-download-fill:before{content:\"\\f27f\"}.ri-video-download-line:before{content:\"\\f280\"}.ri-video-fill:before{content:\"\\f281\"}.ri-video-line:before{content:\"\\f282\"}.ri-video-upload-fill:before{content:\"\\f283\"}.ri-video-upload-line:before{content:\"\\f284\"}.ri-vidicon-2-fill:before{content:\"\\f285\"}.ri-vidicon-2-line:before{content:\"\\f286\"}.ri-vidicon-fill:before{content:\"\\f287\"}.ri-vidicon-line:before{content:\"\\f288\"}.ri-vimeo-fill:before{content:\"\\f289\"}.ri-vimeo-line:before{content:\"\\f28a\"}.ri-vip-crown-2-fill:before{content:\"\\f28b\"}.ri-vip-crown-2-line:before{content:\"\\f28c\"}.ri-vip-crown-fill:before{content:\"\\f28d\"}.ri-vip-crown-line:before{content:\"\\f28e\"}.ri-vip-diamond-fill:before{content:\"\\f28f\"}.ri-vip-diamond-line:before{content:\"\\f290\"}.ri-vip-fill:before{content:\"\\f291\"}.ri-vip-line:before{content:\"\\f292\"}.ri-virus-fill:before{content:\"\\f293\"}.ri-virus-line:before{content:\"\\f294\"}.ri-visa-fill:before{content:\"\\f295\"}.ri-visa-line:before{content:\"\\f296\"}.ri-voice-recognition-fill:before{content:\"\\f297\"}.ri-voice-recognition-line:before{content:\"\\f298\"}.ri-voiceprint-fill:before{content:\"\\f299\"}.ri-voiceprint-line:before{content:\"\\f29a\"}.ri-volume-down-fill:before{content:\"\\f29b\"}.ri-volume-down-line:before{content:\"\\f29c\"}.ri-volume-mute-fill:before{content:\"\\f29d\"}.ri-volume-mute-line:before{content:\"\\f29e\"}.ri-volume-off-vibrate-fill:before{content:\"\\f29f\"}.ri-volume-off-vibrate-line:before{content:\"\\f2a0\"}.ri-volume-up-fill:before{content:\"\\f2a1\"}.ri-volume-up-line:before{content:\"\\f2a2\"}.ri-volume-vibrate-fill:before{content:\"\\f2a3\"}.ri-volume-vibrate-line:before{content:\"\\f2a4\"}.ri-vuejs-fill:before{content:\"\\f2a5\"}.ri-vuejs-line:before{content:\"\\f2a6\"}.ri-walk-fill:before{content:\"\\f2a7\"}.ri-walk-line:before{content:\"\\f2a8\"}.ri-wallet-2-fill:before{content:\"\\f2a9\"}.ri-wallet-2-line:before{content:\"\\f2aa\"}.ri-wallet-3-fill:before{content:\"\\f2ab\"}.ri-wallet-3-line:before{content:\"\\f2ac\"}.ri-wallet-fill:before{content:\"\\f2ad\"}.ri-wallet-line:before{content:\"\\f2ae\"}.ri-water-flash-fill:before{content:\"\\f2af\"}.ri-water-flash-line:before{content:\"\\f2b0\"}.ri-webcam-fill:before{content:\"\\f2b1\"}.ri-webcam-line:before{content:\"\\f2b2\"}.ri-wechat-2-fill:before{content:\"\\f2b3\"}.ri-wechat-2-line:before{content:\"\\f2b4\"}.ri-wechat-fill:before{content:\"\\f2b5\"}.ri-wechat-line:before{content:\"\\f2b6\"}.ri-wechat-pay-fill:before{content:\"\\f2b7\"}.ri-wechat-pay-line:before{content:\"\\f2b8\"}.ri-weibo-fill:before{content:\"\\f2b9\"}.ri-weibo-line:before{content:\"\\f2ba\"}.ri-whatsapp-fill:before{content:\"\\f2bb\"}.ri-whatsapp-line:before{content:\"\\f2bc\"}.ri-wheelchair-fill:before{content:\"\\f2bd\"}.ri-wheelchair-line:before{content:\"\\f2be\"}.ri-wifi-fill:before{content:\"\\f2bf\"}.ri-wifi-line:before{content:\"\\f2c0\"}.ri-wifi-off-fill:before{content:\"\\f2c1\"}.ri-wifi-off-line:before{content:\"\\f2c2\"}.ri-window-2-fill:before{content:\"\\f2c3\"}.ri-window-2-line:before{content:\"\\f2c4\"}.ri-window-fill:before{content:\"\\f2c5\"}.ri-window-line:before{content:\"\\f2c6\"}.ri-windows-fill:before{content:\"\\f2c7\"}.ri-windows-line:before{content:\"\\f2c8\"}.ri-windy-fill:before{content:\"\\f2c9\"}.ri-windy-line:before{content:\"\\f2ca\"}.ri-wireless-charging-fill:before{content:\"\\f2cb\"}.ri-wireless-charging-line:before{content:\"\\f2cc\"}.ri-women-fill:before{content:\"\\f2cd\"}.ri-women-line:before{content:\"\\f2ce\"}.ri-wubi-input:before{content:\"\\f2cf\"}.ri-xbox-fill:before{content:\"\\f2d0\"}.ri-xbox-line:before{content:\"\\f2d1\"}.ri-xing-fill:before{content:\"\\f2d2\"}.ri-xing-line:before{content:\"\\f2d3\"}.ri-youtube-fill:before{content:\"\\f2d4\"}.ri-youtube-line:before{content:\"\\f2d5\"}.ri-zcool-fill:before{content:\"\\f2d6\"}.ri-zcool-line:before{content:\"\\f2d7\"}.ri-zhihu-fill:before{content:\"\\f2d8\"}.ri-zhihu-line:before{content:\"\\f2d9\"}.ri-zoom-in-fill:before{content:\"\\f2da\"}.ri-zoom-in-line:before{content:\"\\f2db\"}.ri-zoom-out-fill:before{content:\"\\f2dc\"}.ri-zoom-out-line:before{content:\"\\f2dd\"}.ri-zzz-fill:before{content:\"\\f2de\"}.ri-zzz-line:before{content:\"\\f2df\"}.ri-lg,.ri-xl{line-height:unset;vertical-align:unset}:host([data-mode-centered]) .container{font-size:inherit;display:flex;justify-content:center;align-items:center}:host([data-mode-inline]){font-size:inherit}:host([data-mode-inline]) [class^=ri-]{vertical-align:middle}";

    const CpIcon$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        /**
         * Determines if the icon is centered or inline
         */
        this.mode = IconMode.Inline;
        /**
         * Determins the icon size. Sizes based on the Remix Icon library.
         */
        this.size = IconSize.inherit;
      }
      /**
       * Helper function to get the icon size.
       * @returns IconSize
       */
      getSize() {
        if (IconSize[this.size]) {
          return IconSize[this.size];
        }
        return this.size;
      }
      /**
       * Stencil lifecycle method.
       */
      componentWillLoad() {
        this.reuseExternalStylesheet();
        this.iconDirection();
      }
      /**
       * This component relies on the Remix Icon font, and we have decided that that dependency
       * should be handled externally because icons are needed in many places and we may not always
       * want to employ this web component to use them.
       *
       * Additionally, @font-face definitions don't currently function when defined within web
       * components without dynamically adding the link tag to the <head> via JavaScript, so
       * cloning an existing tag is the best solution available to us at this time.
       *
       * https://bugs.chromium.org/p/chromium/issues/detail?id=336876
       * https://github.com/ionic-team/stencil/issues/2072#issuecomment-588465875
       * https://github.com/ionic-team/stencil/issues/1875#issuecomment-602720766
       * https://stackoverflow.com/questions/60504404/how-to-use-material-design-icons-in-a-web-component
       */
      reuseExternalStylesheet() {
        var _a;
        const externalStylesheet = document.getElementById("custom-fonts-stylesheet");
        if (externalStylesheet) {
          (_a = this.el.shadowRoot) === null || _a === void 0 ? void 0 : _a.appendChild(externalStylesheet.cloneNode());
          return;
        }
        console.warn("cp-icon: Failed to find the link tag with ID 'custom-fonts-stylesheet'");
      }
      /**
       * Returns the `name` property, altered to suit LTR/RTL as appropriate.
       */
      iconDirection() {
        const pageDir = document.dir;
        if (pageDir === "rtl") {
          if (this.name.includes("right")) {
            return this.name.replace("right", "left");
          }
          if (this.name.includes("left")) {
            return this.name.replace("left", "right");
          }
        }
        return this.name;
      }
      /**
       * Mark up for a centered icon.
       * @returns DOM element
       */
      centeredMarkup() {
        return (h(Host, { "data-mode-centered": true }, h("cp-dir", null, h("div", { class: "container" }, h("i", { class: `ri-${this.iconDirection()} ${this.getSize()}` })))));
      }
      /**
       * Mark up for an inline icon.
       * @returns DOM element
       */
      inlineMarkup() {
        return (h(Host, { "data-mode-inline": true }, h("cp-dir", null, h("i", { class: `ri-${this.iconDirection()} ${this.getSize()}` }))));
      }
      render() {
        return this.mode === IconMode.Centered ? this.centeredMarkup() : this.inlineMarkup();
      }
      get el() { return this; }
      static get style() { return cpIconCss; }
    };

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    /**
     * *DO NOT USE THIS* unless for some reason @cpanel/api doesn’t work for you.
     *
     * Returns the base-url for a cPanel API call.
     */
    function buildRequestURL(securityToken, api) {
      return `${securityToken}/json-api/${api}`;
    }

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    /**
     * A single load average data point.
     */
    class LoadAverages {
      /**
       * Type safe class for the load average data.
       *
       * @param data - The load average data to plug into the class.
       */
      constructor(data) {
        this.fifteen = +data.fifteen;
        this.five = +data.five;
        this.one = +data.one;
      }
    }

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    let abortController;
    function abort() {
      if (abortController) {
        abortController.abort();
        abortController = undefined;
      }
    }
    /**
     * Fetches a sample of the one, five, and fifteen minute server load averages.
     *
     * @param securityToken The current session token.
     * @returns The latest linux load average sample via an api call back to the server.
     */
    function get(securityToken) {
      const url = buildRequestURL(securityToken, "loadavg");
      abortController = new AbortController();
      return fetch(url, {
        method: "GET",
        cache: "no-cache",
        signal: abortController.signal,
      })
        .then(resp => {
        return resp.json();
      })
        .then(data => {
        if (data.cpanelresult && data.cpanelresult.error) {
          throw data.cpanelresult.error;
        }
        return new LoadAverages(data);
      });
    }

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    const refreshInterval = 5000; // 5 sec
    var UpdateType;
    (function (UpdateType) {
      UpdateType[UpdateType["Start"] = 0] = "Start";
      UpdateType[UpdateType["Sample"] = 1] = "Sample";
      UpdateType[UpdateType["Error"] = 2] = "Error";
    })(UpdateType || (UpdateType = {}));
    class LoadAverageSamplerController {
      /**
       * Report an error event.
       *
       * @param error - the error returned by the fetch.
       */
      reportError(error) {
        const errorEvent = new CustomEvent("samplingError", { detail: error });
        window.dispatchEvent(errorEvent);
        return;
      }
      /**
       * Trigger the updateSample event with the next data point.
       *
       * @param sample The sample just retrieved.
       */
      reportUpdate(type, sample) {
        // Use native events since the stencil wrappers can
        // only be used with @Components.
        switch (type) {
          case UpdateType.Start:
            const startEvent = new CustomEvent("startSampling");
            window.dispatchEvent(startEvent);
            return;
          case UpdateType.Sample:
            const sampleEvent = new CustomEvent("updateSample", { detail: sample });
            window.dispatchEvent(sampleEvent);
            return;
        }
      }
      /**
       * Start the load average updater.
       */
      start() {
        const session = state.directoryPrefix;
        if (this.intervalHandle) {
          return; // its already running.
        }
        // we only want to sample if the ui is visible to preserve
        // server cycles for other more important work.
        document.addEventListener("visibilitychange", () => {
          if (document.visibilityState === "hidden") {
            this.stop();
          }
          else {
            this.start();
          }
        }, false);
        this.reportUpdate(UpdateType.Start);
        // Get the first one now
        get(session)
          .then(sample => {
          if (sample) {
            this.reportUpdate(UpdateType.Sample, sample);
          }
        })
          .catch(error => {
          this.reportError(error);
        });
        // And set up a periodic polling
        // function to keep it up to date.
        this.intervalHandle = setInterval(() => {
          get(session)
            .then(sample => {
            if (sample) {
              this.reportUpdate(UpdateType.Sample, sample);
            }
          })
            .catch(error => {
            this.reportError(error);
          });
        }, refreshInterval);
      }
      /**
       * Stop the retrieval of load average data.
       */
      stop() {
        if (!this.intervalHandle) {
          return; // Nothing to stop.
        }
        // Stop the polling
        if (this.intervalHandle) {
          clearInterval(this.intervalHandle);
          this.intervalHandle = null;
        }
        // Cancel any intransit requests
        abort();
      }
    }
    const LoadAverageSampler = new LoadAverageSamplerController();

    const cpLoadAveragesCss = ".stats-table th,.stats-table td{padding:0 var(--cp-spacer-1)}[dir=\"ltr\"] .stats-table th,[dir=\"ltr\"] .stats-table td{text-align:right}[dir=\"rtl\"] .stats-table th,[dir=\"rtl\"] .stats-table td{text-align:left}.stats-table th{font-weight:400}.stats-table td{font-weight:300}[dir=\"ltr\"] .stats-table td:last-child{padding-right:0}[dir=\"rtl\"] .stats-table td:last-child{padding-left:0}.stats-table.inverse td{font-weight:400}.stats-table .border-up,.stats-table .border-down,.stats-table .border-idle{border-radius:50%;background:var(--cp-header-bg, #fff);position:relative;top:2px;font-size:1rem;line-height:var(--cp-spacer-4)}.stats-table .nan{display:inline-block;padding-left:var(--cp-spacer-1);padding-right:var(--cp-spacer-1)}";

    const locale$q = getLocaleInstance();
    var Trend;
    (function (Trend) {
      Trend[Trend["Unknown"] = 0] = "Unknown";
      Trend[Trend["Idle"] = 1] = "Idle";
      Trend[Trend["Up"] = 2] = "Up";
      Trend[Trend["Down"] = 3] = "Down";
      Trend[Trend["SettlingFromTransientPeak"] = 4] = "SettlingFromTransientPeak";
      Trend[Trend["SettlingFromTransientLow"] = 5] = "SettlingFromTransientLow";
    })(Trend || (Trend = {}));
    const CpLoadAverages$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        /**
         * Inverts the font color scheme for high contrast on dark backgrounds.
         */
        this.inverse = false;
        /**
         * Show the header section of the control. Defaults to false.
         */
        this.showHeader = false;
        /**
         * Show the loading panel of the control when the control is intially loading. Defaults to false.
         */
        this.showLoading = false;
        /**
         * When `verbose` is true, the control renders the expanded control with the lable row, stat row and the trend row. When its false, the control renders in a single condensed stats row.
         */
        this.verbose = false;
        /**
         * True when the control is initially loading, false otherwise. When true if showLoading is also true, the loading row will show.
         */
        this.isLoading = true;
      }
      updateSampleHandler(event) {
        this.error = undefined;
        this.isLoading = false;
        this.last = this.current;
        this.current = event.detail;
      }
      samplingErrorHandler(event) {
        this.isLoading = false;
        this.error = event.detail;
      }
      startSamplingHandler() {
        this.error = undefined;
        this.isLoading = true;
      }
      /**
       * This component relies on the Remix Icon font, and we have decided that that dependency
       * should be handled externally because icons are needed in many places and we may not always
       * want to employ this web component to use them.
       *
       * Additionally, @font-face definitions don't currently function when defined within web
       * components without dynamically adding the link tag to the <head> via JavaScript, so
       * cloning an existing tag is the best solution available to us at this time.
       *
       * https://bugs.chromium.org/p/chromium/issues/detail?id=336876
       * https://github.com/ionic-team/stencil/issues/2072#issuecomment-588465875
       * https://github.com/ionic-team/stencil/issues/1875#issuecomment-602720766
       * https://stackoverflow.com/questions/60504404/how-to-use-material-design-icons-in-a-web-component
       */
      reuseExternalStylesheet() {
        var _a;
        const externalStylesheet = document.getElementById("custom-fonts-stylesheet");
        if (externalStylesheet) {
          (_a = this.host.shadowRoot) === null || _a === void 0 ? void 0 : _a.appendChild(externalStylesheet.cloneNode());
          return;
        }
        console.warn("cp-load-averages: Failed to find the link tag with ID 'custom-fonts-stylesheet'");
      }
      /**
       * Conditionally render the loading panel.
       */
      renderLoadingRow() {
        if (this.showLoading && this.isLoading) {
          return (h("tr", null, h("td", { colSpan: 3, class: "lavg_loading", id: `${this.host.id}-ldavg-loading` }, locale$q.maketext("Loading…"))));
        }
      }
      /**
       * Conditionally render the header.
       */
      renderHeaderRow() {
        if (this.showHeader && !this.error) {
          return (h("tr", null, h("th", null, "1 min"), h("th", null, "5 min"), h("th", null, "15 min")));
        }
      }
      /**
       * Generate a statistics output.
       *
       * @param number The number to output.
       */
      formatStat(number) {
        return this.error ? h("span", { class: "nan" }, "\u2015") : number.toFixed(2);
      }
      /**
       * Render the averages
       */
      renderAveragesRow() {
        if (this.current) {
          return (h("tr", null, !this.verbose && !this.error ? this.renderTrend() : "", h("td", { id: `${this.host.id}-one` }, this.formatStat(this.current.one)), h("td", { id: `${this.host.id}-five` }, this.formatStat(this.current.five)), h("td", { id: `${this.host.id}-fifteen` }, this.formatStat(this.current.fifteen))));
        }
      }
      /**
       * Calcualte what trend is present in the sample data.
       *
       * @param current The current sample if any.
       * @param last The previous sample if any.
       * @returns The observed trend.
       */
      calculateTrend(current, last) {
        if (!current || !last) {
          return Trend.Unknown;
        }
        if (current.one === 0.0) {
          return Trend.Idle;
        }
        else if (current.one > current.five || current.one > current.fifteen) {
          // Trending up
          if (current.one >= last.one) {
            return Trend.Up;
          }
          else {
            // but returning to the long term average
            return Trend.SettlingFromTransientPeak;
          }
        }
        else if (current.one < current.five || current.one < current.fifteen) {
          // Trending down
          if (current.one <= last.one) {
            return Trend.Down;
          }
          else {
            // but returning to the long term average
            return Trend.SettlingFromTransientLow;
          }
        }
        return Trend.Unknown;
      }
      /**
       * Lookup the message to describe the trend.
       *
       * @param trend The current observed trend in the sample data.
       * @returns The message.
       */
      trendMessage(trend) {
        switch (trend) {
          case Trend.Idle:
            return locale$q.maketext("System Idle[comment, This needs to stay as short as possible so it fits in the narrow panel without wrapping]");
          case Trend.Up:
            return locale$q.maketext("Load Trending Up[comment, This needs to stay as short as possible so it fits in the narrow panel without wrapping]");
          case Trend.Down:
            return locale$q.maketext("Load Trending Down[comment, This needs to stay as short as possible so it fits in the narrow panel without wrapping]");
          case Trend.SettlingFromTransientLow:
            return locale$q.maketext("Load Decline Settling[comment, This needs to stay as short as possible so it fits in the narrow panel without wrapping]");
          case Trend.SettlingFromTransientPeak:
            return locale$q.maketext("Load Spike Settling[comment, This needs to stay as short as possible so it fits in the narrow panel without wrapping]");
        }
        return "";
      }
      /**
       * Lookup the icon to visually represent the currently observed trend in the samples.
       *
       * @param trend The current observed trend in the sample data.
       * @returns The font icon name.
       */
      trendIcon(trend) {
        switch (trend) {
          case Trend.Up:
          case Trend.SettlingFromTransientPeak:
            return "ri-arrow-up-line text-danger";
          case Trend.Down:
          case Trend.SettlingFromTransientLow:
            return "ri-arrow-down-line text-info";
          case Trend.Idle:
            return "ri-rest-time-line text-info";
          default:
            return "";
        }
      }
      /**
       * Lookup the border class to make trend easier to see in inverse mode.
       *
       * @param trend The current observed trend in the sample data.
       * @returns The border class name.
       */
      trendIconBorder(trend) {
        switch (trend) {
          case Trend.Up:
          case Trend.SettlingFromTransientPeak:
            return " border-up";
          case Trend.Down:
          case Trend.SettlingFromTransientLow:
            return " border-down";
          case Trend.Idle:
            return " border-idle";
          default:
            return "";
        }
      }
      /**
       * Lookup the unique id for the currently observed trend. This is
       * primarily so QA can identify which trend is showing without depending
       * on the human readable strings.
       *
       * @param trend The current observed trend in the sample data.
       * @returns The message.
       */
      trendId(trend) {
        switch (trend) {
          case Trend.Up:
            return `${this.host.id}-increasing`;
          case Trend.Down:
            return `${this.host.id}-decreasing`;
          case Trend.SettlingFromTransientLow:
            return `${this.host.id}-settling_from_down`;
          case Trend.SettlingFromTransientPeak:
            return `${this.host.id}-settling_from_up`;
          case Trend.Idle:
            return `${this.host.id}-idle`;
          default:
            return "";
        }
      }
      /**
       * Render the trend row.
       */
      renderTrendRow() {
        if (this.verbose && !this.error) {
          let trend = this.calculateTrend(this.current, this.last);
          if (trend === Trend.Unknown) {
            return;
          }
          return h("tr", null, this.renderTrend(trend));
        }
      }
      /**
       * Render the trend.
       *
       * @param trend - the current trend. Will auto populate is not passed.
       */
      renderTrend(trend) {
        trend || (trend = this.calculateTrend(this.current, this.last));
        if (trend === Trend.Unknown) {
          return;
        }
        let message = this.trendMessage(trend);
        let attributes = {};
        if (!this.verbose) {
          attributes["title"] = message;
        }
        else {
          attributes["colSpan"] = 3;
        }
        return (h("td", Object.assign({}, attributes), h("span", { id: this.trendId(trend) }, h("i", { class: this.trendIcon(trend) + (this.inverse ? this.trendIconBorder(trend) : ""), "aria-hidden": "true" }), this.verbose ? this.trendMessage(trend) : "")));
      }
      /**
       * Lifecycle Hook: render
       * Render the component.
       */
      render() {
        return (h(Host, null, h("table", { class: this.inverse ? "stats-table inverse" : "stats-table" }, h("tbody", null, this.renderLoadingRow(), this.renderHeaderRow(), this.renderAveragesRow(), this.renderTrendRow()))));
      }
      /**
       * Lifecycle Hook: componentWillLoad
       * We load the font library before the component renders.
       */
      componentWillLoad() {
        this.reuseExternalStylesheet();
      }
      /**
       * Lifecycle Hook: componentDidRender
       * After the initial render, the trigger loading banner if applicable and start the Load Average sampling.
       */
      componentDidRender() {
        LoadAverageSampler.start();
      }
      get host() { return this; }
      static get style() { return cpLoadAveragesCss; }
    };

    var Config = {
        DEBUG: false,
        LIB_VERSION: '2.49.0'
    };

    // since es6 imports are static and we run unit tests from the console, window won't be defined when importing this file
    var window$1;
    if (typeof(window) === 'undefined') {
        var loc = {
            hostname: ''
        };
        window$1 = {
            navigator: { userAgent: '' },
            document: {
                location: loc,
                referrer: ''
            },
            screen: { width: 0, height: 0 },
            location: loc
        };
    } else {
        window$1 = window;
    }

    /*
     * Saved references to long variable names, so that closure compiler can
     * minimize file size.
     */

    var ArrayProto = Array.prototype;
    var FuncProto = Function.prototype;
    var ObjProto = Object.prototype;
    var slice = ArrayProto.slice;
    var toString = ObjProto.toString;
    var hasOwnProperty = ObjProto.hasOwnProperty;
    var windowConsole = window$1.console;
    var navigator = window$1.navigator;
    var document$1 = window$1.document;
    var windowOpera = window$1.opera;
    var screen = window$1.screen;
    var userAgent = navigator.userAgent;
    var nativeBind = FuncProto.bind;
    var nativeForEach = ArrayProto.forEach;
    var nativeIndexOf = ArrayProto.indexOf;
    var nativeMap = ArrayProto.map;
    var nativeIsArray = Array.isArray;
    var breaker = {};
    var _ = {
        trim: function(str) {
            // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/Trim#Polyfill
            return str.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
        }
    };

    // Console override
    var console$1 = {
        /** @type {function(...*)} */
        log: function() {
            if (Config.DEBUG && !_.isUndefined(windowConsole) && windowConsole) {
                try {
                    windowConsole.log.apply(windowConsole, arguments);
                } catch (err) {
                    _.each(arguments, function(arg) {
                        windowConsole.log(arg);
                    });
                }
            }
        },
        /** @type {function(...*)} */
        warn: function() {
            if (Config.DEBUG && !_.isUndefined(windowConsole) && windowConsole) {
                var args = ['Mixpanel warning:'].concat(_.toArray(arguments));
                try {
                    windowConsole.warn.apply(windowConsole, args);
                } catch (err) {
                    _.each(args, function(arg) {
                        windowConsole.warn(arg);
                    });
                }
            }
        },
        /** @type {function(...*)} */
        error: function() {
            if (Config.DEBUG && !_.isUndefined(windowConsole) && windowConsole) {
                var args = ['Mixpanel error:'].concat(_.toArray(arguments));
                try {
                    windowConsole.error.apply(windowConsole, args);
                } catch (err) {
                    _.each(args, function(arg) {
                        windowConsole.error(arg);
                    });
                }
            }
        },
        /** @type {function(...*)} */
        critical: function() {
            if (!_.isUndefined(windowConsole) && windowConsole) {
                var args = ['Mixpanel error:'].concat(_.toArray(arguments));
                try {
                    windowConsole.error.apply(windowConsole, args);
                } catch (err) {
                    _.each(args, function(arg) {
                        windowConsole.error(arg);
                    });
                }
            }
        }
    };

    var log_func_with_prefix = function(func, prefix) {
        return function() {
            arguments[0] = '[' + prefix + '] ' + arguments[0];
            return func.apply(console$1, arguments);
        };
    };
    var console_with_prefix = function(prefix) {
        return {
            log: log_func_with_prefix(console$1.log, prefix),
            error: log_func_with_prefix(console$1.error, prefix),
            critical: log_func_with_prefix(console$1.critical, prefix)
        };
    };


    // UNDERSCORE
    // Embed part of the Underscore Library
    _.bind = function(func, context) {
        var args, bound;
        if (nativeBind && func.bind === nativeBind) {
            return nativeBind.apply(func, slice.call(arguments, 1));
        }
        if (!_.isFunction(func)) {
            throw new TypeError();
        }
        args = slice.call(arguments, 2);
        bound = function() {
            if (!(this instanceof bound)) {
                return func.apply(context, args.concat(slice.call(arguments)));
            }
            var ctor = {};
            ctor.prototype = func.prototype;
            var self = new ctor();
            ctor.prototype = null;
            var result = func.apply(self, args.concat(slice.call(arguments)));
            if (Object(result) === result) {
                return result;
            }
            return self;
        };
        return bound;
    };

    /**
     * @param {*=} obj
     * @param {function(...*)=} iterator
     * @param {Object=} context
     */
    _.each = function(obj, iterator, context) {
        if (obj === null || obj === undefined) {
            return;
        }
        if (nativeForEach && obj.forEach === nativeForEach) {
            obj.forEach(iterator, context);
        } else if (obj.length === +obj.length) {
            for (var i = 0, l = obj.length; i < l; i++) {
                if (i in obj && iterator.call(context, obj[i], i, obj) === breaker) {
                    return;
                }
            }
        } else {
            for (var key in obj) {
                if (hasOwnProperty.call(obj, key)) {
                    if (iterator.call(context, obj[key], key, obj) === breaker) {
                        return;
                    }
                }
            }
        }
    };

    _.extend = function(obj) {
        _.each(slice.call(arguments, 1), function(source) {
            for (var prop in source) {
                if (source[prop] !== void 0) {
                    obj[prop] = source[prop];
                }
            }
        });
        return obj;
    };

    _.isArray = nativeIsArray || function(obj) {
        return toString.call(obj) === '[object Array]';
    };

    // from a comment on http://dbj.org/dbj/?p=286
    // fails on only one very rare and deliberate custom object:
    // var bomb = { toString : undefined, valueOf: function(o) { return "function BOMBA!"; }};
    _.isFunction = function(f) {
        try {
            return /^\s*\bfunction\b/.test(f);
        } catch (x) {
            return false;
        }
    };

    _.isArguments = function(obj) {
        return !!(obj && hasOwnProperty.call(obj, 'callee'));
    };

    _.toArray = function(iterable) {
        if (!iterable) {
            return [];
        }
        if (iterable.toArray) {
            return iterable.toArray();
        }
        if (_.isArray(iterable)) {
            return slice.call(iterable);
        }
        if (_.isArguments(iterable)) {
            return slice.call(iterable);
        }
        return _.values(iterable);
    };

    _.map = function(arr, callback, context) {
        if (nativeMap && arr.map === nativeMap) {
            return arr.map(callback, context);
        } else {
            var results = [];
            _.each(arr, function(item) {
                results.push(callback.call(context, item));
            });
            return results;
        }
    };

    _.keys = function(obj) {
        var results = [];
        if (obj === null) {
            return results;
        }
        _.each(obj, function(value, key) {
            results[results.length] = key;
        });
        return results;
    };

    _.values = function(obj) {
        var results = [];
        if (obj === null) {
            return results;
        }
        _.each(obj, function(value) {
            results[results.length] = value;
        });
        return results;
    };

    _.include = function(obj, target) {
        var found = false;
        if (obj === null) {
            return found;
        }
        if (nativeIndexOf && obj.indexOf === nativeIndexOf) {
            return obj.indexOf(target) != -1;
        }
        _.each(obj, function(value) {
            if (found || (found = (value === target))) {
                return breaker;
            }
        });
        return found;
    };

    _.includes = function(str, needle) {
        return str.indexOf(needle) !== -1;
    };

    // Underscore Addons
    _.inherit = function(subclass, superclass) {
        subclass.prototype = new superclass();
        subclass.prototype.constructor = subclass;
        subclass.superclass = superclass.prototype;
        return subclass;
    };

    _.isObject = function(obj) {
        return (obj === Object(obj) && !_.isArray(obj));
    };

    _.isEmptyObject = function(obj) {
        if (_.isObject(obj)) {
            for (var key in obj) {
                if (hasOwnProperty.call(obj, key)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    };

    _.isUndefined = function(obj) {
        return obj === void 0;
    };

    _.isString = function(obj) {
        return toString.call(obj) == '[object String]';
    };

    _.isDate = function(obj) {
        return toString.call(obj) == '[object Date]';
    };

    _.isNumber = function(obj) {
        return toString.call(obj) == '[object Number]';
    };

    _.isElement = function(obj) {
        return !!(obj && obj.nodeType === 1);
    };

    _.encodeDates = function(obj) {
        _.each(obj, function(v, k) {
            if (_.isDate(v)) {
                obj[k] = _.formatDate(v);
            } else if (_.isObject(v)) {
                obj[k] = _.encodeDates(v); // recurse
            }
        });
        return obj;
    };

    _.timestamp = function() {
        Date.now = Date.now || function() {
            return +new Date;
        };
        return Date.now();
    };

    _.formatDate = function(d) {
        // YYYY-MM-DDTHH:MM:SS in UTC
        function pad(n) {
            return n < 10 ? '0' + n : n;
        }
        return d.getUTCFullYear() + '-' +
            pad(d.getUTCMonth() + 1) + '-' +
            pad(d.getUTCDate()) + 'T' +
            pad(d.getUTCHours()) + ':' +
            pad(d.getUTCMinutes()) + ':' +
            pad(d.getUTCSeconds());
    };

    _.strip_empty_properties = function(p) {
        var ret = {};
        _.each(p, function(v, k) {
            if (_.isString(v) && v.length > 0) {
                ret[k] = v;
            }
        });
        return ret;
    };

    /*
     * this function returns a copy of object after truncating it.  If
     * passed an Array or Object it will iterate through obj and
     * truncate all the values recursively.
     */
    _.truncate = function(obj, length) {
        var ret;

        if (typeof(obj) === 'string') {
            ret = obj.slice(0, length);
        } else if (_.isArray(obj)) {
            ret = [];
            _.each(obj, function(val) {
                ret.push(_.truncate(val, length));
            });
        } else if (_.isObject(obj)) {
            ret = {};
            _.each(obj, function(val, key) {
                ret[key] = _.truncate(val, length);
            });
        } else {
            ret = obj;
        }

        return ret;
    };

    _.JSONEncode = (function() {
        return function(mixed_val) {
            var value = mixed_val;
            var quote = function(string) {
                var escapable = /[\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g; // eslint-disable-line no-control-regex
                var meta = { // table of character substitutions
                    '\b': '\\b',
                    '\t': '\\t',
                    '\n': '\\n',
                    '\f': '\\f',
                    '\r': '\\r',
                    '"': '\\"',
                    '\\': '\\\\'
                };

                escapable.lastIndex = 0;
                return escapable.test(string) ?
                    '"' + string.replace(escapable, function(a) {
                        var c = meta[a];
                        return typeof c === 'string' ? c :
                            '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
                    }) + '"' :
                    '"' + string + '"';
            };

            var str = function(key, holder) {
                var gap = '';
                var indent = '    ';
                var i = 0; // The loop counter.
                var k = ''; // The member key.
                var v = ''; // The member value.
                var length = 0;
                var mind = gap;
                var partial = [];
                var value = holder[key];

                // If the value has a toJSON method, call it to obtain a replacement value.
                if (value && typeof value === 'object' &&
                    typeof value.toJSON === 'function') {
                    value = value.toJSON(key);
                }

                // What happens next depends on the value's type.
                switch (typeof value) {
                    case 'string':
                        return quote(value);

                    case 'number':
                        // JSON numbers must be finite. Encode non-finite numbers as null.
                        return isFinite(value) ? String(value) : 'null';

                    case 'boolean':
                    case 'null':
                        // If the value is a boolean or null, convert it to a string. Note:
                        // typeof null does not produce 'null'. The case is included here in
                        // the remote chance that this gets fixed someday.

                        return String(value);

                    case 'object':
                        // If the type is 'object', we might be dealing with an object or an array or
                        // null.
                        // Due to a specification blunder in ECMAScript, typeof null is 'object',
                        // so watch out for that case.
                        if (!value) {
                            return 'null';
                        }

                        // Make an array to hold the partial results of stringifying this object value.
                        gap += indent;
                        partial = [];

                        // Is the value an array?
                        if (toString.apply(value) === '[object Array]') {
                            // The value is an array. Stringify every element. Use null as a placeholder
                            // for non-JSON values.

                            length = value.length;
                            for (i = 0; i < length; i += 1) {
                                partial[i] = str(i, value) || 'null';
                            }

                            // Join all of the elements together, separated with commas, and wrap them in
                            // brackets.
                            v = partial.length === 0 ? '[]' :
                                gap ? '[\n' + gap +
                                partial.join(',\n' + gap) + '\n' +
                                mind + ']' :
                                    '[' + partial.join(',') + ']';
                            gap = mind;
                            return v;
                        }

                        // Iterate through all of the keys in the object.
                        for (k in value) {
                            if (hasOwnProperty.call(value, k)) {
                                v = str(k, value);
                                if (v) {
                                    partial.push(quote(k) + (gap ? ': ' : ':') + v);
                                }
                            }
                        }

                        // Join all of the member texts together, separated with commas,
                        // and wrap them in braces.
                        v = partial.length === 0 ? '{}' :
                            gap ? '{' + partial.join(',') + '' +
                            mind + '}' : '{' + partial.join(',') + '}';
                        gap = mind;
                        return v;
                }
            };

            // Make a fake root object containing our value under the key of ''.
            // Return the result of stringifying the value.
            return str('', {
                '': value
            });
        };
    })();

    /**
     * From https://github.com/douglascrockford/JSON-js/blob/master/json_parse.js
     * Slightly modified to throw a real Error rather than a POJO
     */
    _.JSONDecode = (function() {
        var at, // The index of the current character
            ch, // The current character
            escapee = {
                '"': '"',
                '\\': '\\',
                '/': '/',
                'b': '\b',
                'f': '\f',
                'n': '\n',
                'r': '\r',
                't': '\t'
            },
            text,
            error = function(m) {
                var e = new SyntaxError(m);
                e.at = at;
                e.text = text;
                throw e;
            },
            next = function(c) {
                // If a c parameter is provided, verify that it matches the current character.
                if (c && c !== ch) {
                    error('Expected \'' + c + '\' instead of \'' + ch + '\'');
                }
                // Get the next character. When there are no more characters,
                // return the empty string.
                ch = text.charAt(at);
                at += 1;
                return ch;
            },
            number = function() {
                // Parse a number value.
                var number,
                    string = '';

                if (ch === '-') {
                    string = '-';
                    next('-');
                }
                while (ch >= '0' && ch <= '9') {
                    string += ch;
                    next();
                }
                if (ch === '.') {
                    string += '.';
                    while (next() && ch >= '0' && ch <= '9') {
                        string += ch;
                    }
                }
                if (ch === 'e' || ch === 'E') {
                    string += ch;
                    next();
                    if (ch === '-' || ch === '+') {
                        string += ch;
                        next();
                    }
                    while (ch >= '0' && ch <= '9') {
                        string += ch;
                        next();
                    }
                }
                number = +string;
                if (!isFinite(number)) {
                    error('Bad number');
                } else {
                    return number;
                }
            },

            string = function() {
                // Parse a string value.
                var hex,
                    i,
                    string = '',
                    uffff;
                // When parsing for string values, we must look for " and \ characters.
                if (ch === '"') {
                    while (next()) {
                        if (ch === '"') {
                            next();
                            return string;
                        }
                        if (ch === '\\') {
                            next();
                            if (ch === 'u') {
                                uffff = 0;
                                for (i = 0; i < 4; i += 1) {
                                    hex = parseInt(next(), 16);
                                    if (!isFinite(hex)) {
                                        break;
                                    }
                                    uffff = uffff * 16 + hex;
                                }
                                string += String.fromCharCode(uffff);
                            } else if (typeof escapee[ch] === 'string') {
                                string += escapee[ch];
                            } else {
                                break;
                            }
                        } else {
                            string += ch;
                        }
                    }
                }
                error('Bad string');
            },
            white = function() {
                // Skip whitespace.
                while (ch && ch <= ' ') {
                    next();
                }
            },
            word = function() {
                // true, false, or null.
                switch (ch) {
                    case 't':
                        next('t');
                        next('r');
                        next('u');
                        next('e');
                        return true;
                    case 'f':
                        next('f');
                        next('a');
                        next('l');
                        next('s');
                        next('e');
                        return false;
                    case 'n':
                        next('n');
                        next('u');
                        next('l');
                        next('l');
                        return null;
                }
                error('Unexpected "' + ch + '"');
            },
            value, // Placeholder for the value function.
            array = function() {
                // Parse an array value.
                var array = [];

                if (ch === '[') {
                    next('[');
                    white();
                    if (ch === ']') {
                        next(']');
                        return array; // empty array
                    }
                    while (ch) {
                        array.push(value());
                        white();
                        if (ch === ']') {
                            next(']');
                            return array;
                        }
                        next(',');
                        white();
                    }
                }
                error('Bad array');
            },
            object = function() {
                // Parse an object value.
                var key,
                    object = {};

                if (ch === '{') {
                    next('{');
                    white();
                    if (ch === '}') {
                        next('}');
                        return object; // empty object
                    }
                    while (ch) {
                        key = string();
                        white();
                        next(':');
                        if (Object.hasOwnProperty.call(object, key)) {
                            error('Duplicate key "' + key + '"');
                        }
                        object[key] = value();
                        white();
                        if (ch === '}') {
                            next('}');
                            return object;
                        }
                        next(',');
                        white();
                    }
                }
                error('Bad object');
            };

        value = function() {
            // Parse a JSON value. It could be an object, an array, a string,
            // a number, or a word.
            white();
            switch (ch) {
                case '{':
                    return object();
                case '[':
                    return array();
                case '"':
                    return string();
                case '-':
                    return number();
                default:
                    return ch >= '0' && ch <= '9' ? number() : word();
            }
        };

        // Return the json_parse function. It will have access to all of the
        // above functions and variables.
        return function(source) {
            var result;

            text = source;
            at = 0;
            ch = ' ';
            result = value();
            white();
            if (ch) {
                error('Syntax error');
            }

            return result;
        };
    })();

    _.base64Encode = function(data) {
        var b64 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
        var o1, o2, o3, h1, h2, h3, h4, bits, i = 0,
            ac = 0,
            enc = '',
            tmp_arr = [];

        if (!data) {
            return data;
        }

        data = _.utf8Encode(data);

        do { // pack three octets into four hexets
            o1 = data.charCodeAt(i++);
            o2 = data.charCodeAt(i++);
            o3 = data.charCodeAt(i++);

            bits = o1 << 16 | o2 << 8 | o3;

            h1 = bits >> 18 & 0x3f;
            h2 = bits >> 12 & 0x3f;
            h3 = bits >> 6 & 0x3f;
            h4 = bits & 0x3f;

            // use hexets to index into b64, and append result to encoded string
            tmp_arr[ac++] = b64.charAt(h1) + b64.charAt(h2) + b64.charAt(h3) + b64.charAt(h4);
        } while (i < data.length);

        enc = tmp_arr.join('');

        switch (data.length % 3) {
            case 1:
                enc = enc.slice(0, -2) + '==';
                break;
            case 2:
                enc = enc.slice(0, -1) + '=';
                break;
        }

        return enc;
    };

    _.utf8Encode = function(string) {
        string = (string + '').replace(/\r\n/g, '\n').replace(/\r/g, '\n');

        var utftext = '',
            start,
            end;
        var stringl = 0,
            n;

        start = end = 0;
        stringl = string.length;

        for (n = 0; n < stringl; n++) {
            var c1 = string.charCodeAt(n);
            var enc = null;

            if (c1 < 128) {
                end++;
            } else if ((c1 > 127) && (c1 < 2048)) {
                enc = String.fromCharCode((c1 >> 6) | 192, (c1 & 63) | 128);
            } else {
                enc = String.fromCharCode((c1 >> 12) | 224, ((c1 >> 6) & 63) | 128, (c1 & 63) | 128);
            }
            if (enc !== null) {
                if (end > start) {
                    utftext += string.substring(start, end);
                }
                utftext += enc;
                start = end = n + 1;
            }
        }

        if (end > start) {
            utftext += string.substring(start, string.length);
        }

        return utftext;
    };

    _.UUID = (function() {

        // Time-based entropy
        var T = function() {
            var time = 1 * new Date(); // cross-browser version of Date.now()
            var ticks;
            if (window$1.performance && window$1.performance.now) {
                ticks = window$1.performance.now();
            } else {
                // fall back to busy loop
                ticks = 0;

                // this while loop figures how many browser ticks go by
                // before 1*new Date() returns a new number, ie the amount
                // of ticks that go by per millisecond
                while (time == 1 * new Date()) {
                    ticks++;
                }
            }
            return time.toString(16) + Math.floor(ticks).toString(16);
        };

        // Math.Random entropy
        var R = function() {
            return Math.random().toString(16).replace('.', '');
        };

        // User agent entropy
        // This function takes the user agent string, and then xors
        // together each sequence of 8 bytes.  This produces a final
        // sequence of 8 bytes which it returns as hex.
        var UA = function() {
            var ua = userAgent,
                i, ch, buffer = [],
                ret = 0;

            function xor(result, byte_array) {
                var j, tmp = 0;
                for (j = 0; j < byte_array.length; j++) {
                    tmp |= (buffer[j] << j * 8);
                }
                return result ^ tmp;
            }

            for (i = 0; i < ua.length; i++) {
                ch = ua.charCodeAt(i);
                buffer.unshift(ch & 0xFF);
                if (buffer.length >= 4) {
                    ret = xor(ret, buffer);
                    buffer = [];
                }
            }

            if (buffer.length > 0) {
                ret = xor(ret, buffer);
            }

            return ret.toString(16);
        };

        return function() {
            var se = (screen.height * screen.width).toString(16);
            return (T() + '-' + R() + '-' + UA() + '-' + se + '-' + T());
        };
    })();

    // _.isBlockedUA()
    // This is to block various web spiders from executing our JS and
    // sending false tracking data
    var BLOCKED_UA_STRS = [
        'ahrefsbot',
        'ahrefssiteaudit',
        'baiduspider',
        'bingbot',
        'bingpreview',
        'chrome-lighthouse',
        'facebookexternal',
        'petalbot',
        'pinterest',
        'screaming frog',
        'yahoo! slurp',
        'yandexbot',

        // a whole bunch of goog-specific crawlers
        // https://developers.google.com/search/docs/advanced/crawling/overview-google-crawlers
        'adsbot-google',
        'apis-google',
        'duplexweb-google',
        'feedfetcher-google',
        'google favicon',
        'google web preview',
        'google-read-aloud',
        'googlebot',
        'googleweblight',
        'mediapartners-google',
        'storebot-google'
    ];
    _.isBlockedUA = function(ua) {
        var i;
        ua = ua.toLowerCase();
        for (i = 0; i < BLOCKED_UA_STRS.length; i++) {
            if (ua.indexOf(BLOCKED_UA_STRS[i]) !== -1) {
                return true;
            }
        }
        return false;
    };

    /**
     * @param {Object=} formdata
     * @param {string=} arg_separator
     */
    _.HTTPBuildQuery = function(formdata, arg_separator) {
        var use_val, use_key, tmp_arr = [];

        if (_.isUndefined(arg_separator)) {
            arg_separator = '&';
        }

        _.each(formdata, function(val, key) {
            use_val = encodeURIComponent(val.toString());
            use_key = encodeURIComponent(key);
            tmp_arr[tmp_arr.length] = use_key + '=' + use_val;
        });

        return tmp_arr.join(arg_separator);
    };

    _.getQueryParam = function(url, param) {
        // Expects a raw URL

        param = param.replace(/[[]/, '\\[').replace(/[\]]/, '\\]');
        var regexS = '[\\?&]' + param + '=([^&#]*)',
            regex = new RegExp(regexS),
            results = regex.exec(url);
        if (results === null || (results && typeof(results[1]) !== 'string' && results[1].length)) {
            return '';
        } else {
            var result = results[1];
            try {
                result = decodeURIComponent(result);
            } catch(err) {
                console$1.error('Skipping decoding for malformed query param: ' + result);
            }
            return result.replace(/\+/g, ' ');
        }
    };


    // _.cookie
    // Methods partially borrowed from quirksmode.org/js/cookies.html
    _.cookie = {
        get: function(name) {
            var nameEQ = name + '=';
            var ca = document$1.cookie.split(';');
            for (var i = 0; i < ca.length; i++) {
                var c = ca[i];
                while (c.charAt(0) == ' ') {
                    c = c.substring(1, c.length);
                }
                if (c.indexOf(nameEQ) === 0) {
                    return decodeURIComponent(c.substring(nameEQ.length, c.length));
                }
            }
            return null;
        },

        parse: function(name) {
            var cookie;
            try {
                cookie = _.JSONDecode(_.cookie.get(name)) || {};
            } catch (err) {
                // noop
            }
            return cookie;
        },

        set_seconds: function(name, value, seconds, is_cross_subdomain, is_secure, is_cross_site, domain_override) {
            var cdomain = '',
                expires = '',
                secure = '';

            if (domain_override) {
                cdomain = '; domain=' + domain_override;
            } else if (is_cross_subdomain) {
                var domain = extract_domain(document$1.location.hostname);
                cdomain = domain ? '; domain=.' + domain : '';
            }

            if (seconds) {
                var date = new Date();
                date.setTime(date.getTime() + (seconds * 1000));
                expires = '; expires=' + date.toGMTString();
            }

            if (is_cross_site) {
                is_secure = true;
                secure = '; SameSite=None';
            }
            if (is_secure) {
                secure += '; secure';
            }

            document$1.cookie = name + '=' + encodeURIComponent(value) + expires + '; path=/' + cdomain + secure;
        },

        set: function(name, value, days, is_cross_subdomain, is_secure, is_cross_site, domain_override) {
            var cdomain = '', expires = '', secure = '';

            if (domain_override) {
                cdomain = '; domain=' + domain_override;
            } else if (is_cross_subdomain) {
                var domain = extract_domain(document$1.location.hostname);
                cdomain = domain ? '; domain=.' + domain : '';
            }

            if (days) {
                var date = new Date();
                date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
                expires = '; expires=' + date.toGMTString();
            }

            if (is_cross_site) {
                is_secure = true;
                secure = '; SameSite=None';
            }
            if (is_secure) {
                secure += '; secure';
            }

            var new_cookie_val = name + '=' + encodeURIComponent(value) + expires + '; path=/' + cdomain + secure;
            document$1.cookie = new_cookie_val;
            return new_cookie_val;
        },

        remove: function(name, is_cross_subdomain, domain_override) {
            _.cookie.set(name, '', -1, is_cross_subdomain, false, false, domain_override);
        }
    };

    var _localStorageSupported = null;
    var localStorageSupported = function(storage, forceCheck) {
        if (_localStorageSupported !== null && !forceCheck) {
            return _localStorageSupported;
        }

        var supported = true;
        try {
            storage = storage || window.localStorage;
            var key = '__mplss_' + cheap_guid(8),
                val = 'xyz';
            storage.setItem(key, val);
            if (storage.getItem(key) !== val) {
                supported = false;
            }
            storage.removeItem(key);
        } catch (err) {
            supported = false;
        }

        _localStorageSupported = supported;
        return supported;
    };

    // _.localStorage
    _.localStorage = {
        is_supported: function(force_check) {
            var supported = localStorageSupported(null, force_check);
            if (!supported) {
                console$1.error('localStorage unsupported; falling back to cookie store');
            }
            return supported;
        },

        error: function(msg) {
            console$1.error('localStorage error: ' + msg);
        },

        get: function(name) {
            try {
                return window.localStorage.getItem(name);
            } catch (err) {
                _.localStorage.error(err);
            }
            return null;
        },

        parse: function(name) {
            try {
                return _.JSONDecode(_.localStorage.get(name)) || {};
            } catch (err) {
                // noop
            }
            return null;
        },

        set: function(name, value) {
            try {
                window.localStorage.setItem(name, value);
            } catch (err) {
                _.localStorage.error(err);
            }
        },

        remove: function(name) {
            try {
                window.localStorage.removeItem(name);
            } catch (err) {
                _.localStorage.error(err);
            }
        }
    };

    _.register_event = (function() {
        // written by Dean Edwards, 2005
        // with input from Tino Zijdel - crisp@xs4all.nl
        // with input from Carl Sverre - mail@carlsverre.com
        // with input from Mixpanel
        // http://dean.edwards.name/weblog/2005/10/add-event/
        // https://gist.github.com/1930440

        /**
         * @param {Object} element
         * @param {string} type
         * @param {function(...*)} handler
         * @param {boolean=} oldSchool
         * @param {boolean=} useCapture
         */
        var register_event = function(element, type, handler, oldSchool, useCapture) {
            if (!element) {
                console$1.error('No valid element provided to register_event');
                return;
            }

            if (element.addEventListener && !oldSchool) {
                element.addEventListener(type, handler, !!useCapture);
            } else {
                var ontype = 'on' + type;
                var old_handler = element[ontype]; // can be undefined
                element[ontype] = makeHandler(element, handler, old_handler);
            }
        };

        function makeHandler(element, new_handler, old_handlers) {
            var handler = function(event) {
                event = event || fixEvent(window.event);

                // this basically happens in firefox whenever another script
                // overwrites the onload callback and doesn't pass the event
                // object to previously defined callbacks.  All the browsers
                // that don't define window.event implement addEventListener
                // so the dom_loaded handler will still be fired as usual.
                if (!event) {
                    return undefined;
                }

                var ret = true;
                var old_result, new_result;

                if (_.isFunction(old_handlers)) {
                    old_result = old_handlers(event);
                }
                new_result = new_handler.call(element, event);

                if ((false === old_result) || (false === new_result)) {
                    ret = false;
                }

                return ret;
            };

            return handler;
        }

        function fixEvent(event) {
            if (event) {
                event.preventDefault = fixEvent.preventDefault;
                event.stopPropagation = fixEvent.stopPropagation;
            }
            return event;
        }
        fixEvent.preventDefault = function() {
            this.returnValue = false;
        };
        fixEvent.stopPropagation = function() {
            this.cancelBubble = true;
        };

        return register_event;
    })();


    var TOKEN_MATCH_REGEX = new RegExp('^(\\w*)\\[(\\w+)([=~\\|\\^\\$\\*]?)=?"?([^\\]"]*)"?\\]$');

    _.dom_query = (function() {
        /* document.getElementsBySelector(selector)
        - returns an array of element objects from the current document
        matching the CSS selector. Selectors can contain element names,
        class names and ids and can be nested. For example:

        elements = document.getElementsBySelector('div#main p a.external')

        Will return an array of all 'a' elements with 'external' in their
        class attribute that are contained inside 'p' elements that are
        contained inside the 'div' element which has id="main"

        New in version 0.4: Support for CSS2 and CSS3 attribute selectors:
        See http://www.w3.org/TR/css3-selectors/#attribute-selectors

        Version 0.4 - Simon Willison, March 25th 2003
        -- Works in Phoenix 0.5, Mozilla 1.3, Opera 7, Internet Explorer 6, Internet Explorer 5 on Windows
        -- Opera 7 fails

        Version 0.5 - Carl Sverre, Jan 7th 2013
        -- Now uses jQuery-esque `hasClass` for testing class name
        equality.  This fixes a bug related to '-' characters being
        considered not part of a 'word' in regex.
        */

        function getAllChildren(e) {
            // Returns all children of element. Workaround required for IE5/Windows. Ugh.
            return e.all ? e.all : e.getElementsByTagName('*');
        }

        var bad_whitespace = /[\t\r\n]/g;

        function hasClass(elem, selector) {
            var className = ' ' + selector + ' ';
            return ((' ' + elem.className + ' ').replace(bad_whitespace, ' ').indexOf(className) >= 0);
        }

        function getElementsBySelector(selector) {
            // Attempt to fail gracefully in lesser browsers
            if (!document$1.getElementsByTagName) {
                return [];
            }
            // Split selector in to tokens
            var tokens = selector.split(' ');
            var token, bits, tagName, found, foundCount, i, j, k, elements, currentContextIndex;
            var currentContext = [document$1];
            for (i = 0; i < tokens.length; i++) {
                token = tokens[i].replace(/^\s+/, '').replace(/\s+$/, '');
                if (token.indexOf('#') > -1) {
                    // Token is an ID selector
                    bits = token.split('#');
                    tagName = bits[0];
                    var id = bits[1];
                    var element = document$1.getElementById(id);
                    if (!element || (tagName && element.nodeName.toLowerCase() != tagName)) {
                        // element not found or tag with that ID not found, return false
                        return [];
                    }
                    // Set currentContext to contain just this element
                    currentContext = [element];
                    continue; // Skip to next token
                }
                if (token.indexOf('.') > -1) {
                    // Token contains a class selector
                    bits = token.split('.');
                    tagName = bits[0];
                    var className = bits[1];
                    if (!tagName) {
                        tagName = '*';
                    }
                    // Get elements matching tag, filter them for class selector
                    found = [];
                    foundCount = 0;
                    for (j = 0; j < currentContext.length; j++) {
                        if (tagName == '*') {
                            elements = getAllChildren(currentContext[j]);
                        } else {
                            elements = currentContext[j].getElementsByTagName(tagName);
                        }
                        for (k = 0; k < elements.length; k++) {
                            found[foundCount++] = elements[k];
                        }
                    }
                    currentContext = [];
                    currentContextIndex = 0;
                    for (j = 0; j < found.length; j++) {
                        if (found[j].className &&
                            _.isString(found[j].className) && // some SVG elements have classNames which are not strings
                            hasClass(found[j], className)
                        ) {
                            currentContext[currentContextIndex++] = found[j];
                        }
                    }
                    continue; // Skip to next token
                }
                // Code to deal with attribute selectors
                var token_match = token.match(TOKEN_MATCH_REGEX);
                if (token_match) {
                    tagName = token_match[1];
                    var attrName = token_match[2];
                    var attrOperator = token_match[3];
                    var attrValue = token_match[4];
                    if (!tagName) {
                        tagName = '*';
                    }
                    // Grab all of the tagName elements within current context
                    found = [];
                    foundCount = 0;
                    for (j = 0; j < currentContext.length; j++) {
                        if (tagName == '*') {
                            elements = getAllChildren(currentContext[j]);
                        } else {
                            elements = currentContext[j].getElementsByTagName(tagName);
                        }
                        for (k = 0; k < elements.length; k++) {
                            found[foundCount++] = elements[k];
                        }
                    }
                    currentContext = [];
                    currentContextIndex = 0;
                    var checkFunction; // This function will be used to filter the elements
                    switch (attrOperator) {
                        case '=': // Equality
                            checkFunction = function(e) {
                                return (e.getAttribute(attrName) == attrValue);
                            };
                            break;
                        case '~': // Match one of space seperated words
                            checkFunction = function(e) {
                                return (e.getAttribute(attrName).match(new RegExp('\\b' + attrValue + '\\b')));
                            };
                            break;
                        case '|': // Match start with value followed by optional hyphen
                            checkFunction = function(e) {
                                return (e.getAttribute(attrName).match(new RegExp('^' + attrValue + '-?')));
                            };
                            break;
                        case '^': // Match starts with value
                            checkFunction = function(e) {
                                return (e.getAttribute(attrName).indexOf(attrValue) === 0);
                            };
                            break;
                        case '$': // Match ends with value - fails with "Warning" in Opera 7
                            checkFunction = function(e) {
                                return (e.getAttribute(attrName).lastIndexOf(attrValue) == e.getAttribute(attrName).length - attrValue.length);
                            };
                            break;
                        case '*': // Match ends with value
                            checkFunction = function(e) {
                                return (e.getAttribute(attrName).indexOf(attrValue) > -1);
                            };
                            break;
                        default:
                            // Just test for existence of attribute
                            checkFunction = function(e) {
                                return e.getAttribute(attrName);
                            };
                    }
                    currentContext = [];
                    currentContextIndex = 0;
                    for (j = 0; j < found.length; j++) {
                        if (checkFunction(found[j])) {
                            currentContext[currentContextIndex++] = found[j];
                        }
                    }
                    // alert('Attribute Selector: '+tagName+' '+attrName+' '+attrOperator+' '+attrValue);
                    continue; // Skip to next token
                }
                // If we get here, token is JUST an element (not a class or ID selector)
                tagName = token;
                found = [];
                foundCount = 0;
                for (j = 0; j < currentContext.length; j++) {
                    elements = currentContext[j].getElementsByTagName(tagName);
                    for (k = 0; k < elements.length; k++) {
                        found[foundCount++] = elements[k];
                    }
                }
                currentContext = found;
            }
            return currentContext;
        }

        return function(query) {
            if (_.isElement(query)) {
                return [query];
            } else if (_.isObject(query) && !_.isUndefined(query.length)) {
                return query;
            } else {
                return getElementsBySelector.call(this, query);
            }
        };
    })();

    var CAMPAIGN_KEYWORDS = ['utm_source', 'utm_medium', 'utm_campaign', 'utm_content', 'utm_term'];
    var CLICK_IDS = ['dclid', 'fbclid', 'gclid', 'ko_click_id', 'li_fat_id', 'msclkid', 'ttclid', 'twclid', 'wbraid'];

    _.info = {
        campaignParams: function(default_value) {
            var kw = '',
                params = {};
            _.each(CAMPAIGN_KEYWORDS, function(kwkey) {
                kw = _.getQueryParam(document$1.URL, kwkey);
                if (kw.length) {
                    params[kwkey] = kw;
                } else if (default_value !== undefined) {
                    params[kwkey] = default_value;
                }
            });

            return params;
        },

        clickParams: function() {
            var id = '',
                params = {};
            _.each(CLICK_IDS, function(idkey) {
                id = _.getQueryParam(document$1.URL, idkey);
                if (id.length) {
                    params[idkey] = id;
                }
            });

            return params;
        },

        marketingParams: function() {
            return _.extend(_.info.campaignParams(), _.info.clickParams());
        },

        searchEngine: function(referrer) {
            if (referrer.search('https?://(.*)google.([^/?]*)') === 0) {
                return 'google';
            } else if (referrer.search('https?://(.*)bing.com') === 0) {
                return 'bing';
            } else if (referrer.search('https?://(.*)yahoo.com') === 0) {
                return 'yahoo';
            } else if (referrer.search('https?://(.*)duckduckgo.com') === 0) {
                return 'duckduckgo';
            } else {
                return null;
            }
        },

        searchInfo: function(referrer) {
            var search = _.info.searchEngine(referrer),
                param = (search != 'yahoo') ? 'q' : 'p',
                ret = {};

            if (search !== null) {
                ret['$search_engine'] = search;

                var keyword = _.getQueryParam(referrer, param);
                if (keyword.length) {
                    ret['mp_keyword'] = keyword;
                }
            }

            return ret;
        },

        /**
         * This function detects which browser is running this script.
         * The order of the checks are important since many user agents
         * include key words used in later checks.
         */
        browser: function(user_agent, vendor, opera) {
            vendor = vendor || ''; // vendor is undefined for at least IE9
            if (opera || _.includes(user_agent, ' OPR/')) {
                if (_.includes(user_agent, 'Mini')) {
                    return 'Opera Mini';
                }
                return 'Opera';
            } else if (/(BlackBerry|PlayBook|BB10)/i.test(user_agent)) {
                return 'BlackBerry';
            } else if (_.includes(user_agent, 'IEMobile') || _.includes(user_agent, 'WPDesktop')) {
                return 'Internet Explorer Mobile';
            } else if (_.includes(user_agent, 'SamsungBrowser/')) {
                // https://developer.samsung.com/internet/user-agent-string-format
                return 'Samsung Internet';
            } else if (_.includes(user_agent, 'Edge') || _.includes(user_agent, 'Edg/')) {
                return 'Microsoft Edge';
            } else if (_.includes(user_agent, 'FBIOS')) {
                return 'Facebook Mobile';
            } else if (_.includes(user_agent, 'Chrome')) {
                return 'Chrome';
            } else if (_.includes(user_agent, 'CriOS')) {
                return 'Chrome iOS';
            } else if (_.includes(user_agent, 'UCWEB') || _.includes(user_agent, 'UCBrowser')) {
                return 'UC Browser';
            } else if (_.includes(user_agent, 'FxiOS')) {
                return 'Firefox iOS';
            } else if (_.includes(vendor, 'Apple')) {
                if (_.includes(user_agent, 'Mobile')) {
                    return 'Mobile Safari';
                }
                return 'Safari';
            } else if (_.includes(user_agent, 'Android')) {
                return 'Android Mobile';
            } else if (_.includes(user_agent, 'Konqueror')) {
                return 'Konqueror';
            } else if (_.includes(user_agent, 'Firefox')) {
                return 'Firefox';
            } else if (_.includes(user_agent, 'MSIE') || _.includes(user_agent, 'Trident/')) {
                return 'Internet Explorer';
            } else if (_.includes(user_agent, 'Gecko')) {
                return 'Mozilla';
            } else {
                return '';
            }
        },

        /**
         * This function detects which browser version is running this script,
         * parsing major and minor version (e.g., 42.1). User agent strings from:
         * http://www.useragentstring.com/pages/useragentstring.php
         */
        browserVersion: function(userAgent, vendor, opera) {
            var browser = _.info.browser(userAgent, vendor, opera);
            var versionRegexs = {
                'Internet Explorer Mobile': /rv:(\d+(\.\d+)?)/,
                'Microsoft Edge': /Edge?\/(\d+(\.\d+)?)/,
                'Chrome': /Chrome\/(\d+(\.\d+)?)/,
                'Chrome iOS': /CriOS\/(\d+(\.\d+)?)/,
                'UC Browser' : /(UCBrowser|UCWEB)\/(\d+(\.\d+)?)/,
                'Safari': /Version\/(\d+(\.\d+)?)/,
                'Mobile Safari': /Version\/(\d+(\.\d+)?)/,
                'Opera': /(Opera|OPR)\/(\d+(\.\d+)?)/,
                'Firefox': /Firefox\/(\d+(\.\d+)?)/,
                'Firefox iOS': /FxiOS\/(\d+(\.\d+)?)/,
                'Konqueror': /Konqueror:(\d+(\.\d+)?)/,
                'BlackBerry': /BlackBerry (\d+(\.\d+)?)/,
                'Android Mobile': /android\s(\d+(\.\d+)?)/,
                'Samsung Internet': /SamsungBrowser\/(\d+(\.\d+)?)/,
                'Internet Explorer': /(rv:|MSIE )(\d+(\.\d+)?)/,
                'Mozilla': /rv:(\d+(\.\d+)?)/
            };
            var regex = versionRegexs[browser];
            if (regex === undefined) {
                return null;
            }
            var matches = userAgent.match(regex);
            if (!matches) {
                return null;
            }
            return parseFloat(matches[matches.length - 2]);
        },

        os: function() {
            var a = userAgent;
            if (/Windows/i.test(a)) {
                if (/Phone/.test(a) || /WPDesktop/.test(a)) {
                    return 'Windows Phone';
                }
                return 'Windows';
            } else if (/(iPhone|iPad|iPod)/.test(a)) {
                return 'iOS';
            } else if (/Android/.test(a)) {
                return 'Android';
            } else if (/(BlackBerry|PlayBook|BB10)/i.test(a)) {
                return 'BlackBerry';
            } else if (/Mac/i.test(a)) {
                return 'Mac OS X';
            } else if (/Linux/.test(a)) {
                return 'Linux';
            } else if (/CrOS/.test(a)) {
                return 'Chrome OS';
            } else {
                return '';
            }
        },

        device: function(user_agent) {
            if (/Windows Phone/i.test(user_agent) || /WPDesktop/.test(user_agent)) {
                return 'Windows Phone';
            } else if (/iPad/.test(user_agent)) {
                return 'iPad';
            } else if (/iPod/.test(user_agent)) {
                return 'iPod Touch';
            } else if (/iPhone/.test(user_agent)) {
                return 'iPhone';
            } else if (/(BlackBerry|PlayBook|BB10)/i.test(user_agent)) {
                return 'BlackBerry';
            } else if (/Android/.test(user_agent)) {
                return 'Android';
            } else {
                return '';
            }
        },

        referringDomain: function(referrer) {
            var split = referrer.split('/');
            if (split.length >= 3) {
                return split[2];
            }
            return '';
        },

        currentUrl: function() {
            return window$1.location.href;
        },

        properties: function(extra_props) {
            if (typeof extra_props !== 'object') {
                extra_props = {};
            }
            return _.extend(_.strip_empty_properties({
                '$os': _.info.os(),
                '$browser': _.info.browser(userAgent, navigator.vendor, windowOpera),
                '$referrer': document$1.referrer,
                '$referring_domain': _.info.referringDomain(document$1.referrer),
                '$device': _.info.device(userAgent)
            }), {
                '$current_url': _.info.currentUrl(),
                '$browser_version': _.info.browserVersion(userAgent, navigator.vendor, windowOpera),
                '$screen_height': screen.height,
                '$screen_width': screen.width,
                'mp_lib': 'web',
                '$lib_version': Config.LIB_VERSION,
                '$insert_id': cheap_guid(),
                'time': _.timestamp() / 1000 // epoch time in seconds
            }, _.strip_empty_properties(extra_props));
        },

        people_properties: function() {
            return _.extend(_.strip_empty_properties({
                '$os': _.info.os(),
                '$browser': _.info.browser(userAgent, navigator.vendor, windowOpera)
            }), {
                '$browser_version': _.info.browserVersion(userAgent, navigator.vendor, windowOpera)
            });
        },

        mpPageViewProperties: function() {
            return _.strip_empty_properties({
                'current_page_title': document$1.title,
                'current_domain': window$1.location.hostname,
                'current_url_path': window$1.location.pathname,
                'current_url_protocol': window$1.location.protocol,
                'current_url_search': window$1.location.search
            });
        }
    };

    var cheap_guid = function(maxlen) {
        var guid = Math.random().toString(36).substring(2, 10) + Math.random().toString(36).substring(2, 10);
        return maxlen ? guid.substring(0, maxlen) : guid;
    };

    // naive way to extract domain name (example.com) from full hostname (my.sub.example.com)
    var SIMPLE_DOMAIN_MATCH_REGEX = /[a-z0-9][a-z0-9-]*\.[a-z]+$/i;
    // this next one attempts to account for some ccSLDs, e.g. extracting oxford.ac.uk from www.oxford.ac.uk
    var DOMAIN_MATCH_REGEX = /[a-z0-9][a-z0-9-]+\.[a-z.]{2,6}$/i;
    /**
     * Attempts to extract main domain name from full hostname, using a few blunt heuristics. For
     * common TLDs like .com/.org that always have a simple SLD.TLD structure (example.com), we
     * simply extract the last two .-separated parts of the hostname (SIMPLE_DOMAIN_MATCH_REGEX).
     * For others, we attempt to account for short ccSLD+TLD combos (.ac.uk) with the legacy
     * DOMAIN_MATCH_REGEX (kept to maintain backwards compatibility with existing Mixpanel
     * integrations). The only _reliable_ way to extract domain from hostname is with an up-to-date
     * list like at https://publicsuffix.org/ so for cases that this helper fails at, the SDK
     * offers the 'cookie_domain' config option to set it explicitly.
     * @example
     * extract_domain('my.sub.example.com')
     * // 'example.com'
     */
    var extract_domain = function(hostname) {
        var domain_regex = DOMAIN_MATCH_REGEX;
        var parts = hostname.split('.');
        var tld = parts[parts.length - 1];
        if (tld.length > 4 || tld === 'com' || tld === 'org') {
            domain_regex = SIMPLE_DOMAIN_MATCH_REGEX;
        }
        var matches = hostname.match(domain_regex);
        return matches ? matches[0] : '';
    };

    var JSONStringify = null;
    var JSONParse = null;
    if (typeof JSON !== 'undefined') {
        JSONStringify = JSON.stringify;
        JSONParse = JSON.parse;
    }
    JSONStringify = JSONStringify || _.JSONEncode;
    JSONParse = JSONParse || _.JSONDecode;

    // EXPORTS (for closure compiler)
    _['toArray']                = _.toArray;
    _['isObject']               = _.isObject;
    _['JSONEncode']             = _.JSONEncode;
    _['JSONDecode']             = _.JSONDecode;
    _['isBlockedUA']            = _.isBlockedUA;
    _['isEmptyObject']          = _.isEmptyObject;
    _['info']                   = _.info;
    _['info']['device']         = _.info.device;
    _['info']['browser']        = _.info.browser;
    _['info']['browserVersion'] = _.info.browserVersion;
    _['info']['properties']     = _.info.properties;

    /**
     * DomTracker Object
     * @constructor
     */
    var DomTracker = function() {};


    // interface
    DomTracker.prototype.create_properties = function() {};
    DomTracker.prototype.event_handler = function() {};
    DomTracker.prototype.after_track_handler = function() {};

    DomTracker.prototype.init = function(mixpanel_instance) {
        this.mp = mixpanel_instance;
        return this;
    };

    /**
     * @param {Object|string} query
     * @param {string} event_name
     * @param {Object=} properties
     * @param {function=} user_callback
     */
    DomTracker.prototype.track = function(query, event_name, properties, user_callback) {
        var that = this;
        var elements = _.dom_query(query);

        if (elements.length === 0) {
            console$1.error('The DOM query (' + query + ') returned 0 elements');
            return;
        }

        _.each(elements, function(element) {
            _.register_event(element, this.override_event, function(e) {
                var options = {};
                var props = that.create_properties(properties, this);
                var timeout = that.mp.get_config('track_links_timeout');

                that.event_handler(e, this, options);

                // in case the mixpanel servers don't get back to us in time
                window.setTimeout(that.track_callback(user_callback, props, options, true), timeout);

                // fire the tracking event
                that.mp.track(event_name, props, that.track_callback(user_callback, props, options));
            });
        }, this);

        return true;
    };

    /**
     * @param {function} user_callback
     * @param {Object} props
     * @param {boolean=} timeout_occured
     */
    DomTracker.prototype.track_callback = function(user_callback, props, options, timeout_occured) {
        timeout_occured = timeout_occured || false;
        var that = this;

        return function() {
            // options is referenced from both callbacks, so we can have
            // a 'lock' of sorts to ensure only one fires
            if (options.callback_fired) { return; }
            options.callback_fired = true;

            if (user_callback && user_callback(timeout_occured, props) === false) {
                // user can prevent the default functionality by
                // returning false from their callback
                return;
            }

            that.after_track_handler(props, options, timeout_occured);
        };
    };

    DomTracker.prototype.create_properties = function(properties, element) {
        var props;

        if (typeof(properties) === 'function') {
            props = properties(element);
        } else {
            props = _.extend({}, properties);
        }

        return props;
    };

    /**
     * LinkTracker Object
     * @constructor
     * @extends DomTracker
     */
    var LinkTracker = function() {
        this.override_event = 'click';
    };
    _.inherit(LinkTracker, DomTracker);

    LinkTracker.prototype.create_properties = function(properties, element) {
        var props = LinkTracker.superclass.create_properties.apply(this, arguments);

        if (element.href) { props['url'] = element.href; }

        return props;
    };

    LinkTracker.prototype.event_handler = function(evt, element, options) {
        options.new_tab = (
            evt.which === 2 ||
            evt.metaKey ||
            evt.ctrlKey ||
            element.target === '_blank'
        );
        options.href = element.href;

        if (!options.new_tab) {
            evt.preventDefault();
        }
    };

    LinkTracker.prototype.after_track_handler = function(props, options) {
        if (options.new_tab) { return; }

        setTimeout(function() {
            window.location = options.href;
        }, 0);
    };

    /**
     * FormTracker Object
     * @constructor
     * @extends DomTracker
     */
    var FormTracker = function() {
        this.override_event = 'submit';
    };
    _.inherit(FormTracker, DomTracker);

    FormTracker.prototype.event_handler = function(evt, element, options) {
        options.element = element;
        evt.preventDefault();
    };

    FormTracker.prototype.after_track_handler = function(props, options) {
        setTimeout(function() {
            options.element.submit();
        }, 0);
    };

    // eslint-disable-line camelcase

    var logger$2 = console_with_prefix('lock');

    /**
     * SharedLock: a mutex built on HTML5 localStorage, to ensure that only one browser
     * window/tab at a time will be able to access shared resources.
     *
     * Based on the Alur and Taubenfeld fast lock
     * (http://www.cs.rochester.edu/research/synchronization/pseudocode/fastlock.html)
     * with an added timeout to ensure there will be eventual progress in the event
     * that a window is closed in the middle of the callback.
     *
     * Implementation based on the original version by David Wolever (https://github.com/wolever)
     * at https://gist.github.com/wolever/5fd7573d1ef6166e8f8c4af286a69432.
     *
     * @example
     * const myLock = new SharedLock('some-key');
     * myLock.withLock(function() {
     *   console.log('I hold the mutex!');
     * });
     *
     * @constructor
     */
    var SharedLock = function(key, options) {
        options = options || {};

        this.storageKey = key;
        this.storage = options.storage || window.localStorage;
        this.pollIntervalMS = options.pollIntervalMS || 100;
        this.timeoutMS = options.timeoutMS || 2000;
    };

    // pass in a specific pid to test contention scenarios; otherwise
    // it is chosen randomly for each acquisition attempt
    SharedLock.prototype.withLock = function(lockedCB, errorCB, pid) {
        if (!pid && typeof errorCB !== 'function') {
            pid = errorCB;
            errorCB = null;
        }

        var i = pid || (new Date().getTime() + '|' + Math.random());
        var startTime = new Date().getTime();

        var key = this.storageKey;
        var pollIntervalMS = this.pollIntervalMS;
        var timeoutMS = this.timeoutMS;
        var storage = this.storage;

        var keyX = key + ':X';
        var keyY = key + ':Y';
        var keyZ = key + ':Z';

        var reportError = function(err) {
            errorCB && errorCB(err);
        };

        var delay = function(cb) {
            if (new Date().getTime() - startTime > timeoutMS) {
                logger$2.error('Timeout waiting for mutex on ' + key + '; clearing lock. [' + i + ']');
                storage.removeItem(keyZ);
                storage.removeItem(keyY);
                loop();
                return;
            }
            setTimeout(function() {
                try {
                    cb();
                } catch(err) {
                    reportError(err);
                }
            }, pollIntervalMS * (Math.random() + 0.1));
        };

        var waitFor = function(predicate, cb) {
            if (predicate()) {
                cb();
            } else {
                delay(function() {
                    waitFor(predicate, cb);
                });
            }
        };

        var getSetY = function() {
            var valY = storage.getItem(keyY);
            if (valY && valY !== i) { // if Y == i then this process already has the lock (useful for test cases)
                return false;
            } else {
                storage.setItem(keyY, i);
                if (storage.getItem(keyY) === i) {
                    return true;
                } else {
                    if (!localStorageSupported(storage, true)) {
                        throw new Error('localStorage support dropped while acquiring lock');
                    }
                    return false;
                }
            }
        };

        var loop = function() {
            storage.setItem(keyX, i);

            waitFor(getSetY, function() {
                if (storage.getItem(keyX) === i) {
                    criticalSection();
                    return;
                }

                delay(function() {
                    if (storage.getItem(keyY) !== i) {
                        loop();
                        return;
                    }
                    waitFor(function() {
                        return !storage.getItem(keyZ);
                    }, criticalSection);
                });
            });
        };

        var criticalSection = function() {
            storage.setItem(keyZ, '1');
            try {
                lockedCB();
            } finally {
                storage.removeItem(keyZ);
                if (storage.getItem(keyY) === i) {
                    storage.removeItem(keyY);
                }
                if (storage.getItem(keyX) === i) {
                    storage.removeItem(keyX);
                }
            }
        };

        try {
            if (localStorageSupported(storage, true)) {
                loop();
            } else {
                throw new Error('localStorage support check failed');
            }
        } catch(err) {
            reportError(err);
        }
    };

    // eslint-disable-line camelcase

    var logger$1 = console_with_prefix('batch');

    /**
     * RequestQueue: queue for batching API requests with localStorage backup for retries.
     * Maintains an in-memory queue which represents the source of truth for the current
     * page, but also writes all items out to a copy in the browser's localStorage, which
     * can be read on subsequent pageloads and retried. For batchability, all the request
     * items in the queue should be of the same type (events, people updates, group updates)
     * so they can be sent in a single request to the same API endpoint.
     *
     * LocalStorage keying and locking: In order for reloads and subsequent pageloads of
     * the same site to access the same persisted data, they must share the same localStorage
     * key (for instance based on project token and queue type). Therefore access to the
     * localStorage entry is guarded by an asynchronous mutex (SharedLock) to prevent
     * simultaneously open windows/tabs from overwriting each other's data (which would lead
     * to data loss in some situations).
     * @constructor
     */
    var RequestQueue = function(storageKey, options) {
        options = options || {};
        this.storageKey = storageKey;
        this.storage = options.storage || window.localStorage;
        this.reportError = options.errorReporter || _.bind(logger$1.error, logger$1);
        this.lock = new SharedLock(storageKey, {storage: this.storage});

        this.pid = options.pid || null; // pass pid to test out storage lock contention scenarios

        this.memQueue = [];
    };

    /**
     * Add one item to queues (memory and localStorage). The queued entry includes
     * the given item along with an auto-generated ID and a "flush-after" timestamp.
     * It is expected that the item will be sent over the network and dequeued
     * before the flush-after time; if this doesn't happen it is considered orphaned
     * (e.g., the original tab where it was enqueued got closed before it could be
     * sent) and the item can be sent by any tab that finds it in localStorage.
     *
     * The final callback param is called with a param indicating success or
     * failure of the enqueue operation; it is asynchronous because the localStorage
     * lock is asynchronous.
     */
    RequestQueue.prototype.enqueue = function(item, flushInterval, cb) {
        var queueEntry = {
            'id': cheap_guid(),
            'flushAfter': new Date().getTime() + flushInterval * 2,
            'payload': item
        };

        this.lock.withLock(_.bind(function lockAcquired() {
            var succeeded;
            try {
                var storedQueue = this.readFromStorage();
                storedQueue.push(queueEntry);
                succeeded = this.saveToStorage(storedQueue);
                if (succeeded) {
                    // only add to in-memory queue when storage succeeds
                    this.memQueue.push(queueEntry);
                }
            } catch(err) {
                this.reportError('Error enqueueing item', item);
                succeeded = false;
            }
            if (cb) {
                cb(succeeded);
            }
        }, this), _.bind(function lockFailure(err) {
            this.reportError('Error acquiring storage lock', err);
            if (cb) {
                cb(false);
            }
        }, this), this.pid);
    };

    /**
     * Read out the given number of queue entries. If this.memQueue
     * has fewer than batchSize items, then look for "orphaned" items
     * in the persisted queue (items where the 'flushAfter' time has
     * already passed).
     */
    RequestQueue.prototype.fillBatch = function(batchSize) {
        var batch = this.memQueue.slice(0, batchSize);
        if (batch.length < batchSize) {
            // don't need lock just to read events; localStorage is thread-safe
            // and the worst that could happen is a duplicate send of some
            // orphaned events, which will be deduplicated on the server side
            var storedQueue = this.readFromStorage();
            if (storedQueue.length) {
                // item IDs already in batch; don't duplicate out of storage
                var idsInBatch = {}; // poor man's Set
                _.each(batch, function(item) { idsInBatch[item['id']] = true; });

                for (var i = 0; i < storedQueue.length; i++) {
                    var item = storedQueue[i];
                    if (new Date().getTime() > item['flushAfter'] && !idsInBatch[item['id']]) {
                        item.orphaned = true;
                        batch.push(item);
                        if (batch.length >= batchSize) {
                            break;
                        }
                    }
                }
            }
        }
        return batch;
    };

    /**
     * Remove items with matching 'id' from array (immutably)
     * also remove any item without a valid id (e.g., malformed
     * storage entries).
     */
    var filterOutIDsAndInvalid = function(items, idSet) {
        var filteredItems = [];
        _.each(items, function(item) {
            if (item['id'] && !idSet[item['id']]) {
                filteredItems.push(item);
            }
        });
        return filteredItems;
    };

    /**
     * Remove items with matching IDs from both in-memory queue
     * and persisted queue
     */
    RequestQueue.prototype.removeItemsByID = function(ids, cb) {
        var idSet = {}; // poor man's Set
        _.each(ids, function(id) { idSet[id] = true; });

        this.memQueue = filterOutIDsAndInvalid(this.memQueue, idSet);

        var removeFromStorage = _.bind(function() {
            var succeeded;
            try {
                var storedQueue = this.readFromStorage();
                storedQueue = filterOutIDsAndInvalid(storedQueue, idSet);
                succeeded = this.saveToStorage(storedQueue);

                // an extra check: did storage report success but somehow
                // the items are still there?
                if (succeeded) {
                    storedQueue = this.readFromStorage();
                    for (var i = 0; i < storedQueue.length; i++) {
                        var item = storedQueue[i];
                        if (item['id'] && !!idSet[item['id']]) {
                            this.reportError('Item not removed from storage');
                            return false;
                        }
                    }
                }
            } catch(err) {
                this.reportError('Error removing items', ids);
                succeeded = false;
            }
            return succeeded;
        }, this);

        this.lock.withLock(function lockAcquired() {
            var succeeded = removeFromStorage();
            if (cb) {
                cb(succeeded);
            }
        }, _.bind(function lockFailure(err) {
            var succeeded = false;
            this.reportError('Error acquiring storage lock', err);
            if (!localStorageSupported(this.storage, true)) {
                // Looks like localStorage writes have stopped working sometime after
                // initialization (probably full), and so nobody can acquire locks
                // anymore. Consider it temporarily safe to remove items without the
                // lock, since nobody's writing successfully anyway.
                succeeded = removeFromStorage();
                if (!succeeded) {
                    // OK, we couldn't even write out the smaller queue. Try clearing it
                    // entirely.
                    try {
                        this.storage.removeItem(this.storageKey);
                    } catch(err) {
                        this.reportError('Error clearing queue', err);
                    }
                }
            }
            if (cb) {
                cb(succeeded);
            }
        }, this), this.pid);
    };

    // internal helper for RequestQueue.updatePayloads
    var updatePayloads = function(existingItems, itemsToUpdate) {
        var newItems = [];
        _.each(existingItems, function(item) {
            var id = item['id'];
            if (id in itemsToUpdate) {
                var newPayload = itemsToUpdate[id];
                if (newPayload !== null) {
                    item['payload'] = newPayload;
                    newItems.push(item);
                }
            } else {
                // no update
                newItems.push(item);
            }
        });
        return newItems;
    };

    /**
     * Update payloads of given items in both in-memory queue and
     * persisted queue. Items set to null are removed from queues.
     */
    RequestQueue.prototype.updatePayloads = function(itemsToUpdate, cb) {
        this.memQueue = updatePayloads(this.memQueue, itemsToUpdate);
        this.lock.withLock(_.bind(function lockAcquired() {
            var succeeded;
            try {
                var storedQueue = this.readFromStorage();
                storedQueue = updatePayloads(storedQueue, itemsToUpdate);
                succeeded = this.saveToStorage(storedQueue);
            } catch(err) {
                this.reportError('Error updating items', itemsToUpdate);
                succeeded = false;
            }
            if (cb) {
                cb(succeeded);
            }
        }, this), _.bind(function lockFailure(err) {
            this.reportError('Error acquiring storage lock', err);
            if (cb) {
                cb(false);
            }
        }, this), this.pid);
    };

    /**
     * Read and parse items array from localStorage entry, handling
     * malformed/missing data if necessary.
     */
    RequestQueue.prototype.readFromStorage = function() {
        var storageEntry;
        try {
            storageEntry = this.storage.getItem(this.storageKey);
            if (storageEntry) {
                storageEntry = JSONParse(storageEntry);
                if (!_.isArray(storageEntry)) {
                    this.reportError('Invalid storage entry:', storageEntry);
                    storageEntry = null;
                }
            }
        } catch (err) {
            this.reportError('Error retrieving queue', err);
            storageEntry = null;
        }
        return storageEntry || [];
    };

    /**
     * Serialize the given items array to localStorage.
     */
    RequestQueue.prototype.saveToStorage = function(queue) {
        try {
            this.storage.setItem(this.storageKey, JSONStringify(queue));
            return true;
        } catch (err) {
            this.reportError('Error saving queue', err);
            return false;
        }
    };

    /**
     * Clear out queues (memory and localStorage).
     */
    RequestQueue.prototype.clear = function() {
        this.memQueue = [];
        this.storage.removeItem(this.storageKey);
    };

    // eslint-disable-line camelcase

    // maximum interval between request retries after exponential backoff
    var MAX_RETRY_INTERVAL_MS = 10 * 60 * 1000; // 10 minutes

    var logger = console_with_prefix('batch');

    /**
     * RequestBatcher: manages the queueing, flushing, retry etc of requests of one
     * type (events, people, groups).
     * Uses RequestQueue to manage the backing store.
     * @constructor
     */
    var RequestBatcher = function(storageKey, options) {
        this.errorReporter = options.errorReporter;
        this.queue = new RequestQueue(storageKey, {
            errorReporter: _.bind(this.reportError, this),
            storage: options.storage
        });

        this.libConfig = options.libConfig;
        this.sendRequest = options.sendRequestFunc;
        this.beforeSendHook = options.beforeSendHook;
        this.stopAllBatching = options.stopAllBatchingFunc;

        // seed variable batch size + flush interval with configured values
        this.batchSize = this.libConfig['batch_size'];
        this.flushInterval = this.libConfig['batch_flush_interval_ms'];

        this.stopped = !this.libConfig['batch_autostart'];
        this.consecutiveRemovalFailures = 0;

        // extra client-side dedupe
        this.itemIdsSentSuccessfully = {};
    };

    /**
     * Add one item to queue.
     */
    RequestBatcher.prototype.enqueue = function(item, cb) {
        this.queue.enqueue(item, this.flushInterval, cb);
    };

    /**
     * Start flushing batches at the configured time interval. Must call
     * this method upon SDK init in order to send anything over the network.
     */
    RequestBatcher.prototype.start = function() {
        this.stopped = false;
        this.consecutiveRemovalFailures = 0;
        this.flush();
    };

    /**
     * Stop flushing batches. Can be restarted by calling start().
     */
    RequestBatcher.prototype.stop = function() {
        this.stopped = true;
        if (this.timeoutID) {
            clearTimeout(this.timeoutID);
            this.timeoutID = null;
        }
    };

    /**
     * Clear out queue.
     */
    RequestBatcher.prototype.clear = function() {
        this.queue.clear();
    };

    /**
     * Restore batch size configuration to whatever is set in the main SDK.
     */
    RequestBatcher.prototype.resetBatchSize = function() {
        this.batchSize = this.libConfig['batch_size'];
    };

    /**
     * Restore flush interval time configuration to whatever is set in the main SDK.
     */
    RequestBatcher.prototype.resetFlush = function() {
        this.scheduleFlush(this.libConfig['batch_flush_interval_ms']);
    };

    /**
     * Schedule the next flush in the given number of milliseconds.
     */
    RequestBatcher.prototype.scheduleFlush = function(flushMS) {
        this.flushInterval = flushMS;
        if (!this.stopped) { // don't schedule anymore if batching has been stopped
            this.timeoutID = setTimeout(_.bind(this.flush, this), this.flushInterval);
        }
    };

    /**
     * Flush one batch to network. Depending on success/failure modes, it will either
     * remove the batch from the queue or leave it in for retry, and schedule the next
     * flush. In cases of most network or API failures, it will back off exponentially
     * when retrying.
     * @param {Object} [options]
     * @param {boolean} [options.sendBeacon] - whether to send batch with
     * navigator.sendBeacon (only useful for sending batches before page unloads, as
     * sendBeacon offers no callbacks or status indications)
     */
    RequestBatcher.prototype.flush = function(options) {
        try {

            if (this.requestInProgress) {
                logger.log('Flush: Request already in progress');
                return;
            }

            options = options || {};
            var timeoutMS = this.libConfig['batch_request_timeout_ms'];
            var startTime = new Date().getTime();
            var currentBatchSize = this.batchSize;
            var batch = this.queue.fillBatch(currentBatchSize);
            var dataForRequest = [];
            var transformedItems = {};
            _.each(batch, function(item) {
                var payload = item['payload'];
                if (this.beforeSendHook && !item.orphaned) {
                    payload = this.beforeSendHook(payload);
                }
                if (payload) {
                    // mp_sent_by_lib_version prop captures which lib version actually
                    // sends each event (regardless of which version originally queued
                    // it for sending)
                    if (payload['event'] && payload['properties']) {
                        payload['properties'] = _.extend(
                            {},
                            payload['properties'],
                            {'mp_sent_by_lib_version': Config.LIB_VERSION}
                        );
                    }
                    var addPayload = true;
                    var itemId = item['id'];
                    if (itemId) {
                        if ((this.itemIdsSentSuccessfully[itemId] || 0) > 5) {
                            this.reportError('[dupe] item ID sent too many times, not sending', {
                                item: item,
                                batchSize: batch.length,
                                timesSent: this.itemIdsSentSuccessfully[itemId]
                            });
                            addPayload = false;
                        }
                    } else {
                        this.reportError('[dupe] found item with no ID', {item: item});
                    }

                    if (addPayload) {
                        dataForRequest.push(payload);
                    }
                }
                transformedItems[item['id']] = payload;
            }, this);
            if (dataForRequest.length < 1) {
                this.resetFlush();
                return; // nothing to do
            }

            this.requestInProgress = true;

            var batchSendCallback = _.bind(function(res) {
                this.requestInProgress = false;

                try {

                    // handle API response in a try-catch to make sure we can reset the
                    // flush operation if something goes wrong

                    var removeItemsFromQueue = false;
                    if (options.unloading) {
                        // update persisted data to include hook transformations
                        this.queue.updatePayloads(transformedItems);
                    } else if (
                        _.isObject(res) &&
                        res.error === 'timeout' &&
                        new Date().getTime() - startTime >= timeoutMS
                    ) {
                        this.reportError('Network timeout; retrying');
                        this.flush();
                    } else if (
                        _.isObject(res) &&
                        res.xhr_req &&
                        (res.xhr_req['status'] >= 500 || res.xhr_req['status'] === 429 || res.error === 'timeout')
                    ) {
                        // network or API error, or 429 Too Many Requests, retry
                        var retryMS = this.flushInterval * 2;
                        var headers = res.xhr_req['responseHeaders'];
                        if (headers) {
                            var retryAfter = headers['Retry-After'];
                            if (retryAfter) {
                                retryMS = (parseInt(retryAfter, 10) * 1000) || retryMS;
                            }
                        }
                        retryMS = Math.min(MAX_RETRY_INTERVAL_MS, retryMS);
                        this.reportError('Error; retry in ' + retryMS + ' ms');
                        this.scheduleFlush(retryMS);
                    } else if (_.isObject(res) && res.xhr_req && res.xhr_req['status'] === 413) {
                        // 413 Payload Too Large
                        if (batch.length > 1) {
                            var halvedBatchSize = Math.max(1, Math.floor(currentBatchSize / 2));
                            this.batchSize = Math.min(this.batchSize, halvedBatchSize, batch.length - 1);
                            this.reportError('413 response; reducing batch size to ' + this.batchSize);
                            this.resetFlush();
                        } else {
                            this.reportError('Single-event request too large; dropping', batch);
                            this.resetBatchSize();
                            removeItemsFromQueue = true;
                        }
                    } else {
                        // successful network request+response; remove each item in batch from queue
                        // (even if it was e.g. a 400, in which case retrying won't help)
                        removeItemsFromQueue = true;
                    }

                    if (removeItemsFromQueue) {
                        this.queue.removeItemsByID(
                            _.map(batch, function(item) { return item['id']; }),
                            _.bind(function(succeeded) {
                                if (succeeded) {
                                    this.consecutiveRemovalFailures = 0;
                                    this.flush(); // handle next batch if the queue isn't empty
                                } else {
                                    this.reportError('Failed to remove items from queue');
                                    if (++this.consecutiveRemovalFailures > 5) {
                                        this.reportError('Too many queue failures; disabling batching system.');
                                        this.stopAllBatching();
                                    } else {
                                        this.resetFlush();
                                    }
                                }
                            }, this)
                        );

                        // client-side dedupe
                        _.each(batch, _.bind(function(item) {
                            var itemId = item['id'];
                            if (itemId) {
                                this.itemIdsSentSuccessfully[itemId] = this.itemIdsSentSuccessfully[itemId] || 0;
                                this.itemIdsSentSuccessfully[itemId]++;
                                if (this.itemIdsSentSuccessfully[itemId] > 5) {
                                    this.reportError('[dupe] item ID sent too many times', {
                                        item: item,
                                        batchSize: batch.length,
                                        timesSent: this.itemIdsSentSuccessfully[itemId]
                                    });
                                }
                            } else {
                                this.reportError('[dupe] found item with no ID while removing', {item: item});
                            }
                        }, this));
                    }

                } catch(err) {
                    this.reportError('Error handling API response', err);
                    this.resetFlush();
                }
            }, this);
            var requestOptions = {
                method: 'POST',
                verbose: true,
                ignore_json_errors: true, // eslint-disable-line camelcase
                timeout_ms: timeoutMS // eslint-disable-line camelcase
            };
            if (options.unloading) {
                requestOptions.transport = 'sendBeacon';
            }
            logger.log('MIXPANEL REQUEST:', dataForRequest);
            this.sendRequest(dataForRequest, requestOptions, batchSendCallback);

        } catch(err) {
            this.reportError('Error flushing request queue', err);
            this.resetFlush();
        }
    };

    /**
     * Log error to global logger and optional user-defined logger.
     */
    RequestBatcher.prototype.reportError = function(msg, err) {
        logger.error.apply(logger.error, arguments);
        if (this.errorReporter) {
            try {
                if (!(err instanceof Error)) {
                    err = new Error(msg);
                }
                this.errorReporter(msg, err);
            } catch(err) {
                logger.error(err);
            }
        }
    };

    /**
     * A function used to track a Mixpanel event (e.g. MixpanelLib.track)
     * @callback trackFunction
     * @param {String} event_name The name of the event. This can be anything the user does - 'Button Click', 'Sign Up', 'Item Purchased', etc.
     * @param {Object} [properties] A set of properties to include with the event you're sending. These describe the user who did the event or details about the event itself.
     * @param {Function} [callback] If provided, the callback function will be called after tracking the event.
     */

    /** Public **/

    var GDPR_DEFAULT_PERSISTENCE_PREFIX = '__mp_opt_in_out_';

    /**
     * Opt the user in to data tracking and cookies/localstorage for the given token
     * @param {string} token - Mixpanel project tracking token
     * @param {Object} [options]
     * @param {trackFunction} [options.track] - function used for tracking a Mixpanel event to record the opt-in action
     * @param {string} [options.trackEventName] - event name to be used for tracking the opt-in action
     * @param {Object} [options.trackProperties] - set of properties to be tracked along with the opt-in action
     * @param {string} [options.persistenceType] Persistence mechanism used - cookie or localStorage
     * @param {string} [options.persistencePrefix=__mp_opt_in_out] - custom prefix to be used in the cookie/localstorage name
     * @param {Number} [options.cookieExpiration] - number of days until the opt-in cookie expires
     * @param {string} [options.cookieDomain] - custom cookie domain
     * @param {boolean} [options.crossSiteCookie] - whether the opt-in cookie is set as cross-site-enabled
     * @param {boolean} [options.crossSubdomainCookie] - whether the opt-in cookie is set as cross-subdomain or not
     * @param {boolean} [options.secureCookie] - whether the opt-in cookie is set as secure or not
     */
    function optIn(token, options) {
        _optInOut(true, token, options);
    }

    /**
     * Opt the user out of data tracking and cookies/localstorage for the given token
     * @param {string} token - Mixpanel project tracking token
     * @param {Object} [options]
     * @param {string} [options.persistenceType] Persistence mechanism used - cookie or localStorage
     * @param {string} [options.persistencePrefix=__mp_opt_in_out] - custom prefix to be used in the cookie/localstorage name
     * @param {Number} [options.cookieExpiration] - number of days until the opt-out cookie expires
     * @param {string} [options.cookieDomain] - custom cookie domain
     * @param {boolean} [options.crossSiteCookie] - whether the opt-in cookie is set as cross-site-enabled
     * @param {boolean} [options.crossSubdomainCookie] - whether the opt-out cookie is set as cross-subdomain or not
     * @param {boolean} [options.secureCookie] - whether the opt-out cookie is set as secure or not
     */
    function optOut(token, options) {
        _optInOut(false, token, options);
    }

    /**
     * Check whether the user has opted in to data tracking and cookies/localstorage for the given token
     * @param {string} token - Mixpanel project tracking token
     * @param {Object} [options]
     * @param {string} [options.persistenceType] Persistence mechanism used - cookie or localStorage
     * @param {string} [options.persistencePrefix=__mp_opt_in_out] - custom prefix to be used in the cookie/localstorage name
     * @returns {boolean} whether the user has opted in to the given opt type
     */
    function hasOptedIn(token, options) {
        return _getStorageValue(token, options) === '1';
    }

    /**
     * Check whether the user has opted out of data tracking and cookies/localstorage for the given token
     * @param {string} token - Mixpanel project tracking token
     * @param {Object} [options]
     * @param {string} [options.persistenceType] Persistence mechanism used - cookie or localStorage
     * @param {string} [options.persistencePrefix=__mp_opt_in_out] - custom prefix to be used in the cookie/localstorage name
     * @param {boolean} [options.ignoreDnt] - flag to ignore browser DNT settings and always return false
     * @returns {boolean} whether the user has opted out of the given opt type
     */
    function hasOptedOut(token, options) {
        if (_hasDoNotTrackFlagOn(options)) {
            console$1.warn('This browser has "Do Not Track" enabled. This will prevent the Mixpanel SDK from sending any data. To ignore the "Do Not Track" browser setting, initialize the Mixpanel instance with the config "ignore_dnt: true"');
            return true;
        }
        var optedOut = _getStorageValue(token, options) === '0';
        if (optedOut) {
            console$1.warn('You are opted out of Mixpanel tracking. This will prevent the Mixpanel SDK from sending any data.');
        }
        return optedOut;
    }

    /**
     * Wrap a MixpanelLib method with a check for whether the user is opted out of data tracking and cookies/localstorage for the given token
     * If the user has opted out, return early instead of executing the method.
     * If a callback argument was provided, execute it passing the 0 error code.
     * @param {function} method - wrapped method to be executed if the user has not opted out
     * @returns {*} the result of executing method OR undefined if the user has opted out
     */
    function addOptOutCheckMixpanelLib(method) {
        return _addOptOutCheck(method, function(name) {
            return this.get_config(name);
        });
    }

    /**
     * Wrap a MixpanelPeople method with a check for whether the user is opted out of data tracking and cookies/localstorage for the given token
     * If the user has opted out, return early instead of executing the method.
     * If a callback argument was provided, execute it passing the 0 error code.
     * @param {function} method - wrapped method to be executed if the user has not opted out
     * @returns {*} the result of executing method OR undefined if the user has opted out
     */
    function addOptOutCheckMixpanelPeople(method) {
        return _addOptOutCheck(method, function(name) {
            return this._get_config(name);
        });
    }

    /**
     * Wrap a MixpanelGroup method with a check for whether the user is opted out of data tracking and cookies/localstorage for the given token
     * If the user has opted out, return early instead of executing the method.
     * If a callback argument was provided, execute it passing the 0 error code.
     * @param {function} method - wrapped method to be executed if the user has not opted out
     * @returns {*} the result of executing method OR undefined if the user has opted out
     */
    function addOptOutCheckMixpanelGroup(method) {
        return _addOptOutCheck(method, function(name) {
            return this._get_config(name);
        });
    }

    /**
     * Clear the user's opt in/out status of data tracking and cookies/localstorage for the given token
     * @param {string} token - Mixpanel project tracking token
     * @param {Object} [options]
     * @param {string} [options.persistenceType] Persistence mechanism used - cookie or localStorage
     * @param {string} [options.persistencePrefix=__mp_opt_in_out] - custom prefix to be used in the cookie/localstorage name
     * @param {Number} [options.cookieExpiration] - number of days until the opt-in cookie expires
     * @param {string} [options.cookieDomain] - custom cookie domain
     * @param {boolean} [options.crossSiteCookie] - whether the opt-in cookie is set as cross-site-enabled
     * @param {boolean} [options.crossSubdomainCookie] - whether the opt-in cookie is set as cross-subdomain or not
     * @param {boolean} [options.secureCookie] - whether the opt-in cookie is set as secure or not
     */
    function clearOptInOut(token, options) {
        options = options || {};
        _getStorage(options).remove(
            _getStorageKey(token, options), !!options.crossSubdomainCookie, options.cookieDomain
        );
    }

    /** Private **/

    /**
     * Get storage util
     * @param {Object} [options]
     * @param {string} [options.persistenceType]
     * @returns {object} either _.cookie or _.localstorage
     */
    function _getStorage(options) {
        options = options || {};
        return options.persistenceType === 'localStorage' ? _.localStorage : _.cookie;
    }

    /**
     * Get the name of the cookie that is used for the given opt type (tracking, cookie, etc.)
     * @param {string} token - Mixpanel project tracking token
     * @param {Object} [options]
     * @param {string} [options.persistencePrefix=__mp_opt_in_out] - custom prefix to be used in the cookie/localstorage name
     * @returns {string} the name of the cookie for the given opt type
     */
    function _getStorageKey(token, options) {
        options = options || {};
        return (options.persistencePrefix || GDPR_DEFAULT_PERSISTENCE_PREFIX) + token;
    }

    /**
     * Get the value of the cookie that is used for the given opt type (tracking, cookie, etc.)
     * @param {string} token - Mixpanel project tracking token
     * @param {Object} [options]
     * @param {string} [options.persistencePrefix=__mp_opt_in_out] - custom prefix to be used in the cookie/localstorage name
     * @returns {string} the value of the cookie for the given opt type
     */
    function _getStorageValue(token, options) {
        return _getStorage(options).get(_getStorageKey(token, options));
    }

    /**
     * Check whether the user has set the DNT/doNotTrack setting to true in their browser
     * @param {Object} [options]
     * @param {string} [options.window] - alternate window object to check; used to force various DNT settings in browser tests
     * @param {boolean} [options.ignoreDnt] - flag to ignore browser DNT settings and always return false
     * @returns {boolean} whether the DNT setting is true
     */
    function _hasDoNotTrackFlagOn(options) {
        if (options && options.ignoreDnt) {
            return false;
        }
        var win = (options && options.window) || window$1;
        var nav = win['navigator'] || {};
        var hasDntOn = false;

        _.each([
            nav['doNotTrack'], // standard
            nav['msDoNotTrack'],
            win['doNotTrack']
        ], function(dntValue) {
            if (_.includes([true, 1, '1', 'yes'], dntValue)) {
                hasDntOn = true;
            }
        });

        return hasDntOn;
    }

    /**
     * Set cookie/localstorage for the user indicating that they are opted in or out for the given opt type
     * @param {boolean} optValue - whether to opt the user in or out for the given opt type
     * @param {string} token - Mixpanel project tracking token
     * @param {Object} [options]
     * @param {trackFunction} [options.track] - function used for tracking a Mixpanel event to record the opt-in action
     * @param {string} [options.trackEventName] - event name to be used for tracking the opt-in action
     * @param {Object} [options.trackProperties] - set of properties to be tracked along with the opt-in action
     * @param {string} [options.persistencePrefix=__mp_opt_in_out] - custom prefix to be used in the cookie/localstorage name
     * @param {Number} [options.cookieExpiration] - number of days until the opt-in cookie expires
     * @param {string} [options.cookieDomain] - custom cookie domain
     * @param {boolean} [options.crossSiteCookie] - whether the opt-in cookie is set as cross-site-enabled
     * @param {boolean} [options.crossSubdomainCookie] - whether the opt-in cookie is set as cross-subdomain or not
     * @param {boolean} [options.secureCookie] - whether the opt-in cookie is set as secure or not
     */
    function _optInOut(optValue, token, options) {
        if (!_.isString(token) || !token.length) {
            console$1.error('gdpr.' + (optValue ? 'optIn' : 'optOut') + ' called with an invalid token');
            return;
        }

        options = options || {};

        _getStorage(options).set(
            _getStorageKey(token, options),
            optValue ? 1 : 0,
            _.isNumber(options.cookieExpiration) ? options.cookieExpiration : null,
            !!options.crossSubdomainCookie,
            !!options.secureCookie,
            !!options.crossSiteCookie,
            options.cookieDomain
        );

        if (options.track && optValue) { // only track event if opting in (optValue=true)
            options.track(options.trackEventName || '$opt_in', options.trackProperties, {
                'send_immediately': true
            });
        }
    }

    /**
     * Wrap a method with a check for whether the user is opted out of data tracking and cookies/localstorage for the given token
     * If the user has opted out, return early instead of executing the method.
     * If a callback argument was provided, execute it passing the 0 error code.
     * @param {function} method - wrapped method to be executed if the user has not opted out
     * @param {function} getConfigValue - getter function for the Mixpanel API token and other options to be used with opt-out check
     * @returns {*} the result of executing method OR undefined if the user has opted out
     */
    function _addOptOutCheck(method, getConfigValue) {
        return function() {
            var optedOut = false;

            try {
                var token = getConfigValue.call(this, 'token');
                var ignoreDnt = getConfigValue.call(this, 'ignore_dnt');
                var persistenceType = getConfigValue.call(this, 'opt_out_tracking_persistence_type');
                var persistencePrefix = getConfigValue.call(this, 'opt_out_tracking_cookie_prefix');
                var win = getConfigValue.call(this, 'window'); // used to override window during browser tests

                if (token) { // if there was an issue getting the token, continue method execution as normal
                    optedOut = hasOptedOut(token, {
                        ignoreDnt: ignoreDnt,
                        persistenceType: persistenceType,
                        persistencePrefix: persistencePrefix,
                        window: win
                    });
                }
            } catch(err) {
                console$1.error('Unexpected error when checking tracking opt-out status: ' + err);
            }

            if (!optedOut) {
                return method.apply(this, arguments);
            }

            var callback = arguments[arguments.length - 1];
            if (typeof(callback) === 'function') {
                callback(0);
            }

            return;
        };
    }

    /** @const */ var SET_ACTION      = '$set';
    /** @const */ var SET_ONCE_ACTION = '$set_once';
    /** @const */ var UNSET_ACTION    = '$unset';
    /** @const */ var ADD_ACTION      = '$add';
    /** @const */ var APPEND_ACTION   = '$append';
    /** @const */ var UNION_ACTION    = '$union';
    /** @const */ var REMOVE_ACTION   = '$remove';
    /** @const */ var DELETE_ACTION   = '$delete';

    // Common internal methods for mixpanel.people and mixpanel.group APIs.
    // These methods shouldn't involve network I/O.
    var apiActions = {
        set_action: function(prop, to) {
            var data = {};
            var $set = {};
            if (_.isObject(prop)) {
                _.each(prop, function(v, k) {
                    if (!this._is_reserved_property(k)) {
                        $set[k] = v;
                    }
                }, this);
            } else {
                $set[prop] = to;
            }

            data[SET_ACTION] = $set;
            return data;
        },

        unset_action: function(prop) {
            var data = {};
            var $unset = [];
            if (!_.isArray(prop)) {
                prop = [prop];
            }

            _.each(prop, function(k) {
                if (!this._is_reserved_property(k)) {
                    $unset.push(k);
                }
            }, this);

            data[UNSET_ACTION] = $unset;
            return data;
        },

        set_once_action: function(prop, to) {
            var data = {};
            var $set_once = {};
            if (_.isObject(prop)) {
                _.each(prop, function(v, k) {
                    if (!this._is_reserved_property(k)) {
                        $set_once[k] = v;
                    }
                }, this);
            } else {
                $set_once[prop] = to;
            }
            data[SET_ONCE_ACTION] = $set_once;
            return data;
        },

        union_action: function(list_name, values) {
            var data = {};
            var $union = {};
            if (_.isObject(list_name)) {
                _.each(list_name, function(v, k) {
                    if (!this._is_reserved_property(k)) {
                        $union[k] = _.isArray(v) ? v : [v];
                    }
                }, this);
            } else {
                $union[list_name] = _.isArray(values) ? values : [values];
            }
            data[UNION_ACTION] = $union;
            return data;
        },

        append_action: function(list_name, value) {
            var data = {};
            var $append = {};
            if (_.isObject(list_name)) {
                _.each(list_name, function(v, k) {
                    if (!this._is_reserved_property(k)) {
                        $append[k] = v;
                    }
                }, this);
            } else {
                $append[list_name] = value;
            }
            data[APPEND_ACTION] = $append;
            return data;
        },

        remove_action: function(list_name, value) {
            var data = {};
            var $remove = {};
            if (_.isObject(list_name)) {
                _.each(list_name, function(v, k) {
                    if (!this._is_reserved_property(k)) {
                        $remove[k] = v;
                    }
                }, this);
            } else {
                $remove[list_name] = value;
            }
            data[REMOVE_ACTION] = $remove;
            return data;
        },

        delete_action: function() {
            var data = {};
            data[DELETE_ACTION] = '';
            return data;
        }
    };

    /**
     * Mixpanel Group Object
     * @constructor
     */
    var MixpanelGroup = function() {};

    _.extend(MixpanelGroup.prototype, apiActions);

    MixpanelGroup.prototype._init = function(mixpanel_instance, group_key, group_id) {
        this._mixpanel = mixpanel_instance;
        this._group_key = group_key;
        this._group_id = group_id;
    };

    /**
     * Set properties on a group.
     *
     * ### Usage:
     *
     *     mixpanel.get_group('company', 'mixpanel').set('Location', '405 Howard');
     *
     *     // or set multiple properties at once
     *     mixpanel.get_group('company', 'mixpanel').set({
     *          'Location': '405 Howard',
     *          'Founded' : 2009,
     *     });
     *     // properties can be strings, integers, dates, or lists
     *
     * @param {Object|String} prop If a string, this is the name of the property. If an object, this is an associative array of names and values.
     * @param {*} [to] A value to set on the given property name
     * @param {Function} [callback] If provided, the callback will be called after the tracking event
     */
    MixpanelGroup.prototype.set = addOptOutCheckMixpanelGroup(function(prop, to, callback) {
        var data = this.set_action(prop, to);
        if (_.isObject(prop)) {
            callback = to;
        }
        return this._send_request(data, callback);
    });

    /**
     * Set properties on a group, only if they do not yet exist.
     * This will not overwrite previous group property values, unlike
     * group.set().
     *
     * ### Usage:
     *
     *     mixpanel.get_group('company', 'mixpanel').set_once('Location', '405 Howard');
     *
     *     // or set multiple properties at once
     *     mixpanel.get_group('company', 'mixpanel').set_once({
     *          'Location': '405 Howard',
     *          'Founded' : 2009,
     *     });
     *     // properties can be strings, integers, lists or dates
     *
     * @param {Object|String} prop If a string, this is the name of the property. If an object, this is an associative array of names and values.
     * @param {*} [to] A value to set on the given property name
     * @param {Function} [callback] If provided, the callback will be called after the tracking event
     */
    MixpanelGroup.prototype.set_once = addOptOutCheckMixpanelGroup(function(prop, to, callback) {
        var data = this.set_once_action(prop, to);
        if (_.isObject(prop)) {
            callback = to;
        }
        return this._send_request(data, callback);
    });

    /**
     * Unset properties on a group permanently.
     *
     * ### Usage:
     *
     *     mixpanel.get_group('company', 'mixpanel').unset('Founded');
     *
     * @param {String} prop The name of the property.
     * @param {Function} [callback] If provided, the callback will be called after the tracking event
     */
    MixpanelGroup.prototype.unset = addOptOutCheckMixpanelGroup(function(prop, callback) {
        var data = this.unset_action(prop);
        return this._send_request(data, callback);
    });

    /**
     * Merge a given list with a list-valued group property, excluding duplicate values.
     *
     * ### Usage:
     *
     *     // merge a value to a list, creating it if needed
     *     mixpanel.get_group('company', 'mixpanel').union('Location', ['San Francisco', 'London']);
     *
     * @param {String} list_name Name of the property.
     * @param {Array} values Values to merge with the given property
     * @param {Function} [callback] If provided, the callback will be called after the tracking event
     */
    MixpanelGroup.prototype.union = addOptOutCheckMixpanelGroup(function(list_name, values, callback) {
        if (_.isObject(list_name)) {
            callback = values;
        }
        var data = this.union_action(list_name, values);
        return this._send_request(data, callback);
    });

    /**
     * Permanently delete a group.
     *
     * ### Usage:
     *
     *     mixpanel.get_group('company', 'mixpanel').delete();
     *
     * @param {Function} [callback] If provided, the callback will be called after the tracking event
     */
    MixpanelGroup.prototype['delete'] = addOptOutCheckMixpanelGroup(function(callback) {
        // bracket notation above prevents a minification error related to reserved words
        var data = this.delete_action();
        return this._send_request(data, callback);
    });

    /**
     * Remove a property from a group. The value will be ignored if doesn't exist.
     *
     * ### Usage:
     *
     *     mixpanel.get_group('company', 'mixpanel').remove('Location', 'London');
     *
     * @param {String} list_name Name of the property.
     * @param {Object} value Value to remove from the given group property
     * @param {Function} [callback] If provided, the callback will be called after the tracking event
     */
    MixpanelGroup.prototype.remove = addOptOutCheckMixpanelGroup(function(list_name, value, callback) {
        var data = this.remove_action(list_name, value);
        return this._send_request(data, callback);
    });

    MixpanelGroup.prototype._send_request = function(data, callback) {
        data['$group_key'] = this._group_key;
        data['$group_id'] = this._group_id;
        data['$token'] = this._get_config('token');

        var date_encoded_data = _.encodeDates(data);
        return this._mixpanel._track_or_batch({
            type: 'groups',
            data: date_encoded_data,
            endpoint: this._get_config('api_host') + '/' +  this._get_config('api_routes')['groups'],
            batcher: this._mixpanel.request_batchers.groups
        }, callback);
    };

    MixpanelGroup.prototype._is_reserved_property = function(prop) {
        return prop === '$group_key' || prop === '$group_id';
    };

    MixpanelGroup.prototype._get_config = function(conf) {
        return this._mixpanel.get_config(conf);
    };

    MixpanelGroup.prototype.toString = function() {
        return this._mixpanel.toString() + '.group.' + this._group_key + '.' + this._group_id;
    };

    // MixpanelGroup Exports
    MixpanelGroup.prototype['remove']   = MixpanelGroup.prototype.remove;
    MixpanelGroup.prototype['set']      = MixpanelGroup.prototype.set;
    MixpanelGroup.prototype['set_once'] = MixpanelGroup.prototype.set_once;
    MixpanelGroup.prototype['union']    = MixpanelGroup.prototype.union;
    MixpanelGroup.prototype['unset']    = MixpanelGroup.prototype.unset;
    MixpanelGroup.prototype['toString'] = MixpanelGroup.prototype.toString;

    /**
     * Mixpanel People Object
     * @constructor
     */
    var MixpanelPeople = function() {};

    _.extend(MixpanelPeople.prototype, apiActions);

    MixpanelPeople.prototype._init = function(mixpanel_instance) {
        this._mixpanel = mixpanel_instance;
    };

    /*
    * Set properties on a user record.
    *
    * ### Usage:
    *
    *     mixpanel.people.set('gender', 'm');
    *
    *     // or set multiple properties at once
    *     mixpanel.people.set({
    *         'Company': 'Acme',
    *         'Plan': 'Premium',
    *         'Upgrade date': new Date()
    *     });
    *     // properties can be strings, integers, dates, or lists
    *
    * @param {Object|String} prop If a string, this is the name of the property. If an object, this is an associative array of names and values.
    * @param {*} [to] A value to set on the given property name
    * @param {Function} [callback] If provided, the callback will be called after tracking the event.
    */
    MixpanelPeople.prototype.set = addOptOutCheckMixpanelPeople(function(prop, to, callback) {
        var data = this.set_action(prop, to);
        if (_.isObject(prop)) {
            callback = to;
        }
        // make sure that the referrer info has been updated and saved
        if (this._get_config('save_referrer')) {
            this._mixpanel['persistence'].update_referrer_info(document.referrer);
        }

        // update $set object with default people properties
        data[SET_ACTION] = _.extend(
            {},
            _.info.people_properties(),
            data[SET_ACTION]
        );
        return this._send_request(data, callback);
    });

    /*
    * Set properties on a user record, only if they do not yet exist.
    * This will not overwrite previous people property values, unlike
    * people.set().
    *
    * ### Usage:
    *
    *     mixpanel.people.set_once('First Login Date', new Date());
    *
    *     // or set multiple properties at once
    *     mixpanel.people.set_once({
    *         'First Login Date': new Date(),
    *         'Starting Plan': 'Premium'
    *     });
    *
    *     // properties can be strings, integers or dates
    *
    * @param {Object|String} prop If a string, this is the name of the property. If an object, this is an associative array of names and values.
    * @param {*} [to] A value to set on the given property name
    * @param {Function} [callback] If provided, the callback will be called after tracking the event.
    */
    MixpanelPeople.prototype.set_once = addOptOutCheckMixpanelPeople(function(prop, to, callback) {
        var data = this.set_once_action(prop, to);
        if (_.isObject(prop)) {
            callback = to;
        }
        return this._send_request(data, callback);
    });

    /*
    * Unset properties on a user record (permanently removes the properties and their values from a profile).
    *
    * ### Usage:
    *
    *     mixpanel.people.unset('gender');
    *
    *     // or unset multiple properties at once
    *     mixpanel.people.unset(['gender', 'Company']);
    *
    * @param {Array|String} prop If a string, this is the name of the property. If an array, this is a list of property names.
    * @param {Function} [callback] If provided, the callback will be called after tracking the event.
    */
    MixpanelPeople.prototype.unset = addOptOutCheckMixpanelPeople(function(prop, callback) {
        var data = this.unset_action(prop);
        return this._send_request(data, callback);
    });

    /*
    * Increment/decrement numeric people analytics properties.
    *
    * ### Usage:
    *
    *     mixpanel.people.increment('page_views', 1);
    *
    *     // or, for convenience, if you're just incrementing a counter by
    *     // 1, you can simply do
    *     mixpanel.people.increment('page_views');
    *
    *     // to decrement a counter, pass a negative number
    *     mixpanel.people.increment('credits_left', -1);
    *
    *     // like mixpanel.people.set(), you can increment multiple
    *     // properties at once:
    *     mixpanel.people.increment({
    *         counter1: 1,
    *         counter2: 6
    *     });
    *
    * @param {Object|String} prop If a string, this is the name of the property. If an object, this is an associative array of names and numeric values.
    * @param {Number} [by] An amount to increment the given property
    * @param {Function} [callback] If provided, the callback will be called after tracking the event.
    */
    MixpanelPeople.prototype.increment = addOptOutCheckMixpanelPeople(function(prop, by, callback) {
        var data = {};
        var $add = {};
        if (_.isObject(prop)) {
            _.each(prop, function(v, k) {
                if (!this._is_reserved_property(k)) {
                    if (isNaN(parseFloat(v))) {
                        console$1.error('Invalid increment value passed to mixpanel.people.increment - must be a number');
                        return;
                    } else {
                        $add[k] = v;
                    }
                }
            }, this);
            callback = by;
        } else {
            // convenience: mixpanel.people.increment('property'); will
            // increment 'property' by 1
            if (_.isUndefined(by)) {
                by = 1;
            }
            $add[prop] = by;
        }
        data[ADD_ACTION] = $add;

        return this._send_request(data, callback);
    });

    /*
    * Append a value to a list-valued people analytics property.
    *
    * ### Usage:
    *
    *     // append a value to a list, creating it if needed
    *     mixpanel.people.append('pages_visited', 'homepage');
    *
    *     // like mixpanel.people.set(), you can append multiple
    *     // properties at once:
    *     mixpanel.people.append({
    *         list1: 'bob',
    *         list2: 123
    *     });
    *
    * @param {Object|String} list_name If a string, this is the name of the property. If an object, this is an associative array of names and values.
    * @param {*} [value] value An item to append to the list
    * @param {Function} [callback] If provided, the callback will be called after tracking the event.
    */
    MixpanelPeople.prototype.append = addOptOutCheckMixpanelPeople(function(list_name, value, callback) {
        if (_.isObject(list_name)) {
            callback = value;
        }
        var data = this.append_action(list_name, value);
        return this._send_request(data, callback);
    });

    /*
    * Remove a value from a list-valued people analytics property.
    *
    * ### Usage:
    *
    *     mixpanel.people.remove('School', 'UCB');
    *
    * @param {Object|String} list_name If a string, this is the name of the property. If an object, this is an associative array of names and values.
    * @param {*} [value] value Item to remove from the list
    * @param {Function} [callback] If provided, the callback will be called after tracking the event.
    */
    MixpanelPeople.prototype.remove = addOptOutCheckMixpanelPeople(function(list_name, value, callback) {
        if (_.isObject(list_name)) {
            callback = value;
        }
        var data = this.remove_action(list_name, value);
        return this._send_request(data, callback);
    });

    /*
    * Merge a given list with a list-valued people analytics property,
    * excluding duplicate values.
    *
    * ### Usage:
    *
    *     // merge a value to a list, creating it if needed
    *     mixpanel.people.union('pages_visited', 'homepage');
    *
    *     // like mixpanel.people.set(), you can append multiple
    *     // properties at once:
    *     mixpanel.people.union({
    *         list1: 'bob',
    *         list2: 123
    *     });
    *
    *     // like mixpanel.people.append(), you can append multiple
    *     // values to the same list:
    *     mixpanel.people.union({
    *         list1: ['bob', 'billy']
    *     });
    *
    * @param {Object|String} list_name If a string, this is the name of the property. If an object, this is an associative array of names and values.
    * @param {*} [value] Value / values to merge with the given property
    * @param {Function} [callback] If provided, the callback will be called after tracking the event.
    */
    MixpanelPeople.prototype.union = addOptOutCheckMixpanelPeople(function(list_name, values, callback) {
        if (_.isObject(list_name)) {
            callback = values;
        }
        var data = this.union_action(list_name, values);
        return this._send_request(data, callback);
    });

    /*
     * Record that you have charged the current user a certain amount
     * of money. Charges recorded with track_charge() will appear in the
     * Mixpanel revenue report.
     *
     * ### Usage:
     *
     *     // charge a user $50
     *     mixpanel.people.track_charge(50);
     *
     *     // charge a user $30.50 on the 2nd of january
     *     mixpanel.people.track_charge(30.50, {
     *         '$time': new Date('jan 1 2012')
     *     });
     *
     * @param {Number} amount The amount of money charged to the current user
     * @param {Object} [properties] An associative array of properties associated with the charge
     * @param {Function} [callback] If provided, the callback will be called when the server responds
     * @deprecated
     */
    MixpanelPeople.prototype.track_charge = addOptOutCheckMixpanelPeople(function(amount, properties, callback) {
        if (!_.isNumber(amount)) {
            amount = parseFloat(amount);
            if (isNaN(amount)) {
                console$1.error('Invalid value passed to mixpanel.people.track_charge - must be a number');
                return;
            }
        }

        return this.append('$transactions', _.extend({
            '$amount': amount
        }, properties), callback);
    });

    /*
     * Permanently clear all revenue report transactions from the
     * current user's people analytics profile.
     *
     * ### Usage:
     *
     *     mixpanel.people.clear_charges();
     *
     * @param {Function} [callback] If provided, the callback will be called after tracking the event.
     * @deprecated
     */
    MixpanelPeople.prototype.clear_charges = function(callback) {
        return this.set('$transactions', [], callback);
    };

    /*
    * Permanently deletes the current people analytics profile from
    * Mixpanel (using the current distinct_id).
    *
    * ### Usage:
    *
    *     // remove the all data you have stored about the current user
    *     mixpanel.people.delete_user();
    *
    */
    MixpanelPeople.prototype.delete_user = function() {
        if (!this._identify_called()) {
            console$1.error('mixpanel.people.delete_user() requires you to call identify() first');
            return;
        }
        var data = {'$delete': this._mixpanel.get_distinct_id()};
        return this._send_request(data);
    };

    MixpanelPeople.prototype.toString = function() {
        return this._mixpanel.toString() + '.people';
    };

    MixpanelPeople.prototype._send_request = function(data, callback) {
        data['$token'] = this._get_config('token');
        data['$distinct_id'] = this._mixpanel.get_distinct_id();
        var device_id = this._mixpanel.get_property('$device_id');
        var user_id = this._mixpanel.get_property('$user_id');
        var had_persisted_distinct_id = this._mixpanel.get_property('$had_persisted_distinct_id');
        if (device_id) {
            data['$device_id'] = device_id;
        }
        if (user_id) {
            data['$user_id'] = user_id;
        }
        if (had_persisted_distinct_id) {
            data['$had_persisted_distinct_id'] = had_persisted_distinct_id;
        }

        var date_encoded_data = _.encodeDates(data);

        if (!this._identify_called()) {
            this._enqueue(data);
            if (!_.isUndefined(callback)) {
                if (this._get_config('verbose')) {
                    callback({status: -1, error: null});
                } else {
                    callback(-1);
                }
            }
            return _.truncate(date_encoded_data, 255);
        }

        return this._mixpanel._track_or_batch({
            type: 'people',
            data: date_encoded_data,
            endpoint: this._get_config('api_host') + '/' +  this._get_config('api_routes')['engage'],
            batcher: this._mixpanel.request_batchers.people
        }, callback);
    };

    MixpanelPeople.prototype._get_config = function(conf_var) {
        return this._mixpanel.get_config(conf_var);
    };

    MixpanelPeople.prototype._identify_called = function() {
        return this._mixpanel._flags.identify_called === true;
    };

    // Queue up engage operations if identify hasn't been called yet.
    MixpanelPeople.prototype._enqueue = function(data) {
        if (SET_ACTION in data) {
            this._mixpanel['persistence']._add_to_people_queue(SET_ACTION, data);
        } else if (SET_ONCE_ACTION in data) {
            this._mixpanel['persistence']._add_to_people_queue(SET_ONCE_ACTION, data);
        } else if (UNSET_ACTION in data) {
            this._mixpanel['persistence']._add_to_people_queue(UNSET_ACTION, data);
        } else if (ADD_ACTION in data) {
            this._mixpanel['persistence']._add_to_people_queue(ADD_ACTION, data);
        } else if (APPEND_ACTION in data) {
            this._mixpanel['persistence']._add_to_people_queue(APPEND_ACTION, data);
        } else if (REMOVE_ACTION in data) {
            this._mixpanel['persistence']._add_to_people_queue(REMOVE_ACTION, data);
        } else if (UNION_ACTION in data) {
            this._mixpanel['persistence']._add_to_people_queue(UNION_ACTION, data);
        } else {
            console$1.error('Invalid call to _enqueue():', data);
        }
    };

    MixpanelPeople.prototype._flush_one_queue = function(action, action_method, callback, queue_to_params_fn) {
        var _this = this;
        var queued_data = _.extend({}, this._mixpanel['persistence'].load_queue(action));
        var action_params = queued_data;

        if (!_.isUndefined(queued_data) && _.isObject(queued_data) && !_.isEmptyObject(queued_data)) {
            _this._mixpanel['persistence']._pop_from_people_queue(action, queued_data);
            _this._mixpanel['persistence'].save();
            if (queue_to_params_fn) {
                action_params = queue_to_params_fn(queued_data);
            }
            action_method.call(_this, action_params, function(response, data) {
                // on bad response, we want to add it back to the queue
                if (response === 0) {
                    _this._mixpanel['persistence']._add_to_people_queue(action, queued_data);
                }
                if (!_.isUndefined(callback)) {
                    callback(response, data);
                }
            });
        }
    };

    // Flush queued engage operations - order does not matter,
    // and there are network level race conditions anyway
    MixpanelPeople.prototype._flush = function(
        _set_callback, _add_callback, _append_callback, _set_once_callback, _union_callback, _unset_callback, _remove_callback
    ) {
        var _this = this;

        this._flush_one_queue(SET_ACTION, this.set, _set_callback);
        this._flush_one_queue(SET_ONCE_ACTION, this.set_once, _set_once_callback);
        this._flush_one_queue(UNSET_ACTION, this.unset, _unset_callback, function(queue) { return _.keys(queue); });
        this._flush_one_queue(ADD_ACTION, this.increment, _add_callback);
        this._flush_one_queue(UNION_ACTION, this.union, _union_callback);

        // we have to fire off each $append individually since there is
        // no concat method server side
        var $append_queue = this._mixpanel['persistence'].load_queue(APPEND_ACTION);
        if (!_.isUndefined($append_queue) && _.isArray($append_queue) && $append_queue.length) {
            var $append_item;
            var append_callback = function(response, data) {
                if (response === 0) {
                    _this._mixpanel['persistence']._add_to_people_queue(APPEND_ACTION, $append_item);
                }
                if (!_.isUndefined(_append_callback)) {
                    _append_callback(response, data);
                }
            };
            for (var i = $append_queue.length - 1; i >= 0; i--) {
                $append_queue = this._mixpanel['persistence'].load_queue(APPEND_ACTION);
                $append_item = $append_queue.pop();
                _this._mixpanel['persistence'].save();
                if (!_.isEmptyObject($append_item)) {
                    _this.append($append_item, append_callback);
                }
            }
        }

        // same for $remove
        var $remove_queue = this._mixpanel['persistence'].load_queue(REMOVE_ACTION);
        if (!_.isUndefined($remove_queue) && _.isArray($remove_queue) && $remove_queue.length) {
            var $remove_item;
            var remove_callback = function(response, data) {
                if (response === 0) {
                    _this._mixpanel['persistence']._add_to_people_queue(REMOVE_ACTION, $remove_item);
                }
                if (!_.isUndefined(_remove_callback)) {
                    _remove_callback(response, data);
                }
            };
            for (var j = $remove_queue.length - 1; j >= 0; j--) {
                $remove_queue = this._mixpanel['persistence'].load_queue(REMOVE_ACTION);
                $remove_item = $remove_queue.pop();
                _this._mixpanel['persistence'].save();
                if (!_.isEmptyObject($remove_item)) {
                    _this.remove($remove_item, remove_callback);
                }
            }
        }
    };

    MixpanelPeople.prototype._is_reserved_property = function(prop) {
        return prop === '$distinct_id' || prop === '$token' || prop === '$device_id' || prop === '$user_id' || prop === '$had_persisted_distinct_id';
    };

    // MixpanelPeople Exports
    MixpanelPeople.prototype['set']           = MixpanelPeople.prototype.set;
    MixpanelPeople.prototype['set_once']      = MixpanelPeople.prototype.set_once;
    MixpanelPeople.prototype['unset']         = MixpanelPeople.prototype.unset;
    MixpanelPeople.prototype['increment']     = MixpanelPeople.prototype.increment;
    MixpanelPeople.prototype['append']        = MixpanelPeople.prototype.append;
    MixpanelPeople.prototype['remove']        = MixpanelPeople.prototype.remove;
    MixpanelPeople.prototype['union']         = MixpanelPeople.prototype.union;
    MixpanelPeople.prototype['track_charge']  = MixpanelPeople.prototype.track_charge;
    MixpanelPeople.prototype['clear_charges'] = MixpanelPeople.prototype.clear_charges;
    MixpanelPeople.prototype['delete_user']   = MixpanelPeople.prototype.delete_user;
    MixpanelPeople.prototype['toString']      = MixpanelPeople.prototype.toString;

    /*
     * Constants
     */
    /** @const */ var SET_QUEUE_KEY          = '__mps';
    /** @const */ var SET_ONCE_QUEUE_KEY     = '__mpso';
    /** @const */ var UNSET_QUEUE_KEY        = '__mpus';
    /** @const */ var ADD_QUEUE_KEY          = '__mpa';
    /** @const */ var APPEND_QUEUE_KEY       = '__mpap';
    /** @const */ var REMOVE_QUEUE_KEY       = '__mpr';
    /** @const */ var UNION_QUEUE_KEY        = '__mpu';
    // This key is deprecated, but we want to check for it to see whether aliasing is allowed.
    /** @const */ var PEOPLE_DISTINCT_ID_KEY = '$people_distinct_id';
    /** @const */ var ALIAS_ID_KEY           = '__alias';
    /** @const */ var EVENT_TIMERS_KEY       = '__timers';
    /** @const */ var RESERVED_PROPERTIES = [
        SET_QUEUE_KEY,
        SET_ONCE_QUEUE_KEY,
        UNSET_QUEUE_KEY,
        ADD_QUEUE_KEY,
        APPEND_QUEUE_KEY,
        REMOVE_QUEUE_KEY,
        UNION_QUEUE_KEY,
        PEOPLE_DISTINCT_ID_KEY,
        ALIAS_ID_KEY,
        EVENT_TIMERS_KEY
    ];

    /**
     * Mixpanel Persistence Object
     * @constructor
     */
    var MixpanelPersistence = function(config) {
        this['props'] = {};
        this.campaign_params_saved = false;

        if (config['persistence_name']) {
            this.name = 'mp_' + config['persistence_name'];
        } else {
            this.name = 'mp_' + config['token'] + '_mixpanel';
        }

        var storage_type = config['persistence'];
        if (storage_type !== 'cookie' && storage_type !== 'localStorage') {
            console$1.critical('Unknown persistence type ' + storage_type + '; falling back to cookie');
            storage_type = config['persistence'] = 'cookie';
        }

        if (storage_type === 'localStorage' && _.localStorage.is_supported()) {
            this.storage = _.localStorage;
        } else {
            this.storage = _.cookie;
        }

        this.load();
        this.update_config(config);
        this.upgrade(config);
        this.save();
    };

    MixpanelPersistence.prototype.properties = function() {
        var p = {};

        this.load();

        // Filter out reserved properties
        _.each(this['props'], function(v, k) {
            if (!_.include(RESERVED_PROPERTIES, k)) {
                p[k] = v;
            }
        });
        return p;
    };

    MixpanelPersistence.prototype.load = function() {
        if (this.disabled) { return; }

        var entry = this.storage.parse(this.name);

        if (entry) {
            this['props'] = _.extend({}, entry);
        }
    };

    MixpanelPersistence.prototype.upgrade = function(config) {
        var upgrade_from_old_lib = config['upgrade'],
            old_cookie_name,
            old_cookie;

        if (upgrade_from_old_lib) {
            old_cookie_name = 'mp_super_properties';
            // Case where they had a custom cookie name before.
            if (typeof(upgrade_from_old_lib) === 'string') {
                old_cookie_name = upgrade_from_old_lib;
            }

            old_cookie = this.storage.parse(old_cookie_name);

            // remove the cookie
            this.storage.remove(old_cookie_name);
            this.storage.remove(old_cookie_name, true);

            if (old_cookie) {
                this['props'] = _.extend(
                    this['props'],
                    old_cookie['all'],
                    old_cookie['events']
                );
            }
        }

        if (!config['cookie_name'] && config['name'] !== 'mixpanel') {
            // special case to handle people with cookies of the form
            // mp_TOKEN_INSTANCENAME from the first release of this library
            old_cookie_name = 'mp_' + config['token'] + '_' + config['name'];
            old_cookie = this.storage.parse(old_cookie_name);

            if (old_cookie) {
                this.storage.remove(old_cookie_name);
                this.storage.remove(old_cookie_name, true);

                // Save the prop values that were in the cookie from before -
                // this should only happen once as we delete the old one.
                this.register_once(old_cookie);
            }
        }

        if (this.storage === _.localStorage) {
            old_cookie = _.cookie.parse(this.name);

            _.cookie.remove(this.name);
            _.cookie.remove(this.name, true);

            if (old_cookie) {
                this.register_once(old_cookie);
            }
        }
    };

    MixpanelPersistence.prototype.save = function() {
        if (this.disabled) { return; }

        this.storage.set(
            this.name,
            _.JSONEncode(this['props']),
            this.expire_days,
            this.cross_subdomain,
            this.secure,
            this.cross_site,
            this.cookie_domain
        );
    };

    MixpanelPersistence.prototype.load_prop = function(key) {
        this.load();
        return this['props'][key];
    };

    MixpanelPersistence.prototype.remove = function() {
        // remove both domain and subdomain cookies
        this.storage.remove(this.name, false, this.cookie_domain);
        this.storage.remove(this.name, true, this.cookie_domain);
    };

    // removes the storage entry and deletes all loaded data
    // forced name for tests
    MixpanelPersistence.prototype.clear = function() {
        this.remove();
        this['props'] = {};
    };

    /**
    * @param {Object} props
    * @param {*=} default_value
    * @param {number=} days
    */
    MixpanelPersistence.prototype.register_once = function(props, default_value, days) {
        if (_.isObject(props)) {
            if (typeof(default_value) === 'undefined') { default_value = 'None'; }
            this.expire_days = (typeof(days) === 'undefined') ? this.default_expiry : days;

            this.load();

            _.each(props, function(val, prop) {
                if (!this['props'].hasOwnProperty(prop) || this['props'][prop] === default_value) {
                    this['props'][prop] = val;
                }
            }, this);

            this.save();

            return true;
        }
        return false;
    };

    /**
    * @param {Object} props
    * @param {number=} days
    */
    MixpanelPersistence.prototype.register = function(props, days) {
        if (_.isObject(props)) {
            this.expire_days = (typeof(days) === 'undefined') ? this.default_expiry : days;

            this.load();
            _.extend(this['props'], props);
            this.save();

            return true;
        }
        return false;
    };

    MixpanelPersistence.prototype.unregister = function(prop) {
        this.load();
        if (prop in this['props']) {
            delete this['props'][prop];
            this.save();
        }
    };

    MixpanelPersistence.prototype.update_search_keyword = function(referrer) {
        this.register(_.info.searchInfo(referrer));
    };

    // EXPORTED METHOD, we test this directly.
    MixpanelPersistence.prototype.update_referrer_info = function(referrer) {
        // If referrer doesn't exist, we want to note the fact that it was type-in traffic.
        this.register_once({
            '$initial_referrer': referrer || '$direct',
            '$initial_referring_domain': _.info.referringDomain(referrer) || '$direct'
        }, '');
    };

    MixpanelPersistence.prototype.get_referrer_info = function() {
        return _.strip_empty_properties({
            '$initial_referrer': this['props']['$initial_referrer'],
            '$initial_referring_domain': this['props']['$initial_referring_domain']
        });
    };

    MixpanelPersistence.prototype.update_config = function(config) {
        this.default_expiry = this.expire_days = config['cookie_expiration'];
        this.set_disabled(config['disable_persistence']);
        this.set_cookie_domain(config['cookie_domain']);
        this.set_cross_site(config['cross_site_cookie']);
        this.set_cross_subdomain(config['cross_subdomain_cookie']);
        this.set_secure(config['secure_cookie']);
    };

    MixpanelPersistence.prototype.set_disabled = function(disabled) {
        this.disabled = disabled;
        if (this.disabled) {
            this.remove();
        } else {
            this.save();
        }
    };

    MixpanelPersistence.prototype.set_cookie_domain = function(cookie_domain) {
        if (cookie_domain !== this.cookie_domain) {
            this.remove();
            this.cookie_domain = cookie_domain;
            this.save();
        }
    };

    MixpanelPersistence.prototype.set_cross_site = function(cross_site) {
        if (cross_site !== this.cross_site) {
            this.cross_site = cross_site;
            this.remove();
            this.save();
        }
    };

    MixpanelPersistence.prototype.set_cross_subdomain = function(cross_subdomain) {
        if (cross_subdomain !== this.cross_subdomain) {
            this.cross_subdomain = cross_subdomain;
            this.remove();
            this.save();
        }
    };

    MixpanelPersistence.prototype.get_cross_subdomain = function() {
        return this.cross_subdomain;
    };

    MixpanelPersistence.prototype.set_secure = function(secure) {
        if (secure !== this.secure) {
            this.secure = secure ? true : false;
            this.remove();
            this.save();
        }
    };

    MixpanelPersistence.prototype._add_to_people_queue = function(queue, data) {
        var q_key = this._get_queue_key(queue),
            q_data = data[queue],
            set_q = this._get_or_create_queue(SET_ACTION),
            set_once_q = this._get_or_create_queue(SET_ONCE_ACTION),
            unset_q = this._get_or_create_queue(UNSET_ACTION),
            add_q = this._get_or_create_queue(ADD_ACTION),
            union_q = this._get_or_create_queue(UNION_ACTION),
            remove_q = this._get_or_create_queue(REMOVE_ACTION, []),
            append_q = this._get_or_create_queue(APPEND_ACTION, []);

        if (q_key === SET_QUEUE_KEY) {
            // Update the set queue - we can override any existing values
            _.extend(set_q, q_data);
            // if there was a pending increment, override it
            // with the set.
            this._pop_from_people_queue(ADD_ACTION, q_data);
            // if there was a pending union, override it
            // with the set.
            this._pop_from_people_queue(UNION_ACTION, q_data);
            this._pop_from_people_queue(UNSET_ACTION, q_data);
        } else if (q_key === SET_ONCE_QUEUE_KEY) {
            // only queue the data if there is not already a set_once call for it.
            _.each(q_data, function(v, k) {
                if (!(k in set_once_q)) {
                    set_once_q[k] = v;
                }
            });
            this._pop_from_people_queue(UNSET_ACTION, q_data);
        } else if (q_key === UNSET_QUEUE_KEY) {
            _.each(q_data, function(prop) {

                // undo previously-queued actions on this key
                _.each([set_q, set_once_q, add_q, union_q], function(enqueued_obj) {
                    if (prop in enqueued_obj) {
                        delete enqueued_obj[prop];
                    }
                });
                _.each(append_q, function(append_obj) {
                    if (prop in append_obj) {
                        delete append_obj[prop];
                    }
                });

                unset_q[prop] = true;

            });
        } else if (q_key === ADD_QUEUE_KEY) {
            _.each(q_data, function(v, k) {
                // If it exists in the set queue, increment
                // the value
                if (k in set_q) {
                    set_q[k] += v;
                } else {
                    // If it doesn't exist, update the add
                    // queue
                    if (!(k in add_q)) {
                        add_q[k] = 0;
                    }
                    add_q[k] += v;
                }
            }, this);
            this._pop_from_people_queue(UNSET_ACTION, q_data);
        } else if (q_key === UNION_QUEUE_KEY) {
            _.each(q_data, function(v, k) {
                if (_.isArray(v)) {
                    if (!(k in union_q)) {
                        union_q[k] = [];
                    }
                    // We may send duplicates, the server will dedup them.
                    union_q[k] = union_q[k].concat(v);
                }
            });
            this._pop_from_people_queue(UNSET_ACTION, q_data);
        } else if (q_key === REMOVE_QUEUE_KEY) {
            remove_q.push(q_data);
            this._pop_from_people_queue(APPEND_ACTION, q_data);
        } else if (q_key === APPEND_QUEUE_KEY) {
            append_q.push(q_data);
            this._pop_from_people_queue(UNSET_ACTION, q_data);
        }

        console$1.log('MIXPANEL PEOPLE REQUEST (QUEUED, PENDING IDENTIFY):');
        console$1.log(data);

        this.save();
    };

    MixpanelPersistence.prototype._pop_from_people_queue = function(queue, data) {
        var q = this['props'][this._get_queue_key(queue)];
        if (!_.isUndefined(q)) {
            _.each(data, function(v, k) {
                if (queue === APPEND_ACTION || queue === REMOVE_ACTION) {
                    // list actions: only remove if both k+v match
                    // e.g. remove should not override append in a case like
                    // append({foo: 'bar'}); remove({foo: 'qux'})
                    _.each(q, function(queued_action) {
                        if (queued_action[k] === v) {
                            delete queued_action[k];
                        }
                    });
                } else {
                    delete q[k];
                }
            }, this);
        }
    };

    MixpanelPersistence.prototype.load_queue = function(queue) {
        return this.load_prop(this._get_queue_key(queue));
    };

    MixpanelPersistence.prototype._get_queue_key = function(queue) {
        if (queue === SET_ACTION) {
            return SET_QUEUE_KEY;
        } else if (queue === SET_ONCE_ACTION) {
            return SET_ONCE_QUEUE_KEY;
        } else if (queue === UNSET_ACTION) {
            return UNSET_QUEUE_KEY;
        } else if (queue === ADD_ACTION) {
            return ADD_QUEUE_KEY;
        } else if (queue === APPEND_ACTION) {
            return APPEND_QUEUE_KEY;
        } else if (queue === REMOVE_ACTION) {
            return REMOVE_QUEUE_KEY;
        } else if (queue === UNION_ACTION) {
            return UNION_QUEUE_KEY;
        } else {
            console$1.error('Invalid queue:', queue);
        }
    };

    MixpanelPersistence.prototype._get_or_create_queue = function(queue, default_val) {
        var key = this._get_queue_key(queue);
        default_val = _.isUndefined(default_val) ? {} : default_val;
        return this['props'][key] || (this['props'][key] = default_val);
    };

    MixpanelPersistence.prototype.set_event_timer = function(event_name, timestamp) {
        var timers = this.load_prop(EVENT_TIMERS_KEY) || {};
        timers[event_name] = timestamp;
        this['props'][EVENT_TIMERS_KEY] = timers;
        this.save();
    };

    MixpanelPersistence.prototype.remove_event_timer = function(event_name) {
        var timers = this.load_prop(EVENT_TIMERS_KEY) || {};
        var timestamp = timers[event_name];
        if (!_.isUndefined(timestamp)) {
            delete this['props'][EVENT_TIMERS_KEY][event_name];
            this.save();
        }
        return timestamp;
    };

    /*
     * Mixpanel JS Library
     *
     * Copyright 2012, Mixpanel, Inc. All Rights Reserved
     * http://mixpanel.com/
     *
     * Includes portions of Underscore.js
     * http://documentcloud.github.com/underscore/
     * (c) 2011 Jeremy Ashkenas, DocumentCloud Inc.
     * Released under the MIT License.
     */

    // ==ClosureCompiler==
    // @compilation_level ADVANCED_OPTIMIZATIONS
    // @output_file_name mixpanel-2.8.min.js
    // ==/ClosureCompiler==

    /*
    SIMPLE STYLE GUIDE:

    this.x === public function
    this._x === internal - only use within this file
    this.__x === private - only use within the class

    Globals should be all caps
    */

    var init_type;       // MODULE or SNIPPET loader
    var mixpanel_master; // main mixpanel instance / object
    var INIT_MODULE  = 0;
    var INIT_SNIPPET = 1;

    var IDENTITY_FUNC = function(x) {return x;};
    var NOOP_FUNC = function() {};

    /** @const */ var PRIMARY_INSTANCE_NAME = 'mixpanel';
    /** @const */ var PAYLOAD_TYPE_BASE64   = 'base64';
    /** @const */ var PAYLOAD_TYPE_JSON     = 'json';
    /** @const */ var DEVICE_ID_PREFIX      = '$device:';


    /*
     * Dynamic... constants? Is that an oxymoron?
     */
    // http://hacks.mozilla.org/2009/07/cross-site-xmlhttprequest-with-cors/
    // https://developer.mozilla.org/en-US/docs/DOM/XMLHttpRequest#withCredentials
    var USE_XHR = (window$1.XMLHttpRequest && 'withCredentials' in new XMLHttpRequest());

    // IE<10 does not support cross-origin XHR's but script tags
    // with defer won't block window.onload; ENQUEUE_REQUESTS
    // should only be true for Opera<12
    var ENQUEUE_REQUESTS = !USE_XHR && (userAgent.indexOf('MSIE') === -1) && (userAgent.indexOf('Mozilla') === -1);

    // save reference to navigator.sendBeacon so it can be minified
    var sendBeacon = null;
    if (navigator['sendBeacon']) {
        sendBeacon = function() {
            // late reference to navigator.sendBeacon to allow patching/spying
            return navigator['sendBeacon'].apply(navigator, arguments);
        };
    }

    var DEFAULT_API_ROUTES = {
        'track': 'track/',
        'engage': 'engage/',
        'groups': 'groups/'
    };

    /*
     * Module-level globals
     */
    var DEFAULT_CONFIG = {
        'api_host':                          'https://api-js.mixpanel.com',
        'api_routes':                        DEFAULT_API_ROUTES,
        'api_method':                        'POST',
        'api_transport':                     'XHR',
        'api_payload_format':                PAYLOAD_TYPE_BASE64,
        'app_host':                          'https://mixpanel.com',
        'cdn':                               'https://cdn.mxpnl.com',
        'cross_site_cookie':                 false,
        'cross_subdomain_cookie':            true,
        'error_reporter':                    NOOP_FUNC,
        'persistence':                       'cookie',
        'persistence_name':                  '',
        'cookie_domain':                     '',
        'cookie_name':                       '',
        'loaded':                            NOOP_FUNC,
        'mp_loader':                         null,
        'track_marketing':                   true,
        'track_pageview':                    false,
        'skip_first_touch_marketing':        false,
        'store_google':                      true,
        'stop_utm_persistence':              false,
        'save_referrer':                     true,
        'test':                              false,
        'verbose':                           false,
        'img':                               false,
        'debug':                             false,
        'track_links_timeout':               300,
        'cookie_expiration':                 365,
        'upgrade':                           false,
        'disable_persistence':               false,
        'disable_cookie':                    false,
        'secure_cookie':                     false,
        'ip':                                true,
        'opt_out_tracking_by_default':       false,
        'opt_out_persistence_by_default':    false,
        'opt_out_tracking_persistence_type': 'localStorage',
        'opt_out_tracking_cookie_prefix':    null,
        'property_blacklist':                [],
        'xhr_headers':                       {}, // { header: value, header2: value }
        'ignore_dnt':                        false,
        'batch_requests':                    true,
        'batch_size':                        50,
        'batch_flush_interval_ms':           5000,
        'batch_request_timeout_ms':          90000,
        'batch_autostart':                   true,
        'hooks':                             {}
    };

    var DOM_LOADED = false;

    /**
     * Mixpanel Library Object
     * @constructor
     */
    var MixpanelLib = function() {};


    /**
     * create_mplib(token:string, config:object, name:string)
     *
     * This function is used by the init method of MixpanelLib objects
     * as well as the main initializer at the end of the JSLib (that
     * initializes document.mixpanel as well as any additional instances
     * declared before this file has loaded).
     */
    var create_mplib = function(token, config, name) {
        var instance,
            target = (name === PRIMARY_INSTANCE_NAME) ? mixpanel_master : mixpanel_master[name];

        if (target && init_type === INIT_MODULE) {
            instance = target;
        } else {
            if (target && !_.isArray(target)) {
                console$1.error('You have already initialized ' + name);
                return;
            }
            instance = new MixpanelLib();
        }

        instance._cached_groups = {}; // cache groups in a pool

        instance._init(token, config, name);

        instance['people'] = new MixpanelPeople();
        instance['people']._init(instance);

        if (!instance.get_config('skip_first_touch_marketing')) {
            // We need null UTM params in the object because
            // UTM parameters act as a tuple. If any UTM param
            // is present, then we set all UTM params including
            // empty ones together
            var utm_params = _.info.campaignParams(null);
            var initial_utm_params = {};
            var has_utm = false;
            _.each(utm_params, function(utm_value, utm_key) {
                initial_utm_params['initial_' + utm_key] = utm_value;
                if (utm_value) {
                    has_utm = true;
                }
            });
            if (has_utm) {
                instance['people'].set_once(initial_utm_params);
            }
        }

        // if any instance on the page has debug = true, we set the
        // global debug to be true
        Config.DEBUG = Config.DEBUG || instance.get_config('debug');

        // if target is not defined, we called init after the lib already
        // loaded, so there won't be an array of things to execute
        if (!_.isUndefined(target) && _.isArray(target)) {
            // Crunch through the people queue first - we queue this data up &
            // flush on identify, so it's better to do all these operations first
            instance._execute_array.call(instance['people'], target['people']);
            instance._execute_array(target);
        }

        return instance;
    };

    // Initialization methods

    /**
     * This function initializes a new instance of the Mixpanel tracking object.
     * All new instances are added to the main mixpanel object as sub properties (such as
     * mixpanel.library_name) and also returned by this function. To define a
     * second instance on the page, you would call:
     *
     *     mixpanel.init('new token', { your: 'config' }, 'library_name');
     *
     * and use it like so:
     *
     *     mixpanel.library_name.track(...);
     *
     * @param {String} token   Your Mixpanel API token
     * @param {Object} [config]  A dictionary of config options to override. <a href="https://github.com/mixpanel/mixpanel-js/blob/v2.46.0/src/mixpanel-core.js#L88-L127">See a list of default config options</a>.
     * @param {String} [name]    The name for the new mixpanel instance that you want created
     */
    MixpanelLib.prototype.init = function (token, config, name) {
        if (_.isUndefined(name)) {
            this.report_error('You must name your new library: init(token, config, name)');
            return;
        }
        if (name === PRIMARY_INSTANCE_NAME) {
            this.report_error('You must initialize the main mixpanel object right after you include the Mixpanel js snippet');
            return;
        }

        var instance = create_mplib(token, config, name);
        mixpanel_master[name] = instance;
        instance._loaded();

        return instance;
    };

    // mixpanel._init(token:string, config:object, name:string)
    //
    // This function sets up the current instance of the mixpanel
    // library.  The difference between this method and the init(...)
    // method is this one initializes the actual instance, whereas the
    // init(...) method sets up a new library and calls _init on it.
    //
    MixpanelLib.prototype._init = function(token, config, name) {
        config = config || {};

        this['__loaded'] = true;
        this['config'] = {};

        var variable_features = {};

        // default to JSON payload for standard mixpanel.com API hosts
        if (!('api_payload_format' in config)) {
            var api_host = config['api_host'] || DEFAULT_CONFIG['api_host'];
            if (api_host.match(/\.mixpanel\.com/)) {
                variable_features['api_payload_format'] = PAYLOAD_TYPE_JSON;
            }
        }

        this.set_config(_.extend({}, DEFAULT_CONFIG, variable_features, config, {
            'name': name,
            'token': token,
            'callback_fn': ((name === PRIMARY_INSTANCE_NAME) ? name : PRIMARY_INSTANCE_NAME + '.' + name) + '._jsc'
        }));

        this['_jsc'] = NOOP_FUNC;

        this.__dom_loaded_queue = [];
        this.__request_queue = [];
        this.__disabled_events = [];
        this._flags = {
            'disable_all_events': false,
            'identify_called': false
        };

        // set up request queueing/batching
        this.request_batchers = {};
        this._batch_requests = this.get_config('batch_requests');
        if (this._batch_requests) {
            if (!_.localStorage.is_supported(true) || !USE_XHR) {
                this._batch_requests = false;
                console$1.log('Turning off Mixpanel request-queueing; needs XHR and localStorage support');
                _.each(this.get_batcher_configs(), function(batcher_config) {
                    console$1.log('Clearing batch queue ' + batcher_config.queue_key);
                    _.localStorage.remove(batcher_config.queue_key);
                });
            } else {
                this.init_batchers();
                if (sendBeacon && window$1.addEventListener) {
                    // Before page closes or hides (user tabs away etc), attempt to flush any events
                    // queued up via navigator.sendBeacon. Since sendBeacon doesn't report success/failure,
                    // events will not be removed from the persistent store; if the site is loaded again,
                    // the events will be flushed again on startup and deduplicated on the Mixpanel server
                    // side.
                    // There is no reliable way to capture only page close events, so we lean on the
                    // visibilitychange and pagehide events as recommended at
                    // https://developer.mozilla.org/en-US/docs/Web/API/Window/unload_event#usage_notes.
                    // These events fire when the user clicks away from the current page/tab, so will occur
                    // more frequently than page unload, but are the only mechanism currently for capturing
                    // this scenario somewhat reliably.
                    var flush_on_unload = _.bind(function() {
                        if (!this.request_batchers.events.stopped) {
                            this.request_batchers.events.flush({unloading: true});
                        }
                    }, this);
                    window$1.addEventListener('pagehide', function(ev) {
                        if (ev['persisted']) {
                            flush_on_unload();
                        }
                    });
                    window$1.addEventListener('visibilitychange', function() {
                        if (document$1['visibilityState'] === 'hidden') {
                            flush_on_unload();
                        }
                    });
                }
            }
        }

        this['persistence'] = this['cookie'] = new MixpanelPersistence(this['config']);
        this.unpersisted_superprops = {};
        this._gdpr_init();

        var uuid = _.UUID();
        if (!this.get_distinct_id()) {
            // There is no need to set the distinct id
            // or the device id if something was already stored
            // in the persitence
            this.register_once({
                'distinct_id': DEVICE_ID_PREFIX + uuid,
                '$device_id': uuid
            }, '');
        }

        var track_pageview_option = this.get_config('track_pageview');
        if (track_pageview_option) {
            this._init_url_change_tracking(track_pageview_option);
        }
    };

    // Private methods

    MixpanelLib.prototype._loaded = function() {
        this.get_config('loaded')(this);
        this._set_default_superprops();
        this['people'].set_once(this['persistence'].get_referrer_info());

        // The original 'store_google' functionality will be deprecated and the config will be
        // used to clear previously managed UTM parameters from persistence.
        // stop_utm_persistence is `false` by default now but will be default `true` in the future.
        if (this.get_config('store_google') && this.get_config('stop_utm_persistence')) {
            var utm_params = _.info.campaignParams(null);
            _.each(utm_params, function(_utm_value, utm_key) {
                // We need to unregister persisted UTM parameters so old values
                // are not mixed with the new UTM parameters
                this.unregister(utm_key);
            }.bind(this));
        }
    };

    // update persistence with info on referrer, UTM params, etc
    MixpanelLib.prototype._set_default_superprops = function() {
        this['persistence'].update_search_keyword(document$1.referrer);
        if (this.get_config('store_google') && !this.get_config('stop_utm_persistence')) {
            this.register(_.info.campaignParams());
        }
        if (this.get_config('save_referrer')) {
            this['persistence'].update_referrer_info(document$1.referrer);
        }
    };

    MixpanelLib.prototype._dom_loaded = function() {
        _.each(this.__dom_loaded_queue, function(item) {
            this._track_dom.apply(this, item);
        }, this);

        if (!this.has_opted_out_tracking()) {
            _.each(this.__request_queue, function(item) {
                this._send_request.apply(this, item);
            }, this);
        }

        delete this.__dom_loaded_queue;
        delete this.__request_queue;
    };

    MixpanelLib.prototype._track_dom = function(DomClass, args) {
        if (this.get_config('img')) {
            this.report_error('You can\'t use DOM tracking functions with img = true.');
            return false;
        }

        if (!DOM_LOADED) {
            this.__dom_loaded_queue.push([DomClass, args]);
            return false;
        }

        var dt = new DomClass().init(this);
        return dt.track.apply(dt, args);
    };

    MixpanelLib.prototype._init_url_change_tracking = function(track_pageview_option) {
        var previous_tracked_url = '';
        var tracked = this.track_pageview();
        if (tracked) {
            previous_tracked_url = _.info.currentUrl();
        }

        if (_.include(['full-url', 'url-with-path-and-query-string', 'url-with-path'], track_pageview_option)) {
            window$1.addEventListener('popstate', function() {
                window$1.dispatchEvent(new Event('mp_locationchange'));
            });
            window$1.addEventListener('hashchange', function() {
                window$1.dispatchEvent(new Event('mp_locationchange'));
            });
            var nativePushState = window$1.history.pushState;
            if (typeof nativePushState === 'function') {
                window$1.history.pushState = function(state, unused, url) {
                    nativePushState.call(window$1.history, state, unused, url);
                    window$1.dispatchEvent(new Event('mp_locationchange'));
                };
            }
            var nativeReplaceState = window$1.history.replaceState;
            if (typeof nativeReplaceState === 'function') {
                window$1.history.replaceState = function(state, unused, url) {
                    nativeReplaceState.call(window$1.history, state, unused, url);
                    window$1.dispatchEvent(new Event('mp_locationchange'));
                };
            }
            window$1.addEventListener('mp_locationchange', function() {
                var current_url = _.info.currentUrl();
                var should_track = false;
                if (track_pageview_option === 'full-url') {
                    should_track = current_url !== previous_tracked_url;
                } else if (track_pageview_option === 'url-with-path-and-query-string') {
                    should_track = current_url.split('#')[0] !== previous_tracked_url.split('#')[0];
                } else if (track_pageview_option === 'url-with-path') {
                    should_track = current_url.split('#')[0].split('?')[0] !== previous_tracked_url.split('#')[0].split('?')[0];
                }

                if (should_track) {
                    var tracked = this.track_pageview();
                    if (tracked) {
                        previous_tracked_url = current_url;
                    }
                }
            }.bind(this));
        }
    };

    /**
     * _prepare_callback() should be called by callers of _send_request for use
     * as the callback argument.
     *
     * If there is no callback, this returns null.
     * If we are going to make XHR/XDR requests, this returns a function.
     * If we are going to use script tags, this returns a string to use as the
     * callback GET param.
     */
    MixpanelLib.prototype._prepare_callback = function(callback, data) {
        if (_.isUndefined(callback)) {
            return null;
        }

        if (USE_XHR) {
            var callback_function = function(response) {
                callback(response, data);
            };
            return callback_function;
        } else {
            // if the user gives us a callback, we store as a random
            // property on this instances jsc function and update our
            // callback string to reflect that.
            var jsc = this['_jsc'];
            var randomized_cb = '' + Math.floor(Math.random() * 100000000);
            var callback_string = this.get_config('callback_fn') + '[' + randomized_cb + ']';
            jsc[randomized_cb] = function(response) {
                delete jsc[randomized_cb];
                callback(response, data);
            };
            return callback_string;
        }
    };

    MixpanelLib.prototype._send_request = function(url, data, options, callback) {
        var succeeded = true;

        if (ENQUEUE_REQUESTS) {
            this.__request_queue.push(arguments);
            return succeeded;
        }

        var DEFAULT_OPTIONS = {
            method: this.get_config('api_method'),
            transport: this.get_config('api_transport'),
            verbose: this.get_config('verbose')
        };
        var body_data = null;

        if (!callback && (_.isFunction(options) || typeof options === 'string')) {
            callback = options;
            options = null;
        }
        options = _.extend(DEFAULT_OPTIONS, options || {});
        if (!USE_XHR) {
            options.method = 'GET';
        }
        var use_post = options.method === 'POST';
        var use_sendBeacon = sendBeacon && use_post && options.transport.toLowerCase() === 'sendbeacon';

        // needed to correctly format responses
        var verbose_mode = options.verbose;
        if (data['verbose']) { verbose_mode = true; }

        if (this.get_config('test')) { data['test'] = 1; }
        if (verbose_mode) { data['verbose'] = 1; }
        if (this.get_config('img')) { data['img'] = 1; }
        if (!USE_XHR) {
            if (callback) {
                data['callback'] = callback;
            } else if (verbose_mode || this.get_config('test')) {
                // Verbose output (from verbose mode, or an error in test mode) is a json blob,
                // which by itself is not valid javascript. Without a callback, this verbose output will
                // cause an error when returned via jsonp, so we force a no-op callback param.
                // See the ECMA script spec: http://www.ecma-international.org/ecma-262/5.1/#sec-12.4
                data['callback'] = '(function(){})';
            }
        }

        data['ip'] = this.get_config('ip')?1:0;
        data['_'] = new Date().getTime().toString();

        if (use_post) {
            body_data = 'data=' + encodeURIComponent(data['data']);
            delete data['data'];
        }

        url += '?' + _.HTTPBuildQuery(data);

        var lib = this;
        if ('img' in data) {
            var img = document$1.createElement('img');
            img.src = url;
            document$1.body.appendChild(img);
        } else if (use_sendBeacon) {
            try {
                succeeded = sendBeacon(url, body_data);
            } catch (e) {
                lib.report_error(e);
                succeeded = false;
            }
            try {
                if (callback) {
                    callback(succeeded ? 1 : 0);
                }
            } catch (e) {
                lib.report_error(e);
            }
        } else if (USE_XHR) {
            try {
                var req = new XMLHttpRequest();
                req.open(options.method, url, true);

                var headers = this.get_config('xhr_headers');
                if (use_post) {
                    headers['Content-Type'] = 'application/x-www-form-urlencoded';
                }
                _.each(headers, function(headerValue, headerName) {
                    req.setRequestHeader(headerName, headerValue);
                });

                if (options.timeout_ms && typeof req.timeout !== 'undefined') {
                    req.timeout = options.timeout_ms;
                    var start_time = new Date().getTime();
                }

                // send the mp_optout cookie
                // withCredentials cannot be modified until after calling .open on Android and Mobile Safari
                req.withCredentials = true;
                req.onreadystatechange = function () {
                    if (req.readyState === 4) { // XMLHttpRequest.DONE == 4, except in safari 4
                        if (req.status === 200) {
                            if (callback) {
                                if (verbose_mode) {
                                    var response;
                                    try {
                                        response = _.JSONDecode(req.responseText);
                                    } catch (e) {
                                        lib.report_error(e);
                                        if (options.ignore_json_errors) {
                                            response = req.responseText;
                                        } else {
                                            return;
                                        }
                                    }
                                    callback(response);
                                } else {
                                    callback(Number(req.responseText));
                                }
                            }
                        } else {
                            var error;
                            if (
                                req.timeout &&
                                !req.status &&
                                new Date().getTime() - start_time >= req.timeout
                            ) {
                                error = 'timeout';
                            } else {
                                error = 'Bad HTTP status: ' + req.status + ' ' + req.statusText;
                            }
                            lib.report_error(error);
                            if (callback) {
                                if (verbose_mode) {
                                    callback({status: 0, error: error, xhr_req: req});
                                } else {
                                    callback(0);
                                }
                            }
                        }
                    }
                };
                req.send(body_data);
            } catch (e) {
                lib.report_error(e);
                succeeded = false;
            }
        } else {
            var script = document$1.createElement('script');
            script.type = 'text/javascript';
            script.async = true;
            script.defer = true;
            script.src = url;
            var s = document$1.getElementsByTagName('script')[0];
            s.parentNode.insertBefore(script, s);
        }

        return succeeded;
    };

    /**
     * _execute_array() deals with processing any mixpanel function
     * calls that were called before the Mixpanel library were loaded
     * (and are thus stored in an array so they can be called later)
     *
     * Note: we fire off all the mixpanel function calls && user defined
     * functions BEFORE we fire off mixpanel tracking calls. This is so
     * identify/register/set_config calls can properly modify early
     * tracking calls.
     *
     * @param {Array} array
     */
    MixpanelLib.prototype._execute_array = function(array) {
        var fn_name, alias_calls = [], other_calls = [], tracking_calls = [];
        _.each(array, function(item) {
            if (item) {
                fn_name = item[0];
                if (_.isArray(fn_name)) {
                    tracking_calls.push(item); // chained call e.g. mixpanel.get_group().set()
                } else if (typeof(item) === 'function') {
                    item.call(this);
                } else if (_.isArray(item) && fn_name === 'alias') {
                    alias_calls.push(item);
                } else if (_.isArray(item) && fn_name.indexOf('track') !== -1 && typeof(this[fn_name]) === 'function') {
                    tracking_calls.push(item);
                } else {
                    other_calls.push(item);
                }
            }
        }, this);

        var execute = function(calls, context) {
            _.each(calls, function(item) {
                if (_.isArray(item[0])) {
                    // chained call
                    var caller = context;
                    _.each(item, function(call) {
                        caller = caller[call[0]].apply(caller, call.slice(1));
                    });
                } else {
                    this[item[0]].apply(this, item.slice(1));
                }
            }, context);
        };

        execute(alias_calls, this);
        execute(other_calls, this);
        execute(tracking_calls, this);
    };

    // request queueing utils

    MixpanelLib.prototype.are_batchers_initialized = function() {
        return !!this.request_batchers.events;
    };

    MixpanelLib.prototype.get_batcher_configs = function() {
        var queue_prefix = '__mpq_' + this.get_config('token');
        var api_routes = this.get_config('api_routes');
        this._batcher_configs = this._batcher_configs || {
            events: {type: 'events', endpoint: '/' + api_routes['track'], queue_key: queue_prefix + '_ev'},
            people: {type: 'people', endpoint: '/' + api_routes['engage'], queue_key: queue_prefix + '_pp'},
            groups: {type: 'groups', endpoint: '/' + api_routes['groups'], queue_key: queue_prefix + '_gr'}
        };
        return this._batcher_configs;
    };

    MixpanelLib.prototype.init_batchers = function() {
        if (!this.are_batchers_initialized()) {
            var batcher_for = _.bind(function(attrs) {
                return new RequestBatcher(
                    attrs.queue_key,
                    {
                        libConfig: this['config'],
                        sendRequestFunc: _.bind(function(data, options, cb) {
                            this._send_request(
                                this.get_config('api_host') + attrs.endpoint,
                                this._encode_data_for_request(data),
                                options,
                                this._prepare_callback(cb, data)
                            );
                        }, this),
                        beforeSendHook: _.bind(function(item) {
                            return this._run_hook('before_send_' + attrs.type, item);
                        }, this),
                        errorReporter: this.get_config('error_reporter'),
                        stopAllBatchingFunc: _.bind(this.stop_batch_senders, this)
                    }
                );
            }, this);
            var batcher_configs = this.get_batcher_configs();
            this.request_batchers = {
                events: batcher_for(batcher_configs.events),
                people: batcher_for(batcher_configs.people),
                groups: batcher_for(batcher_configs.groups)
            };
        }
        if (this.get_config('batch_autostart')) {
            this.start_batch_senders();
        }
    };

    MixpanelLib.prototype.start_batch_senders = function() {
        this._batchers_were_started = true;
        if (this.are_batchers_initialized()) {
            this._batch_requests = true;
            _.each(this.request_batchers, function(batcher) {
                batcher.start();
            });
        }
    };

    MixpanelLib.prototype.stop_batch_senders = function() {
        this._batch_requests = false;
        _.each(this.request_batchers, function(batcher) {
            batcher.stop();
            batcher.clear();
        });
    };

    /**
     * push() keeps the standard async-array-push
     * behavior around after the lib is loaded.
     * This is only useful for external integrations that
     * do not wish to rely on our convenience methods
     * (created in the snippet).
     *
     * ### Usage:
     *     mixpanel.push(['register', { a: 'b' }]);
     *
     * @param {Array} item A [function_name, args...] array to be executed
     */
    MixpanelLib.prototype.push = function(item) {
        this._execute_array([item]);
    };

    /**
     * Disable events on the Mixpanel object. If passed no arguments,
     * this function disables tracking of any event. If passed an
     * array of event names, those events will be disabled, but other
     * events will continue to be tracked.
     *
     * Note: this function does not stop other mixpanel functions from
     * firing, such as register() or people.set().
     *
     * @param {Array} [events] An array of event names to disable
     */
    MixpanelLib.prototype.disable = function(events) {
        if (typeof(events) === 'undefined') {
            this._flags.disable_all_events = true;
        } else {
            this.__disabled_events = this.__disabled_events.concat(events);
        }
    };

    MixpanelLib.prototype._encode_data_for_request = function(data) {
        var encoded_data = _.JSONEncode(data);
        if (this.get_config('api_payload_format') === PAYLOAD_TYPE_BASE64) {
            encoded_data = _.base64Encode(encoded_data);
        }
        return {'data': encoded_data};
    };

    // internal method for handling track vs batch-enqueue logic
    MixpanelLib.prototype._track_or_batch = function(options, callback) {
        var truncated_data = _.truncate(options.data, 255);
        var endpoint = options.endpoint;
        var batcher = options.batcher;
        var should_send_immediately = options.should_send_immediately;
        var send_request_options = options.send_request_options || {};
        callback = callback || NOOP_FUNC;

        var request_enqueued_or_initiated = true;
        var send_request_immediately = _.bind(function() {
            if (!send_request_options.skip_hooks) {
                truncated_data = this._run_hook('before_send_' + options.type, truncated_data);
            }
            if (truncated_data) {
                console$1.log('MIXPANEL REQUEST:');
                console$1.log(truncated_data);
                return this._send_request(
                    endpoint,
                    this._encode_data_for_request(truncated_data),
                    send_request_options,
                    this._prepare_callback(callback, truncated_data)
                );
            } else {
                return null;
            }
        }, this);

        if (this._batch_requests && !should_send_immediately) {
            batcher.enqueue(truncated_data, function(succeeded) {
                if (succeeded) {
                    callback(1, truncated_data);
                } else {
                    send_request_immediately();
                }
            });
        } else {
            request_enqueued_or_initiated = send_request_immediately();
        }

        return request_enqueued_or_initiated && truncated_data;
    };

    /**
     * Track an event. This is the most important and
     * frequently used Mixpanel function.
     *
     * ### Usage:
     *
     *     // track an event named 'Registered'
     *     mixpanel.track('Registered', {'Gender': 'Male', 'Age': 21});
     *
     *     // track an event using navigator.sendBeacon
     *     mixpanel.track('Left page', {'duration_seconds': 35}, {transport: 'sendBeacon'});
     *
     * To track link clicks or form submissions, see track_links() or track_forms().
     *
     * @param {String} event_name The name of the event. This can be anything the user does - 'Button Click', 'Sign Up', 'Item Purchased', etc.
     * @param {Object} [properties] A set of properties to include with the event you're sending. These describe the user who did the event or details about the event itself.
     * @param {Object} [options] Optional configuration for this track request.
     * @param {String} [options.transport] Transport method for network request ('xhr' or 'sendBeacon').
     * @param {Boolean} [options.send_immediately] Whether to bypass batching/queueing and send track request immediately.
     * @param {Function} [callback] If provided, the callback function will be called after tracking the event.
     * @returns {Boolean|Object} If the tracking request was successfully initiated/queued, an object
     * with the tracking payload sent to the API server is returned; otherwise false.
     */
    MixpanelLib.prototype.track = addOptOutCheckMixpanelLib(function(event_name, properties, options, callback) {
        if (!callback && typeof options === 'function') {
            callback = options;
            options = null;
        }
        options = options || {};
        var transport = options['transport']; // external API, don't minify 'transport' prop
        if (transport) {
            options.transport = transport; // 'transport' prop name can be minified internally
        }
        var should_send_immediately = options['send_immediately'];
        if (typeof callback !== 'function') {
            callback = NOOP_FUNC;
        }

        if (_.isUndefined(event_name)) {
            this.report_error('No event name provided to mixpanel.track');
            return;
        }

        if (this._event_is_disabled(event_name)) {
            callback(0);
            return;
        }

        // set defaults
        properties = _.extend({}, properties);
        properties['token'] = this.get_config('token');

        // set $duration if time_event was previously called for this event
        var start_timestamp = this['persistence'].remove_event_timer(event_name);
        if (!_.isUndefined(start_timestamp)) {
            var duration_in_ms = new Date().getTime() - start_timestamp;
            properties['$duration'] = parseFloat((duration_in_ms / 1000).toFixed(3));
        }

        this._set_default_superprops();

        var marketing_properties = this.get_config('track_marketing')
            ? _.info.marketingParams()
            : {};

        // note: extend writes to the first object, so lets make sure we
        // don't write to the persistence properties object and info
        // properties object by passing in a new object

        // update properties with pageview info and super-properties
        properties = _.extend(
            {},
            _.info.properties({'mp_loader': this.get_config('mp_loader')}),
            marketing_properties,
            this['persistence'].properties(),
            this.unpersisted_superprops,
            properties
        );

        var property_blacklist = this.get_config('property_blacklist');
        if (_.isArray(property_blacklist)) {
            _.each(property_blacklist, function(blacklisted_prop) {
                delete properties[blacklisted_prop];
            });
        } else {
            this.report_error('Invalid value for property_blacklist config: ' + property_blacklist);
        }

        var data = {
            'event': event_name,
            'properties': properties
        };
        var ret = this._track_or_batch({
            type: 'events',
            data: data,
            endpoint: this.get_config('api_host') + '/' + this.get_config('api_routes')['track'],
            batcher: this.request_batchers.events,
            should_send_immediately: should_send_immediately,
            send_request_options: options
        }, callback);

        return ret;
    });

    /**
     * Register the current user into one/many groups.
     *
     * ### Usage:
     *
     *      mixpanel.set_group('company', ['mixpanel', 'google']) // an array of IDs
     *      mixpanel.set_group('company', 'mixpanel')
     *      mixpanel.set_group('company', 128746312)
     *
     * @param {String} group_key Group key
     * @param {Array|String|Number} group_ids An array of group IDs, or a singular group ID
     * @param {Function} [callback] If provided, the callback will be called after tracking the event.
     *
     */
    MixpanelLib.prototype.set_group = addOptOutCheckMixpanelLib(function(group_key, group_ids, callback) {
        if (!_.isArray(group_ids)) {
            group_ids = [group_ids];
        }
        var prop = {};
        prop[group_key] = group_ids;
        this.register(prop);
        return this['people'].set(group_key, group_ids, callback);
    });

    /**
     * Add a new group for this user.
     *
     * ### Usage:
     *
     *      mixpanel.add_group('company', 'mixpanel')
     *
     * @param {String} group_key Group key
     * @param {*} group_id A valid Mixpanel property type
     * @param {Function} [callback] If provided, the callback will be called after tracking the event.
     */
    MixpanelLib.prototype.add_group = addOptOutCheckMixpanelLib(function(group_key, group_id, callback) {
        var old_values = this.get_property(group_key);
        var prop = {};
        if (old_values === undefined) {
            prop[group_key] = [group_id];
            this.register(prop);
        } else {
            if (old_values.indexOf(group_id) === -1) {
                old_values.push(group_id);
                prop[group_key] = old_values;
                this.register(prop);
            }
        }
        return this['people'].union(group_key, group_id, callback);
    });

    /**
     * Remove a group from this user.
     *
     * ### Usage:
     *
     *      mixpanel.remove_group('company', 'mixpanel')
     *
     * @param {String} group_key Group key
     * @param {*} group_id A valid Mixpanel property type
     * @param {Function} [callback] If provided, the callback will be called after tracking the event.
     */
    MixpanelLib.prototype.remove_group = addOptOutCheckMixpanelLib(function(group_key, group_id, callback) {
        var old_value = this.get_property(group_key);
        // if the value doesn't exist, the persistent store is unchanged
        if (old_value !== undefined) {
            var idx = old_value.indexOf(group_id);
            if (idx > -1) {
                old_value.splice(idx, 1);
                this.register({group_key: old_value});
            }
            if (old_value.length === 0) {
                this.unregister(group_key);
            }
        }
        return this['people'].remove(group_key, group_id, callback);
    });

    /**
     * Track an event with specific groups.
     *
     * ### Usage:
     *
     *      mixpanel.track_with_groups('purchase', {'product': 'iphone'}, {'University': ['UCB', 'UCLA']})
     *
     * @param {String} event_name The name of the event (see `mixpanel.track()`)
     * @param {Object=} properties A set of properties to include with the event you're sending (see `mixpanel.track()`)
     * @param {Object=} groups An object mapping group name keys to one or more values
     * @param {Function} [callback] If provided, the callback will be called after tracking the event.
     */
    MixpanelLib.prototype.track_with_groups = addOptOutCheckMixpanelLib(function(event_name, properties, groups, callback) {
        var tracking_props = _.extend({}, properties || {});
        _.each(groups, function(v, k) {
            if (v !== null && v !== undefined) {
                tracking_props[k] = v;
            }
        });
        return this.track(event_name, tracking_props, callback);
    });

    MixpanelLib.prototype._create_map_key = function (group_key, group_id) {
        return group_key + '_' + JSON.stringify(group_id);
    };

    MixpanelLib.prototype._remove_group_from_cache = function (group_key, group_id) {
        delete this._cached_groups[this._create_map_key(group_key, group_id)];
    };

    /**
     * Look up reference to a Mixpanel group
     *
     * ### Usage:
     *
     *       mixpanel.get_group(group_key, group_id)
     *
     * @param {String} group_key Group key
     * @param {Object} group_id A valid Mixpanel property type
     * @returns {Object} A MixpanelGroup identifier
     */
    MixpanelLib.prototype.get_group = function (group_key, group_id) {
        var map_key = this._create_map_key(group_key, group_id);
        var group = this._cached_groups[map_key];
        if (group === undefined || group._group_key !== group_key || group._group_id !== group_id) {
            group = new MixpanelGroup();
            group._init(this, group_key, group_id);
            this._cached_groups[map_key] = group;
        }
        return group;
    };

    /**
     * Track a default Mixpanel page view event, which includes extra default event properties to
     * improve page view data.
     *
     * ### Usage:
     *
     *     // track a default $mp_web_page_view event
     *     mixpanel.track_pageview();
     *
     *     // track a page view event with additional event properties
     *     mixpanel.track_pageview({'ab_test_variant': 'card-layout-b'});
     *
     *     // example approach to track page views on different page types as event properties
     *     mixpanel.track_pageview({'page': 'pricing'});
     *     mixpanel.track_pageview({'page': 'homepage'});
     *
     *     // UNCOMMON: Tracking a page view event with a custom event_name option. NOT expected to be used for
     *     // individual pages on the same site or product. Use cases for custom event_name may be page
     *     // views on different products or internal applications that are considered completely separate
     *     mixpanel.track_pageview({'page': 'customer-search'}, {'event_name': '[internal] Admin Page View'});
     *
     * ### Notes:
     *
     * The `config.track_pageview` option for <a href="#mixpanelinit">mixpanel.init()</a>
     * may be turned on for tracking page loads automatically.
     *
     *     // track only page loads
     *     mixpanel.init(PROJECT_TOKEN, {track_pageview: true});
     *
     *     // track when the URL changes in any manner
     *     mixpanel.init(PROJECT_TOKEN, {track_pageview: 'full-url'});
     *
     *     // track when the URL changes, ignoring any changes in the hash part
     *     mixpanel.init(PROJECT_TOKEN, {track_pageview: 'url-with-path-and-query-string'});
     *
     *     // track when the path changes, ignoring any query parameter or hash changes
     *     mixpanel.init(PROJECT_TOKEN, {track_pageview: 'url-with-path'});
     *
     * @param {Object} [properties] An optional set of additional properties to send with the page view event
     * @param {Object} [options] Page view tracking options
     * @param {String} [options.event_name] - Alternate name for the tracking event
     * @returns {Boolean|Object} If the tracking request was successfully initiated/queued, an object
     * with the tracking payload sent to the API server is returned; otherwise false.
     */
    MixpanelLib.prototype.track_pageview = addOptOutCheckMixpanelLib(function(properties, options) {
        if (typeof properties !== 'object') {
            properties = {};
        }
        options = options || {};
        var event_name = options['event_name'] || '$mp_web_page_view';

        var default_page_properties = _.extend(
            _.info.mpPageViewProperties(),
            _.info.campaignParams(),
            _.info.clickParams()
        );

        var event_properties = _.extend(
            {},
            default_page_properties,
            properties
        );

        return this.track(event_name, event_properties);
    });

    /**
     * Track clicks on a set of document elements. Selector must be a
     * valid query. Elements must exist on the page at the time track_links is called.
     *
     * ### Usage:
     *
     *     // track click for link id #nav
     *     mixpanel.track_links('#nav', 'Clicked Nav Link');
     *
     * ### Notes:
     *
     * This function will wait up to 300 ms for the Mixpanel
     * servers to respond. If they have not responded by that time
     * it will head to the link without ensuring that your event
     * has been tracked.  To configure this timeout please see the
     * set_config() documentation below.
     *
     * If you pass a function in as the properties argument, the
     * function will receive the DOMElement that triggered the
     * event as an argument.  You are expected to return an object
     * from the function; any properties defined on this object
     * will be sent to mixpanel as event properties.
     *
     * @type {Function}
     * @param {Object|String} query A valid DOM query, element or jQuery-esque list
     * @param {String} event_name The name of the event to track
     * @param {Object|Function} [properties] A properties object or function that returns a dictionary of properties when passed a DOMElement
     */
    MixpanelLib.prototype.track_links = function() {
        return this._track_dom.call(this, LinkTracker, arguments);
    };

    /**
     * Track form submissions. Selector must be a valid query.
     *
     * ### Usage:
     *
     *     // track submission for form id 'register'
     *     mixpanel.track_forms('#register', 'Created Account');
     *
     * ### Notes:
     *
     * This function will wait up to 300 ms for the mixpanel
     * servers to respond, if they have not responded by that time
     * it will head to the link without ensuring that your event
     * has been tracked.  To configure this timeout please see the
     * set_config() documentation below.
     *
     * If you pass a function in as the properties argument, the
     * function will receive the DOMElement that triggered the
     * event as an argument.  You are expected to return an object
     * from the function; any properties defined on this object
     * will be sent to mixpanel as event properties.
     *
     * @type {Function}
     * @param {Object|String} query A valid DOM query, element or jQuery-esque list
     * @param {String} event_name The name of the event to track
     * @param {Object|Function} [properties] This can be a set of properties, or a function that returns a set of properties after being passed a DOMElement
     */
    MixpanelLib.prototype.track_forms = function() {
        return this._track_dom.call(this, FormTracker, arguments);
    };

    /**
     * Time an event by including the time between this call and a
     * later 'track' call for the same event in the properties sent
     * with the event.
     *
     * ### Usage:
     *
     *     // time an event named 'Registered'
     *     mixpanel.time_event('Registered');
     *     mixpanel.track('Registered', {'Gender': 'Male', 'Age': 21});
     *
     * When called for a particular event name, the next track call for that event
     * name will include the elapsed time between the 'time_event' and 'track'
     * calls. This value is stored as seconds in the '$duration' property.
     *
     * @param {String} event_name The name of the event.
     */
    MixpanelLib.prototype.time_event = function(event_name) {
        if (_.isUndefined(event_name)) {
            this.report_error('No event name provided to mixpanel.time_event');
            return;
        }

        if (this._event_is_disabled(event_name)) {
            return;
        }

        this['persistence'].set_event_timer(event_name,  new Date().getTime());
    };

    var REGISTER_DEFAULTS = {
        'persistent': true
    };
    /**
     * Helper to parse options param for register methods, maintaining
     * legacy support for plain "days" param instead of options object
     * @param {Number|Object} [days_or_options] 'days' option (Number), or Options object for register methods
     * @returns {Object} options object
     */
    var options_for_register = function(days_or_options) {
        var options;
        if (_.isObject(days_or_options)) {
            options = days_or_options;
        } else if (!_.isUndefined(days_or_options)) {
            options = {'days': days_or_options};
        } else {
            options = {};
        }
        return _.extend({}, REGISTER_DEFAULTS, options);
    };

    /**
     * Register a set of super properties, which are included with all
     * events. This will overwrite previous super property values.
     *
     * ### Usage:
     *
     *     // register 'Gender' as a super property
     *     mixpanel.register({'Gender': 'Female'});
     *
     *     // register several super properties when a user signs up
     *     mixpanel.register({
     *         'Email': 'jdoe@example.com',
     *         'Account Type': 'Free'
     *     });
     *
     *     // register only for the current pageload
     *     mixpanel.register({'Name': 'Pat'}, {persistent: false});
     *
     * @param {Object} properties An associative array of properties to store about the user
     * @param {Number|Object} [days_or_options] Options object or number of days since the user's last visit to store the super properties (only valid for persisted props)
     * @param {boolean} [days_or_options.days] - number of days since the user's last visit to store the super properties (only valid for persisted props)
     * @param {boolean} [days_or_options.persistent=true] - whether to put in persistent storage (cookie/localStorage)
     */
    MixpanelLib.prototype.register = function(props, days_or_options) {
        var options = options_for_register(days_or_options);
        if (options['persistent']) {
            this['persistence'].register(props, options['days']);
        } else {
            _.extend(this.unpersisted_superprops, props);
        }
    };

    /**
     * Register a set of super properties only once. This will not
     * overwrite previous super property values, unlike register().
     *
     * ### Usage:
     *
     *     // register a super property for the first time only
     *     mixpanel.register_once({
     *         'First Login Date': new Date().toISOString()
     *     });
     *
     *     // register once, only for the current pageload
     *     mixpanel.register_once({
     *         'First interaction time': new Date().toISOString()
     *     }, 'None', {persistent: false});
     *
     * ### Notes:
     *
     * If default_value is specified, current super properties
     * with that value will be overwritten.
     *
     * @param {Object} properties An associative array of properties to store about the user
     * @param {*} [default_value] Value to override if already set in super properties (ex: 'False') Default: 'None'
     * @param {Number|Object} [days_or_options] Options object or number of days since the user's last visit to store the super properties (only valid for persisted props)
     * @param {boolean} [days_or_options.days] - number of days since the user's last visit to store the super properties (only valid for persisted props)
     * @param {boolean} [days_or_options.persistent=true] - whether to put in persistent storage (cookie/localStorage)
     */
    MixpanelLib.prototype.register_once = function(props, default_value, days_or_options) {
        var options = options_for_register(days_or_options);
        if (options['persistent']) {
            this['persistence'].register_once(props, default_value, options['days']);
        } else {
            if (typeof(default_value) === 'undefined') {
                default_value = 'None';
            }
            _.each(props, function(val, prop) {
                if (!this.unpersisted_superprops.hasOwnProperty(prop) || this.unpersisted_superprops[prop] === default_value) {
                    this.unpersisted_superprops[prop] = val;
                }
            }, this);
        }
    };

    /**
     * Delete a super property stored with the current user.
     *
     * @param {String} property The name of the super property to remove
     * @param {Object} [options]
     * @param {boolean} [options.persistent=true] - whether to look in persistent storage (cookie/localStorage)
     */
    MixpanelLib.prototype.unregister = function(property, options) {
        options = options_for_register(options);
        if (options['persistent']) {
            this['persistence'].unregister(property);
        } else {
            delete this.unpersisted_superprops[property];
        }
    };

    MixpanelLib.prototype._register_single = function(prop, value) {
        var props = {};
        props[prop] = value;
        this.register(props);
    };

    /**
     * Identify a user with a unique ID to track user activity across
     * devices, tie a user to their events, and create a user profile.
     * If you never call this method, unique visitors are tracked using
     * a UUID generated the first time they visit the site.
     *
     * Call identify when you know the identity of the current user,
     * typically after login or signup. We recommend against using
     * identify for anonymous visitors to your site.
     *
     * ### Notes:
     * If your project has
     * <a href="https://help.mixpanel.com/hc/en-us/articles/360039133851">ID Merge</a>
     * enabled, the identify method will connect pre- and
     * post-authentication events when appropriate.
     *
     * If your project does not have ID Merge enabled, identify will
     * change the user's local distinct_id to the unique ID you pass.
     * Events tracked prior to authentication will not be connected
     * to the same user identity. If ID Merge is disabled, alias can
     * be used to connect pre- and post-registration events.
     *
     * @param {String} [unique_id] A string that uniquely identifies a user. If not provided, the distinct_id currently in the persistent store (cookie or localStorage) will be used.
     */
    MixpanelLib.prototype.identify = function(
        new_distinct_id, _set_callback, _add_callback, _append_callback, _set_once_callback, _union_callback, _unset_callback, _remove_callback
    ) {
        // Optional Parameters
        //  _set_callback:function  A callback to be run if and when the People set queue is flushed
        //  _add_callback:function  A callback to be run if and when the People add queue is flushed
        //  _append_callback:function  A callback to be run if and when the People append queue is flushed
        //  _set_once_callback:function  A callback to be run if and when the People set_once queue is flushed
        //  _union_callback:function  A callback to be run if and when the People union queue is flushed
        //  _unset_callback:function  A callback to be run if and when the People unset queue is flushed

        var previous_distinct_id = this.get_distinct_id();
        if (new_distinct_id && previous_distinct_id !== new_distinct_id) {
            // we allow the following condition if previous distinct_id is same as new_distinct_id
            // so that you can force flush people updates for anonymous profiles.
            if (typeof new_distinct_id === 'string' && new_distinct_id.indexOf(DEVICE_ID_PREFIX) === 0) {
                this.report_error('distinct_id cannot have $device: prefix');
                return -1;
            }
            this.register({'$user_id': new_distinct_id});
        }

        if (!this.get_property('$device_id')) {
            // The persisted distinct id might not actually be a device id at all
            // it might be a distinct id of the user from before
            var device_id = previous_distinct_id;
            this.register_once({
                '$had_persisted_distinct_id': true,
                '$device_id': device_id
            }, '');
        }

        // identify only changes the distinct id if it doesn't match either the existing or the alias;
        // if it's new, blow away the alias as well.
        if (new_distinct_id !== previous_distinct_id && new_distinct_id !== this.get_property(ALIAS_ID_KEY)) {
            this.unregister(ALIAS_ID_KEY);
            this.register({'distinct_id': new_distinct_id});
        }
        this._flags.identify_called = true;
        // Flush any queued up people requests
        this['people']._flush(_set_callback, _add_callback, _append_callback, _set_once_callback, _union_callback, _unset_callback, _remove_callback);

        // send an $identify event any time the distinct_id is changing - logic on the server
        // will determine whether or not to do anything with it.
        if (new_distinct_id !== previous_distinct_id) {
            this.track('$identify', {
                'distinct_id': new_distinct_id,
                '$anon_distinct_id': previous_distinct_id
            }, {skip_hooks: true});
        }
    };

    /**
     * Clears super properties and generates a new random distinct_id for this instance.
     * Useful for clearing data when a user logs out.
     */
    MixpanelLib.prototype.reset = function() {
        this['persistence'].clear();
        this._flags.identify_called = false;
        var uuid = _.UUID();
        this.register_once({
            'distinct_id': DEVICE_ID_PREFIX + uuid,
            '$device_id': uuid
        }, '');
    };

    /**
     * Returns the current distinct id of the user. This is either the id automatically
     * generated by the library or the id that has been passed by a call to identify().
     *
     * ### Notes:
     *
     * get_distinct_id() can only be called after the Mixpanel library has finished loading.
     * init() has a loaded function available to handle this automatically. For example:
     *
     *     // set distinct_id after the mixpanel library has loaded
     *     mixpanel.init('YOUR PROJECT TOKEN', {
     *         loaded: function(mixpanel) {
     *             distinct_id = mixpanel.get_distinct_id();
     *         }
     *     });
     */
    MixpanelLib.prototype.get_distinct_id = function() {
        return this.get_property('distinct_id');
    };

    /**
     * The alias method creates an alias which Mixpanel will use to
     * remap one id to another. Multiple aliases can point to the
     * same identifier.
     *
     * The following is a valid use of alias:
     *
     *     mixpanel.alias('new_id', 'existing_id');
     *     // You can add multiple id aliases to the existing ID
     *     mixpanel.alias('newer_id', 'existing_id');
     *
     * Aliases can also be chained - the following is a valid example:
     *
     *     mixpanel.alias('new_id', 'existing_id');
     *     // chain newer_id - new_id - existing_id
     *     mixpanel.alias('newer_id', 'new_id');
     *
     * Aliases cannot point to multiple identifiers - the following
     * example will not work:
     *
     *     mixpanel.alias('new_id', 'existing_id');
     *     // this is invalid as 'new_id' already points to 'existing_id'
     *     mixpanel.alias('new_id', 'newer_id');
     *
     * ### Notes:
     *
     * If your project does not have
     * <a href="https://help.mixpanel.com/hc/en-us/articles/360039133851">ID Merge</a>
     * enabled, the best practice is to call alias once when a unique
     * ID is first created for a user (e.g., when a user first registers
     * for an account). Do not use alias multiple times for a single
     * user without ID Merge enabled.
     *
     * @param {String} alias A unique identifier that you want to use for this user in the future.
     * @param {String} [original] The current identifier being used for this user.
     */
    MixpanelLib.prototype.alias = function(alias, original) {
        // If the $people_distinct_id key exists in persistence, there has been a previous
        // mixpanel.people.identify() call made for this user. It is VERY BAD to make an alias with
        // this ID, as it will duplicate users.
        if (alias === this.get_property(PEOPLE_DISTINCT_ID_KEY)) {
            this.report_error('Attempting to create alias for existing People user - aborting.');
            return -2;
        }

        var _this = this;
        if (_.isUndefined(original)) {
            original = this.get_distinct_id();
        }
        if (alias !== original) {
            this._register_single(ALIAS_ID_KEY, alias);
            return this.track('$create_alias', {
                'alias': alias,
                'distinct_id': original
            }, {
                skip_hooks: true
            }, function() {
                // Flush the people queue
                _this.identify(alias);
            });
        } else {
            this.report_error('alias matches current distinct_id - skipping api call.');
            this.identify(alias);
            return -1;
        }
    };

    /**
     * Provide a string to recognize the user by. The string passed to
     * this method will appear in the Mixpanel Streams product rather
     * than an automatically generated name. Name tags do not have to
     * be unique.
     *
     * This value will only be included in Streams data.
     *
     * @param {String} name_tag A human readable name for the user
     * @deprecated
     */
    MixpanelLib.prototype.name_tag = function(name_tag) {
        this._register_single('mp_name_tag', name_tag);
    };

    /**
     * Update the configuration of a mixpanel library instance.
     *
     * The default config is:
     *
     *     {
     *       // host for requests (customizable for e.g. a local proxy)
     *       api_host: 'https://api-js.mixpanel.com',
     *
     *       // endpoints for different types of requests
     *       api_routes: {
     *         track: 'track/',
     *         engage: 'engage/',
     *         groups: 'groups/',
     *       }
     *
     *       // HTTP method for tracking requests
     *       api_method: 'POST'
     *
     *       // transport for sending requests ('XHR' or 'sendBeacon')
     *       // NB: sendBeacon should only be used for scenarios such as
     *       // page unload where a "best-effort" attempt to send is
     *       // acceptable; the sendBeacon API does not support callbacks
     *       // or any way to know the result of the request. Mixpanel
     *       // tracking via sendBeacon will not support any event-
     *       // batching or retry mechanisms.
     *       api_transport: 'XHR'
     *
     *       // request-batching/queueing/retry
     *       batch_requests: true,
     *
     *       // maximum number of events/updates to send in a single
     *       // network request
     *       batch_size: 50,
     *
     *       // milliseconds to wait between sending batch requests
     *       batch_flush_interval_ms: 5000,
     *
     *       // milliseconds to wait for network responses to batch requests
     *       // before they are considered timed-out and retried
     *       batch_request_timeout_ms: 90000,
     *
     *       // override value for cookie domain, only useful for ensuring
     *       // correct cross-subdomain cookies on unusual domains like
     *       // subdomain.mainsite.avocat.fr; NB this cannot be used to
     *       // set cookies on a different domain than the current origin
     *       cookie_domain: ''
     *
     *       // super properties cookie expiration (in days)
     *       cookie_expiration: 365
     *
     *       // if true, cookie will be set with SameSite=None; Secure
     *       // this is only useful in special situations, like embedded
     *       // 3rd-party iframes that set up a Mixpanel instance
     *       cross_site_cookie: false
     *
     *       // super properties span subdomains
     *       cross_subdomain_cookie: true
     *
     *       // debug mode
     *       debug: false
     *
     *       // if this is true, the mixpanel cookie or localStorage entry
     *       // will be deleted, and no user persistence will take place
     *       disable_persistence: false
     *
     *       // if this is true, Mixpanel will automatically determine
     *       // City, Region and Country data using the IP address of
     *       //the client
     *       ip: true
     *
     *       // opt users out of tracking by this Mixpanel instance by default
     *       opt_out_tracking_by_default: false
     *
     *       // opt users out of browser data storage by this Mixpanel instance by default
     *       opt_out_persistence_by_default: false
     *
     *       // persistence mechanism used by opt-in/opt-out methods - cookie
     *       // or localStorage - falls back to cookie if localStorage is unavailable
     *       opt_out_tracking_persistence_type: 'localStorage'
     *
     *       // customize the name of cookie/localStorage set by opt-in/opt-out methods
     *       opt_out_tracking_cookie_prefix: null
     *
     *       // type of persistent store for super properties (cookie/
     *       // localStorage) if set to 'localStorage', any existing
     *       // mixpanel cookie value with the same persistence_name
     *       // will be transferred to localStorage and deleted
     *       persistence: 'cookie'
     *
     *       // name for super properties persistent store
     *       persistence_name: ''
     *
     *       // names of properties/superproperties which should never
     *       // be sent with track() calls
     *       property_blacklist: []
     *
     *       // if this is true, mixpanel cookies will be marked as
     *       // secure, meaning they will only be transmitted over https
     *       secure_cookie: false
     *
     *       // disables enriching user profiles with first touch marketing data
     *       skip_first_touch_marketing: false
     *
     *       // the amount of time track_links will
     *       // wait for Mixpanel's servers to respond
     *       track_links_timeout: 300
     *
     *       // adds any UTM parameters and click IDs present on the page to any events fired
     *       track_marketing: true
     *
     *       // enables automatic page view tracking using default page view events through
     *       // the track_pageview() method
     *       track_pageview: false
     *
     *       // if you set upgrade to be true, the library will check for
     *       // a cookie from our old js library and import super
     *       // properties from it, then the old cookie is deleted
     *       // The upgrade config option only works in the initialization,
     *       // so make sure you set it when you create the library.
     *       upgrade: false
     *
     *       // extra HTTP request headers to set for each API request, in
     *       // the format {'Header-Name': value}
     *       xhr_headers: {}
     *
     *       // whether to ignore or respect the web browser's Do Not Track setting
     *       ignore_dnt: false
     *     }
     *
     *
     * @param {Object} config A dictionary of new configuration values to update
     */
    MixpanelLib.prototype.set_config = function(config) {
        if (_.isObject(config)) {
            _.extend(this['config'], config);

            var new_batch_size = config['batch_size'];
            if (new_batch_size) {
                _.each(this.request_batchers, function(batcher) {
                    batcher.resetBatchSize();
                });
            }

            if (!this.get_config('persistence_name')) {
                this['config']['persistence_name'] = this['config']['cookie_name'];
            }
            if (!this.get_config('disable_persistence')) {
                this['config']['disable_persistence'] = this['config']['disable_cookie'];
            }

            if (this['persistence']) {
                this['persistence'].update_config(this['config']);
            }
            Config.DEBUG = Config.DEBUG || this.get_config('debug');
        }
    };

    /**
     * returns the current config object for the library.
     */
    MixpanelLib.prototype.get_config = function(prop_name) {
        return this['config'][prop_name];
    };

    /**
     * Fetch a hook function from config, with safe default, and run it
     * against the given arguments
     * @param {string} hook_name which hook to retrieve
     * @returns {any|null} return value of user-provided hook, or null if nothing was returned
     */
    MixpanelLib.prototype._run_hook = function(hook_name) {
        var ret = (this['config']['hooks'][hook_name] || IDENTITY_FUNC).apply(this, slice.call(arguments, 1));
        if (typeof ret === 'undefined') {
            this.report_error(hook_name + ' hook did not return a value');
            ret = null;
        }
        return ret;
    };

    /**
     * Returns the value of the super property named property_name. If no such
     * property is set, get_property() will return the undefined value.
     *
     * ### Notes:
     *
     * get_property() can only be called after the Mixpanel library has finished loading.
     * init() has a loaded function available to handle this automatically. For example:
     *
     *     // grab value for 'user_id' after the mixpanel library has loaded
     *     mixpanel.init('YOUR PROJECT TOKEN', {
     *         loaded: function(mixpanel) {
     *             user_id = mixpanel.get_property('user_id');
     *         }
     *     });
     *
     * @param {String} property_name The name of the super property you want to retrieve
     */
    MixpanelLib.prototype.get_property = function(property_name) {
        return this['persistence'].load_prop([property_name]);
    };

    MixpanelLib.prototype.toString = function() {
        var name = this.get_config('name');
        if (name !== PRIMARY_INSTANCE_NAME) {
            name = PRIMARY_INSTANCE_NAME + '.' + name;
        }
        return name;
    };

    MixpanelLib.prototype._event_is_disabled = function(event_name) {
        return _.isBlockedUA(userAgent) ||
            this._flags.disable_all_events ||
            _.include(this.__disabled_events, event_name);
    };

    // perform some housekeeping around GDPR opt-in/out state
    MixpanelLib.prototype._gdpr_init = function() {
        var is_localStorage_requested = this.get_config('opt_out_tracking_persistence_type') === 'localStorage';

        // try to convert opt-in/out cookies to localStorage if possible
        if (is_localStorage_requested && _.localStorage.is_supported()) {
            if (!this.has_opted_in_tracking() && this.has_opted_in_tracking({'persistence_type': 'cookie'})) {
                this.opt_in_tracking({'enable_persistence': false});
            }
            if (!this.has_opted_out_tracking() && this.has_opted_out_tracking({'persistence_type': 'cookie'})) {
                this.opt_out_tracking({'clear_persistence': false});
            }
            this.clear_opt_in_out_tracking({
                'persistence_type': 'cookie',
                'enable_persistence': false
            });
        }

        // check whether the user has already opted out - if so, clear & disable persistence
        if (this.has_opted_out_tracking()) {
            this._gdpr_update_persistence({'clear_persistence': true});

        // check whether we should opt out by default
        // note: we don't clear persistence here by default since opt-out default state is often
        //       used as an initial state while GDPR information is being collected
        } else if (!this.has_opted_in_tracking() && (
            this.get_config('opt_out_tracking_by_default') || _.cookie.get('mp_optout')
        )) {
            _.cookie.remove('mp_optout');
            this.opt_out_tracking({
                'clear_persistence': this.get_config('opt_out_persistence_by_default')
            });
        }
    };

    /**
     * Enable or disable persistence based on options
     * only enable/disable if persistence is not already in this state
     * @param {boolean} [options.clear_persistence] If true, will delete all data stored by the sdk in persistence and disable it
     * @param {boolean} [options.enable_persistence] If true, will re-enable sdk persistence
     */
    MixpanelLib.prototype._gdpr_update_persistence = function(options) {
        var disabled;
        if (options && options['clear_persistence']) {
            disabled = true;
        } else if (options && options['enable_persistence']) {
            disabled = false;
        } else {
            return;
        }

        if (!this.get_config('disable_persistence') && this['persistence'].disabled !== disabled) {
            this['persistence'].set_disabled(disabled);
        }

        if (disabled) {
            this.stop_batch_senders();
        } else {
            // only start batchers after opt-in if they have previously been started
            // in order to avoid unintentionally starting up batching for the first time
            if (this._batchers_were_started) {
                this.start_batch_senders();
            }
        }
    };

    // call a base gdpr function after constructing the appropriate token and options args
    MixpanelLib.prototype._gdpr_call_func = function(func, options) {
        options = _.extend({
            'track': _.bind(this.track, this),
            'persistence_type': this.get_config('opt_out_tracking_persistence_type'),
            'cookie_prefix': this.get_config('opt_out_tracking_cookie_prefix'),
            'cookie_expiration': this.get_config('cookie_expiration'),
            'cross_site_cookie': this.get_config('cross_site_cookie'),
            'cross_subdomain_cookie': this.get_config('cross_subdomain_cookie'),
            'cookie_domain': this.get_config('cookie_domain'),
            'secure_cookie': this.get_config('secure_cookie'),
            'ignore_dnt': this.get_config('ignore_dnt')
        }, options);

        // check if localStorage can be used for recording opt out status, fall back to cookie if not
        if (!_.localStorage.is_supported()) {
            options['persistence_type'] = 'cookie';
        }

        return func(this.get_config('token'), {
            track: options['track'],
            trackEventName: options['track_event_name'],
            trackProperties: options['track_properties'],
            persistenceType: options['persistence_type'],
            persistencePrefix: options['cookie_prefix'],
            cookieDomain: options['cookie_domain'],
            cookieExpiration: options['cookie_expiration'],
            crossSiteCookie: options['cross_site_cookie'],
            crossSubdomainCookie: options['cross_subdomain_cookie'],
            secureCookie: options['secure_cookie'],
            ignoreDnt: options['ignore_dnt']
        });
    };

    /**
     * Opt the user in to data tracking and cookies/localstorage for this Mixpanel instance
     *
     * ### Usage:
     *
     *     // opt user in
     *     mixpanel.opt_in_tracking();
     *
     *     // opt user in with specific event name, properties, cookie configuration
     *     mixpanel.opt_in_tracking({
     *         track_event_name: 'User opted in',
     *         track_event_properties: {
     *             'Email': 'jdoe@example.com'
     *         },
     *         cookie_expiration: 30,
     *         secure_cookie: true
     *     });
     *
     * @param {Object} [options] A dictionary of config options to override
     * @param {function} [options.track] Function used for tracking a Mixpanel event to record the opt-in action (default is this Mixpanel instance's track method)
     * @param {string} [options.track_event_name=$opt_in] Event name to be used for tracking the opt-in action
     * @param {Object} [options.track_properties] Set of properties to be tracked along with the opt-in action
     * @param {boolean} [options.enable_persistence=true] If true, will re-enable sdk persistence
     * @param {string} [options.persistence_type=localStorage] Persistence mechanism used - cookie or localStorage - falls back to cookie if localStorage is unavailable
     * @param {string} [options.cookie_prefix=__mp_opt_in_out] Custom prefix to be used in the cookie/localstorage name
     * @param {Number} [options.cookie_expiration] Number of days until the opt-in cookie expires (overrides value specified in this Mixpanel instance's config)
     * @param {string} [options.cookie_domain] Custom cookie domain (overrides value specified in this Mixpanel instance's config)
     * @param {boolean} [options.cross_site_cookie] Whether the opt-in cookie is set as cross-site-enabled (overrides value specified in this Mixpanel instance's config)
     * @param {boolean} [options.cross_subdomain_cookie] Whether the opt-in cookie is set as cross-subdomain or not (overrides value specified in this Mixpanel instance's config)
     * @param {boolean} [options.secure_cookie] Whether the opt-in cookie is set as secure or not (overrides value specified in this Mixpanel instance's config)
     */
    MixpanelLib.prototype.opt_in_tracking = function(options) {
        options = _.extend({
            'enable_persistence': true
        }, options);

        this._gdpr_call_func(optIn, options);
        this._gdpr_update_persistence(options);
    };

    /**
     * Opt the user out of data tracking and cookies/localstorage for this Mixpanel instance
     *
     * ### Usage:
     *
     *     // opt user out
     *     mixpanel.opt_out_tracking();
     *
     *     // opt user out with different cookie configuration from Mixpanel instance
     *     mixpanel.opt_out_tracking({
     *         cookie_expiration: 30,
     *         secure_cookie: true
     *     });
     *
     * @param {Object} [options] A dictionary of config options to override
     * @param {boolean} [options.delete_user=true] If true, will delete the currently identified user's profile and clear all charges after opting the user out
     * @param {boolean} [options.clear_persistence=true] If true, will delete all data stored by the sdk in persistence
     * @param {string} [options.persistence_type=localStorage] Persistence mechanism used - cookie or localStorage - falls back to cookie if localStorage is unavailable
     * @param {string} [options.cookie_prefix=__mp_opt_in_out] Custom prefix to be used in the cookie/localstorage name
     * @param {Number} [options.cookie_expiration] Number of days until the opt-in cookie expires (overrides value specified in this Mixpanel instance's config)
     * @param {string} [options.cookie_domain] Custom cookie domain (overrides value specified in this Mixpanel instance's config)
     * @param {boolean} [options.cross_site_cookie] Whether the opt-in cookie is set as cross-site-enabled (overrides value specified in this Mixpanel instance's config)
     * @param {boolean} [options.cross_subdomain_cookie] Whether the opt-in cookie is set as cross-subdomain or not (overrides value specified in this Mixpanel instance's config)
     * @param {boolean} [options.secure_cookie] Whether the opt-in cookie is set as secure or not (overrides value specified in this Mixpanel instance's config)
     */
    MixpanelLib.prototype.opt_out_tracking = function(options) {
        options = _.extend({
            'clear_persistence': true,
            'delete_user': true
        }, options);

        // delete user and clear charges since these methods may be disabled by opt-out
        if (options['delete_user'] && this['people'] && this['people']._identify_called()) {
            this['people'].delete_user();
            this['people'].clear_charges();
        }

        this._gdpr_call_func(optOut, options);
        this._gdpr_update_persistence(options);
    };

    /**
     * Check whether the user has opted in to data tracking and cookies/localstorage for this Mixpanel instance
     *
     * ### Usage:
     *
     *     var has_opted_in = mixpanel.has_opted_in_tracking();
     *     // use has_opted_in value
     *
     * @param {Object} [options] A dictionary of config options to override
     * @param {string} [options.persistence_type=localStorage] Persistence mechanism used - cookie or localStorage - falls back to cookie if localStorage is unavailable
     * @param {string} [options.cookie_prefix=__mp_opt_in_out] Custom prefix to be used in the cookie/localstorage name
     * @returns {boolean} current opt-in status
     */
    MixpanelLib.prototype.has_opted_in_tracking = function(options) {
        return this._gdpr_call_func(hasOptedIn, options);
    };

    /**
     * Check whether the user has opted out of data tracking and cookies/localstorage for this Mixpanel instance
     *
     * ### Usage:
     *
     *     var has_opted_out = mixpanel.has_opted_out_tracking();
     *     // use has_opted_out value
     *
     * @param {Object} [options] A dictionary of config options to override
     * @param {string} [options.persistence_type=localStorage] Persistence mechanism used - cookie or localStorage - falls back to cookie if localStorage is unavailable
     * @param {string} [options.cookie_prefix=__mp_opt_in_out] Custom prefix to be used in the cookie/localstorage name
     * @returns {boolean} current opt-out status
     */
    MixpanelLib.prototype.has_opted_out_tracking = function(options) {
        return this._gdpr_call_func(hasOptedOut, options);
    };

    /**
     * Clear the user's opt in/out status of data tracking and cookies/localstorage for this Mixpanel instance
     *
     * ### Usage:
     *
     *     // clear user's opt-in/out status
     *     mixpanel.clear_opt_in_out_tracking();
     *
     *     // clear user's opt-in/out status with specific cookie configuration - should match
     *     // configuration used when opt_in_tracking/opt_out_tracking methods were called.
     *     mixpanel.clear_opt_in_out_tracking({
     *         cookie_expiration: 30,
     *         secure_cookie: true
     *     });
     *
     * @param {Object} [options] A dictionary of config options to override
     * @param {boolean} [options.enable_persistence=true] If true, will re-enable sdk persistence
     * @param {string} [options.persistence_type=localStorage] Persistence mechanism used - cookie or localStorage - falls back to cookie if localStorage is unavailable
     * @param {string} [options.cookie_prefix=__mp_opt_in_out] Custom prefix to be used in the cookie/localstorage name
     * @param {Number} [options.cookie_expiration] Number of days until the opt-in cookie expires (overrides value specified in this Mixpanel instance's config)
     * @param {string} [options.cookie_domain] Custom cookie domain (overrides value specified in this Mixpanel instance's config)
     * @param {boolean} [options.cross_site_cookie] Whether the opt-in cookie is set as cross-site-enabled (overrides value specified in this Mixpanel instance's config)
     * @param {boolean} [options.cross_subdomain_cookie] Whether the opt-in cookie is set as cross-subdomain or not (overrides value specified in this Mixpanel instance's config)
     * @param {boolean} [options.secure_cookie] Whether the opt-in cookie is set as secure or not (overrides value specified in this Mixpanel instance's config)
     */
    MixpanelLib.prototype.clear_opt_in_out_tracking = function(options) {
        options = _.extend({
            'enable_persistence': true
        }, options);

        this._gdpr_call_func(clearOptInOut, options);
        this._gdpr_update_persistence(options);
    };

    MixpanelLib.prototype.report_error = function(msg, err) {
        console$1.error.apply(console$1.error, arguments);
        try {
            if (!err && !(msg instanceof Error)) {
                msg = new Error(msg);
            }
            this.get_config('error_reporter')(msg, err);
        } catch(err) {
            console$1.error(err);
        }
    };

    // EXPORTS (for closure compiler)

    // MixpanelLib Exports
    MixpanelLib.prototype['init']                      = MixpanelLib.prototype.init;
    MixpanelLib.prototype['reset']                     = MixpanelLib.prototype.reset;
    MixpanelLib.prototype['disable']                   = MixpanelLib.prototype.disable;
    MixpanelLib.prototype['time_event']                = MixpanelLib.prototype.time_event;
    MixpanelLib.prototype['track']                     = MixpanelLib.prototype.track;
    MixpanelLib.prototype['track_links']               = MixpanelLib.prototype.track_links;
    MixpanelLib.prototype['track_forms']               = MixpanelLib.prototype.track_forms;
    MixpanelLib.prototype['track_pageview']            = MixpanelLib.prototype.track_pageview;
    MixpanelLib.prototype['register']                  = MixpanelLib.prototype.register;
    MixpanelLib.prototype['register_once']             = MixpanelLib.prototype.register_once;
    MixpanelLib.prototype['unregister']                = MixpanelLib.prototype.unregister;
    MixpanelLib.prototype['identify']                  = MixpanelLib.prototype.identify;
    MixpanelLib.prototype['alias']                     = MixpanelLib.prototype.alias;
    MixpanelLib.prototype['name_tag']                  = MixpanelLib.prototype.name_tag;
    MixpanelLib.prototype['set_config']                = MixpanelLib.prototype.set_config;
    MixpanelLib.prototype['get_config']                = MixpanelLib.prototype.get_config;
    MixpanelLib.prototype['get_property']              = MixpanelLib.prototype.get_property;
    MixpanelLib.prototype['get_distinct_id']           = MixpanelLib.prototype.get_distinct_id;
    MixpanelLib.prototype['toString']                  = MixpanelLib.prototype.toString;
    MixpanelLib.prototype['opt_out_tracking']          = MixpanelLib.prototype.opt_out_tracking;
    MixpanelLib.prototype['opt_in_tracking']           = MixpanelLib.prototype.opt_in_tracking;
    MixpanelLib.prototype['has_opted_out_tracking']    = MixpanelLib.prototype.has_opted_out_tracking;
    MixpanelLib.prototype['has_opted_in_tracking']     = MixpanelLib.prototype.has_opted_in_tracking;
    MixpanelLib.prototype['clear_opt_in_out_tracking'] = MixpanelLib.prototype.clear_opt_in_out_tracking;
    MixpanelLib.prototype['get_group']                 = MixpanelLib.prototype.get_group;
    MixpanelLib.prototype['set_group']                 = MixpanelLib.prototype.set_group;
    MixpanelLib.prototype['add_group']                 = MixpanelLib.prototype.add_group;
    MixpanelLib.prototype['remove_group']              = MixpanelLib.prototype.remove_group;
    MixpanelLib.prototype['track_with_groups']         = MixpanelLib.prototype.track_with_groups;
    MixpanelLib.prototype['start_batch_senders']       = MixpanelLib.prototype.start_batch_senders;
    MixpanelLib.prototype['stop_batch_senders']        = MixpanelLib.prototype.stop_batch_senders;
    MixpanelLib.prototype['DEFAULT_API_ROUTES']        = DEFAULT_API_ROUTES;

    // MixpanelPersistence Exports
    MixpanelPersistence.prototype['properties']            = MixpanelPersistence.prototype.properties;
    MixpanelPersistence.prototype['update_search_keyword'] = MixpanelPersistence.prototype.update_search_keyword;
    MixpanelPersistence.prototype['update_referrer_info']  = MixpanelPersistence.prototype.update_referrer_info;
    MixpanelPersistence.prototype['get_cross_subdomain']   = MixpanelPersistence.prototype.get_cross_subdomain;
    MixpanelPersistence.prototype['clear']                 = MixpanelPersistence.prototype.clear;


    var instances = {};
    var extend_mp = function() {
        // add all the sub mixpanel instances
        _.each(instances, function(instance, name) {
            if (name !== PRIMARY_INSTANCE_NAME) { mixpanel_master[name] = instance; }
        });

        // add private functions as _
        mixpanel_master['_'] = _;
    };

    var override_mp_init_func = function() {
        // we override the snippets init function to handle the case where a
        // user initializes the mixpanel library after the script loads & runs
        mixpanel_master['init'] = function(token, config, name) {
            if (name) {
                // initialize a sub library
                if (!mixpanel_master[name]) {
                    mixpanel_master[name] = instances[name] = create_mplib(token, config, name);
                    mixpanel_master[name]._loaded();
                }
                return mixpanel_master[name];
            } else {
                var instance = mixpanel_master;

                if (instances[PRIMARY_INSTANCE_NAME]) {
                    // main mixpanel lib already initialized
                    instance = instances[PRIMARY_INSTANCE_NAME];
                } else if (token) {
                    // intialize the main mixpanel lib
                    instance = create_mplib(token, config, PRIMARY_INSTANCE_NAME);
                    instance._loaded();
                    instances[PRIMARY_INSTANCE_NAME] = instance;
                }

                mixpanel_master = instance;
                if (init_type === INIT_SNIPPET) {
                    window$1[PRIMARY_INSTANCE_NAME] = mixpanel_master;
                }
                extend_mp();
            }
        };
    };

    var add_dom_loaded_handler = function() {
        // Cross browser DOM Loaded support
        function dom_loaded_handler() {
            // function flag since we only want to execute this once
            if (dom_loaded_handler.done) { return; }
            dom_loaded_handler.done = true;

            DOM_LOADED = true;
            ENQUEUE_REQUESTS = false;

            _.each(instances, function(inst) {
                inst._dom_loaded();
            });
        }

        function do_scroll_check() {
            try {
                document$1.documentElement.doScroll('left');
            } catch(e) {
                setTimeout(do_scroll_check, 1);
                return;
            }

            dom_loaded_handler();
        }

        if (document$1.addEventListener) {
            if (document$1.readyState === 'complete') {
                // safari 4 can fire the DOMContentLoaded event before loading all
                // external JS (including this file). you will see some copypasta
                // on the internet that checks for 'complete' and 'loaded', but
                // 'loaded' is an IE thing
                dom_loaded_handler();
            } else {
                document$1.addEventListener('DOMContentLoaded', dom_loaded_handler, false);
            }
        } else if (document$1.attachEvent) {
            // IE
            document$1.attachEvent('onreadystatechange', dom_loaded_handler);

            // check to make sure we arn't in a frame
            var toplevel = false;
            try {
                toplevel = window$1.frameElement === null;
            } catch(e) {
                // noop
            }

            if (document$1.documentElement.doScroll && toplevel) {
                do_scroll_check();
            }
        }

        // fallback handler, always will work
        _.register_event(window$1, 'load', dom_loaded_handler, true);
    };

    function init_as_module() {
        init_type = INIT_MODULE;
        mixpanel_master = new MixpanelLib();

        override_mp_init_func();
        mixpanel_master['init']();
        add_dom_loaded_handler();

        return mixpanel_master;
    }

    var mixpanel = init_as_module();

    var mixpanel_cjs = mixpanel;

    //                                      Copyright 2024 WebPros International, LLC
    //                                                           All rights reserved.
    // copyright@cpanel.net                                         http://cpanel.net
    // This code is subject to the cPanel license. Unauthorized copying is prohibited.
    /**
     * A place to store constants used by the Mixpanel tool.
     */
    const MixpanelConstants = {
      devProjectToken: "c7c6f1b1bc8e7b3d8254ebe545861955",
      prodProjectToken: "2cca34424fe0e8ad6897d354b9591c45",
      mpUserSession: "mp_cp_user_session",
      mpResetSession: "mp_cp_reset_session",
    };

    //                                      Copyright 2024 WebPros International, LLC
    class MixpanelUtilsService {
      /**
       * Initialize Mixpanel for the workspace (cPanel, Webmail or WHM)
       * that calls this function.
       * Note: It DOES NOT track any analytics data yet.
       */
      initializeMixpanel(config) {
        // Need this for sending into 'loaded' handler.
        const mixpanelUtilsSvc = this;
        let mixpanelConfig = config && typeof config === "string" ? JSON.parse(unescape(config)) : config;
        let debugMode = mixpanelConfig.debugMode || false;
        let isQaBuild = true;
        if (mixpanelConfig.cpAnalyticsData) {
          isQaBuild =
            !mixpanelConfig.cpAnalyticsData.is_nat && mixpanelConfig.cpAnalyticsData.server_main_ip_is_private;
        }
        let accessToken = this._isProdEnvironment(mixpanelConfig.isSandbox, isQaBuild)
          ? MixpanelConstants.prodProjectToken
          : MixpanelConstants.devProjectToken;
        mixpanel_cjs.init(accessToken, {
          debug: debugMode,
          property_blacklist: [
            // properties that reveal the cpSess CSRF url path
            "$initial_referrer",
            "url",
          ],
          ip: false,
          autotrack: false,
          api_host: "https://api-eu.mixpanel.com",
          loaded: function (mixpanel) {
            // Remove old ones if a new user is detected.
            if (mixpanelConfig.loginUser !== sessionStorage.getItem(MixpanelConstants.mpUserSession)) {
              sessionStorage.removeItem(MixpanelConstants.mpUserSession);
              sessionStorage.removeItem(MixpanelConstants.mpResetSession);
            }
            if (mixpanelConfig.optInAnalytics) {
              mixpanelUtilsSvc.enableAnalyticsForFirstTime(mixpanelConfig);
            }
            else {
              // The init allows track events by default. Disable it here and
              // Let it get enabled when the user consent is checked and mixpanel
              // properties are actually getting registered.
              mixpanel.opt_out_tracking();
            }
            window["mixpanel"] = mixpanel;
          },
        });
      }
      /**
       * Enables analytics first time after login if user's consent is set to 'Allow' or 'on'
       * @param mixpanelConfig    An object that includes mixpanel specific data.
       */
      enableAnalyticsForFirstTime(mixpanelConfig) {
        if (!mixpanelConfig.cpAnalyticsData) {
          return;
        }
        // Store user logged in event when loaded the first time.
        if (!sessionStorage.getItem(MixpanelConstants.mpUserSession)) {
          sessionStorage.setItem(MixpanelConstants.mpUserSession, mixpanelConfig.loginUser);
        }
        this._registerMixpanel(mixpanel_cjs, mixpanelConfig.cpAnalyticsData);
      }
      /**
       * Registers Mixpanel for the workspace (cPanel, Webmail or WHM)
       * that calls this function.
       * Opts in analytics tracking.
       * Creates super properties and that can be accessed by all events.
       */
      _registerMixpanel(mixpanel, analyticsData) {
        if (Object.keys(analyticsData).length === 0) {
          return;
        }
        // Call Mixpanel's opt-in method.
        if (!mixpanel.has_opted_in_tracking()) {
          // We don't want this to create an unnecessary event.
          mixpanel.opt_in_tracking({ track: () => { } });
        }
        const tokenRegex = /\/cpsess\d+\//i;
        // Sanitize the url path.
        var path = this._getUrlPath().replace(tokenRegex, "/");
        var pageTitle = analyticsData.product_interface + "-" + (analyticsData.product_feature || path);
        // Register $current_url before the identify request to ensure it uses
        // the sanitized path in all requests.
        mixpanel.register({
          $current_url: path,
        });
        // Identify the user only if the UUID exists.
        if (analyticsData.UUID) {
          mixpanel.identify(analyticsData.UUID);
        }
        else if (!sessionStorage.getItem(MixpanelConstants.mpResetSession)) {
          // When UUID doesn't exist, Mixpanel SDK uses the previous UUID
          // stored in the cookie. That may end up identifying the current user
          // with a previous user's login. To avoid such situation, we are clearing
          // old data and recreating the props for the current user IF UUID doesn't exist.
          mixpanel.reset();
          sessionStorage.setItem(MixpanelConstants.mpResetSession, "true");
        }
        // Identify the team user only if is_team_user is true and get roles
        if (analyticsData.is_team_user) {
          mixpanel.people.set({ team_user_roles: analyticsData.team_user_roles });
        }
        // Register MixPanel. The properties set during registration are super properties.
        // These super properties are sent with all events tracked by Mixpanel.
        mixpanel.register(Object.assign({}, analyticsData));
        mixpanel.set_group("company_id", analyticsData.company_id);
        mixpanel.people.set({
          product_locale: analyticsData.product_locale,
          product_version: analyticsData.product_version,
          product_trial_status: analyticsData.product_trial_status,
          server_current_license_kind: analyticsData.server_current_license_kind,
          server_main_ip: analyticsData.server_main_ip,
          server_operating_system: analyticsData.server_operating_system,
          server_is_nat: analyticsData.is_nat,
          account_transferred_or_restored: analyticsData.TRANSFERRED_OR_RESTORED,
        });
        // Track Page view event.
        mixpanel.track(pageTitle, {});
      }
      /**
       * Opts out of analytics tracking for the
       * workspace (cPanel, Webmail or WHM)
       * from where this function is called.
       * Additionally, it also clears the super properties
       * that where set during the opt in phase.
       */
      optOutOfAnalytics() {
        if (mixpanel_cjs.has_opted_in_tracking()) {
          mixpanel_cjs.clear_opt_in_out_tracking();
          // Clear all the super properties before opting out.
          mixpanel_cjs.reset();
          mixpanel_cjs.opt_out_tracking();
        }
      }
      /**
       * Returns the sanitized path of the url.
       */
      _getUrlPath() {
        var path = window.location.pathname;
        if (path) {
          var wholepath = path.split("/");
          var custompath = wholepath.slice(2);
          path = "/" + custompath.join("/");
        }
        return path;
      }
      /**
       * Return if the current environment is Production or Development
       * based on sandbox touchfile and IP addressing.
       */
      _isProdEnvironment(isSandbox, isQaBuild) {
        return isSandbox || isQaBuild ? false : true;
      }
    }
    const mixpanelUtils = new MixpanelUtilsService();

    const CpLoadMixpanelJs$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.mixpanelInstanceLoaded = createEvent(this, "mixpanelInstanceLoaded", 7);
        /**
         * IMPORTANT: This is a special variable used to identify if mixpanel is loaded from
         * cp-analytics package.
         * REASON: The users have the ability to disable either or both cp-analytics package updates and cPanel version updates.
         * So to AVOID the situation where the users may end up loading mixpanel DOUBLE times, we added this flag
         * to check if it is available from package and create the new distribution/load strategy ONLY
         * when it DOES NOT exist.
         */
        this.mixpanelAvailableThroughRpm = false;
      }
      componentWillLoad() {
        /**
         * DEV NOTES: The mixpanel instrumentation is now moved to ULC but the consent popup still exists in cp-analytics package.
         * In the scenario where the user gave consent and then later server admin uninstalls cp-analytics package, the consent popup
         * does NOT appear for the user in any workspace (:2083, :2087 and :2096).
         * Since they don't have control to 'Allow'/'Deny' in this scenario, we have to abort mixpanel tracking.
         *
         * The need for this check should go away when consent gathering interface moves to the ULC codebase.
         */
        const analyticsPopup = document.querySelector("#analyticsContainer");
        if (analyticsPopup == null) {
          return;
        }
        /**
         * Having mixpanel defined already tells the system that cp-analytics package did not update.
         * (It could be because the server admin excluded it from updates or just disabled manually)
         * In such case, the system just uses the one defined in cp-analytics package. It helps to avoid
         * double duplication of mixpanel instance.
         */
        if (typeof window["mixpanel"] !== "undefined") {
          this.mixpanelAvailableThroughRpm = true;
        }
        else {
          this.mixpanelAvailableThroughRpm = false;
          mixpanelUtils.initializeMixpanel(this.analyticsConfig);
        }
        this.mixpanelInstanceLoaded.emit();
      }
      /**
       * Listens for consentPrivacySaved event dispatched even when consent and privacy settings are changed and saved
       * outside of the webcomponent area. Hence the reason why this listener targets at the body of the document.
       *
       * @param event
       * @returns
       */
      handleConsentPrivacySavedEvent(event) {
        if (event.detail.analytics) {
          mixpanelUtils.enableAnalyticsForFirstTime(JSON.parse(unescape(this.analyticsConfig)));
        }
        else {
          mixpanelUtils.optOutOfAnalytics();
        }
      }
      render() {
        return !this.mixpanelAvailableThroughRpm ? h(Host, null) : "";
      }
    };

    /**
    # cpanel - ui/web-components/src/components/shared/cp-logo/logo-types.ts
    #                                                  Copyright 2022 cPanel, L.L.C.
    #                                                           All rights reserved.
    # copyright@cpanel.net                                         http://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
     */
    var LogoType;
    (function (LogoType) {
      LogoType["CpanelOrangeLg"] = "./assets/cpanel-logo-orange.svg";
      LogoType["CpanelWhiteLg"] = "./assets/cpanel-logo-white.svg";
    })(LogoType || (LogoType = {}));

    const cpLogoCss = ":host{flex-grow:1}.logo{width:auto;max-width:200px;max-height:100px;min-height:25px;height:-moz-max-content;height:max-content}@media (max-width: 767.98px){.logo{max-width:150px;max-height:50px}}";

    const locale$p = getLocaleInstance();
    const CpLogo$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        /**
         * The href for the anchor tag surrounding the logo.
         */
        this.logoLinkHref = "index.html";
        /**
         * Target for the anchor tag.
         */
        this.linkTarget = "";
        /**
         * Title attribute for the anchor tag.
         */
        this.logoTitle = "";
        /**
         * Id attribute for the logo.
         */
        this.logoId = "";
        /**
         * src attribute for the logo.
         */
        this.logoSrc = getAssetPath(LogoType.CpanelOrangeLg);
        /**
         * Alt text which will override the default logo description.
         */
        this.logoAltText = "";
      }
      /**
       * Stencil lifecycle. Gets values from state.
       */
      componentWillRender() {
        this.directoryPrefix = state.directoryPrefix;
      }
      /**
       * The href property after checking if it is internal or external.
       */
      get parsedLogoLinkHref() {
        // If the link contains http, it is external so we don't add the directoryPrefix
        if (this.logoLinkHref.includes("http")) {
          return this.logoLinkHref;
        }
        return `${this.directoryPrefix}${this.logoLinkHref}`;
      }
      /**
       * When called, applies focus to the a tag within this component
       */
      async doFocus() {
        this.linkEl.focus();
      }
      render() {
        return (h(Host, null, h("cp-dir", null, h("a", { tabindex: "0", href: this.parsedLogoLinkHref, ref: el => (this.linkEl = el), target: this.linkTarget, title: this.logoTitle }, h("img", { id: this.logoId, class: "logo", src: this.logoSrc, alt: this.logoAltText ? this.logoAltText : locale$p.maketext("cPanel logo") })))));
      }
      get host() { return this; }
      static get style() { return cpLogoCss; }
    };

    const cpMainMenuCss = "nav{display:block;background:var(--cp-tertiary, #202654);color:var(--cp-tertiary-contrast, #c3c7cc);height:100%;box-sizing:border-box}.cp-main-menu__logo-container{display:flex;justify-content:flex-start;align-items:baseline}";

    const CpMainMenu$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        /**
         * base64-encoded SVG or url
         */
        this.logoSrc = "";
        /**
         * Optional logo description. This is needed because the logo can be custom and the alt
         * text needs to accurately describe the logo displayed.
         */
        this.logoAltText = "";
      }
      componentWillLoad() {
        this._appName = state.appName;
      }
      /**
       * Handles the scroll event of the nav menu
       */
      handleScroll() {
        var _a;
        this.renderBoxShadow = ((_a = this.navElement) === null || _a === void 0 ? void 0 : _a.scrollTop) !== 0;
      }
      /**
       * Update the favorites dynamically when they are edited.
       *
       * @param items List of apps to put in the favorites category.
       */
      async updateFavorites(items) {
        var _a;
        await ((_a = this.menuEl) === null || _a === void 0 ? void 0 : _a.updateFavorites(items));
      }
      render() {
        return (h(Host, null, h("cp-style-reset", null, h("cp-dir", null, h("nav", { onScroll: () => this.handleScroll(), ref: el => (this.navElement = el) }, this._appName === AppName.Cpanel ? (h("cp-main-menu-nav", { "logo-src": this.logoSrc, "logo-alt-text": this.logoAltText })) : (h("cp-main-menu-nav-whm", { ref: el => (this.menuEl = el), "render-box-shadow": this.renderBoxShadow, "logo-alt-text": this.logoAltText })))))));
      }
      static get style() { return cpMainMenuCss; }
    };

    const cpMainMenuHeaderControlCss = ".cp-main-menu-header-control{display:flex}.btn-hamburger-menu{display:flex;background:transparent;border:none;padding:0;cursor:pointer}";

    const locale$o = getLocaleInstance();
    const CpMainMenuHeaderControl$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.mainMenuOpened = createEvent(this, "mainMenuOpened", 7);
        /**
         * Determines if the main menu is open.
         */
        this.isMainMenuOpen = false;
        /**
         * Main menu DOM element.
         */
        this.mainMenuEl = document.querySelector("#cp-main-menu-container");
        /**
         * Overlay DOM element.
         */
        this.overlayEl = document.querySelector("#page-overlay");
      }
      /**
       * Listens for click on component, opens menu
       */
      openMainMenu() {
        this.isMainMenuOpen = true;
      }
      /**
       * Listens for click on body, ensures menu closes on click-out
       */
      handleClickOut(event) {
        // If menu's already closed, exit early
        if (!this.isMainMenuOpen) {
          return;
        }
        // Check for click-out, close menu when user clicks out
        const isClickOutsideMenu = event.target === this.overlayEl;
        if (isClickOutsideMenu) {
          this.isMainMenuOpen = false;
        }
      }
      /**
       * Listens for ESC keypress on body, closes menu
       */
      handleKeyDown(event) {
        // If menu's already closed, exit early
        if (!this.isMainMenuOpen) {
          return;
        }
        if (event.key === "Escape") {
          this.isMainMenuOpen = false;
        }
      }
      /**
       * Triggers necessary DOM updates + event emissions whenever state or props update
       */
      componentWillUpdate() {
        this.updateDOMBasedOnMenuState();
        this.mainMenuOpened.emit(this.isMainMenuOpen);
      }
      /**
       * Manipulates the DOM as needed when the menu state changes.
       * Displays/hides main menu container
       * Displays/hides overlay
       * Brings focus back to the hamburger menu btn when the user closes the menu
       */
      updateDOMBasedOnMenuState() {
        if (!this.overlayEl || !this.mainMenuEl) {
          return;
        }
        if (this.isMainMenuOpen) {
          this.overlayEl.classList.add("page-overlay--cover-header");
          this.mainMenuEl.classList.add("cp-layout-main-menu--show");
        }
        else {
          this.overlayEl.classList.remove("page-overlay--cover-header");
          this.mainMenuEl.classList.remove("cp-layout-main-menu--show");
          // Ensure focus returns to menu toggle on menu close
          const menuBtnEl = this.host.querySelector("#hamburger-menu");
          menuBtnEl.focus();
        }
      }
      render() {
        return (h(Host, { class: "cp-main-menu-header-control" }, h("button", { id: "hamburger-menu", type: "button", class: "btn-hamburger-menu", "aria-expanded": `${this.isMainMenuOpen}`, "aria-label": locale$o.maketext("Open main menu") }, h("cp-icon", { name: "menu-line", size: IconSize.lg, mode: IconMode.Centered }))));
      }
      get host() { return this; }
      static get style() { return cpMainMenuHeaderControlCss; }
    };

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    /**
     * Tells whether a URL is absolute (i.e., has a scheme and all) or not.
     */
    function urlIsAbsolute(input) {
      return input.includes("://");
    }

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    class ExpandedLeftNavService {
      /**
       * Focuses the first link in the menu.
       * @param event
       * @param childLogo
       */
      async setFocus(event, childLogo) {
        const menuOpened = event.detail;
        if (menuOpened) {
          await childLogo.doFocus();
        }
      }
    }
    const expandedLeftNavService = new ExpandedLeftNavService();

    const cpMainMenuNavCss = ".cp-main-menu__container{padding:var(--cp-spacer-8) var(--cp-spacer-6) 0 var(--cp-spacer-6);height:100%;display:flex;flex-direction:column}.links{margin-top:var(--cp-spacer-8);flex-grow:1;scrollbar-color:var(--cp-tertiary, #202654) rgba(var(--cp-tertiary-rgb, 32, 38, 84), 0.1)}[dir=\"ltr\"] .links{padding-left:0}[dir=\"rtl\"] .links{padding-right:0}.links::-webkit-scrollbar{width:12px}.links::-webkit-scrollbar-track{background:rgba(var(--cp-tertiary-rgb, 32, 38, 84), 0.1)}.links::-webkit-scrollbar-thumb{background-color:var(--cp-tertiary, #202654);border-radius:20px;border:3px solid rgba(var(--cp-tertiary-rgb, 32, 38, 84), 0.1)}.list-item{list-style:none;margin-bottom:var(--cp-spacer-4)}.list-item:last-child{margin-bottom:0}.list-item a:focus{outline:1px dashed var(--cp-tertiary-contrast, #c3c7cc)}.list-item__link{display:block}.list-item__icon{display:inline;vertical-align:middle}[dir=\"ltr\"] .list-item__icon{margin-right:var(--cp-spacer-2);float:left}[dir=\"rtl\"] .list-item__icon{margin-left:var(--cp-spacer-2);float:right}.list-item__text{vertical-align:bottom;letter-spacing:0.04rem}a{color:var(--cp-tertiary-contrast, #c3c7cc)}a:link,a:visited,a:active,a:hover{color:var(--cp-tertiary-contrast, #c3c7cc);text-decoration:none}";

    /**
     * Is the given input an absolute path?
     */
    function _isAbsolutePath(input) {
      return input.startsWith("/");
    }
    const CpMainMenuNav$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
      }
      /**
       * The actual href value
       */
      _finalLinkURL(input) {
        if (urlIsAbsolute(input)) {
          return input;
        }
        if (_isAbsolutePath(input)) {
          // /foo/bar.html needs the security token added
          // (e.g., /cpsessXXXXX/foo/bar.html), but in cP
          // we don’t have the security token for now.
          //
          // This is here as a courtesy so that we get some
          // indicator of a deeper problem once someone tries
          // to send an absolute path in here.
          throw "No security token available!";
        }
        return this.directoryPrefix + input;
      }
      /**
       * Listens for mainMenuOpened event emission on body and focuses the first link in the menu.
       * @param event
       */
      async setFocus(event) {
        expandedLeftNavService.setFocus(event, this.childLogo);
      }
      analyticsInstanceLoadHandler() {
        var _a, _b;
        // Track link clicks from cPanel Jupiter's main menu.
        if (this._appName === AppName.Cpanel) {
          const navLinkEls = (_a = this.navLinks) === null || _a === void 0 ? void 0 : _a.querySelectorAll("li>a");
          if (navLinkEls === null || navLinkEls === void 0 ? void 0 : navLinkEls.length) {
            (_b = window["mixpanel"]) === null || _b === void 0 ? void 0 : _b.track_links(navLinkEls, "cPanel-Main-Menu-Nav-Link", linkEl => {
              return { "nav-link-id": linkEl.id };
            });
          }
        }
      }
      /**
       * Stencil lifecycle method
       */
      componentWillRender() {
        this.directoryPrefix = state.directoryPrefix;
        if (this.directoryPrefix && !this.directoryPrefix.endsWith("/")) {
          this.directoryPrefix += "/";
        }
        this.linkList = state.mainMenuLinks;
      }
      componentDidLoad() {
        this._appName = state.appName;
      }
      render() {
        return (h("div", { class: "cp-main-menu__container" }, h("div", { class: "cp-main-menu__logo-container" }, h("cp-logo", { ref: el => (this.childLogo = el), "logo-src": this.logoSrc, "logo-alt-text": this.logoAltText, id: "cp-main-menu__logo" })), h("ul", { class: "links", id: "cp-main-menu__link-list", ref: el => (this.navLinks = el) }, this.linkList.map(link => (h("li", { class: "list-item", key: link.id }, h("a", { id: link.id, class: "list-item__link", href: this._finalLinkURL(link.linkUrl) }, h("span", { class: "list-item__icon", role: "img", "aria-hidden": "true", innerHTML: link.iconSvg }), h("span", { class: "list-item__text" }, link.userText))))))));
      }
      static get style() { return cpMainMenuNavCss; }
    };

    /**
    # cpanel - ui/web-components/src/components/main-menu/cp-main-menu-nav-whm/session-storage-keys.ts
    #                                                  Copyright 2022 cPanel, L.L.C.
    #                                                           All rights reserved.
    # copyright@cpanel.net                                         http://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    /**
     * Keys used sessionStorage
     */
    var SessionStorage;
    (function (SessionStorage) {
      SessionStorage["SEARCHTERM"] = "searchTerm";
      SessionStorage["USERNAME"] = "userName";
    })(SessionStorage || (SessionStorage = {}));

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    class Category {
      /**
       * @param input - static properties
       * @param initialNavUrl - from the global store/state
       */
      constructor(input, initialNavUrl) {
        this._expansionStateChanged = false;
        Object.assign(this, input);
        this._containsLoadedPageApp = this.items.some(app => app.url === initialNavUrl);
      }
      shownExpanded() {
        if (this._containsLoadedPageApp) {
          if (!this._expansionStateChanged) {
            return true;
          }
        }
        return this.storedExpanded;
      }
      setExpansionState(newState) {
        this._expansionStateChanged = true;
        this.storedExpanded = newState;
      }
      /**
       * Update the list of apps in the category.
       *
       * @param items The list of apps to set for the category.
       */
      update(items) {
        this.items = items;
      }
    }

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    /**
     * Get saved personalization data for user
     */
    function getPersonalizationData(securityToken, store, name) {
      const body = {
        "api.version": 1,
        "names": [`${name}`],
        "store": `${store}`,
      };
      const request = new Request(buildRequestURL(securityToken, "personalization_get"), {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
        },
        body: JSON.stringify(body),
      });
      return fetch(request)
        .then(resp => {
        return resp.json();
      })
        .then(data => {
        if (data.metadata && !data.metadata.result) {
          throw data.metadata.reason;
        }
        else {
          return data.data.personalization;
        }
      })
        .catch(error => {
        console.error(`DEV ERROR: ${error}`);
      });
    }
    /**
     * Set personalization data for user
     */
    function setPersonalizationData(securityToken, store, name, data) {
      const body = {
        "api.version": 1,
        "store": `${store}`,
        "personalization": {},
      };
      body["personalization"][`${name}`] = data;
      const request = new Request(buildRequestURL(securityToken, "personalization_set"), {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
        },
        body: JSON.stringify(body),
      });
      return fetch(request)
        .then(resp => {
        return resp.json();
      })
        .then(data => {
        if (data.metadata && !data.metadata.result) {
          throw data.metadata.reason;
        }
        else {
          return data;
        }
      })
        .catch(error => {
        console.error(`DEV ERROR: ${error}`);
      });
    }

    // Copyright 2023 cPanel, L.L.C. - All rights reserved.
    // copyright@cpanel.net
    // https://cpanel.net
    // This code is subject to the cPanel license. Unauthorized copying is prohibited
    /**
     * Plugins category does not exist in dynamicui.conf. It is created dynamically if plugins exist.
     * This enum returns the hard coded key and name of the category if/when plugins exist.
     */
    var PluginsCategory;
    (function (PluginsCategory) {
      /**
       * Localizable display name
       * Note: Please localize the name wherever it's used.
       *
       * @example
       * const locale = getLocaleInstance();
       * const categoryName = "";
       * if (category.key === PluginsCategory.KEY){
       *      categoryName = locale.maketext(PluginsCategory.NAME)
       * }
       */
      PluginsCategory["NAME"] = "Plugins";
      /**
       * Non localized identifier key
       */
      PluginsCategory["KEY"] = "plugins";
    })(PluginsCategory || (PluginsCategory = {}));

    const cpMainMenuNavWhmCss = "@charset \"UTF-8\";input[type=search].hide-browser-clear-button::-ms-clear{display:none;width:0;height:0}input[type=search].hide-browser-clear-button::-ms-reveal{display:none;width:0;height:0}input[type=search].hide-browser-clear-button::-webkit-search-decoration,input[type=search].hide-browser-clear-button::-webkit-search-cancel-button,input[type=search].hide-browser-clear-button::-webkit-search-results-button,input[type=search].hide-browser-clear-button::-webkit-search-results-decoration{display:none}.flex-wrapper{height:100%;display:flex;flex-direction:column}.section-separator{width:100%;margin:0;border-top:1px solid var(--cp-tertiary-contrast, #c3c7cc);opacity:0.8}.navlist-container{font-size:15px;line-height:1.5;overflow-y:auto;scrollbar-color:var(--cp-tertiary, #202654) rgba(var(--cp-tertiary-rgb, 32, 38, 84), 0.1)}.navlist-container::-webkit-scrollbar{width:12px}.navlist-container::-webkit-scrollbar-track{background:#e5e7e9;opacity:0.1}.navlist-container::-webkit-scrollbar-thumb{background-color:var(--cp-tertiary, #202654);border-radius:20px;border:3px solid #e5e7e9}.links{margin-top:0;flex-grow:1}[dir=\"ltr\"] .links{padding:var(--cp-spacer-1) var(--cp-spacer-6) 0 var(--cp-spacer-4)}[dir=\"rtl\"] .links{padding:var(--cp-spacer-1) var(--cp-spacer-4) 0 var(--cp-spacer-6)}.links a:focus{outline:1px dashed var(--cp-tertiary-contrast, #c3c7cc)}.list-item{list-style:none;margin-bottom:var(--cp-spacer-1);font-weight:400}.list-item:last-child{margin-bottom:0}.list-item a{color:var(--cp-tertiary-contrast, #c3c7cc)}.list-item a:hover,.list-item a:focus{color:var(--cp-tertiary-contrast, #fafafa);opacity:1}.list-item.whm-current-tool .list-item__text{position:relative}.list-item.whm-current-tool .list-item__text::before{content:\"●\";color:var(--cp-tertiary-contrast, #fafafa);opacity:1;position:absolute;font-size:0.75rem;line-height:1.7}[dir=\"ltr\"] .list-item.whm-current-tool .list-item__text::before{left:calc(var(--cp-spacer-5) * -1)}[dir=\"rtl\"] .list-item.whm-current-tool .list-item__text::before{right:calc(var(--cp-spacer-5) * -1)}.list-item.whm-current-tool a,.list-item.whm-current-tool a:hover{color:var(--cp-tertiary-contrast, #fafafa);opacity:1}[dir=\"ltr\"] .list-item__icon{margin-right:var(--cp-spacer-1)}[dir=\"rtl\"] .list-item__icon{margin-left:var(--cp-spacer-1)}.list-item__category-link,.list-item__link{display:flex;align-items:center;opacity:0.9}.list-item__category-link:hover{opacity:1}.list-item__link{padding:2px}[dir=\"ltr\"] .list-item__link{margin-left:calc(var(--cp-spacer-2) * -1)}[dir=\"rtl\"] .list-item__link{margin-right:calc(var(--cp-spacer-2) * -1)}a:link,a:visited,a:active,a:hover{text-decoration:none}.toggle-all-container{margin-top:var(--cp-spacer-3);display:flex;justify-content:space-between;gap:var(--cp-spacer-1)}.toggle-all-container__button{font-size:15px;line-height:1.5;opacity:0.9;background:none;color:var(--cp-tertiary-contrast, #c3c7cc);cursor:pointer;border:1px solid var(--cp-tertiary-contrast, #c3c7cc);border-radius:0.25rem;flex:1 1 0;display:flex;justify-content:center;align-items:center}[dir=\"ltr\"] .toggle-all-container__button{margin-right:0;margin-right:var(--cp-spacer-2)}[dir=\"rtl\"] .toggle-all-container__button{margin-left:0;margin-left:var(--cp-spacer-2)}.toggle-all-container__button:hover,.toggle-all-container__button:active,.toggle-all-container__button:focus{color:var(--cp-tertiary-contrast, #fafafa);border:1px solid var(--cp-tertiary-contrast, #fafafa);opacity:1}[dir=\"ltr\"] .toggle-all-container__button:last-of-type{margin-right:0}[dir=\"rtl\"] .toggle-all-container__button:last-of-type{margin-left:0}.toggle-all-container__text{padding:var(--cp-spacer-1)}[dir=\"ltr\"] .toggle-all-container__text:not(:last-of-type){padding-right:var(--cp-spacer-1)}[dir=\"rtl\"] .toggle-all-container__text:not(:last-of-type){padding-left:var(--cp-spacer-1)}.list{padding-top:var(--cp-spacer-1)}[dir=\"ltr\"] .list{padding-left:var(--cp-spacer-8)}[dir=\"rtl\"] .list{padding-right:var(--cp-spacer-8)}.list a:hover{text-decoration:underline;color:var(--cp-tertiary-contrast, #c3c7cc);opacity:1}.cp-main-menu__header,.cp-main-menu__header--box-shadowed{position:sticky;top:0;padding:var(--cp-spacer-4) var(--cp-spacer-3) var(--cp-spacer-2) var(--cp-spacer-3);background-color:var(--cp-tertiary, #202654);z-index:1;margin-bottom:var(--cp-spacer-1)}.cp-main-menu__header--box-shadowed{box-shadow:0 0.125rem 0.25rem rgba(255, 255, 255, 0.08)}.cp-main-menu__input-container{height:2rem;width:100%;margin-top:var(--cp-spacer-3);display:flex;flex-direction:row;position:relative;background-color:var(--cp-tertiary-contrast, #c3c7cc);border-radius:0.25rem;font-size:15px}.cp-main-menu__filter-input{border:1px solid var(--cp-tertiary-contrast, #c3c7cc);border-radius:0.25rem;width:100%;box-sizing:border-box;background-color:rgba(var(--cp-tertiary-rgb, 32, 38, 84), 0.01)}[dir=\"ltr\"] .cp-main-menu__filter-input{padding:var(--cp-spacer-1) var(--cp-spacer-4) var(--cp-spacer-1) var(--cp-spacer-2)}[dir=\"rtl\"] .cp-main-menu__filter-input{padding:var(--cp-spacer-1) var(--cp-spacer-2) var(--cp-spacer-1) var(--cp-spacer-4)}.cp-main-menu__filter-input::-moz-placeholder{color:rgba(var(--cp-tertiary-rgb, 32, 38, 84), 0.9);opacity:1;}.cp-main-menu__filter-input:-ms-input-placeholder{color:rgba(var(--cp-tertiary-rgb, 32, 38, 84), 0.9);opacity:1;}.cp-main-menu__filter-input::placeholder{color:rgba(var(--cp-tertiary-rgb, 32, 38, 84), 0.9);opacity:1;}.cp-main-menu__filter-input:hover,.cp-main-menu__filter-input:active,.cp-main-menu__filter-input:focus{border:1px solid var(--cp-tertiary, #202654);outline:var(--cp-tertiary, #202654);background-color:#fafafa}.cp-main-menu__filter-input:-moz-placeholder-shown{overflow:ellipsis}.cp-main-menu__filter-input:-ms-input-placeholder{overflow:ellipsis}.cp-main-menu__filter-input:placeholder-shown{overflow:ellipsis}.text-white{color:white}.cp-main-menu__search-clear-search-button{height:100%;display:inline-flex;align-items:center;border:none;background-color:transparent;color:#6d7983;position:absolute;cursor:pointer;padding:var(--cp-spacer-1)}[dir=\"ltr\"] .cp-main-menu__search-clear-search-button{right:0}[dir=\"rtl\"] .cp-main-menu__search-clear-search-button{left:0}";

    /* Should *not* be a property of App because this ID is local to this
     * particular Stencil component.
     */
    function navItemID(appUrl) {
      let scrubbed = appUrl.replace(/[^0-9a-zA-Z_-]/g, "_");
      return `app-nav-${scrubbed}`;
    }
    const locale$n = getLocaleInstance();
    const CpMainMenuNavWhm$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        /**
         * Store property for personalization APIs
         */
        this._personalizationStore = "left-navigation";
        /**
         * Name property for personalization APIs
         */
        this._personalizationName = "toggle-status";
      }
      /**
       * Show clear button if search input has text in it.
       */
      get showClearSearchButton() {
        var _a;
        return ((_a = this.filterInputText) === null || _a === void 0 ? void 0 : _a.length) > 0;
      }
      watchRenderBoxShadowProp(newValue) {
        this.renderBoxShadow = newValue;
      }
      /**
       * Save category toggle status
       */
      async _propagateCategoriesState() {
        // Since category state manifests only in internals of objects
        // that Stencil holds, Stencil doesn’t see those state changes.
        // Thus, we have to redraw explicitly.
        forceUpdate(this.element);
        const data = {};
        this.categories.forEach(category => {
          data[category.group] = fromBoolean(category.storedExpanded);
        });
        await setPersonalizationData(this._securityToken, this._personalizationStore, this._personalizationName, data);
      }
      /**
       * Toggle visibility of all category lists
       */
      toggleAllCategories(expand) {
        this.categories.forEach(category => {
          category.setExpansionState(expand);
        });
        this._propagateCategoriesState();
      }
      /**
       * Toggle visibility of single category list
       */
      setCategoryExpansion(category, expand) {
        category.setExpansionState(expand);
        this._propagateCategoriesState();
      }
      /**
       * Returns a Category[] of the actual items to display
       * in the left-nav menu.
       */
      _categoriesForDisplay() {
        return this.categories.filter(category => !!category.items.length);
      }
      /**
       * Appends the Favorites category to the list
       * of categories in the left-nav menu.
       */
      _addFavoritesCategory(expanded) {
        const favoritesCategory = {
          dnsonly_ok: "dns",
          group: "favorites",
          groupdesc: "Favorites",
          items: state.favorites,
          key: "favorites",
          searchtext: "favorites",
        };
        this.unfilteredCategories.unshift(new Category(Object.assign(Object.assign({}, JSON.parse(JSON.stringify(favoritesCategory))), { storedExpanded: expanded ? toBoolean(expanded[favoritesCategory.group]) : false }), state.initialNavUrl));
      }
      _findApp(item) {
        return state.appList.find((app) => {
          if (app.key == item.key) {
            return true;
          }
          return false;
        });
      }
      /**
       * Update the favorites after a user edits them.
       *
       * @param favorites List of favorites in the set.
       */
      async updateFavorites(items) {
        // Favorites is always at the top of the list
        let favoritesCategory = this.unfilteredCategories[0];
        if (items.length > 0) {
          if (favoritesCategory.group != "favorites") {
            let expanded = await this._fetchGroupExpansionData();
            this._addFavoritesCategory(expanded);
            favoritesCategory = this.unfilteredCategories[0];
          }
        }
        else {
          if (favoritesCategory.group == "favorites") {
            this.unfilteredCategories.splice(0, 1);
          }
        }
        // Update the items.
        if (favoritesCategory.group == "favorites") {
          let apps = items.reduce((apps, item) => {
            let app = this._findApp(item);
            if (app) {
              apps.push({
                url: "/" + app.url,
                itemorder: 1,
                itemdesc: app.name,
                description: app.description,
                target: app.target,
                searchtext: app.searchText.join(" "),
                key: app.key,
              });
            }
            return apps;
          }, []);
          favoritesCategory.update(apps);
        }
        const filterText = this.filterInputText;
        if (filterText) {
          // Reapply the filters
          this.categories = this._filterApps(filterText);
        }
        else {
          // or Show all categories and items.
          this.categories = this.unfilteredCategories;
        }
        // Since we change child properties possibly.
        forceUpdate(this.element);
      }
      async componentWillLoad() {
        this.flatApplicationList = state.appList;
        this._securityToken = state.directoryPrefix;
        const expandedGroups = await this._fetchGroupExpansionData();
        this.unfilteredCategories = this._getFullCategoriesList(expandedGroups);
        this._addFavoritesCategory(expandedGroups);
        this.categories = this.unfilteredCategories;
        this.searchService = new Fuse(this.flatApplicationList, WHM_MAIN_MENU_SEARCH_OPTIONS);
      }
      /**
       * Fetch personalization data for the user
       * @returns Promise of key value pair of strings describing categories and if they are expanded. Values are perl bools ie 1 or 0
       */
      async _fetchGroupExpansionData() {
        let response;
        if (state.permissions.basicWHMFunctions) {
          response = await getPersonalizationData(this._securityToken, this._personalizationStore, this._personalizationName);
          return response[this._personalizationName].value;
        }
        return null;
      }
      /**
       * Add additional data to categories from state.
       * @param expandedGroups key value pair of strings describing categories and if they are expanded. Values are perl bools ie 1 or 0
       * @returns Categories array
       */
      _getFullCategoriesList(expandedGroups) {
        let categoryList = state.categoryList.map(rawCategory => {
          return new Category(Object.assign(Object.assign({}, JSON.parse(JSON.stringify(rawCategory))), { storedExpanded: expandedGroups ? toBoolean(expandedGroups[rawCategory.group]) : false }), state.initialNavUrl);
        });
        return this._getPlugins(categoryList);
      }
      /**
       * Remove the plugin category if none exist, otherwise add any plugins to that category
       * @param categoryList Category array
       * @returns Categories array with or without plugin category group
       */
      _getPlugins(categoryList) {
        if (!state.plugins.length) {
          return categoryList.filter(category => {
            return category.group !== PluginsCategory.KEY;
          });
        }
        else {
          const idx = categoryList.findIndex(category => {
            return category.group === PluginsCategory.KEY;
          });
          state.plugins.forEach((plugin, index) => {
            categoryList[idx].items.push({
              url: plugin.url(),
              itemorder: index,
              itemdesc: plugin.name,
              description: "",
              key: plugin.key,
              searchtext: plugin.name,
            });
          });
          return categoryList;
        }
      }
      componentDidLoad() {
        let navUrl = state.initialNavUrl;
        const filterTextFromSession = this._getFilterInputText();
        if (filterTextFromSession) {
          this.filterInputText = filterTextFromSession;
          this.categories = this._filterApps(this.filterInputText);
        }
        if (navUrl) {
          const el = this.element.querySelector(`#${navItemID(navUrl)}`);
          if (el !== null && el !== undefined) {
            requestAnimationFrame(() => el.scrollIntoView({ behavior: "smooth", block: "center" }));
          }
        }
        this.searchInputElement = this.element.querySelector(".cp-main-menu__filter-input");
      }
      /**
       * Get the value of the filter input from sessionStorage.
       * This is done to keep the filter input across page navigations and across different tabs.
       * @returns string for the input text
       */
      _getFilterInputText() {
        const storageSearchTerm = sessionStorage.getItem(SessionStorage.SEARCHTERM);
        const storageUserName = sessionStorage.getItem(SessionStorage.USERNAME);
        const windowUserName = state.user;
        if (storageSearchTerm && storageUserName && storageUserName === windowUserName) {
          return storageSearchTerm;
        }
        // Most likely end up here because the user names don't match. So clear storage.
        sessionStorage.removeItem(SessionStorage.SEARCHTERM);
        sessionStorage.removeItem(SessionStorage.USERNAME);
        return "";
      }
      /**
       * The actual href value
       */
      _finalMenuHref(app) {
        return urlIsAbsolute(app.url) ? app.url : this._securityToken + app.url;
      }
      /**
       * Get the relevant elements that can be focused in the sidebar
       */
      getFocusNavigation(currentEl) {
        let elements = this.element.querySelectorAll("a");
        if (elements === null || elements === undefined) {
          return;
        }
        let index = Array.prototype.indexOf.call(elements, currentEl), nextEl = elements[index + 1], previousEl = elements[index - 1], categories = Array.prototype.filter.call(elements, (element, _index) => {
          return _index <= index && element.getAttribute("data-type") === "category";
        }), categoryEl = categories[categories.length - 1], firstEl = elements[0], lastEl = elements[elements.length - 1];
        return {
          nextEl,
          previousEl,
          categoryEl,
          firstEl,
          lastEl,
        };
      }
      /**
       * Handle the keydown event with the commands defined
       */
      handleKeyDown(event, category) {
        const commands = {
          ArrowLeft: function () {
            if (document.dir === "rtl") {
              this.setCategoryExpansion(category, true);
              return;
            }
            this.setCategoryExpansion(category, false);
            categoryEl.focus();
          },
          ArrowRight: function () {
            if (document.dir === "rtl") {
              this.setCategoryExpansion(category, false);
              categoryEl.focus();
              return;
            }
            this.setCategoryExpansion(category, true);
          },
          ArrowUp: function () {
            if (!previousEl) {
              return;
            }
            previousEl.focus();
          },
          ArrowDown: function () {
            if (!nextEl) {
              return;
            }
            nextEl.focus();
          },
          Home: function () {
            firstEl.focus();
          },
          End: function () {
            lastEl.focus();
          },
        };
        if (!commands[event.key]) {
          return;
        }
        const currentEl = (event.target || event.srcElement);
        const { nextEl, previousEl, categoryEl, firstEl, lastEl } = this.getFocusNavigation(currentEl);
        event.preventDefault();
        commands[event.key].bind(this)();
      }
      /**
       * Focus the next category when the down arrow is pressed in either expand/collapse all button
       */
      handleButtonKeyDown(event) {
        if (event.key !== "ArrowDown") {
          return;
        }
        event.preventDefault();
        let element = (event.target || event.srcElement);
        let { firstEl } = this.getFocusNavigation(element);
        firstEl.focus();
      }
      /**
       * Handles keyboard inputs when executed while the filter input is focused.
       * Handles moving down to the list of categories and apps.
       * @param event keyboard event from the input
       */
      handleFilterKeyDown(event) {
        const currentEl = event.target;
        const { nextEl } = this.getFocusNavigation(currentEl);
        if (nextEl) {
          this.handleButtonKeyDown(event);
        }
      }
      /**
       * Handles keyboard inputs when executed while the filter input is focused.
       * Handles clearing the input.
       * @param event keyboard event from the input
       * @returns void
       */
      handleFilterKeyUp(event) {
        if (event.key === "Escape") {
          this._clearFilterInput();
          return;
        }
      }
      /**
       * Filters the categories and their apps to display based on user input.
       * @param event onInput event from the input element
       * @returns void
       */
      _handleFilterInput(event) {
        var _a;
        // Handles the case of clicking the "x" in the input provided by the browser.
        if (!event.data && !event.inputType) {
          this._clearFilterInput();
          return;
        }
        this.filterInputText = (_a = event.target) === null || _a === void 0 ? void 0 : _a.value.trim();
        const emptyString = /^\s+$/g.test(this.filterInputText);
        this.categories = this.unfilteredCategories;
        // Don't do filtering if the input is empty or just spaces
        if (!this.filterInputText || emptyString) {
          this._clearFilterInput();
          return;
        }
        // Make a list of categories with filterd app lists
        this.categories = this._filterApps(this.filterInputText);
        this._saveFilterInput(this.filterInputText);
        event.stopPropagation();
      }
      /**
       * Handles clearing the filter input.
       */
      _clearFilterInput() {
        this.filterInputText = "";
        this.categories = this.unfilteredCategories;
        this._saveFilterInput(this.filterInputText);
      }
      /**
       * Creates a new list of categories whose apps contain the input text in their searchtext key.
       * @param input filter string
       * @returns
       */
      _filterApps(input) {
        // Get the fuzzy search results.
        const result = this.searchService.search(input);
        let resultListByCategory = result.reduce((newList, resultItem) => {
          var _a;
          if (newList[resultItem.item.categoryKey]) {
            (_a = newList[resultItem.item.categoryKey]) === null || _a === void 0 ? void 0 : _a.push(resultItem.item.key);
          }
          else {
            newList[resultItem.item.categoryKey] = [resultItem.item.key];
          }
          return newList;
        }, {});
        return this.categories.reduce((newCategoryList, category) => {
          var _a;
          if (((_a = resultListByCategory[category.group]) === null || _a === void 0 ? void 0 : _a.length) > 0) {
            const filteredAppList = category.items.filter(item => {
              var _a;
              return (_a = resultListByCategory[category.group]) === null || _a === void 0 ? void 0 : _a.includes(item.key);
            });
            const categoryWithFilteredItems = new Category(Object.assign(Object.assign({}, JSON.parse(JSON.stringify(category))), {
              // Set them all to expanded
              storedExpanded: true,
              // Show filtered list of apps
              items: filteredAppList
            }), state.initialNavUrl);
            newCategoryList.push(categoryWithFilteredItems);
          }
          return newCategoryList;
        }, []);
      }
      /**
       * When a user inputs a value in the filter, save it to sessionStorage with the current user name.
       * @param input string value from the filter input
       */
      _saveFilterInput(input) {
        sessionStorage.setItem(SessionStorage.SEARCHTERM, input);
        sessionStorage.setItem(SessionStorage.USERNAME, window["COMMON"].userName);
      }
      /**
       * Expand All/Collapse All when shift+8 is pressed
       */
      toggleCategories(event) {
        if (!(event.code == "Digit8" && event.shiftKey)) {
          return;
        }
        let allCollapsed = this.categories.every(function (category) {
          return !category.shownExpanded();
        });
        this.toggleAllCategories(allCollapsed);
      }
      /**
       * Focus the filter ctrl+/ is pressed
       * @param event keyboard event
       */
      focusFilterInput(event) {
        if (event.ctrlKey && event.key === "/") {
          this.searchInputElement.focus();
        }
      }
      /**
       * Listens for mainMenuOpened event emission on body and focuses the first link in the menu.
       * @param event
       */
      async setFocus(event) {
        expandedLeftNavService.setFocus(event, this.childLogo);
      }
      /**
       * Handle clear search click event.
       */
      handleClearSearchClicked() {
        this._clearFilterInput();
        this.searchInputElement.focus();
      }
      /**
       * Allows arrow navigation between Expand and Collapse.
       *
       * @remarks This method listens for keydown events on the document and changes the focus between the expand and collapse buttons based on the arrow keys pressed.
       *
       * @param event - The event object containing information about the keydown event.
       */
      changeButtonFocus(event) {
        var _a, _b;
        const [target] = event.composedPath();
        if (event.code === "ArrowRight" && target === this.expandButton) {
          (_a = this.collapseButton) === null || _a === void 0 ? void 0 : _a.focus();
        }
        else if (event.code === "ArrowLeft" && target === this.collapseButton) {
          (_b = this.expandButton) === null || _b === void 0 ? void 0 : _b.focus();
        }
      }
      render() {
        return (h("div", { class: "flex-wrapper" }, h("div", { class: this.renderBoxShadow ? "cp-main-menu__header--box-shadowed" : "cp-main-menu__header" }, h("div", { class: "cp-main-menu__logo-container" }, h("cp-logo", { ref: el => (this.childLogo = el), "logo-src": state.whmLogos.WhmWhiteLg, "logo-alt-text": this.logoAltText ? this.logoAltText : "", "logo-link-href": "/" }), isDnsOnly() && h("cp-dns-only", { class: "text-white" })), h("div", { class: "toggle-all-container" }, h("button", { ref: el => (this.expandButton = el), "data-key": "toggle-all-open-button", class: "toggle-all-container__button", onKeyDown: e => this.handleButtonKeyDown(e), onClick: () => this.toggleAllCategories(true), title: locale$n.maketext("Expand all category lists.") }, h("cp-icon", { name: "arrow-down-line", size: IconSize.inherit }), h("span", { class: "toggle-all-container__text" }, locale$n.maketext("Expand"))), h("button", { ref: el => (this.collapseButton = el), "data-key": "toggle-all-close-button", class: "toggle-all-container__button", onKeyDown: e => this.handleButtonKeyDown(e), onClick: () => this.toggleAllCategories(false), title: locale$n.maketext("Collapse all category lists.") }, h("cp-icon", { name: "arrow-up-line", size: IconSize.inherit }), h("span", { class: "toggle-all-container__text" }, locale$n.maketext("Collapse")))), h("div", { class: "cp-main-menu__input-container" }, h("input", { id: "main-menu-filter", class: "cp-main-menu__filter-input hide-browser-clear-button", type: "search", autocomplete: "off", spellcheck: "false", placeholder: locale$n.maketext("Search Tools (Ctrl /)[comment,placeholder text]"), title: locale$n.maketext("Search Tools (Ctrl /)[comment,placeholder text]"), "aria-label": locale$n.maketext("Search Tools (Ctrl /)[comment,placeholder text]"), value: this.filterInputText, onInput: e => this._handleFilterInput(e), onKeyDown: e => this.handleFilterKeyDown(e), onKeyUp: e => this.handleFilterKeyUp(e) }), this.showClearSearchButton && (h("button", { onClick: () => this.handleClearSearchClicked(), class: "cp-main-menu__search-clear-search-button", "aria-label": locale$n.maketext("Clear Search") }, h("cp-icon", { name: "close-line", size: IconSize.lg }))))), h("hr", { class: "section-separator" }), h("div", { class: "navlist-container" }, h("ul", { class: "links" }, this._categoriesForDisplay().map(category => (h("li", { class: "list-item", key: category.grouporder }, h("a", { "data-type": "category", class: "list-item__category-link", href: "javascript:void(0)", onKeyDown: e => this.handleKeyDown(e, category), onClick: () => this.setCategoryExpansion(category, !category.shownExpanded()) }, category.shownExpanded() ? (h("cp-icon", { class: "list-item__icon", name: "arrow-down-s-line", size: IconSize.lg, mode: IconMode.Inline })) : (h("cp-icon", { class: "list-item__icon", name: "arrow-right-s-line", size: IconSize.lg, mode: IconMode.Inline })), h("span", { class: "list-item__category-text" }, category.groupdesc)), category.shownExpanded() && (h("ul", { class: "list" }, category.items.map(item => (h("li", { class: "list-item" +
            (state.initialNavUrl === item.url ? " whm-current-tool" : ""), key: item.itemorder, id: navItemID(item.url) }, h("a", { onKeyDown: event => this.handleKeyDown(event, category), class: "list-item__link", href: this._finalMenuHref(item), target: item.target, "data-type": "application" }, h("span", { class: "list-item__text", innerHTML: item.itemdesc }))))))))))))));
      }
      get element() { return this; }
      static get watchers() { return {
        "renderBoxShadow": ["watchRenderBoxShadowProp"]
      }; }
      static get style() { return cpMainMenuNavWhmCss; }
    };

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    var ModalSize;
    (function (ModalSize) {
      ModalSize["default"] = "";
      ModalSize["sm"] = "cp-modal-sm";
      ModalSize["lg"] = "cp-modal-lg";
      ModalSize["xl"] = "cp-modal-xl";
    })(ModalSize || (ModalSize = {}));

    /*
    # Copyright 2023 cPanel, L.L.C. - All rights reserved.
    # copyright@cpanel.net
    # https://cpanel.net
    # This code is subject to the cPanel license. Unauthorized copying is prohibited
    */
    var ModalState;
    (function (ModalState) {
      ModalState["OPEN"] = "open";
      ModalState["CLOSE"] = "close";
    })(ModalState || (ModalState = {}));

    const cpMigrationModalCss = ".cp-modal-content__container{font-weight:300;font-size:0.875rem}@media (max-width: 575.98px){.cp-modal-body{padding:0}}";

    const locale$m = getLocaleInstance();
    const CpMigrationModal$1 = class extends H {
      constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.migrationModalAriaLabel = locale$m.maketext("Migration modal[comment,aria label]");
        /**
         * Determines if the modal is open initially.
         */
        this.opened = false;
      }
      /**
       * Listens for the close modal event from the cp-modal component
       */
      modalDismiss() {
        this.opened = false;
      }
      /**
       * Watches for the modal opening to update the state.
       * @param newValue
       */
      openedChanged(newValue) {
        if (newValue !== true) {
          this.closeMigrationModalHandler();
        }
      }
      /**
       * Listens for the modal close event from the footer
       */
      async closeMigrationModalHandler() {
        await this.saveMigrationModalDismissal();
        this.changeModalState(ModalState.CLOSE);
      }
      componentDidRender() {
        if (this.opened === true) {
          this.changeModalState(ModalState.OPEN);
        }
      }
      /**
       * Saves the user preferences when modal is dismissed as an NVData entry.
       * NVData entry: cp-migration-panel_dismissed
       */
      async saveMigrationModalDismissal() {
        const request = new UapiRequest({
          namespace: "Personalization",
          method: "set",
          arguments: [new Argument("personalization", { "cp-migration-panel_dismissed": 1 })],
          config: {
            json: true,
          },
        });
        await UapiService.post(request)
          .then(uapiResponse => {
          if (uapiResponse.hasErrors) {
            throw uapiResponse.errors;
          }
          return uapiResponse;
        })
          .catch(errors => {
          if (!Array.isArray(errors)) {
            errors = [errors];
          }
          errors.forEach(error => console.error(`Error saving migration modal dismissal: ${error.message}`));
        });
      }
      /**
       * Opens or closes the migration modal based on the given input.
       * @param state ModalState
       */
      async changeModalState(state) {
        var _a;
        await customElements.whenDefined("cp-modal");
        const modalEl = (_a = this.el.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector("cp-modal");
        if (state === ModalState.OPEN) {
          await modalEl.open();
        }
        else {
          await modalEl.close();
        }
      }
      render() {
        return (h("cp-style-reset", null, h("cp-dir", null, h("cp-modal", { "modal-aria-label": this.migrationModalAriaLabel, "hide-title": "true", "modal-size": ModalSize.lg }, h("div", { id: "migrationModalContent", slot: "modal-content", class: "cp-modal-content__container" }, h("cp-migration-modal-body", null)), h("div", { id: "migrationModalFooter", slot: "modal-footer" }, h("cp-migration-modal-footer", null))))));
      }
      get el() { return this; }
      static get watchers() { return {
        "opened": ["openedChanged"]
      }; }
      static get style() { return cpMigrationModalCss; }
    };

    const cpMigrationModalBodyCss = ".container,.container-fluid,.container-xxl,.container-xl,.container-lg,.container-md,.container-sm{--cp-gutter-x:1.5rem;--cp-gutter-y:0;width:100%;padding-right:calc(var(--cp-gutter-x) * 0.5);padding-left:calc(var(--cp-gutter-x) * 0.5);margin-right:auto;margin-left:auto}@media (min-width: 576px){.container-sm,.container{max-width:540px}}@media (min-width: 768px){.container-md,.container-sm,.container{max-width:720px}}@media (min-width: 992px){.container-lg,.container-md,.container-sm,.container{max-width:960px}}@media (min-width: 1200px){.container-xl,.container-lg,.container-md,.container-sm,.container{max-width:1140px}}@media (min-width: 1400px){.container-xxl,.container-xl,.container-lg,.container-md,.container-sm,.container{max-width:1320px}}.row{--cp-gutter-x:1.5rem;--cp-gutter-y:0;display:flex;flex-wrap:wrap;margin-top:calc(-1 * var(--cp-gutter-y));margin-right:calc(-0.5 * var(--cp-gutter-x));margin-left:calc(-0.5 * var(--cp-gutter-x))}.row>*{flex-shrink:0;width:100%;max-width:100%;padding-right:calc(var(--cp-gutter-x) * 0.5);padding-left:calc(var(--cp-gutter-x) * 0.5);margin-top:var(--cp-gutter-y)}.col{flex:1 0 0%}.row-cols-auto>*{flex:0 0 auto;width:auto}.row-cols-1>*{flex:0 0 auto;width:100%}.row-cols-2>*{flex:0 0 auto;width:50%}.row-cols-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-4>*{flex:0 0 auto;width:25%}.row-cols-5>*{flex:0 0 auto;width:20%}.row-cols-6>*{flex:0 0 auto;width:16.6666666667%}.col-auto{flex:0 0 auto;width:auto}.col-1{flex:0 0 auto;width:8.33333333%}.col-2{flex:0 0 auto;width:16.66666667%}.col-3{flex:0 0 auto;width:25%}.col-4{flex:0 0 auto;width:33.33333333%}.col-5{flex:0 0 auto;width:41.66666667%}.col-6{flex:0 0 auto;width:50%}.col-7{flex:0 0 auto;width:58.33333333%}.col-8{flex:0 0 auto;width:66.66666667%}.col-9{flex:0 0 auto;width:75%}.col-10{flex:0 0 auto;width:83.33333333%}.col-11{flex:0 0 auto;width:91.66666667%}.col-12{flex:0 0 auto;width:100%}[dir=\"ltr\"] .offset-1{margin-left:8.33333333%}[dir=\"rtl\"] .offset-1{margin-right:8.33333333%}[dir=\"ltr\"] .offset-2{margin-left:16.66666667%}[dir=\"rtl\"] .offset-2{margin-right:16.66666667%}[dir=\"ltr\"] .offset-3{margin-left:25%}[dir=\"rtl\"] .offset-3{margin-right:25%}[dir=\"ltr\"] .offset-4{margin-left:33.33333333%}[dir=\"rtl\"] .offset-4{margin-right:33.33333333%}[dir=\"ltr\"] .offset-5{margin-left:41.66666667%}[dir=\"rtl\"] .offset-5{margin-right:41.66666667%}[dir=\"ltr\"] .offset-6{margin-left:50%}[dir=\"rtl\"] .offset-6{margin-right:50%}[dir=\"ltr\"] .offset-7{margin-left:58.33333333%}[dir=\"rtl\"] .offset-7{margin-right:58.33333333%}[dir=\"ltr\"] .offset-8{margin-left:66.66666667%}[dir=\"rtl\"] .offset-8{margin-right:66.66666667%}[dir=\"ltr\"] .offset-9{margin-left:75%}[dir=\"rtl\"] .offset-9{margin-right:75%}[dir=\"ltr\"] .offset-10{margin-left:83.33333333%}[dir=\"rtl\"] .offset-10{margin-right:83.33333333%}[dir=\"ltr\"] .offset-11{margin-left:91.66666667%}[dir=\"rtl\"] .offset-11{margin-right:91.66666667%}.g-0,.gx-0{--cp-gutter-x:0}.g-0,.gy-0{--cp-gutter-y:0}.g-1,.gx-1{--cp-gutter-x:0.25rem}.g-1,.gy-1{--cp-gutter-y:0.25rem}.g-2,.gx-2{--cp-gutter-x:0.5rem}.g-2,.gy-2{--cp-gutter-y:0.5rem}.g-3,.gx-3{--cp-gutter-x:0.75rem}.g-3,.gy-3{--cp-gutter-y:0.75rem}.g-4,.gx-4{--cp-gutter-x:1rem}.g-4,.gy-4{--cp-gutter-y:1rem}.g-5,.gx-5{--cp-gutter-x:1.25rem}.g-5,.gy-5{--cp-gutter-y:1.25rem}.g-6,.gx-6{--cp-gutter-x:1.5rem}.g-6,.gy-6{--cp-gutter-y:1.5rem}.g-7,.gx-7{--cp-gutter-x:1.75rem}.g-7,.gy-7{--cp-gutter-y:1.75rem}.g-8,.gx-8{--cp-gutter-x:2rem}.g-8,.gy-8{--cp-gutter-y:2rem}.g-9,.gx-9{--cp-gutter-x:2.5rem}.g-9,.gy-9{--cp-gutter-y:2.5rem}.g-10,.gx-10{--cp-gutter-x:3rem}.g-10,.gy-10{--cp-gutter-y:3rem}@media (min-width: 576px){.col-sm{flex:1 0 0%}.row-cols-sm-auto>*{flex:0 0 auto;width:auto}.row-cols-sm-1>*{flex:0 0 auto;width:100%}.row-cols-sm-2>*{flex:0 0 auto;width:50%}.row-cols-sm-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-sm-4>*{flex:0 0 auto;width:25%}.row-cols-sm-5>*{flex:0 0 auto;width:20%}.row-cols-sm-6>*{flex:0 0 auto;width:16.6666666667%}.col-sm-auto{flex:0 0 auto;width:auto}.col-sm-1{flex:0 0 auto;width:8.33333333%}.col-sm-2{flex:0 0 auto;width:16.66666667%}.col-sm-3{flex:0 0 auto;width:25%}.col-sm-4{flex:0 0 auto;width:33.33333333%}.col-sm-5{flex:0 0 auto;width:41.66666667%}.col-sm-6{flex:0 0 auto;width:50%}.col-sm-7{flex:0 0 auto;width:58.33333333%}.col-sm-8{flex:0 0 auto;width:66.66666667%}.col-sm-9{flex:0 0 auto;width:75%}.col-sm-10{flex:0 0 auto;width:83.33333333%}.col-sm-11{flex:0 0 auto;width:91.66666667%}.col-sm-12{flex:0 0 auto;width:100%}[dir=\"ltr\"] .offset-sm-0{margin-left:0}[dir=\"rtl\"] .offset-sm-0{margin-right:0}[dir=\"ltr\"] .offset-sm-1{margin-left:8.33333333%}[dir=\"rtl\"] .offset-sm-1{margin-right:8.33333333%}[dir=\"ltr\"] .offset-sm-2{margin-left:16.66666667%}[dir=\"rtl\"] .offset-sm-2{margin-right:16.66666667%}[dir=\"ltr\"] .offset-sm-3{margin-left:25%}[dir=\"rtl\"] .offset-sm-3{margin-right:25%}[dir=\"ltr\"] .offset-sm-4{margin-left:33.33333333%}[dir=\"rtl\"] .offset-sm-4{margin-right:33.33333333%}[dir=\"ltr\"] .offset-sm-5{margin-left:41.66666667%}[dir=\"rtl\"] .offset-sm-5{margin-right:41.66666667%}[dir=\"ltr\"] .offset-sm-6{margin-left:50%}[dir=\"rtl\"] .offset-sm-6{margin-right:50%}[dir=\"ltr\"] .offset-sm-7{margin-left:58.33333333%}[dir=\"rtl\"] .offset-sm-7{margin-right:58.33333333%}[dir=\"ltr\"] .offset-sm-8{margin-left:66.66666667%}[dir=\"rtl\"] .offset-sm-8{margin-right:66.66666667%}[dir=\"ltr\"] .offset-sm-9{margin-left:75%}[dir=\"rtl\"] .offset-sm-9{margin-right:75%}[dir=\"ltr\"] .offset-sm-10{margin-left:83.33333333%}[dir=\"rtl\"] .offset-sm-10{margin-right:83.33333333%}[dir=\"ltr\"] .offset-sm-11{margin-left:91.66666667%}[dir=\"rtl\"] .offset-sm-11{margin-right:91.66666667%}.g-sm-0,.gx-sm-0{--cp-gutter-x:0}.g-sm-0,.gy-sm-0{--cp-gutter-y:0}.g-sm-1,.gx-sm-1{--cp-gutter-x:0.25rem}.g-sm-1,.gy-sm-1{--cp-gutter-y:0.25rem}.g-sm-2,.gx-sm-2{--cp-gutter-x:0.5rem}.g-sm-2,.gy-sm-2{--cp-gutter-y:0.5rem}.g-sm-3,.gx-sm-3{--cp-gutter-x:0.75rem}.g-sm-3,.gy-sm-3{--cp-gutter-y:0.75rem}.g-sm-4,.gx-sm-4{--cp-gutter-x:1rem}.g-sm-4,.gy-sm-4{--cp-gutter-y:1rem}.g-sm-5,.gx-sm-5{--cp-gutter-x:1.25rem}.g-sm-5,.gy-sm-5{--cp-gutter-y:1.25rem}.g-sm-6,.gx-sm-6{--cp-gutter-x:1.5rem}.g-sm-6,.gy-sm-6{--cp-gutter-y:1.5rem}.g-sm-7,.gx-sm-7{--cp-gutter-x:1.75rem}.g-sm-7,.gy-sm-7{--cp-gutter-y:1.75rem}.g-sm-8,.gx-sm-8{--cp-gutter-x:2rem}.g-sm-8,.gy-sm-8{--cp-gutter-y:2rem}.g-sm-9,.gx-sm-9{--cp-gutter-x:2.5rem}.g-sm-9,.gy-sm-9{--cp-gutter-y:2.5rem}.g-sm-10,.gx-sm-10{--cp-gutter-x:3rem}.g-sm-10,.gy-sm-10{--cp-gutter-y:3rem}}@media (min-width: 768px){.col-md{flex:1 0 0%}.row-cols-md-auto>*{flex:0 0 auto;width:auto}.row-cols-md-1>*{flex:0 0 auto;width:100%}.row-cols-md-2>*{flex:0 0 auto;width:50%}.row-cols-md-3>*{flex:0 0 auto;width:33.3333333333%}.row-cols-md-4>*{flex:0 0 auto;width:25%}.row-cols-md-5>*{flex:0 0 auto;width:20%}.row-cols-md-6>*{flex:0 0 auto;width:16.6666666667%}.col-md-auto{flex:0 0 auto;width:auto}.col-md-