define("app/views/ROUTES",["cjt/util/locale"],(function(e){"use strict";return[{id:"listDomains",route:"/",hideTitle:!1,controller:"listDomains",templateUrl:"views/listDomains.phtml",title:e.maketext("List Domains"),breadcrumb:{id:"listDomains",name:e.maketext("List Domains"),path:"/"},resolve:{currentDomains:["domains",function(e){return e.get()}]}},{id:"createDomain",route:"/create",controller:"createDomain",templateUrl:"views/createDomain.ptt",title:e.maketext("Create a New Domain"),breadcrumb:{id:"createDomain",name:e.maketext("Create a New Domain"),path:"/create/",parentID:"listDomains"},resolve:{domainTypes:["domains",function(e){return e.getTypes()}],currentDomains:["domains",function(e){return e.get()}]}},{id:"manageDomain",route:"/manage",controller:"manageDomain",templateUrl:"views/manageDomain.ptt",hideTitle:!0,title:e.maketext("Manage the Domain"),breadcrumb:{id:"manageDomain",name:e.maketext("Manage the Domain"),path:"/manage/",parentID:"listDomains"},resolve:{domainTypes:["domains",function(e){return e.getTypes()}],currentDomains:["domains",function(e){return e.get()}]}}]})),define("app/services/domains",["angular","lodash","cjt/util/locale","cjt/io/uapi-request","cjt/io/api2-request","cjt/io/uapi","cjt/io/api2","cjt/modules","cjt/services/APICatcher"],(function(e,t,i,n,s){"use strict";var o=e.module("cpanel.domains.domains.service",["cjt2.services.apicatcher"]);o.value("PAGE",PAGE),o.value("DOMAIN_TYPE_CONSTANTS",{SUBDOMAIN:"subdomain",ADDON:"addon",ALIAS:"alias",MAIN:"main_domain"});var r={documentRoot:!0};o.factory("domains",["$q","APICatcher","DOMAIN_TYPE_CONSTANTS","PAGE",function(o,a,c,l){var u,d,h,m,_,p,f,g={},v=function(e){var t=this;Object.keys(e).forEach((function(i){t[i]=e[i]})),t.protocol=t.isHttpsRedirecting?"https":"http",t.isWildcard=t.domain&&"*"===t.domain.substr(0,1),t.canBeSuggested=!t.isWildcard},D=[{label:i.maketext("Subdomain"),value:c.SUBDOMAIN,requiresCustomDocumentRoot:!0,stat:"subdomains"},{label:i.maketext("Addon"),value:c.ADDON,requiresCustomDocumentRoot:!0,dependantStat:"subdomains",stat:"addon_domains"},{label:i.maketext("Alias"),value:c.ALIAS,stat:"aliases"}],b=function(){};function y(e,t){for(var i in e)if(e.hasOwnProperty(i)&&e[i].id===t)return e[i]}function w(e){for(var t in D)if(D.hasOwnProperty(t)&&D[t].value===e)return D[t]}function S(e){if(e){var t=null===e.maximum?void 0:Number(e.maximum),i=Number(e.usage);if(!isNaN(t))if(0===t||i/t>=1)return!0;return!1}}return(b.prototype=a)._cacheDomain=function(e){u||(u=[]);var t=new v(e);return g[t.domain]||(g[t.domain]=t,u.push(t)),e},b.prototype._uncacheDomain=function(e){if(!u)return!1;for(var t=this._getDomainObject(e),i=u.length-1;i>=0;i--)u[i].domain===t.domain&&u.splice(i,1)},b.prototype.getCurrentDomains=function(){return u},b.prototype._getDomainObject=function(e){return"string"==typeof e?this.findDomainByName(e):e},b.prototype._getSubDomainObject=function(e){return"string"==typeof e?this.findDomainByName(e+"."+this.getMainDomain().domain):e},b.prototype._associateAddonDomains=function(){var t=this;e.forEach(m,(function(e){var i=t._getSubDomainObject(e.subdomain);i&&(i.associatedAddonDomain=e.domain)}))},b.prototype.addSubdomain=function(t){var i=this,n=new s.Class;n.initialize("SubDomain","addsubdomain");var o=t.subdomain.substr(0,t.subdomain.length-(t.domain.length+1));return n.addArgument("domain",o),n.addArgument("rootdomain",t.domain),n.addArgument("canoff","1"),n.addArgument("disallowdot","0"),n.addArgument("dir",t.fullDocumentRoot),i.promise(n).then((function(n){var s=t.newDomainName;return i.fetchSingleDomainData(s).then((function(n){return n=e.extend(n,{subdomain:n.subdomain,rootDomain:t.domain,type:c.SUBDOMAIN,canEdit:l.hasWebServerRole&&r,canRemove:!0}),i._cacheDomain(n)}))}))},b.prototype.addAddonDomain=function(t){var i=this,n=new s.Class;return n.initialize("AddonDomain","addaddondomain"),n.addArgument("subdomain",t.subdomain),n.addArgument("newdomain",t.newDomainName),n.addArgument("ftp_is_optional","1"),n.addArgument("dir",t.documentRoot),i.promise(n).then((function(){return i.fetchSingleDomainData(t.newDomainName).then((function(n){var s=e.extend(e.copy(n),{type:c.ADDON,subdomain:t.subdomain,canEdit:l.hasWebServerRole&&r,canRemove:!0});return i._cacheDomain(e.extend(e.copy(n),{domain:t.subdomain+"."+t.domain,subdomain:t.subdomain,type:c.SUBDOMAIN,associatedAddonDomain:s,canEdit:l.hasWebServerRole&&r,canRemove:!0})),i._cacheDomain(s)}))}))},b.prototype.addAliasDomain=function(t){var i=this,n=new s.Class;return n.initialize("Park","park"),n.addArgument("domain",t.newDomainName),i.promise(n).then((function(){var n=e.copy(i.getMainDomain());return n.domain=t.newDomainName,n.type=c.ALIAS,n.canRemove=!0,i._cacheDomain(n)}))},b.prototype.add=function(e){var t,i=this;return e.domainType===c.SUBDOMAIN?t=i.addSubdomain(e):e.domainType===c.ADDON?t=i.addAddonDomain(e):e.domainType===c.ALIAS&&(t=i.addAliasDomain(e)),t.then((function(t){var n=w(e.domainType),s=y(i.getUsageStats(),n.stat);return s&&s.usage++,i.updateDomainTypeLimits(),t})),t},b.prototype.generateFullDocumentRoot=function(e){var t="1"===l.requirePublicHTMLSubs.toString(),i=this.getMainDomain().homedir+"/";return t&&(i+="public_html/"),i+=e?e.replace(/^\//,""):""},b.prototype.getMainDomain=function(){return d},b.prototype.findDomainByName=function(e){return g[e]},b.prototype.fetchSingleDomainData=function(e){var t=this,i=new n.Class;return i.initialize("DomainInfo","single_domain_data"),i.addArgument("domain",e),i.addArgument("return_https_redirect_status",1),t.promise(i).then((function(e){var i=0;return"addon_domain"===e.data.type?i=c.ADDON:"sub_domain"===e.data.type&&(i=c.SUBDOMAIN),t.formatSingleDomain(e.data,i)}))},b.prototype.fetchDomains=function(){var e=this,i=new n.Class;return i.initialize("DomainInfo","domains_data"),i.addArgument("return_https_redirect_status",1),e.promise(i).then((function(i){var n=e.formatSingleDomain(i.data.main_domain);n.type=c.MAIN,n.canRemove=!1,d=n,e._cacheDomain(d),_=[];var s=i.data.sub_domains||[];return s.forEach((function(t){var i=e.formatSingleDomain(t,c.SUBDOMAIN);this.push(i),e._cacheDomain(i)}),_),m=[],(s=i.data.addon_domains||[]).forEach((function(i){var n=e.formatSingleDomain(i,c.ADDON);this.push(n),e._cacheDomain(n);var s=t.assign({},n);s.domain=s.rootDomain,s.type=c.SUBDOMAIN,_.push(s),e._cacheDomain(s)}),m),h=[],i.data.parked_domains.forEach((function(t){var n=e.formatSingleDomain(i.data.main_domain,c.ALIAS);n.domain=t,this.push(n),e._cacheDomain(n)}),h),d}))},b.prototype.formatSingleDomain=function(e,t){var i={domain:e.domain,homedir:e.homedir,documentRoot:e.documentroot||e.dir,rootDomain:e.servername,isHttpsRedirecting:parseInt(e.is_https_redirecting),hasValidHTTPSAliases:parseInt(e.all_aliases_valid),nonHTTPS:!parseInt(e.can_https_redirect),redirectsTo:"not redirected"===e.status?null:e.status,type:e.type,realRootDomain:l.mainDomain};if(t){i.type=t,i.homedir=this.getMainDomain().homedir;var n=this.getMainDomain().domain;if(t===c.SUBDOMAIN){var s=e.domain.match(/.*\.(.+\..+)$/);n=s?s[1]:n}var o=i.rootDomain?i.rootDomain.substr(0,i.rootDomain.lastIndexOf("."+n)):null;i.canRemove=!0,t!==c.ALIAS&&(i.canEdit=l.hasWebServerRole&&r,i.subdomain=o),t===c.SUBDOMAIN?i.rootDomain=n:t===c.ALIAS&&(i.rootDomain=l.mainDomain)}return i},b.prototype.get=function(){var e=this;return f||(u?o.resolve(u):(u=[],f=e.fetchDomains().then((function(){return e._associateAddonDomains(),u})).finally((function(){f=null}))))},b.prototype.getResourceUsageStats=function(){var e=new n.Class;return e.initialize("ResourceUsage","get_usages"),this.promise(e).then((function(e){return e.data}))},b.prototype.getDomainTypes=function(){return D},b.prototype.getUsageStats=function(){return p},b.prototype.updateDomainTypeLimits=function(){var e=this,t=e.getUsageStats();return e.getDomainTypes().forEach((function(e){var i=y(t,e.stat);e.overLimit=S(i),"1"!==l.hasWebServerRole&&e.requiresCustomDocumentRoot?e.overLimit=!0:!e.overLimit&&e.dependantStat&&(e.overLimit=e.overLimit||S(y(t,e.dependantStat)))})),e.getDomainTypes()},b.prototype.getTypes=function(){var e=this;return e.getUsageStats()?o.resolve(e.getDomainTypes()):e.getResourceUsageStats().then((function(t){return p=t,e.updateDomainTypeLimits(),e.getDomainTypes()}))},b.prototype.updateDocumentRoot=function(e,t){var i=this,n=i._getDomainObject(e);["subdomain","rootDomain"].forEach((function(e){if(!n[e])throw new Error(e+" is required but undefined on "+n.domain)}));var o=n.rootDomain;n.type===c.ADDON&&(o=n.realRootDomain);var r=new s.Class;return r.initialize("SubDomain","changedocroot"),r.addArgument("subdomain",n.subdomain),r.addArgument("rootdomain",o),r.addArgument("dir",t),i.promise(r).then((function(e){return n.documentRoot=t,i.fetchSingleDomainData(n.domain).then((function(e){var t=e.documentRoot;if(n.type===c.ADDON){var s=i._getSubDomainObject(n.subdomain);s&&(s.documentRoot=t)}else if(n.associatedAddonDomain){i._getDomainObject(n.associatedAddonDomain).documentRoot=t}return n.documentRoot=t,n}))}))},b.prototype.removeSubdomain=function(e){var t,i=this._getDomainObject(e),n=new RegExp("."+i.rootDomain+"$");t=i.domain.match(n)?i.subdomain+"_"+i.rootDomain:i.domain;var o=new s.Class;return o.initialize("SubDomain","delsubdomain"),o.addArgument("domain",t),this.promise(o)},b.prototype.removeAddonDomain=function(e){var t=this,i=t._getDomainObject(e),n=new s.Class;return n.initialize("AddonDomain","deladdondomain"),n.addArgument("domain",i.domain),n.addArgument("subdomain",i.subdomain+"_"+t.getMainDomain().domain),t.promise(n)},b.prototype.removeAliasDomain=function(e){var t=this._getDomainObject(e),i=new s.Class;return i.initialize("Park","unpark"),i.addArgument("domain",t.domain),this.promise(i)},b.prototype.removeRedirect=function(e){var t=this._getDomainObject(e),i=new n.Class;return i.initialize("Mime","delete_redirect"),i.addArgument("domain",t.domain),i.addArgument("src",t.redirectTo),i.addArgument("redirect",t.documentRoot),this.promise(i).then((function(){t.redirectTo=""}))},b.prototype._removeDomainAdjustStats=function(e){var t=this,i=t._getDomainObject(e);if(i){i.type===c.ADDON&&t._removeDomainAdjustStats(i.subdomain+"."+t.getMainDomain().domain),t._uncacheDomain(i);var n=w(i.type),s=y(t.getUsageStats(),n.stat);s&&s.usage--,t.updateDomainTypeLimits()}},b.prototype.remove=function(e){var i=this,n=i._getDomainObject(e),s=n.canEdit;n.canEdit=!1;var r=!1,a=[];return n.type===c.SUBDOMAIN?a.push(i.removeSubdomain(n)):n.type===c.ADDON?a.push(i.removeAddonDomain(n)):n.type===c.ALIAS&&(n.redirectTo&&a.push(i.removeRedirect(n)),a.push(i.removeAliasDomain(n))),n.removing=!0,o.all(a).then((function(e){i._removeDomainAdjustStats(n)}),(function(e){if(t.isArray(e))e.forEach((function(e){if(e&&e.error)throw r=!0,e.error}));else if(e&&e.error)throw r=!0,e.error;n.canEdit=s})).finally((function(){n.removing=!1,r||i._uncacheDomain(n)}))},b.prototype.getDocumentRootPattern=function(){return new RegExp("^[^"+t.escapeRegExp('%?* :|"<>\\')+"]+$")},b.prototype.canRedirectHTTPS=function(){return"1"===l.canRedirectHTTPS},b.prototype.toggleHTTPSRedirect=function(e,t){var i=new n.Class;if(i.initialize("SSL","toggle_ssl_redirect_for_domains"),i.addArgument("state",e?1:0),t){var s=t;i.addArgument("domains",s)}else{for(var o=[],r=0;r<u.length;r++)u[r].selected&&!u[r].associatedAddonDomain&&void 0===u[r].associatedAddonDomain&&o.push(u[r].domain);var a=o.join(",");i.addArgument("domains",a)}return this.promise(i)},new b}])})),define("app/views/createDomain",["lodash","angular","cjt/util/locale","cjt/services/fuzzy","cjt/modules","ngRoute","cjt/directives/callout","cjt/validator/domain-validators","cjt/validator/username-validators","cjt/directives/actionButtonDirective","app/services/domains","cjt/directives/validationContainerDirective","cjt/directives/validationItemDirective","cjt/directives/toggleSwitchDirective"],(function(e,t,i,n){"use strict";var s=new n,o="cpanel.domains.views.createDomain",r="createDomain";return t.module(o,["cpanel.domains.domains.service","ngRoute","cjt2.services.alert"]).controller(r,["$scope","$log","$location","$routeParams","$timeout","domains","alertService","domainTypes","DOMAIN_TYPE_CONSTANTS","PAGE","ZONE_EDITOR_APP_OBJ",function(n,o,r,a,c,l,u,d,h,m,_){var p={},f={};function g(){l.get().then((function(e){var t=e.filter((function(e){return!!e.canBeSuggested})).map((function(e){return e.domain}));s.loadSet(t)})),m.hasWebServerRole||(n.mustInheritDocumentRoot=!0)}function v(){n.creationDelayed=!0}function D(e){return l.findDomainByName(e)}function b(){if(n.newDomain.newDomainName)if(n.newDomain.domainType===h.ALIAS)n.newDomain.documentRoot=n.mainDomain.documentRoot.replace(n.mainDomain.homedir+"/",""),n.newDomain.fullDocumentRoot=n.mainDomain.documentRoot;else{var e=n.newDomain.newDomainName.replace("*","_wildcard_");n.newDomain.documentRoot=e,n.newDomain.fullDocumentRoot=l.generateFullDocumentRoot(e)}}function y(e){n.newDomain.subdomain=e}function w(){var e=n.newDomain.newDomainName=n.newDomain.newDomainName.toLocaleLowerCase();if(n.newDomain.domainType="",n.newDomain.newDomainName){if(n.newDomain.inheritDocumentRoot)n.newDomain.domainType=h.ALIAS;else{var t=e.split(".");if(t.length>2)for(var i,s=1;s<t.length;s++){if(D(i=t.slice(s).join("."))){n.newDomain.domainType=h.SUBDOMAIN,n.newDomain.domain=i,n.newDomain.subdomain=t.slice(0,s).join(".");break}}}n.newDomain.domainType||(n.newDomain.domainType=h.ADDON,n.newDomain.domain=n.mainDomain.domain)}}function S(e){n.newDomain.newDomainName=e,w(),b(),n.clearSuggestedDomains()}function T(){n.suggestedDomains=[]}t.extend(n,{creationMessages:[],DOMAIN_TYPE_CONSTANTS:h,submittingForm:!1,creationDelayed:!1,upgradeUrl:m.upgradeUrl,documentRootPattern:l.getDocumentRootPattern(),suggestedDomains:[],domainTypes:d,requirePublicHTMLSubs:"1"===m.requirePublicHTMLSubs.toString(),shareDocrootDefault:"1"===m.shareDocrootDefault.toString(),mainDomain:l.getMainDomain(),newDomain:{},getFormFieldClasses:function(e){return e&&!e.$pristine&&e.$invalid?"col-xs-12 col-md-6":"col-xs-12"},resetForm:function(){n.newDomain.newDomainName="",n.newDomain.documentRoot="",n.shareDocrootDefault?n.newDomain.inheritDocumentRoot=n.canCreateDomainType(h.ALIAS):n.newDomain.inheritDocumentRoot=!1,w(),b(),y(n.newDomain.newDomainName)},createDomain:function(s,a,d){n.submittingForm=!0;var _=c(v,1e3),p=t.copy(a);return m.hasWebServerRole||(o.debug("Because there is no webserver role on this system, the domain will be created as an alias domain."),p.domainType=h.ALIAS),l.add(p).then((function(){var a;o.debug("submittingDomainObj.fullDocumentRoot",p.fullDocumentRoot),a=m.hasWebServerRole?i.maketext("You have successfully created the new “[_1]” domain with the document root of “[_2]”.",p.newDomainName,e.escape(p.fullDocumentRoot)):i.maketext("You have successfully created the new “[_1]” domain.",p.newDomainName),u.add({type:"success",message:a}),d?(g(),n.resetForm(),t.element(document).find("input[autofocus]").focus(),s.$setPristine()):r.path("/")})).finally((function(){n.creationDelayed=!1,c.cancel(_),n.submittingForm=!1}))},onUpdateNewDomainName:function(){if(n.subdomain="",n.domain="",n.documentRoot="",n.newDomain.isWildcard=!1,n.newDomain.newDomainName){"*"===n.newDomain.newDomainName.substr(0,1)&&(n.newDomain.isWildcard=!0),function(e){var t=e.split(".");if(t.shift(),D(t.join(".")))return 1;return 0}(n.newDomain.newDomainName)&&(n.newDomain.inheritDocumentRoot=!1);var e=n.newDomain.newDomainName.split(".");e.length>=3&&function(e){var t=e.slice(e.length-2).join(".");e.pop(),e.pop();var i=!n.canCreateDomainType(h.ALIAS)&&!n.canCreateDomainType(h.ADDON),o=i?10:4,r=s.search(t),a=r.filter((function(e){return e.distance<o}));if(a.length){var c=e.join(".")+"."+r[0].match;n.newDomain.domain=l.getMainDomain().domain,n.clearSuggestedDomains(),c!==n.newDomain.newDomainName&&(n.suggestedDomains=a.slice(0,5).map((function(t){var n=e.join(".")+"."+t.match;return{domain:n,closeable:!i,use:function(){S(n)},cancel:T}})))}}(e),w(),b(),y(n.newDomain.newDomainName)}},useSuggestedDomain:S,clearSuggestedDomains:T,onToggleInheritDocumentRoot:function(){w(),b()},onDocumentRootUpdated:function(){n.newDomain.fullDocumentRoot=l.generateFullDocumentRoot(n.newDomain.documentRoot)},canCreateDomainType:function(e){if(!f[e])return!1;var t=function(e){return p[e]}(e);return("*."!==(n.newDomain.newDomainName||"").substr(0,2)||e!==h.ADDON&&e!==h.ALIAS)&&!t.overLimit},canCreateDomains:function(){return n.canCreateDomainType(h.ALIAS)||n.canCreateDomainType(h.ADDON)||n.canCreateDomainType(h.SUBDOMAIN)},inheritDocRootSelectionDisabled:function(){return!n.canCreateDomainType(h.ALIAS)||!n.canCreateDomainType(h.SUBDOMAIN)&&!n.canCreateDomainType(h.ADDON)}}),d.forEach((function(e){p[e.value]=e,f[e.value]=m.features[e.value]})),n.resetForm(),a.domain&&(n.newDomain.newDomainName=a.domain,w(),b(),y(n.newDomain.newDomainName)),g(),!m.hasWebServerRole&&_&&n.creationMessages.push({type:"info",message:i.maketext("Because this server does not use the “[_1]” role, the system creates new domains as separate zones. If you only need a [asis,DNS] entry, you can add the domain as new record on an existing zone in the [output,url,_2,_3,_4] interface.","WebServer",_.url,_.itemdesc,{_type:"offsite"})})}]),{namespace:o,controllerName:r}})),define("app/directives/tableShowingDirective",["angular","cjt/util/locale","cjt/core"],(function(e,t,i){"use strict";e.module("cpanel.domains.tableShowing.directive",[]).directive("tableShowing",(function(){var e="directives/tableShowingDirective.phtml";return{templateUrl:i.config.debug?i.buildFullPath("domains/directives/tableShowingDirective.phtml"):e,restrict:"EA",scope:{start:"=",limit:"=",total:"="},transclude:!0,controller:["$scope",function(e){e.getShowingText=function(){return t.maketext("Displaying [numf,_1] through [numf,_2] out of [quant,_3,item,items]",e.start,e.limit,e.total)}}]}}))})),define("app/directives/itemLister",["angular","cjt/util/locale","cjt/core","ngRoute","ngSanitize","cjt/modules","app/directives/tableShowingDirective","cjt/services/cpanel/componentSettingSaverService","app/services/domains","cjt/directives/toggleSortDirective","cjt/directives/searchDirective","cjt/directives/pageSizeDirective","cjt/filters/startFromFilter","cjt/decorators/paginationDecorator"],(function(e,t,i){"use strict";var n=e.module("cpanel.domains.itemLister.directive",["cpanel.domains.tableShowing.directive","ngRoute","ngSanitize","cjt2.filters.startFrom"]);n.value("PAGE",PAGE),n.directive("itemLister",["$window","$log","componentSettingSaverService","PAGE",function(n,s,o,r){var a="domainsItemLister",c="directives/itemLister.ptt";return{templateUrl:i.config.debug?i.buildFullPath("domains/directives/itemLister.ptt"):c,restrict:"EA",scope:{parentID:"@id",items:"=",headerItems:"=",configurationOptions:"="},transclude:!0,replace:!0,link:function(t,i,n,s){var o,r;function a(i){e.element(i).hasClass("lister-controls")?function(e){o.append(e)}(i):function(e){e.setAttribute("id",t.parentID+"_transcludePoint"),e.setAttribute("ng-if","filteredItems.length"),r.replaceWith(e)}(i)}setTimeout((function(){o=i.find("#"+t.parentID+"_transcludedControls"),r=i.find("#"+t.parentID+"_transcludePoint");var n=i.find("div.transcluded"),s=n.children();e.forEach(s,a),n.remove()}),2)},controller:["$routeParams","$scope","$filter","ITEM_LISTER_CONSTANTS","domains","alertService",function(i,c,l,u,d,h){c.redirectSelection=1,c.viewCallbacks=[],c.webserverRoleAvailable=r.hasWebServerRole;var m={filter:l("filter"),orderBy:l("orderBy"),startFrom:l("startFrom"),limitTo:l("limitTo")};function p(e){if(!c.loadingInitialState){var t={totalItems:c.totalItems,currentPage:c.currentPage,pageSize:c.pageSize,start:c.start,limit:c.limit,lastInteractedItem:e,filterValue:c.filterValue,sort:{sortDirection:c.sort.sortDirection,sortBy:c.sort.sortBy}};o.set(a,t)}}this.registerViewCallback=function(e){c.viewCallbacks.push(e),e(c.filteredItems)},this.getHeaderItems=function(){return c.headerItems},this.deregisterViewCallback=function(e){for(var t=c.viewCallbacks.length-1;t>=0;t--)c.viewCallbacks[t]===e&&c.viewCallbacks.splice(t,1)},c.fetch=function(){var t=[];return t=function(e){return""!==c.filterValue?m.filter(e,c.filterValue,!1):e}(c.items),c.totalItems=t.length,t=function(e){if(c.totalItems>_.min(c.pageSizes)){var t=(c.currentPage-1)*c.pageSize,i=c.pageSize;e=m.startFrom(e,t),e=m.limitTo(e,i),c.showPager=!0,c.start=t+1,c.limit=t+e.length}else c.showPager=!1,0===e.length?c.start=0:c.start=1,c.limit=e.length;return e}(t=function(e){return""!==c.sort.sortDirection&&""!==c.sort.sortBy?("batchSelect"===c.sort.sortBy&&(c.sort.sortBy="domain"),m.orderBy(e,c.sort.sortBy,"asc"!==c.sort.sortDirection)):e}(t)),c.filteredItems=t,p(),e.forEach(c.viewCallbacks,(function(e){e(c.filteredItems)})),c.$emit(u.ITEM_LISTER_UPDATED_EVENT,{meta:{filterValue:c.filterValue}}),t},c.focusSearch=function(){e.element(document).find("#"+c.parentID+"_search_input").focus(),n.scrollTop=0},c.configurationClicked=function(e){c.$emit(e)},c.$on(u.TABLE_ITEM_BUTTON_EVENT,(function(e,t){t.interactionID&&p(t.interactionID)})),c.$on(u.ITEM_SELECT_EVENT,(function(e,t){for(var i=!0,n=d.getCurrentDomains(),s=0;s<n.length;s++)if(!n[s].selected){i=!1;break}c.selectAll=i})),e.extend(c,{maxPages:5,totalItems:c.items.length,filteredItems:[],currentPage:1,pageSize:20,pageSizes:[20,50,100,500],start:0,limit:20,filterValue:"",sort:{sortDirection:"asc",sortBy:c.headerItems.length?c.headerItems[0].field:""}},{filterValue:i.q});var f=o.register(a);f&&(c.loadingInitialState=!0,f.then((function(t){e.extend(c,t,{filterValue:i.q})}),s.error).finally((function(){c.loadingInitialState=!1,c.fetch()}))),this.showConfigColumn=c.showConfigColumn=c.configurationOptions&&c.configurationOptions.length,c.$on("$destroy",(function(){o.unregister(a)})),c.fetch(),c.canRedirectHTTPS=d.canRedirectHTTPS(),c.$watch("items",c.fetch),c.toggleSelectAll=function(){for(var e=d.getCurrentDomains(),t=0;t<e.length;t++)c.canRedirectHTTPS?e[t].nonHTTPS&&!e[t].isHttpsRedirecting||(e[t].selected=c.selectAll):e[t].isHttpsRedirecting&&(e[t].selected=c.selectAll)},c.hasSelected=function(){for(var e=d.getCurrentDomains(),t=0;t<e.length;t++)if(e[t].selected)return!0;return!1},c.applyMultiSecureRedirects=function(e){var i,n,s=d.getCurrentDomains();e?(i=t.maketext("Force [asis,HTTPS] Redirect is enabled for the selected domains."),n=t.maketext("The system failed to enable Force [asis,HTTPS] Redirect.")):(i=t.maketext("Force [asis,HTTPS] Redirect is disabled for the selected domains."),n=t.maketext("The system failed to disable Force [asis,HTTPS] Redirect.")),c.hasSelected()&&d.toggleHTTPSRedirect(e).then((function(t){if(t.status){for(var o=0;o<s.length;o++)if(s[o].selected){s[o].selected=!1,s[o].isHttpsRedirecting=e;var r=document.getElementById(s[o].domain+"_domain_link");if(void 0!==r){var a=s[o].isHttpsRedirecting?"https":"http";r.href=a+"://"+s[o].domain}}c.selectAll=!1,c.toggleSelectAll(),h.add({message:i,type:"success",autoClose:1e4})}else h.add({message:n,type:"danger"})}))}}]}}])})),define("app/directives/docrootDirective",["angular","lodash","cjt/core"],(function(e,t,i){"use strict";var n=e.module("cpanel.domains.docroot.directive",[]);n.value("PAGE",PAGE),n.directive("docroot",(function(){var e="directives/docrootDirective.phtml";return{templateUrl:i.config.debug?i.buildFullPath("domains/directives/docrootDirective.phtml"):e,restrict:"E",scope:{parentID:"@id",rawDocroot:"@docroot",homedir:"@"},controller:["$scope","PAGE",function(e,i){function n(i){e.fullDocroot=encodeURIComponent(i);var n=new RegExp("^"+t.escapeRegExp(e.homedir)+"/?");return e.docroot=i.replace(n,""),e.docroot="/"===e.docroot?"":e.docroot,e.docroot}var s="cpanel"===i.APP_NAME;e.fileManager=!1,s&&i.fileManagerAppObj&&(e.fileManager={url:i.fileManagerAppObj.url,target:i.fileManagerAppObj.target||"_blank"}),e.$watch("rawDocroot",n),n(e.rawDocroot)}]}}))})),define("app/directives/domainListerViewDirective",["lodash","angular","cjt/core","cjt/util/locale","app/directives/docrootDirective","app/services/domains"],(function(e,t,i,n){"use strict";var s=t.module("cpanel.domains.domainListerView.directive",["cpanel.domains.docroot.directive"]);s.value("PAGE",PAGE),s.directive("domainListerView",(function(){var t="directives/domainListerViewDirective.ptt";return{templateUrl:i.config.debug?i.buildFullPath("domains/directives/domainListerViewDirective.ptt"):t,restrict:"EA",replace:!0,require:"^itemLister",link:function(e,t,i,n){e.domains=[],e.showConfigColumn=n.showConfigColumn,e.headerItems=n.getHeaderItems(),e.updateView=function(t){e.domains=t},e.scope=e,n.registerViewCallback(e.updateView.bind(e)),e.$on("$destroy",(function(){n.deregisterViewCallback(e.updateView)}))},controller:["$scope","ITEM_LISTER_CONSTANTS","DOMAIN_TYPE_CONSTANTS","PAGE","domains","alertService",function(t,i,s,o,r,a){t.isRTL=o.isRTL,t.DOMAIN_TYPE_CONSTANTS=s,t.EMAIL_ACCOUNTS_APP_EXISTS=o.EMAIL_ACCOUNTS_APP_EXISTS,t.webserverRoleAvailable=o.hasWebServerRole,t.canRedirectHTTPS=r.canRedirectHTTPS(),t.getDomains=function(){for(var i=0;i<t.domains.length;i++)t.domains[i].domain=e.escape(t.domains[i].domain),t.domains[i].homedir=e.escape(t.domains[i].homedir);return t.domains},t.actionButtonClicked=function(e,n){t.$emit(i.TABLE_ITEM_BUTTON_EVENT,{actionType:e,item:n,interactionID:n.domain})},t.itemSelected=function(e){t.$emit(i.ITEM_SELECT_EVENT,e)},t.HTTPSRedirectWarning=n.maketext("You cannot activate [asis,HTTPS] Redirect because [asis,AutoSSL] is not currently active for this domain or the [asis,SSL] certificate is not valid."),t.AliasRowWarning=n.maketext("Addon and parked domains inherit their [asis,HTTPS] redirect status from their associated subdomain."),t.AliasWarning=n.maketext("Some aliases for this domain may not have a working SSL certificate configured."),t.setSingleDomainHTTPSRedirect=function(e){var t,i;e.isHttpsRedirecting=!e.isHttpsRedirecting,e.isHttpsRedirecting?(t=n.maketext("Force [asis,HTTPS] Redirect is enabled for the “[_1]” domain.",e.domain),i=n.maketext("The system failed to enable Force [asis,HTTPS] Redirect.")):(t=n.maketext("Force [asis,HTTPS] Redirect is disabled for the “[_1]” domain.",e.domain),i=n.maketext("The system failed to disable Force [asis,HTTPS] Redirect.")),r.toggleHTTPSRedirect(e.isHttpsRedirecting,e.domain).then((function(n){if(n.status){var s=document.getElementById(e.domain+"_domain_link");if(void 0!==s){var o=e.isHttpsRedirecting?"https":"http";s.href=o+"://"+e.domain}a.add({message:t,type:"success",autoClose:1e4})}else a.add({message:i,type:"danger"})}))}}]}}))})),define("app/validators/subdomain",["angular","cjt/util/locale","cjt/validator/validator-utils","cjt/io/api2-request","cjt/io/api2","cjt/modules","cjt/services/APIService","cjt/validator/validateDirectiveFactory","app/services/domains"],(function(e,t,i,n){"use strict";var s=null,o=null;function r(e){console.error(e)}var a={_pattern:function(){return s},_reservedSubdomains:function(){return o},_processReservedSubdomains:function(e){o=null,e&&e.data&&(o=[],o=e.data.map((function(e){return e})))},_processSubdomainRegex:function(e){if(s=null,e&&e.data){var t=e.data.pop();s=new RegExp(t)}}},c={validSubdomain:function(e){var n=i.initializeValidationResult(),s=a._pattern();return!e||s&&s.test(e)||(n.isValid=!1,n.add("validSubdomain",t.maketext("You must enter a valid subdomain."))),n},notReservedSubdomain:function(e){var n=i.initializeValidationResult(),s=a._reservedSubdomains();return!e||s&&-1===s.indexOf(e)||(n.isValid=!1,n.add("notReservedSubdomain",t.maketext("The server reserves this subdomain for system use only. Enter a different subdomain."))),n}};return e.module("cjt2.validate").run(["validatorFactory","APIService",function(e,t){var i=new n.Class;i.initialize("SubDomain","validregex"),t.promise(i).then(a._processSubdomainRegex,r);var s=new n.Class;s.initialize("SubDomain","getreservedsubdomains"),t.promise(s).then(a._processReservedSubdomains,r),e.generate(c)}]),{methods:c,factoryMethods:a,name:"valid-subdomain",description:"Validation to subdomain is not reserved and matches the proper format.",version:1}})),define("app/validators/domainIsUnique",["angular","cjt/util/locale","cjt/validator/validator-utils","cjt/validator/validateDirectiveFactory","app/services/domains"],(function(e,t,i){"use strict";var n,s={_processLoadedDomains:function(e){return n=null,e&&(n={},e.forEach((function(e){n[e.domain]=e}))),n},_getDomains:function(){return n}},o={domainIsUnique:function(e){var n=i.initializeValidationResult(),o=s._getDomains();return(!o||e&&o[e])&&(n.isValid=!1,n.add("domainIsUnique",t.maketext("This domain already exists on this account."),"domainIsUnique")),n}};return e.module("cjt2.validate").run(["validatorFactory","$q","domains",function(e,t,i){var n={domainIsUnique:function(e){return i.get().then((function(i){s._processLoadedDomains(i);var n=o.domainIsUnique(e);return t.resolve(n)}))}};n.domainIsUnique.async=!0,e.generate(n,t)}]),{methods:o,factoryMethods:s,name:"domain-is-unique",description:"Validation to ensure domain is unique for this account.",version:1}})),function(e){define("jquery-chosen",["jquery"],(function(){return function(){
/*!
Chosen, a Select Box Enhancer for jQuery and Prototype
by Patrick Filler for Harvest, http://getharvest.com

Version 1.5.1
Full source at https://github.com/harvesthq/chosen
Copyright (c) 2011-2016 Harvest http://getharvest.com

MIT License, https://github.com/harvesthq/chosen/blob/master/LICENSE.md
This file is generated by `grunt build`, do not edit it by hand.
*/
(function(){var e,t,i,n,s={}.hasOwnProperty;(n=function(){function e(){this.options_index=0,this.parsed=[]}return e.prototype.add_node=function(e){return"OPTGROUP"===e.nodeName.toUpperCase()?this.add_group(e):this.add_option(e)},e.prototype.add_group=function(e){var t,i,n,s,o,r;for(t=this.parsed.length,this.parsed.push({array_index:t,group:!0,label:this.escapeExpression(e.label),title:e.title?e.title:void 0,children:0,disabled:e.disabled,classes:e.className}),r=[],n=0,s=(o=e.childNodes).length;n<s;n++)i=o[n],r.push(this.add_option(i,t,e.disabled));return r},e.prototype.add_option=function(e,t,i){if("OPTION"===e.nodeName.toUpperCase())return""!==e.text?(null!=t&&(this.parsed[t].children+=1),this.parsed.push({array_index:this.parsed.length,options_index:this.options_index,value:e.value,text:e.text,html:e.innerHTML,title:e.title?e.title:void 0,selected:e.selected,disabled:!0===i?i:e.disabled,group_array_index:t,group_label:null!=t?this.parsed[t].label:null,classes:e.className,style:e.style.cssText})):this.parsed.push({array_index:this.parsed.length,options_index:this.options_index,empty:!0}),this.options_index+=1},e.prototype.escapeExpression=function(e){var t,i;return null==e||!1===e?"":/[\&\<\>\"\'\`]/.test(e)?(t={"<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},i=/&(?!\w+;)|[\<\>\"\'\`]/g,e.replace(i,(function(e){return t[e]||"&amp;"}))):e},e}()).select_to_array=function(e){var t,i,s,o,r;for(i=new n,s=0,o=(r=e.childNodes).length;s<o;s++)t=r[s],i.add_node(t);return i.parsed},t=function(){function e(t,i){this.form_field=t,this.options=null!=i?i:{},e.browser_is_supported()&&(this.is_multiple=this.form_field.multiple,this.set_default_text(),this.set_default_values(),this.setup(),this.set_up_html(),this.register_observers(),this.on_ready())}return e.prototype.set_default_values=function(){var e=this;return this.click_test_action=function(t){return e.test_active_click(t)},this.activate_action=function(t){return e.activate_field(t)},this.active_field=!1,this.mouse_on_container=!1,this.results_showing=!1,this.result_highlighted=null,this.allow_single_deselect=null!=this.options.allow_single_deselect&&null!=this.form_field.options[0]&&""===this.form_field.options[0].text&&this.options.allow_single_deselect,this.disable_search_threshold=this.options.disable_search_threshold||0,this.disable_search=this.options.disable_search||!1,this.enable_split_word_search=null==this.options.enable_split_word_search||this.options.enable_split_word_search,this.group_search=null==this.options.group_search||this.options.group_search,this.search_contains=this.options.search_contains||!1,this.single_backstroke_delete=null==this.options.single_backstroke_delete||this.options.single_backstroke_delete,this.max_selected_options=this.options.max_selected_options||1/0,this.inherit_select_classes=this.options.inherit_select_classes||!1,this.display_selected_options=null==this.options.display_selected_options||this.options.display_selected_options,this.display_disabled_options=null==this.options.display_disabled_options||this.options.display_disabled_options,this.include_group_label_in_selected=this.options.include_group_label_in_selected||!1,this.max_shown_results=this.options.max_shown_results||Number.POSITIVE_INFINITY},e.prototype.set_default_text=function(){return this.form_field.getAttribute("data-placeholder")?this.default_text=this.form_field.getAttribute("data-placeholder"):this.is_multiple?this.default_text=this.options.placeholder_text_multiple||this.options.placeholder_text||e.default_multiple_text:this.default_text=this.options.placeholder_text_single||this.options.placeholder_text||e.default_single_text,this.results_none_found=this.form_field.getAttribute("data-no_results_text")||this.options.no_results_text||e.default_no_result_text},e.prototype.choice_label=function(e){return this.include_group_label_in_selected&&null!=e.group_label?"<b class='group-name'>"+e.group_label+"</b>"+e.html:e.html},e.prototype.mouse_enter=function(){return this.mouse_on_container=!0},e.prototype.mouse_leave=function(){return this.mouse_on_container=!1},e.prototype.input_focus=function(e){var t=this;if(this.is_multiple){if(!this.active_field)return setTimeout((function(){return t.container_mousedown()}),50)}else if(!this.active_field)return this.activate_field()},e.prototype.input_blur=function(e){var t=this;if(!this.mouse_on_container)return this.active_field=!1,setTimeout((function(){return t.blur_test()}),100)},e.prototype.results_option_build=function(e){var t,i,n,s,o,r,a;for(t="",s=0,o=0,r=(a=this.results_data).length;o<r&&(n="",""!==(n=(i=a[o]).group?this.result_add_group(i):this.result_add_option(i))&&(s++,t+=n),(null!=e?e.first:void 0)&&(i.selected&&this.is_multiple?this.choice_build(i):i.selected&&!this.is_multiple&&this.single_set_selected_text(this.choice_label(i))),!(s>=this.max_shown_results));o++);return t},e.prototype.result_add_option=function(e){var t,i;return e.search_match&&this.include_option_in_results(e)?(t=[],e.disabled||e.selected&&this.is_multiple||t.push("active-result"),!e.disabled||e.selected&&this.is_multiple||t.push("disabled-result"),e.selected&&t.push("result-selected"),null!=e.group_array_index&&t.push("group-option"),""!==e.classes&&t.push(e.classes),(i=document.createElement("li")).className=t.join(" "),i.style.cssText=e.style,i.setAttribute("data-option-array-index",e.array_index),i.innerHTML=e.search_text,e.title&&(i.title=e.title),this.outerHTML(i)):""},e.prototype.result_add_group=function(e){var t,i;return(e.search_match||e.group_match)&&e.active_options>0?((t=[]).push("group-result"),e.classes&&t.push(e.classes),(i=document.createElement("li")).className=t.join(" "),i.innerHTML=e.search_text,e.title&&(i.title=e.title),this.outerHTML(i)):""},e.prototype.results_update_field=function(){if(this.set_default_text(),this.is_multiple||this.results_reset_cleanup(),this.result_clear_highlight(),this.results_build(),this.results_showing)return this.winnow_results()},e.prototype.reset_single_select_options=function(){var e,t,i,n,s;for(s=[],t=0,i=(n=this.results_data).length;t<i;t++)(e=n[t]).selected?s.push(e.selected=!1):s.push(void 0);return s},e.prototype.results_toggle=function(){return this.results_showing?this.results_hide():this.results_show()},e.prototype.results_search=function(e){return this.results_showing?this.winnow_results():this.results_show()},e.prototype.winnow_results=function(){var e,t,i,n,s,o,r,a,c,l,u,d;for(this.no_results_clear(),n=0,e=(o=this.get_search_text()).replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&"),c=new RegExp(e,"i"),i=this.get_search_regex(e),l=0,u=(d=this.results_data).length;l<u;l++)(t=d[l]).search_match=!1,s=null,this.include_option_in_results(t)&&(t.group&&(t.group_match=!1,t.active_options=0),null!=t.group_array_index&&this.results_data[t.group_array_index]&&(0===(s=this.results_data[t.group_array_index]).active_options&&s.search_match&&(n+=1),s.active_options+=1),t.search_text=t.group?t.label:t.html,t.group&&!this.group_search||(t.search_match=this.search_string_match(t.search_text,i),t.search_match&&!t.group&&(n+=1),t.search_match?(o.length&&(r=t.search_text.search(c),a=t.search_text.substr(0,r+o.length)+"</em>"+t.search_text.substr(r+o.length),t.search_text=a.substr(0,r)+"<em>"+a.substr(r)),null!=s&&(s.group_match=!0)):null!=t.group_array_index&&this.results_data[t.group_array_index].search_match&&(t.search_match=!0)));return this.result_clear_highlight(),n<1&&o.length?(this.update_results_content(""),this.no_results(o)):(this.update_results_content(this.results_option_build()),this.winnow_results_set_highlight())},e.prototype.get_search_regex=function(e){var t;return t=this.search_contains?"":"^",new RegExp(t+e,"i")},e.prototype.search_string_match=function(e,t){var i,n,s,o;if(t.test(e))return!0;if(this.enable_split_word_search&&(e.indexOf(" ")>=0||0===e.indexOf("["))&&(n=e.replace(/\[|\]/g,"").split(" ")).length)for(s=0,o=n.length;s<o;s++)if(i=n[s],t.test(i))return!0},e.prototype.choices_count=function(){var e,t,i;if(null!=this.selected_option_count)return this.selected_option_count;for(this.selected_option_count=0,e=0,t=(i=this.form_field.options).length;e<t;e++)i[e].selected&&(this.selected_option_count+=1);return this.selected_option_count},e.prototype.choices_click=function(e){if(e.preventDefault(),!this.results_showing&&!this.is_disabled)return this.results_show()},e.prototype.keyup_checker=function(e){var t,i;switch(t=null!=(i=e.which)?i:e.keyCode,this.search_field_scale(),t){case 8:if(this.is_multiple&&this.backstroke_length<1&&this.choices_count()>0)return this.keydown_backstroke();if(!this.pending_backstroke)return this.result_clear_highlight(),this.results_search();break;case 13:if(e.preventDefault(),this.results_showing)return this.result_select(e);break;case 27:return this.results_showing&&this.results_hide(),!0;case 9:case 38:case 40:case 16:case 91:case 17:case 18:break;default:return this.results_search()}},e.prototype.clipboard_event_checker=function(e){var t=this;return setTimeout((function(){return t.results_search()}),50)},e.prototype.container_width=function(){return null!=this.options.width?this.options.width:this.form_field.offsetWidth+"px"},e.prototype.include_option_in_results=function(e){return!(this.is_multiple&&!this.display_selected_options&&e.selected)&&(!(!this.display_disabled_options&&e.disabled)&&!e.empty)},e.prototype.search_results_touchstart=function(e){return this.touch_started=!0,this.search_results_mouseover(e)},e.prototype.search_results_touchmove=function(e){return this.touch_started=!1,this.search_results_mouseout(e)},e.prototype.search_results_touchend=function(e){if(this.touch_started)return this.search_results_mouseup(e)},e.prototype.outerHTML=function(e){var t;return e.outerHTML?e.outerHTML:((t=document.createElement("div")).appendChild(e),t.innerHTML)},e.browser_is_supported=function(){return!/iP(od|hone)/i.test(window.navigator.userAgent)&&((!/Android/i.test(window.navigator.userAgent)||!/Mobile/i.test(window.navigator.userAgent))&&(!/IEMobile/i.test(window.navigator.userAgent)&&(!/Windows Phone/i.test(window.navigator.userAgent)&&(!/BlackBerry/i.test(window.navigator.userAgent)&&(!/BB10/i.test(window.navigator.userAgent)&&("Microsoft Internet Explorer"!==window.navigator.appName||document.documentMode>=8))))))},e.default_multiple_text="Select Some Options",e.default_single_text="Select an Option",e.default_no_result_text="No results match",e}(),(e=jQuery).fn.extend({chosen:function(n){return t.browser_is_supported()?this.each((function(t){var s,o;o=(s=e(this)).data("chosen"),"destroy"!==n?o instanceof i||s.data("chosen",new i(this,n)):o instanceof i&&o.destroy()})):this}}),i=function(t){function i(){return i.__super__.constructor.apply(this,arguments)}return function(e,t){for(var i in t)s.call(t,i)&&(e[i]=t[i]);function n(){this.constructor=e}n.prototype=t.prototype,e.prototype=new n,e.__super__=t.prototype}(i,t),i.prototype.setup=function(){return this.form_field_jq=e(this.form_field),this.current_selectedIndex=this.form_field.selectedIndex,this.is_rtl=this.form_field_jq.hasClass("chosen-rtl")},i.prototype.set_up_html=function(){var t,i;return(t=["chosen-container"]).push("chosen-container-"+(this.is_multiple?"multi":"single")),this.inherit_select_classes&&this.form_field.className&&t.push(this.form_field.className),this.is_rtl&&t.push("chosen-rtl"),i={class:t.join(" "),style:"width: "+this.container_width()+";",title:this.form_field.title},this.form_field.id.length&&(i.id=this.form_field.id.replace(/[^\w]/g,"_")+"_chosen"),this.container=e("<div />",i),this.is_multiple?this.container.html('<ul class="chosen-choices"><li class="search-field"><input type="text" value="'+this.default_text+'" class="default" autocomplete="off" style="width:25px;" /></li></ul><div class="chosen-drop"><ul class="chosen-results"></ul></div>'):this.container.html('<a class="chosen-single chosen-default"><span>'+this.default_text+'</span><div><b></b></div></a><div class="chosen-drop"><div class="chosen-search"><input type="text" autocomplete="off" /></div><ul class="chosen-results"></ul></div>'),this.form_field_jq.hide().after(this.container),this.dropdown=this.container.find("div.chosen-drop").first(),this.search_field=this.container.find("input").first(),this.search_results=this.container.find("ul.chosen-results").first(),this.search_field_scale(),this.search_no_results=this.container.find("li.no-results").first(),this.is_multiple?(this.search_choices=this.container.find("ul.chosen-choices").first(),this.search_container=this.container.find("li.search-field").first()):(this.search_container=this.container.find("div.chosen-search").first(),this.selected_item=this.container.find(".chosen-single").first()),this.results_build(),this.set_tab_index(),this.set_label_behavior()},i.prototype.on_ready=function(){return this.form_field_jq.trigger("chosen:ready",{chosen:this})},i.prototype.register_observers=function(){var e=this;return this.container.bind("touchstart.chosen",(function(t){return e.container_mousedown(t),t.preventDefault()})),this.container.bind("touchend.chosen",(function(t){return e.container_mouseup(t),t.preventDefault()})),this.container.bind("mousedown.chosen",(function(t){e.container_mousedown(t)})),this.container.bind("mouseup.chosen",(function(t){e.container_mouseup(t)})),this.container.bind("mouseenter.chosen",(function(t){e.mouse_enter(t)})),this.container.bind("mouseleave.chosen",(function(t){e.mouse_leave(t)})),this.search_results.bind("mouseup.chosen",(function(t){e.search_results_mouseup(t)})),this.search_results.bind("mouseover.chosen",(function(t){e.search_results_mouseover(t)})),this.search_results.bind("mouseout.chosen",(function(t){e.search_results_mouseout(t)})),this.search_results.bind("mousewheel.chosen DOMMouseScroll.chosen",(function(t){e.search_results_mousewheel(t)})),this.search_results.bind("touchstart.chosen",(function(t){e.search_results_touchstart(t)})),this.search_results.bind("touchmove.chosen",(function(t){e.search_results_touchmove(t)})),this.search_results.bind("touchend.chosen",(function(t){e.search_results_touchend(t)})),this.form_field_jq.bind("chosen:updated.chosen",(function(t){e.results_update_field(t)})),this.form_field_jq.bind("chosen:activate.chosen",(function(t){e.activate_field(t)})),this.form_field_jq.bind("chosen:open.chosen",(function(t){e.container_mousedown(t)})),this.form_field_jq.bind("chosen:close.chosen",(function(t){e.input_blur(t)})),this.search_field.bind("blur.chosen",(function(t){e.input_blur(t)})),this.search_field.bind("keyup.chosen",(function(t){e.keyup_checker(t)})),this.search_field.bind("keydown.chosen",(function(t){e.keydown_checker(t)})),this.search_field.bind("focus.chosen",(function(t){e.input_focus(t)})),this.search_field.bind("cut.chosen",(function(t){e.clipboard_event_checker(t)})),this.search_field.bind("paste.chosen",(function(t){e.clipboard_event_checker(t)})),this.is_multiple?this.search_choices.bind("click.chosen",(function(t){e.choices_click(t)})):this.container.bind("click.chosen",(function(e){e.preventDefault()}))},i.prototype.destroy=function(){return e(this.container[0].ownerDocument).unbind("click.chosen",this.click_test_action),this.search_field[0].tabIndex&&(this.form_field_jq[0].tabIndex=this.search_field[0].tabIndex),this.container.remove(),this.form_field_jq.removeData("chosen"),this.form_field_jq.show()},i.prototype.search_field_disabled=function(){return this.is_disabled=this.form_field_jq[0].disabled,this.is_disabled?(this.container.addClass("chosen-disabled"),this.search_field[0].disabled=!0,this.is_multiple||this.selected_item.unbind("focus.chosen",this.activate_action),this.close_field()):(this.container.removeClass("chosen-disabled"),this.search_field[0].disabled=!1,this.is_multiple?void 0:this.selected_item.bind("focus.chosen",this.activate_action))},i.prototype.container_mousedown=function(t){if(!this.is_disabled&&(t&&"mousedown"===t.type&&!this.results_showing&&t.preventDefault(),null==t||!e(t.target).hasClass("search-choice-close")))return this.active_field?this.is_multiple||!t||e(t.target)[0]!==this.selected_item[0]&&!e(t.target).parents("a.chosen-single").length||(t.preventDefault(),this.results_toggle()):(this.is_multiple&&this.search_field.val(""),e(this.container[0].ownerDocument).bind("click.chosen",this.click_test_action),this.results_show()),this.activate_field()},i.prototype.container_mouseup=function(e){if("ABBR"===e.target.nodeName&&!this.is_disabled)return this.results_reset(e)},i.prototype.search_results_mousewheel=function(e){var t;if(e.originalEvent&&(t=e.originalEvent.deltaY||-e.originalEvent.wheelDelta||e.originalEvent.detail),null!=t)return e.preventDefault(),"DOMMouseScroll"===e.type&&(t*=40),this.search_results.scrollTop(t+this.search_results.scrollTop())},i.prototype.blur_test=function(e){if(!this.active_field&&this.container.hasClass("chosen-container-active"))return this.close_field()},i.prototype.close_field=function(){return e(this.container[0].ownerDocument).unbind("click.chosen",this.click_test_action),this.active_field=!1,this.results_hide(),this.container.removeClass("chosen-container-active"),this.clear_backstroke(),this.show_search_field_default(),this.search_field_scale()},i.prototype.activate_field=function(){return this.container.addClass("chosen-container-active"),this.active_field=!0,this.search_field.val(this.search_field.val()),this.search_field.focus()},i.prototype.test_active_click=function(t){var i;return(i=e(t.target).closest(".chosen-container")).length&&this.container[0]===i[0]?this.active_field=!0:this.close_field()},i.prototype.results_build=function(){return this.parsing=!0,this.selected_option_count=null,this.results_data=n.select_to_array(this.form_field),this.is_multiple?this.search_choices.find("li.search-choice").remove():this.is_multiple||(this.single_set_selected_text(),this.disable_search||this.form_field.options.length<=this.disable_search_threshold?(this.search_field[0].readOnly=!0,this.container.addClass("chosen-container-single-nosearch")):(this.search_field[0].readOnly=!1,this.container.removeClass("chosen-container-single-nosearch"))),this.update_results_content(this.results_option_build({first:!0})),this.search_field_disabled(),this.show_search_field_default(),this.search_field_scale(),this.parsing=!1},i.prototype.result_do_highlight=function(e){var t,i,n,s,o;if(e.length){if(this.result_clear_highlight(),this.result_highlight=e,this.result_highlight.addClass("highlighted"),s=(n=parseInt(this.search_results.css("maxHeight"),10))+(o=this.search_results.scrollTop()),(t=(i=this.result_highlight.position().top+this.search_results.scrollTop())+this.result_highlight.outerHeight())>=s)return this.search_results.scrollTop(t-n>0?t-n:0);if(i<o)return this.search_results.scrollTop(i)}},i.prototype.result_clear_highlight=function(){return this.result_highlight&&this.result_highlight.removeClass("highlighted"),this.result_highlight=null},i.prototype.results_show=function(){return this.is_multiple&&this.max_selected_options<=this.choices_count()?(this.form_field_jq.trigger("chosen:maxselected",{chosen:this}),!1):(this.container.addClass("chosen-with-drop"),this.results_showing=!0,this.search_field.focus(),this.search_field.val(this.search_field.val()),this.winnow_results(),this.form_field_jq.trigger("chosen:showing_dropdown",{chosen:this}))},i.prototype.update_results_content=function(e){return this.search_results.html(e)},i.prototype.results_hide=function(){return this.results_showing&&(this.result_clear_highlight(),this.container.removeClass("chosen-with-drop"),this.form_field_jq.trigger("chosen:hiding_dropdown",{chosen:this})),this.results_showing=!1},i.prototype.set_tab_index=function(e){var t;if(this.form_field.tabIndex)return t=this.form_field.tabIndex,this.form_field.tabIndex=-1,this.search_field[0].tabIndex=t},i.prototype.set_label_behavior=function(){var t=this;if(this.form_field_label=this.form_field_jq.parents("label"),!this.form_field_label.length&&this.form_field.id.length&&(this.form_field_label=e("label[for='"+this.form_field.id+"']")),this.form_field_label.length>0)return this.form_field_label.bind("click.chosen",(function(e){return t.is_multiple?t.container_mousedown(e):t.activate_field()}))},i.prototype.show_search_field_default=function(){return this.is_multiple&&this.choices_count()<1&&!this.active_field?(this.search_field.val(this.default_text),this.search_field.addClass("default")):(this.search_field.val(""),this.search_field.removeClass("default"))},i.prototype.search_results_mouseup=function(t){var i;if((i=e(t.target).hasClass("active-result")?e(t.target):e(t.target).parents(".active-result").first()).length)return this.result_highlight=i,this.result_select(t),this.search_field.focus()},i.prototype.search_results_mouseover=function(t){var i;if(i=e(t.target).hasClass("active-result")?e(t.target):e(t.target).parents(".active-result").first())return this.result_do_highlight(i)},i.prototype.search_results_mouseout=function(t){if(e(t.target).hasClass("active-result"))return this.result_clear_highlight()},i.prototype.choice_build=function(t){var i,n,s=this;return i=e("<li />",{class:"search-choice"}).html("<span>"+this.choice_label(t)+"</span>"),t.disabled?i.addClass("search-choice-disabled"):((n=e("<a />",{class:"search-choice-close","data-option-array-index":t.array_index})).bind("click.chosen",(function(e){return s.choice_destroy_link_click(e)})),i.append(n)),this.search_container.before(i)},i.prototype.choice_destroy_link_click=function(t){if(t.preventDefault(),t.stopPropagation(),!this.is_disabled)return this.choice_destroy(e(t.target))},i.prototype.choice_destroy=function(e){if(this.result_deselect(e[0].getAttribute("data-option-array-index")))return this.show_search_field_default(),this.is_multiple&&this.choices_count()>0&&this.search_field.val().length<1&&this.results_hide(),e.parents("li").first().remove(),this.search_field_scale()},i.prototype.results_reset=function(){if(this.reset_single_select_options(),this.form_field.options[0].selected=!0,this.single_set_selected_text(),this.show_search_field_default(),this.results_reset_cleanup(),this.form_field_jq.trigger("change"),this.active_field)return this.results_hide()},i.prototype.results_reset_cleanup=function(){return this.current_selectedIndex=this.form_field.selectedIndex,this.selected_item.find("abbr").remove()},i.prototype.result_select=function(e){var t,i;if(this.result_highlight)return t=this.result_highlight,this.result_clear_highlight(),this.is_multiple&&this.max_selected_options<=this.choices_count()?(this.form_field_jq.trigger("chosen:maxselected",{chosen:this}),!1):(this.is_multiple?t.removeClass("active-result"):this.reset_single_select_options(),t.addClass("result-selected"),(i=this.results_data[t[0].getAttribute("data-option-array-index")]).selected=!0,this.form_field.options[i.options_index].selected=!0,this.selected_option_count=null,this.is_multiple?this.choice_build(i):this.single_set_selected_text(this.choice_label(i)),(e.metaKey||e.ctrlKey)&&this.is_multiple||this.results_hide(),this.show_search_field_default(),(this.is_multiple||this.form_field.selectedIndex!==this.current_selectedIndex)&&this.form_field_jq.trigger("change",{selected:this.form_field.options[i.options_index].value}),this.current_selectedIndex=this.form_field.selectedIndex,e.preventDefault(),this.search_field_scale())},i.prototype.single_set_selected_text=function(e){return null==e&&(e=this.default_text),e===this.default_text?this.selected_item.addClass("chosen-default"):(this.single_deselect_control_build(),this.selected_item.removeClass("chosen-default")),this.selected_item.find("span").html(e)},i.prototype.result_deselect=function(e){var t;return t=this.results_data[e],!this.form_field.options[t.options_index].disabled&&(t.selected=!1,this.form_field.options[t.options_index].selected=!1,this.selected_option_count=null,this.result_clear_highlight(),this.results_showing&&this.winnow_results(),this.form_field_jq.trigger("change",{deselected:this.form_field.options[t.options_index].value}),this.search_field_scale(),!0)},i.prototype.single_deselect_control_build=function(){if(this.allow_single_deselect)return this.selected_item.find("abbr").length||this.selected_item.find("span").first().after('<abbr class="search-choice-close"></abbr>'),this.selected_item.addClass("chosen-single-with-deselect")},i.prototype.get_search_text=function(){return e("<div/>").text(e.trim(this.search_field.val())).html()},i.prototype.winnow_results_set_highlight=function(){var e,t;if(null!=(e=(t=this.is_multiple?[]:this.search_results.find(".result-selected.active-result")).length?t.first():this.search_results.find(".active-result").first()))return this.result_do_highlight(e)},i.prototype.no_results=function(t){var i;return(i=e('<li class="no-results">'+this.results_none_found+' "<span></span>"</li>')).find("span").first().html(t),this.search_results.append(i),this.form_field_jq.trigger("chosen:no_results",{chosen:this})},i.prototype.no_results_clear=function(){return this.search_results.find(".no-results").remove()},i.prototype.keydown_arrow=function(){var e;return this.results_showing&&this.result_highlight?(e=this.result_highlight.nextAll("li.active-result").first())?this.result_do_highlight(e):void 0:this.results_show()},i.prototype.keyup_arrow=function(){var e;return this.results_showing||this.is_multiple?this.result_highlight?(e=this.result_highlight.prevAll("li.active-result")).length?this.result_do_highlight(e.first()):(this.choices_count()>0&&this.results_hide(),this.result_clear_highlight()):void 0:this.results_show()},i.prototype.keydown_backstroke=function(){var e;return this.pending_backstroke?(this.choice_destroy(this.pending_backstroke.find("a").first()),this.clear_backstroke()):(e=this.search_container.siblings("li.search-choice").last()).length&&!e.hasClass("search-choice-disabled")?(this.pending_backstroke=e,this.single_backstroke_delete?this.keydown_backstroke():this.pending_backstroke.addClass("search-choice-focus")):void 0},i.prototype.clear_backstroke=function(){return this.pending_backstroke&&this.pending_backstroke.removeClass("search-choice-focus"),this.pending_backstroke=null},i.prototype.keydown_checker=function(e){var t,i;switch(t=null!=(i=e.which)?i:e.keyCode,this.search_field_scale(),8!==t&&this.pending_backstroke&&this.clear_backstroke(),t){case 8:this.backstroke_length=this.search_field.val().length;break;case 9:this.results_showing&&!this.is_multiple&&this.result_select(e),this.mouse_on_container=!1;break;case 13:this.results_showing&&e.preventDefault();break;case 32:this.disable_search&&e.preventDefault();break;case 38:e.preventDefault(),this.keyup_arrow();break;case 40:e.preventDefault(),this.keydown_arrow()}},i.prototype.search_field_scale=function(){var t,i,n,s,o,r,a,c;if(this.is_multiple){for(0,r=0,s="position:absolute; left: -1000px; top: -1000px; display:none;",a=0,c=(o=["font-size","font-style","font-weight","font-family","line-height","text-transform","letter-spacing"]).length;a<c;a++)s+=(n=o[a])+":"+this.search_field.css(n)+";";return(t=e("<div />",{style:s})).text(this.search_field.val()),e("body").append(t),r=t.width()+25,t.remove(),r>(i=this.container.outerWidth())-10&&(r=i-10),this.search_field.css({width:r+"px"})}},i}(t)}).call(this)}.apply(e,arguments)}))}(this),function(e){define("angular-chosen",["angular","jquery-chosen"],(function(){return function(){
/**
 * angular-chosen-localytics - Angular Chosen directive is an AngularJS Directive that brings the Chosen jQuery in a Angular way
 * @version v1.3.0
 * @link http://github.com/leocaseiro/angular-chosen
 * @license MIT
 */
(function(){var e=[].indexOf||function(e){for(var t=0,i=this.length;t<i;t++)if(t in this&&this[t]===e)return t;return-1};angular.module("localytics.directives",[]),angular.module("localytics.directives").directive("chosen",["$timeout",function(t){var i,n,s,o;return n=/^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+group\s+by\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w]*)|(?:\(\s*([\$\w][\$\w]*)\s*,\s*([\$\w][\$\w]*)\s*\)))\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?$/,i=["persistentCreateOption","createOptionText","createOption","skipNoResults","noResultsText","allowSingleDeselect","disableSearchThreshold","disableSearch","enableSplitWordSearch","inheritSelectClasses","maxSelectedOptions","placeholderTextMultiple","placeholderTextSingle","searchContains","singleBackstrokeDelete","displayDisabledOptions","displaySelectedOptions","width","includeGroupLabelInSelected","maxShownResults"],o=function(e){return e.replace(/[A-Z]/g,(function(e){return"_"+e.toLowerCase()}))},s=function(e){var t;if(angular.isArray(e))return 0===e.length;if(angular.isObject(e))for(t in e)if(e.hasOwnProperty(t))return!1;return!0},{restrict:"A",require:"?ngModel",priority:1,link:function(r,a,c,l){var u,d,h,m,_,p,f,g,v,D;if(r.disabledValuesHistory=r.disabledValuesHistory?r.disabledValuesHistory:[],(a=$(a)).addClass("localytics-chosen"),m=r.$eval(c.chosen)||{},angular.forEach(c,(function(t,n){if(e.call(i,n)>=0)return c.$observe(n,(function(e){return m[o(n)]="{{"===String(a.attr(c.$attr[n])).slice(0,2)?e:r.$eval(e),g()}))})),p=function(){return a.addClass("loading").attr("disabled",!0).trigger("chosen:updated")},f=function(){return a.removeClass("loading"),angular.isDefined(c.disabled)?a.attr("disabled",c.disabled):a.attr("disabled",!1),a.trigger("chosen:updated")},u=null,d=!1,h=function(){return u?a.trigger("chosen:updated"):(t((function(){u=a.chosen(m).data("chosen")})),angular.isObject(u)?u.default_text:void 0)},g=function(){return d?a.attr("data-placeholder",u.results_none_found).attr("disabled",!0):a.removeAttr("data-placeholder"),a.trigger("chosen:updated")},l?(_=l.$render,l.$render=function(){return _(),h()},a.on("chosen:hiding_dropdown",(function(){return r.$apply((function(){return l.$setTouched()}))})),c.multiple&&(D=function(){return l.$viewValue},r.$watch(D,l.$render,!0))):h(),c.$observe("disabled",(function(){return a.trigger("chosen:updated")})),c.ngOptions&&l)return v=c.ngOptions.match(n)[7],r.$watchCollection(v,(function(e,i){return t((function(){return angular.isUndefined(e)?p():(d=s(e),f(),g())}))})),r.$on("$destroy",(function(e){if("undefined"!=typeof timer&&null!==timer)return t.cancel(timer)}))}}}])}).call(this)}.apply(e,arguments)}))}(this),define("app/index",["angular","cjt/core","app/views/ROUTES","app/views/createDomain","cjt/modules","ngRoute","ngAnimate","cjt/services/alertService","app/services/domains","app/directives/itemLister","app/directives/domainListerViewDirective","app/validators/subdomain","app/validators/domainIsUnique","cjt/directives/callout","cjt/directives/loadingPanel","angular-chosen"],(function(e,t,i,n){"use strict";return function(){e.module("cpanel.domains",["ngRoute","ngAnimate","cjt2.cpanel","cpanel.domains.domains.service","cpanel.domains.itemLister.directive","cpanel.domains.domainListerView.directive",n.namespace,"cjt2.directives.loadingPanel","cjt2.services.alert","localytics.directives"]);var t=["cjt/bootstrap","cjt/directives/breadcrumbs","app/views/main"];return i.forEach((function(e){t.push("app/views/"+e.controller)})),require(t,(function(t){var n=e.module("cpanel.domains");n.value("PAGE",PAGE),n.value("ZONE_EDITOR_APP_OBJ",PAGE.zoneEditorAppObj),n.value("ITEM_LISTER_CONSTANTS",{TABLE_ITEM_BUTTON_EVENT:"TableItemActionButtonEmitted",ITEM_LISTER_UPDATED_EVENT:"ItemListerUpdatedEvent"}),n.config(["$routeProvider","$animateProvider",function(e,t){t.classNameFilter(/^((?!no-animate).)*$/),i.forEach((function(t){e.when(t.route,{controller:t.controller,templateUrl:t.templateUrl,breadcrumb:t.breadcrumb,resolve:t.resolve})})),e.otherwise({redirectTo:"/"})}]),t("#content","cpanel.domains")}))}}));