define(["angular","lodash","cjt/util/locale","cjt/io/uapi-request","cjt/io/api2-request","cjt/io/uapi","cjt/io/api2","cjt/modules","cjt/services/APICatcher"],(function(t,n,e,o,a){"use strict";var i=t.module("cpanel.domains.domains.service",["cjt2.services.apicatcher"]);i.value("PAGE",PAGE),i.value("DOMAIN_TYPE_CONSTANTS",{SUBDOMAIN:"subdomain",ADDON:"addon",ALIAS:"alias",MAIN:"main_domain"});var r={documentRoot:!0};i.factory("domains",["$q","APICatcher","DOMAIN_TYPE_CONSTANTS","PAGE",function(i,m,d,s){var u,c,p,D,f,l,h,g={},v=function(t){var n=this;Object.keys(t).forEach((function(e){n[e]=t[e]})),n.protocol=n.isHttpsRedirecting?"https":"http",n.isWildcard=n.domain&&"*"===n.domain.substr(0,1),n.canBeSuggested=!n.isWildcard},A=[{label:e.maketext("Subdomain"),value:d.SUBDOMAIN,requiresCustomDocumentRoot:!0,stat:"subdomains"},{label:e.maketext("Addon"),value:d.ADDON,requiresCustomDocumentRoot:!0,dependantStat:"subdomains",stat:"addon_domains"},{label:e.maketext("Alias"),value:d.ALIAS,stat:"aliases"}],y=function(){};function S(t,n){for(var e in t)if(t.hasOwnProperty(e)&&t[e].id===n)return t[e]}function b(t){for(var n in A)if(A.hasOwnProperty(n)&&A[n].value===t)return A[n]}function _(t){if(t){var n=null===t.maximum?void 0:Number(t.maximum),e=Number(t.usage);if(!isNaN(n))if(0===n||e/n>=1)return!0;return!1}}return(y.prototype=m)._cacheDomain=function(t){u||(u=[]);var n=new v(t);return g[n.domain]||(g[n.domain]=n,u.push(n)),t},y.prototype._uncacheDomain=function(t){if(!u)return!1;for(var n=this._getDomainObject(t),e=u.length-1;e>=0;e--)u[e].domain===n.domain&&u.splice(e,1)},y.prototype.getCurrentDomains=function(){return u},y.prototype._getDomainObject=function(t){return"string"==typeof t?this.findDomainByName(t):t},y.prototype._getSubDomainObject=function(t){return"string"==typeof t?this.findDomainByName(t+"."+this.getMainDomain().domain):t},y.prototype._associateAddonDomains=function(){var n=this;t.forEach(D,(function(t){var e=n._getSubDomainObject(t.subdomain);e&&(e.associatedAddonDomain=t.domain)}))},y.prototype.addSubdomain=function(n){var e=this,o=new a.Class;o.initialize("SubDomain","addsubdomain");var i=n.subdomain.substr(0,n.subdomain.length-(n.domain.length+1));return o.addArgument("domain",i),o.addArgument("rootdomain",n.domain),o.addArgument("canoff","1"),o.addArgument("disallowdot","0"),o.addArgument("dir",n.fullDocumentRoot),e.promise(o).then((function(o){var a=n.newDomainName;return e.fetchSingleDomainData(a).then((function(o){return o=t.extend(o,{subdomain:o.subdomain,rootDomain:n.domain,type:d.SUBDOMAIN,canEdit:s.hasWebServerRole&&r,canRemove:!0}),e._cacheDomain(o)}))}))},y.prototype.addAddonDomain=function(n){var e=this,o=new a.Class;return o.initialize("AddonDomain","addaddondomain"),o.addArgument("subdomain",n.subdomain),o.addArgument("newdomain",n.newDomainName),o.addArgument("ftp_is_optional","1"),o.addArgument("dir",n.documentRoot),e.promise(o).then((function(){return e.fetchSingleDomainData(n.newDomainName).then((function(o){var a=t.extend(t.copy(o),{type:d.ADDON,subdomain:n.subdomain,canEdit:s.hasWebServerRole&&r,canRemove:!0});return e._cacheDomain(t.extend(t.copy(o),{domain:n.subdomain+"."+n.domain,subdomain:n.subdomain,type:d.SUBDOMAIN,associatedAddonDomain:a,canEdit:s.hasWebServerRole&&r,canRemove:!0})),e._cacheDomain(a)}))}))},y.prototype.addAliasDomain=function(n){var e=this,o=new a.Class;return o.initialize("Park","park"),o.addArgument("domain",n.newDomainName),e.promise(o).then((function(){var o=t.copy(e.getMainDomain());return o.domain=n.newDomainName,o.type=d.ALIAS,o.canRemove=!0,e._cacheDomain(o)}))},y.prototype.add=function(t){var n,e=this;return t.domainType===d.SUBDOMAIN?n=e.addSubdomain(t):t.domainType===d.ADDON?n=e.addAddonDomain(t):t.domainType===d.ALIAS&&(n=e.addAliasDomain(t)),n.then((function(n){var o=b(t.domainType),a=S(e.getUsageStats(),o.stat);return a&&a.usage++,e.updateDomainTypeLimits(),n})),n},y.prototype.generateFullDocumentRoot=function(t){var n="1"===s.requirePublicHTMLSubs.toString(),e=this.getMainDomain().homedir+"/";return n&&(e+="public_html/"),e+=t?t.replace(/^\//,""):""},y.prototype.getMainDomain=function(){return c},y.prototype.findDomainByName=function(t){return g[t]},y.prototype.fetchSingleDomainData=function(t){var n=this,e=new o.Class;return e.initialize("DomainInfo","single_domain_data"),e.addArgument("domain",t),e.addArgument("return_https_redirect_status",1),n.promise(e).then((function(t){var e=0;return"addon_domain"===t.data.type?e=d.ADDON:"sub_domain"===t.data.type&&(e=d.SUBDOMAIN),n.formatSingleDomain(t.data,e)}))},y.prototype.fetchDomains=function(){var t=this,e=new o.Class;return e.initialize("DomainInfo","domains_data"),e.addArgument("return_https_redirect_status",1),t.promise(e).then((function(e){var o=t.formatSingleDomain(e.data.main_domain);o.type=d.MAIN,o.canRemove=!1,c=o,t._cacheDomain(c),f=[];var a=e.data.sub_domains||[];return a.forEach((function(n){var e=t.formatSingleDomain(n,d.SUBDOMAIN);this.push(e),t._cacheDomain(e)}),f),D=[],(a=e.data.addon_domains||[]).forEach((function(e){var o=t.formatSingleDomain(e,d.ADDON);this.push(o),t._cacheDomain(o);var a=n.assign({},o);a.domain=a.rootDomain,a.type=d.SUBDOMAIN,f.push(a),t._cacheDomain(a)}),D),p=[],e.data.parked_domains.forEach((function(n){var o=t.formatSingleDomain(e.data.main_domain,d.ALIAS);o.domain=n,this.push(o),t._cacheDomain(o)}),p),c}))},y.prototype.formatSingleDomain=function(t,n){var e={domain:t.domain,homedir:t.homedir,documentRoot:t.documentroot||t.dir,rootDomain:t.servername,isHttpsRedirecting:parseInt(t.is_https_redirecting),hasValidHTTPSAliases:parseInt(t.all_aliases_valid),nonHTTPS:!parseInt(t.can_https_redirect),redirectsTo:"not redirected"===t.status?null:t.status,type:t.type,realRootDomain:s.mainDomain};if(n){e.type=n,e.homedir=this.getMainDomain().homedir;var o=this.getMainDomain().domain;if(n===d.SUBDOMAIN){var a=t.domain.match(/.*\.(.+\..+)$/);o=a?a[1]:o}var i=e.rootDomain?e.rootDomain.substr(0,e.rootDomain.lastIndexOf("."+o)):null;e.canRemove=!0,n!==d.ALIAS&&(e.canEdit=s.hasWebServerRole&&r,e.subdomain=i),n===d.SUBDOMAIN?e.rootDomain=o:n===d.ALIAS&&(e.rootDomain=s.mainDomain)}return e},y.prototype.get=function(){var t=this;return h||(u?i.resolve(u):(u=[],h=t.fetchDomains().then((function(){return t._associateAddonDomains(),u})).finally((function(){h=null}))))},y.prototype.getResourceUsageStats=function(){var t=new o.Class;return t.initialize("ResourceUsage","get_usages"),this.promise(t).then((function(t){return t.data}))},y.prototype.getDomainTypes=function(){return A},y.prototype.getUsageStats=function(){return l},y.prototype.updateDomainTypeLimits=function(){var t=this,n=t.getUsageStats();return t.getDomainTypes().forEach((function(t){var e=S(n,t.stat);t.overLimit=_(e),"1"!==s.hasWebServerRole&&t.requiresCustomDocumentRoot?t.overLimit=!0:!t.overLimit&&t.dependantStat&&(t.overLimit=t.overLimit||_(S(n,t.dependantStat)))})),t.getDomainTypes()},y.prototype.getTypes=function(){var t=this;return t.getUsageStats()?i.resolve(t.getDomainTypes()):t.getResourceUsageStats().then((function(n){return l=n,t.updateDomainTypeLimits(),t.getDomainTypes()}))},y.prototype.updateDocumentRoot=function(t,n){var e=this,o=e._getDomainObject(t);["subdomain","rootDomain"].forEach((function(t){if(!o[t])throw new Error(t+" is required but undefined on "+o.domain)}));var i=o.rootDomain;o.type===d.ADDON&&(i=o.realRootDomain);var r=new a.Class;return r.initialize("SubDomain","changedocroot"),r.addArgument("subdomain",o.subdomain),r.addArgument("rootdomain",i),r.addArgument("dir",n),e.promise(r).then((function(t){return o.documentRoot=n,e.fetchSingleDomainData(o.domain).then((function(t){var n=t.documentRoot;if(o.type===d.ADDON){var a=e._getSubDomainObject(o.subdomain);a&&(a.documentRoot=n)}else if(o.associatedAddonDomain){e._getDomainObject(o.associatedAddonDomain).documentRoot=n}return o.documentRoot=n,o}))}))},y.prototype.removeSubdomain=function(t){var n,e=this._getDomainObject(t),o=new RegExp("."+e.rootDomain+"$");n=e.domain.match(o)?e.subdomain+"_"+e.rootDomain:e.domain;var i=new a.Class;return i.initialize("SubDomain","delsubdomain"),i.addArgument("domain",n),this.promise(i)},y.prototype.removeAddonDomain=function(t){var n=this,e=n._getDomainObject(t),o=new a.Class;return o.initialize("AddonDomain","deladdondomain"),o.addArgument("domain",e.domain),o.addArgument("subdomain",e.subdomain+"_"+n.getMainDomain().domain),n.promise(o)},y.prototype.removeAliasDomain=function(t){var n=this._getDomainObject(t),e=new a.Class;return e.initialize("Park","unpark"),e.addArgument("domain",n.domain),this.promise(e)},y.prototype.removeRedirect=function(t){var n=this._getDomainObject(t),e=new o.Class;return e.initialize("Mime","delete_redirect"),e.addArgument("domain",n.domain),e.addArgument("src",n.redirectTo),e.addArgument("redirect",n.documentRoot),this.promise(e).then((function(){n.redirectTo=""}))},y.prototype._removeDomainAdjustStats=function(t){var n=this,e=n._getDomainObject(t);if(e){e.type===d.ADDON&&n._removeDomainAdjustStats(e.subdomain+"."+n.getMainDomain().domain),n._uncacheDomain(e);var o=b(e.type),a=S(n.getUsageStats(),o.stat);a&&a.usage--,n.updateDomainTypeLimits()}},y.prototype.remove=function(t){var e=this,o=e._getDomainObject(t),a=o.canEdit;o.canEdit=!1;var r=!1,m=[];return o.type===d.SUBDOMAIN?m.push(e.removeSubdomain(o)):o.type===d.ADDON?m.push(e.removeAddonDomain(o)):o.type===d.ALIAS&&(o.redirectTo&&m.push(e.removeRedirect(o)),m.push(e.removeAliasDomain(o))),o.removing=!0,i.all(m).then((function(t){e._removeDomainAdjustStats(o)}),(function(t){if(n.isArray(t))t.forEach((function(t){if(t&&t.error)throw r=!0,t.error}));else if(t&&t.error)throw r=!0,t.error;o.canEdit=a})).finally((function(){o.removing=!1,r||e._uncacheDomain(o)}))},y.prototype.getDocumentRootPattern=function(){return new RegExp("^[^"+n.escapeRegExp('%?* :|"<>\\')+"]+$")},y.prototype.canRedirectHTTPS=function(){return"1"===s.canRedirectHTTPS},y.prototype.toggleHTTPSRedirect=function(t,n){var e=new o.Class;if(e.initialize("SSL","toggle_ssl_redirect_for_domains"),e.addArgument("state",t?1:0),n){var a=n;e.addArgument("domains",a)}else{for(var i=[],r=0;r<u.length;r++)u[r].selected&&!u[r].associatedAddonDomain&&void 0===u[r].associatedAddonDomain&&i.push(u[r].domain);var m=i.join(",");e.addArgument("domains",m)}return this.promise(e)},new y}])}));