define("app/controllers/ROUTES",["cjt/util/locale","cjt/core"],(function(e,t){"use strict";var i=[{id:"listDomains",route:"/",hideTitle:!0,controller:"ListDomainsController",controllerAs:"listDomains",templateUrl:t.buildFullPath("shared/js/email_deliverability/views/listDomains.phtml"),title:e.maketext("List Domains"),resolve:{initialDomains:["DomainsService",function(e){return e.fetchAll()}]}},{id:"manageDomain",route:"/manage",controller:"ManageDomainController",controllerAs:"manageDomain",templateUrl:t.buildFullPath("shared/js/email_deliverability/views/manageDomain.ptt"),hideTitle:!0,title:e.maketext("Manage the Domain"),resolve:{initialDomains:["DomainsService",function(e){return e.fetchAll()}]},parentID:"listDomains"},{id:"manageDomainSPF",route:"/manage/spf",controller:"ManageDomainSPFController",controllerAs:"manageDomainSPF",templateUrl:t.buildFullPath("shared/js/email_deliverability/views/manageDomainSPF.ptt"),hideTitle:!0,title:e.maketext("Customize an [output,abbr,SPF,Sender Policy Framework] Record"),resolve:{initialDomains:["DomainsService",function(e){return e.fetchAll()}]},parentID:"manageDomain"},{id:"manageDomainDKIM",route:"/manage/dkim",controller:"ManageDomainDKIMController",controllerAs:"manageDomainDKIM",templateUrl:t.buildFullPath("shared/js/email_deliverability/views/manageDomainDKIM.ptt"),hideTitle:!0,title:e.maketext("View a [output,acronym,DKIM,DomainKeys Identified Mail] Private Key"),resolve:{initialDomains:["DomainsService",function(e){return e.fetchAll()}]},parentID:"manageDomain"}];return i.forEach((function(e){e.breadcrumb={id:e.id,name:e.title,path:e.route,parentID:e.parentID}})),i})),define("app/controllers/route",["angular","app/controllers/ROUTES","cjt/directives/breadcrumbs","cjt/services/alertService"],(function(e,t){"use strict";var i="cpanel.emailDeliverability.controllers.route",s=["$scope","$rootScope","$location","alertService"],r=function(i,s,r,n){e.extend(i,{activeTab:0,currentTab:null,routes:t}),s.$on("$routeChangeStart",(function(){i.loading=!0,n.clear("danger")})),s.$on("$routeChangeSuccess",(function(e,t){if(i.loading=!1,i.parentTab=null,t){var s=(o=t.$$route.originalPath,i.routes.forEach((function(e,t){e.route===o&&(a=t)})),a);i.currentTab=i.routes[s],i.activeTab=s,i.currentTab&&(i.parentTab=(r=i.currentTab.parentRoute,i.routes.forEach((function(e){e.id===r&&(n=e)})),n))}var r,n,o,a})),s.$on("$routeChangeError",(function(){i.loading=!1}))};return s.push(r),e.module(i,[]).controller("RouteController",s),{class:r,namespace:i}})),define("shared/js/email_deliverability/services/Domain.class",["lodash"],(function(e){"use strict";var t=function(t){var i=this,s=["domain"];this.records=[],this._recordDetails={},this.reloadingIn=0,this.nameservers=[],this.zone="",this.recordsLoaded=!1,this.recordsValid=!1,this._recordTypesLoaded=[],this._recordsTypesWithIssues=[],this._suggestedRecords={},this._expectedMatch={},this.hasNSAuthority=!1,this.mailIP={version:null,address:null},this.hadAnyNSErrors=!1,this.init=function(e){Object.keys(e).forEach((function(t){i[t]=e[t]})),i.protocol="http",i.isWildcard=i.domain&&"*"===i.domain.substr(0,1),s.forEach((function(e){if(!i[e])throw new Error("“"+e+"” is a required parameter.")}))}.bind(this),this.addRecord=function(t){if(e.isUndefined(t.recordType))throw new Error("recordType must be defined on a record");if(e.isUndefined(t.valid))throw new Error("valid must be defined on a record of type “"+t.recordType+"” for domain “"+this.domain+"”");this.records.push(t)}.bind(this),this.setRecordsLoaded=function(e){this._recordTypesLoaded=e,this.recordsLoaded=!0,this._recordsTypesWithIssues=[],e.forEach((function(e){var t=this.getRecords(e);1===t.length&&t[0].valid||this._recordsTypesWithIssues.push(e)}),this);var t=this.getRecordDetails();Object.keys(t).forEach((function(e){t[e].error&&(this.hadAnyNSErrors=!0)}),this),this.recordsValid=0===this._recordsTypesWithIssues.length}.bind(this),this.getRecords=function(e){var t=this.records;return e&&(t=t.filter((function(t){return-1!==e.indexOf(t.recordType)}))),t}.bind(this),this.isRecordValid=function(e){return-1===this._recordsTypesWithIssues.indexOf(e)}.bind(this),this.getRecordTypesWithIssues=function(){return this._recordsTypesWithIssues}.bind(this),this.getRecordTypesWithNSErrors=function(){var e=[];return Object.keys(this._recordDetails).forEach((function(t){this._recordDetails[t].error&&e.push(t)}),this),e}.bind(this),this.getSuggestedRecord=function(e){return this.recordsLoaded&&this.isRecordValid(e)?this.getCurrentRecord(e):this._suggestedRecords[e]}.bind(this),this.setSuggestedRecord=function(e,t){this._suggestedRecords[e]=t}.bind(this),this.getExpectedMatch=function(e){return this._expectedMatch[e]}.bind(this),this.setExpectedMatch=function(e,t){this._expectedMatch[e]=t}.bind(this),this.resetRecordLoaded=function(){this.recordsLoaded=!1,this.recordTypesLoaded=[],this.reloadingIn=0,this.records=[],this.hasNSAuthority=!1,this.recordsValid=!1,this._recordsTypesWithIssues=[],this.hadAnyNSErrors=!1}.bind(this),this.setMailIP=function(e,t){this.mailIP.version=e,this.mailIP.address=t}.bind(this),this.getMailIP=function(){return this.mailIP}.bind(this),this.getRecordTypesLoaded=function(){return this._recordTypesLoaded}.bind(this),this.getCurrentRecord=function(e){var t=this.getRecords([e])[0];return t?t.current:{}}.bind(this),this.recordHadNSError=function(e){return!!this._recordDetails[e].error}.bind(this),this.init(t)};return e.assign(t.prototype,{setRecordDetails:function(e,t){if(!/^[a-z]+$/.test(e))throw new Error("Invalid record type: "+e);this._recordDetails[e]=t},getRecordDetails:function(e){if(!e)return this._recordDetails;if(!this._recordDetails.hasOwnProperty(e))throw new Error("No stored details: "+e);return this._recordDetails[e]}}),t})),define("shared/js/email_deliverability/services/domainFactory",["lodash","shared/js/email_deliverability/services/Domain.class"],(function(e,t){"use strict";var i={SUBDOMAIN:"subdomain",ADDON:"addon",ALIAS:"alias",MAIN:"main_domain"};return new function(e,s){this._mainHomedir=e,this._mainDomain=s,this._cleanRaw=function(e){return e.homedir=this._mainHomedir,e.documentRoot=e.documentRoot||e.dir,e.rootDomain=e.rootDomain||e.rootdomain||this._mainDomain,e.redirectsTo="not redirected"===e.status?null:e.status,delete e.dir,delete e.rootdomain,delete e.status,e}.bind(this),this.create=function(e){var i=this._cleanRaw(e);return new t(i)}.bind(this),this.setMainHomedir=function(e){this._mainHomedir=e}.bind(this),this.setMainDomain=function(e){this._mainDomain=e}.bind(this),this.getTypeConstants=function(){return i}.bind(this),this.getClass=function(){return t}.bind(this)}})),define("shared/js/email_deliverability/services/DKIMRecordProcessor",[],(function(){"use strict";return new function(){this.generateSuggestedRecord=function(e){return{name:e.domain+".",value:e.expected}}.bind(this),this.normalizeResults=function(e){return e.data.forEach((function(e){var t=e.domain;e.records.forEach((function(e){e.current={name:t+".",value:e.current}}))})),e}.bind(this),this.getValidateAPI=function(){return{module:"EmailAuth",func:"validate_current_dkims"}}.bind(this),this.getInstallAPI=function(){return{module:"EmailAuth",func:"enable_dkim"}}.bind(this),this.processResultItem=function(e){var t=[];return e&&(t=e.records.map(this.parseRecord.bind(this))),t}.bind(this),this.processResultItems=function(e){var t=[];return e.forEach((function(e){t.push(this.processResultItem(e))}),this),t}.bind(this),this.parseRecord=function(e){return e.recordType="dkim",this.validateState(e)}.bind(this),this.validateState=function(e){switch(e.valid=!1,e.state){case"MISMATCH":case"PERMFAIL":break;case"PASS":case"VALID":e.valid=!0}return e}.bind(this)}})),define("shared/js/email_deliverability/services/spfParser",["lodash"],(function(e){"use strict";var t=function(e,t){this.name="MechanismError",this.message=e,this.type=t||"warning",this.stack=(new Error).stack};function i(e,i,s){var r=s.match(i)[1];if(!r)return null;if(":"===r||"/"===r)throw new t("Blank argument for the "+e+" mechanism","error");return/^:/.test(r)&&(r=r.replace(/^:/,"")),r}function s(e,i,s,r){var n=s.match(i)[1];if(!r&&!n)throw new t("Missing mandatory argument for the "+e+" mechanism","error");if(":"===n||"="===n)throw new t("Blank argument for the "+e+" mechanism","error");return/^(:|=)/.test(n)&&(n=n.replace(/^(:|=)/,"")),n}(t.prototype=Object.create(Error.prototype)).constructor=t;var r={version:{description:"The SPF record version",pattern:/^v=(.+)$/i,validate:function(e){return e.match(this.pattern)[1]}},all:{description:"Always matches. It goes at the end of your record",pattern:/^all$/i},ip4:{description:"Match if IP is in the given range",pattern:/^ip4:(([\d.]*)(\/\d+)?)$/i,validate:function(e){var i=e.match(this.pattern)[1];if(!i)throw new t("Missing or blank mandatory network specification for the 'ip4' mechanism.","error");return i}},ip6:{description:"Match if IPv6 is in the given range",pattern:/^ip6:((.*?)(\/\d+)?)$/i,validate:function(e){var i=e.match(this.pattern)[1];if(!i)throw new t("Missing or blank mandatory network specification for the 'ip6' mechanism.","error");return i}},a:{description:"Match if IP has a DNS 'A' record in given domain",pattern:/a((:.*?)?(\/\d*)?)?$/i,validate:function(e){return i("a",this.pattern,e)}},mx:{description:"",pattern:/mx((:.*?)?(\/\d*)?)?$/i,validate:function(e){return i("mx",this.pattern,e)}},ptr:{description:"Match if IP has a DNS 'PTR' record within given domain",pattern:/^ptr(:.*?)?$/i,validate:function(e){return t="ptr",i=this.pattern,s(t,i,e,!0);var t,i}},exists:{pattern:/^exists(:.*?)?$/i,validate:function(e){return s("exists",this.pattern,e)}},include:{description:"The specified domain is searched for an 'allow'",pattern:/^include(:.*?)?$/i,validate:function(e){return s("include",this.pattern,e)}},redirect:{description:"The SPF record for the value replaces the current record",pattern:/redirect(=.*?)?$/i,validate:function(e){return s("redirect",this.pattern,e)}},exp:{description:"Explanation message to send with rejection",pattern:/exp(=.*?)?$/i,validate:function(e){return s("exp",this.pattern,e)}}},n={"+":"Pass","-":"Fail","~":"SoftFail","?":"Neutral"},o=/^v=spf1/i,a=/(\+|-|~|\?)?(.+)/i;function c(e,i){var s=e.match(a),c={};if(null!==s){var l=s[1],d=s[2];l?(c.prefix=l,c.prefixdesc=n[l]):o.test(d)?c.prefix="v":(c.prefix="+",c.prefixdesc=n["+"]);var u=!1;for(var h in r)if(Object.prototype.hasOwnProperty.call(r,h)){var p=r[h];if(p.pattern.test(d)){if(u=!0,c.type=h,c.description=p.description,p.validate)try{var m=p.validate.call(p,d);null!=m&&(c.value=m)}catch(e){if(e instanceof t){i.push({message:e.message,type:e.type});break}}break}}u||i.push({message:"Unknown standalone term '".concat(d,"'"),type:"error"})}return c}return{parse:function(t){t=t.trim();var i={mechanisms:[],messages:[],valid:!1};if(!o.test(t))return i.messages.push({message:"No valid version found, record must start with 'v=spf1'",type:"error"}),i;var s=t.split(/\s+/),r=s.filter((function(e){return new RegExp("=").test(e)})).map((function(e){return e.match(/^(.*?)=/)[1]})).filter((function(t,i,s){return e.includes(s,t,i+1)}));if(r&&r.length>0)return i.messages.push({type:"error",message:'Modifiers like "'.concat(r[0],'" may appear only once in an SPF string')}),i;var n=s.map((function(e){return e.replace(/^(\+|-|~|\?)/,"")})).filter((function(t,i,s){return e.includes(s,t,i+1)}));n&&n.length>0&&i.messages.push({type:"warning",message:"One or more duplicate mechanisms were found in the policy"});try{for(var a=0;a<s.length;a++){var l=c(s[a],i.messages);l&&i.mechanisms.push(l)}}catch(e){console.error(e)}if(i.mechanisms.length>0){var d=e.find(i.mechanisms,(function(e){return"redirect"===e.type})),u=e.find(i.mechanisms,(function(e){return"all"===e.type}));u||d||i.messages.push({type:"warning",message:'SPF strings should always either use an "all" mechanism or a "redirect" modifier to explicitly terminate processing.'});var h=-1;i.mechanisms.forEach((function(e,t){"all"===e.type&&-1===h&&(h=t)})),h>-1&&h<i.mechanisms.length-1&&i.messages.push({type:"warning",message:'One or more mechanisms were found after the "all" mechanism. These mechanisms will be ignored'}),d&&u&&i.messages.push({type:"warning",message:'The "redirect" modifier will not be used, because the SPF string contains an "all" mechanism. A "redirect" modifier is only used after all mechanisms fail to match, but "all" will always match'})}return!Object.keys(i.messages).length>0&&delete i.messages,i.valid=!0,i},parseTerm:c,mechanisms:r,prefixes:n}})),define("shared/js/email_deliverability/services/SPFRecordProcessor",["shared/js/email_deliverability/services/spfParser"],(function(e){"use strict";return new function(){this.generateSuggestedRecord=function(e){var t=(e.expected||"").split(/\s+/).map(this._parseSPFTerm),i="";if(e.records.length){var s=e.records[0].current;i=this.combineRecords(s.value,t)}else i=this.combineRecords("v=spf1 +mx +a ~all",t);return{name:e.domain+".",value:i,originalExpected:e.expected}}.bind(this),this.normalizeResults=function(e){return e.data.forEach((function(e){var t=e.domain;e.records.forEach((function(e){e.current={name:t+".",value:e.current}}))})),e}.bind(this),this.getValidateAPI=function(){return{module:"EmailAuth",func:"validate_current_spfs"}}.bind(this),this.getInstallAPI=function(){return{module:"EmailAuth",func:"install_spf_records"}}.bind(this),this.processResultItem=function(e){var t=[];return e&&(t=e.records.map(this.parseRecord.bind(this))),t}.bind(this),this.processResultItems=function(e){var t=[];return e.forEach((function(e){t.push(this.processResultItem(e))}),this),t}.bind(this),this.parseRecord=function(e){var t=e.current.name,i=e.current.value,s=this._parseSPF(i);return s.state=e.state,s.recordType="spf",s.current={name:t,value:i},s=this.validateState(s)}.bind(this),this.validateState=function(e){switch(e.valid=!1,e.state){case"SOFTFAIL":case"PERMERROR":break;case"PASS":case"VALID":e.valid=!0}return e}.bind(this),this._parseSPF=e.parse.bind(e),this._parseSPFTerm=e.parseTerm.bind(e),this.combineRecords=function(e,t){e=e||"";var i=this._parseSPF(e),s=[];t.forEach((function(e){i.mechanisms.forEach((function(t,i){t.type===e.type&&t.value===e.value&&s.push(i)}))})),(s=s.sort().reverse()).forEach((function(e){i.mechanisms.splice(e,1)}));for(var r=[],n=0;i.mechanisms[n]&&i.mechanisms[n].type&&i.mechanisms[n].type.match(/^(version|ip|mx|a)$/);)r.push(i.mechanisms[n]),n++;for(t.forEach((function(e){r.push(e)}));n<i.mechanisms.length;)r.push(i.mechanisms[n]),n++;return r.map((function(e){var t;return"version"===e.type?t=e.prefix+"="+e.value:(t=e.prefix+e.type,e.value&&(t+=":"+e.value)),t})).join(" ")}.bind(this)}})),define("shared/js/email_deliverability/services/PTRRecordProcessor",[],(function(){"use strict";return new function(){this.generateSuggestedRecord=function(e){return{name:e.expected+".",value:"unknown"}}.bind(this),this.normalizeResults=function(e){return{data:e.data.map((function(e){var t=e.domain,i=e.ptr_records.map((function(i){return{current:{name:e.arpa_domain+".",value:i.domain},domain:t,state:i.state}}));return{expected:e.arpa_domain,domain:t,records:i,details:e}}))}}.bind(this),this.getValidateAPI=function(){return{module:"EmailAuth",func:"validate_current_ptrs"}}.bind(this),this.getInstallAPI=function(){throw new Error("ptr does not do install in this interface")}.bind(this),this.processResultItem=function(e){var t=[];return e&&(t=e.records.map(this.parseRecord.bind(this))),t}.bind(this),this.processResultItems=function(e){var t=[];return e.forEach((function(e){t.push(this.processResultItem(e))}),this),t}.bind(this),this.parseRecord=function(e){return e.recordType="ptr",this.validateState(e)}.bind(this),this.validateState=function(e){switch(e.valid=!1,e.state){case"PASS":case"VALID":e.valid=!0}return e}.bind(this)}})),define("shared/js/email_deliverability/services/domains",["angular","lodash","cjt/util/locale","shared/js/email_deliverability/services/domainFactory","shared/js/email_deliverability/services/DKIMRecordProcessor","shared/js/email_deliverability/services/SPFRecordProcessor","shared/js/email_deliverability/services/PTRRecordProcessor","cjt/modules","cjt/services/alertService","cjt/modules","cjt/services/APICatcher"],(function(e,t,i,s,r,n,o){"use strict";var a="shared.emailDeliverability.services.domains",c=["$q","$log","$interval","alertService","APIInitializer","APICatcher","DOMAIN_TYPE_CONSTANTS","PAGE"];var l=function(e){this.zone=e,this.domains=[],this.lockDomain=null};l.prototype.addDomain=function(e){this.domains.push(e)},l.prototype.getLockDomain=function(){return this.lockDomain},l.prototype.lock=function(e){if("object"!=typeof e)throw new Error("Give a domain object!");if(this.lockDomain)throw new Error("Zone "+this.zone+" cannot lock for "+e.domain+" because the zone is already locked for "+this.lockDomain+"!");this.lockDomain=e},l.prototype.unlock=function(){this.lockDomain=null};var d=function(e,a,c,d,u,h,p,m){var f,_={},g={},v=[],y=function(){};return(y.prototype=Object.create(h))._cacheDomain=function(e){return f||(f=[]),_[e.domain]=e,_["default._domainkey."+e.domain]=e,f.push(e),e},y.prototype._uncacheDomain=function(e){if(!f)return!1;for(var t=this._getDomainObject(e),i=f.length-1;i>=0;i--)if(f[i].domain===t.domain)return f.splice(i,1),!0;return!1},y.prototype._getDomainObject=function(e){var t=e;return"string"==typeof t&&(t=this.findDomainByName(t)),t instanceof s.getClass()!=!0&&a.warn("Could not find domain “"+e+"”"),t},y.prototype.findDomainByName=function(e){return _[e]},y.prototype.getAll=function(){return f},y.prototype.fetchAll=function(){var t=this;return t.getAll()||(f=[],(m.domains||[]).forEach((function(e){if("*."!==e.substring(0,2)){var i=s.create({domain:e,type:e===m.mainDomain?p.MAIN:p.DOMAIN});t._cacheDomain(i)}}))),e.resolve(t.getAll())},y.prototype._extractMailIPs=function(e){e.data.forEach((function(e){var t=this._getDomainObject(e.domain);t&&t.setMailIP(e.ip_version,e.ip_address)}),this)},y.prototype.findZoneByName=function(e){for(var t=0;t<v.length;t++)if(v[t].zone===e)return v[t];return null},y.prototype.findZoneByDomain=function(e){var t=this._getDomainObject(e);return _[t.domain]},y.prototype._addDomainToZone=function(e,t){var i=this.findZoneByName(t);i||(i=new l(t),v.push(i)),e.zone=t,i.addDomain(e),g[e.domain]=i},y.prototype._processNSAuthResultItem=function(e){var t=this._getDomainObject(e.domain);return t&&(t.soaError=e.error||void 0,t.hasNSAuthority="1"===e.local_authority.toString(),t.nameservers=e.nameservers,this._addDomainToZone(t,e.zone)),t},y.prototype._processRecordTypeResults=function(e,t,i){var s=e.normalizeResults(t);"ptr"===i&&this._extractMailIPs(t);var r=s.data,n=e.processResultItems(r);r.forEach((function(t,s){var r=this._getDomainObject(t.domain);if(r){var o=n[s],c=e.generateSuggestedRecord(t);r.setSuggestedRecord(i,c),r.setRecordDetails(i,t.details||t),"spf"===i&&r.setExpectedMatch(i,t.expected),o.forEach(r.addRecord.bind(r))}else a.debug("domain not found",t)}),this)},y.prototype._processMailRecordResults=function(e,s){var r=e.data,n=r.shift();n.data&&n.data.forEach(this._processNSAuthResultItem,this),s=s||this.getSupportedRecordTypes();var o=this.getRecordProcessors();s.forEach((function(e,s){var n=r[s],a=o[e];this._processRecordTypeResults(a,n,e),"dkim"===e&&function(e){var s=e.data.filter((function(e){return"set"===e.validity_cache_update}));if(s.length){var r=s.map((function(e){return t.escape(e.domain.replace(/^.+\._domainkey\./,""))}));r=t.sortBy(r,(function(e){return e.length})),d.add({type:"info",replace:!1,message:i.maketext("The system detected [quant,_1,domain,domains] whose [output,acronym,DKIM,DomainKeys Identified Mail] signatures were inactive despite valid [asis,DKIM] configuration. The system has automatically enabled [asis,DKIM] signatures for the following [numerate,_1,domain,domains]: [list_and_quoted,_2]",r.length,r)})}}(n)}),this)},y.prototype.fetchMailRecords=function(t,i){var s=this;if(0===t.length)return e.resolve();var r=(new Date).getTime(),n=u.init("Batch","strict"),o={};t.forEach((function(e,t){return o["domain-"+t]=e.domain}));var c=[];c.push(u.buildBatchCommandItem("DNS","has_local_authority",o)),i=i||this.getSupportedRecordTypes();var l=this.getRecordProcessors();return i.forEach((function(e){var t=l[e].getValidateAPI();c.push(u.buildBatchCommandItem(t.module,t.func,o))}),this),n.addArgument("command",c),this._fetchMailRecordsPromise&&(a.debug("Canceling prior record status load"),this._fetchMailRecordsPromise.cancelCpCall()),this._fetchMailRecordsPromise=this.promise(n),this._fetchMailRecordsPromise.then((function(e){var n=(new Date).getTime();a.debug("Updating record statuses load took "+(n-r)+"ms for "+t.length+" domains"),r=n,s._processMailRecordResults(e,i)})).finally((function(){delete s._fetchMailRecordsPromise;var e=(new Date).getTime();a.debug("Updating record statuses parsing took "+(e-r)+"ms for "+t.length+" domains")}))},y.prototype.validateAllRecords=function(e,t){var i=this;return t=t||i.getSupportedRecordTypes(),(e=e.filter((function(e){return!e.reloadingIn}))).forEach((function(e){e.resetRecordLoaded()}),i),i.fetchMailRecords(e,t).then((function(){e.forEach((function(e){e.setRecordsLoaded(t)}),i)}))},y.prototype.getRecordProcessors=function(){var e={dkim:r,spf:n};return void 0!==m.skipPTRLookups&&m.skipPTRLookups||(e.ptr=o),e},y.prototype.getSupportedRecordTypes=function(){return Object.keys(this.getRecordProcessors())},y.prototype.repairSPF=function(e,t){var i=this.getRecordProcessors().spf.getInstallAPI(),s=e.map((function(e){return e.domain})),r=u.init(i.module,i.func);return r.addArgument("domain",s),r.addArgument("record",t),this.promise(r)},y.prototype.unreflectedChangeMessage=function(e){var t=m.zoneEditorUrl,s="";s+=i.maketext("Because this is not an authoritative nameserver for the domain “[_1]”, the current or suggested records will not reflect your changes.",e),t&&(s+=" ",s+=i.maketext("Use the [output,url,_1,Zone Editor] to ensure that the system applied your changes.",t+e)),d.add({message:s,type:"warning"})},y.prototype.repairDKIM=function(e){var t=this.getRecordProcessors().dkim.getInstallAPI(),i=e.map((function(e){return e.domain})),s=u.init(t.module,t.func);return s.addArgument("domain",i),this.promise(s)},y.prototype.repairPTR=function(e){throw new Error("Installing PTR Records are not currently supported in this interface.")},y.prototype.repairRecord=function(e,t,i){return"spf"===t?this.repairSPF([e],[i]):"dkim"===t?this.repairDKIM([e],[i]):"ptr"===t?this.repairPTR([e],[i]):void 0},y.prototype._repairRecordSuccess=function(e,s,r){d.success({replace:!1,message:i.maketext("The system updated the “[_1]” record for “[_2]” to the following: [_3]",s.toUpperCase(),t.escape(e.domain),"<pre>"+t.escape(r)+"</pre>")})},y.prototype._repairRecordFailure=function(e,s,r){d.add({type:"error",replace:!1,message:i.maketext("The system failed to update the “[_1]” record for “[_2]” because of an error: [_3]",s.toUpperCase(),t.escape(e.domain),t.escape(r))})},y.prototype._interval=function(e,t,i){return c(e,t,i)},y.prototype._validateUntilSuccessComplete=function(e,t,s,r){var n=this;a.debug("["+e.domain+"] fetchMailRecords completed");var o=n.getSupportedRecordTypes();e.setRecordsLoaded(o);var c=t.some((function(t){return!e.isRecordValid(t)})),l=((new Date).getTime()-r)/1e3;if(a.debug("["+e.domain+"] time passed since records set: "+l),c&&l<120)return a.debug("["+e.domain+"] some failed, wait "+s+"s, and then try again."),l>5&&d.add({type:"info",replace:!0,message:i.maketext("The server records have not updated after [quant,_1,second,seconds]. The system will try again in [quant,_2,second,seconds].",Math.floor(l),Math.floor(s))}),e.resetRecordLoaded(),e.reloadingIn=s,n._interval((function(){e.reloadingIn--}),1e3,s).then((function(){return e.reloadingIn=0,s*=2,a.debug("["+e.domain+"] done waiting, trying again."),n.validateUntilSuccess(e,t,s,r)}));c?l>120&&(a.debug("["+e.domain+"] more than 120s was taken to validate the change."),d.add({type:"warning",replace:!0,message:i.maketext("The system cannot verify that the record updated after 120 seconds.")})):(a.debug("["+e.domain+"] all records fixed."),d.success({replace:!0,message:i.maketext("The system successfully updated the [asis,DNS] records.")})),e.setRecordsLoaded(n.getSupportedRecordTypes())},y.prototype.validateUntilSuccess=function(e,t,i,s){var r=this,n=this._getDomainObject(e),o=r.getSupportedRecordTypes();return a.debug("["+e.domain+"] begin validateUntilSuccess @"+i+"s"),r.fetchMailRecords([n],o).then((function(){return r._validateUntilSuccessComplete(n,t,i,s)}))},y.prototype.getDomainZoneObject=function(e){var t=this._getDomainObject(e);return this.findZoneByName(t.zone)||!1},y.prototype._repairDomainComplete=function(e,t,i,s,r){a.debug("["+t.domain+"] beginning _repairDomainComplete.");if(e.data){var n=[];if(e.data.forEach((function(e,r){var o=i[r],c=s[r],l=e.data[0];a.debug("["+l.domain+"] being parsed in _repairDomainComplete status: ["+l.status+"]."),"1"!==l.status.toString()?this._repairRecordFailure(t,o,l.msg):(n.push(o),this._repairRecordSuccess(t,o,c))}),this),r)return void a.debug("["+t.domain+"] does not have NS Authority. Do not continue validation check");if(n.length){a.debug("["+t.domain+"] some records succeeeded.",n.join(","));var o=(new Date).getTime();return this.validateUntilSuccess(t,n,5,o)}return this.validateAllRecords([t])}},y.prototype.repairDomain=function(e,t,i,s){t=t.slice(),i=i.slice();var r=this,n=this._getDomainObject(e),o=this.findZoneByName(n.zone);o.lock(n),a.debug("["+n.domain+"] locking zone: ",o.zone),a.debug("["+n.domain+"] beginning repairDomain."),s||n.resetRecordLoaded(),a.debug("["+n.domain+"] resetting loaded records.");var c=u.init("Batch","strict"),l=r.getRecordProcessors(),d=t.map((function(e,t){var s=i[t],r=l[e].getInstallAPI();return a.debug("["+n.domain+"] adding batch command for “"+e+"”."),u.buildBatchCommandItem(r.module,r.func,{domain:n.domain,record:s})}));return c.addArgument("command",d),r.promise(c).then((function(e){return a.debug("["+n.domain+"] batch command completed."),o.unlock(),r._repairDomainComplete(e,n,t,i,s)}))},y.prototype._processGetPrivateDKIMKey=function(e){return e.data.pop()},y.prototype.fetchPrivateDKIMKey=function(e){var t=this._getDomainObject(e),i=u.init("EmailAuth","fetch_dkim_private_keys");return i.addArgument("domain",t.domain),this.promise(i).then(this._processGetPrivateDKIMKey)},y.prototype.getCurrentRecord=function(e,t){return this._getDomainObject(e).getCurrentRecord(t)},y.prototype.getNoAuthorityMessage=function(e,s){var r,n=e.nameservers.map(t.escape);return r=e.nameservers.length?i.maketext("This system does not control [asis,DNS] for the “[_1]” domain.",e.domain):i.maketext("This system does not control [asis,DNS] for the “[_1]” domain and the system did not find any authoritative nameservers for this domain.",e.domain),"spf"!==s&&"dkim"!==s||(r+=" ",r+="<strong>",r+=i.maketext("You can install the suggested “[_1]” record locally. However, this server is not the authoritative nameserver. If you install this record, this change will not be effective.",s.toUpperCase()),r+="</strong>"),r+=" ",e.nameservers.length?r+=i.maketext("Contact the person responsible for the [list_and_quoted,_3] [numerate,_2,nameserver,nameservers] and request that they update the “[_1]” record with the following:",s.toUpperCase(),e.nameservers.length,n):r+=i.maketext("Contact your domain registrar to verify this domain’s registration."),r},y.prototype.fetchMailHeloIP=function(e){var t=this._getDomainObject(e),i=u.init("EmailAuth","get_mail_helo_ip");return i.addArgument("domain",t.domain),this.promise(i).then(this._processMailHeloResult)},y.prototype.localDKIMExists=function(e){var t="dkim";return!!e.isRecordValid(t)||!!e.getSuggestedRecord(t).value},y.prototype.ensureLocalDKIMKeyExists=function(e){var i=this,s=u.init("EmailAuth","ensure_dkim_keys_exist");return s.addArgument("domain",e.domain),i.promise(s).then((function(s){var r=s.data.pop();return"1"===r.status.toString()?i.fetchMailRecords([e]):d.add({type:"error",message:t.escape(r.msg)})}))},y.prototype.markViewLoad=function(){this._fetchMailRecordsPromise&&this._fetchMailRecordsPromise.cancelCpCall()},new y};c.push(d);var u=e.module(a,["cjt2.services.apicatcher","cjt2.services.alert"]);return u.value("PAGE",PAGE),u.value("DOMAIN_TYPE_CONSTANTS",s.getTypeConstants()),u.factory("DomainsService",c),{class:d,namespace:a}})),define("shared/js/email_deliverability/filters/htmlSafeString",["angular","lodash"],(function(e,t){"use strict";var i="shared.emailDeliverability.htmlSafeString.filter",s=function(){return t.escape};return e.module(i,[]).filter("htmlSafeString",[].concat(s)),{class:s,namespace:i}})),define("app/decorators/paginationDecorator",["angular","cjt/core","cjt/util/locale","uiBootstrap"],(function(e,t,i){"use strict";var s,r="cpanel.emailAccounts",n="decorators/pagination.phtml";try{s=e.module(r)}catch(t){s=e.module(r,["ui.bootstrap.pagination"])}return s.config(["$provide",function(e){e.decorator("uibPaginationDirective",["$delegate",function(e){var s=e[0],r=function(e,t){e&&e.forEach((function(e){e.id=t+"_"+e.text}))},o=function(e){e&&e.forEach((function(e){e.ariaLabel=i.maketext("Go to page “[_1]”.",e.text)}))},a=function(e,t){return i.maketext("Page [numf,_1] of [numf,_2]",e,t)};s.templateUrl=t.config.debug?t.buildFullPath("email_accounts/decorators/pagination.phtml"):n;var c=s.link;return s.compile=function(){return function(e,t,s,n){var l=n[0];c.apply(this,arguments),e.parentId=s.id,e.ariaLabels={title:i.maketext("Pagination"),firstPage:i.maketext("Go to first page."),previousPage:i.maketext("Go to previous page."),nextPage:i.maketext("Go to next page."),lastPage:i.maketext("Go to last page.")},e.updateCurrentSelectedText=a;var d=l.render;l.render=function(){d.apply(l),r(e.pages,e.parentId),o(e.pages)}}},e}])}]),{namespace:r,template:n}})),function(e){define("jquery-chosen",["jquery"],(function(){return function(){
/*!
Chosen, a Select Box Enhancer for jQuery and Prototype
by Patrick Filler for Harvest, http://getharvest.com

Version 1.5.1
Full source at https://github.com/harvesthq/chosen
Copyright (c) 2011-2016 Harvest http://getharvest.com

MIT License, https://github.com/harvesthq/chosen/blob/master/LICENSE.md
This file is generated by `grunt build`, do not edit it by hand.
*/
(function(){var e,t,i,s,r={}.hasOwnProperty;(s=function(){function e(){this.options_index=0,this.parsed=[]}return e.prototype.add_node=function(e){return"OPTGROUP"===e.nodeName.toUpperCase()?this.add_group(e):this.add_option(e)},e.prototype.add_group=function(e){var t,i,s,r,n,o;for(t=this.parsed.length,this.parsed.push({array_index:t,group:!0,label:this.escapeExpression(e.label),title:e.title?e.title:void 0,children:0,disabled:e.disabled,classes:e.className}),o=[],s=0,r=(n=e.childNodes).length;s<r;s++)i=n[s],o.push(this.add_option(i,t,e.disabled));return o},e.prototype.add_option=function(e,t,i){if("OPTION"===e.nodeName.toUpperCase())return""!==e.text?(null!=t&&(this.parsed[t].children+=1),this.parsed.push({array_index:this.parsed.length,options_index:this.options_index,value:e.value,text:e.text,html:e.innerHTML,title:e.title?e.title:void 0,selected:e.selected,disabled:!0===i?i:e.disabled,group_array_index:t,group_label:null!=t?this.parsed[t].label:null,classes:e.className,style:e.style.cssText})):this.parsed.push({array_index:this.parsed.length,options_index:this.options_index,empty:!0}),this.options_index+=1},e.prototype.escapeExpression=function(e){var t,i;return null==e||!1===e?"":/[\&\<\>\"\'\`]/.test(e)?(t={"<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},i=/&(?!\w+;)|[\<\>\"\'\`]/g,e.replace(i,(function(e){return t[e]||"&amp;"}))):e},e}()).select_to_array=function(e){var t,i,r,n,o;for(i=new s,r=0,n=(o=e.childNodes).length;r<n;r++)t=o[r],i.add_node(t);return i.parsed},t=function(){function e(t,i){this.form_field=t,this.options=null!=i?i:{},e.browser_is_supported()&&(this.is_multiple=this.form_field.multiple,this.set_default_text(),this.set_default_values(),this.setup(),this.set_up_html(),this.register_observers(),this.on_ready())}return e.prototype.set_default_values=function(){var e=this;return this.click_test_action=function(t){return e.test_active_click(t)},this.activate_action=function(t){return e.activate_field(t)},this.active_field=!1,this.mouse_on_container=!1,this.results_showing=!1,this.result_highlighted=null,this.allow_single_deselect=null!=this.options.allow_single_deselect&&null!=this.form_field.options[0]&&""===this.form_field.options[0].text&&this.options.allow_single_deselect,this.disable_search_threshold=this.options.disable_search_threshold||0,this.disable_search=this.options.disable_search||!1,this.enable_split_word_search=null==this.options.enable_split_word_search||this.options.enable_split_word_search,this.group_search=null==this.options.group_search||this.options.group_search,this.search_contains=this.options.search_contains||!1,this.single_backstroke_delete=null==this.options.single_backstroke_delete||this.options.single_backstroke_delete,this.max_selected_options=this.options.max_selected_options||1/0,this.inherit_select_classes=this.options.inherit_select_classes||!1,this.display_selected_options=null==this.options.display_selected_options||this.options.display_selected_options,this.display_disabled_options=null==this.options.display_disabled_options||this.options.display_disabled_options,this.include_group_label_in_selected=this.options.include_group_label_in_selected||!1,this.max_shown_results=this.options.max_shown_results||Number.POSITIVE_INFINITY},e.prototype.set_default_text=function(){return this.form_field.getAttribute("data-placeholder")?this.default_text=this.form_field.getAttribute("data-placeholder"):this.is_multiple?this.default_text=this.options.placeholder_text_multiple||this.options.placeholder_text||e.default_multiple_text:this.default_text=this.options.placeholder_text_single||this.options.placeholder_text||e.default_single_text,this.results_none_found=this.form_field.getAttribute("data-no_results_text")||this.options.no_results_text||e.default_no_result_text},e.prototype.choice_label=function(e){return this.include_group_label_in_selected&&null!=e.group_label?"<b class='group-name'>"+e.group_label+"</b>"+e.html:e.html},e.prototype.mouse_enter=function(){return this.mouse_on_container=!0},e.prototype.mouse_leave=function(){return this.mouse_on_container=!1},e.prototype.input_focus=function(e){var t=this;if(this.is_multiple){if(!this.active_field)return setTimeout((function(){return t.container_mousedown()}),50)}else if(!this.active_field)return this.activate_field()},e.prototype.input_blur=function(e){var t=this;if(!this.mouse_on_container)return this.active_field=!1,setTimeout((function(){return t.blur_test()}),100)},e.prototype.results_option_build=function(e){var t,i,s,r,n,o,a;for(t="",r=0,n=0,o=(a=this.results_data).length;n<o&&(s="",""!==(s=(i=a[n]).group?this.result_add_group(i):this.result_add_option(i))&&(r++,t+=s),(null!=e?e.first:void 0)&&(i.selected&&this.is_multiple?this.choice_build(i):i.selected&&!this.is_multiple&&this.single_set_selected_text(this.choice_label(i))),!(r>=this.max_shown_results));n++);return t},e.prototype.result_add_option=function(e){var t,i;return e.search_match&&this.include_option_in_results(e)?(t=[],e.disabled||e.selected&&this.is_multiple||t.push("active-result"),!e.disabled||e.selected&&this.is_multiple||t.push("disabled-result"),e.selected&&t.push("result-selected"),null!=e.group_array_index&&t.push("group-option"),""!==e.classes&&t.push(e.classes),(i=document.createElement("li")).className=t.join(" "),i.style.cssText=e.style,i.setAttribute("data-option-array-index",e.array_index),i.innerHTML=e.search_text,e.title&&(i.title=e.title),this.outerHTML(i)):""},e.prototype.result_add_group=function(e){var t,i;return(e.search_match||e.group_match)&&e.active_options>0?((t=[]).push("group-result"),e.classes&&t.push(e.classes),(i=document.createElement("li")).className=t.join(" "),i.innerHTML=e.search_text,e.title&&(i.title=e.title),this.outerHTML(i)):""},e.prototype.results_update_field=function(){if(this.set_default_text(),this.is_multiple||this.results_reset_cleanup(),this.result_clear_highlight(),this.results_build(),this.results_showing)return this.winnow_results()},e.prototype.reset_single_select_options=function(){var e,t,i,s,r;for(r=[],t=0,i=(s=this.results_data).length;t<i;t++)(e=s[t]).selected?r.push(e.selected=!1):r.push(void 0);return r},e.prototype.results_toggle=function(){return this.results_showing?this.results_hide():this.results_show()},e.prototype.results_search=function(e){return this.results_showing?this.winnow_results():this.results_show()},e.prototype.winnow_results=function(){var e,t,i,s,r,n,o,a,c,l,d,u;for(this.no_results_clear(),s=0,e=(n=this.get_search_text()).replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&"),c=new RegExp(e,"i"),i=this.get_search_regex(e),l=0,d=(u=this.results_data).length;l<d;l++)(t=u[l]).search_match=!1,r=null,this.include_option_in_results(t)&&(t.group&&(t.group_match=!1,t.active_options=0),null!=t.group_array_index&&this.results_data[t.group_array_index]&&(0===(r=this.results_data[t.group_array_index]).active_options&&r.search_match&&(s+=1),r.active_options+=1),t.search_text=t.group?t.label:t.html,t.group&&!this.group_search||(t.search_match=this.search_string_match(t.search_text,i),t.search_match&&!t.group&&(s+=1),t.search_match?(n.length&&(o=t.search_text.search(c),a=t.search_text.substr(0,o+n.length)+"</em>"+t.search_text.substr(o+n.length),t.search_text=a.substr(0,o)+"<em>"+a.substr(o)),null!=r&&(r.group_match=!0)):null!=t.group_array_index&&this.results_data[t.group_array_index].search_match&&(t.search_match=!0)));return this.result_clear_highlight(),s<1&&n.length?(this.update_results_content(""),this.no_results(n)):(this.update_results_content(this.results_option_build()),this.winnow_results_set_highlight())},e.prototype.get_search_regex=function(e){var t;return t=this.search_contains?"":"^",new RegExp(t+e,"i")},e.prototype.search_string_match=function(e,t){var i,s,r,n;if(t.test(e))return!0;if(this.enable_split_word_search&&(e.indexOf(" ")>=0||0===e.indexOf("["))&&(s=e.replace(/\[|\]/g,"").split(" ")).length)for(r=0,n=s.length;r<n;r++)if(i=s[r],t.test(i))return!0},e.prototype.choices_count=function(){var e,t,i;if(null!=this.selected_option_count)return this.selected_option_count;for(this.selected_option_count=0,e=0,t=(i=this.form_field.options).length;e<t;e++)i[e].selected&&(this.selected_option_count+=1);return this.selected_option_count},e.prototype.choices_click=function(e){if(e.preventDefault(),!this.results_showing&&!this.is_disabled)return this.results_show()},e.prototype.keyup_checker=function(e){var t,i;switch(t=null!=(i=e.which)?i:e.keyCode,this.search_field_scale(),t){case 8:if(this.is_multiple&&this.backstroke_length<1&&this.choices_count()>0)return this.keydown_backstroke();if(!this.pending_backstroke)return this.result_clear_highlight(),this.results_search();break;case 13:if(e.preventDefault(),this.results_showing)return this.result_select(e);break;case 27:return this.results_showing&&this.results_hide(),!0;case 9:case 38:case 40:case 16:case 91:case 17:case 18:break;default:return this.results_search()}},e.prototype.clipboard_event_checker=function(e){var t=this;return setTimeout((function(){return t.results_search()}),50)},e.prototype.container_width=function(){return null!=this.options.width?this.options.width:this.form_field.offsetWidth+"px"},e.prototype.include_option_in_results=function(e){return!(this.is_multiple&&!this.display_selected_options&&e.selected)&&(!(!this.display_disabled_options&&e.disabled)&&!e.empty)},e.prototype.search_results_touchstart=function(e){return this.touch_started=!0,this.search_results_mouseover(e)},e.prototype.search_results_touchmove=function(e){return this.touch_started=!1,this.search_results_mouseout(e)},e.prototype.search_results_touchend=function(e){if(this.touch_started)return this.search_results_mouseup(e)},e.prototype.outerHTML=function(e){var t;return e.outerHTML?e.outerHTML:((t=document.createElement("div")).appendChild(e),t.innerHTML)},e.browser_is_supported=function(){return!/iP(od|hone)/i.test(window.navigator.userAgent)&&((!/Android/i.test(window.navigator.userAgent)||!/Mobile/i.test(window.navigator.userAgent))&&(!/IEMobile/i.test(window.navigator.userAgent)&&(!/Windows Phone/i.test(window.navigator.userAgent)&&(!/BlackBerry/i.test(window.navigator.userAgent)&&(!/BB10/i.test(window.navigator.userAgent)&&("Microsoft Internet Explorer"!==window.navigator.appName||document.documentMode>=8))))))},e.default_multiple_text="Select Some Options",e.default_single_text="Select an Option",e.default_no_result_text="No results match",e}(),(e=jQuery).fn.extend({chosen:function(s){return t.browser_is_supported()?this.each((function(t){var r,n;n=(r=e(this)).data("chosen"),"destroy"!==s?n instanceof i||r.data("chosen",new i(this,s)):n instanceof i&&n.destroy()})):this}}),i=function(t){function i(){return i.__super__.constructor.apply(this,arguments)}return function(e,t){for(var i in t)r.call(t,i)&&(e[i]=t[i]);function s(){this.constructor=e}s.prototype=t.prototype,e.prototype=new s,e.__super__=t.prototype}(i,t),i.prototype.setup=function(){return this.form_field_jq=e(this.form_field),this.current_selectedIndex=this.form_field.selectedIndex,this.is_rtl=this.form_field_jq.hasClass("chosen-rtl")},i.prototype.set_up_html=function(){var t,i;return(t=["chosen-container"]).push("chosen-container-"+(this.is_multiple?"multi":"single")),this.inherit_select_classes&&this.form_field.className&&t.push(this.form_field.className),this.is_rtl&&t.push("chosen-rtl"),i={class:t.join(" "),style:"width: "+this.container_width()+";",title:this.form_field.title},this.form_field.id.length&&(i.id=this.form_field.id.replace(/[^\w]/g,"_")+"_chosen"),this.container=e("<div />",i),this.is_multiple?this.container.html('<ul class="chosen-choices"><li class="search-field"><input type="text" value="'+this.default_text+'" class="default" autocomplete="off" style="width:25px;" /></li></ul><div class="chosen-drop"><ul class="chosen-results"></ul></div>'):this.container.html('<a class="chosen-single chosen-default"><span>'+this.default_text+'</span><div><b></b></div></a><div class="chosen-drop"><div class="chosen-search"><input type="text" autocomplete="off" /></div><ul class="chosen-results"></ul></div>'),this.form_field_jq.hide().after(this.container),this.dropdown=this.container.find("div.chosen-drop").first(),this.search_field=this.container.find("input").first(),this.search_results=this.container.find("ul.chosen-results").first(),this.search_field_scale(),this.search_no_results=this.container.find("li.no-results").first(),this.is_multiple?(this.search_choices=this.container.find("ul.chosen-choices").first(),this.search_container=this.container.find("li.search-field").first()):(this.search_container=this.container.find("div.chosen-search").first(),this.selected_item=this.container.find(".chosen-single").first()),this.results_build(),this.set_tab_index(),this.set_label_behavior()},i.prototype.on_ready=function(){return this.form_field_jq.trigger("chosen:ready",{chosen:this})},i.prototype.register_observers=function(){var e=this;return this.container.bind("touchstart.chosen",(function(t){return e.container_mousedown(t),t.preventDefault()})),this.container.bind("touchend.chosen",(function(t){return e.container_mouseup(t),t.preventDefault()})),this.container.bind("mousedown.chosen",(function(t){e.container_mousedown(t)})),this.container.bind("mouseup.chosen",(function(t){e.container_mouseup(t)})),this.container.bind("mouseenter.chosen",(function(t){e.mouse_enter(t)})),this.container.bind("mouseleave.chosen",(function(t){e.mouse_leave(t)})),this.search_results.bind("mouseup.chosen",(function(t){e.search_results_mouseup(t)})),this.search_results.bind("mouseover.chosen",(function(t){e.search_results_mouseover(t)})),this.search_results.bind("mouseout.chosen",(function(t){e.search_results_mouseout(t)})),this.search_results.bind("mousewheel.chosen DOMMouseScroll.chosen",(function(t){e.search_results_mousewheel(t)})),this.search_results.bind("touchstart.chosen",(function(t){e.search_results_touchstart(t)})),this.search_results.bind("touchmove.chosen",(function(t){e.search_results_touchmove(t)})),this.search_results.bind("touchend.chosen",(function(t){e.search_results_touchend(t)})),this.form_field_jq.bind("chosen:updated.chosen",(function(t){e.results_update_field(t)})),this.form_field_jq.bind("chosen:activate.chosen",(function(t){e.activate_field(t)})),this.form_field_jq.bind("chosen:open.chosen",(function(t){e.container_mousedown(t)})),this.form_field_jq.bind("chosen:close.chosen",(function(t){e.input_blur(t)})),this.search_field.bind("blur.chosen",(function(t){e.input_blur(t)})),this.search_field.bind("keyup.chosen",(function(t){e.keyup_checker(t)})),this.search_field.bind("keydown.chosen",(function(t){e.keydown_checker(t)})),this.search_field.bind("focus.chosen",(function(t){e.input_focus(t)})),this.search_field.bind("cut.chosen",(function(t){e.clipboard_event_checker(t)})),this.search_field.bind("paste.chosen",(function(t){e.clipboard_event_checker(t)})),this.is_multiple?this.search_choices.bind("click.chosen",(function(t){e.choices_click(t)})):this.container.bind("click.chosen",(function(e){e.preventDefault()}))},i.prototype.destroy=function(){return e(this.container[0].ownerDocument).unbind("click.chosen",this.click_test_action),this.search_field[0].tabIndex&&(this.form_field_jq[0].tabIndex=this.search_field[0].tabIndex),this.container.remove(),this.form_field_jq.removeData("chosen"),this.form_field_jq.show()},i.prototype.search_field_disabled=function(){return this.is_disabled=this.form_field_jq[0].disabled,this.is_disabled?(this.container.addClass("chosen-disabled"),this.search_field[0].disabled=!0,this.is_multiple||this.selected_item.unbind("focus.chosen",this.activate_action),this.close_field()):(this.container.removeClass("chosen-disabled"),this.search_field[0].disabled=!1,this.is_multiple?void 0:this.selected_item.bind("focus.chosen",this.activate_action))},i.prototype.container_mousedown=function(t){if(!this.is_disabled&&(t&&"mousedown"===t.type&&!this.results_showing&&t.preventDefault(),null==t||!e(t.target).hasClass("search-choice-close")))return this.active_field?this.is_multiple||!t||e(t.target)[0]!==this.selected_item[0]&&!e(t.target).parents("a.chosen-single").length||(t.preventDefault(),this.results_toggle()):(this.is_multiple&&this.search_field.val(""),e(this.container[0].ownerDocument).bind("click.chosen",this.click_test_action),this.results_show()),this.activate_field()},i.prototype.container_mouseup=function(e){if("ABBR"===e.target.nodeName&&!this.is_disabled)return this.results_reset(e)},i.prototype.search_results_mousewheel=function(e){var t;if(e.originalEvent&&(t=e.originalEvent.deltaY||-e.originalEvent.wheelDelta||e.originalEvent.detail),null!=t)return e.preventDefault(),"DOMMouseScroll"===e.type&&(t*=40),this.search_results.scrollTop(t+this.search_results.scrollTop())},i.prototype.blur_test=function(e){if(!this.active_field&&this.container.hasClass("chosen-container-active"))return this.close_field()},i.prototype.close_field=function(){return e(this.container[0].ownerDocument).unbind("click.chosen",this.click_test_action),this.active_field=!1,this.results_hide(),this.container.removeClass("chosen-container-active"),this.clear_backstroke(),this.show_search_field_default(),this.search_field_scale()},i.prototype.activate_field=function(){return this.container.addClass("chosen-container-active"),this.active_field=!0,this.search_field.val(this.search_field.val()),this.search_field.focus()},i.prototype.test_active_click=function(t){var i;return(i=e(t.target).closest(".chosen-container")).length&&this.container[0]===i[0]?this.active_field=!0:this.close_field()},i.prototype.results_build=function(){return this.parsing=!0,this.selected_option_count=null,this.results_data=s.select_to_array(this.form_field),this.is_multiple?this.search_choices.find("li.search-choice").remove():this.is_multiple||(this.single_set_selected_text(),this.disable_search||this.form_field.options.length<=this.disable_search_threshold?(this.search_field[0].readOnly=!0,this.container.addClass("chosen-container-single-nosearch")):(this.search_field[0].readOnly=!1,this.container.removeClass("chosen-container-single-nosearch"))),this.update_results_content(this.results_option_build({first:!0})),this.search_field_disabled(),this.show_search_field_default(),this.search_field_scale(),this.parsing=!1},i.prototype.result_do_highlight=function(e){var t,i,s,r,n;if(e.length){if(this.result_clear_highlight(),this.result_highlight=e,this.result_highlight.addClass("highlighted"),r=(s=parseInt(this.search_results.css("maxHeight"),10))+(n=this.search_results.scrollTop()),(t=(i=this.result_highlight.position().top+this.search_results.scrollTop())+this.result_highlight.outerHeight())>=r)return this.search_results.scrollTop(t-s>0?t-s:0);if(i<n)return this.search_results.scrollTop(i)}},i.prototype.result_clear_highlight=function(){return this.result_highlight&&this.result_highlight.removeClass("highlighted"),this.result_highlight=null},i.prototype.results_show=function(){return this.is_multiple&&this.max_selected_options<=this.choices_count()?(this.form_field_jq.trigger("chosen:maxselected",{chosen:this}),!1):(this.container.addClass("chosen-with-drop"),this.results_showing=!0,this.search_field.focus(),this.search_field.val(this.search_field.val()),this.winnow_results(),this.form_field_jq.trigger("chosen:showing_dropdown",{chosen:this}))},i.prototype.update_results_content=function(e){return this.search_results.html(e)},i.prototype.results_hide=function(){return this.results_showing&&(this.result_clear_highlight(),this.container.removeClass("chosen-with-drop"),this.form_field_jq.trigger("chosen:hiding_dropdown",{chosen:this})),this.results_showing=!1},i.prototype.set_tab_index=function(e){var t;if(this.form_field.tabIndex)return t=this.form_field.tabIndex,this.form_field.tabIndex=-1,this.search_field[0].tabIndex=t},i.prototype.set_label_behavior=function(){var t=this;if(this.form_field_label=this.form_field_jq.parents("label"),!this.form_field_label.length&&this.form_field.id.length&&(this.form_field_label=e("label[for='"+this.form_field.id+"']")),this.form_field_label.length>0)return this.form_field_label.bind("click.chosen",(function(e){return t.is_multiple?t.container_mousedown(e):t.activate_field()}))},i.prototype.show_search_field_default=function(){return this.is_multiple&&this.choices_count()<1&&!this.active_field?(this.search_field.val(this.default_text),this.search_field.addClass("default")):(this.search_field.val(""),this.search_field.removeClass("default"))},i.prototype.search_results_mouseup=function(t){var i;if((i=e(t.target).hasClass("active-result")?e(t.target):e(t.target).parents(".active-result").first()).length)return this.result_highlight=i,this.result_select(t),this.search_field.focus()},i.prototype.search_results_mouseover=function(t){var i;if(i=e(t.target).hasClass("active-result")?e(t.target):e(t.target).parents(".active-result").first())return this.result_do_highlight(i)},i.prototype.search_results_mouseout=function(t){if(e(t.target).hasClass("active-result"))return this.result_clear_highlight()},i.prototype.choice_build=function(t){var i,s,r=this;return i=e("<li />",{class:"search-choice"}).html("<span>"+this.choice_label(t)+"</span>"),t.disabled?i.addClass("search-choice-disabled"):((s=e("<a />",{class:"search-choice-close","data-option-array-index":t.array_index})).bind("click.chosen",(function(e){return r.choice_destroy_link_click(e)})),i.append(s)),this.search_container.before(i)},i.prototype.choice_destroy_link_click=function(t){if(t.preventDefault(),t.stopPropagation(),!this.is_disabled)return this.choice_destroy(e(t.target))},i.prototype.choice_destroy=function(e){if(this.result_deselect(e[0].getAttribute("data-option-array-index")))return this.show_search_field_default(),this.is_multiple&&this.choices_count()>0&&this.search_field.val().length<1&&this.results_hide(),e.parents("li").first().remove(),this.search_field_scale()},i.prototype.results_reset=function(){if(this.reset_single_select_options(),this.form_field.options[0].selected=!0,this.single_set_selected_text(),this.show_search_field_default(),this.results_reset_cleanup(),this.form_field_jq.trigger("change"),this.active_field)return this.results_hide()},i.prototype.results_reset_cleanup=function(){return this.current_selectedIndex=this.form_field.selectedIndex,this.selected_item.find("abbr").remove()},i.prototype.result_select=function(e){var t,i;if(this.result_highlight)return t=this.result_highlight,this.result_clear_highlight(),this.is_multiple&&this.max_selected_options<=this.choices_count()?(this.form_field_jq.trigger("chosen:maxselected",{chosen:this}),!1):(this.is_multiple?t.removeClass("active-result"):this.reset_single_select_options(),t.addClass("result-selected"),(i=this.results_data[t[0].getAttribute("data-option-array-index")]).selected=!0,this.form_field.options[i.options_index].selected=!0,this.selected_option_count=null,this.is_multiple?this.choice_build(i):this.single_set_selected_text(this.choice_label(i)),(e.metaKey||e.ctrlKey)&&this.is_multiple||this.results_hide(),this.show_search_field_default(),(this.is_multiple||this.form_field.selectedIndex!==this.current_selectedIndex)&&this.form_field_jq.trigger("change",{selected:this.form_field.options[i.options_index].value}),this.current_selectedIndex=this.form_field.selectedIndex,e.preventDefault(),this.search_field_scale())},i.prototype.single_set_selected_text=function(e){return null==e&&(e=this.default_text),e===this.default_text?this.selected_item.addClass("chosen-default"):(this.single_deselect_control_build(),this.selected_item.removeClass("chosen-default")),this.selected_item.find("span").html(e)},i.prototype.result_deselect=function(e){var t;return t=this.results_data[e],!this.form_field.options[t.options_index].disabled&&(t.selected=!1,this.form_field.options[t.options_index].selected=!1,this.selected_option_count=null,this.result_clear_highlight(),this.results_showing&&this.winnow_results(),this.form_field_jq.trigger("change",{deselected:this.form_field.options[t.options_index].value}),this.search_field_scale(),!0)},i.prototype.single_deselect_control_build=function(){if(this.allow_single_deselect)return this.selected_item.find("abbr").length||this.selected_item.find("span").first().after('<abbr class="search-choice-close"></abbr>'),this.selected_item.addClass("chosen-single-with-deselect")},i.prototype.get_search_text=function(){return e("<div/>").text(e.trim(this.search_field.val())).html()},i.prototype.winnow_results_set_highlight=function(){var e,t;if(null!=(e=(t=this.is_multiple?[]:this.search_results.find(".result-selected.active-result")).length?t.first():this.search_results.find(".active-result").first()))return this.result_do_highlight(e)},i.prototype.no_results=function(t){var i;return(i=e('<li class="no-results">'+this.results_none_found+' "<span></span>"</li>')).find("span").first().html(t),this.search_results.append(i),this.form_field_jq.trigger("chosen:no_results",{chosen:this})},i.prototype.no_results_clear=function(){return this.search_results.find(".no-results").remove()},i.prototype.keydown_arrow=function(){var e;return this.results_showing&&this.result_highlight?(e=this.result_highlight.nextAll("li.active-result").first())?this.result_do_highlight(e):void 0:this.results_show()},i.prototype.keyup_arrow=function(){var e;return this.results_showing||this.is_multiple?this.result_highlight?(e=this.result_highlight.prevAll("li.active-result")).length?this.result_do_highlight(e.first()):(this.choices_count()>0&&this.results_hide(),this.result_clear_highlight()):void 0:this.results_show()},i.prototype.keydown_backstroke=function(){var e;return this.pending_backstroke?(this.choice_destroy(this.pending_backstroke.find("a").first()),this.clear_backstroke()):(e=this.search_container.siblings("li.search-choice").last()).length&&!e.hasClass("search-choice-disabled")?(this.pending_backstroke=e,this.single_backstroke_delete?this.keydown_backstroke():this.pending_backstroke.addClass("search-choice-focus")):void 0},i.prototype.clear_backstroke=function(){return this.pending_backstroke&&this.pending_backstroke.removeClass("search-choice-focus"),this.pending_backstroke=null},i.prototype.keydown_checker=function(e){var t,i;switch(t=null!=(i=e.which)?i:e.keyCode,this.search_field_scale(),8!==t&&this.pending_backstroke&&this.clear_backstroke(),t){case 8:this.backstroke_length=this.search_field.val().length;break;case 9:this.results_showing&&!this.is_multiple&&this.result_select(e),this.mouse_on_container=!1;break;case 13:this.results_showing&&e.preventDefault();break;case 32:this.disable_search&&e.preventDefault();break;case 38:e.preventDefault(),this.keyup_arrow();break;case 40:e.preventDefault(),this.keydown_arrow()}},i.prototype.search_field_scale=function(){var t,i,s,r,n,o,a,c;if(this.is_multiple){for(0,o=0,r="position:absolute; left: -1000px; top: -1000px; display:none;",a=0,c=(n=["font-size","font-style","font-weight","font-family","line-height","text-transform","letter-spacing"]).length;a<c;a++)r+=(s=n[a])+":"+this.search_field.css(s)+";";return(t=e("<div />",{style:r})).text(this.search_field.val()),e("body").append(t),o=t.width()+25,t.remove(),o>(i=this.container.outerWidth())-10&&(o=i-10),this.search_field.css({width:o+"px"})}},i}(t)}).call(this)}.apply(e,arguments)}))}(this),function(e){define("angular-chosen",["angular","jquery-chosen"],(function(){return function(){
/**
 * angular-chosen-localytics - Angular Chosen directive is an AngularJS Directive that brings the Chosen jQuery in a Angular way
 * @version v1.3.0
 * @link http://github.com/leocaseiro/angular-chosen
 * @license MIT
 */
(function(){var e=[].indexOf||function(e){for(var t=0,i=this.length;t<i;t++)if(t in this&&this[t]===e)return t;return-1};angular.module("localytics.directives",[]),angular.module("localytics.directives").directive("chosen",["$timeout",function(t){var i,s,r,n;return s=/^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+group\s+by\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w]*)|(?:\(\s*([\$\w][\$\w]*)\s*,\s*([\$\w][\$\w]*)\s*\)))\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?$/,i=["persistentCreateOption","createOptionText","createOption","skipNoResults","noResultsText","allowSingleDeselect","disableSearchThreshold","disableSearch","enableSplitWordSearch","inheritSelectClasses","maxSelectedOptions","placeholderTextMultiple","placeholderTextSingle","searchContains","singleBackstrokeDelete","displayDisabledOptions","displaySelectedOptions","width","includeGroupLabelInSelected","maxShownResults"],n=function(e){return e.replace(/[A-Z]/g,(function(e){return"_"+e.toLowerCase()}))},r=function(e){var t;if(angular.isArray(e))return 0===e.length;if(angular.isObject(e))for(t in e)if(e.hasOwnProperty(t))return!1;return!0},{restrict:"A",require:"?ngModel",priority:1,link:function(o,a,c,l){var d,u,h,p,m,f,_,g,v,y;if(o.disabledValuesHistory=o.disabledValuesHistory?o.disabledValuesHistory:[],(a=$(a)).addClass("localytics-chosen"),p=o.$eval(c.chosen)||{},angular.forEach(c,(function(t,s){if(e.call(i,s)>=0)return c.$observe(s,(function(e){return p[n(s)]="{{"===String(a.attr(c.$attr[s])).slice(0,2)?e:o.$eval(e),g()}))})),f=function(){return a.addClass("loading").attr("disabled",!0).trigger("chosen:updated")},_=function(){return a.removeClass("loading"),angular.isDefined(c.disabled)?a.attr("disabled",c.disabled):a.attr("disabled",!1),a.trigger("chosen:updated")},d=null,u=!1,h=function(){return d?a.trigger("chosen:updated"):(t((function(){d=a.chosen(p).data("chosen")})),angular.isObject(d)?d.default_text:void 0)},g=function(){return u?a.attr("data-placeholder",d.results_none_found).attr("disabled",!0):a.removeAttr("data-placeholder"),a.trigger("chosen:updated")},l?(m=l.$render,l.$render=function(){return m(),h()},a.on("chosen:hiding_dropdown",(function(){return o.$apply((function(){return l.$setTouched()}))})),c.multiple&&(y=function(){return l.$viewValue},o.$watch(y,l.$render,!0))):h(),c.$observe("disabled",(function(){return a.trigger("chosen:updated")})),c.ngOptions&&l)return v=c.ngOptions.match(s)[7],o.$watchCollection(v,(function(e,i){return t((function(){return angular.isUndefined(e)?f():(u=r(e),_(),g())}))})),o.$on("$destroy",(function(e){if("undefined"!=typeof timer&&null!==timer)return t.cancel(timer)}))}}}])}).call(this)}.apply(e,arguments)}))}(this),define("shared/js/email_deliverability/directives/suggestedRecordSet",["angular","lodash","cjt/directives/copyField","shared/js/email_deliverability/filters/htmlSafeString","cjt/util/locale","cjt/core","cjt/directives/callout","cjt/modules"],(function(e,t,i,s,r,n){"use strict";var o="shared/js/email_deliverability/directives/suggestedRecordSet.ptt",a=n.config.debug?n.buildFullPath(o):n.buildPath(o),c="shared.emailDeliverability.suggestedRecordSet.directive",l=[i.namespace,s.namespace],d=new RegExp("(.{1,255})","g"),u=["$scope"],h=function(e){e.domainName=e.domain.domain,e._suggestionMode=function(){e.label=r.maketext("Suggested “[_1]” ([_2]) Record",e.recordType.toUpperCase(),e.recordZoneType),e.record=e.domain.getSuggestedRecord(e.recordType),e.noRecordMessage=r.maketext("Suggested “[_1]” does not exist.",e.recordType.toUpperCase()),e.nameText=e.record.name,e.originalValueText=e.valueText=e.record.value},e._currentMode=function(){e.label=r.maketext("Current “[_1]” ([_2]) Record",e.recordType.toUpperCase(),e.recordZoneType),e.record=e.domain.getCurrentRecord(e.recordType),e.noRecordMessage=r.maketext("Current “[_1]” does not exist.",e.recordType.toUpperCase()),e.nameText=e.record.name,e.originalValueText=e.valueText=e.record.value},e._recordsReady=function(){e.domain.recordsLoaded&&(e.recordValid=e.domain.isRecordValid(e.recordType),e.recordsLoaded=!0,e.alwaysCurrent?e._currentMode():e.alwaysSuggested?e._suggestionMode():e.recordValid?e._currentMode():e._suggestionMode(),0===Object.keys(e.record).length&&(e.record=!1))},e._checkRecordsReady=function(){return e.domain.recordsLoaded},e.splitMode="full",e.toggleSplitMode=function(){if(e.splitMode="full"===e.splitMode?"split":"full","split"===e.splitMode){if(!e.splitText){var i=e.originalValueText.match(d);e.splitText=t.join(t.map(i,(function(e){return'"'+e+'"'}))," ")}e.valueText=e.splitText}else e.valueText=e.originalValueText},e.$watch(e._checkRecordsReady,e._recordsReady),e.label=r.maketext("Loading “[_1]” Record",e.recordType.toUpperCase())},p=e.module(c,l),m=function(e,i,s){!1===t.isUndefined(s.hideExtras)&&(e.hideExtras=!0),!1===t.isUndefined(s.alwaysSuggested)&&(e.alwaysSuggested=!0),!1===t.isUndefined(s.alwaysCurrent)&&(e.alwaysCurrent=!0)};return p.directive("suggestedRecordSet",(function(){return{templateUrl:a,scope:{parentID:"@id",domain:"=",recordType:"@",recordZoneType:"@",splitable:"="},restrict:"E",replace:!0,transclude:!0,link:m,controller:u.concat(h)}})),{class:h,namespace:c,template:a}})),define("shared/js/email_deliverability/views/manageDomain",["angular","lodash","cjt/core","cjt/util/locale","cjt/util/inet6","shared/js/email_deliverability/services/domains","cjt/directives/copyField","shared/js/email_deliverability/directives/suggestedRecordSet","cjt/modules","cjt/directives/callout","cjt/directives/actionButtonDirective"],(function(e,t,i,s,r,n,o,a){"use strict";var c="shared.emailDeliverability.views.manageDomain",l=[n.namespace,o.namespace,a.namespace],d=["$scope","$location","$routeParams","DomainsService","alertService","ADD_RESOURCE_PANEL","PAGE"];var u=function(n,o,a,c,l,d,u){return n.canReturnToLister=!u.CAN_SKIP_LISTER||c.getAll().length>1,n._returnToLister=function(){o.path("/").search("")},n.init=function(){var t=c.getAll();if(n.currentDomain=c.findDomainByName(a.domain),n.skipPTRLookups=void 0!==u.skipPTRLookups&&u.skipPTRLookups,!n.currentDomain&&t.length>1)return l.add({message:s.maketext("You did not specify a domain to manage."),type:"info"}),void n._returnToLister();1===t.length&&(n.currentDomain=t[0]),e.extend(n,{isWhm:i.isWhm(),confirmDKIMDownloadRequest:!1,showConfirmDKIM:!1,dkimPrivateKey:!1,ptrServerName:"",resourcesPanelTemplate:d,isRecordValid:n.currentDomain.isRecordValid.bind(n.currentDomain),getSuggestedRecord:n.currentDomain.getSuggestedRecord.bind(n.currentDomain),errors:{}});var r=c.validateAllRecords([n.currentDomain]).then(n._handleRecordErrors);return n.skipPTRLookups||r.then(n._populatePTRInfo).then(n._handlePTRStatus),r},n._populatePTRInfo=function(){var e=n.currentDomain.getRecordDetails("ptr"),t=n.currentDomain.getSuggestedRecord("ptr");t.value=e.helo+".",n.currentDomain.setSuggestedRecord("ptr",t),n.ptrServerName=e.helo,n.ptrServerIP=e.ip_address},n.hasNSAuthority=function(){return n.currentDomain.hasNSAuthority},n.badConfigurationMessage=function(e){return n.currentDomain.getRecords([e]).length?s.maketext("“[_1]” is [output,strong,not] properly configured for this domain.",e.toUpperCase()):s.maketext("A “[_1]” record does [output,strong,not] exist for this domain.",e.toUpperCase())},n.noAuthorityMessage=function(e){return c.getNoAuthorityMessage(n.currentDomain,e)},n.validRecordMessage=function(e){return s.maketext("“[_1]” is properly configured for this domain.",e.toUpperCase())},n.repairRecord=function(e){var t=n.getSuggestedRecord(e),i=c.repairDomain(n.currentDomain,[e],[t.value]);return n.currentDomain.hasNSAuthority||i.then(c.validateAllRecords([n.currentDomain])),n.skipPTRLookups||i.then(n._populatePTRInfo),i.finally((function(){n.currentDomain.hasNSAuthority||c.unreflectedChangeMessage(n.currentDomain.domain),n.showConfirmDKIM=!1})),i},n.toggleShowConfirmDKIM=function(){n.showConfirmDKIM=!n.showConfirmDKIM},n.getCurrentRecord=function(e){return c.getCurrentRecord(n.currentDomain,e)},n._handleRecordErrors=function(){var e=n.currentDomain.getRecordDetails();Object.keys(e).forEach((function(t){var i=e[t];i.error&&(n.errors[t]=function(e,t,i){return s.maketext("The system failed to complete validation of “[_1]”’s “[_2]” because of an error: [_3]",e,t,i)}(n.currentDomain.domain,t.toUpperCase(),i.error))}))},n._handlePTRStatus=function(){var e=n.currentDomain.getRecordDetails("ptr"),o=e.state,a=e.ptr_records,c=e.ip_address,l=e.helo,d=e.arpa_domain;if(n.ptrStatusCode=o,"IP_IS_PRIVATE"===o)n.ipIsPrivate=!0;else{var u=n.getSuggestedRecord("ptr").name;u=u.replace(/\.$/,""),n.ptrRecordName=t.escape(u);var h=e.nameservers.map(t.escape)||[];if(h.sort(),"MISSING_PTR"===o&&(n.badPTRMessages=[s.maketext("There is no reverse [asis,DNS] configured for the [asis,IP] address ([_1]) that the system uses to send this domain’s outgoing email.",c)],i.isWhm()?h.length?n.ptrToFixMessage=s.maketext("To fix this problem, create the following [asis,PTR] record at [list_and_quoted,_1]:",h):n.ptrToFixMessage=s.maketext("To fix this problem, create the following [asis,PTR] record in [asis,DNS]:"):h.length?n.ptrToFixMessage=s.maketext("To fix this problem, contact your system administrator and request that they create the following [asis,PTR] record at [list_and_quoted,_1]:",h):n.ptrToFixMessage=s.maketext("To fix this problem, contact your system administrator and request that they create the following [asis,PTR] record in [asis,DNS]:")),"HELO_MISMATCH"===o){var p=a.filter((function(e){return e.domain!==l})).map((function(e){return e.domain})),m=s.maketext("The system sends “[_1]”’s outgoing email from the “[_2]” [output,abbr,IP,Internet Protocol] address.",n.currentDomain.domain,c);n.badPTRMessages=[m+" "+s.maketext("The only [asis,PTR] value for this [output,abbr,IP,Internet Protocol] address must be “[_1]”. This is the name that this server sends with [output,abbr,SMTP,Simple Mail Transfer Protocol]’s “[_2]” command to send “[_3]”’s outgoing email.",l,"HELO",n.currentDomain.domain),s.maketext("[numf,_1] unexpected [asis,PTR] [numerate,_1,value exists,values exist] for this [output,abbr,IP,Internet Protocol] address:",p.length)],n.badPTRNames=p,i.isWhm()?h.length?n.ptrToFixMessage=s.maketext("To fix this problem, replace all [asis,PTR] records for “[_1]” with the following record at [list_and_quoted,_2]:",d,h):n.ptrToFixMessage=s.maketext("To fix this problem, replace all [asis,PTR] records for “[_1]” with the following record:",d):h.length?n.ptrToFixMessage=s.maketext("To fix this problem, contact your system administrator and request that they replace all [asis,PTR] records for “[_1]” with the following record at [list_and_quoted,_2]:",d,h):n.ptrToFixMessage=s.maketext("To fix this problem, contact your system administrator and request that they replace all [asis,PTR] records for “[_1]” with the following record:",d)}if("PTR_MISMATCH"===o){var f=a[0].forward_records,_=s.maketext("The system sends the domain “[_1]” in the [output,abbr,SMTP,Simple Mail Transfer Protocol] handshake for this domain’s email.",l);f.length?_+=" "+s.maketext("“[_1]” resolves to [list_and_quoted,_2], not “[_3]”.",l,f,c):_+=" "+s.maketext("“[_1]” does not resolve to any [output,abbr,IP,Internet Protocol] addresses.",l),n.badPTRMessages=[_];var g=r.isValid(c)?"AAAA":"A";i.isWhm()?n.ptrToFixMessage=s.maketext("To fix this problem, create a [output,abbr,DNS,Domain Name System] “[_1]” record for “[_2]” whose value is “[_3]”.",g,l,c):n.ptrToFixMessage=s.maketext("To fix this problem, contact your system administrator and request that they create a [output,abbr,DNS,Domain Name System] “[_1]” record for “[_2]” whose value is “[_3]”.",g,l,c)}}},n.localDKIMExists=function(){return c.localDKIMExists(n.currentDomain)},n.ensureLocalDKIMKeyExists=function(){return c.ensureLocalDKIMKeyExists(n.currentDomain).then(n._handleRecordErrors)},n.init()};return d.push(u),e.module(c,l).controller("ManageDomainController",d),{class:u,namespace:c}})),define("shared/js/email_deliverability/views/manageDomainSPF",["angular","lodash","cjt/util/locale","shared/js/email_deliverability/services/domains","shared/js/email_deliverability/services/spfParser","shared/js/email_deliverability/services/SPFRecordProcessor","cjt/directives/copyField","cjt/modules","cjt/services/cpanel/componentSettingSaverService","cjt/directives/callout","cjt/directives/multiFieldEditorItem","cjt/directives/multiFieldEditor","cjt/directives/actionButtonDirective","cjt/validator/ip-validators","cjt/validator/domain-validators"],(function(e,t,i,s,r,n,o){"use strict";var a="shared.emailDeliverability.views.manageDomainSPF",c=[s.namespace,o.namespace],l="ManageDomainSPFController",d=["$scope","$log","$location","$routeParams","DomainsService","alertService","componentSettingSaverService","ADD_RESOURCE_PANEL"],u=function(s,o,a,c,d,u,h,p){var m=["additionalHosts","additionalMXServers","additionalIPv4Addresses","additionalIPv6Addresses","additionalINCLUDEItems"];return s._updateSuggestedRecords=function(){s.suggestedRecord=s.currentDomain.getSuggestedRecord("spf");var e=(s.suggestedRecord.originalExpected||"").trim().split(/\s+/);s.missingMechanisms=e.map(n._parseSPFTerm).filter((function(e){return!!e.type})),s.workingRecord=s.suggestedRecord,s.populateFormFrom(s.workingRecord),s.updatePreview()},s.init=function(){var e=d.getAll();return!s.currentDomain&&e.length>1?(u.add({message:i.maketext("You did not specify a domain to manage."),type:"danger"}),void a.path("/").search("")):(1===e.length&&(s.currentDomain=e[0]),h.get(l).then((function(e){void 0!==e&&e&&(s.showAllHelp=e.showAllHelp)})),h.register(l),s.$on("$destroy",(function(){h.unregister(l)})),m.forEach((function(e){s.$watchCollection(e,s.updatePreview.bind(s))})),d.validateAllRecords([s.currentDomain]).then(s._updateSuggestedRecords).then((function(){s._hasNSAuthority=s.currentDomain.hasNSAuthority})))},s.parseRecord=function(e){e&&(e.value&&r.parse(e.value).mechanisms.forEach((function(e){if("all"===e.type||e.value)return-1===["version","all"].indexOf(e.type)&&"+"!==e.prefix?(o.debug("Non-pass mechanism exists. Presenting warning.",e),void(s.nonPassPrefixesExist=!0)):void("mx"===e.type?s.additionalMXServers.push(e.value):"ip4"===e.type?s.additionalIPv4Addresses.push(e.value):"ip6"===e.type?s.additionalIPv6Addresses.push(e.value):"all"===e.type&&"-"===e.prefix?s.excludeAllOtherDomains=!0:"a"===e.type?s.additionalHosts.push(e.value):"include"===e.type&&s.additionalINCLUDEItems.push(e.value))})))},s.removeDuplicates=function(){m.forEach((function(e){var i=s[e].slice(0),r=t.uniq(i);s[e].splice(0,s[e].length),r.forEach(s[e].push)}))},s.populateFormFrom=function(e){m.forEach((function(e){s[e].splice(0,s[e].length)})),s.parseRecord(e)},s.toggleExcludeAllOtherDomains=function(){s.excludeAllOtherDomains=!s.excludeAllOtherDomains,s.updatePreview()},s.updatePreview=function(){var e=["v=spf1","+mx","+a"];if(s.missingMechanisms){s.additionalHosts.forEach((function(t){e.push("+a:"+t)})),s.additionalMXServers.forEach((function(t){e.push("+mx:"+t)})),s.additionalIPv4Addresses.forEach((function(t){e.push("+ip4:"+t)})),s.additionalIPv6Addresses.forEach((function(t){e.push("+ip6:"+t)})),s.additionalINCLUDEItems.forEach((function(t){e.push("+include:"+t)}));var t=s.currentDomain.getCurrentRecord("spf");t&&t.value&&r.parse(t.value).mechanisms.forEach((function(t){-1===["version","all"].indexOf(t.type)&&"+"!==t.prefix&&e.push(t.prefix+t.type+":"+t.value)})),s.excludeAllOtherDomains?e.push("-all"):e.push("~all");var i=e.join(" ");s.workingRecord=n.combineRecords(i,s.missingMechanisms)}},s.hasNSAuthority=function(){return s._hasNSAuthority},s.badConfigurationMessage=function(e){return i.maketext("“[_1]” is [output,strong,not] properly configured for this domain.",e.toUpperCase())},s.noAuthorityMessage=function(e){return d.getNoAuthorityMessage(s.currentDomain,e)},s.toggleHelp=function(){s.showAllHelp=!s.showAllHelp,s.saveToComponentSettings()},s.saveToComponentSettings=function(){h.set(l,{showAllHelp:s.showAllHelp})},s.update=function(){return d.repairDomain(s.currentDomain,["spf"],[s.workingRecord],!s.hasNSAuthority()).then((function(){if(!s.hasNSAuthority())return d.validateAllRecords([s.currentDomain]).then(s._updateSuggestedRecords)})).finally((function(){s.hasNSAuthority()||d.unreflectedChangeMessage(s.currentDomain.domain),s.showConfirmDKIM=!1}))},s.currentDomain=d.findDomainByName(c.domain),e.extend(s,{getCurrentRecord:s.currentDomain.getCurrentRecord.bind(s.currentDomain),resourcesPanelTemplate:p,showAllHelp:!1,currentRecord:"",workingRecord:"",excludeAllOtherDomains:!1,additionalHosts:[],additionalMXServers:[],additionalIPv4Addresses:[],additionalIPv6Addresses:[],additionalINCLUDEItems:[]}),s.init()};return d.push(u),e.module(a,c).controller(l,d),{class:u,namespace:a}})),define("shared/js/email_deliverability/views/manageDomainDKIM",["angular","lodash","cjt/util/locale","shared/js/email_deliverability/services/domains","cjt/directives/copyField","cjt/modules","cjt/services/cpanel/componentSettingSaverService","cjt/directives/callout","cjt/directives/multiFieldEditorItem","cjt/directives/multiFieldEditor","cjt/directives/actionButtonDirective"],(function(e,t,i,s,r){"use strict";var n="shared.emailDeliverability.views.manageDomainDKIM",o=[s.namespace,r.namespace],a="ManageDomainDKIMController",c=["$scope","$location","$routeParams","DomainsService","alertService","componentSettingSaverService","ADD_RESOURCE_PANEL"],l=function(t,s,r,n,o,c,l){t.getWorkingRecords=function(){t.suggestedRecord=t.currentDomain.getSuggestedRecord("spf"),t.workingRecord=t.suggestedRecord;var e=t.currentDomain.getRecords(["dkim"]);t.currentRecord=e[0]?e[0].current:""},t.init=function(){var e=n.getAll();if(!t.currentDomain&&e.length>1)return o.add({message:i.maketext("You did not specify a domain to manage."),type:"danger"}),void s.path("/").search("");1===e.length&&(t.currentDomain=e[0]),t.getWorkingRecords(),t.suggestedRecord||n.validateAllRecords([t.currentDomain]).then(t.getWorkingRecords),c.get(a).then((function(e){void 0!==e&&e&&(t.showAllHelp=e.showAllHelp)})),c.register(a),t.$on("$destroy",(function(){c.unregister(a)}))},t.toggleHelp=function(){t.showAllHelp=!t.showAllHelp,t.$broadcast("showHideAllChange",t.showAllHelp)},t.saveToComponentSettings=function(){c.set(a,{showAllHelp:t.showAllHelp})},t.hasNSAuthority=function(){return t.currentDomain.hasNSAuthority},t.requestConfirmDownloadDKIMKey=function(){t.confirmDKIMDownloadRequest=!0},t._getPrivateDKIMKeyLoaded=function(e){t.dkimPrivateKey=e.pem},t.confirmRevealDKIMKey=function(){return n.fetchPrivateDKIMKey(t.currentDomain).then(t._getPrivateDKIMKeyLoaded).finally(t.cancelRevealDKIMKey)},t.cancelRevealDKIMKey=function(){t.confirmDKIMDownloadRequest=!1},e.extend(t,{currentDomain:n.findDomainByName(r.domain),resourcesPanelTemplate:l,showAllHelp:!1,currentRecord:"",workingRecord:""}),t.init()};return c.push(l),e.module(n,o).controller(a,c),{class:l,namespace:n}})),define("shared/js/email_deliverability/directives/recordStatus",["angular","cjt/util/locale","cjt/core"],(function(e,t,i){"use strict";var s="shared/js/email_deliverability/directives/recordStatus.phtml",r=i.config.debug?i.buildFullPath(s):i.buildPath(s),n="cpanel.emailDeliverabilitty.recordStatus.directive",o=["$scope"],a=function(i){i._getStatusIconClass=function(e,t){return t?"fa-times text-danger":e?"fa-check text-success":"fa-exclamation-triangle text-warning"},i._getStatusDescription=function(e,i){return i?t.maketext("One or more [asis,DNS] errors occurred while validating this domain."):e?t.maketext("No problems exist on this domain."):t.maketext("One or more problems exist on this domain.")},i._getStatusLabel=function(e,i){return i?t.maketext("[asis,DNS] Errors Occurred"):e?t.maketext("Valid"):t.maketext("Problems Exist")},i._updateStatus=function(){if(i.domain&&i.domain.recordsLoaded){var t=i.records.some((function(e){return!i.domain.isRecordValid(e)})),s=i.records.some((function(e){return i.domain.recordHadNSError(e)})),r=!t;e.extend(i,{statusIconClass:i._getStatusIconClass(r,s),statusLabel:i._getStatusLabel(r,s),statusDescription:i._getStatusDescription(r,s),recordLoading:!1})}else i.recordLoading=!0},i.getLoadingMessage=function(){return i.domain?i.domain.reloadingIn?t.maketext("Rechecking the server records in [quant,_1,second,seconds] …",i.domain.reloadingIn):t.maketext("Loading …"):""};var s=i.$watch((function(){return!!i.domain&&i.domain.recordsLoaded}),i._updateStatus);i.domain&&i._updateStatus(),i.$on("$destroy",(function(){s()}))},c=e.module(n,[]),l=function(e,t,i){e.recordLoading=!0};return c.directive("recordStatus",(function(){return{templateUrl:r,scope:{parentID:"@id",records:"=",domain:"="},restrict:"EA",replace:!1,link:l,controller:o.concat(a)}})),{class:a,namespace:n,link:l,template:r}})),define("shared/js/email_deliverability/directives/edDomainListerViewDirective",["angular","lodash","cjt/core","cjt/util/locale","shared/js/email_deliverability/directives/recordStatus","shared/js/email_deliverability/filters/htmlSafeString","shared/js/email_deliverability/services/domains"],(function(e,t,i,s,r,n,o){"use strict";var a="cpanel.emailDeliverabilitty.domainListerView.directive",c=[r.namespace,o.namespace,n.namespace],l="shared/js/email_deliverability/directives/edDomainListerViewDirective.ptt",d=i.config.debug?i.buildFullPath(l):i.buildPath(l),u=["$scope","DomainsService","ITEM_LISTER_CONSTANTS","DOMAIN_TYPE_CONSTANTS","PAGE"],h=function(e,i,r,n,o){function a(e){var t=i.getDomainZoneObject(e);return t&&t.getLockDomain()}e.DOMAIN_TYPE_CONSTANTS=n,e.EMAIL_ACCOUNTS_APP_EXISTS=o.EMAIL_ACCOUNTS_APP_EXISTS,e.webserverRoleAvailable=o.hasWebServerRole,e.recordsToCheck=i.getSupportedRecordTypes(),e._confirmingRepairDomains={},e.getDomains=function(){return e.domains},e.escapeString=t.escape,e.getDomainRowClasses=function(e){if(e.recordsLoaded)if(e.hadAnyNSErrors)e._rowClasses="danger";else{if(e.recordsValid)return!1;e._rowClasses="warning"}return e._rowClasses},e.showRecordsFilteredMessage=function(e){if(!e.recordsLoaded)return!1;if(!e.recordsValid)return!1;var t=e.getRecordTypesLoaded(),s=i.getSupportedRecordTypes();return t.length!==s.length},e.confirmRepair=function(t){e._confirmingRepairDomains[t.domain]=!0},e.cancelConfirmRepair=function(t){e._confirmingRepairDomains[t.domain]=!1},e.isConfirmingRepair=function(t){return e._confirmingRepairDomains[t.domain]},e.getDomainLockedMessage=function(e){return e.recordsLoaded&&!e.hasNSAuthority?e.nameservers.length?s.maketext("This system does not control [asis,DNS] for the “[_1]” domain. Contact the person responsible for the [list_and_quoted,_3] [numerate,_2,nameserver,nameservers] and request that they update the records.",e.domain,e.nameservers.length,e.nameservers):s.maketext("This system does not control [asis,DNS] for the “[_1]” domain, and the system did not find any authoritative nameservers for this domain. Contact your domain registrar to verify this domain’s registration.",e.domain):!(e.recordsLoadingIn||!a(e))&&s.maketext("You cannot modify this domain while a domain on the “[_1]” zone is updating.",e.zone)},e.whyCannotAutoRepairDomain=function(e){var t;if(e.recordsLoaded)if(e.hasNSAuthority){var i=a(e);i?t=s.maketext("Automatic repair is currently unavailable for this domain. You must wait until “[_1]”’s operation completes because these two domains share the same DNS zone.",i):e.isRecordValid("spf")&&e.isRecordValid("dkim")&&(t=s.maketext("This domain’s DKIM and SPF configurations are valid."))}else t=s.maketext("Automatic repair is not available for this domain because this system is not authoritative for this domain.");else t=s.maketext("Loading …");return t},e.actionButtonClicked=function(t,i){return e.$emit(r.TABLE_ITEM_BUTTON_EVENT,{actionType:t,item:i,interactionID:i.domain})};var c=["dkim","spf","ptr"];function l(e){return 0!==e.length&&(e.sort((function(e,t){return(e=c.indexOf(e))<(t=c.indexOf(t))?-1:e>t?1:0})),e=e.map((function(e){return"PTR"===(e=e.toUpperCase())?s.maketext("Reverse [asis,DNS]"):e.toUpperCase()})),s.list_and(e))}e.getRecordTypesWithIssues=function(e){return l(e.getRecordTypesWithIssues())},e.getRecordTypesWithNSErrors=function(e){return l(e.getRecordTypesWithNSErrors())},e.localDKIMExists=function(e){return i.localDKIMExists(e)},e.ensureLocalDKIMKeyExists=function(e){return i.ensureLocalDKIMKeyExists(e)}},p=e.module(a,c);p.value("PAGE",PAGE);var m=function(e,t,i,s){e.domains=[],e.headerItems=s.getHeaderItems(),e.updateView=function(t){e.domains=t},s.registerViewCallback(e.updateView.bind(e)),e.$on("$destroy",(function(){s.deregisterViewCallback(e.updateView)}))};return p.directive("domainListerView",(function(){return{templateUrl:d,restrict:"EA",replace:!0,require:"^itemLister",link:m,controller:u.concat(h)}})),{class:h,namespace:a,link:m,template:d}})),define("shared/js/email_deliverability/directives/tableShowingDirective",["angular","cjt/util/locale","cjt/core"],(function(e,t,i){"use strict";var s="shared/js/email_deliverability/directives/tableShowingDirective.phtml",r=i.config.debug?i.buildFullPath(s):i.buildPath(s),n="shared.emailDeliverability.tableShowing.directive",o=e.module(n,[]),a=function(e){e.getShowingText=function(){return t.maketext("[_1] - [_2] of [_3]",e.start,e.limit,e.total)}};return o.directive("tableShowing",(function(){return{templateUrl:r,restrict:"EA",scope:{start:"=",limit:"=",total:"="},transclude:!0,controller:["$scope",a]}})),{class:a,namespace:n,template:r}})),define("shared/js/email_deliverability/directives/itemLister",["angular","lodash","cjt/core","shared/js/email_deliverability/directives/tableShowingDirective","ngSanitize","ngRoute","cjt/modules","cjt/directives/pageSizeButtonDirective","cjt/services/cpanel/componentSettingSaverService","cjt/directives/toggleSortDirective","cjt/directives/searchDirective","cjt/directives/pageSizeDirective","cjt/filters/startFromFilter","cjt/decorators/paginationDecorator"],(function(e,t,i,s){"use strict";var r=[s.namespace,"ngRoute","ngSanitize","cjt2.filters.startFrom"],n="shared.emailDeliverability.itemLister.directive",o="domainsItemLister",a=["$routeParams","$scope","$filter","$log","$window","componentSettingSaverService","ITEM_LISTER_CONSTANTS"],c=function(i,s,r,n,a,c,l){s.viewCallbacks=[];var d={filter:r("filter"),orderBy:r("orderBy"),startFrom:r("startFrom"),limitTo:r("limitTo")};s._filter=function(e){return""!==s.filterValue?d.filter(e,{domain:s.filterValue},!1):e},s._sort=function(e){return""!==s.sort.sortDirection&&""!==s.sort.sortBy?d.orderBy(e,s.sort.sortBy,"asc"!==s.sort.sortDirection):e},s._paginate=function(e){if(s.totalItems>t.min(s.pageSizes)){var i=(s.currentPage-1)*s.pageSize,r=s.pageSize;e=d.startFrom(e,i),e=d.limitTo(e,r),s.showPager=!0,s.start=i+1,s.limit=i+e.length}else s.showPager=!1,0===e.length?s.start=0:s.start=1,s.limit=e.length;return e},s._updatedListerState=function(e){if(!s.loadingInitialState){var t={totalItems:s.totalItems,currentPage:s.currentPage,pageSize:s.pageSize,start:s.start,limit:s.limit,lastInteractedItem:e,filterValue:s.filterValue,sort:{sortDirection:s.sort.sortDirection,sortBy:s.sort.sortBy}};c.set(o,t)}},s._itemInteracted=function(e,t){t.interactionID&&s._updatedListerState(t.interactionID)},this.registerViewCallback=function(e){s.viewCallbacks.push(e),e(s.filteredItems)},this.getHeaderItems=function(){return s.headerItems},this.deregisterViewCallback=function(e){for(var t=s.viewCallbacks.length-1;t>=0;t--)s.viewCallbacks[t]===e&&s.viewCallbacks.splice(t,1)},s.fetch=function(){var t=[];return t=s._filter(s.items)||[],s.totalItems=t.length,t=s._sort(t),t=s._paginate(t),s.filteredItems=t,s._updatedListerState(),e.forEach(s.viewCallbacks,(function(e){e(s.filteredItems)})),s.$emit(l.ITEM_LISTER_UPDATED_EVENT,{meta:{filterValue:s.filterValue},items:t}),t},s.focusSearch=function(){e.element(document).find("#"+s.parentID+"_search_input").focus(),a.scrollTop=0},s.tableConfigurationClicked=function(e){s.$emit(l.TABLE_ITEM_BUTTON_EVENT,{actionType:"tableConfigurationClicked",config:e})},s.$on(l.TABLE_ITEM_BUTTON_EVENT,s._itemInteracted),e.extend(s,{maxPages:5,totalItems:(s.items||[]).length,filteredItems:[],currentPage:1,pageSize:20,pageSizes:[10,20,50],start:0,limit:20,filterValue:"",sort:{sortDirection:"asc",sortBy:(s.headerItems||[]).length?s.headerItems[0].field:""}},{filterValue:i.q}),s._savedStateLoaded=function(t){e.extend(s,t,{filterValue:i.q})};var u=c.register(o);u&&(s.loadingInitialState=!0,u.then(s._savedStateLoaded,n.error).finally((function(){s.loadingInitialState=!1,s.fetch()}))),s.$on("$destroy",(function(){c.unregister(o)})),s.fetch(),s.$watch("items",s.fetch)},l="shared/js/email_deliverability/directives/itemLister.ptt",d=i.config.debug?i.buildFullPath(l):i.buildPath(l),u=function(t,i){t.controlsBlock=null,t.contentBlock=null,t._attachControls=function(e){t.controlsBlock.append(e)},t._attachOthers=function(e){e.setAttribute("id",t.parentID+"_transcludePoint"),e.setAttribute("ng-if","filteredItems.length"),t.contentBlock.replaceWith(e)},t._attachTransclude=function(i){e.element(i).hasClass("lister-controls")?t._attachControls(i):t._attachOthers(i)},t._findTranscludes=function(){t.controlsBlock=i.find("#"+t.parentID+"_transcludedControls"),t.contentBlock=i.find("#"+t.parentID+"_transcludePoint");var s=i.find("div.transcluded"),r=s.children();e.forEach(r,t._attachTransclude,t),s.remove()},setTimeout(t._findTranscludes,2)};return e.module(n,r).directive("itemLister",["$window","$log","componentSettingSaverService"].concat((function(e,t,i){return{templateUrl:d,restrict:"EA",scope:{parentID:"@id",items:"=",headerItems:"=",tableConfigurations:"="},transclude:!0,replace:!0,link:u,controller:a.concat(c)}}))),{class:c,namespace:n,link:u,template:d}})),define("shared/js/email_deliverability/views/listDomains",["angular","lodash","cjt/util/locale","shared/js/email_deliverability/directives/edDomainListerViewDirective","shared/js/email_deliverability/directives/tableShowingDirective","shared/js/email_deliverability/directives/itemLister","shared/js/email_deliverability/services/domains","cjt/modules"],(function(e,t,i,s,r,n,o){"use strict";var a=function(){this.field="",this.label="",this.sortable=!1};function c(e,t,i,s,r){var n=new a;return n.field=e,n.label=s?i+" <span class='thead-desc'>"+s+"</span>":i,n.sortable=t,n.hiddenOnMobile=r,n}var l="shared.emailDeliverability.views.listDomains",d=[r.namespace,n.namespace,s.namespace,o.namespace],u=["$scope","$timeout","$location","$log","$q","alertService","DomainsService","initialDomains","ITEM_LISTER_CONSTANTS","PAGE"],h=function(e,t,s,r,n,o,a,l,d,u){e.itemChangeRequested=function(t,i){switch(i.actionType){case"manage":e.manageDomain(i.item.domain);break;case"repair":e.repairDomain(i.item.domain);break;case"repairAll":e.repairAllDomainRecords(i.domain)}},e.manageDomain=function(e){a.markViewLoad(),s.path("manage").search("domain",e)},e.getSuggestedRecord=function(e,t){return e.getSuggestedRecord(t)},e.repairDomain=function(t){var i=a.findDomainByName(t);o.clear();var s=e.getDisplayedRecordTypes(),r=(s=s.filter((function(e){return"ptr"!==e&&!i.isRecordValid(e)}))).map((function(t){return e.getSuggestedRecord(i,t).value}));return a.repairDomain(t,s,r)},e.getDisplayedRecordTypes=function(){return a.getSupportedRecordTypes()},e._fetchTableData=function(t){var i=e.getDisplayedRecordTypes();return a.validateAllRecords(t,i)},e._beginDelayedFetch=function(){e.currentTimeout&&(t.cancel(e.currentTimeout),e.currentTimeout=null),e.currentTimeout=t(e._fetchTableData,500,!0,e.pageDomains)},e._itemListerUpdated=function(t,i){e.itemListerMeta=i.meta,e.currentSearchFilterValue=e.itemListerMeta.filterValue,e.pageDomains=i.items,e._beginDelayedFetch()},e._buildTableHeaders=function(){var e=[];return e.push(c("domain",!0,i.maketext("Domain"),!1,!1)),e.push(c("status",!1,i.maketext("Email Deliverability Status"),!1,!0)),e.push(c("actions",!1,"",!1)),e},e.getFilteredDomains=function(){return e.filteredDomains},e._readyToDisplay=function(){e.$on(d.TABLE_ITEM_BUTTON_EVENT,e.itemChangeRequested),e.$on(d.ITEM_LISTER_UPDATED_EVENT,e._itemListerUpdated)},e.init=function(){1===l.length&&u.CAN_SKIP_LISTER?s.path("/manage").search("domain",l[0].domain):(e.domains=l,e.filteredDomains=l,e.tableHeaderItems=e._buildTableHeaders(),e._readyToDisplay())},e.init()};return u.push(h),e.module(l,d).controller("ListDomainsController",u),{class:h,namespace:l}})),define("app/index",["angular","lodash","cjt/core","app/controllers/ROUTES","app/controllers/route","shared/js/email_deliverability/services/domains","shared/js/email_deliverability/filters/htmlSafeString","app/decorators/paginationDecorator","cjt/io/uapi-request","ngRoute","ngAnimate","angular-chosen","cjt/modules","cjt/io/uapi","cjt/directives/breadcrumbs","cjt/services/alertService","cjt/directives/loadingPanel","shared/js/email_deliverability/views/manageDomain","shared/js/email_deliverability/views/manageDomainSPF","shared/js/email_deliverability/views/manageDomainDKIM","shared/js/email_deliverability/views/listDomains"],(function(e,t,i,s,r,n,o,a,c){"use strict";return function(){var t="cpanel.emailDeliverability",i=["ngRoute","ngAnimate","cjt2.cpanel","cjt2.directives.loadingPanel","cjt2.services.alert",n.namespace,o.namespace,r.namespace,a.namespace],l=["cjt/bootstrap"];return s.forEach((function(e){i.push("shared.emailDeliverability.views."+e.controllerAs),l.push("shared/js/email_deliverability/views/"+e.controllerAs)})),e.module(t,i),require(l,(function(i){var r=e.module(t);r.value("PAGE",PAGE),r.value("ADD_RESOURCE_PANEL","views/additionalResourcesPanel.ptt"),r.factory("APIInitializer",(function(){return new function(){this.init=function(e,t){return(new c.Class).initialize(e,t)}.bind(this),this.buildBatchCommandItem=function(e,t,i){return JSON.stringify([e,t,i])}.bind(this)}})),r.value("ITEM_LISTER_CONSTANTS",{TABLE_ITEM_BUTTON_EVENT:"TableItemActionButtonEmitted",ITEM_LISTER_UPDATED_EVENT:"ItemListerUpdatedEvent"}),r.value("RECORD_STATUS_CONSTANTS",{VALID:"validRecordStatus",OUT_OF_SYNC:"outOfSyncRecordStatus",MISSING:"missingRecordStatus",TOO_MANY:"tooManyRecordStatus",LOADING:null}),r.config(["$routeProvider","$animateProvider",function(e,t){t.classNameFilter(/^((?!no-animate).)*$/),s.forEach((function(t){e.when(t.route,t)})),e.otherwise({redirectTo:"/"})}]),i("#content",t)}))}}));