/* ***** BEGIN LICENSE BLOCK *****

# cpanel12 - xmlapi.js                       Copyright(c) 1997-2020 cPanel, L.L.C.
#                                                           All rights reserved.
# copyright@cpanel.net                                         http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited

 * ***** END LICENSE BLOCK *****
  * ***** BEGIN APPLICABLE CODE BLOCK ***** */
var use_fast_proto = 1;

function cpanel_api1() {
    var argv = cpanel_api1.arguments;
    var mycallback = argv[0];
    var module = argv[1];
    var func = argv[2];
    var argc = argv.length;

    var callback = {
        success: cpanel_api1_parser,
        argument: mycallback
    };

    var sFormData;
    if (use_fast_proto) {
        sFormData = "cpanel_xmlapi_module=" + encodeURIComponent(module) + "&cpanel_xmlapi_func=" + encodeURIComponent(func) + "&cpanel_xmlapi_apiversion=1";
        var argnum = 0;
        for (var i = 3; i < argc; i++) {
            sFormData += "&arg-" + argnum + "=" + encodeURIComponent(argv[i]);
            argnum++;
        }
    } else {
        sFormData = "xmlin=<cpanelaction><apiversion>1</apiversion><module>" + module + "</module><func>" + func + "</func>";
        for (var i = 3; i < argc; i++) {
            sFormData += "<args>" + argv[i] + "</args>";
        }
        sFormData += "</cpanelaction>";
    }
    if (sFormData.length < 2000) {
        YAHOO.util.Connect.asyncRequest("GET", CPANEL.security_token + "/xml-api/cpanel?" + sFormData, callback);
    } else {
        YAHOO.util.Connect.asyncRequest("POST", CPANEL.security_token + "/xml-api/cpanel", callback, sFormData);
    }
}

function cpanel_api1_parser(o) {
    var mycallback = o.argument;
    var rootNode = o.responseXML;
    var cpanelresultEl = rootNode.getElementsByTagName("cpanelresult")[0];
    var cpaneldataEl = cpanelresultEl.getElementsByTagName("data")[0];
    var dataresultEl = cpaneldataEl.getElementsByTagName("result")[0];

    var parsed_data;
    if (dataresultEl.firstChild) {
        parsed_data = dataresultEl.firstChild.nodeValue;
    }
    if (mycallback) {
        mycallback(parsed_data);
    }
}

function cpanel_api2() {
    var argv = cpanel_api2.arguments;
    var mycallback = argv[0];
    var module = argv[1];
    var func = argv[2];
    var argc = argv.length;

    var callback = {
        success: cpanel_api2_parser,
        argument: mycallback
    };

    var sFormData;
    if (use_fast_proto) {
        sFormData = "cpanel_xmlapi_module=" + encodeURIComponent(module) + "&cpanel_xmlapi_func=" + encodeURIComponent(func) + "&cpanel_xmlapi_apiversion=2";
        for (var i = 3; i < argc; i += 2) {
            sFormData += "&" + encodeURIComponent(argv[i]) + "=" + encodeURIComponent(argv[i + 1]);
        }
    } else {
        sFormData = "xmlin=<cpanelaction><apiversion>2</apiversion><module>" + module + "</module><func>" + func + "</func><args>";
        for (var i = 3; i < argc; i += 2) {
            sFormData += "<" + argv[i] + ">" + argv[i + 1] + "</" + argv[i] + ">";
        }
        sFormData += "</args></cpanelaction>";
    }
    if (sFormData.length < 2000) {
        YAHOO.util.Connect.asyncRequest("GET", CPANEL.security_token + "/xml-api/cpanel?" + sFormData, callback);
    } else {
        YAHOO.util.Connect.asyncRequest("POST", CPANEL.security_token + "/xml-api/cpanel", callback, sFormData);
    }
}

function cpanel_api2_parser(o) {
    var mycallback = o.argument;
    var rootNode = o.responseXML;
    var cpanelresultEl = rootNode.getElementsByTagName("cpanelresult")[0];
    var cpaneldataEl = cpanelresultEl.getElementsByTagName("data");

    if (mycallback) {
        mycallback(cpaneldataEl);
    }
}
