define("app/views/ROUTES",["cjt/util/locale"],(function(e){"use strict";return[{id:"atAGlance",route:"/overview",hideTitle:!0,controller:"atAGlance",templateUrl:"views/atAGlance.ptt",title:e.maketext("Overview"),resolve:{userPreferences:["spamAssassin",function(e){return e.getUserPreferences()}]}},{id:"spamBox",route:"/spambox",controller:"spamBox",parentRoute:"atAGlance",templateUrl:"views/spamBox.ptt",title:e.maketext("Spam Box"),description:e.maketext("Spam Box will deliver any emails that the system identifies as spam into a separate mail folder named [output,em,spam]."),resolve:{userPreferences:["spamAssassin",function(e){return e.getUserPreferences()}]}},{id:"requiredScore",route:"/required-score",controller:"configurations",parentRoute:"atAGlance",templateUrl:"views/requiredScore.ptt",title:e.maketext("Adjust Spam Threshold Score"),description:e.maketext("Configure the [asis,Spam Score Threshold].")+" "+e.maketext("If your hosting provider enables rewrites, the server will add a “***SPAM***” tag to the subject when the message’s calculated spam score meets or exceeds the Spam Threshold Score."),resolve:{userPreferences:["spamAssassin",function(e){return e.getUserPreferences()}]}},{id:"spamAutoDelete",route:"/autodelete",controller:"spamAutoDelete",parentRoute:"atAGlance",templateUrl:"views/spamAutoDelete.ptt",title:e.maketext("Auto-Delete"),description:e.maketext("Automatically delete messages with spam scores that meet or exceed the Auto-Delete Threshold Score. The Auto-Delete Threshold Score does not affect the Spam Threshold Score."),resolve:{userPreferences:["spamAssassin",function(e){return e.getUserPreferences()}]}},{id:"whitelist",route:"/whitelist",controller:"configurations",parentRoute:"atAGlance",templateUrl:"views/whitelist.ptt",title:e.maketext("Whitelist"),description:e.maketext("Configure the whitelist settings for Spam Filters."),resolve:{userPreferences:["spamAssassin",function(e){return e.getUserPreferences()}]}},{id:"blacklist",route:"/blacklist",controller:"configurations",parentRoute:"atAGlance",templateUrl:"views/blacklist.ptt",title:e.maketext("Blacklist"),description:e.maketext("Configure the blacklist settings for Spam Filters."),resolve:{userPreferences:["spamAssassin",function(e){return e.getUserPreferences()}]}},{id:"advanced",route:"/advanced-settings",controller:"configurations",parentRoute:"atAGlance",templateUrl:"views/advancedSettings.ptt",title:e.maketext("Calculated Spam Score Settings"),description:e.maketext("Configure the calculated spam score settings."),resolve:{userPreferences:["spamAssassin",function(e){return e.getUserPreferences()}],spamTestingSymbolicNames:["spamAssassin",function(e){return e.getSymbolicTestNames()}]}}]})),define("app/services/spamAssassin",["angular","lodash","cjt/util/locale","cjt/io/uapi-request","cjt/io/uapi","cjt/services/APICatcher","cjt/services/alertService"],(function(e,t,s,i){"use strict";var r=e.module("cpanel.apacheSpamAssassin.spamAssassin.service",[]);r.value("PAGE",PAGE),r.factory("spamAssassin",["$q","$filter","APICatcher","PAGE","alertService",function(r,n,o,l,a){var c=function(){},h="INBOX.spam",u=["rewrites_subjects","spam_as_acl","spam_auto_delete","spam_box_enabled","spam_enabled","spam_status_changeable"];function d(e){a.add({message:e,type:"success",replace:!1})}function _(){return l.user}function p(e){return"spamBox"===e?"1"===l.feature_spam_box.toString():"spamAutoDelete"!==e||"1"===l.feature_spam_assassin.toString()}return c.prototype=o,e.extend(c.prototype,{symbolicTestNames:[],spamAssassinSettings:{},userPreferences:{},_parseUserPreferences:function(t){var s=this;return t?(e.forEach(t,(function(e,t){"required_score"===t?(s.userPreferences[t]=Number(e.shift(),10)||5,s.userPreferences[t]=isNaN(s.userPreferences[t])?5:s.userPreferences[t]):s.userPreferences[t]="score"===t?e.filter((function(e){var t=e.trim().split(/\s+/);return 2===t.length||5===t.length})).map((function(e){var t=e.trim().split(/\s+/);return t.shift()+" "+t.pop()})):e})),s.userPreferences):s.userPreferences},hasFeature:p,getValidRoutes:function(e){return t.filter(e,(function(e){return p(e.id)}))}.bind(c.prototype),getSpamAssassinSettings:function(){var t=this,s=new i.Class;return s.initialize("Email","get_spam_settings"),t.promise(s).then((function(s){var i=s.data;return e.forEach(i,(function(e,s){"spam_auto_delete_score"===s?(t.spamAssassinSettings[s]=parseInt(e,10),t.spamAssassinSettings[s]=isNaN(t.spamAssassinSettings[s])?5:t.spamAssassinSettings[s]):-1!==u.indexOf(s)?t.spamAssassinSettings[s]="1"===e.toString():t.spamAssassinSettings[s]=i[s]})),t.spamAssassinSettings}))}.bind(c.prototype),enableSpamAssassin:function(){var e=this,t=new i.Class;return t.initialize("Email","enable_spam_assassin"),e.promise(t).then((function(t){return e.spamAssassinSettings.spam_enabled=!0,d(s.maketext("[asis,Apache SpamAssassin] has been enabled.")),t}))}.bind(c.prototype),disableSpamAssassin:function(){var e=this,t=new i.Class;return t.initialize("Email","disable_spam_assassin"),e.promise(t).then((function(t){return e.spamAssassinSettings.spam_enabled=!1,d(s.maketext("[asis,Apache SpamAssassin] has been disabled.")),e.spamAssassinSettings.spam_box_enabled&&e.disableSpamBox(),e.spamAssassinSettings.spam_auto_delete&&e.disableAutoDelete(),t}))}.bind(c.prototype),enableAutoDelete:function(e){var t=this,r=new i.Class;function n(i){return t.spamAssassinSettings.spam_auto_delete?d(s.maketext("The Auto-Delete Threshold Score has been updated to [_1].",e)):d(s.maketext("Spam Auto-Delete has been enabled.")),t.spamAssassinSettings.spam_auto_delete=!0,t.spamAssassinSettings.spam_auto_delete_score=e,i}return r.initialize("Email","add_spam_filter",{required_score:e}),t.spamAssassinSettings.spam_enabled?this.promise(r).then(n):t.enableSpamAssassin().then((function(){return t.promise(r).then(n)}))}.bind(c.prototype),disableAutoDelete:function(){var e=this,t=new i.Class;return t.initialize("Email","disable_spam_autodelete"),this.promise(t).then((function(t){return e.spamAssassinSettings.spam_auto_delete=!1,d(s.maketext("Spam Auto-Delete has been disabled.")),t}))}.bind(c.prototype),enableSpamBox:function(){var e=this,t=new i.Class;function r(t){return e.spamAssassinSettings.spam_box_enabled=!0,d(s.maketext("Spam Box has been enabled.")),t}return t.initialize("Email","enable_spam_box"),e.spamAssassinSettings.spam_enabled?this.promise(t).then(r):e.enableSpamAssassin().then((function(){return e.promise(t).then(r)}))}.bind(c.prototype),disableSpamBox:function(){var e=this,t=new i.Class;return t.initialize("Email","disable_spam_box"),this.promise(t).then((function(t){return e.spamAssassinSettings.spam_box_enabled=!1,d(s.maketext("Spam Box has been disabled.")),t}))}.bind(c.prototype),getSpamBoxSize:function(){var e=new i.Class;return e.initialize("Mailboxes","get_mailbox_status_list",{account:_()}),e.addFilter("mailbox","eq",h),this.promise(e).then((function(e){var t=e.data.shift();if(!t)return 0;var s=parseInt(t.vsize,10);return isNaN(s)?0:s}))}.bind(c.prototype),clearSpamBoxFolder:function(){var e=new i.Class;return e.initialize("Mailboxes","expunge_mailbox_messages",{account:_(),query:"all",mailbox:h}),this.promise(e).then((function(e){return d(s.maketext("Expunged the Spam Box folder for “[_1]”.",_())),e}))}.bind(c.prototype),getUserPreferences:function(){var e=this,t=new i.Class;return t.initialize("SpamAssassin","get_user_preferences"),this.promise(t).then((function(t){return e.userPreferences.whitelist_from=[],e.userPreferences.blacklist_from=[],e.userPreferences.required_score=5,e.userPreferences.score=[],e._parseUserPreferences(t.data)}))}.bind(c.prototype),updateUserPreference:function(e,t){var r=this,n=new i.Class;return n.initialize("SpamAssassin","update_user_preference",{preference:e}),n.addArgument("value",t),this.promise(n).then((function(e){return d(s.maketext("The [asis,Apache SpamAssassin] user preferences have been updated.")),r._parseUserPreferences(e.data)}))}.bind(c.prototype),getSymbolicTestNames:function(){var e=this;if(e.symbolicTestNames.length)return r.resolve(e.symbolicTestNames);var t=new i.Class;return t.initialize("SpamAssassin","get_symbolic_test_names"),e.promise(t).then((function(t){return e.symbolicTestNames=t.data.map((function(e){return{key:e.key,rule_type:e.rule_type,score:e.score}})),e.symbolicTestNames}))}.bind(c.prototype),clearAllSpamBoxFolders:function(){var e=new i.Class;return e.initialize("SpamAssassin","clear_spam_box"),this.promise(e).then((function(e){return d(s.maketext("All Spam Box folders expunged.")),e}))}.bind(c.prototype)}),new c}])})),function(e){define("jquery-chosen",["jquery"],(function(){return function(){
/*!
Chosen, a Select Box Enhancer for jQuery and Prototype
by Patrick Filler for Harvest, http://getharvest.com

Version 1.5.1
Full source at https://github.com/harvesthq/chosen
Copyright (c) 2011-2016 Harvest http://getharvest.com

MIT License, https://github.com/harvesthq/chosen/blob/master/LICENSE.md
This file is generated by `grunt build`, do not edit it by hand.
*/
(function(){var e,t,s,i,r={}.hasOwnProperty;(i=function(){function e(){this.options_index=0,this.parsed=[]}return e.prototype.add_node=function(e){return"OPTGROUP"===e.nodeName.toUpperCase()?this.add_group(e):this.add_option(e)},e.prototype.add_group=function(e){var t,s,i,r,n,o;for(t=this.parsed.length,this.parsed.push({array_index:t,group:!0,label:this.escapeExpression(e.label),title:e.title?e.title:void 0,children:0,disabled:e.disabled,classes:e.className}),o=[],i=0,r=(n=e.childNodes).length;i<r;i++)s=n[i],o.push(this.add_option(s,t,e.disabled));return o},e.prototype.add_option=function(e,t,s){if("OPTION"===e.nodeName.toUpperCase())return""!==e.text?(null!=t&&(this.parsed[t].children+=1),this.parsed.push({array_index:this.parsed.length,options_index:this.options_index,value:e.value,text:e.text,html:e.innerHTML,title:e.title?e.title:void 0,selected:e.selected,disabled:!0===s?s:e.disabled,group_array_index:t,group_label:null!=t?this.parsed[t].label:null,classes:e.className,style:e.style.cssText})):this.parsed.push({array_index:this.parsed.length,options_index:this.options_index,empty:!0}),this.options_index+=1},e.prototype.escapeExpression=function(e){var t,s;return null==e||!1===e?"":/[\&\<\>\"\'\`]/.test(e)?(t={"<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},s=/&(?!\w+;)|[\<\>\"\'\`]/g,e.replace(s,(function(e){return t[e]||"&amp;"}))):e},e}()).select_to_array=function(e){var t,s,r,n,o;for(s=new i,r=0,n=(o=e.childNodes).length;r<n;r++)t=o[r],s.add_node(t);return s.parsed},t=function(){function e(t,s){this.form_field=t,this.options=null!=s?s:{},e.browser_is_supported()&&(this.is_multiple=this.form_field.multiple,this.set_default_text(),this.set_default_values(),this.setup(),this.set_up_html(),this.register_observers(),this.on_ready())}return e.prototype.set_default_values=function(){var e=this;return this.click_test_action=function(t){return e.test_active_click(t)},this.activate_action=function(t){return e.activate_field(t)},this.active_field=!1,this.mouse_on_container=!1,this.results_showing=!1,this.result_highlighted=null,this.allow_single_deselect=null!=this.options.allow_single_deselect&&null!=this.form_field.options[0]&&""===this.form_field.options[0].text&&this.options.allow_single_deselect,this.disable_search_threshold=this.options.disable_search_threshold||0,this.disable_search=this.options.disable_search||!1,this.enable_split_word_search=null==this.options.enable_split_word_search||this.options.enable_split_word_search,this.group_search=null==this.options.group_search||this.options.group_search,this.search_contains=this.options.search_contains||!1,this.single_backstroke_delete=null==this.options.single_backstroke_delete||this.options.single_backstroke_delete,this.max_selected_options=this.options.max_selected_options||1/0,this.inherit_select_classes=this.options.inherit_select_classes||!1,this.display_selected_options=null==this.options.display_selected_options||this.options.display_selected_options,this.display_disabled_options=null==this.options.display_disabled_options||this.options.display_disabled_options,this.include_group_label_in_selected=this.options.include_group_label_in_selected||!1,this.max_shown_results=this.options.max_shown_results||Number.POSITIVE_INFINITY},e.prototype.set_default_text=function(){return this.form_field.getAttribute("data-placeholder")?this.default_text=this.form_field.getAttribute("data-placeholder"):this.is_multiple?this.default_text=this.options.placeholder_text_multiple||this.options.placeholder_text||e.default_multiple_text:this.default_text=this.options.placeholder_text_single||this.options.placeholder_text||e.default_single_text,this.results_none_found=this.form_field.getAttribute("data-no_results_text")||this.options.no_results_text||e.default_no_result_text},e.prototype.choice_label=function(e){return this.include_group_label_in_selected&&null!=e.group_label?"<b class='group-name'>"+e.group_label+"</b>"+e.html:e.html},e.prototype.mouse_enter=function(){return this.mouse_on_container=!0},e.prototype.mouse_leave=function(){return this.mouse_on_container=!1},e.prototype.input_focus=function(e){var t=this;if(this.is_multiple){if(!this.active_field)return setTimeout((function(){return t.container_mousedown()}),50)}else if(!this.active_field)return this.activate_field()},e.prototype.input_blur=function(e){var t=this;if(!this.mouse_on_container)return this.active_field=!1,setTimeout((function(){return t.blur_test()}),100)},e.prototype.results_option_build=function(e){var t,s,i,r,n,o,l;for(t="",r=0,n=0,o=(l=this.results_data).length;n<o&&(i="",""!==(i=(s=l[n]).group?this.result_add_group(s):this.result_add_option(s))&&(r++,t+=i),(null!=e?e.first:void 0)&&(s.selected&&this.is_multiple?this.choice_build(s):s.selected&&!this.is_multiple&&this.single_set_selected_text(this.choice_label(s))),!(r>=this.max_shown_results));n++);return t},e.prototype.result_add_option=function(e){var t,s;return e.search_match&&this.include_option_in_results(e)?(t=[],e.disabled||e.selected&&this.is_multiple||t.push("active-result"),!e.disabled||e.selected&&this.is_multiple||t.push("disabled-result"),e.selected&&t.push("result-selected"),null!=e.group_array_index&&t.push("group-option"),""!==e.classes&&t.push(e.classes),(s=document.createElement("li")).className=t.join(" "),s.style.cssText=e.style,s.setAttribute("data-option-array-index",e.array_index),s.innerHTML=e.search_text,e.title&&(s.title=e.title),this.outerHTML(s)):""},e.prototype.result_add_group=function(e){var t,s;return(e.search_match||e.group_match)&&e.active_options>0?((t=[]).push("group-result"),e.classes&&t.push(e.classes),(s=document.createElement("li")).className=t.join(" "),s.innerHTML=e.search_text,e.title&&(s.title=e.title),this.outerHTML(s)):""},e.prototype.results_update_field=function(){if(this.set_default_text(),this.is_multiple||this.results_reset_cleanup(),this.result_clear_highlight(),this.results_build(),this.results_showing)return this.winnow_results()},e.prototype.reset_single_select_options=function(){var e,t,s,i,r;for(r=[],t=0,s=(i=this.results_data).length;t<s;t++)(e=i[t]).selected?r.push(e.selected=!1):r.push(void 0);return r},e.prototype.results_toggle=function(){return this.results_showing?this.results_hide():this.results_show()},e.prototype.results_search=function(e){return this.results_showing?this.winnow_results():this.results_show()},e.prototype.winnow_results=function(){var e,t,s,i,r,n,o,l,a,c,h,u;for(this.no_results_clear(),i=0,e=(n=this.get_search_text()).replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&"),a=new RegExp(e,"i"),s=this.get_search_regex(e),c=0,h=(u=this.results_data).length;c<h;c++)(t=u[c]).search_match=!1,r=null,this.include_option_in_results(t)&&(t.group&&(t.group_match=!1,t.active_options=0),null!=t.group_array_index&&this.results_data[t.group_array_index]&&(0===(r=this.results_data[t.group_array_index]).active_options&&r.search_match&&(i+=1),r.active_options+=1),t.search_text=t.group?t.label:t.html,t.group&&!this.group_search||(t.search_match=this.search_string_match(t.search_text,s),t.search_match&&!t.group&&(i+=1),t.search_match?(n.length&&(o=t.search_text.search(a),l=t.search_text.substr(0,o+n.length)+"</em>"+t.search_text.substr(o+n.length),t.search_text=l.substr(0,o)+"<em>"+l.substr(o)),null!=r&&(r.group_match=!0)):null!=t.group_array_index&&this.results_data[t.group_array_index].search_match&&(t.search_match=!0)));return this.result_clear_highlight(),i<1&&n.length?(this.update_results_content(""),this.no_results(n)):(this.update_results_content(this.results_option_build()),this.winnow_results_set_highlight())},e.prototype.get_search_regex=function(e){var t;return t=this.search_contains?"":"^",new RegExp(t+e,"i")},e.prototype.search_string_match=function(e,t){var s,i,r,n;if(t.test(e))return!0;if(this.enable_split_word_search&&(e.indexOf(" ")>=0||0===e.indexOf("["))&&(i=e.replace(/\[|\]/g,"").split(" ")).length)for(r=0,n=i.length;r<n;r++)if(s=i[r],t.test(s))return!0},e.prototype.choices_count=function(){var e,t,s;if(null!=this.selected_option_count)return this.selected_option_count;for(this.selected_option_count=0,e=0,t=(s=this.form_field.options).length;e<t;e++)s[e].selected&&(this.selected_option_count+=1);return this.selected_option_count},e.prototype.choices_click=function(e){if(e.preventDefault(),!this.results_showing&&!this.is_disabled)return this.results_show()},e.prototype.keyup_checker=function(e){var t,s;switch(t=null!=(s=e.which)?s:e.keyCode,this.search_field_scale(),t){case 8:if(this.is_multiple&&this.backstroke_length<1&&this.choices_count()>0)return this.keydown_backstroke();if(!this.pending_backstroke)return this.result_clear_highlight(),this.results_search();break;case 13:if(e.preventDefault(),this.results_showing)return this.result_select(e);break;case 27:return this.results_showing&&this.results_hide(),!0;case 9:case 38:case 40:case 16:case 91:case 17:case 18:break;default:return this.results_search()}},e.prototype.clipboard_event_checker=function(e){var t=this;return setTimeout((function(){return t.results_search()}),50)},e.prototype.container_width=function(){return null!=this.options.width?this.options.width:this.form_field.offsetWidth+"px"},e.prototype.include_option_in_results=function(e){return!(this.is_multiple&&!this.display_selected_options&&e.selected)&&(!(!this.display_disabled_options&&e.disabled)&&!e.empty)},e.prototype.search_results_touchstart=function(e){return this.touch_started=!0,this.search_results_mouseover(e)},e.prototype.search_results_touchmove=function(e){return this.touch_started=!1,this.search_results_mouseout(e)},e.prototype.search_results_touchend=function(e){if(this.touch_started)return this.search_results_mouseup(e)},e.prototype.outerHTML=function(e){var t;return e.outerHTML?e.outerHTML:((t=document.createElement("div")).appendChild(e),t.innerHTML)},e.browser_is_supported=function(){return!/iP(od|hone)/i.test(window.navigator.userAgent)&&((!/Android/i.test(window.navigator.userAgent)||!/Mobile/i.test(window.navigator.userAgent))&&(!/IEMobile/i.test(window.navigator.userAgent)&&(!/Windows Phone/i.test(window.navigator.userAgent)&&(!/BlackBerry/i.test(window.navigator.userAgent)&&(!/BB10/i.test(window.navigator.userAgent)&&("Microsoft Internet Explorer"!==window.navigator.appName||document.documentMode>=8))))))},e.default_multiple_text="Select Some Options",e.default_single_text="Select an Option",e.default_no_result_text="No results match",e}(),(e=jQuery).fn.extend({chosen:function(i){return t.browser_is_supported()?this.each((function(t){var r,n;n=(r=e(this)).data("chosen"),"destroy"!==i?n instanceof s||r.data("chosen",new s(this,i)):n instanceof s&&n.destroy()})):this}}),s=function(t){function s(){return s.__super__.constructor.apply(this,arguments)}return function(e,t){for(var s in t)r.call(t,s)&&(e[s]=t[s]);function i(){this.constructor=e}i.prototype=t.prototype,e.prototype=new i,e.__super__=t.prototype}(s,t),s.prototype.setup=function(){return this.form_field_jq=e(this.form_field),this.current_selectedIndex=this.form_field.selectedIndex,this.is_rtl=this.form_field_jq.hasClass("chosen-rtl")},s.prototype.set_up_html=function(){var t,s;return(t=["chosen-container"]).push("chosen-container-"+(this.is_multiple?"multi":"single")),this.inherit_select_classes&&this.form_field.className&&t.push(this.form_field.className),this.is_rtl&&t.push("chosen-rtl"),s={class:t.join(" "),style:"width: "+this.container_width()+";",title:this.form_field.title},this.form_field.id.length&&(s.id=this.form_field.id.replace(/[^\w]/g,"_")+"_chosen"),this.container=e("<div />",s),this.is_multiple?this.container.html('<ul class="chosen-choices"><li class="search-field"><input type="text" value="'+this.default_text+'" class="default" autocomplete="off" style="width:25px;" /></li></ul><div class="chosen-drop"><ul class="chosen-results"></ul></div>'):this.container.html('<a class="chosen-single chosen-default"><span>'+this.default_text+'</span><div><b></b></div></a><div class="chosen-drop"><div class="chosen-search"><input type="text" autocomplete="off" /></div><ul class="chosen-results"></ul></div>'),this.form_field_jq.hide().after(this.container),this.dropdown=this.container.find("div.chosen-drop").first(),this.search_field=this.container.find("input").first(),this.search_results=this.container.find("ul.chosen-results").first(),this.search_field_scale(),this.search_no_results=this.container.find("li.no-results").first(),this.is_multiple?(this.search_choices=this.container.find("ul.chosen-choices").first(),this.search_container=this.container.find("li.search-field").first()):(this.search_container=this.container.find("div.chosen-search").first(),this.selected_item=this.container.find(".chosen-single").first()),this.results_build(),this.set_tab_index(),this.set_label_behavior()},s.prototype.on_ready=function(){return this.form_field_jq.trigger("chosen:ready",{chosen:this})},s.prototype.register_observers=function(){var e=this;return this.container.bind("touchstart.chosen",(function(t){return e.container_mousedown(t),t.preventDefault()})),this.container.bind("touchend.chosen",(function(t){return e.container_mouseup(t),t.preventDefault()})),this.container.bind("mousedown.chosen",(function(t){e.container_mousedown(t)})),this.container.bind("mouseup.chosen",(function(t){e.container_mouseup(t)})),this.container.bind("mouseenter.chosen",(function(t){e.mouse_enter(t)})),this.container.bind("mouseleave.chosen",(function(t){e.mouse_leave(t)})),this.search_results.bind("mouseup.chosen",(function(t){e.search_results_mouseup(t)})),this.search_results.bind("mouseover.chosen",(function(t){e.search_results_mouseover(t)})),this.search_results.bind("mouseout.chosen",(function(t){e.search_results_mouseout(t)})),this.search_results.bind("mousewheel.chosen DOMMouseScroll.chosen",(function(t){e.search_results_mousewheel(t)})),this.search_results.bind("touchstart.chosen",(function(t){e.search_results_touchstart(t)})),this.search_results.bind("touchmove.chosen",(function(t){e.search_results_touchmove(t)})),this.search_results.bind("touchend.chosen",(function(t){e.search_results_touchend(t)})),this.form_field_jq.bind("chosen:updated.chosen",(function(t){e.results_update_field(t)})),this.form_field_jq.bind("chosen:activate.chosen",(function(t){e.activate_field(t)})),this.form_field_jq.bind("chosen:open.chosen",(function(t){e.container_mousedown(t)})),this.form_field_jq.bind("chosen:close.chosen",(function(t){e.input_blur(t)})),this.search_field.bind("blur.chosen",(function(t){e.input_blur(t)})),this.search_field.bind("keyup.chosen",(function(t){e.keyup_checker(t)})),this.search_field.bind("keydown.chosen",(function(t){e.keydown_checker(t)})),this.search_field.bind("focus.chosen",(function(t){e.input_focus(t)})),this.search_field.bind("cut.chosen",(function(t){e.clipboard_event_checker(t)})),this.search_field.bind("paste.chosen",(function(t){e.clipboard_event_checker(t)})),this.is_multiple?this.search_choices.bind("click.chosen",(function(t){e.choices_click(t)})):this.container.bind("click.chosen",(function(e){e.preventDefault()}))},s.prototype.destroy=function(){return e(this.container[0].ownerDocument).unbind("click.chosen",this.click_test_action),this.search_field[0].tabIndex&&(this.form_field_jq[0].tabIndex=this.search_field[0].tabIndex),this.container.remove(),this.form_field_jq.removeData("chosen"),this.form_field_jq.show()},s.prototype.search_field_disabled=function(){return this.is_disabled=this.form_field_jq[0].disabled,this.is_disabled?(this.container.addClass("chosen-disabled"),this.search_field[0].disabled=!0,this.is_multiple||this.selected_item.unbind("focus.chosen",this.activate_action),this.close_field()):(this.container.removeClass("chosen-disabled"),this.search_field[0].disabled=!1,this.is_multiple?void 0:this.selected_item.bind("focus.chosen",this.activate_action))},s.prototype.container_mousedown=function(t){if(!this.is_disabled&&(t&&"mousedown"===t.type&&!this.results_showing&&t.preventDefault(),null==t||!e(t.target).hasClass("search-choice-close")))return this.active_field?this.is_multiple||!t||e(t.target)[0]!==this.selected_item[0]&&!e(t.target).parents("a.chosen-single").length||(t.preventDefault(),this.results_toggle()):(this.is_multiple&&this.search_field.val(""),e(this.container[0].ownerDocument).bind("click.chosen",this.click_test_action),this.results_show()),this.activate_field()},s.prototype.container_mouseup=function(e){if("ABBR"===e.target.nodeName&&!this.is_disabled)return this.results_reset(e)},s.prototype.search_results_mousewheel=function(e){var t;if(e.originalEvent&&(t=e.originalEvent.deltaY||-e.originalEvent.wheelDelta||e.originalEvent.detail),null!=t)return e.preventDefault(),"DOMMouseScroll"===e.type&&(t*=40),this.search_results.scrollTop(t+this.search_results.scrollTop())},s.prototype.blur_test=function(e){if(!this.active_field&&this.container.hasClass("chosen-container-active"))return this.close_field()},s.prototype.close_field=function(){return e(this.container[0].ownerDocument).unbind("click.chosen",this.click_test_action),this.active_field=!1,this.results_hide(),this.container.removeClass("chosen-container-active"),this.clear_backstroke(),this.show_search_field_default(),this.search_field_scale()},s.prototype.activate_field=function(){return this.container.addClass("chosen-container-active"),this.active_field=!0,this.search_field.val(this.search_field.val()),this.search_field.focus()},s.prototype.test_active_click=function(t){var s;return(s=e(t.target).closest(".chosen-container")).length&&this.container[0]===s[0]?this.active_field=!0:this.close_field()},s.prototype.results_build=function(){return this.parsing=!0,this.selected_option_count=null,this.results_data=i.select_to_array(this.form_field),this.is_multiple?this.search_choices.find("li.search-choice").remove():this.is_multiple||(this.single_set_selected_text(),this.disable_search||this.form_field.options.length<=this.disable_search_threshold?(this.search_field[0].readOnly=!0,this.container.addClass("chosen-container-single-nosearch")):(this.search_field[0].readOnly=!1,this.container.removeClass("chosen-container-single-nosearch"))),this.update_results_content(this.results_option_build({first:!0})),this.search_field_disabled(),this.show_search_field_default(),this.search_field_scale(),this.parsing=!1},s.prototype.result_do_highlight=function(e){var t,s,i,r,n;if(e.length){if(this.result_clear_highlight(),this.result_highlight=e,this.result_highlight.addClass("highlighted"),r=(i=parseInt(this.search_results.css("maxHeight"),10))+(n=this.search_results.scrollTop()),(t=(s=this.result_highlight.position().top+this.search_results.scrollTop())+this.result_highlight.outerHeight())>=r)return this.search_results.scrollTop(t-i>0?t-i:0);if(s<n)return this.search_results.scrollTop(s)}},s.prototype.result_clear_highlight=function(){return this.result_highlight&&this.result_highlight.removeClass("highlighted"),this.result_highlight=null},s.prototype.results_show=function(){return this.is_multiple&&this.max_selected_options<=this.choices_count()?(this.form_field_jq.trigger("chosen:maxselected",{chosen:this}),!1):(this.container.addClass("chosen-with-drop"),this.results_showing=!0,this.search_field.focus(),this.search_field.val(this.search_field.val()),this.winnow_results(),this.form_field_jq.trigger("chosen:showing_dropdown",{chosen:this}))},s.prototype.update_results_content=function(e){return this.search_results.html(e)},s.prototype.results_hide=function(){return this.results_showing&&(this.result_clear_highlight(),this.container.removeClass("chosen-with-drop"),this.form_field_jq.trigger("chosen:hiding_dropdown",{chosen:this})),this.results_showing=!1},s.prototype.set_tab_index=function(e){var t;if(this.form_field.tabIndex)return t=this.form_field.tabIndex,this.form_field.tabIndex=-1,this.search_field[0].tabIndex=t},s.prototype.set_label_behavior=function(){var t=this;if(this.form_field_label=this.form_field_jq.parents("label"),!this.form_field_label.length&&this.form_field.id.length&&(this.form_field_label=e("label[for='"+this.form_field.id+"']")),this.form_field_label.length>0)return this.form_field_label.bind("click.chosen",(function(e){return t.is_multiple?t.container_mousedown(e):t.activate_field()}))},s.prototype.show_search_field_default=function(){return this.is_multiple&&this.choices_count()<1&&!this.active_field?(this.search_field.val(this.default_text),this.search_field.addClass("default")):(this.search_field.val(""),this.search_field.removeClass("default"))},s.prototype.search_results_mouseup=function(t){var s;if((s=e(t.target).hasClass("active-result")?e(t.target):e(t.target).parents(".active-result").first()).length)return this.result_highlight=s,this.result_select(t),this.search_field.focus()},s.prototype.search_results_mouseover=function(t){var s;if(s=e(t.target).hasClass("active-result")?e(t.target):e(t.target).parents(".active-result").first())return this.result_do_highlight(s)},s.prototype.search_results_mouseout=function(t){if(e(t.target).hasClass("active-result"))return this.result_clear_highlight()},s.prototype.choice_build=function(t){var s,i,r=this;return s=e("<li />",{class:"search-choice"}).html("<span>"+this.choice_label(t)+"</span>"),t.disabled?s.addClass("search-choice-disabled"):((i=e("<a />",{class:"search-choice-close","data-option-array-index":t.array_index})).bind("click.chosen",(function(e){return r.choice_destroy_link_click(e)})),s.append(i)),this.search_container.before(s)},s.prototype.choice_destroy_link_click=function(t){if(t.preventDefault(),t.stopPropagation(),!this.is_disabled)return this.choice_destroy(e(t.target))},s.prototype.choice_destroy=function(e){if(this.result_deselect(e[0].getAttribute("data-option-array-index")))return this.show_search_field_default(),this.is_multiple&&this.choices_count()>0&&this.search_field.val().length<1&&this.results_hide(),e.parents("li").first().remove(),this.search_field_scale()},s.prototype.results_reset=function(){if(this.reset_single_select_options(),this.form_field.options[0].selected=!0,this.single_set_selected_text(),this.show_search_field_default(),this.results_reset_cleanup(),this.form_field_jq.trigger("change"),this.active_field)return this.results_hide()},s.prototype.results_reset_cleanup=function(){return this.current_selectedIndex=this.form_field.selectedIndex,this.selected_item.find("abbr").remove()},s.prototype.result_select=function(e){var t,s;if(this.result_highlight)return t=this.result_highlight,this.result_clear_highlight(),this.is_multiple&&this.max_selected_options<=this.choices_count()?(this.form_field_jq.trigger("chosen:maxselected",{chosen:this}),!1):(this.is_multiple?t.removeClass("active-result"):this.reset_single_select_options(),t.addClass("result-selected"),(s=this.results_data[t[0].getAttribute("data-option-array-index")]).selected=!0,this.form_field.options[s.options_index].selected=!0,this.selected_option_count=null,this.is_multiple?this.choice_build(s):this.single_set_selected_text(this.choice_label(s)),(e.metaKey||e.ctrlKey)&&this.is_multiple||this.results_hide(),this.show_search_field_default(),(this.is_multiple||this.form_field.selectedIndex!==this.current_selectedIndex)&&this.form_field_jq.trigger("change",{selected:this.form_field.options[s.options_index].value}),this.current_selectedIndex=this.form_field.selectedIndex,e.preventDefault(),this.search_field_scale())},s.prototype.single_set_selected_text=function(e){return null==e&&(e=this.default_text),e===this.default_text?this.selected_item.addClass("chosen-default"):(this.single_deselect_control_build(),this.selected_item.removeClass("chosen-default")),this.selected_item.find("span").html(e)},s.prototype.result_deselect=function(e){var t;return t=this.results_data[e],!this.form_field.options[t.options_index].disabled&&(t.selected=!1,this.form_field.options[t.options_index].selected=!1,this.selected_option_count=null,this.result_clear_highlight(),this.results_showing&&this.winnow_results(),this.form_field_jq.trigger("change",{deselected:this.form_field.options[t.options_index].value}),this.search_field_scale(),!0)},s.prototype.single_deselect_control_build=function(){if(this.allow_single_deselect)return this.selected_item.find("abbr").length||this.selected_item.find("span").first().after('<abbr class="search-choice-close"></abbr>'),this.selected_item.addClass("chosen-single-with-deselect")},s.prototype.get_search_text=function(){return e("<div/>").text(e.trim(this.search_field.val())).html()},s.prototype.winnow_results_set_highlight=function(){var e,t;if(null!=(e=(t=this.is_multiple?[]:this.search_results.find(".result-selected.active-result")).length?t.first():this.search_results.find(".active-result").first()))return this.result_do_highlight(e)},s.prototype.no_results=function(t){var s;return(s=e('<li class="no-results">'+this.results_none_found+' "<span></span>"</li>')).find("span").first().html(t),this.search_results.append(s),this.form_field_jq.trigger("chosen:no_results",{chosen:this})},s.prototype.no_results_clear=function(){return this.search_results.find(".no-results").remove()},s.prototype.keydown_arrow=function(){var e;return this.results_showing&&this.result_highlight?(e=this.result_highlight.nextAll("li.active-result").first())?this.result_do_highlight(e):void 0:this.results_show()},s.prototype.keyup_arrow=function(){var e;return this.results_showing||this.is_multiple?this.result_highlight?(e=this.result_highlight.prevAll("li.active-result")).length?this.result_do_highlight(e.first()):(this.choices_count()>0&&this.results_hide(),this.result_clear_highlight()):void 0:this.results_show()},s.prototype.keydown_backstroke=function(){var e;return this.pending_backstroke?(this.choice_destroy(this.pending_backstroke.find("a").first()),this.clear_backstroke()):(e=this.search_container.siblings("li.search-choice").last()).length&&!e.hasClass("search-choice-disabled")?(this.pending_backstroke=e,this.single_backstroke_delete?this.keydown_backstroke():this.pending_backstroke.addClass("search-choice-focus")):void 0},s.prototype.clear_backstroke=function(){return this.pending_backstroke&&this.pending_backstroke.removeClass("search-choice-focus"),this.pending_backstroke=null},s.prototype.keydown_checker=function(e){var t,s;switch(t=null!=(s=e.which)?s:e.keyCode,this.search_field_scale(),8!==t&&this.pending_backstroke&&this.clear_backstroke(),t){case 8:this.backstroke_length=this.search_field.val().length;break;case 9:this.results_showing&&!this.is_multiple&&this.result_select(e),this.mouse_on_container=!1;break;case 13:this.results_showing&&e.preventDefault();break;case 32:this.disable_search&&e.preventDefault();break;case 38:e.preventDefault(),this.keyup_arrow();break;case 40:e.preventDefault(),this.keydown_arrow()}},s.prototype.search_field_scale=function(){var t,s,i,r,n,o,l,a;if(this.is_multiple){for(0,o=0,r="position:absolute; left: -1000px; top: -1000px; display:none;",l=0,a=(n=["font-size","font-style","font-weight","font-family","line-height","text-transform","letter-spacing"]).length;l<a;l++)r+=(i=n[l])+":"+this.search_field.css(i)+";";return(t=e("<div />",{style:r})).text(this.search_field.val()),e("body").append(t),o=t.width()+25,t.remove(),o>(s=this.container.outerWidth())-10&&(o=s-10),this.search_field.css({width:o+"px"})}},s}(t)}).call(this)}.apply(e,arguments)}))}(this),function(e){define("angular-chosen",["angular","jquery-chosen"],(function(){return function(){
/**
 * angular-chosen-localytics - Angular Chosen directive is an AngularJS Directive that brings the Chosen jQuery in a Angular way
 * @version v1.3.0
 * @link http://github.com/leocaseiro/angular-chosen
 * @license MIT
 */
(function(){var e=[].indexOf||function(e){for(var t=0,s=this.length;t<s;t++)if(t in this&&this[t]===e)return t;return-1};angular.module("localytics.directives",[]),angular.module("localytics.directives").directive("chosen",["$timeout",function(t){var s,i,r,n;return i=/^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+group\s+by\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w]*)|(?:\(\s*([\$\w][\$\w]*)\s*,\s*([\$\w][\$\w]*)\s*\)))\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?$/,s=["persistentCreateOption","createOptionText","createOption","skipNoResults","noResultsText","allowSingleDeselect","disableSearchThreshold","disableSearch","enableSplitWordSearch","inheritSelectClasses","maxSelectedOptions","placeholderTextMultiple","placeholderTextSingle","searchContains","singleBackstrokeDelete","displayDisabledOptions","displaySelectedOptions","width","includeGroupLabelInSelected","maxShownResults"],n=function(e){return e.replace(/[A-Z]/g,(function(e){return"_"+e.toLowerCase()}))},r=function(e){var t;if(angular.isArray(e))return 0===e.length;if(angular.isObject(e))for(t in e)if(e.hasOwnProperty(t))return!1;return!0},{restrict:"A",require:"?ngModel",priority:1,link:function(o,l,a,c){var h,u,d,_,p,f,m,g,b,v;if(o.disabledValuesHistory=o.disabledValuesHistory?o.disabledValuesHistory:[],(l=$(l)).addClass("localytics-chosen"),_=o.$eval(a.chosen)||{},angular.forEach(a,(function(t,i){if(e.call(s,i)>=0)return a.$observe(i,(function(e){return _[n(i)]="{{"===String(l.attr(a.$attr[i])).slice(0,2)?e:o.$eval(e),g()}))})),f=function(){return l.addClass("loading").attr("disabled",!0).trigger("chosen:updated")},m=function(){return l.removeClass("loading"),angular.isDefined(a.disabled)?l.attr("disabled",a.disabled):l.attr("disabled",!1),l.trigger("chosen:updated")},h=null,u=!1,d=function(){return h?l.trigger("chosen:updated"):(t((function(){h=l.chosen(_).data("chosen")})),angular.isObject(h)?h.default_text:void 0)},g=function(){return u?l.attr("data-placeholder",h.results_none_found).attr("disabled",!0):l.removeAttr("data-placeholder"),l.trigger("chosen:updated")},c?(p=c.$render,c.$render=function(){return p(),d()},l.on("chosen:hiding_dropdown",(function(){return o.$apply((function(){return c.$setTouched()}))})),a.multiple&&(v=function(){return c.$viewValue},o.$watch(v,c.$render,!0))):d(),a.$observe("disabled",(function(){return l.trigger("chosen:updated")})),a.ngOptions&&c)return b=a.ngOptions.match(i)[7],o.$watchCollection(b,(function(e,s){return t((function(){return angular.isUndefined(e)?f():(u=r(e),m(),g())}))})),o.$on("$destroy",(function(e){if("undefined"!=typeof timer&&null!==timer)return t.cancel(timer)}))}}}])}).call(this)}.apply(e,arguments)}))}(this),define("app/directives/scoreField",["angular","cjt/util/locale","cjt/core","angular-chosen"],(function(e,t,s){"use strict";e.module("cpanel.apacheSpamAssassin.directives.scoreField",["localytics.directives"]).directive("scoreField",["$timeout",function(t){return{templateUrl:"directives/scoreField.phtml",restrict:"EA",require:["ngModel"],transclude:!0,scope:{scoreTypes:"=",ngModel:"=",parentID:"@id"},link:function(e,t){e.scoreType=null,e.selectedScoreType=null,e.scoreValue=null,e.$watch("selectedScoreType",(function(t,s){!t||null!==e.scoreValue&&e.scoreType===t.key||(e.scoreType=t.key,e.scoreValue=t.score)}))},controller:["$scope",function(t){["scoreType","scoreValue"].forEach((function(e){t.$watch(e,(function(e,s){t.scoreType&&null!==t.scoreValue&&(t.ngModel=t.scoreType+" "+t.scoreValue)}))})),t.modelUpdated=function(){if(t.ngModel){var s=t.ngModel.split(" ");t.scoreType=s[0],e.forEach(t.scoreTypes,(function(e){e.key===t.scoreType&&(t.selectedScoreType=e)})),t.scoreValue=isNaN(s[1])?null:Number(s[1])}},t.$watch("ngModel",t.modelUpdated),t.modelUpdated()}]}}])})),define("app/index",["angular","cjt/core","app/views/ROUTES","cjt/modules","ngRoute","app/services/spamAssassin","cjt/directives/multiFieldEditorItem","cjt/directives/multiFieldEditor","app/directives/scoreField","cjt/directives/callout","ngAnimate"],(function(e,t,s){"use strict";return function(){e.module("cpanel.apacheSpamAssassin",["ngRoute","angular-growl","cjt2.cpanel","cpanel.apacheSpamAssassin.spamAssassin.service","cjt2.directives.toggleSwitch","cjt2.directives.callout","cpanel.apacheSpamAssassin.directives.scoreField","cjt2.directives.multiFieldEditor","cjt2.directives.multiFieldEditorItem"]);var i=["app/views/main"];return s.forEach((function(e){i.push("app/views/"+e.controller)})),require(i,(function(){var i=e.module("cpanel.apacheSpamAssassin");i.value("PAGE",PAGE),i.config(["$routeProvider","$compileProvider","$animateProvider",function(e,i,r){r.classNameFilter(/^((?!no-animate).)*$/),t.config.debug||i.debugInfoEnabled(!1),s.forEach((function(t){e.when(t.route,{controller:t.controller,templateUrl:t.templateUrl,resolve:t.resolve})}))}]),i.init=function(){var t=e.element("#content");return null!==t[0]&&e.bootstrap(t[0],["cpanel.apacheSpamAssassin"]),i},i.init()}))}}));