(function(root) {
define("jquery-chosen", ["jquery"], function() {
  return (function() {
/*!
Chosen, a Select Box Enhancer for jQuery and Prototype
by Patrick Filler for Harvest, http://getharvest.com

Version 1.5.1
Full source at https://github.com/harvesthq/chosen
Copyright (c) 2011-2016 Harvest http://getharvest.com

MIT License, https://github.com/harvesthq/chosen/blob/master/LICENSE.md
This file is generated by `grunt build`, do not edit it by hand.
*/

(function() {
  var $, AbstractChosen, Chosen, SelectParser, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  SelectParser = (function() {
    function SelectParser() {
      this.options_index = 0;
      this.parsed = [];
    }

    SelectParser.prototype.add_node = function(child) {
      if (child.nodeName.toUpperCase() === "OPTGROUP") {
        return this.add_group(child);
      } else {
        return this.add_option(child);
      }
    };

    SelectParser.prototype.add_group = function(group) {
      var group_position, option, _i, _len, _ref, _results;
      group_position = this.parsed.length;
      this.parsed.push({
        array_index: group_position,
        group: true,
        label: this.escapeExpression(group.label),
        title: group.title ? group.title : void 0,
        children: 0,
        disabled: group.disabled,
        classes: group.className
      });
      _ref = group.childNodes;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        option = _ref[_i];
        _results.push(this.add_option(option, group_position, group.disabled));
      }
      return _results;
    };

    SelectParser.prototype.add_option = function(option, group_position, group_disabled) {
      if (option.nodeName.toUpperCase() === "OPTION") {
        if (option.text !== "") {
          if (group_position != null) {
            this.parsed[group_position].children += 1;
          }
          this.parsed.push({
            array_index: this.parsed.length,
            options_index: this.options_index,
            value: option.value,
            text: option.text,
            html: option.innerHTML,
            title: option.title ? option.title : void 0,
            selected: option.selected,
            disabled: group_disabled === true ? group_disabled : option.disabled,
            group_array_index: group_position,
            group_label: group_position != null ? this.parsed[group_position].label : null,
            classes: option.className,
            style: option.style.cssText
          });
        } else {
          this.parsed.push({
            array_index: this.parsed.length,
            options_index: this.options_index,
            empty: true
          });
        }
        return this.options_index += 1;
      }
    };

    SelectParser.prototype.escapeExpression = function(text) {
      var map, unsafe_chars;
      if ((text == null) || text === false) {
        return "";
      }
      if (!/[\&\<\>\"\'\`]/.test(text)) {
        return text;
      }
      map = {
        "<": "&lt;",
        ">": "&gt;",
        '"': "&quot;",
        "'": "&#x27;",
        "`": "&#x60;"
      };
      unsafe_chars = /&(?!\w+;)|[\<\>\"\'\`]/g;
      return text.replace(unsafe_chars, function(chr) {
        return map[chr] || "&amp;";
      });
    };

    return SelectParser;

  })();

  SelectParser.select_to_array = function(select) {
    var child, parser, _i, _len, _ref;
    parser = new SelectParser();
    _ref = select.childNodes;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      child = _ref[_i];
      parser.add_node(child);
    }
    return parser.parsed;
  };

  AbstractChosen = (function() {
    function AbstractChosen(form_field, options) {
      this.form_field = form_field;
      this.options = options != null ? options : {};
      if (!AbstractChosen.browser_is_supported()) {
        return;
      }
      this.is_multiple = this.form_field.multiple;
      this.set_default_text();
      this.set_default_values();
      this.setup();
      this.set_up_html();
      this.register_observers();
      this.on_ready();
    }

    AbstractChosen.prototype.set_default_values = function() {
      var _this = this;
      this.click_test_action = function(evt) {
        return _this.test_active_click(evt);
      };
      this.activate_action = function(evt) {
        return _this.activate_field(evt);
      };
      this.active_field = false;
      this.mouse_on_container = false;
      this.results_showing = false;
      this.result_highlighted = null;
      this.allow_single_deselect = (this.options.allow_single_deselect != null) && (this.form_field.options[0] != null) && this.form_field.options[0].text === "" ? this.options.allow_single_deselect : false;
      this.disable_search_threshold = this.options.disable_search_threshold || 0;
      this.disable_search = this.options.disable_search || false;
      this.enable_split_word_search = this.options.enable_split_word_search != null ? this.options.enable_split_word_search : true;
      this.group_search = this.options.group_search != null ? this.options.group_search : true;
      this.search_contains = this.options.search_contains || false;
      this.single_backstroke_delete = this.options.single_backstroke_delete != null ? this.options.single_backstroke_delete : true;
      this.max_selected_options = this.options.max_selected_options || Infinity;
      this.inherit_select_classes = this.options.inherit_select_classes || false;
      this.display_selected_options = this.options.display_selected_options != null ? this.options.display_selected_options : true;
      this.display_disabled_options = this.options.display_disabled_options != null ? this.options.display_disabled_options : true;
      this.include_group_label_in_selected = this.options.include_group_label_in_selected || false;
      return this.max_shown_results = this.options.max_shown_results || Number.POSITIVE_INFINITY;
    };

    AbstractChosen.prototype.set_default_text = function() {
      if (this.form_field.getAttribute("data-placeholder")) {
        this.default_text = this.form_field.getAttribute("data-placeholder");
      } else if (this.is_multiple) {
        this.default_text = this.options.placeholder_text_multiple || this.options.placeholder_text || AbstractChosen.default_multiple_text;
      } else {
        this.default_text = this.options.placeholder_text_single || this.options.placeholder_text || AbstractChosen.default_single_text;
      }
      return this.results_none_found = this.form_field.getAttribute("data-no_results_text") || this.options.no_results_text || AbstractChosen.default_no_result_text;
    };

    AbstractChosen.prototype.choice_label = function(item) {
      if (this.include_group_label_in_selected && (item.group_label != null)) {
        return "<b class='group-name'>" + item.group_label + "</b>" + item.html;
      } else {
        return item.html;
      }
    };

    AbstractChosen.prototype.mouse_enter = function() {
      return this.mouse_on_container = true;
    };

    AbstractChosen.prototype.mouse_leave = function() {
      return this.mouse_on_container = false;
    };

    AbstractChosen.prototype.input_focus = function(evt) {
      var _this = this;
      if (this.is_multiple) {
        if (!this.active_field) {
          return setTimeout((function() {
            return _this.container_mousedown();
          }), 50);
        }
      } else {
        if (!this.active_field) {
          return this.activate_field();
        }
      }
    };

    AbstractChosen.prototype.input_blur = function(evt) {
      var _this = this;
      if (!this.mouse_on_container) {
        this.active_field = false;
        return setTimeout((function() {
          return _this.blur_test();
        }), 100);
      }
    };

    AbstractChosen.prototype.results_option_build = function(options) {
      var content, data, data_content, shown_results, _i, _len, _ref;
      content = '';
      shown_results = 0;
      _ref = this.results_data;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        data = _ref[_i];
        data_content = '';
        if (data.group) {
          data_content = this.result_add_group(data);
        } else {
          data_content = this.result_add_option(data);
        }
        if (data_content !== '') {
          shown_results++;
          content += data_content;
        }
        if (options != null ? options.first : void 0) {
          if (data.selected && this.is_multiple) {
            this.choice_build(data);
          } else if (data.selected && !this.is_multiple) {
            this.single_set_selected_text(this.choice_label(data));
          }
        }
        if (shown_results >= this.max_shown_results) {
          break;
        }
      }
      return content;
    };

    AbstractChosen.prototype.result_add_option = function(option) {
      var classes, option_el;
      if (!option.search_match) {
        return '';
      }
      if (!this.include_option_in_results(option)) {
        return '';
      }
      classes = [];
      if (!option.disabled && !(option.selected && this.is_multiple)) {
        classes.push("active-result");
      }
      if (option.disabled && !(option.selected && this.is_multiple)) {
        classes.push("disabled-result");
      }
      if (option.selected) {
        classes.push("result-selected");
      }
      if (option.group_array_index != null) {
        classes.push("group-option");
      }
      if (option.classes !== "") {
        classes.push(option.classes);
      }
      option_el = document.createElement("li");
      option_el.className = classes.join(" ");
      option_el.style.cssText = option.style;
      option_el.setAttribute("data-option-array-index", option.array_index);
      option_el.innerHTML = option.search_text;
      if (option.title) {
        option_el.title = option.title;
      }
      return this.outerHTML(option_el);
    };

    AbstractChosen.prototype.result_add_group = function(group) {
      var classes, group_el;
      if (!(group.search_match || group.group_match)) {
        return '';
      }
      if (!(group.active_options > 0)) {
        return '';
      }
      classes = [];
      classes.push("group-result");
      if (group.classes) {
        classes.push(group.classes);
      }
      group_el = document.createElement("li");
      group_el.className = classes.join(" ");
      group_el.innerHTML = group.search_text;
      if (group.title) {
        group_el.title = group.title;
      }
      return this.outerHTML(group_el);
    };

    AbstractChosen.prototype.results_update_field = function() {
      this.set_default_text();
      if (!this.is_multiple) {
        this.results_reset_cleanup();
      }
      this.result_clear_highlight();
      this.results_build();
      if (this.results_showing) {
        return this.winnow_results();
      }
    };

    AbstractChosen.prototype.reset_single_select_options = function() {
      var result, _i, _len, _ref, _results;
      _ref = this.results_data;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        result = _ref[_i];
        if (result.selected) {
          _results.push(result.selected = false);
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    AbstractChosen.prototype.results_toggle = function() {
      if (this.results_showing) {
        return this.results_hide();
      } else {
        return this.results_show();
      }
    };

    AbstractChosen.prototype.results_search = function(evt) {
      if (this.results_showing) {
        return this.winnow_results();
      } else {
        return this.results_show();
      }
    };

    AbstractChosen.prototype.winnow_results = function() {
      var escapedSearchText, option, regex, results, results_group, searchText, startpos, text, zregex, _i, _len, _ref;
      this.no_results_clear();
      results = 0;
      searchText = this.get_search_text();
      escapedSearchText = searchText.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
      zregex = new RegExp(escapedSearchText, 'i');
      regex = this.get_search_regex(escapedSearchText);
      _ref = this.results_data;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        option = _ref[_i];
        option.search_match = false;
        results_group = null;
        if (this.include_option_in_results(option)) {
          if (option.group) {
            option.group_match = false;
            option.active_options = 0;
          }
          if ((option.group_array_index != null) && this.results_data[option.group_array_index]) {
            results_group = this.results_data[option.group_array_index];
            if (results_group.active_options === 0 && results_group.search_match) {
              results += 1;
            }
            results_group.active_options += 1;
          }
          option.search_text = option.group ? option.label : option.html;
          if (!(option.group && !this.group_search)) {
            option.search_match = this.search_string_match(option.search_text, regex);
            if (option.search_match && !option.group) {
              results += 1;
            }
            if (option.search_match) {
              if (searchText.length) {
                startpos = option.search_text.search(zregex);
                text = option.search_text.substr(0, startpos + searchText.length) + '</em>' + option.search_text.substr(startpos + searchText.length);
                option.search_text = text.substr(0, startpos) + '<em>' + text.substr(startpos);
              }
              if (results_group != null) {
                results_group.group_match = true;
              }
            } else if ((option.group_array_index != null) && this.results_data[option.group_array_index].search_match) {
              option.search_match = true;
            }
          }
        }
      }
      this.result_clear_highlight();
      if (results < 1 && searchText.length) {
        this.update_results_content("");
        return this.no_results(searchText);
      } else {
        this.update_results_content(this.results_option_build());
        return this.winnow_results_set_highlight();
      }
    };

    AbstractChosen.prototype.get_search_regex = function(escaped_search_string) {
      var regex_anchor;
      regex_anchor = this.search_contains ? "" : "^";
      return new RegExp(regex_anchor + escaped_search_string, 'i');
    };

    AbstractChosen.prototype.search_string_match = function(search_string, regex) {
      var part, parts, _i, _len;
      if (regex.test(search_string)) {
        return true;
      } else if (this.enable_split_word_search && (search_string.indexOf(" ") >= 0 || search_string.indexOf("[") === 0)) {
        parts = search_string.replace(/\[|\]/g, "").split(" ");
        if (parts.length) {
          for (_i = 0, _len = parts.length; _i < _len; _i++) {
            part = parts[_i];
            if (regex.test(part)) {
              return true;
            }
          }
        }
      }
    };

    AbstractChosen.prototype.choices_count = function() {
      var option, _i, _len, _ref;
      if (this.selected_option_count != null) {
        return this.selected_option_count;
      }
      this.selected_option_count = 0;
      _ref = this.form_field.options;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        option = _ref[_i];
        if (option.selected) {
          this.selected_option_count += 1;
        }
      }
      return this.selected_option_count;
    };

    AbstractChosen.prototype.choices_click = function(evt) {
      evt.preventDefault();
      if (!(this.results_showing || this.is_disabled)) {
        return this.results_show();
      }
    };

    AbstractChosen.prototype.keyup_checker = function(evt) {
      var stroke, _ref;
      stroke = (_ref = evt.which) != null ? _ref : evt.keyCode;
      this.search_field_scale();
      switch (stroke) {
        case 8:
          if (this.is_multiple && this.backstroke_length < 1 && this.choices_count() > 0) {
            return this.keydown_backstroke();
          } else if (!this.pending_backstroke) {
            this.result_clear_highlight();
            return this.results_search();
          }
          break;
        case 13:
          evt.preventDefault();
          if (this.results_showing) {
            return this.result_select(evt);
          }
          break;
        case 27:
          if (this.results_showing) {
            this.results_hide();
          }
          return true;
        case 9:
        case 38:
        case 40:
        case 16:
        case 91:
        case 17:
        case 18:
          break;
        default:
          return this.results_search();
      }
    };

    AbstractChosen.prototype.clipboard_event_checker = function(evt) {
      var _this = this;
      return setTimeout((function() {
        return _this.results_search();
      }), 50);
    };

    AbstractChosen.prototype.container_width = function() {
      if (this.options.width != null) {
        return this.options.width;
      } else {
        return "" + this.form_field.offsetWidth + "px";
      }
    };

    AbstractChosen.prototype.include_option_in_results = function(option) {
      if (this.is_multiple && (!this.display_selected_options && option.selected)) {
        return false;
      }
      if (!this.display_disabled_options && option.disabled) {
        return false;
      }
      if (option.empty) {
        return false;
      }
      return true;
    };

    AbstractChosen.prototype.search_results_touchstart = function(evt) {
      this.touch_started = true;
      return this.search_results_mouseover(evt);
    };

    AbstractChosen.prototype.search_results_touchmove = function(evt) {
      this.touch_started = false;
      return this.search_results_mouseout(evt);
    };

    AbstractChosen.prototype.search_results_touchend = function(evt) {
      if (this.touch_started) {
        return this.search_results_mouseup(evt);
      }
    };

    AbstractChosen.prototype.outerHTML = function(element) {
      var tmp;
      if (element.outerHTML) {
        return element.outerHTML;
      }
      tmp = document.createElement("div");
      tmp.appendChild(element);
      return tmp.innerHTML;
    };

    AbstractChosen.browser_is_supported = function() {
      if (/iP(od|hone)/i.test(window.navigator.userAgent)) {
        return false;
      }
      if (/Android/i.test(window.navigator.userAgent)) {
        if (/Mobile/i.test(window.navigator.userAgent)) {
          return false;
        }
      }
      if (/IEMobile/i.test(window.navigator.userAgent)) {
        return false;
      }
      if (/Windows Phone/i.test(window.navigator.userAgent)) {
        return false;
      }
      if (/BlackBerry/i.test(window.navigator.userAgent)) {
        return false;
      }
      if (/BB10/i.test(window.navigator.userAgent)) {
        return false;
      }
      if (window.navigator.appName === "Microsoft Internet Explorer") {
        return document.documentMode >= 8;
      }
      return true;
    };

    AbstractChosen.default_multiple_text = "Select Some Options";

    AbstractChosen.default_single_text = "Select an Option";

    AbstractChosen.default_no_result_text = "No results match";

    return AbstractChosen;

  })();

  $ = jQuery;

  $.fn.extend({
    chosen: function(options) {
      if (!AbstractChosen.browser_is_supported()) {
        return this;
      }
      return this.each(function(input_field) {
        var $this, chosen;
        $this = $(this);
        chosen = $this.data('chosen');
        if (options === 'destroy') {
          if (chosen instanceof Chosen) {
            chosen.destroy();
          }
          return;
        }
        if (!(chosen instanceof Chosen)) {
          $this.data('chosen', new Chosen(this, options));
        }
      });
    }
  });

  Chosen = (function(_super) {
    __extends(Chosen, _super);

    function Chosen() {
      _ref = Chosen.__super__.constructor.apply(this, arguments);
      return _ref;
    }

    Chosen.prototype.setup = function() {
      this.form_field_jq = $(this.form_field);
      this.current_selectedIndex = this.form_field.selectedIndex;
      return this.is_rtl = this.form_field_jq.hasClass("chosen-rtl");
    };

    Chosen.prototype.set_up_html = function() {
      var container_classes, container_props;
      container_classes = ["chosen-container"];
      container_classes.push("chosen-container-" + (this.is_multiple ? "multi" : "single"));
      if (this.inherit_select_classes && this.form_field.className) {
        container_classes.push(this.form_field.className);
      }
      if (this.is_rtl) {
        container_classes.push("chosen-rtl");
      }
      container_props = {
        'class': container_classes.join(' '),
        'style': "width: " + (this.container_width()) + ";",
        'title': this.form_field.title
      };
      if (this.form_field.id.length) {
        container_props.id = this.form_field.id.replace(/[^\w]/g, '_') + "_chosen";
      }
      this.container = $("<div />", container_props);
      if (this.is_multiple) {
        this.container.html('<ul class="chosen-choices"><li class="search-field"><input type="text" value="' + this.default_text + '" class="default" autocomplete="off" style="width:25px;" /></li></ul><div class="chosen-drop"><ul class="chosen-results"></ul></div>');
      } else {
        this.container.html('<a class="chosen-single chosen-default"><span>' + this.default_text + '</span><div><b></b></div></a><div class="chosen-drop"><div class="chosen-search"><input type="text" autocomplete="off" /></div><ul class="chosen-results"></ul></div>');
      }
      this.form_field_jq.hide().after(this.container);
      this.dropdown = this.container.find('div.chosen-drop').first();
      this.search_field = this.container.find('input').first();
      this.search_results = this.container.find('ul.chosen-results').first();
      this.search_field_scale();
      this.search_no_results = this.container.find('li.no-results').first();
      if (this.is_multiple) {
        this.search_choices = this.container.find('ul.chosen-choices').first();
        this.search_container = this.container.find('li.search-field').first();
      } else {
        this.search_container = this.container.find('div.chosen-search').first();
        this.selected_item = this.container.find('.chosen-single').first();
      }
      this.results_build();
      this.set_tab_index();
      return this.set_label_behavior();
    };

    Chosen.prototype.on_ready = function() {
      return this.form_field_jq.trigger("chosen:ready", {
        chosen: this
      });
    };

    Chosen.prototype.register_observers = function() {
      var _this = this;
      this.container.bind('touchstart.chosen', function(evt) {
        _this.container_mousedown(evt);
        return evt.preventDefault();
      });
      this.container.bind('touchend.chosen', function(evt) {
        _this.container_mouseup(evt);
        return evt.preventDefault();
      });
      this.container.bind('mousedown.chosen', function(evt) {
        _this.container_mousedown(evt);
      });
      this.container.bind('mouseup.chosen', function(evt) {
        _this.container_mouseup(evt);
      });
      this.container.bind('mouseenter.chosen', function(evt) {
        _this.mouse_enter(evt);
      });
      this.container.bind('mouseleave.chosen', function(evt) {
        _this.mouse_leave(evt);
      });
      this.search_results.bind('mouseup.chosen', function(evt) {
        _this.search_results_mouseup(evt);
      });
      this.search_results.bind('mouseover.chosen', function(evt) {
        _this.search_results_mouseover(evt);
      });
      this.search_results.bind('mouseout.chosen', function(evt) {
        _this.search_results_mouseout(evt);
      });
      this.search_results.bind('mousewheel.chosen DOMMouseScroll.chosen', function(evt) {
        _this.search_results_mousewheel(evt);
      });
      this.search_results.bind('touchstart.chosen', function(evt) {
        _this.search_results_touchstart(evt);
      });
      this.search_results.bind('touchmove.chosen', function(evt) {
        _this.search_results_touchmove(evt);
      });
      this.search_results.bind('touchend.chosen', function(evt) {
        _this.search_results_touchend(evt);
      });
      this.form_field_jq.bind("chosen:updated.chosen", function(evt) {
        _this.results_update_field(evt);
      });
      this.form_field_jq.bind("chosen:activate.chosen", function(evt) {
        _this.activate_field(evt);
      });
      this.form_field_jq.bind("chosen:open.chosen", function(evt) {
        _this.container_mousedown(evt);
      });
      this.form_field_jq.bind("chosen:close.chosen", function(evt) {
        _this.input_blur(evt);
      });
      this.search_field.bind('blur.chosen', function(evt) {
        _this.input_blur(evt);
      });
      this.search_field.bind('keyup.chosen', function(evt) {
        _this.keyup_checker(evt);
      });
      this.search_field.bind('keydown.chosen', function(evt) {
        _this.keydown_checker(evt);
      });
      this.search_field.bind('focus.chosen', function(evt) {
        _this.input_focus(evt);
      });
      this.search_field.bind('cut.chosen', function(evt) {
        _this.clipboard_event_checker(evt);
      });
      this.search_field.bind('paste.chosen', function(evt) {
        _this.clipboard_event_checker(evt);
      });
      if (this.is_multiple) {
        return this.search_choices.bind('click.chosen', function(evt) {
          _this.choices_click(evt);
        });
      } else {
        return this.container.bind('click.chosen', function(evt) {
          evt.preventDefault();
        });
      }
    };

    Chosen.prototype.destroy = function() {
      $(this.container[0].ownerDocument).unbind("click.chosen", this.click_test_action);
      if (this.search_field[0].tabIndex) {
        this.form_field_jq[0].tabIndex = this.search_field[0].tabIndex;
      }
      this.container.remove();
      this.form_field_jq.removeData('chosen');
      return this.form_field_jq.show();
    };

    Chosen.prototype.search_field_disabled = function() {
      this.is_disabled = this.form_field_jq[0].disabled;
      if (this.is_disabled) {
        this.container.addClass('chosen-disabled');
        this.search_field[0].disabled = true;
        if (!this.is_multiple) {
          this.selected_item.unbind("focus.chosen", this.activate_action);
        }
        return this.close_field();
      } else {
        this.container.removeClass('chosen-disabled');
        this.search_field[0].disabled = false;
        if (!this.is_multiple) {
          return this.selected_item.bind("focus.chosen", this.activate_action);
        }
      }
    };

    Chosen.prototype.container_mousedown = function(evt) {
      if (!this.is_disabled) {
        if (evt && evt.type === "mousedown" && !this.results_showing) {
          evt.preventDefault();
        }
        if (!((evt != null) && ($(evt.target)).hasClass("search-choice-close"))) {
          if (!this.active_field) {
            if (this.is_multiple) {
              this.search_field.val("");
            }
            $(this.container[0].ownerDocument).bind('click.chosen', this.click_test_action);
            this.results_show();
          } else if (!this.is_multiple && evt && (($(evt.target)[0] === this.selected_item[0]) || $(evt.target).parents("a.chosen-single").length)) {
            evt.preventDefault();
            this.results_toggle();
          }
          return this.activate_field();
        }
      }
    };

    Chosen.prototype.container_mouseup = function(evt) {
      if (evt.target.nodeName === "ABBR" && !this.is_disabled) {
        return this.results_reset(evt);
      }
    };

    Chosen.prototype.search_results_mousewheel = function(evt) {
      var delta;
      if (evt.originalEvent) {
        delta = evt.originalEvent.deltaY || -evt.originalEvent.wheelDelta || evt.originalEvent.detail;
      }
      if (delta != null) {
        evt.preventDefault();
        if (evt.type === 'DOMMouseScroll') {
          delta = delta * 40;
        }
        return this.search_results.scrollTop(delta + this.search_results.scrollTop());
      }
    };

    Chosen.prototype.blur_test = function(evt) {
      if (!this.active_field && this.container.hasClass("chosen-container-active")) {
        return this.close_field();
      }
    };

    Chosen.prototype.close_field = function() {
      $(this.container[0].ownerDocument).unbind("click.chosen", this.click_test_action);
      this.active_field = false;
      this.results_hide();
      this.container.removeClass("chosen-container-active");
      this.clear_backstroke();
      this.show_search_field_default();
      return this.search_field_scale();
    };

    Chosen.prototype.activate_field = function() {
      this.container.addClass("chosen-container-active");
      this.active_field = true;
      this.search_field.val(this.search_field.val());
      return this.search_field.focus();
    };

    Chosen.prototype.test_active_click = function(evt) {
      var active_container;
      active_container = $(evt.target).closest('.chosen-container');
      if (active_container.length && this.container[0] === active_container[0]) {
        return this.active_field = true;
      } else {
        return this.close_field();
      }
    };

    Chosen.prototype.results_build = function() {
      this.parsing = true;
      this.selected_option_count = null;
      this.results_data = SelectParser.select_to_array(this.form_field);
      if (this.is_multiple) {
        this.search_choices.find("li.search-choice").remove();
      } else if (!this.is_multiple) {
        this.single_set_selected_text();
        if (this.disable_search || this.form_field.options.length <= this.disable_search_threshold) {
          this.search_field[0].readOnly = true;
          this.container.addClass("chosen-container-single-nosearch");
        } else {
          this.search_field[0].readOnly = false;
          this.container.removeClass("chosen-container-single-nosearch");
        }
      }
      this.update_results_content(this.results_option_build({
        first: true
      }));
      this.search_field_disabled();
      this.show_search_field_default();
      this.search_field_scale();
      return this.parsing = false;
    };

    Chosen.prototype.result_do_highlight = function(el) {
      var high_bottom, high_top, maxHeight, visible_bottom, visible_top;
      if (el.length) {
        this.result_clear_highlight();
        this.result_highlight = el;
        this.result_highlight.addClass("highlighted");
        maxHeight = parseInt(this.search_results.css("maxHeight"), 10);
        visible_top = this.search_results.scrollTop();
        visible_bottom = maxHeight + visible_top;
        high_top = this.result_highlight.position().top + this.search_results.scrollTop();
        high_bottom = high_top + this.result_highlight.outerHeight();
        if (high_bottom >= visible_bottom) {
          return this.search_results.scrollTop((high_bottom - maxHeight) > 0 ? high_bottom - maxHeight : 0);
        } else if (high_top < visible_top) {
          return this.search_results.scrollTop(high_top);
        }
      }
    };

    Chosen.prototype.result_clear_highlight = function() {
      if (this.result_highlight) {
        this.result_highlight.removeClass("highlighted");
      }
      return this.result_highlight = null;
    };

    Chosen.prototype.results_show = function() {
      if (this.is_multiple && this.max_selected_options <= this.choices_count()) {
        this.form_field_jq.trigger("chosen:maxselected", {
          chosen: this
        });
        return false;
      }
      this.container.addClass("chosen-with-drop");
      this.results_showing = true;
      this.search_field.focus();
      this.search_field.val(this.search_field.val());
      this.winnow_results();
      return this.form_field_jq.trigger("chosen:showing_dropdown", {
        chosen: this
      });
    };

    Chosen.prototype.update_results_content = function(content) {
      return this.search_results.html(content);
    };

    Chosen.prototype.results_hide = function() {
      if (this.results_showing) {
        this.result_clear_highlight();
        this.container.removeClass("chosen-with-drop");
        this.form_field_jq.trigger("chosen:hiding_dropdown", {
          chosen: this
        });
      }
      return this.results_showing = false;
    };

    Chosen.prototype.set_tab_index = function(el) {
      var ti;
      if (this.form_field.tabIndex) {
        ti = this.form_field.tabIndex;
        this.form_field.tabIndex = -1;
        return this.search_field[0].tabIndex = ti;
      }
    };

    Chosen.prototype.set_label_behavior = function() {
      var _this = this;
      this.form_field_label = this.form_field_jq.parents("label");
      if (!this.form_field_label.length && this.form_field.id.length) {
        this.form_field_label = $("label[for='" + this.form_field.id + "']");
      }
      if (this.form_field_label.length > 0) {
        return this.form_field_label.bind('click.chosen', function(evt) {
          if (_this.is_multiple) {
            return _this.container_mousedown(evt);
          } else {
            return _this.activate_field();
          }
        });
      }
    };

    Chosen.prototype.show_search_field_default = function() {
      if (this.is_multiple && this.choices_count() < 1 && !this.active_field) {
        this.search_field.val(this.default_text);
        return this.search_field.addClass("default");
      } else {
        this.search_field.val("");
        return this.search_field.removeClass("default");
      }
    };

    Chosen.prototype.search_results_mouseup = function(evt) {
      var target;
      target = $(evt.target).hasClass("active-result") ? $(evt.target) : $(evt.target).parents(".active-result").first();
      if (target.length) {
        this.result_highlight = target;
        this.result_select(evt);
        return this.search_field.focus();
      }
    };

    Chosen.prototype.search_results_mouseover = function(evt) {
      var target;
      target = $(evt.target).hasClass("active-result") ? $(evt.target) : $(evt.target).parents(".active-result").first();
      if (target) {
        return this.result_do_highlight(target);
      }
    };

    Chosen.prototype.search_results_mouseout = function(evt) {
      if ($(evt.target).hasClass("active-result" || $(evt.target).parents('.active-result').first())) {
        return this.result_clear_highlight();
      }
    };

    Chosen.prototype.choice_build = function(item) {
      var choice, close_link,
        _this = this;
      choice = $('<li />', {
        "class": "search-choice"
      }).html("<span>" + (this.choice_label(item)) + "</span>");
      if (item.disabled) {
        choice.addClass('search-choice-disabled');
      } else {
        close_link = $('<a />', {
          "class": 'search-choice-close',
          'data-option-array-index': item.array_index
        });
        close_link.bind('click.chosen', function(evt) {
          return _this.choice_destroy_link_click(evt);
        });
        choice.append(close_link);
      }
      return this.search_container.before(choice);
    };

    Chosen.prototype.choice_destroy_link_click = function(evt) {
      evt.preventDefault();
      evt.stopPropagation();
      if (!this.is_disabled) {
        return this.choice_destroy($(evt.target));
      }
    };

    Chosen.prototype.choice_destroy = function(link) {
      if (this.result_deselect(link[0].getAttribute("data-option-array-index"))) {
        this.show_search_field_default();
        if (this.is_multiple && this.choices_count() > 0 && this.search_field.val().length < 1) {
          this.results_hide();
        }
        link.parents('li').first().remove();
        return this.search_field_scale();
      }
    };

    Chosen.prototype.results_reset = function() {
      this.reset_single_select_options();
      this.form_field.options[0].selected = true;
      this.single_set_selected_text();
      this.show_search_field_default();
      this.results_reset_cleanup();
      this.form_field_jq.trigger("change");
      if (this.active_field) {
        return this.results_hide();
      }
    };

    Chosen.prototype.results_reset_cleanup = function() {
      this.current_selectedIndex = this.form_field.selectedIndex;
      return this.selected_item.find("abbr").remove();
    };

    Chosen.prototype.result_select = function(evt) {
      var high, item;
      if (this.result_highlight) {
        high = this.result_highlight;
        this.result_clear_highlight();
        if (this.is_multiple && this.max_selected_options <= this.choices_count()) {
          this.form_field_jq.trigger("chosen:maxselected", {
            chosen: this
          });
          return false;
        }
        if (this.is_multiple) {
          high.removeClass("active-result");
        } else {
          this.reset_single_select_options();
        }
        high.addClass("result-selected");
        item = this.results_data[high[0].getAttribute("data-option-array-index")];
        item.selected = true;
        this.form_field.options[item.options_index].selected = true;
        this.selected_option_count = null;
        if (this.is_multiple) {
          this.choice_build(item);
        } else {
          this.single_set_selected_text(this.choice_label(item));
        }
        if (!((evt.metaKey || evt.ctrlKey) && this.is_multiple)) {
          this.results_hide();
        }
        this.show_search_field_default();
        if (this.is_multiple || this.form_field.selectedIndex !== this.current_selectedIndex) {
          this.form_field_jq.trigger("change", {
            'selected': this.form_field.options[item.options_index].value
          });
        }
        this.current_selectedIndex = this.form_field.selectedIndex;
        evt.preventDefault();
        return this.search_field_scale();
      }
    };

    Chosen.prototype.single_set_selected_text = function(text) {
      if (text == null) {
        text = this.default_text;
      }
      if (text === this.default_text) {
        this.selected_item.addClass("chosen-default");
      } else {
        this.single_deselect_control_build();
        this.selected_item.removeClass("chosen-default");
      }
      return this.selected_item.find("span").html(text);
    };

    Chosen.prototype.result_deselect = function(pos) {
      var result_data;
      result_data = this.results_data[pos];
      if (!this.form_field.options[result_data.options_index].disabled) {
        result_data.selected = false;
        this.form_field.options[result_data.options_index].selected = false;
        this.selected_option_count = null;
        this.result_clear_highlight();
        if (this.results_showing) {
          this.winnow_results();
        }
        this.form_field_jq.trigger("change", {
          deselected: this.form_field.options[result_data.options_index].value
        });
        this.search_field_scale();
        return true;
      } else {
        return false;
      }
    };

    Chosen.prototype.single_deselect_control_build = function() {
      if (!this.allow_single_deselect) {
        return;
      }
      if (!this.selected_item.find("abbr").length) {
        this.selected_item.find("span").first().after("<abbr class=\"search-choice-close\"></abbr>");
      }
      return this.selected_item.addClass("chosen-single-with-deselect");
    };

    Chosen.prototype.get_search_text = function() {
      return $('<div/>').text($.trim(this.search_field.val())).html();
    };

    Chosen.prototype.winnow_results_set_highlight = function() {
      var do_high, selected_results;
      selected_results = !this.is_multiple ? this.search_results.find(".result-selected.active-result") : [];
      do_high = selected_results.length ? selected_results.first() : this.search_results.find(".active-result").first();
      if (do_high != null) {
        return this.result_do_highlight(do_high);
      }
    };

    Chosen.prototype.no_results = function(terms) {
      var no_results_html;
      no_results_html = $('<li class="no-results">' + this.results_none_found + ' "<span></span>"</li>');
      no_results_html.find("span").first().html(terms);
      this.search_results.append(no_results_html);
      return this.form_field_jq.trigger("chosen:no_results", {
        chosen: this
      });
    };

    Chosen.prototype.no_results_clear = function() {
      return this.search_results.find(".no-results").remove();
    };

    Chosen.prototype.keydown_arrow = function() {
      var next_sib;
      if (this.results_showing && this.result_highlight) {
        next_sib = this.result_highlight.nextAll("li.active-result").first();
        if (next_sib) {
          return this.result_do_highlight(next_sib);
        }
      } else {
        return this.results_show();
      }
    };

    Chosen.prototype.keyup_arrow = function() {
      var prev_sibs;
      if (!this.results_showing && !this.is_multiple) {
        return this.results_show();
      } else if (this.result_highlight) {
        prev_sibs = this.result_highlight.prevAll("li.active-result");
        if (prev_sibs.length) {
          return this.result_do_highlight(prev_sibs.first());
        } else {
          if (this.choices_count() > 0) {
            this.results_hide();
          }
          return this.result_clear_highlight();
        }
      }
    };

    Chosen.prototype.keydown_backstroke = function() {
      var next_available_destroy;
      if (this.pending_backstroke) {
        this.choice_destroy(this.pending_backstroke.find("a").first());
        return this.clear_backstroke();
      } else {
        next_available_destroy = this.search_container.siblings("li.search-choice").last();
        if (next_available_destroy.length && !next_available_destroy.hasClass("search-choice-disabled")) {
          this.pending_backstroke = next_available_destroy;
          if (this.single_backstroke_delete) {
            return this.keydown_backstroke();
          } else {
            return this.pending_backstroke.addClass("search-choice-focus");
          }
        }
      }
    };

    Chosen.prototype.clear_backstroke = function() {
      if (this.pending_backstroke) {
        this.pending_backstroke.removeClass("search-choice-focus");
      }
      return this.pending_backstroke = null;
    };

    Chosen.prototype.keydown_checker = function(evt) {
      var stroke, _ref1;
      stroke = (_ref1 = evt.which) != null ? _ref1 : evt.keyCode;
      this.search_field_scale();
      if (stroke !== 8 && this.pending_backstroke) {
        this.clear_backstroke();
      }
      switch (stroke) {
        case 8:
          this.backstroke_length = this.search_field.val().length;
          break;
        case 9:
          if (this.results_showing && !this.is_multiple) {
            this.result_select(evt);
          }
          this.mouse_on_container = false;
          break;
        case 13:
          if (this.results_showing) {
            evt.preventDefault();
          }
          break;
        case 32:
          if (this.disable_search) {
            evt.preventDefault();
          }
          break;
        case 38:
          evt.preventDefault();
          this.keyup_arrow();
          break;
        case 40:
          evt.preventDefault();
          this.keydown_arrow();
          break;
      }
    };

    Chosen.prototype.search_field_scale = function() {
      var div, f_width, h, style, style_block, styles, w, _i, _len;
      if (this.is_multiple) {
        h = 0;
        w = 0;
        style_block = "position:absolute; left: -1000px; top: -1000px; display:none;";
        styles = ['font-size', 'font-style', 'font-weight', 'font-family', 'line-height', 'text-transform', 'letter-spacing'];
        for (_i = 0, _len = styles.length; _i < _len; _i++) {
          style = styles[_i];
          style_block += style + ":" + this.search_field.css(style) + ";";
        }
        div = $('<div />', {
          'style': style_block
        });
        div.text(this.search_field.val());
        $('body').append(div);
        w = div.width() + 25;
        div.remove();
        f_width = this.container.outerWidth();
        if (w > f_width - 10) {
          w = f_width - 10;
        }
        return this.search_field.css({
          'width': w + 'px'
        });
      }
    };

    return Chosen;

  })(AbstractChosen);

}).call(this);


  }).apply(root, arguments);
});
}(this));

(function(root) {
define("angular-chosen", ["angular","jquery-chosen"], function() {
  return (function() {
/**
 * angular-chosen-localytics - Angular Chosen directive is an AngularJS Directive that brings the Chosen jQuery in a Angular way
 * @version v1.3.0
 * @link http://github.com/leocaseiro/angular-chosen
 * @license MIT
 */
(function() {
  var indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  angular.module('localytics.directives', []);

  angular.module('localytics.directives').directive('chosen', [
    '$timeout', function($timeout) {
      var CHOSEN_OPTION_WHITELIST, NG_OPTIONS_REGEXP, isEmpty, snakeCase;
      NG_OPTIONS_REGEXP = /^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+group\s+by\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w]*)|(?:\(\s*([\$\w][\$\w]*)\s*,\s*([\$\w][\$\w]*)\s*\)))\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?$/;
      CHOSEN_OPTION_WHITELIST = ['persistentCreateOption', 'createOptionText', 'createOption', 'skipNoResults', 'noResultsText', 'allowSingleDeselect', 'disableSearchThreshold', 'disableSearch', 'enableSplitWordSearch', 'inheritSelectClasses', 'maxSelectedOptions', 'placeholderTextMultiple', 'placeholderTextSingle', 'searchContains', 'singleBackstrokeDelete', 'displayDisabledOptions', 'displaySelectedOptions', 'width', 'includeGroupLabelInSelected', 'maxShownResults'];
      snakeCase = function(input) {
        return input.replace(/[A-Z]/g, function($1) {
          return "_" + ($1.toLowerCase());
        });
      };
      isEmpty = function(value) {
        var key;
        if (angular.isArray(value)) {
          return value.length === 0;
        } else if (angular.isObject(value)) {
          for (key in value) {
            if (value.hasOwnProperty(key)) {
              return false;
            }
          }
        }
        return true;
      };
      return {
        restrict: 'A',
        require: '?ngModel',
        priority: 1,
        link: function(scope, element, attr, ngModel) {
          var chosen, empty, initOrUpdate, match, options, origRender, startLoading, stopLoading, updateMessage, valuesExpr, viewWatch;
          scope.disabledValuesHistory = scope.disabledValuesHistory ? scope.disabledValuesHistory : [];
          element = $(element);
          element.addClass('localytics-chosen');
          options = scope.$eval(attr.chosen) || {};
          angular.forEach(attr, function(value, key) {
            if (indexOf.call(CHOSEN_OPTION_WHITELIST, key) >= 0) {
              return attr.$observe(key, function(value) {
                options[snakeCase(key)] = String(element.attr(attr.$attr[key])).slice(0, 2) === '{{' ? value : scope.$eval(value);
                return updateMessage();
              });
            }
          });
          startLoading = function() {
            return element.addClass('loading').attr('disabled', true).trigger('chosen:updated');
          };
          stopLoading = function() {
            element.removeClass('loading');
            if (angular.isDefined(attr.disabled)) {
              element.attr('disabled', attr.disabled);
            } else {
              element.attr('disabled', false);
            }
            return element.trigger('chosen:updated');
          };
          chosen = null;
          empty = false;
          initOrUpdate = function() {
            var defaultText;
            if (chosen) {
              return element.trigger('chosen:updated');
            } else {
              $timeout(function() {
                chosen = element.chosen(options).data('chosen');
              });
              if (angular.isObject(chosen)) {
                return defaultText = chosen.default_text;
              }
            }
          };
          updateMessage = function() {
            if (empty) {
              element.attr('data-placeholder', chosen.results_none_found).attr('disabled', true);
            } else {
              element.removeAttr('data-placeholder');
            }
            return element.trigger('chosen:updated');
          };
          if (ngModel) {
            origRender = ngModel.$render;
            ngModel.$render = function() {
              origRender();
              return initOrUpdate();
            };
            element.on('chosen:hiding_dropdown', function() {
              return scope.$apply(function() {
                return ngModel.$setTouched();
              });
            });
            if (attr.multiple) {
              viewWatch = function() {
                return ngModel.$viewValue;
              };
              scope.$watch(viewWatch, ngModel.$render, true);
            }
          } else {
            initOrUpdate();
          }
          attr.$observe('disabled', function() {
            return element.trigger('chosen:updated');
          });
          if (attr.ngOptions && ngModel) {
            match = attr.ngOptions.match(NG_OPTIONS_REGEXP);
            valuesExpr = match[7];
            scope.$watchCollection(valuesExpr, function(newVal, oldVal) {
              var timer;
              return timer = $timeout(function() {
                if (angular.isUndefined(newVal)) {
                  return startLoading();
                } else {
                  empty = isEmpty(newVal);
                  stopLoading();
                  return updateMessage();
                }
              });
            });
            return scope.$on('$destroy', function(event) {
              if (typeof timer !== "undefined" && timer !== null) {
                return $timeout.cancel(timer);
              }
            });
          }
        }
      };
    }
  ]);

}).call(this);


  }).apply(root, arguments);
});
}(this));

/*
# passenger/services/zones.js                                     Copyright(c) 2020 cPanel, L.L.C.
#                                                                           All rights reserved.
# copyright@cpanel.net                                                         http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited
*/

/* global define: false */

define(
    'app/services/apps',[
        "angular",
        "jquery",
        "lodash",
        "cjt/util/locale",
        "cjt/util/parse",
        "cjt/io/api",
        "cjt/io/uapi-request",
        "cjt/io/uapi"
    ],
    function(angular, $, _, LOCALE, PARSE, API, UAPIREQUEST, UAPIDRIVER) {
        "use strict";

        var app = angular.module("cpanel.applicationManager.appsService", []);
        app.value("defaultInfo", PAGE);
        var factory = app.factory("Apps", ["$q", "defaultInfo", function($q, defaultInfo) {

            var store = {};

            store.applications = [];

            store.homedir_regex = new RegExp("^(?:" + defaultInfo.homedir + ")/?");

            store.has_support_for_env_vars = PARSE.parsePerlBoolean(defaultInfo.has_mod_env);

            store.max_number_of_apps = Number(defaultInfo.max_passenger_apps);

            store.get_maximum_number_of_apps = function() {
                return store.max_number_of_apps;
            };

            store.exceeds_quota = function() {
                return store.applications.length >= store.max_number_of_apps;
            };

            store.get_default_application = function() {
                var new_appl = {};

                new_appl.name = "";
                new_appl.path = "";
                new_appl.enabled = true;
                new_appl.domain = "";
                new_appl.base_uri = "/";
                new_appl.deployment_mode = "production";
                if (store.has_support_for_env_vars) {
                    new_appl.envvars = {};
                }

                return new_appl;
            };

            /**
             * Add an application based on the type.
             * @param appl - the application object we are sending. the fields in the object
             *                  depend on the type of record.
             * @return Promise
             */
            store.add_application = function(appl) {
                var apiCall = new UAPIREQUEST.Class();
                apiCall.initialize("PassengerApps", "register_application");
                apiCall.addArgument("name", appl.name);
                apiCall.addArgument("path", appl.path);
                apiCall.addArgument("deployment_mode", appl.deployment_mode);
                apiCall.addArgument("domain", appl.domain);
                apiCall.addArgument("base_uri", appl.base_uri);

                if (store.has_support_for_env_vars) {
                    var envvar_index = 1;

                    _.forEach(appl.envvars, function(value, key) {
                        apiCall.addArgument("envvar_name-" + envvar_index, key);
                        apiCall.addArgument("envvar_value-" + envvar_index, value);
                        envvar_index++;
                    });
                }

                apiCall.addArgument("enabled", appl.enabled ? 1 : 0);

                return $q.when(API.promise(apiCall.getRunArguments()))
                    .then(function(response) {
                        response = response.parsedResponse;
                        if (response.status) {
                            var obj = store.strip_homedirs_and_convert_enabled(response.data);
                            store.applications.push(obj);
                            return obj;
                        } else {
                            return $q.reject(response.error);
                        }
                    }, function(response) {
                        if (!response.status) {
                            return $q.reject(response.error);
                        }
                    });
            };

            store.update_application = function(appl, previous_name) {
                var apiCall = new UAPIREQUEST.Class();
                _.defaults(appl, { name: "" }, { path: "" }, { base_uri: "/" });
                apiCall.initialize("PassengerApps", "edit_application");

                if (appl.name !== previous_name) {
                    apiCall.addArgument("name", previous_name);
                    apiCall.addArgument("new_name", appl.name);
                } else {
                    apiCall.addArgument("name", appl.name);
                }

                apiCall.addArgument("path", appl.path);
                apiCall.addArgument("base_uri", appl.base_uri);
                apiCall.addArgument("domain", appl.domain);
                apiCall.addArgument("deployment_mode", appl.deployment_mode);
                if (store.has_support_for_env_vars) {
                    var envvar_count = _.size(appl.envvars);
                    if (envvar_count === 0) {
                        apiCall.addArgument("clear_envvars", 1);
                    } else {
                        var envvar_index = 0;

                        _.forEach(appl.envvars, function(value, key) {
                            envvar_index++;
                            apiCall.addArgument("envvar_name-" + envvar_index, key);
                            apiCall.addArgument("envvar_value-" + envvar_index, value);
                        });
                    }
                }

                apiCall.addArgument("enabled", appl.enabled ? 1 : 0);

                return $q.when(API.promise(apiCall.getRunArguments()))
                    .then(function(response) {
                        response = response.parsedResponse;
                        if (response.status) {

                            // update the applications array with the new information
                            var app_to_update = store.get_application_index(previous_name);
                            var obj = store.strip_homedirs_and_convert_enabled(response.data);
                            if (response.data.name !== previous_name) {
                                if (app_to_update >= 0) {
                                    store.applications.splice(app_to_update, 1);
                                    store.applications.push(obj);
                                }
                            } else {
                                store.applications[app_to_update] = obj;
                            }
                            return obj;
                        } else {
                            return $q.reject(response.error);
                        }
                    }, function(response) {
                        return $q.reject(response.error);
                    });
            };

            store.strip_homedir_from_path = function(obj) {
                if (obj.path) {
                    obj.path = obj.path.replace(store.homedir_regex, "");
                }
                return obj;
            };

            store.strip_homedirs_and_convert_enabled = function(to_convert) {
                var temp = to_convert;
                if (!Array.isArray(to_convert)) {
                    temp = [to_convert];
                }

                for (var i = 0, len = temp.length; i < len; i++) {
                    temp[i] = store.strip_homedir_from_path(temp[i]);
                    temp[i].enabled = PARSE.parsePerlBoolean(temp[i].enabled);
                }

                if (!Array.isArray(to_convert)) {
                    return temp[0];
                } else {
                    return temp;
                }
            };

            store.fetch = function(force) {
                if (store.applications.length === 0 || force) {
                    var apiCall = new UAPIREQUEST.Class();
                    apiCall.initialize("PassengerApps", "list_applications");

                    return $q.when(API.promise(apiCall.getRunArguments()))
                        .then(function(response) {
                            response = response.parsedResponse;
                            if (response.status) {
                                store.applications = _.values(response.data);
                                store.applications = store.strip_homedirs_and_convert_enabled(store.applications);
                                return store.applications;
                            } else {
                                return $q.reject(response.error);
                            }
                        });
                } else {
                    return $q.when(store.applications);
                }
            };

            store.get_application_index = function(appl_name) {
                return _.findIndex( store.applications, function(element) {
                    return appl_name === element.name;
                });
            };

            store.find_application = function(appl) {
                var app_index = store.get_application_index(appl.name);

                if (app_index >= 0) {
                    return store.applications[app_index];
                }

                return null;
            };

            store.get_application_by_name = function(appl_name) {
                return store.fetch()
                    .then(function(data) {
                        var app_index = store.get_application_index(appl_name);

                        if (app_index > -1) {
                            return data[app_index];
                        } else {
                            return null;
                        }
                    });
            };

            store.toggle_application_status = function(appl) {
                var apiCall = new UAPIREQUEST.Class();
                if (appl.enabled) {
                    apiCall.initialize("PassengerApps", "disable_application");
                } else {
                    apiCall.initialize("PassengerApps", "enable_application");
                }

                apiCall.addArgument("name", appl.name);

                return $q.when(API.promise(apiCall.getRunArguments()))
                    .then(function(response) {
                        response = response.parsedResponse;
                        if (response.status) {
                            var app_index = store.get_application_index(appl.name);
                            store.applications[app_index].enabled = !appl.enabled;
                            return store.applications[app_index];
                        } else {
                            return $q.reject(response.error);
                        }
                    }, function(response) {
                        return $q.reject(response.error);
                    });
            };

            /**
             * Remove an application
             * @param application - the application to remove
             * @return Promise
             */
            store.remove_application = function(appl_name) {
                var apiCall = new UAPIREQUEST.Class();
                apiCall.initialize("PassengerApps", "unregister_application");
                apiCall.addArgument("name", appl_name);

                return $q.when(API.promise(apiCall.getRunArguments()))
                    .then(function(response) {
                        response = response.parsedResponse;
                        if (response.status) {
                            var app_index = store.get_application_index(appl_name);
                            store.applications.splice(app_index, 1);
                        } else {
                            return $q.reject(response.error);
                        }
                    }, function(response) {
                        return $q.reject(response.error);
                    });
            };

            store.ensureDependencies = function(appType, appPath) {
                var apiCall = new UAPIREQUEST.Class();
                apiCall.initialize("PassengerApps", "ensure_deps");
                apiCall.addArgument("type", appType);
                apiCall.addArgument("app_path", appPath);

                return $q.when(API.promise(apiCall.getRunArguments()))
                    .then(function(response) {
                        response = response.parsedResponse;
                        if (response.status) {
                            return response;
                        } else {
                            return $q.reject(response.error);
                        }
                    }, function(response) {
                        return $q.reject(response.error);
                    });
            };

            return store;
        }]);

        return factory;
    }
);

/*
# passenger/services/domains.js                 Copyright(c) 2020 cPanel, L.L.C.
#                                                           All rights reserved.
# copyright@cpanel.net                                         http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited
*/

/* global define: false */

define(
    'app/services/domains',[
        "angular",
        "jquery",
        "lodash",
        "cjt/util/locale",
        "cjt/io/api",
        "cjt/io/api2-request",
        "cjt/io/api2",
        "cjt/util/httpStatus",
        "cjt/core",
        "cjt/services/APIService"
    ],
    function(angular, $, _, LOCALE, API, APIREQUEST, APIDRIVER, HTTP_STATUS, CJT) {

        var app = angular.module("cpanel.applicationManager");
        var factory = app.factory(
            "Domains",
            ["$q", "defaultInfo", "APIService", function($q, defaultInfo, APIService) {

                var types = {
                    "addon_domains": LOCALE.maketext("Addon Domains"),
                    "main_domain": LOCALE.maketext("Main Domain"),
                    "sub_domains": LOCALE.maketext("Subdomains")
                };

                function determine_group(type) {
                    if (types[type]) {
                        return types[type];
                    } else {
                        return LOCALE.maketext("Other");
                    }
                }

                function massage_data(data) {
                    var formatted_data = [];

                    for (var j = 0, keys = _.keys(data).sort(), key_len = keys.length; j < key_len; j++) {
                        var category = keys[j];
                        if (category === "cp_php_magic_include_path.conf" || category === "parked_domains") {
                            continue;
                        }

                        if (!_.isArray(data[category])) {
                            formatted_data.push({
                                "domain": data[category],
                                "type": determine_group(category)
                            });
                        } else {
                            var temp_array = [];
                            for (var i = 0, len = data[category].length; i < len; i++) {
                                temp_array.push({
                                    "domain": data[category][i],
                                    "type": determine_group(category)
                                });
                            }
                            formatted_data = formatted_data.concat(_.sortBy(temp_array, ["domain"]));
                        }
                    }

                    return formatted_data;
                }

                var DomainsService = function() {};
                DomainsService.prototype = new APIService();
                DomainsService.domains = [];

                angular.extend(DomainsService.prototype, {
                    fetch: function() {
                        if (this.domains.length === 0) {
                            var apiCall = new APIREQUEST.Class();
                            apiCall.initialize("DomainInfo", "list_domains");

                            var deferred = this.deferred(apiCall, {
                                transformAPISuccess: function(response) {
                                    this.domains = massage_data(response.data);
                                    return this.domains;
                                }
                            });
                            return deferred.promise;
                        } else {
                            return $q.when(this.domains);
                        }
                    },

                    init: function() {
                        this.domains = massage_data(defaultInfo.domains);
                    }

                });


                var service = new DomainsService();
                service.init();

                return service;
            }]);

        return factory;
    }
);

/*
 * services/sseApiService.js                            Copyright 2022 cPanel, L.L.C.
 *                                                           All rights reserved.
 * copyright@cpanel.net                                         http://cpanel.net
 * This code is subject to the cPanel license. Unauthorized copying is prohibited
 */

/* global define: false */

define('app/services/sseAPIService',[
    "angular",
    "cjt/core",
    "lodash",
], function(
        angular,
        CJT,
        _
    ) {
    "use strict";

    var app = angular.module("cpanel.applicationManager.sseAPIService", []);

    app.factory("sseAPIService", [
        "$rootScope",
        function(
            $rootScope
        ) {

            /**
             * Format the data based on the configuration requested.
             * Currently only has the option to convert from string to JSON if config.json is true.
             *
             * @param  {Object} config - SSE configuration
             * @param  {String} data
             * @return {Any}
             */
            var _formatData = function(config, data) {
                if (config && config.json && data) {
                    data = JSON.parse(data);
                }
                return data;
            };

            /**
             * Custom event sent when JSON parsing is requested but fails for some reason.
             *
             * @event sse:<eventName>:error
             * @property {Object} data
             *   @property {String} data.error - Error message from the JSON parser.
             *   @property {String} data.data  - Data passed with the message that could not be parsed.
             */

            /**
             * Custom event sent.
             *
             * @event sse:<eventName>
             * @property {Object} data
             */

            /**
             * Send a format error if the parsing fails
             *
             * @param {String} eventName
             * @param {String} exception
             * @param {String} data
             * @fires sse:<evenName>:error
             */
            var _sendFormatErrorEvent = function(eventName, exception, data) {
                $rootScope.$broadcast(
                    "sse:" + eventName + ":error",
                    {
                        data: data,
                        error: exception
                    }
                );
            };

            /**
             * Create a message event handler callback. The callback will annotate the event with
             * a eventName field and will generated an angularjs event with the following name:
             *
             *   sse:<eventName>
             *
             * If a data element is available it will send the data along with the event in the
             * data field.
             *
             *
             * @param  {String} eventName The name of the event.
             * @param  {Object} config configuration
             * @return {Function}
             */
            var makeHandler = function(eventName, config) {
                return function(e) {
                    e.eventName = eventName;
                    var data = e.data;
                    try {
                        data = _formatData(config, data);
                    } catch (exception) {
                        _sendFormatErrorEvent(eventName, exception, data);
                        return;
                    }

                    $rootScope.$broadcast("sse:" + eventName, data);
                };
            };

            /**
             * Fired when the sse process is done.
             *
             * @event sse:done
             */

            /**
             * Fired when sse generated an error.
             *
             * @event sse:error
             */

            /**
             * Fired when the sse is running and the page is being unloaded.
             *
             * @event sse:beforeunload
             */

            /**
             * Connect the specified SSE url fire an angular event for the requested events.
             *
             * @param {String} url - url to connect to the sse event source.
             * @param {Array[String]} [events]  - array of additional events to register.
             * @param {Object}        [config]  - optional configuration options
             *   @param {Boolean} [config.json] - if true, will parse the e.data as json. otherwise, just returns the data to the caller as is.
             * @fires sse:beforeunload, sse:error, sse:done, sse:*
             */
            var connect = function connect(url, events, config) {

                if (!events) {
                    events = [];
                }

                var sseConfig = config || {};

                var sse = new EventSource(url);

                // Setup known events
                if (events) {
                    events.forEach(function(event) {
                        sse.addEventListener(event, makeHandler(event, sseConfig));
                    });
                }

                // Setup the error event handler
                sse.onerror = function(e) {
                    $rootScope.$broadcast("sse:error", e);
                };

                // Setup the beforeunload event handler
                window.addEventListener("beforeunload", function(e) {
                    if (sse) {
                        sse.close();
                        sse = null;
                        $rootScope.$broadcast("sse:beforeunload", e);
                    }
                });

                return sse;
            };

            /**
             * Fired when the sse polyfill is loaded when needed. It will fire both
             * when the polyfill is needed and finished loading and when the polyfill
             * is not needed.
             *
             * @event sse:ready
             */

            /**
             * Initialize the SSE resources
             *
             * @param {Function} [ready] Optional callback to call when the sse is ready to run.
             * @fires sse:ready
             */
            var initialize = function initialize(ready) {

                // Microsoft browsers (including Edge)
                // don’t support SSE as of November 2017.
                // https://developer.microsoft.com/en-us/microsoft-edge/platform/status/serversenteventseventsource/
                if (!window.EventSource) {
                    var script = document.createElement("script");
                    script.src = CJT.buildFullPath("libraries/eventsource-polyfill/eventsource.js");
                    script.onload = function() {
                        if (ready) {
                            ready();
                        }
                        $rootScope.$broadcast("sse:ready");
                    };
                    document.body.appendChild(script);
                } else {
                    if (ready) {
                        ready();
                    }
                    $rootScope.$broadcast("sse:ready");
                }
            };

            /**
             * Close the sse connection and clean up the sseApi state.
             *
             * @param {Object} SSE object
             */
            var close = function(sse) {
                if (sse) {
                    sse.close();
                }
            };

            return {
                initialize: initialize,
                connect: connect,
                close: close
            };
        }
    ]);
});

/*
# passenger/views/manage.js                        Copyright 2022 cPanel, L.L.C.
#                                                           All rights reserved.
# copyright@cpanel.net                                         http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited
*/

/* global define: false */

/* eslint-disable camelcase */

define(
    'app/views/manage',[
        "angular",
        "lodash",
        "cjt/util/locale",
        "cjt/util/table",
        "cjt/util/parse",
        "cjt/directives/actionButtonDirective",
        "cjt/decorators/paginationDecorator",
        "cjt/directives/toggleSortDirective",
        "cjt/directives/searchDirective",
        "cjt/directives/pageSizeDirective",
        "cjt/directives/alertList",
        "cjt/services/alertService",
        "cjt/services/viewNavigationApi",
        "cjt/directives/quickFiltersDirective",
        "app/services/sseAPIService",
        "uiBootstrap",
    ],
    function(angular, _, LOCALE, Table, PARSE) {
        "use strict";

        var app = angular.module("cpanel.applicationManager");
        app.value("PAGE", PAGE);
        var controller = app.controller(
            "ManageApplicationsController",
            [
                "$scope",
                "$routeParams",
                "viewNavigationApi",
                "$uibModal",
                "Apps",
                "defaultInfo",
                "alertService",
                "sseAPIService",
                "PAGE",
                "$timeout",
                function(
                    $scope,
                    $routeParams,
                    viewNavigationApi,
                    $uibModal,
                    Apps,
                    defaultInfo,
                    alertService,
                    sseAPIService,
                    PAGE,
                    $timeout) {
                    var manage = this;

                    manage.is_loading = false;
                    manage.applications = [];
                    manage.loading_error = false;
                    manage.loading_error_message = "";
                    manage.user_home_dir = defaultInfo.homedir;
                    manage.change_in_progress = false;
                    manage.ensureDepList = [];

                    manage.secTokenPrefix = PAGE.securityToken; // Initialize with security token.
                    manage.sseObj = null;

                    // SSE events and config
                    var events = ["task_processing", "task_complete", "task_failed"];
                    var sseConfig = { json: true };

                    var table = new Table();

                    function searchByName(item, searchText) {
                        return item.name.indexOf(searchText) !== -1;
                    }
                    function searchByType(item, type) {
                        return item.type === type;
                    }

                    table.setSearchFunction(searchByName);
                    table.setFilterOptionFunction(searchByType);

                    manage.meta = table.getMetadata();
                    manage.filteredList = table.getList();
                    manage.paginationMessage = table.paginationMessage;
                    manage.render = function() {
                        manage.filteredList = table.update();
                    };
                    manage.sortList = function() {
                        manage.render();
                    };
                    manage.selectPage = function() {
                        manage.render();
                    };
                    manage.selectPageSize = function() {
                        manage.render();
                    };
                    manage.searchList = function() {
                        manage.render();
                    };

                    manage.quota_warning = function() {
                        return LOCALE.maketext("You can’t have more than [numf,_1] applications on your account.", Apps.get_maximum_number_of_apps());
                    };

                    manage.show_quota_warning = function() {
                        return Apps.exceeds_quota();
                    };

                    manage.dependenciesExist = function(appl) {
                        var exist = false;
                        if (appl) {
                            var deps = appl.deps;
                            exist = _.some(deps, function(key) {
                                if (key) {
                                    return true;
                                }
                            });
                        }
                        return exist;
                    };

                    /**
                     * Resets ensure deps state of application
                     * @method ensureDependencies
                     * @param {Object} app application object
                     * @returns {Object} Promise
                     */
                    manage.ensureDependencies = function(app) {
                        var types = _.keys(app.deps);
                        _.each(types, function(type) {
                            if (app.deps[type]) {
                                return Apps.ensureDependencies(type, app.path)
                                    .then(function(res) {
                                        var sseUrl = res.data.sse_url;
                                        var ensureStarted = true;
                                        app.ensureInProgress = ensureStarted;
                                        app.showEnsureView = ensureStarted;
                                        if (app.ensureDeps) {
                                            app.ensureDeps[type] = {
                                                taskId: res.data.task_id,
                                                inProgress: ensureStarted,
                                            };
                                        }

                                        if (!manage.sseURL && !manage.sseObj) {
                                            manage.sseURL = manage.secTokenPrefix + sseUrl;
                                            sseAPIService.initialize();
                                        }

                                        manage.ensureDepList.push(app);
                                    })
                                    .catch(function(error) {
                                        alertService.add({
                                            type: "danger",
                                            message: error,
                                            closeable: true,
                                            replace: false,
                                            group: "passenger",
                                        });
                                    });
                            }
                        });
                    };

                    /**
                     * Resets ensure deps state of application
                     * @method resetEnsureDependencyParams
                     * @param {Object} appObject application
                     * @returns {Object} updated application object
                     */
                    function resetEnsureDependencyParams(appObject) {
                        if (appObject) {
                            appObject.ensureDeps = {};
                            appObject.ensureState = "";
                            appObject.ensureInProgress = false;
                            appObject.showEnsureView = false;
                        }
                        return appObject;
                    }

                    /**
                     * Handles the close action of failed callout of ensure dependency.
                     * @method clearEnsureDepsTaskParams
                     * @param {Object} appObject application object
                     */
                    manage.clearEnsureDepsTaskParams = function(appObject) {
                        resetEnsureDependencyParams(appObject);
                    };

                    /**
                     * Return the appropriate message depending on application level ensure state.
                     *
                     * @method getAppLevelEnsureStateMessage
                     * @param {Object} appl application object
                     */
                    manage.getAppLevelEnsureStateMessage = function(appl) {
                        var msg = "";
                        switch (appl.ensureState) {
                            case "processing":
                                msg = LOCALE.maketext("Ensuring dependencies for your application …");
                                break;
                            case "complete":
                                msg = LOCALE.maketext("The system ensured the dependencies for your application.");
                                break;
                            case "failure":
                                msg = LOCALE.maketext("The system couldn’t ensure dependencies for your application. For more information, see the instructions below.");
                                break;
                            default:
                                msg = LOCALE.maketext("The system queued your application to ensure its dependencies …");
                                break;
                        }
                        return msg;
                    };

                    /**
                     * Determines font awesome icon to show based on individual package types' state
                     * (i.e. gem/pip/npm etc. types)
                     *
                     * @method getIconClassForEnsureState
                     * @param {String} ensureState ensure state of a package type.
                     */
                    manage.getIconClassForEnsureState = function(ensureState) {
                        var strClass = "";
                        switch (ensureState) {
                            case "complete":
                                strClass = "far fa-check-circle text-success";
                                break;
                            case "failure":
                                strClass = "fas fa-exclamation-circle text-danger";
                                break;
                            default:
                                strClass = "fas fa-spinner fa-spin";
                                break;
                        }
                        return strClass;
                    };

                    /**
                     * Retrieves the application object that owns the task given the task id.
                     *
                     * @method getTaskOwner
                     * @param {String} taskId the task id of the package type that is being ensured.
                     */
                    var getTaskOwner = function(taskId) {
                        var ensureType = "";
                        var applicationItem = _.find(manage.ensureDepList, function(app) {
                            var types = _.keys(app.ensureDeps);
                            if (types.length > 0) {
                                return _.some(app.ensureDeps, function(value, type) {
                                    if (value.taskId === taskId) {
                                        ensureType = type;
                                        return true;
                                    }
                                });
                            }
                        });

                        return { ensureType: ensureType, applicationItem: applicationItem };
                    };

                    /**
                     * Determines what is the application's ensure state
                     * depending on the individual package types state (i.e. gem/pip/npm etc. types)
                     *
                     * @method getAppLevelEnsureState
                     * @param {Object} app application object
                     * @return {String} ensureState - Final determined ensureState at the application level.
                     */
                    var getAppLevelEnsureState = function(app) {
                        var ensureState = app.ensureState;

                        // The ensure state at the application level will be marked as 'complete'
                        // only if all types in a given application are complete. But if at least one
                        // type fails, then the application's ensure state is failure.
                        var type = _.findKey(app.ensureDeps, function(value) {
                            return value.ensureState !== "complete";
                        });
                        if (type) {
                            ensureState = app.ensureDeps[type].ensureState;
                        } else {
                            ensureState = "complete";
                        }
                        return ensureState;
                    };

                    /**
                     * Determines the progress of ensure process at the application level
                     * depending on the individual package types progress state (i.e. gem/pip/npm etc. types)
                     *
                     * @method getAppLevelEnsureProgress
                     * @param {Object} app application object
                     * @return {Boolean} ensureProgress - Final determined progress state at the application level.
                     */
                    var getAppLevelEnsureProgress = function(app) {
                        var ensureProgress = app.ensureInProgress;
                        var typeInProgress = _.findKey(app.ensureDeps, function(value) {
                            return value.inProgress;
                        });
                        if (typeInProgress) {
                            ensureProgress = true;
                        } else {
                            ensureProgress = false;
                        }
                        return ensureProgress;
                    };

                    /**
                     * Handles task_processing.
                     *
                     * @method
                     * @param {sse:task_processing} event - Task processing event.
                     * @param {Object} data - Data
                     * @listens sse:task_processing
                     */
                    $scope.$on("sse:task_processing", function(event, data) {
                        var taskID = data.task_id;
                        var taskOwner = getTaskOwner(taskID);

                        if (taskOwner.applicationItem) {
                            var unfilteredIndex = _.indexOf(manage.filteredList, taskOwner.applicationItem);

                            if (unfilteredIndex !== -1) {
                                taskOwner.applicationItem.ensureDeps[taskOwner.ensureType].ensureState = "processing";

                                // Application level ensureState is set to processing if at least one of the types is in processing.
                                taskOwner.applicationItem.ensureInProgress = true;
                                taskOwner.applicationItem.ensureState = "processing";
                                _.extend(manage.filteredList[unfilteredIndex], taskOwner.applicationItem);
                                $scope.$apply(manage.render);
                            }
                        }
                    });

                    /**
                     * Close and reset the SSE connection
                     *
                     * @method close_and_reset_SSE
                     */
                    var close_and_reset_SSE = function() {
                        if (manage.sseObj) {
                            sseAPIService.close(manage.sseObj);
                            manage.sseObj = null;
                            manage.sseURL = "";
                        }
                    };

                    /**
                     * Update the params that are used in the ensure dependency view.
                     *
                     * @method updateEnsureViewParams
                     * @param {Object} taskOwner - { ensureType, applicationItem }
                     * @param {String} eventState
                     */
                    var updateEnsureViewParams  = function(taskOwner, eventState) {
                        var unfilteredIndex = _.indexOf(manage.filteredList, taskOwner.applicationItem);

                        if (unfilteredIndex !== -1) {
                            taskOwner.applicationItem.ensureDeps[taskOwner.ensureType].ensureState = eventState;
                            taskOwner.applicationItem.ensureDeps[taskOwner.ensureType].inProgress = false;
                            var appLevelEnsureProgress = getAppLevelEnsureProgress(taskOwner.applicationItem);
                            taskOwner.applicationItem.ensureInProgress = appLevelEnsureProgress;

                            // This means all types are processed and should be either success or failure at this point.
                            if (!appLevelEnsureProgress) {
                                taskOwner.applicationItem.ensureState = getAppLevelEnsureState(taskOwner.applicationItem);
                            }
                            if (eventState === "failure") {
                                taskOwner.applicationItem.ensureDeps[taskOwner.ensureType].command = taskOwner.applicationItem.deps[taskOwner.ensureType];
                            }
                            _.extend(manage.filteredList[unfilteredIndex], taskOwner.applicationItem);
                            $scope.$apply(manage.render);
                        }

                        // removing object from ensure list after the action is done (success or failure)
                        if (!taskOwner.applicationItem.ensureInProgress &&
                            (taskOwner.applicationItem.ensureState === "complete" || taskOwner.applicationItem.ensureState === "failure")) {
                            _.remove(manage.ensureDepList, taskOwner.applicationItem);
                            if (taskOwner.applicationItem.ensureState === "complete") {
                                $timeout(function() {

                                    // updating the ensure view with new information so that the row is active
                                    _.extend(manage.filteredList[unfilteredIndex], resetEnsureDependencyParams(taskOwner.applicationItem));
                                    $scope.$apply(manage.render);
                                }, 5000);
                            }
                        }
                        if (manage.ensureDepList.length === 0) {
                            close_and_reset_SSE();
                        }
                    };

                    /**
                     * Handles task_complete.
                     *
                     * @method
                     * @param {sse:task_complete} event - Task complete event.
                     * @param {Object} data - Data
                     * @listens sse:task_complete
                     */
                    $scope.$on("sse:task_complete", function(event, data) {
                        var taskID = data.task_id;
                        var taskOwner = getTaskOwner(taskID);

                        if (taskOwner.applicationItem) {

                            // The failed tasks are triggering 'complete' event as well. Skipping them here since
                            // failures are handled in 'sse:failure'.
                            if (taskOwner.applicationItem.ensureDeps[taskOwner.ensureType].ensureState === "failure") {
                                return;
                            }

                            updateEnsureViewParams(taskOwner, "complete");
                            close_and_reset_SSE();
                        }
                    });

                    /**
                     * Handles task_failed.
                     *
                     * @method
                     * @param {sse:task_failed} event - Task failed event.
                     * @param {Object} data - Data
                     * @listens sse:task_failed
                     */
                    $scope.$on("sse:task_failed", function(event, data) {
                        var taskID = data.task_id;
                        var taskOwner = getTaskOwner(taskID);

                        if (taskOwner.applicationItem) {
                            updateEnsureViewParams(taskOwner, "failure");
                            close_and_reset_SSE();
                        }
                    });

                    /**
                     * Handles ready.
                     *
                     * @method
                     * @param {sse:ready} event - Task ready event.
                     * @listens sse:ready
                     */
                    $scope.$on("sse:ready", function(event) {
                        manage.sseObj = sseAPIService.connect(manage.sseURL, events, sseConfig);
                    });

                    /**
                     * Handles destroy.
                     *
                     * @method
                     * @listens $destroy
                     */
                    $scope.$on("$destroy", function() {
                        close_and_reset_SSE();
                    });

                    manage.configure_details = function(appl) {
                        if (appl === void 0) {
                            viewNavigationApi.loadView("/details");
                        } else {
                            viewNavigationApi.loadView("/details/" + appl.name);
                        }
                    };

                    manage.toggle_status = function(app) {
                        manage.change_in_progress = true;

                        return Apps.toggle_application_status(app)
                            .then(function(application_data) {
                                if (application_data.enabled) {
                                    alertService.add({
                                        type: "success",
                                        message: LOCALE.maketext("You successfully enabled your application."),
                                        closeable: true,
                                        replace: false,
                                        autoClose: 10000,
                                        group: "passenger",
                                    });
                                } else {
                                    alertService.add({
                                        type: "success",
                                        message: LOCALE.maketext("You successfully disabled your application."),
                                        closeable: true,
                                        replace: false,
                                        autoClose: 10000,
                                        group: "passenger",
                                    });
                                }
                                app.enabled = PARSE.parsePerlBoolean(application_data.enabled);
                            })
                            .catch(function(error) {
                                alertService.add({
                                    type: "danger",
                                    message: error,
                                    closeable: true,
                                    replace: false,
                                    group: "passenger",
                                });
                            })
                            .finally(function() {
                                manage.change_in_progress = false;
                            });
                    };

                    function RemoveRecordModalController($uibModalInstance, appl_name) {
                        var ctrl = this;

                        ctrl.confirm_msg = LOCALE.maketext("Are you sure that you want to unregister your application (“[_1]”)?", appl_name);

                        ctrl.cancel = function() {
                            $uibModalInstance.dismiss("cancel");
                        };
                        ctrl.confirm = function() {
                            return Apps.remove_application(appl_name)
                                .then(function() {
                                    table.setSort("name", "asc");
                                    _.remove(manage.applications, function(app) {
                                        return app.name === appl_name;
                                    });
                                    manage.render();
                                    alertService.add({
                                        type: "success",
                                        message: LOCALE.maketext("You successfully unregistered your application."),
                                        closeable: true,
                                        replace: false,
                                        autoClose: 10000,
                                        group: "passenger",
                                    });
                                })
                                .catch(function(error) {
                                    alertService.add({
                                        type: "danger",
                                        message: error,
                                        closeable: true,
                                        replace: false,
                                        group: "passenger",
                                    });
                                })
                                .finally(function() {
                                    $uibModalInstance.close();
                                });

                        };
                    }

                    RemoveRecordModalController.$inject = ["$uibModalInstance", "appl_name"];

                    manage.confirm_delete_record = function(applName) {
                        manage.change_in_progress = true;
                        var instance = $uibModal.open({
                            templateUrl: "confirm_delete.html",
                            controller: RemoveRecordModalController,
                            controllerAs: "ctrl",
                            resolve: {
                                appl_name: function() {
                                    return applName;
                                },
                            },
                        });
                        instance.result.finally(function() {
                            manage.change_in_progress = false;
                        });
                    };

                    manage.refresh = function() {
                        return load(true);
                    };

                    function load(force) {
                        if ($routeParams.hasOwnProperty("forceLoad") &&
                        $routeParams.forceLoad === 1) {
                            force = true;
                        } else if (force === void 0) {
                            force = false;
                        }

                        manage.is_loading = true;
                        return Apps.fetch(force)
                            .then(function(data) {
                                manage.applications = data;
                                if (manage.applications) {
                                    manage.applications = _.map(manage.applications, function(app) {

                                        // Init ensure dependency related data.
                                        app = resetEnsureDependencyParams(app);
                                        return app;
                                    });
                                }

                                table.setSort("name", "asc");
                                table.load(manage.applications);
                                manage.render();
                            })
                            .catch(function(error) {

                                // If we get an error at this point, we assume that the user
                                // should not be able to do anything on the page.
                                manage.loading_error = true;
                                manage.loading_error_message = error;
                            })
                            .finally(function() {
                                manage.is_loading = false;
                            });
                    }

                    manage.init = function() {
                        alertService.clear(void 0, "passenger");
                        load();
                    };

                    manage.init();
                },
            ]);

        return controller;
    }
);

/*
# passenger/directives/passenger_validators.js            Copyright(c) 2020 cPanel, L.L.C.
#                                                                   All rights reserved.
# copyright@cpanel.net                                                 http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited
*/

/* --------------------------*/
/* DEFINE GLOBALS FOR LINT
/*--------------------------*/
/* global define: false     */
/* --------------------------*/

define('app/directives/passenger_validators',[
    "angular",
    "cjt/validator/validator-utils",
    "cjt/util/locale",
    "cjt/validator/validateDirectiveFactory",
],
function(angular, validationUtils, LOCALE) {

    var uri_regex = new RegExp("[^0-9A-Za-z\/_-]");

    /**
         * Validate base uri
         *
         * @method  baseuri
         * @param {string} base uri
         * @return {object} validation result
         */
    var validators = {

        baseuri: function(val) {
            var result = validationUtils.initializeValidationResult();
            var isValid = true;

            if (val.length >= 1 && val.substring(0, 1) !== "/") {
                isValid = false;
            } else if (val.length > 1 && val.indexOf("/", val.length - 1) !== -1) {
                isValid = false;
            } else if (uri_regex.test(val)) {
                isValid = false;
            }

            if (!isValid) {
                result.isValid = false;
                result.add("baseuri", LOCALE.maketext("The [asis,Base URI] must begin with a single slash ([asis,/]) and may not contain spaces, special characters or a trailing slash."));
            }

            return result;
        },
        noApacheLiterals: function(val) {
            var result = validationUtils.initializeValidationResult();

            if (val.length > 1 && val.indexOf("${") !== -1) {
                result.isValid = false;
            }

            return result;
        },
    };

    var validatorModule = angular.module("cjt2.validate");

    validatorModule.run(["validatorFactory",
        function(validatorFactory) {
            validatorFactory.generate(validators);
        }
    ]);

    return {
        methods: validators,
        name: "passengerValidators",
        description: "Validation directives for passenger API parameters.",
        version: 11.66
    };
}
);

/*
# passenger/directives/cp_edit_form_inline.js                          Copyright(c) 2020 cPanel, L.L.C.
#                                                                                All rights reserved.
# copyright@cpanel.net                                                           http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited
*/

/* global define: false */

define(
    'app/directives/table_row_form',[
        "angular",
        "cjt/util/locale",
        "cjt/core",
    ],
    function(angular, LOCALE, CJT) {

        var app = angular.module("cpanel.applicationManager");

        app.directive("tableRowForm", function() {

            return {
                restrict: "A",
                scope: {
                    model: "=formModel",
                    onSave: "&onSave",
                    onCancel: "&onCancel"
                },
                require: ["^form"],
                replace: true,
                templateUrl: "passenger/directives/table_row_form.ptt",
                link: function($scope, $element, $attrs, $ctrl) {
                    $scope.form = $ctrl[0];

                    $scope.envarName = $scope.model.name;
                    $scope.envarValue = $scope.model.value;

                    /**
                     * Disable the save button if:
                     * - all the environment variable fields have not been modified
                     * - any of the environment variable fields have errors
                     */
                    $scope.checkSaveDisabledStatus = function() {
                        return ($scope.form.envarName.$pristine && $scope.form.envarValue.$pristine) ||
                            ($scope.form.envarName.$invalid || $scope.form.envarValue.$invalid);
                    };

                    $scope.handleCancel = function() {
                        return $scope.onCancel({ "envar": $scope.model });
                    };

                    $scope.handleSave = function() {
                        return $scope.onSave({ "envar": $scope.model, "name": $scope.envarName, "value": $scope.envarValue });
                    };

                }
            };

        });
    }
);

/*
# passenger/views/details.js                       Copyright 2022 cPanel, L.L.C.
#                                                           All rights reserved.
# copyright@cpanel.net                                         http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited
*/

/* global define: false */

/* jshint -W100 */

define(
    'app/views/details',[
        "angular",
        "lodash",
        "cjt/util/locale",
        "cjt/util/parse",
        "cjt/util/table",
        "app/directives/passenger_validators",
        "cjt/directives/toggleSwitchDirective",
        "cjt/directives/actionButtonDirective",
        "cjt/directives/toggleLabelInfoDirective",
        "cjt/directives/alertList",
        "cjt/directives/pageSizeDirective",
        "cjt/services/alertService",
        "cjt/services/cpanel/componentSettingSaverService",
        "cjt/services/viewNavigationApi",
        "cjt/directives/validationContainerDirective",
        "cjt/directives/validationItemDirective",
        "cjt/validator/ip-validators",
        "cjt/validator/domain-validators",
        "cjt/validator/compare-validators",
        "cjt/validator/datatype-validators",
        "cjt/validator/path-validators",
        "cjt/validator/length-validators",
        "cjt/services/viewNavigationApi",
        "app/directives/table_row_form",
        "uiBootstrap"
    ],
    function(angular, _, LOCALE, PARSE, Table) {

        var app = angular.module("cpanel.applicationManager");

        var controller = app.controller(
            "ConfigurationDetailsController",
            [
                "$routeParams",
                "viewNavigationApi",
                "Apps",
                "Domains",
                "defaultInfo",
                "alertService",
                "componentSettingSaverService",
                function(
                    $routeParams,
                    viewNavigationApi,
                    Apps,
                    Domains,
                    defaultInfo,
                    alertService,
                    componentSettingSaverService) {
                    var details = this;

                    details.is_loading = false;
                    details.domains = [];
                    details.user_home_dir = defaultInfo.homedir;
                    details.supports_env_vars = Apps.has_support_for_env_vars;
                    details.edit_mode = $routeParams.applname !== void 0;
                    details.editing_envar = false;
                    details.forceLoad = false;
                    details.isRTL = false;
                    details.savedSettings = {};

                    var SAVED_SETTINGS_DEFAULTS = {
                        showAllHelp: true,
                    };

                    // This is the dynamic portion of the form's description text
                    details.formDescription = details.edit_mode ?
                        LOCALE.maketext("You can use this section of the interface to manage your custom applications.") :
                        LOCALE.maketext("You can use this section of the interface to register a new application.");

                    var html = document.querySelector("html");
                    if (html) {
                        details.isRTL = html.getAttribute("dir") === "rtl";
                    }

                    details.get_page_title = function() {
                        if (details.edit_mode) {
                            return LOCALE.maketext("Edit");
                        } else {
                            return LOCALE.maketext("Register");
                        }
                    };

                    details.get_application_title = function() {
                        if (details.edit_mode) {
                            return LOCALE.maketext("Edit Your Application");
                        } else {
                            return LOCALE.maketext("Register Your Application");
                        }
                    };

                    var envarTable = new Table();

                    details.meta = envarTable.getMetadata();
                    details.filteredEnvars = envarTable.getList();
                    details.paginationMessage = envarTable.paginationMessage;
                    details.renderEnvars = function() {
                        details.filteredEnvars = envarTable.update();
                    };
                    details.sortList = function() {
                        details.renderEnvars();
                    };
                    details.selectPage = function() {
                        details.renderEnvars();
                    };
                    details.selectPageSize = function() {
                        details.renderEnvars();
                    };
                    details.searchList = function() {
                        details.renderEnvars();
                    };

                    details.goToView = function(view, forceLoad) {
                        viewNavigationApi.loadView(view, forceLoad ? { "forceLoad": 1 } : {} );
                    };

                    details.save_application = function() {
                        if (details.add_app.$pristine || details.add_app.$invalid) {
                            alertService.add({
                                type: "danger",
                                message: LOCALE.maketext("Your application is incomplete or invalid."),
                                closeable: true,
                                replace: true,
                                autoClose: false,
                                group: "passenger"
                            });
                            return;
                        }
                        if (details.editing_envar) {
                            alertService.add({
                                type: "danger",
                                message: LOCALE.maketext("You must finish adding or editing environment variables first."),
                                closeable: true,
                                replace: true,
                                autoClose: false,
                                group: "passenger"
                            });
                            return;
                        }

                        if (details.edit_mode) {
                            return details.save_edited_application();
                        } else {
                            return details.save_new_application();
                        }
                    };

                    details.save_edited_application = function() {
                        return Apps.update_application(details.application, details.previous_name)
                            .then(function() {
                                alertService.add({
                                    type: "success",
                                    message: LOCALE.maketext("You successfully updated your application."),
                                    closeable: true,
                                    replace: false,
                                    autoClose: 10000,
                                    group: "passenger"
                                });

                                // Force load required to make sure
                                // the manage view always reflects the reality.
                                details.goToView("manage", true);
                            })
                            .catch(function(error) {
                                alertService.add({
                                    type: "danger",
                                    message: error,
                                    closeable: true,
                                    replace: false,
                                    group: "passenger"
                                });
                            });
                    };

                    details.save_new_application = function() {
                        return Apps.add_application(details.application)
                            .then(function() {
                                alertService.add({
                                    type: "success",
                                    message: LOCALE.maketext("You successfully registered your application."),
                                    closeable: true,
                                    replace: false,
                                    autoClose: 10000,
                                    group: "passenger"
                                });

                                // Force load required to make sure
                                // the manage view always reflects the reality.
                                details.goToView("manage", true);
                            })
                            .catch(function(error) {
                                alertService.add({
                                    type: "danger",
                                    message: error,
                                    closeable: true,
                                    replace: false,
                                    group: "passenger"
                                });
                            });
                    };

                    details.add_envar = function() {
                        envarTable.add({ "name": "", "value": "", "is_editing": true, "is_new": true });
                        details.editing_envar = true;
                        details.renderEnvars();
                    };

                    details.close_envar_editor = function(envar) {
                        envar.is_editing = false;
                        details.editing_envar = false;

                        // check if the user cancelled a new item
                        if (envar.is_new) {
                            envarTable.remove(envar);
                            details.renderEnvars();
                        }
                    };

                    details.save_envar = function(envar, name, value) {
                        if (envar.is_new) {
                            delete envar.is_new;
                        } else {

                            // check for a rename
                            if (name !== envar.name) {
                                delete details.application.envvars[envar.name];
                            }
                        }

                        envar.name = name;
                        envar.value = value;
                        details.application.envvars[name] = value;
                        details.close_envar_editor(envar);
                        details.renderEnvars();
                    };

                    details.delete_envar = function(envar) {
                        envarTable.remove(envar);
                        delete details.application.envvars[envar.name];
                        details.renderEnvars();
                        details.add_app.$setDirty();
                    };

                    details.edit_envar = function(envar) {
                        envar.is_editing = true;
                        details.editing_envar = true;
                    };

                    /**
                     * Toggles whether all help info blocks should be shown or not. Saves this
                     * preference to the user's personalization store.
                     */
                    details.toggleShowAllHelp = function() {
                        details.savedSettings.showAllHelp = !details.savedSettings.showAllHelp;
                        componentSettingSaverService.set("application_details", details.savedSettings);
                    };

                    details.init = function() {
                        alertService.clear(void 0, "passenger");
                        var savedSettings = componentSettingSaverService.getCached("application_details").cachedValue;
                        _.merge(details.savedSettings, SAVED_SETTINGS_DEFAULTS, savedSettings || {});

                        if (details.edit_mode) {
                            details.is_loading = true;
                            Apps.get_application_by_name($routeParams.applname)
                                .then(function(data) {
                                    details.application = angular.copy(data);
                                    details.application = Apps.strip_homedir_from_path(details.application);
                                    var array_for_table = [];
                                    _.forOwn(details.application.envvars, function(envar_value, envar_key) {
                                        array_for_table.push({
                                            "name": envar_key,
                                            "value": envar_value,
                                            "is_editing": false
                                        });
                                    });
                                    envarTable.load(array_for_table);
                                    details.renderEnvars();
                                    details.previous_name = details.application.name;
                                    details.is_loading = false;
                                });
                        } else {
                            if (Apps.applications.length === 0) {
                                details.forceLoad = true;
                            }
                            details.application = Apps.get_default_application();
                        }

                        Domains.fetch()
                            .then(function(data) {
                                details.domains = data;
                            });

                        envarTable.setSort("name", "asc");
                    };

                    details.init();
                }
            ]);

        return controller;
    }
);

/*
# passenger/index.js                               Copyright 2022 cPanel, L.L.C.
#                                                           All rights reserved.
# copyright@cpanel.net                                         http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited
*/
/* global require: false, define: false, PAGE: false */

define(
    'app/index',[
        "angular",
        "jquery",
        "lodash",
        "cjt/core",
        "cjt/modules",
        "ngRoute",
        "uiBootstrap",
        "jquery-chosen",
        "angular-chosen"
    ],
    function(angular, $, _, CJT) {
        return function() {

            // First create the application
            angular.module("cpanel.applicationManager", ["ngRoute", "ui.bootstrap", "cjt2.cpanel", "localytics.directives", "cpanel.applicationManager.sseAPIService", "cpanel.applicationManager.appsService"]);

            // Then load the application dependencies
            var app = require(
                [
                    "cjt/bootstrap",
                    "cjt/services/autoTopService",
                    "cjt/services/alertService",
                    "cjt/directives/alertList",
                    "cjt/services/cpanel/componentSettingSaverService",
                    "app/services/apps",
                    "app/services/domains",
                    "app/views/manage",
                    "app/views/details",
                    "app/directives/table_row_form"
                ], function(BOOTSTRAP) {

                    var app = angular.module("cpanel.applicationManager");

                    app.value("defaultInfo", PAGE);

                    app.config([
                        "$routeProvider",
                        function($routeProvider) {

                            $routeProvider.when("/manage", {
                                controller: "ManageApplicationsController",
                                controllerAs: "manage",
                                templateUrl: "passenger/views/manage.ptt"
                            });

                            $routeProvider.when("/details/:applname?", {
                                controller: "ConfigurationDetailsController",
                                controllerAs: "details",
                                templateUrl: "passenger/views/details.ptt"
                            });

                            $routeProvider.otherwise({
                                "redirectTo": "/manage"
                            });
                        }
                    ]);

                    app.run([
                        "autoTopService",
                        "componentSettingSaverService",
                        function(
                            autoTopService,
                            componentSettingSaverService
                        ) {
                            autoTopService.initialize();
                            componentSettingSaverService.register("application_details");
                        }]);

                    BOOTSTRAP("#content", "cpanel.applicationManager");

                });

            return app;
        };
    }
);

