define("app/services/HasIdVerMix",["angular","lodash"],(function(e){"use strict";var t;try{t=angular.module("App")}catch(e){t=angular.module("App",[])}return t.factory("HasIdVerMix",["$log",function(e){return{set_identity_verification:function(t){if("object"!=typeof t)throw e.error("bad idver",t),new Error;this.identity_verification=t},get_identity_verification:function(){return this.identity_verification}}}])})),define("app/views/Certificate",["angular","lodash","app/services/HasIdVerMix"],(function(e,t){"use strict";e.module("App").factory("Certificate",["HasIdVerMix",function(e){function i(e){this.reset(),e&&this.init(e)}return t.assign(i.prototype,e),t.assign(i.prototype,{get_product:function(){return this.selected_product},set_product:function(e){this.selected_product=e},set_price:function(e){this.total_price=e},get_price:function(){return this.total_price},set_domains:function(e){this.domains=e},get_domains:function(){return this.domains},get_subject_names:function(){return this.domains.map((function(e){return{type:"dNSName",name:e.domain,dcv_method:e.dcvPassed.dns?"dns":"http"}}))},set_virtual_hosts:function(e){this.virtual_hosts=e},get_virtual_hosts:function(){return this.virtual_hosts},get_validity_period:function(){return this.selected_product.validity_period||[1,"year"]},reset:function(){this.domains=[],this.total_price=null,this.virtual_hosts=[],this.selected_product=null,this.product_price=0,this.product_wildcard_price=0,this.identity_verification=null},toJSON:function(){return{domains:this.domains,total_price:this.total_price,virtual_hosts:this.virtual_hosts,selected_product:this.selected_product,product_price:this.product_price,product_wildcard_price:this.product_wildcard_price,identity_verification:this.get_identity_verification()}},init:function(e){t.assign(this,e)}}),i}])})),define("app/services/VirtualHost",["angular","lodash","app/services/HasIdVerMix"],(function(e,t,i){"use strict";var r;try{r=e.module("App")}catch(t){r=e.module("App",[])}r.factory("VirtualHost",["HasIdVerMix",function(i){function r(t){var i=this;i.display_name="",i.domains=[],i.selected_domains=[],i.filtered_domains={},i.show_wildcards=!0,i.show_domains=!0,i.display_meta={items_per_page:10,current_page:1},i.displayed_domains=[],i.selected_product=null,i.calculated_price=null,i.is_ssl=0,i.product_price=0,i.product_wildcard_price=0,i.added_to_cart=!1,i.current_step="domains",e.extend(i,t)}return e.extend(r.prototype,i),e.extend(r.prototype,{get_display_name:function(){return this.display_name},reset:function(){this.current_step="domains",this.set_product(null),this.set_product_price(0),this.calculated_price=null,this.selected_product=null,e.forEach(this.domains,(function(e){e.selected=!1})),this.get_selected_domains()},get_step:function(){return this.current_step},go_step:function(e){return this.current_step=e,this.current_step},get_price:function(){var e=this.get_selected_domains(),t=e.filter((function(e){return!!e.is_wildcard}));return this.calculated_price=this.product_price*(e.length-t.length)+t.length*this.product_wildcard_price,this.calculated_price},set_product_price:function(e,t){this.product_price=e||0,this.product_wildcard_price=t||0},get_price_string:function(){return"$"+this.get_price().toFixed(2)+" USD"},get_product:function(){return this.selected_product},set_product:function(e){this.selected_product=e},get_domains:function(){return this.domains},set_displayed_domains:function(e){this.displayed_domains=e},get_filtered_domains:function(){var t,i=this.get_domains();if(this.show_wildcards&&this.show_domains)t="all";else if(this.show_wildcards)t="wildcards";else{if(!this.show_domains)return[];t="domains"}if(this.filtered_domains[t])return this.filtered_domains[t];this.filtered_domains[t]=[];var r=this;return e.forEach(i,(function(e){return!(!r.show_wildcards&&e.is_wildcard)&&(!(!r.show_domains&&!e.is_wildcard)&&void r.filtered_domains[t].push(e))})),this.filtered_domains[t]},get_domain_count:function(e){return e?this.domains.length:this.domains.length/2},get_displayed_domains:function(){this.displayed_domains=[];var e=this.get_filtered_domains();this.display_meta.start=this.display_meta.items_per_page*(this.display_meta.current_page-1),this.display_meta.limit=Math.min(e.length,this.display_meta.start+this.display_meta.items_per_page);for(var t=this.display_meta.start;t<this.display_meta.limit;t++)e[t].is_wildcard||this.displayed_domains.push(e[t]);return this.displayed_domains},add_domain:function(e){if(!this.get_domain_by_domain(e.domain)){e.resolved=-1,e.resolving=!1;var t=this.domains.length;return this.domains.push(e),t}},get_domain_by_domain:function(t){var i;return e.forEach(this.domains,(function(e){e.domain===t&&(i=e)})),i},remove_domain:function(e){e.selected=0,this.get_selected_domains()},remove_all_domains:function(){for(var e=0;e<this.domains.length;e++)this.remove_domain(this.domains[e])},is_ready:function(){return 0!==this.get_domains().length&&!!this.get_product()},toJSON:function(){var e={};return e.display_name=this.display_name,e.selected_domains=this.selected_domains,e.selected_product=this.selected_product,e.calculated_price=this.calculated_price,e.product_price=this.product_price,e.domains=this.get_domains(),e.identity_verification=this.get_identity_verification(),e},get_selected_domains:function(){var e=t.filter(this.get_domains(),"selected");return this.selected_domains=e,e},has_selected_domains:function(){return t.some(this.get_domains(),"selected")}}),r}])})),define("app/services/CertificatesService",["angular","lodash","cjt/util/locale","cjt/util/html","cjt/util/parse","cjt/io/api","cjt/io/uapi-request","app/views/Certificate","app/services/VirtualHost","cjt/io/uapi","cjt/services/alertService"],(function(e,t,i,r,a,n,o){"use strict";var s,c={evClickThroughStatus:i.maketext("Sign the Agreement"),ovCallbackStatus:i.maketext("Schedule a Call"),DEFAULT:i.maketext("Complete this Now")},d={ovCallbackStatus:"fas fa-phone-square",DEFAULT:"fas fa-external-link-alt"},_={csrStatus:{label:i.maketext("[output,abbr,CSR,Certificate Signing Request] Status:"),inProgress:i.maketext("Validating the [output,abbr,CSR,Certificate Signing Request] status …")},dcvStatus:{label:i.maketext("[output,abbr,DCV,Domain Control Validation] Status:"),inProgress:i.maketext("Validating the [output,abbr,DCV,Domain Control Validation] status …")},evClickThroughStatus:{label:i.maketext("[output,abbr,EV,Extended Validation] Click-Through Status:"),inProgress:i.maketext("Validating the [output,abbr,EV,Extended Validation] click-through status …")},freeDVUPStatus:{label:i.maketext("Free [output,abbr,DV,Domain Validated] Up Status:"),inProgress:i.maketext("Validating the free [output,abbr,DV,Domain Validated] up status …")},organizationValidationStatus:{label:i.maketext("[output,abbr,OV,Organization Validation] Status:"),inProgress:i.maketext("Validating the [output,abbr,OV,Organization Validation] status …")},ovCallbackStatus:{label:i.maketext("[output,abbr,OV,Organization Validation] Callback Status:"),inProgress:i.maketext("Validating the [output,abbr,OV,Organization Validation] callback status …")},validationStatus:{label:i.maketext("Validation Status:"),inProgress:i.maketext("Checking the validation status …")}};function l(e){return/^\*/.test(e)}function u(e){return("0"+e).slice(-2)}try{s=e.module("App")}catch(t){s=e.module("App",["cjt2.services.alert"])}return s.factory("CertificatesService",["VirtualHost","Certificate","$q","$log","alertService",function(s,p,f,m,g){var h,v,y={},w=[],b=[],k=[],x=[],S=[],C=[],E=null,D=[],A={},P={},V={},z={},T=new Date,I=!1;function L(e,r){var a=i.maketext("The “[_1]” [asis,API] failed due to the following error: [_2]",t.escape(e),r);g.add({type:"danger",message:a,group:"tlsWizard"})}function O(){return localStorage.getItem("tls_wizard_data")}y.add_new_certificate=function(e){return D.push(e),D},y.get_purchasing_certs=function(){return D},y.get_order_by_id=function(e){for(var t=0;t<S.length;t++)if(S[t].order_id===e)return S[t]},y.add_order=function(t){var i=y.get_order_by_id(t.order_id);return i?e.extend(i,t):S.push(t),S},y.restore=function(){if(y.get_virtual_hosts().length)return!1;var t=O();if(!t)return!1;var i=JSON.parse(t);return e.forEach(i.virtual_hosts,(function(e){w.push(new s(e))})),e.forEach(i.purchasing_certs,(function(e){y.add_new_certificate(new p(e))})),i.orders=i.orders?i.orders:[],S=i.orders,w.length===i.virtual_hosts.length&&S.length===i.orders.length},y.add_virtual_host=function(e,t){var i=new s({display_name:e,is_ssl:t}),r=w.length;return w.push(i),r},y.get_virtual_hosts=function(){return w},y.doesDomainMatchOneOf=function(e,t){return null!==t&&null!==e&&t.some((function(t){var i,r,a=e;if(t===a)return!0;if(l(t))i=t,r=a;else{if(!l(a))return!1;i=a,r=t}return(i=i.replace(/^\*\./,""))===(r=r.replace(/^[^.]+\./,""))}))},y._getWWWDomainsLookup=function(){return z},y.add_raw_domain=function(t){if(/^www\./.test(t.domain))z[t.domain]=!0;else{t.virtual_host=t.vhost_name,t.order_by_name=t.domain,t.is_wildcard=0===t.domain.indexOf("*."),t.is_proxy=t.is_proxy&&"1"===t.is_proxy.toString(),t.stripped_domain=t.domain,y.add_domain(t);var i=t.domain.match(/^(mail|ipv6)\./);t.is_wildcard||t.is_proxy||i||y.add_domain(e.extend({},t,{domain:"*."+t.domain,is_wildcard:!0}))}},y._getWildcardMap=function(){return V},y.domain_covered_by_wildcard=function(e){return V[e]},y.compare_wildcard_domain=function(e,t){return V[t]===e.domain},y.build_wildcard_map=function(){V={};var e,i=y.get_all_domains();i.forEach((function(r){if(!1===r.is_wildcard)return!1;e=new RegExp("^[^\\.]+\\."+t.escapeRegExp(r.stripped_domain.replace(/^\*\./,""))+"$"),i.forEach((function(t){r.domain!==t.domain&&e.test(t.domain)&&(V[t.domain]=r)}))}))},y.get_domain_certificate_status=function(e){var t=y.get_domain_certificate(e.domain);if(t&&t.certificate){var i=new Date(1e3*t.certificate.not_after),r=(i-T)/1e3/60/60/24;return i<T?"expired":r<30&&r>0?"expiring_soon":"active"}return"unsecured"},y._getSSLDomains=function(){return A},y._getInstalledHostsMap=function(){return P},y._getInstalledHosts=function(){return E},y.add_domain=function(t){var i=y.get_virtual_host_by_display_name(t.virtual_host);if(0===i||i||(i=y.add_virtual_host(t.virtual_host,1)),w[i].is_ssl=1,!y.get_domain_by_domain(t.domain)){A[t.domain]=null;var r=P[t.virtual_host];return r&&r.certificate&&e.forEach(r.certificate.domains,(function(e){t.domain!==e?t.domain.replace(/^[^.]+\./,"*.")===e&&(A[t.domain]=r):A[t.domain]=r})),t.type=t.is_wildcard?"wildcard_domain":"main_domain",t.proxy_type=t.is_proxy?"proxy_domain":"main_domain",t.certificate_status=y.get_domain_certificate_status(t),w[i].add_domain(t)}},y.remove_virtual_host=function(e){var i=y.get_virtual_host_by_display_name(e);t.isNil(i)||w[i].remove_all_domains()},y.get_virtual_host_by_display_name=function(e){for(var t=0;t<w.length;t++){if("*"===w[t].display_name)return 0;if(w[t].display_name===e)return t}},y._runUAPI=function(e){var t=f.defer();return n.promise(e.getRunArguments()).done((function(e){(e=e.parsedResponse).status?t.resolve(e):t.reject(e.error)})),t.promise},y.set_confirmed_status_for_ssl_certificates=function(t,i){var r=f.defer(),a=new o.Class,s=[];return e.forEach(i.certificates,(function(e){s.push(e.order_item_id)})),a.initialize("Market","set_status_of_pending_queue_items"),a.addArgument("provider",t),a.addArgument("status","confirmed"),a.addArgument("order_item_id",s),n.promise(a.getRunArguments()).done((function(e){var t=(e=e.parsedResponse).status?"resolve":"reject";r[t](e)})),r.promise},y.fetch_domains=function(){var i=y.fetch_installed_hosts();if(!1!==t.isFunction(i.then))return i.then((function(){return y.fetch_domains()}));if(CPANEL.PAGE.domains&&(e.forEach(CPANEL.PAGE.domains,(function(e){y.add_raw_domain(e)})),y.get_all_domains().length))return!0;var r=f.defer(),a=new o.Class;return a.initialize("WebVhosts","list_ssl_capable_domains"),n.promise(a.getRunArguments()).done((function(e){(e=e.parsedResponse).status?r.resolve(e):r.reject(e.error)})),r.promise.then((function(t){e.forEach(t.data,(function(e){y.add_raw_domain(e)}))}),(function(e){L("WebVHosts::list_ssl_capable_domains",e)})),r.promise},y.get_store_login_url=function(e,t){var i=f.defer(),r=new o.Class;return r.initialize("Market","get_login_url"),r.addArgument("provider",e),r.addArgument("url_after_login",t),n.promise(r.getRunArguments()).done((function(e){(e=e.parsedResponse).status?i.resolve(e):i.reject(e.error)})),i.promise},y.store_settings=function(e){var t=y.get_storable_settings(e);return localStorage.setItem("tls_wizard_data",t),O()===t},y.save=y.store_settings,y.get_stored_extra_settings=function(){var e=O();return e&&(e=JSON.parse(e).extras),e||{}},y.clear_stored_settings=function(){return localStorage.removeItem("tls_wizard_data")},y.get_storable_settings=function(e){var i=O();return(i=i?JSON.parse(i):{}).extras||(i.extras={}),e&&t.assign(i.extras,e),t.assign(i,{orders:S,virtual_hosts:w,purchasing_certs:y.get_purchasing_certs()}),JSON.stringify(i)},y.get_all_domains=function(){return b=[],e.forEach(w,(function(e){b=b.concat(e.get_domains())})),b},y.get_all_selected_domains=function(){return k=[],e.forEach(w,(function(e){k=k.concat(e.get_selected_domains())})),k},y.get_products=function(){return x},y.fetch_products=function(){if(y.get_products().length)return!0;if(CPANEL.PAGE.products&&(e.forEach(CPANEL.PAGE.products,(function(e){y.add_raw_product(e)})),y.get_products().length))return!0;x=[];var t=f.defer(),i=new o.Class;return i.initialize("Market","get_all_products"),i.addFilter("enabled","eq","1"),i.addFilter("product_group","eq","ssl_certificate"),i.addSorting("recommended","dsc","numeric"),i.addSorting("x_price_per_domain","asc","numeric"),n.promise(i.getRunArguments()).done((function(e){(e=e.parsedResponse).status?t.resolve(e):t.reject(e.error)})),t.promise.then((function(t){e.forEach(t.data,(function(e){e.product_id+="",["x_warn_after","x_price_per_domain","x_max_http_redirects"].forEach((function(t){e[t]&&(e[t]=a.parseNumber(e[t]))})),y.add_raw_product(e)}))}),(function(e){L("Market::get_all_products",e)})),t.promise},y._make_certificate_term_label=function(e,t){return{year:i.maketext("[quant,_1,Year,Years]",t),month:i.maketext("[quant,_1,Month,Months]",t),day:i.maketext("[quant,_1,Day,Days]",t)}[e]||t+" "+e},y._make_validation_type_label=function(e){return{dv:i.maketext("[output,abbr,DV,Domain Validated] Certificate"),ov:i.maketext("[output,abbr,OV,Organization Validated] Certificate"),ev:i.maketext("[output,abbr,EV,Extended Validation] Certificate")}[e]||e},y.add_raw_product=function(e){e.id=e.product_id,e.provider=e.provider_name,e.provider_display_name=e.provider_display_name||e.provider,e.price=Number(e.x_price_per_domain),e.wildcard_price=Number(e.x_price_per_wildcard_domain),e.wildcard_parent_domain_included=e.x_wildcard_parent_domain_free&&"1"===e.x_wildcard_parent_domain_free.toString(),e.icon_mime_type=e.icon_mime_type?e.icon_mime_type:"image/png",e.is_wildcard=!isNaN(e.wildcard_price),e.x_certificate_term=e.x_certificate_term||[1,"year"],e.x_certificate_term_display_name=y._make_certificate_term_label(e.x_certificate_term[1],e.x_certificate_term[0]),e.x_certificate_term_key=e.x_certificate_term.join("_"),e.x_validation_type_display_name=y._make_validation_type_label(e.x_validation_type),e.x_supports_dns_dcv=a.parsePerlBoolean(e.x_supports_dns_dcv),e.validity_period=e.x_certificate_term,x.push(e)},y.get_domain_search_options=function(){return v||(v={domainType:{label:i.maketext("Domain Types:"),item_key:"type",options:[{value:"main_domain",label:i.maketext("Non-Wildcard"),description:i.maketext("Only list Non-Wildcard domains.")},{value:"wildcard_domain",label:i.maketext("Wildcard"),description:i.maketext("Only list Wildcard domains.")}]},proxyDomainType:{label:i.maketext("Service Subdomain Types:"),item_key:"proxy_type",options:[{value:"proxy_domain",label:i.maketext("[asis,cPanel] Service Subdomains"),description:i.maketext("Only list Service Subdomains.")},{value:"main_domain",label:i.maketext("Other Domains"),description:i.maketext("Only list non-Service Subdomains.")}]},sslType:{label:i.maketext("[asis,SSL] Types:"),item_key:"certificate_type",options:[{value:"unsecured",label:i.maketext("Unsecured or Self-signed"),description:i.maketext("Only list unsecured or self-signed domains.")},{value:"dv",label:y._make_validation_type_label("dv"),description:i.maketext("Only list domains with [asis,DV] Certificates.")},{value:"ov",label:y._make_validation_type_label("ov"),description:i.maketext("Only list domains with [asis,OV] Certificates.")},{value:"ev",label:y._make_validation_type_label("ev"),description:i.maketext("Only list domains with [asis,EV] Certificates.")}]},sslStatus:{label:i.maketext("[asis,SSL] Statuses:"),item_key:"certificate_status",options:[{value:"unsecured",label:i.maketext("Unsecured"),description:i.maketext("Only list unsecured domains.")},{value:"active",label:i.maketext("Active"),description:i.maketext("Only list domains with an active certificate.")},{value:"expired",label:i.maketext("Expired"),description:i.maketext("Only list domains whose certificate is expiring soon.")},{value:"expiring_soon",label:i.maketext("Expiring Soon"),description:i.maketext("Only list domains with certificates that expire soon.")}]}},y.get_domain_search_options())},y.get_product_search_options=function(){if(h)return h;h={validationType:{label:i.maketext("[asis,SSL] Validation Types"),item_key:"x_validation_type",options:[]},sslProvider:{label:i.maketext("[asis,SSL] Providers"),item_key:"provider",options:[]},certTerms:{label:i.maketext("Certificate Terms"),item_key:"x_certificate_term_key",options:[]}};var t=y.get_products(),r={},a={},n={};for(var o in e.forEach(t,(function(e){r[e.x_certificate_term_key]={value:e.x_certificate_term_key,label:e.x_certificate_term_display_name,description:i.maketext("Only list products with a term of ([_1]).",e.x_certificate_term_display_name)},a[e.provider]={value:e.provider,label:e.provider_display_name,description:i.maketext("Only list products from the “[_1]” provider.",e.provider_display_name)},n[e.x_validation_type]={value:e.x_validation_type,label:e.x_validation_type_display_name,description:i.maketext("Only list products that use the “[_1]” validation type.",e.x_validation_type_display_name)}})),e.forEach(r,(function(e){h.certTerms.options.push(e)})),e.forEach(a,(function(e){h.sslProvider.options.push(e)})),e.forEach(n,(function(e){h.validationType.options.push(e)})),h)h.hasOwnProperty(o)&&h[o].options.length<=1&&delete h[o];return y.get_product_search_options()},y.get_product_by_id=function(e,t){for(var i=0;i<x.length;i++)if(x[i].id===t&&x[i].provider===e)return x[i]};var j=function(n,s){var c={},d=[],_={};if(e.forEach(n,(function(e){-1===e.resolved&&(c[e.domain]=e,l(e.domain)?_[e.domain]=e:d.push(e.domain),e.dcvPassed={},e.resolving=!0)})),0!==Object.keys(c).length){var u;if(d.length){var p=(new o.Class).initialize("DCV","check_domains_via_http",{domain:d,dcv_file_allowed_characters:JSON.stringify(s.dcv_file_allowed_characters),dcv_file_random_character_count:s.dcv_file_random_character_count,dcv_file_extension:s.dcv_file_extension,dcv_file_relative_path:s.dcv_file_relative_path,dcv_user_agent_string:s.dcv_user_agent_string}),f=x.filter((function(e){return 0===e.x_max_http_redirects}));u=y._runUAPI(p).then((function(e){for(var r=0;r<d.length;r++){var n=d[r],o=c[n];if(o.resolution_failure_reason=e.data[r].failure_reason,o.redirects_count=a.parseNumber(e.data[r].redirects_count),o.redirects_count&&!o.resolution_failure_reason&&f.length){var s=i.maketext("“[_1]”’s [output,abbr,DCV,Domain Control Validation] check completed correctly, but the check required an [asis,HTTP] redirection. The system tried to exclude such redirections from this domain by editing the website document root’s “[_2]” file, but the redirection persists. You should investigate further.",t.escape(o.domain),".htaccess");g.add({type:"danger",message:s,group:"tlsWizard"})}o.dcvPassed.http=!o.resolution_failure_reason,!o.dcvPassed.http||o.redirects_count?_[o.domain]=o:o.resolved=o.dcvPassed.http?1:0}}),(function(e){L("DCV::check_domains_via_http",e)}))}else u=Promise.resolve();return u.then((function(){var e=Object.values(_);if(e.length)return function(e){var t=(new o.Class).initialize("DCV","check_domains_via_dns",{domain:e.map((function(e){return e.domain}))});return y._runUAPI(t).then((function(t){for(var n=0;n<e.length;n++){var o=e[n];o.resolving=!1,o.dcvPassed.dns=a.parsePerlBoolean(t.data[n].succeeded),o.dcvPassed.dns?o.resolved=1:(o.resolved=0,o.resolution_failure_reason?o.resolution_failure_reason+=" "+r.decode(i.maketext("[asis,DNS]-based [output,abbr,DCV,Domain Control Validation] also failed.")):o.resolution_failure_reason=r.decode(i.maketext("[asis,DNS]-based [output,abbr,DCV,Domain Control Validation] failed.")))}}),(function(e){L("DCV::check_domains_via_dns",e)}))}(e)})).finally((function(){Object.values(c).forEach((function(e){e.resolving=!1}))}))}};y.get_default_provider_name=function(){var e=y.get_products(),t=e.filter((function(e){return"cPStore"===e.provider_name}));return(t.length?t[0]:e[0]).provider_name},y.get_provider_specific_dcv_constraints=function(e){var t=(new o.Class).initialize("Market","get_provider_specific_dcv_constraints",{provider:e});return y._runUAPI(t)},y.ensure_domains_can_pass_dcv=function(e,t){return y.get_provider_specific_dcv_constraints(t).then((function(t){return j(e,t.data)}),(function(e){L("Market::get_provider_specific_dcv_constraints",e)}))},y.verify_login_token=function(e,t,i){var r=f.defer(),a=new o.Class;return a.initialize("Market","validate_login_token"),a.addArgument("login_token",t),a.addArgument("url_after_login",i),a.addArgument("provider",e),n.promise(a.getRunArguments()).done((function(e){(e=e.parsedResponse).status?r.resolve(e):r.reject(e.error)})),r.promise},y.set_url_after_checkout=function(e,t,i,r){var a=f.defer(),s=new o.Class;return s.initialize("Market","set_url_after_checkout"),s.addArgument("provider",e),s.addArgument("access_token",t),s.addArgument("order_id",i),s.addArgument("url_after_checkout",r),n.promise(s.getRunArguments()).done((function(e){var t=(e=e.parsedResponse).status?"resolve":"reject";a[t](e)})),a.promise};var q=function(e,t,i,r){var a=f.defer(),s=new o.Class;s.initialize("Market","request_ssl_certificates"),s.addArgument("provider",e),s.addArgument("access_token",t),s.addArgument("url_after_checkout",r);var c=i.map((function(e){var t={product_id:e.get_product().id,subject_names:e.get_subject_names(),vhost_names:e.get_virtual_hosts(),price:e.get_price(),validity_period:e.get_validity_period()};if(e.get_product().x_identity_verification){var i=e.get_identity_verification();t.identity_verification={},e.get_product().x_identity_verification.forEach((function(e){var r,a=e.name;if(i[a])if("date"===e.type){var n;try{n=new Date(i[a])}catch(e){m.warn("new Date() failed; ignoring",i[a],e)}n&&(t.identity_verification[a]=[(r=n).getFullYear(),u(1+r.getMonth()),u(r.getDate())].join("-"))}else t.identity_verification[a]=i[a]}))}var r={};t.subject_names.forEach((function(e){var t=e.name;0===t.indexOf("*.")&&(r[t]=!0)}));var a=[];return t.subject_names.forEach((function(e){var t=e.name,i=!r["*."+t];(i=i&&z["www."+t])&&a.push({type:"dNSName",name:"www."+t,dcv_method:e.dcv_method})})),t.subject_names=t.subject_names.concat(a),JSON.stringify(t)}));return s.addArgument("certificate",c),n.promise(s.getRunArguments()).done((function(e){(e=e.parsedResponse).status?a.resolve(e):a.reject(e.error)})),a.promise.catch(y.reset.bind(y)),a.promise};y.request_certificates=function(e,t,i,r){var a=y.fetch_domains(),n=function(){return q(e,t,i,r)};return a.then?a.then(n):n()},y.get_pending_certificates=function(){return C};var $=function(e){(C=e).forEach((function(e){e.order_id+="",e.order_item_id+="",e.product_id+=""}))};y.fetch_pending_certificates=function(){if(CPANEL.PAGE.pending_certificates&&($(CPANEL.PAGE.pending_certificates),CPANEL.PAGE.pending_certificates=null,C.length))return!0;var e=f.defer(),t=new o.Class;return t.initialize("Market","get_pending_ssl_certificates"),n.promise(t.getRunArguments()).done((function(t){(t=t.parsedResponse).status?e.resolve(t):e.reject(t.error)})),e.promise.then((function(e){$(e.data)}),(function(e){L("Market::pending_certificates",e)})),e.promise},y.add_raw_installed_host=function(e){E||(E=[]),e.certificate.is_self_signed=1===parseInt(e.certificate.is_self_signed,10),E.push(e),P[e.servername]=e},y.get_domain_certificate=function(e){return A[e]},y.get_domain_by_domain=function(e){for(var t=y.get_all_domains(),i=0;i<t.length;i++)if(t[i].domain===e)return t[i]},y.get_virtual_host_certificate=function(e){if(E){for(var t=0;t<E.length;t++)if(E[t].servername===e.display_name)return E[t];return E[0]?E[0]:void 0}},y.fetch_installed_hosts=function(){if(E)return!0;if(CPANEL.PAGE.installed_hosts){if(!CPANEL.PAGE.installed_hosts.length)return!0;if(E=[],P={},A={},e.forEach(CPANEL.PAGE.installed_hosts,(function(e){y.add_raw_installed_host(e)})),E.length)return!0}var t=f.defer(),i=new o.Class;return i.initialize("SSL","installed_hosts"),n.promise(i.getRunArguments()).done((function(e){(e=e.parsedResponse).status?t.resolve(e):t.reject(e.error)})),t.promise.then((function(t){E=[],P={},A={},e.forEach(t.data,(function(e){y.add_raw_installed_host(e)}))}),(function(e){L("SSL::installed_hosts",e)})),t.promise};var N=function(e){var t=new o.Class;return t.initialize("Batch","strict"),t.addArgument("command",e.map(JSON.stringify,JSON)),t};return y.install_certificate=function(e,t){var i=N(t.map((function(t){return["SSL","install_ssl",{cert:e,domain:t}]})));return y._runUAPI(i)},y.get_ssl_certificate_if_available=function(e,t){var i=new o.Class;return i.initialize("Market","get_ssl_certificate_if_available"),i.addArgument("provider",e),i.addArgument("order_item_id",t),y._runUAPI(i)},y.get_installed_ssl_for_domain=function(e){var t=new o.Class;return t.initialize("SSL","installed_host"),t.addArgument("domain",e),y._runUAPI(t)},y.cancel_pending_ssl_certificate_and_poll=function(e,t){var i=N([["Market","cancel_pending_ssl_certificate",{provider:e,order_item_id:t}],["Market","get_ssl_certificate_if_available",{provider:e,order_item_id:t}]]);return y._runUAPI(i)},y.cancel_pending_ssl_certificates=function(e,t){var i=N(t.map((function(t){return["Market","cancel_pending_ssl_certificate",{provider:e,order_item_id:t}]})));return y._runUAPI(i)},y.cancel_certificate=function(t,i,r){y.cancel_pending_ssl_certificate(i,r).then((function(){e.forEach(t.get_selected_domains(),(function(e){e.selected=!1}))}))},y.process_ssl_pending_queue=function(){var e=f.defer(),t=new o.Class;return t.initialize("Market","process_ssl_pending_queue"),n.promise(t.getRunArguments()).done((function(t){(t=t.parsedResponse).status?e.resolve(t):e.reject(t.error)})),e.promise},y.hard_reset=function(){y.reset(),CPANEL.PAGE.domains=null},y.reset=function(){w=[],b=[],x=[],E=null,D=[],A={},S=[],V={}},y.reset_purchasing_certificates=function(){D=[]},y.dismiss_introduction=function(){I=!0},y.show_introduction_block=function(){return!I&&!g.getAlerts().length},y.parseCertificateDomainDetails=function(t){var i={};return e.forEach(t,(function(e){i[e.domain]=e.status})),i},y.parseCertificateStatusDetails=function(t,r){var a=[];return t?(r=r||{},e.forEach(t,(function(e,t){var n=_[t];if(n||(n={label:t,inProgress:""}),"not-applicable"!==e&&"certificateStatus"!==t&&"csrStatus"!==t&&e){var o;o="not-completed"===e?n.inProgress:"completed"===e?i.maketext("Complete."):e;var s={label:n.label,status:o,rawLabel:t,rawStatus:e};r[t]&&(s.actionLabel=c[t]||c.DEFAULT,s.actionURL=r[t],s.actionIcon=d[t]||d.DEFAULT),a.push(s)}})),a):a},y.getCertificateStatusDetails=function(e,t){var i=new o.Class;return i.initialize("Market","get_certificate_status_details",{provider:e,order_item_id:t}),y._runUAPI(i).then((function(e){return{statusDetails:y.parseCertificateStatusDetails(e.data.status_details,e.data.action_urls),domainDetails:y.parseCertificateDomainDetails(e.data.domain_details)}}))},y}])})),define("app/services/LocationService",["angular"],(function(e){"use strict";return e.module("App").factory("LocationService",["$location",function(e){return{go_to_last_create_route:function(){return e.path(this.last_create_route())},last_create_route:function(){return localStorage.getItem("tls_wizard_create_route")||localStorage.setItem("tls_wizard_create_route","/create"),localStorage.getItem("tls_wizard_create_route")},go_to_simple_create_route:function(){return localStorage.removeItem("tls_wizard_create_route"),this.go_to_last_create_route()},go_to_advanced_create_route:function(){return localStorage.setItem("tls_wizard_create_route","/create-advanced"),this.go_to_last_create_route()}}}])})),define("app/services/IdVerDefaults",["angular","lodash","app/services/CertificatesService"],(function(e,t){"use strict";return e.module("App").factory("IdVerDefaults",["CertificatesService",function(e){return{restore_previous:function(i,r){t.assign(i,r),e.get_products().forEach((function(e){e.x_identity_verification&&e.x_identity_verification.forEach((function(e){"date"===e.type&&i[e.name]&&(i[e.name]=new Date(i[e.name]))}))}))},set_defaults:function(t){var i={};["country_code"].forEach((function(e){i[e]=new Set})),e.get_products().forEach((function(e){e.x_identity_verification&&e.x_identity_verification.forEach((function(e){e.type in i&&i[e.type].add(e.name)}))})),i.country_code.forEach((function(e){t[e]=CPANEL.PAGE.guessed_country_code}))}}}])})),define("app/services/CountriesService",["angular"],(function(e){"use strict";return e.module("App").factory("CountriesService",[function(){return CPANEL.PAGE.countries}])})),define("app/views/VirtualHostsController",["angular","cjt/util/locale","jquery","cjt/modules","ngSanitize","app/services/CertificatesService","app/services/IdVerDefaults","cjt/filters/qaSafeIDFilter","cjt/directives/cpanel/searchSettingsPanel","cjt/directives/triStateCheckbox","cjt/directives/spinnerDirective","cjt/decorators/growlDecorator","app/services/CountriesService","app/services/LocationService"],(function(e,t,i){"use strict";e.module("App").controller("VirtualHostsController",["$rootScope","$scope","$controller","$location","$filter","$timeout","$sce","$routeParams","$window","CertificatesService","IdVerDefaults","spinnerAPI","growl","CountriesService","LocationService","SearchSettingsModel","alertService",function(r,a,n,o,s,c,d,_,l,u,p,f,m,g,h,v,y){a.show_introduction_block=u.show_introduction_block,a.domains=u.get_all_domains(),a.virtual_hosts=u.get_virtual_hosts(),a.pending_certificates=u.get_pending_certificates(),a.showExistingCertificates=!1,a.working_virtual_host=null,a.LOCALE=t,a.resolution_timeout=0,a.cart_items=[],a.filterValue=null,a.checkout_mode=!1,a.filteredProducts=[],a.showAdvancedSettings=!0,r.addToCartGrowl=null,a.COUNTRIES=g;var w={};a.identity_verification=w;for(var b=u.get_stored_extra_settings().advanced_identity_verification,k=0;k<a.virtual_hosts.length;k++){var x=a.virtual_hosts[k].get_display_name();w[x]={},b&&b[x]?p.restore_previous(w[x],b[x]):p.set_defaults(w[x])}e.forEach(a.virtual_hosts,(function(e){e.reset(),e.show_wildcards=!1})),a.domains=u.get_all_domains(),a.domains=s("filter")(a.domains,{is_wildcard:!1}),a.virtual_hosts=u.get_virtual_hosts(),a.virtual_hosts=s("filter")(a.virtual_hosts,(function(e){return!e.display_name.match(/^\*\./)})),a.searchFilterOptions=new v(u.get_product_search_options(),{certTerms:{"1_year":!0,"2_year":!1,"3_year":!1}}),a.filter_products=function(){var e=u.get_products();e=a.searchFilterOptions.filter(e),a.filteredProducts=e},a.slow_scroll_to_top=function(){i("body,html").animate({scrollTop:0},2e3)},a.go_to_product_filters=function(){a.showAdvancedSettings=!0,a.slow_scroll_to_top()};var S=["domains","providers","cert-info"],C=s("qaSafeID");a.get_cart_certs_title=function(){return t.maketext("[quant,_1,Certificate,Certificates]",a.get_cart_items().length)},a.get_vhost_showing_text=function(){var e=s("filter")(a.get_virtual_hosts(),a.filterValue);return t.maketext("[output,strong,Showing] [numf,_1] of [quant,_2,website,websites]",e.length,a.get_virtual_hosts().length)},a.get_domains_showing_text=function(e){var i=1+e.display_meta.start,r=e.display_meta.limit,a=e.get_domain_count(!0);return t.maketext("[output,strong,Showing] [numf,_1] - [numf,_2] of [quant,_3,domain,domains].",i,r,a)},a.deselect_unresolved_msg=function(e){var i=e.get_selected_domains().filter((function(e){return 0===e.resolved})).length;return t.maketext("Deselect all unresolved domains ([numf,_1]).",i)},a.go_to_pending=function(e){e?o.path("/pending-certificates/").search("orderItemID",e):o.path("/pending-certificates")},a.pending_certificate=function(t){var i=!1;return e.forEach(a.pending_certificates,(function(r){e.forEach(r.vhost_names,(function(e){e===t.display_name&&(i=r.order_item_id)}))})),i},a.get_certpanel_class=function(e){return a.pending_certificate(e)?"panel-default":"panel-primary"},a.view_pending_certificate=function(e){var t=a.pending_certificate(e);a.go_to_pending(t)},a.get_currency_string=function(e,i){e+=.001;var r=t.numf(e);return r="$"+r.substring(0,r.length-1),i&&(r+=" "+i),r},a.get_virtual_hosts=function(){var e=a.virtual_hosts;return a.filterValue&&(e=s("filter")(e,a.filterValue)),a.checkout_mode&&(e=s("filter")(e,{added_to_cart:!0})),e},a.get_virtual_host_classes=function(e){return{"col-lg-4":a.virtual_hosts.length>2,"col-lg-6":a.virtual_hosts.length<=2,"panel-success":e.is_ssl}},a.get_step_panel_classes=function(e,t){var i=["col-sm-12","col-xs-12"];return a.working_virtual_host===e.display_name?(i.push("col-md-4"),i.push("col-lg-4")):(i.push("col-md-12"),i.push("col-lg-12")),t&&i.push("cert-step-panel-current"),i},a.get_cart_price=function(){var t=0;return e.forEach(a.get_cart_items(),(function(e){t+=e.get_price()})),t},a.get_cart_items=function(){return a.cart_items=s("filter")(a.virtual_hosts,{added_to_cart:!0}),a.cart_items},a.checkout=function(){a.checkout_mode=!0},a.get_product_form_fields=function(){return[]},a.get_step=function(e){return e.get_step()},a.go_step=function(e,t){if(a.can_step(e,t))return e.go_step(t)},a.focus_virtual_host=function(){},a.check_selected_domains=function(e){(a.resolution_timeout&&c.cancel(a.resolution_timeout),e&&e.added_to_cart)&&(s("filter")(e.get_selected_domains(),(function(e){if(1!==e.resolved)return!0})).length&&(y.add({type:"danger",message:t.maketext("You have altered an item in your cart. The system has removed that item. After you make the necessary changes, add that item back to your cart."),group:"tlsWizard"}),a.remove_from_cart(e)));a.resolution_timeout=c((function(e){a.ensure_dns(e)}),850,!0,u.get_all_selected_domains())},a.deselect_domains=function(t){e.forEach(t,(function(e){e.selected=!1}))},a.get_current_or_default_provider=function(){return u.get_default_provider_name()},a.ensure_dns=function(t){if(!(t=s("filter")(t,{selected:!0,resolved:-1})).length)return!1;e.forEach(t,(function(e){e.resolving=!0,f.start(a.get_spinner_id(e.domain))}));var i=a.get_current_or_default_provider();return u.ensure_domains_can_pass_dcv(t,i).finally((function(){var i;e.forEach(t,(function(e){if(0===e.resolved&&e.selected){var t=u.get_virtual_host_by_display_name(e.vhost_name),r=a.virtual_hosts[t];if(r&&"providers"===r.get_step()){a.go_step(r,"domains");var n=l.document.getElementById(a.get_domain_id(e));n&&!i&&(i=n,c((function(){i.focus()})))}}f.stop(a.get_spinner_id(e.domain))}))}))},a.get_domain_id=function(e){return C(e.vhost_name+"_"+e.domain)},a.check_product_match=function(e,t){return!(!e||!t)&&(e.id===t.id&&e.provider===t.provider||void 0)},a.can_step=function(e,t){if(t===S[0])return!0;if(t===S[1])return!!e.get_selected_domains().length;if(t===S[2]){var i=e.get_product();if(!i)return!1;if(!(i=u.get_product_by_id(i.provider,i.id)))return!1;if(!a.get_product_form_fields(i))return!1}return!1},a.get_product_by_id=function(e,t){return u.get_product_by_id(e,t)},a.can_next_step=function(t){var i,r=t.get_step();return e.forEach(S,(function(e,t){e===r&&(i=S[t+1])})),a.can_step(t,i)},a.next_step=function(t){var i,r=t.get_step();e.forEach(S,(function(e,t){e===r&&(i=S[t+1])})),a.can_step(t,i)&&(a.focus_virtual_host(t),t.go_step(i))},a.get_spinner_id=function(e){return C("dns_resolving_"+e)},a.get_products=function(e){return a.filteredProducts},a.set_product=function(e,t){e.set_product_price(t.price),e.set_product(t)},a.all_domains_resolved=function(e){var t=e.get_selected_domains();return 0!==(t=s("filter")(t,(function(e){return 1===e.resolved}))).length},a.can_add_to_cart=function(e){var t=e.get_product();return!!t&&!!(t=u.get_product_by_id(t.provider,t.id))},a.add_to_cart=function(e){if(!a.can_add_to_cart(e)||!a.all_domains_resolved(e))return!1;e.added_to_cart=!0,e.go_step("added-to-cart"),e.set_identity_verification(a.identity_verification[e.display_name]),a.working_virtual_host=null,r.addToCartGrowl&&(r.addToCartGrowl.ttl=0,r.addToCartGrowl=null);var i={ttl:-1,variables:{buttonLabel:t.maketext("Proceed to checkout."),showAction:!0,action:function(){a.purchase()}}};r.addToCartGrowl=m.success(t.maketext("Item Successfully Added to Cart."),i)},a.get_domain_certificate=function(e){return u.get_domain_certificate(e)},a.view_existing_certificate=function(){},a.get_virtual_host_certificate=function(e){return u.get_virtual_host_certificate(e)},a.build_csr_url=function(e){var t=a.get_virtual_host_certificate(e);if(t&&t.certificate){var i="";return i+="../../ssl/install.html?id=",i+=encodeURIComponent(t.certificate.id)}},a.get_existing_certificate_name=function(e){var i,r=a.get_virtual_host_certificate(e);if(r&&r.certificate){var n=r.certificate;"dv"===n.validation_type?i=t.maketext("A [output,abbr,DV,Domain Validated] certificate is installed."):"ov"===n.validation_type?i=t.maketext("An [output,abbr,OV,Organization Validated] certificate is installed."):"ev"===n.validation_type?i=t.maketext("An [output,abbr,EV,Extended Validation] certificate is installed."):n.is_self_signed&&(i=t.maketext("A self-signed certificate is installed."))}return i||(i=t.maketext("A certificate of unknown type is installed.")),i},a.get_domain_lock_classes=function(e){var t=a.get_virtual_host_certificate(e);if(t&&t.certificate)return t.certificate.is_self_signed?"grey-padlock":"green-padlock"},a.remove_from_cart=function(e){r.addToCartGrowl&&(r.addToCartGrowl.ttl=0,r.addToCartGrowl.destroy(),r.addToCartGrowl=null),e.added_to_cart=!1},a.go_to_simple=function(){u.hard_reset(),h.go_to_simple_create_route().search("")},a.purchase=function(){r.addToCartGrowl&&(r.addToCartGrowl.ttl=0,r.addToCartGrowl.destroy(),r.addToCartGrowl=null),u.save({advanced_identity_verification:w})?o.path("/purchase"):y.add({type:"danger",message:t.maketext("Failed to save information to browser cache."),group:"tlsWizard"})},_.domain&&(e.forEach(s("filter")(a.domains,{domain:_.domain},!0),(function(e){e.selected=!0,a.check_selected_domains(e.vhost_name)})),a.virtual_hosts=u.get_virtual_hosts(),a.filterValue=_.domain)}])})),define("app/views/PurchaseSimpleController",["angular","lodash","cjt/util/locale","app/views/Certificate","app/services/CountriesService","cjt/modules","ngSanitize","app/services/CertificatesService","app/services/LocationService","app/services/IdVerDefaults","cjt/directives/cpanel/searchSettingsPanel","cjt/directives/triStateCheckbox","cjt/filters/qaSafeIDFilter","cjt/directives/spinnerDirective","cjt/directives/quickFiltersDirective"],(function(e,t,i){"use strict";e.module("App").controller("PurchaseSimpleController",["$rootScope","$scope","$controller","$location","$filter","$timeout","$sce","$routeParams","$window","CertificatesService","IdVerDefaults","CountriesService","Certificate","LocationService","SearchSettingsModel","alertService",function(r,a,n,o,s,c,d,_,l,u,p,f,m,g,h,v){a.show_introduction_block=u.show_introduction_block,a.domains=u.get_all_domains(!0),a.virtual_hosts=u.get_virtual_hosts(),a.pending_certificates=u.get_pending_certificates(),a.showExistingCertificates=!1,a.selected_domains=[],a.working_virtual_host=null,a.LOCALE=i,a.resolution_timeout=0,a.show_wildcard_domains=!0,a.cart_items=[],a.checkout_mode=!1,a.missing_base_domains=[],a.showAdvancedProductSettings=!0,a.panels={},r.addToCartGrowl=null,a.COUNTRIES=f,a.identity_verification={};var y=u.get_stored_extra_settings().simple_identity_verification;y?p.restore_previous(a.identity_verification,y):p.set_defaults(a.identity_verification),e.forEach(a.virtual_hosts,(function(e){e.reset(),e.show_wildcards=!0})),u.build_wildcard_map(),a.meta={sortReverse:!1,sortBy:"label",sortDirection:"asc",maxPages:5,totalItems:a.domains.length,currentPage:1,pageSize:20,pageSizes:[20,50,100,250],start:0,limit:20,filterValue:"",productFilterValue:""},a.cart_price_strings=null;function w(e){return!e.selected&&(!e.is_wildcard&&(0!==e.resolved&&(!a.domain_covered_by_wildcard(e)&&-1!==a.get_selected_vhosts().indexOf(e.virtual_host))))}function b(e){return 1!==e.resolved}a.searchFilterOptions=new h(u.get_domain_search_options()),a.productSearchFilterOptions=new h(u.get_product_search_options(),{certTerms:{"1_year":!0,"2_year":!1,"3_year":!1}}),a.displayProxySubdomains=!0,a.filter_domains=function(e){var t=e;return a.meta.filterValue&&(t=s("filter")(t,a.meta.filterValue)),t=a.searchFilterOptions.filter(t)},a.filter_products=function(e){var t=e,i=a.selected_domains,r=s("filter")(i,{is_wildcard:!0});return t=s("filter")(t,(function(e){if((e.wildcard_price||!r.length)&&(e.price||!(i.length-r.length>0)))return!0})),a.meta.productFilterValue&&(t=s("filter")(t,a.meta.productFilterValue)),t=a.productSearchFilterOptions.filter(t)},a.toggle_values=function(t,i,r){e.forEach(t,(function(e){e[i]=r}))},a.get_showing_text=function(){return i.maketext("[output,strong,Showing] [numf,_1] - [numf,_2] of [quant,_3,domain,domains]",a.meta.start,a.meta.limit,a.meta.totalItems)},a.get_resolution_text=function(e){return e.resolving?i.maketext("Running Domain Control Validation …"):0===e.resolved?i.maketext("Domain Control Validation failed: [_1]",e.resolution_failure_reason):1===e.resolved?e.dcvPassed.dns?(t=e.redirects_count?i.maketext("[asis,HTTP]-based Domain Control Validation required [quant,_1,redirection,redirections].",e.redirects_count):i.maketext("[asis,HTTP]-based Domain Control Validation failed."),i.maketext("Validated via [asis,DNS]-based Domain Control Validation.")+" ("+t+")"):i.maketext("Validated via [asis,HTTP]-based Domain Control Validation."):void 0;var t},a.get_domain_badge_color=function(e){return e.resolving?"info":1===e.resolved?"success":0===e.resolved?"danger":"default"},a.get_cert_status_color=function(e){var t=a.get_domain_certificate(e.domain).certificate;if(t)return"active"!==e.certificate_status||t.is_self_signed?"expired"===e.certificate_status?"label-danger":t.is_self_signed||"expiring_soon"===e.certificate_status?"label-warning":void 0:"label-success"},a.select_domain=function(e){if(e.selected&&e.is_wildcard){var t=s("filter")(a.domains,(function(t){return u.compare_wildcard_domain(e,t.domain)}));a.toggle_values(t,"selected",!0)}a.update_selected_domains(),a.check_selected_domains()},a.check_selected_domains=function(){a.resolution_timeout&&c.cancel(a.resolution_timeout),a.resolution_timeout=c((function(e){a.ensure_dns(e)}),850,!0,u.get_all_selected_domains())},a.update_selected_domains=function(){a.selected_domains=s("filter")(a.domains,(function(e){return!!e.selected&&!a.domain_covered_by_wildcard(e)})),a.current_certificate.set_domains(a.selected_domains),a.current_certificate.set_virtual_hosts(a.get_selected_vhosts()),a.update_baseless_wildcard_domains(),a.fetch_products(),a.update_cart_strings()},a.get_domain_certificate=function(e){return u.get_domain_certificate(e)},a.get_domain_certificate_type=function(e){if(e.certificate_type)return e.certificate_type;e.certificate_type="unsecured";var t=a.get_domain_certificate(e.domain);return t&&t.certificate&&!t.certificate.is_self_signed&&t.certificate.validation_type&&(e.certificate_type=t.certificate.validation_type),a.get_domain_certificate_type(e)},a.get_domain_cert_msg=function(e){if(e.certificate_status_msg)return e.certificate_status_msg;var t,r=a.get_domain_certificate(e.domain);if(r&&r.certificate){var n=r.certificate;"dv"===n.validation_type?t=i.maketext("A [output,abbr,DV,Domain Validated] certificate already secures this domain."):"ov"===n.validation_type?t=i.maketext("An [output,abbr,OV,Organization Validated] certificate already secures this domain."):"ev"===n.validation_type?t=i.maketext("An [output,abbr,EV,Extended Validation] certificate already secures this domain."):n.is_self_signed&&(t=i.maketext("A self-signed certificate already secures this domain."))}return t||(t=i.maketext("A certificate of unknown type already secures this domain.")),"expired"===e.certificate_status?t+=" "+i.maketext("The certificate has expired."):"expiring_soon"===e.certificate_status&&(t+=" "+i.maketext("It will expire soon.")),e.certificate_status_msg=t,a.get_domain_cert_msg(e)},a.pending_certificate=function(e){var t=a.pendingCertificateObject(e);return!!t&&t.order_item_id},a.pendingCertificateObject=function(t){var i=!1;return e.forEach(a.pending_certificates,(function(r){e.forEach(r.vhost_names,(function(e){e===t.virtual_host&&(i=r)}))})),i},a.view_pending_certificate=function(e){var t=a.pending_certificate(e);a.go_to_pending(t)},a.go_to_pending=function(e){e?o.path("/pending-certificates/").search("orderItemID",e):o.path("/pending-certificates")},a.get_domain_lock_classes=function(e){var t=a.get_domain_certificate(e.domain);if(t&&t.certificate)return t.certificate.is_self_signed||"expired"===e.certificate_status?"grey-padlock":"green-padlock"},a.build_csr_url=function(e){var t=a.get_virtual_host_certificate(e);if(t&&t.certificate){var i="";return i+="../../ssl/install.html?id=",i+=encodeURIComponent(t.certificate.id)}},a.get_domain_msg_state=function(e){var t=a.pendingCertificateObject(e);return t?u.doesDomainMatchOneOf(e.domain,t.domains)?"cert-pending":"cert-pending-other-domains":a.domain_covered_by_wildcard(e)?"covered-by-wildcard":a.get_domain_certificate(e.domain)&&-1===e.resolved&&!e.resolving?"ssl-exists":"default"},a.get_virtual_host_by_display_name=function(e){var t=u.get_virtual_host_by_display_name(e);return a.virtual_hosts[t]},a.get_virtual_host_certificate=function(e){return a.get_domain_certificate(e.domain)},a.ensure_dns=function(e){if(!(e=s("filter")(e,{selected:!0,resolved:-1})).length)return!1;var t=a.get_current_or_default_provider();return u.ensure_domains_can_pass_dcv(e,t)},a.get_current_or_default_provider=function(){var e=a.get_product();if(e){var t=a.get_product_by_id(e.provider,e.id);if(t)return t.provider_name}return u.get_default_provider_name()},a.get_dcv_class=function(e){var t=[];return e.resolving&&(t.push("fa-spinner"),t.push("fa-spin"),t.unshift("fa"),t.push("fa-sm")),t},a.get_other_vhost_domains=function(e){return s("filter")(a.domains,(function(t){return!t.is_wildcard&&(!t.selected&&(0!==t.resolved&&(t.domain!==e.domain&&t.virtual_host===e.virtual_host)))}))},a.get_selected_vhosts=function(){var e=a.get_covered_domains(),i=t.filter(e,{selected:!0});return t.uniq(i.map((function(e){return e.virtual_host})))},a.has_partial_vhosts=function(){return a.domains.some(w)},a.get_partial_vhost_domains=function(){return a.domains.filter(w)},a.get_undercovered_vhost_message=function(e){var t=e.map((function(e){return e.domain})),r="";return r+="<p>"+i.maketext("The certificate will secure some, but not all, of the domains on websites on which they exist.")+"</p>",r+="<p>"+i.maketext("If you choose to continue, the certificate will not secure the following [numerate,_1,domain,domains], and because a certificate will exist on their website, you may have to purchase a new certificate to secure all of these domains later. [list_and_quoted,_2]",t.length,t)+"</p>"},a.add_partial_vhost_domains=function(e){a.toggle_values(e,"selected",!0),a.update_selected_domains(),a.check_selected_domains(),a.goto("domains")},a.get_other_domains_msg=function(e,t){var r=t.map((function(e){return e.domain})),a="";return a+="<p>"+i.maketext("This certificate will not secure [quant,_2,other domain,other domains] on the same website as “[_1]”.",e.domain,r.length)+"</p>",a+="<p>"+i.maketext("Because you cannot secure a single website with multiple certificates, in order to secure any unselected [numerate,_1,domain,domains] in the future, you would need to purchase a new certificate to secure all of these domains.",r.length)+"</p>",a+="<p>"+i.maketext("Would you like to secure the following additional [numerate,_2,domain,domains] with this certificate? [list_and_quoted,_1]",r,r.length)+"</p>"},a.get_covered_domains=function(){return s("filter")(a.domains,(function(e){if(e.selected||a.domain_covered_by_wildcard(e))return!0}))},a.get_other_wildcard_domains=function(e){return!!e.is_wildcard&&s("filter")(a.domains,(function(t){return!t.selected&&(!t.is_wildcard&&(t.domain!==e.domain&&!1!==u.compare_wildcard_domain(e,t.domain)))}))},a.has_failed_dcv_domains=function(){return a.selected_domains.some(b)},a.get_failed_dcv_domains=function(){return a.selected_domains.filter(b)},a.get_failed_dcv_message=function(e){var t=e.map((function(e){return e.domain})),r="";return r+="<p>"+i.maketext("The following [numerate,_2,domain,domains] failed [numerate,_2,its,their] [output,abbr,DCV,Domain Control Validation] check: [list_and_quoted,_1]",t,t.length)+"</p>"},a.clear_failed_domains=function(e){a.toggle_values(e,"selected",!1),a.update_selected_domains(),0===a.selected_domains.length?a.goto("domains"):!1===a.check_unresolved_issues()&&a.goto("review")},a.domain_covered_by_wildcard=function(e){if(e.is_wildcard)return!1;var t=u.domain_covered_by_wildcard(e.domain);return!(!t||!t.selected)&&t},a.get_covered_by_wildcard_message=function(e){var t=a.domain_covered_by_wildcard(e);return t?i.maketext("The certificate for wildcard domain “[_1]” will secure this domain.",t.domain):""},a.is_domain_disabled=function(e){return!!a.pending_certificate(e)||(!!a.domain_covered_by_wildcard(e)||void 0)},a.get_currency_string=function(e,t){e+=.001;var r=i.numf(e);return r="$"+r.substring(0,r.length-1),t&&(r+=" "+t),r},a.get_products=function(){return u.get_products()},a.cant_checkout_msg=function(){v.add({type:"warn",message:i.maketext("You cannot check out until you resolve all errors (in red)."),closeable:!0,replace:!1,group:"tlsWizard"})},a.cant_products_msg=function(){v.add({type:"warn",message:i.maketext("You need to select at least one domain before you can select a product."),closeable:!0,replace:!1,group:"tlsWizard"})},a.clear_cloud_domain=function(e){e.selected=!1,a.update_selected_domains(),0===a.selected_domains.length&&a.panels.review&&a.goto("domains")},a.goto=function(t){"review"===t&&a.blocker_issues_exist()?a.cant_checkout_msg():("products"!==t||a.selected_domains.length||(a.cant_products_msg(),t="domains"),e.forEach(a.panels,(function(e,t){a.panels[t]=!1})),a.panels[t]=!0)},a.get_product_name=function(e){if(!e)return"";var t=a.get_product_by_id(e.provider,e.id);return t?t.display_name:""},a.get_product_by_id=function(e,t){return u.get_product_by_id(e,t)},a.check_product_match=function(e){var t=a.get_product();return!(!e||!t)&&(e.id===t.id&&e.provider===t.provider||void 0)},a.get_per_price_string=function(e){var t=[];return e.price&&(t[t.length]=i.maketext("[_1] per domain",a.get_currency_string(e.price,e.price_unit))),e.wildcard_price&&(t[t.length]=i.maketext("[_1] per wildcard domain",a.get_currency_string(e.wildcard_price))),t.join(", ")},a.get_product_estimate_string=function(e){var t=a.get_currency_string(a.calculate_product_price(e));return"("+i.maketext("[_1] total",t,e.price_unit)+")"};var k=function(e,t,i){if(e){var r=0;if(i.length&&e.wildcard_price&&(r+=i.length*e.wildcard_price),t.length&&e.price&&(r+=t.length*e.price),e.wildcard_parent_domain_included){var a={};t.forEach((function(e){a[e.domain]=e})),i.forEach((function(t){var i=t.domain.replace(/^\*\./,"");a[i]&&(r-=e.price)}))}return r}};a.calculate_product_price=function(e){var t=a.selected_domains,i=s("filter")(t,{is_wildcard:!0}),r=s("filter")(t,{is_wildcard:!1});return k(e,r,i)},a.set_product=function(e){a.current_certificate.set_product(e)},a.get_product=function(){return a.current_certificate.get_product()},a.get_product_prices=function(){var e=[],i=a.selected_domains,r=i.filter((function(e){return!!e.is_wildcard})),n=i.filter((function(e){return!e.is_wildcard}));return a.filteredProductList.forEach((function(t){var i=k(t,n,r);e.push(i)})),t.sortBy(e)},a.get_min_price=function(){return a.get_product_prices().shift()},a.get_max_price=function(){return a.get_product_prices().pop()},a.check_unresolved_issues=function(){return!!a.has_partial_vhosts()||!!a.has_failed_dcv_domains()},a.update_baseless_wildcard_domains=function(){if(a.missing_base_domains=[],a.selected_domains.forEach((function(e){if(!1!==e.is_wildcard){var t=u.get_domain_by_domain(e.stripped_domain);t.selected||a.missing_base_domains.push(t)}})),a.missing_base_domains.length){var e=a.missing_base_domains.map((function(e){return e.domain}));v.add({type:"info",message:i.maketext("Because wildcard certificates require their parent domains, the system added the following [numerate,_1,domain,domains] for you: [list_and_quoted,_2]",e.length,e),closeable:!0,replace:!1,group:"tlsWizard"}),a.select_baseless_wildcard_domains(a.missing_base_domains)}},a.select_baseless_wildcard_domains=function(e){a.toggle_values(e,"selected",!0),a.update_selected_domains()},a.get_resolve_panel_color=function(){var e="warning";return a.has_partial_vhosts()&&(e="warning"),a.has_failed_dcv_domains()&&(e="danger"),e},a.blocker_issues_exist=function(){return"danger"===a.get_resolve_panel_color()},a.get_cart_price=function(){if(!a.get_product())return 0;var e=a.get_product_by_id(a.get_product().provider,a.get_product().id),t=a.calculate_product_price(e);return a.current_certificate.set_price(t),t},a.get_cart_strings=function(){return a.cart_price_strings},a.update_cart_strings=function(){var e=a.get_product(),t=a.get_product_prices(),i=a.selected_domains,r={min:0,max:0};e&&i.length?r.min=a.get_currency_string(a.get_cart_price(),"USD"):i.length?(r.min=a.get_currency_string(a.get_min_price(),"USD"),t.length>1&&(r.max=a.get_currency_string(a.get_max_price(),"USD"))):a.cart_price_strings=!1,a.cart_price_strings=r},a.get_cart_items=function(){return a.cart_items=[a.current_certificate],a.cart_items},a.purchase=function(){a.blocker_issues_exist()?a.cant_checkout_msg():(a.current_certificate.set_identity_verification(a.identity_verification),u.add_new_certificate(a.current_certificate),u.save({simple_identity_verification:a.identity_verification})?o.path("/purchase"):v.add({type:"danger",message:i.maketext("Failed to save information to browser cache."),group:"tlsWizard"}))},a.selectFilterType=function(e){a.meta.quickFilterValue="all"===e?"":e,a.fetch()},a.go_to_advanced=function(){u.hard_reset(),g.go_to_advanced_create_route().search("")},a.get_wildcard_base_domain_msg=function(){return i.maketext("This certificate includes the parent domain in the price of the certificate.")},a.fetch=function(){var i=[];if(i=a.filter_domains(a.domains),e.forEach(i,(function(e){a.get_domain_certificate_type(e)})),i=""!==a.meta.filterValue?i.sort((function(e,t){return e.domain.length===t.domain.length?0:a.meta.filterValue.length/e.domain.length<a.meta.filterValue.length/t.domain.length?-1:1})):i.sort((function(e,t){return e.domain==="*."+t.domain?-1:"*."+e.domain===t.domain?1:t.stripped_domain.localeCompare(e.stripped_domain)})),""!==a.meta.sortDirection&&""!==a.meta.sortBy&&(i=s("orderBy")(i,a.meta.sortBy,"asc"===a.meta.sortDirection)),a.meta.totalItems=i.length,a.meta.totalItems>t.min(a.meta.pageSizes)){var r=(a.meta.currentPage-1)*a.meta.pageSize,n=a.meta.pageSize;i=s("limitTo")(s("startFrom")(i,r),n),a.showPager=!0,a.meta.start=r+1,a.meta.limit=r+i.length}else a.showPager=!1,0===i.length?a.meta.start=0:a.meta.start=1,a.meta.limit=i.length;var o=0;return i.forEach((function(e){-1!==a.selected_domains.indexOf(e.id)?e.rowSelected=!0:(e.rowSelected=!1,o++)})),a.filteredList=i,a.allRowsSelected=i.length>0&&0===o,i},a.fetch_products=function(){var e=this.get_products();return a.filteredProductList=a.filter_products(e),a.filteredProductList},a.init=function(){if(_.domain){var i=_.domain;t.isString(i)&&(i=[i]),e.forEach(i,(function(e){var t=u.get_domain_by_domain(e);t&&(t.selected=!0)}))}var r=u.get_product_search_options(),n={certTerms:{"1_year":!0,"2_year":!1,"3_year":!1}};if(_.certificate_type){var o=_.certificate_type;t.isString(o)&&(o=[o]);var s={};void 0===r.validationType?s.all=!0:e.forEach(r.validationType.options,(function(e){s[e.value]=-1!==o.indexOf(e.value)})),n.validationType=s}a.searchFilterOptions=new h(u.get_domain_search_options()),a.productSearchFilterOptions=new h(u.get_product_search_options(),n),a.fetch(),a.fetch_products(),a.current_certificate=new m,a.update_selected_domains(),a.selected_domains.length?(a.check_selected_domains(),a.goto("products")):a.goto("domains")},a.init()}])})),define("app/views/CheckoutController",["lodash","angular","jquery","cjt/util/locale","cjt/util/query","app/views/Certificate","cjt/modules","app/services/CertificatesService","app/services/LocationService","cjt/directives/spinnerDirective","uiBootstrap"],(function(e,t,i,r,a){"use strict";t.module("App").controller("CheckoutController",["$scope","$controller","$location","$filter","$routeParams","$window","$timeout","CertificatesService","spinnerAPI","$q","$uibModal","$log","Certificate","LocationService","alertService",function(n,o,s,c,d,_,l,u,p,f,m,g,h,v,y){var w={cPStore:["login","send_cart_items","checkout","payment_callback","checkout_complete"],default:["login","send_cart_items","checkout","payment_callback","checkout_complete"]};function b(e){return e.replace(/^\s*-\S+/,"").replace(/-\S+\s*$/,"").replace(/\s+/g,"")}function k(){i(".checkout-step-inner").each((function(e,t){var r=(t=i(t)).find(".content-wrapper"),a=(t.height()-r.height())/2;r.css("padding-top",a)}))}n.pending_certificates=u.get_pending_certificates(),n.LOCALE=r,n.purchase_steps=[],n.current_step=-1,n.start_step=null,n.providers=[],n.certificates_count=0,n.steps=[],n.html_escape=e.escape.bind(e),n.get_step_classes=function(e,t){var i=n.get_steps(e.name).length,r=n.get_step_index(e.name,t),a=Math.floor(12/i),o=["col-xs-12","col-sm-12","col-md-"+a,"col-lg-"+a,"checkout-step"];return n.current_step_index===r?(o.push("checkout-step-current"),"checkout_complete"===t&&o.push("checkout-step-completed")):n.current_step_index>r&&o.push("checkout-step-completed"),o},n.cert_count_title=function(){return r.maketext("Purchasing [quant,_1,certificate,certificates] …",n.certificates_count)},n.get_purchases_title=function(e){return r.maketext("Completing [numerate,_2,purchase,purchases] for the “[_1]” provider …",n.html_escape(e.display_name),e.certificates.length)},n.sending_items_msg=function(){return r.maketext("Sending your [numerate,_1,item,items] to the store cart …",n.certificates_count)},n.starting_polling_msg=function(){return r.maketext("Starting background polling for the [numerate,_1,certificate,certificates]. The system will download and install the [numerate,_1,certificate,certificates] when available.",n.certificates_count)},n.get_provider_by_name=function(e){for(var t=0;t<n.providers.length;t++)if(n.providers[t].name===e)return n.providers[t]},n.get_steps=function(e){return w[e]?w[e]:w.default},n.get_current_step=function(){return n.steps[n.current_step_index]},n.get_step_index=function(e,t){for(var i=0;i<n.steps.length;i++)if(n.steps[i].provider===e&&n.steps[i].step===t)return i;return 0},n.get_step_url=function(e){return"/"+encodeURIComponent(e.provider)+"/"+encodeURIComponent(e.step)},n.get_next_step=function(){if(n.current_step_index+1<n.steps.length)return n.steps[n.current_step_index+1]},n.get_param=function(e){return a.parse_query_string(location.search.replace(/^\?/,""))[e]||d[e]},n.require_params=function(e){var i=[],a=[];return t.forEach(e,(function(e){var t=n.get_param(e);t?t instanceof Array&&a.push(e):i.push(e)})),i.length&&y.add({type:"danger",message:r.maketext("The following [numerate,_1,parameter is,parameters are] required but [numerate,_1,does,do] not appear in the [asis,URL]: [list_and_quoted,_2]",i.length,i),group:"tlsWizard"}),a.length&&y.add({type:"danger",message:r.maketext("The following [numerate,_1,parameter appears,parameters appear] more than once in the [asis,URL]: [list_and_quoted,_2]",a.length,a),group:"tlsWizard"}),!i.length&&!a.length},n.in_debug_mode=!1,n.get_route_url=function(){var e="";return e+=s.absUrl().replace(/tls_wizard\/.+/,"tls_wizard/#/purchase")},n.dismiss_modal=function(){this.modal.dismiss()},n.go_to_purchase_page=v.go_to_last_create_route,n.go_to_login=function(){this.go_step(this.get_current_step().provider,"login")},n.do_current_step=function(){var i=n.get_current_step();if(i){var a,o=n.get_next_step(),c=n.get_param("order_id"),d=n.get_param("code"),p=u.get_order_by_id(c),g=n.get_param("order_status"),h=n.get_provider_by_name(i.provider),w=n.get_param("access_token");if("login"===i.step)a=n.get_route_url()+n.get_step_url(i),p&&(a+="?order_id="+p.order_id),d?u.verify_login_token(i.provider,d,a).then((function(e){p?n.go_step(i.provider,"checkout",{order_id:p.order_id,access_token:e.data.access_token}):n.go_step(i.provider,"send_cart_items",{access_token:e.data.access_token})}),(function(e){n.return_to_wizard(),y.add({type:"danger",message:r.maketext("The system encountered an error as it attempted to verify the login token: [_1]",e)+" "+r.maketext("You will now return to the beginning of the wizard."),closeable:!0,replace:!1,group:"tlsWizard"})})):u.get_store_login_url(i.provider,a).then((function(e){_.location.href=e.data}),(function(e){n.return_to_wizard(),y.add({type:"danger",message:r.maketext("The system encountered an error as it attempted to get the store login [output,abbr,URL,Uniform Resource Location]: [_1]",e)+" "+r.maketext("You will now return to the beginning of the wizard."),closeable:!0,replace:!1,group:"tlsWizard"})}));else{if("send_cart_items"===i.step){if(!n.require_params(["access_token"]))return;return a=n.get_route_url()+n.get_step_url(o),u.request_certificates(i.provider,w,h.certificates).then((function(e){var t=e.data;t.order_id=t.order_id.toString(),u.add_order(t),u.save(),n.go_step(i.provider,"checkout",{order_id:t.order_id,access_token:w})}),(function(e){n.return_to_wizard(),y.add({type:"danger",message:r.maketext("The system encountered an error as it attempted to request the [asis,SSL] [numerate,_2,certificate,certificates]: [_1]",e,n.get_provider_by_name(i.provider).certificates.length)+" "+r.maketext("You will now return to the beginning of the wizard."),closeable:!0,replace:!1,group:"tlsWizard"})}))}if("checkout"===i.step){if(!n.require_params(["order_id"]))return;if(a=n.get_route_url()+n.get_step_url(i),g)n.go_step(i.provider,"payment_callback",{order_id:p.order_id,order_status:g});else{if(!n.require_params(["access_token"]))return;u.set_url_after_checkout(i.provider,w,p.order_id,a).then((function(){_.location.href=p.checkout_url}),(function(t){t.data&&"OrderNotFound"===t.data.error_type?(n.order_id=p.order_id,n.provider=n.get_provider_by_name(i.provider),n.modal=m.open({template:document.getElementById("user-mismatch-modal").text,scope:n,backdrop:"static",animation:!1,size:"sm"})):(v.go_to_last_create_route(),y.add({type:"danger",message:r.maketext("The system encountered an error as it attempted to set the [asis,URL] after checkout: [_1]",e.escape(t.error))+" "+r.maketext("You will now return to the beginning of the wizard."),closeable:!0,replace:!1,group:"tlsWizard"}))}))}}else if("payment_callback"===i.step){if(CPANEL.PAGE.pending_certificates=null,CPANEL.PAGE.installed_hosts=null,"success"!==g){if("error"===g)u.reset(),u.save(),n.return_to_wizard(),y.add({type:"danger",message:r.maketext("The system encountered an error as it attempted to complete your transaction.")+" "+r.maketext("You will now return to the beginning of the wizard."),closeable:!0,replace:!1,group:"tlsWizard"});else if(/^cancel?led$/.test(g)){var k=[];t.forEach(p.certificates,(function(e){k.push(e.order_item_id)})),y.add({type:"warn",message:r.maketext("You seem to have canceled your transaction.")+" "+r.maketext("You will now return to the beginning of the wizard."),closeable:!0,replace:!1,group:"tlsWizard"}),s.url(s.path()),u.cancel_pending_ssl_certificates(i.provider,k).then((function(){u.reset(),u.save(),n.return_to_wizard()}),(function(e){y.add({type:"danger",message:r.maketext("The system encountered an error as it attempted to cancel your transaction: [_1]",e)+" "+r.maketext("You will now return to the beginning of the wizard."),closeable:!0,replace:!1,group:"tlsWizard"})}))}return!1}y.add({type:"success",message:r.maketext("You have successfully completed your certificate order (order ID “[_1]”). If you need help with this order, use the support [numerate,_2,link,links] below.",e.escape(c),p.certificates.length),closeable:!0,replace:!1,autoClose:1e4,group:"tlsWizard"}),u.set_confirmed_status_for_ssl_certificates(i.provider,p).then((function(){n.go_step(i.provider,o.step)}),(function(t){if(t.data&&"EntryDoesNotExist"===t.data.error_type){var a=t.data.order_item_ids,o=r.maketext("There are no pending certificates from “[_1]” with the following order item [numerate,_2,ID,IDs]: [join,~, ,_3]. The system will now verify that the [numerate,_2,certificate has,certificates have] been issued and installed.",e.escape(i.provider),a.length,a.map(e.escape.bind(e)));y.add({type:"info",message:o,closeable:!0,replace:!1,autoClose:1e4,group:"tlsWizard"});var s=h.certificates;a.forEach((function(t){var a=u.get_ssl_certificate_if_available(i.provider,t);s.forEach((function(n){n.get_virtual_hosts().forEach((function(o){var s=n.get_domains().filter((function(e){return e.virtual_host===o})).pop().domain;(function(e){if(!(e instanceof Array))throw"Only arrays here!";return f.all(e.map((function(e,t){return f((function(i,r){e.then(i,(function(e){r([t,e])}))}))})))})([u.get_installed_ssl_for_domain(),a]).then((function(a){var n,d=a[0].data.certificate.text;d&&(n=b(d));var _,l=a[1].data.certificate_pem;if(!l){var p,f=a[1].data,m=f.status_code,g=f.status_message;if(/OrderCancell?ed/.test(m))p=r.maketext("“[_1]” indicated that the order with [asis,ID] “[_2]” has been canceled.",e.escape(i.provider),e.escape(c));else if(/OrderItemCancell?ed/.test(m))p=r.maketext("“[_1]” indicated that the certificate with order item [asis,ID] “[_2]” has been canceled.",e.escape(i.provider),e.escape(t));else{p=r.maketext("“[_1]” has not issued a certificate for order item [asis,ID] “[_2]”. Contact them for further assistance.",e.escape(i.provider),e.escape(t));var h=[m,g].filter((function(e){return!!e})).join(": ");h&&(p+=" ("+h+")")}return y.add({type:"danger",message:p,closeable:!0,replace:!1,group:"tlsWizard"}),void v.go_to_last_create_route()}b(l)===n&&(y.add({type:"success",message:r.maketext("The system confirmed that the certificate for the website “[_1]” is installed.",e.escape(o)),closeable:!0,replace:!1,autoClose:1e4,group:"tlsWizard"}),n?y.add({type:"info",message:r.maketext("“[_1]” has an [asis,SSL] certificate installed, but it is not the certificate that you just ordered (order item [asis,ID] “[_2]”). The system will now install this certificate.",e.escape(o),e.escape(t)),closeable:!0,replace:!1,autoClose:1e4,group:"tlsWizard"}):(_=r.maketext("You do not have an [asis,SSL] certificate installed for the website “[_1]”.",e.escape(o)),_+=r.maketext("The system will now install the new certificate."),y.add({type:"info",message:_,closeable:!0,replace:!1,autoClose:1e4,group:"tlsWizard"}),u.install_certificate(l,[s]).then((function(){y.add({type:"success",message:r.maketext("The system installed the certificate onto the website “[_1]”.",e.escape(o)),closeable:!0,replace:!1,autoClose:1e4,group:"tlsWizard"})}),(function(t){y.add({type:"danger",message:r.maketext("The system failed to install the certificate onto the website “[_1]” because of the following error: [_2]",e.escape(o),t),closeable:!0,replace:!1,group:"tlsWizard"})})).then(v.go_to_last_create_route)))}),(function(a){var n=a[0],s=a[1];0===n?y.add({type:"danger",message:r.maketext("The system failed to locate the installed [asis,SSL] certificate for the website “[_1]” because of the following error: [_2]",e.escape(o),s),closeable:!0,replace:!1,group:"tlsWizard"}):1===n?y.add({type:"danger",message:r.maketext("The system failed to query “[_1]” for order item [asis,ID] “[_2]” ([_3]) because of the following error: [_4]",e.escape(i.provider),e.escape(t),e.escape(o),s),closeable:!0,replace:!1,group:"tlsWizard"}):y.add({type:"danger",message:"Unknown index: "+n,closeable:!0,replace:!1,group:"tlsWizard"}),v.go_to_last_create_route()}))}))}))}))}else{var d=t.error;y.add({type:"danger",message:r.maketext("The system failed to begin polling for [quant,_2,new certificate,new certificates] because of an error: [_1]",d,n.certificates_count)+" "+r.maketext("You will now return to the beginning of the wizard."),closeable:!0,replace:!1,group:"tlsWizard"})}}))}else"checkout_complete"===i.step&&(o||(u.reset(),u.save(),y.add({type:"success",message:r.maketext("The system has completed the [numerate,_1,purchase,purchases] and will begin to poll for your [numerate,_2,certificate,certificates].",n.providers.length,n.certificates_count),closeable:!0,replace:!1,autoClose:1e4,group:"tlsWizard"}),l(n.go_to_pending,1e3)))}}else v.go_to_last_create_route()},n.return_to_wizard=function(){var e=s.absUrl();if(n.get_param("code")){var t=e.replace(/([^#?]+\/).*/,"$1#"+v.last_create_route());_.location.href=t}else v.go_to_last_create_route()},n.check_step_success=function(e){if(e<n.current_step_index)return!0},n.go_step=function(e,t,i){s.path("/purchase/"+e+"/"+t+"/"),i&&s.search(i)},n.get_providers=function(){var e;return n.providers=[],n.purchasing_certs.forEach((function(i){var r=i.get_product(),a=n.get_provider_by_name(r.provider);a||(a={name:r.provider,display_name:r.provider_display_name||r.provider,certificates:[]},n.providers.push(a),e=n.get_steps(a.name),t.forEach(e,(function(e){n.steps.push({provider:a.name,step:e})}))),a.certificates.push(i),n.certificates_count++})),n.providers},n.go_to_pending=function(e){e?s.path("/pending-certificates/").search("orderItemID",e):s.path("/pending-certificates")},n.pending_certificate=function(e){var i=!1;return t.forEach(n.pending_certificates,(function(r){t.forEach(r.vhost_names,(function(t){t===e.display_name&&(i=r.order_item_id)}))})),i},n.view_pending_certificate=function(e){var t=n.pending_certificate(e);n.go_to_pending(t)},n.begin=function(){n.purchasing_certs=u.get_purchasing_certs(),0===n.purchasing_certs.length&&(u.get_virtual_hosts().filter((function(e){if(!e.has_selected_domains())return!1;var t=e.get_product();return t?!!u.get_product_by_id(t.provider,t.id)||(g.warn("Unknown product!",t),!1):(g.warn("has selected, but no product?"),!1)})).forEach((function(e){var t=e.get_product(),i=new h;if(i.set_product(t),i.set_price(e.get_price()),i.set_domains(e.get_selected_domains()),i.set_virtual_hosts([e.display_name]),t.x_identity_verification){var r=e.get_identity_verification();r&&i.set_identity_verification(r)}u.add_new_certificate(i)})),n.purchasing_certs=u.get_purchasing_certs()),n.get_providers(),n.current_provider_name=d.provider,n.current_step_id=d.step,n.current_step_index=n.get_step_index(n.current_provider_name,n.current_step_id),n.do_current_step(),l((function(){k()}),1)},n.init=function(){u.restore(),n.begin()},t.element(_).bind("resize",k),n.init()}])})),define("app/views/PendingCertificatesController",["lodash","angular","cjt/util/locale","app/views/Certificate","cjt/modules","cjt/directives/spinnerDirective","app/services/CertificatesService","app/services/LocationService","cjt/directives/actionButtonDirective"],(function(e,t,i){"use strict";t.module("App").controller("PendingCertificatesController",["$scope","$location","$routeParams","$anchorScroll","$timeout","$window","CertificatesService","LocationService","Certificate","alertService",function(r,a,n,o,s,c,d,_,l,u){var p={};CPANEL.PAGE.products.forEach((function(e){p[e.provider]=e.provider_display_name})),r.show_introduction_block=d.show_introduction_block,r.get_provider_display_name=function(e){return p[e]||e},r.html_escape=e.escape,r.get_time=function(){return parseInt(Date.now()/1e3,10)},r.LOCALE=i,r.checking_pending_queue=!1,r.cjt1_LOCALE=window.LOCALE,r.pending_certificates=d.get_pending_certificates(),r.expanded_cert=null,r.get_product_by_id=function(e,t){return d.get_product_by_id(e,t)},r.get_cert_title=function(e){var t=e.domains.sort((function(e,t){return e.length===t.length?0:e.length>t.length?1:-1}));return 1===t.length?t[0]:i.maketext("“[_1]” and [quant,_2,other domain,other domains]",t[0],t.length-1)},r.check_pending_queue=function(){return d.process_ssl_pending_queue().then((function(a){var n=[],o=0;if(a.data.forEach((function(t){if(o+=1*t.deleted,t.installed)n.push(t);else{var a,s,c=t.domains,d=r.get_provider_display_name(t.provider),_=e.escape(d),l=e.escape(c[0]),p=c.length-1;switch(t.last_status_code){case"OrderCanceled":case"OrderItemCanceled":s="info",a=p?i.maketext("“[_1]” reports that the certificate for “[_2]” and [quant,_3,other domain,other domains] has been canceled.",_,l,p):i.maketext("“[_1]” reports that the certificate for “[_2]” has been canceled.",_,l);break;case"CA:revoked":s="danger",a=p?i.maketext("“[_1]” reports that the certificate authority issued but then revoked the certificate for “[_2]” and [quant,_3,other domain,other domains].",_,l,p):i.maketext("“[_1]” reports that the certificate authority issued but then revoked “[_2]”’s certificate.",_,l);break;case"CA:rejected":s="danger",a=p?i.maketext("“[_1]” reports that the certificate authority rejected the request for a certificate for “[_2]” and [quant,_3,other domain,other domains].",_,l,p):i.maketext("“[_1]” reports that the certificate authority rejected the request for a certificate for “[_2]”.",_,l)}t.last_status_message&&(a+=" ("+e.escape(t.last_status_message)+")"),u.add({type:s,message:a,closeable:!0,replace:!1,group:"tlsWizard"})}})),n.length){var s=[];t.forEach(n,(function(e){s=s.concat(e.vhost_names)})),u.add({type:"success",message:i.maketext("[numerate,_2,A certificate,Certificates] for the following [numerate,_2,website was,websites were] available, and the system has installed [numerate,_2,it,them]: [list_and_quoted,_1]",s,n.length),closeable:!0,replace:!1,autoClose:1e4,group:"tlsWizard"})}else o||u.add({type:"info",message:i.maketext("The system processed the pending certificate queue successfully, but [numerate,_1,your pending certificate was not,none of your pending certificates were] available.",a.data.length),closeable:!0,replace:!1,group:"tlsWizard"});return d.fetch_pending_certificates().then((function(){r.pending_certificates=d.get_pending_certificates(),0===r.pending_certificates.length?(u.add({type:"info",message:i.maketext("You have no more pending [asis,SSL] certificates.")+" "+i.maketext("You will now return to the beginning of the wizard."),closeable:!0,replace:!1,group:"tlsWizard"}),d.reset(),CPANEL.PAGE.installed_hosts=null,CPANEL.PAGE.domains=null,r.get_new_certs()):(r.prepare_pending_certificates(),r.expanded_cert&&t.forEach(r.pending_certificates,(function(e){e.order_item_id===r.expanded_cert&&r.load_certificate_details(e)})))}))}))},r.reset_and_create=function(){d.hard_reset(),r.get_new_certs()},r.get_new_certs=function(){_.go_to_last_create_route().search("")},r.cancel_purchase=function(t){d.cancel_pending_ssl_certificate_and_poll(t.provider,t.order_item_id).then((function(a){var n=a.data[1].parsedResponse.data,o=n.certificate_pem,s=e.escape(r.get_provider_display_name(t.provider));return o?(u.add({type:"info",message:i.maketext("You have canceled this order, but “[_1]” already issued the certificate. The system will now install it. ([output,url,_2,Do you need help with this order?])",s,t.support_uri),closeable:!0,replace:!1,group:"tlsWizard"}),d.install_certificate(o,t.vhost_names).then((function(){u.add({type:"success",message:i.maketext("The system has installed the new [asis,SSL] certificate on to the [numerate,_1,website,websites] [list_and_quoted,_2].",t.vhost_names.length,t.vhost_names),closeable:!0,replace:!1,autoClose:1e4,group:"tlsWizard"})}),(function(e){u.add({type:"danger",message:i.maketext("The system failed to install the new [asis,SSL] certificate because of an error: [_1]",e),group:"tlsWizard"})}))):"RequiresApproval"===n.status_code?u.add({type:"info",message:i.maketext("The system has canceled the request for this certificate; however, “[_1]” was already waiting on approval before processing your order. To ensure that this certificate order is canceled, you must [output,url,_2,contact support directly].",s,t.support_uri),closeable:!0,replace:!1,group:"tlsWizard"}):"OrderCanceled"===n.status_code?u.add({type:"info",message:i.maketext("This certificate’s order (ID “[_1]”) was already canceled directly via “[_2]”.",e.escape(t.order_id),s),closeable:!0,replace:!1,group:"tlsWizard"}):"OrderItemCanceled"===n.status_code?u.add({type:"info",message:i.maketext("This certificate (order item ID “[_1]”) was already canceled directly via “[_2]”.",e.escape(t.order_item_id),s),closeable:!0,replace:!1,group:"tlsWizard"}):u.add({type:"success",message:i.maketext("The system has canceled this certificate. Your credit card should not be charged for this order."),closeable:!0,replace:!1,autoClose:1e4,group:"tlsWizard"}),CPANEL.PAGE.pending_certificates=null,d.fetch_pending_certificates().then((function(){r.pending_certificates=d.get_pending_certificates(),0===r.pending_certificates.length?r.get_new_certs():r.prepare_pending_certificates()}),(function(e){u.add({type:"danger",message:i.maketext("The system encountered an error as it attempted to refresh your pending certificates: [_1]",e),group:"tlsWizard"})}))}),(function(e){u.add({type:"danger",message:i.maketext("The system encountered an error as it attempted to cancel your transaction: [_1]",e),group:"tlsWizard"})}))};var f=function(e,t){e.domainDetails&&(t.orderDetails=e.domainDetails[t.domain])};r.get_displayed_domains=function(e){var t=e.domains,i=e.display_meta.items_per_page*(e.display_meta.current_page-1),r=Math.min(t.length,i+e.display_meta.items_per_page);if(e.displayed_domains&&e.display_meta.start===i&&e.display_meta.limit===r&&e.displayed_domains.length)return e.displayed_domains;e.display_meta.start=i,e.display_meta.limit=r;for(var a=[],n=e.display_meta.start;n<e.display_meta.limit;n++){var o={domain:t[n]};f(e,o),a.push(o)}return e.displayed_domains=a,e.displayed_domains},r.get_cert_status=function(e){var t=function(e,t){var a;if("RequiresApproval"===e){var n=r.get_providerDisplayName(t);a=i.maketext("Waiting for “[_1]” to approve your order …",n)}return a}(e.last_status_code,e.provider);if(t)return t;var a=e.status;if("unconfirmed"===a)return i.maketext("Pending Completion of Payment");if("confirmed"===a){if(e.statusDetails&&e.statusDetails.loaded){var n=e.statusDetails.details.filter((function(e){return"not-completed"===e.rawStatus}));return 0===n.length?i.maketext("Payment Completed.")+" "+i.maketext("Awaiting Validation …"):1===n.length?i.maketext("Payment Completed.")+" "+n[0].status:i.maketext("Payment Completed.")+" "+i.maketext("Multiple validation items pending …")}return i.maketext("Payment Completed.")+" "+i.maketext("Waiting for the provider to issue the certificate …")}return i.maketext("Status Unknown")},r.toggle_cert_collapse=function(e){r.expanded_cert===e.order_item_id?r.collapse_cert(e):r.expand_cert(e)},r.expand_cert=function(e){a.search("orderItemID",e.order_item_id),r.expanded_cert=e.order_item_id,e.statusDetails||r.load_certificate_details(e),o(r.expanded_cert)},r.load_certificate_details=function(e){e.domainDetails={},e.statusDetails={loaded:!1,loading:!0,details:[]},d.getCertificateStatusDetails(e.provider,e.order_item_id).then((function(r){e.statusDetails.loaded=!0,e.statusDetails.details=r.statusDetails,e.domainDetails={},t.forEach(e.statusDetails.details,(function(e){"completed"===e.rawStatus?(e.rowStatusClass="success",delete e.actionURL):e.rowStatusClass="warning"})),t.forEach(e.domains,(function(t){var a=r.domainDetails[t];a&&(e.hasDomainDetails=!0),e.domainDetails[t]={},"NOTVALIDATED"===a?(e.domainDetails[t].rowStatusClass="warning",e.domainDetails[t].rowStatusLabel=i.maketext("Not Validated"),e.domainDetails[t].domainDetailDescription=i.maketext("The [output,abbr,CA,Certificate Authority] received the request but has not yet performed a [output,abbr,DCV,Domain Control Validation] check.")):"VALIDATED"===a?(e.domainDetails[t].rowStatusClass="success",e.domainDetails[t].rowStatusLabel=i.maketext("Validated"),e.domainDetails[t].domainDetailDescription=i.maketext("The [output,abbr,CA,Certificate Authority] validated the certificate.")):"AWAITINGBRANDING"===a?(e.domainDetails[t].rowStatusClass="info",e.domainDetails[t].rowStatusLabel=i.maketext("Awaiting Branding …"),e.domainDetails[t].domainDetailDescription=i.maketext("The [output,abbr,CA,Certificate Authority] received the request and must now process the brand verification approval.")):(e.domainDetails[t].rowStatusClass="info",e.domainDetails[t].rowStatusLabel=i.maketext("Unknown"),e.domainDetails[t].domainDetailDescription=i.maketext("Unknown."))})),t.forEach(e.displayed_domains,(function(t){f(e,t)}))})).finally((function(){e.statusDetails.loading=!1}))},r.collapse_cert=function(){a.search(),r.expanded_cert=null},r.continue_purchase=function(e){var i=d.get_all_domains();d.reset_purchasing_certificates();var r=new l,n=[],o=d.get_product_by_id(e.provider,e.product_id),s=0;r.set_domains(n),r.set_virtual_hosts(e.vhost_names),r.set_product(o),t.forEach(e.domains,(function(e){t.forEach(i,(function(t){t.domain===e&&(n.push(t),s+=t.is_wildcard?o.wildcard_price:o.price)}))})),r.set_price(s),d.add_new_certificate(r),d.save(),a.path("/purchase/"+e.provider+"/login/").search({order_id:e.order_id})},r.rebuild_local_storage=function(){var e={},i=d.get_all_domains(),a=d.get_virtual_hosts();t.forEach(r.pending_certificates,(function(r){e[r.order_id]=e[r.order_id]||{access_token:"",certificates:[],order_id:r.order_id,checkout_url:r.checkout_url},e[r.order_id].certificates.push(r),t.forEach(r.domains,(function(e){t.forEach(i,(function(t){t.domain===e&&(t.selected=!0)}))})),t.forEach(r.vhost_names,(function(e){var t=d.get_virtual_host_by_display_name(e),i=a[t],n=d.get_product_by_id(r.provider,r.product_id);i&&i.set_product(n)}))})),t.forEach(e,(function(e){d.add_order(e)})),d.save()},r.restore_orders=function(){d.clear_stored_settings();var t=d.fetch_domains();e.isFunction(t.finally)?t.then(r.rebuild_local_storage):t&&r.rebuild_local_storage()},r.prepare_pending_certificates=function(){r.pending_certificates.forEach((function(e){e.support_uri_is_http=/^http/.test(e.support_uri),e.display_meta=e.display_meta||{items_per_page:10,current_page:1}}))},r.init=function(){r.restore_orders(),r.prepare_pending_certificates(),n.orderItemID&&(r.expanded_cert=n.orderItemID,t.forEach(r.pending_certificates,(function(e){e.order_item_id===r.expanded_cert&&r.load_certificate_details(e)})),s((function(){o(r.expanded_cert)}),500))},r.init()}])})),define("app/directives/identityVerificationDirective",["angular","cjt/util/locale"],(function(e,t){"use strict";var i;try{i=e.module("App")}catch(t){i=e.module("App",[])}var r={date:!0,number:!0,email:!0,tel:!0},a={country_code:!0,choose_one:!0},n={required:t.maketext("Required"),preamble:t.maketext("To ensure quick service, fill out the form below as completely as possible.")};function o(e){return!(e.type in a)}function s(e){return r[e.type]?e.type:"text"}function c(){var e=(new Date).toISOString().replace(/T.*/,"");return t.maketext("Use the format “[_1]”. For example, today is “[_2]”.","YYYY-MM-DD",e)}i.directive("identityVerification",[function(){return{templateUrl:"directives/identityVerification.phtml",restrict:"E",scope:{items:"=",models:"=",countries:"=",vhostName:"="},link:function(t,i){e.extend(t,{SELF:t,STR:n,get_html_input_type:s,use_html_input:o,get_date_format_description:c}),t.items.forEach((function(e){e.is_optional=Boolean(+e.is_optional)}))}}}])})),define("app/index",["angular","cjt/core","lodash","cjt/modules","uiBootstrap","ngRoute","ngSanitize","ngAnimate"],(function(e,t,i){"use strict";return function(){return e.module("App",["ui.bootstrap","angular-growl","cjt2.cpanel","ngAnimate"]),require(["cjt/bootstrap","cjt/services/alertService","cjt/directives/alert","cjt/directives/alertList","app/services/CertificatesService","app/services/LocationService","app/views/VirtualHostsController","app/views/PurchaseSimpleController","app/views/CheckoutController","app/views/PendingCertificatesController","app/directives/identityVerificationDirective","cjt/decorators/growlDecorator","cjt/services/cpanel/componentSettingSaverService"],(function(r){var a=e.module("App");a.value("PAGE",CPANEL.PAGE),a.controller("BaseController",["componentSettingSaverService","CertificatesService","$rootScope","$scope","$route","$location",function(e,t,i,r,a,n){var o="IntroductionBlock";r.loading=!1,i.$on("$routeChangeStart",(function(e,t,i){i&&t.loadedTemplateURL===i.loadedTemplateURL||(r.loading=!0)})),i.$on("$routeChangeSuccess",(function(){r.loading=!1})),i.$on("$routeChangeError",(function(){r.loading=!1})),r.introduction_dismissed=function(){e.set(o,{hidden:!0}),t.dismiss_introduction()},r.current_route_matches=function(e){return n.path().match(e)},r.go=function(e){n.path(e)};var s=e.register(o);s&&s.then((function(e){e&&e.hidden&&t.dismiss_introduction()})),r.$on("$destroy",(function(){e.unregister(o)}))}]),a.config(["$routeProvider","growlProvider",function(e,r){r.globalPosition("top-right"),e.when("/create-advanced/:domain?",{controller:"VirtualHostsController",templateUrl:t.buildFullPath("security/tls_wizard/views/virtual_hosts.html.tt"),resolve:{installed_hosts:["CertificatesService",function(e){return e.fetch_installed_hosts()}],products:["CertificatesService",function(e){return e.fetch_products()}],domains:["CertificatesService",function(e){return e.fetch_domains()}],pending_certificates:["CertificatesService",function(e){return e.fetch_pending_certificates()}]}}),e.when("/create/:domain?",{controller:"PurchaseSimpleController",templateUrl:t.buildFullPath("security/tls_wizard/views/purchase_simple.html.tt"),resolve:{installed_hosts:["CertificatesService",function(e){return e.fetch_installed_hosts()}],products:["CertificatesService",function(e){return e.fetch_products()}],domains:["CertificatesService",function(e){return e.fetch_domains()}],pending_certificates:["CertificatesService",function(e){return e.fetch_pending_certificates()}]}}),e.when("/pending-certificates/",{controller:"PendingCertificatesController",reloadOnSearch:!1,templateUrl:t.buildFullPath("security/tls_wizard/views/pending_certificates.html.tt"),resolve:{installed_hosts:["CertificatesService",function(e){return e.fetch_installed_hosts()}],pending_certificates:["CertificatesService","LocationService","$location",function(e,t,r){var a=e.fetch_pending_certificates();return i.isFunction(a.finally)?a.then((function(){return!!e.get_pending_certificates().length||(t.go_to_last_create_route(),!1)})):!!e.get_pending_certificates().length||(t.go_to_last_create_route(),!1)}],products:["CertificatesService",function(e){return e.fetch_products()}]}}),e.when("/purchase/:provider?/:step?/:everythingelse?",{controller:"CheckoutController",templateUrl:t.buildFullPath("security/tls_wizard/views/checkout.html.tt"),resolve:{products:["CertificatesService",function(e){return e.fetch_products()}]}}),e.otherwise({redirectTo:"/pending-certificates"})}]),r("#content","App")}))}}));