(function(window){"use strict";var d3=window.d3;var Chart_Utilities=window.Chart_Utilities;var GRAPH_WIDTH=620;var GRAPH_HEIGHT=200;function sort_nums(a,b){return a-b}var resolution_interval={"5min":3e5,hourly:36e5,daily:864e5};function draw_protocols_time_graph_key(opts){var protocols_order=opts.protocols_order;var container_path=opts.container_path;var D3_COLOR=d3.scale.category10().domain(protocols_order);var key_sel=d3.select(container_path).append("div").classed("graph-key",true);var key_item=key_sel.selectAll(".key-item").data(protocols_order).enter().append("span").classed("key-item",true);key_item.append("span").classed("color-sample",true).style("background-color",(function(d){return D3_COLOR(d)}));key_item.append("span").classed("field-name",true).html((function(d){return"&nbsp;"+d.toUpperCase()}))}function draw_protocols_time_graph(opts){var rear_opts=Object.create(opts);rear_opts.data=opts.api_protocol_data;rear_opts.protocols_order=opts.protocols_order;return _draw_time_graph(rear_opts)}function _draw_time_graph(opts){var container_path=opts.container_path;var data_in=opts.data;var graph_protocols=opts.protocols_order;var D3_COLOR=d3.scale.category10().domain(graph_protocols);if(!Object.keys(data_in).length){d3.select(container_path).text(LOCALE.maketext("There is no data for this period."));return false}var MIN_TIME=opts.min_date;var RESOLUTION=resolution_interval[opts.resolution];var time_format=opts.time_format;var time_ticks=opts.time_ticks;var MAX_TIME=opts.max_date?new Date(opts.max_date):new Date;var margin={top:20,right:20,bottom:30,left:120},width=GRAPH_WIDTH-margin.left-margin.right,height=GRAPH_HEIGHT-margin.top-margin.bottom;var svg=d3.select(container_path).append("svg").attr("width",GRAPH_WIDTH).attr("height",GRAPH_HEIGHT).append("g").attr("transform","translate("+margin.left+","+margin.top+")");var x_scale=d3.time.scale().range([0,width]).domain([MIN_TIME,MAX_TIME]);var x_axis=d3.svg.axis().scale(x_scale).orient("bottom").tickFormat(time_format);if(time_ticks){x_axis.tickValues(time_ticks)}svg.append("g").attr("class","x axis").attr("transform","translate(0,"+height+")").call(x_axis);var protocol_data={};var total_data_per_time={};var protocol_max_unixtime={};var min_unixtime=Math.floor(Date.now()/1e3);graph_protocols.forEach((function(ptcl){protocol_data[ptcl]=[];if(data_in[ptcl]){var unixtimes=Object.keys(data_in[ptcl]).sort(sort_nums);protocol_max_unixtime[ptcl]=unixtimes[unixtimes.length-1];if(unixtimes[0]<min_unixtime){min_unixtime=unixtimes[0]}}}));var bytes_per_minute;var bytes_divisor=RESOLUTION/60/1e3;var cur_time=new Date(min_unixtime*1e3);while(cur_time<MAX_TIME){var cur_date=new Date(cur_time);cur_time.setMilliseconds(RESOLUTION+cur_time.getMilliseconds());if(cur_date<MIN_TIME){continue}var unixtime=cur_date.getTime()/1e3;if(!(unixtime in total_data_per_time)){total_data_per_time[unixtime]=0}for(var p=0;p<graph_protocols.length;p++){var ptcl=graph_protocols[p];if(!protocol_max_unixtime[ptcl]){continue}var p_data=data_in[ptcl];bytes_per_minute=p_data[unixtime];if(bytes_per_minute){bytes_per_minute/=bytes_divisor;total_data_per_time[unixtime]+=bytes_per_minute}protocol_data[ptcl].push({date:cur_date,y:bytes_per_minute||0})}}var graph_data=graph_protocols.slice().reverse().map((function(ptcl){if(protocol_data[ptcl].length){return{protocol:ptcl,values:protocol_data[ptcl]}}return false})).filter(Boolean);var stack=d3.layout.stack().values((function(d){return d.values}));var stacked_data=stack(graph_data);var tick_values=Chart_Utilities.get_tick_values_for_format_bytes(d3.max(d3.values(total_data_per_time)));var y_scale=d3.scale.linear().range([height,0]).domain([0,tick_values[tick_values.length-1]]);var y_axis=d3.svg.axis().scale(y_scale).orient("left").tickFormat((function(b){return b?LOCALE.maketext("[format_bytes,_1]/min.",b):""})).tickValues(tick_values);svg.append("g").attr("class","y axis").call(y_axis);var area=d3.svg.area().x((function(d){return x_scale(d.date)})).y0((function(d){return y_scale(d.y0)})).y1((function(d){return y_scale(d.y0+d.y)})).interpolate("step-after");var protocol_svg=svg.selectAll(".protocol").data(stacked_data).enter().append("g").attr("class","protocol");protocol_svg.append("path").attr("class","area").attr("d",(function(d){return area(d.values)})).style("fill",(function(d){return D3_COLOR(d.protocol)}));return true}window.Bandwidth_Graph={draw_protocols_time_graph:draw_protocols_time_graph,draw_protocols_time_graph_key:draw_protocols_time_graph_key}})(window);
