if(typeof dojo!=="undefined"){dojo.provide("org.cometd")}else{this.org=this.org||{};org.cometd={}}org.cometd.JSON={};org.cometd.JSON.toJSON=org.cometd.JSON.fromJSON=function(object){throw"Abstract"};org.cometd.TransportRegistry=function(){var _types=[];var _transports={};this.getTransportTypes=function(){return _types.slice(0)};this.findTransportTypes=function(version,crossDomain){var result=[];for(var i=0;i<_types.length;++i){var type=_types[i];if(_transports[type].accept(version,crossDomain)){result.push(type)}}return result};this.negotiateTransport=function(types,version,crossDomain){for(var i=0;i<_types.length;++i){var type=_types[i];for(var j=0;j<types.length;++j){if(type==types[j]){var transport=_transports[type];if(transport.accept(version,crossDomain)===true){return transport}}}}return null};this.add=function(type,transport,index){var existing=false;for(var i=0;i<_types.length;++i){if(_types[i]==type){existing=true;break}}if(!existing){if(typeof index!=="number"){_types.push(type)}else{_types.splice(index,0,type)}_transports[type]=transport}return!existing};this.remove=function(type){for(var i=0;i<_types.length;++i){if(_types[i]==type){_types.splice(i,1);var transport=_transports[type];delete _transports[type];return transport}}return null};this.reset=function(){for(var i=0;i<_types.length;++i){_transports[_types[i]].reset()}}};org.cometd.Cometd=function(name){var _cometd=this;var _name=name||"default";var _logLevel;var _url;var _maxConnections;var _backoffIncrement;var _maxBackoff;var _reverseIncomingExtensions;var _maxNetworkDelay;var _requestHeaders;var _appendMessageTypeToURL;var _autoBatch;var _crossDomain=false;var _transports=new org.cometd.TransportRegistry;var _transport;var _status="disconnected";var _messageId=0;var _clientId=null;var _batch=0;var _messageQueue=[];var _internalBatch=false;var _listeners={};var _backoff=0;var _scheduledSend=null;var _extensions=[];var _defaultAdvice={};var _advice={};var _handshakeProps;var _reestablish=false;var _connected=false;function _mixin(deep,target,objects){var result=target||{};for(var i=2;i<arguments.length;++i){var object=arguments[i];if(object===undefined||object===null){continue}for(var propName in object){var prop=object[propName];if(prop===target){continue}if(prop===undefined){continue}if(deep&&typeof prop==="object"&&prop!==null){if(prop instanceof Array){result[propName]=_mixin(deep,[],prop)}else{result[propName]=_mixin(deep,{},prop)}}else{result[propName]=prop}}}return result}this._mixin=_mixin;function _inArray(element,array){for(var i=0;i<array.length;++i){if(element==array[i]){return i}}return-1}function _isString(value){if(value===undefined||value===null){return false}return typeof value==="string"||value instanceof String}function _isArray(value){if(value===undefined||value===null){return false}return value instanceof Array}function _isFunction(value){if(value===undefined||value===null){return false}return typeof value==="function"}function _log(level,args){if(window.console){var logger=window.console[level];if(_isFunction(logger)){logger.apply(window.console,args)}}}function _warn(){_log("warn",arguments)}this._warn=_warn;function _info(){if(_logLevel!="warn"){_log("info",arguments)}}this._info=_info;function _debug(){if(_logLevel=="debug"){_log("debug",arguments)}}this._debug=_debug;function _configure(configuration){_debug("Configuring cometd object with",configuration);if(_isString(configuration)){configuration={url:configuration}}if(!configuration){configuration={}}_url=configuration.url;if(!_url){throw"Missing required configuration parameter 'url' specifying the Bayeux server URL"}_maxConnections=configuration.maxConnections||2;_backoffIncrement=configuration.backoffIncrement||1e3;_maxBackoff=configuration.maxBackoff||6e4;_logLevel=configuration.logLevel||"info";_reverseIncomingExtensions=configuration.reverseIncomingExtensions!==false;_maxNetworkDelay=configuration.maxNetworkDelay||1e4;_requestHeaders=configuration.requestHeaders||{};_appendMessageTypeToURL=configuration.appendMessageTypeToURL!==false;_autoBatch=configuration.autoBatch===true;_defaultAdvice.timeout=configuration.timeout||6e4;_defaultAdvice.interval=configuration.interval||0;_defaultAdvice.reconnect=configuration.reconnect||"retry";var urlParts=/(^https?:)?(\/\/(([^:\/\?#]+)(:(\d+))?))?([^\?#]*)(.*)?/.exec(_url);_crossDomain=urlParts[3]&&urlParts[3]!=window.location.host;if(_appendMessageTypeToURL){if(urlParts[8]!==undefined){_info("Appending message type to URI "+urlParts[7]+urlParts[8]+" is not supported, disabling 'appendMessageTypeToURL' configuration");_appendMessageTypeToURL=false}else{var uriSegments=urlParts[7].split("/");var lastSegmentIndex=uriSegments.length-1;if(urlParts[7].match(/\/$/)){lastSegmentIndex-=1}if(uriSegments[lastSegmentIndex].indexOf(".")>=0){_info("Appending message type to URI "+urlParts[7]+" is not supported, disabling 'appendMessageTypeToURL' configuration");_appendMessageTypeToURL=false}}}}function _clearSubscriptions(){for(var channel in _listeners){var subscriptions=_listeners[channel];for(var i=0;i<subscriptions.length;++i){var subscription=subscriptions[i];if(subscription&&!subscription.listener){delete subscriptions[i];_debug("Removed subscription",subscription,"for channel",channel)}}}}function _setStatus(newStatus){if(_status!=newStatus){_debug("Status",_status,"->",newStatus);_status=newStatus}}function _isDisconnected(){return _status=="disconnecting"||_status=="disconnected"}function _nextMessageId(){return++_messageId}function _applyExtension(scope,callback,name,message,outgoing){try{return callback.call(scope,message)}catch(x){_debug("Exception during execution of extension",name,x);var exceptionCallback=_cometd.onExtensionException;if(_isFunction(exceptionCallback)){_debug("Invoking extension exception callback",name,x);try{exceptionCallback.call(_cometd,x,name,outgoing,message)}catch(xx){_info("Exception during execution of exception callback in extension",name,xx)}}return message}}function _applyIncomingExtensions(message){for(var i=0;i<_extensions.length;++i){if(message===undefined||message===null){break}var index=_reverseIncomingExtensions?_extensions.length-1-i:i;var extension=_extensions[index];var callback=extension.extension.incoming;if(_isFunction(callback)){var result=_applyExtension(extension.extension,callback,extension.name,message,false);message=result===undefined?message:result}}return message}function _applyOutgoingExtensions(message){for(var i=0;i<_extensions.length;++i){if(message===undefined||message===null){break}var extension=_extensions[i];var callback=extension.extension.outgoing;if(_isFunction(callback)){var result=_applyExtension(extension.extension,callback,extension.name,message,true);message=result===undefined?message:result}}return message}function _notify(channel,message){var subscriptions=_listeners[channel];if(subscriptions&&subscriptions.length>0){for(var i=0;i<subscriptions.length;++i){var subscription=subscriptions[i];if(subscription){try{subscription.callback.call(subscription.scope,message)}catch(x){_debug("Exception during notification",subscription,message,x);var listenerCallback=_cometd.onListenerException;if(_isFunction(listenerCallback)){_debug("Invoking listener exception callback",subscription,x);try{listenerCallback.call(_cometd,x,subscription.handle,subscription.listener,message)}catch(xx){_info("Exception during execution of listener callback",subscription,xx)}}}}}}}function _notifyListeners(channel,message){_notify(channel,message);var channelParts=channel.split("/");var last=channelParts.length-1;for(var i=last;i>0;--i){var channelPart=channelParts.slice(0,i).join("/")+"/*";if(i==last){_notify(channelPart,message)}channelPart+="*";_notify(channelPart,message)}}function _setTimeout(funktion,delay){return setTimeout((function(){try{funktion()}catch(x){_debug("Exception invoking timed function",funktion,x)}}),delay)}function _cancelDelayedSend(){if(_scheduledSend!==null){clearTimeout(_scheduledSend)}_scheduledSend=null}function _delayedSend(operation){_cancelDelayedSend();var delay=_advice.interval+_backoff;_debug("Function scheduled in",delay,"ms, interval =",_advice.interval,"backoff =",_backoff,operation);_scheduledSend=_setTimeout(operation,delay)}var _handleMessages;var _handleFailure;function _send(sync,messages,longpoll,extraPath){for(var i=0;i<messages.length;++i){var message=messages[i];message.id=""+_nextMessageId();if(_clientId){message.clientId=_clientId}message=_applyOutgoingExtensions(message);if(message!==undefined&&message!==null){messages[i]=message}else{messages.splice(i--,1)}}if(messages.length===0){return}var url=_url;if(_appendMessageTypeToURL){if(!url.match(/\/$/)){url=url+"/"}if(extraPath){url=url+extraPath}}var envelope={url:url,sync:sync,messages:messages,onSuccess:function(rcvdMessages){try{_handleMessages.call(_cometd,rcvdMessages)}catch(x){_debug("Exception during handling of messages",x)}},onFailure:function(conduit,reason,exception){try{_handleFailure.call(_cometd,conduit,messages,reason,exception)}catch(x){_debug("Exception during handling of failure",x)}}};_debug("Send, sync =",sync,envelope);_transport.send(envelope,longpoll)}function _queueSend(message){if(_batch>0||_internalBatch===true){_messageQueue.push(message)}else{_send(false,[message],false)}}this.send=_queueSend;function _resetBackoff(){_backoff=0}function _increaseBackoff(){if(_backoff<_maxBackoff){_backoff+=_backoffIncrement}}function _startBatch(){++_batch}function _flushBatch(){var messages=_messageQueue;_messageQueue=[];if(messages.length>0){_send(false,messages,false)}}function _endBatch(){--_batch;if(_batch<0){throw"Calls to startBatch() and endBatch() are not paired"}if(_batch===0&&!_isDisconnected()&&!_internalBatch){_flushBatch()}}function _connect(){if(!_isDisconnected()){var message={channel:"/meta/connect",connectionType:_transport.getType()};if(!_connected){message.advice={timeout:0}}_setStatus("connecting");_debug("Connect sent",message);_send(false,[message],true,"connect");_setStatus("connected")}}function _delayedConnect(){_setStatus("connecting");_delayedSend((function(){_connect()}))}function _updateAdvice(newAdvice){if(newAdvice){_advice=_mixin(false,{},_defaultAdvice,newAdvice);_debug("New advice",_advice,org.cometd.JSON.toJSON(_advice))}}function _handshake(handshakeProps){_clientId=null;_clearSubscriptions();if(_isDisconnected()){_transports.reset()}if(_isDisconnected()){_updateAdvice(_defaultAdvice)}else{_updateAdvice(_mixin(false,_advice,{reconnect:"retry"}))}_batch=0;_internalBatch=true;_handshakeProps=handshakeProps;var version="1.0";var transportTypes=_transports.findTransportTypes(version,_crossDomain);var bayeuxMessage={version:version,minimumVersion:"0.9",channel:"/meta/handshake",supportedConnectionTypes:transportTypes,advice:{timeout:_advice.timeout,interval:_advice.interval}};var message=_mixin(false,{},_handshakeProps,bayeuxMessage);_transport=_transports.negotiateTransport(transportTypes,version,_crossDomain);_debug("Initial transport is",_transport);_setStatus("handshaking");_debug("Handshake sent",message);_send(false,[message],false,"handshake")}function _delayedHandshake(){_setStatus("handshaking");_internalBatch=true;_delayedSend((function(){_handshake(_handshakeProps)}))}function _handshakeResponse(message){if(message.successful){_clientId=message.clientId;var newTransport=_transports.negotiateTransport(message.supportedConnectionTypes,message.version,_crossDomain);if(newTransport===null){throw"Could not negotiate transport with server; client "+_transports.findTransportTypes(message.version,_crossDomain)+", server "+message.supportedConnectionTypes}else if(_transport!=newTransport){_debug("Transport",_transport,"->",newTransport);_transport=newTransport}_internalBatch=false;_flushBatch();message.reestablish=_reestablish;_reestablish=true;_notifyListeners("/meta/handshake",message);var action=_isDisconnected()?"none":_advice.reconnect;switch(action){case"retry":_resetBackoff();_delayedConnect();break;case"none":_resetBackoff();_setStatus("disconnected");break;default:throw"Unrecognized advice action "+action}}else{_notifyListeners("/meta/handshake",message);_notifyListeners("/meta/unsuccessful",message);var retry=!_isDisconnected()&&_advice.reconnect!="none";if(retry){_increaseBackoff();_delayedHandshake()}else{_resetBackoff();_setStatus("disconnected")}}}function _handshakeFailure(xhr,message){var failureMessage={successful:false,failure:true,channel:"/meta/handshake",request:message,xhr:xhr,advice:{reconnect:"retry",interval:_backoff}};_notifyListeners("/meta/handshake",failureMessage);_notifyListeners("/meta/unsuccessful",failureMessage);var retry=!_isDisconnected()&&_advice.reconnect!="none";if(retry){_increaseBackoff();_delayedHandshake()}else{_resetBackoff();_setStatus("disconnected")}}function _connectResponse(message){_connected=message.successful;if(_connected){_notifyListeners("/meta/connect",message);var action1=_isDisconnected()?"none":_advice.reconnect;switch(action1){case"retry":_resetBackoff();_delayedConnect();break;case"none":_resetBackoff();_setStatus("disconnected");break;default:throw"Unrecognized advice action "+action1}}else{_info("Connect failed:",message.error);_notifyListeners("/meta/connect",message);_notifyListeners("/meta/unsuccessful",message);var action2=_isDisconnected()?"none":_advice.reconnect;switch(action2){case"retry":_increaseBackoff();_delayedConnect();break;case"handshake":_resetBackoff();_delayedHandshake();break;case"none":_resetBackoff();_setStatus("disconnected");break;default:throw"Unrecognized advice action"+action2}}}function _connectFailure(xhr,message){_connected=false;var failureMessage={successful:false,failure:true,channel:"/meta/connect",request:message,xhr:xhr,advice:{reconnect:"retry",interval:_backoff}};_notifyListeners("/meta/connect",failureMessage);_notifyListeners("/meta/unsuccessful",failureMessage);var action=_isDisconnected()?"none":_advice.reconnect;switch(action){case"retry":_increaseBackoff();_delayedConnect();break;case"handshake":_resetBackoff();_delayedHandshake();break;case"none":_resetBackoff();_setStatus("disconnected");break;default:throw"Unrecognized advice action"+action}}function _disconnect(abort){_cancelDelayedSend();if(abort){_transport.abort()}_clientId=null;_setStatus("disconnected");_batch=0;_messageQueue=[];_resetBackoff()}function _disconnectResponse(message){if(message.successful){_disconnect(false);_notifyListeners("/meta/disconnect",message)}else{_disconnect(true);_notifyListeners("/meta/disconnect",message);_notifyListeners("/meta/unsuccessful",message)}}function _disconnectFailure(xhr,message){_disconnect(true);var failureMessage={successful:false,failure:true,channel:"/meta/disconnect",request:message,xhr:xhr,advice:{reconnect:"none",interval:0}};_notifyListeners("/meta/disconnect",failureMessage);_notifyListeners("/meta/unsuccessful",failureMessage)}function _subscribeResponse(message){if(message.successful){_notifyListeners("/meta/subscribe",message)}else{_info("Subscription to",message.subscription,"failed:",message.error);_notifyListeners("/meta/subscribe",message);_notifyListeners("/meta/unsuccessful",message)}}function _subscribeFailure(xhr,message){var failureMessage={successful:false,failure:true,channel:"/meta/subscribe",request:message,xhr:xhr,advice:{reconnect:"none",interval:0}};_notifyListeners("/meta/subscribe",failureMessage);_notifyListeners("/meta/unsuccessful",failureMessage)}function _unsubscribeResponse(message){if(message.successful){_notifyListeners("/meta/unsubscribe",message)}else{_info("Unsubscription to",message.subscription,"failed:",message.error);_notifyListeners("/meta/unsubscribe",message);_notifyListeners("/meta/unsuccessful",message)}}function _unsubscribeFailure(xhr,message){var failureMessage={successful:false,failure:true,channel:"/meta/unsubscribe",request:message,xhr:xhr,advice:{reconnect:"none",interval:0}};_notifyListeners("/meta/unsubscribe",failureMessage);_notifyListeners("/meta/unsuccessful",failureMessage)}function _messageResponse(message){if(message.successful===undefined){if(message.data){_notifyListeners(message.channel,message)}else{_debug("Unknown message",message)}}else{if(message.successful){_notifyListeners("/meta/publish",message)}else{_info("Publish failed:",message.error);_notifyListeners("/meta/publish",message);_notifyListeners("/meta/unsuccessful",message)}}}function _messageFailure(xhr,message){var failureMessage={successful:false,failure:true,channel:message.channel,request:message,xhr:xhr,advice:{reconnect:"none",interval:0}};_notifyListeners("/meta/publish",failureMessage);_notifyListeners("/meta/unsuccessful",failureMessage)}function _receive(message){message=_applyIncomingExtensions(message);if(message===undefined||message===null){return}_updateAdvice(message.advice);var channel=message.channel;switch(channel){case"/meta/handshake":_handshakeResponse(message);break;case"/meta/connect":_connectResponse(message);break;case"/meta/disconnect":_disconnectResponse(message);break;case"/meta/subscribe":_subscribeResponse(message);break;case"/meta/unsubscribe":_unsubscribeResponse(message);break;default:_messageResponse(message);break}}this.receive=_receive;_handleMessages=function _handleMessages(rcvdMessages){_debug("Received",rcvdMessages,org.cometd.JSON.toJSON(rcvdMessages));for(var i=0;i<rcvdMessages.length;++i){var message=rcvdMessages[i];_receive(message)}};_handleFailure=function _handleFailure(conduit,messages,reason,exception){_debug("handleFailure",conduit,messages,reason,exception);for(var i=0;i<messages.length;++i){var message=messages[i];var channel=message.channel;switch(channel){case"/meta/handshake":_handshakeFailure(conduit,message);break;case"/meta/connect":_connectFailure(conduit,message);break;case"/meta/disconnect":_disconnectFailure(conduit,message);break;case"/meta/subscribe":_subscribeFailure(conduit,message);break;case"/meta/unsubscribe":_unsubscribeFailure(conduit,message);break;default:_messageFailure(conduit,message);break}}};function _hasSubscriptions(channel){var subscriptions=_listeners[channel];if(subscriptions){for(var i=0;i<subscriptions.length;++i){if(subscriptions[i]){return true}}}return false}function _resolveScopedCallback(scope,callback){var delegate={scope:scope,method:callback};if(_isFunction(scope)){delegate.scope=undefined;delegate.method=scope}else{if(_isString(callback)){if(!scope){throw"Invalid scope "+scope}delegate.method=scope[callback];if(!_isFunction(delegate.method)){throw"Invalid callback "+callback+" for scope "+scope}}else if(!_isFunction(callback)){throw"Invalid callback "+callback}}return delegate}function _addListener(channel,scope,callback,isListener){var delegate=_resolveScopedCallback(scope,callback);_debug("Adding listener on",channel,"with scope",delegate.scope,"and callback",delegate.method);var subscription={channel:channel,scope:delegate.scope,callback:delegate.method,listener:isListener};var subscriptions=_listeners[channel];if(!subscriptions){subscriptions=[];_listeners[channel]=subscriptions}var subscriptionID=subscriptions.push(subscription)-1;subscription.id=subscriptionID;subscription.handle=[channel,subscriptionID];_debug("Added listener",subscription,"for channel",channel,"having id =",subscriptionID);return subscription.handle}function _removeListener(subscription){var subscriptions=_listeners[subscription[0]];if(subscriptions){delete subscriptions[subscription[1]];_debug("Removed listener",subscription)}}this.registerTransport=function(type,transport,index){var result=_transports.add(type,transport,index);if(result){_debug("Registered transport",type);if(_isFunction(transport.registered)){transport.registered(type,this)}}return result};this.getTransportTypes=function(){return _transports.getTransportTypes()};this.unregisterTransport=function(type){var transport=_transports.remove(type);if(transport!==null){_debug("Unregistered transport",type);if(_isFunction(transport.unregistered)){transport.unregistered()}}return transport};this.configure=function(configuration){_configure.call(this,configuration)};this.init=function(configuration,handshakeProps){this.configure(configuration);this.handshake(handshakeProps)};this.handshake=function(handshakeProps){_setStatus("disconnected");_reestablish=false;_handshake(handshakeProps)};this.disconnect=function(sync,disconnectProps){if(_isDisconnected()){return}if(disconnectProps===undefined){if(typeof sync!=="boolean"){disconnectProps=sync;sync=false}}var bayeuxMessage={channel:"/meta/disconnect"};var message=_mixin(false,{},disconnectProps,bayeuxMessage);_setStatus("disconnecting");_send(sync===true,[message],false,"disconnect")};this.startBatch=function(){_startBatch()};this.endBatch=function(){_endBatch()};this.batch=function(scope,callback){var delegate=_resolveScopedCallback(scope,callback);this.startBatch();try{delegate.method.call(delegate.scope);this.endBatch()}catch(x){_debug("Exception during execution of batch",x);this.endBatch();throw x}};this.addListener=function(channel,scope,callback){if(arguments.length<2){throw"Illegal arguments number: required 2, got "+arguments.length}if(!_isString(channel)){throw"Illegal argument type: channel must be a string"}return _addListener(channel,scope,callback,true)};this.removeListener=function(subscription){if(!_isArray(subscription)){throw"Invalid argument: expected subscription, not "+subscription}_removeListener(subscription)};this.clearListeners=function(){_listeners={}};this.subscribe=function(channel,scope,callback,subscribeProps){if(arguments.length<2){throw"Illegal arguments number: required 2, got "+arguments.length}if(!_isString(channel)){throw"Illegal argument type: channel must be a string"}if(_isDisconnected()){throw"Illegal state: already disconnected"}if(_isFunction(scope)){subscribeProps=callback;callback=scope;scope=undefined}var send=!_hasSubscriptions(channel);var subscription=_addListener(channel,scope,callback,false);if(send){var bayeuxMessage={channel:"/meta/subscribe",subscription:channel};var message=_mixin(false,{},subscribeProps,bayeuxMessage);_queueSend(message)}return subscription};this.unsubscribe=function(subscription,unsubscribeProps){if(arguments.length<1){throw"Illegal arguments number: required 1, got "+arguments.length}if(_isDisconnected()){throw"Illegal state: already disconnected"}this.removeListener(subscription);var channel=subscription[0];if(!_hasSubscriptions(channel)){var bayeuxMessage={channel:"/meta/unsubscribe",subscription:channel};var message=_mixin(false,{},unsubscribeProps,bayeuxMessage);_queueSend(message)}};this.clearSubscriptions=function(){_clearSubscriptions()};this.publish=function(channel,content,publishProps){if(arguments.length<1){throw"Illegal arguments number: required 1, got "+arguments.length}if(!_isString(channel)){throw"Illegal argument type: channel must be a string"}if(_isDisconnected()){throw"Illegal state: already disconnected"}var bayeuxMessage={channel:channel,data:content};var message=_mixin(false,{},publishProps,bayeuxMessage);_queueSend(message)};this.getStatus=function(){return _status};this.isDisconnected=_isDisconnected;this.setBackoffIncrement=function(period){_backoffIncrement=period};this.getBackoffIncrement=function(){return _backoffIncrement};this.getBackoffPeriod=function(){return _backoff};this.setLogLevel=function(level){_logLevel=level};this.registerExtension=function(name,extension){if(arguments.length<2){throw"Illegal arguments number: required 2, got "+arguments.length}if(!_isString(name)){throw"Illegal argument type: extension name must be a string"}var existing=false;for(var i=0;i<_extensions.length;++i){var existingExtension=_extensions[i];if(existingExtension.name==name){existing=true;break}}if(!existing){_extensions.push({name:name,extension:extension});_debug("Registered extension",name);if(_isFunction(extension.registered)){extension.registered(name,this)}return true}else{_info("Could not register extension with name",name,"since another extension with the same name already exists");return false}};this.unregisterExtension=function(name){if(!_isString(name)){throw"Illegal argument type: extension name must be a string"}var unregistered=false;for(var i=0;i<_extensions.length;++i){var extension=_extensions[i];if(extension.name==name){_extensions.splice(i,1);unregistered=true;_debug("Unregistered extension",name);var ext=extension.extension;if(_isFunction(ext.unregistered)){ext.unregistered()}break}}return unregistered};this.getExtension=function(name){for(var i=0;i<_extensions.length;++i){var extension=_extensions[i];if(extension.name==name){return extension.extension}}return null};this.getName=function(){return _name};this.getClientId=function(){return _clientId};this.getURL=function(){return _url};this.getTransport=function(){return _transport};org.cometd.Transport=function(){var _type;this.registered=function(type,cometd){_type=type};this.unregistered=function(){_type=null};this.convertToMessages=function(response){if(_isString(response)){try{return org.cometd.JSON.fromJSON(response)}catch(x){_debug("Could not convert to JSON the following string",'"'+response+'"');throw x}}if(_isArray(response)){return response}if(response===undefined||response===null){return[]}if(response instanceof Object){return[response]}throw"Conversion Error "+response+", typeof "+typeof response};this.accept=function(version,crossDomain){throw"Abstract"};this.getType=function(){return _type};this.send=function(envelope,metaConnect){throw"Abstract"};this.reset=function(){}};org.cometd.Transport.derive=function(baseObject){function F(){}F.prototype=baseObject;return new F};org.cometd.RequestTransport=function(){var _super=new org.cometd.Transport;var that=org.cometd.Transport.derive(_super);var _requestIds=0;var _metaConnectRequest=null;var _requests=[];var _envelopes=[];function _metaConnectComplete(request){var requestId=request.id;_debug("metaConnect complete",this.getType(),requestId);if(_metaConnectRequest!==null&&_metaConnectRequest.id!==requestId){throw"Longpoll request mismatch, completing request "+requestId}_metaConnectRequest=null}function _coalesceEnvelopes(envelope){while(_envelopes.length>0){var envelopeAndRequest=_envelopes[0];var newEnvelope=envelopeAndRequest[0];var newRequest=envelopeAndRequest[1];if(newEnvelope.url===envelope.url&&newEnvelope.sync===envelope.sync){_envelopes.shift();envelope.messages=envelope.messages.concat(newEnvelope.messages);_debug("Coalesced",newEnvelope.messages.length,"messages from request",newRequest.id);continue}break}}function _complete(request,success){var self=this;var index=_inArray(request,_requests);if(index>=0){_requests.splice(index,1)}if(_envelopes.length>0){var envelopeAndRequest=_envelopes.shift();var nextEnvelope=envelopeAndRequest[0];var nextRequest=envelopeAndRequest[1];_debug("Transport dequeued request",nextRequest.id);if(success){if(_autoBatch){_coalesceEnvelopes(nextEnvelope)}_queueSend.call(this,nextEnvelope);_debug("Transport completed request",request.id,nextEnvelope)}else{setTimeout((function(){self.complete(nextRequest,false,nextRequest.metaConnect);nextEnvelope.onFailure(nextRequest.xhr,"error","Previous request failed")}),0)}}}that.complete=function(request,success,metaConnect){if(metaConnect){_metaConnectComplete.call(this,request)}else{_complete.call(this,request,success)}};that.transportSend=function(envelope,request){throw"Abstract"};that.transportSuccess=function(envelope,request,responses){if(!request.expired){clearTimeout(request.timeout);this.complete(request,true,request.metaConnect);if(responses&&responses.length>0){envelope.onSuccess(responses)}else{envelope.onFailure(request,"Empty HTTP response")}}};that.transportFailure=function(envelope,request,reason,exception){if(!request.expired){clearTimeout(request.timeout);this.complete(request,false,request.metaConnect);envelope.onFailure(request.xhr,reason,exception)}};function _transportSend(envelope,request){var self=this;this.transportSend(envelope,request);request.expired=false;if(!envelope.sync){var delay=_maxNetworkDelay;if(request.metaConnect===true){delay+=_advice.timeout}_debug("Will wait at most",delay,"ms for the response, maxNetworkDelay =",_maxNetworkDelay);request.timeout=_setTimeout((function(){request.expired=true;if(request.xhr){request.xhr.abort()}var errorMessage="Request "+request.id+" of transport "+self.getType()+" exceeded "+delay+" ms max network delay";_debug(errorMessage);self.complete(request,false,request.metaConnect);envelope.onFailure(request.xhr,"timeout",errorMessage)}),delay)}}function _metaConnectSend(envelope){if(_metaConnectRequest!==null){throw"Concurrent metaConnect requests not allowed, request id="+_metaConnectRequest.id+" not yet completed"}var requestId=++_requestIds;_debug("metaConnect send ",this.getType(),requestId,envelope);var request={id:requestId,metaConnect:true};_transportSend.call(this,envelope,request);_metaConnectRequest=request}function _queueSend(envelope){var requestId=++_requestIds;var request={id:requestId,metaConnect:false};if(_requests.length<_maxConnections-1){_debug("Transport sending request",requestId,envelope);_transportSend.call(this,envelope,request);_requests.push(request)}else{_debug("Transport queueing request",requestId,envelope);_envelopes.push([envelope,request])}}that.send=function(envelope,metaConnect){if(metaConnect){_metaConnectSend.call(this,envelope)}else{_queueSend.call(this,envelope)}};that.abort=function(){for(var i=0;i<_requests.length;++i){var request=_requests[i];_debug("Aborting request",request);if(request.xhr){request.xhr.abort()}}if(_metaConnectRequest){_debug("Aborting metaConnect request",_metaConnectRequest);if(_metaConnectRequest.xhr){_metaConnectRequest.xhr.abort()}}this.reset()};that.reset=function(){_metaConnectRequest=null;_requests=[];_envelopes=[]};that.toString=function(){return this.getType()};return that};org.cometd.LongPollingTransport=function(){var _super=new org.cometd.RequestTransport;var that=org.cometd.Transport.derive(_super);var _supportsCrossDomain=true;that.accept=function(version,crossDomain){return _supportsCrossDomain||!crossDomain};that.xhrSend=function(packet){throw"Abstract"};that.transportSend=function(envelope,request){var self=this;try{var sameStack=true;request.xhr=this.xhrSend({transport:this,url:envelope.url,sync:envelope.sync,headers:_requestHeaders,body:org.cometd.JSON.toJSON(envelope.messages),onSuccess:function(response){_debug("Transport",self,"received response",response);var success=false;try{var received=self.convertToMessages(response);if(received.length===0){_supportsCrossDomain=false;self.transportFailure(envelope,request,"no response",null)}else{success=true;self.transportSuccess(envelope,request,received)}}catch(x){_debug(x);if(!success){_supportsCrossDomain=false;self.transportFailure(envelope,request,"bad response",x)}}},onError:function(reason,exception){_supportsCrossDomain=false;if(sameStack){_setTimeout((function(){self.transportFailure(envelope,request,reason,exception)}),0)}else{self.transportFailure(envelope,request,reason,exception)}}});sameStack=false}catch(x){_supportsCrossDomain=false;_setTimeout((function(){self.transportFailure(envelope,request,"error",x)}),0)}};that.reset=function(){_super.reset();_supportsCrossDomain=true};return that};org.cometd.CallbackPollingTransport=function(){var _super=new org.cometd.RequestTransport;var that=org.cometd.Transport.derive(_super);var _maxLength=2e3;that.accept=function(version,crossDomain){return true};that.jsonpSend=function(packet){throw"Abstract"};that.transportSend=function(envelope,request){var self=this;var messages=org.cometd.JSON.toJSON(envelope.messages);var urlLength=envelope.url.length+encodeURI(messages).length;if(urlLength>_maxLength){var x=envelope.messages.length>1?"Too many bayeux messages in the same batch resulting in message too big "+"("+urlLength+" bytes, max is "+_maxLength+") for transport "+this.getType():"Bayeux message too big ("+urlLength+" bytes, max is "+_maxLength+") "+"for transport "+this.getType();_setTimeout((function(){self.transportFailure(envelope,request,"error",x)}),0)}else{try{var sameStack=true;this.jsonpSend({transport:this,url:envelope.url,sync:envelope.sync,headers:_requestHeaders,body:messages,onSuccess:function(responses){var success=false;try{var received=self.convertToMessages(responses);if(received.length===0){self.transportFailure(envelope,request,"no response",null)}else{success=true;self.transportSuccess(envelope,request,received)}}catch(x){_debug(x);if(!success){self.transportFailure(envelope,request,"bad response",x)}}},onError:function(reason,exception){if(sameStack){_setTimeout((function(){self.transportFailure(envelope,request,reason,exception)}),0)}else{self.transportFailure(envelope,request,reason,exception)}}});sameStack=false}catch(xx){_setTimeout((function(){self.transportFailure(envelope,request,"error",xx)}),0)}}};return that};org.cometd.WebSocketTransport=function(){var _super=new org.cometd.Transport;var that=org.cometd.Transport.derive(_super);var _webSocket;var _supportsWebSocket=true;var _envelope;var _state;var _metaConnectEnvelope;var _timeouts={};var _WebSocket;if(window.WebSocket){_WebSocket=window.WebSocket;_state=_WebSocket.CLOSED}function _doSend(envelope,metaConnect){if(_webSocket.send(org.cometd.JSON.toJSON(envelope.messages))){var delay=_maxNetworkDelay;if(metaConnect){delay+=_advice.timeout}for(var i=0;i<envelope.messages.length;++i){var message=envelope.messages[i];if(message.id){_timeouts[message.id]=_setTimeout((function(){delete _timeouts[message.id];var errorMessage="TIMEOUT message "+message.id+" exceeded "+delay+"ms";_debug(errorMessage);envelope.onFailure(_webSocket,"timeout",errorMessage)}),delay);_debug("waiting",delay," for  ",message.id,org.cometd.JSON.toJSON(_timeouts))}}}else{_setTimeout((function(){envelope.onFailure(_webSocket,"failed",null)}),0)}}that.accept=function(version,crossDomain){return _supportsWebSocket&&_WebSocket!==null&&typeof _WebSocket==="function"};that.send=function(envelope,metaConnect){_debug("Transport",this,"sending",envelope,"metaConnect",metaConnect);if(metaConnect){_metaConnectEnvelope=envelope}else{_envelope=envelope}if(_state===_WebSocket.OPEN){_doSend(envelope,metaConnect)}else{var url=(document.location.protocol+"//"+document.location.host+envelope.url).replace(/^http/,"ws");_debug("Transport",this,"URL",url);var self=this;var webSocket=new _WebSocket(url);webSocket.onopen=function(){_debug("Opened",webSocket);_state=_WebSocket.OPEN;_webSocket=webSocket;_doSend(envelope,metaConnect)};webSocket.onclose=function(){_debug("Closed",webSocket);if(_state!==_WebSocket.OPEN){_supportsWebSocket=false;envelope.onFailure(webSocket,"cannot open",null)}else{_state=_WebSocket.CLOSED;for(var i in _timeouts){clearTimeout(_timeouts[i]);delete _timeouts[i]}}};webSocket.onmessage=function(message){_debug("Message",message);if(_state===_WebSocket.OPEN){var rcvdMessages=self.convertToMessages(message.data);var mc=false;for(var i=0;i<rcvdMessages.length;++i){var msg=rcvdMessages[i];if("/meta/connect"==msg.channelId){mc=true}_debug("timeouts",_timeouts,org.cometd.JSON.toJSON(_timeouts));if(!msg.data&&msg.id&&_timeouts[msg.id]){_debug("timeout",_timeouts[msg.id]);clearTimeout(_timeouts[msg.id]);delete _timeouts[msg.id]}if("/meta/disconnect"==msg.channel&&msg.successful){webSocket.close()}}if(mc){_metaConnectEnvelope.onSuccess(rcvdMessages)}else{_envelope.onSuccess(rcvdMessages)}}else{envelope.onFailure(webSocket,"closed",null)}}}};that.reset=function(){_debug("reset",_webSocket);_super.reset();if(_webSocket){_webSocket.close()}_supportsWebSocket=true;_state=_WebSocket.CLOSED;_envelope=null;_metaConnectEnvelope=null};return that}};
