/*
# cjt/modules.js                                     Copyright 2022 cPanel, L.L.C.
#                                                           All rights reserved.
# copyright@cpanel.net                                         http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited
*/

/* global define: false, console: false */

define(
    [
        PAGE.CJT2_MODULES_DEPENDENCY_PATH,
        "cjt/util/module",
        "cjt/bootstrap",
        "cjt/decorators/$httpDecorator",
        "cjt/decorators/alertAPIReporter",
        "cjt/decorators/angularChosenDecorator",
        "cjt/decorators/dynamicName",
        "cjt/decorators/growlAPIReporter",
        "cjt/decorators/growlDecorator",
        "cjt/decorators/paginationDecorator",
        "cjt/decorators/uibTypeaheadDecorator",
        "cjt/diag/routeDirective",
        "cjt/directives/actionButtonDirective",
        "cjt/directives/alert",
        "cjt/directives/alertList",
        "cjt/directives/autoFocus",
        "cjt/directives/boolToInt",
        "cjt/directives/breadcrumbs",
        "cjt/directives/bytesInput",
        "cjt/directives/callout",
        "cjt/directives/checkStrength",
        "cjt/directives/copyField",
        "cjt/directives/datePicker",
        "cjt/directives/deepTriStateCheckbox",
        "cjt/directives/disableAnimations",
        "cjt/directives/displayPasswordStrength",
        "cjt/directives/dynamicValidatorDirective",
        "cjt/directives/focusFirstErrorDirective",
        "cjt/directives/focusInput",
        "cjt/directives/formWaiting",
        "cjt/directives/includeExclude",
        "cjt/directives/jsonFieldDirective",
        "cjt/directives/labelSuffixDirective",
        "cjt/directives/lastItem",
        "cjt/directives/limitRange",
        "cjt/directives/loadingPanel",
        "cjt/directives/multiFieldEditor",
        "cjt/directives/multiFieldEditorItem",
        "cjt/directives/indeterminateState",
        "cjt/directives/ngDebounceDirective",
        "cjt/directives/onKeyupDirective",
        "cjt/directives/pageSizeDirective",
        "cjt/directives/pageSizeButtonDirective",
        "cjt/directives/passwordFieldDirective",
        "cjt/directives/preventDefaultOnEnter",
        "cjt/directives/preventNavigationOnBackspaceDirective",
        "cjt/directives/processingIconDirective",
        "cjt/directives/quickFiltersDirective",
        "cjt/directives/quickFilterItemDirective",
        "cjt/directives/responsiveSortDirective",
        "cjt/directives/responsiveSortInsertDirective",
        "cjt/directives/searchDirective",
        "cjt/directives/selectSortDirective",
        "cjt/directives/spinnerDirective",
        "cjt/directives/statsDirective",
        "cjt/directives/terminal",
        "cjt/directives/timePicker",
        "cjt/directives/toggleLabelInfoDirective",
        "cjt/directives/toggleSortDirective",
        "cjt/directives/toggleSwitchDirective",
        "cjt/directives/triStateCheckbox",
        "cjt/directives/updatePasswordStrengthDirective",
        "cjt/directives/validateEqualsDirective",
        "cjt/directives/validateMinimumPasswordStrength",
        "cjt/directives/validationContainerDirective",
        "cjt/directives/validationItemDirective",
        "cjt/filters/breakFilter",
        "cjt/filters/htmlFilter",
        "cjt/filters/jsonFilter",
        "cjt/filters/nospaceFilter",
        "cjt/filters/notApplicableFilter",
        "cjt/filters/replaceFilter",
        "cjt/filters/splitFilter",
        "cjt/filters/startFromFilter",
        "cjt/filters/timezoneFilter",
        "cjt/filters/wrapFilter",
        "cjt/filters/rangeFilter",
        "cjt/services/APIFailures",
        "cjt/services/APICatcher",
        "cjt/services/APIService",
        "cjt/services/alertService",
        "cjt/services/autoTopService",
        "cjt/services/dataCacheService",
        "cjt/services/onBeforeUnload",
        "cjt/services/passwordStrengthService",
        "cjt/services/viewNavigationApi",
        "cjt/validator/validateDirectiveFactory",
        "cjt/views/applicationController",
        "cjt/filters/qaSafeIDFilter",
        "cjt/services/popupService",
        "cjt/services/windowMonitorService",
        "cjt/services/pageIdentifierService",
        "cjt/models/searchSettingsModel",
    ],
    function(APPLICATION_SPECIFIC_MODULES, MODULE_UTIL) {
        "use strict";

        // Create the cjt2 module package and set its dependencies
        MODULE_UTIL.createModule(PAGE.CJT2_ANGULAR_MODULE_NAME, [

            // Decorators
            "cjt2.decorators.$http",
            "cjt2.decorators.alertAPIReporter",
            "cjt2.decorators.angularChosenDecorator",
            "cjt2.decorators.dynamicName",
            "cjt2.decorators.growlAPIReporter",
            "cjt2.decorators.growlDecorator",
            "cjt2.decorators.paginationDecorator",
            "cjt2.decorators.uibTypeaheadDecorator",

            // Diagnostics
            "cjt2.diag.route",

            // Directives
            "cjt2.directives.actionButton",
            "cjt2.directives.alert",
            "cjt2.directives.alertList",
            "cjt2.directives.autoFocus",
            "cjt2.directives.boolToInt",
            "cjt2.directives.breadcrumbs",
            "cjt2.directives.bytesInput",
            "cjt2.directives.callout",
            "cjt2.directives.checkPasswordStrength",
            "cjt2.directives.copyField",
            "cjt2.directives.datePicker",
            "cjt2.directives.deepTriStateCheckbox",
            "cjt2.directives.disableAnimations",
            "cjt2.directives.displayPasswordStrength",
            "cjt2.directives.dynamicValidator",
            "cjt2.directives.focusFirstError",
            "cjt2.directives.focusInput",
            "cjt2.directives.formWaiting",
            "cjt2.directives.excludeCharacters",
            "cjt2.directives.includeCharacters",
            "cjt2.directives.jsonFieldDirective",
            "cjt2.directives.labelSuffix",
            "cjt2.directives.lastItem",
            "cjt2.directives.limitRange",
            "cjt2.directives.loadingPanel",
            "cjt2.directives.multiFieldEditor",
            "cjt2.directives.multiFieldEditorItem",
            "cjt2.directives.indeterminateState",
            "cjt2.directives.ngDebounce",
            "cjt2.directives.onKeyUp",
            "cjt2.directives.pageSize",
            "cjt2.directives.pageSizeButton",
            "cjt2.directives.password",
            "cjt2.directives.preventDefaultOnEnter",
            "cjt2.directives.preventNavigationOnBackspace",
            "cjt2.directives.processingIcon",
            "cjt2.directives.quickFilters",
            "cjt2.directives.quickFilterItem",
            "cjt2.directives.responsiveSort",
            "cjt2.directives.responsiveSortInsert",
            "cjt2.directives.search",
            "cjt2.directives.selectSort",
            "cjt2.directives.spinner",
            "cjt2.directives.statsDirective",
            "cjt2.directives.terminal",
            "cjt2.directives.timePicker",
            "cjt2.directives.toggleLabelInfo",
            "cjt2.directives.toggleSort",
            "cjt2.directives.toggleSwitch",
            "cjt2.directives.triStateCheckbox",
            "cjt2.directives.updatePasswordStrength",
            "cjt2.directives.validateEquals",
            "cjt2.directives.minimumPasswordStrength",
            "cjt2.directives.validationContainer",
            "cjt2.directives.validationItem",

            // Filters
            "cjt2.filters.break",
            "cjt2.filters.encodeHtml",
            "cjt2.filters.json",
            "cjt2.filters.nospace",
            "cjt2.filters.na",
            "cjt2.filters.replace",
            "cjt2.filters.split",
            "cjt2.filters.startFrom",
            "cjt2.filters.timezone",
            "cjt2.filters.wrap",
            "cjt2.filters.qaSafeID",
            "cjt2.filters.range",

            // Services
            "cjt2.services.alert",
            "cjt2.services.api",
            "cjt2.services.apifailures",
            "cjt2.services.apicatcher",
            "cjt2.services.autoTop",
            "cjt2.services.dataCache",
            "cjt2.services.onBeforeUnload",
            "cjt2.services.passwordStrength",
            "cjt2.services.pageIdentiferService",
            "cjt2.services.popupService",
            "cjt2.services.viewNavigationApi",
            "cjt2.services.windowMonitor",

            // Views
            "cjt2.views.applicationController",

            // Validation
            "cjt2.validate"
        ].concat(APPLICATION_SPECIFIC_MODULES));
    }
);
