(function () {
/**
 * @license RequireJS text 2.0.12 Copyright (c) 2010-2014, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/requirejs/text for details
 */
/*jslint regexp: true */
/*global require, XMLHttpRequest, ActiveXObject,
  define, window, process, Packages,
  java, location, Components, FileUtils */
define('text',["module"], function(e) {
    "use strict";
    var t, n, r, i, s, o = ["Msxml2.XMLHTTP", "Microsoft.XMLHTTP", "Msxml2.XMLHTTP.4.0"],
        u = /^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,
        a = /<body[^>]*>\s*([\s\S]+)\s*<\/body>/im,
        f = typeof location !== "undefined" && location.href,
        l = f && location.protocol && location.protocol.replace(/\:/, ""),
        c = f && location.hostname,
        h = f && (location.port || undefined),
        p = {}, d = e.config && e.config() || {};
    t = {
        version: "2.0.12",
        strip: function(e) {
            if (e) {
                e = e.replace(u, "");
                var t = e.match(a);
                if (t) {
                    e = t[1]
                }
            } else {
                e = ""
            }
            return e
        },
        jsEscape: function(e) {
            return e.replace(/(['\\])/g, "\\$1").replace(/[\f]/g, "\\f").replace(/[\b]/g, "\\b").replace(/[\n]/g, "\\n").replace(/[\t]/g, "\\t").replace(/[\r]/g, "\\r").replace(/[\u2028]/g, "\\u2028").replace(/[\u2029]/g, "\\u2029")
        },
        createXhr: d.createXhr || function() {
            var e, t, n;
            if (typeof XMLHttpRequest !== "undefined") {
                return new XMLHttpRequest
            } else if (typeof ActiveXObject !== "undefined") {
                for (t = 0; t < 3; t += 1) {
                    n = o[t];
                    try {
                        e = new ActiveXObject(n)
                    } catch (r) {}
                    if (e) {
                        o = [n];
                        break
                    }
                }
            }
            return e
        },
        parseName: function(e) {
            var t, n, r, i = false,
                s = e.indexOf("."),
                o = e.indexOf("./") === 0 || e.indexOf("../") === 0;
            if (s !== -1 && (!o || s > 1)) {
                t = e.substring(0, s);
                n = e.substring(s + 1, e.length)
            } else {
                t = e
            }
            r = n || t;
            s = r.indexOf("!");
            if (s !== -1) {
                i = r.substring(s + 1) === "strip";
                r = r.substring(0, s);
                if (n) {
                    n = r
                } else {
                    t = r
                }
            }
            return {
                moduleName: t,
                ext: n,
                strip: i
            }
        },
        xdRegExp: /^((\w+)\:)?\/\/([^\/\\]+)/,
        useXhr: function(e, n, r, i) {
            var s, o, u, a = t.xdRegExp.exec(e);
            if (!a) {
                return true
            }
            s = a[2];
            o = a[3];
            o = o.split(":");
            u = o[1];
            o = o[0];
            return (!s || s === n) && (!o || o.toLowerCase() === r.toLowerCase()) && (!u && !o || u === i)
        },
        finishLoad: function(e, n, r, i) {
            r = n ? t.strip(r) : r;
            if (d.isBuild) {
                p[e] = r
            }
            i(r)
        },
        load: function(e, n, r, i) {
            if (i && i.isBuild && !i.inlineText) {
                r();
                return
            }
            d.isBuild = i && i.isBuild;
            var s = t.parseName(e),
                o = s.moduleName + (s.ext ? "." + s.ext : ""),
                u = n.toUrl(o),
                a = d.useXhr || t.useXhr;
            if (u.indexOf("empty:") === 0) {
                r();
                return
            }
            if (!f || a(u, l, c, h)) {
                t.get(u, function(n) {
                    t.finishLoad(e, s.strip, n, r)
                }, function(e) {
                    if (r.error) {
                        r.error(e)
                    }
                })
            } else {
                n([o], function(e) {
                    t.finishLoad(s.moduleName + "." + s.ext, s.strip, e, r)
                })
            }
        },
        write: function(e, n, r, i) {
            if (p.hasOwnProperty(n)) {
                var s = t.jsEscape(p[n]);
                r.asModule(e + "!" + n, "define(function () { return '" + s + "';});\n")
            }
        },
        writeFile: function(e, n, r, i, s) {
            var o = t.parseName(n),
                u = o.ext ? "." + o.ext : "",
                a = o.moduleName + u,
                f = r.toUrl(o.moduleName + u) + ".js";
            t.load(a, r, function(n) {
                var r = function(e) {
                    return i(f, e)
                };
                r.asModule = function(e, t) {
                    return i.asModule(e, f, t)
                };
                t.write(e, a, r, s)
            }, s)
        }
    };
    if (d.env === "node" || !d.env && typeof process !== "undefined" && process.versions && !! process.versions.node && !process.versions["node-webkit"]) {
        n = require.nodeRequire("fs");
        t.get = function(e, t, r) {
            try {
                var i = n.readFileSync(e, "utf8");
                if (i.indexOf("﻿") === 0) {
                    i = i.substring(1)
                }
                t(i)
            } catch (s) {
                if (r) {
                    r(s)
                }
            }
        }
    } else if (d.env === "xhr" || !d.env && t.createXhr()) {
        t.get = function(e, n, r, i) {
            var s = t.createXhr(),
                o;
            s.open("GET", e, true);
            if (i) {
                for (o in i) {
                    if (i.hasOwnProperty(o)) {
                        s.setRequestHeader(o.toLowerCase(), i[o])
                    }
                }
            }
            if (d.onXhr) {
                d.onXhr(s, e)
            }
            s.onreadystatechange = function(t) {
                var i, o;
                if (s.readyState === 4) {
                    i = s.status || 0;
                    if (i > 399 && i < 600) {
                        o = new Error(e + " HTTP status: " + i);
                        o.xhr = s;
                        if (r) {
                            r(o)
                        }
                    } else {
                        n(s.responseText)
                    } if (d.onXhrComplete) {
                        d.onXhrComplete(s, e)
                    }
                }
            };
            s.send(null)
        }
    } else if (d.env === "rhino" || !d.env && typeof Packages !== "undefined" && typeof java !== "undefined") {
        t.get = function(e, t) {
            var n, r, i = "utf-8",
                s = new java.io.File(e),
                o = java.lang.System.getProperty("line.separator"),
                u = new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(s), i)),
                a = "";
            try {
                n = new java.lang.StringBuffer;
                r = u.readLine();
                if (r && r.length() && r.charAt(0) === 65279) {
                    r = r.substring(1)
                }
                if (r !== null) {
                    n.append(r)
                }
                while ((r = u.readLine()) !== null) {
                    n.append(o);
                    n.append(r)
                }
                a = String(n.toString())
            } finally {
                u.close()
            }
            t(a)
        }
    } else if (d.env === "xpconnect" || !d.env && typeof Components !== "undefined" && Components.classes && Components.interfaces) {
        r = Components.classes;
        i = Components.interfaces;
        Components.utils["import"]("resource://gre/modules/FileUtils.jsm");
        s = "@mozilla.org/windows-registry-key;1" in r;
        t.get = function(e, t) {
            var n, o, u, a = {};
            if (s) {
                e = e.replace(/\//g, "\\")
            }
            u = new FileUtils.File(e);
            try {
                n = r["@mozilla.org/network/file-input-stream;1"].createInstance(i.nsIFileInputStream);
                n.init(u, 1, 0, false);
                o = r["@mozilla.org/intl/converter-input-stream;1"].createInstance(i.nsIConverterInputStream);
                o.init(n, "utf-8", n.available(), i.nsIConverterInputStream.DEFAULT_REPLACEMENT_CHARACTER);
                o.readString(n.available(), a);
                o.close();
                n.close();
                t(a.value)
            } catch (f) {
                throw new Error((u && u.path || "") + ": " + f)
            }
        }
    }
    return t
});
/*! jQuery v3.6.0 | (c) OpenJS Foundation and other contributors | jquery.org/license */
!function(e,t){"use strict";"object"==typeof module&&"object"==typeof module.exports?module.exports=e.document?t(e,!0):function(e){if(!e.document)throw new Error("jQuery requires a window with a document");return t(e)}:t(e)}("undefined"!=typeof window?window:this,function(C,e){"use strict";var t=[],r=Object.getPrototypeOf,s=t.slice,g=t.flat?function(e){return t.flat.call(e)}:function(e){return t.concat.apply([],e)},u=t.push,i=t.indexOf,n={},o=n.toString,v=n.hasOwnProperty,a=v.toString,l=a.call(Object),y={},m=function(e){return"function"==typeof e&&"number"!=typeof e.nodeType&&"function"!=typeof e.item},x=function(e){return null!=e&&e===e.window},E=C.document,c={type:!0,src:!0,nonce:!0,noModule:!0};function b(e,t,n){var r,i,o=(n=n||E).createElement("script");if(o.text=e,t)for(r in c)(i=t[r]||t.getAttribute&&t.getAttribute(r))&&o.setAttribute(r,i);n.head.appendChild(o).parentNode.removeChild(o)}function w(e){return null==e?e+"":"object"==typeof e||"function"==typeof e?n[o.call(e)]||"object":typeof e}var f="3.6.0",S=function(e,t){return new S.fn.init(e,t)};function p(e){var t=!!e&&"length"in e&&e.length,n=w(e);return!m(e)&&!x(e)&&("array"===n||0===t||"number"==typeof t&&0<t&&t-1 in e)}S.fn=S.prototype={jquery:f,constructor:S,length:0,toArray:function(){return s.call(this)},get:function(e){return null==e?s.call(this):e<0?this[e+this.length]:this[e]},pushStack:function(e){var t=S.merge(this.constructor(),e);return t.prevObject=this,t},each:function(e){return S.each(this,e)},map:function(n){return this.pushStack(S.map(this,function(e,t){return n.call(e,t,e)}))},slice:function(){return this.pushStack(s.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},even:function(){return this.pushStack(S.grep(this,function(e,t){return(t+1)%2}))},odd:function(){return this.pushStack(S.grep(this,function(e,t){return t%2}))},eq:function(e){var t=this.length,n=+e+(e<0?t:0);return this.pushStack(0<=n&&n<t?[this[n]]:[])},end:function(){return this.prevObject||this.constructor()},push:u,sort:t.sort,splice:t.splice},S.extend=S.fn.extend=function(){var e,t,n,r,i,o,a=arguments[0]||{},s=1,u=arguments.length,l=!1;for("boolean"==typeof a&&(l=a,a=arguments[s]||{},s++),"object"==typeof a||m(a)||(a={}),s===u&&(a=this,s--);s<u;s++)if(null!=(e=arguments[s]))for(t in e)r=e[t],"__proto__"!==t&&a!==r&&(l&&r&&(S.isPlainObject(r)||(i=Array.isArray(r)))?(n=a[t],o=i&&!Array.isArray(n)?[]:i||S.isPlainObject(n)?n:{},i=!1,a[t]=S.extend(l,o,r)):void 0!==r&&(a[t]=r));return a},S.extend({expando:"jQuery"+(f+Math.random()).replace(/\D/g,""),isReady:!0,error:function(e){throw new Error(e)},noop:function(){},isPlainObject:function(e){var t,n;return!(!e||"[object Object]"!==o.call(e))&&(!(t=r(e))||"function"==typeof(n=v.call(t,"constructor")&&t.constructor)&&a.call(n)===l)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},globalEval:function(e,t,n){b(e,{nonce:t&&t.nonce},n)},each:function(e,t){var n,r=0;if(p(e)){for(n=e.length;r<n;r++)if(!1===t.call(e[r],r,e[r]))break}else for(r in e)if(!1===t.call(e[r],r,e[r]))break;return e},makeArray:function(e,t){var n=t||[];return null!=e&&(p(Object(e))?S.merge(n,"string"==typeof e?[e]:e):u.call(n,e)),n},inArray:function(e,t,n){return null==t?-1:i.call(t,e,n)},merge:function(e,t){for(var n=+t.length,r=0,i=e.length;r<n;r++)e[i++]=t[r];return e.length=i,e},grep:function(e,t,n){for(var r=[],i=0,o=e.length,a=!n;i<o;i++)!t(e[i],i)!==a&&r.push(e[i]);return r},map:function(e,t,n){var r,i,o=0,a=[];if(p(e))for(r=e.length;o<r;o++)null!=(i=t(e[o],o,n))&&a.push(i);else for(o in e)null!=(i=t(e[o],o,n))&&a.push(i);return g(a)},guid:1,support:y}),"function"==typeof Symbol&&(S.fn[Symbol.iterator]=t[Symbol.iterator]),S.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(e,t){n["[object "+t+"]"]=t.toLowerCase()});var d=function(n){var e,d,b,o,i,h,f,g,w,u,l,T,C,a,E,v,s,c,y,S="sizzle"+1*new Date,p=n.document,k=0,r=0,m=ue(),x=ue(),A=ue(),N=ue(),j=function(e,t){return e===t&&(l=!0),0},D={}.hasOwnProperty,t=[],q=t.pop,L=t.push,H=t.push,O=t.slice,P=function(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1},R="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",M="[\\x20\\t\\r\\n\\f]",I="(?:\\\\[\\da-fA-F]{1,6}"+M+"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",W="\\["+M+"*("+I+")(?:"+M+"*([*^$|!~]?=)"+M+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+I+"))|)"+M+"*\\]",F=":("+I+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+W+")*)|.*)\\)|)",B=new RegExp(M+"+","g"),$=new RegExp("^"+M+"+|((?:^|[^\\\\])(?:\\\\.)*)"+M+"+$","g"),_=new RegExp("^"+M+"*,"+M+"*"),z=new RegExp("^"+M+"*([>+~]|"+M+")"+M+"*"),U=new RegExp(M+"|>"),X=new RegExp(F),V=new RegExp("^"+I+"$"),G={ID:new RegExp("^#("+I+")"),CLASS:new RegExp("^\\.("+I+")"),TAG:new RegExp("^("+I+"|[*])"),ATTR:new RegExp("^"+W),PSEUDO:new RegExp("^"+F),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+M+"*(even|odd|(([+-]|)(\\d*)n|)"+M+"*(?:([+-]|)"+M+"*(\\d+)|))"+M+"*\\)|)","i"),bool:new RegExp("^(?:"+R+")$","i"),needsContext:new RegExp("^"+M+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+M+"*((?:-\\d)?\\d*)"+M+"*\\)|)(?=[^-]|$)","i")},Y=/HTML$/i,Q=/^(?:input|select|textarea|button)$/i,J=/^h\d$/i,K=/^[^{]+\{\s*\[native \w/,Z=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,ee=/[+~]/,te=new RegExp("\\\\[\\da-fA-F]{1,6}"+M+"?|\\\\([^\\r\\n\\f])","g"),ne=function(e,t){var n="0x"+e.slice(1)-65536;return t||(n<0?String.fromCharCode(n+65536):String.fromCharCode(n>>10|55296,1023&n|56320))},re=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,ie=function(e,t){return t?"\0"===e?"\ufffd":e.slice(0,-1)+"\\"+e.charCodeAt(e.length-1).toString(16)+" ":"\\"+e},oe=function(){T()},ae=be(function(e){return!0===e.disabled&&"fieldset"===e.nodeName.toLowerCase()},{dir:"parentNode",next:"legend"});try{H.apply(t=O.call(p.childNodes),p.childNodes),t[p.childNodes.length].nodeType}catch(e){H={apply:t.length?function(e,t){L.apply(e,O.call(t))}:function(e,t){var n=e.length,r=0;while(e[n++]=t[r++]);e.length=n-1}}}function se(t,e,n,r){var i,o,a,s,u,l,c,f=e&&e.ownerDocument,p=e?e.nodeType:9;if(n=n||[],"string"!=typeof t||!t||1!==p&&9!==p&&11!==p)return n;if(!r&&(T(e),e=e||C,E)){if(11!==p&&(u=Z.exec(t)))if(i=u[1]){if(9===p){if(!(a=e.getElementById(i)))return n;if(a.id===i)return n.push(a),n}else if(f&&(a=f.getElementById(i))&&y(e,a)&&a.id===i)return n.push(a),n}else{if(u[2])return H.apply(n,e.getElementsByTagName(t)),n;if((i=u[3])&&d.getElementsByClassName&&e.getElementsByClassName)return H.apply(n,e.getElementsByClassName(i)),n}if(d.qsa&&!N[t+" "]&&(!v||!v.test(t))&&(1!==p||"object"!==e.nodeName.toLowerCase())){if(c=t,f=e,1===p&&(U.test(t)||z.test(t))){(f=ee.test(t)&&ye(e.parentNode)||e)===e&&d.scope||((s=e.getAttribute("id"))?s=s.replace(re,ie):e.setAttribute("id",s=S)),o=(l=h(t)).length;while(o--)l[o]=(s?"#"+s:":scope")+" "+xe(l[o]);c=l.join(",")}try{return H.apply(n,f.querySelectorAll(c)),n}catch(e){N(t,!0)}finally{s===S&&e.removeAttribute("id")}}}return g(t.replace($,"$1"),e,n,r)}function ue(){var r=[];return function e(t,n){return r.push(t+" ")>b.cacheLength&&delete e[r.shift()],e[t+" "]=n}}function le(e){return e[S]=!0,e}function ce(e){var t=C.createElement("fieldset");try{return!!e(t)}catch(e){return!1}finally{t.parentNode&&t.parentNode.removeChild(t),t=null}}function fe(e,t){var n=e.split("|"),r=n.length;while(r--)b.attrHandle[n[r]]=t}function pe(e,t){var n=t&&e,r=n&&1===e.nodeType&&1===t.nodeType&&e.sourceIndex-t.sourceIndex;if(r)return r;if(n)while(n=n.nextSibling)if(n===t)return-1;return e?1:-1}function de(t){return function(e){return"input"===e.nodeName.toLowerCase()&&e.type===t}}function he(n){return function(e){var t=e.nodeName.toLowerCase();return("input"===t||"button"===t)&&e.type===n}}function ge(t){return function(e){return"form"in e?e.parentNode&&!1===e.disabled?"label"in e?"label"in e.parentNode?e.parentNode.disabled===t:e.disabled===t:e.isDisabled===t||e.isDisabled!==!t&&ae(e)===t:e.disabled===t:"label"in e&&e.disabled===t}}function ve(a){return le(function(o){return o=+o,le(function(e,t){var n,r=a([],e.length,o),i=r.length;while(i--)e[n=r[i]]&&(e[n]=!(t[n]=e[n]))})})}function ye(e){return e&&"undefined"!=typeof e.getElementsByTagName&&e}for(e in d=se.support={},i=se.isXML=function(e){var t=e&&e.namespaceURI,n=e&&(e.ownerDocument||e).documentElement;return!Y.test(t||n&&n.nodeName||"HTML")},T=se.setDocument=function(e){var t,n,r=e?e.ownerDocument||e:p;return r!=C&&9===r.nodeType&&r.documentElement&&(a=(C=r).documentElement,E=!i(C),p!=C&&(n=C.defaultView)&&n.top!==n&&(n.addEventListener?n.addEventListener("unload",oe,!1):n.attachEvent&&n.attachEvent("onunload",oe)),d.scope=ce(function(e){return a.appendChild(e).appendChild(C.createElement("div")),"undefined"!=typeof e.querySelectorAll&&!e.querySelectorAll(":scope fieldset div").length}),d.attributes=ce(function(e){return e.className="i",!e.getAttribute("className")}),d.getElementsByTagName=ce(function(e){return e.appendChild(C.createComment("")),!e.getElementsByTagName("*").length}),d.getElementsByClassName=K.test(C.getElementsByClassName),d.getById=ce(function(e){return a.appendChild(e).id=S,!C.getElementsByName||!C.getElementsByName(S).length}),d.getById?(b.filter.ID=function(e){var t=e.replace(te,ne);return function(e){return e.getAttribute("id")===t}},b.find.ID=function(e,t){if("undefined"!=typeof t.getElementById&&E){var n=t.getElementById(e);return n?[n]:[]}}):(b.filter.ID=function(e){var n=e.replace(te,ne);return function(e){var t="undefined"!=typeof e.getAttributeNode&&e.getAttributeNode("id");return t&&t.value===n}},b.find.ID=function(e,t){if("undefined"!=typeof t.getElementById&&E){var n,r,i,o=t.getElementById(e);if(o){if((n=o.getAttributeNode("id"))&&n.value===e)return[o];i=t.getElementsByName(e),r=0;while(o=i[r++])if((n=o.getAttributeNode("id"))&&n.value===e)return[o]}return[]}}),b.find.TAG=d.getElementsByTagName?function(e,t){return"undefined"!=typeof t.getElementsByTagName?t.getElementsByTagName(e):d.qsa?t.querySelectorAll(e):void 0}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if("*"===e){while(n=o[i++])1===n.nodeType&&r.push(n);return r}return o},b.find.CLASS=d.getElementsByClassName&&function(e,t){if("undefined"!=typeof t.getElementsByClassName&&E)return t.getElementsByClassName(e)},s=[],v=[],(d.qsa=K.test(C.querySelectorAll))&&(ce(function(e){var t;a.appendChild(e).innerHTML="<a id='"+S+"'></a><select id='"+S+"-\r\\' msallowcapture=''><option selected=''></option></select>",e.querySelectorAll("[msallowcapture^='']").length&&v.push("[*^$]="+M+"*(?:''|\"\")"),e.querySelectorAll("[selected]").length||v.push("\\["+M+"*(?:value|"+R+")"),e.querySelectorAll("[id~="+S+"-]").length||v.push("~="),(t=C.createElement("input")).setAttribute("name",""),e.appendChild(t),e.querySelectorAll("[name='']").length||v.push("\\["+M+"*name"+M+"*="+M+"*(?:''|\"\")"),e.querySelectorAll(":checked").length||v.push(":checked"),e.querySelectorAll("a#"+S+"+*").length||v.push(".#.+[+~]"),e.querySelectorAll("\\\f"),v.push("[\\r\\n\\f]")}),ce(function(e){e.innerHTML="<a href='' disabled='disabled'></a><select disabled='disabled'><option/></select>";var t=C.createElement("input");t.setAttribute("type","hidden"),e.appendChild(t).setAttribute("name","D"),e.querySelectorAll("[name=d]").length&&v.push("name"+M+"*[*^$|!~]?="),2!==e.querySelectorAll(":enabled").length&&v.push(":enabled",":disabled"),a.appendChild(e).disabled=!0,2!==e.querySelectorAll(":disabled").length&&v.push(":enabled",":disabled"),e.querySelectorAll("*,:x"),v.push(",.*:")})),(d.matchesSelector=K.test(c=a.matches||a.webkitMatchesSelector||a.mozMatchesSelector||a.oMatchesSelector||a.msMatchesSelector))&&ce(function(e){d.disconnectedMatch=c.call(e,"*"),c.call(e,"[s!='']:x"),s.push("!=",F)}),v=v.length&&new RegExp(v.join("|")),s=s.length&&new RegExp(s.join("|")),t=K.test(a.compareDocumentPosition),y=t||K.test(a.contains)?function(e,t){var n=9===e.nodeType?e.documentElement:e,r=t&&t.parentNode;return e===r||!(!r||1!==r.nodeType||!(n.contains?n.contains(r):e.compareDocumentPosition&&16&e.compareDocumentPosition(r)))}:function(e,t){if(t)while(t=t.parentNode)if(t===e)return!0;return!1},j=t?function(e,t){if(e===t)return l=!0,0;var n=!e.compareDocumentPosition-!t.compareDocumentPosition;return n||(1&(n=(e.ownerDocument||e)==(t.ownerDocument||t)?e.compareDocumentPosition(t):1)||!d.sortDetached&&t.compareDocumentPosition(e)===n?e==C||e.ownerDocument==p&&y(p,e)?-1:t==C||t.ownerDocument==p&&y(p,t)?1:u?P(u,e)-P(u,t):0:4&n?-1:1)}:function(e,t){if(e===t)return l=!0,0;var n,r=0,i=e.parentNode,o=t.parentNode,a=[e],s=[t];if(!i||!o)return e==C?-1:t==C?1:i?-1:o?1:u?P(u,e)-P(u,t):0;if(i===o)return pe(e,t);n=e;while(n=n.parentNode)a.unshift(n);n=t;while(n=n.parentNode)s.unshift(n);while(a[r]===s[r])r++;return r?pe(a[r],s[r]):a[r]==p?-1:s[r]==p?1:0}),C},se.matches=function(e,t){return se(e,null,null,t)},se.matchesSelector=function(e,t){if(T(e),d.matchesSelector&&E&&!N[t+" "]&&(!s||!s.test(t))&&(!v||!v.test(t)))try{var n=c.call(e,t);if(n||d.disconnectedMatch||e.document&&11!==e.document.nodeType)return n}catch(e){N(t,!0)}return 0<se(t,C,null,[e]).length},se.contains=function(e,t){return(e.ownerDocument||e)!=C&&T(e),y(e,t)},se.attr=function(e,t){(e.ownerDocument||e)!=C&&T(e);var n=b.attrHandle[t.toLowerCase()],r=n&&D.call(b.attrHandle,t.toLowerCase())?n(e,t,!E):void 0;return void 0!==r?r:d.attributes||!E?e.getAttribute(t):(r=e.getAttributeNode(t))&&r.specified?r.value:null},se.escape=function(e){return(e+"").replace(re,ie)},se.error=function(e){throw new Error("Syntax error, unrecognized expression: "+e)},se.uniqueSort=function(e){var t,n=[],r=0,i=0;if(l=!d.detectDuplicates,u=!d.sortStable&&e.slice(0),e.sort(j),l){while(t=e[i++])t===e[i]&&(r=n.push(i));while(r--)e.splice(n[r],1)}return u=null,e},o=se.getText=function(e){var t,n="",r=0,i=e.nodeType;if(i){if(1===i||9===i||11===i){if("string"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=o(e)}else if(3===i||4===i)return e.nodeValue}else while(t=e[r++])n+=o(t);return n},(b=se.selectors={cacheLength:50,createPseudo:le,match:G,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(te,ne),e[3]=(e[3]||e[4]||e[5]||"").replace(te,ne),"~="===e[2]&&(e[3]=" "+e[3]+" "),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),"nth"===e[1].slice(0,3)?(e[3]||se.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*("even"===e[3]||"odd"===e[3])),e[5]=+(e[7]+e[8]||"odd"===e[3])):e[3]&&se.error(e[0]),e},PSEUDO:function(e){var t,n=!e[6]&&e[2];return G.CHILD.test(e[0])?null:(e[3]?e[2]=e[4]||e[5]||"":n&&X.test(n)&&(t=h(n,!0))&&(t=n.indexOf(")",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){var t=e.replace(te,ne).toLowerCase();return"*"===e?function(){return!0}:function(e){return e.nodeName&&e.nodeName.toLowerCase()===t}},CLASS:function(e){var t=m[e+" "];return t||(t=new RegExp("(^|"+M+")"+e+"("+M+"|$)"))&&m(e,function(e){return t.test("string"==typeof e.className&&e.className||"undefined"!=typeof e.getAttribute&&e.getAttribute("class")||"")})},ATTR:function(n,r,i){return function(e){var t=se.attr(e,n);return null==t?"!="===r:!r||(t+="","="===r?t===i:"!="===r?t!==i:"^="===r?i&&0===t.indexOf(i):"*="===r?i&&-1<t.indexOf(i):"$="===r?i&&t.slice(-i.length)===i:"~="===r?-1<(" "+t.replace(B," ")+" ").indexOf(i):"|="===r&&(t===i||t.slice(0,i.length+1)===i+"-"))}},CHILD:function(h,e,t,g,v){var y="nth"!==h.slice(0,3),m="last"!==h.slice(-4),x="of-type"===e;return 1===g&&0===v?function(e){return!!e.parentNode}:function(e,t,n){var r,i,o,a,s,u,l=y!==m?"nextSibling":"previousSibling",c=e.parentNode,f=x&&e.nodeName.toLowerCase(),p=!n&&!x,d=!1;if(c){if(y){while(l){a=e;while(a=a[l])if(x?a.nodeName.toLowerCase()===f:1===a.nodeType)return!1;u=l="only"===h&&!u&&"nextSibling"}return!0}if(u=[m?c.firstChild:c.lastChild],m&&p){d=(s=(r=(i=(o=(a=c)[S]||(a[S]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]||[])[0]===k&&r[1])&&r[2],a=s&&c.childNodes[s];while(a=++s&&a&&a[l]||(d=s=0)||u.pop())if(1===a.nodeType&&++d&&a===e){i[h]=[k,s,d];break}}else if(p&&(d=s=(r=(i=(o=(a=e)[S]||(a[S]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]||[])[0]===k&&r[1]),!1===d)while(a=++s&&a&&a[l]||(d=s=0)||u.pop())if((x?a.nodeName.toLowerCase()===f:1===a.nodeType)&&++d&&(p&&((i=(o=a[S]||(a[S]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]=[k,d]),a===e))break;return(d-=v)===g||d%g==0&&0<=d/g}}},PSEUDO:function(e,o){var t,a=b.pseudos[e]||b.setFilters[e.toLowerCase()]||se.error("unsupported pseudo: "+e);return a[S]?a(o):1<a.length?(t=[e,e,"",o],b.setFilters.hasOwnProperty(e.toLowerCase())?le(function(e,t){var n,r=a(e,o),i=r.length;while(i--)e[n=P(e,r[i])]=!(t[n]=r[i])}):function(e){return a(e,0,t)}):a}},pseudos:{not:le(function(e){var r=[],i=[],s=f(e.replace($,"$1"));return s[S]?le(function(e,t,n,r){var i,o=s(e,null,r,[]),a=e.length;while(a--)(i=o[a])&&(e[a]=!(t[a]=i))}):function(e,t,n){return r[0]=e,s(r,null,n,i),r[0]=null,!i.pop()}}),has:le(function(t){return function(e){return 0<se(t,e).length}}),contains:le(function(t){return t=t.replace(te,ne),function(e){return-1<(e.textContent||o(e)).indexOf(t)}}),lang:le(function(n){return V.test(n||"")||se.error("unsupported lang: "+n),n=n.replace(te,ne).toLowerCase(),function(e){var t;do{if(t=E?e.lang:e.getAttribute("xml:lang")||e.getAttribute("lang"))return(t=t.toLowerCase())===n||0===t.indexOf(n+"-")}while((e=e.parentNode)&&1===e.nodeType);return!1}}),target:function(e){var t=n.location&&n.location.hash;return t&&t.slice(1)===e.id},root:function(e){return e===a},focus:function(e){return e===C.activeElement&&(!C.hasFocus||C.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:ge(!1),disabled:ge(!0),checked:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&!!e.checked||"option"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,!0===e.selected},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeType<6)return!1;return!0},parent:function(e){return!b.pseudos.empty(e)},header:function(e){return J.test(e.nodeName)},input:function(e){return Q.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&"button"===e.type||"button"===t},text:function(e){var t;return"input"===e.nodeName.toLowerCase()&&"text"===e.type&&(null==(t=e.getAttribute("type"))||"text"===t.toLowerCase())},first:ve(function(){return[0]}),last:ve(function(e,t){return[t-1]}),eq:ve(function(e,t,n){return[n<0?n+t:n]}),even:ve(function(e,t){for(var n=0;n<t;n+=2)e.push(n);return e}),odd:ve(function(e,t){for(var n=1;n<t;n+=2)e.push(n);return e}),lt:ve(function(e,t,n){for(var r=n<0?n+t:t<n?t:n;0<=--r;)e.push(r);return e}),gt:ve(function(e,t,n){for(var r=n<0?n+t:n;++r<t;)e.push(r);return e})}}).pseudos.nth=b.pseudos.eq,{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})b.pseudos[e]=de(e);for(e in{submit:!0,reset:!0})b.pseudos[e]=he(e);function me(){}function xe(e){for(var t=0,n=e.length,r="";t<n;t++)r+=e[t].value;return r}function be(s,e,t){var u=e.dir,l=e.next,c=l||u,f=t&&"parentNode"===c,p=r++;return e.first?function(e,t,n){while(e=e[u])if(1===e.nodeType||f)return s(e,t,n);return!1}:function(e,t,n){var r,i,o,a=[k,p];if(n){while(e=e[u])if((1===e.nodeType||f)&&s(e,t,n))return!0}else while(e=e[u])if(1===e.nodeType||f)if(i=(o=e[S]||(e[S]={}))[e.uniqueID]||(o[e.uniqueID]={}),l&&l===e.nodeName.toLowerCase())e=e[u]||e;else{if((r=i[c])&&r[0]===k&&r[1]===p)return a[2]=r[2];if((i[c]=a)[2]=s(e,t,n))return!0}return!1}}function we(i){return 1<i.length?function(e,t,n){var r=i.length;while(r--)if(!i[r](e,t,n))return!1;return!0}:i[0]}function Te(e,t,n,r,i){for(var o,a=[],s=0,u=e.length,l=null!=t;s<u;s++)(o=e[s])&&(n&&!n(o,r,i)||(a.push(o),l&&t.push(s)));return a}function Ce(d,h,g,v,y,e){return v&&!v[S]&&(v=Ce(v)),y&&!y[S]&&(y=Ce(y,e)),le(function(e,t,n,r){var i,o,a,s=[],u=[],l=t.length,c=e||function(e,t,n){for(var r=0,i=t.length;r<i;r++)se(e,t[r],n);return n}(h||"*",n.nodeType?[n]:n,[]),f=!d||!e&&h?c:Te(c,s,d,n,r),p=g?y||(e?d:l||v)?[]:t:f;if(g&&g(f,p,n,r),v){i=Te(p,u),v(i,[],n,r),o=i.length;while(o--)(a=i[o])&&(p[u[o]]=!(f[u[o]]=a))}if(e){if(y||d){if(y){i=[],o=p.length;while(o--)(a=p[o])&&i.push(f[o]=a);y(null,p=[],i,r)}o=p.length;while(o--)(a=p[o])&&-1<(i=y?P(e,a):s[o])&&(e[i]=!(t[i]=a))}}else p=Te(p===t?p.splice(l,p.length):p),y?y(null,t,p,r):H.apply(t,p)})}function Ee(e){for(var i,t,n,r=e.length,o=b.relative[e[0].type],a=o||b.relative[" "],s=o?1:0,u=be(function(e){return e===i},a,!0),l=be(function(e){return-1<P(i,e)},a,!0),c=[function(e,t,n){var r=!o&&(n||t!==w)||((i=t).nodeType?u(e,t,n):l(e,t,n));return i=null,r}];s<r;s++)if(t=b.relative[e[s].type])c=[be(we(c),t)];else{if((t=b.filter[e[s].type].apply(null,e[s].matches))[S]){for(n=++s;n<r;n++)if(b.relative[e[n].type])break;return Ce(1<s&&we(c),1<s&&xe(e.slice(0,s-1).concat({value:" "===e[s-2].type?"*":""})).replace($,"$1"),t,s<n&&Ee(e.slice(s,n)),n<r&&Ee(e=e.slice(n)),n<r&&xe(e))}c.push(t)}return we(c)}return me.prototype=b.filters=b.pseudos,b.setFilters=new me,h=se.tokenize=function(e,t){var n,r,i,o,a,s,u,l=x[e+" "];if(l)return t?0:l.slice(0);a=e,s=[],u=b.preFilter;while(a){for(o in n&&!(r=_.exec(a))||(r&&(a=a.slice(r[0].length)||a),s.push(i=[])),n=!1,(r=z.exec(a))&&(n=r.shift(),i.push({value:n,type:r[0].replace($," ")}),a=a.slice(n.length)),b.filter)!(r=G[o].exec(a))||u[o]&&!(r=u[o](r))||(n=r.shift(),i.push({value:n,type:o,matches:r}),a=a.slice(n.length));if(!n)break}return t?a.length:a?se.error(e):x(e,s).slice(0)},f=se.compile=function(e,t){var n,v,y,m,x,r,i=[],o=[],a=A[e+" "];if(!a){t||(t=h(e)),n=t.length;while(n--)(a=Ee(t[n]))[S]?i.push(a):o.push(a);(a=A(e,(v=o,m=0<(y=i).length,x=0<v.length,r=function(e,t,n,r,i){var o,a,s,u=0,l="0",c=e&&[],f=[],p=w,d=e||x&&b.find.TAG("*",i),h=k+=null==p?1:Math.random()||.1,g=d.length;for(i&&(w=t==C||t||i);l!==g&&null!=(o=d[l]);l++){if(x&&o){a=0,t||o.ownerDocument==C||(T(o),n=!E);while(s=v[a++])if(s(o,t||C,n)){r.push(o);break}i&&(k=h)}m&&((o=!s&&o)&&u--,e&&c.push(o))}if(u+=l,m&&l!==u){a=0;while(s=y[a++])s(c,f,t,n);if(e){if(0<u)while(l--)c[l]||f[l]||(f[l]=q.call(r));f=Te(f)}H.apply(r,f),i&&!e&&0<f.length&&1<u+y.length&&se.uniqueSort(r)}return i&&(k=h,w=p),c},m?le(r):r))).selector=e}return a},g=se.select=function(e,t,n,r){var i,o,a,s,u,l="function"==typeof e&&e,c=!r&&h(e=l.selector||e);if(n=n||[],1===c.length){if(2<(o=c[0]=c[0].slice(0)).length&&"ID"===(a=o[0]).type&&9===t.nodeType&&E&&b.relative[o[1].type]){if(!(t=(b.find.ID(a.matches[0].replace(te,ne),t)||[])[0]))return n;l&&(t=t.parentNode),e=e.slice(o.shift().value.length)}i=G.needsContext.test(e)?0:o.length;while(i--){if(a=o[i],b.relative[s=a.type])break;if((u=b.find[s])&&(r=u(a.matches[0].replace(te,ne),ee.test(o[0].type)&&ye(t.parentNode)||t))){if(o.splice(i,1),!(e=r.length&&xe(o)))return H.apply(n,r),n;break}}}return(l||f(e,c))(r,t,!E,n,!t||ee.test(e)&&ye(t.parentNode)||t),n},d.sortStable=S.split("").sort(j).join("")===S,d.detectDuplicates=!!l,T(),d.sortDetached=ce(function(e){return 1&e.compareDocumentPosition(C.createElement("fieldset"))}),ce(function(e){return e.innerHTML="<a href='#'></a>","#"===e.firstChild.getAttribute("href")})||fe("type|href|height|width",function(e,t,n){if(!n)return e.getAttribute(t,"type"===t.toLowerCase()?1:2)}),d.attributes&&ce(function(e){return e.innerHTML="<input/>",e.firstChild.setAttribute("value",""),""===e.firstChild.getAttribute("value")})||fe("value",function(e,t,n){if(!n&&"input"===e.nodeName.toLowerCase())return e.defaultValue}),ce(function(e){return null==e.getAttribute("disabled")})||fe(R,function(e,t,n){var r;if(!n)return!0===e[t]?t.toLowerCase():(r=e.getAttributeNode(t))&&r.specified?r.value:null}),se}(C);S.find=d,S.expr=d.selectors,S.expr[":"]=S.expr.pseudos,S.uniqueSort=S.unique=d.uniqueSort,S.text=d.getText,S.isXMLDoc=d.isXML,S.contains=d.contains,S.escapeSelector=d.escape;var h=function(e,t,n){var r=[],i=void 0!==n;while((e=e[t])&&9!==e.nodeType)if(1===e.nodeType){if(i&&S(e).is(n))break;r.push(e)}return r},T=function(e,t){for(var n=[];e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n},k=S.expr.match.needsContext;function A(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()}var N=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;function j(e,n,r){return m(n)?S.grep(e,function(e,t){return!!n.call(e,t,e)!==r}):n.nodeType?S.grep(e,function(e){return e===n!==r}):"string"!=typeof n?S.grep(e,function(e){return-1<i.call(n,e)!==r}):S.filter(n,e,r)}S.filter=function(e,t,n){var r=t[0];return n&&(e=":not("+e+")"),1===t.length&&1===r.nodeType?S.find.matchesSelector(r,e)?[r]:[]:S.find.matches(e,S.grep(t,function(e){return 1===e.nodeType}))},S.fn.extend({find:function(e){var t,n,r=this.length,i=this;if("string"!=typeof e)return this.pushStack(S(e).filter(function(){for(t=0;t<r;t++)if(S.contains(i[t],this))return!0}));for(n=this.pushStack([]),t=0;t<r;t++)S.find(e,i[t],n);return 1<r?S.uniqueSort(n):n},filter:function(e){return this.pushStack(j(this,e||[],!1))},not:function(e){return this.pushStack(j(this,e||[],!0))},is:function(e){return!!j(this,"string"==typeof e&&k.test(e)?S(e):e||[],!1).length}});var D,q=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/;(S.fn.init=function(e,t,n){var r,i;if(!e)return this;if(n=n||D,"string"==typeof e){if(!(r="<"===e[0]&&">"===e[e.length-1]&&3<=e.length?[null,e,null]:q.exec(e))||!r[1]&&t)return!t||t.jquery?(t||n).find(e):this.constructor(t).find(e);if(r[1]){if(t=t instanceof S?t[0]:t,S.merge(this,S.parseHTML(r[1],t&&t.nodeType?t.ownerDocument||t:E,!0)),N.test(r[1])&&S.isPlainObject(t))for(r in t)m(this[r])?this[r](t[r]):this.attr(r,t[r]);return this}return(i=E.getElementById(r[2]))&&(this[0]=i,this.length=1),this}return e.nodeType?(this[0]=e,this.length=1,this):m(e)?void 0!==n.ready?n.ready(e):e(S):S.makeArray(e,this)}).prototype=S.fn,D=S(E);var L=/^(?:parents|prev(?:Until|All))/,H={children:!0,contents:!0,next:!0,prev:!0};function O(e,t){while((e=e[t])&&1!==e.nodeType);return e}S.fn.extend({has:function(e){var t=S(e,this),n=t.length;return this.filter(function(){for(var e=0;e<n;e++)if(S.contains(this,t[e]))return!0})},closest:function(e,t){var n,r=0,i=this.length,o=[],a="string"!=typeof e&&S(e);if(!k.test(e))for(;r<i;r++)for(n=this[r];n&&n!==t;n=n.parentNode)if(n.nodeType<11&&(a?-1<a.index(n):1===n.nodeType&&S.find.matchesSelector(n,e))){o.push(n);break}return this.pushStack(1<o.length?S.uniqueSort(o):o)},index:function(e){return e?"string"==typeof e?i.call(S(e),this[0]):i.call(this,e.jquery?e[0]:e):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){return this.pushStack(S.uniqueSort(S.merge(this.get(),S(e,t))))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),S.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return h(e,"parentNode")},parentsUntil:function(e,t,n){return h(e,"parentNode",n)},next:function(e){return O(e,"nextSibling")},prev:function(e){return O(e,"previousSibling")},nextAll:function(e){return h(e,"nextSibling")},prevAll:function(e){return h(e,"previousSibling")},nextUntil:function(e,t,n){return h(e,"nextSibling",n)},prevUntil:function(e,t,n){return h(e,"previousSibling",n)},siblings:function(e){return T((e.parentNode||{}).firstChild,e)},children:function(e){return T(e.firstChild)},contents:function(e){return null!=e.contentDocument&&r(e.contentDocument)?e.contentDocument:(A(e,"template")&&(e=e.content||e),S.merge([],e.childNodes))}},function(r,i){S.fn[r]=function(e,t){var n=S.map(this,i,e);return"Until"!==r.slice(-5)&&(t=e),t&&"string"==typeof t&&(n=S.filter(t,n)),1<this.length&&(H[r]||S.uniqueSort(n),L.test(r)&&n.reverse()),this.pushStack(n)}});var P=/[^\x20\t\r\n\f]+/g;function R(e){return e}function M(e){throw e}function I(e,t,n,r){var i;try{e&&m(i=e.promise)?i.call(e).done(t).fail(n):e&&m(i=e.then)?i.call(e,t,n):t.apply(void 0,[e].slice(r))}catch(e){n.apply(void 0,[e])}}S.Callbacks=function(r){var e,n;r="string"==typeof r?(e=r,n={},S.each(e.match(P)||[],function(e,t){n[t]=!0}),n):S.extend({},r);var i,t,o,a,s=[],u=[],l=-1,c=function(){for(a=a||r.once,o=i=!0;u.length;l=-1){t=u.shift();while(++l<s.length)!1===s[l].apply(t[0],t[1])&&r.stopOnFalse&&(l=s.length,t=!1)}r.memory||(t=!1),i=!1,a&&(s=t?[]:"")},f={add:function(){return s&&(t&&!i&&(l=s.length-1,u.push(t)),function n(e){S.each(e,function(e,t){m(t)?r.unique&&f.has(t)||s.push(t):t&&t.length&&"string"!==w(t)&&n(t)})}(arguments),t&&!i&&c()),this},remove:function(){return S.each(arguments,function(e,t){var n;while(-1<(n=S.inArray(t,s,n)))s.splice(n,1),n<=l&&l--}),this},has:function(e){return e?-1<S.inArray(e,s):0<s.length},empty:function(){return s&&(s=[]),this},disable:function(){return a=u=[],s=t="",this},disabled:function(){return!s},lock:function(){return a=u=[],t||i||(s=t=""),this},locked:function(){return!!a},fireWith:function(e,t){return a||(t=[e,(t=t||[]).slice?t.slice():t],u.push(t),i||c()),this},fire:function(){return f.fireWith(this,arguments),this},fired:function(){return!!o}};return f},S.extend({Deferred:function(e){var o=[["notify","progress",S.Callbacks("memory"),S.Callbacks("memory"),2],["resolve","done",S.Callbacks("once memory"),S.Callbacks("once memory"),0,"resolved"],["reject","fail",S.Callbacks("once memory"),S.Callbacks("once memory"),1,"rejected"]],i="pending",a={state:function(){return i},always:function(){return s.done(arguments).fail(arguments),this},"catch":function(e){return a.then(null,e)},pipe:function(){var i=arguments;return S.Deferred(function(r){S.each(o,function(e,t){var n=m(i[t[4]])&&i[t[4]];s[t[1]](function(){var e=n&&n.apply(this,arguments);e&&m(e.promise)?e.promise().progress(r.notify).done(r.resolve).fail(r.reject):r[t[0]+"With"](this,n?[e]:arguments)})}),i=null}).promise()},then:function(t,n,r){var u=0;function l(i,o,a,s){return function(){var n=this,r=arguments,e=function(){var e,t;if(!(i<u)){if((e=a.apply(n,r))===o.promise())throw new TypeError("Thenable self-resolution");t=e&&("object"==typeof e||"function"==typeof e)&&e.then,m(t)?s?t.call(e,l(u,o,R,s),l(u,o,M,s)):(u++,t.call(e,l(u,o,R,s),l(u,o,M,s),l(u,o,R,o.notifyWith))):(a!==R&&(n=void 0,r=[e]),(s||o.resolveWith)(n,r))}},t=s?e:function(){try{e()}catch(e){S.Deferred.exceptionHook&&S.Deferred.exceptionHook(e,t.stackTrace),u<=i+1&&(a!==M&&(n=void 0,r=[e]),o.rejectWith(n,r))}};i?t():(S.Deferred.getStackHook&&(t.stackTrace=S.Deferred.getStackHook()),C.setTimeout(t))}}return S.Deferred(function(e){o[0][3].add(l(0,e,m(r)?r:R,e.notifyWith)),o[1][3].add(l(0,e,m(t)?t:R)),o[2][3].add(l(0,e,m(n)?n:M))}).promise()},promise:function(e){return null!=e?S.extend(e,a):a}},s={};return S.each(o,function(e,t){var n=t[2],r=t[5];a[t[1]]=n.add,r&&n.add(function(){i=r},o[3-e][2].disable,o[3-e][3].disable,o[0][2].lock,o[0][3].lock),n.add(t[3].fire),s[t[0]]=function(){return s[t[0]+"With"](this===s?void 0:this,arguments),this},s[t[0]+"With"]=n.fireWith}),a.promise(s),e&&e.call(s,s),s},when:function(e){var n=arguments.length,t=n,r=Array(t),i=s.call(arguments),o=S.Deferred(),a=function(t){return function(e){r[t]=this,i[t]=1<arguments.length?s.call(arguments):e,--n||o.resolveWith(r,i)}};if(n<=1&&(I(e,o.done(a(t)).resolve,o.reject,!n),"pending"===o.state()||m(i[t]&&i[t].then)))return o.then();while(t--)I(i[t],a(t),o.reject);return o.promise()}});var W=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;S.Deferred.exceptionHook=function(e,t){C.console&&C.console.warn&&e&&W.test(e.name)&&C.console.warn("jQuery.Deferred exception: "+e.message,e.stack,t)},S.readyException=function(e){C.setTimeout(function(){throw e})};var F=S.Deferred();function B(){E.removeEventListener("DOMContentLoaded",B),C.removeEventListener("load",B),S.ready()}S.fn.ready=function(e){return F.then(e)["catch"](function(e){S.readyException(e)}),this},S.extend({isReady:!1,readyWait:1,ready:function(e){(!0===e?--S.readyWait:S.isReady)||(S.isReady=!0)!==e&&0<--S.readyWait||F.resolveWith(E,[S])}}),S.ready.then=F.then,"complete"===E.readyState||"loading"!==E.readyState&&!E.documentElement.doScroll?C.setTimeout(S.ready):(E.addEventListener("DOMContentLoaded",B),C.addEventListener("load",B));var $=function(e,t,n,r,i,o,a){var s=0,u=e.length,l=null==n;if("object"===w(n))for(s in i=!0,n)$(e,t,s,n[s],!0,o,a);else if(void 0!==r&&(i=!0,m(r)||(a=!0),l&&(a?(t.call(e,r),t=null):(l=t,t=function(e,t,n){return l.call(S(e),n)})),t))for(;s<u;s++)t(e[s],n,a?r:r.call(e[s],s,t(e[s],n)));return i?e:l?t.call(e):u?t(e[0],n):o},_=/^-ms-/,z=/-([a-z])/g;function U(e,t){return t.toUpperCase()}function X(e){return e.replace(_,"ms-").replace(z,U)}var V=function(e){return 1===e.nodeType||9===e.nodeType||!+e.nodeType};function G(){this.expando=S.expando+G.uid++}G.uid=1,G.prototype={cache:function(e){var t=e[this.expando];return t||(t={},V(e)&&(e.nodeType?e[this.expando]=t:Object.defineProperty(e,this.expando,{value:t,configurable:!0}))),t},set:function(e,t,n){var r,i=this.cache(e);if("string"==typeof t)i[X(t)]=n;else for(r in t)i[X(r)]=t[r];return i},get:function(e,t){return void 0===t?this.cache(e):e[this.expando]&&e[this.expando][X(t)]},access:function(e,t,n){return void 0===t||t&&"string"==typeof t&&void 0===n?this.get(e,t):(this.set(e,t,n),void 0!==n?n:t)},remove:function(e,t){var n,r=e[this.expando];if(void 0!==r){if(void 0!==t){n=(t=Array.isArray(t)?t.map(X):(t=X(t))in r?[t]:t.match(P)||[]).length;while(n--)delete r[t[n]]}(void 0===t||S.isEmptyObject(r))&&(e.nodeType?e[this.expando]=void 0:delete e[this.expando])}},hasData:function(e){var t=e[this.expando];return void 0!==t&&!S.isEmptyObject(t)}};var Y=new G,Q=new G,J=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,K=/[A-Z]/g;function Z(e,t,n){var r,i;if(void 0===n&&1===e.nodeType)if(r="data-"+t.replace(K,"-$&").toLowerCase(),"string"==typeof(n=e.getAttribute(r))){try{n="true"===(i=n)||"false"!==i&&("null"===i?null:i===+i+""?+i:J.test(i)?JSON.parse(i):i)}catch(e){}Q.set(e,t,n)}else n=void 0;return n}S.extend({hasData:function(e){return Q.hasData(e)||Y.hasData(e)},data:function(e,t,n){return Q.access(e,t,n)},removeData:function(e,t){Q.remove(e,t)},_data:function(e,t,n){return Y.access(e,t,n)},_removeData:function(e,t){Y.remove(e,t)}}),S.fn.extend({data:function(n,e){var t,r,i,o=this[0],a=o&&o.attributes;if(void 0===n){if(this.length&&(i=Q.get(o),1===o.nodeType&&!Y.get(o,"hasDataAttrs"))){t=a.length;while(t--)a[t]&&0===(r=a[t].name).indexOf("data-")&&(r=X(r.slice(5)),Z(o,r,i[r]));Y.set(o,"hasDataAttrs",!0)}return i}return"object"==typeof n?this.each(function(){Q.set(this,n)}):$(this,function(e){var t;if(o&&void 0===e)return void 0!==(t=Q.get(o,n))?t:void 0!==(t=Z(o,n))?t:void 0;this.each(function(){Q.set(this,n,e)})},null,e,1<arguments.length,null,!0)},removeData:function(e){return this.each(function(){Q.remove(this,e)})}}),S.extend({queue:function(e,t,n){var r;if(e)return t=(t||"fx")+"queue",r=Y.get(e,t),n&&(!r||Array.isArray(n)?r=Y.access(e,t,S.makeArray(n)):r.push(n)),r||[]},dequeue:function(e,t){t=t||"fx";var n=S.queue(e,t),r=n.length,i=n.shift(),o=S._queueHooks(e,t);"inprogress"===i&&(i=n.shift(),r--),i&&("fx"===t&&n.unshift("inprogress"),delete o.stop,i.call(e,function(){S.dequeue(e,t)},o)),!r&&o&&o.empty.fire()},_queueHooks:function(e,t){var n=t+"queueHooks";return Y.get(e,n)||Y.access(e,n,{empty:S.Callbacks("once memory").add(function(){Y.remove(e,[t+"queue",n])})})}}),S.fn.extend({queue:function(t,n){var e=2;return"string"!=typeof t&&(n=t,t="fx",e--),arguments.length<e?S.queue(this[0],t):void 0===n?this:this.each(function(){var e=S.queue(this,t,n);S._queueHooks(this,t),"fx"===t&&"inprogress"!==e[0]&&S.dequeue(this,t)})},dequeue:function(e){return this.each(function(){S.dequeue(this,e)})},clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,t){var n,r=1,i=S.Deferred(),o=this,a=this.length,s=function(){--r||i.resolveWith(o,[o])};"string"!=typeof e&&(t=e,e=void 0),e=e||"fx";while(a--)(n=Y.get(o[a],e+"queueHooks"))&&n.empty&&(r++,n.empty.add(s));return s(),i.promise(t)}});var ee=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,te=new RegExp("^(?:([+-])=|)("+ee+")([a-z%]*)$","i"),ne=["Top","Right","Bottom","Left"],re=E.documentElement,ie=function(e){return S.contains(e.ownerDocument,e)},oe={composed:!0};re.getRootNode&&(ie=function(e){return S.contains(e.ownerDocument,e)||e.getRootNode(oe)===e.ownerDocument});var ae=function(e,t){return"none"===(e=t||e).style.display||""===e.style.display&&ie(e)&&"none"===S.css(e,"display")};function se(e,t,n,r){var i,o,a=20,s=r?function(){return r.cur()}:function(){return S.css(e,t,"")},u=s(),l=n&&n[3]||(S.cssNumber[t]?"":"px"),c=e.nodeType&&(S.cssNumber[t]||"px"!==l&&+u)&&te.exec(S.css(e,t));if(c&&c[3]!==l){u/=2,l=l||c[3],c=+u||1;while(a--)S.style(e,t,c+l),(1-o)*(1-(o=s()/u||.5))<=0&&(a=0),c/=o;c*=2,S.style(e,t,c+l),n=n||[]}return n&&(c=+c||+u||0,i=n[1]?c+(n[1]+1)*n[2]:+n[2],r&&(r.unit=l,r.start=c,r.end=i)),i}var ue={};function le(e,t){for(var n,r,i,o,a,s,u,l=[],c=0,f=e.length;c<f;c++)(r=e[c]).style&&(n=r.style.display,t?("none"===n&&(l[c]=Y.get(r,"display")||null,l[c]||(r.style.display="")),""===r.style.display&&ae(r)&&(l[c]=(u=a=o=void 0,a=(i=r).ownerDocument,s=i.nodeName,(u=ue[s])||(o=a.body.appendChild(a.createElement(s)),u=S.css(o,"display"),o.parentNode.removeChild(o),"none"===u&&(u="block"),ue[s]=u)))):"none"!==n&&(l[c]="none",Y.set(r,"display",n)));for(c=0;c<f;c++)null!=l[c]&&(e[c].style.display=l[c]);return e}S.fn.extend({show:function(){return le(this,!0)},hide:function(){return le(this)},toggle:function(e){return"boolean"==typeof e?e?this.show():this.hide():this.each(function(){ae(this)?S(this).show():S(this).hide()})}});var ce,fe,pe=/^(?:checkbox|radio)$/i,de=/<([a-z][^\/\0>\x20\t\r\n\f]*)/i,he=/^$|^module$|\/(?:java|ecma)script/i;ce=E.createDocumentFragment().appendChild(E.createElement("div")),(fe=E.createElement("input")).setAttribute("type","radio"),fe.setAttribute("checked","checked"),fe.setAttribute("name","t"),ce.appendChild(fe),y.checkClone=ce.cloneNode(!0).cloneNode(!0).lastChild.checked,ce.innerHTML="<textarea>x</textarea>",y.noCloneChecked=!!ce.cloneNode(!0).lastChild.defaultValue,ce.innerHTML="<option></option>",y.option=!!ce.lastChild;var ge={thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};function ve(e,t){var n;return n="undefined"!=typeof e.getElementsByTagName?e.getElementsByTagName(t||"*"):"undefined"!=typeof e.querySelectorAll?e.querySelectorAll(t||"*"):[],void 0===t||t&&A(e,t)?S.merge([e],n):n}function ye(e,t){for(var n=0,r=e.length;n<r;n++)Y.set(e[n],"globalEval",!t||Y.get(t[n],"globalEval"))}ge.tbody=ge.tfoot=ge.colgroup=ge.caption=ge.thead,ge.th=ge.td,y.option||(ge.optgroup=ge.option=[1,"<select multiple='multiple'>","</select>"]);var me=/<|&#?\w+;/;function xe(e,t,n,r,i){for(var o,a,s,u,l,c,f=t.createDocumentFragment(),p=[],d=0,h=e.length;d<h;d++)if((o=e[d])||0===o)if("object"===w(o))S.merge(p,o.nodeType?[o]:o);else if(me.test(o)){a=a||f.appendChild(t.createElement("div")),s=(de.exec(o)||["",""])[1].toLowerCase(),u=ge[s]||ge._default,a.innerHTML=u[1]+S.htmlPrefilter(o)+u[2],c=u[0];while(c--)a=a.lastChild;S.merge(p,a.childNodes),(a=f.firstChild).textContent=""}else p.push(t.createTextNode(o));f.textContent="",d=0;while(o=p[d++])if(r&&-1<S.inArray(o,r))i&&i.push(o);else if(l=ie(o),a=ve(f.appendChild(o),"script"),l&&ye(a),n){c=0;while(o=a[c++])he.test(o.type||"")&&n.push(o)}return f}var be=/^([^.]*)(?:\.(.+)|)/;function we(){return!0}function Te(){return!1}function Ce(e,t){return e===function(){try{return E.activeElement}catch(e){}}()==("focus"===t)}function Ee(e,t,n,r,i,o){var a,s;if("object"==typeof t){for(s in"string"!=typeof n&&(r=r||n,n=void 0),t)Ee(e,s,n,r,t[s],o);return e}if(null==r&&null==i?(i=n,r=n=void 0):null==i&&("string"==typeof n?(i=r,r=void 0):(i=r,r=n,n=void 0)),!1===i)i=Te;else if(!i)return e;return 1===o&&(a=i,(i=function(e){return S().off(e),a.apply(this,arguments)}).guid=a.guid||(a.guid=S.guid++)),e.each(function(){S.event.add(this,t,i,r,n)})}function Se(e,i,o){o?(Y.set(e,i,!1),S.event.add(e,i,{namespace:!1,handler:function(e){var t,n,r=Y.get(this,i);if(1&e.isTrigger&&this[i]){if(r.length)(S.event.special[i]||{}).delegateType&&e.stopPropagation();else if(r=s.call(arguments),Y.set(this,i,r),t=o(this,i),this[i](),r!==(n=Y.get(this,i))||t?Y.set(this,i,!1):n={},r!==n)return e.stopImmediatePropagation(),e.preventDefault(),n&&n.value}else r.length&&(Y.set(this,i,{value:S.event.trigger(S.extend(r[0],S.Event.prototype),r.slice(1),this)}),e.stopImmediatePropagation())}})):void 0===Y.get(e,i)&&S.event.add(e,i,we)}S.event={global:{},add:function(t,e,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=Y.get(t);if(V(t)){n.handler&&(n=(o=n).handler,i=o.selector),i&&S.find.matchesSelector(re,i),n.guid||(n.guid=S.guid++),(u=v.events)||(u=v.events=Object.create(null)),(a=v.handle)||(a=v.handle=function(e){return"undefined"!=typeof S&&S.event.triggered!==e.type?S.event.dispatch.apply(t,arguments):void 0}),l=(e=(e||"").match(P)||[""]).length;while(l--)d=g=(s=be.exec(e[l])||[])[1],h=(s[2]||"").split(".").sort(),d&&(f=S.event.special[d]||{},d=(i?f.delegateType:f.bindType)||d,f=S.event.special[d]||{},c=S.extend({type:d,origType:g,data:r,handler:n,guid:n.guid,selector:i,needsContext:i&&S.expr.match.needsContext.test(i),namespace:h.join(".")},o),(p=u[d])||((p=u[d]=[]).delegateCount=0,f.setup&&!1!==f.setup.call(t,r,h,a)||t.addEventListener&&t.addEventListener(d,a)),f.add&&(f.add.call(t,c),c.handler.guid||(c.handler.guid=n.guid)),i?p.splice(p.delegateCount++,0,c):p.push(c),S.event.global[d]=!0)}},remove:function(e,t,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=Y.hasData(e)&&Y.get(e);if(v&&(u=v.events)){l=(t=(t||"").match(P)||[""]).length;while(l--)if(d=g=(s=be.exec(t[l])||[])[1],h=(s[2]||"").split(".").sort(),d){f=S.event.special[d]||{},p=u[d=(r?f.delegateType:f.bindType)||d]||[],s=s[2]&&new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"),a=o=p.length;while(o--)c=p[o],!i&&g!==c.origType||n&&n.guid!==c.guid||s&&!s.test(c.namespace)||r&&r!==c.selector&&("**"!==r||!c.selector)||(p.splice(o,1),c.selector&&p.delegateCount--,f.remove&&f.remove.call(e,c));a&&!p.length&&(f.teardown&&!1!==f.teardown.call(e,h,v.handle)||S.removeEvent(e,d,v.handle),delete u[d])}else for(d in u)S.event.remove(e,d+t[l],n,r,!0);S.isEmptyObject(u)&&Y.remove(e,"handle events")}},dispatch:function(e){var t,n,r,i,o,a,s=new Array(arguments.length),u=S.event.fix(e),l=(Y.get(this,"events")||Object.create(null))[u.type]||[],c=S.event.special[u.type]||{};for(s[0]=u,t=1;t<arguments.length;t++)s[t]=arguments[t];if(u.delegateTarget=this,!c.preDispatch||!1!==c.preDispatch.call(this,u)){a=S.event.handlers.call(this,u,l),t=0;while((i=a[t++])&&!u.isPropagationStopped()){u.currentTarget=i.elem,n=0;while((o=i.handlers[n++])&&!u.isImmediatePropagationStopped())u.rnamespace&&!1!==o.namespace&&!u.rnamespace.test(o.namespace)||(u.handleObj=o,u.data=o.data,void 0!==(r=((S.event.special[o.origType]||{}).handle||o.handler).apply(i.elem,s))&&!1===(u.result=r)&&(u.preventDefault(),u.stopPropagation()))}return c.postDispatch&&c.postDispatch.call(this,u),u.result}},handlers:function(e,t){var n,r,i,o,a,s=[],u=t.delegateCount,l=e.target;if(u&&l.nodeType&&!("click"===e.type&&1<=e.button))for(;l!==this;l=l.parentNode||this)if(1===l.nodeType&&("click"!==e.type||!0!==l.disabled)){for(o=[],a={},n=0;n<u;n++)void 0===a[i=(r=t[n]).selector+" "]&&(a[i]=r.needsContext?-1<S(i,this).index(l):S.find(i,this,null,[l]).length),a[i]&&o.push(r);o.length&&s.push({elem:l,handlers:o})}return l=this,u<t.length&&s.push({elem:l,handlers:t.slice(u)}),s},addProp:function(t,e){Object.defineProperty(S.Event.prototype,t,{enumerable:!0,configurable:!0,get:m(e)?function(){if(this.originalEvent)return e(this.originalEvent)}:function(){if(this.originalEvent)return this.originalEvent[t]},set:function(e){Object.defineProperty(this,t,{enumerable:!0,configurable:!0,writable:!0,value:e})}})},fix:function(e){return e[S.expando]?e:new S.Event(e)},special:{load:{noBubble:!0},click:{setup:function(e){var t=this||e;return pe.test(t.type)&&t.click&&A(t,"input")&&Se(t,"click",we),!1},trigger:function(e){var t=this||e;return pe.test(t.type)&&t.click&&A(t,"input")&&Se(t,"click"),!0},_default:function(e){var t=e.target;return pe.test(t.type)&&t.click&&A(t,"input")&&Y.get(t,"click")||A(t,"a")}},beforeunload:{postDispatch:function(e){void 0!==e.result&&e.originalEvent&&(e.originalEvent.returnValue=e.result)}}}},S.removeEvent=function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n)},S.Event=function(e,t){if(!(this instanceof S.Event))return new S.Event(e,t);e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||void 0===e.defaultPrevented&&!1===e.returnValue?we:Te,this.target=e.target&&3===e.target.nodeType?e.target.parentNode:e.target,this.currentTarget=e.currentTarget,this.relatedTarget=e.relatedTarget):this.type=e,t&&S.extend(this,t),this.timeStamp=e&&e.timeStamp||Date.now(),this[S.expando]=!0},S.Event.prototype={constructor:S.Event,isDefaultPrevented:Te,isPropagationStopped:Te,isImmediatePropagationStopped:Te,isSimulated:!1,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=we,e&&!this.isSimulated&&e.preventDefault()},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=we,e&&!this.isSimulated&&e.stopPropagation()},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=we,e&&!this.isSimulated&&e.stopImmediatePropagation(),this.stopPropagation()}},S.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,"char":!0,code:!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:!0},S.event.addProp),S.each({focus:"focusin",blur:"focusout"},function(e,t){S.event.special[e]={setup:function(){return Se(this,e,Ce),!1},trigger:function(){return Se(this,e),!0},_default:function(){return!0},delegateType:t}}),S.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(e,i){S.event.special[e]={delegateType:i,bindType:i,handle:function(e){var t,n=e.relatedTarget,r=e.handleObj;return n&&(n===this||S.contains(this,n))||(e.type=r.origType,t=r.handler.apply(this,arguments),e.type=i),t}}}),S.fn.extend({on:function(e,t,n,r){return Ee(this,e,t,n,r)},one:function(e,t,n,r){return Ee(this,e,t,n,r,1)},off:function(e,t,n){var r,i;if(e&&e.preventDefault&&e.handleObj)return r=e.handleObj,S(e.delegateTarget).off(r.namespace?r.origType+"."+r.namespace:r.origType,r.selector,r.handler),this;if("object"==typeof e){for(i in e)this.off(i,t,e[i]);return this}return!1!==t&&"function"!=typeof t||(n=t,t=void 0),!1===n&&(n=Te),this.each(function(){S.event.remove(this,e,n,t)})}});var ke=/<script|<style|<link/i,Ae=/checked\s*(?:[^=]|=\s*.checked.)/i,Ne=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;function je(e,t){return A(e,"table")&&A(11!==t.nodeType?t:t.firstChild,"tr")&&S(e).children("tbody")[0]||e}function De(e){return e.type=(null!==e.getAttribute("type"))+"/"+e.type,e}function qe(e){return"true/"===(e.type||"").slice(0,5)?e.type=e.type.slice(5):e.removeAttribute("type"),e}function Le(e,t){var n,r,i,o,a,s;if(1===t.nodeType){if(Y.hasData(e)&&(s=Y.get(e).events))for(i in Y.remove(t,"handle events"),s)for(n=0,r=s[i].length;n<r;n++)S.event.add(t,i,s[i][n]);Q.hasData(e)&&(o=Q.access(e),a=S.extend({},o),Q.set(t,a))}}function He(n,r,i,o){r=g(r);var e,t,a,s,u,l,c=0,f=n.length,p=f-1,d=r[0],h=m(d);if(h||1<f&&"string"==typeof d&&!y.checkClone&&Ae.test(d))return n.each(function(e){var t=n.eq(e);h&&(r[0]=d.call(this,e,t.html())),He(t,r,i,o)});if(f&&(t=(e=xe(r,n[0].ownerDocument,!1,n,o)).firstChild,1===e.childNodes.length&&(e=t),t||o)){for(s=(a=S.map(ve(e,"script"),De)).length;c<f;c++)u=e,c!==p&&(u=S.clone(u,!0,!0),s&&S.merge(a,ve(u,"script"))),i.call(n[c],u,c);if(s)for(l=a[a.length-1].ownerDocument,S.map(a,qe),c=0;c<s;c++)u=a[c],he.test(u.type||"")&&!Y.access(u,"globalEval")&&S.contains(l,u)&&(u.src&&"module"!==(u.type||"").toLowerCase()?S._evalUrl&&!u.noModule&&S._evalUrl(u.src,{nonce:u.nonce||u.getAttribute("nonce")},l):b(u.textContent.replace(Ne,""),u,l))}return n}function Oe(e,t,n){for(var r,i=t?S.filter(t,e):e,o=0;null!=(r=i[o]);o++)n||1!==r.nodeType||S.cleanData(ve(r)),r.parentNode&&(n&&ie(r)&&ye(ve(r,"script")),r.parentNode.removeChild(r));return e}S.extend({htmlPrefilter:function(e){return e},clone:function(e,t,n){var r,i,o,a,s,u,l,c=e.cloneNode(!0),f=ie(e);if(!(y.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||S.isXMLDoc(e)))for(a=ve(c),r=0,i=(o=ve(e)).length;r<i;r++)s=o[r],u=a[r],void 0,"input"===(l=u.nodeName.toLowerCase())&&pe.test(s.type)?u.checked=s.checked:"input"!==l&&"textarea"!==l||(u.defaultValue=s.defaultValue);if(t)if(n)for(o=o||ve(e),a=a||ve(c),r=0,i=o.length;r<i;r++)Le(o[r],a[r]);else Le(e,c);return 0<(a=ve(c,"script")).length&&ye(a,!f&&ve(e,"script")),c},cleanData:function(e){for(var t,n,r,i=S.event.special,o=0;void 0!==(n=e[o]);o++)if(V(n)){if(t=n[Y.expando]){if(t.events)for(r in t.events)i[r]?S.event.remove(n,r):S.removeEvent(n,r,t.handle);n[Y.expando]=void 0}n[Q.expando]&&(n[Q.expando]=void 0)}}}),S.fn.extend({detach:function(e){return Oe(this,e,!0)},remove:function(e){return Oe(this,e)},text:function(e){return $(this,function(e){return void 0===e?S.text(this):this.empty().each(function(){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(this.textContent=e)})},null,e,arguments.length)},append:function(){return He(this,arguments,function(e){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||je(this,e).appendChild(e)})},prepend:function(){return He(this,arguments,function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=je(this,e);t.insertBefore(e,t.firstChild)}})},before:function(){return He(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return He(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},empty:function(){for(var e,t=0;null!=(e=this[t]);t++)1===e.nodeType&&(S.cleanData(ve(e,!1)),e.textContent="");return this},clone:function(e,t){return e=null!=e&&e,t=null==t?e:t,this.map(function(){return S.clone(this,e,t)})},html:function(e){return $(this,function(e){var t=this[0]||{},n=0,r=this.length;if(void 0===e&&1===t.nodeType)return t.innerHTML;if("string"==typeof e&&!ke.test(e)&&!ge[(de.exec(e)||["",""])[1].toLowerCase()]){e=S.htmlPrefilter(e);try{for(;n<r;n++)1===(t=this[n]||{}).nodeType&&(S.cleanData(ve(t,!1)),t.innerHTML=e);t=0}catch(e){}}t&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(){var n=[];return He(this,arguments,function(e){var t=this.parentNode;S.inArray(this,n)<0&&(S.cleanData(ve(this)),t&&t.replaceChild(e,this))},n)}}),S.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(e,a){S.fn[e]=function(e){for(var t,n=[],r=S(e),i=r.length-1,o=0;o<=i;o++)t=o===i?this:this.clone(!0),S(r[o])[a](t),u.apply(n,t.get());return this.pushStack(n)}});var Pe=new RegExp("^("+ee+")(?!px)[a-z%]+$","i"),Re=function(e){var t=e.ownerDocument.defaultView;return t&&t.opener||(t=C),t.getComputedStyle(e)},Me=function(e,t,n){var r,i,o={};for(i in t)o[i]=e.style[i],e.style[i]=t[i];for(i in r=n.call(e),t)e.style[i]=o[i];return r},Ie=new RegExp(ne.join("|"),"i");function We(e,t,n){var r,i,o,a,s=e.style;return(n=n||Re(e))&&(""!==(a=n.getPropertyValue(t)||n[t])||ie(e)||(a=S.style(e,t)),!y.pixelBoxStyles()&&Pe.test(a)&&Ie.test(t)&&(r=s.width,i=s.minWidth,o=s.maxWidth,s.minWidth=s.maxWidth=s.width=a,a=n.width,s.width=r,s.minWidth=i,s.maxWidth=o)),void 0!==a?a+"":a}function Fe(e,t){return{get:function(){if(!e())return(this.get=t).apply(this,arguments);delete this.get}}}!function(){function e(){if(l){u.style.cssText="position:absolute;left:-11111px;width:60px;margin-top:1px;padding:0;border:0",l.style.cssText="position:relative;display:block;box-sizing:border-box;overflow:scroll;margin:auto;border:1px;padding:1px;width:60%;top:1%",re.appendChild(u).appendChild(l);var e=C.getComputedStyle(l);n="1%"!==e.top,s=12===t(e.marginLeft),l.style.right="60%",o=36===t(e.right),r=36===t(e.width),l.style.position="absolute",i=12===t(l.offsetWidth/3),re.removeChild(u),l=null}}function t(e){return Math.round(parseFloat(e))}var n,r,i,o,a,s,u=E.createElement("div"),l=E.createElement("div");l.style&&(l.style.backgroundClip="content-box",l.cloneNode(!0).style.backgroundClip="",y.clearCloneStyle="content-box"===l.style.backgroundClip,S.extend(y,{boxSizingReliable:function(){return e(),r},pixelBoxStyles:function(){return e(),o},pixelPosition:function(){return e(),n},reliableMarginLeft:function(){return e(),s},scrollboxSize:function(){return e(),i},reliableTrDimensions:function(){var e,t,n,r;return null==a&&(e=E.createElement("table"),t=E.createElement("tr"),n=E.createElement("div"),e.style.cssText="position:absolute;left:-11111px;border-collapse:separate",t.style.cssText="border:1px solid",t.style.height="1px",n.style.height="9px",n.style.display="block",re.appendChild(e).appendChild(t).appendChild(n),r=C.getComputedStyle(t),a=parseInt(r.height,10)+parseInt(r.borderTopWidth,10)+parseInt(r.borderBottomWidth,10)===t.offsetHeight,re.removeChild(e)),a}}))}();var Be=["Webkit","Moz","ms"],$e=E.createElement("div").style,_e={};function ze(e){var t=S.cssProps[e]||_e[e];return t||(e in $e?e:_e[e]=function(e){var t=e[0].toUpperCase()+e.slice(1),n=Be.length;while(n--)if((e=Be[n]+t)in $e)return e}(e)||e)}var Ue=/^(none|table(?!-c[ea]).+)/,Xe=/^--/,Ve={position:"absolute",visibility:"hidden",display:"block"},Ge={letterSpacing:"0",fontWeight:"400"};function Ye(e,t,n){var r=te.exec(t);return r?Math.max(0,r[2]-(n||0))+(r[3]||"px"):t}function Qe(e,t,n,r,i,o){var a="width"===t?1:0,s=0,u=0;if(n===(r?"border":"content"))return 0;for(;a<4;a+=2)"margin"===n&&(u+=S.css(e,n+ne[a],!0,i)),r?("content"===n&&(u-=S.css(e,"padding"+ne[a],!0,i)),"margin"!==n&&(u-=S.css(e,"border"+ne[a]+"Width",!0,i))):(u+=S.css(e,"padding"+ne[a],!0,i),"padding"!==n?u+=S.css(e,"border"+ne[a]+"Width",!0,i):s+=S.css(e,"border"+ne[a]+"Width",!0,i));return!r&&0<=o&&(u+=Math.max(0,Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-o-u-s-.5))||0),u}function Je(e,t,n){var r=Re(e),i=(!y.boxSizingReliable()||n)&&"border-box"===S.css(e,"boxSizing",!1,r),o=i,a=We(e,t,r),s="offset"+t[0].toUpperCase()+t.slice(1);if(Pe.test(a)){if(!n)return a;a="auto"}return(!y.boxSizingReliable()&&i||!y.reliableTrDimensions()&&A(e,"tr")||"auto"===a||!parseFloat(a)&&"inline"===S.css(e,"display",!1,r))&&e.getClientRects().length&&(i="border-box"===S.css(e,"boxSizing",!1,r),(o=s in e)&&(a=e[s])),(a=parseFloat(a)||0)+Qe(e,t,n||(i?"border":"content"),o,r,a)+"px"}function Ke(e,t,n,r,i){return new Ke.prototype.init(e,t,n,r,i)}S.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=We(e,"opacity");return""===n?"1":n}}}},cssNumber:{animationIterationCount:!0,columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,gridArea:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnStart:!0,gridRow:!0,gridRowEnd:!0,gridRowStart:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{},style:function(e,t,n,r){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var i,o,a,s=X(t),u=Xe.test(t),l=e.style;if(u||(t=ze(s)),a=S.cssHooks[t]||S.cssHooks[s],void 0===n)return a&&"get"in a&&void 0!==(i=a.get(e,!1,r))?i:l[t];"string"===(o=typeof n)&&(i=te.exec(n))&&i[1]&&(n=se(e,t,i),o="number"),null!=n&&n==n&&("number"!==o||u||(n+=i&&i[3]||(S.cssNumber[s]?"":"px")),y.clearCloneStyle||""!==n||0!==t.indexOf("background")||(l[t]="inherit"),a&&"set"in a&&void 0===(n=a.set(e,n,r))||(u?l.setProperty(t,n):l[t]=n))}},css:function(e,t,n,r){var i,o,a,s=X(t);return Xe.test(t)||(t=ze(s)),(a=S.cssHooks[t]||S.cssHooks[s])&&"get"in a&&(i=a.get(e,!0,n)),void 0===i&&(i=We(e,t,r)),"normal"===i&&t in Ge&&(i=Ge[t]),""===n||n?(o=parseFloat(i),!0===n||isFinite(o)?o||0:i):i}}),S.each(["height","width"],function(e,u){S.cssHooks[u]={get:function(e,t,n){if(t)return!Ue.test(S.css(e,"display"))||e.getClientRects().length&&e.getBoundingClientRect().width?Je(e,u,n):Me(e,Ve,function(){return Je(e,u,n)})},set:function(e,t,n){var r,i=Re(e),o=!y.scrollboxSize()&&"absolute"===i.position,a=(o||n)&&"border-box"===S.css(e,"boxSizing",!1,i),s=n?Qe(e,u,n,a,i):0;return a&&o&&(s-=Math.ceil(e["offset"+u[0].toUpperCase()+u.slice(1)]-parseFloat(i[u])-Qe(e,u,"border",!1,i)-.5)),s&&(r=te.exec(t))&&"px"!==(r[3]||"px")&&(e.style[u]=t,t=S.css(e,u)),Ye(0,t,s)}}}),S.cssHooks.marginLeft=Fe(y.reliableMarginLeft,function(e,t){if(t)return(parseFloat(We(e,"marginLeft"))||e.getBoundingClientRect().left-Me(e,{marginLeft:0},function(){return e.getBoundingClientRect().left}))+"px"}),S.each({margin:"",padding:"",border:"Width"},function(i,o){S.cssHooks[i+o]={expand:function(e){for(var t=0,n={},r="string"==typeof e?e.split(" "):[e];t<4;t++)n[i+ne[t]+o]=r[t]||r[t-2]||r[0];return n}},"margin"!==i&&(S.cssHooks[i+o].set=Ye)}),S.fn.extend({css:function(e,t){return $(this,function(e,t,n){var r,i,o={},a=0;if(Array.isArray(t)){for(r=Re(e),i=t.length;a<i;a++)o[t[a]]=S.css(e,t[a],!1,r);return o}return void 0!==n?S.style(e,t,n):S.css(e,t)},e,t,1<arguments.length)}}),((S.Tween=Ke).prototype={constructor:Ke,init:function(e,t,n,r,i,o){this.elem=e,this.prop=n,this.easing=i||S.easing._default,this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=o||(S.cssNumber[n]?"":"px")},cur:function(){var e=Ke.propHooks[this.prop];return e&&e.get?e.get(this):Ke.propHooks._default.get(this)},run:function(e){var t,n=Ke.propHooks[this.prop];return this.options.duration?this.pos=t=S.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):this.pos=t=e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):Ke.propHooks._default.set(this),this}}).init.prototype=Ke.prototype,(Ke.propHooks={_default:{get:function(e){var t;return 1!==e.elem.nodeType||null!=e.elem[e.prop]&&null==e.elem.style[e.prop]?e.elem[e.prop]:(t=S.css(e.elem,e.prop,""))&&"auto"!==t?t:0},set:function(e){S.fx.step[e.prop]?S.fx.step[e.prop](e):1!==e.elem.nodeType||!S.cssHooks[e.prop]&&null==e.elem.style[ze(e.prop)]?e.elem[e.prop]=e.now:S.style(e.elem,e.prop,e.now+e.unit)}}}).scrollTop=Ke.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},S.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2},_default:"swing"},S.fx=Ke.prototype.init,S.fx.step={};var Ze,et,tt,nt,rt=/^(?:toggle|show|hide)$/,it=/queueHooks$/;function ot(){et&&(!1===E.hidden&&C.requestAnimationFrame?C.requestAnimationFrame(ot):C.setTimeout(ot,S.fx.interval),S.fx.tick())}function at(){return C.setTimeout(function(){Ze=void 0}),Ze=Date.now()}function st(e,t){var n,r=0,i={height:e};for(t=t?1:0;r<4;r+=2-t)i["margin"+(n=ne[r])]=i["padding"+n]=e;return t&&(i.opacity=i.width=e),i}function ut(e,t,n){for(var r,i=(lt.tweeners[t]||[]).concat(lt.tweeners["*"]),o=0,a=i.length;o<a;o++)if(r=i[o].call(n,t,e))return r}function lt(o,e,t){var n,a,r=0,i=lt.prefilters.length,s=S.Deferred().always(function(){delete u.elem}),u=function(){if(a)return!1;for(var e=Ze||at(),t=Math.max(0,l.startTime+l.duration-e),n=1-(t/l.duration||0),r=0,i=l.tweens.length;r<i;r++)l.tweens[r].run(n);return s.notifyWith(o,[l,n,t]),n<1&&i?t:(i||s.notifyWith(o,[l,1,0]),s.resolveWith(o,[l]),!1)},l=s.promise({elem:o,props:S.extend({},e),opts:S.extend(!0,{specialEasing:{},easing:S.easing._default},t),originalProperties:e,originalOptions:t,startTime:Ze||at(),duration:t.duration,tweens:[],createTween:function(e,t){var n=S.Tween(o,l.opts,e,t,l.opts.specialEasing[e]||l.opts.easing);return l.tweens.push(n),n},stop:function(e){var t=0,n=e?l.tweens.length:0;if(a)return this;for(a=!0;t<n;t++)l.tweens[t].run(1);return e?(s.notifyWith(o,[l,1,0]),s.resolveWith(o,[l,e])):s.rejectWith(o,[l,e]),this}}),c=l.props;for(!function(e,t){var n,r,i,o,a;for(n in e)if(i=t[r=X(n)],o=e[n],Array.isArray(o)&&(i=o[1],o=e[n]=o[0]),n!==r&&(e[r]=o,delete e[n]),(a=S.cssHooks[r])&&"expand"in a)for(n in o=a.expand(o),delete e[r],o)n in e||(e[n]=o[n],t[n]=i);else t[r]=i}(c,l.opts.specialEasing);r<i;r++)if(n=lt.prefilters[r].call(l,o,c,l.opts))return m(n.stop)&&(S._queueHooks(l.elem,l.opts.queue).stop=n.stop.bind(n)),n;return S.map(c,ut,l),m(l.opts.start)&&l.opts.start.call(o,l),l.progress(l.opts.progress).done(l.opts.done,l.opts.complete).fail(l.opts.fail).always(l.opts.always),S.fx.timer(S.extend(u,{elem:o,anim:l,queue:l.opts.queue})),l}S.Animation=S.extend(lt,{tweeners:{"*":[function(e,t){var n=this.createTween(e,t);return se(n.elem,e,te.exec(t),n),n}]},tweener:function(e,t){m(e)?(t=e,e=["*"]):e=e.match(P);for(var n,r=0,i=e.length;r<i;r++)n=e[r],lt.tweeners[n]=lt.tweeners[n]||[],lt.tweeners[n].unshift(t)},prefilters:[function(e,t,n){var r,i,o,a,s,u,l,c,f="width"in t||"height"in t,p=this,d={},h=e.style,g=e.nodeType&&ae(e),v=Y.get(e,"fxshow");for(r in n.queue||(null==(a=S._queueHooks(e,"fx")).unqueued&&(a.unqueued=0,s=a.empty.fire,a.empty.fire=function(){a.unqueued||s()}),a.unqueued++,p.always(function(){p.always(function(){a.unqueued--,S.queue(e,"fx").length||a.empty.fire()})})),t)if(i=t[r],rt.test(i)){if(delete t[r],o=o||"toggle"===i,i===(g?"hide":"show")){if("show"!==i||!v||void 0===v[r])continue;g=!0}d[r]=v&&v[r]||S.style(e,r)}if((u=!S.isEmptyObject(t))||!S.isEmptyObject(d))for(r in f&&1===e.nodeType&&(n.overflow=[h.overflow,h.overflowX,h.overflowY],null==(l=v&&v.display)&&(l=Y.get(e,"display")),"none"===(c=S.css(e,"display"))&&(l?c=l:(le([e],!0),l=e.style.display||l,c=S.css(e,"display"),le([e]))),("inline"===c||"inline-block"===c&&null!=l)&&"none"===S.css(e,"float")&&(u||(p.done(function(){h.display=l}),null==l&&(c=h.display,l="none"===c?"":c)),h.display="inline-block")),n.overflow&&(h.overflow="hidden",p.always(function(){h.overflow=n.overflow[0],h.overflowX=n.overflow[1],h.overflowY=n.overflow[2]})),u=!1,d)u||(v?"hidden"in v&&(g=v.hidden):v=Y.access(e,"fxshow",{display:l}),o&&(v.hidden=!g),g&&le([e],!0),p.done(function(){for(r in g||le([e]),Y.remove(e,"fxshow"),d)S.style(e,r,d[r])})),u=ut(g?v[r]:0,r,p),r in v||(v[r]=u.start,g&&(u.end=u.start,u.start=0))}],prefilter:function(e,t){t?lt.prefilters.unshift(e):lt.prefilters.push(e)}}),S.speed=function(e,t,n){var r=e&&"object"==typeof e?S.extend({},e):{complete:n||!n&&t||m(e)&&e,duration:e,easing:n&&t||t&&!m(t)&&t};return S.fx.off?r.duration=0:"number"!=typeof r.duration&&(r.duration in S.fx.speeds?r.duration=S.fx.speeds[r.duration]:r.duration=S.fx.speeds._default),null!=r.queue&&!0!==r.queue||(r.queue="fx"),r.old=r.complete,r.complete=function(){m(r.old)&&r.old.call(this),r.queue&&S.dequeue(this,r.queue)},r},S.fn.extend({fadeTo:function(e,t,n,r){return this.filter(ae).css("opacity",0).show().end().animate({opacity:t},e,n,r)},animate:function(t,e,n,r){var i=S.isEmptyObject(t),o=S.speed(e,n,r),a=function(){var e=lt(this,S.extend({},t),o);(i||Y.get(this,"finish"))&&e.stop(!0)};return a.finish=a,i||!1===o.queue?this.each(a):this.queue(o.queue,a)},stop:function(i,e,o){var a=function(e){var t=e.stop;delete e.stop,t(o)};return"string"!=typeof i&&(o=e,e=i,i=void 0),e&&this.queue(i||"fx",[]),this.each(function(){var e=!0,t=null!=i&&i+"queueHooks",n=S.timers,r=Y.get(this);if(t)r[t]&&r[t].stop&&a(r[t]);else for(t in r)r[t]&&r[t].stop&&it.test(t)&&a(r[t]);for(t=n.length;t--;)n[t].elem!==this||null!=i&&n[t].queue!==i||(n[t].anim.stop(o),e=!1,n.splice(t,1));!e&&o||S.dequeue(this,i)})},finish:function(a){return!1!==a&&(a=a||"fx"),this.each(function(){var e,t=Y.get(this),n=t[a+"queue"],r=t[a+"queueHooks"],i=S.timers,o=n?n.length:0;for(t.finish=!0,S.queue(this,a,[]),r&&r.stop&&r.stop.call(this,!0),e=i.length;e--;)i[e].elem===this&&i[e].queue===a&&(i[e].anim.stop(!0),i.splice(e,1));for(e=0;e<o;e++)n[e]&&n[e].finish&&n[e].finish.call(this);delete t.finish})}}),S.each(["toggle","show","hide"],function(e,r){var i=S.fn[r];S.fn[r]=function(e,t,n){return null==e||"boolean"==typeof e?i.apply(this,arguments):this.animate(st(r,!0),e,t,n)}}),S.each({slideDown:st("show"),slideUp:st("hide"),slideToggle:st("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(e,r){S.fn[e]=function(e,t,n){return this.animate(r,e,t,n)}}),S.timers=[],S.fx.tick=function(){var e,t=0,n=S.timers;for(Ze=Date.now();t<n.length;t++)(e=n[t])()||n[t]!==e||n.splice(t--,1);n.length||S.fx.stop(),Ze=void 0},S.fx.timer=function(e){S.timers.push(e),S.fx.start()},S.fx.interval=13,S.fx.start=function(){et||(et=!0,ot())},S.fx.stop=function(){et=null},S.fx.speeds={slow:600,fast:200,_default:400},S.fn.delay=function(r,e){return r=S.fx&&S.fx.speeds[r]||r,e=e||"fx",this.queue(e,function(e,t){var n=C.setTimeout(e,r);t.stop=function(){C.clearTimeout(n)}})},tt=E.createElement("input"),nt=E.createElement("select").appendChild(E.createElement("option")),tt.type="checkbox",y.checkOn=""!==tt.value,y.optSelected=nt.selected,(tt=E.createElement("input")).value="t",tt.type="radio",y.radioValue="t"===tt.value;var ct,ft=S.expr.attrHandle;S.fn.extend({attr:function(e,t){return $(this,S.attr,e,t,1<arguments.length)},removeAttr:function(e){return this.each(function(){S.removeAttr(this,e)})}}),S.extend({attr:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return"undefined"==typeof e.getAttribute?S.prop(e,t,n):(1===o&&S.isXMLDoc(e)||(i=S.attrHooks[t.toLowerCase()]||(S.expr.match.bool.test(t)?ct:void 0)),void 0!==n?null===n?void S.removeAttr(e,t):i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:(e.setAttribute(t,n+""),n):i&&"get"in i&&null!==(r=i.get(e,t))?r:null==(r=S.find.attr(e,t))?void 0:r)},attrHooks:{type:{set:function(e,t){if(!y.radioValue&&"radio"===t&&A(e,"input")){var n=e.value;return e.setAttribute("type",t),n&&(e.value=n),t}}}},removeAttr:function(e,t){var n,r=0,i=t&&t.match(P);if(i&&1===e.nodeType)while(n=i[r++])e.removeAttribute(n)}}),ct={set:function(e,t,n){return!1===t?S.removeAttr(e,n):e.setAttribute(n,n),n}},S.each(S.expr.match.bool.source.match(/\w+/g),function(e,t){var a=ft[t]||S.find.attr;ft[t]=function(e,t,n){var r,i,o=t.toLowerCase();return n||(i=ft[o],ft[o]=r,r=null!=a(e,t,n)?o:null,ft[o]=i),r}});var pt=/^(?:input|select|textarea|button)$/i,dt=/^(?:a|area)$/i;function ht(e){return(e.match(P)||[]).join(" ")}function gt(e){return e.getAttribute&&e.getAttribute("class")||""}function vt(e){return Array.isArray(e)?e:"string"==typeof e&&e.match(P)||[]}S.fn.extend({prop:function(e,t){return $(this,S.prop,e,t,1<arguments.length)},removeProp:function(e){return this.each(function(){delete this[S.propFix[e]||e]})}}),S.extend({prop:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return 1===o&&S.isXMLDoc(e)||(t=S.propFix[t]||t,i=S.propHooks[t]),void 0!==n?i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:e[t]=n:i&&"get"in i&&null!==(r=i.get(e,t))?r:e[t]},propHooks:{tabIndex:{get:function(e){var t=S.find.attr(e,"tabindex");return t?parseInt(t,10):pt.test(e.nodeName)||dt.test(e.nodeName)&&e.href?0:-1}}},propFix:{"for":"htmlFor","class":"className"}}),y.optSelected||(S.propHooks.selected={get:function(e){var t=e.parentNode;return t&&t.parentNode&&t.parentNode.selectedIndex,null},set:function(e){var t=e.parentNode;t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex)}}),S.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){S.propFix[this.toLowerCase()]=this}),S.fn.extend({addClass:function(t){var e,n,r,i,o,a,s,u=0;if(m(t))return this.each(function(e){S(this).addClass(t.call(this,e,gt(this)))});if((e=vt(t)).length)while(n=this[u++])if(i=gt(n),r=1===n.nodeType&&" "+ht(i)+" "){a=0;while(o=e[a++])r.indexOf(" "+o+" ")<0&&(r+=o+" ");i!==(s=ht(r))&&n.setAttribute("class",s)}return this},removeClass:function(t){var e,n,r,i,o,a,s,u=0;if(m(t))return this.each(function(e){S(this).removeClass(t.call(this,e,gt(this)))});if(!arguments.length)return this.attr("class","");if((e=vt(t)).length)while(n=this[u++])if(i=gt(n),r=1===n.nodeType&&" "+ht(i)+" "){a=0;while(o=e[a++])while(-1<r.indexOf(" "+o+" "))r=r.replace(" "+o+" "," ");i!==(s=ht(r))&&n.setAttribute("class",s)}return this},toggleClass:function(i,t){var o=typeof i,a="string"===o||Array.isArray(i);return"boolean"==typeof t&&a?t?this.addClass(i):this.removeClass(i):m(i)?this.each(function(e){S(this).toggleClass(i.call(this,e,gt(this),t),t)}):this.each(function(){var e,t,n,r;if(a){t=0,n=S(this),r=vt(i);while(e=r[t++])n.hasClass(e)?n.removeClass(e):n.addClass(e)}else void 0!==i&&"boolean"!==o||((e=gt(this))&&Y.set(this,"__className__",e),this.setAttribute&&this.setAttribute("class",e||!1===i?"":Y.get(this,"__className__")||""))})},hasClass:function(e){var t,n,r=0;t=" "+e+" ";while(n=this[r++])if(1===n.nodeType&&-1<(" "+ht(gt(n))+" ").indexOf(t))return!0;return!1}});var yt=/\r/g;S.fn.extend({val:function(n){var r,e,i,t=this[0];return arguments.length?(i=m(n),this.each(function(e){var t;1===this.nodeType&&(null==(t=i?n.call(this,e,S(this).val()):n)?t="":"number"==typeof t?t+="":Array.isArray(t)&&(t=S.map(t,function(e){return null==e?"":e+""})),(r=S.valHooks[this.type]||S.valHooks[this.nodeName.toLowerCase()])&&"set"in r&&void 0!==r.set(this,t,"value")||(this.value=t))})):t?(r=S.valHooks[t.type]||S.valHooks[t.nodeName.toLowerCase()])&&"get"in r&&void 0!==(e=r.get(t,"value"))?e:"string"==typeof(e=t.value)?e.replace(yt,""):null==e?"":e:void 0}}),S.extend({valHooks:{option:{get:function(e){var t=S.find.attr(e,"value");return null!=t?t:ht(S.text(e))}},select:{get:function(e){var t,n,r,i=e.options,o=e.selectedIndex,a="select-one"===e.type,s=a?null:[],u=a?o+1:i.length;for(r=o<0?u:a?o:0;r<u;r++)if(((n=i[r]).selected||r===o)&&!n.disabled&&(!n.parentNode.disabled||!A(n.parentNode,"optgroup"))){if(t=S(n).val(),a)return t;s.push(t)}return s},set:function(e,t){var n,r,i=e.options,o=S.makeArray(t),a=i.length;while(a--)((r=i[a]).selected=-1<S.inArray(S.valHooks.option.get(r),o))&&(n=!0);return n||(e.selectedIndex=-1),o}}}}),S.each(["radio","checkbox"],function(){S.valHooks[this]={set:function(e,t){if(Array.isArray(t))return e.checked=-1<S.inArray(S(e).val(),t)}},y.checkOn||(S.valHooks[this].get=function(e){return null===e.getAttribute("value")?"on":e.value})}),y.focusin="onfocusin"in C;var mt=/^(?:focusinfocus|focusoutblur)$/,xt=function(e){e.stopPropagation()};S.extend(S.event,{trigger:function(e,t,n,r){var i,o,a,s,u,l,c,f,p=[n||E],d=v.call(e,"type")?e.type:e,h=v.call(e,"namespace")?e.namespace.split("."):[];if(o=f=a=n=n||E,3!==n.nodeType&&8!==n.nodeType&&!mt.test(d+S.event.triggered)&&(-1<d.indexOf(".")&&(d=(h=d.split(".")).shift(),h.sort()),u=d.indexOf(":")<0&&"on"+d,(e=e[S.expando]?e:new S.Event(d,"object"==typeof e&&e)).isTrigger=r?2:3,e.namespace=h.join("."),e.rnamespace=e.namespace?new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,e.result=void 0,e.target||(e.target=n),t=null==t?[e]:S.makeArray(t,[e]),c=S.event.special[d]||{},r||!c.trigger||!1!==c.trigger.apply(n,t))){if(!r&&!c.noBubble&&!x(n)){for(s=c.delegateType||d,mt.test(s+d)||(o=o.parentNode);o;o=o.parentNode)p.push(o),a=o;a===(n.ownerDocument||E)&&p.push(a.defaultView||a.parentWindow||C)}i=0;while((o=p[i++])&&!e.isPropagationStopped())f=o,e.type=1<i?s:c.bindType||d,(l=(Y.get(o,"events")||Object.create(null))[e.type]&&Y.get(o,"handle"))&&l.apply(o,t),(l=u&&o[u])&&l.apply&&V(o)&&(e.result=l.apply(o,t),!1===e.result&&e.preventDefault());return e.type=d,r||e.isDefaultPrevented()||c._default&&!1!==c._default.apply(p.pop(),t)||!V(n)||u&&m(n[d])&&!x(n)&&((a=n[u])&&(n[u]=null),S.event.triggered=d,e.isPropagationStopped()&&f.addEventListener(d,xt),n[d](),e.isPropagationStopped()&&f.removeEventListener(d,xt),S.event.triggered=void 0,a&&(n[u]=a)),e.result}},simulate:function(e,t,n){var r=S.extend(new S.Event,n,{type:e,isSimulated:!0});S.event.trigger(r,null,t)}}),S.fn.extend({trigger:function(e,t){return this.each(function(){S.event.trigger(e,t,this)})},triggerHandler:function(e,t){var n=this[0];if(n)return S.event.trigger(e,t,n,!0)}}),y.focusin||S.each({focus:"focusin",blur:"focusout"},function(n,r){var i=function(e){S.event.simulate(r,e.target,S.event.fix(e))};S.event.special[r]={setup:function(){var e=this.ownerDocument||this.document||this,t=Y.access(e,r);t||e.addEventListener(n,i,!0),Y.access(e,r,(t||0)+1)},teardown:function(){var e=this.ownerDocument||this.document||this,t=Y.access(e,r)-1;t?Y.access(e,r,t):(e.removeEventListener(n,i,!0),Y.remove(e,r))}}});var bt=C.location,wt={guid:Date.now()},Tt=/\?/;S.parseXML=function(e){var t,n;if(!e||"string"!=typeof e)return null;try{t=(new C.DOMParser).parseFromString(e,"text/xml")}catch(e){}return n=t&&t.getElementsByTagName("parsererror")[0],t&&!n||S.error("Invalid XML: "+(n?S.map(n.childNodes,function(e){return e.textContent}).join("\n"):e)),t};var Ct=/\[\]$/,Et=/\r?\n/g,St=/^(?:submit|button|image|reset|file)$/i,kt=/^(?:input|select|textarea|keygen)/i;function At(n,e,r,i){var t;if(Array.isArray(e))S.each(e,function(e,t){r||Ct.test(n)?i(n,t):At(n+"["+("object"==typeof t&&null!=t?e:"")+"]",t,r,i)});else if(r||"object"!==w(e))i(n,e);else for(t in e)At(n+"["+t+"]",e[t],r,i)}S.param=function(e,t){var n,r=[],i=function(e,t){var n=m(t)?t():t;r[r.length]=encodeURIComponent(e)+"="+encodeURIComponent(null==n?"":n)};if(null==e)return"";if(Array.isArray(e)||e.jquery&&!S.isPlainObject(e))S.each(e,function(){i(this.name,this.value)});else for(n in e)At(n,e[n],t,i);return r.join("&")},S.fn.extend({serialize:function(){return S.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=S.prop(this,"elements");return e?S.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!S(this).is(":disabled")&&kt.test(this.nodeName)&&!St.test(e)&&(this.checked||!pe.test(e))}).map(function(e,t){var n=S(this).val();return null==n?null:Array.isArray(n)?S.map(n,function(e){return{name:t.name,value:e.replace(Et,"\r\n")}}):{name:t.name,value:n.replace(Et,"\r\n")}}).get()}});var Nt=/%20/g,jt=/#.*$/,Dt=/([?&])_=[^&]*/,qt=/^(.*?):[ \t]*([^\r\n]*)$/gm,Lt=/^(?:GET|HEAD)$/,Ht=/^\/\//,Ot={},Pt={},Rt="*/".concat("*"),Mt=E.createElement("a");function It(o){return function(e,t){"string"!=typeof e&&(t=e,e="*");var n,r=0,i=e.toLowerCase().match(P)||[];if(m(t))while(n=i[r++])"+"===n[0]?(n=n.slice(1)||"*",(o[n]=o[n]||[]).unshift(t)):(o[n]=o[n]||[]).push(t)}}function Wt(t,i,o,a){var s={},u=t===Pt;function l(e){var r;return s[e]=!0,S.each(t[e]||[],function(e,t){var n=t(i,o,a);return"string"!=typeof n||u||s[n]?u?!(r=n):void 0:(i.dataTypes.unshift(n),l(n),!1)}),r}return l(i.dataTypes[0])||!s["*"]&&l("*")}function Ft(e,t){var n,r,i=S.ajaxSettings.flatOptions||{};for(n in t)void 0!==t[n]&&((i[n]?e:r||(r={}))[n]=t[n]);return r&&S.extend(!0,e,r),e}Mt.href=bt.href,S.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:bt.href,type:"GET",isLocal:/^(?:about|app|app-storage|.+-extension|file|res|widget):$/.test(bt.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":Rt,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":S.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?Ft(Ft(e,S.ajaxSettings),t):Ft(S.ajaxSettings,e)},ajaxPrefilter:It(Ot),ajaxTransport:It(Pt),ajax:function(e,t){"object"==typeof e&&(t=e,e=void 0),t=t||{};var c,f,p,n,d,r,h,g,i,o,v=S.ajaxSetup({},t),y=v.context||v,m=v.context&&(y.nodeType||y.jquery)?S(y):S.event,x=S.Deferred(),b=S.Callbacks("once memory"),w=v.statusCode||{},a={},s={},u="canceled",T={readyState:0,getResponseHeader:function(e){var t;if(h){if(!n){n={};while(t=qt.exec(p))n[t[1].toLowerCase()+" "]=(n[t[1].toLowerCase()+" "]||[]).concat(t[2])}t=n[e.toLowerCase()+" "]}return null==t?null:t.join(", ")},getAllResponseHeaders:function(){return h?p:null},setRequestHeader:function(e,t){return null==h&&(e=s[e.toLowerCase()]=s[e.toLowerCase()]||e,a[e]=t),this},overrideMimeType:function(e){return null==h&&(v.mimeType=e),this},statusCode:function(e){var t;if(e)if(h)T.always(e[T.status]);else for(t in e)w[t]=[w[t],e[t]];return this},abort:function(e){var t=e||u;return c&&c.abort(t),l(0,t),this}};if(x.promise(T),v.url=((e||v.url||bt.href)+"").replace(Ht,bt.protocol+"//"),v.type=t.method||t.type||v.method||v.type,v.dataTypes=(v.dataType||"*").toLowerCase().match(P)||[""],null==v.crossDomain){r=E.createElement("a");try{r.href=v.url,r.href=r.href,v.crossDomain=Mt.protocol+"//"+Mt.host!=r.protocol+"//"+r.host}catch(e){v.crossDomain=!0}}if(v.data&&v.processData&&"string"!=typeof v.data&&(v.data=S.param(v.data,v.traditional)),Wt(Ot,v,t,T),h)return T;for(i in(g=S.event&&v.global)&&0==S.active++&&S.event.trigger("ajaxStart"),v.type=v.type.toUpperCase(),v.hasContent=!Lt.test(v.type),f=v.url.replace(jt,""),v.hasContent?v.data&&v.processData&&0===(v.contentType||"").indexOf("application/x-www-form-urlencoded")&&(v.data=v.data.replace(Nt,"+")):(o=v.url.slice(f.length),v.data&&(v.processData||"string"==typeof v.data)&&(f+=(Tt.test(f)?"&":"?")+v.data,delete v.data),!1===v.cache&&(f=f.replace(Dt,"$1"),o=(Tt.test(f)?"&":"?")+"_="+wt.guid+++o),v.url=f+o),v.ifModified&&(S.lastModified[f]&&T.setRequestHeader("If-Modified-Since",S.lastModified[f]),S.etag[f]&&T.setRequestHeader("If-None-Match",S.etag[f])),(v.data&&v.hasContent&&!1!==v.contentType||t.contentType)&&T.setRequestHeader("Content-Type",v.contentType),T.setRequestHeader("Accept",v.dataTypes[0]&&v.accepts[v.dataTypes[0]]?v.accepts[v.dataTypes[0]]+("*"!==v.dataTypes[0]?", "+Rt+"; q=0.01":""):v.accepts["*"]),v.headers)T.setRequestHeader(i,v.headers[i]);if(v.beforeSend&&(!1===v.beforeSend.call(y,T,v)||h))return T.abort();if(u="abort",b.add(v.complete),T.done(v.success),T.fail(v.error),c=Wt(Pt,v,t,T)){if(T.readyState=1,g&&m.trigger("ajaxSend",[T,v]),h)return T;v.async&&0<v.timeout&&(d=C.setTimeout(function(){T.abort("timeout")},v.timeout));try{h=!1,c.send(a,l)}catch(e){if(h)throw e;l(-1,e)}}else l(-1,"No Transport");function l(e,t,n,r){var i,o,a,s,u,l=t;h||(h=!0,d&&C.clearTimeout(d),c=void 0,p=r||"",T.readyState=0<e?4:0,i=200<=e&&e<300||304===e,n&&(s=function(e,t,n){var r,i,o,a,s=e.contents,u=e.dataTypes;while("*"===u[0])u.shift(),void 0===r&&(r=e.mimeType||t.getResponseHeader("Content-Type"));if(r)for(i in s)if(s[i]&&s[i].test(r)){u.unshift(i);break}if(u[0]in n)o=u[0];else{for(i in n){if(!u[0]||e.converters[i+" "+u[0]]){o=i;break}a||(a=i)}o=o||a}if(o)return o!==u[0]&&u.unshift(o),n[o]}(v,T,n)),!i&&-1<S.inArray("script",v.dataTypes)&&S.inArray("json",v.dataTypes)<0&&(v.converters["text script"]=function(){}),s=function(e,t,n,r){var i,o,a,s,u,l={},c=e.dataTypes.slice();if(c[1])for(a in e.converters)l[a.toLowerCase()]=e.converters[a];o=c.shift();while(o)if(e.responseFields[o]&&(n[e.responseFields[o]]=t),!u&&r&&e.dataFilter&&(t=e.dataFilter(t,e.dataType)),u=o,o=c.shift())if("*"===o)o=u;else if("*"!==u&&u!==o){if(!(a=l[u+" "+o]||l["* "+o]))for(i in l)if((s=i.split(" "))[1]===o&&(a=l[u+" "+s[0]]||l["* "+s[0]])){!0===a?a=l[i]:!0!==l[i]&&(o=s[0],c.unshift(s[1]));break}if(!0!==a)if(a&&e["throws"])t=a(t);else try{t=a(t)}catch(e){return{state:"parsererror",error:a?e:"No conversion from "+u+" to "+o}}}return{state:"success",data:t}}(v,s,T,i),i?(v.ifModified&&((u=T.getResponseHeader("Last-Modified"))&&(S.lastModified[f]=u),(u=T.getResponseHeader("etag"))&&(S.etag[f]=u)),204===e||"HEAD"===v.type?l="nocontent":304===e?l="notmodified":(l=s.state,o=s.data,i=!(a=s.error))):(a=l,!e&&l||(l="error",e<0&&(e=0))),T.status=e,T.statusText=(t||l)+"",i?x.resolveWith(y,[o,l,T]):x.rejectWith(y,[T,l,a]),T.statusCode(w),w=void 0,g&&m.trigger(i?"ajaxSuccess":"ajaxError",[T,v,i?o:a]),b.fireWith(y,[T,l]),g&&(m.trigger("ajaxComplete",[T,v]),--S.active||S.event.trigger("ajaxStop")))}return T},getJSON:function(e,t,n){return S.get(e,t,n,"json")},getScript:function(e,t){return S.get(e,void 0,t,"script")}}),S.each(["get","post"],function(e,i){S[i]=function(e,t,n,r){return m(t)&&(r=r||n,n=t,t=void 0),S.ajax(S.extend({url:e,type:i,dataType:r,data:t,success:n},S.isPlainObject(e)&&e))}}),S.ajaxPrefilter(function(e){var t;for(t in e.headers)"content-type"===t.toLowerCase()&&(e.contentType=e.headers[t]||"")}),S._evalUrl=function(e,t,n){return S.ajax({url:e,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,converters:{"text script":function(){}},dataFilter:function(e){S.globalEval(e,t,n)}})},S.fn.extend({wrapAll:function(e){var t;return this[0]&&(m(e)&&(e=e.call(this[0])),t=S(e,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){var e=this;while(e.firstElementChild)e=e.firstElementChild;return e}).append(this)),this},wrapInner:function(n){return m(n)?this.each(function(e){S(this).wrapInner(n.call(this,e))}):this.each(function(){var e=S(this),t=e.contents();t.length?t.wrapAll(n):e.append(n)})},wrap:function(t){var n=m(t);return this.each(function(e){S(this).wrapAll(n?t.call(this,e):t)})},unwrap:function(e){return this.parent(e).not("body").each(function(){S(this).replaceWith(this.childNodes)}),this}}),S.expr.pseudos.hidden=function(e){return!S.expr.pseudos.visible(e)},S.expr.pseudos.visible=function(e){return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)},S.ajaxSettings.xhr=function(){try{return new C.XMLHttpRequest}catch(e){}};var Bt={0:200,1223:204},$t=S.ajaxSettings.xhr();y.cors=!!$t&&"withCredentials"in $t,y.ajax=$t=!!$t,S.ajaxTransport(function(i){var o,a;if(y.cors||$t&&!i.crossDomain)return{send:function(e,t){var n,r=i.xhr();if(r.open(i.type,i.url,i.async,i.username,i.password),i.xhrFields)for(n in i.xhrFields)r[n]=i.xhrFields[n];for(n in i.mimeType&&r.overrideMimeType&&r.overrideMimeType(i.mimeType),i.crossDomain||e["X-Requested-With"]||(e["X-Requested-With"]="XMLHttpRequest"),e)r.setRequestHeader(n,e[n]);o=function(e){return function(){o&&(o=a=r.onload=r.onerror=r.onabort=r.ontimeout=r.onreadystatechange=null,"abort"===e?r.abort():"error"===e?"number"!=typeof r.status?t(0,"error"):t(r.status,r.statusText):t(Bt[r.status]||r.status,r.statusText,"text"!==(r.responseType||"text")||"string"!=typeof r.responseText?{binary:r.response}:{text:r.responseText},r.getAllResponseHeaders()))}},r.onload=o(),a=r.onerror=r.ontimeout=o("error"),void 0!==r.onabort?r.onabort=a:r.onreadystatechange=function(){4===r.readyState&&C.setTimeout(function(){o&&a()})},o=o("abort");try{r.send(i.hasContent&&i.data||null)}catch(e){if(o)throw e}},abort:function(){o&&o()}}}),S.ajaxPrefilter(function(e){e.crossDomain&&(e.contents.script=!1)}),S.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(e){return S.globalEval(e),e}}}),S.ajaxPrefilter("script",function(e){void 0===e.cache&&(e.cache=!1),e.crossDomain&&(e.type="GET")}),S.ajaxTransport("script",function(n){var r,i;if(n.crossDomain||n.scriptAttrs)return{send:function(e,t){r=S("<script>").attr(n.scriptAttrs||{}).prop({charset:n.scriptCharset,src:n.url}).on("load error",i=function(e){r.remove(),i=null,e&&t("error"===e.type?404:200,e.type)}),E.head.appendChild(r[0])},abort:function(){i&&i()}}});var _t,zt=[],Ut=/(=)\?(?=&|$)|\?\?/;S.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=zt.pop()||S.expando+"_"+wt.guid++;return this[e]=!0,e}}),S.ajaxPrefilter("json jsonp",function(e,t,n){var r,i,o,a=!1!==e.jsonp&&(Ut.test(e.url)?"url":"string"==typeof e.data&&0===(e.contentType||"").indexOf("application/x-www-form-urlencoded")&&Ut.test(e.data)&&"data");if(a||"jsonp"===e.dataTypes[0])return r=e.jsonpCallback=m(e.jsonpCallback)?e.jsonpCallback():e.jsonpCallback,a?e[a]=e[a].replace(Ut,"$1"+r):!1!==e.jsonp&&(e.url+=(Tt.test(e.url)?"&":"?")+e.jsonp+"="+r),e.converters["script json"]=function(){return o||S.error(r+" was not called"),o[0]},e.dataTypes[0]="json",i=C[r],C[r]=function(){o=arguments},n.always(function(){void 0===i?S(C).removeProp(r):C[r]=i,e[r]&&(e.jsonpCallback=t.jsonpCallback,zt.push(r)),o&&m(i)&&i(o[0]),o=i=void 0}),"script"}),y.createHTMLDocument=((_t=E.implementation.createHTMLDocument("").body).innerHTML="<form></form><form></form>",2===_t.childNodes.length),S.parseHTML=function(e,t,n){return"string"!=typeof e?[]:("boolean"==typeof t&&(n=t,t=!1),t||(y.createHTMLDocument?((r=(t=E.implementation.createHTMLDocument("")).createElement("base")).href=E.location.href,t.head.appendChild(r)):t=E),o=!n&&[],(i=N.exec(e))?[t.createElement(i[1])]:(i=xe([e],t,o),o&&o.length&&S(o).remove(),S.merge([],i.childNodes)));var r,i,o},S.fn.load=function(e,t,n){var r,i,o,a=this,s=e.indexOf(" ");return-1<s&&(r=ht(e.slice(s)),e=e.slice(0,s)),m(t)?(n=t,t=void 0):t&&"object"==typeof t&&(i="POST"),0<a.length&&S.ajax({url:e,type:i||"GET",dataType:"html",data:t}).done(function(e){o=arguments,a.html(r?S("<div>").append(S.parseHTML(e)).find(r):e)}).always(n&&function(e,t){a.each(function(){n.apply(this,o||[e.responseText,t,e])})}),this},S.expr.pseudos.animated=function(t){return S.grep(S.timers,function(e){return t===e.elem}).length},S.offset={setOffset:function(e,t,n){var r,i,o,a,s,u,l=S.css(e,"position"),c=S(e),f={};"static"===l&&(e.style.position="relative"),s=c.offset(),o=S.css(e,"top"),u=S.css(e,"left"),("absolute"===l||"fixed"===l)&&-1<(o+u).indexOf("auto")?(a=(r=c.position()).top,i=r.left):(a=parseFloat(o)||0,i=parseFloat(u)||0),m(t)&&(t=t.call(e,n,S.extend({},s))),null!=t.top&&(f.top=t.top-s.top+a),null!=t.left&&(f.left=t.left-s.left+i),"using"in t?t.using.call(e,f):c.css(f)}},S.fn.extend({offset:function(t){if(arguments.length)return void 0===t?this:this.each(function(e){S.offset.setOffset(this,t,e)});var e,n,r=this[0];return r?r.getClientRects().length?(e=r.getBoundingClientRect(),n=r.ownerDocument.defaultView,{top:e.top+n.pageYOffset,left:e.left+n.pageXOffset}):{top:0,left:0}:void 0},position:function(){if(this[0]){var e,t,n,r=this[0],i={top:0,left:0};if("fixed"===S.css(r,"position"))t=r.getBoundingClientRect();else{t=this.offset(),n=r.ownerDocument,e=r.offsetParent||n.documentElement;while(e&&(e===n.body||e===n.documentElement)&&"static"===S.css(e,"position"))e=e.parentNode;e&&e!==r&&1===e.nodeType&&((i=S(e).offset()).top+=S.css(e,"borderTopWidth",!0),i.left+=S.css(e,"borderLeftWidth",!0))}return{top:t.top-i.top-S.css(r,"marginTop",!0),left:t.left-i.left-S.css(r,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){var e=this.offsetParent;while(e&&"static"===S.css(e,"position"))e=e.offsetParent;return e||re})}}),S.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(t,i){var o="pageYOffset"===i;S.fn[t]=function(e){return $(this,function(e,t,n){var r;if(x(e)?r=e:9===e.nodeType&&(r=e.defaultView),void 0===n)return r?r[i]:e[t];r?r.scrollTo(o?r.pageXOffset:n,o?n:r.pageYOffset):e[t]=n},t,e,arguments.length)}}),S.each(["top","left"],function(e,n){S.cssHooks[n]=Fe(y.pixelPosition,function(e,t){if(t)return t=We(e,n),Pe.test(t)?S(e).position()[n]+"px":t})}),S.each({Height:"height",Width:"width"},function(a,s){S.each({padding:"inner"+a,content:s,"":"outer"+a},function(r,o){S.fn[o]=function(e,t){var n=arguments.length&&(r||"boolean"!=typeof e),i=r||(!0===e||!0===t?"margin":"border");return $(this,function(e,t,n){var r;return x(e)?0===o.indexOf("outer")?e["inner"+a]:e.document.documentElement["client"+a]:9===e.nodeType?(r=e.documentElement,Math.max(e.body["scroll"+a],r["scroll"+a],e.body["offset"+a],r["offset"+a],r["client"+a])):void 0===n?S.css(e,t,i):S.style(e,t,n,i)},s,n?e:void 0,n)}})}),S.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(e,t){S.fn[t]=function(e){return this.on(t,e)}}),S.fn.extend({bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,"**"):this.off(t,e||"**",n)},hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)}}),S.each("blur focus focusin focusout resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu".split(" "),function(e,n){S.fn[n]=function(e,t){return 0<arguments.length?this.on(n,null,e,t):this.trigger(n)}});var Xt=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;S.proxy=function(e,t){var n,r,i;if("string"==typeof t&&(n=e[t],t=e,e=n),m(e))return r=s.call(arguments,2),(i=function(){return e.apply(t||this,r.concat(s.call(arguments)))}).guid=e.guid=e.guid||S.guid++,i},S.holdReady=function(e){e?S.readyWait++:S.ready(!0)},S.isArray=Array.isArray,S.parseJSON=JSON.parse,S.nodeName=A,S.isFunction=m,S.isWindow=x,S.camelCase=X,S.type=w,S.now=Date.now,S.isNumeric=function(e){var t=S.type(e);return("number"===t||"string"===t)&&!isNaN(e-parseFloat(e))},S.trim=function(e){return null==e?"":(e+"").replace(Xt,"")},"function"==typeof define&&define.amd&&define("jquery",[],function(){return S});var Vt=C.jQuery,Gt=C.$;return S.noConflict=function(e){return C.$===S&&(C.$=Gt),e&&C.jQuery===S&&(C.jQuery=Vt),S},"undefined"==typeof e&&(C.jQuery=C.$=S),S});

/**
 * @license
 * lodash 4.8.2 (Custom Build) lodash.com/license | Underscore.js 1.8.3 underscorejs.org/LICENSE
 * Build: `lodash -o ./dist/lodash.js`
 */
;(function(){function t(t,n){return t.set(n[0],n[1]),t}function n(t,n){return t.add(n),t}function r(t,n,r){switch(r.length){case 0:return t.call(n);case 1:return t.call(n,r[0]);case 2:return t.call(n,r[0],r[1]);case 3:return t.call(n,r[0],r[1],r[2])}return t.apply(n,r)}function e(t,n,r,e){for(var u=-1,o=t.length;++u<o;){var i=t[u];n(e,i,r(i),t)}return e}function u(t,n){for(var r=-1,e=t.length;++r<e&&false!==n(t[r],r,t););return t}function o(t,n){for(var r=-1,e=t.length;++r<e;)if(!n(t[r],r,t))return false;
return true}function i(t,n){for(var r=-1,e=t.length,u=0,o=[];++r<e;){var i=t[r];n(i,r,t)&&(o[u++]=i)}return o}function f(t,n){return!!t.length&&-1<d(t,n,0)}function c(t,n,r){for(var e=-1,u=t.length;++e<u;)if(r(n,t[e]))return true;return false}function a(t,n){for(var r=-1,e=t.length,u=Array(e);++r<e;)u[r]=n(t[r],r,t);return u}function l(t,n){for(var r=-1,e=n.length,u=t.length;++r<e;)t[u+r]=n[r];return t}function s(t,n,r,e){var u=-1,o=t.length;for(e&&o&&(r=t[++u]);++u<o;)r=n(r,t[u],u,t);return r}function h(t,n,r,e){
var u=t.length;for(e&&u&&(r=t[--u]);u--;)r=n(r,t[u],u,t);return r}function p(t,n){for(var r=-1,e=t.length;++r<e;)if(n(t[r],r,t))return true;return false}function _(t,n,r){for(var e=-1,u=t.length;++e<u;){var o=t[e],i=n(o);if(null!=i&&(f===T?i===i:r(i,f)))var f=i,c=o}return c}function v(t,n,r,e){var u;return r(t,function(t,r,o){return n(t,r,o)?(u=e?r:t,false):void 0}),u}function g(t,n,r){for(var e=t.length,u=r?e:-1;r?u--:++u<e;)if(n(t[u],u,t))return u;return-1}function d(t,n,r){if(n!==n)return U(t,r);--r;for(var e=t.length;++r<e;)if(t[r]===n)return r;
return-1}function y(t,n,r,e){--r;for(var u=t.length;++r<u;)if(e(t[r],n))return r;return-1}function b(t,n){var r=t?t.length:0;return r?m(t,n)/r:K}function x(t,n,r,e,u){return u(t,function(t,u,o){r=e?(e=false,t):n(r,t,u,o)}),r}function j(t,n){var r=t.length;for(t.sort(n);r--;)t[r]=t[r].c;return t}function m(t,n){for(var r,e=-1,u=t.length;++e<u;){var o=n(t[e]);o!==T&&(r=r===T?o:r+o)}return r}function w(t,n){for(var r=-1,e=Array(t);++r<t;)e[r]=n(r);return e}function A(t,n){return a(n,function(n){return[n,t[n]];
})}function O(t){return function(n){return t(n)}}function k(t,n){return a(n,function(n){return t[n]})}function E(t,n){for(var r=-1,e=t.length;++r<e&&-1<d(n,t[r],0););return r}function I(t,n){for(var r=t.length;r--&&-1<d(n,t[r],0););return r}function S(t){return t&&t.Object===Object?t:null}function R(t,n){if(t!==n){var r=null===t,e=t===T,u=t===t,o=null===n,i=n===T,f=n===n;if(t>n&&!o||!u||r&&!i&&f||e&&f)return 1;if(n>t&&!r||!f||o&&!e&&u||i&&u)return-1}return 0}function W(t){return function(n,r){var e;
return n===T&&r===T?0:(n!==T&&(e=n),r!==T&&(e=e===T?r:t(e,r)),e)}}function B(t){return Mt[t]}function C(t){return Lt[t]}function z(t){return"\\"+Ft[t]}function U(t,n,r){var e=t.length;for(n+=r?0:-1;r?n--:++n<e;){var u=t[n];if(u!==u)return n}return-1}function M(t){var n=false;if(null!=t&&typeof t.toString!="function")try{n=!!(t+"")}catch(r){}return n}function L(t,n){return t=typeof t=="number"||xt.test(t)?+t:-1,t>-1&&0==t%1&&(null==n?9007199254740991:n)>t}function $(t){for(var n,r=[];!(n=t.next()).done;)r.push(n.value);
return r}function D(t){var n=-1,r=Array(t.size);return t.forEach(function(t,e){r[++n]=[e,t]}),r}function F(t,n){for(var r=-1,e=t.length,u=0,o=[];++r<e;){var i=t[r];i!==n&&"__lodash_placeholder__"!==i||(t[r]="__lodash_placeholder__",o[u++]=r)}return o}function N(t){var n=-1,r=Array(t.size);return t.forEach(function(t){r[++n]=t}),r}function P(t){if(!t||!St.test(t))return t.length;for(var n=It.lastIndex=0;It.test(t);)n++;return n}function Z(t){return $t[t]}function q(S){function xt(t){if(Se(t)&&!Qo(t)&&!(t instanceof kt)){
if(t instanceof Ot)return t;if(vu.call(t,"__wrapped__"))return Jr(t)}return new Ot(t)}function At(){}function Ot(t,n){this.__wrapped__=t,this.__actions__=[],this.__chain__=!!n,this.__index__=0,this.__values__=T}function kt(t){this.__wrapped__=t,this.__actions__=[],this.__dir__=1,this.__filtered__=false,this.__iteratees__=[],this.__takeCount__=4294967295,this.__views__=[]}function Mt(){}function Lt(t){var n=-1,r=t?t.length:0;for(this.clear();++n<r;){var e=t[n];this.set(e[0],e[1])}}function $t(t){var n=-1,r=t?t.length:0;
for(this.__data__=new Lt;++n<r;)this.push(t[n])}function Dt(t,n){var r=t.__data__;return Pr(n)?(r=r.__data__,"__lodash_hash_undefined__"===(typeof n=="string"?r.string:r.hash)[n]):r.has(n)}function Ft(t){var n=-1,r=t?t.length:0;for(this.clear();++n<r;){var e=t[n];this.set(e[0],e[1])}}function Zt(t,n){var r=Vt(t,n);return 0>r?false:(r==t.length-1?t.pop():Bu.call(t,r,1),true)}function qt(t,n){var r=Vt(t,n);return 0>r?T:t[r][1]}function Vt(t,n){for(var r=t.length;r--;)if(be(t[r][0],n))return r;return-1}function Kt(t,n,r){
var e=Vt(t,n);0>e?t.push([n,r]):t[e][1]=r}function Gt(t,n,r,e){return t===T||be(t,pu[r])&&!vu.call(e,r)?n:t}function Ht(t,n,r){(r===T||be(t[n],r))&&(typeof n!="number"||r!==T||n in t)||(t[n]=r)}function Qt(t,n,r){var e=t[n];vu.call(t,n)&&be(e,r)&&(r!==T||n in t)||(t[n]=r)}function Xt(t,n,r,e){return fo(t,function(t,u,o){n(e,t,r(t),o)}),e}function tn(t,n){return t&&ur(n,Ke(n),t)}function nn(t,n){for(var r=-1,e=null==t,u=n.length,o=Array(u);++r<u;)o[r]=e?T:qe(t,n[r]);return o}function rn(t){return we(t)?t:[];
}function en(t){return typeof t=="string"||Ue(t)?t:t+""}function un(t){return Qo(t)?t:yo(t)}function on(t,n,r){return t===t&&(r!==T&&(t=t>r?r:t),n!==T&&(t=n>t?n:t)),t}function fn(t,n,r,e,o,i,f){var c;if(e&&(c=i?e(t,o,i,f):e(t)),c!==T)return c;if(!Ie(t))return t;if(o=Qo(t)){if(c=Mr(t),!n)return er(t,c)}else{var a=zr(t),l="[object Function]"==a||"[object GeneratorFunction]"==a;if(Xo(t))return Xn(t,n);if("[object Object]"==a||"[object Arguments]"==a||l&&!i){if(M(t))return i?t:{};if(c=Lr(l?{}:t),!n)return ir(t,tn(c,t));
}else{if(!Ut[a])return i?t:{};c=$r(t,a,fn,n)}}if(f||(f=new Ft),i=f.get(t))return i;if(f.set(t,c),!o)var s=r?bn(t,Ke,Cr):Ke(t);return u(s||t,function(u,o){s&&(o=u,u=t[o]),Qt(c,o,fn(u,n,r,e,o,t,f))}),c}function cn(t){var n=Ke(t),r=n.length;return function(e){if(null==e)return!r;for(var u=r;u--;){var o=n[u],i=t[o],f=e[o];if(f===T&&!(o in Object(e))||!i(f))return false}return true}}function an(t){return Ie(t)?Su(t):{}}function ln(t,n,r){if(typeof t!="function")throw new su("Expected a function");return Wu(function(){
t.apply(T,r)},n)}function sn(t,n,r,e){var u=-1,o=f,i=true,l=t.length,s=[],h=n.length;if(!l)return s;r&&(n=a(n,O(r))),e?(o=c,i=false):n.length>=200&&(o=Dt,i=false,n=new $t(n));t:for(;++u<l;){var p=t[u],_=r?r(p):p;if(i&&_===_){for(var v=h;v--;)if(n[v]===_)continue t;s.push(p)}else o(n,_,e)||s.push(p)}return s}function hn(t,n){var r=true;return fo(t,function(t,e,u){return r=!!n(t,e,u)}),r}function pn(t,n){var r=[];return fo(t,function(t,e,u){n(t,e,u)&&r.push(t)}),r}function _n(t,n,r,e){e||(e=[]);for(var u=-1,o=t.length;++u<o;){
var i=t[u];n>0&&we(i)&&(r||Qo(i)||je(i))?n>1?_n(i,n-1,r,e):l(e,i):r||(e[e.length]=i)}return e}function vn(t,n){return t&&ao(t,n,Ke)}function gn(t,n){return t&&lo(t,n,Ke)}function dn(t,n){return i(n,function(n){return Oe(t[n])})}function yn(t,n){n=Nr(n,t)?[n]:un(n);for(var r=0,e=n.length;null!=t&&e>r;)t=t[n[r++]];return r&&r==e?t:T}function bn(t,n,r){return n=n(t),Qo(t)?n:l(n,r(t))}function xn(t,n){return vu.call(t,n)||typeof t=="object"&&n in t&&null===Uu(Object(t))}function jn(t,n){return n in Object(t);
}function mn(t,n,r){for(var e=r?c:f,u=t[0].length,o=t.length,i=o,l=Array(o),s=1/0,h=[];i--;){var p=t[i];i&&n&&(p=a(p,O(n))),s=Fu(p.length,s),l[i]=r||!n&&(120>u||120>p.length)?T:new $t(i&&p)}var p=t[0],_=-1,v=l[0];t:for(;++_<u&&s>h.length;){var g=p[_],d=n?n(g):g;if(v?!Dt(v,d):!e(h,d,r)){for(i=o;--i;){var y=l[i];if(y?!Dt(y,d):!e(t[i],d,r))continue t}v&&v.push(d),h.push(g)}}return h}function wn(t,n,r){var e={};return vn(t,function(t,u,o){n(e,r(t),u,o)}),e}function An(t,n,e){return Nr(n,t)||(n=un(n),
t=Kr(t,n),n=Xr(n)),n=null==t?t:t[n],null==n?T:r(n,t,e)}function On(t,n,r,e,u){if(t===n)n=true;else if(null==t||null==n||!Ie(t)&&!Se(n))n=t!==t&&n!==n;else t:{var o=Qo(t),i=Qo(n),f="[object Array]",c="[object Array]";o||(f=zr(t),f="[object Arguments]"==f?"[object Object]":f),i||(c=zr(n),c="[object Arguments]"==c?"[object Object]":c);var a="[object Object]"==f&&!M(t),i="[object Object]"==c&&!M(n);if((c=f==c)&&!a)u||(u=new Ft),n=o||Me(t)?kr(t,n,On,r,e,u):Er(t,n,f,On,r,e,u);else{if(!(2&e)&&(o=a&&vu.call(t,"__wrapped__"),
f=i&&vu.call(n,"__wrapped__"),o||f)){t=o?t.value():t,n=f?n.value():n,u||(u=new Ft),n=On(t,n,r,e,u);break t}if(c)n:if(u||(u=new Ft),o=2&e,f=Ke(t),i=f.length,c=Ke(n).length,i==c||o){for(a=i;a--;){var l=f[a];if(!(o?l in n:xn(n,l))){n=false;break n}}if(c=u.get(t))n=c==n;else{c=true,u.set(t,n);for(var s=o;++a<i;){var l=f[a],h=t[l],p=n[l];if(r)var _=o?r(p,h,l,n,t,u):r(h,p,l,t,n,u);if(_===T?h!==p&&!On(h,p,r,e,u):!_){c=false;break}s||(s="constructor"==l)}c&&!s&&(r=t.constructor,e=n.constructor,r!=e&&"constructor"in t&&"constructor"in n&&!(typeof r=="function"&&r instanceof r&&typeof e=="function"&&e instanceof e)&&(c=false)),
u["delete"](t),n=c}}else n=false;else n=false}}return n}function kn(t,n,r,e){var u=r.length,o=u,i=!e;if(null==t)return!o;for(t=Object(t);u--;){var f=r[u];if(i&&f[2]?f[1]!==t[f[0]]:!(f[0]in t))return false}for(;++u<o;){var f=r[u],c=f[0],a=t[c],l=f[1];if(i&&f[2]){if(a===T&&!(c in t))return false}else{if(f=new Ft,e)var s=e(a,l,c,t,n,f);if(s===T?!On(l,a,e,3,f):!s)return false}}return true}function En(t){return typeof t=="function"?t:null==t?ru:typeof t=="object"?Qo(t)?Wn(t[0],t[1]):Rn(t):iu(t)}function In(t){t=null==t?t:Object(t);
var n,r=[];for(n in t)r.push(n);return r}function Sn(t,n){var r=-1,e=me(t)?Array(t.length):[];return fo(t,function(t,u,o){e[++r]=n(t,u,o)}),e}function Rn(t){var n=Rr(t);return 1==n.length&&n[0][2]?Tr(n[0][0],n[0][1]):function(r){return r===t||kn(r,t,n)}}function Wn(t,n){return Nr(t)&&n===n&&!Ie(n)?Tr(t,n):function(r){var e=qe(r,t);return e===T&&e===n?Ve(r,t):On(n,e,T,3)}}function Bn(t,n,r,e,o){if(t!==n){if(!Qo(n)&&!Me(n))var i=Ge(n);u(i||n,function(u,f){if(i&&(f=u,u=n[f]),Ie(u)){o||(o=new Ft);var c=f,a=o,l=t[c],s=n[c],h=a.get(s);
if(h)Ht(t,c,h);else{var h=e?e(l,s,c+"",t,n,a):T,p=h===T;p&&(h=s,Qo(s)||Me(s)?Qo(l)?h=l:we(l)?h=er(l):(p=false,h=fn(s,true)):Be(s)||je(s)?je(l)?h=Pe(l):!Ie(l)||r&&Oe(l)?(p=false,h=fn(s,true)):h=l:p=false),a.set(s,h),p&&Bn(h,s,r,e,a),a["delete"](s),Ht(t,c,h)}}else c=e?e(t[f],u,f+"",t,n,o):T,c===T&&(c=u),Ht(t,f,c)})}}function Cn(t,n,r){var e=-1;return n=a(n.length?n:[ru],Sr()),t=Sn(t,function(t){return{a:a(n,function(n){return n(t)}),b:++e,c:t}}),j(t,function(t,n){var e;t:{e=-1;for(var u=t.a,o=n.a,i=u.length,f=r.length;++e<i;){
var c=R(u[e],o[e]);if(c){e=f>e?c*("desc"==r[e]?-1:1):c;break t}}e=t.b-n.b}return e})}function zn(t,n){return t=Object(t),s(n,function(n,r){return r in t&&(n[r]=t[r]),n},{})}function Un(t,n){for(var r=-1,e=bn(t,Ge,vo),u=e.length,o={};++r<u;){var i=e[r],f=t[i];n(f,i)&&(o[i]=f)}return o}function Mn(t){return function(n){return null==n?T:n[t]}}function Ln(t){return function(n){return yn(n,t)}}function $n(t,n,r,e){var u=e?y:d,o=-1,i=n.length,f=t;for(r&&(f=a(t,O(r)));++o<i;)for(var c=0,l=n[o],l=r?r(l):l;-1<(c=u(f,l,c,e));)f!==t&&Bu.call(f,c,1),
Bu.call(t,c,1);return t}function Dn(t,n){for(var r=t?n.length:0,e=r-1;r--;){var u=n[r];if(e==r||u!=o){var o=u;if(L(u))Bu.call(t,u,1);else if(Nr(u,t))delete t[u];else{var u=un(u),i=Kr(t,u);null!=i&&delete i[Xr(u)]}}}}function Fn(t,n){return t+zu(Pu()*(n-t+1))}function Nn(t,n){var r="";if(!t||1>n||n>9007199254740991)return r;do n%2&&(r+=t),(n=zu(n/2))&&(t+=t);while(n);return r}function Pn(t,n,r,e){n=Nr(n,t)?[n]:un(n);for(var u=-1,o=n.length,i=o-1,f=t;null!=f&&++u<o;){var c=n[u];if(Ie(f)){var a=r;if(u!=i){
var l=f[c],a=e?e(l,c,f):T;a===T&&(a=null==l?L(n[u+1])?[]:{}:l)}Qt(f,c,a)}f=f[c]}return t}function Zn(t,n,r){var e=-1,u=t.length;for(0>n&&(n=-n>u?0:u+n),r=r>u?u:r,0>r&&(r+=u),u=n>r?0:r-n>>>0,n>>>=0,r=Array(u);++e<u;)r[e]=t[e+n];return r}function qn(t,n){var r;return fo(t,function(t,e,u){return r=n(t,e,u),!r}),!!r}function Tn(t,n,r){var e=0,u=t?t.length:e;if(typeof n=="number"&&n===n&&2147483647>=u){for(;u>e;){var o=e+u>>>1,i=t[o];(r?n>=i:n>i)&&null!==i?e=o+1:u=o}return u}return Vn(t,n,ru,r)}function Vn(t,n,r,e){
n=r(n);for(var u=0,o=t?t.length:0,i=n!==n,f=null===n,c=n===T;o>u;){var a=zu((u+o)/2),l=r(t[a]),s=l!==T,h=l===l;(i?h||e:f?h&&s&&(e||null!=l):c?h&&(e||s):null==l?0:e?n>=l:n>l)?u=a+1:o=a}return Fu(o,4294967294)}function Kn(t,n){for(var r=0,e=t.length,u=t[0],o=n?n(u):u,i=o,f=1,c=[u];++r<e;)u=t[r],o=n?n(u):u,be(o,i)||(i=o,c[f++]=u);return c}function Gn(t,n,r){var e=-1,u=f,o=t.length,i=true,a=[],l=a;if(r)i=false,u=c;else if(o<200)l=n?[]:a;else{if(u=n?null:ho(t))return N(u);i=false,u=Dt,l=new $t}t:for(;++e<o;){
var s=t[e],h=n?n(s):s;if(i&&h===h){for(var p=l.length;p--;)if(l[p]===h)continue t;n&&l.push(h),a.push(s)}else u(l,h,r)||(l!==a&&l.push(h),a.push(s))}return a}function Jn(t,n,r,e){for(var u=t.length,o=e?u:-1;(e?o--:++o<u)&&n(t[o],o,t););return r?Zn(t,e?0:o,e?o+1:u):Zn(t,e?o+1:0,e?u:o)}function Yn(t,n){var r=t;return r instanceof kt&&(r=r.value()),s(n,function(t,n){return n.func.apply(n.thisArg,l([t],n.args))},r)}function Hn(t,n,r){for(var e=-1,u=t.length;++e<u;)var o=o?l(sn(o,t[e],n,r),sn(t[e],o,n,r)):t[e];
return o&&o.length?Gn(o,n,r):[]}function Qn(t,n,r){for(var e=-1,u=t.length,o=n.length,i={};++e<u;)r(i,t[e],o>e?n[e]:T);return i}function Xn(t,n){if(n)return t.slice();var r=new t.constructor(t.length);return t.copy(r),r}function tr(t){var n=new t.constructor(t.byteLength);return new Au(n).set(new Au(t)),n}function nr(t,n,r,e){var u=-1,o=t.length,i=r.length,f=-1,c=n.length,a=Du(o-i,0),l=Array(c+a);for(e=!e;++f<c;)l[f]=n[f];for(;++u<i;)(e||o>u)&&(l[r[u]]=t[u]);for(;a--;)l[f++]=t[u++];return l}function rr(t,n,r,e){
var u=-1,o=t.length,i=-1,f=r.length,c=-1,a=n.length,l=Du(o-f,0),s=Array(l+a);for(e=!e;++u<l;)s[u]=t[u];for(l=u;++c<a;)s[l+c]=n[c];for(;++i<f;)(e||o>u)&&(s[l+r[i]]=t[u++]);return s}function er(t,n){var r=-1,e=t.length;for(n||(n=Array(e));++r<e;)n[r]=t[r];return n}function ur(t,n,r){return or(t,n,r)}function or(t,n,r,e){r||(r={});for(var u=-1,o=n.length;++u<o;){var i=n[u],f=e?e(r[i],t[i],i,r,t):t[i];Qt(r,i,f)}return r}function ir(t,n){return ur(t,Cr(t),n)}function fr(t,n){return function(r,u){var o=Qo(r)?e:Xt,i=n?n():{};
return o(r,t,Sr(u),i)}}function cr(t){return de(function(n,r){var e=-1,u=r.length,o=u>1?r[u-1]:T,i=u>2?r[2]:T,o=typeof o=="function"?(u--,o):T;for(i&&Fr(r[0],r[1],i)&&(o=3>u?T:o,u=1),n=Object(n);++e<u;)(i=r[e])&&t(n,i,e,o);return n})}function ar(t,n){return function(r,e){if(null==r)return r;if(!me(r))return t(r,e);for(var u=r.length,o=n?u:-1,i=Object(r);(n?o--:++o<u)&&false!==e(i[o],o,i););return r}}function lr(t){return function(n,r,e){var u=-1,o=Object(n);e=e(n);for(var i=e.length;i--;){var f=e[t?i:++u];
if(false===r(o[f],f,o))break}return n}}function sr(t,n,r){function e(){return(this&&this!==Jt&&this instanceof e?o:t).apply(u?r:this,arguments)}var u=1&n,o=_r(t);return e}function hr(t){return function(n){n=Ze(n);var r=St.test(n)?n.match(It):T,e=r?r[0]:n.charAt(0);return n=r?r.slice(1).join(""):n.slice(1),e[t]()+n}}function pr(t){return function(n){return s(tu(Xe(n)),t,"")}}function _r(t){return function(){var n=arguments;switch(n.length){case 0:return new t;case 1:return new t(n[0]);case 2:return new t(n[0],n[1]);
case 3:return new t(n[0],n[1],n[2]);case 4:return new t(n[0],n[1],n[2],n[3]);case 5:return new t(n[0],n[1],n[2],n[3],n[4]);case 6:return new t(n[0],n[1],n[2],n[3],n[4],n[5]);case 7:return new t(n[0],n[1],n[2],n[3],n[4],n[5],n[6])}var r=an(t.prototype),n=t.apply(r,n);return Ie(n)?n:r}}function vr(t,n,e){function u(){for(var i=arguments.length,f=Array(i),c=i,a=Br(u);c--;)f[c]=arguments[c];return c=3>i&&f[0]!==a&&f[i-1]!==a?[]:F(f,a),i-=c.length,e>i?wr(t,n,dr,u.placeholder,T,f,c,T,T,e-i):r(this&&this!==Jt&&this instanceof u?o:t,this,f);
}var o=_r(t);return u}function gr(t){return de(function(n){n=_n(n,1);var r=n.length,e=r,u=Ot.prototype.thru;for(t&&n.reverse();e--;){var o=n[e];if(typeof o!="function")throw new su("Expected a function");if(u&&!i&&"wrapper"==Ir(o))var i=new Ot([],true)}for(e=i?e:r;++e<r;)var o=n[e],u=Ir(o),f="wrapper"==u?po(o):T,i=f&&Zr(f[0])&&424==f[1]&&!f[4].length&&1==f[9]?i[Ir(f[0])].apply(i,f[3]):1==o.length&&Zr(o)?i[u]():i.thru(o);return function(){var t=arguments,e=t[0];if(i&&1==t.length&&Qo(e)&&e.length>=200)return i.plant(e).value();
for(var u=0,t=r?n[u].apply(this,t):e;++u<r;)t=n[u].call(this,t);return t}})}function dr(t,n,r,e,u,o,i,f,c,a){function l(){for(var d=arguments.length,y=d,b=Array(d);y--;)b[y]=arguments[y];if(_){var x,j=Br(l),y=b.length;for(x=0;y--;)b[y]===j&&x++}if(e&&(b=nr(b,e,u,_)),o&&(b=rr(b,o,i,_)),d-=x,_&&a>d)return j=F(b,j),wr(t,n,dr,l.placeholder,r,b,j,f,c,a-d);if(j=h?r:this,y=p?j[t]:t,d=b.length,f){x=b.length;for(var m=Fu(f.length,x),w=er(b);m--;){var A=f[m];b[m]=L(A,x)?w[A]:T}}else v&&d>1&&b.reverse();return s&&d>c&&(b.length=c),
this&&this!==Jt&&this instanceof l&&(y=g||_r(y)),y.apply(j,b)}var s=128&n,h=1&n,p=2&n,_=24&n,v=512&n,g=p?T:_r(t);return l}function yr(t,n){return function(r,e){return wn(r,t,n(e))}}function br(t){return de(function(n){return n=a(_n(n,1),Sr()),de(function(e){var u=this;return t(n,function(t){return r(t,u,e)})})})}function xr(t,n){n=n===T?" ":n+"";var r=n.length;return 2>r?r?Nn(n,t):n:(r=Nn(n,Cu(t/P(n))),St.test(n)?r.match(It).slice(0,t).join(""):r.slice(0,t))}function jr(t,n,e,u){function o(){for(var n=-1,c=arguments.length,a=-1,l=u.length,s=Array(l+c),h=this&&this!==Jt&&this instanceof o?f:t;++a<l;)s[a]=u[a];
for(;c--;)s[a++]=arguments[++n];return r(h,i?e:this,s)}var i=1&n,f=_r(t);return o}function mr(t){return function(n,r,e){e&&typeof e!="number"&&Fr(n,r,e)&&(r=e=T),n=Ne(n),n=n===n?n:0,r===T?(r=n,n=0):r=Ne(r)||0,e=e===T?r>n?1:-1:Ne(e)||0;var u=-1;r=Du(Cu((r-n)/(e||1)),0);for(var o=Array(r);r--;)o[t?r:++u]=n,n+=e;return o}}function wr(t,n,r,e,u,o,i,f,c,a){var l=8&n;f=f?er(f):T;var s=l?i:T;i=l?T:i;var h=l?o:T;return o=l?T:o,n=(n|(l?32:64))&~(l?64:32),4&n||(n&=-4),n=[t,n,u,h,s,o,i,f,c,a],r=r.apply(T,n),
Zr(t)&&go(r,n),r.placeholder=e,r}function Ar(t){var n=au[t];return function(t,r){if(t=Ne(t),r=De(r)){var e=(Ze(t)+"e").split("e"),e=n(e[0]+"e"+(+e[1]+r)),e=(Ze(e)+"e").split("e");return+(e[0]+"e"+(+e[1]-r))}return n(t)}}function Or(t,n,r,e,u,o,i,f){var c=2&n;if(!c&&typeof t!="function")throw new su("Expected a function");var a=e?e.length:0;if(a||(n&=-97,e=u=T),i=i===T?i:Du(De(i),0),f=f===T?f:De(f),a-=u?u.length:0,64&n){var l=e,s=u;e=u=T}var h=c?T:po(t);return o=[t,n,r,e,u,l,s,o,i,f],h&&(r=o[1],t=h[1],
n=r|t,e=128==t&&8==r||128==t&&256==r&&h[8]>=o[7].length||384==t&&h[8]>=h[7].length&&8==r,131>n||e)&&(1&t&&(o[2]=h[2],n|=1&r?0:4),(r=h[3])&&(e=o[3],o[3]=e?nr(e,r,h[4]):er(r),o[4]=e?F(o[3],"__lodash_placeholder__"):er(h[4])),(r=h[5])&&(e=o[5],o[5]=e?rr(e,r,h[6]):er(r),o[6]=e?F(o[5],"__lodash_placeholder__"):er(h[6])),(r=h[7])&&(o[7]=er(r)),128&t&&(o[8]=null==o[8]?h[8]:Fu(o[8],h[8])),null==o[9]&&(o[9]=h[9]),o[0]=h[0],o[1]=n),t=o[0],n=o[1],r=o[2],e=o[3],u=o[4],f=o[9]=null==o[9]?c?0:t.length:Du(o[9]-a,0),
!f&&24&n&&(n&=-25),(h?so:go)(n&&1!=n?8==n||16==n?vr(t,n,f):32!=n&&33!=n||u.length?dr.apply(T,o):jr(t,n,r,e):sr(t,n,r),o)}function kr(t,n,r,e,u,o){var i=-1,f=2&u,c=1&u,a=t.length,l=n.length;if(!(a==l||f&&l>a))return false;if(l=o.get(t))return l==n;for(l=true,o.set(t,n);++i<a;){var s=t[i],h=n[i];if(e)var _=f?e(h,s,i,n,t,o):e(s,h,i,t,n,o);if(_!==T){if(_)continue;l=false;break}if(c){if(!p(n,function(t){return s===t||r(s,t,e,u,o)})){l=false;break}}else if(s!==h&&!r(s,h,e,u,o)){l=false;break}}return o["delete"](t),l}
function Er(t,n,r,e,u,o,i){switch(r){case"[object DataView]":if(t.byteLength!=n.byteLength||t.byteOffset!=n.byteOffset)break;t=t.buffer,n=n.buffer;case"[object ArrayBuffer]":if(t.byteLength!=n.byteLength||!e(new Au(t),new Au(n)))break;return true;case"[object Boolean]":case"[object Date]":return+t==+n;case"[object Error]":return t.name==n.name&&t.message==n.message;case"[object Number]":return t!=+t?n!=+n:t==+n;case"[object RegExp]":case"[object String]":return t==n+"";case"[object Map]":var f=D;case"[object Set]":
if(f||(f=N),t.size!=n.size&&!(2&o))break;return(r=i.get(t))?r==n:(o|=1,i.set(t,n),kr(f(t),f(n),e,u,o,i));case"[object Symbol]":if(oo)return oo.call(t)==oo.call(n)}return false}function Ir(t){for(var n=t.name+"",r=Qu[n],e=vu.call(Qu,n)?r.length:0;e--;){var u=r[e],o=u.func;if(null==o||o==t)return u.name}return n}function Sr(){var t=xt.iteratee||eu,t=t===eu?En:t;return arguments.length?t(arguments[0],arguments[1]):t}function Rr(t){t=Je(t);for(var n=t.length;n--;){var r=t[n][1];t[n][2]=r===r&&!Ie(r)}return t;
}function Wr(t,n){var r=t[n];return Re(r)?r:T}function Br(t){return(vu.call(xt,"placeholder")?xt:t).placeholder}function Cr(t){return Eu(Object(t))}function zr(t){return yu.call(t)}function Ur(t,n,r){n=Nr(n,t)?[n]:un(n);for(var e,u=-1,o=n.length;++u<o;){var i=n[u];if(!(e=null!=t&&r(t,i)))break;t=t[i]}return e?e:(o=t?t.length:0,!!o&&Ee(o)&&L(i,o)&&(Qo(t)||ze(t)||je(t)))}function Mr(t){var n=t.length,r=t.constructor(n);return n&&"string"==typeof t[0]&&vu.call(t,"index")&&(r.index=t.index,r.input=t.input),
r}function Lr(t){return typeof t.constructor!="function"||qr(t)?{}:an(Uu(Object(t)))}function $r(r,e,u,o){var i=r.constructor;switch(e){case"[object ArrayBuffer]":return tr(r);case"[object Boolean]":case"[object Date]":return new i(+r);case"[object DataView]":return e=o?tr(r.buffer):r.buffer,new r.constructor(e,r.byteOffset,r.byteLength);case"[object Float32Array]":case"[object Float64Array]":case"[object Int8Array]":case"[object Int16Array]":case"[object Int32Array]":case"[object Uint8Array]":case"[object Uint8ClampedArray]":
case"[object Uint16Array]":case"[object Uint32Array]":return e=o?tr(r.buffer):r.buffer,new r.constructor(e,r.byteOffset,r.length);case"[object Map]":return e=o?u(D(r),true):D(r),s(e,t,new r.constructor);case"[object Number]":case"[object String]":return new i(r);case"[object RegExp]":return e=new r.constructor(r.source,_t.exec(r)),e.lastIndex=r.lastIndex,e;case"[object Set]":return e=o?u(N(r),true):N(r),s(e,n,new r.constructor);case"[object Symbol]":return oo?Object(oo.call(r)):{}}}function Dr(t){var n=t?t.length:T;
return Ee(n)&&(Qo(t)||ze(t)||je(t))?w(n,String):null}function Fr(t,n,r){if(!Ie(r))return false;var e=typeof n;return("number"==e?me(r)&&L(n,r.length):"string"==e&&n in r)?be(r[n],t):false}function Nr(t,n){var r=typeof t;return"number"==r||"symbol"==r?true:!Qo(t)&&(Ue(t)||ot.test(t)||!ut.test(t)||null!=n&&t in Object(n))}function Pr(t){var n=typeof t;return"number"==n||"boolean"==n||"string"==n&&"__proto__"!=t||null==t}function Zr(t){var n=Ir(t),r=xt[n];return typeof r=="function"&&n in kt.prototype?t===r?true:(n=po(r),
!!n&&t===n[0]):false}function qr(t){var n=t&&t.constructor;return t===(typeof n=="function"&&n.prototype||pu)}function Tr(t,n){return function(r){return null==r?false:r[t]===n&&(n!==T||t in Object(r))}}function Vr(t,n,r,e,u,o){return Ie(t)&&Ie(n)&&Bn(t,n,T,Vr,o.set(n,t)),t}function Kr(t,n){return 1==n.length?t:yn(t,Zn(n,0,-1))}function Gr(t){if(Oe(t))try{return _u.call(t)}catch(n){}return Ze(t)}function Jr(t){if(t instanceof kt)return t.clone();var n=new Ot(t.__wrapped__,t.__chain__);return n.__actions__=er(t.__actions__),
n.__index__=t.__index__,n.__values__=t.__values__,n}function Yr(t,n,r){var e=t?t.length:0;return e?(n=r||n===T?1:De(n),Zn(t,0>n?0:n,e)):[]}function Hr(t,n,r){var e=t?t.length:0;return e?(n=r||n===T?1:De(n),n=e-n,Zn(t,0,0>n?0:n)):[]}function Qr(t){return t?t[0]:T}function Xr(t){var n=t?t.length:0;return n?t[n-1]:T}function te(t,n){return t&&t.length&&n&&n.length?$n(t,n):t}function ne(t){return t?Zu.call(t):t}function re(t){if(!t||!t.length)return[];var n=0;return t=i(t,function(t){return we(t)?(n=Du(t.length,n),
!0):void 0}),w(n,function(n){return a(t,Mn(n))})}function ee(t,n){if(!t||!t.length)return[];var e=re(t);return null==n?e:a(e,function(t){return r(n,T,t)})}function ue(t){return t=xt(t),t.__chain__=true,t}function oe(t,n){return n(t)}function ie(){return this}function fe(t,n){return typeof n=="function"&&Qo(t)?u(t,n):fo(t,Sr(n))}function ce(t,n){var r;if(typeof n=="function"&&Qo(t)){for(r=t.length;r--&&false!==n(t[r],r,t););r=t}else r=co(t,Sr(n));return r}function ae(t,n){return(Qo(t)?a:Sn)(t,Sr(n,3))}function le(t,n,r){
var e=-1,u=$e(t),o=u.length,i=o-1;for(n=(r?Fr(t,n,r):n===T)?1:on(De(n),0,o);++e<n;)t=Fn(e,i),r=u[t],u[t]=u[e],u[e]=r;return u.length=n,u}function se(t,n,r){return n=r?T:n,n=t&&null==n?t.length:n,Or(t,128,T,T,T,T,n)}function he(t,n){var r;if(typeof n!="function")throw new su("Expected a function");return t=De(t),function(){return 0<--t&&(r=n.apply(this,arguments)),1>=t&&(n=T),r}}function pe(t,n,r){return n=r?T:n,t=Or(t,8,T,T,T,T,T,n),t.placeholder=pe.placeholder,t}function _e(t,n,r){return n=r?T:n,
t=Or(t,16,T,T,T,T,T,n),t.placeholder=_e.placeholder,t}function ve(t,n,r){function e(n){var r=c,e=a;return c=a=T,p=n,l=t.apply(e,r)}function u(t){var r=t-h;return t-=p,!h||r>=n||0>r||false!==v&&t>=v}function o(){var t=Zo();if(u(t))return i(t);var r;r=t-p,t=n-(t-h),r=false===v?t:Fu(t,v-r),s=Wu(o,r)}function i(t){return Ou(s),s=T,g&&c?e(t):(c=a=T,l)}function f(){var t=Zo(),r=u(t);return c=arguments,a=this,h=t,r?s===T?(p=t=h,s=Wu(o,n),_?e(t):l):(Ou(s),s=Wu(o,n),e(h)):l}var c,a,l,s,h=0,p=0,_=false,v=false,g=true;if(typeof t!="function")throw new su("Expected a function");
return n=Ne(n)||0,Ie(r)&&(_=!!r.leading,v="maxWait"in r&&Du(Ne(r.maxWait)||0,n),g="trailing"in r?!!r.trailing:g),f.cancel=function(){s!==T&&Ou(s),h=p=0,c=a=s=T},f.flush=function(){return s===T?l:i(Zo())},f}function ge(t,n){function r(){var e=arguments,u=n?n.apply(this,e):e[0],o=r.cache;return o.has(u)?o.get(u):(e=t.apply(this,e),r.cache=o.set(u,e),e)}if(typeof t!="function"||n&&typeof n!="function")throw new su("Expected a function");return r.cache=new(ge.Cache||Lt),r}function de(t,n){if(typeof t!="function")throw new su("Expected a function");
return n=Du(n===T?t.length-1:De(n),0),function(){for(var e=arguments,u=-1,o=Du(e.length-n,0),i=Array(o);++u<o;)i[u]=e[n+u];switch(n){case 0:return t.call(this,i);case 1:return t.call(this,e[0],i);case 2:return t.call(this,e[0],e[1],i)}for(o=Array(n+1),u=-1;++u<n;)o[u]=e[u];return o[n]=i,r(t,this,o)}}function ye(){if(!arguments.length)return[];var t=arguments[0];return Qo(t)?t:[t]}function be(t,n){return t===n||t!==t&&n!==n}function xe(t,n){return t>n}function je(t){return we(t)&&vu.call(t,"callee")&&(!Ru.call(t,"callee")||"[object Arguments]"==yu.call(t));
}function me(t){return null!=t&&Ee(_o(t))&&!Oe(t)}function we(t){return Se(t)&&me(t)}function Ae(t){return Se(t)?"[object Error]"==yu.call(t)||typeof t.message=="string"&&typeof t.name=="string":false}function Oe(t){return t=Ie(t)?yu.call(t):"","[object Function]"==t||"[object GeneratorFunction]"==t}function ke(t){return typeof t=="number"&&t==De(t)}function Ee(t){return typeof t=="number"&&t>-1&&0==t%1&&9007199254740991>=t}function Ie(t){var n=typeof t;return!!t&&("object"==n||"function"==n)}function Se(t){
return!!t&&typeof t=="object"}function Re(t){return Ie(t)?(Oe(t)||M(t)?xu:yt).test(Gr(t)):false}function We(t){return typeof t=="number"||Se(t)&&"[object Number]"==yu.call(t)}function Be(t){return!Se(t)||"[object Object]"!=yu.call(t)||M(t)?false:(t=Uu(Object(t)),null===t?true:(t=vu.call(t,"constructor")&&t.constructor,typeof t=="function"&&t instanceof t&&_u.call(t)==du))}function Ce(t){return Ie(t)&&"[object RegExp]"==yu.call(t)}function ze(t){return typeof t=="string"||!Qo(t)&&Se(t)&&"[object String]"==yu.call(t);
}function Ue(t){return typeof t=="symbol"||Se(t)&&"[object Symbol]"==yu.call(t)}function Me(t){return Se(t)&&Ee(t.length)&&!!zt[yu.call(t)]}function Le(t,n){return n>t}function $e(t){if(!t)return[];if(me(t))return ze(t)?t.match(It):er(t);if(Iu&&t[Iu])return $(t[Iu]());var n=zr(t);return("[object Map]"==n?D:"[object Set]"==n?N:He)(t)}function De(t){if(!t)return 0===t?t:0;if(t=Ne(t),t===V||t===-V)return 1.7976931348623157e308*(0>t?-1:1);var n=t%1;return t===t?n?t-n:t:0}function Fe(t){return t?on(De(t),0,4294967295):0;
}function Ne(t){if(typeof t=="number")return t;if(Ue(t))return K;if(Ie(t)&&(t=Oe(t.valueOf)?t.valueOf():t,t=Ie(t)?t+"":t),typeof t!="string")return 0===t?t:+t;t=t.replace(at,"");var n=dt.test(t);return n||bt.test(t)?Pt(t.slice(2),n?2:8):gt.test(t)?K:+t}function Pe(t){return ur(t,Ge(t))}function Ze(t){if(typeof t=="string")return t;if(null==t)return"";if(Ue(t))return io?io.call(t):"";var n=t+"";return"0"==n&&1/t==-V?"-0":n}function qe(t,n,r){return t=null==t?T:yn(t,n),t===T?r:t}function Te(t,n){return null!=t&&Ur(t,n,xn);
}function Ve(t,n){return null!=t&&Ur(t,n,jn)}function Ke(t){var n=qr(t);if(!n&&!me(t))return $u(Object(t));var r,e=Dr(t),u=!!e,e=e||[],o=e.length;for(r in t)!xn(t,r)||u&&("length"==r||L(r,o))||n&&"constructor"==r||e.push(r);return e}function Ge(t){for(var n=-1,r=qr(t),e=In(t),u=e.length,o=Dr(t),i=!!o,o=o||[],f=o.length;++n<u;){var c=e[n];i&&("length"==c||L(c,f))||"constructor"==c&&(r||!vu.call(t,c))||o.push(c)}return o}function Je(t){return A(t,Ke(t))}function Ye(t){return A(t,Ge(t))}function He(t){
return t?k(t,Ke(t)):[]}function Qe(t){return ji(Ze(t).toLowerCase())}function Xe(t){return(t=Ze(t))&&t.replace(jt,B).replace(Et,"")}function tu(t,n,r){return t=Ze(t),n=r?T:n,n===T&&(n=Bt.test(t)?Wt:Rt),t.match(n)||[]}function nu(t){return function(){return t}}function ru(t){return t}function eu(t){return En(typeof t=="function"?t:fn(t,true))}function uu(t,n,r){var e=Ke(n),o=dn(n,e);null!=r||Ie(n)&&(o.length||!e.length)||(r=n,n=t,t=this,o=dn(n,Ke(n)));var i=Ie(r)&&"chain"in r?r.chain:true,f=Oe(t);return u(o,function(r){
var e=n[r];t[r]=e,f&&(t.prototype[r]=function(){var n=this.__chain__;if(i||n){var r=t(this.__wrapped__);return(r.__actions__=er(this.__actions__)).push({func:e,args:arguments,thisArg:t}),r.__chain__=n,r}return e.apply(t,l([this.value()],arguments))})}),t}function ou(){}function iu(t){return Nr(t)?Mn(t):Ln(t)}S=S?Yt.defaults({},S,Yt.pick(Jt,Ct)):Jt;var fu=S.Date,cu=S.Error,au=S.Math,lu=S.RegExp,su=S.TypeError,hu=S.Array.prototype,pu=S.Object.prototype,_u=S.Function.prototype.toString,vu=pu.hasOwnProperty,gu=0,du=_u.call(Object),yu=pu.toString,bu=Jt._,xu=lu("^"+_u.call(vu).replace(ft,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),ju=Tt?S.Buffer:T,mu=S.Reflect,wu=S.Symbol,Au=S.Uint8Array,Ou=S.clearTimeout,ku=mu?mu.f:T,Eu=Object.getOwnPropertySymbols,Iu=typeof(Iu=wu&&wu.iterator)=="symbol"?Iu:T,Su=Object.create,Ru=pu.propertyIsEnumerable,Wu=S.setTimeout,Bu=hu.splice,Cu=au.ceil,zu=au.floor,Uu=Object.getPrototypeOf,Mu=S.isFinite,Lu=hu.join,$u=Object.keys,Du=au.max,Fu=au.min,Nu=S.parseInt,Pu=au.random,Zu=hu.reverse,qu=Wr(S,"DataView"),Tu=Wr(S,"Map"),Vu=Wr(S,"Promise"),Ku=Wr(S,"Set"),Gu=Wr(S,"WeakMap"),Ju=Wr(Object,"create"),Yu=Gu&&new Gu,Hu=!Ru.call({
valueOf:1},"valueOf"),Qu={},Xu=Gr(qu),to=Gr(Tu),no=Gr(Vu),ro=Gr(Ku),eo=Gr(Gu),uo=wu?wu.prototype:T,oo=uo?uo.valueOf:T,io=uo?uo.toString:T;xt.templateSettings={escape:nt,evaluate:rt,interpolate:et,variable:"",imports:{_:xt}},xt.prototype=At.prototype,xt.prototype.constructor=xt,Ot.prototype=an(At.prototype),Ot.prototype.constructor=Ot,kt.prototype=an(At.prototype),kt.prototype.constructor=kt,Mt.prototype=Ju?Ju(null):pu,Lt.prototype.clear=function(){this.__data__={hash:new Mt,map:Tu?new Tu:[],string:new Mt
}},Lt.prototype["delete"]=function(t){var n=this.__data__;return Pr(t)?(n=typeof t=="string"?n.string:n.hash,t=(Ju?n[t]!==T:vu.call(n,t))&&delete n[t]):t=Tu?n.map["delete"](t):Zt(n.map,t),t},Lt.prototype.get=function(t){var n=this.__data__;return Pr(t)?(n=typeof t=="string"?n.string:n.hash,Ju?(t=n[t],t="__lodash_hash_undefined__"===t?T:t):t=vu.call(n,t)?n[t]:T):t=Tu?n.map.get(t):qt(n.map,t),t},Lt.prototype.has=function(t){var n=this.__data__;return Pr(t)?(n=typeof t=="string"?n.string:n.hash,t=Ju?n[t]!==T:vu.call(n,t)):t=Tu?n.map.has(t):-1<Vt(n.map,t),
t},Lt.prototype.set=function(t,n){var r=this.__data__;return Pr(t)?(typeof t=="string"?r.string:r.hash)[t]=Ju&&n===T?"__lodash_hash_undefined__":n:Tu?r.map.set(t,n):Kt(r.map,t,n),this},$t.prototype.push=function(t){var n=this.__data__;Pr(t)?(n=n.__data__,(typeof t=="string"?n.string:n.hash)[t]="__lodash_hash_undefined__"):n.set(t,"__lodash_hash_undefined__")},Ft.prototype.clear=function(){this.__data__={array:[],map:null}},Ft.prototype["delete"]=function(t){var n=this.__data__,r=n.array;return r?Zt(r,t):n.map["delete"](t);
},Ft.prototype.get=function(t){var n=this.__data__,r=n.array;return r?qt(r,t):n.map.get(t)},Ft.prototype.has=function(t){var n=this.__data__,r=n.array;return r?-1<Vt(r,t):n.map.has(t)},Ft.prototype.set=function(t,n){var r=this.__data__,e=r.array;return e&&(199>e.length?Kt(e,t,n):(r.array=null,r.map=new Lt(e))),(r=r.map)&&r.set(t,n),this};var fo=ar(vn),co=ar(gn,true),ao=lr(),lo=lr(true);ku&&!Ru.call({valueOf:1},"valueOf")&&(In=function(t){return $(ku(t))});var so=Yu?function(t,n){return Yu.set(t,n),t}:ru,ho=Ku&&2===new Ku([1,2]).size?function(t){
return new Ku(t)}:ou,po=Yu?function(t){return Yu.get(t)}:ou,_o=Mn("length");Eu||(Cr=function(){return[]});var vo=Eu?function(t){for(var n=[];t;)l(n,Cr(t)),t=Uu(Object(t));return n}:Cr;(qu&&"[object DataView]"!=zr(new qu(new ArrayBuffer(1)))||Tu&&"[object Map]"!=zr(new Tu)||Vu&&"[object Promise]"!=zr(Vu.resolve())||Ku&&"[object Set]"!=zr(new Ku)||Gu&&"[object WeakMap]"!=zr(new Gu))&&(zr=function(t){var n=yu.call(t);if(t=Gr("[object Object]"==n?t.constructor:null))switch(t){case Xu:return"[object DataView]";
case to:return"[object Map]";case no:return"[object Promise]";case ro:return"[object Set]";case eo:return"[object WeakMap]"}return n});var go=function(){var t=0,n=0;return function(r,e){var u=Zo(),o=16-(u-n);if(n=u,o>0){if(150<=++t)return r}else t=0;return so(r,e)}}(),yo=ge(function(t){var n=[];return Ze(t).replace(it,function(t,r,e,u){n.push(e?u.replace(ht,"$1"):r||t)}),n}),bo=de(function(t,n){return we(t)?sn(t,_n(n,1,true)):[]}),xo=de(function(t,n){var r=Xr(n);return we(r)&&(r=T),we(t)?sn(t,_n(n,1,true),Sr(r)):[];
}),jo=de(function(t,n){var r=Xr(n);return we(r)&&(r=T),we(t)?sn(t,_n(n,1,true),T,r):[]}),mo=de(function(t){var n=a(t,rn);return n.length&&n[0]===t[0]?mn(n):[]}),wo=de(function(t){var n=Xr(t),r=a(t,rn);return n===Xr(r)?n=T:r.pop(),r.length&&r[0]===t[0]?mn(r,Sr(n)):[]}),Ao=de(function(t){var n=Xr(t),r=a(t,rn);return n===Xr(r)?n=T:r.pop(),r.length&&r[0]===t[0]?mn(r,T,n):[]}),Oo=de(te),ko=de(function(t,n){n=a(_n(n,1),String);var r=nn(t,n);return Dn(t,n.sort(R)),r}),Eo=de(function(t){return Gn(_n(t,1,true));
}),Io=de(function(t){var n=Xr(t);return we(n)&&(n=T),Gn(_n(t,1,true),Sr(n))}),So=de(function(t){var n=Xr(t);return we(n)&&(n=T),Gn(_n(t,1,true),T,n)}),Ro=de(function(t,n){return we(t)?sn(t,n):[]}),Wo=de(function(t){return Hn(i(t,we))}),Bo=de(function(t){var n=Xr(t);return we(n)&&(n=T),Hn(i(t,we),Sr(n))}),Co=de(function(t){var n=Xr(t);return we(n)&&(n=T),Hn(i(t,we),T,n)}),zo=de(re),Uo=de(function(t){var n=t.length,n=n>1?t[n-1]:T,n=typeof n=="function"?(t.pop(),n):T;return ee(t,n)}),Mo=de(function(t){function n(n){
return nn(n,t)}t=_n(t,1);var r=t.length,e=r?t[0]:0,u=this.__wrapped__;return 1>=r&&!this.__actions__.length&&u instanceof kt&&L(e)?(u=u.slice(e,+e+(r?1:0)),u.__actions__.push({func:oe,args:[n],thisArg:T}),new Ot(u,this.__chain__).thru(function(t){return r&&!t.length&&t.push(T),t})):this.thru(n)}),Lo=fr(function(t,n,r){vu.call(t,r)?++t[r]:t[r]=1}),$o=fr(function(t,n,r){vu.call(t,r)?t[r].push(n):t[r]=[n]}),Do=de(function(t,n,e){var u=-1,o=typeof n=="function",i=Nr(n),f=me(t)?Array(t.length):[];return fo(t,function(t){
var c=o?n:i&&null!=t?t[n]:T;f[++u]=c?r(c,t,e):An(t,n,e)}),f}),Fo=fr(function(t,n,r){t[r]=n}),No=fr(function(t,n,r){t[r?0:1].push(n)},function(){return[[],[]]}),Po=de(function(t,n){if(null==t)return[];var r=n.length;return r>1&&Fr(t,n[0],n[1])?n=[]:r>2&&Fr(n[0],n[1],n[2])&&(n.length=1),Cn(t,_n(n,1),[])}),Zo=fu.now,qo=de(function(t,n,r){var e=1;if(r.length)var u=F(r,Br(qo)),e=32|e;return Or(t,e,n,r,u)}),To=de(function(t,n,r){var e=3;if(r.length)var u=F(r,Br(To)),e=32|e;return Or(n,e,t,r,u)}),Vo=de(function(t,n){
return ln(t,1,n)}),Ko=de(function(t,n,r){return ln(t,Ne(n)||0,r)});ge.Cache=Lt;var Go=de(function(t,n){n=a(_n(n,1),Sr());var e=n.length;return de(function(u){for(var o=-1,i=Fu(u.length,e);++o<i;)u[o]=n[o].call(this,u[o]);return r(t,this,u)})}),Jo=de(function(t,n){var r=F(n,Br(Jo));return Or(t,32,T,n,r)}),Yo=de(function(t,n){var r=F(n,Br(Yo));return Or(t,64,T,n,r)}),Ho=de(function(t,n){return Or(t,256,T,T,T,_n(n,1))}),Qo=Array.isArray,Xo=ju?function(t){return t instanceof ju}:nu(false),ti=cr(function(t,n){
if(Hu||qr(n)||me(n))ur(n,Ke(n),t);else for(var r in n)vu.call(n,r)&&Qt(t,r,n[r])}),ni=cr(function(t,n){if(Hu||qr(n)||me(n))ur(n,Ge(n),t);else for(var r in n)Qt(t,r,n[r])}),ri=cr(function(t,n,r,e){or(n,Ge(n),t,e)}),ei=cr(function(t,n,r,e){or(n,Ke(n),t,e)}),ui=de(function(t,n){return nn(t,_n(n,1))}),oi=de(function(t){return t.push(T,Gt),r(ri,T,t)}),ii=de(function(t){return t.push(T,Vr),r(si,T,t)}),fi=yr(function(t,n,r){t[n]=r},nu(ru)),ci=yr(function(t,n,r){vu.call(t,n)?t[n].push(r):t[n]=[r]},Sr),ai=de(An),li=cr(function(t,n,r){
Bn(t,n,r)}),si=cr(function(t,n,r,e){Bn(t,n,r,e)}),hi=de(function(t,n){return null==t?{}:(n=a(_n(n,1),en),zn(t,sn(bn(t,Ge,vo),n)))}),pi=de(function(t,n){return null==t?{}:zn(t,_n(n,1))}),_i=pr(function(t,n,r){return n=n.toLowerCase(),t+(r?Qe(n):n)}),vi=pr(function(t,n,r){return t+(r?"-":"")+n.toLowerCase()}),gi=pr(function(t,n,r){return t+(r?" ":"")+n.toLowerCase()}),di=hr("toLowerCase"),yi=pr(function(t,n,r){return t+(r?"_":"")+n.toLowerCase()}),bi=pr(function(t,n,r){return t+(r?" ":"")+ji(n)}),xi=pr(function(t,n,r){
return t+(r?" ":"")+n.toUpperCase()}),ji=hr("toUpperCase"),mi=de(function(t,n){try{return r(t,T,n)}catch(e){return Ae(e)?e:new cu(e)}}),wi=de(function(t,n){return u(_n(n,1),function(n){t[n]=qo(t[n],t)}),t}),Ai=gr(),Oi=gr(true),ki=de(function(t,n){return function(r){return An(r,t,n)}}),Ei=de(function(t,n){return function(r){return An(t,r,n)}}),Ii=br(a),Si=br(o),Ri=br(p),Wi=mr(),Bi=mr(true),Ci=W(function(t,n){return t+n}),zi=Ar("ceil"),Ui=W(function(t,n){return t/n}),Mi=Ar("floor"),Li=W(function(t,n){return t*n;
}),$i=Ar("round"),Di=W(function(t,n){return t-n});return xt.after=function(t,n){if(typeof n!="function")throw new su("Expected a function");return t=De(t),function(){return 1>--t?n.apply(this,arguments):void 0}},xt.ary=se,xt.assign=ti,xt.assignIn=ni,xt.assignInWith=ri,xt.assignWith=ei,xt.at=ui,xt.before=he,xt.bind=qo,xt.bindAll=wi,xt.bindKey=To,xt.castArray=ye,xt.chain=ue,xt.chunk=function(t,n,r){if(n=(r?Fr(t,n,r):n===T)?1:Du(De(n),0),r=t?t.length:0,!r||1>n)return[];for(var e=0,u=0,o=Array(Cu(r/n));r>e;)o[u++]=Zn(t,e,e+=n);
return o},xt.compact=function(t){for(var n=-1,r=t?t.length:0,e=0,u=[];++n<r;){var o=t[n];o&&(u[e++]=o)}return u},xt.concat=function(){var t=arguments.length,n=ye(arguments[0]);if(2>t)return t?er(n):[];for(var r=Array(t-1);t--;)r[t-1]=arguments[t];for(var t=_n(r,1),r=-1,e=n.length,u=-1,o=t.length,i=Array(e+o);++r<e;)i[r]=n[r];for(;++u<o;)i[r++]=t[u];return i},xt.cond=function(t){var n=t?t.length:0,e=Sr();return t=n?a(t,function(t){if("function"!=typeof t[1])throw new su("Expected a function");return[e(t[0]),t[1]];
}):[],de(function(e){for(var u=-1;++u<n;){var o=t[u];if(r(o[0],this,e))return r(o[1],this,e)}})},xt.conforms=function(t){return cn(fn(t,true))},xt.constant=nu,xt.countBy=Lo,xt.create=function(t,n){var r=an(t);return n?tn(r,n):r},xt.curry=pe,xt.curryRight=_e,xt.debounce=ve,xt.defaults=oi,xt.defaultsDeep=ii,xt.defer=Vo,xt.delay=Ko,xt.difference=bo,xt.differenceBy=xo,xt.differenceWith=jo,xt.drop=Yr,xt.dropRight=Hr,xt.dropRightWhile=function(t,n){return t&&t.length?Jn(t,Sr(n,3),true,true):[]},xt.dropWhile=function(t,n){
return t&&t.length?Jn(t,Sr(n,3),true):[]},xt.fill=function(t,n,r,e){var u=t?t.length:0;if(!u)return[];for(r&&typeof r!="number"&&Fr(t,n,r)&&(r=0,e=u),u=t.length,r=De(r),0>r&&(r=-r>u?0:u+r),e=e===T||e>u?u:De(e),0>e&&(e+=u),e=r>e?0:Fe(e);e>r;)t[r++]=n;return t},xt.filter=function(t,n){return(Qo(t)?i:pn)(t,Sr(n,3))},xt.flatMap=function(t,n){return _n(ae(t,n),1)},xt.flatMapDeep=function(t,n){return _n(ae(t,n),V)},xt.flatMapDepth=function(t,n,r){return r=r===T?1:De(r),_n(ae(t,n),r)},xt.flatten=function(t){
return t&&t.length?_n(t,1):[]},xt.flattenDeep=function(t){return t&&t.length?_n(t,V):[]},xt.flattenDepth=function(t,n){return t&&t.length?(n=n===T?1:De(n),_n(t,n)):[]},xt.flip=function(t){return Or(t,512)},xt.flow=Ai,xt.flowRight=Oi,xt.fromPairs=function(t){for(var n=-1,r=t?t.length:0,e={};++n<r;){var u=t[n];e[u[0]]=u[1]}return e},xt.functions=function(t){return null==t?[]:dn(t,Ke(t))},xt.functionsIn=function(t){return null==t?[]:dn(t,Ge(t))},xt.groupBy=$o,xt.initial=function(t){return Hr(t,1)},xt.intersection=mo,
xt.intersectionBy=wo,xt.intersectionWith=Ao,xt.invert=fi,xt.invertBy=ci,xt.invokeMap=Do,xt.iteratee=eu,xt.keyBy=Fo,xt.keys=Ke,xt.keysIn=Ge,xt.map=ae,xt.mapKeys=function(t,n){var r={};return n=Sr(n,3),vn(t,function(t,e,u){r[n(t,e,u)]=t}),r},xt.mapValues=function(t,n){var r={};return n=Sr(n,3),vn(t,function(t,e,u){r[e]=n(t,e,u)}),r},xt.matches=function(t){return Rn(fn(t,true))},xt.matchesProperty=function(t,n){return Wn(t,fn(n,true))},xt.memoize=ge,xt.merge=li,xt.mergeWith=si,xt.method=ki,xt.methodOf=Ei,
xt.mixin=uu,xt.negate=function(t){if(typeof t!="function")throw new su("Expected a function");return function(){return!t.apply(this,arguments)}},xt.nthArg=function(t){return t=De(t),function(){return arguments[t]}},xt.omit=hi,xt.omitBy=function(t,n){return n=Sr(n),Un(t,function(t,r){return!n(t,r)})},xt.once=function(t){return he(2,t)},xt.orderBy=function(t,n,r,e){return null==t?[]:(Qo(n)||(n=null==n?[]:[n]),r=e?T:r,Qo(r)||(r=null==r?[]:[r]),Cn(t,n,r))},xt.over=Ii,xt.overArgs=Go,xt.overEvery=Si,xt.overSome=Ri,
xt.partial=Jo,xt.partialRight=Yo,xt.partition=No,xt.pick=pi,xt.pickBy=function(t,n){return null==t?{}:Un(t,Sr(n))},xt.property=iu,xt.propertyOf=function(t){return function(n){return null==t?T:yn(t,n)}},xt.pull=Oo,xt.pullAll=te,xt.pullAllBy=function(t,n,r){return t&&t.length&&n&&n.length?$n(t,n,Sr(r)):t},xt.pullAllWith=function(t,n,r){return t&&t.length&&n&&n.length?$n(t,n,T,r):t},xt.pullAt=ko,xt.range=Wi,xt.rangeRight=Bi,xt.rearg=Ho,xt.reject=function(t,n){var r=Qo(t)?i:pn;return n=Sr(n,3),r(t,function(t,r,e){
return!n(t,r,e)})},xt.remove=function(t,n){var r=[];if(!t||!t.length)return r;var e=-1,u=[],o=t.length;for(n=Sr(n,3);++e<o;){var i=t[e];n(i,e,t)&&(r.push(i),u.push(e))}return Dn(t,u),r},xt.rest=de,xt.reverse=ne,xt.sampleSize=le,xt.set=function(t,n,r){return null==t?t:Pn(t,n,r)},xt.setWith=function(t,n,r,e){return e=typeof e=="function"?e:T,null==t?t:Pn(t,n,r,e)},xt.shuffle=function(t){return le(t,4294967295)},xt.slice=function(t,n,r){var e=t?t.length:0;return e?(r&&typeof r!="number"&&Fr(t,n,r)?(n=0,
r=e):(n=null==n?0:De(n),r=r===T?e:De(r)),Zn(t,n,r)):[]},xt.sortBy=Po,xt.sortedUniq=function(t){return t&&t.length?Kn(t):[]},xt.sortedUniqBy=function(t,n){return t&&t.length?Kn(t,Sr(n)):[]},xt.split=function(t,n,r){return Ze(t).split(n,r)},xt.spread=function(t,n){if(typeof t!="function")throw new su("Expected a function");return n=n===T?0:Du(De(n),0),de(function(e){var u=e[n];return e=e.slice(0,n),u&&l(e,u),r(t,this,e)})},xt.tail=function(t){return Yr(t,1)},xt.take=function(t,n,r){return t&&t.length?(n=r||n===T?1:De(n),
Zn(t,0,0>n?0:n)):[]},xt.takeRight=function(t,n,r){var e=t?t.length:0;return e?(n=r||n===T?1:De(n),n=e-n,Zn(t,0>n?0:n,e)):[]},xt.takeRightWhile=function(t,n){return t&&t.length?Jn(t,Sr(n,3),false,true):[]},xt.takeWhile=function(t,n){return t&&t.length?Jn(t,Sr(n,3)):[]},xt.tap=function(t,n){return n(t),t},xt.throttle=function(t,n,r){var e=true,u=true;if(typeof t!="function")throw new su("Expected a function");return Ie(r)&&(e="leading"in r?!!r.leading:e,u="trailing"in r?!!r.trailing:u),ve(t,n,{leading:e,maxWait:n,
trailing:u})},xt.thru=oe,xt.toArray=$e,xt.toPairs=Je,xt.toPairsIn=Ye,xt.toPath=function(t){return Qo(t)?a(t,en):Ue(t)?[t]:er(yo(t))},xt.toPlainObject=Pe,xt.transform=function(t,n,r){var e=Qo(t)||Me(t);if(n=Sr(n,4),null==r)if(e||Ie(t)){var o=t.constructor;r=e?Qo(t)?new o:[]:Oe(o)?an(Uu(Object(t))):{}}else r={};return(e?u:vn)(t,function(t,e,u){return n(r,t,e,u)}),r},xt.unary=function(t){return se(t,1)},xt.union=Eo,xt.unionBy=Io,xt.unionWith=So,xt.uniq=function(t){return t&&t.length?Gn(t):[]},xt.uniqBy=function(t,n){
return t&&t.length?Gn(t,Sr(n)):[]},xt.uniqWith=function(t,n){return t&&t.length?Gn(t,T,n):[]},xt.unset=function(t,n){var r;if(null==t)r=true;else{r=t;var e=n,e=Nr(e,r)?[e]:un(e);r=Kr(r,e),e=Xr(e),r=null!=r&&Te(r,e)?delete r[e]:true}return r},xt.unzip=re,xt.unzipWith=ee,xt.update=function(t,n,r){return null==t?t:Pn(t,n,(typeof r=="function"?r:ru)(yn(t,n)),void 0)},xt.updateWith=function(t,n,r,e){return e=typeof e=="function"?e:T,null!=t&&(t=Pn(t,n,(typeof r=="function"?r:ru)(yn(t,n)),e)),t},xt.values=He,
xt.valuesIn=function(t){return null==t?[]:k(t,Ge(t))},xt.without=Ro,xt.words=tu,xt.wrap=function(t,n){return n=null==n?ru:n,Jo(n,t)},xt.xor=Wo,xt.xorBy=Bo,xt.xorWith=Co,xt.zip=zo,xt.zipObject=function(t,n){return Qn(t||[],n||[],Qt)},xt.zipObjectDeep=function(t,n){return Qn(t||[],n||[],Pn)},xt.zipWith=Uo,xt.entries=Je,xt.entriesIn=Ye,xt.extend=ni,xt.extendWith=ri,uu(xt,xt),xt.add=Ci,xt.attempt=mi,xt.camelCase=_i,xt.capitalize=Qe,xt.ceil=zi,xt.clamp=function(t,n,r){return r===T&&(r=n,n=T),r!==T&&(r=Ne(r),
r=r===r?r:0),n!==T&&(n=Ne(n),n=n===n?n:0),on(Ne(t),n,r)},xt.clone=function(t){return fn(t,false,true)},xt.cloneDeep=function(t){return fn(t,true,true)},xt.cloneDeepWith=function(t,n){return fn(t,true,true,n)},xt.cloneWith=function(t,n){return fn(t,false,true,n)},xt.deburr=Xe,xt.divide=Ui,xt.endsWith=function(t,n,r){t=Ze(t),n=typeof n=="string"?n:n+"";var e=t.length;return r=r===T?e:on(De(r),0,e),r-=n.length,r>=0&&t.indexOf(n,r)==r},xt.eq=be,xt.escape=function(t){return(t=Ze(t))&&tt.test(t)?t.replace(Q,C):t},xt.escapeRegExp=function(t){
return(t=Ze(t))&&ct.test(t)?t.replace(ft,"\\$&"):t},xt.every=function(t,n,r){var e=Qo(t)?o:hn;return r&&Fr(t,n,r)&&(n=T),e(t,Sr(n,3))},xt.find=function(t,n){if(n=Sr(n,3),Qo(t)){var r=g(t,n);return r>-1?t[r]:T}return v(t,n,fo)},xt.findIndex=function(t,n){return t&&t.length?g(t,Sr(n,3)):-1},xt.findKey=function(t,n){return v(t,Sr(n,3),vn,true)},xt.findLast=function(t,n){if(n=Sr(n,3),Qo(t)){var r=g(t,n,true);return r>-1?t[r]:T}return v(t,n,co)},xt.findLastIndex=function(t,n){return t&&t.length?g(t,Sr(n,3),true):-1;
},xt.findLastKey=function(t,n){return v(t,Sr(n,3),gn,true)},xt.floor=Mi,xt.forEach=fe,xt.forEachRight=ce,xt.forIn=function(t,n){return null==t?t:ao(t,Sr(n),Ge)},xt.forInRight=function(t,n){return null==t?t:lo(t,Sr(n),Ge)},xt.forOwn=function(t,n){return t&&vn(t,Sr(n))},xt.forOwnRight=function(t,n){return t&&gn(t,Sr(n))},xt.get=qe,xt.gt=xe,xt.gte=function(t,n){return t>=n},xt.has=Te,xt.hasIn=Ve,xt.head=Qr,xt.identity=ru,xt.includes=function(t,n,r,e){return t=me(t)?t:He(t),r=r&&!e?De(r):0,e=t.length,0>r&&(r=Du(e+r,0)),
ze(t)?e>=r&&-1<t.indexOf(n,r):!!e&&-1<d(t,n,r)},xt.indexOf=function(t,n,r){var e=t?t.length:0;return e?(r=De(r),0>r&&(r=Du(e+r,0)),d(t,n,r)):-1},xt.inRange=function(t,n,r){return n=Ne(n)||0,r===T?(r=n,n=0):r=Ne(r)||0,t=Ne(t),t>=Fu(n,r)&&t<Du(n,r)},xt.invoke=ai,xt.isArguments=je,xt.isArray=Qo,xt.isArrayBuffer=function(t){return Se(t)&&"[object ArrayBuffer]"==yu.call(t)},xt.isArrayLike=me,xt.isArrayLikeObject=we,xt.isBoolean=function(t){return true===t||false===t||Se(t)&&"[object Boolean]"==yu.call(t)},xt.isBuffer=Xo,
xt.isDate=function(t){return Se(t)&&"[object Date]"==yu.call(t)},xt.isElement=function(t){return!!t&&1===t.nodeType&&Se(t)&&!Be(t)},xt.isEmpty=function(t){if(me(t)&&(Qo(t)||ze(t)||Oe(t.splice)||je(t)||Xo(t)))return!t.length;if(Se(t)){var n=zr(t);if("[object Map]"==n||"[object Set]"==n)return!t.size}for(var r in t)if(vu.call(t,r))return false;return!(Hu&&Ke(t).length)},xt.isEqual=function(t,n){return On(t,n)},xt.isEqualWith=function(t,n,r){var e=(r=typeof r=="function"?r:T)?r(t,n):T;return e===T?On(t,n,r):!!e;
},xt.isError=Ae,xt.isFinite=function(t){return typeof t=="number"&&Mu(t)},xt.isFunction=Oe,xt.isInteger=ke,xt.isLength=Ee,xt.isMap=function(t){return Se(t)&&"[object Map]"==zr(t)},xt.isMatch=function(t,n){return t===n||kn(t,n,Rr(n))},xt.isMatchWith=function(t,n,r){return r=typeof r=="function"?r:T,kn(t,n,Rr(n),r)},xt.isNaN=function(t){return We(t)&&t!=+t},xt.isNative=Re,xt.isNil=function(t){return null==t},xt.isNull=function(t){return null===t},xt.isNumber=We,xt.isObject=Ie,xt.isObjectLike=Se,xt.isPlainObject=Be,
xt.isRegExp=Ce,xt.isSafeInteger=function(t){return ke(t)&&t>=-9007199254740991&&9007199254740991>=t},xt.isSet=function(t){return Se(t)&&"[object Set]"==zr(t)},xt.isString=ze,xt.isSymbol=Ue,xt.isTypedArray=Me,xt.isUndefined=function(t){return t===T},xt.isWeakMap=function(t){return Se(t)&&"[object WeakMap]"==zr(t)},xt.isWeakSet=function(t){return Se(t)&&"[object WeakSet]"==yu.call(t)},xt.join=function(t,n){return t?Lu.call(t,n):""},xt.kebabCase=vi,xt.last=Xr,xt.lastIndexOf=function(t,n,r){var e=t?t.length:0;
if(!e)return-1;var u=e;if(r!==T&&(u=De(r),u=(0>u?Du(e+u,0):Fu(u,e-1))+1),n!==n)return U(t,u,true);for(;u--;)if(t[u]===n)return u;return-1},xt.lowerCase=gi,xt.lowerFirst=di,xt.lt=Le,xt.lte=function(t,n){return n>=t},xt.max=function(t){return t&&t.length?_(t,ru,xe):T},xt.maxBy=function(t,n){return t&&t.length?_(t,Sr(n),xe):T},xt.mean=function(t){return b(t,ru)},xt.meanBy=function(t,n){return b(t,Sr(n))},xt.min=function(t){return t&&t.length?_(t,ru,Le):T},xt.minBy=function(t,n){return t&&t.length?_(t,Sr(n),Le):T;
},xt.multiply=Li,xt.noConflict=function(){return Jt._===this&&(Jt._=bu),this},xt.noop=ou,xt.now=Zo,xt.pad=function(t,n,r){t=Ze(t);var e=(n=De(n))?P(t):0;return n&&n>e?(n=(n-e)/2,xr(zu(n),r)+t+xr(Cu(n),r)):t},xt.padEnd=function(t,n,r){t=Ze(t);var e=(n=De(n))?P(t):0;return n&&n>e?t+xr(n-e,r):t},xt.padStart=function(t,n,r){t=Ze(t);var e=(n=De(n))?P(t):0;return n&&n>e?xr(n-e,r)+t:t},xt.parseInt=function(t,n,r){return r||null==n?n=0:n&&(n=+n),t=Ze(t).replace(at,""),Nu(t,n||(vt.test(t)?16:10))},xt.random=function(t,n,r){
if(r&&typeof r!="boolean"&&Fr(t,n,r)&&(n=r=T),r===T&&(typeof n=="boolean"?(r=n,n=T):typeof t=="boolean"&&(r=t,t=T)),t===T&&n===T?(t=0,n=1):(t=Ne(t)||0,n===T?(n=t,t=0):n=Ne(n)||0),t>n){var e=t;t=n,n=e}return r||t%1||n%1?(r=Pu(),Fu(t+r*(n-t+Nt("1e-"+((r+"").length-1))),n)):Fn(t,n)},xt.reduce=function(t,n,r){var e=Qo(t)?s:x,u=3>arguments.length;return e(t,Sr(n,4),r,u,fo)},xt.reduceRight=function(t,n,r){var e=Qo(t)?h:x,u=3>arguments.length;return e(t,Sr(n,4),r,u,co)},xt.repeat=function(t,n,r){return n=(r?Fr(t,n,r):n===T)?1:De(n),
Nn(Ze(t),n)},xt.replace=function(){var t=arguments,n=Ze(t[0]);return 3>t.length?n:n.replace(t[1],t[2])},xt.result=function(t,n,r){n=Nr(n,t)?[n]:un(n);var e=-1,u=n.length;for(u||(t=T,u=1);++e<u;){var o=null==t?T:t[n[e]];o===T&&(e=u,o=r),t=Oe(o)?o.call(t):o}return t},xt.round=$i,xt.runInContext=q,xt.sample=function(t){t=me(t)?t:He(t);var n=t.length;return n>0?t[Fn(0,n-1)]:T},xt.size=function(t){if(null==t)return 0;if(me(t)){var n=t.length;return n&&ze(t)?P(t):n}return Se(t)&&(n=zr(t),"[object Map]"==n||"[object Set]"==n)?t.size:Ke(t).length;
},xt.snakeCase=yi,xt.some=function(t,n,r){var e=Qo(t)?p:qn;return r&&Fr(t,n,r)&&(n=T),e(t,Sr(n,3))},xt.sortedIndex=function(t,n){return Tn(t,n)},xt.sortedIndexBy=function(t,n,r){return Vn(t,n,Sr(r))},xt.sortedIndexOf=function(t,n){var r=t?t.length:0;if(r){var e=Tn(t,n);if(r>e&&be(t[e],n))return e}return-1},xt.sortedLastIndex=function(t,n){return Tn(t,n,true)},xt.sortedLastIndexBy=function(t,n,r){return Vn(t,n,Sr(r),true)},xt.sortedLastIndexOf=function(t,n){if(t&&t.length){var r=Tn(t,n,true)-1;if(be(t[r],n))return r;
}return-1},xt.startCase=bi,xt.startsWith=function(t,n,r){return t=Ze(t),r=on(De(r),0,t.length),t.lastIndexOf(n,r)==r},xt.subtract=Di,xt.sum=function(t){return t&&t.length?m(t,ru):0},xt.sumBy=function(t,n){return t&&t.length?m(t,Sr(n)):0},xt.template=function(t,n,r){var e=xt.templateSettings;r&&Fr(t,n,r)&&(n=T),t=Ze(t),n=ri({},n,e,Gt),r=ri({},n.imports,e.imports,Gt);var u,o,i=Ke(r),f=k(r,i),c=0;r=n.interpolate||mt;var a="__p+='";r=lu((n.escape||mt).source+"|"+r.source+"|"+(r===et?pt:mt).source+"|"+(n.evaluate||mt).source+"|$","g");
var l="sourceURL"in n?"//# sourceURL="+n.sourceURL+"\n":"";if(t.replace(r,function(n,r,e,i,f,l){return e||(e=i),a+=t.slice(c,l).replace(wt,z),r&&(u=true,a+="'+__e("+r+")+'"),f&&(o=true,a+="';"+f+";\n__p+='"),e&&(a+="'+((__t=("+e+"))==null?'':__t)+'"),c=l+n.length,n}),a+="';",(n=n.variable)||(a="with(obj){"+a+"}"),a=(o?a.replace(G,""):a).replace(J,"$1").replace(Y,"$1;"),a="function("+(n||"obj")+"){"+(n?"":"obj||(obj={});")+"var __t,__p=''"+(u?",__e=_.escape":"")+(o?",__j=Array.prototype.join;function print(){__p+=__j.call(arguments,'')}":";")+a+"return __p}",
n=mi(function(){return Function(i,l+"return "+a).apply(T,f)}),n.source=a,Ae(n))throw n;return n},xt.times=function(t,n){if(t=De(t),1>t||t>9007199254740991)return[];var r=4294967295,e=Fu(t,4294967295);for(n=Sr(n),t-=4294967295,e=w(e,n);++r<t;)n(r);return e},xt.toInteger=De,xt.toLength=Fe,xt.toLower=function(t){return Ze(t).toLowerCase()},xt.toNumber=Ne,xt.toSafeInteger=function(t){return on(De(t),-9007199254740991,9007199254740991)},xt.toString=Ze,xt.toUpper=function(t){return Ze(t).toUpperCase()},
xt.trim=function(t,n,r){return(t=Ze(t))?r||n===T?t.replace(at,""):(n+="")?(t=t.match(It),n=n.match(It),t.slice(E(t,n),I(t,n)+1).join("")):t:t},xt.trimEnd=function(t,n,r){return(t=Ze(t))?r||n===T?t.replace(st,""):(n+="")?(t=t.match(It),t.slice(0,I(t,n.match(It))+1).join("")):t:t},xt.trimStart=function(t,n,r){return(t=Ze(t))?r||n===T?t.replace(lt,""):(n+="")?(t=t.match(It),t.slice(E(t,n.match(It))).join("")):t:t},xt.truncate=function(t,n){var r=30,e="...";if(Ie(n))var u="separator"in n?n.separator:u,r="length"in n?De(n.length):r,e="omission"in n?Ze(n.omission):e;
t=Ze(t);var o=t.length;if(St.test(t))var i=t.match(It),o=i.length;if(r>=o)return t;if(o=r-P(e),1>o)return e;if(r=i?i.slice(0,o).join(""):t.slice(0,o),u===T)return r+e;if(i&&(o+=r.length-o),Ce(u)){if(t.slice(o).search(u)){var f=r;for(u.global||(u=lu(u.source,Ze(_t.exec(u))+"g")),u.lastIndex=0;i=u.exec(f);)var c=i.index;r=r.slice(0,c===T?o:c)}}else t.indexOf(u,o)!=o&&(u=r.lastIndexOf(u),u>-1&&(r=r.slice(0,u)));return r+e},xt.unescape=function(t){return(t=Ze(t))&&X.test(t)?t.replace(H,Z):t},xt.uniqueId=function(t){
var n=++gu;return Ze(t)+n},xt.upperCase=xi,xt.upperFirst=ji,xt.each=fe,xt.eachRight=ce,xt.first=Qr,uu(xt,function(){var t={};return vn(xt,function(n,r){vu.call(xt.prototype,r)||(t[r]=n)}),t}(),{chain:false}),xt.VERSION="4.8.2",u("bind bindKey curry curryRight partial partialRight".split(" "),function(t){xt[t].placeholder=xt}),u(["drop","take"],function(t,n){kt.prototype[t]=function(r){var e=this.__filtered__;if(e&&!n)return new kt(this);r=r===T?1:Du(De(r),0);var u=this.clone();return e?u.__takeCount__=Fu(r,u.__takeCount__):u.__views__.push({
size:Fu(r,4294967295),type:t+(0>u.__dir__?"Right":"")}),u},kt.prototype[t+"Right"]=function(n){return this.reverse()[t](n).reverse()}}),u(["filter","map","takeWhile"],function(t,n){var r=n+1,e=1==r||3==r;kt.prototype[t]=function(t){var n=this.clone();return n.__iteratees__.push({iteratee:Sr(t,3),type:r}),n.__filtered__=n.__filtered__||e,n}}),u(["head","last"],function(t,n){var r="take"+(n?"Right":"");kt.prototype[t]=function(){return this[r](1).value()[0]}}),u(["initial","tail"],function(t,n){var r="drop"+(n?"":"Right");
kt.prototype[t]=function(){return this.__filtered__?new kt(this):this[r](1)}}),kt.prototype.compact=function(){return this.filter(ru)},kt.prototype.find=function(t){return this.filter(t).head()},kt.prototype.findLast=function(t){return this.reverse().find(t)},kt.prototype.invokeMap=de(function(t,n){return typeof t=="function"?new kt(this):this.map(function(r){return An(r,t,n)})}),kt.prototype.reject=function(t){return t=Sr(t,3),this.filter(function(n){return!t(n)})},kt.prototype.slice=function(t,n){
t=De(t);var r=this;return r.__filtered__&&(t>0||0>n)?new kt(r):(0>t?r=r.takeRight(-t):t&&(r=r.drop(t)),n!==T&&(n=De(n),r=0>n?r.dropRight(-n):r.take(n-t)),r)},kt.prototype.takeRightWhile=function(t){return this.reverse().takeWhile(t).reverse()},kt.prototype.toArray=function(){return this.take(4294967295)},vn(kt.prototype,function(t,n){var r=/^(?:filter|find|map|reject)|While$/.test(n),e=/^(?:head|last)$/.test(n),u=xt[e?"take"+("last"==n?"Right":""):n],o=e||/^find/.test(n);u&&(xt.prototype[n]=function(){
function n(t){return t=u.apply(xt,l([t],f)),e&&h?t[0]:t}var i=this.__wrapped__,f=e?[1]:arguments,c=i instanceof kt,a=f[0],s=c||Qo(i);s&&r&&typeof a=="function"&&1!=a.length&&(c=s=false);var h=this.__chain__,p=!!this.__actions__.length,a=o&&!h,c=c&&!p;return!o&&s?(i=c?i:new kt(this),i=t.apply(i,f),i.__actions__.push({func:oe,args:[n],thisArg:T}),new Ot(i,h)):a&&c?t.apply(this,f):(i=this.thru(n),a?e?i.value()[0]:i.value():i)})}),u("pop push shift sort splice unshift".split(" "),function(t){var n=hu[t],r=/^(?:push|sort|unshift)$/.test(t)?"tap":"thru",e=/^(?:pop|shift)$/.test(t);
xt.prototype[t]=function(){var t=arguments;if(e&&!this.__chain__){var u=this.value();return n.apply(Qo(u)?u:[],t)}return this[r](function(r){return n.apply(Qo(r)?r:[],t)})}}),vn(kt.prototype,function(t,n){var r=xt[n];if(r){var e=r.name+"";(Qu[e]||(Qu[e]=[])).push({name:n,func:r})}}),Qu[dr(T,2).name]=[{name:"wrapper",func:T}],kt.prototype.clone=function(){var t=new kt(this.__wrapped__);return t.__actions__=er(this.__actions__),t.__dir__=this.__dir__,t.__filtered__=this.__filtered__,t.__iteratees__=er(this.__iteratees__),
t.__takeCount__=this.__takeCount__,t.__views__=er(this.__views__),t},kt.prototype.reverse=function(){if(this.__filtered__){var t=new kt(this);t.__dir__=-1,t.__filtered__=true}else t=this.clone(),t.__dir__*=-1;return t},kt.prototype.value=function(){var t,n=this.__wrapped__.value(),r=this.__dir__,e=Qo(n),u=0>r,o=e?n.length:0;t=o;for(var i=this.__views__,f=0,c=-1,a=i.length;++c<a;){var l=i[c],s=l.size;switch(l.type){case"drop":f+=s;break;case"dropRight":t-=s;break;case"take":t=Fu(t,f+s);break;case"takeRight":
f=Du(f,t-s)}}if(t={start:f,end:t},i=t.start,f=t.end,t=f-i,u=u?f:i-1,i=this.__iteratees__,f=i.length,c=0,a=Fu(t,this.__takeCount__),!e||200>o||o==t&&a==t)return Yn(n,this.__actions__);e=[];t:for(;t--&&a>c;){for(u+=r,o=-1,l=n[u];++o<f;){var h=i[o],s=h.type,h=(0,h.iteratee)(l);if(2==s)l=h;else if(!h){if(1==s)continue t;break t}}e[c++]=l}return e},xt.prototype.at=Mo,xt.prototype.chain=function(){return ue(this)},xt.prototype.commit=function(){return new Ot(this.value(),this.__chain__)},xt.prototype.next=function(){
this.__values__===T&&(this.__values__=$e(this.value()));var t=this.__index__>=this.__values__.length,n=t?T:this.__values__[this.__index__++];return{done:t,value:n}},xt.prototype.plant=function(t){for(var n,r=this;r instanceof At;){var e=Jr(r);e.__index__=0,e.__values__=T,n?u.__wrapped__=e:n=e;var u=e,r=r.__wrapped__}return u.__wrapped__=t,n},xt.prototype.reverse=function(){var t=this.__wrapped__;return t instanceof kt?(this.__actions__.length&&(t=new kt(this)),t=t.reverse(),t.__actions__.push({func:oe,
args:[ne],thisArg:T}),new Ot(t,this.__chain__)):this.thru(ne)},xt.prototype.toJSON=xt.prototype.valueOf=xt.prototype.value=function(){return Yn(this.__wrapped__,this.__actions__)},Iu&&(xt.prototype[Iu]=ie),xt}var T,V=1/0,K=NaN,G=/\b__p\+='';/g,J=/\b(__p\+=)''\+/g,Y=/(__e\(.*?\)|\b__t\))\+'';/g,H=/&(?:amp|lt|gt|quot|#39|#96);/g,Q=/[&<>"'`]/g,X=RegExp(H.source),tt=RegExp(Q.source),nt=/<%-([\s\S]+?)%>/g,rt=/<%([\s\S]+?)%>/g,et=/<%=([\s\S]+?)%>/g,ut=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,ot=/^\w*$/,it=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]/g,ft=/[\\^$.*+?()[\]{}|]/g,ct=RegExp(ft.source),at=/^\s+|\s+$/g,lt=/^\s+/,st=/\s+$/,ht=/\\(\\)?/g,pt=/\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g,_t=/\w*$/,vt=/^0x/i,gt=/^[-+]0x[0-9a-f]+$/i,dt=/^0b[01]+$/i,yt=/^\[object .+?Constructor\]$/,bt=/^0o[0-7]+$/i,xt=/^(?:0|[1-9]\d*)$/,jt=/[\xc0-\xd6\xd8-\xde\xdf-\xf6\xf8-\xff]/g,mt=/($^)/,wt=/['\n\r\u2028\u2029\\]/g,At="[\\ufe0e\\ufe0f]?(?:[\\u0300-\\u036f\\ufe20-\\ufe23\\u20d0-\\u20f0]|\\ud83c[\\udffb-\\udfff])?(?:\\u200d(?:[^\\ud800-\\udfff]|(?:\\ud83c[\\udde6-\\uddff]){2}|[\\ud800-\\udbff][\\udc00-\\udfff])[\\ufe0e\\ufe0f]?(?:[\\u0300-\\u036f\\ufe20-\\ufe23\\u20d0-\\u20f0]|\\ud83c[\\udffb-\\udfff])?)*",Ot="(?:[\\u2700-\\u27bf]|(?:\\ud83c[\\udde6-\\uddff]){2}|[\\ud800-\\udbff][\\udc00-\\udfff])"+At,kt="(?:[^\\ud800-\\udfff][\\u0300-\\u036f\\ufe20-\\ufe23\\u20d0-\\u20f0]?|[\\u0300-\\u036f\\ufe20-\\ufe23\\u20d0-\\u20f0]|(?:\\ud83c[\\udde6-\\uddff]){2}|[\\ud800-\\udbff][\\udc00-\\udfff]|[\\ud800-\\udfff])",Et=RegExp("[\\u0300-\\u036f\\ufe20-\\ufe23\\u20d0-\\u20f0]","g"),It=RegExp("\\ud83c[\\udffb-\\udfff](?=\\ud83c[\\udffb-\\udfff])|"+kt+At,"g"),St=RegExp("[\\u200d\\ud800-\\udfff\\u0300-\\u036f\\ufe20-\\ufe23\\u20d0-\\u20f0\\ufe0e\\ufe0f]"),Rt=/[a-zA-Z0-9]+/g,Wt=RegExp(["[A-Z\\xc0-\\xd6\\xd8-\\xde]?[a-z\\xdf-\\xf6\\xf8-\\xff]+(?=[\\xac\\xb1\\xd7\\xf7\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf\\u2018\\u2019\\u201c\\u201d \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000]|[A-Z\\xc0-\\xd6\\xd8-\\xde]|$)|(?:[A-Z\\xc0-\\xd6\\xd8-\\xde]|[^\\ud800-\\udfff\\xac\\xb1\\xd7\\xf7\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf\\u2018\\u2019\\u201c\\u201d \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000\\d+\\u2700-\\u27bfa-z\\xdf-\\xf6\\xf8-\\xffA-Z\\xc0-\\xd6\\xd8-\\xde])+(?=[\\xac\\xb1\\xd7\\xf7\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf\\u2018\\u2019\\u201c\\u201d \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000]|[A-Z\\xc0-\\xd6\\xd8-\\xde](?:[a-z\\xdf-\\xf6\\xf8-\\xff]|[^\\ud800-\\udfff\\xac\\xb1\\xd7\\xf7\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf\\u2018\\u2019\\u201c\\u201d \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000\\d+\\u2700-\\u27bfa-z\\xdf-\\xf6\\xf8-\\xffA-Z\\xc0-\\xd6\\xd8-\\xde])|$)|[A-Z\\xc0-\\xd6\\xd8-\\xde]?(?:[a-z\\xdf-\\xf6\\xf8-\\xff]|[^\\ud800-\\udfff\\xac\\xb1\\xd7\\xf7\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf\\u2018\\u2019\\u201c\\u201d \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000\\d+\\u2700-\\u27bfa-z\\xdf-\\xf6\\xf8-\\xffA-Z\\xc0-\\xd6\\xd8-\\xde])+|[A-Z\\xc0-\\xd6\\xd8-\\xde]+|\\d+",Ot].join("|"),"g"),Bt=/[a-z][A-Z]|[A-Z]{2,}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/,Ct="Array Buffer DataView Date Error Float32Array Float64Array Function Int8Array Int16Array Int32Array Map Math Object Promise Reflect RegExp Set String Symbol TypeError Uint8Array Uint8ClampedArray Uint16Array Uint32Array WeakMap _ clearTimeout isFinite parseInt setTimeout".split(" "),zt={};
zt["[object Float32Array]"]=zt["[object Float64Array]"]=zt["[object Int8Array]"]=zt["[object Int16Array]"]=zt["[object Int32Array]"]=zt["[object Uint8Array]"]=zt["[object Uint8ClampedArray]"]=zt["[object Uint16Array]"]=zt["[object Uint32Array]"]=true,zt["[object Arguments]"]=zt["[object Array]"]=zt["[object ArrayBuffer]"]=zt["[object Boolean]"]=zt["[object DataView]"]=zt["[object Date]"]=zt["[object Error]"]=zt["[object Function]"]=zt["[object Map]"]=zt["[object Number]"]=zt["[object Object]"]=zt["[object RegExp]"]=zt["[object Set]"]=zt["[object String]"]=zt["[object WeakMap]"]=false;
var Ut={};Ut["[object Arguments]"]=Ut["[object Array]"]=Ut["[object ArrayBuffer]"]=Ut["[object DataView]"]=Ut["[object Boolean]"]=Ut["[object Date]"]=Ut["[object Float32Array]"]=Ut["[object Float64Array]"]=Ut["[object Int8Array]"]=Ut["[object Int16Array]"]=Ut["[object Int32Array]"]=Ut["[object Map]"]=Ut["[object Number]"]=Ut["[object Object]"]=Ut["[object RegExp]"]=Ut["[object Set]"]=Ut["[object String]"]=Ut["[object Symbol]"]=Ut["[object Uint8Array]"]=Ut["[object Uint8ClampedArray]"]=Ut["[object Uint16Array]"]=Ut["[object Uint32Array]"]=true,
Ut["[object Error]"]=Ut["[object Function]"]=Ut["[object WeakMap]"]=false;var Mt={"\xc0":"A","\xc1":"A","\xc2":"A","\xc3":"A","\xc4":"A","\xc5":"A","\xe0":"a","\xe1":"a","\xe2":"a","\xe3":"a","\xe4":"a","\xe5":"a","\xc7":"C","\xe7":"c","\xd0":"D","\xf0":"d","\xc8":"E","\xc9":"E","\xca":"E","\xcb":"E","\xe8":"e","\xe9":"e","\xea":"e","\xeb":"e","\xcc":"I","\xcd":"I","\xce":"I","\xcf":"I","\xec":"i","\xed":"i","\xee":"i","\xef":"i","\xd1":"N","\xf1":"n","\xd2":"O","\xd3":"O","\xd4":"O","\xd5":"O","\xd6":"O",
"\xd8":"O","\xf2":"o","\xf3":"o","\xf4":"o","\xf5":"o","\xf6":"o","\xf8":"o","\xd9":"U","\xda":"U","\xdb":"U","\xdc":"U","\xf9":"u","\xfa":"u","\xfb":"u","\xfc":"u","\xdd":"Y","\xfd":"y","\xff":"y","\xc6":"Ae","\xe6":"ae","\xde":"Th","\xfe":"th","\xdf":"ss"},Lt={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","`":"&#96;"},$t={"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&#39;":"'","&#96;":"`"},Dt={"function":true,object:true},Ft={"\\":"\\","'":"'","\n":"n","\r":"r","\u2028":"u2028","\u2029":"u2029"
},Nt=parseFloat,Pt=parseInt,Zt=Dt[typeof exports]&&exports&&!exports.nodeType?exports:T,qt=Dt[typeof module]&&module&&!module.nodeType?module:T,Tt=qt&&qt.exports===Zt?Zt:T,Vt=S(Dt[typeof self]&&self),Kt=S(Dt[typeof window]&&window),Gt=S(Dt[typeof this]&&this),Jt=S(Zt&&qt&&typeof global=="object"&&global)||Kt!==(Gt&&Gt.window)&&Kt||Vt||Gt||Function("return this")(),Yt=q();(Kt||Vt||{})._=Yt,typeof define=="function"&&typeof define.amd=="object"&&define.amd? define('lodash',[],function(){return Yt}):Zt&&qt?(Tt&&((qt.exports=Yt)._=Yt),
Zt._=Yt):Jt._=Yt}).call(this);
(function(root) {
define("angular", ["jquery"], function() {
  return (function() {
/*
 AngularJS v1.4.4
 (c) 2010-2015 Google, Inc. http://angularjs.org
 License: MIT
*/
(function(O,W,t){'use strict';function L(b){return function(){var a=arguments[0],c;c="["+(b?b+":":"")+a+"] http://errors.angularjs.org/1.4.4/"+(b?b+"/":"")+a;for(a=1;a<arguments.length;a++){c=c+(1==a?"?":"&")+"p"+(a-1)+"=";var d=encodeURIComponent,e;e=arguments[a];e="function"==typeof e?e.toString().replace(/ \{[\s\S]*$/,""):"undefined"==typeof e?"undefined":"string"!=typeof e?JSON.stringify(e):e;c+=d(e)}return Error(c)}}function Da(b){if(null==b||Ya(b))return!1;var a="length"in Object(b)&&b.length;
return b.nodeType===pa&&a?!0:I(b)||G(b)||0===a||"number"===typeof a&&0<a&&a-1 in b}function m(b,a,c){var d,e;if(b)if(C(b))for(d in b)"prototype"==d||"length"==d||"name"==d||b.hasOwnProperty&&!b.hasOwnProperty(d)||a.call(c,b[d],d,b);else if(G(b)||Da(b)){var f="object"!==typeof b;d=0;for(e=b.length;d<e;d++)(f||d in b)&&a.call(c,b[d],d,b)}else if(b.forEach&&b.forEach!==m)b.forEach(a,c,b);else if(lc(b))for(d in b)a.call(c,b[d],d,b);else if("function"===typeof b.hasOwnProperty)for(d in b)b.hasOwnProperty(d)&&
a.call(c,b[d],d,b);else for(d in b)Na.call(b,d)&&a.call(c,b[d],d,b);return b}function mc(b,a,c){for(var d=Object.keys(b).sort(),e=0;e<d.length;e++)a.call(c,b[d[e]],d[e]);return d}function nc(b){return function(a,c){b(c,a)}}function Ud(){return++mb}function oc(b,a){a?b.$$hashKey=a:delete b.$$hashKey}function Mb(b,a,c){for(var d=b.$$hashKey,e=0,f=a.length;e<f;++e){var g=a[e];if(D(g)||C(g))for(var h=Object.keys(g),l=0,k=h.length;l<k;l++){var n=h[l],q=g[n];c&&D(q)?ca(q)?b[n]=new Date(q.valueOf()):Oa(q)?
b[n]=new RegExp(q):(D(b[n])||(b[n]=G(q)?[]:{}),Mb(b[n],[q],!0)):b[n]=q}}oc(b,d);return b}function Q(b){return Mb(b,xa.call(arguments,1),!1)}function Vd(b){return Mb(b,xa.call(arguments,1),!0)}function Y(b){return parseInt(b,10)}function Nb(b,a){return Q(Object.create(b),a)}function v(){}function Za(b){return b}function qa(b){return function(){return b}}function pc(b){return C(b.toString)&&b.toString!==Object.prototype.toString}function y(b){return"undefined"===typeof b}function x(b){return"undefined"!==
typeof b}function D(b){return null!==b&&"object"===typeof b}function lc(b){return null!==b&&"object"===typeof b&&!qc(b)}function I(b){return"string"===typeof b}function X(b){return"number"===typeof b}function ca(b){return"[object Date]"===sa.call(b)}function C(b){return"function"===typeof b}function Oa(b){return"[object RegExp]"===sa.call(b)}function Ya(b){return b&&b.window===b}function $a(b){return b&&b.$evalAsync&&b.$watch}function ab(b){return"boolean"===typeof b}function rc(b){return!(!b||!(b.nodeName||
b.prop&&b.attr&&b.find))}function Wd(b){var a={};b=b.split(",");var c;for(c=0;c<b.length;c++)a[b[c]]=!0;return a}function ta(b){return M(b.nodeName||b[0]&&b[0].nodeName)}function bb(b,a){var c=b.indexOf(a);0<=c&&b.splice(c,1);return c}function fa(b,a,c,d){if(Ya(b)||$a(b))throw Ea("cpws");if(sc.test(sa.call(a)))throw Ea("cpta");if(a){if(b===a)throw Ea("cpi");c=c||[];d=d||[];D(b)&&(c.push(b),d.push(a));var e;if(G(b))for(e=a.length=0;e<b.length;e++)a.push(fa(b[e],null,c,d));else{var f=a.$$hashKey;G(a)?
a.length=0:m(a,function(b,c){delete a[c]});if(lc(b))for(e in b)a[e]=fa(b[e],null,c,d);else if(b&&"function"===typeof b.hasOwnProperty)for(e in b)b.hasOwnProperty(e)&&(a[e]=fa(b[e],null,c,d));else for(e in b)Na.call(b,e)&&(a[e]=fa(b[e],null,c,d));oc(a,f)}}else if(a=b,D(b)){if(c&&-1!==(f=c.indexOf(b)))return d[f];if(G(b))return fa(b,[],c,d);if(sc.test(sa.call(b)))a=new b.constructor(b);else if(ca(b))a=new Date(b.getTime());else if(Oa(b))a=new RegExp(b.source,b.toString().match(/[^\/]*$/)[0]),a.lastIndex=
b.lastIndex;else return e=Object.create(qc(b)),fa(b,e,c,d);d&&(c.push(b),d.push(a))}return a}function ia(b,a){if(G(b)){a=a||[];for(var c=0,d=b.length;c<d;c++)a[c]=b[c]}else if(D(b))for(c in a=a||{},b)if("$"!==c.charAt(0)||"$"!==c.charAt(1))a[c]=b[c];return a||b}function ka(b,a){if(b===a)return!0;if(null===b||null===a)return!1;if(b!==b&&a!==a)return!0;var c=typeof b,d;if(c==typeof a&&"object"==c)if(G(b)){if(!G(a))return!1;if((c=b.length)==a.length){for(d=0;d<c;d++)if(!ka(b[d],a[d]))return!1;return!0}}else{if(ca(b))return ca(a)?
ka(b.getTime(),a.getTime()):!1;if(Oa(b))return Oa(a)?b.toString()==a.toString():!1;if($a(b)||$a(a)||Ya(b)||Ya(a)||G(a)||ca(a)||Oa(a))return!1;c=ga();for(d in b)if("$"!==d.charAt(0)&&!C(b[d])){if(!ka(b[d],a[d]))return!1;c[d]=!0}for(d in a)if(!(d in c||"$"===d.charAt(0)||a[d]===t||C(a[d])))return!1;return!0}return!1}function cb(b,a,c){return b.concat(xa.call(a,c))}function tc(b,a){var c=2<arguments.length?xa.call(arguments,2):[];return!C(a)||a instanceof RegExp?a:c.length?function(){return arguments.length?
a.apply(b,cb(c,arguments,0)):a.apply(b,c)}:function(){return arguments.length?a.apply(b,arguments):a.call(b)}}function Xd(b,a){var c=a;"string"===typeof b&&"$"===b.charAt(0)&&"$"===b.charAt(1)?c=t:Ya(a)?c="$WINDOW":a&&W===a?c="$DOCUMENT":$a(a)&&(c="$SCOPE");return c}function db(b,a){if("undefined"===typeof b)return t;X(a)||(a=a?2:null);return JSON.stringify(b,Xd,a)}function uc(b){return I(b)?JSON.parse(b):b}function vc(b,a){var c=Date.parse("Jan 01, 1970 00:00:00 "+b)/6E4;return isNaN(c)?a:c}function Ob(b,
a,c){c=c?-1:1;var d=vc(a,b.getTimezoneOffset());a=b;b=c*(d-b.getTimezoneOffset());a=new Date(a.getTime());a.setMinutes(a.getMinutes()+b);return a}function ua(b){b=z(b).clone();try{b.empty()}catch(a){}var c=z("<div>").append(b).html();try{return b[0].nodeType===Pa?M(c):c.match(/^(<[^>]+>)/)[1].replace(/^<([\w\-]+)/,function(a,b){return"<"+M(b)})}catch(d){return M(c)}}function wc(b){try{return decodeURIComponent(b)}catch(a){}}function xc(b){var a={};m((b||"").split("&"),function(b){var d,e,f;b&&(e=
b=b.replace(/\+/g,"%20"),d=b.indexOf("="),-1!==d&&(e=b.substring(0,d),f=b.substring(d+1)),e=wc(e),x(e)&&(f=x(f)?wc(f):!0,Na.call(a,e)?G(a[e])?a[e].push(f):a[e]=[a[e],f]:a[e]=f))});return a}function Pb(b){var a=[];m(b,function(b,d){G(b)?m(b,function(b){a.push(ma(d,!0)+(!0===b?"":"="+ma(b,!0)))}):a.push(ma(d,!0)+(!0===b?"":"="+ma(b,!0)))});return a.length?a.join("&"):""}function nb(b){return ma(b,!0).replace(/%26/gi,"&").replace(/%3D/gi,"=").replace(/%2B/gi,"+")}function ma(b,a){return encodeURIComponent(b).replace(/%40/gi,
"@").replace(/%3A/gi,":").replace(/%24/g,"$").replace(/%2C/gi,",").replace(/%3B/gi,";").replace(/%20/g,a?"%20":"+")}function Yd(b,a){var c,d,e=Qa.length;for(d=0;d<e;++d)if(c=Qa[d]+a,I(c=b.getAttribute(c)))return c;return null}function Zd(b,a){var c,d,e={};m(Qa,function(a){a+="app";!c&&b.hasAttribute&&b.hasAttribute(a)&&(c=b,d=b.getAttribute(a))});m(Qa,function(a){a+="app";var e;!c&&(e=b.querySelector("["+a.replace(":","\\:")+"]"))&&(c=e,d=e.getAttribute(a))});c&&(e.strictDi=null!==Yd(c,"strict-di"),
a(c,d?[d]:[],e))}function yc(b,a,c){D(c)||(c={});c=Q({strictDi:!1},c);var d=function(){b=z(b);if(b.injector()){var d=b[0]===W?"document":ua(b);throw Ea("btstrpd",d.replace(/</,"&lt;").replace(/>/,"&gt;"));}a=a||[];a.unshift(["$provide",function(a){a.value("$rootElement",b)}]);c.debugInfoEnabled&&a.push(["$compileProvider",function(a){a.debugInfoEnabled(!0)}]);a.unshift("ng");d=eb(a,c.strictDi);d.invoke(["$rootScope","$rootElement","$compile","$injector",function(a,b,c,d){a.$apply(function(){b.data("$injector",
d);c(b)(a)})}]);return d},e=/^NG_ENABLE_DEBUG_INFO!/,f=/^NG_DEFER_BOOTSTRAP!/;O&&e.test(O.name)&&(c.debugInfoEnabled=!0,O.name=O.name.replace(e,""));if(O&&!f.test(O.name))return d();O.name=O.name.replace(f,"");aa.resumeBootstrap=function(b){m(b,function(b){a.push(b)});return d()};C(aa.resumeDeferredBootstrap)&&aa.resumeDeferredBootstrap()}function $d(){O.name="NG_ENABLE_DEBUG_INFO!"+O.name;O.location.reload()}function ae(b){b=aa.element(b).injector();if(!b)throw Ea("test");return b.get("$$testability")}
function zc(b,a){a=a||"_";return b.replace(be,function(b,d){return(d?a:"")+b.toLowerCase()})}function ce(){var b;if(!Ac){var a=ob();la=O.jQuery;x(a)&&(la=null===a?t:O[a]);la&&la.fn.on?(z=la,Q(la.fn,{scope:Ra.scope,isolateScope:Ra.isolateScope,controller:Ra.controller,injector:Ra.injector,inheritedData:Ra.inheritedData}),b=la.cleanData,la.cleanData=function(a){var d;if(Qb)Qb=!1;else for(var e=0,f;null!=(f=a[e]);e++)(d=la._data(f,"events"))&&d.$destroy&&la(f).triggerHandler("$destroy");b(a)}):z=R;aa.element=
z;Ac=!0}}function pb(b,a,c){if(!b)throw Ea("areq",a||"?",c||"required");return b}function Sa(b,a,c){c&&G(b)&&(b=b[b.length-1]);pb(C(b),a,"not a function, got "+(b&&"object"===typeof b?b.constructor.name||"Object":typeof b));return b}function Ta(b,a){if("hasOwnProperty"===b)throw Ea("badname",a);}function Bc(b,a,c){if(!a)return b;a=a.split(".");for(var d,e=b,f=a.length,g=0;g<f;g++)d=a[g],b&&(b=(e=b)[d]);return!c&&C(b)?tc(e,b):b}function qb(b){var a=b[0];b=b[b.length-1];var c=[a];do{a=a.nextSibling;
if(!a)break;c.push(a)}while(a!==b);return z(c)}function ga(){return Object.create(null)}function de(b){function a(a,b,c){return a[b]||(a[b]=c())}var c=L("$injector"),d=L("ng");b=a(b,"angular",Object);b.$$minErr=b.$$minErr||L;return a(b,"module",function(){var b={};return function(f,g,h){if("hasOwnProperty"===f)throw d("badname","module");g&&b.hasOwnProperty(f)&&(b[f]=null);return a(b,f,function(){function a(b,c,e,f){f||(f=d);return function(){f[e||"push"]([b,c,arguments]);return B}}function b(a,c){return function(b,
e){e&&C(e)&&(e.$$moduleName=f);d.push([a,c,arguments]);return B}}if(!g)throw c("nomod",f);var d=[],e=[],r=[],u=a("$injector","invoke","push",e),B={_invokeQueue:d,_configBlocks:e,_runBlocks:r,requires:g,name:f,provider:b("$provide","provider"),factory:b("$provide","factory"),service:b("$provide","service"),value:a("$provide","value"),constant:a("$provide","constant","unshift"),decorator:b("$provide","decorator"),animation:b("$animateProvider","register"),filter:b("$filterProvider","register"),controller:b("$controllerProvider",
"register"),directive:b("$compileProvider","directive"),config:u,run:function(a){r.push(a);return this}};h&&u(h);return B})}})}function ee(b){Q(b,{bootstrap:yc,copy:fa,extend:Q,merge:Vd,equals:ka,element:z,forEach:m,injector:eb,noop:v,bind:tc,toJson:db,fromJson:uc,identity:Za,isUndefined:y,isDefined:x,isString:I,isFunction:C,isObject:D,isNumber:X,isElement:rc,isArray:G,version:fe,isDate:ca,lowercase:M,uppercase:rb,callbacks:{counter:0},getTestability:ae,$$minErr:L,$$csp:Fa,reloadWithDebugInfo:$d});
Rb=de(O);Rb("ng",["ngLocale"],["$provide",function(a){a.provider({$$sanitizeUri:ge});a.provider("$compile",Cc).directive({a:he,input:Dc,textarea:Dc,form:ie,script:je,select:ke,style:le,option:me,ngBind:ne,ngBindHtml:oe,ngBindTemplate:pe,ngClass:qe,ngClassEven:re,ngClassOdd:se,ngCloak:te,ngController:ue,ngForm:ve,ngHide:we,ngIf:xe,ngInclude:ye,ngInit:ze,ngNonBindable:Ae,ngPluralize:Be,ngRepeat:Ce,ngShow:De,ngStyle:Ee,ngSwitch:Fe,ngSwitchWhen:Ge,ngSwitchDefault:He,ngOptions:Ie,ngTransclude:Je,ngModel:Ke,
ngList:Le,ngChange:Me,pattern:Ec,ngPattern:Ec,required:Fc,ngRequired:Fc,minlength:Gc,ngMinlength:Gc,maxlength:Hc,ngMaxlength:Hc,ngValue:Ne,ngModelOptions:Oe}).directive({ngInclude:Pe}).directive(sb).directive(Ic);a.provider({$anchorScroll:Qe,$animate:Re,$animateCss:Se,$$animateQueue:Te,$$AnimateRunner:Ue,$browser:Ve,$cacheFactory:We,$controller:Xe,$document:Ye,$exceptionHandler:Ze,$filter:Jc,$$forceReflow:$e,$interpolate:af,$interval:bf,$http:cf,$httpParamSerializer:df,$httpParamSerializerJQLike:ef,
$httpBackend:ff,$location:gf,$log:hf,$parse:jf,$rootScope:kf,$q:lf,$$q:mf,$sce:nf,$sceDelegate:of,$sniffer:pf,$templateCache:qf,$templateRequest:rf,$$testability:sf,$timeout:tf,$window:uf,$$rAF:vf,$$jqLite:wf,$$HashMap:xf,$$cookieReader:yf})}])}function fb(b){return b.replace(zf,function(a,b,d,e){return e?d.toUpperCase():d}).replace(Af,"Moz$1")}function Kc(b){b=b.nodeType;return b===pa||!b||9===b}function Lc(b,a){var c,d,e=a.createDocumentFragment(),f=[];if(Sb.test(b)){c=c||e.appendChild(a.createElement("div"));
d=(Bf.exec(b)||["",""])[1].toLowerCase();d=na[d]||na._default;c.innerHTML=d[1]+b.replace(Cf,"<$1></$2>")+d[2];for(d=d[0];d--;)c=c.lastChild;f=cb(f,c.childNodes);c=e.firstChild;c.textContent=""}else f.push(a.createTextNode(b));e.textContent="";e.innerHTML="";m(f,function(a){e.appendChild(a)});return e}function R(b){if(b instanceof R)return b;var a;I(b)&&(b=T(b),a=!0);if(!(this instanceof R)){if(a&&"<"!=b.charAt(0))throw Tb("nosel");return new R(b)}if(a){a=W;var c;b=(c=Df.exec(b))?[a.createElement(c[1])]:
(c=Lc(b,a))?c.childNodes:[]}Mc(this,b)}function Ub(b){return b.cloneNode(!0)}function tb(b,a){a||ub(b);if(b.querySelectorAll)for(var c=b.querySelectorAll("*"),d=0,e=c.length;d<e;d++)ub(c[d])}function Nc(b,a,c,d){if(x(d))throw Tb("offargs");var e=(d=vb(b))&&d.events,f=d&&d.handle;if(f)if(a)m(a.split(" "),function(a){if(x(c)){var d=e[a];bb(d||[],c);if(d&&0<d.length)return}b.removeEventListener(a,f,!1);delete e[a]});else for(a in e)"$destroy"!==a&&b.removeEventListener(a,f,!1),delete e[a]}function ub(b,
a){var c=b.ng339,d=c&&gb[c];d&&(a?delete d.data[a]:(d.handle&&(d.events.$destroy&&d.handle({},"$destroy"),Nc(b)),delete gb[c],b.ng339=t))}function vb(b,a){var c=b.ng339,c=c&&gb[c];a&&!c&&(b.ng339=c=++Ef,c=gb[c]={events:{},data:{},handle:t});return c}function Vb(b,a,c){if(Kc(b)){var d=x(c),e=!d&&a&&!D(a),f=!a;b=(b=vb(b,!e))&&b.data;if(d)b[a]=c;else{if(f)return b;if(e)return b&&b[a];Q(b,a)}}}function wb(b,a){return b.getAttribute?-1<(" "+(b.getAttribute("class")||"")+" ").replace(/[\n\t]/g," ").indexOf(" "+
a+" "):!1}function xb(b,a){a&&b.setAttribute&&m(a.split(" "),function(a){b.setAttribute("class",T((" "+(b.getAttribute("class")||"")+" ").replace(/[\n\t]/g," ").replace(" "+T(a)+" "," ")))})}function yb(b,a){if(a&&b.setAttribute){var c=(" "+(b.getAttribute("class")||"")+" ").replace(/[\n\t]/g," ");m(a.split(" "),function(a){a=T(a);-1===c.indexOf(" "+a+" ")&&(c+=a+" ")});b.setAttribute("class",T(c))}}function Mc(b,a){if(a)if(a.nodeType)b[b.length++]=a;else{var c=a.length;if("number"===typeof c&&a.window!==
a){if(c)for(var d=0;d<c;d++)b[b.length++]=a[d]}else b[b.length++]=a}}function Oc(b,a){return zb(b,"$"+(a||"ngController")+"Controller")}function zb(b,a,c){9==b.nodeType&&(b=b.documentElement);for(a=G(a)?a:[a];b;){for(var d=0,e=a.length;d<e;d++)if((c=z.data(b,a[d]))!==t)return c;b=b.parentNode||11===b.nodeType&&b.host}}function Pc(b){for(tb(b,!0);b.firstChild;)b.removeChild(b.firstChild)}function Wb(b,a){a||tb(b);var c=b.parentNode;c&&c.removeChild(b)}function Ff(b,a){a=a||O;if("complete"===a.document.readyState)a.setTimeout(b);
else z(a).on("load",b)}function Qc(b,a){var c=Ab[a.toLowerCase()];return c&&Rc[ta(b)]&&c}function Gf(b,a){var c=b.nodeName;return("INPUT"===c||"TEXTAREA"===c)&&Sc[a]}function Hf(b,a){var c=function(c,e){c.isDefaultPrevented=function(){return c.defaultPrevented};var f=a[e||c.type],g=f?f.length:0;if(g){if(y(c.immediatePropagationStopped)){var h=c.stopImmediatePropagation;c.stopImmediatePropagation=function(){c.immediatePropagationStopped=!0;c.stopPropagation&&c.stopPropagation();h&&h.call(c)}}c.isImmediatePropagationStopped=
function(){return!0===c.immediatePropagationStopped};1<g&&(f=ia(f));for(var l=0;l<g;l++)c.isImmediatePropagationStopped()||f[l].call(b,c)}};c.elem=b;return c}function wf(){this.$get=function(){return Q(R,{hasClass:function(b,a){b.attr&&(b=b[0]);return wb(b,a)},addClass:function(b,a){b.attr&&(b=b[0]);return yb(b,a)},removeClass:function(b,a){b.attr&&(b=b[0]);return xb(b,a)}})}}function Ga(b,a){var c=b&&b.$$hashKey;if(c)return"function"===typeof c&&(c=b.$$hashKey()),c;c=typeof b;return c="function"==
c||"object"==c&&null!==b?b.$$hashKey=c+":"+(a||Ud)():c+":"+b}function Ua(b,a){if(a){var c=0;this.nextUid=function(){return++c}}m(b,this.put,this)}function If(b){return(b=b.toString().replace(Tc,"").match(Uc))?"function("+(b[1]||"").replace(/[\s\r\n]+/," ")+")":"fn"}function eb(b,a){function c(a){return function(b,c){if(D(b))m(b,nc(a));else return a(b,c)}}function d(a,b){Ta(a,"service");if(C(b)||G(b))b=r.instantiate(b);if(!b.$get)throw Ha("pget",a);return q[a+"Provider"]=b}function e(a,b){return function(){var c=
B.invoke(b,this);if(y(c))throw Ha("undef",a);return c}}function f(a,b,c){return d(a,{$get:!1!==c?e(a,b):b})}function g(a){pb(y(a)||G(a),"modulesToLoad","not an array");var b=[],c;m(a,function(a){function d(a){var b,c;b=0;for(c=a.length;b<c;b++){var e=a[b],f=r.get(e[0]);f[e[1]].apply(f,e[2])}}if(!n.get(a)){n.put(a,!0);try{I(a)?(c=Rb(a),b=b.concat(g(c.requires)).concat(c._runBlocks),d(c._invokeQueue),d(c._configBlocks)):C(a)?b.push(r.invoke(a)):G(a)?b.push(r.invoke(a)):Sa(a,"module")}catch(e){throw G(a)&&
(a=a[a.length-1]),e.message&&e.stack&&-1==e.stack.indexOf(e.message)&&(e=e.message+"\n"+e.stack),Ha("modulerr",a,e.stack||e.message||e);}}});return b}function h(b,c){function d(a,e){if(b.hasOwnProperty(a)){if(b[a]===l)throw Ha("cdep",a+" <- "+k.join(" <- "));return b[a]}try{return k.unshift(a),b[a]=l,b[a]=c(a,e)}catch(f){throw b[a]===l&&delete b[a],f;}finally{k.shift()}}function e(b,c,f,g){"string"===typeof f&&(g=f,f=null);var h=[],k=eb.$$annotate(b,a,g),l,r,n;r=0;for(l=k.length;r<l;r++){n=k[r];if("string"!==
typeof n)throw Ha("itkn",n);h.push(f&&f.hasOwnProperty(n)?f[n]:d(n,g))}G(b)&&(b=b[l]);return b.apply(c,h)}return{invoke:e,instantiate:function(a,b,c){var d=Object.create((G(a)?a[a.length-1]:a).prototype||null);a=e(a,d,b,c);return D(a)||C(a)?a:d},get:d,annotate:eb.$$annotate,has:function(a){return q.hasOwnProperty(a+"Provider")||b.hasOwnProperty(a)}}}a=!0===a;var l={},k=[],n=new Ua([],!0),q={$provide:{provider:c(d),factory:c(f),service:c(function(a,b){return f(a,["$injector",function(a){return a.instantiate(b)}])}),
value:c(function(a,b){return f(a,qa(b),!1)}),constant:c(function(a,b){Ta(a,"constant");q[a]=b;u[a]=b}),decorator:function(a,b){var c=r.get(a+"Provider"),d=c.$get;c.$get=function(){var a=B.invoke(d,c);return B.invoke(b,null,{$delegate:a})}}}},r=q.$injector=h(q,function(a,b){aa.isString(b)&&k.push(b);throw Ha("unpr",k.join(" <- "));}),u={},B=u.$injector=h(u,function(a,b){var c=r.get(a+"Provider",b);return B.invoke(c.$get,c,t,a)});m(g(b),function(a){a&&B.invoke(a)});return B}function Qe(){var b=!0;this.disableAutoScrolling=
function(){b=!1};this.$get=["$window","$location","$rootScope",function(a,c,d){function e(a){var b=null;Array.prototype.some.call(a,function(a){if("a"===ta(a))return b=a,!0});return b}function f(b){if(b){b.scrollIntoView();var c;c=g.yOffset;C(c)?c=c():rc(c)?(c=c[0],c="fixed"!==a.getComputedStyle(c).position?0:c.getBoundingClientRect().bottom):X(c)||(c=0);c&&(b=b.getBoundingClientRect().top,a.scrollBy(0,b-c))}else a.scrollTo(0,0)}function g(a){a=I(a)?a:c.hash();var b;a?(b=h.getElementById(a))?f(b):
(b=e(h.getElementsByName(a)))?f(b):"top"===a&&f(null):f(null)}var h=a.document;b&&d.$watch(function(){return c.hash()},function(a,b){a===b&&""===a||Ff(function(){d.$evalAsync(g)})});return g}]}function hb(b,a){if(!b&&!a)return"";if(!b)return a;if(!a)return b;G(b)&&(b=b.join(" "));G(a)&&(a=a.join(" "));return b+" "+a}function Jf(b){I(b)&&(b=b.split(" "));var a=ga();m(b,function(b){b.length&&(a[b]=!0)});return a}function Ia(b){return D(b)?b:{}}function Kf(b,a,c,d){function e(a){try{a.apply(null,xa.call(arguments,
1))}finally{if(B--,0===B)for(;K.length;)try{K.pop()()}catch(b){c.error(b)}}}function f(){g();h()}function g(){a:{try{w=n.state;break a}catch(a){}w=void 0}w=y(w)?null:w;ka(w,F)&&(w=F);F=w}function h(){if(A!==l.url()||p!==w)A=l.url(),p=w,m(N,function(a){a(l.url(),w)})}var l=this,k=b.location,n=b.history,q=b.setTimeout,r=b.clearTimeout,u={};l.isMock=!1;var B=0,K=[];l.$$completeOutstandingRequest=e;l.$$incOutstandingRequestCount=function(){B++};l.notifyWhenNoOutstandingRequests=function(a){0===B?a():
K.push(a)};var w,p,A=k.href,s=a.find("base"),H=null;g();p=w;l.url=function(a,c,e){y(e)&&(e=null);k!==b.location&&(k=b.location);n!==b.history&&(n=b.history);if(a){var f=p===e;if(A===a&&(!d.history||f))return l;var h=A&&Ja(A)===Ja(a);A=a;p=e;if(!d.history||h&&f){if(!h||H)H=a;c?k.replace(a):h?(c=k,e=a.indexOf("#"),a=-1===e?"":a.substr(e),c.hash=a):k.href=a}else n[c?"replaceState":"pushState"](e,"",a),g(),p=w;return l}return H||k.href.replace(/%27/g,"'")};l.state=function(){return w};var N=[],J=!1,F=
null;l.onUrlChange=function(a){if(!J){if(d.history)z(b).on("popstate",f);z(b).on("hashchange",f);J=!0}N.push(a);return a};l.$$applicationDestroyed=function(){z(b).off("hashchange popstate",f)};l.$$checkUrlChange=h;l.baseHref=function(){var a=s.attr("href");return a?a.replace(/^(https?\:)?\/\/[^\/]*/,""):""};l.defer=function(a,b){var c;B++;c=q(function(){delete u[c];e(a)},b||0);u[c]=!0;return c};l.defer.cancel=function(a){return u[a]?(delete u[a],r(a),e(v),!0):!1}}function Ve(){this.$get=["$window",
"$log","$sniffer","$document",function(b,a,c,d){return new Kf(b,d,a,c)}]}function We(){this.$get=function(){function b(b,d){function e(a){a!=q&&(r?r==a&&(r=a.n):r=a,f(a.n,a.p),f(a,q),q=a,q.n=null)}function f(a,b){a!=b&&(a&&(a.p=b),b&&(b.n=a))}if(b in a)throw L("$cacheFactory")("iid",b);var g=0,h=Q({},d,{id:b}),l={},k=d&&d.capacity||Number.MAX_VALUE,n={},q=null,r=null;return a[b]={put:function(a,b){if(!y(b)){if(k<Number.MAX_VALUE){var c=n[a]||(n[a]={key:a});e(c)}a in l||g++;l[a]=b;g>k&&this.remove(r.key);
return b}},get:function(a){if(k<Number.MAX_VALUE){var b=n[a];if(!b)return;e(b)}return l[a]},remove:function(a){if(k<Number.MAX_VALUE){var b=n[a];if(!b)return;b==q&&(q=b.p);b==r&&(r=b.n);f(b.n,b.p);delete n[a]}delete l[a];g--},removeAll:function(){l={};g=0;n={};q=r=null},destroy:function(){n=h=l=null;delete a[b]},info:function(){return Q({},h,{size:g})}}}var a={};b.info=function(){var b={};m(a,function(a,e){b[e]=a.info()});return b};b.get=function(b){return a[b]};return b}}function qf(){this.$get=
["$cacheFactory",function(b){return b("templates")}]}function Cc(b,a){function c(a,b,c){var d=/^\s*([@&]|=(\*?))(\??)\s*(\w*)\s*$/,e={};m(a,function(a,f){var g=a.match(d);if(!g)throw ea("iscp",b,f,a,c?"controller bindings definition":"isolate scope definition");e[f]={mode:g[1][0],collection:"*"===g[2],optional:"?"===g[3],attrName:g[4]||f}});return e}function d(a){var b=a.charAt(0);if(!b||b!==M(b))throw ea("baddir",a);if(a!==a.trim())throw ea("baddir",a);}var e={},f=/^\s*directive\:\s*([\w\-]+)\s+(.*)$/,
g=/(([\w\-]+)(?:\:([^;]+))?;?)/,h=Wd("ngSrc,ngSrcset,src,srcset"),l=/^(?:(\^\^?)?(\?)?(\^\^?)?)?/,k=/^(on[a-z]+|formaction)$/;this.directive=function r(a,f){Ta(a,"directive");I(a)?(d(a),pb(f,"directiveFactory"),e.hasOwnProperty(a)||(e[a]=[],b.factory(a+"Directive",["$injector","$exceptionHandler",function(b,d){var f=[];m(e[a],function(e,g){try{var h=b.invoke(e);C(h)?h={compile:qa(h)}:!h.compile&&h.link&&(h.compile=qa(h.link));h.priority=h.priority||0;h.index=g;h.name=h.name||a;h.require=h.require||
h.controller&&h.name;h.restrict=h.restrict||"EA";var k=h,l=h,r=h.name,n={isolateScope:null,bindToController:null};D(l.scope)&&(!0===l.bindToController?(n.bindToController=c(l.scope,r,!0),n.isolateScope={}):n.isolateScope=c(l.scope,r,!1));D(l.bindToController)&&(n.bindToController=c(l.bindToController,r,!0));if(D(n.bindToController)){var S=l.controller,B=l.controllerAs;if(!S)throw ea("noctrl",r);var ha;a:if(B&&I(B))ha=B;else{if(I(S)){var m=Vc.exec(S);if(m){ha=m[3];break a}}ha=void 0}if(!ha)throw ea("noident",
r);}var s=k.$$bindings=n;D(s.isolateScope)&&(h.$$isolateBindings=s.isolateScope);h.$$moduleName=e.$$moduleName;f.push(h)}catch(t){d(t)}});return f}])),e[a].push(f)):m(a,nc(r));return this};this.aHrefSanitizationWhitelist=function(b){return x(b)?(a.aHrefSanitizationWhitelist(b),this):a.aHrefSanitizationWhitelist()};this.imgSrcSanitizationWhitelist=function(b){return x(b)?(a.imgSrcSanitizationWhitelist(b),this):a.imgSrcSanitizationWhitelist()};var n=!0;this.debugInfoEnabled=function(a){return x(a)?
(n=a,this):n};this.$get=["$injector","$interpolate","$exceptionHandler","$templateRequest","$parse","$controller","$rootScope","$document","$sce","$animate","$$sanitizeUri",function(a,b,c,d,w,p,A,s,H,N,J){function F(a,b){try{a.addClass(b)}catch(c){}}function V(a,b,c,d,e){a instanceof z||(a=z(a));m(a,function(b,c){b.nodeType==Pa&&b.nodeValue.match(/\S+/)&&(a[c]=z(b).wrap("<span></span>").parent()[0])});var f=S(a,b,a,c,d,e);V.$$addScopeClass(a);var g=null;return function(b,c,d){pb(b,"scope");d=d||{};
var e=d.parentBoundTranscludeFn,h=d.transcludeControllers;d=d.futureParentElement;e&&e.$$boundTransclude&&(e=e.$$boundTransclude);g||(g=(d=d&&d[0])?"foreignobject"!==ta(d)&&d.toString().match(/SVG/)?"svg":"html":"html");d="html"!==g?z(Xb(g,z("<div>").append(a).html())):c?Ra.clone.call(a):a;if(h)for(var l in h)d.data("$"+l+"Controller",h[l].instance);V.$$addScopeInfo(d,b);c&&c(d,b);f&&f(b,d,d,e);return d}}function S(a,b,c,d,e,f){function g(a,c,d,e){var f,l,k,r,n,u,N;if(p)for(N=Array(c.length),r=0;r<
h.length;r+=3)f=h[r],N[f]=c[f];else N=c;r=0;for(n=h.length;r<n;)if(l=N[h[r++]],c=h[r++],f=h[r++],c){if(c.scope){if(k=a.$new(),V.$$addScopeInfo(z(l),k),u=c.$$destroyBindings)c.$$destroyBindings=null,k.$on("$destroyed",u)}else k=a;u=c.transcludeOnThisElement?P(a,c.transclude,e):!c.templateOnThisElement&&e?e:!e&&b?P(a,b):null;c(f,k,l,d,u,c)}else f&&f(a,l.childNodes,t,e)}for(var h=[],l,k,r,n,p,u=0;u<a.length;u++){l=new aa;k=ha(a[u],[],l,0===u?d:t,e);(f=k.length?E(k,a[u],l,b,c,null,[],[],f):null)&&f.scope&&
V.$$addScopeClass(l.$$element);l=f&&f.terminal||!(r=a[u].childNodes)||!r.length?null:S(r,f?(f.transcludeOnThisElement||!f.templateOnThisElement)&&f.transclude:b);if(f||l)h.push(u,f,l),n=!0,p=p||f;f=null}return n?g:null}function P(a,b,c){return function(d,e,f,g,h){d||(d=a.$new(!1,h),d.$$transcluded=!0);return b(d,e,{parentBoundTranscludeFn:c,transcludeControllers:f,futureParentElement:g})}}function ha(a,b,c,d,e){var h=c.$attr,l;switch(a.nodeType){case pa:x(b,va(ta(a)),"E",d,e);for(var k,r,n,p=a.attributes,
u=0,N=p&&p.length;u<N;u++){var K=!1,J=!1;k=p[u];l=k.name;r=T(k.value);k=va(l);if(n=ia.test(k))l=l.replace(Xc,"").substr(8).replace(/_(.)/g,function(a,b){return b.toUpperCase()});var S=k.replace(/(Start|End)$/,"");L(S)&&k===S+"Start"&&(K=l,J=l.substr(0,l.length-5)+"end",l=l.substr(0,l.length-6));k=va(l.toLowerCase());h[k]=l;if(n||!c.hasOwnProperty(k))c[k]=r,Qc(a,k)&&(c[k]=!0);X(a,b,r,k,n);x(b,k,"A",d,e,K,J)}a=a.className;D(a)&&(a=a.animVal);if(I(a)&&""!==a)for(;l=g.exec(a);)k=va(l[2]),x(b,k,"C",d,
e)&&(c[k]=T(l[3])),a=a.substr(l.index+l[0].length);break;case Pa:if(11===Va)for(;a.parentNode&&a.nextSibling&&a.nextSibling.nodeType===Pa;)a.nodeValue+=a.nextSibling.nodeValue,a.parentNode.removeChild(a.nextSibling);wa(b,a.nodeValue);break;case 8:try{if(l=f.exec(a.nodeValue))k=va(l[1]),x(b,k,"M",d,e)&&(c[k]=T(l[2]))}catch(B){}}b.sort(za);return b}function ya(a,b,c){var d=[],e=0;if(b&&a.hasAttribute&&a.hasAttribute(b)){do{if(!a)throw ea("uterdir",b,c);a.nodeType==pa&&(a.hasAttribute(b)&&e++,a.hasAttribute(c)&&
e--);d.push(a);a=a.nextSibling}while(0<e)}else d.push(a);return z(d)}function Wc(a,b,c){return function(d,e,f,g,h){e=ya(e[0],b,c);return a(d,e,f,g,h)}}function E(a,b,d,e,f,g,h,k,r){function n(a,b,c,d){if(a){c&&(a=Wc(a,c,d));a.require=E.require;a.directiveName=x;if(P===E||E.$$isolateScope)a=Z(a,{isolateScope:!0});h.push(a)}if(b){c&&(b=Wc(b,c,d));b.require=E.require;b.directiveName=x;if(P===E||E.$$isolateScope)b=Z(b,{isolateScope:!0});k.push(b)}}function u(a,b,c,d){var e;if(I(b)){var f=b.match(l);b=
b.substring(f[0].length);var g=f[1]||f[3],f="?"===f[2];"^^"===g?c=c.parent():e=(e=d&&d[b])&&e.instance;e||(d="$"+b+"Controller",e=g?c.inheritedData(d):c.data(d));if(!e&&!f)throw ea("ctreq",b,a);}else if(G(b))for(e=[],g=0,f=b.length;g<f;g++)e[g]=u(a,b[g],c,d);return e||null}function N(a,b,c,d,e,f){var g=ga(),h;for(h in d){var l=d[h],k={$scope:l===P||l.$$isolateScope?e:f,$element:a,$attrs:b,$transclude:c},r=l.controller;"@"==r&&(r=b[l.name]);k=p(r,k,!0,l.controllerAs);g[l.name]=k;s||a.data("$"+l.name+
"Controller",k.instance)}return g}function K(a,c,e,f,g,l){function r(a,b,c){var d;$a(a)||(c=b,b=a,a=t);s&&(d=A);c||(c=s?ja.parent():ja);return g(a,b,d,c,ya)}var n,p,J,B,A,ha,ja;b===e?(f=d,ja=d.$$element):(ja=z(e),f=new aa(ja,d));P&&(B=c.$new(!0));g&&(ha=r,ha.$$boundTransclude=g);w&&(A=N(ja,f,ha,w,B,c));P&&(V.$$addScopeInfo(ja,B,!0,!(F&&(F===P||F===P.$$originalDirective))),V.$$addScopeClass(ja,!0),B.$$isolateBindings=P.$$isolateBindings,Y(c,f,B,B.$$isolateBindings,P,B));if(A){var m=P||S,H;m&&A[m.name]&&
(p=m.$$bindings.bindToController,(J=A[m.name])&&J.identifier&&p&&(H=J,l.$$destroyBindings=Y(c,f,J.instance,p,m)));for(n in A){J=A[n];var E=J();E!==J.instance&&(J.instance=E,ja.data("$"+n+"Controller",E),J===H&&(l.$$destroyBindings(),l.$$destroyBindings=Y(c,f,E,p,m)))}}n=0;for(l=h.length;n<l;n++)p=h[n],$(p,p.isolateScope?B:c,ja,f,p.require&&u(p.directiveName,p.require,ja,A),ha);var ya=c;P&&(P.template||null===P.templateUrl)&&(ya=B);a&&a(ya,e.childNodes,t,g);for(n=k.length-1;0<=n;n--)p=k[n],$(p,p.isolateScope?
B:c,ja,f,p.require&&u(p.directiveName,p.require,ja,A),ha)}r=r||{};for(var J=-Number.MAX_VALUE,S=r.newScopeDirective,w=r.controllerDirectives,P=r.newIsolateScopeDirective,F=r.templateDirective,A=r.nonTlbTranscludeDirective,m=!1,H=!1,s=r.hasElementTranscludeDirective,ba=d.$$element=z(b),E,x,v,y=e,za,wa=0,L=a.length;wa<L;wa++){E=a[wa];var Bb=E.$$start,M=E.$$end;Bb&&(ba=ya(b,Bb,M));v=t;if(J>E.priority)break;if(v=E.scope)E.templateUrl||(D(v)?(O("new/isolated scope",P||S,E,ba),P=E):O("new/isolated scope",
P,E,ba)),S=S||E;x=E.name;!E.templateUrl&&E.controller&&(v=E.controller,w=w||ga(),O("'"+x+"' controller",w[x],E,ba),w[x]=E);if(v=E.transclude)m=!0,E.$$tlb||(O("transclusion",A,E,ba),A=E),"element"==v?(s=!0,J=E.priority,v=ba,ba=d.$$element=z(W.createComment(" "+x+": "+d[x]+" ")),b=ba[0],U(f,xa.call(v,0),b),y=V(v,e,J,g&&g.name,{nonTlbTranscludeDirective:A})):(v=z(Ub(b)).contents(),ba.empty(),y=V(v,e));if(E.template)if(H=!0,O("template",F,E,ba),F=E,v=C(E.template)?E.template(ba,d):E.template,v=fa(v),
E.replace){g=E;v=Sb.test(v)?Yc(Xb(E.templateNamespace,T(v))):[];b=v[0];if(1!=v.length||b.nodeType!==pa)throw ea("tplrt",x,"");U(f,ba,b);L={$attr:{}};v=ha(b,[],L);var Q=a.splice(wa+1,a.length-(wa+1));P&&Zc(v);a=a.concat(v).concat(Q);$c(d,L);L=a.length}else ba.html(v);if(E.templateUrl)H=!0,O("template",F,E,ba),F=E,E.replace&&(g=E),K=Lf(a.splice(wa,a.length-wa),ba,d,f,m&&y,h,k,{controllerDirectives:w,newScopeDirective:S!==E&&S,newIsolateScopeDirective:P,templateDirective:F,nonTlbTranscludeDirective:A}),
L=a.length;else if(E.compile)try{za=E.compile(ba,d,y),C(za)?n(null,za,Bb,M):za&&n(za.pre,za.post,Bb,M)}catch(R){c(R,ua(ba))}E.terminal&&(K.terminal=!0,J=Math.max(J,E.priority))}K.scope=S&&!0===S.scope;K.transcludeOnThisElement=m;K.templateOnThisElement=H;K.transclude=y;r.hasElementTranscludeDirective=s;return K}function Zc(a){for(var b=0,c=a.length;b<c;b++)a[b]=Nb(a[b],{$$isolateScope:!0})}function x(b,d,f,g,h,l,k){if(d===h)return null;h=null;if(e.hasOwnProperty(d)){var n;d=a.get(d+"Directive");for(var p=
0,u=d.length;p<u;p++)try{n=d[p],(g===t||g>n.priority)&&-1!=n.restrict.indexOf(f)&&(l&&(n=Nb(n,{$$start:l,$$end:k})),b.push(n),h=n)}catch(J){c(J)}}return h}function L(b){if(e.hasOwnProperty(b))for(var c=a.get(b+"Directive"),d=0,f=c.length;d<f;d++)if(b=c[d],b.multiElement)return!0;return!1}function $c(a,b){var c=b.$attr,d=a.$attr,e=a.$$element;m(a,function(d,e){"$"!=e.charAt(0)&&(b[e]&&b[e]!==d&&(d+=("style"===e?";":" ")+b[e]),a.$set(e,d,!0,c[e]))});m(b,function(b,f){"class"==f?(F(e,b),a["class"]=(a["class"]?
a["class"]+" ":"")+b):"style"==f?(e.attr("style",e.attr("style")+";"+b),a.style=(a.style?a.style+";":"")+b):"$"==f.charAt(0)||a.hasOwnProperty(f)||(a[f]=b,d[f]=c[f])})}function Lf(a,b,c,e,f,g,h,l){var k=[],r,n,p=b[0],u=a.shift(),J=Nb(u,{templateUrl:null,transclude:null,replace:null,$$originalDirective:u}),N=C(u.templateUrl)?u.templateUrl(b,c):u.templateUrl,B=u.templateNamespace;b.empty();d(N).then(function(d){var K,w;d=fa(d);if(u.replace){d=Sb.test(d)?Yc(Xb(B,T(d))):[];K=d[0];if(1!=d.length||K.nodeType!==
pa)throw ea("tplrt",u.name,N);d={$attr:{}};U(e,b,K);var A=ha(K,[],d);D(u.scope)&&Zc(A);a=A.concat(a);$c(c,d)}else K=p,b.html(d);a.unshift(J);r=E(a,K,c,f,b,u,g,h,l);m(e,function(a,c){a==K&&(e[c]=b[0])});for(n=S(b[0].childNodes,f);k.length;){d=k.shift();w=k.shift();var H=k.shift(),V=k.shift(),A=b[0];if(!d.$$destroyed){if(w!==p){var ya=w.className;l.hasElementTranscludeDirective&&u.replace||(A=Ub(K));U(H,z(w),A);F(z(A),ya)}w=r.transcludeOnThisElement?P(d,r.transclude,V):V;r(n,d,A,e,w,r)}}k=null});return function(a,
b,c,d,e){a=e;b.$$destroyed||(k?k.push(b,c,d,a):(r.transcludeOnThisElement&&(a=P(b,r.transclude,e)),r(n,b,c,d,a,r)))}}function za(a,b){var c=b.priority-a.priority;return 0!==c?c:a.name!==b.name?a.name<b.name?-1:1:a.index-b.index}function O(a,b,c,d){function e(a){return a?" (module: "+a+")":""}if(b)throw ea("multidir",b.name,e(b.$$moduleName),c.name,e(c.$$moduleName),a,ua(d));}function wa(a,c){var d=b(c,!0);d&&a.push({priority:0,compile:function(a){a=a.parent();var b=!!a.length;b&&V.$$addBindingClass(a);
return function(a,c){var e=c.parent();b||V.$$addBindingClass(e);V.$$addBindingInfo(e,d.expressions);a.$watch(d,function(a){c[0].nodeValue=a})}}})}function Xb(a,b){a=M(a||"html");switch(a){case "svg":case "math":var c=W.createElement("div");c.innerHTML="<"+a+">"+b+"</"+a+">";return c.childNodes[0].childNodes;default:return b}}function R(a,b){if("srcdoc"==b)return H.HTML;var c=ta(a);if("xlinkHref"==b||"form"==c&&"action"==b||"img"!=c&&("src"==b||"ngSrc"==b))return H.RESOURCE_URL}function X(a,c,d,e,
f){var g=R(a,e);f=h[e]||f;var l=b(d,!0,g,f);if(l){if("multiple"===e&&"select"===ta(a))throw ea("selmulti",ua(a));c.push({priority:100,compile:function(){return{pre:function(a,c,h){c=h.$$observers||(h.$$observers={});if(k.test(e))throw ea("nodomevents");var r=h[e];r!==d&&(l=r&&b(r,!0,g,f),d=r);l&&(h[e]=l(a),(c[e]||(c[e]=[])).$$inter=!0,(h.$$observers&&h.$$observers[e].$$scope||a).$watch(l,function(a,b){"class"===e&&a!=b?h.$updateClass(a,b):h.$set(e,a)}))}}}})}}function U(a,b,c){var d=b[0],e=b.length,
f=d.parentNode,g,h;if(a)for(g=0,h=a.length;g<h;g++)if(a[g]==d){a[g++]=c;h=g+e-1;for(var l=a.length;g<l;g++,h++)h<l?a[g]=a[h]:delete a[g];a.length-=e-1;a.context===d&&(a.context=c);break}f&&f.replaceChild(c,d);a=W.createDocumentFragment();a.appendChild(d);z.hasData(d)&&(z(c).data(z(d).data()),la?(Qb=!0,la.cleanData([d])):delete z.cache[d[z.expando]]);d=1;for(e=b.length;d<e;d++)f=b[d],z(f).remove(),a.appendChild(f),delete b[d];b[0]=c;b.length=1}function Z(a,b){return Q(function(){return a.apply(null,
arguments)},a,b)}function $(a,b,d,e,f,g){try{a(b,d,e,f,g)}catch(h){c(h,ua(d))}}function Y(a,c,d,e,f,g){var h;m(e,function(e,g){var l=e.attrName,k=e.optional,r,n,p,K;switch(e.mode){case "@":k||Na.call(c,l)||(d[g]=c[l]=void 0);c.$observe(l,function(a){I(a)&&(d[g]=a)});c.$$observers[l].$$scope=a;I(c[l])&&(d[g]=b(c[l])(a));break;case "=":if(!Na.call(c,l)){if(k)break;c[l]=void 0}if(k&&!c[l])break;n=w(c[l]);K=n.literal?ka:function(a,b){return a===b||a!==a&&b!==b};p=n.assign||function(){r=d[g]=n(a);throw ea("nonassign",
c[l],f.name);};r=d[g]=n(a);k=function(b){K(b,d[g])||(K(b,r)?p(a,b=d[g]):d[g]=b);return r=b};k.$stateful=!0;k=e.collection?a.$watchCollection(c[l],k):a.$watch(w(c[l],k),null,n.literal);h=h||[];h.push(k);break;case "&":n=c.hasOwnProperty(l)?w(c[l]):v;if(n===v&&k)break;d[g]=function(b){return n(a,b)}}});e=h?function(){for(var a=0,b=h.length;a<b;++a)h[a]()}:v;return g&&e!==v?(g.$on("$destroy",e),v):e}var aa=function(a,b){if(b){var c=Object.keys(b),d,e,f;d=0;for(e=c.length;d<e;d++)f=c[d],this[f]=b[f]}else this.$attr=
{};this.$$element=a};aa.prototype={$normalize:va,$addClass:function(a){a&&0<a.length&&N.addClass(this.$$element,a)},$removeClass:function(a){a&&0<a.length&&N.removeClass(this.$$element,a)},$updateClass:function(a,b){var c=ad(a,b);c&&c.length&&N.addClass(this.$$element,c);(c=ad(b,a))&&c.length&&N.removeClass(this.$$element,c)},$set:function(a,b,d,e){var f=this.$$element[0],g=Qc(f,a),h=Gf(f,a),f=a;g?(this.$$element.prop(a,b),e=g):h&&(this[h]=b,f=h);this[a]=b;e?this.$attr[a]=e:(e=this.$attr[a])||(this.$attr[a]=
e=zc(a,"-"));g=ta(this.$$element);if("a"===g&&"href"===a||"img"===g&&"src"===a)this[a]=b=J(b,"src"===a);else if("img"===g&&"srcset"===a){for(var g="",h=T(b),l=/(\s+\d+x\s*,|\s+\d+w\s*,|\s+,|,\s+)/,l=/\s/.test(h)?l:/(,)/,h=h.split(l),l=Math.floor(h.length/2),k=0;k<l;k++)var r=2*k,g=g+J(T(h[r]),!0),g=g+(" "+T(h[r+1]));h=T(h[2*k]).split(/\s/);g+=J(T(h[0]),!0);2===h.length&&(g+=" "+T(h[1]));this[a]=b=g}!1!==d&&(null===b||b===t?this.$$element.removeAttr(e):this.$$element.attr(e,b));(a=this.$$observers)&&
m(a[f],function(a){try{a(b)}catch(d){c(d)}})},$observe:function(a,b){var c=this,d=c.$$observers||(c.$$observers=ga()),e=d[a]||(d[a]=[]);e.push(b);A.$evalAsync(function(){e.$$inter||!c.hasOwnProperty(a)||y(c[a])||b(c[a])});return function(){bb(e,b)}}};var ca=b.startSymbol(),da=b.endSymbol(),fa="{{"==ca||"}}"==da?Za:function(a){return a.replace(/\{\{/g,ca).replace(/}}/g,da)},ia=/^ngAttr[A-Z]/;V.$$addBindingInfo=n?function(a,b){var c=a.data("$binding")||[];G(b)?c=c.concat(b):c.push(b);a.data("$binding",
c)}:v;V.$$addBindingClass=n?function(a){F(a,"ng-binding")}:v;V.$$addScopeInfo=n?function(a,b,c,d){a.data(c?d?"$isolateScopeNoTemplate":"$isolateScope":"$scope",b)}:v;V.$$addScopeClass=n?function(a,b){F(a,b?"ng-isolate-scope":"ng-scope")}:v;return V}]}function va(b){return fb(b.replace(Xc,""))}function ad(b,a){var c="",d=b.split(/\s+/),e=a.split(/\s+/),f=0;a:for(;f<d.length;f++){for(var g=d[f],h=0;h<e.length;h++)if(g==e[h])continue a;c+=(0<c.length?" ":"")+g}return c}function Yc(b){b=z(b);var a=b.length;
if(1>=a)return b;for(;a--;)8===b[a].nodeType&&Mf.call(b,a,1);return b}function Xe(){var b={},a=!1;this.register=function(a,d){Ta(a,"controller");D(a)?Q(b,a):b[a]=d};this.allowGlobals=function(){a=!0};this.$get=["$injector","$window",function(c,d){function e(a,b,c,d){if(!a||!D(a.$scope))throw L("$controller")("noscp",d,b);a.$scope[b]=c}return function(f,g,h,l){var k,n,q;h=!0===h;l&&I(l)&&(q=l);if(I(f)){l=f.match(Vc);if(!l)throw Nf("ctrlfmt",f);n=l[1];q=q||l[3];f=b.hasOwnProperty(n)?b[n]:Bc(g.$scope,
n,!0)||(a?Bc(d,n,!0):t);Sa(f,n,!0)}if(h)return h=(G(f)?f[f.length-1]:f).prototype,k=Object.create(h||null),q&&e(g,q,k,n||f.name),Q(function(){var a=c.invoke(f,k,g,n);a!==k&&(D(a)||C(a))&&(k=a,q&&e(g,q,k,n||f.name));return k},{instance:k,identifier:q});k=c.instantiate(f,g,n);q&&e(g,q,k,n||f.name);return k}}]}function Ye(){this.$get=["$window",function(b){return z(b.document)}]}function Ze(){this.$get=["$log",function(b){return function(a,c){b.error.apply(b,arguments)}}]}function Yb(b){return D(b)?
ca(b)?b.toISOString():db(b):b}function df(){this.$get=function(){return function(b){if(!b)return"";var a=[];mc(b,function(b,d){null===b||y(b)||(G(b)?m(b,function(b,c){a.push(ma(d)+"="+ma(Yb(b)))}):a.push(ma(d)+"="+ma(Yb(b))))});return a.join("&")}}}function ef(){this.$get=function(){return function(b){function a(b,e,f){null===b||y(b)||(G(b)?m(b,function(b,c){a(b,e+"["+(D(b)?c:"")+"]")}):D(b)&&!ca(b)?mc(b,function(b,c){a(b,e+(f?"":"[")+c+(f?"":"]"))}):c.push(ma(e)+"="+ma(Yb(b))))}if(!b)return"";var c=
[];a(b,"",!0);return c.join("&")}}}function Zb(b,a){if(I(b)){var c=b.replace(Of,"").trim();if(c){var d=a("Content-Type");(d=d&&0===d.indexOf(bd))||(d=(d=c.match(Pf))&&Qf[d[0]].test(c));d&&(b=uc(c))}}return b}function cd(b){var a=ga(),c;I(b)?m(b.split("\n"),function(b){c=b.indexOf(":");var e=M(T(b.substr(0,c)));b=T(b.substr(c+1));e&&(a[e]=a[e]?a[e]+", "+b:b)}):D(b)&&m(b,function(b,c){var f=M(c),g=T(b);f&&(a[f]=a[f]?a[f]+", "+g:g)});return a}function dd(b){var a;return function(c){a||(a=cd(b));return c?
(c=a[M(c)],void 0===c&&(c=null),c):a}}function ed(b,a,c,d){if(C(d))return d(b,a,c);m(d,function(d){b=d(b,a,c)});return b}function cf(){var b=this.defaults={transformResponse:[Zb],transformRequest:[function(a){return D(a)&&"[object File]"!==sa.call(a)&&"[object Blob]"!==sa.call(a)&&"[object FormData]"!==sa.call(a)?db(a):a}],headers:{common:{Accept:"application/json, text/plain, */*"},post:ia($b),put:ia($b),patch:ia($b)},xsrfCookieName:"XSRF-TOKEN",xsrfHeaderName:"X-XSRF-TOKEN",paramSerializer:"$httpParamSerializer"},
a=!1;this.useApplyAsync=function(b){return x(b)?(a=!!b,this):a};var c=!0;this.useLegacyPromiseExtensions=function(a){return x(a)?(c=!!a,this):c};var d=this.interceptors=[];this.$get=["$httpBackend","$$cookieReader","$cacheFactory","$rootScope","$q","$injector",function(e,f,g,h,l,k){function n(a){function d(a){var b=Q({},a);b.data=a.data?ed(a.data,a.headers,a.status,f.transformResponse):a.data;a=a.status;return 200<=a&&300>a?b:l.reject(b)}function e(a,b){var c,d={};m(a,function(a,e){C(a)?(c=a(b),null!=
c&&(d[e]=c)):d[e]=a});return d}if(!aa.isObject(a))throw L("$http")("badreq",a);var f=Q({method:"get",transformRequest:b.transformRequest,transformResponse:b.transformResponse,paramSerializer:b.paramSerializer},a);f.headers=function(a){var c=b.headers,d=Q({},a.headers),f,g,h,c=Q({},c.common,c[M(a.method)]);a:for(f in c){g=M(f);for(h in d)if(M(h)===g)continue a;d[f]=c[f]}return e(d,ia(a))}(a);f.method=rb(f.method);f.paramSerializer=I(f.paramSerializer)?k.get(f.paramSerializer):f.paramSerializer;var g=
[function(a){var c=a.headers,e=ed(a.data,dd(c),t,a.transformRequest);y(e)&&m(c,function(a,b){"content-type"===M(b)&&delete c[b]});y(a.withCredentials)&&!y(b.withCredentials)&&(a.withCredentials=b.withCredentials);return q(a,e).then(d,d)},t],h=l.when(f);for(m(B,function(a){(a.request||a.requestError)&&g.unshift(a.request,a.requestError);(a.response||a.responseError)&&g.push(a.response,a.responseError)});g.length;){a=g.shift();var r=g.shift(),h=h.then(a,r)}c?(h.success=function(a){Sa(a,"fn");h.then(function(b){a(b.data,
b.status,b.headers,f)});return h},h.error=function(a){Sa(a,"fn");h.then(null,function(b){a(b.data,b.status,b.headers,f)});return h}):(h.success=fd("success"),h.error=fd("error"));return h}function q(c,d){function g(b,c,d,e){function f(){k(c,b,d,e)}F&&(200<=b&&300>b?F.put(P,[b,c,cd(d),e]):F.remove(P));a?h.$applyAsync(f):(f(),h.$$phase||h.$apply())}function k(a,b,d,e){b=Math.max(b,0);(200<=b&&300>b?N.resolve:N.reject)({data:a,status:b,headers:dd(d),config:c,statusText:e})}function q(a){k(a.data,a.status,
ia(a.headers()),a.statusText)}function B(){var a=n.pendingRequests.indexOf(c);-1!==a&&n.pendingRequests.splice(a,1)}var N=l.defer(),J=N.promise,F,m,S=c.headers,P=r(c.url,c.paramSerializer(c.params));n.pendingRequests.push(c);J.then(B,B);!c.cache&&!b.cache||!1===c.cache||"GET"!==c.method&&"JSONP"!==c.method||(F=D(c.cache)?c.cache:D(b.cache)?b.cache:u);F&&(m=F.get(P),x(m)?m&&C(m.then)?m.then(q,q):G(m)?k(m[1],m[0],ia(m[2]),m[3]):k(m,200,{},"OK"):F.put(P,J));y(m)&&((m=gd(c.url)?f()[c.xsrfCookieName||
b.xsrfCookieName]:t)&&(S[c.xsrfHeaderName||b.xsrfHeaderName]=m),e(c.method,P,d,g,S,c.timeout,c.withCredentials,c.responseType));return J}function r(a,b){0<b.length&&(a+=(-1==a.indexOf("?")?"?":"&")+b);return a}var u=g("$http");b.paramSerializer=I(b.paramSerializer)?k.get(b.paramSerializer):b.paramSerializer;var B=[];m(d,function(a){B.unshift(I(a)?k.get(a):k.invoke(a))});n.pendingRequests=[];(function(a){m(arguments,function(a){n[a]=function(b,c){return n(Q({},c||{},{method:a,url:b}))}})})("get","delete",
"head","jsonp");(function(a){m(arguments,function(a){n[a]=function(b,c,d){return n(Q({},d||{},{method:a,url:b,data:c}))}})})("post","put","patch");n.defaults=b;return n}]}function Rf(){return new O.XMLHttpRequest}function ff(){this.$get=["$browser","$window","$document",function(b,a,c){return Sf(b,Rf,b.defer,a.angular.callbacks,c[0])}]}function Sf(b,a,c,d,e){function f(a,b,c){var f=e.createElement("script"),n=null;f.type="text/javascript";f.src=a;f.async=!0;n=function(a){f.removeEventListener("load",
n,!1);f.removeEventListener("error",n,!1);e.body.removeChild(f);f=null;var g=-1,u="unknown";a&&("load"!==a.type||d[b].called||(a={type:"error"}),u=a.type,g="error"===a.type?404:200);c&&c(g,u)};f.addEventListener("load",n,!1);f.addEventListener("error",n,!1);e.body.appendChild(f);return n}return function(e,h,l,k,n,q,r,u){function B(){p&&p();A&&A.abort()}function K(a,d,e,f,g){H!==t&&c.cancel(H);p=A=null;a(d,e,f,g);b.$$completeOutstandingRequest(v)}b.$$incOutstandingRequestCount();h=h||b.url();if("jsonp"==
M(e)){var w="_"+(d.counter++).toString(36);d[w]=function(a){d[w].data=a;d[w].called=!0};var p=f(h.replace("JSON_CALLBACK","angular.callbacks."+w),w,function(a,b){K(k,a,d[w].data,"",b);d[w]=v})}else{var A=a();A.open(e,h,!0);m(n,function(a,b){x(a)&&A.setRequestHeader(b,a)});A.onload=function(){var a=A.statusText||"",b="response"in A?A.response:A.responseText,c=1223===A.status?204:A.status;0===c&&(c=b?200:"file"==Aa(h).protocol?404:0);K(k,c,b,A.getAllResponseHeaders(),a)};e=function(){K(k,-1,null,null,
"")};A.onerror=e;A.onabort=e;r&&(A.withCredentials=!0);if(u)try{A.responseType=u}catch(s){if("json"!==u)throw s;}A.send(l)}if(0<q)var H=c(B,q);else q&&C(q.then)&&q.then(B)}}function af(){var b="{{",a="}}";this.startSymbol=function(a){return a?(b=a,this):b};this.endSymbol=function(b){return b?(a=b,this):a};this.$get=["$parse","$exceptionHandler","$sce",function(c,d,e){function f(a){return"\\\\\\"+a}function g(c){return c.replace(n,b).replace(q,a)}function h(f,h,n,q){function w(a){try{var b=a;a=n?e.getTrusted(n,
b):e.valueOf(b);var c;if(q&&!x(a))c=a;else if(null==a)c="";else{switch(typeof a){case "string":break;case "number":a=""+a;break;default:a=db(a)}c=a}return c}catch(g){d(Ka.interr(f,g))}}q=!!q;for(var p,m,s=0,H=[],N=[],J=f.length,F=[],V=[];s<J;)if(-1!=(p=f.indexOf(b,s))&&-1!=(m=f.indexOf(a,p+l)))s!==p&&F.push(g(f.substring(s,p))),s=f.substring(p+l,m),H.push(s),N.push(c(s,w)),s=m+k,V.push(F.length),F.push("");else{s!==J&&F.push(g(f.substring(s)));break}n&&1<F.length&&Ka.throwNoconcat(f);if(!h||H.length){var S=
function(a){for(var b=0,c=H.length;b<c;b++){if(q&&y(a[b]))return;F[V[b]]=a[b]}return F.join("")};return Q(function(a){var b=0,c=H.length,e=Array(c);try{for(;b<c;b++)e[b]=N[b](a);return S(e)}catch(g){d(Ka.interr(f,g))}},{exp:f,expressions:H,$$watchDelegate:function(a,b){var c;return a.$watchGroup(N,function(d,e){var f=S(d);C(b)&&b.call(this,f,d!==e?c:f,a);c=f})}})}}var l=b.length,k=a.length,n=new RegExp(b.replace(/./g,f),"g"),q=new RegExp(a.replace(/./g,f),"g");h.startSymbol=function(){return b};h.endSymbol=
function(){return a};return h}]}function bf(){this.$get=["$rootScope","$window","$q","$$q",function(b,a,c,d){function e(e,h,l,k){var n=4<arguments.length,q=n?xa.call(arguments,4):[],r=a.setInterval,u=a.clearInterval,B=0,K=x(k)&&!k,w=(K?d:c).defer(),p=w.promise;l=x(l)?l:0;p.then(null,null,n?function(){e.apply(null,q)}:e);p.$$intervalId=r(function(){w.notify(B++);0<l&&B>=l&&(w.resolve(B),u(p.$$intervalId),delete f[p.$$intervalId]);K||b.$apply()},h);f[p.$$intervalId]=w;return p}var f={};e.cancel=function(b){return b&&
b.$$intervalId in f?(f[b.$$intervalId].reject("canceled"),a.clearInterval(b.$$intervalId),delete f[b.$$intervalId],!0):!1};return e}]}function ac(b){b=b.split("/");for(var a=b.length;a--;)b[a]=nb(b[a]);return b.join("/")}function hd(b,a){var c=Aa(b);a.$$protocol=c.protocol;a.$$host=c.hostname;a.$$port=Y(c.port)||Tf[c.protocol]||null}function id(b,a){var c="/"!==b.charAt(0);c&&(b="/"+b);var d=Aa(b);a.$$path=decodeURIComponent(c&&"/"===d.pathname.charAt(0)?d.pathname.substring(1):d.pathname);a.$$search=
xc(d.search);a.$$hash=decodeURIComponent(d.hash);a.$$path&&"/"!=a.$$path.charAt(0)&&(a.$$path="/"+a.$$path)}function ra(b,a){if(0===a.indexOf(b))return a.substr(b.length)}function Ja(b){var a=b.indexOf("#");return-1==a?b:b.substr(0,a)}function Cb(b){return b.replace(/(#.+)|#$/,"$1")}function bc(b,a,c){this.$$html5=!0;c=c||"";hd(b,this);this.$$parse=function(b){var c=ra(a,b);if(!I(c))throw Db("ipthprfx",b,a);id(c,this);this.$$path||(this.$$path="/");this.$$compose()};this.$$compose=function(){var b=
Pb(this.$$search),c=this.$$hash?"#"+nb(this.$$hash):"";this.$$url=ac(this.$$path)+(b?"?"+b:"")+c;this.$$absUrl=a+this.$$url.substr(1)};this.$$parseLinkUrl=function(d,e){if(e&&"#"===e[0])return this.hash(e.slice(1)),!0;var f,g;(f=ra(b,d))!==t?(g=f,g=(f=ra(c,f))!==t?a+(ra("/",f)||f):b+g):(f=ra(a,d))!==t?g=a+f:a==d+"/"&&(g=a);g&&this.$$parse(g);return!!g}}function cc(b,a,c){hd(b,this);this.$$parse=function(d){var e=ra(b,d)||ra(a,d),f;y(e)||"#"!==e.charAt(0)?this.$$html5?f=e:(f="",y(e)&&(b=d,this.replace())):
(f=ra(c,e),y(f)&&(f=e));id(f,this);d=this.$$path;var e=b,g=/^\/[A-Z]:(\/.*)/;0===f.indexOf(e)&&(f=f.replace(e,""));g.exec(f)||(d=(f=g.exec(d))?f[1]:d);this.$$path=d;this.$$compose()};this.$$compose=function(){var a=Pb(this.$$search),e=this.$$hash?"#"+nb(this.$$hash):"";this.$$url=ac(this.$$path)+(a?"?"+a:"")+e;this.$$absUrl=b+(this.$$url?c+this.$$url:"")};this.$$parseLinkUrl=function(a,c){return Ja(b)==Ja(a)?(this.$$parse(a),!0):!1}}function jd(b,a,c){this.$$html5=!0;cc.apply(this,arguments);this.$$parseLinkUrl=
function(d,e){if(e&&"#"===e[0])return this.hash(e.slice(1)),!0;var f,g;b==Ja(d)?f=d:(g=ra(a,d))?f=b+c+g:a===d+"/"&&(f=a);f&&this.$$parse(f);return!!f};this.$$compose=function(){var a=Pb(this.$$search),e=this.$$hash?"#"+nb(this.$$hash):"";this.$$url=ac(this.$$path)+(a?"?"+a:"")+e;this.$$absUrl=b+c+this.$$url}}function Eb(b){return function(){return this[b]}}function kd(b,a){return function(c){if(y(c))return this[b];this[b]=a(c);this.$$compose();return this}}function gf(){var b="",a={enabled:!1,requireBase:!0,
rewriteLinks:!0};this.hashPrefix=function(a){return x(a)?(b=a,this):b};this.html5Mode=function(b){return ab(b)?(a.enabled=b,this):D(b)?(ab(b.enabled)&&(a.enabled=b.enabled),ab(b.requireBase)&&(a.requireBase=b.requireBase),ab(b.rewriteLinks)&&(a.rewriteLinks=b.rewriteLinks),this):a};this.$get=["$rootScope","$browser","$sniffer","$rootElement","$window",function(c,d,e,f,g){function h(a,b,c){var e=k.url(),f=k.$$state;try{d.url(a,b,c),k.$$state=d.state()}catch(g){throw k.url(e),k.$$state=f,g;}}function l(a,
b){c.$broadcast("$locationChangeSuccess",k.absUrl(),a,k.$$state,b)}var k,n;n=d.baseHref();var q=d.url(),r;if(a.enabled){if(!n&&a.requireBase)throw Db("nobase");r=q.substring(0,q.indexOf("/",q.indexOf("//")+2))+(n||"/");n=e.history?bc:jd}else r=Ja(q),n=cc;var u=r.substr(0,Ja(r).lastIndexOf("/")+1);k=new n(r,u,"#"+b);k.$$parseLinkUrl(q,q);k.$$state=d.state();var B=/^\s*(javascript|mailto):/i;f.on("click",function(b){if(a.rewriteLinks&&!b.ctrlKey&&!b.metaKey&&!b.shiftKey&&2!=b.which&&2!=b.button){for(var e=
z(b.target);"a"!==ta(e[0]);)if(e[0]===f[0]||!(e=e.parent())[0])return;var h=e.prop("href"),l=e.attr("href")||e.attr("xlink:href");D(h)&&"[object SVGAnimatedString]"===h.toString()&&(h=Aa(h.animVal).href);B.test(h)||!h||e.attr("target")||b.isDefaultPrevented()||!k.$$parseLinkUrl(h,l)||(b.preventDefault(),k.absUrl()!=d.url()&&(c.$apply(),g.angular["ff-684208-preventDefault"]=!0))}});Cb(k.absUrl())!=Cb(q)&&d.url(k.absUrl(),!0);var K=!0;d.onUrlChange(function(a,b){y(ra(u,a))?g.location.href=a:(c.$evalAsync(function(){var d=
k.absUrl(),e=k.$$state,f;k.$$parse(a);k.$$state=b;f=c.$broadcast("$locationChangeStart",a,d,b,e).defaultPrevented;k.absUrl()===a&&(f?(k.$$parse(d),k.$$state=e,h(d,!1,e)):(K=!1,l(d,e)))}),c.$$phase||c.$digest())});c.$watch(function(){var a=Cb(d.url()),b=Cb(k.absUrl()),f=d.state(),g=k.$$replace,n=a!==b||k.$$html5&&e.history&&f!==k.$$state;if(K||n)K=!1,c.$evalAsync(function(){var b=k.absUrl(),d=c.$broadcast("$locationChangeStart",b,a,k.$$state,f).defaultPrevented;k.absUrl()===b&&(d?(k.$$parse(a),k.$$state=
f):(n&&h(b,g,f===k.$$state?null:k.$$state),l(a,f)))});k.$$replace=!1});return k}]}function hf(){var b=!0,a=this;this.debugEnabled=function(a){return x(a)?(b=a,this):b};this.$get=["$window",function(c){function d(a){a instanceof Error&&(a.stack?a=a.message&&-1===a.stack.indexOf(a.message)?"Error: "+a.message+"\n"+a.stack:a.stack:a.sourceURL&&(a=a.message+"\n"+a.sourceURL+":"+a.line));return a}function e(a){var b=c.console||{},e=b[a]||b.log||v;a=!1;try{a=!!e.apply}catch(l){}return a?function(){var a=
[];m(arguments,function(b){a.push(d(b))});return e.apply(b,a)}:function(a,b){e(a,null==b?"":b)}}return{log:e("log"),info:e("info"),warn:e("warn"),error:e("error"),debug:function(){var c=e("debug");return function(){b&&c.apply(a,arguments)}}()}}]}function Wa(b,a){if("__defineGetter__"===b||"__defineSetter__"===b||"__lookupGetter__"===b||"__lookupSetter__"===b||"__proto__"===b)throw da("isecfld",a);return b}function Ba(b,a){if(b){if(b.constructor===b)throw da("isecfn",a);if(b.window===b)throw da("isecwindow",
a);if(b.children&&(b.nodeName||b.prop&&b.attr&&b.find))throw da("isecdom",a);if(b===Object)throw da("isecobj",a);}return b}function ld(b,a){if(b){if(b.constructor===b)throw da("isecfn",a);if(b===Uf||b===Vf||b===Wf)throw da("isecff",a);}}function Xf(b,a){return"undefined"!==typeof b?b:a}function md(b,a){return"undefined"===typeof b?a:"undefined"===typeof a?b:b+a}function U(b,a){var c,d;switch(b.type){case s.Program:c=!0;m(b.body,function(b){U(b.expression,a);c=c&&b.expression.constant});b.constant=
c;break;case s.Literal:b.constant=!0;b.toWatch=[];break;case s.UnaryExpression:U(b.argument,a);b.constant=b.argument.constant;b.toWatch=b.argument.toWatch;break;case s.BinaryExpression:U(b.left,a);U(b.right,a);b.constant=b.left.constant&&b.right.constant;b.toWatch=b.left.toWatch.concat(b.right.toWatch);break;case s.LogicalExpression:U(b.left,a);U(b.right,a);b.constant=b.left.constant&&b.right.constant;b.toWatch=b.constant?[]:[b];break;case s.ConditionalExpression:U(b.test,a);U(b.alternate,a);U(b.consequent,
a);b.constant=b.test.constant&&b.alternate.constant&&b.consequent.constant;b.toWatch=b.constant?[]:[b];break;case s.Identifier:b.constant=!1;b.toWatch=[b];break;case s.MemberExpression:U(b.object,a);b.computed&&U(b.property,a);b.constant=b.object.constant&&(!b.computed||b.property.constant);b.toWatch=[b];break;case s.CallExpression:c=b.filter?!a(b.callee.name).$stateful:!1;d=[];m(b.arguments,function(b){U(b,a);c=c&&b.constant;b.constant||d.push.apply(d,b.toWatch)});b.constant=c;b.toWatch=b.filter&&
!a(b.callee.name).$stateful?d:[b];break;case s.AssignmentExpression:U(b.left,a);U(b.right,a);b.constant=b.left.constant&&b.right.constant;b.toWatch=[b];break;case s.ArrayExpression:c=!0;d=[];m(b.elements,function(b){U(b,a);c=c&&b.constant;b.constant||d.push.apply(d,b.toWatch)});b.constant=c;b.toWatch=d;break;case s.ObjectExpression:c=!0;d=[];m(b.properties,function(b){U(b.value,a);c=c&&b.value.constant;b.value.constant||d.push.apply(d,b.value.toWatch)});b.constant=c;b.toWatch=d;break;case s.ThisExpression:b.constant=
!1,b.toWatch=[]}}function nd(b){if(1==b.length){b=b[0].expression;var a=b.toWatch;return 1!==a.length?a:a[0]!==b?a:t}}function od(b){return b.type===s.Identifier||b.type===s.MemberExpression}function pd(b){if(1===b.body.length&&od(b.body[0].expression))return{type:s.AssignmentExpression,left:b.body[0].expression,right:{type:s.NGValueParameter},operator:"="}}function qd(b){return 0===b.body.length||1===b.body.length&&(b.body[0].expression.type===s.Literal||b.body[0].expression.type===s.ArrayExpression||
b.body[0].expression.type===s.ObjectExpression)}function rd(b,a){this.astBuilder=b;this.$filter=a}function sd(b,a){this.astBuilder=b;this.$filter=a}function Fb(b){return"constructor"==b}function dc(b){return C(b.valueOf)?b.valueOf():Yf.call(b)}function jf(){var b=ga(),a=ga();this.$get=["$filter",function(c){function d(a,b){return null==a||null==b?a===b:"object"===typeof a&&(a=dc(a),"object"===typeof a)?!1:a===b||a!==a&&b!==b}function e(a,b,c,e,f){var g=e.inputs,h;if(1===g.length){var l=d,g=g[0];return a.$watch(function(a){var b=
g(a);d(b,l)||(h=e(a,t,t,[b]),l=b&&dc(b));return h},b,c,f)}for(var k=[],n=[],q=0,m=g.length;q<m;q++)k[q]=d,n[q]=null;return a.$watch(function(a){for(var b=!1,c=0,f=g.length;c<f;c++){var l=g[c](a);if(b||(b=!d(l,k[c])))n[c]=l,k[c]=l&&dc(l)}b&&(h=e(a,t,t,n));return h},b,c,f)}function f(a,b,c,d){var e,f;return e=a.$watch(function(a){return d(a)},function(a,c,d){f=a;C(b)&&b.apply(this,arguments);x(a)&&d.$$postDigest(function(){x(f)&&e()})},c)}function g(a,b,c,d){function e(a){var b=!0;m(a,function(a){x(a)||
(b=!1)});return b}var f,g;return f=a.$watch(function(a){return d(a)},function(a,c,d){g=a;C(b)&&b.call(this,a,c,d);e(a)&&d.$$postDigest(function(){e(g)&&f()})},c)}function h(a,b,c,d){var e;return e=a.$watch(function(a){return d(a)},function(a,c,d){C(b)&&b.apply(this,arguments);e()},c)}function l(a,b){if(!b)return a;var c=a.$$watchDelegate,c=c!==g&&c!==f?function(c,d,e,f){e=a(c,d,e,f);return b(e,c,d)}:function(c,d,e,f){e=a(c,d,e,f);c=b(e,c,d);return x(e)?c:e};a.$$watchDelegate&&a.$$watchDelegate!==
e?c.$$watchDelegate=a.$$watchDelegate:b.$stateful||(c.$$watchDelegate=e,c.inputs=a.inputs?a.inputs:[a]);return c}var k=Fa().noUnsafeEval,n={csp:k,expensiveChecks:!1},q={csp:k,expensiveChecks:!0};return function(d,k,B){var m,w,p;switch(typeof d){case "string":p=d=d.trim();var s=B?a:b;m=s[p];m||(":"===d.charAt(0)&&":"===d.charAt(1)&&(w=!0,d=d.substring(2)),B=B?q:n,m=new ec(B),m=(new fc(m,c,B)).parse(d),m.constant?m.$$watchDelegate=h:w?m.$$watchDelegate=m.literal?g:f:m.inputs&&(m.$$watchDelegate=e),
s[p]=m);return l(m,k);case "function":return l(d,k);default:return v}}}]}function lf(){this.$get=["$rootScope","$exceptionHandler",function(b,a){return td(function(a){b.$evalAsync(a)},a)}]}function mf(){this.$get=["$browser","$exceptionHandler",function(b,a){return td(function(a){b.defer(a)},a)}]}function td(b,a){function c(a,b,c){function d(b){return function(c){e||(e=!0,b.call(a,c))}}var e=!1;return[d(b),d(c)]}function d(){this.$$state={status:0}}function e(a,b){return function(c){b.call(a,c)}}
function f(c){!c.processScheduled&&c.pending&&(c.processScheduled=!0,b(function(){var b,d,e;e=c.pending;c.processScheduled=!1;c.pending=t;for(var f=0,g=e.length;f<g;++f){d=e[f][0];b=e[f][c.status];try{C(b)?d.resolve(b(c.value)):1===c.status?d.resolve(c.value):d.reject(c.value)}catch(h){d.reject(h),a(h)}}}))}function g(){this.promise=new d;this.resolve=e(this,this.resolve);this.reject=e(this,this.reject);this.notify=e(this,this.notify)}var h=L("$q",TypeError);Q(d.prototype,{then:function(a,b,c){if(y(a)&&
y(b)&&y(c))return this;var d=new g;this.$$state.pending=this.$$state.pending||[];this.$$state.pending.push([d,a,b,c]);0<this.$$state.status&&f(this.$$state);return d.promise},"catch":function(a){return this.then(null,a)},"finally":function(a,b){return this.then(function(b){return k(b,!0,a)},function(b){return k(b,!1,a)},b)}});Q(g.prototype,{resolve:function(a){this.promise.$$state.status||(a===this.promise?this.$$reject(h("qcycle",a)):this.$$resolve(a))},$$resolve:function(b){var d,e;e=c(this,this.$$resolve,
this.$$reject);try{if(D(b)||C(b))d=b&&b.then;C(d)?(this.promise.$$state.status=-1,d.call(b,e[0],e[1],this.notify)):(this.promise.$$state.value=b,this.promise.$$state.status=1,f(this.promise.$$state))}catch(g){e[1](g),a(g)}},reject:function(a){this.promise.$$state.status||this.$$reject(a)},$$reject:function(a){this.promise.$$state.value=a;this.promise.$$state.status=2;f(this.promise.$$state)},notify:function(c){var d=this.promise.$$state.pending;0>=this.promise.$$state.status&&d&&d.length&&b(function(){for(var b,
e,f=0,g=d.length;f<g;f++){e=d[f][0];b=d[f][3];try{e.notify(C(b)?b(c):c)}catch(h){a(h)}}})}});var l=function(a,b){var c=new g;b?c.resolve(a):c.reject(a);return c.promise},k=function(a,b,c){var d=null;try{C(c)&&(d=c())}catch(e){return l(e,!1)}return d&&C(d.then)?d.then(function(){return l(a,b)},function(a){return l(a,!1)}):l(a,b)},n=function(a,b,c,d){var e=new g;e.resolve(a);return e.promise.then(b,c,d)},q=function u(a){if(!C(a))throw h("norslvr",a);if(!(this instanceof u))return new u(a);var b=new g;
a(function(a){b.resolve(a)},function(a){b.reject(a)});return b.promise};q.defer=function(){return new g};q.reject=function(a){var b=new g;b.reject(a);return b.promise};q.when=n;q.resolve=n;q.all=function(a){var b=new g,c=0,d=G(a)?[]:{};m(a,function(a,e){c++;n(a).then(function(a){d.hasOwnProperty(e)||(d[e]=a,--c||b.resolve(d))},function(a){d.hasOwnProperty(e)||b.reject(a)})});0===c&&b.resolve(d);return b.promise};return q}function vf(){this.$get=["$window","$timeout",function(b,a){function c(){for(var a=
0;a<n.length;a++){var b=n[a];b&&(n[a]=null,b())}k=n.length=0}function d(a){var b=n.length;k++;n.push(a);0===b&&(l=h(c));return function(){0<=b&&(b=n[b]=null,0===--k&&l&&(l(),l=null,n.length=0))}}var e=b.requestAnimationFrame||b.webkitRequestAnimationFrame,f=b.cancelAnimationFrame||b.webkitCancelAnimationFrame||b.webkitCancelRequestAnimationFrame,g=!!e,h=g?function(a){var b=e(a);return function(){f(b)}}:function(b){var c=a(b,16.66,!1);return function(){a.cancel(c)}};d.supported=g;var l,k=0,n=[];return d}]}
function kf(){function b(a){function b(){this.$$watchers=this.$$nextSibling=this.$$childHead=this.$$childTail=null;this.$$listeners={};this.$$listenerCount={};this.$$watchersCount=0;this.$id=++mb;this.$$ChildScope=null}b.prototype=a;return b}var a=10,c=L("$rootScope"),d=null,e=null;this.digestTtl=function(b){arguments.length&&(a=b);return a};this.$get=["$injector","$exceptionHandler","$parse","$browser",function(f,g,h,l){function k(a){a.currentScope.$$destroyed=!0}function n(){this.$id=++mb;this.$$phase=
this.$parent=this.$$watchers=this.$$nextSibling=this.$$prevSibling=this.$$childHead=this.$$childTail=null;this.$root=this;this.$$destroyed=!1;this.$$listeners={};this.$$listenerCount={};this.$$watchersCount=0;this.$$isolateBindings=null}function q(a){if(p.$$phase)throw c("inprog",p.$$phase);p.$$phase=a}function r(a,b){do a.$$watchersCount+=b;while(a=a.$parent)}function u(a,b,c){do a.$$listenerCount[c]-=b,0===a.$$listenerCount[c]&&delete a.$$listenerCount[c];while(a=a.$parent)}function s(){}function K(){for(;H.length;)try{H.shift()()}catch(a){g(a)}e=
null}function w(){null===e&&(e=l.defer(function(){p.$apply(K)}))}n.prototype={constructor:n,$new:function(a,c){var d;c=c||this;a?(d=new n,d.$root=this.$root):(this.$$ChildScope||(this.$$ChildScope=b(this)),d=new this.$$ChildScope);d.$parent=c;d.$$prevSibling=c.$$childTail;c.$$childHead?(c.$$childTail.$$nextSibling=d,c.$$childTail=d):c.$$childHead=c.$$childTail=d;(a||c!=this)&&d.$on("$destroy",k);return d},$watch:function(a,b,c,e){var f=h(a);if(f.$$watchDelegate)return f.$$watchDelegate(this,b,c,f,
a);var g=this,l=g.$$watchers,k={fn:b,last:s,get:f,exp:e||a,eq:!!c};d=null;C(b)||(k.fn=v);l||(l=g.$$watchers=[]);l.unshift(k);r(this,1);return function(){0<=bb(l,k)&&r(g,-1);d=null}},$watchGroup:function(a,b){function c(){h=!1;l?(l=!1,b(e,e,g)):b(e,d,g)}var d=Array(a.length),e=Array(a.length),f=[],g=this,h=!1,l=!0;if(!a.length){var k=!0;g.$evalAsync(function(){k&&b(e,e,g)});return function(){k=!1}}if(1===a.length)return this.$watch(a[0],function(a,c,f){e[0]=a;d[0]=c;b(e,a===c?e:d,f)});m(a,function(a,
b){var l=g.$watch(a,function(a,f){e[b]=a;d[b]=f;h||(h=!0,g.$evalAsync(c))});f.push(l)});return function(){for(;f.length;)f.shift()()}},$watchCollection:function(a,b){function c(a){e=a;var b,d,g,h;if(!y(e)){if(D(e))if(Da(e))for(f!==q&&(f=q,u=f.length=0,k++),a=e.length,u!==a&&(k++,f.length=u=a),b=0;b<a;b++)h=f[b],g=e[b],d=h!==h&&g!==g,d||h===g||(k++,f[b]=g);else{f!==r&&(f=r={},u=0,k++);a=0;for(b in e)e.hasOwnProperty(b)&&(a++,g=e[b],h=f[b],b in f?(d=h!==h&&g!==g,d||h===g||(k++,f[b]=g)):(u++,f[b]=g,
k++));if(u>a)for(b in k++,f)e.hasOwnProperty(b)||(u--,delete f[b])}else f!==e&&(f=e,k++);return k}}c.$stateful=!0;var d=this,e,f,g,l=1<b.length,k=0,n=h(a,c),q=[],r={},p=!0,u=0;return this.$watch(n,function(){p?(p=!1,b(e,e,d)):b(e,g,d);if(l)if(D(e))if(Da(e)){g=Array(e.length);for(var a=0;a<e.length;a++)g[a]=e[a]}else for(a in g={},e)Na.call(e,a)&&(g[a]=e[a]);else g=e})},$digest:function(){var b,f,h,k,n,r,u=a,m,w=[],E,H;q("$digest");l.$$checkUrlChange();this===p&&null!==e&&(l.defer.cancel(e),K());d=
null;do{r=!1;for(m=this;t.length;){try{H=t.shift(),H.scope.$eval(H.expression,H.locals)}catch(v){g(v)}d=null}a:do{if(k=m.$$watchers)for(n=k.length;n--;)try{if(b=k[n])if((f=b.get(m))!==(h=b.last)&&!(b.eq?ka(f,h):"number"===typeof f&&"number"===typeof h&&isNaN(f)&&isNaN(h)))r=!0,d=b,b.last=b.eq?fa(f,null):f,b.fn(f,h===s?f:h,m),5>u&&(E=4-u,w[E]||(w[E]=[]),w[E].push({msg:C(b.exp)?"fn: "+(b.exp.name||b.exp.toString()):b.exp,newVal:f,oldVal:h}));else if(b===d){r=!1;break a}}catch(y){g(y)}if(!(k=m.$$watchersCount&&
m.$$childHead||m!==this&&m.$$nextSibling))for(;m!==this&&!(k=m.$$nextSibling);)m=m.$parent}while(m=k);if((r||t.length)&&!u--)throw p.$$phase=null,c("infdig",a,w);}while(r||t.length);for(p.$$phase=null;x.length;)try{x.shift()()}catch(z){g(z)}},$destroy:function(){if(!this.$$destroyed){var a=this.$parent;this.$broadcast("$destroy");this.$$destroyed=!0;this===p&&l.$$applicationDestroyed();r(this,-this.$$watchersCount);for(var b in this.$$listenerCount)u(this,this.$$listenerCount[b],b);a&&a.$$childHead==
this&&(a.$$childHead=this.$$nextSibling);a&&a.$$childTail==this&&(a.$$childTail=this.$$prevSibling);this.$$prevSibling&&(this.$$prevSibling.$$nextSibling=this.$$nextSibling);this.$$nextSibling&&(this.$$nextSibling.$$prevSibling=this.$$prevSibling);this.$destroy=this.$digest=this.$apply=this.$evalAsync=this.$applyAsync=v;this.$on=this.$watch=this.$watchGroup=function(){return v};this.$$listeners={};this.$parent=this.$$nextSibling=this.$$prevSibling=this.$$childHead=this.$$childTail=this.$root=this.$$watchers=
null}},$eval:function(a,b){return h(a)(this,b)},$evalAsync:function(a,b){p.$$phase||t.length||l.defer(function(){t.length&&p.$digest()});t.push({scope:this,expression:a,locals:b})},$$postDigest:function(a){x.push(a)},$apply:function(a){try{q("$apply");try{return this.$eval(a)}finally{p.$$phase=null}}catch(b){g(b)}finally{try{p.$digest()}catch(c){throw g(c),c;}}},$applyAsync:function(a){function b(){c.$eval(a)}var c=this;a&&H.push(b);w()},$on:function(a,b){var c=this.$$listeners[a];c||(this.$$listeners[a]=
c=[]);c.push(b);var d=this;do d.$$listenerCount[a]||(d.$$listenerCount[a]=0),d.$$listenerCount[a]++;while(d=d.$parent);var e=this;return function(){var d=c.indexOf(b);-1!==d&&(c[d]=null,u(e,1,a))}},$emit:function(a,b){var c=[],d,e=this,f=!1,h={name:a,targetScope:e,stopPropagation:function(){f=!0},preventDefault:function(){h.defaultPrevented=!0},defaultPrevented:!1},l=cb([h],arguments,1),k,n;do{d=e.$$listeners[a]||c;h.currentScope=e;k=0;for(n=d.length;k<n;k++)if(d[k])try{d[k].apply(null,l)}catch(q){g(q)}else d.splice(k,
1),k--,n--;if(f)return h.currentScope=null,h;e=e.$parent}while(e);h.currentScope=null;return h},$broadcast:function(a,b){var c=this,d=this,e={name:a,targetScope:this,preventDefault:function(){e.defaultPrevented=!0},defaultPrevented:!1};if(!this.$$listenerCount[a])return e;for(var f=cb([e],arguments,1),h,l;c=d;){e.currentScope=c;d=c.$$listeners[a]||[];h=0;for(l=d.length;h<l;h++)if(d[h])try{d[h].apply(null,f)}catch(k){g(k)}else d.splice(h,1),h--,l--;if(!(d=c.$$listenerCount[a]&&c.$$childHead||c!==this&&
c.$$nextSibling))for(;c!==this&&!(d=c.$$nextSibling);)c=c.$parent}e.currentScope=null;return e}};var p=new n,t=p.$$asyncQueue=[],x=p.$$postDigestQueue=[],H=p.$$applyAsyncQueue=[];return p}]}function ge(){var b=/^\s*(https?|ftp|mailto|tel|file):/,a=/^\s*((https?|ftp|file|blob):|data:image\/)/;this.aHrefSanitizationWhitelist=function(a){return x(a)?(b=a,this):b};this.imgSrcSanitizationWhitelist=function(b){return x(b)?(a=b,this):a};this.$get=function(){return function(c,d){var e=d?a:b,f;f=Aa(c).href;
return""===f||f.match(e)?c:"unsafe:"+f}}}function Zf(b){if("self"===b)return b;if(I(b)){if(-1<b.indexOf("***"))throw Ca("iwcard",b);b=ud(b).replace("\\*\\*",".*").replace("\\*","[^:/.?&;]*");return new RegExp("^"+b+"$")}if(Oa(b))return new RegExp("^"+b.source+"$");throw Ca("imatcher");}function vd(b){var a=[];x(b)&&m(b,function(b){a.push(Zf(b))});return a}function of(){this.SCE_CONTEXTS=oa;var b=["self"],a=[];this.resourceUrlWhitelist=function(a){arguments.length&&(b=vd(a));return b};this.resourceUrlBlacklist=
function(b){arguments.length&&(a=vd(b));return a};this.$get=["$injector",function(c){function d(a,b){return"self"===a?gd(b):!!a.exec(b.href)}function e(a){var b=function(a){this.$$unwrapTrustedValue=function(){return a}};a&&(b.prototype=new a);b.prototype.valueOf=function(){return this.$$unwrapTrustedValue()};b.prototype.toString=function(){return this.$$unwrapTrustedValue().toString()};return b}var f=function(a){throw Ca("unsafe");};c.has("$sanitize")&&(f=c.get("$sanitize"));var g=e(),h={};h[oa.HTML]=
e(g);h[oa.CSS]=e(g);h[oa.URL]=e(g);h[oa.JS]=e(g);h[oa.RESOURCE_URL]=e(h[oa.URL]);return{trustAs:function(a,b){var c=h.hasOwnProperty(a)?h[a]:null;if(!c)throw Ca("icontext",a,b);if(null===b||b===t||""===b)return b;if("string"!==typeof b)throw Ca("itype",a);return new c(b)},getTrusted:function(c,e){if(null===e||e===t||""===e)return e;var g=h.hasOwnProperty(c)?h[c]:null;if(g&&e instanceof g)return e.$$unwrapTrustedValue();if(c===oa.RESOURCE_URL){var g=Aa(e.toString()),q,r,u=!1;q=0;for(r=b.length;q<r;q++)if(d(b[q],
g)){u=!0;break}if(u)for(q=0,r=a.length;q<r;q++)if(d(a[q],g)){u=!1;break}if(u)return e;throw Ca("insecurl",e.toString());}if(c===oa.HTML)return f(e);throw Ca("unsafe");},valueOf:function(a){return a instanceof g?a.$$unwrapTrustedValue():a}}}]}function nf(){var b=!0;this.enabled=function(a){arguments.length&&(b=!!a);return b};this.$get=["$parse","$sceDelegate",function(a,c){if(b&&8>Va)throw Ca("iequirks");var d=ia(oa);d.isEnabled=function(){return b};d.trustAs=c.trustAs;d.getTrusted=c.getTrusted;d.valueOf=
c.valueOf;b||(d.trustAs=d.getTrusted=function(a,b){return b},d.valueOf=Za);d.parseAs=function(b,c){var e=a(c);return e.literal&&e.constant?e:a(c,function(a){return d.getTrusted(b,a)})};var e=d.parseAs,f=d.getTrusted,g=d.trustAs;m(oa,function(a,b){var c=M(b);d[fb("parse_as_"+c)]=function(b){return e(a,b)};d[fb("get_trusted_"+c)]=function(b){return f(a,b)};d[fb("trust_as_"+c)]=function(b){return g(a,b)}});return d}]}function pf(){this.$get=["$window","$document",function(b,a){var c={},d=Y((/android (\d+)/.exec(M((b.navigator||
{}).userAgent))||[])[1]),e=/Boxee/i.test((b.navigator||{}).userAgent),f=a[0]||{},g,h=/^(Moz|webkit|ms)(?=[A-Z])/,l=f.body&&f.body.style,k=!1,n=!1;if(l){for(var q in l)if(k=h.exec(q)){g=k[0];g=g.substr(0,1).toUpperCase()+g.substr(1);break}g||(g="WebkitOpacity"in l&&"webkit");k=!!("transition"in l||g+"Transition"in l);n=!!("animation"in l||g+"Animation"in l);!d||k&&n||(k=I(l.webkitTransition),n=I(l.webkitAnimation))}return{history:!(!b.history||!b.history.pushState||4>d||e),hasEvent:function(a){if("input"===
a&&11>=Va)return!1;if(y(c[a])){var b=f.createElement("div");c[a]="on"+a in b}return c[a]},csp:Fa(),vendorPrefix:g,transitions:k,animations:n,android:d}}]}function rf(){this.$get=["$templateCache","$http","$q","$sce",function(b,a,c,d){function e(f,g){e.totalPendingRequests++;I(f)&&b.get(f)||(f=d.getTrustedResourceUrl(f));var h=a.defaults&&a.defaults.transformResponse;G(h)?h=h.filter(function(a){return a!==Zb}):h===Zb&&(h=null);return a.get(f,{cache:b,transformResponse:h})["finally"](function(){e.totalPendingRequests--}).then(function(a){b.put(f,
a.data);return a.data},function(a){if(!g)throw ea("tpload",f,a.status,a.statusText);return c.reject(a)})}e.totalPendingRequests=0;return e}]}function sf(){this.$get=["$rootScope","$browser","$location",function(b,a,c){return{findBindings:function(a,b,c){a=a.getElementsByClassName("ng-binding");var g=[];m(a,function(a){var d=aa.element(a).data("$binding");d&&m(d,function(d){c?(new RegExp("(^|\\s)"+ud(b)+"(\\s|\\||$)")).test(d)&&g.push(a):-1!=d.indexOf(b)&&g.push(a)})});return g},findModels:function(a,
b,c){for(var g=["ng-","data-ng-","ng\\:"],h=0;h<g.length;++h){var l=a.querySelectorAll("["+g[h]+"model"+(c?"=":"*=")+'"'+b+'"]');if(l.length)return l}},getLocation:function(){return c.url()},setLocation:function(a){a!==c.url()&&(c.url(a),b.$digest())},whenStable:function(b){a.notifyWhenNoOutstandingRequests(b)}}}]}function tf(){this.$get=["$rootScope","$browser","$q","$$q","$exceptionHandler",function(b,a,c,d,e){function f(f,l,k){C(f)||(k=l,l=f,f=v);var n=xa.call(arguments,3),q=x(k)&&!k,r=(q?d:c).defer(),
u=r.promise,m;m=a.defer(function(){try{r.resolve(f.apply(null,n))}catch(a){r.reject(a),e(a)}finally{delete g[u.$$timeoutId]}q||b.$apply()},l);u.$$timeoutId=m;g[m]=r;return u}var g={};f.cancel=function(b){return b&&b.$$timeoutId in g?(g[b.$$timeoutId].reject("canceled"),delete g[b.$$timeoutId],a.defer.cancel(b.$$timeoutId)):!1};return f}]}function Aa(b){Va&&(Z.setAttribute("href",b),b=Z.href);Z.setAttribute("href",b);return{href:Z.href,protocol:Z.protocol?Z.protocol.replace(/:$/,""):"",host:Z.host,
search:Z.search?Z.search.replace(/^\?/,""):"",hash:Z.hash?Z.hash.replace(/^#/,""):"",hostname:Z.hostname,port:Z.port,pathname:"/"===Z.pathname.charAt(0)?Z.pathname:"/"+Z.pathname}}function gd(b){b=I(b)?Aa(b):b;return b.protocol===wd.protocol&&b.host===wd.host}function uf(){this.$get=qa(O)}function xd(b){function a(a){try{return decodeURIComponent(a)}catch(b){return a}}var c=b[0]||{},d={},e="";return function(){var b,g,h,l,k;b=c.cookie||"";if(b!==e)for(e=b,b=e.split("; "),d={},h=0;h<b.length;h++)g=
b[h],l=g.indexOf("="),0<l&&(k=a(g.substring(0,l)),d[k]===t&&(d[k]=a(g.substring(l+1))));return d}}function yf(){this.$get=xd}function Jc(b){function a(c,d){if(D(c)){var e={};m(c,function(b,c){e[c]=a(c,b)});return e}return b.factory(c+"Filter",d)}this.register=a;this.$get=["$injector",function(a){return function(b){return a.get(b+"Filter")}}];a("currency",yd);a("date",zd);a("filter",$f);a("json",ag);a("limitTo",bg);a("lowercase",cg);a("number",Ad);a("orderBy",Bd);a("uppercase",dg)}function $f(){return function(b,
a,c){if(!Da(b)){if(null==b)return b;throw L("filter")("notarray",b);}var d;switch(gc(a)){case "function":break;case "boolean":case "null":case "number":case "string":d=!0;case "object":a=eg(a,c,d);break;default:return b}return Array.prototype.filter.call(b,a)}}function eg(b,a,c){var d=D(b)&&"$"in b;!0===a?a=ka:C(a)||(a=function(a,b){if(y(a))return!1;if(null===a||null===b)return a===b;if(D(b)||D(a)&&!pc(a))return!1;a=M(""+a);b=M(""+b);return-1!==a.indexOf(b)});return function(e){return d&&!D(e)?La(e,
b.$,a,!1):La(e,b,a,c)}}function La(b,a,c,d,e){var f=gc(b),g=gc(a);if("string"===g&&"!"===a.charAt(0))return!La(b,a.substring(1),c,d);if(G(b))return b.some(function(b){return La(b,a,c,d)});switch(f){case "object":var h;if(d){for(h in b)if("$"!==h.charAt(0)&&La(b[h],a,c,!0))return!0;return e?!1:La(b,a,c,!1)}if("object"===g){for(h in a)if(e=a[h],!C(e)&&!y(e)&&(f="$"===h,!La(f?b:b[h],e,c,f,f)))return!1;return!0}return c(b,a);case "function":return!1;default:return c(b,a)}}function gc(b){return null===
b?"null":typeof b}function yd(b){var a=b.NUMBER_FORMATS;return function(b,d,e){y(d)&&(d=a.CURRENCY_SYM);y(e)&&(e=a.PATTERNS[1].maxFrac);return null==b?b:Cd(b,a.PATTERNS[1],a.GROUP_SEP,a.DECIMAL_SEP,e).replace(/\u00A4/g,d)}}function Ad(b){var a=b.NUMBER_FORMATS;return function(b,d){return null==b?b:Cd(b,a.PATTERNS[0],a.GROUP_SEP,a.DECIMAL_SEP,d)}}function Cd(b,a,c,d,e){if(D(b))return"";var f=0>b;b=Math.abs(b);var g=Infinity===b;if(!g&&!isFinite(b))return"";var h=b+"",l="",k=!1,n=[];g&&(l="\u221e");
if(!g&&-1!==h.indexOf("e")){var q=h.match(/([\d\.]+)e(-?)(\d+)/);q&&"-"==q[2]&&q[3]>e+1?b=0:(l=h,k=!0)}if(g||k)0<e&&1>b&&(l=b.toFixed(e),b=parseFloat(l));else{g=(h.split(Dd)[1]||"").length;y(e)&&(e=Math.min(Math.max(a.minFrac,g),a.maxFrac));b=+(Math.round(+(b.toString()+"e"+e)).toString()+"e"+-e);var g=(""+b).split(Dd),h=g[0],g=g[1]||"",q=0,r=a.lgSize,u=a.gSize;if(h.length>=r+u)for(q=h.length-r,k=0;k<q;k++)0===(q-k)%u&&0!==k&&(l+=c),l+=h.charAt(k);for(k=q;k<h.length;k++)0===(h.length-k)%r&&0!==k&&
(l+=c),l+=h.charAt(k);for(;g.length<e;)g+="0";e&&"0"!==e&&(l+=d+g.substr(0,e))}0===b&&(f=!1);n.push(f?a.negPre:a.posPre,l,f?a.negSuf:a.posSuf);return n.join("")}function Gb(b,a,c){var d="";0>b&&(d="-",b=-b);for(b=""+b;b.length<a;)b="0"+b;c&&(b=b.substr(b.length-a));return d+b}function $(b,a,c,d){c=c||0;return function(e){e=e["get"+b]();if(0<c||e>-c)e+=c;0===e&&-12==c&&(e=12);return Gb(e,a,d)}}function Hb(b,a){return function(c,d){var e=c["get"+b](),f=rb(a?"SHORT"+b:b);return d[f][e]}}function Ed(b){var a=
(new Date(b,0,1)).getDay();return new Date(b,0,(4>=a?5:12)-a)}function Fd(b){return function(a){var c=Ed(a.getFullYear());a=+new Date(a.getFullYear(),a.getMonth(),a.getDate()+(4-a.getDay()))-+c;a=1+Math.round(a/6048E5);return Gb(a,b)}}function hc(b,a){return 0>=b.getFullYear()?a.ERAS[0]:a.ERAS[1]}function zd(b){function a(a){var b;if(b=a.match(c)){a=new Date(0);var f=0,g=0,h=b[8]?a.setUTCFullYear:a.setFullYear,l=b[8]?a.setUTCHours:a.setHours;b[9]&&(f=Y(b[9]+b[10]),g=Y(b[9]+b[11]));h.call(a,Y(b[1]),
Y(b[2])-1,Y(b[3]));f=Y(b[4]||0)-f;g=Y(b[5]||0)-g;h=Y(b[6]||0);b=Math.round(1E3*parseFloat("0."+(b[7]||0)));l.call(a,f,g,h,b)}return a}var c=/^(\d{4})-?(\d\d)-?(\d\d)(?:T(\d\d)(?::?(\d\d)(?::?(\d\d)(?:\.(\d+))?)?)?(Z|([+-])(\d\d):?(\d\d))?)?$/;return function(c,e,f){var g="",h=[],l,k;e=e||"mediumDate";e=b.DATETIME_FORMATS[e]||e;I(c)&&(c=fg.test(c)?Y(c):a(c));X(c)&&(c=new Date(c));if(!ca(c)||!isFinite(c.getTime()))return c;for(;e;)(k=gg.exec(e))?(h=cb(h,k,1),e=h.pop()):(h.push(e),e=null);var n=c.getTimezoneOffset();
f&&(n=vc(f,c.getTimezoneOffset()),c=Ob(c,f,!0));m(h,function(a){l=hg[a];g+=l?l(c,b.DATETIME_FORMATS,n):a.replace(/(^'|'$)/g,"").replace(/''/g,"'")});return g}}function ag(){return function(b,a){y(a)&&(a=2);return db(b,a)}}function bg(){return function(b,a,c){a=Infinity===Math.abs(Number(a))?Number(a):Y(a);if(isNaN(a))return b;X(b)&&(b=b.toString());if(!G(b)&&!I(b))return b;c=!c||isNaN(c)?0:Y(c);c=0>c&&c>=-b.length?b.length+c:c;return 0<=a?b.slice(c,c+a):0===c?b.slice(a,b.length):b.slice(Math.max(0,
c+a),c)}}function Bd(b){function a(a,c){c=c?-1:1;return a.map(function(a){var d=1,h=Za;if(C(a))h=a;else if(I(a)){if("+"==a.charAt(0)||"-"==a.charAt(0))d="-"==a.charAt(0)?-1:1,a=a.substring(1);if(""!==a&&(h=b(a),h.constant))var l=h(),h=function(a){return a[l]}}return{get:h,descending:d*c}})}function c(a){switch(typeof a){case "number":case "boolean":case "string":return!0;default:return!1}}return function(b,e,f){if(!Da(b))return b;G(e)||(e=[e]);0===e.length&&(e=["+"]);var g=a(e,f);g.push({get:function(){return{}},
descending:f?-1:1});b=Array.prototype.map.call(b,function(a,b){return{value:a,predicateValues:g.map(function(d){var e=d.get(a);d=typeof e;if(null===e)d="string",e="null";else if("string"===d)e=e.toLowerCase();else if("object"===d)a:{if("function"===typeof e.valueOf&&(e=e.valueOf(),c(e)))break a;if(pc(e)&&(e=e.toString(),c(e)))break a;e=b}return{value:e,type:d}})}});b.sort(function(a,b){for(var c=0,d=0,e=g.length;d<e;++d){var c=a.predicateValues[d],f=b.predicateValues[d],u=0;c.type===f.type?c.value!==
f.value&&(u=c.value<f.value?-1:1):u=c.type<f.type?-1:1;if(c=u*g[d].descending)break}return c});return b=b.map(function(a){return a.value})}}function Ma(b){C(b)&&(b={link:b});b.restrict=b.restrict||"AC";return qa(b)}function Gd(b,a,c,d,e){var f=this,g=[],h=f.$$parentForm=b.parent().controller("form")||Ib;f.$error={};f.$$success={};f.$pending=t;f.$name=e(a.name||a.ngForm||"")(c);f.$dirty=!1;f.$pristine=!0;f.$valid=!0;f.$invalid=!1;f.$submitted=!1;h.$addControl(f);f.$rollbackViewValue=function(){m(g,
function(a){a.$rollbackViewValue()})};f.$commitViewValue=function(){m(g,function(a){a.$commitViewValue()})};f.$addControl=function(a){Ta(a.$name,"input");g.push(a);a.$name&&(f[a.$name]=a)};f.$$renameControl=function(a,b){var c=a.$name;f[c]===a&&delete f[c];f[b]=a;a.$name=b};f.$removeControl=function(a){a.$name&&f[a.$name]===a&&delete f[a.$name];m(f.$pending,function(b,c){f.$setValidity(c,null,a)});m(f.$error,function(b,c){f.$setValidity(c,null,a)});m(f.$$success,function(b,c){f.$setValidity(c,null,
a)});bb(g,a)};Hd({ctrl:this,$element:b,set:function(a,b,c){var d=a[b];d?-1===d.indexOf(c)&&d.push(c):a[b]=[c]},unset:function(a,b,c){var d=a[b];d&&(bb(d,c),0===d.length&&delete a[b])},parentForm:h,$animate:d});f.$setDirty=function(){d.removeClass(b,Xa);d.addClass(b,Jb);f.$dirty=!0;f.$pristine=!1;h.$setDirty()};f.$setPristine=function(){d.setClass(b,Xa,Jb+" ng-submitted");f.$dirty=!1;f.$pristine=!0;f.$submitted=!1;m(g,function(a){a.$setPristine()})};f.$setUntouched=function(){m(g,function(a){a.$setUntouched()})};
f.$setSubmitted=function(){d.addClass(b,"ng-submitted");f.$submitted=!0;h.$setSubmitted()}}function ic(b){b.$formatters.push(function(a){return b.$isEmpty(a)?a:a.toString()})}function ib(b,a,c,d,e,f){var g=M(a[0].type);if(!e.android){var h=!1;a.on("compositionstart",function(a){h=!0});a.on("compositionend",function(){h=!1;l()})}var l=function(b){k&&(f.defer.cancel(k),k=null);if(!h){var e=a.val();b=b&&b.type;"password"===g||c.ngTrim&&"false"===c.ngTrim||(e=T(e));(d.$viewValue!==e||""===e&&d.$$hasNativeValidators)&&
d.$setViewValue(e,b)}};if(e.hasEvent("input"))a.on("input",l);else{var k,n=function(a,b,c){k||(k=f.defer(function(){k=null;b&&b.value===c||l(a)}))};a.on("keydown",function(a){var b=a.keyCode;91===b||15<b&&19>b||37<=b&&40>=b||n(a,this,this.value)});if(e.hasEvent("paste"))a.on("paste cut",n)}a.on("change",l);d.$render=function(){var b=d.$isEmpty(d.$viewValue)?"":d.$viewValue;a.val()!==b&&a.val(b)}}function Kb(b,a){return function(c,d){var e,f;if(ca(c))return c;if(I(c)){'"'==c.charAt(0)&&'"'==c.charAt(c.length-
1)&&(c=c.substring(1,c.length-1));if(ig.test(c))return new Date(c);b.lastIndex=0;if(e=b.exec(c))return e.shift(),f=d?{yyyy:d.getFullYear(),MM:d.getMonth()+1,dd:d.getDate(),HH:d.getHours(),mm:d.getMinutes(),ss:d.getSeconds(),sss:d.getMilliseconds()/1E3}:{yyyy:1970,MM:1,dd:1,HH:0,mm:0,ss:0,sss:0},m(e,function(b,c){c<a.length&&(f[a[c]]=+b)}),new Date(f.yyyy,f.MM-1,f.dd,f.HH,f.mm,f.ss||0,1E3*f.sss||0)}return NaN}}function jb(b,a,c,d){return function(e,f,g,h,l,k,n){function q(a){return a&&!(a.getTime&&
a.getTime()!==a.getTime())}function r(a){return x(a)?ca(a)?a:c(a):t}Id(e,f,g,h);ib(e,f,g,h,l,k);var u=h&&h.$options&&h.$options.timezone,m;h.$$parserName=b;h.$parsers.push(function(b){return h.$isEmpty(b)?null:a.test(b)?(b=c(b,m),u&&(b=Ob(b,u)),b):t});h.$formatters.push(function(a){if(a&&!ca(a))throw kb("datefmt",a);if(q(a))return(m=a)&&u&&(m=Ob(m,u,!0)),n("date")(a,d,u);m=null;return""});if(x(g.min)||g.ngMin){var s;h.$validators.min=function(a){return!q(a)||y(s)||c(a)>=s};g.$observe("min",function(a){s=
r(a);h.$validate()})}if(x(g.max)||g.ngMax){var w;h.$validators.max=function(a){return!q(a)||y(w)||c(a)<=w};g.$observe("max",function(a){w=r(a);h.$validate()})}}}function Id(b,a,c,d){(d.$$hasNativeValidators=D(a[0].validity))&&d.$parsers.push(function(b){var c=a.prop("validity")||{};return c.badInput&&!c.typeMismatch?t:b})}function Jd(b,a,c,d,e){if(x(d)){b=b(d);if(!b.constant)throw kb("constexpr",c,d);return b(a)}return e}function jc(b,a){b="ngClass"+b;return["$animate",function(c){function d(a,b){var c=
[],d=0;a:for(;d<a.length;d++){for(var e=a[d],n=0;n<b.length;n++)if(e==b[n])continue a;c.push(e)}return c}function e(a){var b=[];return G(a)?(m(a,function(a){b=b.concat(e(a))}),b):I(a)?a.split(" "):D(a)?(m(a,function(a,c){a&&(b=b.concat(c.split(" ")))}),b):a}return{restrict:"AC",link:function(f,g,h){function l(a,b){var c=g.data("$classCounts")||ga(),d=[];m(a,function(a){if(0<b||c[a])c[a]=(c[a]||0)+b,c[a]===+(0<b)&&d.push(a)});g.data("$classCounts",c);return d.join(" ")}function k(b){if(!0===a||f.$index%
2===a){var k=e(b||[]);if(!n){var m=l(k,1);h.$addClass(m)}else if(!ka(b,n)){var s=e(n),m=d(k,s),k=d(s,k),m=l(m,1),k=l(k,-1);m&&m.length&&c.addClass(g,m);k&&k.length&&c.removeClass(g,k)}}n=ia(b)}var n;f.$watch(h[b],k,!0);h.$observe("class",function(a){k(f.$eval(h[b]))});"ngClass"!==b&&f.$watch("$index",function(c,d){var g=c&1;if(g!==(d&1)){var k=e(f.$eval(h[b]));g===a?(g=l(k,1),h.$addClass(g)):(g=l(k,-1),h.$removeClass(g))}})}}}]}function Hd(b){function a(a,b){b&&!f[a]?(k.addClass(e,a),f[a]=!0):!b&&
f[a]&&(k.removeClass(e,a),f[a]=!1)}function c(b,c){b=b?"-"+zc(b,"-"):"";a(lb+b,!0===c);a(Kd+b,!1===c)}var d=b.ctrl,e=b.$element,f={},g=b.set,h=b.unset,l=b.parentForm,k=b.$animate;f[Kd]=!(f[lb]=e.hasClass(lb));d.$setValidity=function(b,e,f){e===t?(d.$pending||(d.$pending={}),g(d.$pending,b,f)):(d.$pending&&h(d.$pending,b,f),Ld(d.$pending)&&(d.$pending=t));ab(e)?e?(h(d.$error,b,f),g(d.$$success,b,f)):(g(d.$error,b,f),h(d.$$success,b,f)):(h(d.$error,b,f),h(d.$$success,b,f));d.$pending?(a(Md,!0),d.$valid=
d.$invalid=t,c("",null)):(a(Md,!1),d.$valid=Ld(d.$error),d.$invalid=!d.$valid,c("",d.$valid));e=d.$pending&&d.$pending[b]?t:d.$error[b]?!1:d.$$success[b]?!0:null;c(b,e);l.$setValidity(b,e,d)}}function Ld(b){if(b)for(var a in b)if(b.hasOwnProperty(a))return!1;return!0}var jg=/^\/(.+)\/([a-z]*)$/,M=function(b){return I(b)?b.toLowerCase():b},Na=Object.prototype.hasOwnProperty,rb=function(b){return I(b)?b.toUpperCase():b},Va,z,la,xa=[].slice,Mf=[].splice,kg=[].push,sa=Object.prototype.toString,qc=Object.getPrototypeOf,
Ea=L("ng"),aa=O.angular||(O.angular={}),Rb,mb=0;Va=W.documentMode;v.$inject=[];Za.$inject=[];var G=Array.isArray,sc=/^\[object (Uint8(Clamped)?)|(Uint16)|(Uint32)|(Int8)|(Int16)|(Int32)|(Float(32)|(64))Array\]$/,T=function(b){return I(b)?b.trim():b},ud=function(b){return b.replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g,"\\$1").replace(/\x08/g,"\\x08")},Fa=function(){if(!x(Fa.rules)){var b=W.querySelector("[ng-csp]")||W.querySelector("[data-ng-csp]");if(b){var a=b.getAttribute("ng-csp")||b.getAttribute("data-ng-csp");
Fa.rules={noUnsafeEval:!a||-1!==a.indexOf("no-unsafe-eval"),noInlineStyle:!a||-1!==a.indexOf("no-inline-style")}}else{b=Fa;try{new Function(""),a=!1}catch(c){a=!0}b.rules={noUnsafeEval:a,noInlineStyle:!1}}}return Fa.rules},ob=function(){if(x(ob.name_))return ob.name_;var b,a,c=Qa.length,d,e;for(a=0;a<c;++a)if(d=Qa[a],b=W.querySelector("["+d.replace(":","\\:")+"jq]")){e=b.getAttribute(d+"jq");break}return ob.name_=e},Qa=["ng-","data-ng-","ng:","x-ng-"],be=/[A-Z]/g,Ac=!1,Qb,pa=1,Pa=3,fe={full:"1.4.4",
major:1,minor:4,dot:4,codeName:"pylon-requirement"};R.expando="ng339";var gb=R.cache={},Ef=1;R._data=function(b){return this.cache[b[this.expando]]||{}};var zf=/([\:\-\_]+(.))/g,Af=/^moz([A-Z])/,lg={mouseleave:"mouseout",mouseenter:"mouseover"},Tb=L("jqLite"),Df=/^<(\w+)\s*\/?>(?:<\/\1>|)$/,Sb=/<|&#?\w+;/,Bf=/<([\w:]+)/,Cf=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,na={option:[1,'<select multiple="multiple">',"</select>"],thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>",
"</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};na.optgroup=na.option;na.tbody=na.tfoot=na.colgroup=na.caption=na.thead;na.th=na.td;var Ra=R.prototype={ready:function(b){function a(){c||(c=!0,b())}var c=!1;"complete"===W.readyState?setTimeout(a):(this.on("DOMContentLoaded",a),R(O).on("load",a))},toString:function(){var b=[];m(this,function(a){b.push(""+a)});return"["+b.join(", ")+"]"},eq:function(b){return 0<=
b?z(this[b]):z(this[this.length+b])},length:0,push:kg,sort:[].sort,splice:[].splice},Ab={};m("multiple selected checked disabled readOnly required open".split(" "),function(b){Ab[M(b)]=b});var Rc={};m("input select option textarea button form details".split(" "),function(b){Rc[b]=!0});var Sc={ngMinlength:"minlength",ngMaxlength:"maxlength",ngMin:"min",ngMax:"max",ngPattern:"pattern"};m({data:Vb,removeData:ub,hasData:function(b){for(var a in gb[b.ng339])return!0;return!1}},function(b,a){R[a]=b});m({data:Vb,
inheritedData:zb,scope:function(b){return z.data(b,"$scope")||zb(b.parentNode||b,["$isolateScope","$scope"])},isolateScope:function(b){return z.data(b,"$isolateScope")||z.data(b,"$isolateScopeNoTemplate")},controller:Oc,injector:function(b){return zb(b,"$injector")},removeAttr:function(b,a){b.removeAttribute(a)},hasClass:wb,css:function(b,a,c){a=fb(a);if(x(c))b.style[a]=c;else return b.style[a]},attr:function(b,a,c){var d=b.nodeType;if(d!==Pa&&2!==d&&8!==d)if(d=M(a),Ab[d])if(x(c))c?(b[a]=!0,b.setAttribute(a,
d)):(b[a]=!1,b.removeAttribute(d));else return b[a]||(b.attributes.getNamedItem(a)||v).specified?d:t;else if(x(c))b.setAttribute(a,c);else if(b.getAttribute)return b=b.getAttribute(a,2),null===b?t:b},prop:function(b,a,c){if(x(c))b[a]=c;else return b[a]},text:function(){function b(a,b){if(y(b)){var d=a.nodeType;return d===pa||d===Pa?a.textContent:""}a.textContent=b}b.$dv="";return b}(),val:function(b,a){if(y(a)){if(b.multiple&&"select"===ta(b)){var c=[];m(b.options,function(a){a.selected&&c.push(a.value||
a.text)});return 0===c.length?null:c}return b.value}b.value=a},html:function(b,a){if(y(a))return b.innerHTML;tb(b,!0);b.innerHTML=a},empty:Pc},function(b,a){R.prototype[a]=function(a,d){var e,f,g=this.length;if(b!==Pc&&(2==b.length&&b!==wb&&b!==Oc?a:d)===t){if(D(a)){for(e=0;e<g;e++)if(b===Vb)b(this[e],a);else for(f in a)b(this[e],f,a[f]);return this}e=b.$dv;g=e===t?Math.min(g,1):g;for(f=0;f<g;f++){var h=b(this[f],a,d);e=e?e+h:h}return e}for(e=0;e<g;e++)b(this[e],a,d);return this}});m({removeData:ub,
on:function a(c,d,e,f){if(x(f))throw Tb("onargs");if(Kc(c)){var g=vb(c,!0);f=g.events;var h=g.handle;h||(h=g.handle=Hf(c,f));for(var g=0<=d.indexOf(" ")?d.split(" "):[d],l=g.length;l--;){d=g[l];var k=f[d];k||(f[d]=[],"mouseenter"===d||"mouseleave"===d?a(c,lg[d],function(a){var c=a.relatedTarget;c&&(c===this||this.contains(c))||h(a,d)}):"$destroy"!==d&&c.addEventListener(d,h,!1),k=f[d]);k.push(e)}}},off:Nc,one:function(a,c,d){a=z(a);a.on(c,function f(){a.off(c,d);a.off(c,f)});a.on(c,d)},replaceWith:function(a,
c){var d,e=a.parentNode;tb(a);m(new R(c),function(c){d?e.insertBefore(c,d.nextSibling):e.replaceChild(c,a);d=c})},children:function(a){var c=[];m(a.childNodes,function(a){a.nodeType===pa&&c.push(a)});return c},contents:function(a){return a.contentDocument||a.childNodes||[]},append:function(a,c){var d=a.nodeType;if(d===pa||11===d){c=new R(c);for(var d=0,e=c.length;d<e;d++)a.appendChild(c[d])}},prepend:function(a,c){if(a.nodeType===pa){var d=a.firstChild;m(new R(c),function(c){a.insertBefore(c,d)})}},
wrap:function(a,c){c=z(c).eq(0).clone()[0];var d=a.parentNode;d&&d.replaceChild(c,a);c.appendChild(a)},remove:Wb,detach:function(a){Wb(a,!0)},after:function(a,c){var d=a,e=a.parentNode;c=new R(c);for(var f=0,g=c.length;f<g;f++){var h=c[f];e.insertBefore(h,d.nextSibling);d=h}},addClass:yb,removeClass:xb,toggleClass:function(a,c,d){c&&m(c.split(" "),function(c){var f=d;y(f)&&(f=!wb(a,c));(f?yb:xb)(a,c)})},parent:function(a){return(a=a.parentNode)&&11!==a.nodeType?a:null},next:function(a){return a.nextElementSibling},
find:function(a,c){return a.getElementsByTagName?a.getElementsByTagName(c):[]},clone:Ub,triggerHandler:function(a,c,d){var e,f,g=c.type||c,h=vb(a);if(h=(h=h&&h.events)&&h[g])e={preventDefault:function(){this.defaultPrevented=!0},isDefaultPrevented:function(){return!0===this.defaultPrevented},stopImmediatePropagation:function(){this.immediatePropagationStopped=!0},isImmediatePropagationStopped:function(){return!0===this.immediatePropagationStopped},stopPropagation:v,type:g,target:a},c.type&&(e=Q(e,
c)),c=ia(h),f=d?[e].concat(d):[e],m(c,function(c){e.isImmediatePropagationStopped()||c.apply(a,f)})}},function(a,c){R.prototype[c]=function(c,e,f){for(var g,h=0,l=this.length;h<l;h++)y(g)?(g=a(this[h],c,e,f),x(g)&&(g=z(g))):Mc(g,a(this[h],c,e,f));return x(g)?g:this};R.prototype.bind=R.prototype.on;R.prototype.unbind=R.prototype.off});Ua.prototype={put:function(a,c){this[Ga(a,this.nextUid)]=c},get:function(a){return this[Ga(a,this.nextUid)]},remove:function(a){var c=this[a=Ga(a,this.nextUid)];delete this[a];
return c}};var xf=[function(){this.$get=[function(){return Ua}]}],Uc=/^[^\(]*\(\s*([^\)]*)\)/m,mg=/,/,ng=/^\s*(_?)(\S+?)\1\s*$/,Tc=/((\/\/.*$)|(\/\*[\s\S]*?\*\/))/mg,Ha=L("$injector");eb.$$annotate=function(a,c,d){var e;if("function"===typeof a){if(!(e=a.$inject)){e=[];if(a.length){if(c)throw I(d)&&d||(d=a.name||If(a)),Ha("strictdi",d);c=a.toString().replace(Tc,"");c=c.match(Uc);m(c[1].split(mg),function(a){a.replace(ng,function(a,c,d){e.push(d)})})}a.$inject=e}}else G(a)?(c=a.length-1,Sa(a[c],"fn"),
e=a.slice(0,c)):Sa(a,"fn",!0);return e};var Nd=L("$animate"),Ue=function(){this.$get=["$q","$$rAF",function(a,c){function d(){}d.all=v;d.chain=v;d.prototype={end:v,cancel:v,resume:v,pause:v,complete:v,then:function(d,f){return a(function(a){c(function(){a()})}).then(d,f)}};return d}]},Te=function(){var a=new Ua,c=[];this.$get=["$$AnimateRunner","$rootScope",function(d,e){function f(d,f,l){var k=a.get(d);k||(a.put(d,k={}),c.push(d));d=function(a,c){var d=!1;a&&(a=I(a)?a.split(" "):G(a)?a:[],m(a,function(a){a&&
(d=!0,k[a]=c)}));return d};f=d(f,!0);l=d(l,!1);!f&&!l||1<c.length||e.$$postDigest(function(){m(c,function(c){var d=a.get(c);if(d){var e=Jf(c.attr("class")),f="",g="";m(d,function(a,c){a!==!!e[c]&&(a?f+=(f.length?" ":"")+c:g+=(g.length?" ":"")+c)});m(c,function(a){f&&yb(a,f);g&&xb(a,g)});a.remove(c)}});c.length=0})}return{enabled:v,on:v,off:v,pin:v,push:function(a,c,e,k){k&&k();e=e||{};e.from&&a.css(e.from);e.to&&a.css(e.to);(e.addClass||e.removeClass)&&f(a,e.addClass,e.removeClass);return new d}}}]},
Re=["$provide",function(a){var c=this;this.$$registeredAnimations=Object.create(null);this.register=function(d,e){if(d&&"."!==d.charAt(0))throw Nd("notcsel",d);var f=d+"-animation";c.$$registeredAnimations[d.substr(1)]=f;a.factory(f,e)};this.classNameFilter=function(a){if(1===arguments.length&&(this.$$classNameFilter=a instanceof RegExp?a:null)&&/(\s+|\/)ng-animate(\s+|\/)/.test(this.$$classNameFilter.toString()))throw Nd("nongcls","ng-animate");return this.$$classNameFilter};this.$get=["$$animateQueue",
function(a){function c(a,d,e){if(e){var l;a:{for(l=0;l<e.length;l++){var k=e[l];if(1===k.nodeType){l=k;break a}}l=void 0}!l||l.parentNode||l.previousElementSibling||(e=null)}e?e.after(a):d.prepend(a)}return{on:a.on,off:a.off,pin:a.pin,enabled:a.enabled,cancel:function(a){a.end&&a.end()},enter:function(f,g,h,l){g=g&&z(g);h=h&&z(h);g=g||h.parent();c(f,g,h);return a.push(f,"enter",Ia(l))},move:function(f,g,h,l){g=g&&z(g);h=h&&z(h);g=g||h.parent();c(f,g,h);return a.push(f,"move",Ia(l))},leave:function(c,
e){return a.push(c,"leave",Ia(e),function(){c.remove()})},addClass:function(c,e,h){h=Ia(h);h.addClass=hb(h.addclass,e);return a.push(c,"addClass",h)},removeClass:function(c,e,h){h=Ia(h);h.removeClass=hb(h.removeClass,e);return a.push(c,"removeClass",h)},setClass:function(c,e,h,l){l=Ia(l);l.addClass=hb(l.addClass,e);l.removeClass=hb(l.removeClass,h);return a.push(c,"setClass",l)},animate:function(c,e,h,l,k){k=Ia(k);k.from=k.from?Q(k.from,e):e;k.to=k.to?Q(k.to,h):h;k.tempClasses=hb(k.tempClasses,l||
"ng-inline-animate");return a.push(c,"animate",k)}}}]}],Se=function(){this.$get=["$$rAF","$q",function(a,c){var d=function(){};d.prototype={done:function(a){this.defer&&this.defer[!0===a?"reject":"resolve"]()},end:function(){this.done()},cancel:function(){this.done(!0)},getPromise:function(){this.defer||(this.defer=c.defer());return this.defer.promise},then:function(a,c){return this.getPromise().then(a,c)},"catch":function(a){return this.getPromise().catch(a)},"finally":function(a){return this.getPromise().finally(a)}};
return function(c,f){function g(){a(function(){f.addClass&&(c.addClass(f.addClass),f.addClass=null);f.removeClass&&(c.removeClass(f.removeClass),f.removeClass=null);f.to&&(c.css(f.to),f.to=null);h||l.done();h=!0});return l}f.from&&(c.css(f.from),f.from=null);var h,l=new d;return{start:g,end:g}}}]},ea=L("$compile");Cc.$inject=["$provide","$$sanitizeUriProvider"];var Xc=/^((?:x|data)[\:\-_])/i,Nf=L("$controller"),Vc=/^(\S+)(\s+as\s+(\w+))?$/,$e=function(){this.$get=["$document",function(a){return function(c){c?
!c.nodeType&&c instanceof z&&(c=c[0]):c=a[0].body;return c.offsetWidth+1}}]},bd="application/json",$b={"Content-Type":bd+";charset=utf-8"},Pf=/^\[|^\{(?!\{)/,Qf={"[":/]$/,"{":/}$/},Of=/^\)\]\}',?\n/,og=L("$http"),fd=function(a){return function(){throw og("legacy",a);}},Ka=aa.$interpolateMinErr=L("$interpolate");Ka.throwNoconcat=function(a){throw Ka("noconcat",a);};Ka.interr=function(a,c){return Ka("interr",a,c.toString())};var pg=/^([^\?#]*)(\?([^#]*))?(#(.*))?$/,Tf={http:80,https:443,ftp:21},Db=
L("$location"),qg={$$html5:!1,$$replace:!1,absUrl:Eb("$$absUrl"),url:function(a){if(y(a))return this.$$url;var c=pg.exec(a);(c[1]||""===a)&&this.path(decodeURIComponent(c[1]));(c[2]||c[1]||""===a)&&this.search(c[3]||"");this.hash(c[5]||"");return this},protocol:Eb("$$protocol"),host:Eb("$$host"),port:Eb("$$port"),path:kd("$$path",function(a){a=null!==a?a.toString():"";return"/"==a.charAt(0)?a:"/"+a}),search:function(a,c){switch(arguments.length){case 0:return this.$$search;case 1:if(I(a)||X(a))a=
a.toString(),this.$$search=xc(a);else if(D(a))a=fa(a,{}),m(a,function(c,e){null==c&&delete a[e]}),this.$$search=a;else throw Db("isrcharg");break;default:y(c)||null===c?delete this.$$search[a]:this.$$search[a]=c}this.$$compose();return this},hash:kd("$$hash",function(a){return null!==a?a.toString():""}),replace:function(){this.$$replace=!0;return this}};m([jd,cc,bc],function(a){a.prototype=Object.create(qg);a.prototype.state=function(c){if(!arguments.length)return this.$$state;if(a!==bc||!this.$$html5)throw Db("nostate");
this.$$state=y(c)?null:c;return this}});var da=L("$parse"),Uf=Function.prototype.call,Vf=Function.prototype.apply,Wf=Function.prototype.bind,Lb=ga();m("+ - * / % === !== == != < > <= >= && || ! = |".split(" "),function(a){Lb[a]=!0});var rg={n:"\n",f:"\f",r:"\r",t:"\t",v:"\v","'":"'",'"':'"'},ec=function(a){this.options=a};ec.prototype={constructor:ec,lex:function(a){this.text=a;this.index=0;for(this.tokens=[];this.index<this.text.length;)if(a=this.text.charAt(this.index),'"'===a||"'"===a)this.readString(a);
else if(this.isNumber(a)||"."===a&&this.isNumber(this.peek()))this.readNumber();else if(this.isIdent(a))this.readIdent();else if(this.is(a,"(){}[].,;:?"))this.tokens.push({index:this.index,text:a}),this.index++;else if(this.isWhitespace(a))this.index++;else{var c=a+this.peek(),d=c+this.peek(2),e=Lb[c],f=Lb[d];Lb[a]||e||f?(a=f?d:e?c:a,this.tokens.push({index:this.index,text:a,operator:!0}),this.index+=a.length):this.throwError("Unexpected next character ",this.index,this.index+1)}return this.tokens},
is:function(a,c){return-1!==c.indexOf(a)},peek:function(a){a=a||1;return this.index+a<this.text.length?this.text.charAt(this.index+a):!1},isNumber:function(a){return"0"<=a&&"9">=a&&"string"===typeof a},isWhitespace:function(a){return" "===a||"\r"===a||"\t"===a||"\n"===a||"\v"===a||"\u00a0"===a},isIdent:function(a){return"a"<=a&&"z">=a||"A"<=a&&"Z">=a||"_"===a||"$"===a},isExpOperator:function(a){return"-"===a||"+"===a||this.isNumber(a)},throwError:function(a,c,d){d=d||this.index;c=x(c)?"s "+c+"-"+
this.index+" ["+this.text.substring(c,d)+"]":" "+d;throw da("lexerr",a,c,this.text);},readNumber:function(){for(var a="",c=this.index;this.index<this.text.length;){var d=M(this.text.charAt(this.index));if("."==d||this.isNumber(d))a+=d;else{var e=this.peek();if("e"==d&&this.isExpOperator(e))a+=d;else if(this.isExpOperator(d)&&e&&this.isNumber(e)&&"e"==a.charAt(a.length-1))a+=d;else if(!this.isExpOperator(d)||e&&this.isNumber(e)||"e"!=a.charAt(a.length-1))break;else this.throwError("Invalid exponent")}this.index++}this.tokens.push({index:c,
text:a,constant:!0,value:Number(a)})},readIdent:function(){for(var a=this.index;this.index<this.text.length;){var c=this.text.charAt(this.index);if(!this.isIdent(c)&&!this.isNumber(c))break;this.index++}this.tokens.push({index:a,text:this.text.slice(a,this.index),identifier:!0})},readString:function(a){var c=this.index;this.index++;for(var d="",e=a,f=!1;this.index<this.text.length;){var g=this.text.charAt(this.index),e=e+g;if(f)"u"===g?(f=this.text.substring(this.index+1,this.index+5),f.match(/[\da-f]{4}/i)||
this.throwError("Invalid unicode escape [\\u"+f+"]"),this.index+=4,d+=String.fromCharCode(parseInt(f,16))):d+=rg[g]||g,f=!1;else if("\\"===g)f=!0;else{if(g===a){this.index++;this.tokens.push({index:c,text:e,constant:!0,value:d});return}d+=g}this.index++}this.throwError("Unterminated quote",c)}};var s=function(a,c){this.lexer=a;this.options=c};s.Program="Program";s.ExpressionStatement="ExpressionStatement";s.AssignmentExpression="AssignmentExpression";s.ConditionalExpression="ConditionalExpression";
s.LogicalExpression="LogicalExpression";s.BinaryExpression="BinaryExpression";s.UnaryExpression="UnaryExpression";s.CallExpression="CallExpression";s.MemberExpression="MemberExpression";s.Identifier="Identifier";s.Literal="Literal";s.ArrayExpression="ArrayExpression";s.Property="Property";s.ObjectExpression="ObjectExpression";s.ThisExpression="ThisExpression";s.NGValueParameter="NGValueParameter";s.prototype={ast:function(a){this.text=a;this.tokens=this.lexer.lex(a);a=this.program();0!==this.tokens.length&&
this.throwError("is an unexpected token",this.tokens[0]);return a},program:function(){for(var a=[];;)if(0<this.tokens.length&&!this.peek("}",")",";","]")&&a.push(this.expressionStatement()),!this.expect(";"))return{type:s.Program,body:a}},expressionStatement:function(){return{type:s.ExpressionStatement,expression:this.filterChain()}},filterChain:function(){for(var a=this.expression();this.expect("|");)a=this.filter(a);return a},expression:function(){return this.assignment()},assignment:function(){var a=
this.ternary();this.expect("=")&&(a={type:s.AssignmentExpression,left:a,right:this.assignment(),operator:"="});return a},ternary:function(){var a=this.logicalOR(),c,d;return this.expect("?")&&(c=this.expression(),this.consume(":"))?(d=this.expression(),{type:s.ConditionalExpression,test:a,alternate:c,consequent:d}):a},logicalOR:function(){for(var a=this.logicalAND();this.expect("||");)a={type:s.LogicalExpression,operator:"||",left:a,right:this.logicalAND()};return a},logicalAND:function(){for(var a=
this.equality();this.expect("&&");)a={type:s.LogicalExpression,operator:"&&",left:a,right:this.equality()};return a},equality:function(){for(var a=this.relational(),c;c=this.expect("==","!=","===","!==");)a={type:s.BinaryExpression,operator:c.text,left:a,right:this.relational()};return a},relational:function(){for(var a=this.additive(),c;c=this.expect("<",">","<=",">=");)a={type:s.BinaryExpression,operator:c.text,left:a,right:this.additive()};return a},additive:function(){for(var a=this.multiplicative(),
c;c=this.expect("+","-");)a={type:s.BinaryExpression,operator:c.text,left:a,right:this.multiplicative()};return a},multiplicative:function(){for(var a=this.unary(),c;c=this.expect("*","/","%");)a={type:s.BinaryExpression,operator:c.text,left:a,right:this.unary()};return a},unary:function(){var a;return(a=this.expect("+","-","!"))?{type:s.UnaryExpression,operator:a.text,prefix:!0,argument:this.unary()}:this.primary()},primary:function(){var a;this.expect("(")?(a=this.filterChain(),this.consume(")")):
this.expect("[")?a=this.arrayDeclaration():this.expect("{")?a=this.object():this.constants.hasOwnProperty(this.peek().text)?a=fa(this.constants[this.consume().text]):this.peek().identifier?a=this.identifier():this.peek().constant?a=this.constant():this.throwError("not a primary expression",this.peek());for(var c;c=this.expect("(","[",".");)"("===c.text?(a={type:s.CallExpression,callee:a,arguments:this.parseArguments()},this.consume(")")):"["===c.text?(a={type:s.MemberExpression,object:a,property:this.expression(),
computed:!0},this.consume("]")):"."===c.text?a={type:s.MemberExpression,object:a,property:this.identifier(),computed:!1}:this.throwError("IMPOSSIBLE");return a},filter:function(a){a=[a];for(var c={type:s.CallExpression,callee:this.identifier(),arguments:a,filter:!0};this.expect(":");)a.push(this.expression());return c},parseArguments:function(){var a=[];if(")"!==this.peekToken().text){do a.push(this.expression());while(this.expect(","))}return a},identifier:function(){var a=this.consume();a.identifier||
this.throwError("is not a valid identifier",a);return{type:s.Identifier,name:a.text}},constant:function(){return{type:s.Literal,value:this.consume().value}},arrayDeclaration:function(){var a=[];if("]"!==this.peekToken().text){do{if(this.peek("]"))break;a.push(this.expression())}while(this.expect(","))}this.consume("]");return{type:s.ArrayExpression,elements:a}},object:function(){var a=[],c;if("}"!==this.peekToken().text){do{if(this.peek("}"))break;c={type:s.Property,kind:"init"};this.peek().constant?
c.key=this.constant():this.peek().identifier?c.key=this.identifier():this.throwError("invalid key",this.peek());this.consume(":");c.value=this.expression();a.push(c)}while(this.expect(","))}this.consume("}");return{type:s.ObjectExpression,properties:a}},throwError:function(a,c){throw da("syntax",c.text,a,c.index+1,this.text,this.text.substring(c.index));},consume:function(a){if(0===this.tokens.length)throw da("ueoe",this.text);var c=this.expect(a);c||this.throwError("is unexpected, expecting ["+a+
"]",this.peek());return c},peekToken:function(){if(0===this.tokens.length)throw da("ueoe",this.text);return this.tokens[0]},peek:function(a,c,d,e){return this.peekAhead(0,a,c,d,e)},peekAhead:function(a,c,d,e,f){if(this.tokens.length>a){a=this.tokens[a];var g=a.text;if(g===c||g===d||g===e||g===f||!(c||d||e||f))return a}return!1},expect:function(a,c,d,e){return(a=this.peek(a,c,d,e))?(this.tokens.shift(),a):!1},constants:{"true":{type:s.Literal,value:!0},"false":{type:s.Literal,value:!1},"null":{type:s.Literal,
value:null},undefined:{type:s.Literal,value:t},"this":{type:s.ThisExpression}}};rd.prototype={compile:function(a,c){var d=this,e=this.astBuilder.ast(a);this.state={nextId:0,filters:{},expensiveChecks:c,fn:{vars:[],body:[],own:{}},assign:{vars:[],body:[],own:{}},inputs:[]};U(e,d.$filter);var f="",g;this.stage="assign";if(g=pd(e))this.state.computing="assign",f=this.nextId(),this.recurse(g,f),f="fn.assign="+this.generateFunction("assign","s,v,l");g=nd(e.body);d.stage="inputs";m(g,function(a,c){var e=
"fn"+c;d.state[e]={vars:[],body:[],own:{}};d.state.computing=e;var f=d.nextId();d.recurse(a,f);d.return_(f);d.state.inputs.push(e);a.watchId=c});this.state.computing="fn";this.stage="main";this.recurse(e);f='"'+this.USE+" "+this.STRICT+'";\n'+this.filterPrefix()+"var fn="+this.generateFunction("fn","s,l,a,i")+f+this.watchFns()+"return fn;";f=(new Function("$filter","ensureSafeMemberName","ensureSafeObject","ensureSafeFunction","ifDefined","plus","text",f))(this.$filter,Wa,Ba,ld,Xf,md,a);this.state=
this.stage=t;f.literal=qd(e);f.constant=e.constant;return f},USE:"use",STRICT:"strict",watchFns:function(){var a=[],c=this.state.inputs,d=this;m(c,function(c){a.push("var "+c+"="+d.generateFunction(c,"s"))});c.length&&a.push("fn.inputs=["+c.join(",")+"];");return a.join("")},generateFunction:function(a,c){return"function("+c+"){"+this.varsPrefix(a)+this.body(a)+"};"},filterPrefix:function(){var a=[],c=this;m(this.state.filters,function(d,e){a.push(d+"=$filter("+c.escape(e)+")")});return a.length?
"var "+a.join(",")+";":""},varsPrefix:function(a){return this.state[a].vars.length?"var "+this.state[a].vars.join(",")+";":""},body:function(a){return this.state[a].body.join("")},recurse:function(a,c,d,e,f,g){var h,l,k=this,n,q;e=e||v;if(!g&&x(a.watchId))c=c||this.nextId(),this.if_("i",this.lazyAssign(c,this.computedMember("i",a.watchId)),this.lazyRecurse(a,c,d,e,f,!0));else switch(a.type){case s.Program:m(a.body,function(c,d){k.recurse(c.expression,t,t,function(a){l=a});d!==a.body.length-1?k.current().body.push(l,
";"):k.return_(l)});break;case s.Literal:q=this.escape(a.value);this.assign(c,q);e(q);break;case s.UnaryExpression:this.recurse(a.argument,t,t,function(a){l=a});q=a.operator+"("+this.ifDefined(l,0)+")";this.assign(c,q);e(q);break;case s.BinaryExpression:this.recurse(a.left,t,t,function(a){h=a});this.recurse(a.right,t,t,function(a){l=a});q="+"===a.operator?this.plus(h,l):"-"===a.operator?this.ifDefined(h,0)+a.operator+this.ifDefined(l,0):"("+h+")"+a.operator+"("+l+")";this.assign(c,q);e(q);break;case s.LogicalExpression:c=
c||this.nextId();k.recurse(a.left,c);k.if_("&&"===a.operator?c:k.not(c),k.lazyRecurse(a.right,c));e(c);break;case s.ConditionalExpression:c=c||this.nextId();k.recurse(a.test,c);k.if_(c,k.lazyRecurse(a.alternate,c),k.lazyRecurse(a.consequent,c));e(c);break;case s.Identifier:c=c||this.nextId();d&&(d.context="inputs"===k.stage?"s":this.assign(this.nextId(),this.getHasOwnProperty("l",a.name)+"?l:s"),d.computed=!1,d.name=a.name);Wa(a.name);k.if_("inputs"===k.stage||k.not(k.getHasOwnProperty("l",a.name)),
function(){k.if_("inputs"===k.stage||"s",function(){f&&1!==f&&k.if_(k.not(k.nonComputedMember("s",a.name)),k.lazyAssign(k.nonComputedMember("s",a.name),"{}"));k.assign(c,k.nonComputedMember("s",a.name))})},c&&k.lazyAssign(c,k.nonComputedMember("l",a.name)));(k.state.expensiveChecks||Fb(a.name))&&k.addEnsureSafeObject(c);e(c);break;case s.MemberExpression:h=d&&(d.context=this.nextId())||this.nextId();c=c||this.nextId();k.recurse(a.object,h,t,function(){k.if_(k.notNull(h),function(){if(a.computed)l=
k.nextId(),k.recurse(a.property,l),k.addEnsureSafeMemberName(l),f&&1!==f&&k.if_(k.not(k.computedMember(h,l)),k.lazyAssign(k.computedMember(h,l),"{}")),q=k.ensureSafeObject(k.computedMember(h,l)),k.assign(c,q),d&&(d.computed=!0,d.name=l);else{Wa(a.property.name);f&&1!==f&&k.if_(k.not(k.nonComputedMember(h,a.property.name)),k.lazyAssign(k.nonComputedMember(h,a.property.name),"{}"));q=k.nonComputedMember(h,a.property.name);if(k.state.expensiveChecks||Fb(a.property.name))q=k.ensureSafeObject(q);k.assign(c,
q);d&&(d.computed=!1,d.name=a.property.name)}},function(){k.assign(c,"undefined")});e(c)},!!f);break;case s.CallExpression:c=c||this.nextId();a.filter?(l=k.filter(a.callee.name),n=[],m(a.arguments,function(a){var c=k.nextId();k.recurse(a,c);n.push(c)}),q=l+"("+n.join(",")+")",k.assign(c,q),e(c)):(l=k.nextId(),h={},n=[],k.recurse(a.callee,l,h,function(){k.if_(k.notNull(l),function(){k.addEnsureSafeFunction(l);m(a.arguments,function(a){k.recurse(a,k.nextId(),t,function(a){n.push(k.ensureSafeObject(a))})});
h.name?(k.state.expensiveChecks||k.addEnsureSafeObject(h.context),q=k.member(h.context,h.name,h.computed)+"("+n.join(",")+")"):q=l+"("+n.join(",")+")";q=k.ensureSafeObject(q);k.assign(c,q)},function(){k.assign(c,"undefined")});e(c)}));break;case s.AssignmentExpression:l=this.nextId();h={};if(!od(a.left))throw da("lval");this.recurse(a.left,t,h,function(){k.if_(k.notNull(h.context),function(){k.recurse(a.right,l);k.addEnsureSafeObject(k.member(h.context,h.name,h.computed));q=k.member(h.context,h.name,
h.computed)+a.operator+l;k.assign(c,q);e(c||q)})},1);break;case s.ArrayExpression:n=[];m(a.elements,function(a){k.recurse(a,k.nextId(),t,function(a){n.push(a)})});q="["+n.join(",")+"]";this.assign(c,q);e(q);break;case s.ObjectExpression:n=[];m(a.properties,function(a){k.recurse(a.value,k.nextId(),t,function(c){n.push(k.escape(a.key.type===s.Identifier?a.key.name:""+a.key.value)+":"+c)})});q="{"+n.join(",")+"}";this.assign(c,q);e(q);break;case s.ThisExpression:this.assign(c,"s");e("s");break;case s.NGValueParameter:this.assign(c,
"v"),e("v")}},getHasOwnProperty:function(a,c){var d=a+"."+c,e=this.current().own;e.hasOwnProperty(d)||(e[d]=this.nextId(!1,a+"&&("+this.escape(c)+" in "+a+")"));return e[d]},assign:function(a,c){if(a)return this.current().body.push(a,"=",c,";"),a},filter:function(a){this.state.filters.hasOwnProperty(a)||(this.state.filters[a]=this.nextId(!0));return this.state.filters[a]},ifDefined:function(a,c){return"ifDefined("+a+","+this.escape(c)+")"},plus:function(a,c){return"plus("+a+","+c+")"},return_:function(a){this.current().body.push("return ",
a,";")},if_:function(a,c,d){if(!0===a)c();else{var e=this.current().body;e.push("if(",a,"){");c();e.push("}");d&&(e.push("else{"),d(),e.push("}"))}},not:function(a){return"!("+a+")"},notNull:function(a){return a+"!=null"},nonComputedMember:function(a,c){return a+"."+c},computedMember:function(a,c){return a+"["+c+"]"},member:function(a,c,d){return d?this.computedMember(a,c):this.nonComputedMember(a,c)},addEnsureSafeObject:function(a){this.current().body.push(this.ensureSafeObject(a),";")},addEnsureSafeMemberName:function(a){this.current().body.push(this.ensureSafeMemberName(a),
";")},addEnsureSafeFunction:function(a){this.current().body.push(this.ensureSafeFunction(a),";")},ensureSafeObject:function(a){return"ensureSafeObject("+a+",text)"},ensureSafeMemberName:function(a){return"ensureSafeMemberName("+a+",text)"},ensureSafeFunction:function(a){return"ensureSafeFunction("+a+",text)"},lazyRecurse:function(a,c,d,e,f,g){var h=this;return function(){h.recurse(a,c,d,e,f,g)}},lazyAssign:function(a,c){var d=this;return function(){d.assign(a,c)}},stringEscapeRegex:/[^ a-zA-Z0-9]/g,
stringEscapeFn:function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)},escape:function(a){if(I(a))return"'"+a.replace(this.stringEscapeRegex,this.stringEscapeFn)+"'";if(X(a))return a.toString();if(!0===a)return"true";if(!1===a)return"false";if(null===a)return"null";if("undefined"===typeof a)return"undefined";throw da("esc");},nextId:function(a,c){var d="v"+this.state.nextId++;a||this.current().vars.push(d+(c?"="+c:""));return d},current:function(){return this.state[this.state.computing]}};
sd.prototype={compile:function(a,c){var d=this,e=this.astBuilder.ast(a);this.expression=a;this.expensiveChecks=c;U(e,d.$filter);var f,g;if(f=pd(e))g=this.recurse(f);f=nd(e.body);var h;f&&(h=[],m(f,function(a,c){var e=d.recurse(a);a.input=e;h.push(e);a.watchId=c}));var l=[];m(e.body,function(a){l.push(d.recurse(a.expression))});f=0===e.body.length?function(){}:1===e.body.length?l[0]:function(a,c){var d;m(l,function(e){d=e(a,c)});return d};g&&(f.assign=function(a,c,d){return g(a,d,c)});h&&(f.inputs=
h);f.literal=qd(e);f.constant=e.constant;return f},recurse:function(a,c,d){var e,f,g=this,h;if(a.input)return this.inputs(a.input,a.watchId);switch(a.type){case s.Literal:return this.value(a.value,c);case s.UnaryExpression:return f=this.recurse(a.argument),this["unary"+a.operator](f,c);case s.BinaryExpression:return e=this.recurse(a.left),f=this.recurse(a.right),this["binary"+a.operator](e,f,c);case s.LogicalExpression:return e=this.recurse(a.left),f=this.recurse(a.right),this["binary"+a.operator](e,
f,c);case s.ConditionalExpression:return this["ternary?:"](this.recurse(a.test),this.recurse(a.alternate),this.recurse(a.consequent),c);case s.Identifier:return Wa(a.name,g.expression),g.identifier(a.name,g.expensiveChecks||Fb(a.name),c,d,g.expression);case s.MemberExpression:return e=this.recurse(a.object,!1,!!d),a.computed||(Wa(a.property.name,g.expression),f=a.property.name),a.computed&&(f=this.recurse(a.property)),a.computed?this.computedMember(e,f,c,d,g.expression):this.nonComputedMember(e,f,
g.expensiveChecks,c,d,g.expression);case s.CallExpression:return h=[],m(a.arguments,function(a){h.push(g.recurse(a))}),a.filter&&(f=this.$filter(a.callee.name)),a.filter||(f=this.recurse(a.callee,!0)),a.filter?function(a,d,e,g){for(var r=[],m=0;m<h.length;++m)r.push(h[m](a,d,e,g));a=f.apply(t,r,g);return c?{context:t,name:t,value:a}:a}:function(a,d,e,q){var r=f(a,d,e,q),m;if(null!=r.value){Ba(r.context,g.expression);ld(r.value,g.expression);m=[];for(var s=0;s<h.length;++s)m.push(Ba(h[s](a,d,e,q),
g.expression));m=Ba(r.value.apply(r.context,m),g.expression)}return c?{value:m}:m};case s.AssignmentExpression:return e=this.recurse(a.left,!0,1),f=this.recurse(a.right),function(a,d,h,q){var m=e(a,d,h,q);a=f(a,d,h,q);Ba(m.value,g.expression);m.context[m.name]=a;return c?{value:a}:a};case s.ArrayExpression:return h=[],m(a.elements,function(a){h.push(g.recurse(a))}),function(a,d,e,f){for(var g=[],m=0;m<h.length;++m)g.push(h[m](a,d,e,f));return c?{value:g}:g};case s.ObjectExpression:return h=[],m(a.properties,
function(a){h.push({key:a.key.type===s.Identifier?a.key.name:""+a.key.value,value:g.recurse(a.value)})}),function(a,d,e,f){for(var g={},m=0;m<h.length;++m)g[h[m].key]=h[m].value(a,d,e,f);return c?{value:g}:g};case s.ThisExpression:return function(a){return c?{value:a}:a};case s.NGValueParameter:return function(a,d,e,f){return c?{value:e}:e}}},"unary+":function(a,c){return function(d,e,f,g){d=a(d,e,f,g);d=x(d)?+d:0;return c?{value:d}:d}},"unary-":function(a,c){return function(d,e,f,g){d=a(d,e,f,g);
d=x(d)?-d:0;return c?{value:d}:d}},"unary!":function(a,c){return function(d,e,f,g){d=!a(d,e,f,g);return c?{value:d}:d}},"binary+":function(a,c,d){return function(e,f,g,h){var l=a(e,f,g,h);e=c(e,f,g,h);l=md(l,e);return d?{value:l}:l}},"binary-":function(a,c,d){return function(e,f,g,h){var l=a(e,f,g,h);e=c(e,f,g,h);l=(x(l)?l:0)-(x(e)?e:0);return d?{value:l}:l}},"binary*":function(a,c,d){return function(e,f,g,h){e=a(e,f,g,h)*c(e,f,g,h);return d?{value:e}:e}},"binary/":function(a,c,d){return function(e,
f,g,h){e=a(e,f,g,h)/c(e,f,g,h);return d?{value:e}:e}},"binary%":function(a,c,d){return function(e,f,g,h){e=a(e,f,g,h)%c(e,f,g,h);return d?{value:e}:e}},"binary===":function(a,c,d){return function(e,f,g,h){e=a(e,f,g,h)===c(e,f,g,h);return d?{value:e}:e}},"binary!==":function(a,c,d){return function(e,f,g,h){e=a(e,f,g,h)!==c(e,f,g,h);return d?{value:e}:e}},"binary==":function(a,c,d){return function(e,f,g,h){e=a(e,f,g,h)==c(e,f,g,h);return d?{value:e}:e}},"binary!=":function(a,c,d){return function(e,
f,g,h){e=a(e,f,g,h)!=c(e,f,g,h);return d?{value:e}:e}},"binary<":function(a,c,d){return function(e,f,g,h){e=a(e,f,g,h)<c(e,f,g,h);return d?{value:e}:e}},"binary>":function(a,c,d){return function(e,f,g,h){e=a(e,f,g,h)>c(e,f,g,h);return d?{value:e}:e}},"binary<=":function(a,c,d){return function(e,f,g,h){e=a(e,f,g,h)<=c(e,f,g,h);return d?{value:e}:e}},"binary>=":function(a,c,d){return function(e,f,g,h){e=a(e,f,g,h)>=c(e,f,g,h);return d?{value:e}:e}},"binary&&":function(a,c,d){return function(e,f,g,h){e=
a(e,f,g,h)&&c(e,f,g,h);return d?{value:e}:e}},"binary||":function(a,c,d){return function(e,f,g,h){e=a(e,f,g,h)||c(e,f,g,h);return d?{value:e}:e}},"ternary?:":function(a,c,d,e){return function(f,g,h,l){f=a(f,g,h,l)?c(f,g,h,l):d(f,g,h,l);return e?{value:f}:f}},value:function(a,c){return function(){return c?{context:t,name:t,value:a}:a}},identifier:function(a,c,d,e,f){return function(g,h,l,k){g=h&&a in h?h:g;e&&1!==e&&g&&!g[a]&&(g[a]={});h=g?g[a]:t;c&&Ba(h,f);return d?{context:g,name:a,value:h}:h}},
computedMember:function(a,c,d,e,f){return function(g,h,l,k){var n=a(g,h,l,k),q,m;null!=n&&(q=c(g,h,l,k),Wa(q,f),e&&1!==e&&n&&!n[q]&&(n[q]={}),m=n[q],Ba(m,f));return d?{context:n,name:q,value:m}:m}},nonComputedMember:function(a,c,d,e,f,g){return function(h,l,k,n){h=a(h,l,k,n);f&&1!==f&&h&&!h[c]&&(h[c]={});l=null!=h?h[c]:t;(d||Fb(c))&&Ba(l,g);return e?{context:h,name:c,value:l}:l}},inputs:function(a,c){return function(d,e,f,g){return g?g[c]:a(d,e,f)}}};var fc=function(a,c,d){this.lexer=a;this.$filter=
c;this.options=d;this.ast=new s(this.lexer);this.astCompiler=d.csp?new sd(this.ast,c):new rd(this.ast,c)};fc.prototype={constructor:fc,parse:function(a){return this.astCompiler.compile(a,this.options.expensiveChecks)}};ga();ga();var Yf=Object.prototype.valueOf,Ca=L("$sce"),oa={HTML:"html",CSS:"css",URL:"url",RESOURCE_URL:"resourceUrl",JS:"js"},ea=L("$compile"),Z=W.createElement("a"),wd=Aa(O.location.href);xd.$inject=["$document"];Jc.$inject=["$provide"];yd.$inject=["$locale"];Ad.$inject=["$locale"];
var Dd=".",hg={yyyy:$("FullYear",4),yy:$("FullYear",2,0,!0),y:$("FullYear",1),MMMM:Hb("Month"),MMM:Hb("Month",!0),MM:$("Month",2,1),M:$("Month",1,1),dd:$("Date",2),d:$("Date",1),HH:$("Hours",2),H:$("Hours",1),hh:$("Hours",2,-12),h:$("Hours",1,-12),mm:$("Minutes",2),m:$("Minutes",1),ss:$("Seconds",2),s:$("Seconds",1),sss:$("Milliseconds",3),EEEE:Hb("Day"),EEE:Hb("Day",!0),a:function(a,c){return 12>a.getHours()?c.AMPMS[0]:c.AMPMS[1]},Z:function(a,c,d){a=-1*d;return a=(0<=a?"+":"")+(Gb(Math[0<a?"floor":
"ceil"](a/60),2)+Gb(Math.abs(a%60),2))},ww:Fd(2),w:Fd(1),G:hc,GG:hc,GGG:hc,GGGG:function(a,c){return 0>=a.getFullYear()?c.ERANAMES[0]:c.ERANAMES[1]}},gg=/((?:[^yMdHhmsaZEwG']+)|(?:'(?:[^']|'')*')|(?:E+|y+|M+|d+|H+|h+|m+|s+|a|Z|G+|w+))(.*)/,fg=/^\-?\d+$/;zd.$inject=["$locale"];var cg=qa(M),dg=qa(rb);Bd.$inject=["$parse"];var he=qa({restrict:"E",compile:function(a,c){if(!c.href&&!c.xlinkHref)return function(a,c){if("a"===c[0].nodeName.toLowerCase()){var f="[object SVGAnimatedString]"===sa.call(c.prop("href"))?
"xlink:href":"href";c.on("click",function(a){c.attr(f)||a.preventDefault()})}}}}),sb={};m(Ab,function(a,c){function d(a,d,f){a.$watch(f[e],function(a){f.$set(c,!!a)})}if("multiple"!=a){var e=va("ng-"+c),f=d;"checked"===a&&(f=function(a,c,f){f.ngModel!==f[e]&&d(a,c,f)});sb[e]=function(){return{restrict:"A",priority:100,link:f}}}});m(Sc,function(a,c){sb[c]=function(){return{priority:100,link:function(a,e,f){if("ngPattern"===c&&"/"==f.ngPattern.charAt(0)&&(e=f.ngPattern.match(jg))){f.$set("ngPattern",
new RegExp(e[1],e[2]));return}a.$watch(f[c],function(a){f.$set(c,a)})}}}});m(["src","srcset","href"],function(a){var c=va("ng-"+a);sb[c]=function(){return{priority:99,link:function(d,e,f){var g=a,h=a;"href"===a&&"[object SVGAnimatedString]"===sa.call(e.prop("href"))&&(h="xlinkHref",f.$attr[h]="xlink:href",g=null);f.$observe(c,function(c){c?(f.$set(h,c),Va&&g&&e.prop(g,f[h])):"href"===a&&f.$set(h,null)})}}}});var Ib={$addControl:v,$$renameControl:function(a,c){a.$name=c},$removeControl:v,$setValidity:v,
$setDirty:v,$setPristine:v,$setSubmitted:v};Gd.$inject=["$element","$attrs","$scope","$animate","$interpolate"];var Od=function(a){return["$timeout","$parse",function(c,d){function e(a){return""===a?d('this[""]').assign:d(a).assign||v}return{name:"form",restrict:a?"EAC":"E",controller:Gd,compile:function(d,g){d.addClass(Xa).addClass(lb);var h=g.name?"name":a&&g.ngForm?"ngForm":!1;return{pre:function(a,d,f,g){if(!("action"in f)){var m=function(c){a.$apply(function(){g.$commitViewValue();g.$setSubmitted()});
c.preventDefault()};d[0].addEventListener("submit",m,!1);d.on("$destroy",function(){c(function(){d[0].removeEventListener("submit",m,!1)},0,!1)})}var s=g.$$parentForm,B=h?e(g.$name):v;h&&(B(a,g),f.$observe(h,function(c){g.$name!==c&&(B(a,t),s.$$renameControl(g,c),B=e(g.$name),B(a,g))}));d.on("$destroy",function(){s.$removeControl(g);B(a,t);Q(g,Ib)})}}}}}]},ie=Od(),ve=Od(!0),ig=/\d{4}-[01]\d-[0-3]\dT[0-2]\d:[0-5]\d:[0-5]\d\.\d+([+-][0-2]\d:[0-5]\d|Z)/,sg=/^(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?$/,
tg=/^[a-z0-9!#$%&'*+\/=?^_`{|}~.-]+@[a-z0-9]([a-z0-9-]*[a-z0-9])?(\.[a-z0-9]([a-z0-9-]*[a-z0-9])?)*$/i,ug=/^\s*(\-|\+)?(\d+|(\d*(\.\d*)))([eE][+-]?\d+)?\s*$/,Pd=/^(\d{4})-(\d{2})-(\d{2})$/,Qd=/^(\d{4})-(\d\d)-(\d\d)T(\d\d):(\d\d)(?::(\d\d)(\.\d{1,3})?)?$/,kc=/^(\d{4})-W(\d\d)$/,Rd=/^(\d{4})-(\d\d)$/,Sd=/^(\d\d):(\d\d)(?::(\d\d)(\.\d{1,3})?)?$/,Td={text:function(a,c,d,e,f,g){ib(a,c,d,e,f,g);ic(e)},date:jb("date",Pd,Kb(Pd,["yyyy","MM","dd"]),"yyyy-MM-dd"),"datetime-local":jb("datetimelocal",Qd,Kb(Qd,
"yyyy MM dd HH mm ss sss".split(" ")),"yyyy-MM-ddTHH:mm:ss.sss"),time:jb("time",Sd,Kb(Sd,["HH","mm","ss","sss"]),"HH:mm:ss.sss"),week:jb("week",kc,function(a,c){if(ca(a))return a;if(I(a)){kc.lastIndex=0;var d=kc.exec(a);if(d){var e=+d[1],f=+d[2],g=d=0,h=0,l=0,k=Ed(e),f=7*(f-1);c&&(d=c.getHours(),g=c.getMinutes(),h=c.getSeconds(),l=c.getMilliseconds());return new Date(e,0,k.getDate()+f,d,g,h,l)}}return NaN},"yyyy-Www"),month:jb("month",Rd,Kb(Rd,["yyyy","MM"]),"yyyy-MM"),number:function(a,c,d,e,f,g){Id(a,
c,d,e);ib(a,c,d,e,f,g);e.$$parserName="number";e.$parsers.push(function(a){return e.$isEmpty(a)?null:ug.test(a)?parseFloat(a):t});e.$formatters.push(function(a){if(!e.$isEmpty(a)){if(!X(a))throw kb("numfmt",a);a=a.toString()}return a});if(x(d.min)||d.ngMin){var h;e.$validators.min=function(a){return e.$isEmpty(a)||y(h)||a>=h};d.$observe("min",function(a){x(a)&&!X(a)&&(a=parseFloat(a,10));h=X(a)&&!isNaN(a)?a:t;e.$validate()})}if(x(d.max)||d.ngMax){var l;e.$validators.max=function(a){return e.$isEmpty(a)||
y(l)||a<=l};d.$observe("max",function(a){x(a)&&!X(a)&&(a=parseFloat(a,10));l=X(a)&&!isNaN(a)?a:t;e.$validate()})}},url:function(a,c,d,e,f,g){ib(a,c,d,e,f,g);ic(e);e.$$parserName="url";e.$validators.url=function(a,c){var d=a||c;return e.$isEmpty(d)||sg.test(d)}},email:function(a,c,d,e,f,g){ib(a,c,d,e,f,g);ic(e);e.$$parserName="email";e.$validators.email=function(a,c){var d=a||c;return e.$isEmpty(d)||tg.test(d)}},radio:function(a,c,d,e){y(d.name)&&c.attr("name",++mb);c.on("click",function(a){c[0].checked&&
e.$setViewValue(d.value,a&&a.type)});e.$render=function(){c[0].checked=d.value==e.$viewValue};d.$observe("value",e.$render)},checkbox:function(a,c,d,e,f,g,h,l){var k=Jd(l,a,"ngTrueValue",d.ngTrueValue,!0),n=Jd(l,a,"ngFalseValue",d.ngFalseValue,!1);c.on("click",function(a){e.$setViewValue(c[0].checked,a&&a.type)});e.$render=function(){c[0].checked=e.$viewValue};e.$isEmpty=function(a){return!1===a};e.$formatters.push(function(a){return ka(a,k)});e.$parsers.push(function(a){return a?k:n})},hidden:v,
button:v,submit:v,reset:v,file:v},Dc=["$browser","$sniffer","$filter","$parse",function(a,c,d,e){return{restrict:"E",require:["?ngModel"],link:{pre:function(f,g,h,l){l[0]&&(Td[M(h.type)]||Td.text)(f,g,h,l[0],c,a,d,e)}}}}],vg=/^(true|false|\d+)$/,Ne=function(){return{restrict:"A",priority:100,compile:function(a,c){return vg.test(c.ngValue)?function(a,c,f){f.$set("value",a.$eval(f.ngValue))}:function(a,c,f){a.$watch(f.ngValue,function(a){f.$set("value",a)})}}}},ne=["$compile",function(a){return{restrict:"AC",
compile:function(c){a.$$addBindingClass(c);return function(c,e,f){a.$$addBindingInfo(e,f.ngBind);e=e[0];c.$watch(f.ngBind,function(a){e.textContent=a===t?"":a})}}}}],pe=["$interpolate","$compile",function(a,c){return{compile:function(d){c.$$addBindingClass(d);return function(d,f,g){d=a(f.attr(g.$attr.ngBindTemplate));c.$$addBindingInfo(f,d.expressions);f=f[0];g.$observe("ngBindTemplate",function(a){f.textContent=a===t?"":a})}}}}],oe=["$sce","$parse","$compile",function(a,c,d){return{restrict:"A",
compile:function(e,f){var g=c(f.ngBindHtml),h=c(f.ngBindHtml,function(a){return(a||"").toString()});d.$$addBindingClass(e);return function(c,e,f){d.$$addBindingInfo(e,f.ngBindHtml);c.$watch(h,function(){e.html(a.getTrustedHtml(g(c))||"")})}}}}],Me=qa({restrict:"A",require:"ngModel",link:function(a,c,d,e){e.$viewChangeListeners.push(function(){a.$eval(d.ngChange)})}}),qe=jc("",!0),se=jc("Odd",0),re=jc("Even",1),te=Ma({compile:function(a,c){c.$set("ngCloak",t);a.removeClass("ng-cloak")}}),ue=[function(){return{restrict:"A",
scope:!0,controller:"@",priority:500}}],Ic={},wg={blur:!0,focus:!0};m("click dblclick mousedown mouseup mouseover mouseout mousemove mouseenter mouseleave keydown keyup keypress submit focus blur copy cut paste".split(" "),function(a){var c=va("ng-"+a);Ic[c]=["$parse","$rootScope",function(d,e){return{restrict:"A",compile:function(f,g){var h=d(g[c],null,!0);return function(c,d){d.on(a,function(d){var f=function(){h(c,{$event:d})};wg[a]&&e.$$phase?c.$evalAsync(f):c.$apply(f)})}}}}]});var xe=["$animate",
function(a){return{multiElement:!0,transclude:"element",priority:600,terminal:!0,restrict:"A",$$tlb:!0,link:function(c,d,e,f,g){var h,l,k;c.$watch(e.ngIf,function(c){c?l||g(function(c,f){l=f;c[c.length++]=W.createComment(" end ngIf: "+e.ngIf+" ");h={clone:c};a.enter(c,d.parent(),d)}):(k&&(k.remove(),k=null),l&&(l.$destroy(),l=null),h&&(k=qb(h.clone),a.leave(k).then(function(){k=null}),h=null))})}}}],ye=["$templateRequest","$anchorScroll","$animate",function(a,c,d){return{restrict:"ECA",priority:400,
terminal:!0,transclude:"element",controller:aa.noop,compile:function(e,f){var g=f.ngInclude||f.src,h=f.onload||"",l=f.autoscroll;return function(e,f,m,r,s){var t=0,v,w,p,A=function(){w&&(w.remove(),w=null);v&&(v.$destroy(),v=null);p&&(d.leave(p).then(function(){w=null}),w=p,p=null)};e.$watch(g,function(g){var m=function(){!x(l)||l&&!e.$eval(l)||c()},q=++t;g?(a(g,!0).then(function(a){if(q===t){var c=e.$new();r.template=a;a=s(c,function(a){A();d.enter(a,null,f).then(m)});v=c;p=a;v.$emit("$includeContentLoaded",
g);e.$eval(h)}},function(){q===t&&(A(),e.$emit("$includeContentError",g))}),e.$emit("$includeContentRequested",g)):(A(),r.template=null)})}}}}],Pe=["$compile",function(a){return{restrict:"ECA",priority:-400,require:"ngInclude",link:function(c,d,e,f){/SVG/.test(d[0].toString())?(d.empty(),a(Lc(f.template,W).childNodes)(c,function(a){d.append(a)},{futureParentElement:d})):(d.html(f.template),a(d.contents())(c))}}}],ze=Ma({priority:450,compile:function(){return{pre:function(a,c,d){a.$eval(d.ngInit)}}}}),
Le=function(){return{restrict:"A",priority:100,require:"ngModel",link:function(a,c,d,e){var f=c.attr(d.$attr.ngList)||", ",g="false"!==d.ngTrim,h=g?T(f):f;e.$parsers.push(function(a){if(!y(a)){var c=[];a&&m(a.split(h),function(a){a&&c.push(g?T(a):a)});return c}});e.$formatters.push(function(a){return G(a)?a.join(f):t});e.$isEmpty=function(a){return!a||!a.length}}}},lb="ng-valid",Kd="ng-invalid",Xa="ng-pristine",Jb="ng-dirty",Md="ng-pending",kb=L("ngModel"),xg=["$scope","$exceptionHandler","$attrs",
"$element","$parse","$animate","$timeout","$rootScope","$q","$interpolate",function(a,c,d,e,f,g,h,l,k,n){this.$modelValue=this.$viewValue=Number.NaN;this.$$rawModelValue=t;this.$validators={};this.$asyncValidators={};this.$parsers=[];this.$formatters=[];this.$viewChangeListeners=[];this.$untouched=!0;this.$touched=!1;this.$pristine=!0;this.$dirty=!1;this.$valid=!0;this.$invalid=!1;this.$error={};this.$$success={};this.$pending=t;this.$name=n(d.name||"",!1)(a);var q=f(d.ngModel),r=q.assign,s=q,B=r,
K=null,w,p=this;this.$$setOptions=function(a){if((p.$options=a)&&a.getterSetter){var c=f(d.ngModel+"()"),g=f(d.ngModel+"($$$p)");s=function(a){var d=q(a);C(d)&&(d=c(a));return d};B=function(a,c){C(q(a))?g(a,{$$$p:p.$modelValue}):r(a,p.$modelValue)}}else if(!q.assign)throw kb("nonassign",d.ngModel,ua(e));};this.$render=v;this.$isEmpty=function(a){return y(a)||""===a||null===a||a!==a};var A=e.inheritedData("$formController")||Ib,z=0;Hd({ctrl:this,$element:e,set:function(a,c){a[c]=!0},unset:function(a,
c){delete a[c]},parentForm:A,$animate:g});this.$setPristine=function(){p.$dirty=!1;p.$pristine=!0;g.removeClass(e,Jb);g.addClass(e,Xa)};this.$setDirty=function(){p.$dirty=!0;p.$pristine=!1;g.removeClass(e,Xa);g.addClass(e,Jb);A.$setDirty()};this.$setUntouched=function(){p.$touched=!1;p.$untouched=!0;g.setClass(e,"ng-untouched","ng-touched")};this.$setTouched=function(){p.$touched=!0;p.$untouched=!1;g.setClass(e,"ng-touched","ng-untouched")};this.$rollbackViewValue=function(){h.cancel(K);p.$viewValue=
p.$$lastCommittedViewValue;p.$render()};this.$validate=function(){if(!X(p.$modelValue)||!isNaN(p.$modelValue)){var a=p.$$rawModelValue,c=p.$valid,d=p.$modelValue,e=p.$options&&p.$options.allowInvalid;p.$$runValidators(a,p.$$lastCommittedViewValue,function(f){e||c===f||(p.$modelValue=f?a:t,p.$modelValue!==d&&p.$$writeModelToScope())})}};this.$$runValidators=function(a,c,d){function e(){var d=!0;m(p.$validators,function(e,f){var h=e(a,c);d=d&&h;g(f,h)});return d?!0:(m(p.$asyncValidators,function(a,
c){g(c,null)}),!1)}function f(){var d=[],e=!0;m(p.$asyncValidators,function(f,h){var k=f(a,c);if(!k||!C(k.then))throw kb("$asyncValidators",k);g(h,t);d.push(k.then(function(){g(h,!0)},function(a){e=!1;g(h,!1)}))});d.length?k.all(d).then(function(){h(e)},v):h(!0)}function g(a,c){l===z&&p.$setValidity(a,c)}function h(a){l===z&&d(a)}z++;var l=z;(function(){var a=p.$$parserName||"parse";if(w===t)g(a,null);else return w||(m(p.$validators,function(a,c){g(c,null)}),m(p.$asyncValidators,function(a,c){g(c,
null)})),g(a,w),w;return!0})()?e()?f():h(!1):h(!1)};this.$commitViewValue=function(){var a=p.$viewValue;h.cancel(K);if(p.$$lastCommittedViewValue!==a||""===a&&p.$$hasNativeValidators)p.$$lastCommittedViewValue=a,p.$pristine&&this.$setDirty(),this.$$parseAndValidate()};this.$$parseAndValidate=function(){var c=p.$$lastCommittedViewValue;if(w=y(c)?t:!0)for(var d=0;d<p.$parsers.length;d++)if(c=p.$parsers[d](c),y(c)){w=!1;break}X(p.$modelValue)&&isNaN(p.$modelValue)&&(p.$modelValue=s(a));var e=p.$modelValue,
f=p.$options&&p.$options.allowInvalid;p.$$rawModelValue=c;f&&(p.$modelValue=c,p.$modelValue!==e&&p.$$writeModelToScope());p.$$runValidators(c,p.$$lastCommittedViewValue,function(a){f||(p.$modelValue=a?c:t,p.$modelValue!==e&&p.$$writeModelToScope())})};this.$$writeModelToScope=function(){B(a,p.$modelValue);m(p.$viewChangeListeners,function(a){try{a()}catch(d){c(d)}})};this.$setViewValue=function(a,c){p.$viewValue=a;p.$options&&!p.$options.updateOnDefault||p.$$debounceViewValueCommit(c)};this.$$debounceViewValueCommit=
function(c){var d=0,e=p.$options;e&&x(e.debounce)&&(e=e.debounce,X(e)?d=e:X(e[c])?d=e[c]:X(e["default"])&&(d=e["default"]));h.cancel(K);d?K=h(function(){p.$commitViewValue()},d):l.$$phase?p.$commitViewValue():a.$apply(function(){p.$commitViewValue()})};a.$watch(function(){var c=s(a);if(c!==p.$modelValue&&(p.$modelValue===p.$modelValue||c===c)){p.$modelValue=p.$$rawModelValue=c;w=t;for(var d=p.$formatters,e=d.length,f=c;e--;)f=d[e](f);p.$viewValue!==f&&(p.$viewValue=p.$$lastCommittedViewValue=f,p.$render(),
p.$$runValidators(c,f,v))}return c})}],Ke=["$rootScope",function(a){return{restrict:"A",require:["ngModel","^?form","^?ngModelOptions"],controller:xg,priority:1,compile:function(c){c.addClass(Xa).addClass("ng-untouched").addClass(lb);return{pre:function(a,c,f,g){var h=g[0],l=g[1]||Ib;h.$$setOptions(g[2]&&g[2].$options);l.$addControl(h);f.$observe("name",function(a){h.$name!==a&&l.$$renameControl(h,a)});a.$on("$destroy",function(){l.$removeControl(h)})},post:function(c,e,f,g){var h=g[0];if(h.$options&&
h.$options.updateOn)e.on(h.$options.updateOn,function(a){h.$$debounceViewValueCommit(a&&a.type)});e.on("blur",function(e){h.$touched||(a.$$phase?c.$evalAsync(h.$setTouched):c.$apply(h.$setTouched))})}}}}}],yg=/(\s+|^)default(\s+|$)/,Oe=function(){return{restrict:"A",controller:["$scope","$attrs",function(a,c){var d=this;this.$options=fa(a.$eval(c.ngModelOptions));this.$options.updateOn!==t?(this.$options.updateOnDefault=!1,this.$options.updateOn=T(this.$options.updateOn.replace(yg,function(){d.$options.updateOnDefault=
!0;return" "}))):this.$options.updateOnDefault=!0}]}},Ae=Ma({terminal:!0,priority:1E3}),zg=L("ngOptions"),Ag=/^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+group\s+by\s+([\s\S]+?))?(?:\s+disable\s+when\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w]*)|(?:\(\s*([\$\w][\$\w]*)\s*,\s*([\$\w][\$\w]*)\s*\)))\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?$/,Ie=["$compile","$parse",function(a,c){function d(a,d,e){function f(a,c,d,e,g){this.selectValue=a;this.viewValue=c;this.label=d;this.group=e;this.disabled=g}
function n(a){var c;if(!s&&Da(a))c=a;else{c=[];for(var d in a)a.hasOwnProperty(d)&&"$"!==d.charAt(0)&&c.push(d)}return c}var m=a.match(Ag);if(!m)throw zg("iexp",a,ua(d));var r=m[5]||m[7],s=m[6];a=/ as /.test(m[0])&&m[1];var t=m[9];d=c(m[2]?m[1]:r);var v=a&&c(a)||d,w=t&&c(t),p=t?function(a,c){return w(e,c)}:function(a){return Ga(a)},A=function(a,c){return p(a,C(a,c))},x=c(m[2]||m[1]),z=c(m[3]||""),y=c(m[4]||""),J=c(m[8]),F={},C=s?function(a,c){F[s]=c;F[r]=a;return F}:function(a){F[r]=a;return F};return{trackBy:t,
getTrackByValue:A,getWatchables:c(J,function(a){var c=[];a=a||[];for(var d=n(a),f=d.length,g=0;g<f;g++){var h=a===d?g:d[g],k=C(a[h],h),h=p(a[h],k);c.push(h);if(m[2]||m[1])h=x(e,k),c.push(h);m[4]&&(k=y(e,k),c.push(k))}return c}),getOptions:function(){for(var a=[],c={},d=J(e)||[],g=n(d),h=g.length,m=0;m<h;m++){var q=d===g?m:g[m],r=C(d[q],q),s=v(e,r),q=p(s,r),u=x(e,r),w=z(e,r),r=y(e,r),s=new f(q,s,u,w,r);a.push(s);c[q]=s}return{items:a,selectValueMap:c,getOptionFromViewValue:function(a){return c[A(a)]},
getViewValueFromOption:function(a){return t?aa.copy(a.viewValue):a.viewValue}}}}}var e=W.createElement("option"),f=W.createElement("optgroup");return{restrict:"A",terminal:!0,require:["select","?ngModel"],link:function(c,h,l,k){function n(a,c){a.element=c;c.disabled=a.disabled;a.value!==c.value&&(c.value=a.selectValue);a.label!==c.label&&(c.label=a.label,c.textContent=a.label)}function q(a,c,d,e){c&&M(c.nodeName)===d?d=c:(d=e.cloneNode(!1),c?a.insertBefore(d,c):a.appendChild(d));return d}function r(a){for(var c;a;)c=
a.nextSibling,Wb(a),a=c}function s(a){var c=p&&p[0],d=J&&J[0];if(c||d)for(;a&&(a===c||a===d);)a=a.nextSibling;return a}function t(){var a=F&&w.readValue();F=D.getOptions();var c={},d=h[0].firstChild;N&&h.prepend(p);d=s(d);F.items.forEach(function(a){var g,k;a.group?(g=c[a.group],g||(g=q(h[0],d,"optgroup",f),d=g.nextSibling,g.label=a.group,g=c[a.group]={groupElement:g,currentOptionElement:g.firstChild}),k=q(g.groupElement,g.currentOptionElement,"option",e),n(a,k),g.currentOptionElement=k.nextSibling):
(k=q(h[0],d,"option",e),n(a,k),d=k.nextSibling)});Object.keys(c).forEach(function(a){r(c[a].currentOptionElement)});r(d);v.$render();if(!v.$isEmpty(a)){var g=w.readValue();(D.trackBy?ka(a,g):a===g)||(v.$setViewValue(g),v.$render())}}var v=k[1];if(v){var w=k[0];k=l.multiple;for(var p,x=0,y=h.children(),C=y.length;x<C;x++)if(""===y[x].value){p=y.eq(x);break}var N=!!p,J=z(e.cloneNode(!1));J.val("?");var F,D=d(l.ngOptions,h,c);k?(v.$isEmpty=function(a){return!a||0===a.length},w.writeValue=function(a){F.items.forEach(function(a){a.element.selected=
!1});a&&a.forEach(function(a){(a=F.getOptionFromViewValue(a))&&!a.disabled&&(a.element.selected=!0)})},w.readValue=function(){var a=h.val()||[],c=[];m(a,function(a){(a=F.selectValueMap[a])&&!a.disabled&&c.push(F.getViewValueFromOption(a))});return c},D.trackBy&&c.$watchCollection(function(){if(G(v.$viewValue))return v.$viewValue.map(function(a){return D.getTrackByValue(a)})},function(){v.$render()})):(w.writeValue=function(a){var c=F.getOptionFromViewValue(a);c&&!c.disabled?h[0].value!==c.selectValue&&
(J.remove(),N||p.remove(),h[0].value=c.selectValue,c.element.selected=!0,c.element.setAttribute("selected","selected")):null===a||N?(J.remove(),N||h.prepend(p),h.val(""),p.prop("selected",!0),p.attr("selected",!0)):(N||p.remove(),h.prepend(J),h.val("?"),J.prop("selected",!0),J.attr("selected",!0))},w.readValue=function(){var a=F.selectValueMap[h.val()];return a&&!a.disabled?(N||p.remove(),J.remove(),F.getViewValueFromOption(a)):null},D.trackBy&&c.$watch(function(){return D.getTrackByValue(v.$viewValue)},
function(){v.$render()}));N?(p.remove(),a(p)(c),p.removeClass("ng-scope")):p=z(e.cloneNode(!1));t();c.$watchCollection(D.getWatchables,t)}}}}],Be=["$locale","$interpolate","$log",function(a,c,d){var e=/{}/g,f=/^when(Minus)?(.+)$/;return{link:function(g,h,l){function k(a){h.text(a||"")}var n=l.count,q=l.$attr.when&&h.attr(l.$attr.when),r=l.offset||0,s=g.$eval(q)||{},t={},x=c.startSymbol(),w=c.endSymbol(),p=x+n+"-"+r+w,A=aa.noop,z;m(l,function(a,c){var d=f.exec(c);d&&(d=(d[1]?"-":"")+M(d[2]),s[d]=h.attr(l.$attr[c]))});
m(s,function(a,d){t[d]=c(a.replace(e,p))});g.$watch(n,function(c){var e=parseFloat(c),f=isNaN(e);f||e in s||(e=a.pluralCat(e-r));e===z||f&&X(z)&&isNaN(z)||(A(),f=t[e],y(f)?(null!=c&&d.debug("ngPluralize: no rule defined for '"+e+"' in "+q),A=v,k()):A=g.$watch(f,k),z=e)})}}}],Ce=["$parse","$animate",function(a,c){var d=L("ngRepeat"),e=function(a,c,d,e,k,n,m){a[d]=e;k&&(a[k]=n);a.$index=c;a.$first=0===c;a.$last=c===m-1;a.$middle=!(a.$first||a.$last);a.$odd=!(a.$even=0===(c&1))};return{restrict:"A",
multiElement:!0,transclude:"element",priority:1E3,terminal:!0,$$tlb:!0,compile:function(f,g){var h=g.ngRepeat,l=W.createComment(" end ngRepeat: "+h+" "),k=h.match(/^\s*([\s\S]+?)\s+in\s+([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+track\s+by\s+([\s\S]+?))?\s*$/);if(!k)throw d("iexp",h);var n=k[1],q=k[2],r=k[3],s=k[4],k=n.match(/^(?:(\s*[\$\w]+)|\(\s*([\$\w]+)\s*,\s*([\$\w]+)\s*\))$/);if(!k)throw d("iidexp",n);var v=k[3]||k[1],x=k[2];if(r&&(!/^[$a-zA-Z_][$a-zA-Z0-9_]*$/.test(r)||/^(null|undefined|this|\$index|\$first|\$middle|\$last|\$even|\$odd|\$parent|\$root|\$id)$/.test(r)))throw d("badident",
r);var w,p,A,y,C={$id:Ga};s?w=a(s):(A=function(a,c){return Ga(c)},y=function(a){return a});return function(a,f,g,k,n){w&&(p=function(c,d,e){x&&(C[x]=c);C[v]=d;C.$index=e;return w(a,C)});var s=ga();a.$watchCollection(q,function(g){var k,q,u=f[0],w,C=ga(),D,F,I,G,L,H,M;r&&(a[r]=g);if(Da(g))L=g,q=p||A;else for(M in q=p||y,L=[],g)g.hasOwnProperty(M)&&"$"!==M.charAt(0)&&L.push(M);D=L.length;M=Array(D);for(k=0;k<D;k++)if(F=g===L?k:L[k],I=g[F],G=q(F,I,k),s[G])H=s[G],delete s[G],C[G]=H,M[k]=H;else{if(C[G])throw m(M,
function(a){a&&a.scope&&(s[a.id]=a)}),d("dupes",h,G,I);M[k]={id:G,scope:t,clone:t};C[G]=!0}for(w in s){H=s[w];G=qb(H.clone);c.leave(G);if(G[0].parentNode)for(k=0,q=G.length;k<q;k++)G[k].$$NG_REMOVED=!0;H.scope.$destroy()}for(k=0;k<D;k++)if(F=g===L?k:L[k],I=g[F],H=M[k],H.scope){w=u;do w=w.nextSibling;while(w&&w.$$NG_REMOVED);H.clone[0]!=w&&c.move(qb(H.clone),null,z(u));u=H.clone[H.clone.length-1];e(H.scope,k,v,I,x,F,D)}else n(function(a,d){H.scope=d;var f=l.cloneNode(!1);a[a.length++]=f;c.enter(a,
null,z(u));u=f;H.clone=a;C[H.id]=H;e(H.scope,k,v,I,x,F,D)});s=C})}}}}],De=["$animate",function(a){return{restrict:"A",multiElement:!0,link:function(c,d,e){c.$watch(e.ngShow,function(c){a[c?"removeClass":"addClass"](d,"ng-hide",{tempClasses:"ng-hide-animate"})})}}}],we=["$animate",function(a){return{restrict:"A",multiElement:!0,link:function(c,d,e){c.$watch(e.ngHide,function(c){a[c?"addClass":"removeClass"](d,"ng-hide",{tempClasses:"ng-hide-animate"})})}}}],Ee=Ma(function(a,c,d){a.$watch(d.ngStyle,
function(a,d){d&&a!==d&&m(d,function(a,d){c.css(d,"")});a&&c.css(a)},!0)}),Fe=["$animate",function(a){return{require:"ngSwitch",controller:["$scope",function(){this.cases={}}],link:function(c,d,e,f){var g=[],h=[],l=[],k=[],n=function(a,c){return function(){a.splice(c,1)}};c.$watch(e.ngSwitch||e.on,function(c){var d,e;d=0;for(e=l.length;d<e;++d)a.cancel(l[d]);d=l.length=0;for(e=k.length;d<e;++d){var s=qb(h[d].clone);k[d].$destroy();(l[d]=a.leave(s)).then(n(l,d))}h.length=0;k.length=0;(g=f.cases["!"+
c]||f.cases["?"])&&m(g,function(c){c.transclude(function(d,e){k.push(e);var f=c.element;d[d.length++]=W.createComment(" end ngSwitchWhen: ");h.push({clone:d});a.enter(d,f.parent(),f)})})})}}}],Ge=Ma({transclude:"element",priority:1200,require:"^ngSwitch",multiElement:!0,link:function(a,c,d,e,f){e.cases["!"+d.ngSwitchWhen]=e.cases["!"+d.ngSwitchWhen]||[];e.cases["!"+d.ngSwitchWhen].push({transclude:f,element:c})}}),He=Ma({transclude:"element",priority:1200,require:"^ngSwitch",multiElement:!0,link:function(a,
c,d,e,f){e.cases["?"]=e.cases["?"]||[];e.cases["?"].push({transclude:f,element:c})}}),Je=Ma({restrict:"EAC",link:function(a,c,d,e,f){if(!f)throw L("ngTransclude")("orphan",ua(c));f(function(a){c.empty();c.append(a)})}}),je=["$templateCache",function(a){return{restrict:"E",terminal:!0,compile:function(c,d){"text/ng-template"==d.type&&a.put(d.id,c[0].text)}}}],Bg={$setViewValue:v,$render:v},Cg=["$element","$scope","$attrs",function(a,c,d){var e=this,f=new Ua;e.ngModelCtrl=Bg;e.unknownOption=z(W.createElement("option"));
e.renderUnknownOption=function(c){c="? "+Ga(c)+" ?";e.unknownOption.val(c);a.prepend(e.unknownOption);a.val(c)};c.$on("$destroy",function(){e.renderUnknownOption=v});e.removeUnknownOption=function(){e.unknownOption.parent()&&e.unknownOption.remove()};e.readValue=function(){e.removeUnknownOption();return a.val()};e.writeValue=function(c){e.hasOption(c)?(e.removeUnknownOption(),a.val(c),""===c&&e.emptyOption.prop("selected",!0)):null==c&&e.emptyOption?(e.removeUnknownOption(),a.val("")):e.renderUnknownOption(c)};
e.addOption=function(a,c){Ta(a,'"option value"');""===a&&(e.emptyOption=c);var d=f.get(a)||0;f.put(a,d+1)};e.removeOption=function(a){var c=f.get(a);c&&(1===c?(f.remove(a),""===a&&(e.emptyOption=t)):f.put(a,c-1))};e.hasOption=function(a){return!!f.get(a)}}],ke=function(){return{restrict:"E",require:["select","?ngModel"],controller:Cg,link:function(a,c,d,e){var f=e[1];if(f){var g=e[0];g.ngModelCtrl=f;f.$render=function(){g.writeValue(f.$viewValue)};c.on("change",function(){a.$apply(function(){f.$setViewValue(g.readValue())})});
if(d.multiple){g.readValue=function(){var a=[];m(c.find("option"),function(c){c.selected&&a.push(c.value)});return a};g.writeValue=function(a){var d=new Ua(a);m(c.find("option"),function(a){a.selected=x(d.get(a.value))})};var h,l=NaN;a.$watch(function(){l!==f.$viewValue||ka(h,f.$viewValue)||(h=ia(f.$viewValue),f.$render());l=f.$viewValue});f.$isEmpty=function(a){return!a||0===a.length}}}}}},me=["$interpolate",function(a){function c(a){a[0].hasAttribute("selected")&&(a[0].selected=!0)}return{restrict:"E",
priority:100,compile:function(d,e){if(y(e.value)){var f=a(d.text(),!0);f||e.$set("value",d.text())}return function(a,d,e){var k=d.parent(),m=k.data("$selectController")||k.parent().data("$selectController");m&&m.ngModelCtrl&&(f?a.$watch(f,function(a,f){e.$set("value",a);f!==a&&m.removeOption(f);m.addOption(a,d);m.ngModelCtrl.$render();c(d)}):(m.addOption(e.value,d),m.ngModelCtrl.$render(),c(d)),d.on("$destroy",function(){m.removeOption(e.value);m.ngModelCtrl.$render()}))}}}}],le=qa({restrict:"E",
terminal:!1}),Fc=function(){return{restrict:"A",require:"?ngModel",link:function(a,c,d,e){e&&(d.required=!0,e.$validators.required=function(a,c){return!d.required||!e.$isEmpty(c)},d.$observe("required",function(){e.$validate()}))}}},Ec=function(){return{restrict:"A",require:"?ngModel",link:function(a,c,d,e){if(e){var f,g=d.ngPattern||d.pattern;d.$observe("pattern",function(a){I(a)&&0<a.length&&(a=new RegExp("^"+a+"$"));if(a&&!a.test)throw L("ngPattern")("noregexp",g,a,ua(c));f=a||t;e.$validate()});
e.$validators.pattern=function(a){return e.$isEmpty(a)||y(f)||f.test(a)}}}}},Hc=function(){return{restrict:"A",require:"?ngModel",link:function(a,c,d,e){if(e){var f=-1;d.$observe("maxlength",function(a){a=Y(a);f=isNaN(a)?-1:a;e.$validate()});e.$validators.maxlength=function(a,c){return 0>f||e.$isEmpty(c)||c.length<=f}}}}},Gc=function(){return{restrict:"A",require:"?ngModel",link:function(a,c,d,e){if(e){var f=0;d.$observe("minlength",function(a){f=Y(a)||0;e.$validate()});e.$validators.minlength=function(a,
c){return e.$isEmpty(c)||c.length>=f}}}}};O.angular.bootstrap?console.log("WARNING: Tried to load angular more than once."):(ce(),ee(aa),aa.module("ngLocale",[],["$provide",function(a){function c(a){a+="";var c=a.indexOf(".");return-1==c?0:a.length-c-1}a.value("$locale",{DATETIME_FORMATS:{AMPMS:["AM","PM"],DAY:"Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "),ERANAMES:["Before Christ","Anno Domini"],ERAS:["BC","AD"],FIRSTDAYOFWEEK:6,MONTH:"January February March April May June July August September October November December".split(" "),
SHORTDAY:"Sun Mon Tue Wed Thu Fri Sat".split(" "),SHORTMONTH:"Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec".split(" "),WEEKENDRANGE:[5,6],fullDate:"EEEE, MMMM d, y",longDate:"MMMM d, y",medium:"MMM d, y h:mm:ss a",mediumDate:"MMM d, y",mediumTime:"h:mm:ss a","short":"M/d/yy h:mm a",shortDate:"M/d/yy",shortTime:"h:mm a"},NUMBER_FORMATS:{CURRENCY_SYM:"$",DECIMAL_SEP:".",GROUP_SEP:",",PATTERNS:[{gSize:3,lgSize:3,maxFrac:3,minFrac:0,minInt:1,negPre:"-",negSuf:"",posPre:"",posSuf:""},{gSize:3,lgSize:3,
maxFrac:2,minFrac:2,minInt:1,negPre:"-\u00a4",negSuf:"",posPre:"\u00a4",posSuf:""}]},id:"en-us",pluralCat:function(a,e){var f=a|0,g=e;t===g&&(g=Math.min(c(a),3));Math.pow(10,g);return 1==f&&0==g?"one":"other"}})}]),z(W).ready(function(){Zd(W,yc)}))})(window,document);!window.angular.$$csp().noInlineStyle&&window.angular.element(document.head).prepend('<style type="text/css">@charset "UTF-8";[ng\\:cloak],[ng-cloak],[data-ng-cloak],[x-ng-cloak],.ng-cloak,.x-ng-cloak,.ng-hide:not(.ng-hide-animate){display:none !important;}ng\\:form{display:block;}.ng-animate-shim{visibility:hidden;}.ng-anchor{position:absolute;}</style>');
//# sourceMappingURL=angular.min.js.map
;
return root.angular = angular;
  }).apply(root, arguments);
});
}(this));

(function(root) {
define("ngRoute", ["angular"], function() {
  return (function() {
/*
 AngularJS v1.4.4
 (c) 2010-2015 Google, Inc. http://angularjs.org
 License: MIT
*/
(function(p,c,C){'use strict';function v(r,h,g){return{restrict:"ECA",terminal:!0,priority:400,transclude:"element",link:function(a,f,b,d,y){function z(){k&&(g.cancel(k),k=null);l&&(l.$destroy(),l=null);m&&(k=g.leave(m),k.then(function(){k=null}),m=null)}function x(){var b=r.current&&r.current.locals;if(c.isDefined(b&&b.$template)){var b=a.$new(),d=r.current;m=y(b,function(b){g.enter(b,null,m||f).then(function(){!c.isDefined(t)||t&&!a.$eval(t)||h()});z()});l=d.scope=b;l.$emit("$viewContentLoaded");
l.$eval(w)}else z()}var l,m,k,t=b.autoscroll,w=b.onload||"";a.$on("$routeChangeSuccess",x);x()}}}function A(c,h,g){return{restrict:"ECA",priority:-400,link:function(a,f){var b=g.current,d=b.locals;f.html(d.$template);var y=c(f.contents());b.controller&&(d.$scope=a,d=h(b.controller,d),b.controllerAs&&(a[b.controllerAs]=d),f.data("$ngControllerController",d),f.children().data("$ngControllerController",d));y(a)}}}p=c.module("ngRoute",["ng"]).provider("$route",function(){function r(a,f){return c.extend(Object.create(a),
f)}function h(a,c){var b=c.caseInsensitiveMatch,d={originalPath:a,regexp:a},g=d.keys=[];a=a.replace(/([().])/g,"\\$1").replace(/(\/)?:(\w+)([\?\*])?/g,function(a,c,b,d){a="?"===d?d:null;d="*"===d?d:null;g.push({name:b,optional:!!a});c=c||"";return""+(a?"":c)+"(?:"+(a?c:"")+(d&&"(.+?)"||"([^/]+)")+(a||"")+")"+(a||"")}).replace(/([\/$\*])/g,"\\$1");d.regexp=new RegExp("^"+a+"$",b?"i":"");return d}var g={};this.when=function(a,f){var b=c.copy(f);c.isUndefined(b.reloadOnSearch)&&(b.reloadOnSearch=!0);
c.isUndefined(b.caseInsensitiveMatch)&&(b.caseInsensitiveMatch=this.caseInsensitiveMatch);g[a]=c.extend(b,a&&h(a,b));if(a){var d="/"==a[a.length-1]?a.substr(0,a.length-1):a+"/";g[d]=c.extend({redirectTo:a},h(d,b))}return this};this.caseInsensitiveMatch=!1;this.otherwise=function(a){"string"===typeof a&&(a={redirectTo:a});this.when(null,a);return this};this.$get=["$rootScope","$location","$routeParams","$q","$injector","$templateRequest","$sce",function(a,f,b,d,h,p,x){function l(b){var e=s.current;
(v=(n=k())&&e&&n.$$route===e.$$route&&c.equals(n.pathParams,e.pathParams)&&!n.reloadOnSearch&&!w)||!e&&!n||a.$broadcast("$routeChangeStart",n,e).defaultPrevented&&b&&b.preventDefault()}function m(){var u=s.current,e=n;if(v)u.params=e.params,c.copy(u.params,b),a.$broadcast("$routeUpdate",u);else if(e||u)w=!1,(s.current=e)&&e.redirectTo&&(c.isString(e.redirectTo)?f.path(t(e.redirectTo,e.params)).search(e.params).replace():f.url(e.redirectTo(e.pathParams,f.path(),f.search())).replace()),d.when(e).then(function(){if(e){var a=
c.extend({},e.resolve),b,f;c.forEach(a,function(b,e){a[e]=c.isString(b)?h.get(b):h.invoke(b,null,null,e)});c.isDefined(b=e.template)?c.isFunction(b)&&(b=b(e.params)):c.isDefined(f=e.templateUrl)&&(c.isFunction(f)&&(f=f(e.params)),c.isDefined(f)&&(e.loadedTemplateUrl=x.valueOf(f),b=p(f)));c.isDefined(b)&&(a.$template=b);return d.all(a)}}).then(function(f){e==s.current&&(e&&(e.locals=f,c.copy(e.params,b)),a.$broadcast("$routeChangeSuccess",e,u))},function(b){e==s.current&&a.$broadcast("$routeChangeError",
e,u,b)})}function k(){var a,b;c.forEach(g,function(d,g){var q;if(q=!b){var h=f.path();q=d.keys;var l={};if(d.regexp)if(h=d.regexp.exec(h)){for(var k=1,m=h.length;k<m;++k){var n=q[k-1],p=h[k];n&&p&&(l[n.name]=p)}q=l}else q=null;else q=null;q=a=q}q&&(b=r(d,{params:c.extend({},f.search(),a),pathParams:a}),b.$$route=d)});return b||g[null]&&r(g[null],{params:{},pathParams:{}})}function t(a,b){var d=[];c.forEach((a||"").split(":"),function(a,c){if(0===c)d.push(a);else{var f=a.match(/(\w+)(?:[?*])?(.*)/),
g=f[1];d.push(b[g]);d.push(f[2]||"");delete b[g]}});return d.join("")}var w=!1,n,v,s={routes:g,reload:function(){w=!0;a.$evalAsync(function(){l();m()})},updateParams:function(a){if(this.current&&this.current.$$route)a=c.extend({},this.current.params,a),f.path(t(this.current.$$route.originalPath,a)),f.search(a);else throw B("norout");}};a.$on("$locationChangeStart",l);a.$on("$locationChangeSuccess",m);return s}]});var B=c.$$minErr("ngRoute");p.provider("$routeParams",function(){this.$get=function(){return{}}});
p.directive("ngView",v);p.directive("ngView",A);v.$inject=["$route","$anchorScroll","$animate"];A.$inject=["$compile","$controller","$route"]})(window,window.angular);
//# sourceMappingURL=angular-route.min.js.map
;

  }).apply(root, arguments);
});
}(this));

(function(root) {
define("ngAnimate", ["angular"], function() {
  return (function() {
/*
 AngularJS v1.4.4
 (c) 2010-2015 Google, Inc. http://angularjs.org
 License: MIT
*/
(function(E,s,X){'use strict';function sa(a,b,c){if(!a)throw ngMinErr("areq",b||"?",c||"required");return a}function ta(a,b){if(!a&&!b)return"";if(!a)return b;if(!b)return a;Y(a)&&(a=a.join(" "));Y(b)&&(b=b.join(" "));return a+" "+b}function Da(a){var b={};a&&(a.to||a.from)&&(b.to=a.to,b.from=a.from);return b}function U(a,b,c){var d="";a=Y(a)?a:a&&O(a)&&a.length?a.split(/\s+/):[];l(a,function(a,w){a&&0<a.length&&(d+=0<w?" ":"",d+=c?b+a:a+b)});return d}function Ea(a){if(a instanceof J)switch(a.length){case 0:return[];
case 1:if(1===a[0].nodeType)return a;break;default:return J(ia(a))}if(1===a.nodeType)return J(a)}function ia(a){if(!a[0])return a;for(var b=0;b<a.length;b++){var c=a[b];if(1==c.nodeType)return c}}function Fa(a,b,c){l(b,function(b){a.addClass(b,c)})}function Ga(a,b,c){l(b,function(b){a.removeClass(b,c)})}function R(a){return function(b,c){c.addClass&&(Fa(a,b,c.addClass),c.addClass=null);c.removeClass&&(Ga(a,b,c.removeClass),c.removeClass=null)}}function ha(a){a=a||{};if(!a.$$prepared){var b=a.domOperation||
G;a.domOperation=function(){a.$$domOperationFired=!0;b();b=G};a.$$prepared=!0}return a}function da(a,b){ua(a,b);va(a,b)}function ua(a,b){b.from&&(a.css(b.from),b.from=null)}function va(a,b){b.to&&(a.css(b.to),b.to=null)}function S(a,b,c){var d=(b.addClass||"")+" "+(c.addClass||""),e=(b.removeClass||"")+" "+(c.removeClass||"");a=Ha(a.attr("class"),d,e);c.preparationClasses&&(b.preparationClasses=V(c.preparationClasses,b.preparationClasses),delete c.preparationClasses);d=b.domOperation!==G?b.domOperation:
null;wa(b,c);d&&(b.domOperation=d);b.addClass=a.addClass?a.addClass:null;b.removeClass=a.removeClass?a.removeClass:null;return b}function Ha(a,b,c){function d(a){O(a)&&(a=a.split(" "));var b={};l(a,function(a){a.length&&(b[a]=!0)});return b}var e={};a=d(a);b=d(b);l(b,function(a,b){e[b]=1});c=d(c);l(c,function(a,b){e[b]=1===e[b]?null:-1});var w={addClass:"",removeClass:""};l(e,function(b,c){var d,e;1===b?(d="addClass",e=!a[c]):-1===b&&(d="removeClass",e=a[c]);e&&(w[d].length&&(w[d]+=" "),w[d]+=c)});
return w}function D(a){return a instanceof s.element?a[0]:a}function xa(a,b,c){var d="";b&&(d=U(b,"ng-",!0));c.addClass&&(d=V(d,U(c.addClass,"-add")));c.removeClass&&(d=V(d,U(c.removeClass,"-remove")));d.length&&(c.preparationClasses=d,a.addClass(d))}function $(a,b){var c=b?"-"+b+"s":"";ea(a,[fa,c]);return[fa,c]}function ja(a,b){var c=b?"paused":"",d=W+"PlayState";ea(a,[d,c]);return[d,c]}function ea(a,b){a.style[b[0]]=b[1]}function V(a,b){return a?b?a+" "+b:a:b}function ya(a,b,c){var d=Object.create(null),
e=a.getComputedStyle(b)||{};l(c,function(a,b){var c=e[a];if(c){var F=c.charAt(0);if("-"===F||"+"===F||0<=F)c=Ia(c);0===c&&(c=null);d[b]=c}});return d}function Ia(a){var b=0;a=a.split(/\s*,\s*/);l(a,function(a){"s"==a.charAt(a.length-1)&&(a=a.substring(0,a.length-1));a=parseFloat(a)||0;b=b?Math.max(a,b):a});return b}function ka(a){return 0===a||null!=a}function za(a,b){var c=K,d=a+"s";b?c+="Duration":d+=" linear all";return[c,d]}function Aa(){var a=Object.create(null);return{flush:function(){a=Object.create(null)},
count:function(b){return(b=a[b])?b.total:0},get:function(b){return(b=a[b])&&b.value},put:function(b,c){a[b]?a[b].total++:a[b]={total:1,value:c}}}}var G=s.noop,wa=s.extend,J=s.element,l=s.forEach,Y=s.isArray,O=s.isString,la=s.isObject,Ja=s.isUndefined,Ka=s.isDefined,Ba=s.isFunction,ma=s.isElement,K,na,W,oa;E.ontransitionend===X&&E.onwebkittransitionend!==X?(K="WebkitTransition",na="webkitTransitionEnd transitionend"):(K="transition",na="transitionend");E.onanimationend===X&&E.onwebkitanimationend!==
X?(W="WebkitAnimation",oa="webkitAnimationEnd animationend"):(W="animation",oa="animationend");var pa=W+"Delay",qa=W+"Duration",fa=K+"Delay";E=K+"Duration";var La={transitionDuration:E,transitionDelay:fa,transitionProperty:K+"Property",animationDuration:qa,animationDelay:pa,animationIterationCount:W+"IterationCount"},Ma={transitionDuration:E,transitionDelay:fa,animationDuration:qa,animationDelay:pa};s.module("ngAnimate",[]).provider("$$body",function(){this.$get=["$document",function(a){return J(a[0].body)}]}).directive("ngAnimateChildren",
[function(){return function(a,b,c){a=c.ngAnimateChildren;s.isString(a)&&0===a.length?b.data("$$ngAnimateChildren",!0):c.$observe("ngAnimateChildren",function(a){b.data("$$ngAnimateChildren","on"===a||"true"===a)})}}]).factory("$$rAFMutex",["$$rAF",function(a){return function(){var b=!1;a(function(){b=!0});return function(c){b?c():a(c)}}}]).factory("$$AnimateRunner",["$q","$$rAFMutex",function(a,b){function c(a){this.setHost(a);this._doneCallbacks=[];this._runInAnimationFrame=b();this._state=0}c.chain=
function(a,b){function c(){if(H===a.length)b(!0);else a[H](function(a){!1===a?b(!1):(H++,c())})}var H=0;c()};c.all=function(a,b){function c(w){u=u&&w;++H===a.length&&b(u)}var H=0,u=!0;l(a,function(a){a.done(c)})};c.prototype={setHost:function(a){this.host=a||{}},done:function(a){2===this._state?a():this._doneCallbacks.push(a)},progress:G,getPromise:function(){if(!this.promise){var b=this;this.promise=a(function(a,c){b.done(function(b){!1===b?c():a()})})}return this.promise},then:function(a,b){return this.getPromise().then(a,
b)},"catch":function(a){return this.getPromise()["catch"](a)},"finally":function(a){return this.getPromise()["finally"](a)},pause:function(){this.host.pause&&this.host.pause()},resume:function(){this.host.resume&&this.host.resume()},end:function(){this.host.end&&this.host.end();this._resolve(!0)},cancel:function(){this.host.cancel&&this.host.cancel();this._resolve(!1)},complete:function(a){var b=this;0===b._state&&(b._state=1,b._runInAnimationFrame(function(){b._resolve(a)}))},_resolve:function(a){2!==
this._state&&(l(this._doneCallbacks,function(b){b(a)}),this._doneCallbacks.length=0,this._state=2)}};return c}]).provider("$$animateQueue",["$animateProvider",function(a){function b(a,b,c,l){return d[a].some(function(a){return a(b,c,l)})}function c(a,b){a=a||{};var c=0<(a.addClass||"").length,d=0<(a.removeClass||"").length;return b?c&&d:c||d}var d=this.rules={skip:[],cancel:[],join:[]};d.join.push(function(a,b,d){return!b.structural&&c(b.options)});d.skip.push(function(a,b,d){return!b.structural&&
!c(b.options)});d.skip.push(function(a,b,c){return"leave"==c.event&&b.structural});d.skip.push(function(a,b,c){return c.structural&&2===c.state&&!b.structural});d.cancel.push(function(a,b,c){return c.structural&&b.structural});d.cancel.push(function(a,b,c){return 2===c.state&&b.structural});d.cancel.push(function(a,b,c){a=b.options;c=c.options;return a.addClass&&a.addClass===c.removeClass||a.removeClass&&a.removeClass===c.addClass});this.$get=["$$rAF","$rootScope","$rootElement","$document","$$body",
"$$HashMap","$$animation","$$AnimateRunner","$templateRequest","$$jqLite","$$forceReflow",function(d,w,H,u,F,B,N,z,Na,t,Oa){function s(a,b){var c=D(a),f=[],h=r[b];h&&l(h,function(a){a.node.contains(c)&&f.push(a.callback)});return f}function I(a,b,c,f){d(function(){l(s(b,a),function(a){a(b,c,f)})})}function n(a,h,m){function d(b,c,f,h){I(c,a,f,h);b.progress(c,f,h)}function r(b){var c=a,f=m;f.preparationClasses&&(c.removeClass(f.preparationClasses),f.preparationClasses=null);f.activeClasses&&(c.removeClass(f.activeClasses),
f.activeClasses=null);Ca(a,m);da(a,m);m.domOperation();q.complete(!b)}var g,n;if(a=Ea(a))g=D(a),n=a.parent();m=ha(m);var q=new z;Y(m.addClass)&&(m.addClass=m.addClass.join(" "));m.addClass&&!O(m.addClass)&&(m.addClass=null);Y(m.removeClass)&&(m.removeClass=m.removeClass.join(" "));m.removeClass&&!O(m.removeClass)&&(m.removeClass=null);m.from&&!la(m.from)&&(m.from=null);m.to&&!la(m.to)&&(m.to=null);if(!g)return r(),q;var e=[g.className,m.addClass,m.removeClass].join(" ");if(!A(e))return r(),q;var l=
0<=["enter","move","leave"].indexOf(h),F=!M||x.get(g),e=!F&&v.get(g)||{},t=!!e.state;F||t&&1==e.state||(F=!ca(a,n,h));if(F)return r(),q;l&&y(a);n={structural:l,element:a,event:h,close:r,options:m,runner:q};if(t){if(b("skip",a,n,e)){if(2===e.state)return r(),q;S(a,e.options,m);return e.runner}if(b("cancel",a,n,e))if(2===e.state)e.runner.end();else if(e.structural)e.close();else return S(a,e.options,n.options),e.runner;else if(b("join",a,n,e))if(2===e.state)S(a,m,{});else return xa(a,l?h:null,m),h=
n.event=e.event,m=S(a,e.options,n.options),e.runner}else S(a,m,{});(t=n.structural)||(t="animate"===n.event&&0<Object.keys(n.options.to||{}).length||c(n.options));if(!t)return r(),f(a),q;xa(a,l?h:null,m);$(g,9999);var B=(e.counter||0)+1;n.counter=B;k(a,1,n);w.$$postDigest(function(){var b=v.get(g),y=!b,b=b||{},A=0<(a.parent()||[]).length&&("animate"===b.event||b.structural||c(b.options));if(y||b.counter!==B||!A){y&&(Ca(a,m),da(a,m));if(y||l&&b.event!==h)m.domOperation(),q.end();A||f(a)}else h=!b.structural&&
c(b.options,!0)?"setClass":b.event,k(a,2),b=N(a,h,b.options,function(a){Oa();$(D(a),!1)}),b.done(function(b){r(!b);(b=v.get(g))&&b.counter===B&&f(D(a));d(q,h,"close",{})}),q.setHost(b),d(q,h,"start",{})});return q}function y(a){a=D(a).querySelectorAll("[data-ng-animate]");l(a,function(a){var b=parseInt(a.getAttribute("data-ng-animate")),c=v.get(a);switch(b){case 2:c.runner.end();case 1:c&&v.remove(a)}})}function f(a){a=D(a);a.removeAttribute("data-ng-animate");v.remove(a)}function g(a,b){return D(a)===
D(b)}function ca(a,b,c){c=g(a,F)||"HTML"===a[0].nodeName;var f=g(a,H),h=!1,r;for((a=a.data("$ngAnimatePin"))&&(b=a);b&&b.length;){f||(f=g(b,H));a=b[0];if(1!==a.nodeType)break;var d=v.get(a)||{};h||(h=d.structural||x.get(a));if(Ja(r)||!0===r)a=b.data("$$ngAnimateChildren"),Ka(a)&&(r=a);if(h&&!1===r)break;f||(f=g(b,H),f||(a=b.data("$ngAnimatePin"))&&(b=a));c||(c=g(b,F));b=b.parent()}return(!h||r)&&f&&c}function k(a,b,c){c=c||{};c.state=b;a=D(a);a.setAttribute("data-ng-animate",b);c=(b=v.get(a))?wa(b,
c):c;v.put(a,c)}var v=new B,x=new B,M=null,h=w.$watch(function(){return 0===Na.totalPendingRequests},function(a){a&&(h(),w.$$postDigest(function(){w.$$postDigest(function(){null===M&&(M=!0)})}))}),r={},q=a.classNameFilter(),A=q?function(a){return q.test(a)}:function(){return!0},Ca=R(t);return{on:function(a,b,c){b=ia(b);r[a]=r[a]||[];r[a].push({node:b,callback:c})},off:function(a,b,c){function f(a,b,c){var h=ia(b);return a.filter(function(a){return!(a.node===h&&(!c||a.callback===c))})}var h=r[a];h&&
(r[a]=1===arguments.length?null:f(h,b,c))},pin:function(a,b){sa(ma(a),"element","not an element");sa(ma(b),"parentElement","not an element");a.data("$ngAnimatePin",b)},push:function(a,b,c,f){c=c||{};c.domOperation=f;return n(a,b,c)},enabled:function(a,b){var c=arguments.length;if(0===c)b=!!M;else if(ma(a)){var f=D(a),h=x.get(f);1===c?b=!h:(b=!!b)?h&&x.remove(f):x.put(f,!0)}else b=M=!!a;return b}}}]}]).provider("$$animation",["$animateProvider",function(a){function b(a){return a.data("$$animationRunner")}
var c=this.drivers=[];this.$get=["$$jqLite","$rootScope","$injector","$$AnimateRunner","$$HashMap",function(a,e,w,H,u){function F(a){function b(a){if(a.processed)return a;a.processed=!0;var d=a.domNode,f=d.parentNode;e.put(d,a);for(var g;f;){if(g=e.get(f)){g.processed||(g=b(g));break}f=f.parentNode}(g||c).children.push(a);return a}var c={children:[]},d,e=new u;for(d=0;d<a.length;d++){var I=a[d];e.put(I.domNode,a[d]={domNode:I.domNode,fn:I.fn,children:[]})}for(d=0;d<a.length;d++)b(a[d]);return function(a){var b=
[],c=[],d;for(d=0;d<a.children.length;d++)c.push(a.children[d]);a=c.length;var e=0,k=[];for(d=0;d<c.length;d++){var v=c[d];0>=a&&(a=e,e=0,b=b.concat(k),k=[]);k.push(v.fn);l(v.children,function(a){e++;c.push(a)});a--}k.length&&(b=b.concat(k));return b}(c)}var B=[],N=R(a);return function(z,u,t,s){function G(a){a=a.hasAttribute("ng-animate-ref")?[a]:a.querySelectorAll("[ng-animate-ref]");var b=[];l(a,function(a){var c=a.getAttribute("ng-animate-ref");c&&c.length&&b.push(a)});return b}function I(a){var b=
[],c={};l(a,function(a,f){var h=D(a.element),d=0<=["enter","move"].indexOf(a.event),h=a.structural?G(h):[];if(h.length){var e=d?"to":"from";l(h,function(a){var b=a.getAttribute("ng-animate-ref");c[b]=c[b]||{};c[b][e]={animationID:f,element:J(a)}})}else b.push(a)});var f={},d={};l(c,function(c,e){var k=c.from,y=c.to;if(k&&y){var g=a[k.animationID],v=a[y.animationID],q=k.animationID.toString();if(!d[q]){var x=d[q]={beforeStart:function(){g.beforeStart();v.beforeStart()},close:function(){g.close();v.close()},
classes:n(g.classes,v.classes),from:g,to:v,anchors:[]};x.classes.length?b.push(x):(b.push(g),b.push(v))}d[q].anchors.push({out:k.element,"in":y.element})}else k=k?k.animationID:y.animationID,y=k.toString(),f[y]||(f[y]=!0,b.push(a[k]))});return b}function n(a,b){a=a.split(" ");b=b.split(" ");for(var c=[],f=0;f<a.length;f++){var d=a[f];if("ng-"!==d.substring(0,3))for(var k=0;k<b.length;k++)if(d===b[k]){c.push(d);break}}return c.join(" ")}function y(a,b){for(var f=c.length-1;0<=f;f--){var d=c[f];if(w.has(d)&&
(d=w.get(d)(a,b)))return d}}function f(a,c){a.from&&a.to?(b(a.from.element).setHost(c),b(a.to.element).setHost(c)):b(a.element).setHost(c)}function g(){var a=b(z);!a||"leave"===u&&t.$$domOperationFired||a.end()}function ca(b){z.off("$destroy",g);z.removeData("$$animationRunner");N(z,t);da(z,t);t.domOperation();M&&a.removeClass(z,M);z.removeClass("ng-animate");v.complete(!b)}t=ha(t);var k=0<=["enter","move","leave"].indexOf(u),v=new H({end:function(){ca()},cancel:function(){ca(!0)}});if(!c.length)return ca(),
v;z.data("$$animationRunner",v);var x=ta(z.attr("class"),ta(t.addClass,t.removeClass)),M=t.tempClasses;M&&(x+=" "+M,t.tempClasses=null);B.push({element:z,classes:x,event:u,structural:k,options:t,beforeStart:function(){z.addClass("ng-animate");M&&a.addClass(z,M)},close:ca});z.on("$destroy",g);if(1<B.length)return v;e.$$postDigest(function(){var a=[];l(B,function(c){var f=c.element;b(f)&&D(f).parentNode?a.push(c):c.close()});B.length=0;var c=I(a),d=[];l(c,function(a){d.push({domNode:D(a.from?a.from.element:
a.element),fn:function(){a.beforeStart();var c,d=a.close;if(b(a.anchors?a.from.element||a.to.element:a.element)){var h=y(a,s);h&&(c=h.start)}c?(c=c(),c.done(function(a){d(!a)}),f(a,c)):d()}})});l(F(d),function(a){a()})});return v}}]}]).provider("$animateCss",["$animateProvider",function(a){var b=Aa(),c=Aa();this.$get=["$window","$$jqLite","$$AnimateRunner","$timeout","$$forceReflow","$sniffer","$$rAF",function(a,e,w,H,u,F,B){function N(a,b){var c=a.parentNode;return(c.$$ngAnimateParentKey||(c.$$ngAnimateParentKey=
++E))+"-"+a.getAttribute("class")+"-"+b}function z(y,f,g,n){var k;0<b.count(g)&&(k=c.get(g),k||(f=U(f,"-stagger"),e.addClass(y,f),k=ya(a,y,n),k.animationDuration=Math.max(k.animationDuration,0),k.transitionDuration=Math.max(k.transitionDuration,0),e.removeClass(y,f),c.put(g,k)));return k||{}}function s(a){I&&I();n.push(a);I=B(function(){I=null;b.flush();c.flush();for(var a=u(),d=0;d<n.length;d++)n[d](a);n.length=0})}function t(c,f,e){f=b.get(e);f||(f=ya(a,c,La),"infinite"===f.animationIterationCount&&
(f.animationIterationCount=1));b.put(e,f);c=f;e=c.animationDelay;f=c.transitionDelay;c.maxDelay=e&&f?Math.max(e,f):e||f;c.maxDuration=Math.max(c.animationDuration*c.animationIterationCount,c.transitionDuration);return c}var G=R(e),E=0,I,n=[];return function(a,c){function d(){k()}function n(){k(!0)}function k(b){if(!(B||ra&&u)){B=!0;u=!1;c.$$skipPreparationClasses||e.removeClass(a,Z);e.removeClass(a,X);ja(h,!1);$(h,!1);l(r,function(a){h.style[a[0]]=""});G(a,c);da(a,c);if(c.onDone)c.onDone();m&&m.complete(!b)}}
function v(a){p.blockTransition&&$(h,a);p.blockKeyframeAnimation&&ja(h,!!a)}function x(){m=new w({end:d,cancel:n});k();return{$$willAnimate:!1,start:function(){return m},end:d}}function I(){function b(){if(!B){v(!1);l(r,function(a){h.style[a[0]]=a[1]});G(a,c);e.addClass(a,X);if(p.recalculateTimingStyles){ga=h.className+" "+Z;aa=N(h,ga);C=t(h,ga,aa);Q=C.maxDelay;J=Math.max(Q,0);L=C.maxDuration;if(0===L){k();return}p.hasTransitions=0<C.transitionDuration;p.hasAnimations=0<C.animationDuration}if(p.applyTransitionDelay||
p.applyAnimationDelay){Q="boolean"!==typeof c.delay&&ka(c.delay)?parseFloat(c.delay):Q;J=Math.max(Q,0);var g;p.applyTransitionDelay&&(C.transitionDelay=Q,g=[fa,Q+"s"],r.push(g),h.style[g[0]]=g[1]);p.applyAnimationDelay&&(C.animationDelay=Q,g=[pa,Q+"s"],r.push(g),h.style[g[0]]=g[1])}O=1E3*J;R=1E3*L;if(c.easing){var q=c.easing;p.hasTransitions&&(g=K+"TimingFunction",r.push([g,q]),h.style[g]=q);p.hasAnimations&&(g=W+"TimingFunction",r.push([g,q]),h.style[g]=q)}C.transitionDuration&&x.push(na);C.animationDuration&&
x.push(oa);n=Date.now();a.on(x.join(" "),m);H(d,O+1.5*R,!1);va(a,c)}}function d(){k()}function m(a){a.stopPropagation();var b=a.originalEvent||a;a=b.$manualTimeStamp||b.timeStamp||Date.now();b=parseFloat(b.elapsedTime.toFixed(3));Math.max(a-n,0)>=O&&b>=L&&(ra=!0,k())}if(!B)if(h.parentNode){var n,x=[],g=function(a){if(ra)u&&a&&(u=!1,k());else if(u=!a,C.animationDuration)if(a=ja(h,u),u)r.push(a);else{var b=r,c=b.indexOf(a);0<=a&&b.splice(c,1)}},q=0<V&&(C.transitionDuration&&0===T.transitionDuration||
C.animationDuration&&0===T.animationDuration)&&Math.max(T.animationDelay,T.transitionDelay);q?H(b,Math.floor(q*V*1E3),!1):b();E.resume=function(){g(!0)};E.pause=function(){g(!1)}}else k()}var h=D(a);if(!h||!h.parentNode)return x();c=ha(c);var r=[],q=a.attr("class"),A=Da(c),B,u,ra,m,E,J,O,L,R;if(0===c.duration||!F.animations&&!F.transitions)return x();var ba=c.event&&Y(c.event)?c.event.join(" "):c.event,S="",P="";ba&&c.structural?S=U(ba,"ng-",!0):ba&&(S=ba);c.addClass&&(P+=U(c.addClass,"-add"));c.removeClass&&
(P.length&&(P+=" "),P+=U(c.removeClass,"-remove"));c.applyClassesEarly&&P.length&&(G(a,c),P="");var Z=[S,P].join(" ").trim(),ga=q+" "+Z,X=U(Z,"-active"),q=A.to&&0<Object.keys(A.to).length;if(!(0<(c.keyframeStyle||"").length||q||Z))return x();var aa,T;0<c.stagger?(A=parseFloat(c.stagger),T={transitionDelay:A,animationDelay:A,transitionDuration:0,animationDuration:0}):(aa=N(h,ga),T=z(h,Z,aa,Ma));c.$$skipPreparationClasses||e.addClass(a,Z);c.transitionStyle&&(A=[K,c.transitionStyle],ea(h,A),r.push(A));
0<=c.duration&&(A=0<h.style[K].length,A=za(c.duration,A),ea(h,A),r.push(A));c.keyframeStyle&&(A=[W,c.keyframeStyle],ea(h,A),r.push(A));var V=T?0<=c.staggerIndex?c.staggerIndex:b.count(aa):0;(ba=0===V)&&!c.skipBlocking&&$(h,9999);var C=t(h,ga,aa),Q=C.maxDelay;J=Math.max(Q,0);L=C.maxDuration;var p={};p.hasTransitions=0<C.transitionDuration;p.hasAnimations=0<C.animationDuration;p.hasTransitionAll=p.hasTransitions&&"all"==C.transitionProperty;p.applyTransitionDuration=q&&(p.hasTransitions&&!p.hasTransitionAll||
p.hasAnimations&&!p.hasTransitions);p.applyAnimationDuration=c.duration&&p.hasAnimations;p.applyTransitionDelay=ka(c.delay)&&(p.applyTransitionDuration||p.hasTransitions);p.applyAnimationDelay=ka(c.delay)&&p.hasAnimations;p.recalculateTimingStyles=0<P.length;if(p.applyTransitionDuration||p.applyAnimationDuration)L=c.duration?parseFloat(c.duration):L,p.applyTransitionDuration&&(p.hasTransitions=!0,C.transitionDuration=L,A=0<h.style[K+"Property"].length,r.push(za(L,A))),p.applyAnimationDuration&&(p.hasAnimations=
!0,C.animationDuration=L,r.push([qa,L+"s"]));if(0===L&&!p.recalculateTimingStyles)return x();null==c.duration&&0<C.transitionDuration&&(p.recalculateTimingStyles=p.recalculateTimingStyles||ba);O=1E3*J;R=1E3*L;c.skipBlocking||(p.blockTransition=0<C.transitionDuration,p.blockKeyframeAnimation=0<C.animationDuration&&0<T.animationDelay&&0===T.animationDuration);ua(a,c);p.blockTransition||p.blockKeyframeAnimation?v(L):c.skipBlocking||$(h,!1);return{$$willAnimate:!0,end:d,start:function(){if(!B)return E=
{end:d,cancel:n,resume:null,pause:null},m=new w(E),s(I),m}}}}]}]).provider("$$animateCssDriver",["$$animationProvider",function(a){a.drivers.push("$$animateCssDriver");this.$get=["$animateCss","$rootScope","$$AnimateRunner","$rootElement","$$body","$sniffer","$$jqLite",function(a,c,d,e,w,H,u){function F(a){return a.replace(/\bng-\S+\b/g,"")}function B(a,b){O(a)&&(a=a.split(" "));O(b)&&(b=b.split(" "));return a.filter(function(a){return-1===b.indexOf(a)}).join(" ")}function N(c,e,u){function f(a){var b=
{},c=D(a).getBoundingClientRect();l(["width","height","top","left"],function(a){var d=c[a];switch(a){case "top":d+=t.scrollTop;break;case "left":d+=t.scrollLeft}b[a]=Math.floor(d)+"px"});return b}function g(){var c=F(u.attr("class")||""),d=B(c,v),c=B(v,c),d=a(k,{to:f(u),addClass:"ng-anchor-in "+d,removeClass:"ng-anchor-out "+c,delay:!0});return d.$$willAnimate?d:null}function N(){k.remove();e.removeClass("ng-animate-shim");u.removeClass("ng-animate-shim")}var k=J(D(e).cloneNode(!0)),v=F(k.attr("class")||
"");e.addClass("ng-animate-shim");u.addClass("ng-animate-shim");k.addClass("ng-anchor");E.append(k);var x;c=function(){var c=a(k,{addClass:"ng-anchor-out",delay:!0,from:f(e)});return c.$$willAnimate?c:null}();if(!c&&(x=g(),!x))return N();var M=c||x;return{start:function(){function a(){c&&c.end()}var b,c=M.start();c.done(function(){c=null;if(!x&&(x=g()))return c=x.start(),c.done(function(){c=null;N();b.complete()}),c;N();b.complete()});return b=new d({end:a,cancel:a})}}}function z(a,b,c,f){var e=s(a,
G),u=s(b,G),k=[];l(f,function(a){(a=N(c,a.out,a["in"]))&&k.push(a)});if(e||u||0!==k.length)return{start:function(){function a(){l(b,function(a){a.end()})}var b=[];e&&b.push(e.start());u&&b.push(u.start());l(k,function(a){b.push(a.start())});var c=new d({end:a,cancel:a});d.all(b,function(a){c.complete(a)});return c}}}function s(c,d){var e=c.element,f=c.options||{};f.$$skipPreparationClasses=!0;f.skipBlocking=!0;c.structural&&(f.event=c.event,"leave"===c.event&&(f.onDone=f.domOperation));d(e);K(e,f);
f.preparationClasses&&(f.event=V(f.event,f.preparationClasses));e=a(e,f);return e.$$willAnimate?e:null}if(!H.animations&&!H.transitions)return G;var t=D(w);c=D(e);var E=J(t.parentNode===c?t:c),K=R(u);return function(a,b){return a.from&&a.to?z(a.from,a.to,a.classes,a.anchors):s(a,b)}}]}]).provider("$$animateJs",["$animateProvider",function(a){this.$get=["$injector","$$AnimateRunner","$$rAFMutex","$$jqLite",function(b,c,d,e){function w(c){c=Y(c)?c:c.split(" ");for(var d=[],e={},l=0;l<c.length;l++){var w=
c[l],s=a.$$registeredAnimations[w];s&&!e[w]&&(d.push(b.get(s)),e[w]=!0)}return d}var s=R(e);return function(a,b,d,e){function z(){e.domOperation();s(a,e)}function D(a,b,d,e,f){switch(d){case "animate":b=[b,e.from,e.to,f];break;case "setClass":b=[b,J,I,f];break;case "addClass":b=[b,J,f];break;case "removeClass":b=[b,I,f];break;default:b=[b,f]}b.push(e);if(a=a.apply(a,b))if(Ba(a.start)&&(a=a.start()),a instanceof c)a.done(f);else if(Ba(a))return a;return G}function t(a,b,d,e,f){var g=[];l(e,function(e){var l=
e[f];l&&g.push(function(){var e,f,h=!1,g=function(a){h||(h=!0,(f||G)(a),e.complete(!a))};e=new c({end:function(){g()},cancel:function(){g(!0)}});f=D(l,a,b,d,function(a){g(!1===a)});return e})});return g}function E(a,b,d,e,f){var g=t(a,b,d,e,f);if(0===g.length){var q,n;"beforeSetClass"===f?(q=t(a,"removeClass",d,e,"beforeRemoveClass"),n=t(a,"addClass",d,e,"beforeAddClass")):"setClass"===f&&(q=t(a,"removeClass",d,e,"removeClass"),n=t(a,"addClass",d,e,"addClass"));q&&(g=g.concat(q));n&&(g=g.concat(n))}if(0!==
g.length)return function(a){var b=[];g.length&&l(g,function(a){b.push(a())});b.length?c.all(b,a):a();return function(a){l(b,function(b){a?b.cancel():b.end()})}}}3===arguments.length&&la(d)&&(e=d,d=null);e=ha(e);d||(d=a.attr("class")||"",e.addClass&&(d+=" "+e.addClass),e.removeClass&&(d+=" "+e.removeClass));var J=e.addClass,I=e.removeClass,n=w(d),y,f;if(n.length){var g,K;"leave"==b?(K="leave",g="afterLeave"):(K="before"+b.charAt(0).toUpperCase()+b.substr(1),g=b);"enter"!==b&&"move"!==b&&(y=E(a,b,e,
n,K));f=E(a,b,e,n,g)}if(y||f)return{start:function(){function b(c){l=!0;z();da(a,e);h.complete(c)}var d,g=[];y&&g.push(function(a){d=y(a)});g.length?g.push(function(a){z();a(!0)}):z();f&&g.push(function(a){d=f(a)});var l=!1,h=new c({end:function(){l||((d||G)(void 0),b(void 0))},cancel:function(){l||((d||G)(!0),b(!0))}});c.chain(g,b);return h}}}}]}]).provider("$$animateJsDriver",["$$animationProvider",function(a){a.drivers.push("$$animateJsDriver");this.$get=["$$animateJs","$$AnimateRunner",function(a,
c){function d(c){return a(c.element,c.event,c.classes,c.options)}return function(a){if(a.from&&a.to){var b=d(a.from),s=d(a.to);if(b||s)return{start:function(){function a(){return function(){l(d,function(a){a.end()})}}var d=[];b&&d.push(b.start());s&&d.push(s.start());c.all(d,function(a){e.complete(a)});var e=new c({end:a(),cancel:a()});return e}}}else return d(a)}}]}])})(window,window.angular);
//# sourceMappingURL=angular-animate.min.js.map
;

  }).apply(root, arguments);
});
}(this));

(function(root) {
define("ngSanitize", ["angular"], function() {
  return (function() {
/*
 AngularJS v1.4.4
 (c) 2010-2015 Google, Inc. http://angularjs.org
 License: MIT
*/
(function(n,h,p){'use strict';function E(a){var f=[];r(f,h.noop).chars(a);return f.join("")}function g(a,f){var d={},c=a.split(","),b;for(b=0;b<c.length;b++)d[f?h.lowercase(c[b]):c[b]]=!0;return d}function F(a,f){function d(a,b,d,l){b=h.lowercase(b);if(s[b])for(;e.last()&&t[e.last()];)c("",e.last());u[b]&&e.last()==b&&c("",b);(l=v[b]||!!l)||e.push(b);var m={};d.replace(G,function(b,a,f,c,d){m[a]=q(f||c||d||"")});f.start&&f.start(b,m,l)}function c(b,a){var c=0,d;if(a=h.lowercase(a))for(c=e.length-
1;0<=c&&e[c]!=a;c--);if(0<=c){for(d=e.length-1;d>=c;d--)f.end&&f.end(e[d]);e.length=c}}"string"!==typeof a&&(a=null===a||"undefined"===typeof a?"":""+a);var b,k,e=[],m=a,l;for(e.last=function(){return e[e.length-1]};a;){l="";k=!0;if(e.last()&&w[e.last()])a=a.replace(new RegExp("([\\W\\w]*)<\\s*\\/\\s*"+e.last()+"[^>]*>","i"),function(a,b){b=b.replace(H,"$1").replace(I,"$1");f.chars&&f.chars(q(b));return""}),c("",e.last());else{if(0===a.indexOf("\x3c!--"))b=a.indexOf("--",4),0<=b&&a.lastIndexOf("--\x3e",
b)===b&&(f.comment&&f.comment(a.substring(4,b)),a=a.substring(b+3),k=!1);else if(x.test(a)){if(b=a.match(x))a=a.replace(b[0],""),k=!1}else if(J.test(a)){if(b=a.match(y))a=a.substring(b[0].length),b[0].replace(y,c),k=!1}else K.test(a)&&((b=a.match(z))?(b[4]&&(a=a.substring(b[0].length),b[0].replace(z,d)),k=!1):(l+="<",a=a.substring(1)));k&&(b=a.indexOf("<"),l+=0>b?a:a.substring(0,b),a=0>b?"":a.substring(b),f.chars&&f.chars(q(l)))}if(a==m)throw L("badparse",a);m=a}c()}function q(a){if(!a)return"";A.innerHTML=
a.replace(/</g,"&lt;");return A.textContent}function B(a){return a.replace(/&/g,"&amp;").replace(M,function(a){var d=a.charCodeAt(0);a=a.charCodeAt(1);return"&#"+(1024*(d-55296)+(a-56320)+65536)+";"}).replace(N,function(a){return"&#"+a.charCodeAt(0)+";"}).replace(/</g,"&lt;").replace(/>/g,"&gt;")}function r(a,f){var d=!1,c=h.bind(a,a.push);return{start:function(a,k,e){a=h.lowercase(a);!d&&w[a]&&(d=a);d||!0!==C[a]||(c("<"),c(a),h.forEach(k,function(d,e){var k=h.lowercase(e),g="img"===a&&"src"===k||
"background"===k;!0!==O[k]||!0===D[k]&&!f(d,g)||(c(" "),c(e),c('="'),c(B(d)),c('"'))}),c(e?"/>":">"))},end:function(a){a=h.lowercase(a);d||!0!==C[a]||(c("</"),c(a),c(">"));a==d&&(d=!1)},chars:function(a){d||c(B(a))}}}var L=h.$$minErr("$sanitize"),z=/^<((?:[a-zA-Z])[\w:-]*)((?:\s+[\w:-]+(?:\s*=\s*(?:(?:"[^"]*")|(?:'[^']*')|[^>\s]+))?)*)\s*(\/?)\s*(>?)/,y=/^<\/\s*([\w:-]+)[^>]*>/,G=/([\w:-]+)(?:\s*=\s*(?:(?:"((?:[^"])*)")|(?:'((?:[^'])*)')|([^>\s]+)))?/g,K=/^</,J=/^<\//,H=/\x3c!--(.*?)--\x3e/g,x=/<!DOCTYPE([^>]*?)>/i,
I=/<!\[CDATA\[(.*?)]]\x3e/g,M=/[\uD800-\uDBFF][\uDC00-\uDFFF]/g,N=/([^\#-~| |!])/g,v=g("area,br,col,hr,img,wbr");n=g("colgroup,dd,dt,li,p,tbody,td,tfoot,th,thead,tr");p=g("rp,rt");var u=h.extend({},p,n),s=h.extend({},n,g("address,article,aside,blockquote,caption,center,del,dir,div,dl,figure,figcaption,footer,h1,h2,h3,h4,h5,h6,header,hgroup,hr,ins,map,menu,nav,ol,pre,script,section,table,ul")),t=h.extend({},p,g("a,abbr,acronym,b,bdi,bdo,big,br,cite,code,del,dfn,em,font,i,img,ins,kbd,label,map,mark,q,ruby,rp,rt,s,samp,small,span,strike,strong,sub,sup,time,tt,u,var"));
n=g("circle,defs,desc,ellipse,font-face,font-face-name,font-face-src,g,glyph,hkern,image,linearGradient,line,marker,metadata,missing-glyph,mpath,path,polygon,polyline,radialGradient,rect,stop,svg,switch,text,title,tspan,use");var w=g("script,style"),C=h.extend({},v,s,t,u,n),D=g("background,cite,href,longdesc,src,usemap,xlink:href");n=g("abbr,align,alt,axis,bgcolor,border,cellpadding,cellspacing,class,clear,color,cols,colspan,compact,coords,dir,face,headers,height,hreflang,hspace,ismap,lang,language,nohref,nowrap,rel,rev,rows,rowspan,rules,scope,scrolling,shape,size,span,start,summary,tabindex,target,title,type,valign,value,vspace,width");
p=g("accent-height,accumulate,additive,alphabetic,arabic-form,ascent,baseProfile,bbox,begin,by,calcMode,cap-height,class,color,color-rendering,content,cx,cy,d,dx,dy,descent,display,dur,end,fill,fill-rule,font-family,font-size,font-stretch,font-style,font-variant,font-weight,from,fx,fy,g1,g2,glyph-name,gradientUnits,hanging,height,horiz-adv-x,horiz-origin-x,ideographic,k,keyPoints,keySplines,keyTimes,lang,marker-end,marker-mid,marker-start,markerHeight,markerUnits,markerWidth,mathematical,max,min,offset,opacity,orient,origin,overline-position,overline-thickness,panose-1,path,pathLength,points,preserveAspectRatio,r,refX,refY,repeatCount,repeatDur,requiredExtensions,requiredFeatures,restart,rotate,rx,ry,slope,stemh,stemv,stop-color,stop-opacity,strikethrough-position,strikethrough-thickness,stroke,stroke-dasharray,stroke-dashoffset,stroke-linecap,stroke-linejoin,stroke-miterlimit,stroke-opacity,stroke-width,systemLanguage,target,text-anchor,to,transform,type,u1,u2,underline-position,underline-thickness,unicode,unicode-range,units-per-em,values,version,viewBox,visibility,width,widths,x,x-height,x1,x2,xlink:actuate,xlink:arcrole,xlink:role,xlink:show,xlink:title,xlink:type,xml:base,xml:lang,xml:space,xmlns,xmlns:xlink,y,y1,y2,zoomAndPan",
!0);var O=h.extend({},D,p,n),A=document.createElement("pre");h.module("ngSanitize",[]).provider("$sanitize",function(){this.$get=["$$sanitizeUri",function(a){return function(f){var d=[];F(f,r(d,function(c,b){return!/^unsafe/.test(a(c,b))}));return d.join("")}}]});h.module("ngSanitize").filter("linky",["$sanitize",function(a){var f=/((ftp|https?):\/\/|(www\.)|(mailto:)?[A-Za-z0-9._%+-]+@)\S*[^\s.;,(){}<>"\u201d\u2019]/i,d=/^mailto:/i;return function(c,b){function k(a){a&&g.push(E(a))}function e(a,
c){g.push("<a ");h.isDefined(b)&&g.push('target="',b,'" ');g.push('href="',a.replace(/"/g,"&quot;"),'">');k(c);g.push("</a>")}if(!c)return c;for(var m,l=c,g=[],n,p;m=l.match(f);)n=m[0],m[2]||m[4]||(n=(m[3]?"http://":"mailto:")+n),p=m.index,k(l.substr(0,p)),e(n,m[0].replace(d,"")),l=l.substring(p+m[0].length);k(l);return a(g.join(""))}}])})(window,window.angular);
//# sourceMappingURL=angular-sanitize.min.js.map
;

  }).apply(root, arguments);
});
}(this));

(function(root) {
define("ngAria", ["angular"], function() {
  return (function() {
/*
 AngularJS v1.4.4
 (c) 2010-2015 Google, Inc. http://angularjs.org
 License: MIT
*/
(function(s,n,t){'use strict';n.module("ngAria",["ng"]).provider("$aria",function(){function a(a,f,l){return function(m,d,e){var b=e.$normalize(f);c[b]&&!e[b]&&m.$watch(e[a],function(b){b=l?!b:!!b;d.attr(f,b)})}}var c={ariaHidden:!0,ariaChecked:!0,ariaDisabled:!0,ariaRequired:!0,ariaInvalid:!0,ariaMultiline:!0,ariaValue:!0,tabindex:!0,bindKeypress:!0,bindRoleForClick:!0};this.config=function(a){c=n.extend(c,a)};this.$get=function(){return{config:function(a){return c[a]},$$watchExpr:a}}}).directive("ngShow",
["$aria",function(a){return a.$$watchExpr("ngShow","aria-hidden",!0)}]).directive("ngHide",["$aria",function(a){return a.$$watchExpr("ngHide","aria-hidden",!1)}]).directive("ngModel",["$aria",function(a){function c(c,m,d){return a.config(m)&&!d.attr(c)}function k(a,c){return!c.attr("role")&&c.attr("type")===a&&"INPUT"!==c[0].nodeName}function f(a,c){var d=a.type,e=a.role;return"checkbox"===(d||e)||"menuitemcheckbox"===e?"checkbox":"radio"===(d||e)||"menuitemradio"===e?"radio":"range"===d||"progressbar"===
e||"slider"===e?"range":"textbox"===(d||e)||"TEXTAREA"===c[0].nodeName?"multiline":""}return{restrict:"A",require:"?ngModel",priority:200,compile:function(l,m){var d=f(m,l);return{pre:function(a,b,c,g){"checkbox"===d&&"checkbox"!==c.type&&(g.$isEmpty=function(b){return!1===b})},post:function(e,b,h,g){function f(){return g.$modelValue}function m(){return p?(p=!1,function(a){a=h.value==g.$viewValue;b.attr("aria-checked",a);b.attr("tabindex",0-!a)}):function(a){b.attr("aria-checked",h.value==g.$viewValue)}}
function l(){b.attr("aria-checked",!g.$isEmpty(g.$viewValue))}var p=c("tabindex","tabindex",b);switch(d){case "radio":case "checkbox":k(d,b)&&b.attr("role",d);c("aria-checked","ariaChecked",b)&&e.$watch(f,"radio"===d?m():l);break;case "range":k(d,b)&&b.attr("role","slider");if(a.config("ariaValue")){var n=!b.attr("aria-valuemin")&&(h.hasOwnProperty("min")||h.hasOwnProperty("ngMin")),q=!b.attr("aria-valuemax")&&(h.hasOwnProperty("max")||h.hasOwnProperty("ngMax")),r=!b.attr("aria-valuenow");n&&h.$observe("min",
function(a){b.attr("aria-valuemin",a)});q&&h.$observe("max",function(a){b.attr("aria-valuemax",a)});r&&e.$watch(f,function(a){b.attr("aria-valuenow",a)})}break;case "multiline":c("aria-multiline","ariaMultiline",b)&&b.attr("aria-multiline",!0)}p&&b.attr("tabindex",0);g.$validators.required&&c("aria-required","ariaRequired",b)&&e.$watch(function(){return g.$error.required},function(a){b.attr("aria-required",!!a)});c("aria-invalid","ariaInvalid",b)&&e.$watch(function(){return g.$invalid},function(a){b.attr("aria-invalid",
!!a)})}}}}}]).directive("ngDisabled",["$aria",function(a){return a.$$watchExpr("ngDisabled","aria-disabled")}]).directive("ngMessages",function(){return{restrict:"A",require:"?ngMessages",link:function(a,c,k,f){c.attr("aria-live")||c.attr("aria-live","assertive")}}}).directive("ngClick",["$aria","$parse",function(a,c){return{restrict:"A",compile:function(k,f){var l=c(f.ngClick,null,!0);return function(c,d,e){function b(a,b){if(-1!==b.indexOf(a[0].nodeName))return!0}var f=["BUTTON","A","INPUT","TEXTAREA"];
!a.config("bindRoleForClick")||d.attr("role")||b(d,f)||d.attr("role","button");a.config("tabindex")&&!d.attr("tabindex")&&d.attr("tabindex",0);if(a.config("bindKeypress")&&!e.ngKeypress&&!b(d,f))d.on("keypress",function(a){function b(){l(c,{$event:a})}var d=a.which||a.keyCode;32!==d&&13!==d||c.$apply(b)})}}}}]).directive("ngDblclick",["$aria",function(a){return function(c,k,f){a.config("tabindex")&&!k.attr("tabindex")&&k.attr("tabindex",0)}}])})(window,window.angular);
//# sourceMappingURL=angular-aria.min.js.map
;

  }).apply(root, arguments);
});
}(this));

(function(root) {
define("uiBootstrap", ["angular"], function() {
  return (function() {
/*
 * angular-ui-bootstrap
 * http://angular-ui.github.io/bootstrap/

 * Version: 1.2.5 - 2016-03-20
 * Version: 1.2.5 (patch 1) - 2022-03-02 Regerenated from the commit 6955cf0079de4ae712d73e2c0067614dfbfacbc9
 *   plus our patch of the improved code from HEAD. (uibTab cancel tab change only)
 * License: MIT
*/angular.module("ui.bootstrap",["ui.bootstrap.tpls","ui.bootstrap.collapse","ui.bootstrap.accordion","ui.bootstrap.alert","ui.bootstrap.buttons","ui.bootstrap.carousel","ui.bootstrap.dateparser","ui.bootstrap.isClass","ui.bootstrap.position","ui.bootstrap.datepicker","ui.bootstrap.debounce","ui.bootstrap.dropdown","ui.bootstrap.stackedMap","ui.bootstrap.modal","ui.bootstrap.paging","ui.bootstrap.pager","ui.bootstrap.pagination","ui.bootstrap.tooltip","ui.bootstrap.popover","ui.bootstrap.progressbar","ui.bootstrap.rating","ui.bootstrap.tabs","ui.bootstrap.timepicker","ui.bootstrap.typeahead"]),angular.module("ui.bootstrap.tpls",["uib/template/accordion/accordion-group.html","uib/template/accordion/accordion.html","uib/template/alert/alert.html","uib/template/carousel/carousel.html","uib/template/carousel/slide.html","uib/template/datepicker/datepicker.html","uib/template/datepicker/day.html","uib/template/datepicker/month.html","uib/template/datepicker/popup.html","uib/template/datepicker/year.html","uib/template/modal/backdrop.html","uib/template/modal/window.html","uib/template/pager/pager.html","uib/template/pagination/pagination.html","uib/template/tooltip/tooltip-html-popup.html","uib/template/tooltip/tooltip-popup.html","uib/template/tooltip/tooltip-template-popup.html","uib/template/popover/popover-html.html","uib/template/popover/popover-template.html","uib/template/popover/popover.html","uib/template/progressbar/bar.html","uib/template/progressbar/progress.html","uib/template/progressbar/progressbar.html","uib/template/rating/rating.html","uib/template/tabs/tab.html","uib/template/tabs/tabset.html","uib/template/timepicker/timepicker.html","uib/template/typeahead/typeahead-match.html","uib/template/typeahead/typeahead-popup.html"]),angular.module("ui.bootstrap.collapse",[]).directive("uibCollapse",["$animate","$q","$parse","$injector",function(a,b,c,d){var e=d.has("$animateCss")?d.get("$animateCss"):null;return{link:function(d,f,g){function h(){f.hasClass("collapse")&&f.hasClass("in")||b.resolve(l(d)).then(function(){f.removeClass("collapse").addClass("collapsing").attr("aria-expanded",!0).attr("aria-hidden",!1),e?e(f,{addClass:"in",easing:"ease",to:{height:f[0].scrollHeight+"px"}}).start()["finally"](i):a.addClass(f,"in",{to:{height:f[0].scrollHeight+"px"}}).then(i)})}function i(){f.removeClass("collapsing").addClass("collapse").css({height:"auto"}),m(d)}function j(){return f.hasClass("collapse")||f.hasClass("in")?void b.resolve(n(d)).then(function(){f.css({height:f[0].scrollHeight+"px"}).removeClass("collapse").addClass("collapsing").attr("aria-expanded",!1).attr("aria-hidden",!0),e?e(f,{removeClass:"in",to:{height:"0"}}).start()["finally"](k):a.removeClass(f,"in",{to:{height:"0"}}).then(k)}):k()}function k(){f.css({height:"0"}),f.removeClass("collapsing").addClass("collapse"),o(d)}var l=c(g.expanding),m=c(g.expanded),n=c(g.collapsing),o=c(g.collapsed);d.$eval(g.uibCollapse)||f.addClass("in").addClass("collapse").attr("aria-expanded",!0).attr("aria-hidden",!1).css({height:"auto"}),d.$watch(g.uibCollapse,function(a){a?j():h()})}}}]),angular.module("ui.bootstrap.accordion",["ui.bootstrap.collapse"]).constant("uibAccordionConfig",{closeOthers:!0}).controller("UibAccordionController",["$scope","$attrs","uibAccordionConfig",function(a,b,c){this.groups=[],this.closeOthers=function(d){var e=angular.isDefined(b.closeOthers)?a.$eval(b.closeOthers):c.closeOthers;e&&angular.forEach(this.groups,function(a){a!==d&&(a.isOpen=!1)})},this.addGroup=function(a){var b=this;this.groups.push(a),a.$on("$destroy",function(c){b.removeGroup(a)})},this.removeGroup=function(a){var b=this.groups.indexOf(a);b!==-1&&this.groups.splice(b,1)}}]).directive("uibAccordion",function(){return{controller:"UibAccordionController",controllerAs:"accordion",transclude:!0,templateUrl:function(a,b){return b.templateUrl||"uib/template/accordion/accordion.html"}}}).directive("uibAccordionGroup",function(){return{require:"^uibAccordion",transclude:!0,replace:!0,templateUrl:function(a,b){return b.templateUrl||"uib/template/accordion/accordion-group.html"},scope:{heading:"@",panelClass:"@?",isOpen:"=?",isDisabled:"=?"},controller:function(){this.setHeading=function(a){this.heading=a}},link:function(a,b,c,d){d.addGroup(a),a.openClass=c.openClass||"panel-open",a.panelClass=c.panelClass||"panel-default",a.$watch("isOpen",function(c){b.toggleClass(a.openClass,!!c),c&&d.closeOthers(a)}),a.toggleOpen=function(b){a.isDisabled||b&&32!==b.which||(a.isOpen=!a.isOpen)};var e="accordiongroup-"+a.$id+"-"+Math.floor(1e4*Math.random());a.headingId=e+"-tab",a.panelId=e+"-panel"}}}).directive("uibAccordionHeading",function(){return{transclude:!0,template:"",replace:!0,require:"^uibAccordionGroup",link:function(a,b,c,d,e){d.setHeading(e(a,angular.noop))}}}).directive("uibAccordionTransclude",function(){return{require:"^uibAccordionGroup",link:function(a,b,c,d){a.$watch(function(){return d[c.uibAccordionTransclude]},function(a){if(a){var c=angular.element(b[0].querySelector("[uib-accordion-header]"));c.html(""),c.append(a)}})}}}),angular.module("ui.bootstrap.alert",[]).controller("UibAlertController",["$scope","$attrs","$interpolate","$timeout",function(a,b,c,d){a.closeable=!!b.close;var e=angular.isDefined(b.dismissOnTimeout)?c(b.dismissOnTimeout)(a.$parent):null;e&&d(function(){a.close()},parseInt(e,10))}]).directive("uibAlert",function(){return{controller:"UibAlertController",controllerAs:"alert",templateUrl:function(a,b){return b.templateUrl||"uib/template/alert/alert.html"},transclude:!0,replace:!0,scope:{type:"@",close:"&"}}}),angular.module("ui.bootstrap.buttons",[]).constant("uibButtonConfig",{activeClass:"active",toggleEvent:"click"}).controller("UibButtonsController",["uibButtonConfig",function(a){this.activeClass=a.activeClass||"active",this.toggleEvent=a.toggleEvent||"click"}]).directive("uibBtnRadio",["$parse",function(a){return{require:["uibBtnRadio","ngModel"],controller:"UibButtonsController",controllerAs:"buttons",link:function(b,c,d,e){var f=e[0],g=e[1],h=a(d.uibUncheckable);c.find("input").css({display:"none"}),g.$render=function(){c.toggleClass(f.activeClass,angular.equals(g.$modelValue,b.$eval(d.uibBtnRadio)))},c.on(f.toggleEvent,function(){if(!d.disabled){var a=c.hasClass(f.activeClass);a&&!angular.isDefined(d.uncheckable)||b.$apply(function(){g.$setViewValue(a?null:b.$eval(d.uibBtnRadio)),g.$render()})}}),d.uibUncheckable&&b.$watch(h,function(a){d.$set("uncheckable",a?"":void 0)})}}}]).directive("uibBtnCheckbox",function(){return{require:["uibBtnCheckbox","ngModel"],controller:"UibButtonsController",controllerAs:"button",link:function(a,b,c,d){function e(){return g(c.btnCheckboxTrue,!0)}function f(){return g(c.btnCheckboxFalse,!1)}function g(b,c){return angular.isDefined(b)?a.$eval(b):c}var h=d[0],i=d[1];b.find("input").css({display:"none"}),i.$render=function(){b.toggleClass(h.activeClass,angular.equals(i.$modelValue,e()))},b.on(h.toggleEvent,function(){c.disabled||a.$apply(function(){i.$setViewValue(b.hasClass(h.activeClass)?f():e()),i.$render()})})}}}),angular.module("ui.bootstrap.carousel",[]).controller("UibCarouselController",["$scope","$element","$interval","$timeout","$animate",function(a,b,c,d,e){function f(){for(;t.length;)t.shift()}function g(a){for(var b=0;b<q.length;b++)q[b].slide.active=b===a}function h(c,d,i){if(!u){if(angular.extend(c,{direction:i}),angular.extend(q[s].slide||{},{direction:i}),e.enabled(b)&&!a.$currentTransition&&q[d].element&&p.slides.length>1){q[d].element.data(r,c.direction);var j=p.getCurrentIndex();angular.isNumber(j)&&q[j].element&&q[j].element.data(r,c.direction),a.$currentTransition=!0,e.on("addClass",q[d].element,function(b,c){if("close"===c&&(a.$currentTransition=null,e.off("addClass",b),t.length)){var d=t.pop().slide,g=d.index,i=g>p.getCurrentIndex()?"next":"prev";f(),h(d,g,i)}})}a.active=c.index,s=c.index,g(d),l()}}function i(a){for(var b=0;b<q.length;b++)if(q[b].slide===a)return b}function j(){n&&(c.cancel(n),n=null)}function k(b){b.length||(a.$currentTransition=null,f())}function l(){j();var b=+a.interval;!isNaN(b)&&b>0&&(n=c(m,b))}function m(){var b=+a.interval;o&&!isNaN(b)&&b>0&&q.length?a.next():a.pause()}var n,o,p=this,q=p.slides=a.slides=[],r="uib-slideDirection",s=a.active,t=[],u=!1;p.addSlide=function(b,c){q.push({slide:b,element:c}),q.sort(function(a,b){return+a.slide.index>+b.slide.index}),(b.index===a.active||1===q.length&&!angular.isNumber(a.active))&&(a.$currentTransition&&(a.$currentTransition=null),s=b.index,a.active=b.index,g(s),p.select(q[i(b)]),1===q.length&&a.play())},p.getCurrentIndex=function(){for(var a=0;a<q.length;a++)if(q[a].slide.index===s)return a},p.next=a.next=function(){var b=(p.getCurrentIndex()+1)%q.length;return 0===b&&a.noWrap()?void a.pause():p.select(q[b],"next")},p.prev=a.prev=function(){var b=p.getCurrentIndex()-1<0?q.length-1:p.getCurrentIndex()-1;return a.noWrap()&&b===q.length-1?void a.pause():p.select(q[b],"prev")},p.removeSlide=function(b){var c=i(b),d=t.indexOf(q[c]);d!==-1&&t.splice(d,1),q.splice(c,1),q.length>0&&s===c?c>=q.length?(s=q.length-1,a.active=s,g(s),p.select(q[q.length-1])):(s=c,a.active=s,g(s),p.select(q[c])):s>c&&(s--,a.active=s),0===q.length&&(s=null,a.active=null,f())},p.select=a.select=function(b,c){var d=i(b.slide);void 0===c&&(c=d>p.getCurrentIndex()?"next":"prev"),b.slide.index===s||a.$currentTransition?b&&b.slide.index!==s&&a.$currentTransition&&t.push(q[d]):h(b.slide,d,c)},a.indexOfSlide=function(a){return+a.slide.index},a.isActive=function(b){return a.active===b.slide.index},a.pause=function(){a.noPause||(o=!1,j())},a.play=function(){o||(o=!0,l())},a.$on("$destroy",function(){u=!0,j()}),a.$watch("noTransition",function(a){e.enabled(b,!a)}),a.$watch("interval",l),a.$watchCollection("slides",k),a.$watch("active",function(a){if(angular.isNumber(a)&&s!==a){for(var b=0;b<q.length;b++)if(q[b].slide.index===a){a=b;break}var c=q[a];c&&(s=a,g(a),p.select(q[a]))}})}]).directive("uibCarousel",function(){return{transclude:!0,replace:!0,controller:"UibCarouselController",controllerAs:"carousel",templateUrl:function(a,b){return b.templateUrl||"uib/template/carousel/carousel.html"},scope:{active:"=",interval:"=",noTransition:"=",noPause:"=",noWrap:"&"}}}).directive("uibSlide",function(){return{require:"^uibCarousel",transclude:!0,replace:!0,templateUrl:function(a,b){return b.templateUrl||"uib/template/carousel/slide.html"},scope:{actual:"=?",index:"=?"},link:function(a,b,c,d){d.addSlide(a,b),a.$on("$destroy",function(){d.removeSlide(a)})}}}).animation(".item",["$animateCss",function(a){function b(a,b,c){a.removeClass(b),c&&c()}var c="uib-slideDirection";return{beforeAddClass:function(d,e,f){if("active"===e){var g=!1,h=d.data(c),i="next"===h?"left":"right",j=b.bind(this,d,i+" "+h,f);return d.addClass(h),a(d,{addClass:i}).start().done(j),function(){g=!0}}f()},beforeRemoveClass:function(d,e,f){if("active"===e){var g=!1,h=d.data(c),i="next"===h?"left":"right",j=b.bind(this,d,i,f);return a(d,{addClass:i}).start().done(j),function(){g=!0}}f()}}}]),angular.module("ui.bootstrap.dateparser",[]).service("uibDateParser",["$log","$locale","dateFilter","orderByFilter",function(a,b,c,d){function e(a,b){var c=[],e=a.split(""),f=a.indexOf("'");if(f>-1){var g=!1;a=a.split("");for(var h=f;h<a.length;h++)g?("'"===a[h]&&(h+1<a.length&&"'"===a[h+1]?(a[h+1]="$",e[h+1]=""):(e[h]="",g=!1)),a[h]="$"):"'"===a[h]&&(a[h]="$",e[h]="",g=!0);a=a.join("")}return angular.forEach(n,function(d){var f=a.indexOf(d.key);if(f>-1){a=a.split(""),e[f]="("+d.regex+")",a[f]="$";for(var g=f+1,h=f+d.key.length;g<h;g++)e[g]="",a[g]="$";a=a.join(""),c.push({index:f,key:d.key,apply:d[b],matcher:d.regex})}}),{regex:new RegExp("^"+e.join("")+"$"),map:d(c,"index")}}function f(a,b,c){return!(c<1)&&(1===b&&c>28?29===c&&(a%4===0&&a%100!==0||a%400===0):3!==b&&5!==b&&8!==b&&10!==b||c<31)}function g(a){return parseInt(a,10)}function h(a,b){return a&&b?l(a,b):a}function i(a,b){return a&&b?l(a,b,!0):a}function j(a,b){var c=Date.parse("Jan 01, 1970 00:00:00 "+a)/6e4;return isNaN(c)?b:c}function k(a,b){return a=new Date(a.getTime()),a.setMinutes(a.getMinutes()+b),a}function l(a,b,c){c=c?-1:1;var d=j(b,a.getTimezoneOffset());return k(a,c*(d-a.getTimezoneOffset()))}var m,n,o=/[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;this.init=function(){m=b.id,this.parsers={},this.formatters={},n=[{key:"yyyy",regex:"\\d{4}",apply:function(a){this.year=+a},formatter:function(a){var b=new Date;return b.setFullYear(Math.abs(a.getFullYear())),c(b,"yyyy")}},{key:"yy",regex:"\\d{2}",apply:function(a){this.year=+a+2e3},formatter:function(a){var b=new Date;return b.setFullYear(Math.abs(a.getFullYear())),c(b,"yy")}},{key:"y",regex:"\\d{1,4}",apply:function(a){this.year=+a},formatter:function(a){var b=new Date;return b.setFullYear(Math.abs(a.getFullYear())),c(b,"y")}},{key:"M!",regex:"0?[1-9]|1[0-2]",apply:function(a){this.month=a-1},formatter:function(a){var b=a.getMonth();return/^[0-9]$/.test(b)?c(a,"MM"):c(a,"M")}},{key:"MMMM",regex:b.DATETIME_FORMATS.MONTH.join("|"),apply:function(a){this.month=b.DATETIME_FORMATS.MONTH.indexOf(a)},formatter:function(a){return c(a,"MMMM")}},{key:"MMM",regex:b.DATETIME_FORMATS.SHORTMONTH.join("|"),apply:function(a){this.month=b.DATETIME_FORMATS.SHORTMONTH.indexOf(a)},formatter:function(a){return c(a,"MMM")}},{key:"MM",regex:"0[1-9]|1[0-2]",apply:function(a){this.month=a-1},formatter:function(a){return c(a,"MM")}},{key:"M",regex:"[1-9]|1[0-2]",apply:function(a){this.month=a-1},formatter:function(a){return c(a,"M")}},{key:"d!",regex:"[0-2]?[0-9]{1}|3[0-1]{1}",apply:function(a){this.date=+a},formatter:function(a){var b=a.getDate();return/^[1-9]$/.test(b)?c(a,"dd"):c(a,"d")}},{key:"dd",regex:"[0-2][0-9]{1}|3[0-1]{1}",apply:function(a){this.date=+a},formatter:function(a){return c(a,"dd")}},{key:"d",regex:"[1-2]?[0-9]{1}|3[0-1]{1}",apply:function(a){this.date=+a},formatter:function(a){return c(a,"d")}},{key:"EEEE",regex:b.DATETIME_FORMATS.DAY.join("|"),formatter:function(a){return c(a,"EEEE")}},{key:"EEE",regex:b.DATETIME_FORMATS.SHORTDAY.join("|"),formatter:function(a){return c(a,"EEE")}},{key:"HH",regex:"(?:0|1)[0-9]|2[0-3]",apply:function(a){this.hours=+a},formatter:function(a){return c(a,"HH")}},{key:"hh",regex:"0[0-9]|1[0-2]",apply:function(a){this.hours=+a},formatter:function(a){return c(a,"hh")}},{key:"H",regex:"1?[0-9]|2[0-3]",apply:function(a){this.hours=+a},formatter:function(a){return c(a,"H")}},{key:"h",regex:"[0-9]|1[0-2]",apply:function(a){this.hours=+a},formatter:function(a){return c(a,"h")}},{key:"mm",regex:"[0-5][0-9]",apply:function(a){this.minutes=+a},formatter:function(a){return c(a,"mm")}},{key:"m",regex:"[0-9]|[1-5][0-9]",apply:function(a){this.minutes=+a},formatter:function(a){return c(a,"m")}},{key:"sss",regex:"[0-9][0-9][0-9]",apply:function(a){this.milliseconds=+a},formatter:function(a){return c(a,"sss")}},{key:"ss",regex:"[0-5][0-9]",apply:function(a){this.seconds=+a},formatter:function(a){return c(a,"ss")}},{key:"s",regex:"[0-9]|[1-5][0-9]",apply:function(a){this.seconds=+a},formatter:function(a){return c(a,"s")}},{key:"a",regex:b.DATETIME_FORMATS.AMPMS.join("|"),apply:function(a){12===this.hours&&(this.hours=0),"PM"===a&&(this.hours+=12)},formatter:function(a){return c(a,"a")}},{key:"Z",regex:"[+-]\\d{4}",apply:function(a){var b=a.match(/([+-])(\d{2})(\d{2})/),c=b[1],d=b[2],e=b[3];this.hours+=g(c+d),this.minutes+=g(c+e)},formatter:function(a){return c(a,"Z")}},{key:"ww",regex:"[0-4][0-9]|5[0-3]",formatter:function(a){return c(a,"ww")}},{key:"w",regex:"[0-9]|[1-4][0-9]|5[0-3]",formatter:function(a){return c(a,"w")}},{key:"GGGG",regex:b.DATETIME_FORMATS.ERANAMES.join("|").replace(/\s/g,"\\s"),formatter:function(a){return c(a,"GGGG")}},{key:"GGG",regex:b.DATETIME_FORMATS.ERAS.join("|"),formatter:function(a){return c(a,"GGG")}},{key:"GG",regex:b.DATETIME_FORMATS.ERAS.join("|"),formatter:function(a){return c(a,"GG")}},{key:"G",regex:b.DATETIME_FORMATS.ERAS.join("|"),formatter:function(a){return c(a,"G")}}]},this.init(),this.filter=function(a,c){if(!angular.isDate(a)||isNaN(a)||!c)return"";c=b.DATETIME_FORMATS[c]||c,b.id!==m&&this.init(),this.formatters[c]||(this.formatters[c]=e(c,"formatter"));var d=this.formatters[c],f=d.map,g=c;return f.reduce(function(b,c,d){var e=g.match(new RegExp("(.*)"+c.key));e&&angular.isString(e[1])&&(b+=e[1],g=g.replace(e[1]+c.key,""));var h=d===f.length-1?g:"";return c.apply?b+c.apply.call(null,a)+h:b+h},"")},this.parse=function(c,d,g){if(!angular.isString(c)||!d)return c;d=b.DATETIME_FORMATS[d]||d,d=d.replace(o,"\\$&"),b.id!==m&&this.init(),this.parsers[d]||(this.parsers[d]=e(d,"apply"));var h=this.parsers[d],i=h.regex,j=h.map,k=c.match(i),l=!1;if(k&&k.length){var n,p;angular.isDate(g)&&!isNaN(g.getTime())?n={year:g.getFullYear(),month:g.getMonth(),date:g.getDate(),hours:g.getHours(),minutes:g.getMinutes(),seconds:g.getSeconds(),milliseconds:g.getMilliseconds()}:(g&&a.warn("dateparser:","baseDate is not a valid date"),n={year:1900,month:0,date:1,hours:0,minutes:0,seconds:0,milliseconds:0});for(var q=1,r=k.length;q<r;q++){var s=j[q-1];"Z"===s.matcher&&(l=!0),s.apply&&s.apply.call(n,k[q])}var t=l?Date.prototype.setUTCFullYear:Date.prototype.setFullYear,u=l?Date.prototype.setUTCHours:Date.prototype.setHours;return f(n.year,n.month,n.date)&&(!angular.isDate(g)||isNaN(g.getTime())||l?(p=new Date(0),t.call(p,n.year,n.month,n.date),u.call(p,n.hours||0,n.minutes||0,n.seconds||0,n.milliseconds||0)):(p=new Date(g),t.call(p,n.year,n.month,n.date),u.call(p,n.hours,n.minutes,n.seconds,n.milliseconds))),p}},this.toTimezone=h,this.fromTimezone=i,this.timezoneToOffset=j,this.addDateMinutes=k,this.convertTimezoneToLocal=l}]),angular.module("ui.bootstrap.isClass",[]).directive("uibIsClass",["$animate",function(a){var b=/^\s*([\s\S]+?)\s+on\s+([\s\S]+?)\s*$/,c=/^\s*([\s\S]+?)\s+for\s+([\s\S]+?)\s*$/;return{restrict:"A",compile:function(d,e){function f(a,b,c){i.push(a),j.push({scope:a,element:b}),o.forEach(function(b,c){g(b,a)}),a.$on("$destroy",h)}function g(b,d){var e=b.match(c),f=d.$eval(e[1]),g=e[2],h=k[b];if(!h){var i=function(b){var c=null;j.some(function(a){var d=a.scope.$eval(m);if(d===b)return c=a,!0}),h.lastActivated!==c&&(h.lastActivated&&a.removeClass(h.lastActivated.element,f),c&&a.addClass(c.element,f),h.lastActivated=c)};k[b]=h={lastActivated:null,scope:d,watchFn:i,compareWithExp:g,watcher:d.$watch(g,i)}}h.watchFn(d.$eval(g))}function h(a){var b=a.targetScope,c=i.indexOf(b);if(i.splice(c,1),j.splice(c,1),i.length){var d=i[0];angular.forEach(k,function(a){a.scope===b&&(a.watcher=d.$watch(a.compareWithExp,a.watchFn),a.scope=d)})}else k={}}var i=[],j=[],k={},l=e.uibIsClass.match(b),m=l[2],n=l[1],o=n.split(",");return f}}}]),angular.module("ui.bootstrap.position",[]).factory("$uibPosition",["$document","$window",function(a,b){var c,d={normal:/(auto|scroll)/,hidden:/(auto|scroll|hidden)/},e={auto:/\s?auto?\s?/i,primary:/^(top|bottom|left|right)$/,secondary:/^(top|bottom|left|right|center)$/,vertical:/^(top|bottom)$/};return{getRawNode:function(a){return a.nodeName?a:a[0]||a},parseStyle:function(a){return a=parseFloat(a),isFinite(a)?a:0},offsetParent:function(c){function d(a){return"static"===(b.getComputedStyle(a).position||"static")}c=this.getRawNode(c);for(var e=c.offsetParent||a[0].documentElement;e&&e!==a[0].documentElement&&d(e);)e=e.offsetParent;return e||a[0].documentElement},scrollbarWidth:function(){if(angular.isUndefined(c)){var b=angular.element('<div class="uib-position-scrollbar-measure"></div>');a.find("body").append(b),c=b[0].offsetWidth-b[0].clientWidth,c=isFinite(c)?c:0,b.remove()}return c},isScrollable:function(a,c){a=this.getRawNode(a);var e=c?d.hidden:d.normal,f=b.getComputedStyle(a);return e.test(f.overflow+f.overflowY+f.overflowX)},scrollParent:function(c,e){c=this.getRawNode(c);var f=e?d.hidden:d.normal,g=a[0].documentElement,h=b.getComputedStyle(c),i="absolute"===h.position,j=c.parentElement||g;if(j===g||"fixed"===h.position)return g;for(;j.parentElement&&j!==g;){var k=b.getComputedStyle(j);if(i&&"static"!==k.position&&(i=!1),!i&&f.test(k.overflow+k.overflowY+k.overflowX))break;j=j.parentElement}return j},position:function(c,d){c=this.getRawNode(c);var e=this.offset(c);if(d){var f=b.getComputedStyle(c);e.top-=this.parseStyle(f.marginTop),e.left-=this.parseStyle(f.marginLeft)}var g=this.offsetParent(c),h={top:0,left:0};return g!==a[0].documentElement&&(h=this.offset(g),h.top+=g.clientTop-g.scrollTop,h.left+=g.clientLeft-g.scrollLeft),{width:Math.round(angular.isNumber(e.width)?e.width:c.offsetWidth),height:Math.round(angular.isNumber(e.height)?e.height:c.offsetHeight),top:Math.round(e.top-h.top),left:Math.round(e.left-h.left)}},offset:function(c){c=this.getRawNode(c);var d=c.getBoundingClientRect();return{width:Math.round(angular.isNumber(d.width)?d.width:c.offsetWidth),height:Math.round(angular.isNumber(d.height)?d.height:c.offsetHeight),top:Math.round(d.top+(b.pageYOffset||a[0].documentElement.scrollTop)),left:Math.round(d.left+(b.pageXOffset||a[0].documentElement.scrollLeft))}},viewportOffset:function(c,d,e){c=this.getRawNode(c),e=e!==!1;var f=c.getBoundingClientRect(),g={top:0,left:0,bottom:0,right:0},h=d?a[0].documentElement:this.scrollParent(c),i=h.getBoundingClientRect();if(g.top=i.top+h.clientTop,g.left=i.left+h.clientLeft,h===a[0].documentElement&&(g.top+=b.pageYOffset,g.left+=b.pageXOffset),g.bottom=g.top+h.clientHeight,g.right=g.left+h.clientWidth,e){var j=b.getComputedStyle(h);g.top+=this.parseStyle(j.paddingTop),g.bottom-=this.parseStyle(j.paddingBottom),g.left+=this.parseStyle(j.paddingLeft),g.right-=this.parseStyle(j.paddingRight)}return{top:Math.round(f.top-g.top),bottom:Math.round(g.bottom-f.bottom),left:Math.round(f.left-g.left),right:Math.round(g.right-f.right)}},parsePlacement:function(a){var b=e.auto.test(a);return b&&(a=a.replace(e.auto,"")),a=a.split("-"),a[0]=a[0]||"top",e.primary.test(a[0])||(a[0]="top"),a[1]=a[1]||"center",e.secondary.test(a[1])||(a[1]="center"),b?a[2]=!0:a[2]=!1,a},positionElements:function(a,c,d,f){a=this.getRawNode(a),c=this.getRawNode(c);var g=angular.isDefined(c.offsetWidth)?c.offsetWidth:c.prop("offsetWidth"),h=angular.isDefined(c.offsetHeight)?c.offsetHeight:c.prop("offsetHeight");d=this.parsePlacement(d);var i=f?this.offset(a):this.position(a),j={top:0,left:0,placement:""};if(d[2]){var k=this.viewportOffset(a,f),l=b.getComputedStyle(c),m={width:g+Math.round(Math.abs(this.parseStyle(l.marginLeft)+this.parseStyle(l.marginRight))),height:h+Math.round(Math.abs(this.parseStyle(l.marginTop)+this.parseStyle(l.marginBottom)))};if(d[0]="top"===d[0]&&m.height>k.top&&m.height<=k.bottom?"bottom":"bottom"===d[0]&&m.height>k.bottom&&m.height<=k.top?"top":"left"===d[0]&&m.width>k.left&&m.width<=k.right?"right":"right"===d[0]&&m.width>k.right&&m.width<=k.left?"left":d[0],d[1]="top"===d[1]&&m.height-i.height>k.bottom&&m.height-i.height<=k.top?"bottom":"bottom"===d[1]&&m.height-i.height>k.top&&m.height-i.height<=k.bottom?"top":"left"===d[1]&&m.width-i.width>k.right&&m.width-i.width<=k.left?"right":"right"===d[1]&&m.width-i.width>k.left&&m.width-i.width<=k.right?"left":d[1],"center"===d[1])if(e.vertical.test(d[0])){var n=i.width/2-g/2;k.left+n<0&&m.width-i.width<=k.right?d[1]="left":k.right+n<0&&m.width-i.width<=k.left&&(d[1]="right")}else{var o=i.height/2-m.height/2;k.top+o<0&&m.height-i.height<=k.bottom?d[1]="top":k.bottom+o<0&&m.height-i.height<=k.top&&(d[1]="bottom")}}switch(d[0]){case"top":j.top=i.top-h;break;case"bottom":j.top=i.top+i.height;break;case"left":j.left=i.left-g;break;case"right":j.left=i.left+i.width}switch(d[1]){case"top":j.top=i.top;break;case"bottom":j.top=i.top+i.height-h;break;case"left":j.left=i.left;break;case"right":j.left=i.left+i.width-g;break;case"center":e.vertical.test(d[0])?j.left=i.left+i.width/2-g/2:j.top=i.top+i.height/2-h/2}return j.top=Math.round(j.top),j.left=Math.round(j.left),j.placement="center"===d[1]?d[0]:d[0]+"-"+d[1],j},positionArrow:function(a,c){a=this.getRawNode(a);var d=a.querySelector(".tooltip-inner, .popover-inner");if(d){var f=angular.element(d).hasClass("tooltip-inner"),g=f?a.querySelector(".tooltip-arrow"):a.querySelector(".arrow");if(g){var h={top:"",bottom:"",left:"",right:""};if(c=this.parsePlacement(c),"center"===c[1])return void angular.element(g).css(h);var i="border-"+c[0]+"-width",j=b.getComputedStyle(g)[i],k="border-";k+=e.vertical.test(c[0])?c[0]+"-"+c[1]:c[1]+"-"+c[0],k+="-radius";var l=b.getComputedStyle(f?d:a)[k];switch(c[0]){case"top":h.bottom=f?"0":"-"+j;break;case"bottom":h.top=f?"0":"-"+j;break;case"left":h.right=f?"0":"-"+j;break;case"right":h.left=f?"0":"-"+j}h[c[1]]=l,angular.element(g).css(h)}}}}}]),angular.module("ui.bootstrap.datepicker",["ui.bootstrap.dateparser","ui.bootstrap.isClass","ui.bootstrap.position"]).value("$datepickerSuppressError",!1).value("uibDatepickerAttributeWarning",!0).constant("uibDatepickerConfig",{datepickerMode:"day",formatDay:"dd",formatMonth:"MMMM",formatYear:"yyyy",formatDayHeader:"EEE",formatDayTitle:"MMMM yyyy",formatMonthTitle:"yyyy",maxDate:null,maxMode:"year",minDate:null,minMode:"day",ngModelOptions:{},shortcutPropagation:!1,showWeeks:!0,yearColumns:5,yearRows:4}).controller("UibDatepickerController",["$scope","$attrs","$parse","$interpolate","$locale","$log","dateFilter","uibDatepickerConfig","$datepickerSuppressError","uibDatepickerAttributeWarning","uibDateParser",function(a,b,c,d,e,f,g,h,i,j,k){function l(b){a.datepickerMode=b,q&&(a.datepickerOptions.datepickerMode=b)}var m=this,n={$setViewValue:angular.noop},o={},p=[],q=!!b.datepickerOptions;if(this.modes=["day","month","year"],q)["customClass","dateDisabled","datepickerMode","formatDay","formatDayHeader","formatDayTitle","formatMonth","formatMonthTitle","formatYear","initDate","maxDate","maxMode","minDate","minMode","showWeeks","shortcutPropagation","startingDay","yearColumns","yearRows"].forEach(function(b){switch(b){case"customClass":case"dateDisabled":a[b]=a.datepickerOptions[b]||angular.noop;break;case"datepickerMode":a.datepickerMode=angular.isDefined(a.datepickerOptions.datepickerMode)?a.datepickerOptions.datepickerMode:h.datepickerMode;break;case"formatDay":case"formatDayHeader":case"formatDayTitle":case"formatMonth":case"formatMonthTitle":case"formatYear":m[b]=angular.isDefined(a.datepickerOptions[b])?d(a.datepickerOptions[b])(a.$parent):h[b];break;case"showWeeks":case"shortcutPropagation":case"yearColumns":case"yearRows":m[b]=angular.isDefined(a.datepickerOptions[b])?a.datepickerOptions[b]:h[b];break;case"startingDay":angular.isDefined(a.datepickerOptions.startingDay)?m.startingDay=a.datepickerOptions.startingDay:angular.isNumber(h.startingDay)?m.startingDay=h.startingDay:m.startingDay=(e.DATETIME_FORMATS.FIRSTDAYOFWEEK+8)%7;break;case"maxDate":case"minDate":a.datepickerOptions[b]?a.$watch(function(){return a.datepickerOptions[b]},function(a){a?angular.isDate(a)?m[b]=k.fromTimezone(new Date(a),o.timezone):m[b]=new Date(g(a,"medium")):m[b]=null,m.refreshView()}):m[b]=h[b]?k.fromTimezone(new Date(h[b]),o.timezone):null;break;case"maxMode":case"minMode":a.datepickerOptions[b]?a.$watch(function(){return a.datepickerOptions[b]},function(c){m[b]=a[b]=angular.isDefined(c)?c:datepickerOptions[b],("minMode"===b&&m.modes.indexOf(a.datepickerOptions.datepickerMode)<m.modes.indexOf(m[b])||"maxMode"===b&&m.modes.indexOf(a.datepickerOptions.datepickerMode)>m.modes.indexOf(m[b]))&&(a.datepickerMode=m[b],a.datepickerOptions.datepickerMode=m[b])}):m[b]=a[b]=h[b]||null;break;case"initDate":a.datepickerOptions.initDate?(m.activeDate=k.fromTimezone(a.datepickerOptions.initDate,o.timezone)||new Date,a.$watch(function(){return a.datepickerOptions.initDate},function(a){a&&(n.$isEmpty(n.$modelValue)||n.$invalid)&&(m.activeDate=k.fromTimezone(a,o.timezone),m.refreshView())})):m.activeDate=new Date}});else{if(angular.forEach(["formatDay","formatMonth","formatYear","formatDayHeader","formatDayTitle","formatMonthTitle"],function(c){m[c]=angular.isDefined(b[c])?d(b[c])(a.$parent):h[c],angular.isDefined(b[c])&&j&&f.warn("uib-datepicker "+c+" attribute usage is deprecated, use datepicker-options attribute instead")}),angular.forEach(["showWeeks","yearRows","yearColumns","shortcutPropagation"],function(c){m[c]=angular.isDefined(b[c])?a.$parent.$eval(b[c]):h[c],angular.isDefined(b[c])&&j&&f.warn("uib-datepicker "+c+" attribute usage is deprecated, use datepicker-options attribute instead")}),angular.forEach(["dateDisabled","customClass"],function(a){angular.isDefined(b[a])&&j&&f.warn("uib-datepicker "+a+" attribute usage is deprecated, use datepicker-options attribute instead")}),angular.isDefined(b.startingDay)?(j&&f.warn("uib-datepicker startingDay attribute usage is deprecated, use datepicker-options attribute instead"),m.startingDay=a.$parent.$eval(b.startingDay)):angular.isNumber(h.startingDay)?m.startingDay=h.startingDay:m.startingDay=(e.DATETIME_FORMATS.FIRSTDAYOFWEEK+8)%7,angular.forEach(["minDate","maxDate"],function(c){b[c]?(j&&f.warn("uib-datepicker "+c+" attribute usage is deprecated, use datepicker-options attribute instead"),p.push(a.$parent.$watch(b[c],function(a){a?angular.isDate(a)?m[c]=k.fromTimezone(new Date(a),o.timezone):m[c]=new Date(g(a,"medium")):m[c]=null,m.refreshView()}))):m[c]=h[c]?k.fromTimezone(new Date(h[c]),o.timezone):null}),angular.forEach(["minMode","maxMode"],function(c){b[c]?(j&&f.warn("uib-datepicker "+c+" attribute usage is deprecated, use datepicker-options attribute instead"),p.push(a.$parent.$watch(b[c],function(d){m[c]=a[c]=angular.isDefined(d)?d:b[c],("minMode"===c&&m.modes.indexOf(a.datepickerMode)<m.modes.indexOf(m[c])||"maxMode"===c&&m.modes.indexOf(a.datepickerMode)>m.modes.indexOf(m[c]))&&(a.datepickerMode=m[c])}))):m[c]=a[c]=h[c]||null}),angular.isDefined(b.initDate)){j&&f.warn("uib-datepicker initDate attribute usage is deprecated, use datepicker-options attribute instead");var r=k.fromTimezone(a.$parent.$eval(b.initDate),o.timezone);this.activeDate=isNaN(r)?new Date:r,p.push(a.$parent.$watch(b.initDate,function(a){a&&(n.$isEmpty(n.$modelValue)||n.$invalid)&&(a=k.fromTimezone(a,o.timezone),m.activeDate=isNaN(a)?new Date:a,m.refreshView())}))}else this.activeDate=new Date;b.datepickerMode&&j&&f.warn("uib-datepicker datepickerMode attribute usage is deprecated, use datepicker-options attribute instead"),a.datepickerMode=a.datepickerMode||h.datepickerMode}a.uniqueId="datepicker-"+a.$id+"-"+Math.floor(1e4*Math.random()),a.disabled=angular.isDefined(b.disabled)||!1,angular.isDefined(b.ngDisabled)&&p.push(a.$parent.$watch(b.ngDisabled,function(b){a.disabled=b,m.refreshView()})),a.isActive=function(b){return 0===m.compare(b.date,m.activeDate)&&(a.activeDateId=b.uid,!0)},this.init=function(a){n=a,o=a.$options||h.ngModelOptions,this.activeDate=n.$modelValue?k.fromTimezone(new Date(n.$modelValue),o.timezone):k.fromTimezone(new Date,o.timezone),n.$render=function(){m.render()}},this.render=function(){if(n.$viewValue){var a=new Date(n.$viewValue),b=!isNaN(a);b?this.activeDate=k.fromTimezone(a,o.timezone):i||f.error('Datepicker directive: "ng-model" value must be a Date object')}this.refreshView()},this.refreshView=function(){if(this.element){a.selectedDt=null,this._refreshView(),a.activeDt&&(a.activeDateId=a.activeDt.uid);var b=n.$viewValue?new Date(n.$viewValue):null;b=k.fromTimezone(b,o.timezone),n.$setValidity("dateDisabled",!b||this.element&&!this.isDisabled(b))}},this.createDateObject=function(b,c){var d=n.$viewValue?new Date(n.$viewValue):null;d=k.fromTimezone(d,o.timezone);var e=new Date;e=k.fromTimezone(e,o.timezone);var f=this.compare(b,e),g={date:b,label:k.filter(b,c),selected:d&&0===this.compare(b,d),disabled:this.isDisabled(b),past:f<0,current:0===f,future:f>0,customClass:this.customClass(b)||null};return d&&0===this.compare(b,d)&&(a.selectedDt=g),m.activeDate&&0===this.compare(g.date,m.activeDate)&&(a.activeDt=g),g},this.isDisabled=function(b){return a.disabled||this.minDate&&this.compare(b,this.minDate)<0||this.maxDate&&this.compare(b,this.maxDate)>0||a.dateDisabled&&a.dateDisabled({date:b,mode:a.datepickerMode})},this.customClass=function(b){return a.customClass({date:b,mode:a.datepickerMode});
},this.split=function(a,b){for(var c=[];a.length>0;)c.push(a.splice(0,b));return c},a.select=function(b){if(a.datepickerMode===m.minMode){var c=n.$viewValue?k.fromTimezone(new Date(n.$viewValue),o.timezone):new Date(0,0,0,0,0,0,0);c.setFullYear(b.getFullYear(),b.getMonth(),b.getDate()),c=k.toTimezone(c,o.timezone),n.$setViewValue(c),n.$render()}else m.activeDate=b,l(m.modes[m.modes.indexOf(a.datepickerMode)-1]),a.$emit("uib:datepicker.mode")},a.move=function(a){var b=m.activeDate.getFullYear()+a*(m.step.years||0),c=m.activeDate.getMonth()+a*(m.step.months||0);m.activeDate.setFullYear(b,c,1),m.refreshView()},a.toggleMode=function(b){b=b||1,a.datepickerMode===m.maxMode&&1===b||a.datepickerMode===m.minMode&&b===-1||(l(m.modes[m.modes.indexOf(a.datepickerMode)+b]),a.$emit("uib:datepicker.mode"))},a.keys={13:"enter",32:"space",33:"pageup",34:"pagedown",35:"end",36:"home",37:"left",38:"up",39:"right",40:"down"};var s=function(){m.element[0].focus()};a.$on("uib:datepicker.focus",s),a.keydown=function(b){var c=a.keys[b.which];if(c&&!b.shiftKey&&!b.altKey&&!a.disabled)if(b.preventDefault(),m.shortcutPropagation||b.stopPropagation(),"enter"===c||"space"===c){if(m.isDisabled(m.activeDate))return;a.select(m.activeDate)}else!b.ctrlKey||"up"!==c&&"down"!==c?(m.handleKeyDown(c,b),m.refreshView()):a.toggleMode("up"===c?1:-1)},a.$on("$destroy",function(){for(;p.length;)p.shift()()})}]).controller("UibDaypickerController",["$scope","$element","dateFilter",function(a,b,c){function d(a,b){return 1!==b||a%4!==0||a%100===0&&a%400!==0?f[b]:29}function e(a){var b=new Date(a);b.setDate(b.getDate()+4-(b.getDay()||7));var c=b.getTime();return b.setMonth(0),b.setDate(1),Math.floor(Math.round((c-b)/864e5)/7)+1}var f=[31,28,31,30,31,30,31,31,30,31,30,31];this.step={months:1},this.element=b,this.init=function(b){angular.extend(b,this),a.showWeeks=b.showWeeks,b.refreshView()},this.getDates=function(a,b){for(var c,d=new Array(b),e=new Date(a),f=0;f<b;)c=new Date(e),d[f++]=c,e.setDate(e.getDate()+1);return d},this._refreshView=function(){var b=this.activeDate.getFullYear(),d=this.activeDate.getMonth(),f=new Date(this.activeDate);f.setFullYear(b,d,1);var g=this.startingDay-f.getDay(),h=g>0?7-g:-g,i=new Date(f);h>0&&i.setDate(-h+1);for(var j=this.getDates(i,42),k=0;k<42;k++)j[k]=angular.extend(this.createDateObject(j[k],this.formatDay),{secondary:j[k].getMonth()!==d,uid:a.uniqueId+"-"+k});a.labels=new Array(7);for(var l=0;l<7;l++)a.labels[l]={abbr:c(j[l].date,this.formatDayHeader),full:c(j[l].date,"EEEE")};if(a.title=c(this.activeDate,this.formatDayTitle),a.rows=this.split(j,7),a.showWeeks){a.weekNumbers=[];for(var m=(11-this.startingDay)%7,n=a.rows.length,o=0;o<n;o++)a.weekNumbers.push(e(a.rows[o][m].date))}},this.compare=function(a,b){var c=new Date(a.getFullYear(),a.getMonth(),a.getDate()),d=new Date(b.getFullYear(),b.getMonth(),b.getDate());return c.setFullYear(a.getFullYear()),d.setFullYear(b.getFullYear()),c-d},this.handleKeyDown=function(a,b){var c=this.activeDate.getDate();if("left"===a)c-=1;else if("up"===a)c-=7;else if("right"===a)c+=1;else if("down"===a)c+=7;else if("pageup"===a||"pagedown"===a){var e=this.activeDate.getMonth()+("pageup"===a?-1:1);this.activeDate.setMonth(e,1),c=Math.min(d(this.activeDate.getFullYear(),this.activeDate.getMonth()),c)}else"home"===a?c=1:"end"===a&&(c=d(this.activeDate.getFullYear(),this.activeDate.getMonth()));this.activeDate.setDate(c)}}]).controller("UibMonthpickerController",["$scope","$element","dateFilter",function(a,b,c){this.step={years:1},this.element=b,this.init=function(a){angular.extend(a,this),a.refreshView()},this._refreshView=function(){for(var b,d=new Array(12),e=this.activeDate.getFullYear(),f=0;f<12;f++)b=new Date(this.activeDate),b.setFullYear(e,f,1),d[f]=angular.extend(this.createDateObject(b,this.formatMonth),{uid:a.uniqueId+"-"+f});a.title=c(this.activeDate,this.formatMonthTitle),a.rows=this.split(d,3)},this.compare=function(a,b){var c=new Date(a.getFullYear(),a.getMonth()),d=new Date(b.getFullYear(),b.getMonth());return c.setFullYear(a.getFullYear()),d.setFullYear(b.getFullYear()),c-d},this.handleKeyDown=function(a,b){var c=this.activeDate.getMonth();if("left"===a)c-=1;else if("up"===a)c-=3;else if("right"===a)c+=1;else if("down"===a)c+=3;else if("pageup"===a||"pagedown"===a){var d=this.activeDate.getFullYear()+("pageup"===a?-1:1);this.activeDate.setFullYear(d)}else"home"===a?c=0:"end"===a&&(c=11);this.activeDate.setMonth(c)}}]).controller("UibYearpickerController",["$scope","$element","dateFilter",function(a,b,c){function d(a){return parseInt((a-1)/f,10)*f+1}var e,f;this.element=b,this.yearpickerInit=function(){e=this.yearColumns,f=this.yearRows*e,this.step={years:f}},this._refreshView=function(){for(var b,c=new Array(f),g=0,h=d(this.activeDate.getFullYear());g<f;g++)b=new Date(this.activeDate),b.setFullYear(h+g,0,1),c[g]=angular.extend(this.createDateObject(b,this.formatYear),{uid:a.uniqueId+"-"+g});a.title=[c[0].label,c[f-1].label].join(" - "),a.rows=this.split(c,e),a.columns=e},this.compare=function(a,b){return a.getFullYear()-b.getFullYear()},this.handleKeyDown=function(a,b){var c=this.activeDate.getFullYear();"left"===a?c-=1:"up"===a?c-=e:"right"===a?c+=1:"down"===a?c+=e:"pageup"===a||"pagedown"===a?c+=("pageup"===a?-1:1)*f:"home"===a?c=d(this.activeDate.getFullYear()):"end"===a&&(c=d(this.activeDate.getFullYear())+f-1),this.activeDate.setFullYear(c)}}]).directive("uibDatepicker",function(){return{replace:!0,templateUrl:function(a,b){return b.templateUrl||"uib/template/datepicker/datepicker.html"},scope:{datepickerMode:"=?",datepickerOptions:"=?",dateDisabled:"&",customClass:"&",shortcutPropagation:"&?"},require:["uibDatepicker","^ngModel"],controller:"UibDatepickerController",controllerAs:"datepicker",link:function(a,b,c,d){var e=d[0],f=d[1];e.init(f)}}}).directive("uibDaypicker",function(){return{replace:!0,templateUrl:function(a,b){return b.templateUrl||"uib/template/datepicker/day.html"},require:["^uibDatepicker","uibDaypicker"],controller:"UibDaypickerController",link:function(a,b,c,d){var e=d[0],f=d[1];f.init(e)}}}).directive("uibMonthpicker",function(){return{replace:!0,templateUrl:function(a,b){return b.templateUrl||"uib/template/datepicker/month.html"},require:["^uibDatepicker","uibMonthpicker"],controller:"UibMonthpickerController",link:function(a,b,c,d){var e=d[0],f=d[1];f.init(e)}}}).directive("uibYearpicker",function(){return{replace:!0,templateUrl:function(a,b){return b.templateUrl||"uib/template/datepicker/year.html"},require:["^uibDatepicker","uibYearpicker"],controller:"UibYearpickerController",link:function(a,b,c,d){var e=d[0];angular.extend(e,d[1]),e.yearpickerInit(),e.refreshView()}}}).value("uibDatepickerPopupAttributeWarning",!0).constant("uibDatepickerPopupConfig",{altInputFormats:[],appendToBody:!1,clearText:"Clear",closeOnDateSelection:!0,closeText:"Done",currentText:"Today",datepickerPopup:"yyyy-MM-dd",datepickerPopupTemplateUrl:"uib/template/datepicker/popup.html",datepickerTemplateUrl:"uib/template/datepicker/datepicker.html",html5Types:{date:"yyyy-MM-dd","datetime-local":"yyyy-MM-ddTHH:mm:ss.sss",month:"yyyy-MM"},onOpenFocus:!0,showButtonBar:!0,placement:"auto bottom-left"}).controller("UibDatepickerPopupController",["$scope","$element","$attrs","$compile","$log","$parse","$window","$document","$rootScope","$uibPosition","dateFilter","uibDateParser","uibDatepickerPopupConfig","$timeout","uibDatepickerConfig","uibDatepickerPopupAttributeWarning",function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){function q(a){return a.replace(/([A-Z])/g,function(a){return"-"+a.toLowerCase()})}function r(b){var c=l.parse(b,x,a.date);if(isNaN(c))for(var d=0;d<J.length;d++)if(c=l.parse(b,J[d],a.date),!isNaN(c))return c;return c}function s(a){if(angular.isNumber(a)&&(a=new Date(a)),!a)return null;if(angular.isDate(a)&&!isNaN(a))return a;if(angular.isString(a)){var b=r(a);if(!isNaN(b))return l.toTimezone(b,H.timezone)}return G.$options&&G.$options.allowInvalid?a:void 0}function t(a,b){var d=a||b;return!c.ngRequired&&!d||(angular.isNumber(d)&&(d=new Date(d)),!d||(!(!angular.isDate(d)||isNaN(d))||!!angular.isString(d)&&!isNaN(r(b))))}function u(c){if(a.isOpen||!a.disabled){var d=I[0],e=b[0].contains(c.target),f=void 0!==d.contains&&d.contains(c.target);!a.isOpen||e||f||a.$apply(function(){a.isOpen=!1})}}function v(c){27===c.which&&a.isOpen?(c.preventDefault(),c.stopPropagation(),a.$apply(function(){a.isOpen=!1}),b[0].focus()):40!==c.which||a.isOpen||(c.preventDefault(),c.stopPropagation(),a.$apply(function(){a.isOpen=!0}))}function w(){if(a.isOpen){var d=angular.element(I[0].querySelector(".uib-datepicker-popup")),e=c.popupPlacement?c.popupPlacement:m.placement,f=j.positionElements(b,d,e,z);d.css({top:f.top+"px",left:f.left+"px"}),d.hasClass("uib-position-measure")&&d.removeClass("uib-position-measure")}}var x,y,z,A,B,C,D,E,F,G,H,I,J,K={},L=!1,M=[];a.watchData={},this.init=function(j){if(G=j,H=j.$options||o.ngModelOptions,y=angular.isDefined(c.closeOnDateSelection)?a.$parent.$eval(c.closeOnDateSelection):m.closeOnDateSelection,z=angular.isDefined(c.datepickerAppendToBody)?a.$parent.$eval(c.datepickerAppendToBody):m.appendToBody,A=angular.isDefined(c.onOpenFocus)?a.$parent.$eval(c.onOpenFocus):m.onOpenFocus,B=angular.isDefined(c.datepickerPopupTemplateUrl)?c.datepickerPopupTemplateUrl:m.datepickerPopupTemplateUrl,C=angular.isDefined(c.datepickerTemplateUrl)?c.datepickerTemplateUrl:m.datepickerTemplateUrl,J=angular.isDefined(c.altInputFormats)?a.$parent.$eval(c.altInputFormats):m.altInputFormats,a.showButtonBar=angular.isDefined(c.showButtonBar)?a.$parent.$eval(c.showButtonBar):m.showButtonBar,m.html5Types[c.type]?(x=m.html5Types[c.type],L=!0):(x=c.uibDatepickerPopup||m.datepickerPopup,c.$observe("uibDatepickerPopup",function(a,b){var c=a||m.datepickerPopup;if(c!==x&&(x=c,G.$modelValue=null,!x))throw new Error("uibDatepickerPopup must have a date format specified.")})),!x)throw new Error("uibDatepickerPopup must have a date format specified.");if(L&&c.uibDatepickerPopup)throw new Error("HTML5 date input types do not support custom formats.");D=angular.element("<div uib-datepicker-popup-wrap><div uib-datepicker></div></div>"),a.ngModelOptions=angular.copy(H),a.ngModelOptions.timezone=null,a.ngModelOptions.updateOnDefault===!0&&(a.ngModelOptions.updateOn=a.ngModelOptions.updateOn?a.ngModelOptions.updateOn+" default":"default"),D.attr({"ng-model":"date","ng-model-options":"ngModelOptions","ng-change":"dateSelection(date)","template-url":B}),E=angular.element(D.children()[0]),E.attr("template-url",C),L&&"month"===c.type&&(E.attr("datepicker-mode",'"month"'),E.attr("min-mode","month")),a.datepickerOptions&&E.attr("datepicker-options","datepickerOptions"),angular.forEach(["minMode","maxMode","datepickerMode","shortcutPropagation"],function(b){if(c[b]){p&&e.warn("uib-datepicker settings via uib-datepicker-popup attributes are deprecated and will be removed in UI Bootstrap 1.3, use datepicker-options attribute instead");var d=f(c[b]),g={get:function(){return d(a.$parent)}};if(E.attr(q(b),"watchData."+b),"datepickerMode"===b){var h=d.assign;g.set=function(b){h(a.$parent,b)}}Object.defineProperty(a.watchData,b,g)}}),angular.forEach(["minDate","maxDate","initDate"],function(b){if(c[b]){p&&e.warn("uib-datepicker settings via uib-datepicker-popup attributes are deprecated and will be removed in UI Bootstrap 1.3, use datepicker-options attribute instead");var d=f(c[b]);M.push(a.$parent.$watch(d,function(c){if("minDate"===b||"maxDate"===b)null===c?K[b]=null:angular.isDate(c)?K[b]=l.fromTimezone(new Date(c),H.timezone):K[b]=new Date(k(c,"medium")),a.watchData[b]=null===c?null:K[b];else{var d=c?new Date(c):new Date;a.watchData[b]=l.fromTimezone(d,H.timezone)}})),E.attr(q(b),"watchData."+b)}}),c.dateDisabled&&(p&&e.warn("uib-datepicker settings via uib-datepicker-popup attributes are deprecated and will be removed in UI Bootstrap 1.3, use datepicker-options attribute instead"),E.attr("date-disabled","dateDisabled({ date: date, mode: mode })")),angular.forEach(["formatDay","formatMonth","formatYear","formatDayHeader","formatDayTitle","formatMonthTitle","showWeeks","startingDay","yearRows","yearColumns"],function(a){angular.isDefined(c[a])&&(p&&e.warn("uib-datepicker settings via uib-datepicker-popup attributes are deprecated and will be removed in UI Bootstrap 1.3, use datepicker-options attribute instead"),E.attr(q(a),c[a]))}),c.customClass&&(p&&e.warn("uib-datepicker settings via uib-datepicker-popup attributes are deprecated and will be removed in UI Bootstrap 1.3, use datepicker-options attribute instead"),E.attr("custom-class","customClass({ date: date, mode: mode })")),L?G.$formatters.push(function(b){return a.date=l.fromTimezone(b,H.timezone),b}):(G.$$parserName="date",G.$validators.date=t,G.$parsers.unshift(s),G.$formatters.push(function(b){return G.$isEmpty(b)?(a.date=b,b):(a.date=l.fromTimezone(b,H.timezone),angular.isNumber(a.date)&&(a.date=new Date(a.date)),l.filter(a.date,x))})),G.$viewChangeListeners.push(function(){a.date=r(G.$viewValue)}),b.on("keydown",v),I=d(D)(a),D.remove(),z?h.find("body").append(I):b.after(I),a.$on("$destroy",function(){for(a.isOpen===!0&&(i.$$phase||a.$apply(function(){a.isOpen=!1})),I.remove(),b.off("keydown",v),h.off("click",u),F&&F.off("scroll",w),angular.element(g).off("resize",w);M.length;)M.shift()()})},a.getText=function(b){return a[b+"Text"]||m[b+"Text"]},a.isDisabled=function(b){return"today"===b&&(b=l.fromTimezone(new Date,H.timezone)),a.datepickerOptions?a.datepickerOptions&&a.datepickerOptions.minDate&&a.compare(b,a.datepickerOptions.minDate)<0||a.datepickerOptions.maxDate&&a.compare(b,a.datepickerOptions.maxDate)>0:a.watchData.minDate&&a.compare(b,K.minDate)<0||a.watchData.maxDate&&a.compare(b,K.maxDate)>0},a.compare=function(a,b){return new Date(a.getFullYear(),a.getMonth(),a.getDate())-new Date(b.getFullYear(),b.getMonth(),b.getDate())},a.dateSelection=function(c){angular.isDefined(c)&&(a.date=c);var d=a.date?l.filter(a.date,x):null;b.val(d),G.$setViewValue(d),y&&(a.isOpen=!1,b[0].focus())},a.keydown=function(c){27===c.which&&(c.stopPropagation(),a.isOpen=!1,b[0].focus())},a.select=function(b,c){if(c.stopPropagation(),"today"===b){var d=new Date;angular.isDate(a.date)?(b=new Date(a.date),b.setFullYear(d.getFullYear(),d.getMonth(),d.getDate())):b=new Date(d.setHours(0,0,0,0))}a.dateSelection(b)},a.close=function(c){c.stopPropagation(),a.isOpen=!1,b[0].focus()},a.disabled=angular.isDefined(c.disabled)||!1,c.ngDisabled&&M.push(a.$parent.$watch(f(c.ngDisabled),function(b){a.disabled=b})),a.$watch("isOpen",function(d){d?a.disabled?a.isOpen=!1:n(function(){w(),A&&a.$broadcast("uib:datepicker.focus"),h.on("click",u);var d=c.popupPlacement?c.popupPlacement:m.placement;z||j.parsePlacement(d)[2]?(F=F||angular.element(j.scrollParent(b)),F&&F.on("scroll",w)):F=null,angular.element(g).on("resize",w)},0,!1):(h.off("click",u),F&&F.off("scroll",w),angular.element(g).off("resize",w))}),a.$on("uib:datepicker.mode",function(){n(w,0,!1)})}]).directive("uibDatepickerPopup",function(){return{require:["ngModel","uibDatepickerPopup"],controller:"UibDatepickerPopupController",scope:{datepickerOptions:"=?",isOpen:"=?",currentText:"@",clearText:"@",closeText:"@",dateDisabled:"&",customClass:"&"},link:function(a,b,c,d){var e=d[0],f=d[1];f.init(e)}}}).directive("uibDatepickerPopupWrap",function(){return{replace:!0,transclude:!0,templateUrl:function(a,b){return b.templateUrl||"uib/template/datepicker/popup.html"}}}),angular.module("ui.bootstrap.debounce",[]).factory("$$debounce",["$timeout",function(a){return function(b,c){var d;return function(){var e=this,f=Array.prototype.slice.call(arguments);d&&a.cancel(d),d=a(function(){b.apply(e,f)},c)}}}]),angular.module("ui.bootstrap.dropdown",["ui.bootstrap.position"]).constant("uibDropdownConfig",{appendToOpenClass:"uib-dropdown-open",openClass:"open"}).service("uibDropdownService",["$document","$rootScope",function(a,b){var c=null;this.open=function(b){c||(a.on("click",d),a.on("keydown",e)),c&&c!==b&&(c.isOpen=!1),c=b},this.close=function(b){c===b&&(c=null,a.off("click",d),a.off("keydown",e))};var d=function(a){if(c&&!(a&&"disabled"===c.getAutoClose()||a&&3===a.which)){var d=c.getToggleElement();if(!(a&&d&&d[0].contains(a.target))){var e=c.getDropdownElement();a&&"outsideClick"===c.getAutoClose()&&e&&e[0].contains(a.target)||(c.isOpen=!1,b.$$phase||c.$apply())}}},e=function(a){27===a.which?(c.focusToggleElement(),d()):c.isKeynavEnabled()&&[38,40].indexOf(a.which)!==-1&&c.isOpen&&(a.preventDefault(),a.stopPropagation(),c.focusDropdownEntry(a.which))}}]).controller("UibDropdownController",["$scope","$element","$attrs","$parse","uibDropdownConfig","uibDropdownService","$animate","$uibPosition","$document","$compile","$templateRequest",function(a,b,c,d,e,f,g,h,i,j,k){var l,m,n=this,o=a.$new(),p=e.appendToOpenClass,q=e.openClass,r=angular.noop,s=c.onToggle?d(c.onToggle):angular.noop,t=!1,u=null,v=!1,w=i.find("body");b.addClass("dropdown"),this.init=function(){if(c.isOpen&&(m=d(c.isOpen),r=m.assign,a.$watch(m,function(a){o.isOpen=!!a})),angular.isDefined(c.dropdownAppendTo)){var e=d(c.dropdownAppendTo)(o);e&&(u=angular.element(e))}t=angular.isDefined(c.dropdownAppendToBody),v=angular.isDefined(c.keyboardNav),t&&!u&&(u=w),u&&n.dropdownMenu&&(u.append(n.dropdownMenu),b.on("$destroy",function(){n.dropdownMenu.remove()}))},this.toggle=function(a){return o.isOpen=arguments.length?!!a:!o.isOpen,angular.isFunction(r)&&r(o,o.isOpen),o.isOpen},this.isOpen=function(){return o.isOpen},o.getToggleElement=function(){return n.toggleElement},o.getAutoClose=function(){return c.autoClose||"always"},o.getElement=function(){return b},o.isKeynavEnabled=function(){return v},o.focusDropdownEntry=function(a){var c=n.dropdownMenu?angular.element(n.dropdownMenu).find("a"):b.find("ul").eq(0).find("a");switch(a){case 40:angular.isNumber(n.selectedOption)?n.selectedOption=n.selectedOption===c.length-1?n.selectedOption:n.selectedOption+1:n.selectedOption=0;break;case 38:angular.isNumber(n.selectedOption)?n.selectedOption=0===n.selectedOption?0:n.selectedOption-1:n.selectedOption=c.length-1}c[n.selectedOption].focus()},o.getDropdownElement=function(){return n.dropdownMenu},o.focusToggleElement=function(){n.toggleElement&&n.toggleElement[0].focus()},o.$watch("isOpen",function(c,d){if(u&&n.dropdownMenu){var e,i,m=h.positionElements(b,n.dropdownMenu,"bottom-left",!0);if(e={top:m.top+"px",display:c?"block":"none"},i=n.dropdownMenu.hasClass("dropdown-menu-right"),i?(e.left="auto",e.right=window.innerWidth-(m.left+b.prop("offsetWidth"))+"px"):(e.left=m.left+"px",e.right="auto"),!t){var v=h.offset(u);e.top=m.top-v.top+"px",i?e.right=window.innerWidth-(m.left-v.left+b.prop("offsetWidth"))+"px":e.left=m.left-v.left+"px"}n.dropdownMenu.css(e)}var w=u?u:b,x=w.hasClass(u?p:q);if(x===!c&&g[c?"addClass":"removeClass"](w,u?p:q).then(function(){angular.isDefined(c)&&c!==d&&s(a,{open:!!c})}),c)n.dropdownMenuTemplateUrl&&k(n.dropdownMenuTemplateUrl).then(function(a){l=o.$new(),j(a.trim())(l,function(a){var b=a;n.dropdownMenu.replaceWith(b),n.dropdownMenu=b})}),o.focusToggleElement(),f.open(o);else{if(n.dropdownMenuTemplateUrl){l&&l.$destroy();var y=angular.element('<ul class="dropdown-menu"></ul>');n.dropdownMenu.replaceWith(y),n.dropdownMenu=y}f.close(o),n.selectedOption=null}angular.isFunction(r)&&r(a,c)}),a.$on("$locationChangeSuccess",function(){"disabled"!==o.getAutoClose()&&(o.isOpen=!1)})}]).directive("uibDropdown",function(){return{controller:"UibDropdownController",link:function(a,b,c,d){d.init()}}}).directive("uibDropdownMenu",function(){return{restrict:"A",require:"?^uibDropdown",link:function(a,b,c,d){if(d&&!angular.isDefined(c.dropdownNested)){b.addClass("dropdown-menu");var e=c.templateUrl;e&&(d.dropdownMenuTemplateUrl=e),d.dropdownMenu||(d.dropdownMenu=b)}}}}).directive("uibDropdownToggle",function(){return{require:"?^uibDropdown",link:function(a,b,c,d){if(d){b.addClass("dropdown-toggle"),d.toggleElement=b;var e=function(e){e.preventDefault(),b.hasClass("disabled")||c.disabled||a.$apply(function(){d.toggle()})};b.bind("click",e),b.attr({"aria-haspopup":!0,"aria-expanded":!1}),a.$watch(d.isOpen,function(a){b.attr("aria-expanded",!!a)}),a.$on("$destroy",function(){b.unbind("click",e)})}}}}),angular.module("ui.bootstrap.stackedMap",[]).factory("$$stackedMap",function(){return{createNew:function(){var a=[];return{add:function(b,c){a.push({key:b,value:c})},get:function(b){for(var c=0;c<a.length;c++)if(b===a[c].key)return a[c]},keys:function(){for(var b=[],c=0;c<a.length;c++)b.push(a[c].key);return b},top:function(){return a[a.length-1]},remove:function(b){for(var c=-1,d=0;d<a.length;d++)if(b===a[d].key){c=d;break}return a.splice(c,1)[0]},removeTop:function(){return a.splice(a.length-1,1)[0]},length:function(){return a.length}}}}}),angular.module("ui.bootstrap.modal",["ui.bootstrap.stackedMap"]).factory("$$multiMap",function(){return{createNew:function(){var a={};return{entries:function(){return Object.keys(a).map(function(b){return{key:b,value:a[b]}})},get:function(b){return a[b]},hasKey:function(b){return!!a[b]},keys:function(){return Object.keys(a)},put:function(b,c){a[b]||(a[b]=[]),a[b].push(c)},remove:function(b,c){var d=a[b];if(d){var e=d.indexOf(c);e!==-1&&d.splice(e,1),d.length||delete a[b]}}}}}}).provider("$uibResolve",function(){var a=this;this.resolver=null,this.setResolver=function(a){this.resolver=a},this.$get=["$injector","$q",function(b,c){var d=a.resolver?b.get(a.resolver):null;return{resolve:function(a,e,f,g){if(d)return d.resolve(a,e,f,g);var h=[];return angular.forEach(a,function(a){angular.isFunction(a)||angular.isArray(a)?h.push(c.resolve(b.invoke(a))):angular.isString(a)?h.push(c.resolve(b.get(a))):h.push(c.resolve(a))}),c.all(h).then(function(b){var c={},d=0;return angular.forEach(a,function(a,e){c[e]=b[d++]}),c})}}}]}).directive("uibModalBackdrop",["$animate","$injector","$uibModalStack",function(a,b,c){function d(b,d,e){e.modalInClass&&(a.addClass(d,e.modalInClass),b.$on(c.NOW_CLOSING_EVENT,function(c,f){var g=f();b.modalOptions.animation?a.removeClass(d,e.modalInClass).then(g):g()}))}return{replace:!0,templateUrl:"uib/template/modal/backdrop.html",compile:function(a,b){return a.addClass(b.backdropClass),d}}}]).directive("uibModalWindow",["$uibModalStack","$q","$animateCss","$document",function(a,b,c,d){return{scope:{index:"@"},replace:!0,transclude:!0,templateUrl:function(a,b){return b.templateUrl||"uib/template/modal/window.html"},link:function(e,f,g){f.addClass(g.windowClass||""),f.addClass(g.windowTopClass||""),e.size=g.size,e.close=function(b){var c=a.getTop();c&&c.value.backdrop&&"static"!==c.value.backdrop&&b.target===b.currentTarget&&(b.preventDefault(),b.stopPropagation(),a.dismiss(c.key,"backdrop click"))},f.on("click",e.close),e.$isRendered=!0;var h=b.defer();g.$observe("modalRender",function(a){"true"===a&&h.resolve()}),h.promise.then(function(){var h=null;g.modalInClass&&(h=c(f,{addClass:g.modalInClass}).start(),e.$on(a.NOW_CLOSING_EVENT,function(a,b){var d=b();c(f,{removeClass:g.modalInClass}).start().then(d)})),b.when(h).then(function(){var b=a.getTop();if(b&&a.modalRendered(b.key),!d[0].activeElement||!f[0].contains(d[0].activeElement)){var c=f[0].querySelector("[autofocus]");c?c.focus():f[0].focus()}})})}}}]).directive("uibModalAnimationClass",function(){return{compile:function(a,b){b.modalAnimation&&a.addClass(b.uibModalAnimationClass)}}}).directive("uibModalTransclude",function(){return{link:function(a,b,c,d,e){e(a.$parent,function(a){b.empty(),b.append(a)})}}}).factory("$uibModalStack",["$animate","$animateCss","$document","$compile","$rootScope","$q","$$multiMap","$$stackedMap",function(a,b,c,d,e,f,g,h){function i(a){return!!(a.offsetWidth||a.offsetHeight||a.getClientRects().length)}function j(){for(var a=-1,b=t.keys(),c=0;c<b.length;c++)t.get(b[c]).value.backdrop&&(a=c);return a}function k(a,b){var c=t.get(a).value,d=c.appendTo;t.remove(a),n(c.modalDomEl,c.modalScope,function(){var b=c.openedClass||s;u.remove(b,a),d.toggleClass(b,u.hasKey(b)),l(!0)},c.closedDeferred),m(),b&&b.focus?b.focus():d.focus&&d.focus()}function l(a){var b;t.length()>0&&(b=t.top().value,b.modalDomEl.toggleClass(b.windowTopClass||"",a))}function m(){if(q&&j()===-1){var a=r;n(q,r,function(){a=null}),q=void 0,r=void 0}}function n(b,c,d,e){function g(){g.done||(g.done=!0,a.leave(b).then(function(){b.remove(),e&&e.resolve()}),c.$destroy(),d&&d())}var h,i=null,j=function(){return h||(h=f.defer(),i=h.promise),function(){h.resolve()}};return c.$broadcast(v.NOW_CLOSING_EVENT,j),f.when(i).then(g)}function o(a){if(a.isDefaultPrevented())return a;var b=t.top();if(b)switch(a.which){case 27:b.value.keyboard&&(a.preventDefault(),e.$apply(function(){v.dismiss(b.key,"escape key press")}));break;case 9:var c=v.loadFocusElementList(b),d=!1;a.shiftKey?(v.isFocusInFirstItem(a,c)||v.isModalFocused(a,b))&&(d=v.focusLastFocusableElement(c)):v.isFocusInLastItem(a,c)&&(d=v.focusFirstFocusableElement(c)),d&&(a.preventDefault(),a.stopPropagation())}}function p(a,b,c){return!a.value.modalScope.$broadcast("modal.closing",b,c).defaultPrevented}var q,r,s="modal-open",t=h.createNew(),u=g.createNew(),v={NOW_CLOSING_EVENT:"modal.stack.now-closing"},w="a[href], area[href], input:not([disabled]), button:not([disabled]),select:not([disabled]), textarea:not([disabled]), iframe, object, embed, *[tabindex], *[contenteditable=true]";return e.$watch(j,function(a){r&&(r.index=a)}),c.on("keydown",o),e.$on("$destroy",function(){c.off("keydown",o)}),v.open=function(b,f){var g=c[0].activeElement,h=f.openedClass||s;l(!1),t.add(b,{deferred:f.deferred,renderDeferred:f.renderDeferred,closedDeferred:f.closedDeferred,modalScope:f.scope,backdrop:f.backdrop,keyboard:f.keyboard,openedClass:f.openedClass,windowTopClass:f.windowTopClass,animation:f.animation,appendTo:f.appendTo}),u.put(h,b);var i=f.appendTo,k=j();if(!i.length)throw new Error("appendTo element not found. Make sure that the element passed is in DOM.");k>=0&&!q&&(r=e.$new(!0),r.modalOptions=f,r.index=k,q=angular.element('<div uib-modal-backdrop="modal-backdrop"></div>'),q.attr("backdrop-class",f.backdropClass),f.animation&&q.attr("modal-animation","true"),d(q)(r),a.enter(q,i));var m=angular.element('<div uib-modal-window="modal-window"></div>');m.attr({"template-url":f.windowTemplateUrl,"window-class":f.windowClass,"window-top-class":f.windowTopClass,size:f.size,index:t.length()-1,animate:"animate"}).html(f.content),f.animation&&m.attr("modal-animation","true"),a.enter(d(m)(f.scope),i).then(function(){f.scope.$$uibDestructionScheduled||a.addClass(i,h)}),t.top().value.modalDomEl=m,t.top().value.modalOpener=g},v.close=function(a,b){var c=t.get(a);return c&&p(c,b,!0)?(c.value.modalScope.$$uibDestructionScheduled=!0,c.value.deferred.resolve(b),k(a,c.value.modalOpener),!0):!c},v.dismiss=function(a,b){var c=t.get(a);return c&&p(c,b,!1)?(c.value.modalScope.$$uibDestructionScheduled=!0,c.value.deferred.reject(b),k(a,c.value.modalOpener),!0):!c},v.dismissAll=function(a){for(var b=this.getTop();b&&this.dismiss(b.key,a);)b=this.getTop()},v.getTop=function(){return t.top()},v.modalRendered=function(a){var b=t.get(a);b&&b.value.renderDeferred.resolve()},v.focusFirstFocusableElement=function(a){return a.length>0&&(a[0].focus(),!0)},v.focusLastFocusableElement=function(a){return a.length>0&&(a[a.length-1].focus(),!0)},v.isModalFocused=function(a,b){if(a&&b){var c=b.value.modalDomEl;if(c&&c.length)return(a.target||a.srcElement)===c[0]}return!1},v.isFocusInFirstItem=function(a,b){return b.length>0&&(a.target||a.srcElement)===b[0]},v.isFocusInLastItem=function(a,b){return b.length>0&&(a.target||a.srcElement)===b[b.length-1]},v.loadFocusElementList=function(a){if(a){var b=a.value.modalDomEl;if(b&&b.length){var c=b[0].querySelectorAll(w);return c?Array.prototype.filter.call(c,function(a){return i(a)}):c}}},v}]).provider("$uibModal",function(){var a={options:{animation:!0,backdrop:!0,keyboard:!0},$get:["$rootScope","$q","$document","$templateRequest","$controller","$uibResolve","$uibModalStack",function(b,c,d,e,f,g,h){function i(a){return a.template?c.when(a.template):e(angular.isFunction(a.templateUrl)?a.templateUrl():a.templateUrl)}var j={},k=null;return j.getPromiseChain=function(){return k},j.open=function(e){function j(){return r}var l=c.defer(),m=c.defer(),n=c.defer(),o=c.defer(),p={result:l.promise,opened:m.promise,closed:n.promise,rendered:o.promise,close:function(a){return h.close(p,a)},dismiss:function(a){return h.dismiss(p,a)}};if(e=angular.extend({},a.options,e),e.resolve=e.resolve||{},e.appendTo=e.appendTo||d.find("body").eq(0),!e.template&&!e.templateUrl)throw new Error("One of template or templateUrl options is required.");var q,r=c.all([i(e),g.resolve(e.resolve,{},null,null)]);return q=k=c.all([k]).then(j,j).then(function(a){var c=e.scope||b,d=c.$new();d.$close=p.close,d.$dismiss=p.dismiss,d.$on("$destroy",function(){d.$$uibDestructionScheduled||d.$dismiss("$uibUnscheduledDestruction")});var g,i,j={};e.controller&&(j.$scope=d,j.$uibModalInstance=p,angular.forEach(a[1],function(a,b){j[b]=a}),i=f(e.controller,j,!0),e.controllerAs?(g=i.instance,e.bindToController&&(g.$close=d.$close,g.$dismiss=d.$dismiss,angular.extend(g,c)),g=i(),d[e.controllerAs]=g):g=i(),angular.isFunction(g.$onInit)&&g.$onInit()),h.open(p,{scope:d,deferred:l,renderDeferred:o,closedDeferred:n,content:a[0],animation:e.animation,backdrop:e.backdrop,keyboard:e.keyboard,backdropClass:e.backdropClass,windowTopClass:e.windowTopClass,windowClass:e.windowClass,windowTemplateUrl:e.windowTemplateUrl,size:e.size,openedClass:e.openedClass,appendTo:e.appendTo}),m.resolve(!0)},function(a){m.reject(a),l.reject(a)})["finally"](function(){k===q&&(k=null)}),p},j}]};return a}),angular.module("ui.bootstrap.paging",[]).factory("uibPaging",["$parse",function(a){return{create:function(b,c,d){b.setNumPages=d.numPages?a(d.numPages).assign:angular.noop,b.ngModelCtrl={$setViewValue:angular.noop},b._watchers=[],b.init=function(a,e){b.ngModelCtrl=a,b.config=e,a.$render=function(){b.render()},d.itemsPerPage?b._watchers.push(c.$parent.$watch(d.itemsPerPage,function(a){b.itemsPerPage=parseInt(a,10),c.totalPages=b.calculateTotalPages(),b.updatePage()})):b.itemsPerPage=e.itemsPerPage,c.$watch("totalItems",function(a,d){(angular.isDefined(a)||a!==d)&&(c.totalPages=b.calculateTotalPages(),b.updatePage())})},b.calculateTotalPages=function(){var a=b.itemsPerPage<1?1:Math.ceil(c.totalItems/b.itemsPerPage);return Math.max(a||0,1)},b.render=function(){c.page=parseInt(b.ngModelCtrl.$viewValue,10)||1},c.selectPage=function(a,d){d&&d.preventDefault();var e=!c.ngDisabled||!d;e&&c.page!==a&&a>0&&a<=c.totalPages&&(d&&d.target&&d.target.blur(),b.ngModelCtrl.$setViewValue(a),b.ngModelCtrl.$render())},c.getText=function(a){return c[a+"Text"]||b.config[a+"Text"]},c.noPrevious=function(){return 1===c.page},c.noNext=function(){return c.page===c.totalPages},b.updatePage=function(){b.setNumPages(c.$parent,c.totalPages),c.page>c.totalPages?c.selectPage(c.totalPages):b.ngModelCtrl.$render()},c.$on("$destroy",function(){for(;b._watchers.length;)b._watchers.shift()()})}}}]),angular.module("ui.bootstrap.pager",["ui.bootstrap.paging"]).controller("UibPagerController",["$scope","$attrs","uibPaging","uibPagerConfig",function(a,b,c,d){a.align=angular.isDefined(b.align)?a.$parent.$eval(b.align):d.align,c.create(this,a,b)}]).constant("uibPagerConfig",{itemsPerPage:10,previousText:"« Previous",nextText:"Next »",align:!0}).directive("uibPager",["uibPagerConfig",function(a){return{scope:{totalItems:"=",previousText:"@",nextText:"@",ngDisabled:"="},require:["uibPager","?ngModel"],controller:"UibPagerController",controllerAs:"pager",templateUrl:function(a,b){return b.templateUrl||"uib/template/pager/pager.html"},replace:!0,link:function(b,c,d,e){var f=e[0],g=e[1];g&&f.init(g,a)}}}]),angular.module("ui.bootstrap.pagination",["ui.bootstrap.paging"]).controller("UibPaginationController",["$scope","$attrs","$parse","uibPaging","uibPaginationConfig",function(a,b,c,d,e){function f(a,b,c){return{number:a,text:b,active:c}}function g(a,b){
var c=[],d=1,e=b,g=angular.isDefined(i)&&i<b;g&&(j?(d=Math.max(a-Math.floor(i/2),1),e=d+i-1,e>b&&(e=b,d=e-i+1)):(d=(Math.ceil(a/i)-1)*i+1,e=Math.min(d+i-1,b)));for(var h=d;h<=e;h++){var n=f(h,m(h),h===a);c.push(n)}if(g&&i>0&&(!j||k||l)){if(d>1){if(!l||d>3){var o=f(d-1,"...",!1);c.unshift(o)}if(l){if(3===d){var p=f(2,"2",!1);c.unshift(p)}var q=f(1,"1",!1);c.unshift(q)}}if(e<b){if(!l||e<b-2){var r=f(e+1,"...",!1);c.push(r)}if(l){if(e===b-2){var s=f(b-1,b-1,!1);c.push(s)}var t=f(b,b,!1);c.push(t)}}}return c}var h=this,i=angular.isDefined(b.maxSize)?a.$parent.$eval(b.maxSize):e.maxSize,j=angular.isDefined(b.rotate)?a.$parent.$eval(b.rotate):e.rotate,k=angular.isDefined(b.forceEllipses)?a.$parent.$eval(b.forceEllipses):e.forceEllipses,l=angular.isDefined(b.boundaryLinkNumbers)?a.$parent.$eval(b.boundaryLinkNumbers):e.boundaryLinkNumbers,m=angular.isDefined(b.pageLabel)?function(c){return a.$parent.$eval(b.pageLabel,{$page:c})}:angular.identity;a.boundaryLinks=angular.isDefined(b.boundaryLinks)?a.$parent.$eval(b.boundaryLinks):e.boundaryLinks,a.directionLinks=angular.isDefined(b.directionLinks)?a.$parent.$eval(b.directionLinks):e.directionLinks,d.create(this,a,b),b.maxSize&&h._watchers.push(a.$parent.$watch(c(b.maxSize),function(a){i=parseInt(a,10),h.render()}));var n=this.render;this.render=function(){n(),a.page>0&&a.page<=a.totalPages&&(a.pages=g(a.page,a.totalPages))}}]).constant("uibPaginationConfig",{itemsPerPage:10,boundaryLinks:!1,boundaryLinkNumbers:!1,directionLinks:!0,firstText:"First",previousText:"Previous",nextText:"Next",lastText:"Last",rotate:!0,forceEllipses:!1}).directive("uibPagination",["$parse","uibPaginationConfig",function(a,b){return{scope:{totalItems:"=",firstText:"@",previousText:"@",nextText:"@",lastText:"@",ngDisabled:"="},require:["uibPagination","?ngModel"],controller:"UibPaginationController",controllerAs:"pagination",templateUrl:function(a,b){return b.templateUrl||"uib/template/pagination/pagination.html"},replace:!0,link:function(a,c,d,e){var f=e[0],g=e[1];g&&f.init(g,b)}}}]),angular.module("ui.bootstrap.tooltip",["ui.bootstrap.position","ui.bootstrap.stackedMap"]).provider("$uibTooltip",function(){function a(a){var b=/[A-Z]/g,c="-";return a.replace(b,function(a,b){return(b?c:"")+a.toLowerCase()})}var b={placement:"top",placementClassPrefix:"",animation:!0,popupDelay:0,popupCloseDelay:0,useContentExp:!1},c={mouseenter:"mouseleave",click:"click",outsideClick:"outsideClick",focus:"blur",none:""},d={};this.options=function(a){angular.extend(d,a)},this.setTriggers=function(a){angular.extend(c,a)},this.$get=["$window","$compile","$timeout","$document","$uibPosition","$interpolate","$rootScope","$parse","$$stackedMap",function(e,f,g,h,i,j,k,l,m){function n(a){if(27===a.which){var b=o.top();b&&(b.value.close(),o.removeTop(),b=null)}}var o=m.createNew();return h.on("keypress",n),k.$on("$destroy",function(){h.off("keypress",n)}),function(e,k,m,n){function p(a){var b=(a||n.trigger||m).split(" "),d=b.map(function(a){return c[a]||a});return{show:b,hide:d}}n=angular.extend({},b,d,n);var q=a(e),r=j.startSymbol(),s=j.endSymbol(),t="<div "+q+'-popup title="'+r+"title"+s+'" '+(n.useContentExp?'content-exp="contentExp()" ':'content="'+r+"content"+s+'" ')+'placement="'+r+"placement"+s+'" popup-class="'+r+"popupClass"+s+'" animation="animation" is-open="isOpen"origin-scope="origScope" class="uib-position-measure"></div>';return{compile:function(a,b){var c=f(t);return function(a,b,d,f){function j(){N.isOpen?q():m()}function m(){M&&!a.$eval(d[k+"Enable"])||(u(),x(),N.popupDelay?G||(G=g(r,N.popupDelay,!1)):r())}function q(){s(),N.popupCloseDelay?H||(H=g(t,N.popupCloseDelay,!1)):t()}function r(){return s(),u(),N.content?(v(),void N.$evalAsync(function(){N.isOpen=!0,y(!0),S()})):angular.noop}function s(){G&&(g.cancel(G),G=null),I&&(g.cancel(I),I=null)}function t(){N&&N.$evalAsync(function(){N&&(N.isOpen=!1,y(!1),N.animation?F||(F=g(w,150,!1)):w())})}function u(){H&&(g.cancel(H),H=null),F&&(g.cancel(F),F=null)}function v(){D||(E=N.$new(),D=c(E,function(a){K?h.find("body").append(a):b.after(a)}),z())}function w(){s(),u(),A(),D&&(D.remove(),D=null),E&&(E.$destroy(),E=null)}function x(){N.title=d[k+"Title"],Q?N.content=Q(a):N.content=d[e],N.popupClass=d[k+"Class"],N.placement=angular.isDefined(d[k+"Placement"])?d[k+"Placement"]:n.placement;var b=i.parsePlacement(N.placement);J=b[1]?b[0]+"-"+b[1]:b[0];var c=parseInt(d[k+"PopupDelay"],10),f=parseInt(d[k+"PopupCloseDelay"],10);N.popupDelay=isNaN(c)?n.popupDelay:c,N.popupCloseDelay=isNaN(f)?n.popupCloseDelay:f}function y(b){P&&angular.isFunction(P.assign)&&P.assign(a,b)}function z(){R.length=0,Q?(R.push(a.$watch(Q,function(a){N.content=a,!a&&N.isOpen&&t()})),R.push(E.$watch(function(){O||(O=!0,E.$$postDigest(function(){O=!1,N&&N.isOpen&&S()}))}))):R.push(d.$observe(e,function(a){N.content=a,!a&&N.isOpen?t():S()})),R.push(d.$observe(k+"Title",function(a){N.title=a,N.isOpen&&S()})),R.push(d.$observe(k+"Placement",function(a){N.placement=a?a:n.placement;var b=i.parsePlacement(N.placement);J=b[1]?b[0]+"-"+b[1]:b[0],N.isOpen&&S()}))}function A(){R.length&&(angular.forEach(R,function(a){a()}),R.length=0)}function B(a){N&&N.isOpen&&D&&(b[0].contains(a.target)||D[0].contains(a.target)||q())}function C(){var a=d[k+"Trigger"];T(),L=p(a),"none"!==L.show&&L.show.forEach(function(a,c){"outsideClick"===a?(b.on("click",j),h.on("click",B)):a===L.hide[c]?b.on(a,j):a&&(b.on(a,m),b.on(L.hide[c],q)),b.on("keypress",function(a){27===a.which&&q()})})}var D,E,F,G,H,I,J,K=!!angular.isDefined(n.appendToBody)&&n.appendToBody,L=p(void 0),M=angular.isDefined(d[k+"Enable"]),N=a.$new(!0),O=!1,P=!!angular.isDefined(d[k+"IsOpen"])&&l(d[k+"IsOpen"]),Q=!!n.useContentExp&&l(d[e]),R=[],S=function(){D&&D.html()&&(I||(I=g(function(){var a=i.positionElements(b,D,N.placement,K);D.css({top:a.top+"px",left:a.left+"px"}),D.hasClass(a.placement.split("-")[0])||(D.removeClass(J.split("-")[0]),D.addClass(a.placement.split("-")[0])),D.hasClass(n.placementClassPrefix+a.placement)||(D.removeClass(n.placementClassPrefix+J),D.addClass(n.placementClassPrefix+a.placement)),D.hasClass("uib-position-measure")?(i.positionArrow(D,a.placement),D.removeClass("uib-position-measure")):J!==a.placement&&i.positionArrow(D,a.placement),J=a.placement,I=null},0,!1)))};N.origScope=a,N.isOpen=!1,o.add(N,{close:t}),N.contentExp=function(){return N.content},d.$observe("disabled",function(a){a&&s(),a&&N.isOpen&&t()}),P&&a.$watch(P,function(a){N&&!a===N.isOpen&&j()});var T=function(){L.show.forEach(function(a){"outsideClick"===a?b.off("click",j):(b.off(a,m),b.off(a,j))}),L.hide.forEach(function(a){"outsideClick"===a?h.off("click",B):b.off(a,q)})};C();var U=a.$eval(d[k+"Animation"]);N.animation=angular.isDefined(U)?!!U:n.animation;var V,W=k+"AppendToBody";V=W in d&&void 0===d[W]||a.$eval(d[W]),K=angular.isDefined(V)?V:K,a.$on("$destroy",function(){T(),w(),o.remove(N),N=null})}}}}}]}).directive("uibTooltipTemplateTransclude",["$animate","$sce","$compile","$templateRequest",function(a,b,c,d){return{link:function(e,f,g){var h,i,j,k=e.$eval(g.tooltipTemplateTranscludeScope),l=0,m=function(){i&&(i.remove(),i=null),h&&(h.$destroy(),h=null),j&&(a.leave(j).then(function(){i=null}),i=j,j=null)};e.$watch(b.parseAsResourceUrl(g.uibTooltipTemplateTransclude),function(b){var g=++l;b?(d(b,!0).then(function(d){if(g===l){var e=k.$new(),i=d,n=c(i)(e,function(b){m(),a.enter(b,f)});h=e,j=n,h.$emit("$includeContentLoaded",b)}},function(){g===l&&(m(),e.$emit("$includeContentError",b))}),e.$emit("$includeContentRequested",b)):m()}),e.$on("$destroy",m)}}}]).directive("uibTooltipClasses",["$uibPosition",function(a){return{restrict:"A",link:function(b,c,d){if(b.placement){var e=a.parsePlacement(b.placement);c.addClass(e[0])}b.popupClass&&c.addClass(b.popupClass),b.animation()&&c.addClass(d.tooltipAnimationClass)}}}]).directive("uibTooltipPopup",function(){return{replace:!0,scope:{content:"@",placement:"@",popupClass:"@",animation:"&",isOpen:"&"},templateUrl:"uib/template/tooltip/tooltip-popup.html"}}).directive("uibTooltip",["$uibTooltip",function(a){return a("uibTooltip","tooltip","mouseenter")}]).directive("uibTooltipTemplatePopup",function(){return{replace:!0,scope:{contentExp:"&",placement:"@",popupClass:"@",animation:"&",isOpen:"&",originScope:"&"},templateUrl:"uib/template/tooltip/tooltip-template-popup.html"}}).directive("uibTooltipTemplate",["$uibTooltip",function(a){return a("uibTooltipTemplate","tooltip","mouseenter",{useContentExp:!0})}]).directive("uibTooltipHtmlPopup",function(){return{replace:!0,scope:{contentExp:"&",placement:"@",popupClass:"@",animation:"&",isOpen:"&"},templateUrl:"uib/template/tooltip/tooltip-html-popup.html"}}).directive("uibTooltipHtml",["$uibTooltip",function(a){return a("uibTooltipHtml","tooltip","mouseenter",{useContentExp:!0})}]),angular.module("ui.bootstrap.popover",["ui.bootstrap.tooltip"]).directive("uibPopoverTemplatePopup",function(){return{replace:!0,scope:{title:"@",contentExp:"&",placement:"@",popupClass:"@",animation:"&",isOpen:"&",originScope:"&"},templateUrl:"uib/template/popover/popover-template.html"}}).directive("uibPopoverTemplate",["$uibTooltip",function(a){return a("uibPopoverTemplate","popover","click",{useContentExp:!0})}]).directive("uibPopoverHtmlPopup",function(){return{replace:!0,scope:{contentExp:"&",title:"@",placement:"@",popupClass:"@",animation:"&",isOpen:"&"},templateUrl:"uib/template/popover/popover-html.html"}}).directive("uibPopoverHtml",["$uibTooltip",function(a){return a("uibPopoverHtml","popover","click",{useContentExp:!0})}]).directive("uibPopoverPopup",function(){return{replace:!0,scope:{title:"@",content:"@",placement:"@",popupClass:"@",animation:"&",isOpen:"&"},templateUrl:"uib/template/popover/popover.html"}}).directive("uibPopover",["$uibTooltip",function(a){return a("uibPopover","popover","click")}]),angular.module("ui.bootstrap.progressbar",[]).constant("uibProgressConfig",{animate:!0,max:100}).controller("UibProgressController",["$scope","$attrs","uibProgressConfig",function(a,b,c){function d(){return angular.isDefined(a.maxParam)?a.maxParam:c.max}var e=this,f=angular.isDefined(b.animate)?a.$parent.$eval(b.animate):c.animate;this.bars=[],a.max=d(),this.addBar=function(a,b,c){f||b.css({transition:"none"}),this.bars.push(a),a.max=d(),a.title=c&&angular.isDefined(c.title)?c.title:"progressbar",a.$watch("value",function(b){a.recalculatePercentage()}),a.recalculatePercentage=function(){var b=e.bars.reduce(function(a,b){return b.percent=+(100*b.value/b.max).toFixed(2),a+b.percent},0);b>100&&(a.percent-=b-100)},a.$on("$destroy",function(){b=null,e.removeBar(a)})},this.removeBar=function(a){this.bars.splice(this.bars.indexOf(a),1),this.bars.forEach(function(a){a.recalculatePercentage()})},a.$watch("maxParam",function(a){e.bars.forEach(function(a){a.max=d(),a.recalculatePercentage()})})}]).directive("uibProgress",function(){return{replace:!0,transclude:!0,controller:"UibProgressController",require:"uibProgress",scope:{maxParam:"=?max"},templateUrl:"uib/template/progressbar/progress.html"}}).directive("uibBar",function(){return{replace:!0,transclude:!0,require:"^uibProgress",scope:{value:"=",type:"@"},templateUrl:"uib/template/progressbar/bar.html",link:function(a,b,c,d){d.addBar(a,b,c)}}}).directive("uibProgressbar",function(){return{replace:!0,transclude:!0,controller:"UibProgressController",scope:{value:"=",maxParam:"=?max",type:"@"},templateUrl:"uib/template/progressbar/progressbar.html",link:function(a,b,c,d){d.addBar(a,angular.element(b.children()[0]),{title:c.title})}}}),angular.module("ui.bootstrap.rating",[]).constant("uibRatingConfig",{max:5,stateOn:null,stateOff:null,enableReset:!0,titles:["one","two","three","four","five"]}).controller("UibRatingController",["$scope","$attrs","uibRatingConfig",function(a,b,c){var d={$setViewValue:angular.noop},e=this;this.init=function(e){d=e,d.$render=this.render,d.$formatters.push(function(a){return angular.isNumber(a)&&a<<0!==a&&(a=Math.round(a)),a}),this.stateOn=angular.isDefined(b.stateOn)?a.$parent.$eval(b.stateOn):c.stateOn,this.stateOff=angular.isDefined(b.stateOff)?a.$parent.$eval(b.stateOff):c.stateOff,this.enableReset=angular.isDefined(b.enableReset)?a.$parent.$eval(b.enableReset):c.enableReset;var f=angular.isDefined(b.titles)?a.$parent.$eval(b.titles):c.titles;this.titles=angular.isArray(f)&&f.length>0?f:c.titles;var g=angular.isDefined(b.ratingStates)?a.$parent.$eval(b.ratingStates):new Array(angular.isDefined(b.max)?a.$parent.$eval(b.max):c.max);a.range=this.buildTemplateObjects(g)},this.buildTemplateObjects=function(a){for(var b=0,c=a.length;b<c;b++)a[b]=angular.extend({index:b},{stateOn:this.stateOn,stateOff:this.stateOff,title:this.getTitle(b)},a[b]);return a},this.getTitle=function(a){return a>=this.titles.length?a+1:this.titles[a]},a.rate=function(b){if(!a.readonly&&b>=0&&b<=a.range.length){var c=e.enableReset&&d.$viewValue===b?0:b;d.$setViewValue(c),d.$render()}},a.enter=function(b){a.readonly||(a.value=b),a.onHover({value:b})},a.reset=function(){a.value=d.$viewValue,a.onLeave()},a.onKeydown=function(b){/(37|38|39|40)/.test(b.which)&&(b.preventDefault(),b.stopPropagation(),a.rate(a.value+(38===b.which||39===b.which?1:-1)))},this.render=function(){a.value=d.$viewValue,a.title=e.getTitle(a.value-1)}}]).directive("uibRating",function(){return{require:["uibRating","ngModel"],scope:{readonly:"=?readOnly",onHover:"&",onLeave:"&"},controller:"UibRatingController",templateUrl:"uib/template/rating/rating.html",replace:!0,link:function(a,b,c,d){var e=d[0],f=d[1];e.init(f)}}}),angular.module("ui.bootstrap.tabs",[]).controller("UibTabsetController",["$scope",function(a){function b(a){for(var b=0;b<d.tabs.length;b++)if(d.tabs[b].index===a)return b}var c,d=this;d.tabs=[],d.select=function(a,f){if(!e){var g=b(c),h=d.tabs[g];if(h){if(h.tab.onDeselect({$event:f}),f&&f.isDefaultPrevented())return;h.tab.active=!1}var i=d.tabs[a];i?(i.tab.onSelect({$event:f}),i.tab.active=!0,d.active=i.index,c=i.index):!i&&angular.isNumber(c)&&(d.active=null,c=null)}},d.addTab=function(a){if(d.tabs.push({tab:a,index:a.index}),d.tabs.sort(function(a,b){return a.index>b.index?1:a.index<b.index?-1:0}),a.index===d.active||!angular.isNumber(d.active)&&1===d.tabs.length){var c=b(a.index);d.select(c)}},d.removeTab=function(a){var c=b(a.index);if(a.index===d.active){var e=c===d.tabs.length-1?c-1:c+1%d.tabs.length;d.select(e)}d.tabs.splice(c,1)},a.$watch("tabset.active",function(a){angular.isNumber(a)&&a!==c&&d.select(b(a))});var e;a.$on("$destroy",function(){e=!0})}]).directive("uibTabset",function(){return{transclude:!0,replace:!0,scope:{},bindToController:{active:"=?",type:"@"},controller:"UibTabsetController",controllerAs:"tabset",templateUrl:function(a,b){return b.templateUrl||"uib/template/tabs/tabset.html"},link:function(a,b,c){a.vertical=!!angular.isDefined(c.vertical)&&a.$parent.$eval(c.vertical),a.justified=!!angular.isDefined(c.justified)&&a.$parent.$eval(c.justified),angular.isUndefined(c.active)&&(a.active=0)}}}).directive("uibTab",["$parse",function(a){return{require:"^uibTabset",replace:!0,templateUrl:function(a,b){return b.templateUrl||"uib/template/tabs/tab.html"},transclude:!0,scope:{heading:"@",index:"=?",classes:"@?",onSelect:"&select",onDeselect:"&deselect"},controller:function(){},controllerAs:"tab",link:function(b,c,d,e,f){b.disabled=!1,d.disable&&b.$parent.$watch(a(d.disable),function(a){b.disabled=!!a}),angular.isUndefined(d.index)&&(e.tabs&&e.tabs.length?b.index=Math.max.apply(null,e.tabs.map(function(a){return a.index}))+1:b.index=0),angular.isUndefined(d.classes)&&(b.classes=""),b.select=function(a){if(!b.disabled){for(var c,d=0;d<e.tabs.length;d++)if(e.tabs[d].tab===b){c=d;break}e.select(c,a)}},e.addTab(b),b.$on("$destroy",function(){e.removeTab(b)}),b.$transcludeFn=f}}}]).directive("uibTabHeadingTransclude",function(){return{restrict:"A",require:"^uibTab",link:function(a,b){a.$watch("headingElement",function(a){a&&(b.html(""),b.append(a))})}}}).directive("uibTabContentTransclude",function(){function a(a){return a.tagName&&(a.hasAttribute("uib-tab-heading")||a.hasAttribute("data-uib-tab-heading")||a.hasAttribute("x-uib-tab-heading")||"uib-tab-heading"===a.tagName.toLowerCase()||"data-uib-tab-heading"===a.tagName.toLowerCase()||"x-uib-tab-heading"===a.tagName.toLowerCase()||"uib:tab-heading"===a.tagName.toLowerCase())}return{restrict:"A",require:"^uibTabset",link:function(b,c,d){var e=b.$eval(d.uibTabContentTransclude).tab;e.$transcludeFn(e.$parent,function(b){angular.forEach(b,function(b){a(b)?e.headingElement=b:c.append(b)})})}}}),angular.module("ui.bootstrap.timepicker",[]).constant("uibTimepickerConfig",{hourStep:1,minuteStep:1,secondStep:1,showMeridian:!0,showSeconds:!1,meridians:null,readonlyInput:!1,mousewheel:!0,arrowkeys:!0,showSpinners:!0,templateUrl:"uib/template/timepicker/timepicker.html"}).controller("UibTimepickerController",["$scope","$element","$attrs","$parse","$log","$locale","uibTimepickerConfig",function(a,b,c,d,e,f,g){function h(){var b=+a.hours,c=a.showMeridian?b>0&&b<13:b>=0&&b<24;if(c)return a.showMeridian&&(12===b&&(b=0),a.meridian===u[1]&&(b+=12)),b}function i(){var b=+a.minutes;return b>=0&&b<60?b:void 0}function j(){var b=+a.seconds;return b>=0&&b<60?b:void 0}function k(a,b){return null===a?"":angular.isDefined(a)&&a.toString().length<2&&!b?"0"+a:a.toString()}function l(a){m(),t.$setViewValue(new Date(r)),n(a)}function m(){t.$setValidity("time",!0),a.invalidHours=!1,a.invalidMinutes=!1,a.invalidSeconds=!1}function n(b){if(t.$modelValue){var c=r.getHours(),d=r.getMinutes(),e=r.getSeconds();a.showMeridian&&(c=0===c||12===c?12:c%12),a.hours="h"===b?c:k(c,!v),"m"!==b&&(a.minutes=k(d)),a.meridian=r.getHours()<12?u[0]:u[1],"s"!==b&&(a.seconds=k(e)),a.meridian=r.getHours()<12?u[0]:u[1]}else a.hours=null,a.minutes=null,a.seconds=null,a.meridian=u[0]}function o(a){r=q(r,a),l()}function p(a,b){return q(a,60*b)}function q(a,b){var c=new Date(a.getTime()+1e3*b),d=new Date(a);return d.setHours(c.getHours(),c.getMinutes(),c.getSeconds()),d}var r=new Date,s=[],t={$setViewValue:angular.noop},u=angular.isDefined(c.meridians)?a.$parent.$eval(c.meridians):g.meridians||f.DATETIME_FORMATS.AMPMS,v=!angular.isDefined(c.padHours)||a.$parent.$eval(c.padHours);a.tabindex=angular.isDefined(c.tabindex)?c.tabindex:0,b.removeAttr("tabindex"),this.init=function(b,d){t=b,t.$render=this.render,t.$formatters.unshift(function(a){return a?new Date(a):null});var e=d.eq(0),f=d.eq(1),h=d.eq(2),i=angular.isDefined(c.mousewheel)?a.$parent.$eval(c.mousewheel):g.mousewheel;i&&this.setupMousewheelEvents(e,f,h);var j=angular.isDefined(c.arrowkeys)?a.$parent.$eval(c.arrowkeys):g.arrowkeys;j&&this.setupArrowkeyEvents(e,f,h),a.readonlyInput=angular.isDefined(c.readonlyInput)?a.$parent.$eval(c.readonlyInput):g.readonlyInput,this.setupInputEvents(e,f,h)};var w=g.hourStep;c.hourStep&&s.push(a.$parent.$watch(d(c.hourStep),function(a){w=+a}));var x=g.minuteStep;c.minuteStep&&s.push(a.$parent.$watch(d(c.minuteStep),function(a){x=+a}));var y;s.push(a.$parent.$watch(d(c.min),function(a){var b=new Date(a);y=isNaN(b)?void 0:b}));var z;s.push(a.$parent.$watch(d(c.max),function(a){var b=new Date(a);z=isNaN(b)?void 0:b}));var A=!1;c.ngDisabled&&s.push(a.$parent.$watch(d(c.ngDisabled),function(a){A=a})),a.noIncrementHours=function(){var a=p(r,60*w);return A||a>z||a<r&&a<y},a.noDecrementHours=function(){var a=p(r,60*-w);return A||a<y||a>r&&a>z},a.noIncrementMinutes=function(){var a=p(r,x);return A||a>z||a<r&&a<y},a.noDecrementMinutes=function(){var a=p(r,-x);return A||a<y||a>r&&a>z},a.noIncrementSeconds=function(){var a=q(r,B);return A||a>z||a<r&&a<y},a.noDecrementSeconds=function(){var a=q(r,-B);return A||a<y||a>r&&a>z},a.noToggleMeridian=function(){return r.getHours()<12?A||p(r,720)>z:A||p(r,-720)<y};var B=g.secondStep;c.secondStep&&s.push(a.$parent.$watch(d(c.secondStep),function(a){B=+a})),a.showSeconds=g.showSeconds,c.showSeconds&&s.push(a.$parent.$watch(d(c.showSeconds),function(b){a.showSeconds=!!b})),a.showMeridian=g.showMeridian,c.showMeridian&&s.push(a.$parent.$watch(d(c.showMeridian),function(b){if(a.showMeridian=!!b,t.$error.time){var c=h(),d=i();angular.isDefined(c)&&angular.isDefined(d)&&(r.setHours(c),l())}else n()})),this.setupMousewheelEvents=function(b,c,d){var e=function(a){a.originalEvent&&(a=a.originalEvent);var b=a.wheelDelta?a.wheelDelta:-a.deltaY;return a.detail||b>0};b.bind("mousewheel wheel",function(b){A||a.$apply(e(b)?a.incrementHours():a.decrementHours()),b.preventDefault()}),c.bind("mousewheel wheel",function(b){A||a.$apply(e(b)?a.incrementMinutes():a.decrementMinutes()),b.preventDefault()}),d.bind("mousewheel wheel",function(b){A||a.$apply(e(b)?a.incrementSeconds():a.decrementSeconds()),b.preventDefault()})},this.setupArrowkeyEvents=function(b,c,d){b.bind("keydown",function(b){A||(38===b.which?(b.preventDefault(),a.incrementHours(),a.$apply()):40===b.which&&(b.preventDefault(),a.decrementHours(),a.$apply()))}),c.bind("keydown",function(b){A||(38===b.which?(b.preventDefault(),a.incrementMinutes(),a.$apply()):40===b.which&&(b.preventDefault(),a.decrementMinutes(),a.$apply()))}),d.bind("keydown",function(b){A||(38===b.which?(b.preventDefault(),a.incrementSeconds(),a.$apply()):40===b.which&&(b.preventDefault(),a.decrementSeconds(),a.$apply()))})},this.setupInputEvents=function(b,c,d){if(a.readonlyInput)return a.updateHours=angular.noop,a.updateMinutes=angular.noop,void(a.updateSeconds=angular.noop);var e=function(b,c,d){t.$setViewValue(null),t.$setValidity("time",!1),angular.isDefined(b)&&(a.invalidHours=b),angular.isDefined(c)&&(a.invalidMinutes=c),angular.isDefined(d)&&(a.invalidSeconds=d)};a.updateHours=function(){var a=h(),b=i();t.$setDirty(),angular.isDefined(a)&&angular.isDefined(b)?(r.setHours(a),r.setMinutes(b),r<y||r>z?e(!0):l("h")):e(!0)},b.bind("blur",function(b){t.$setTouched(),null===a.hours||""===a.hours?e(!0):!a.invalidHours&&a.hours<10&&a.$apply(function(){a.hours=k(a.hours,!v)})}),a.updateMinutes=function(){var a=i(),b=h();t.$setDirty(),angular.isDefined(a)&&angular.isDefined(b)?(r.setHours(b),r.setMinutes(a),r<y||r>z?e(void 0,!0):l("m")):e(void 0,!0)},c.bind("blur",function(b){t.$setTouched(),null===a.minutes?e(void 0,!0):!a.invalidMinutes&&a.minutes<10&&a.$apply(function(){a.minutes=k(a.minutes)})}),a.updateSeconds=function(){var a=j();t.$setDirty(),angular.isDefined(a)?(r.setSeconds(a),l("s")):e(void 0,void 0,!0)},d.bind("blur",function(b){!a.invalidSeconds&&a.seconds<10&&a.$apply(function(){a.seconds=k(a.seconds)})})},this.render=function(){var b=t.$viewValue;isNaN(b)?(t.$setValidity("time",!1),e.error('Timepicker directive: "ng-model" value must be a Date object, a number of milliseconds since 01.01.1970 or a string representing an RFC2822 or ISO 8601 date.')):(b&&(r=b),r<y||r>z?(t.$setValidity("time",!1),a.invalidHours=!0,a.invalidMinutes=!0):m(),n())},a.showSpinners=angular.isDefined(c.showSpinners)?a.$parent.$eval(c.showSpinners):g.showSpinners,a.incrementHours=function(){a.noIncrementHours()||o(60*w*60)},a.decrementHours=function(){a.noDecrementHours()||o(60*-w*60)},a.incrementMinutes=function(){a.noIncrementMinutes()||o(60*x)},a.decrementMinutes=function(){a.noDecrementMinutes()||o(60*-x)},a.incrementSeconds=function(){a.noIncrementSeconds()||o(B)},a.decrementSeconds=function(){a.noDecrementSeconds()||o(-B)},a.toggleMeridian=function(){var b=i(),c=h();a.noToggleMeridian()||(angular.isDefined(b)&&angular.isDefined(c)?o(720*(r.getHours()<12?60:-60)):a.meridian=a.meridian===u[0]?u[1]:u[0])},a.blur=function(){t.$setTouched()},a.$on("$destroy",function(){for(;s.length;)s.shift()()})}]).directive("uibTimepicker",["uibTimepickerConfig",function(a){return{require:["uibTimepicker","?^ngModel"],controller:"UibTimepickerController",controllerAs:"timepicker",replace:!0,scope:{},templateUrl:function(b,c){return c.templateUrl||a.templateUrl},link:function(a,b,c,d){var e=d[0],f=d[1];f&&e.init(f,b.find("input"))}}}]),angular.module("ui.bootstrap.typeahead",["ui.bootstrap.debounce","ui.bootstrap.position"]).factory("uibTypeaheadParser",["$parse",function(a){var b=/^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w\d]*))\s+in\s+([\s\S]+?)$/;return{parse:function(c){var d=c.match(b);if(!d)throw new Error('Expected typeahead specification in form of "_modelValue_ (as _label_)? for _item_ in _collection_" but got "'+c+'".');return{itemName:d[3],source:a(d[4]),viewMapper:a(d[2]||d[1]),modelMapper:a(d[1])}}}}]).controller("UibTypeaheadController",["$scope","$element","$attrs","$compile","$parse","$q","$timeout","$document","$window","$rootScope","$$debounce","$uibPosition","uibTypeaheadParser",function(a,b,c,d,e,f,g,h,i,j,k,l,m){function n(){N.moveInProgress||(N.moveInProgress=!0,N.$digest()),Y()}function o(){N.position=D?l.offset(b):l.position(b),N.position.top+=b.prop("offsetHeight")}var p,q,r=[9,13,27,38,40],s=200,t=a.$eval(c.typeaheadMinLength);t||0===t||(t=1),a.$watch(c.typeaheadMinLength,function(a){t=a||0===a?a:1});var u=a.$eval(c.typeaheadWaitMs)||0,v=a.$eval(c.typeaheadEditable)!==!1;a.$watch(c.typeaheadEditable,function(a){v=a!==!1});var w,x,y=e(c.typeaheadLoading).assign||angular.noop,z=e(c.typeaheadOnSelect),A=!!angular.isDefined(c.typeaheadSelectOnBlur)&&a.$eval(c.typeaheadSelectOnBlur),B=e(c.typeaheadNoResults).assign||angular.noop,C=c.typeaheadInputFormatter?e(c.typeaheadInputFormatter):void 0,D=!!c.typeaheadAppendToBody&&a.$eval(c.typeaheadAppendToBody),E=c.typeaheadAppendTo?a.$eval(c.typeaheadAppendTo):null,F=a.$eval(c.typeaheadFocusFirst)!==!1,G=!!c.typeaheadSelectOnExact&&a.$eval(c.typeaheadSelectOnExact),H=e(c.typeaheadIsOpen).assign||angular.noop,I=a.$eval(c.typeaheadShowHint)||!1,J=e(c.ngModel),K=e(c.ngModel+"($$$p)"),L=function(b,c){return angular.isFunction(J(a))&&q&&q.$options&&q.$options.getterSetter?K(b,{$$$p:c}):J.assign(b,c)},M=m.parse(c.uibTypeahead),N=a.$new(),O=a.$on("$destroy",function(){N.$destroy()});N.$on("$destroy",O);var P="typeahead-"+N.$id+"-"+Math.floor(1e4*Math.random());b.attr({"aria-autocomplete":"list","aria-expanded":!1,"aria-owns":P});var Q,R;I&&(Q=angular.element("<div></div>"),Q.css("position","relative"),b.after(Q),R=b.clone(),R.attr("placeholder",""),R.attr("tabindex","-1"),R.val(""),R.css({position:"absolute",top:"0px",left:"0px","border-color":"transparent","box-shadow":"none",opacity:1,background:"none 0% 0% / auto repeat scroll padding-box border-box rgb(255, 255, 255)",color:"#999"}),b.css({position:"relative","vertical-align":"top","background-color":"transparent"}),Q.append(R),R.after(b));var S=angular.element("<div uib-typeahead-popup></div>");S.attr({id:P,matches:"matches",active:"activeIdx",select:"select(activeIdx, evt)","move-in-progress":"moveInProgress",query:"query",position:"position","assign-is-open":"assignIsOpen(isOpen)",debounce:"debounceUpdate"}),angular.isDefined(c.typeaheadTemplateUrl)&&S.attr("template-url",c.typeaheadTemplateUrl),angular.isDefined(c.typeaheadPopupTemplateUrl)&&S.attr("popup-template-url",c.typeaheadPopupTemplateUrl);var T=function(){I&&R.val("")},U=function(){N.matches=[],N.activeIdx=-1,b.attr("aria-expanded",!1),T()},V=function(a){return P+"-option-"+a};N.$watch("activeIdx",function(a){a<0?b.removeAttr("aria-activedescendant"):b.attr("aria-activedescendant",V(a))});var W=function(a,b){return!!(N.matches.length>b&&a)&&a.toUpperCase()===N.matches[b].label.toUpperCase()},X=function(c,d){var e={$viewValue:c};y(a,!0),B(a,!1),f.when(M.source(a,e)).then(function(f){var g=c===p.$viewValue;if(g&&w)if(f&&f.length>0){N.activeIdx=F?0:-1,B(a,!1),N.matches.length=0;for(var h=0;h<f.length;h++)e[M.itemName]=f[h],N.matches.push({id:V(h),label:M.viewMapper(N,e),model:f[h]});if(N.query=c,o(),b.attr("aria-expanded",!0),G&&1===N.matches.length&&W(c,0)&&(angular.isNumber(N.debounceUpdate)||angular.isObject(N.debounceUpdate)?k(function(){N.select(0,d)},angular.isNumber(N.debounceUpdate)?N.debounceUpdate:N.debounceUpdate["default"]):N.select(0,d)),I){var i=N.matches[0].label;angular.isString(c)&&c.length>0&&i.slice(0,c.length).toUpperCase()===c.toUpperCase()?R.val(c+i.slice(c.length)):R.val("")}}else U(),B(a,!0);g&&y(a,!1)},function(){U(),y(a,!1),B(a,!0)})};D&&(angular.element(i).on("resize",n),h.find("body").on("scroll",n));var Y=k(function(){N.matches.length&&o(),N.moveInProgress=!1},s);N.moveInProgress=!1,N.query=void 0;var Z,$=function(a){Z=g(function(){X(a)},u)},_=function(){Z&&g.cancel(Z)};U(),N.assignIsOpen=function(b){H(a,b)},N.select=function(d,e){var f,h,i={};x=!0,i[M.itemName]=h=N.matches[d].model,f=M.modelMapper(a,i),L(a,f),p.$setValidity("editable",!0),p.$setValidity("parse",!0),z(a,{$item:h,$model:f,$label:M.viewMapper(a,i),$event:e}),U(),N.$eval(c.typeaheadFocusOnSelect)!==!1&&g(function(){b[0].focus()},0,!1)},b.on("keydown",function(b){if(0!==N.matches.length&&r.indexOf(b.which)!==-1){if(N.activeIdx===-1&&(9===b.which||13===b.which)||9===b.which&&b.shiftKey)return U(),void N.$digest();b.preventDefault();var c;switch(b.which){case 9:case 13:N.$apply(function(){angular.isNumber(N.debounceUpdate)||angular.isObject(N.debounceUpdate)?k(function(){N.select(N.activeIdx,b)},angular.isNumber(N.debounceUpdate)?N.debounceUpdate:N.debounceUpdate["default"]):N.select(N.activeIdx,b)});break;case 27:b.stopPropagation(),U(),a.$digest();break;case 38:N.activeIdx=(N.activeIdx>0?N.activeIdx:N.matches.length)-1,N.$digest(),c=S.find("li")[N.activeIdx],c.parentNode.scrollTop=c.offsetTop;break;case 40:N.activeIdx=(N.activeIdx+1)%N.matches.length,N.$digest(),c=S.find("li")[N.activeIdx],c.parentNode.scrollTop=c.offsetTop}}}),b.bind("focus",function(a){w=!0,0!==t||p.$viewValue||g(function(){X(p.$viewValue,a)},0)}),b.bind("blur",function(a){A&&N.matches.length&&N.activeIdx!==-1&&!x&&(x=!0,N.$apply(function(){angular.isObject(N.debounceUpdate)&&angular.isNumber(N.debounceUpdate.blur)?k(function(){N.select(N.activeIdx,a)},N.debounceUpdate.blur):N.select(N.activeIdx,a)})),!v&&p.$error.editable&&(p.$viewValue="",p.$setValidity("editable",!0),p.$setValidity("parse",!0),b.val("")),w=!1,x=!1});var aa=function(c){b[0]!==c.target&&3!==c.which&&0!==N.matches.length&&(U(),j.$$phase||a.$digest())};h.on("click",aa),a.$on("$destroy",function(){h.off("click",aa),(D||E)&&ba.remove(),D&&(angular.element(i).off("resize",n),h.find("body").off("scroll",n)),S.remove(),I&&Q.remove()});var ba=d(S)(N);D?h.find("body").append(ba):E?angular.element(E).eq(0).append(ba):b.after(ba),this.init=function(b,c){p=b,q=c,N.debounceUpdate=p.$options&&e(p.$options.debounce)(a),p.$parsers.unshift(function(b){return w=!0,0===t||b&&b.length>=t?u>0?(_(),$(b)):X(b):(y(a,!1),_(),U()),v?b:b?void p.$setValidity("editable",!1):(p.$setValidity("editable",!0),null)}),p.$formatters.push(function(b){var c,d,e={};return v||p.$setValidity("editable",!0),C?(e.$model=b,C(a,e)):(e[M.itemName]=b,c=M.viewMapper(a,e),e[M.itemName]=void 0,d=M.viewMapper(a,e),c!==d?c:b)})}}]).directive("uibTypeahead",function(){return{controller:"UibTypeaheadController",require:["ngModel","^?ngModelOptions","uibTypeahead"],link:function(a,b,c,d){d[2].init(d[0],d[1])}}}).directive("uibTypeaheadPopup",["$$debounce",function(a){return{scope:{matches:"=",query:"=",active:"=",position:"&",moveInProgress:"=",select:"&",assignIsOpen:"&",debounce:"&"},replace:!0,templateUrl:function(a,b){return b.popupTemplateUrl||"uib/template/typeahead/typeahead-popup.html"},link:function(b,c,d){b.templateUrl=d.templateUrl,b.isOpen=function(){var a=b.matches.length>0;return b.assignIsOpen({isOpen:a}),a},b.isActive=function(a){return b.active===a},b.selectActive=function(a){b.active=a},b.selectMatch=function(c,d){var e=b.debounce();angular.isNumber(e)||angular.isObject(e)?a(function(){b.select({activeIdx:c,evt:d})},angular.isNumber(e)?e:e["default"]):b.select({activeIdx:c,evt:d})}}}}]).directive("uibTypeaheadMatch",["$templateRequest","$compile","$parse",function(a,b,c){return{scope:{index:"=",match:"=",query:"="},link:function(d,e,f){var g=c(f.templateUrl)(d.$parent)||"uib/template/typeahead/typeahead-match.html";a(g).then(function(a){var c=angular.element(a.trim());e.replaceWith(c),b(c)(d)})}}}]).filter("uibTypeaheadHighlight",["$sce","$injector","$log",function(a,b,c){
function d(a){return a.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1")}function e(a){return/<.*>/g.test(a)}var f;return f=b.has("$sanitize"),function(b,g){return!f&&e(b)&&c.warn("Unsafe use of typeahead please use ngSanitize"),b=g?(""+b).replace(new RegExp(d(g),"gi"),"<strong>$&</strong>"):b,f||(b=a.trustAsHtml(b)),b}}]),angular.module("uib/template/accordion/accordion-group.html",[]).run(["$templateCache",function(a){a.put("uib/template/accordion/accordion-group.html",'<div class="panel" ng-class="panelClass || \'panel-default\'">\n  <div role="tab" id="{{::headingId}}" aria-selected="{{isOpen}}" class="panel-heading" ng-keypress="toggleOpen($event)">\n    <h4 class="panel-title">\n      <a role="button" data-toggle="collapse" href aria-expanded="{{isOpen}}" aria-controls="{{::panelId}}" tabindex="0" class="accordion-toggle" ng-click="toggleOpen()" uib-accordion-transclude="heading"><span uib-accordion-header ng-class="{\'text-muted\': isDisabled}">{{heading}}</span></a>\n    </h4>\n  </div>\n  <div id="{{::panelId}}" aria-labelledby="{{::headingId}}" aria-hidden="{{!isOpen}}" role="tabpanel" class="panel-collapse collapse" uib-collapse="!isOpen">\n    <div class="panel-body" ng-transclude></div>\n  </div>\n</div>\n')}]),angular.module("uib/template/accordion/accordion.html",[]).run(["$templateCache",function(a){a.put("uib/template/accordion/accordion.html",'<div role="tablist" class="panel-group" ng-transclude></div>')}]),angular.module("uib/template/alert/alert.html",[]).run(["$templateCache",function(a){a.put("uib/template/alert/alert.html",'<div class="alert" ng-class="[\'alert-\' + (type || \'warning\'), closeable ? \'alert-dismissible\' : null]" role="alert">\n    <button ng-show="closeable" type="button" class="close" ng-click="close({$event: $event})">\n        <span aria-hidden="true">&times;</span>\n        <span class="sr-only">Close</span>\n    </button>\n    <div ng-transclude></div>\n</div>\n')}]),angular.module("uib/template/carousel/carousel.html",[]).run(["$templateCache",function(a){a.put("uib/template/carousel/carousel.html",'<div ng-mouseenter="pause()" ng-mouseleave="play()" class="carousel" ng-swipe-right="prev()" ng-swipe-left="next()">\n  <div class="carousel-inner" ng-transclude></div>\n  <a role="button" href class="left carousel-control" ng-click="prev()" ng-show="slides.length > 1">\n    <span aria-hidden="true" class="glyphicon glyphicon-chevron-left"></span>\n    <span class="sr-only">previous</span>\n  </a>\n  <a role="button" href class="right carousel-control" ng-click="next()" ng-show="slides.length > 1">\n    <span aria-hidden="true" class="glyphicon glyphicon-chevron-right"></span>\n    <span class="sr-only">next</span>\n  </a>\n  <ol class="carousel-indicators" ng-show="slides.length > 1">\n    <li ng-repeat="slide in slides | orderBy:indexOfSlide track by $index" ng-class="{ active: isActive(slide) }" ng-click="select(slide)">\n      <span class="sr-only">slide {{ $index + 1 }} of {{ slides.length }}<span ng-if="isActive(slide)">, currently active</span></span>\n    </li>\n  </ol>\n</div>\n')}]),angular.module("uib/template/carousel/slide.html",[]).run(["$templateCache",function(a){a.put("uib/template/carousel/slide.html",'<div ng-class="{\n    \'active\': active\n  }" class="item text-center" ng-transclude></div>\n')}]),angular.module("uib/template/datepicker/datepicker.html",[]).run(["$templateCache",function(a){a.put("uib/template/datepicker/datepicker.html",'<div class="uib-datepicker" ng-switch="datepickerMode" role="application" ng-keydown="keydown($event)">\n  <uib-daypicker ng-switch-when="day" tabindex="0"></uib-daypicker>\n  <uib-monthpicker ng-switch-when="month" tabindex="0"></uib-monthpicker>\n  <uib-yearpicker ng-switch-when="year" tabindex="0"></uib-yearpicker>\n</div>\n')}]),angular.module("uib/template/datepicker/day.html",[]).run(["$templateCache",function(a){a.put("uib/template/datepicker/day.html",'<table class="uib-daypicker" role="grid" aria-labelledby="{{::uniqueId}}-title" aria-activedescendant="{{activeDateId}}">\n  <thead>\n    <tr>\n      <th><button type="button" class="btn btn-default btn-sm pull-left uib-left" ng-click="move(-1)" tabindex="-1"><i class="glyphicon glyphicon-chevron-left"></i></button></th>\n      <th colspan="{{::5 + showWeeks}}"><button id="{{::uniqueId}}-title" role="heading" aria-live="assertive" aria-atomic="true" type="button" class="btn btn-default btn-sm uib-title" ng-click="toggleMode()" ng-disabled="datepickerMode === maxMode" tabindex="-1"><strong>{{title}}</strong></button></th>\n      <th><button type="button" class="btn btn-default btn-sm pull-right uib-right" ng-click="move(1)" tabindex="-1"><i class="glyphicon glyphicon-chevron-right"></i></button></th>\n    </tr>\n    <tr>\n      <th ng-if="showWeeks" class="text-center"></th>\n      <th ng-repeat="label in ::labels track by $index" class="text-center"><small aria-label="{{::label.full}}">{{::label.abbr}}</small></th>\n    </tr>\n  </thead>\n  <tbody>\n    <tr class="uib-weeks" ng-repeat="row in rows track by $index">\n      <td ng-if="showWeeks" class="text-center h6"><em>{{ weekNumbers[$index] }}</em></td>\n      <td ng-repeat="dt in row" class="uib-day text-center" role="gridcell"\n        id="{{::dt.uid}}"\n        ng-class="::dt.customClass">\n        <button type="button" class="btn btn-default btn-sm"\n          uib-is-class="\n            \'btn-info\' for selectedDt,\n            \'active\' for activeDt\n            on dt"\n          ng-click="select(dt.date)"\n          ng-disabled="::dt.disabled"\n          tabindex="-1"><span ng-class="::{\'text-muted\': dt.secondary, \'text-info\': dt.current}">{{::dt.label}}</span></button>\n      </td>\n    </tr>\n  </tbody>\n</table>\n')}]),angular.module("uib/template/datepicker/month.html",[]).run(["$templateCache",function(a){a.put("uib/template/datepicker/month.html",'<table class="uib-monthpicker" role="grid" aria-labelledby="{{::uniqueId}}-title" aria-activedescendant="{{activeDateId}}">\n  <thead>\n    <tr>\n      <th><button type="button" class="btn btn-default btn-sm pull-left uib-left" ng-click="move(-1)" tabindex="-1"><i class="glyphicon glyphicon-chevron-left"></i></button></th>\n      <th><button id="{{::uniqueId}}-title" role="heading" aria-live="assertive" aria-atomic="true" type="button" class="btn btn-default btn-sm uib-title" ng-click="toggleMode()" ng-disabled="datepickerMode === maxMode" tabindex="-1"><strong>{{title}}</strong></button></th>\n      <th><button type="button" class="btn btn-default btn-sm pull-right uib-right" ng-click="move(1)" tabindex="-1"><i class="glyphicon glyphicon-chevron-right"></i></button></th>\n    </tr>\n  </thead>\n  <tbody>\n    <tr class="uib-months" ng-repeat="row in rows track by $index">\n      <td ng-repeat="dt in row" class="uib-month text-center" role="gridcell"\n        id="{{::dt.uid}}"\n        ng-class="::dt.customClass">\n        <button type="button" class="btn btn-default"\n          uib-is-class="\n            \'btn-info\' for selectedDt,\n            \'active\' for activeDt\n            on dt"\n          ng-click="select(dt.date)"\n          ng-disabled="::dt.disabled"\n          tabindex="-1"><span ng-class="::{\'text-info\': dt.current}">{{::dt.label}}</span></button>\n      </td>\n    </tr>\n  </tbody>\n</table>\n')}]),angular.module("uib/template/datepicker/popup.html",[]).run(["$templateCache",function(a){a.put("uib/template/datepicker/popup.html",'<div>\n  <ul class="uib-datepicker-popup dropdown-menu uib-position-measure" dropdown-nested ng-if="isOpen" ng-keydown="keydown($event)" ng-click="$event.stopPropagation()">\n    <li ng-transclude></li>\n    <li ng-if="showButtonBar" class="uib-button-bar">\n      <span class="btn-group pull-left">\n        <button type="button" class="btn btn-sm btn-info uib-datepicker-current" ng-click="select(\'today\', $event)" ng-disabled="isDisabled(\'today\')">{{ getText(\'current\') }}</button>\n        <button type="button" class="btn btn-sm btn-danger uib-clear" ng-click="select(null, $event)">{{ getText(\'clear\') }}</button>\n      </span>\n      <button type="button" class="btn btn-sm btn-success pull-right uib-close" ng-click="close($event)">{{ getText(\'close\') }}</button>\n    </li>\n  </ul>\n</div>\n')}]),angular.module("uib/template/datepicker/year.html",[]).run(["$templateCache",function(a){a.put("uib/template/datepicker/year.html",'<table class="uib-yearpicker" role="grid" aria-labelledby="{{::uniqueId}}-title" aria-activedescendant="{{activeDateId}}">\n  <thead>\n    <tr>\n      <th><button type="button" class="btn btn-default btn-sm pull-left uib-left" ng-click="move(-1)" tabindex="-1"><i class="glyphicon glyphicon-chevron-left"></i></button></th>\n      <th colspan="{{::columns - 2}}"><button id="{{::uniqueId}}-title" role="heading" aria-live="assertive" aria-atomic="true" type="button" class="btn btn-default btn-sm uib-title" ng-click="toggleMode()" ng-disabled="datepickerMode === maxMode" tabindex="-1"><strong>{{title}}</strong></button></th>\n      <th><button type="button" class="btn btn-default btn-sm pull-right uib-right" ng-click="move(1)" tabindex="-1"><i class="glyphicon glyphicon-chevron-right"></i></button></th>\n    </tr>\n  </thead>\n  <tbody>\n    <tr class="uib-years" ng-repeat="row in rows track by $index">\n      <td ng-repeat="dt in row" class="uib-year text-center" role="gridcell"\n        id="{{::dt.uid}}"\n        ng-class="::dt.customClass">\n        <button type="button" class="btn btn-default"\n          uib-is-class="\n            \'btn-info\' for selectedDt,\n            \'active\' for activeDt\n            on dt"\n          ng-click="select(dt.date)"\n          ng-disabled="::dt.disabled"\n          tabindex="-1"><span ng-class="::{\'text-info\': dt.current}">{{::dt.label}}</span></button>\n      </td>\n    </tr>\n  </tbody>\n</table>\n')}]),angular.module("uib/template/modal/backdrop.html",[]).run(["$templateCache",function(a){a.put("uib/template/modal/backdrop.html",'<div class="modal-backdrop"\n     uib-modal-animation-class="fade"\n     modal-in-class="in"\n     ng-style="{\'z-index\': 1040 + (index && 1 || 0) + index*10}"\n></div>\n')}]),angular.module("uib/template/modal/window.html",[]).run(["$templateCache",function(a){a.put("uib/template/modal/window.html",'<div modal-render="{{$isRendered}}" tabindex="-1" role="dialog" class="modal"\n    uib-modal-animation-class="fade"\n    modal-in-class="in"\n    ng-style="{\'z-index\': 1050 + index*10, display: \'block\'}">\n    <div class="modal-dialog {{size ? \'modal-\' + size : \'\'}}"><div class="modal-content" uib-modal-transclude></div></div>\n</div>\n')}]),angular.module("uib/template/pager/pager.html",[]).run(["$templateCache",function(a){a.put("uib/template/pager/pager.html",'<ul class="pager">\n  <li ng-class="{disabled: noPrevious()||ngDisabled, previous: align}"><a href ng-click="selectPage(page - 1, $event)">{{::getText(\'previous\')}}</a></li>\n  <li ng-class="{disabled: noNext()||ngDisabled, next: align}"><a href ng-click="selectPage(page + 1, $event)">{{::getText(\'next\')}}</a></li>\n</ul>\n')}]),angular.module("uib/template/pagination/pagination.html",[]).run(["$templateCache",function(a){a.put("uib/template/pagination/pagination.html",'<ul class="pagination">\n  <li ng-if="::boundaryLinks" ng-class="{disabled: noPrevious()||ngDisabled}" class="pagination-first"><a href ng-click="selectPage(1, $event)">{{::getText(\'first\')}}</a></li>\n  <li ng-if="::directionLinks" ng-class="{disabled: noPrevious()||ngDisabled}" class="pagination-prev"><a href ng-click="selectPage(page - 1, $event)">{{::getText(\'previous\')}}</a></li>\n  <li ng-repeat="page in pages track by $index" ng-class="{active: page.active,disabled: ngDisabled&&!page.active}" class="pagination-page"><a href ng-click="selectPage(page.number, $event)">{{page.text}}</a></li>\n  <li ng-if="::directionLinks" ng-class="{disabled: noNext()||ngDisabled}" class="pagination-next"><a href ng-click="selectPage(page + 1, $event)">{{::getText(\'next\')}}</a></li>\n  <li ng-if="::boundaryLinks" ng-class="{disabled: noNext()||ngDisabled}" class="pagination-last"><a href ng-click="selectPage(totalPages, $event)">{{::getText(\'last\')}}</a></li>\n</ul>\n')}]),angular.module("uib/template/tooltip/tooltip-html-popup.html",[]).run(["$templateCache",function(a){a.put("uib/template/tooltip/tooltip-html-popup.html",'<div class="tooltip"\n  tooltip-animation-class="fade"\n  uib-tooltip-classes\n  ng-class="{ in: isOpen() }">\n  <div class="tooltip-arrow"></div>\n  <div class="tooltip-inner" ng-bind-html="contentExp()"></div>\n</div>\n')}]),angular.module("uib/template/tooltip/tooltip-popup.html",[]).run(["$templateCache",function(a){a.put("uib/template/tooltip/tooltip-popup.html",'<div class="tooltip"\n  tooltip-animation-class="fade"\n  uib-tooltip-classes\n  ng-class="{ in: isOpen() }">\n  <div class="tooltip-arrow"></div>\n  <div class="tooltip-inner" ng-bind="content"></div>\n</div>\n')}]),angular.module("uib/template/tooltip/tooltip-template-popup.html",[]).run(["$templateCache",function(a){a.put("uib/template/tooltip/tooltip-template-popup.html",'<div class="tooltip"\n  tooltip-animation-class="fade"\n  uib-tooltip-classes\n  ng-class="{ in: isOpen() }">\n  <div class="tooltip-arrow"></div>\n  <div class="tooltip-inner"\n    uib-tooltip-template-transclude="contentExp()"\n    tooltip-template-transclude-scope="originScope()"></div>\n</div>\n')}]),angular.module("uib/template/popover/popover-html.html",[]).run(["$templateCache",function(a){a.put("uib/template/popover/popover-html.html",'<div class="popover"\n  tooltip-animation-class="fade"\n  uib-tooltip-classes\n  ng-class="{ in: isOpen() }">\n  <div class="arrow"></div>\n\n  <div class="popover-inner">\n      <h3 class="popover-title" ng-bind="title" ng-if="title"></h3>\n      <div class="popover-content" ng-bind-html="contentExp()"></div>\n  </div>\n</div>\n')}]),angular.module("uib/template/popover/popover-template.html",[]).run(["$templateCache",function(a){a.put("uib/template/popover/popover-template.html",'<div class="popover"\n  tooltip-animation-class="fade"\n  uib-tooltip-classes\n  ng-class="{ in: isOpen() }">\n  <div class="arrow"></div>\n\n  <div class="popover-inner">\n      <h3 class="popover-title" ng-bind="title" ng-if="title"></h3>\n      <div class="popover-content"\n        uib-tooltip-template-transclude="contentExp()"\n        tooltip-template-transclude-scope="originScope()"></div>\n  </div>\n</div>\n')}]),angular.module("uib/template/popover/popover.html",[]).run(["$templateCache",function(a){a.put("uib/template/popover/popover.html",'<div class="popover"\n  tooltip-animation-class="fade"\n  uib-tooltip-classes\n  ng-class="{ in: isOpen() }">\n  <div class="arrow"></div>\n\n  <div class="popover-inner">\n      <h3 class="popover-title" ng-bind="title" ng-if="title"></h3>\n      <div class="popover-content" ng-bind="content"></div>\n  </div>\n</div>\n')}]),angular.module("uib/template/progressbar/bar.html",[]).run(["$templateCache",function(a){a.put("uib/template/progressbar/bar.html",'<div class="progress-bar" ng-class="type && \'progress-bar-\' + type" role="progressbar" aria-valuenow="{{value}}" aria-valuemin="0" aria-valuemax="{{max}}" ng-style="{width: (percent < 100 ? percent : 100) + \'%\'}" aria-valuetext="{{percent | number:0}}%" aria-labelledby="{{::title}}" ng-transclude></div>\n')}]),angular.module("uib/template/progressbar/progress.html",[]).run(["$templateCache",function(a){a.put("uib/template/progressbar/progress.html",'<div class="progress" ng-transclude aria-labelledby="{{::title}}"></div>')}]),angular.module("uib/template/progressbar/progressbar.html",[]).run(["$templateCache",function(a){a.put("uib/template/progressbar/progressbar.html",'<div class="progress">\n  <div class="progress-bar" ng-class="type && \'progress-bar-\' + type" role="progressbar" aria-valuenow="{{value}}" aria-valuemin="0" aria-valuemax="{{max}}" ng-style="{width: (percent < 100 ? percent : 100) + \'%\'}" aria-valuetext="{{percent | number:0}}%" aria-labelledby="{{::title}}" ng-transclude></div>\n</div>\n')}]),angular.module("uib/template/rating/rating.html",[]).run(["$templateCache",function(a){a.put("uib/template/rating/rating.html",'<span ng-mouseleave="reset()" ng-keydown="onKeydown($event)" tabindex="0" role="slider" aria-valuemin="0" aria-valuemax="{{range.length}}" aria-valuenow="{{value}}" aria-valuetext="{{title}}">\n    <span ng-repeat-start="r in range track by $index" class="sr-only">({{ $index < value ? \'*\' : \' \' }})</span>\n    <i ng-repeat-end ng-mouseenter="enter($index + 1)" ng-click="rate($index + 1)" class="glyphicon" ng-class="$index < value && (r.stateOn || \'glyphicon-star\') || (r.stateOff || \'glyphicon-star-empty\')" ng-attr-title="{{r.title}}"></i>\n</span>\n')}]),angular.module("uib/template/tabs/tab.html",[]).run(["$templateCache",function(a){a.put("uib/template/tabs/tab.html",'<li ng-class="[{active: active, disabled: disabled}, classes]" class="uib-tab nav-item">\n  <a href ng-click="select($event)" class="nav-link" uib-tab-heading-transclude>{{heading}}</a>\n</li>\n')}]),angular.module("uib/template/tabs/tabset.html",[]).run(["$templateCache",function(a){a.put("uib/template/tabs/tabset.html",'<div>\n  <ul class="nav nav-{{tabset.type || \'tabs\'}}" ng-class="{\'nav-stacked\': vertical, \'nav-justified\': justified}" ng-transclude></ul>\n  <div class="tab-content">\n    <div class="tab-pane"\n         ng-repeat="tab in tabset.tabs"\n         ng-class="{active: tabset.active === tab.index}"\n         uib-tab-content-transclude="tab">\n    </div>\n  </div>\n</div>\n')}]),angular.module("uib/template/timepicker/timepicker.html",[]).run(["$templateCache",function(a){a.put("uib/template/timepicker/timepicker.html",'<table class="uib-timepicker">\n  <tbody>\n    <tr class="text-center" ng-show="::showSpinners">\n      <td class="uib-increment hours"><a ng-click="incrementHours()" ng-class="{disabled: noIncrementHours()}" class="btn btn-link" ng-disabled="noIncrementHours()" tabindex="{{::tabindex}}"><span class="glyphicon glyphicon-chevron-up"></span></a></td>\n      <td>&nbsp;</td>\n      <td class="uib-increment minutes"><a ng-click="incrementMinutes()" ng-class="{disabled: noIncrementMinutes()}" class="btn btn-link" ng-disabled="noIncrementMinutes()" tabindex="{{::tabindex}}"><span class="glyphicon glyphicon-chevron-up"></span></a></td>\n      <td ng-show="showSeconds">&nbsp;</td>\n      <td ng-show="showSeconds" class="uib-increment seconds"><a ng-click="incrementSeconds()" ng-class="{disabled: noIncrementSeconds()}" class="btn btn-link" ng-disabled="noIncrementSeconds()" tabindex="{{::tabindex}}"><span class="glyphicon glyphicon-chevron-up"></span></a></td>\n      <td ng-show="showMeridian"></td>\n    </tr>\n    <tr>\n      <td class="form-group uib-time hours" ng-class="{\'has-error\': invalidHours}">\n        <input style="width:50px;" type="text" placeholder="HH" ng-model="hours" ng-change="updateHours()" class="form-control text-center" ng-readonly="::readonlyInput" maxlength="2" tabindex="{{::tabindex}}" ng-disabled="noIncrementHours()" ng-blur="blur()">\n      </td>\n      <td class="uib-separator">:</td>\n      <td class="form-group uib-time minutes" ng-class="{\'has-error\': invalidMinutes}">\n        <input style="width:50px;" type="text" placeholder="MM" ng-model="minutes" ng-change="updateMinutes()" class="form-control text-center" ng-readonly="::readonlyInput" maxlength="2" tabindex="{{::tabindex}}" ng-disabled="noIncrementMinutes()" ng-blur="blur()">\n      </td>\n      <td ng-show="showSeconds" class="uib-separator">:</td>\n      <td class="form-group uib-time seconds" ng-class="{\'has-error\': invalidSeconds}" ng-show="showSeconds">\n        <input style="width:50px;" type="text" placeholder="SS" ng-model="seconds" ng-change="updateSeconds()" class="form-control text-center" ng-readonly="readonlyInput" maxlength="2" tabindex="{{::tabindex}}" ng-disabled="noIncrementSeconds()" ng-blur="blur()">\n      </td>\n      <td ng-show="showMeridian" class="uib-time am-pm"><button type="button" ng-class="{disabled: noToggleMeridian()}" class="btn btn-default text-center" ng-click="toggleMeridian()" ng-disabled="noToggleMeridian()" tabindex="{{::tabindex}}">{{meridian}}</button></td>\n    </tr>\n    <tr class="text-center" ng-show="::showSpinners">\n      <td class="uib-decrement hours"><a ng-click="decrementHours()" ng-class="{disabled: noDecrementHours()}" class="btn btn-link" ng-disabled="noDecrementHours()" tabindex="{{::tabindex}}"><span class="glyphicon glyphicon-chevron-down"></span></a></td>\n      <td>&nbsp;</td>\n      <td class="uib-decrement minutes"><a ng-click="decrementMinutes()" ng-class="{disabled: noDecrementMinutes()}" class="btn btn-link" ng-disabled="noDecrementMinutes()" tabindex="{{::tabindex}}"><span class="glyphicon glyphicon-chevron-down"></span></a></td>\n      <td ng-show="showSeconds">&nbsp;</td>\n      <td ng-show="showSeconds" class="uib-decrement seconds"><a ng-click="decrementSeconds()" ng-class="{disabled: noDecrementSeconds()}" class="btn btn-link" ng-disabled="noDecrementSeconds()" tabindex="{{::tabindex}}"><span class="glyphicon glyphicon-chevron-down"></span></a></td>\n      <td ng-show="showMeridian"></td>\n    </tr>\n  </tbody>\n</table>\n')}]),angular.module("uib/template/typeahead/typeahead-match.html",[]).run(["$templateCache",function(a){a.put("uib/template/typeahead/typeahead-match.html",'<a href\n   tabindex="-1"\n   ng-bind-html="match.label | uibTypeaheadHighlight:query"\n   ng-attr-title="{{match.label}}"></a>\n')}]),angular.module("uib/template/typeahead/typeahead-popup.html",[]).run(["$templateCache",function(a){a.put("uib/template/typeahead/typeahead-popup.html",'<ul class="dropdown-menu" ng-show="isOpen() && !moveInProgress" ng-style="{top: position().top+\'px\', left: position().left+\'px\'}" role="listbox" aria-hidden="{{!isOpen()}}">\n    <li ng-repeat="match in matches track by $index" ng-class="{active: isActive($index) }" ng-mouseenter="selectActive($index)" ng-click="selectMatch($index, $event)" role="option" id="{{::match.id}}">\n        <div uib-typeahead-match index="$index" match="match" query="query" template-url="templateUrl"></div>\n    </li>\n</ul>\n')}]),angular.module("ui.bootstrap.carousel").run(function(){!angular.$$csp().noInlineStyle&&!angular.$$uibCarouselCss&&angular.element(document).find("head").prepend('<style type="text/css">.ng-animate.item:not(.left):not(.right){-webkit-transition:0s ease-in-out left;transition:0s ease-in-out left}</style>'),angular.$$uibCarouselCss=!0}),angular.module("ui.bootstrap.position").run(function(){!angular.$$csp().noInlineStyle&&!angular.$$uibPositionCss&&angular.element(document).find("head").prepend('<style type="text/css">.uib-position-measure{display:block !important;visibility:hidden !important;position:absolute !important;top:-9999px !important;left:-9999px !important;}.uib-position-scrollbar-measure{position:absolute;top:-9999px;width:50px;height:50px;overflow:scroll;}</style>'),angular.$$uibPositionCss=!0}),angular.module("ui.bootstrap.datepicker").run(function(){!angular.$$csp().noInlineStyle&&!angular.$$uibDatepickerCss&&angular.element(document).find("head").prepend('<style type="text/css">.uib-datepicker .uib-title{width:100%;}.uib-day button,.uib-month button,.uib-year button{min-width:100%;}.uib-datepicker-popup.dropdown-menu{display:block;float:none;margin:0;}.uib-button-bar{padding:10px 9px 2px;}.uib-left,.uib-right{width:100%}</style>'),angular.$$uibDatepickerCss=!0}),angular.module("ui.bootstrap.tooltip").run(function(){!angular.$$csp().noInlineStyle&&!angular.$$uibTooltipCss&&angular.element(document).find("head").prepend('<style type="text/css">[uib-tooltip-popup].tooltip.top-left > .tooltip-arrow,[uib-tooltip-popup].tooltip.top-right > .tooltip-arrow,[uib-tooltip-popup].tooltip.bottom-left > .tooltip-arrow,[uib-tooltip-popup].tooltip.bottom-right > .tooltip-arrow,[uib-tooltip-popup].tooltip.left-top > .tooltip-arrow,[uib-tooltip-popup].tooltip.left-bottom > .tooltip-arrow,[uib-tooltip-popup].tooltip.right-top > .tooltip-arrow,[uib-tooltip-popup].tooltip.right-bottom > .tooltip-arrow,[uib-tooltip-html-popup].tooltip.top-left > .tooltip-arrow,[uib-tooltip-html-popup].tooltip.top-right > .tooltip-arrow,[uib-tooltip-html-popup].tooltip.bottom-left > .tooltip-arrow,[uib-tooltip-html-popup].tooltip.bottom-right > .tooltip-arrow,[uib-tooltip-html-popup].tooltip.left-top > .tooltip-arrow,[uib-tooltip-html-popup].tooltip.left-bottom > .tooltip-arrow,[uib-tooltip-html-popup].tooltip.right-top > .tooltip-arrow,[uib-tooltip-html-popup].tooltip.right-bottom > .tooltip-arrow,[uib-tooltip-template-popup].tooltip.top-left > .tooltip-arrow,[uib-tooltip-template-popup].tooltip.top-right > .tooltip-arrow,[uib-tooltip-template-popup].tooltip.bottom-left > .tooltip-arrow,[uib-tooltip-template-popup].tooltip.bottom-right > .tooltip-arrow,[uib-tooltip-template-popup].tooltip.left-top > .tooltip-arrow,[uib-tooltip-template-popup].tooltip.left-bottom > .tooltip-arrow,[uib-tooltip-template-popup].tooltip.right-top > .tooltip-arrow,[uib-tooltip-template-popup].tooltip.right-bottom > .tooltip-arrow,[uib-popover-popup].popover.top-left > .arrow,[uib-popover-popup].popover.top-right > .arrow,[uib-popover-popup].popover.bottom-left > .arrow,[uib-popover-popup].popover.bottom-right > .arrow,[uib-popover-popup].popover.left-top > .arrow,[uib-popover-popup].popover.left-bottom > .arrow,[uib-popover-popup].popover.right-top > .arrow,[uib-popover-popup].popover.right-bottom > .arrow,[uib-popover-html-popup].popover.top-left > .arrow,[uib-popover-html-popup].popover.top-right > .arrow,[uib-popover-html-popup].popover.bottom-left > .arrow,[uib-popover-html-popup].popover.bottom-right > .arrow,[uib-popover-html-popup].popover.left-top > .arrow,[uib-popover-html-popup].popover.left-bottom > .arrow,[uib-popover-html-popup].popover.right-top > .arrow,[uib-popover-html-popup].popover.right-bottom > .arrow,[uib-popover-template-popup].popover.top-left > .arrow,[uib-popover-template-popup].popover.top-right > .arrow,[uib-popover-template-popup].popover.bottom-left > .arrow,[uib-popover-template-popup].popover.bottom-right > .arrow,[uib-popover-template-popup].popover.left-top > .arrow,[uib-popover-template-popup].popover.left-bottom > .arrow,[uib-popover-template-popup].popover.right-top > .arrow,[uib-popover-template-popup].popover.right-bottom > .arrow{top:auto;bottom:auto;left:auto;right:auto;margin:0;}[uib-popover-popup].popover,[uib-popover-html-popup].popover,[uib-popover-template-popup].popover{display:block !important;}</style>'),angular.$$uibTooltipCss=!0}),angular.module("ui.bootstrap.timepicker").run(function(){!angular.$$csp().noInlineStyle&&!angular.$$uibTimepickerCss&&angular.element(document).find("head").prepend('<style type="text/css">.uib-time input{width:50px;}</style>'),angular.$$uibTimepickerCss=!0}),angular.module("ui.bootstrap.typeahead").run(function(){!angular.$$csp().noInlineStyle&&!angular.$$uibTypeaheadCss&&angular.element(document).find("head").prepend('<style type="text/css">[uib-typeahead-popup].dropdown-menu{display:block;}</style>'),angular.$$uibTypeaheadCss=!0});

  }).apply(root, arguments);
});
}(this));

(function(root) {
define("angular-growl", ["angular"], function() {
  return (function() {
/**
 * angular-growl-v2 - v0.7.3 - 2018-06-06
 * http://janstevens.github.io/angular-growl-2
 * Copyright (c) 2018 Marco Rinck,Jan Stevens; Licensed MIT
 */
angular.module("angular-growl",[]),angular.module("angular-growl").directive("growl",[function(){"use strict";return{restrict:"A",templateUrl:"templates/growl/growl.html",replace:!1,scope:{reference:"@",inline:"=",limitMessages:"="},controller:["$scope","$timeout","growl","growlMessages",function(a,b,c,d){a.referenceId=a.reference||0,d.initDirective(a.referenceId,a.limitMessages),a.growlMessages=d,a.inlineMessage=angular.isDefined(a.inline)?a.inline:c.inlineMessages(),a.$watch("limitMessages",function(b){var c=d.directives[a.referenceId];angular.isUndefined(b)||angular.isUndefined(c)||(c.limitMessages=b)}),a.stopTimeoutClose=function(a){a.clickToClose||(angular.forEach(a.promises,function(a){b.cancel(a)}),a.close?d.deleteMessage(a):a.close=!0)},a.alertClasses=function(a){return{"alert-success":"success"===a.severity,"alert-error":"error"===a.severity,"alert-danger":"error"===a.severity,"alert-info":"info"===a.severity,"alert-warning":"warning"===a.severity,icon:a.disableIcons===!1,"alert-dismissable":!a.disableCloseButton}},a.showCountDown=function(a){return!a.disableCountDown&&a.ttl>0},a.wrapperClasses=function(){var b={};return b["growl-fixed"]=!a.inlineMessage,b[c.position()]=!0,b},a.computeTitle=function(a){var b={success:"Success",error:"Error",info:"Information",warn:"Warning"};return b[a.severity]}}]}}]),angular.module("angular-growl").run(["$templateCache",function(a){"use strict";void 0===a.get("templates/growl/growl.html")&&a.put("templates/growl/growl.html",'<div class="growl-container" ng-class="wrapperClasses()"><div class="growl-item alert" ng-repeat="message in growlMessages.directives[referenceId].messages" ng-class="alertClasses(message)" ng-click="stopTimeoutClose(message)"><button type="button" class="close" data-dismiss="alert" aria-hidden="true" ng-click="growlMessages.deleteMessage(message)" ng-show="!message.disableCloseButton">&times;</button><button type="button" class="close" aria-hidden="true" ng-show="showCountDown(message)">{{message.countdown}}</button><h4 class="growl-title" ng-show="message.title" ng-bind="message.title"></h4><div class="growl-message" ng-bind-html="message.text"></div></div></div>')}]),angular.module("angular-growl").provider("growl",function(){"use strict";var a={success:null,error:null,warning:null,info:null},b="messages",c="text",d="title",e="severity",f=!0,g="variables",h=0,i=!1,j="top-right",k=!1,l=!1,m=!1,n=!1,o=!0;this.globalTimeToLive=function(b){if("object"==typeof b)for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c]);else for(var d in a)a.hasOwnProperty(d)&&(a[d]=b)},this.globalTranslateMessages=function(a){o=a},this.globalDisableCloseButton=function(a){k=a},this.globalDisableIcons=function(a){l=a},this.globalReversedOrder=function(a){m=a},this.globalDisableCountDown=function(a){n=a},this.messageVariableKey=function(a){g=a},this.globalInlineMessages=function(a){i=a},this.globalPosition=function(a){j=a},this.messagesKey=function(a){b=a},this.messageTextKey=function(a){c=a},this.messageTitleKey=function(a){d=a},this.messageSeverityKey=function(a){e=a},this.onlyUniqueMessages=function(a){f=a},this.serverMessagesInterceptor=["$q","growl",function(a,c){function d(a){void 0!==a&&a.data[b]&&a.data[b].length>0&&c.addServerMessages(a.data[b])}return{response:function(a){return d(a),a},responseError:function(b){return d(b),a.reject(b)}}}],this.$get=["$rootScope","$interpolate","$sce","$filter","$timeout","growlMessages",function(b,p,q,r,s,t){function u(a){if(G&&a.translateMessage)a.text=G(a.text,a.variables);else if(a.interpolate||Object.keys(a.variables).length>0){var c=p(a.text);a.text=c(a.variables)}var d=t.addMessage(a);return b.$broadcast("growlMessage",a),s(function(){},0),d}function v(b,c,d){var e,f=c||{};return e={text:b,title:f.title,severity:d,ttl:f.ttl||a[d],variables:f.variables||{},disableCloseButton:void 0===f.disableCloseButton?k:f.disableCloseButton,disableIcons:void 0===f.disableIcons?l:f.disableIcons,disableCountDown:void 0===f.disableCountDown?n:f.disableCountDown,position:f.position||j,referenceId:f.referenceId||h,translateMessage:void 0===f.translateMessage?o:f.translateMessage,destroy:function(){t.deleteMessage(e)},setText:function(a){e.text=q.trustAsHtml(String(a))},onclose:f.onclose,onopen:f.onopen,interpolate:f.interpolate},u(e)}function w(a,b){return v(a,b,"warning")}function x(a,b){return v(a,b,"error")}function y(a,b){return v(a,b,"info")}function z(a,b){return v(a,b,"success")}function A(a,b,c){c=(c||"error").toLowerCase(),v(a,b,c)}function B(a){if(a&&a.length){var b,f,h,i;for(i=a.length,b=0;i>b;b++)if(f=a[b],f[c]){h=(f[e]||"error").toLowerCase();var j={};j.variables=f[g]||{},j.title=f[d],v(f[c],j,h)}}}function C(){return f}function D(){return m}function E(){return i}function F(){return j}var G;t.onlyUnique=f,t.reverseOrder=m;try{G=r("translate")}catch(H){}return{warning:w,error:x,info:y,success:z,general:A,addServerMessages:B,onlyUnique:C,reverseOrder:D,inlineMessages:E,position:F}}]}),angular.module("angular-growl").service("growlMessages",["$sce","$timeout",function(a,b){"use strict";function c(a){var b;return b=d[a]?d[a]:d[a]={messages:[]}}this.directives={};var d={};this.initDirective=function(a,b){return d[a]?(this.directives[a]=d[a],this.directives[a].limitMessages=b):this.directives[a]={messages:[],limitMessages:b},this.directives[a]},this.getAllMessages=function(a){a=a||0;var b;return b=this.directives[a]?this.directives[a].messages:[]},this.destroyAllMessages=function(a){for(var b=this.getAllMessages(a),c=b.length-1;c>=0;c--)b[c].destroy();this.directives[a]&&(this.directives[a].messages=[])},this.addMessage=function(d){var e,f,g,h;if(e=this.directives[d.referenceId]?this.directives[d.referenceId]:c(d.referenceId),f=e.messages,!this.onlyUnique||(angular.forEach(f,function(b){h=a.getTrustedHtml(b.text),d.text===h&&d.severity===b.severity&&d.title===b.title&&(g=!0)}),!g)){if(d.text=a.trustAsHtml(String(d.text)),d.ttl&&-1!==d.ttl&&(d.countdown=d.ttl/1e3,d.promises=[],d.close=!1,d.countdownFunction=function(){d.countdown>1?(d.countdown--,d.promises.push(b(d.countdownFunction,1e3))):d.countdown--}),angular.isDefined(e.limitMessages)){var i=f.length-(e.limitMessages-1);i>0&&f.splice(e.limitMessages-1,i)}return this.reverseOrder?f.unshift(d):f.push(d),"function"==typeof d.onopen&&d.onopen(),d.ttl&&-1!==d.ttl&&(d.promises.push(b(angular.bind(this,function(){this.deleteMessage(d)}),d.ttl)),d.promises.push(b(d.countdownFunction,1e3))),d}},this.deleteMessage=function(a){var b=this.directives[a.referenceId].messages,c=b.indexOf(a);c>-1&&(b[c].close=!0,b.splice(c,1)),"function"==typeof a.onclose&&a.onclose()}}]);

  }).apply(root, arguments);
});
}(this));

(function(root) {
define("angular-ui-scroll", ["angular","jquery"], function() {
  return (function() {
/*!
 * angular-ui-scroll (compressed)
 * https://github.com/angular-ui/ui-scroll
 * Version: 1.6.1 -- 2017-03-06T07:25:30.385Z
 * License: MIT
 */
!function(e){function t(r){if(n[r])return n[r].exports;var i=n[r]={exports:{},id:r,loaded:!1};return e[r].call(i.exports,i,i.exports,t),i.loaded=!0,i.exports}var n={};return t.m=e,t.c=n,t.p="",t(0)}([function(e,t,n){"use strict";function r(e){return e&&e.__esModule?e:{default:e}}var i=n(1),o=r(i),a=n(2),u=r(a),l=n(3),s=r(l),c=n(4),f=r(c),d=n(6),p=r(d);angular.module("ui.scroll",[]).service("jqLiteExtras",function(){return new o.default}).run(["jqLiteExtras",function(e){return window.jQuery?null:e.registerFor(angular.element)}]).directive("uiScrollViewport",function(){return{restrict:"A",controller:["$scope","$element",function(e,t){var n=this;return this.container=t,this.viewport=t,this.scope=e,angular.forEach(t.children(),function(e){"tbody"===e.tagName.toLowerCase()&&(n.viewport=angular.element(e))}),this}]}}).directive("uiScroll",["$log","$injector","$rootScope","$timeout","$q","$parse",function(e,t,n,r,i,o){function a(e,a,l,c,d){function h(t,n){var r=o(t)(e);return isNaN(r)?n:r}function g(e,t,n){var i=Object.getOwnPropertyDescriptor(e,t);i&&(i.set||i.get)||Object.defineProperty(e,t,{set:function(e){J[t]=e,r(function(){if(X[n]=e,!z.length){var r=Y.topDataPos();Y.adjustPadding(),"minIndex"===t&&Y.adjustScrollTopAfterMinIndexSet(r)}})},get:function(){return J[t]}})}function m(t){return t&&t!==q||e.$$destroyed}function v(){Y.bind("resize",A),Y.bind("scroll",A)}function b(){Y.unbind("resize",A),Y.unbind("scroll",A)}function y(){Y.resetTopPadding(),Y.resetBottomPadding(),arguments.length&&(W=arguments[0]),X.reset(W),T()}function x(e){return e.element.height()&&e.element[0].offsetParent}function w(e){x(e)&&(X.forEach(function(e){angular.isFunction(e.unregisterVisibilityWatcher)&&(e.unregisterVisibilityWatcher(),delete e.unregisterVisibilityWatcher)}),z.length||T())}function E(e,t){P(e,t,Y.insertElement),x(e)||(e.unregisterVisibilityWatcher=e.scope.$watch(function(){return w(e)})),e.element.addClass("ng-hide")}function P(e,t,n){var r=null,i=t>0?X[t-1].element:void 0;return d(function(t,o){r=n(t,i),e.element=t,e.scope=o,o[U]=e.item}),Q.transform&&Q.transform(e.scope,e.element),r}function $(){var e=[],t=[],n=[],r=[];return X.forEach(function(i,o){switch(i.op){case"prepend":t.unshift(i);break;case"append":E(i,o),i.op="none",r.push(i);break;case"insert":e=e.concat(P(i,o,Y.insertElementAnimated)),i.op="none",r.push(i);break;case"remove":n.push(i)}}),n.forEach(function(t){return e=e.concat(X.remove(t))}),t.length&&t.forEach(function(e){E(e),e.op="none"}),X.forEach(function(e,t){return e.scope.$index=X.first+t}),{prepended:t,removed:n,inserted:r,animated:e}}function j(e,t){t.animated.length?i.all(t.animated).then(function(){Y.adjustPadding(),T(e)}):Y.adjustPadding()}function S(e,t){Y.shouldLoadBottom()?(!t||X.effectiveHeight(t.inserted)>0)&&1===z.push(!0)&&(O(e),Q.loading(!0)):Y.shouldLoadTop()&&(!t||X.effectiveHeight(t.prepended)>0||z[0])&&1===z.push(!1)&&(O(e),Q.loading(!0))}function T(e){e||(z=[],e=++q);var t=$();r(function(){t.inserted.forEach(function(e){return e.element.removeClass("ng-hide")}),t.prepended.forEach(function(e){return e.element.removeClass("ng-hide")}),m(e)||(j(e,t),S(e),z.length||Q.calculateProperties())})}function I(e){var t=$();r(function(){t.inserted.forEach(function(e){return e.element.removeClass("ng-hide")}),t.prepended.forEach(function(e){return e.element.removeClass("ng-hide")}),Y.adjustScrollTopAfterPrepend(t),m(e)||(j(e,t),S(e,t),z.shift(),z.length?O(e):(Q.loading(!1),v(),Q.calculateProperties()))})}function O(e){z[0]?X.length&&!Y.shouldLoadBottom()?I(e):K(function(t){m(e)||(t.length<F&&(X.eof=!0),t.length>0&&(Y.clipTop(),X.append(t)),I(e))}):X.length&&!Y.shouldLoadTop()?I(e):Z(function(t){m(e)||(t.length<F&&(X.bof=!0),t.length>0&&(X.length&&Y.clipBottom(),X.prepend(t)),I(e))})}function A(){n.$$phase||Q.isLoading||Q.disabled||(S(q),z.length?b():(Q.calculateProperties(),e.$apply()))}function k(e){if(!Q.disabled){var t=Y[0].scrollTop,n=Y[0].scrollHeight-Y[0].clientHeight;(0===t&&!X.bof||t===n&&!X.eof)&&e.preventDefault()}}var L=l.uiScroll.match(/^\s*(\w+)\s+in\s+([(\w|\$)\.]+)\s*$/);if(!L)throw new Error("Expected uiScroll in form of '_item_ in _datasource_' but got '"+l.uiScroll+"'");var C=3,V=10,_=.3,H=.5,M=null,U=L[1],B=L[2],D=c[0],F=Math.max(C,h(l.bufferSize,V)),N=Math.max(_,h(l.padding,H)),W=h(l.startIndex,1),q=0,z=[],R=new u.default(t,i),X=new s.default(R,F),Y=new f.default(R,X,a,D,n,N),Q=new p.default(Y,X,T,y,l,o,a,e);D&&(D.adapter=Q);var G=function(){return angular.isObject(M)&&angular.isFunction(M.get)};if(M=o(B)(e),!G()&&(M=t.get(B),!G()))throw new Error(B+" is not a valid datasource");var J={};g(M,"minIndex","minIndexUser"),g(M,"maxIndex","maxIndexUser");var K=2!==M.get.length?function(e){return M.get(X.next,F,e)}:function(e){M.get({index:X.next,append:X.length?X[X.length-1].item:void 0,count:F},e)},Z=2!==M.get.length?function(e){return M.get(X.first-F,F,e)}:function(e){M.get({index:X.first-F,prepend:X.length?X[0].item:void 0,count:F},e)};d(function(e,t){Y.createPaddingElements(e[0]),t.$destroy(),e.remove()}),e.$on("$destroy",function(){b(),Y.unbind("mousewheel",k)}),Y.bind("mousewheel",k),r(function(){Y.applyContainerStyle(),y()})}return{require:["?^uiScrollViewport"],restrict:"A",transclude:"element",priority:1e3,terminal:!0,link:a}}])},function(e,t){"use strict";function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var r=function(){function e(e,t){var n=[],r=!0,i=!1,o=void 0;try{for(var a,u=e[Symbol.iterator]();!(r=(a=u.next()).done)&&(n.push(a.value),!t||n.length!==t);r=!0);}catch(e){i=!0,o=e}finally{try{!r&&u.return&&u.return()}finally{if(i)throw o}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),i=function(){function e(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,n,r){return n&&e(t.prototype,n),r&&e(t,r),t}}(),o=function(){function e(){n(this,e)}return i(e,[{key:"registerFor",value:function(e){function t(e,t,n){var i=e[0],o=r({top:["scrollTop","pageYOffset","scrollLeft"],left:["scrollLeft","pageXOffset","scrollTop"]}[t],3),a=o[0],u=o[1],s=o[2];return l(i)?angular.isDefined(n)?i.scrollTo(e[s].call(e),n):u in i?i[u]:i.document.documentElement[a]:(angular.isDefined(n)&&(i[a]=n),i[a])}function n(e,t){var n=void 0,i=void 0,a=void 0,s=void 0,c=void 0,f=void 0,d=void 0,p=void 0,h=void 0,g=void 0,m=void 0,v=void 0;if(l(e))return n=document.documentElement[{height:"clientHeight",width:"clientWidth"}[t]],{base:n,padding:0,border:0,margin:0};var b=r({width:[e.offsetWidth,"Left","Right"],height:[e.offsetHeight,"Top","Bottom"]}[t],3);return n=b[0],d=b[1],p=b[2],f=u(e),m=o(e,f["padding"+d])||0,v=o(e,f["padding"+p])||0,i=o(e,f["border"+d+"Width"])||0,a=o(e,f["border"+p+"Width"])||0,s=f["margin"+d],c=f["margin"+p],h=o(e,s)||0,g=o(e,c)||0,{base:n,padding:m+v,border:i+a,margin:h+g}}function i(e,t,r){var i=void 0,o=void 0,a=n(e,t);return a.base>0?{base:a.base-a.padding-a.border,outer:a.base,outerfull:a.base+a.margin}[r]:(i=u(e),o=i[t],(o<0||null===o)&&(o=e.style[t]||0),o=parseFloat(o)||0,{base:o-a.padding-a.border,outer:o,outerfull:o+a.padding+a.border+a.margin}[r])}var o=void 0,a=void 0,u=void 0,l=void 0;return a=angular.element.prototype.css,e.prototype.css=function(e,t){var n=this,r=n[0];if(r&&3!==r.nodeType&&8!==r.nodeType&&r.style)return a.call(n,e,t)},l=function(e){return e&&e.document&&e.location&&e.alert&&e.setInterval},window.getComputedStyle?(u=function(e){return window.getComputedStyle(e,null)},o=function(e,t){return parseFloat(t)}):(u=function(e){return e.currentStyle},o=function(e,t){var n=void 0,r=void 0,i=void 0,o=void 0,a=void 0,u=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,l=new RegExp("^("+u+")(?!px)[a-z%]+$","i");return l.test(t)?(a=e.style,n=a.left,i=e.runtimeStyle,o=i&&i.left,i&&(i.left=a.left),a.left=t,r=a.pixelLeft,a.left=n,o&&(i.left=o),r):parseFloat(t)}),angular.forEach({before:function(e){var t,n,r,i,o,a,u;if(u=this,n=u[0],o=u.parent(),t=o.contents(),t[0]===n)return o.prepend(e);for(r=i=1,a=t.length-1;1<=a?i<=a:i>=a;r=1<=a?++i:--i)if(t[r]===n)return void angular.element(t[r-1]).after(e);throw new Error("invalid DOM structure "+n.outerHTML)},height:function(e){var t;return t=this,angular.isDefined(e)?(angular.isNumber(e)&&(e+="px"),a.call(t,"height",e)):i(this[0],"height","base")},outerHeight:function(e){return i(this[0],"height",e?"outerfull":"outer")},outerWidth:function(e){return i(this[0],"width",e?"outerfull":"outer")},offset:function(e){var t=void 0,n=void 0,r=this,i={top:0,left:0},o=r[0],a=o&&o.ownerDocument;if(arguments.length){if(void 0===e)return r;throw new Error("offset setter method is not implemented")}if(a)return t=a.documentElement,null!=o.getBoundingClientRect&&(i=o.getBoundingClientRect()),n=a.defaultView||a.parentWindow,{top:i.top+(n.pageYOffset||t.scrollTop)-(t.clientTop||0),left:i.left+(n.pageXOffset||t.scrollLeft)-(t.clientLeft||0)}},scrollTop:function(e){return t(this,"top",e)},scrollLeft:function(e){return t(this,"left",e)}},function(t,n){if(!e.prototype[n])return e.prototype[n]=t})}}]),e}();t.default=o},function(e,t){"use strict";function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},i=function(){function e(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,n,r){return n&&e(t.prototype,n),r&&e(t,r),t}}(),o=function(){function e(t,r){n(this,e),this.$animate=t.has&&t.has("$animate")?t.get("$animate"):null,this.isAngularVersionLessThen1_3=1===angular.version.major&&angular.version.minor<3,this.$q=r}return i(e,[{key:"insertElement",value:function(e,t){return t.after(e),[]}},{key:"removeElement",value:function(e){return e.element.remove(),e.scope.$destroy(),[]}},{key:"insertElementAnimated",value:function(e,t){var n=this;if(!this.$animate)return this.insertElement(e,t);if(this.isAngularVersionLessThen1_3){var i=function(){var r=n.$q.defer();return n.$animate.enter(e,null,t,function(){return r.resolve()}),{v:[r.promise]}}();if("object"===("undefined"==typeof i?"undefined":r(i)))return i.v}return[this.$animate.enter(e,null,t)]}},{key:"removeElementAnimated",value:function(e){var t=this;if(!this.$animate)return this.removeElement(e);if(this.isAngularVersionLessThen1_3){var n=function(){var n=t.$q.defer();return t.$animate.leave(e.element,function(){return e.scope.$destroy(),n.resolve()}),{v:[n.promise]}}();if("object"===("undefined"==typeof n?"undefined":r(n)))return n.v}return[this.$animate.leave(e.element).then(function(){return e.scope.$destroy()})]}}]),e}();t.default=o},function(e,t){"use strict";function n(e,t){var n=Object.create(Array.prototype);return angular.extend(n,{size:t,reset:function(e){n.remove(0,n.length),n.eof=!1,n.bof=!1,n.first=e,n.next=e,n.minIndex=e,n.maxIndex=e,n.minIndexUser=null,n.maxIndexUser=null},append:function(e){e.forEach(function(e){++n.next,n.insert("append",e)}),n.maxIndex=n.eof?n.next-1:Math.max(n.next-1,n.maxIndex)},prepend:function(e){e.reverse().forEach(function(e){--n.first,n.insert("prepend",e)}),n.minIndex=n.bof?n.minIndex=n.first:Math.min(n.first,n.minIndex)},insert:function(e,t){var r={item:t};if(e%1===0)r.op="insert",n.splice(e,0,r);else switch(r.op=e,e){case"append":n.push(r);break;case"prepend":n.unshift(r)}},remove:function(t,r){if(angular.isNumber(t)){for(var i=t;i<r;i++)e.removeElement(n[i]);return n.splice(t,r-t)}return n.splice(n.indexOf(t),1),e.removeElementAnimated(t)},effectiveHeight:function(e){if(!e.length)return 0;var t=Number.MAX_VALUE,n=Number.MIN_VALUE;return e.forEach(function(e){e.element[0].offsetParent&&(t=Math.min(t,e.element.offset().top),n=Math.max(n,e.element.offset().top+e.element.outerHeight(!0)))}),Math.max(0,n-t)}}),n}Object.defineProperty(t,"__esModule",{value:!0}),t.default=n},function(e,t,n){"use strict";function r(e){return e&&e.__esModule?e:{default:e}}function i(e,t,n,r,i,o){function u(){return c.outerHeight()*o}var l=null,s=null,c=r&&r.viewport?r.viewport:angular.element(window),f=r&&r.container?r.container:void 0,d=r&&r.scope?r.scope:i;return c.css({"overflow-anchor":"none","overflow-y":"auto",display:"block"}),angular.extend(c,{getScope:function(){return d},createPaddingElements:function(e){l=new a.default(e),s=new a.default(e),n.before(l),n.after(s)},applyContainerStyle:function(){f&&f!==c&&c.css("height",window.getComputedStyle(f[0]).height)},bottomDataPos:function(){var e=c[0].scrollHeight;return e=null!=e?e:c[0].document.documentElement.scrollHeight,e-s.height()},topDataPos:function(){return l.height()},bottomVisiblePos:function(){return c.scrollTop()+c.outerHeight()},topVisiblePos:function(){return c.scrollTop()},insertElement:function(t,n){return e.insertElement(t,n||l)},insertElementAnimated:function(t,n){return e.insertElementAnimated(t,n||l)},shouldLoadBottom:function(){return!t.eof&&c.bottomDataPos()<c.bottomVisiblePos()+u()},clipBottom:function(){for(var e=0,n=0,r=0,i=c.bottomDataPos()-c.bottomVisiblePos()-u(),o=t.length-1;o>=0&&(r=t[o].element.outerHeight(!0),!(n+r>i));o--)s.cache.add(t[o]),n+=r,e++;e>0&&(t.eof=!1,t.remove(t.length-e,t.length),t.next-=e,c.adjustPadding())},shouldLoadTop:function(){return!t.bof&&c.topDataPos()>c.topVisiblePos()-u()},clipTop:function(){for(var e=0,n=0,r=0,i=c.topVisiblePos()-c.topDataPos()-u(),o=0;o<t.length&&(r=t[o].element.outerHeight(!0),!(n+r>i));o++)l.cache.add(t[o]),n+=r,e++;e>0&&(l.height(l.height()+n),t.bof=!1,t.remove(0,e),t.first+=e)},adjustPadding:function(){if(t.length){var e=l.cache.reduce(function(e,n){return e+(n.index<t.first?n.height:0)},0),n=s.cache.reduce(function(e,n){return e+(n.index>=t.next?n.height:0)},0),r=t.reduce(function(e,t){return e+t.element.outerHeight(!0)},0),i=(r+e+n)/(t.maxIndex-t.minIndex+1),o=null!==t.minIndexUser&&t.minIndex>t.minIndexUser,a=null!==t.maxIndexUser&&t.maxIndex<t.maxIndexUser,u=o?(t.minIndex-t.minIndexUser)*i:0,c=a?(t.maxIndexUser-t.maxIndex)*i:0;l.height(e+u),s.height(n+c)}},adjustScrollTopAfterMinIndexSet:function(e){if(null!==t.minIndexUser&&t.minIndex>t.minIndexUser){var n=l.height()-e;c.scrollTop(c.scrollTop()+n)}},adjustScrollTopAfterPrepend:function(e){if(e.prepended.length){var n=t.effectiveHeight(e.prepended),r=l.height()-n;r>=0?l.height(r):(l.height(0),c.scrollTop(c.scrollTop()-r))}},resetTopPadding:function(){l.height(0),l.cache.clear()},resetBottomPadding:function(){s.height(0),s.cache.clear()}}),c}Object.defineProperty(t,"__esModule",{value:!0}),t.default=i;var o=n(5),a=r(o)},function(e,t){"use strict";function n(){var e=Object.create(Array.prototype);return angular.extend(e,{add:function(t){for(var n=e.length-1;n>=0;n--)if(e[n].index===t.scope.$index)return void(e[n].height=t.element.outerHeight());e.push({index:t.scope.$index,height:t.element.outerHeight()})},clear:function(){e.length=0}}),e}function r(e){var t=void 0;switch(e.tagName){case"dl":throw new Error("ui-scroll directive does not support <"+e.tagName+"> as a repeating tag: "+e.outerHTML);case"tr":var r=angular.element("<table><tr><td><div></div></td></tr></table>");t=r.find("tr");break;case"li":t=angular.element("<li></li>");break;default:t=angular.element("<div></div>")}return t.cache=new n,t}Object.defineProperty(t,"__esModule",{value:!0}),t.default=r},function(e,t){"use strict";function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function r(e,t){var n=e.match(/^(.+)(\s+on\s+)(.+)?/);if(n&&4===n.length){window.console.log('Angular ui-scroll adapter assignment warning. "Controller On" syntax has been deprecated since ui-scroll v1.6.1.');for(var r=n[3],i=n[1],o=t;o.length;){var a=o.scope(),u=(o.attr("ng-controller")||"").match(/(\w(?:\w|\d)*)(?:\s+as\s+(\w(?:\w|\d)*))?/);if(u&&u[1]===r)return{target:a,source:i};o=o.parent()}throw new Error('Angular ui-scroll adapter assignment error. Failed to locate target controller "'+r+'" to inject "'+i+'"')}}Object.defineProperty(t,"__esModule",{value:!0});var i=function(){function e(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,n,r){return n&&e(t.prototype,n),r&&e(t,r),t}}(),o=function(){function e(t,r,i,o,a,u,l,s){n(this,e),this.viewport=t,this.buffer=r,this.adjustBuffer=i,this.reload=o,this.isLoading=!1,this.disabled=!1;var c=t.getScope();this.startScope=c.$parent?c:s,this.publicContext={},this.assignAdapter(a.adapter,u,l),this.generatePublicContext(a,u)}return i(e,[{key:"assignAdapter",value:function(e,t,n){if(e&&(e=e.replace(/^\s+|\s+$/gm,""))){var i=r(e,n),o=void 0;try{i?(t(i.source).assign(i.target,{}),o=t(i.source)(i.target)):(t(e).assign(this.startScope,{}),o=t(e)(this.startScope))}catch(t){throw t.message="Angular ui-scroll Adapter assignment exception.\n"+("Can't parse \""+e+'" expression.\n')+t.message,t}angular.extend(o,this.publicContext),this.publicContext=o}}},{key:"generatePublicContext",value:function(e,t){for(var n=this,r=["reload","applyUpdates","append","prepend","isBOF","isEOF","isEmpty"],i=r.length-1;i>=0;i--)this.publicContext[r[i]]=this[r[i]].bind(this);for(var o=["isLoading","topVisible","topVisibleElement","topVisibleScope"],a=function(r){var i=void 0,a=e[o[r]];Object.defineProperty(n,o[r],{get:function(){return i},set:function(e){i=e,n.publicContext[o[r]]=e,a&&t(a).assign(n.startScope,e)}})},u=o.length-1;u>=0;u--)a(u);Object.defineProperty(this.publicContext,"disabled",{get:function(){return n.disabled},set:function(e){return(n.disabled=e)?null:n.adjustBuffer()}})}},{key:"loading",value:function(e){this.isLoading=e}},{key:"isBOF",value:function(){return this.buffer.bof}},{key:"isEOF",value:function(){return this.buffer.eof}},{key:"isEmpty",value:function(){return!this.buffer.length}},{key:"applyUpdates",value:function(e,t){var n=this;if(angular.isFunction(e))this.buffer.slice(0).forEach(function(t){n.applyUpdate(t,e(t.item,t.scope,t.element))});else{if(e%1!==0)throw new Error("applyUpdates - "+e+" is not a valid index");var r=e-this.buffer.first;r>=0&&r<this.buffer.length&&this.applyUpdate(this.buffer[r],t)}this.adjustBuffer()}},{key:"append",value:function(e){this.buffer.append(e),this.adjustBuffer()}},{key:"prepend",value:function(e){this.buffer.prepend(e),this.adjustBuffer()}},{key:"calculateProperties",value:function(){for(var e=void 0,t=void 0,n=void 0,r=void 0,i=null,o=0,a=0;a<this.buffer.length;a++){if(e=this.buffer[a],n=e.element.offset().top,r=i!==n,i=n,r&&(t=e.element.outerHeight(!0)),!(r&&this.viewport.topDataPos()+o+t<=this.viewport.topVisiblePos())){r&&(this.topVisible=e.item,this.topVisibleElement=e.element,this.topVisibleScope=e.scope);break}o+=t}}},{key:"applyUpdate",value:function(e,t){var n=this;if(angular.isArray(t)){var r=void 0,i=this.buffer.indexOf(e)+1;t.reverse().forEach(function(t){t===e.item?(r=!0,i--):n.buffer.insert(i,t)}),r||(e.op="remove")}}}]),e}();t.default=o}]);
//# sourceMappingURL=ui-scroll.min.js.map;

  }).apply(root, arguments);
});
}(this));

(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define('xterm',[],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.Terminal=f()}})(function(){var define,module,exports;return function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s}({1:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var Strings=require("./Strings");var Browser_1=require("./shared/utils/Browser");var RenderDebouncer_1=require("./utils/RenderDebouncer");var Dom_1=require("./utils/Dom");var MAX_ROWS_TO_READ=20;var BoundaryPosition;(function(BoundaryPosition){BoundaryPosition[BoundaryPosition["Top"]=0]="Top";BoundaryPosition[BoundaryPosition["Bottom"]=1]="Bottom"})(BoundaryPosition||(BoundaryPosition={}));var AccessibilityManager=function(){function AccessibilityManager(_terminal){var _this=this;this._terminal=_terminal;this._liveRegionLineCount=0;this._disposables=[];this._charsToConsume=[];this._accessibilityTreeRoot=document.createElement("div");this._accessibilityTreeRoot.classList.add("xterm-accessibility");this._rowContainer=document.createElement("div");this._rowContainer.classList.add("xterm-accessibility-tree");this._rowElements=[];for(var i=0;i<this._terminal.rows;i++){this._rowElements[i]=this._createAccessibilityTreeNode();this._rowContainer.appendChild(this._rowElements[i])}this._topBoundaryFocusListener=function(e){return _this._onBoundaryFocus(e,BoundaryPosition.Top)};this._bottomBoundaryFocusListener=function(e){return _this._onBoundaryFocus(e,BoundaryPosition.Bottom)};this._rowElements[0].addEventListener("focus",this._topBoundaryFocusListener);this._rowElements[this._rowElements.length-1].addEventListener("focus",this._bottomBoundaryFocusListener);this._refreshRowsDimensions();this._accessibilityTreeRoot.appendChild(this._rowContainer);this._renderRowsDebouncer=new RenderDebouncer_1.RenderDebouncer(this._terminal,this._renderRows.bind(this));this._refreshRows();this._liveRegion=document.createElement("div");this._liveRegion.classList.add("live-region");this._liveRegion.setAttribute("aria-live","assertive");this._accessibilityTreeRoot.appendChild(this._liveRegion);this._terminal.element.insertAdjacentElement("afterbegin",this._accessibilityTreeRoot);this._disposables.push(this._renderRowsDebouncer);this._disposables.push(this._terminal.addDisposableListener("resize",function(data){return _this._onResize(data.cols,data.rows)}));this._disposables.push(this._terminal.addDisposableListener("refresh",function(data){return _this._refreshRows(data.start,data.end)}));this._disposables.push(this._terminal.addDisposableListener("scroll",function(data){return _this._refreshRows()}));this._disposables.push(this._terminal.addDisposableListener("a11y.char",function(char){return _this._onChar(char)}));this._disposables.push(this._terminal.addDisposableListener("linefeed",function(){return _this._onChar("\n")}));this._disposables.push(this._terminal.addDisposableListener("a11y.tab",function(spaceCount){return _this._onTab(spaceCount)}));this._disposables.push(this._terminal.addDisposableListener("key",function(keyChar){return _this._onKey(keyChar)}));this._disposables.push(this._terminal.addDisposableListener("blur",function(){return _this._clearLiveRegion()}));this._disposables.push(this._terminal.addDisposableListener("dprchange",function(){return _this._refreshRowsDimensions()}));this._disposables.push(this._terminal.renderer.addDisposableListener("resize",function(){return _this._refreshRowsDimensions()}));this._disposables.push(Dom_1.addDisposableListener(window,"resize",function(){return _this._refreshRowsDimensions()}))}AccessibilityManager.prototype.dispose=function(){this._disposables.forEach(function(d){return d.dispose()});this._disposables.length=0;this._terminal.element.removeChild(this._accessibilityTreeRoot);this._rowElements.length=0};AccessibilityManager.prototype._onBoundaryFocus=function(e,position){var boundaryElement=e.target;var beforeBoundaryElement=this._rowElements[position===BoundaryPosition.Top?1:this._rowElements.length-2];var posInSet=boundaryElement.getAttribute("aria-posinset");var lastRowPos=position===BoundaryPosition.Top?"1":""+this._terminal.buffer.lines.length;if(posInSet===lastRowPos){return}if(e.relatedTarget!==beforeBoundaryElement){return}var topBoundaryElement;var bottomBoundaryElement;if(position===BoundaryPosition.Top){topBoundaryElement=boundaryElement;bottomBoundaryElement=this._rowElements.pop();this._rowContainer.removeChild(bottomBoundaryElement)}else{topBoundaryElement=this._rowElements.shift();bottomBoundaryElement=boundaryElement;this._rowContainer.removeChild(topBoundaryElement)}topBoundaryElement.removeEventListener("focus",this._topBoundaryFocusListener);bottomBoundaryElement.removeEventListener("focus",this._bottomBoundaryFocusListener);if(position===BoundaryPosition.Top){var newElement=this._createAccessibilityTreeNode();this._rowElements.unshift(newElement);this._rowContainer.insertAdjacentElement("afterbegin",newElement)}else{var newElement=this._createAccessibilityTreeNode();this._rowElements.push(newElement);this._rowContainer.appendChild(newElement)}this._rowElements[0].addEventListener("focus",this._topBoundaryFocusListener);this._rowElements[this._rowElements.length-1].addEventListener("focus",this._bottomBoundaryFocusListener);this._terminal.scrollLines(position===BoundaryPosition.Top?-1:1);this._rowElements[position===BoundaryPosition.Top?1:this._rowElements.length-2].focus();e.preventDefault();e.stopImmediatePropagation()};AccessibilityManager.prototype._onResize=function(cols,rows){this._rowElements[this._rowElements.length-1].removeEventListener("focus",this._bottomBoundaryFocusListener);for(var i=this._rowContainer.children.length;i<this._terminal.rows;i++){this._rowElements[i]=this._createAccessibilityTreeNode();this._rowContainer.appendChild(this._rowElements[i])}while(this._rowElements.length>rows){this._rowContainer.removeChild(this._rowElements.pop())}this._rowElements[this._rowElements.length-1].addEventListener("focus",this._bottomBoundaryFocusListener);this._refreshRowsDimensions()};AccessibilityManager.prototype._createAccessibilityTreeNode=function(){var element=document.createElement("div");element.setAttribute("role","listitem");element.tabIndex=-1;this._refreshRowDimensions(element);return element};AccessibilityManager.prototype._onTab=function(spaceCount){for(var i=0;i<spaceCount;i++){this._onChar(" ")}};AccessibilityManager.prototype._onChar=function(char){var _this=this;if(this._liveRegionLineCount<MAX_ROWS_TO_READ+1){if(this._charsToConsume.length>0){var shiftedChar=this._charsToConsume.shift();if(shiftedChar!==char){this._announceCharacter(char)}}else{this._announceCharacter(char)}if(char==="\n"){this._liveRegionLineCount++;if(this._liveRegionLineCount===MAX_ROWS_TO_READ+1){this._liveRegion.textContent+=Strings.tooMuchOutput}}if(Browser_1.isMac){if(this._liveRegion.textContent&&this._liveRegion.textContent.length>0&&!this._liveRegion.parentNode){setTimeout(function(){_this._accessibilityTreeRoot.appendChild(_this._liveRegion)},0)}}}};AccessibilityManager.prototype._clearLiveRegion=function(){this._liveRegion.textContent="";this._liveRegionLineCount=0;if(Browser_1.isMac){if(this._liveRegion.parentNode){this._accessibilityTreeRoot.removeChild(this._liveRegion)}}};AccessibilityManager.prototype._onKey=function(keyChar){this._clearLiveRegion();this._charsToConsume.push(keyChar)};AccessibilityManager.prototype._refreshRows=function(start,end){this._renderRowsDebouncer.refresh(start,end)};AccessibilityManager.prototype._renderRows=function(start,end){var buffer=this._terminal.buffer;var setSize=buffer.lines.length.toString();for(var i=start;i<=end;i++){var lineData=buffer.translateBufferLineToString(buffer.ydisp+i,true);var posInSet=(buffer.ydisp+i+1).toString();var element=this._rowElements[i];element.textContent=lineData.length===0?Strings.blankLine:lineData;element.setAttribute("aria-posinset",posInSet);element.setAttribute("aria-setsize",setSize)}};AccessibilityManager.prototype._refreshRowsDimensions=function(){if(!this._terminal.renderer.dimensions.actualCellHeight){return}for(var i=0;i<this._terminal.rows;i++){this._refreshRowDimensions(this._rowElements[i])}};AccessibilityManager.prototype._refreshRowDimensions=function(element){element.style.height=this._terminal.renderer.dimensions.actualCellHeight+"px"};AccessibilityManager.prototype._announceCharacter=function(char){if(char===" "){this._liveRegion.innerHTML+="&nbsp;"}else{this._liveRegion.textContent+=char}};return AccessibilityManager}();exports.AccessibilityManager=AccessibilityManager},{"./Strings":15,"./shared/utils/Browser":36,"./utils/Dom":40,"./utils/RenderDebouncer":42}],2:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:true});var CircularList_1=require("./utils/CircularList");var EventEmitter_1=require("./EventEmitter");exports.CHAR_DATA_ATTR_INDEX=0;exports.CHAR_DATA_CHAR_INDEX=1;exports.CHAR_DATA_WIDTH_INDEX=2;exports.CHAR_DATA_CODE_INDEX=3;exports.MAX_BUFFER_SIZE=4294967295;var Buffer=function(){function Buffer(_terminal,_hasScrollback){this._terminal=_terminal;this._hasScrollback=_hasScrollback;this.markers=[];this.clear()}Object.defineProperty(Buffer.prototype,"lines",{get:function(){return this._lines},enumerable:true,configurable:true});Object.defineProperty(Buffer.prototype,"hasScrollback",{get:function(){return this._hasScrollback&&this.lines.maxLength>this._terminal.rows},enumerable:true,configurable:true});Object.defineProperty(Buffer.prototype,"isCursorInViewport",{get:function(){var absoluteY=this.ybase+this.y;var relativeY=absoluteY-this.ydisp;return relativeY>=0&&relativeY<this._terminal.rows},enumerable:true,configurable:true});Buffer.prototype._getCorrectBufferLength=function(rows){if(!this._hasScrollback){return rows}var correctBufferLength=rows+this._terminal.options.scrollback;return correctBufferLength>exports.MAX_BUFFER_SIZE?exports.MAX_BUFFER_SIZE:correctBufferLength};Buffer.prototype.fillViewportRows=function(){if(this._lines.length===0){var i=this._terminal.rows;while(i--){this.lines.push(this._terminal.blankLine())}}};Buffer.prototype.clear=function(){this.ydisp=0;this.ybase=0;this.y=0;this.x=0;this._lines=new CircularList_1.CircularList(this._getCorrectBufferLength(this._terminal.rows));this.scrollTop=0;this.scrollBottom=this._terminal.rows-1;this.setupTabStops()};Buffer.prototype.resize=function(newCols,newRows){var newMaxLength=this._getCorrectBufferLength(newRows);if(newMaxLength>this._lines.maxLength){this._lines.maxLength=newMaxLength}if(this._lines.length>0){if(this._terminal.cols<newCols){var ch=[this._terminal.defAttr," ",1,32];for(var i=0;i<this._lines.length;i++){while(this._lines.get(i).length<newCols){this._lines.get(i).push(ch)}}}var addToY=0;if(this._terminal.rows<newRows){for(var y=this._terminal.rows;y<newRows;y++){if(this._lines.length<newRows+this.ybase){if(this.ybase>0&&this._lines.length<=this.ybase+this.y+addToY+1){this.ybase--;addToY++;if(this.ydisp>0){this.ydisp--}}else{this._lines.push(this._terminal.blankLine(undefined,undefined,newCols))}}}}else{for(var y=this._terminal.rows;y>newRows;y--){if(this._lines.length>newRows+this.ybase){if(this._lines.length>this.ybase+this.y+1){this._lines.pop()}else{this.ybase++;this.ydisp++}}}}if(newMaxLength<this._lines.maxLength){var amountToTrim=this._lines.length-newMaxLength;if(amountToTrim>0){this._lines.trimStart(amountToTrim);this.ybase=Math.max(this.ybase-amountToTrim,0);this.ydisp=Math.max(this.ydisp-amountToTrim,0)}this._lines.maxLength=newMaxLength}this.x=Math.min(this.x,newCols-1);this.y=Math.min(this.y,newRows-1);if(addToY){this.y+=addToY}this.savedY=Math.min(this.savedY,newRows-1);this.savedX=Math.min(this.savedX,newCols-1);this.scrollTop=0}this.scrollBottom=newRows-1};Buffer.prototype.translateBufferLineToString=function(lineIndex,trimRight,startCol,endCol){if(startCol===void 0){startCol=0}if(endCol===void 0){endCol=null}var lineString="";var line=this.lines.get(lineIndex);if(!line){return""}var startIndex=startCol;if(endCol===null){endCol=line.length}var endIndex=endCol;for(var i=0;i<line.length;i++){var char=line[i];lineString+=char[exports.CHAR_DATA_CHAR_INDEX];if(char[exports.CHAR_DATA_WIDTH_INDEX]===0){if(startCol>=i){startIndex--}if(endCol>=i){endIndex--}}else{if(char[exports.CHAR_DATA_CHAR_INDEX].length>1){if(startCol>i){startIndex+=char[exports.CHAR_DATA_CHAR_INDEX].length-1}if(endCol>i){endIndex+=char[exports.CHAR_DATA_CHAR_INDEX].length-1}}}}if(trimRight){var rightWhitespaceIndex=lineString.search(/\s+$/);if(rightWhitespaceIndex!==-1){endIndex=Math.min(endIndex,rightWhitespaceIndex)}if(endIndex<=startIndex){return""}}return lineString.substring(startIndex,endIndex)};Buffer.prototype.setupTabStops=function(i){if(i!=null){if(!this.tabs[i]){i=this.prevStop(i)}}else{this.tabs={};i=0}for(;i<this._terminal.cols;i+=this._terminal.options.tabStopWidth){this.tabs[i]=true}};Buffer.prototype.prevStop=function(x){if(x==null){x=this.x}while(!this.tabs[--x]&&x>0);return x>=this._terminal.cols?this._terminal.cols-1:x<0?0:x};Buffer.prototype.nextStop=function(x){if(x==null){x=this.x}while(!this.tabs[++x]&&x<this._terminal.cols);return x>=this._terminal.cols?this._terminal.cols-1:x<0?0:x};Buffer.prototype.addMarker=function(y){var _this=this;var marker=new Marker(y);this.markers.push(marker);marker.disposables.push(this._lines.addDisposableListener("trim",function(amount){marker.line-=amount;if(marker.line<0){marker.dispose()}}));marker.on("dispose",function(){return _this._removeMarker(marker)});return marker};Buffer.prototype._removeMarker=function(marker){this.markers.splice(this.markers.indexOf(marker),1)};return Buffer}();exports.Buffer=Buffer;var Marker=function(_super){__extends(Marker,_super);function Marker(line){var _this=_super.call(this)||this;_this.line=line;_this._id=Marker.NEXT_ID++;_this.isDisposed=false;_this.disposables=[];return _this}Object.defineProperty(Marker.prototype,"id",{get:function(){return this._id},enumerable:true,configurable:true});Marker.prototype.dispose=function(){if(this.isDisposed){return}this.isDisposed=true;this.disposables.forEach(function(d){return d.dispose()});this.disposables.length=0;this.emit("dispose")};Marker.NEXT_ID=1;return Marker}(EventEmitter_1.EventEmitter);exports.Marker=Marker},{"./EventEmitter":8,"./utils/CircularList":38}],3:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:true});var Buffer_1=require("./Buffer");var EventEmitter_1=require("./EventEmitter");var BufferSet=function(_super){__extends(BufferSet,_super);function BufferSet(_terminal){var _this=_super.call(this)||this;_this._terminal=_terminal;_this._normal=new Buffer_1.Buffer(_this._terminal,true);_this._normal.fillViewportRows();_this._alt=new Buffer_1.Buffer(_this._terminal,false);_this._activeBuffer=_this._normal;_this.setupTabStops();return _this}Object.defineProperty(BufferSet.prototype,"alt",{get:function(){return this._alt},enumerable:true,configurable:true});Object.defineProperty(BufferSet.prototype,"active",{get:function(){return this._activeBuffer},enumerable:true,configurable:true});Object.defineProperty(BufferSet.prototype,"normal",{get:function(){return this._normal},enumerable:true,configurable:true});BufferSet.prototype.activateNormalBuffer=function(){if(this._activeBuffer===this._normal){return}this._alt.clear();this._activeBuffer=this._normal;this.emit("activate",{activeBuffer:this._normal,inactiveBuffer:this._alt})};BufferSet.prototype.activateAltBuffer=function(){if(this._activeBuffer===this._alt){return}this._alt.fillViewportRows();this._activeBuffer=this._alt;this.emit("activate",{activeBuffer:this._alt,inactiveBuffer:this._normal})};BufferSet.prototype.resize=function(newCols,newRows){this._normal.resize(newCols,newRows);this._alt.resize(newCols,newRows)};BufferSet.prototype.setupTabStops=function(i){this._normal.setupTabStops(i);this._alt.setupTabStops(i)};return BufferSet}(EventEmitter_1.EventEmitter);exports.BufferSet=BufferSet},{"./Buffer":2,"./EventEmitter":8}],4:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.wcwidth=function(opts){var COMBINING_BMP=[[768,879],[1155,1158],[1160,1161],[1425,1469],[1471,1471],[1473,1474],[1476,1477],[1479,1479],[1536,1539],[1552,1557],[1611,1630],[1648,1648],[1750,1764],[1767,1768],[1770,1773],[1807,1807],[1809,1809],[1840,1866],[1958,1968],[2027,2035],[2305,2306],[2364,2364],[2369,2376],[2381,2381],[2385,2388],[2402,2403],[2433,2433],[2492,2492],[2497,2500],[2509,2509],[2530,2531],[2561,2562],[2620,2620],[2625,2626],[2631,2632],[2635,2637],[2672,2673],[2689,2690],[2748,2748],[2753,2757],[2759,2760],[2765,2765],[2786,2787],[2817,2817],[2876,2876],[2879,2879],[2881,2883],[2893,2893],[2902,2902],[2946,2946],[3008,3008],[3021,3021],[3134,3136],[3142,3144],[3146,3149],[3157,3158],[3260,3260],[3263,3263],[3270,3270],[3276,3277],[3298,3299],[3393,3395],[3405,3405],[3530,3530],[3538,3540],[3542,3542],[3633,3633],[3636,3642],[3655,3662],[3761,3761],[3764,3769],[3771,3772],[3784,3789],[3864,3865],[3893,3893],[3895,3895],[3897,3897],[3953,3966],[3968,3972],[3974,3975],[3984,3991],[3993,4028],[4038,4038],[4141,4144],[4146,4146],[4150,4151],[4153,4153],[4184,4185],[4448,4607],[4959,4959],[5906,5908],[5938,5940],[5970,5971],[6002,6003],[6068,6069],[6071,6077],[6086,6086],[6089,6099],[6109,6109],[6155,6157],[6313,6313],[6432,6434],[6439,6440],[6450,6450],[6457,6459],[6679,6680],[6912,6915],[6964,6964],[6966,6970],[6972,6972],[6978,6978],[7019,7027],[7616,7626],[7678,7679],[8203,8207],[8234,8238],[8288,8291],[8298,8303],[8400,8431],[12330,12335],[12441,12442],[43014,43014],[43019,43019],[43045,43046],[64286,64286],[65024,65039],[65056,65059],[65279,65279],[65529,65531]];var COMBINING_HIGH=[[68097,68099],[68101,68102],[68108,68111],[68152,68154],[68159,68159],[119143,119145],[119155,119170],[119173,119179],[119210,119213],[119362,119364],[917505,917505],[917536,917631],[917760,917999]];function bisearch(ucs,data){var min=0;var max=data.length-1;var mid;if(ucs<data[0][0]||ucs>data[max][1]){return false}while(max>=min){mid=min+max>>1;if(ucs>data[mid][1]){min=mid+1}else if(ucs<data[mid][0]){max=mid-1}else{return true}}return false}function wcwidthBMP(ucs){if(ucs===0){return opts.nul}if(ucs<32||ucs>=127&&ucs<160){return opts.control}if(bisearch(ucs,COMBINING_BMP)){return 0}if(isWideBMP(ucs)){return 2}return 1}function isWideBMP(ucs){return ucs>=4352&&(ucs<=4447||ucs===9001||ucs===9002||ucs>=11904&&ucs<=42191&&ucs!==12351||ucs>=44032&&ucs<=55203||ucs>=63744&&ucs<=64255||ucs>=65040&&ucs<=65049||ucs>=65072&&ucs<=65135||ucs>=65280&&ucs<=65376||ucs>=65504&&ucs<=65510)}function wcwidthHigh(ucs){if(bisearch(ucs,COMBINING_HIGH)){return 0}if(ucs>=131072&&ucs<=196605||ucs>=196608&&ucs<=262141){return 2}return 1}var control=opts.control|0;var table=null;function init_table(){var CODEPOINTS=65536;var BITWIDTH=2;var ITEMSIZE=32;var CONTAINERSIZE=CODEPOINTS*BITWIDTH/ITEMSIZE;var CODEPOINTS_PER_ITEM=ITEMSIZE/BITWIDTH;table=typeof Uint32Array==="undefined"?new Array(CONTAINERSIZE):new Uint32Array(CONTAINERSIZE);for(var i=0;i<CONTAINERSIZE;++i){var num=0;var pos=CODEPOINTS_PER_ITEM;while(pos--){num=num<<2|wcwidthBMP(CODEPOINTS_PER_ITEM*i+pos)}table[i]=num}return table}return function(num){num=num|0;if(num<32){return control|0}if(num<127){return 1}var t=table||init_table();if(num<65536){return t[num>>4]>>((num&15)<<1)&3}return wcwidthHigh(num)}}({nul:0,control:0})},{}],5:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.CHARSETS={};exports.DEFAULT_CHARSET=exports.CHARSETS["B"];exports.CHARSETS["0"]={"`":"◆",a:"▒",b:"\t",c:"\f",d:"\r",e:"\n",f:"°",g:"±",h:"␤",i:"\v",j:"┘",k:"┐",l:"┌",m:"└",n:"┼",o:"⎺",p:"⎻",q:"─",r:"⎼",s:"⎽",t:"├",u:"┤",v:"┴",w:"┬",x:"│",y:"≤",z:"≥","{":"π","|":"≠","}":"£","~":"·"};exports.CHARSETS["A"]={"#":"£"};exports.CHARSETS["B"]=null;exports.CHARSETS["4"]={"#":"£","@":"¾","[":"ij","\\":"½","]":"|","{":"¨","|":"f","}":"¼","~":"´"};exports.CHARSETS["C"]=exports.CHARSETS["5"]={"[":"Ä","\\":"Ö","]":"Å","^":"Ü","`":"é","{":"ä","|":"ö","}":"å","~":"ü"};exports.CHARSETS["R"]={"#":"£","@":"à","[":"°","\\":"ç","]":"§","{":"é","|":"ù","}":"è","~":"¨"};exports.CHARSETS["Q"]={"@":"à","[":"â","\\":"ç","]":"ê","^":"î","`":"ô","{":"é","|":"ù","}":"è","~":"û"};exports.CHARSETS["K"]={"@":"§","[":"Ä","\\":"Ö","]":"Ü","{":"ä","|":"ö","}":"ü","~":"ß"};exports.CHARSETS["Y"]={"#":"£","@":"§","[":"°","\\":"ç","]":"é","`":"ù","{":"à","|":"ò","}":"è","~":"ì"};exports.CHARSETS["E"]=exports.CHARSETS["6"]={"@":"Ä","[":"Æ","\\":"Ø","]":"Å","^":"Ü","`":"ä","{":"æ","|":"ø","}":"å","~":"ü"};exports.CHARSETS["Z"]={"#":"£","@":"§","[":"¡","\\":"Ñ","]":"¿","{":"°","|":"ñ","}":"ç"};exports.CHARSETS["H"]=exports.CHARSETS["7"]={"@":"É","[":"Ä","\\":"Ö","]":"Å","^":"Ü","`":"é","{":"ä","|":"ö","}":"å","~":"ü"};exports.CHARSETS["="]={"#":"ù","@":"à","[":"é","\\":"ç","]":"ê","^":"î",_:"è","`":"ô","{":"ä","|":"ö","}":"ü","~":"û"}},{}],6:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var CompositionHelper=function(){function CompositionHelper(_textarea,_compositionView,_terminal){this._textarea=_textarea;this._compositionView=_compositionView;this._terminal=_terminal;this._isComposing=false;this._isSendingComposition=false;this._compositionPosition={start:null,end:null}}CompositionHelper.prototype.compositionstart=function(){this._isComposing=true;this._compositionPosition.start=this._textarea.value.length;this._compositionView.textContent="";this._compositionView.classList.add("active")};CompositionHelper.prototype.compositionupdate=function(ev){var _this=this;this._compositionView.textContent=ev.data;this.updateCompositionElements();setTimeout(function(){_this._compositionPosition.end=_this._textarea.value.length},0)};CompositionHelper.prototype.compositionend=function(){this._finalizeComposition(true)};CompositionHelper.prototype.keydown=function(ev){if(this._isComposing||this._isSendingComposition){if(ev.keyCode===229){return false}else if(ev.keyCode===16||ev.keyCode===17||ev.keyCode===18){return false}else{this._finalizeComposition(false)}}if(ev.keyCode===229){this._handleAnyTextareaChanges();return false}return true};CompositionHelper.prototype._finalizeComposition=function(waitForPropogation){var _this=this;this._compositionView.classList.remove("active");this._isComposing=false;this._clearTextareaPosition();if(!waitForPropogation){this._isSendingComposition=false;var input=this._textarea.value.substring(this._compositionPosition.start,this._compositionPosition.end);this._terminal.handler(input)}else{var currentCompositionPosition_1={start:this._compositionPosition.start,end:this._compositionPosition.end};this._isSendingComposition=true;setTimeout(function(){if(_this._isSendingComposition){_this._isSendingComposition=false;var input=void 0;if(_this._isComposing){input=_this._textarea.value.substring(currentCompositionPosition_1.start,currentCompositionPosition_1.end)}else{input=_this._textarea.value.substring(currentCompositionPosition_1.start)}_this._terminal.handler(input)}},0)}};CompositionHelper.prototype._handleAnyTextareaChanges=function(){var _this=this;var oldValue=this._textarea.value;setTimeout(function(){if(!_this._isComposing){var newValue=_this._textarea.value;var diff=newValue.replace(oldValue,"");if(diff.length>0){_this._terminal.handler(diff)}}},0)};CompositionHelper.prototype.updateCompositionElements=function(dontRecurse){var _this=this;if(!this._isComposing){return}if(this._terminal.buffer.isCursorInViewport){var cellHeight=Math.ceil(this._terminal.charMeasure.height*this._terminal.options.lineHeight);var cursorTop=this._terminal.buffer.y*cellHeight;var cursorLeft=this._terminal.buffer.x*this._terminal.charMeasure.width;this._compositionView.style.left=cursorLeft+"px";this._compositionView.style.top=cursorTop+"px";this._compositionView.style.height=cellHeight+"px";this._compositionView.style.lineHeight=cellHeight+"px";var compositionViewBounds=this._compositionView.getBoundingClientRect();this._textarea.style.left=cursorLeft+"px";this._textarea.style.top=cursorTop+"px";this._textarea.style.width=compositionViewBounds.width+"px";this._textarea.style.height=compositionViewBounds.height+"px";this._textarea.style.lineHeight=compositionViewBounds.height+"px"}if(!dontRecurse){setTimeout(function(){return _this.updateCompositionElements(true)},0)}};CompositionHelper.prototype._clearTextareaPosition=function(){this._textarea.style.left="";this._textarea.style.top=""};return CompositionHelper}();exports.CompositionHelper=CompositionHelper},{}],7:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var C0;(function(C0){C0.NUL="\0";C0.SOH="";C0.STX="";C0.ETX="";C0.EOT="";C0.ENQ="";C0.ACK="";C0.BEL="";C0.BS="\b";C0.HT="\t";C0.LF="\n";C0.VT="\v";C0.FF="\f";C0.CR="\r";C0.SO="";C0.SI="";C0.DLE="";C0.DC1="";C0.DC2="";C0.DC3="";C0.DC4="";C0.NAK="";C0.SYN="";C0.ETB="";C0.CAN="";C0.EM="";C0.SUB="";C0.ESC="";C0.FS="";C0.GS="";C0.RS="";C0.US="";C0.SP=" ";C0.DEL=""})(C0=exports.C0||(exports.C0={}))},{}],8:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var EventEmitter=function(){function EventEmitter(){this._events=this._events||{}}EventEmitter.prototype.on=function(type,listener){this._events[type]=this._events[type]||[];this._events[type].push(listener)};EventEmitter.prototype.addDisposableListener=function(type,handler){var _this=this;this.on(type,handler);return{dispose:function(){if(!handler){return}_this.off(type,handler);handler=null}}};EventEmitter.prototype.off=function(type,listener){if(!this._events[type]){return}var obj=this._events[type];var i=obj.length;while(i--){if(obj[i]===listener){obj.splice(i,1);return}}};EventEmitter.prototype.removeAllListeners=function(type){if(this._events[type]){delete this._events[type]}};EventEmitter.prototype.emit=function(type){var args=[];for(var _i=1;_i<arguments.length;_i++){args[_i-1]=arguments[_i]}if(!this._events[type]){return}var obj=this._events[type];for(var i=0;i<obj.length;i++){obj[i].apply(this,args)}};EventEmitter.prototype.listeners=function(type){return this._events[type]||[]};EventEmitter.prototype.destroy=function(){this._events={}};return EventEmitter}();exports.EventEmitter=EventEmitter},{}],9:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var EscapeSequences_1=require("./EscapeSequences");var Charsets_1=require("./Charsets");var Buffer_1=require("./Buffer");var Types_1=require("./renderer/Types");var CharWidth_1=require("./CharWidth");var InputHandler=function(){function InputHandler(_terminal){this._terminal=_terminal}InputHandler.prototype.addChar=function(char,code){if(char>=" "){var chWidth=CharWidth_1.wcwidth(code);if(this._terminal.charset&&this._terminal.charset[char]){char=this._terminal.charset[char]}if(this._terminal.options.screenReaderMode){this._terminal.emit("a11y.char",char)}var row=this._terminal.buffer.y+this._terminal.buffer.ybase;if(!chWidth&&this._terminal.buffer.x){if(this._terminal.buffer.lines.get(row)[this._terminal.buffer.x-1]){if(!this._terminal.buffer.lines.get(row)[this._terminal.buffer.x-1][Buffer_1.CHAR_DATA_WIDTH_INDEX]){if(this._terminal.buffer.lines.get(row)[this._terminal.buffer.x-2]){this._terminal.buffer.lines.get(row)[this._terminal.buffer.x-2][Buffer_1.CHAR_DATA_CHAR_INDEX]+=char;this._terminal.buffer.lines.get(row)[this._terminal.buffer.x-2][3]=char.charCodeAt(0)}}else{this._terminal.buffer.lines.get(row)[this._terminal.buffer.x-1][Buffer_1.CHAR_DATA_CHAR_INDEX]+=char;this._terminal.buffer.lines.get(row)[this._terminal.buffer.x-1][3]=char.charCodeAt(0)}this._terminal.updateRange(this._terminal.buffer.y)}return}if(this._terminal.buffer.x+chWidth-1>=this._terminal.cols){if(this._terminal.wraparoundMode){this._terminal.buffer.x=0;this._terminal.buffer.y++;if(this._terminal.buffer.y>this._terminal.buffer.scrollBottom){this._terminal.buffer.y--;this._terminal.scroll(true)}else{this._terminal.buffer.lines.get(this._terminal.buffer.y).isWrapped=true}}else{if(chWidth===2){return}}}row=this._terminal.buffer.y+this._terminal.buffer.ybase;if(this._terminal.insertMode){for(var moves=0;moves<chWidth;++moves){var removed=this._terminal.buffer.lines.get(this._terminal.buffer.y+this._terminal.buffer.ybase).pop();if(removed[Buffer_1.CHAR_DATA_WIDTH_INDEX]===0&&this._terminal.buffer.lines.get(row)[this._terminal.cols-2]&&this._terminal.buffer.lines.get(row)[this._terminal.cols-2][Buffer_1.CHAR_DATA_WIDTH_INDEX]===2){this._terminal.buffer.lines.get(row)[this._terminal.cols-2]=[this._terminal.curAttr," ",1," ".charCodeAt(0)]}this._terminal.buffer.lines.get(row).splice(this._terminal.buffer.x,0,[this._terminal.curAttr," ",1," ".charCodeAt(0)])}}this._terminal.buffer.lines.get(row)[this._terminal.buffer.x]=[this._terminal.curAttr,char,chWidth,char.charCodeAt(0)];this._terminal.buffer.x++;this._terminal.updateRange(this._terminal.buffer.y);if(chWidth===2){this._terminal.buffer.lines.get(row)[this._terminal.buffer.x]=[this._terminal.curAttr,"",0,undefined];this._terminal.buffer.x++}}};InputHandler.prototype.bell=function(){this._terminal.bell()};InputHandler.prototype.lineFeed=function(){if(this._terminal.convertEol){this._terminal.buffer.x=0}this._terminal.buffer.y++;if(this._terminal.buffer.y>this._terminal.buffer.scrollBottom){this._terminal.buffer.y--;this._terminal.scroll()}if(this._terminal.buffer.x>=this._terminal.cols){this._terminal.buffer.x--}this._terminal.emit("linefeed")};InputHandler.prototype.carriageReturn=function(){this._terminal.buffer.x=0};InputHandler.prototype.backspace=function(){if(this._terminal.buffer.x>0){this._terminal.buffer.x--}};InputHandler.prototype.tab=function(){var originalX=this._terminal.buffer.x;this._terminal.buffer.x=this._terminal.buffer.nextStop();if(this._terminal.options.screenReaderMode){this._terminal.emit("a11y.tab",this._terminal.buffer.x-originalX)}};InputHandler.prototype.shiftOut=function(){this._terminal.setgLevel(1)};InputHandler.prototype.shiftIn=function(){this._terminal.setgLevel(0)};InputHandler.prototype.insertChars=function(params){var param=params[0];if(param<1)param=1;var row=this._terminal.buffer.y+this._terminal.buffer.ybase;var j=this._terminal.buffer.x;var ch=[this._terminal.eraseAttr()," ",1,32];while(param--&&j<this._terminal.cols){this._terminal.buffer.lines.get(row).splice(j++,0,ch);this._terminal.buffer.lines.get(row).pop()}};InputHandler.prototype.cursorUp=function(params){var param=params[0];if(param<1){param=1}this._terminal.buffer.y-=param;if(this._terminal.buffer.y<0){this._terminal.buffer.y=0}};InputHandler.prototype.cursorDown=function(params){var param=params[0];if(param<1){param=1}this._terminal.buffer.y+=param;if(this._terminal.buffer.y>=this._terminal.rows){this._terminal.buffer.y=this._terminal.rows-1}if(this._terminal.buffer.x>=this._terminal.cols){this._terminal.buffer.x--}};InputHandler.prototype.cursorForward=function(params){var param=params[0];if(param<1){param=1}this._terminal.buffer.x+=param;if(this._terminal.buffer.x>=this._terminal.cols){this._terminal.buffer.x=this._terminal.cols-1}};InputHandler.prototype.cursorBackward=function(params){var param=params[0];if(param<1){param=1}if(this._terminal.buffer.x>=this._terminal.cols){this._terminal.buffer.x--}this._terminal.buffer.x-=param;if(this._terminal.buffer.x<0){this._terminal.buffer.x=0}};InputHandler.prototype.cursorNextLine=function(params){var param=params[0];if(param<1){param=1}this._terminal.buffer.y+=param;if(this._terminal.buffer.y>=this._terminal.rows){this._terminal.buffer.y=this._terminal.rows-1}this._terminal.buffer.x=0};InputHandler.prototype.cursorPrecedingLine=function(params){var param=params[0];if(param<1){param=1}this._terminal.buffer.y-=param;if(this._terminal.buffer.y<0){this._terminal.buffer.y=0}this._terminal.buffer.x=0};InputHandler.prototype.cursorCharAbsolute=function(params){var param=params[0];if(param<1){param=1}this._terminal.buffer.x=param-1};InputHandler.prototype.cursorPosition=function(params){var col;var row=params[0]-1;if(params.length>=2){col=params[1]-1}else{col=0}if(row<0){row=0}else if(row>=this._terminal.rows){row=this._terminal.rows-1}if(col<0){col=0}else if(col>=this._terminal.cols){col=this._terminal.cols-1}this._terminal.buffer.x=col;this._terminal.buffer.y=row};InputHandler.prototype.cursorForwardTab=function(params){var param=params[0]||1;while(param--){this._terminal.buffer.x=this._terminal.buffer.nextStop()}};InputHandler.prototype.eraseInDisplay=function(params){var j;switch(params[0]){case 0:this._terminal.eraseRight(this._terminal.buffer.x,this._terminal.buffer.y);j=this._terminal.buffer.y+1;for(;j<this._terminal.rows;j++){this._terminal.eraseLine(j)}break;case 1:this._terminal.eraseLeft(this._terminal.buffer.x,this._terminal.buffer.y);j=this._terminal.buffer.y;while(j--){this._terminal.eraseLine(j)}break;case 2:j=this._terminal.rows;while(j--)this._terminal.eraseLine(j);break;case 3:var scrollBackSize=this._terminal.buffer.lines.length-this._terminal.rows;if(scrollBackSize>0){this._terminal.buffer.lines.trimStart(scrollBackSize);this._terminal.buffer.ybase=Math.max(this._terminal.buffer.ybase-scrollBackSize,0);this._terminal.buffer.ydisp=Math.max(this._terminal.buffer.ydisp-scrollBackSize,0);this._terminal.emit("scroll",0)}break}};InputHandler.prototype.eraseInLine=function(params){switch(params[0]){case 0:this._terminal.eraseRight(this._terminal.buffer.x,this._terminal.buffer.y);break;case 1:this._terminal.eraseLeft(this._terminal.buffer.x,this._terminal.buffer.y);break;case 2:this._terminal.eraseLine(this._terminal.buffer.y);break}};InputHandler.prototype.insertLines=function(params){var param=params[0];if(param<1){param=1}var row=this._terminal.buffer.y+this._terminal.buffer.ybase;var scrollBottomRowsOffset=this._terminal.rows-1-this._terminal.buffer.scrollBottom;var scrollBottomAbsolute=this._terminal.rows-1+this._terminal.buffer.ybase-scrollBottomRowsOffset+1;while(param--){this._terminal.buffer.lines.splice(scrollBottomAbsolute-1,1);this._terminal.buffer.lines.splice(row,0,this._terminal.blankLine(true))}this._terminal.updateRange(this._terminal.buffer.y);this._terminal.updateRange(this._terminal.buffer.scrollBottom)};InputHandler.prototype.deleteLines=function(params){var param=params[0];if(param<1){param=1}var row=this._terminal.buffer.y+this._terminal.buffer.ybase;var j;j=this._terminal.rows-1-this._terminal.buffer.scrollBottom;j=this._terminal.rows-1+this._terminal.buffer.ybase-j;while(param--){this._terminal.buffer.lines.splice(row,1);this._terminal.buffer.lines.splice(j,0,this._terminal.blankLine(true))}this._terminal.updateRange(this._terminal.buffer.y);this._terminal.updateRange(this._terminal.buffer.scrollBottom)};InputHandler.prototype.deleteChars=function(params){var param=params[0];if(param<1){param=1}var row=this._terminal.buffer.y+this._terminal.buffer.ybase;var ch=[this._terminal.eraseAttr()," ",1,32];while(param--){this._terminal.buffer.lines.get(row).splice(this._terminal.buffer.x,1);this._terminal.buffer.lines.get(row).push(ch)}this._terminal.updateRange(this._terminal.buffer.y)};InputHandler.prototype.scrollUp=function(params){var param=params[0]||1;while(param--){this._terminal.buffer.lines.splice(this._terminal.buffer.ybase+this._terminal.buffer.scrollTop,1);this._terminal.buffer.lines.splice(this._terminal.buffer.ybase+this._terminal.buffer.scrollBottom,0,this._terminal.blankLine())}this._terminal.updateRange(this._terminal.buffer.scrollTop);this._terminal.updateRange(this._terminal.buffer.scrollBottom)};InputHandler.prototype.scrollDown=function(params){var param=params[0]||1;while(param--){this._terminal.buffer.lines.splice(this._terminal.buffer.ybase+this._terminal.buffer.scrollBottom,1);this._terminal.buffer.lines.splice(this._terminal.buffer.ybase+this._terminal.buffer.scrollTop,0,this._terminal.blankLine())}this._terminal.updateRange(this._terminal.buffer.scrollTop);this._terminal.updateRange(this._terminal.buffer.scrollBottom)};InputHandler.prototype.eraseChars=function(params){var param=params[0];if(param<1){param=1}var row=this._terminal.buffer.y+this._terminal.buffer.ybase;var j=this._terminal.buffer.x;var ch=[this._terminal.eraseAttr()," ",1,32];while(param--&&j<this._terminal.cols){this._terminal.buffer.lines.get(row)[j++]=ch}};InputHandler.prototype.cursorBackwardTab=function(params){var param=params[0]||1;while(param--){this._terminal.buffer.x=this._terminal.buffer.prevStop()}};InputHandler.prototype.charPosAbsolute=function(params){var param=params[0];if(param<1){param=1}this._terminal.buffer.x=param-1;if(this._terminal.buffer.x>=this._terminal.cols){this._terminal.buffer.x=this._terminal.cols-1}};InputHandler.prototype.HPositionRelative=function(params){var param=params[0];if(param<1){param=1}this._terminal.buffer.x+=param;if(this._terminal.buffer.x>=this._terminal.cols){this._terminal.buffer.x=this._terminal.cols-1}};InputHandler.prototype.repeatPrecedingCharacter=function(params){var param=params[0]||1;var line=this._terminal.buffer.lines.get(this._terminal.buffer.ybase+this._terminal.buffer.y);var ch=line[this._terminal.buffer.x-1]||[this._terminal.defAttr," ",1,32];while(param--){line[this._terminal.buffer.x++]=ch}};InputHandler.prototype.sendDeviceAttributes=function(params){if(params[0]>0){return}if(!this._terminal.prefix){if(this._terminal.is("xterm")||this._terminal.is("rxvt-unicode")||this._terminal.is("screen")){this._terminal.send(EscapeSequences_1.C0.ESC+"[?1;2c")}else if(this._terminal.is("linux")){this._terminal.send(EscapeSequences_1.C0.ESC+"[?6c")}}else if(this._terminal.prefix===">"){if(this._terminal.is("xterm")){this._terminal.send(EscapeSequences_1.C0.ESC+"[>0;276;0c")}else if(this._terminal.is("rxvt-unicode")){this._terminal.send(EscapeSequences_1.C0.ESC+"[>85;95;0c")}else if(this._terminal.is("linux")){this._terminal.send(params[0]+"c")}else if(this._terminal.is("screen")){this._terminal.send(EscapeSequences_1.C0.ESC+"[>83;40003;0c")}}};InputHandler.prototype.linePosAbsolute=function(params){var param=params[0];if(param<1){param=1}this._terminal.buffer.y=param-1;if(this._terminal.buffer.y>=this._terminal.rows){this._terminal.buffer.y=this._terminal.rows-1}};InputHandler.prototype.VPositionRelative=function(params){var param=params[0];if(param<1){param=1}this._terminal.buffer.y+=param;if(this._terminal.buffer.y>=this._terminal.rows){this._terminal.buffer.y=this._terminal.rows-1}if(this._terminal.buffer.x>=this._terminal.cols){this._terminal.buffer.x--}};InputHandler.prototype.HVPosition=function(params){if(params[0]<1)params[0]=1;if(params[1]<1)params[1]=1;this._terminal.buffer.y=params[0]-1;if(this._terminal.buffer.y>=this._terminal.rows){this._terminal.buffer.y=this._terminal.rows-1}this._terminal.buffer.x=params[1]-1;if(this._terminal.buffer.x>=this._terminal.cols){this._terminal.buffer.x=this._terminal.cols-1}};InputHandler.prototype.tabClear=function(params){var param=params[0];if(param<=0){delete this._terminal.buffer.tabs[this._terminal.buffer.x]}else if(param===3){this._terminal.buffer.tabs={}}};InputHandler.prototype.setMode=function(params){if(params.length>1){for(var i=0;i<params.length;i++){this.setMode([params[i]])}return}if(!this._terminal.prefix){switch(params[0]){case 4:this._terminal.insertMode=true;break;case 20:break}}else if(this._terminal.prefix==="?"){switch(params[0]){case 1:this._terminal.applicationCursor=true;break;case 2:this._terminal.setgCharset(0,Charsets_1.DEFAULT_CHARSET);this._terminal.setgCharset(1,Charsets_1.DEFAULT_CHARSET);this._terminal.setgCharset(2,Charsets_1.DEFAULT_CHARSET);this._terminal.setgCharset(3,Charsets_1.DEFAULT_CHARSET);break;case 3:this._terminal.savedCols=this._terminal.cols;this._terminal.resize(132,this._terminal.rows);break;case 6:this._terminal.originMode=true;break;case 7:this._terminal.wraparoundMode=true;break;case 12:break;case 66:this._terminal.log("Serial port requested application keypad.");this._terminal.applicationKeypad=true;this._terminal.viewport.syncScrollArea();break;case 9:case 1e3:case 1002:case 1003:this._terminal.x10Mouse=params[0]===9;this._terminal.vt200Mouse=params[0]===1e3;this._terminal.normalMouse=params[0]>1e3;this._terminal.mouseEvents=true;this._terminal.element.classList.add("enable-mouse-events");this._terminal.selectionManager.disable();this._terminal.log("Binding to mouse events.");break;case 1004:this._terminal.sendFocus=true;break;case 1005:this._terminal.utfMouse=true;break;case 1006:this._terminal.sgrMouse=true;break;case 1015:this._terminal.urxvtMouse=true;break;case 25:this._terminal.cursorHidden=false;break;case 1049:case 47:case 1047:this._terminal.buffers.activateAltBuffer();this._terminal.viewport.syncScrollArea();this._terminal.showCursor();break;case 2004:this._terminal.bracketedPasteMode=true;break}}};InputHandler.prototype.resetMode=function(params){if(params.length>1){for(var i=0;i<params.length;i++){this.resetMode([params[i]])}return}if(!this._terminal.prefix){switch(params[0]){case 4:this._terminal.insertMode=false;break;case 20:break}}else if(this._terminal.prefix==="?"){switch(params[0]){case 1:this._terminal.applicationCursor=false;break;case 3:if(this._terminal.cols===132&&this._terminal.savedCols){this._terminal.resize(this._terminal.savedCols,this._terminal.rows)}delete this._terminal.savedCols;break;case 6:this._terminal.originMode=false;break;case 7:this._terminal.wraparoundMode=false;break;case 12:break;case 66:this._terminal.log("Switching back to normal keypad.");this._terminal.applicationKeypad=false;this._terminal.viewport.syncScrollArea();break;case 9:case 1e3:case 1002:case 1003:this._terminal.x10Mouse=false;this._terminal.vt200Mouse=false;this._terminal.normalMouse=false;this._terminal.mouseEvents=false;this._terminal.element.classList.remove("enable-mouse-events");this._terminal.selectionManager.enable();break;case 1004:this._terminal.sendFocus=false;break;case 1005:this._terminal.utfMouse=false;break;case 1006:this._terminal.sgrMouse=false;break;case 1015:this._terminal.urxvtMouse=false;break;case 25:this._terminal.cursorHidden=true;break;case 1049:case 47:case 1047:this._terminal.buffers.activateNormalBuffer();this._terminal.refresh(0,this._terminal.rows-1);this._terminal.viewport.syncScrollArea();this._terminal.showCursor();break;case 2004:this._terminal.bracketedPasteMode=false;break}}};InputHandler.prototype.charAttributes=function(params){if(params.length===1&&params[0]===0){this._terminal.curAttr=this._terminal.defAttr;return}var l=params.length;var flags=this._terminal.curAttr>>18;var fg=this._terminal.curAttr>>9&511;var bg=this._terminal.curAttr&511;var p;for(var i=0;i<l;i++){p=params[i];if(p>=30&&p<=37){fg=p-30}else if(p>=40&&p<=47){bg=p-40}else if(p>=90&&p<=97){p+=8;fg=p-90}else if(p>=100&&p<=107){p+=8;bg=p-100}else if(p===0){flags=this._terminal.defAttr>>18;fg=this._terminal.defAttr>>9&511;bg=this._terminal.defAttr&511}else if(p===1){flags|=Types_1.FLAGS.BOLD}else if(p===4){flags|=Types_1.FLAGS.UNDERLINE}else if(p===5){flags|=Types_1.FLAGS.BLINK}else if(p===7){flags|=Types_1.FLAGS.INVERSE}else if(p===8){flags|=Types_1.FLAGS.INVISIBLE}else if(p===2){flags|=Types_1.FLAGS.DIM}else if(p===22){flags&=~Types_1.FLAGS.BOLD;flags&=~Types_1.FLAGS.DIM}else if(p===24){flags&=~Types_1.FLAGS.UNDERLINE}else if(p===25){flags&=~Types_1.FLAGS.BLINK}else if(p===27){flags&=~Types_1.FLAGS.INVERSE}else if(p===28){flags&=~Types_1.FLAGS.INVISIBLE}else if(p===39){fg=this._terminal.defAttr>>9&511}else if(p===49){bg=this._terminal.defAttr&511}else if(p===38){if(params[i+1]===2){i+=2;fg=this._terminal.matchColor(params[i]&255,params[i+1]&255,params[i+2]&255);if(fg===-1)fg=511;i+=2}else if(params[i+1]===5){i+=2;p=params[i]&255;fg=p}}else if(p===48){if(params[i+1]===2){i+=2;bg=this._terminal.matchColor(params[i]&255,params[i+1]&255,params[i+2]&255);if(bg===-1)bg=511;i+=2}else if(params[i+1]===5){i+=2;p=params[i]&255;bg=p}}else if(p===100){fg=this._terminal.defAttr>>9&511;bg=this._terminal.defAttr&511}else{this._terminal.error("Unknown SGR attribute: %d.",p)}}this._terminal.curAttr=flags<<18|fg<<9|bg};InputHandler.prototype.deviceStatus=function(params){if(!this._terminal.prefix){switch(params[0]){case 5:this._terminal.send(EscapeSequences_1.C0.ESC+"[0n");break;case 6:this._terminal.send(EscapeSequences_1.C0.ESC+"["+(this._terminal.buffer.y+1)+";"+(this._terminal.buffer.x+1)+"R");break}}else if(this._terminal.prefix==="?"){switch(params[0]){case 6:this._terminal.send(EscapeSequences_1.C0.ESC+"[?"+(this._terminal.buffer.y+1)+";"+(this._terminal.buffer.x+1)+"R");break;case 15:break;case 25:break;case 26:break;case 53:break}}};InputHandler.prototype.softReset=function(params){this._terminal.cursorHidden=false;this._terminal.insertMode=false;this._terminal.originMode=false;this._terminal.wraparoundMode=true;this._terminal.applicationKeypad=false;this._terminal.viewport.syncScrollArea();this._terminal.applicationCursor=false;this._terminal.buffer.scrollTop=0;this._terminal.buffer.scrollBottom=this._terminal.rows-1;this._terminal.curAttr=this._terminal.defAttr;this._terminal.buffer.x=this._terminal.buffer.y=0;this._terminal.charset=null;this._terminal.glevel=0;this._terminal.charsets=[null]};InputHandler.prototype.setCursorStyle=function(params){var param=params[0]<1?1:params[0];switch(param){case 1:case 2:this._terminal.setOption("cursorStyle","block");break;case 3:case 4:this._terminal.setOption("cursorStyle","underline");break;case 5:case 6:this._terminal.setOption("cursorStyle","bar");break}var isBlinking=param%2===1;this._terminal.setOption("cursorBlink",isBlinking)};InputHandler.prototype.setScrollRegion=function(params){if(this._terminal.prefix)return;this._terminal.buffer.scrollTop=(params[0]||1)-1;this._terminal.buffer.scrollBottom=(params[1]&&params[1]<=this._terminal.rows?params[1]:this._terminal.rows)-1;this._terminal.buffer.x=0;this._terminal.buffer.y=0};InputHandler.prototype.saveCursor=function(params){this._terminal.buffer.savedX=this._terminal.buffer.x;this._terminal.buffer.savedY=this._terminal.buffer.y};InputHandler.prototype.restoreCursor=function(params){this._terminal.buffer.x=this._terminal.buffer.savedX||0;this._terminal.buffer.y=this._terminal.buffer.savedY||0};return InputHandler}();exports.InputHandler=InputHandler},{"./Buffer":2,"./CharWidth":4,"./Charsets":5,"./EscapeSequences":7,"./renderer/Types":30}],10:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:true});var Types_1=require("./Types");var MouseZoneManager_1=require("./input/MouseZoneManager");var EventEmitter_1=require("./EventEmitter");var Linkifier=function(_super){__extends(Linkifier,_super);function Linkifier(_terminal){var _this=_super.call(this)||this;_this._terminal=_terminal;_this._linkMatchers=[];_this._nextLinkMatcherId=0;_this._rowsToLinkify={start:null,end:null};return _this}Linkifier.prototype.attachToDom=function(mouseZoneManager){this._mouseZoneManager=mouseZoneManager};Linkifier.prototype.linkifyRows=function(start,end){var _this=this;if(!this._mouseZoneManager){return}if(this._rowsToLinkify.start===null){this._rowsToLinkify.start=start;this._rowsToLinkify.end=end}else{this._rowsToLinkify.start=Math.min(this._rowsToLinkify.start,start);this._rowsToLinkify.end=Math.max(this._rowsToLinkify.end,end)}this._mouseZoneManager.clearAll(start,end);if(this._rowsTimeoutId){clearTimeout(this._rowsTimeoutId)}this._rowsTimeoutId=setTimeout(function(){return _this._linkifyRows()},Linkifier.TIME_BEFORE_LINKIFY)};Linkifier.prototype._linkifyRows=function(){this._rowsTimeoutId=null;for(var i=this._rowsToLinkify.start;i<=this._rowsToLinkify.end;i++){this._linkifyRow(i)}this._rowsToLinkify.start=null;this._rowsToLinkify.end=null};Linkifier.prototype.registerLinkMatcher=function(regex,handler,options){if(options===void 0){options={}}if(!handler){throw new Error("handler must be defined")}var matcher={id:this._nextLinkMatcherId++,regex:regex,handler:handler,matchIndex:options.matchIndex,validationCallback:options.validationCallback,hoverTooltipCallback:options.tooltipCallback,hoverLeaveCallback:options.leaveCallback,willLinkActivate:options.willLinkActivate,priority:options.priority||0};this._addLinkMatcherToList(matcher);return matcher.id};Linkifier.prototype._addLinkMatcherToList=function(matcher){if(this._linkMatchers.length===0){this._linkMatchers.push(matcher);return}for(var i=this._linkMatchers.length-1;i>=0;i--){if(matcher.priority<=this._linkMatchers[i].priority){this._linkMatchers.splice(i+1,0,matcher);return}}this._linkMatchers.splice(0,0,matcher)};Linkifier.prototype.deregisterLinkMatcher=function(matcherId){for(var i=0;i<this._linkMatchers.length;i++){if(this._linkMatchers[i].id===matcherId){this._linkMatchers.splice(i,1);return true}}return false};Linkifier.prototype._linkifyRow=function(rowIndex){var absoluteRowIndex=this._terminal.buffer.ydisp+rowIndex;if(absoluteRowIndex>=this._terminal.buffer.lines.length){return}if(this._terminal.buffer.lines.get(absoluteRowIndex).isWrapped){if(rowIndex!==0){return}do{rowIndex--;absoluteRowIndex--}while(this._terminal.buffer.lines.get(absoluteRowIndex).isWrapped)}var text=this._terminal.buffer.translateBufferLineToString(absoluteRowIndex,false);var currentIndex=absoluteRowIndex+1;while(currentIndex<this._terminal.buffer.lines.length&&this._terminal.buffer.lines.get(currentIndex).isWrapped){text+=this._terminal.buffer.translateBufferLineToString(currentIndex++,false)}for(var i=0;i<this._linkMatchers.length;i++){this._doLinkifyRow(rowIndex,text,this._linkMatchers[i])}};Linkifier.prototype._doLinkifyRow=function(rowIndex,text,matcher,offset){var _this=this;if(offset===void 0){offset=0}var match=text.match(matcher.regex);if(!match||match.length===0){return}var uri=match[typeof matcher.matchIndex!=="number"?0:matcher.matchIndex];var index=text.indexOf(uri);if(matcher.validationCallback){matcher.validationCallback(uri,function(isValid){if(_this._rowsTimeoutId){return}if(isValid){_this._addLink(offset+index,rowIndex,uri,matcher)}})}else{this._addLink(offset+index,rowIndex,uri,matcher)}var remainingStartIndex=index+uri.length;var remainingText=text.substr(remainingStartIndex);if(remainingText.length>0){this._doLinkifyRow(rowIndex,remainingText,matcher,offset+remainingStartIndex)}};Linkifier.prototype._addLink=function(x,y,uri,matcher){var _this=this;var x1=x%this._terminal.cols;var y1=y+Math.floor(x/this._terminal.cols);var x2=(x1+uri.length)%this._terminal.cols;var y2=y1+Math.floor((x1+uri.length)/this._terminal.cols);if(x2===0){x2=this._terminal.cols;y2--}this._mouseZoneManager.add(new MouseZoneManager_1.MouseZone(x1+1,y1+1,x2+1,y2+1,function(e){if(matcher.handler){return matcher.handler(e,uri)}window.open(uri,"_blank")},function(e){_this.emit(Types_1.LinkHoverEventTypes.HOVER,_this._createLinkHoverEvent(x1,y1,x2,y2));_this._terminal.element.classList.add("xterm-cursor-pointer")},function(e){_this.emit(Types_1.LinkHoverEventTypes.TOOLTIP,_this._createLinkHoverEvent(x1,y1,x2,y2));if(matcher.hoverTooltipCallback){matcher.hoverTooltipCallback(e,uri)}},function(){_this.emit(Types_1.LinkHoverEventTypes.LEAVE,_this._createLinkHoverEvent(x1,y1,x2,y2));_this._terminal.element.classList.remove("xterm-cursor-pointer");if(matcher.hoverLeaveCallback){matcher.hoverLeaveCallback()}},function(e){if(matcher.willLinkActivate){return matcher.willLinkActivate(e,uri)}return true}))};Linkifier.prototype._createLinkHoverEvent=function(x1,y1,x2,y2){return{x1:x1,y1:y1,x2:x2,y2:y2,cols:this._terminal.cols}};Linkifier.TIME_BEFORE_LINKIFY=200;return Linkifier}(EventEmitter_1.EventEmitter);exports.Linkifier=Linkifier},{"./EventEmitter":8,"./Types":17,"./input/MouseZoneManager":21}],11:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var EscapeSequences_1=require("./EscapeSequences");var Charsets_1=require("./Charsets");var normalStateHandler={};normalStateHandler[EscapeSequences_1.C0.BEL]=function(parser,handler){return handler.bell()};normalStateHandler[EscapeSequences_1.C0.LF]=function(parser,handler){return handler.lineFeed()};normalStateHandler[EscapeSequences_1.C0.VT]=normalStateHandler[EscapeSequences_1.C0.LF];normalStateHandler[EscapeSequences_1.C0.FF]=normalStateHandler[EscapeSequences_1.C0.LF];normalStateHandler[EscapeSequences_1.C0.CR]=function(parser,handler){return handler.carriageReturn()};normalStateHandler[EscapeSequences_1.C0.BS]=function(parser,handler){return handler.backspace()};normalStateHandler[EscapeSequences_1.C0.HT]=function(parser,handler){return handler.tab()};normalStateHandler[EscapeSequences_1.C0.SO]=function(parser,handler){return handler.shiftOut()};normalStateHandler[EscapeSequences_1.C0.SI]=function(parser,handler){return handler.shiftIn()};normalStateHandler[EscapeSequences_1.C0.ESC]=function(parser,handler){return parser.setState(ParserState.ESCAPED)};var escapedStateHandler={};escapedStateHandler["["]=function(parser,terminal){terminal.params=[];terminal.currentParam=0;parser.setState(ParserState.CSI_PARAM)};escapedStateHandler["]"]=function(parser,terminal){terminal.params=[];terminal.currentParam=0;parser.setState(ParserState.OSC)};escapedStateHandler["P"]=function(parser,terminal){terminal.params=[];terminal.currentParam=0;parser.setState(ParserState.DCS)};escapedStateHandler["_"]=function(parser,terminal){parser.setState(ParserState.IGNORE)};escapedStateHandler["^"]=function(parser,terminal){parser.setState(ParserState.IGNORE)};escapedStateHandler["c"]=function(parser,terminal){terminal.reset()};escapedStateHandler["E"]=function(parser,terminal){terminal.buffer.x=0;terminal.index();parser.setState(ParserState.NORMAL)};escapedStateHandler["D"]=function(parser,terminal){terminal.index();parser.setState(ParserState.NORMAL)};escapedStateHandler["M"]=function(parser,terminal){terminal.reverseIndex();parser.setState(ParserState.NORMAL)};escapedStateHandler["%"]=function(parser,terminal){terminal.setgLevel(0);terminal.setgCharset(0,Charsets_1.DEFAULT_CHARSET);parser.setState(ParserState.NORMAL);parser.skipNextChar()};escapedStateHandler[EscapeSequences_1.C0.CAN]=function(parser){return parser.setState(ParserState.NORMAL)};var csiParamStateHandler={};csiParamStateHandler["?"]=function(parser){return parser.setPrefix("?")};csiParamStateHandler[">"]=function(parser){return parser.setPrefix(">")};csiParamStateHandler["!"]=function(parser){return parser.setPrefix("!")};csiParamStateHandler["0"]=function(parser){return parser.setParam(parser.getParam()*10)};csiParamStateHandler["1"]=function(parser){return parser.setParam(parser.getParam()*10+1)};csiParamStateHandler["2"]=function(parser){return parser.setParam(parser.getParam()*10+2)};csiParamStateHandler["3"]=function(parser){return parser.setParam(parser.getParam()*10+3)};csiParamStateHandler["4"]=function(parser){return parser.setParam(parser.getParam()*10+4)};csiParamStateHandler["5"]=function(parser){return parser.setParam(parser.getParam()*10+5)};csiParamStateHandler["6"]=function(parser){return parser.setParam(parser.getParam()*10+6)};csiParamStateHandler["7"]=function(parser){return parser.setParam(parser.getParam()*10+7)};csiParamStateHandler["8"]=function(parser){return parser.setParam(parser.getParam()*10+8)};csiParamStateHandler["9"]=function(parser){return parser.setParam(parser.getParam()*10+9)};csiParamStateHandler["$"]=function(parser){return parser.setPostfix("$")};csiParamStateHandler['"']=function(parser){return parser.setPostfix('"')};csiParamStateHandler[" "]=function(parser){return parser.setPostfix(" ")};csiParamStateHandler["'"]=function(parser){return parser.setPostfix("'")};csiParamStateHandler[";"]=function(parser){return parser.finalizeParam()};csiParamStateHandler[EscapeSequences_1.C0.CAN]=function(parser){return parser.setState(ParserState.NORMAL)};var csiStateHandler={};csiStateHandler["@"]=function(handler,params,prefix){return handler.insertChars(params)};csiStateHandler["A"]=function(handler,params,prefix){return handler.cursorUp(params)};csiStateHandler["B"]=function(handler,params,prefix){return handler.cursorDown(params)};csiStateHandler["C"]=function(handler,params,prefix){return handler.cursorForward(params)};csiStateHandler["D"]=function(handler,params,prefix){return handler.cursorBackward(params)};csiStateHandler["E"]=function(handler,params,prefix){return handler.cursorNextLine(params)};csiStateHandler["F"]=function(handler,params,prefix){return handler.cursorPrecedingLine(params)};csiStateHandler["G"]=function(handler,params,prefix){return handler.cursorCharAbsolute(params)};csiStateHandler["H"]=function(handler,params,prefix){return handler.cursorPosition(params)};csiStateHandler["I"]=function(handler,params,prefix){return handler.cursorForwardTab(params)};csiStateHandler["J"]=function(handler,params,prefix){return handler.eraseInDisplay(params)};csiStateHandler["K"]=function(handler,params,prefix){return handler.eraseInLine(params)};csiStateHandler["L"]=function(handler,params,prefix){return handler.insertLines(params)};csiStateHandler["M"]=function(handler,params,prefix){return handler.deleteLines(params)};csiStateHandler["P"]=function(handler,params,prefix){return handler.deleteChars(params)};csiStateHandler["S"]=function(handler,params,prefix){return handler.scrollUp(params)};csiStateHandler["T"]=function(handler,params,prefix){if(params.length<2&&!prefix){handler.scrollDown(params)}};csiStateHandler["X"]=function(handler,params,prefix){return handler.eraseChars(params)};csiStateHandler["Z"]=function(handler,params,prefix){return handler.cursorBackwardTab(params)};csiStateHandler["`"]=function(handler,params,prefix){return handler.charPosAbsolute(params)};csiStateHandler["a"]=function(handler,params,prefix){return handler.HPositionRelative(params)};csiStateHandler["b"]=function(handler,params,prefix){return handler.repeatPrecedingCharacter(params)};csiStateHandler["c"]=function(handler,params,prefix){return handler.sendDeviceAttributes(params)};csiStateHandler["d"]=function(handler,params,prefix){return handler.linePosAbsolute(params)};csiStateHandler["e"]=function(handler,params,prefix){return handler.VPositionRelative(params)};csiStateHandler["f"]=function(handler,params,prefix){return handler.HVPosition(params)};csiStateHandler["g"]=function(handler,params,prefix){return handler.tabClear(params)};csiStateHandler["h"]=function(handler,params,prefix){return handler.setMode(params)};csiStateHandler["l"]=function(handler,params,prefix){return handler.resetMode(params)};csiStateHandler["m"]=function(handler,params,prefix){return handler.charAttributes(params)};csiStateHandler["n"]=function(handler,params,prefix){return handler.deviceStatus(params)};csiStateHandler["p"]=function(handler,params,prefix){switch(prefix){case"!":handler.softReset(params);break}};csiStateHandler["q"]=function(handler,params,prefix,postfix){if(postfix===" "){handler.setCursorStyle(params)}};csiStateHandler["r"]=function(handler,params){return handler.setScrollRegion(params)};csiStateHandler["s"]=function(handler,params){return handler.saveCursor(params)};csiStateHandler["u"]=function(handler,params){return handler.restoreCursor(params)};csiStateHandler[EscapeSequences_1.C0.CAN]=function(handler,params,prefix,postfix,parser){return parser.setState(ParserState.NORMAL)};var ParserState;(function(ParserState){ParserState[ParserState["NORMAL"]=0]="NORMAL";ParserState[ParserState["ESCAPED"]=1]="ESCAPED";ParserState[ParserState["CSI_PARAM"]=2]="CSI_PARAM";ParserState[ParserState["CSI"]=3]="CSI";ParserState[ParserState["OSC"]=4]="OSC";ParserState[ParserState["CHARSET"]=5]="CHARSET";ParserState[ParserState["DCS"]=6]="DCS";ParserState[ParserState["IGNORE"]=7]="IGNORE"})(ParserState=exports.ParserState||(exports.ParserState={}));var Parser=function(){function Parser(_inputHandler,_terminal){this._inputHandler=_inputHandler;this._terminal=_terminal;this._state=ParserState.NORMAL}Parser.prototype.parse=function(data){var l=data.length;var cs;var ch;var code;var low;var cursorStartX=this._terminal.buffer.x;var cursorStartY=this._terminal.buffer.y;if(this._terminal.debug){this._terminal.log("data: "+data)}this._position=0;if(this._terminal.surrogate_high){data=this._terminal.surrogate_high+data;this._terminal.surrogate_high=""}for(;this._position<l;this._position++){ch=data[this._position];code=data.charCodeAt(this._position);if(55296<=code&&code<=56319){low=data.charCodeAt(this._position+1);if(isNaN(low)){this._terminal.surrogate_high=ch;continue}code=(code-55296)*1024+(low-56320)+65536;ch+=data.charAt(this._position+1)}if(56320<=code&&code<=57343){continue}switch(this._state){case ParserState.NORMAL:if(ch in normalStateHandler){normalStateHandler[ch](this,this._inputHandler)}else{this._inputHandler.addChar(ch,code)}break;case ParserState.ESCAPED:if(ch in escapedStateHandler){escapedStateHandler[ch](this,this._terminal);break}switch(ch){case"(":case")":case"*":case"+":case"-":case".":switch(ch){case"(":this._terminal.gcharset=0;break;case")":this._terminal.gcharset=1;break;case"*":this._terminal.gcharset=2;break;case"+":this._terminal.gcharset=3;break;case"-":this._terminal.gcharset=1;break;case".":this._terminal.gcharset=2;break}this._state=ParserState.CHARSET;break;case"/":this._terminal.gcharset=3;this._state=ParserState.CHARSET;this._position--;break;case"N":this._state=ParserState.NORMAL;break;case"O":this._state=ParserState.NORMAL;break;case"n":this._terminal.setgLevel(2);this._state=ParserState.NORMAL;break;case"o":this._terminal.setgLevel(3);this._state=ParserState.NORMAL;break;case"|":this._terminal.setgLevel(3);this._state=ParserState.NORMAL;break;case"}":this._terminal.setgLevel(2);this._state=ParserState.NORMAL;break;case"~":this._terminal.setgLevel(1);this._state=ParserState.NORMAL;break;case"7":this._inputHandler.saveCursor();this._state=ParserState.NORMAL;break;case"8":this._inputHandler.restoreCursor();this._state=ParserState.NORMAL;break;case"#":this._state=ParserState.NORMAL;this._position++;break;case"H":this._terminal.tabSet();this._state=ParserState.NORMAL;break;case"=":this._terminal.log("Serial port requested application keypad.");this._terminal.applicationKeypad=true;if(this._terminal.viewport){this._terminal.viewport.syncScrollArea()}this._state=ParserState.NORMAL;break;case">":this._terminal.log("Switching back to normal keypad.");this._terminal.applicationKeypad=false;if(this._terminal.viewport){this._terminal.viewport.syncScrollArea()}this._state=ParserState.NORMAL;break;default:this._state=ParserState.NORMAL;this._terminal.error("Unknown ESC control: %s.",ch);break}break;case ParserState.CHARSET:if(ch in Charsets_1.CHARSETS){cs=Charsets_1.CHARSETS[ch];if(ch==="/"){this.skipNextChar()}}else{cs=Charsets_1.DEFAULT_CHARSET}this._terminal.setgCharset(this._terminal.gcharset,cs);this._terminal.gcharset=null;this._state=ParserState.NORMAL;break;case ParserState.OSC:if(ch===EscapeSequences_1.C0.ESC||ch===EscapeSequences_1.C0.BEL){if(ch===EscapeSequences_1.C0.ESC)this._position++;this._terminal.params.push(this._terminal.currentParam);switch(this._terminal.params[0]){case 0:case 1:case 2:if(this._terminal.params[1]){this._terminal.title=this._terminal.params[1];this._terminal.handleTitle(this._terminal.title)}break;case 3:break;case 4:case 5:break;case 10:case 11:case 12:case 13:case 14:case 15:case 16:case 17:case 18:case 19:break;case 46:break;case 50:break;case 51:break;case 52:break;case 104:case 105:case 110:case 111:case 112:case 113:case 114:case 115:case 116:case 117:case 118:break}this._terminal.params=[];this._terminal.currentParam=0;this._state=ParserState.NORMAL}else{if(!this._terminal.params.length){if(ch>="0"&&ch<="9"){this._terminal.currentParam=this._terminal.currentParam*10+ch.charCodeAt(0)-48}else if(ch===";"){this._terminal.params.push(this._terminal.currentParam);this._terminal.currentParam=""}}else{this._terminal.currentParam+=ch}}break;case ParserState.CSI_PARAM:if(ch in csiParamStateHandler){csiParamStateHandler[ch](this);break}this.finalizeParam();this._state=ParserState.CSI;case ParserState.CSI:if(ch in csiStateHandler){if(this._terminal.debug){this._terminal.log("CSI "+(this._terminal.prefix?this._terminal.prefix:"")+" "+(this._terminal.params?this._terminal.params.join(";"):"")+" "+(this._terminal.postfix?this._terminal.postfix:"")+" "+ch)}csiStateHandler[ch](this._inputHandler,this._terminal.params,this._terminal.prefix,this._terminal.postfix,this)}else{this._terminal.error("Unknown CSI code: %s.",ch)}this._state=ParserState.NORMAL;this._terminal.prefix="";this._terminal.postfix="";break;case ParserState.DCS:if(ch===EscapeSequences_1.C0.ESC||ch===EscapeSequences_1.C0.BEL){if(ch===EscapeSequences_1.C0.ESC)this._position++;var pt=void 0;var valid=void 0;switch(this._terminal.prefix){case"":break;case"$q":pt=this._terminal.currentParam;valid=false;switch(pt){case'"q':pt='0"q';break;case'"p':pt='61"p';break;case"r":pt=""+(this._terminal.buffer.scrollTop+1)+";"+(this._terminal.buffer.scrollBottom+1)+"r";break;case"m":pt="0m";break;default:this._terminal.error("Unknown DCS Pt: %s.",pt);pt="";break}this._terminal.send(EscapeSequences_1.C0.ESC+"P"+ +valid+"$r"+pt+EscapeSequences_1.C0.ESC+"\\");break;case"+p":break;case"+q":pt=this._terminal.currentParam;valid=false;this._terminal.send(EscapeSequences_1.C0.ESC+"P"+ +valid+"+r"+pt+EscapeSequences_1.C0.ESC+"\\");break;default:this._terminal.error("Unknown DCS prefix: %s.",this._terminal.prefix);break}this._terminal.currentParam=0;this._terminal.prefix="";this._state=ParserState.NORMAL}else if(!this._terminal.currentParam){if(!this._terminal.prefix&&ch!=="$"&&ch!=="+"){this._terminal.currentParam=ch}else if(this._terminal.prefix.length===2){this._terminal.currentParam=ch}else{this._terminal.prefix+=ch}}else{this._terminal.currentParam+=ch}break;case ParserState.IGNORE:if(ch===EscapeSequences_1.C0.ESC||ch===EscapeSequences_1.C0.BEL){if(ch===EscapeSequences_1.C0.ESC)this._position++;this._state=ParserState.NORMAL}break}}if(this._terminal.buffer.x!==cursorStartX||this._terminal.buffer.y!==cursorStartY){this._terminal.emit("cursormove")}return this._state};Parser.prototype.setState=function(state){this._state=state};Parser.prototype.setPrefix=function(prefix){this._terminal.prefix=prefix};Parser.prototype.setPostfix=function(postfix){this._terminal.postfix=postfix};Parser.prototype.setParam=function(param){this._terminal.currentParam=param};Parser.prototype.getParam=function(){return this._terminal.currentParam};Parser.prototype.finalizeParam=function(){this._terminal.params.push(this._terminal.currentParam);this._terminal.currentParam=0};Parser.prototype.skipNextChar=function(){this._position++};return Parser}();exports.Parser=Parser},{"./Charsets":5,"./EscapeSequences":7}],12:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:true});var MouseHelper_1=require("./utils/MouseHelper");var Browser=require("./shared/utils/Browser");var EventEmitter_1=require("./EventEmitter");var SelectionModel_1=require("./SelectionModel");var Buffer_1=require("./Buffer");var AltClickHandler_1=require("./handlers/AltClickHandler");var DRAG_SCROLL_MAX_THRESHOLD=50;var DRAG_SCROLL_MAX_SPEED=15;var DRAG_SCROLL_INTERVAL=50;var ALT_CLICK_MOVE_CURSOR_TIME=500;var WORD_SEPARATORS=" ()[]{}'\"";var NON_BREAKING_SPACE_CHAR=String.fromCharCode(160);var ALL_NON_BREAKING_SPACE_REGEX=new RegExp(NON_BREAKING_SPACE_CHAR,"g");var SelectionMode;(function(SelectionMode){SelectionMode[SelectionMode["NORMAL"]=0]="NORMAL";SelectionMode[SelectionMode["WORD"]=1]="WORD";SelectionMode[SelectionMode["LINE"]=2]="LINE"})(SelectionMode||(SelectionMode={}));var SelectionManager=function(_super){__extends(SelectionManager,_super);function SelectionManager(_terminal,_charMeasure){var _this=_super.call(this)||this;_this._terminal=_terminal;_this._charMeasure=_charMeasure;_this._enabled=true;_this._initListeners();_this.enable();_this._model=new SelectionModel_1.SelectionModel(_terminal);_this._activeSelectionMode=SelectionMode.NORMAL;return _this}Object.defineProperty(SelectionManager.prototype,"_buffer",{get:function(){return this._terminal.buffers.active},enumerable:true,configurable:true});SelectionManager.prototype._initListeners=function(){var _this=this;this._mouseMoveListener=function(event){return _this._onMouseMove(event)};this._mouseUpListener=function(event){return _this._onMouseUp(event)};this._trimListener=function(amount){return _this._onTrim(amount)};this.initBuffersListeners()};SelectionManager.prototype.initBuffersListeners=function(){var _this=this;this._terminal.buffer.lines.on("trim",this._trimListener);this._terminal.buffers.on("activate",function(e){return _this._onBufferActivate(e)})};SelectionManager.prototype.disable=function(){this.clearSelection();this._enabled=false};SelectionManager.prototype.enable=function(){this._enabled=true};Object.defineProperty(SelectionManager.prototype,"selectionStart",{get:function(){return this._model.finalSelectionStart},enumerable:true,configurable:true});Object.defineProperty(SelectionManager.prototype,"selectionEnd",{get:function(){return this._model.finalSelectionEnd},enumerable:true,configurable:true});Object.defineProperty(SelectionManager.prototype,"hasSelection",{get:function(){var start=this._model.finalSelectionStart;var end=this._model.finalSelectionEnd;if(!start||!end){return false}return start[0]!==end[0]||start[1]!==end[1]},enumerable:true,configurable:true});Object.defineProperty(SelectionManager.prototype,"selectionText",{get:function(){var start=this._model.finalSelectionStart;var end=this._model.finalSelectionEnd;if(!start||!end){return""}var startRowEndCol=start[1]===end[1]?end[0]:null;var result=[];result.push(this._buffer.translateBufferLineToString(start[1],true,start[0],startRowEndCol));for(var i=start[1]+1;i<=end[1]-1;i++){var bufferLine=this._buffer.lines.get(i);var lineText=this._buffer.translateBufferLineToString(i,true);if(bufferLine.isWrapped){result[result.length-1]+=lineText}else{result.push(lineText)}}if(start[1]!==end[1]){var bufferLine=this._buffer.lines.get(end[1]);var lineText=this._buffer.translateBufferLineToString(end[1],true,0,end[0]);if(bufferLine.isWrapped){result[result.length-1]+=lineText}else{result.push(lineText)}}var formattedResult=result.map(function(line){return line.replace(ALL_NON_BREAKING_SPACE_REGEX," ")}).join(Browser.isMSWindows?"\r\n":"\n");return formattedResult},enumerable:true,configurable:true});SelectionManager.prototype.clearSelection=function(){this._model.clearSelection();this._removeMouseDownListeners();this.refresh()};SelectionManager.prototype.refresh=function(isNewSelection){var _this=this;if(!this._refreshAnimationFrame){this._refreshAnimationFrame=window.requestAnimationFrame(function(){return _this._refresh()})}if(Browser.isLinux&&isNewSelection){var selectionText=this.selectionText;if(selectionText.length){this.emit("newselection",this.selectionText)}}};SelectionManager.prototype._refresh=function(){this._refreshAnimationFrame=null;this.emit("refresh",{start:this._model.finalSelectionStart,end:this._model.finalSelectionEnd})};SelectionManager.prototype.isClickInSelection=function(event){var coords=this._getMouseBufferCoords(event);var start=this._model.finalSelectionStart;var end=this._model.finalSelectionEnd;if(!start||!end){return false}return coords[1]>start[1]&&coords[1]<end[1]||start[1]===end[1]&&coords[1]===start[1]&&coords[0]>start[0]&&coords[0]<end[0]||start[1]<end[1]&&coords[1]===end[1]&&coords[0]<end[0]};SelectionManager.prototype.selectWordAtCursor=function(event){var coords=this._getMouseBufferCoords(event);if(coords){this._selectWordAt(coords,false);this._model.selectionEnd=null;this.refresh(true)}};SelectionManager.prototype.selectAll=function(){this._model.isSelectAllActive=true;this.refresh();this._terminal.emit("selection")};SelectionManager.prototype.selectLines=function(start,end){this._model.clearSelection();start=Math.max(start,0);end=Math.min(end,this._terminal.buffer.lines.length-1);this._model.selectionStart=[0,start];this._model.selectionEnd=[this._terminal.cols,end];this.refresh();this._terminal.emit("selection")};SelectionManager.prototype._onTrim=function(amount){var needsRefresh=this._model.onTrim(amount);if(needsRefresh){this.refresh()}};SelectionManager.prototype._getMouseBufferCoords=function(event){var coords=this._terminal.mouseHelper.getCoords(event,this._terminal.screenElement,this._charMeasure,this._terminal.options.lineHeight,this._terminal.cols,this._terminal.rows,true);if(!coords){return null}coords[0]--;coords[1]--;coords[1]+=this._terminal.buffer.ydisp;return coords};SelectionManager.prototype._getMouseEventScrollAmount=function(event){var offset=MouseHelper_1.MouseHelper.getCoordsRelativeToElement(event,this._terminal.screenElement)[1];var terminalHeight=this._terminal.rows*Math.ceil(this._charMeasure.height*this._terminal.options.lineHeight);if(offset>=0&&offset<=terminalHeight){return 0}if(offset>terminalHeight){offset-=terminalHeight}offset=Math.min(Math.max(offset,-DRAG_SCROLL_MAX_THRESHOLD),DRAG_SCROLL_MAX_THRESHOLD);offset/=DRAG_SCROLL_MAX_THRESHOLD;return offset/Math.abs(offset)+Math.round(offset*(DRAG_SCROLL_MAX_SPEED-1))};SelectionManager.prototype.shouldForceSelection=function(event){return Browser.isMac?event.altKey:event.shiftKey};SelectionManager.prototype.onMouseDown=function(event){this._mouseDownTimeStamp=event.timeStamp;if(event.button===2&&this.hasSelection){return}if(event.button!==0){return}if(!this._enabled){if(!this.shouldForceSelection(event)){return}event.stopPropagation()}event.preventDefault();this._dragScrollAmount=0;if(this._enabled&&event.shiftKey){this._onIncrementalClick(event)}else{if(event.detail===1){this._onSingleClick(event)}else if(event.detail===2){this._onDoubleClick(event)}else if(event.detail===3){this._onTripleClick(event)}}this._addMouseDownListeners();this.refresh(true)};SelectionManager.prototype._addMouseDownListeners=function(){var _this=this;this._terminal.element.ownerDocument.addEventListener("mousemove",this._mouseMoveListener);this._terminal.element.ownerDocument.addEventListener("mouseup",this._mouseUpListener);this._dragScrollIntervalTimer=setInterval(function(){return _this._dragScroll()},DRAG_SCROLL_INTERVAL)};SelectionManager.prototype._removeMouseDownListeners=function(){this._terminal.element.ownerDocument.removeEventListener("mousemove",this._mouseMoveListener);this._terminal.element.ownerDocument.removeEventListener("mouseup",this._mouseUpListener);clearInterval(this._dragScrollIntervalTimer);this._dragScrollIntervalTimer=null};SelectionManager.prototype._onIncrementalClick=function(event){if(this._model.selectionStart){this._model.selectionEnd=this._getMouseBufferCoords(event)}};SelectionManager.prototype._onSingleClick=function(event){this._model.selectionStartLength=0;this._model.isSelectAllActive=false;this._activeSelectionMode=SelectionMode.NORMAL;this._model.selectionStart=this._getMouseBufferCoords(event);if(!this._model.selectionStart){return}this._model.selectionEnd=null;var line=this._buffer.lines.get(this._model.selectionStart[1]);if(!line){return}if(line.length>=this._model.selectionStart[0]){return}var char=line[this._model.selectionStart[0]];if(char[Buffer_1.CHAR_DATA_WIDTH_INDEX]===0){this._model.selectionStart[0]++}};SelectionManager.prototype._onDoubleClick=function(event){var coords=this._getMouseBufferCoords(event);if(coords){this._activeSelectionMode=SelectionMode.WORD;this._selectWordAt(coords,true)}};SelectionManager.prototype._onTripleClick=function(event){var coords=this._getMouseBufferCoords(event);if(coords){this._activeSelectionMode=SelectionMode.LINE;this._selectLineAt(coords[1])}};SelectionManager.prototype._onMouseMove=function(event){event.stopImmediatePropagation();var previousSelectionEnd=this._model.selectionEnd?[this._model.selectionEnd[0],this._model.selectionEnd[1]]:null;this._model.selectionEnd=this._getMouseBufferCoords(event);if(!this._model.selectionEnd){this.refresh(true);return}if(this._activeSelectionMode===SelectionMode.LINE){if(this._model.selectionEnd[1]<this._model.selectionStart[1]){this._model.selectionEnd[0]=0}else{this._model.selectionEnd[0]=this._terminal.cols}}else if(this._activeSelectionMode===SelectionMode.WORD){this._selectToWordAt(this._model.selectionEnd)}this._dragScrollAmount=this._getMouseEventScrollAmount(event);if(this._dragScrollAmount>0){this._model.selectionEnd[0]=this._terminal.cols}else if(this._dragScrollAmount<0){this._model.selectionEnd[0]=0}if(this._model.selectionEnd[1]<this._buffer.lines.length){var char=this._buffer.lines.get(this._model.selectionEnd[1])[this._model.selectionEnd[0]];if(char&&char[Buffer_1.CHAR_DATA_WIDTH_INDEX]===0){this._model.selectionEnd[0]++}}if(!previousSelectionEnd||previousSelectionEnd[0]!==this._model.selectionEnd[0]||previousSelectionEnd[1]!==this._model.selectionEnd[1]){this.refresh(true)}};SelectionManager.prototype._dragScroll=function(){if(this._dragScrollAmount){this._terminal.scrollLines(this._dragScrollAmount,false);if(this._dragScrollAmount>0){this._model.selectionEnd=[this._terminal.cols-1,Math.min(this._terminal.buffer.ydisp+this._terminal.rows,this._terminal.buffer.lines.length-1)]}else{this._model.selectionEnd=[0,this._terminal.buffer.ydisp]}this.refresh()}};SelectionManager.prototype._onMouseUp=function(event){var timeElapsed=event.timeStamp-this._mouseDownTimeStamp;this._removeMouseDownListeners();if(this.selectionText.length<=1&&timeElapsed<ALT_CLICK_MOVE_CURSOR_TIME){new AltClickHandler_1.AltClickHandler(event,this._terminal).move()}else if(this.hasSelection){this._terminal.emit("selection")}};SelectionManager.prototype._onBufferActivate=function(e){this.clearSelection();e.inactiveBuffer.lines.off("trim",this._trimListener);e.activeBuffer.lines.on("trim",this._trimListener)};SelectionManager.prototype._convertViewportColToCharacterIndex=function(bufferLine,coords){var charIndex=coords[0];for(var i=0;coords[0]>=i;i++){var char=bufferLine[i];if(char[Buffer_1.CHAR_DATA_WIDTH_INDEX]===0){charIndex--}else if(char[Buffer_1.CHAR_DATA_CHAR_INDEX].length>1&&coords[0]!==i){charIndex+=char[Buffer_1.CHAR_DATA_CHAR_INDEX].length-1}}return charIndex};SelectionManager.prototype.setSelection=function(col,row,length){this._model.clearSelection();this._removeMouseDownListeners();this._model.selectionStart=[col,row];this._model.selectionStartLength=length;this.refresh()};SelectionManager.prototype._getWordAt=function(coords,allowWhitespaceOnlySelection){if(coords[0]>=this._terminal.cols){return null}var bufferLine=this._buffer.lines.get(coords[1]);if(!bufferLine){return null}var line=this._buffer.translateBufferLineToString(coords[1],false);var startIndex=this._convertViewportColToCharacterIndex(bufferLine,coords);var endIndex=startIndex;var charOffset=coords[0]-startIndex;var leftWideCharCount=0;var rightWideCharCount=0;var leftLongCharOffset=0;var rightLongCharOffset=0;if(line.charAt(startIndex)===" "){while(startIndex>0&&line.charAt(startIndex-1)===" "){startIndex--}while(endIndex<line.length&&line.charAt(endIndex+1)===" "){endIndex++}}else{var startCol=coords[0];var endCol=coords[0];if(bufferLine[startCol][Buffer_1.CHAR_DATA_WIDTH_INDEX]===0){leftWideCharCount++;startCol--}if(bufferLine[endCol][Buffer_1.CHAR_DATA_WIDTH_INDEX]===2){rightWideCharCount++;endCol++}if(bufferLine[endCol][Buffer_1.CHAR_DATA_CHAR_INDEX].length>1){rightLongCharOffset+=bufferLine[endCol][Buffer_1.CHAR_DATA_CHAR_INDEX].length-1;endIndex+=bufferLine[endCol][Buffer_1.CHAR_DATA_CHAR_INDEX].length-1}while(startCol>0&&startIndex>0&&!this._isCharWordSeparator(bufferLine[startCol-1])){var char=bufferLine[startCol-1];if(char[Buffer_1.CHAR_DATA_WIDTH_INDEX]===0){leftWideCharCount++;startCol--}else if(char[Buffer_1.CHAR_DATA_CHAR_INDEX].length>1){leftLongCharOffset+=char[Buffer_1.CHAR_DATA_CHAR_INDEX].length-1;startIndex-=char[Buffer_1.CHAR_DATA_CHAR_INDEX].length-1}startIndex--;startCol--}while(endCol<bufferLine.length&&endIndex+1<line.length&&!this._isCharWordSeparator(bufferLine[endCol+1])){var char=bufferLine[endCol+1];if(char[Buffer_1.CHAR_DATA_WIDTH_INDEX]===2){rightWideCharCount++;endCol++}else if(char[Buffer_1.CHAR_DATA_CHAR_INDEX].length>1){rightLongCharOffset+=char[Buffer_1.CHAR_DATA_CHAR_INDEX].length-1;endIndex+=char[Buffer_1.CHAR_DATA_CHAR_INDEX].length-1}endIndex++;endCol++}}endIndex++;var start=startIndex+charOffset-leftWideCharCount+leftLongCharOffset;var length=Math.min(this._terminal.cols,endIndex-startIndex+leftWideCharCount+rightWideCharCount-leftLongCharOffset-rightLongCharOffset);if(!allowWhitespaceOnlySelection&&line.slice(startIndex,endIndex).trim()===""){return null}return{start:start,length:length}};SelectionManager.prototype._selectWordAt=function(coords,allowWhitespaceOnlySelection){var wordPosition=this._getWordAt(coords,allowWhitespaceOnlySelection);if(wordPosition){this._model.selectionStart=[wordPosition.start,coords[1]];this._model.selectionStartLength=wordPosition.length}};SelectionManager.prototype._selectToWordAt=function(coords){var wordPosition=this._getWordAt(coords,true);if(wordPosition){this._model.selectionEnd=[this._model.areSelectionValuesReversed()?wordPosition.start:wordPosition.start+wordPosition.length,coords[1]]}};SelectionManager.prototype._isCharWordSeparator=function(charData){if(charData[Buffer_1.CHAR_DATA_WIDTH_INDEX]===0){return false}return WORD_SEPARATORS.indexOf(charData[Buffer_1.CHAR_DATA_CHAR_INDEX])>=0};SelectionManager.prototype._selectLineAt=function(line){this._model.selectionStart=[0,line];this._model.selectionStartLength=this._terminal.cols};return SelectionManager}(EventEmitter_1.EventEmitter);exports.SelectionManager=SelectionManager},{"./Buffer":2,"./EventEmitter":8,"./SelectionModel":13,"./handlers/AltClickHandler":19,"./shared/utils/Browser":36,"./utils/MouseHelper":41}],13:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var SelectionModel=function(){function SelectionModel(_terminal){this._terminal=_terminal;this.clearSelection()}SelectionModel.prototype.clearSelection=function(){this.selectionStart=null;this.selectionEnd=null;this.isSelectAllActive=false;this.selectionStartLength=0};Object.defineProperty(SelectionModel.prototype,"finalSelectionStart",{get:function(){if(this.isSelectAllActive){return[0,0]}if(!this.selectionEnd||!this.selectionStart){return this.selectionStart}return this.areSelectionValuesReversed()?this.selectionEnd:this.selectionStart},enumerable:true,configurable:true});Object.defineProperty(SelectionModel.prototype,"finalSelectionEnd",{get:function(){if(this.isSelectAllActive){return[this._terminal.cols,this._terminal.buffer.ybase+this._terminal.rows-1]}if(!this.selectionStart){return null}if(!this.selectionEnd||this.areSelectionValuesReversed()){return[this.selectionStart[0]+this.selectionStartLength,this.selectionStart[1]]}if(this.selectionStartLength){if(this.selectionEnd[1]===this.selectionStart[1]){return[Math.max(this.selectionStart[0]+this.selectionStartLength,this.selectionEnd[0]),this.selectionEnd[1]]}}return this.selectionEnd},enumerable:true,configurable:true});SelectionModel.prototype.areSelectionValuesReversed=function(){var start=this.selectionStart;var end=this.selectionEnd;if(!start||!end){return false}return start[1]>end[1]||start[1]===end[1]&&start[0]>end[0]};SelectionModel.prototype.onTrim=function(amount){if(this.selectionStart){this.selectionStart[1]-=amount}if(this.selectionEnd){this.selectionEnd[1]-=amount}if(this.selectionEnd&&this.selectionEnd[1]<0){this.clearSelection();return true}if(this.selectionStart&&this.selectionStart[1]<0){this.selectionStart[1]=0}return false};return SelectionModel}();exports.SelectionModel=SelectionModel},{}],14:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.DEFAULT_BELL_SOUND="data:audio/wav;base64,UklGRigBAABXQVZFZm10IBAAAAABAAEARKwAAIhYAQACABAAZGF0YQQBAADpAFgCwAMlBZoG/wdmCcoKRAypDQ8PbRDBEQQTOxRtFYcWlBePGIUZXhoiG88bcBz7HHIdzh0WHlMeZx51HmkeUx4WHs8dah0AHXwc3hs9G4saxRnyGBIYGBcQFv8U4RPAEoYRQBACD70NWwwHC6gJOwjWBloF7gOBAhABkf8b/qv8R/ve+Xf4Ife79W/0JfPZ8Z/wde9N7ijtE+wU6xvqM+lb6H7nw+YX5mrlxuQz5Mzje+Ma49fioeKD4nXiYeJy4pHitOL04j/jn+MN5IPkFOWs5U3mDefM55/ogOl36m7rdOyE7abuyu8D8Unyj/Pg9D/2qfcb+Yn6/vuK/Qj/lAAlAg==";var SoundManager=function(){function SoundManager(_terminal){this._terminal=_terminal}SoundManager.prototype.playBellSound=function(){var audioContextCtor=window.AudioContext||window.webkitAudioContext;if(!this._audioContext&&audioContextCtor){this._audioContext=new audioContextCtor}if(this._audioContext){var bellAudioSource_1=this._audioContext.createBufferSource();var context_1=this._audioContext;this._audioContext.decodeAudioData(this._base64ToArrayBuffer(this._removeMimeType(this._terminal.options.bellSound)),function(buffer){bellAudioSource_1.buffer=buffer;bellAudioSource_1.connect(context_1.destination);bellAudioSource_1.start(0)})}else{console.warn("Sorry, but the Web Audio API is not supported by your browser. Please, consider upgrading to the latest version")}};SoundManager.prototype._base64ToArrayBuffer=function(base64){var binaryString=window.atob(base64);var len=binaryString.length;var bytes=new Uint8Array(len);for(var i=0;i<len;i++){bytes[i]=binaryString.charCodeAt(i)}return bytes.buffer};SoundManager.prototype._removeMimeType=function(dataURI){var splitUri=dataURI.split(",");return splitUri[1]};return SoundManager}();exports.SoundManager=SoundManager},{}],15:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.blankLine="Blank line";exports.promptLabel="Terminal input";exports.tooMuchOutput="Too much output to announce, navigate to rows manually to read"},{}],16:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:true});var BufferSet_1=require("./BufferSet");var Buffer_1=require("./Buffer");var CompositionHelper_1=require("./CompositionHelper");var EventEmitter_1=require("./EventEmitter");var Viewport_1=require("./Viewport");var Clipboard_1=require("./handlers/Clipboard");var EscapeSequences_1=require("./EscapeSequences");var InputHandler_1=require("./InputHandler");var Parser_1=require("./Parser");var Renderer_1=require("./renderer/Renderer");var Linkifier_1=require("./Linkifier");var SelectionManager_1=require("./SelectionManager");var CharMeasure_1=require("./utils/CharMeasure");var Browser=require("./shared/utils/Browser");var Strings=require("./Strings");var MouseHelper_1=require("./utils/MouseHelper");var Clone_1=require("./utils/Clone");var SoundManager_1=require("./SoundManager");var ColorManager_1=require("./renderer/ColorManager");var MouseZoneManager_1=require("./input/MouseZoneManager");var AccessibilityManager_1=require("./AccessibilityManager");var ScreenDprMonitor_1=require("./utils/ScreenDprMonitor");var KEYCODE_KEY_MAPPINGS={48:["0",")"],49:["1","!"],50:["2","@"],51:["3","#"],52:["4","$"],53:["5","%"],54:["6","^"],55:["7","&"],56:["8","*"],57:["9","("],186:[";",":"],187:["=","+"],188:[",","<"],189:["-","_"],190:[".",">"],191:["/","?"],192:["`","~"],219:["[","{"],220:["\\","|"],221:["]","}"],222:["'",'"']};var document=typeof window!=="undefined"?window.document:null;var WRITE_BUFFER_PAUSE_THRESHOLD=5;var WRITE_BATCH_SIZE=300;var DEFAULT_OPTIONS={cols:80,rows:24,convertEol:false,termName:"xterm",cursorBlink:false,cursorStyle:"block",bellSound:SoundManager_1.DEFAULT_BELL_SOUND,bellStyle:"none",enableBold:true,fontFamily:"courier-new, courier, monospace",fontSize:15,fontWeight:"normal",fontWeightBold:"bold",lineHeight:1,letterSpacing:0,scrollback:1e3,screenKeys:false,screenReaderMode:false,debug:false,macOptionIsMeta:false,cancelEvents:false,disableStdin:false,useFlowControl:false,allowTransparency:false,tabStopWidth:8,theme:null,rightClickSelectsWord:Browser.isMac};var Terminal=function(_super){__extends(Terminal,_super);function Terminal(options){if(options===void 0){options={}}var _this=_super.call(this)||this;_this.browser=Browser;_this.options=Clone_1.clone(options);_this._setup();return _this}Terminal.prototype._setup=function(){var _this=this;Object.keys(DEFAULT_OPTIONS).forEach(function(key){if(_this.options[key]==null){_this.options[key]=DEFAULT_OPTIONS[key]}_this[key]=_this.options[key]});this._parent=document?document.body:null;this.cols=this.options.cols;this.rows=this.options.rows;if(this.options.handler){this.on("data",this.options.handler)}this.cursorState=0;this.cursorHidden=false;this._sendDataQueue="";this._customKeyEventHandler=null;this.applicationKeypad=false;this.applicationCursor=false;this.originMode=false;this.insertMode=false;this.wraparoundMode=true;this.bracketedPasteMode=false;this.charset=null;this.gcharset=null;this.glevel=0;this.charsets=[null];this.defAttr=0<<18|257<<9|256<<0;this.curAttr=0<<18|257<<9|256<<0;this.params=[];this.currentParam=0;this.prefix="";this.postfix="";this.writeBuffer=[];this._writeInProgress=false;this._xoffSentToCatchUp=false;this._userScrolling=false;this._inputHandler=new InputHandler_1.InputHandler(this);this._parser=new Parser_1.Parser(this._inputHandler,this);this.renderer=this.renderer||null;this.selectionManager=this.selectionManager||null;this.linkifier=this.linkifier||new Linkifier_1.Linkifier(this);this._mouseZoneManager=this._mouseZoneManager||null;this.soundManager=this.soundManager||new SoundManager_1.SoundManager(this);this.buffers=new BufferSet_1.BufferSet(this);if(this.selectionManager){this.selectionManager.clearSelection();this.selectionManager.initBuffersListeners()}};Object.defineProperty(Terminal.prototype,"buffer",{get:function(){return this.buffers.active},enumerable:true,configurable:true});Object.defineProperty(Terminal,"strings",{get:function(){return Strings},enumerable:true,configurable:true});Terminal.prototype.eraseAttr=function(){return this.defAttr&~511|this.curAttr&511};Terminal.prototype.focus=function(){if(this.textarea){this.textarea.focus()}};Object.defineProperty(Terminal.prototype,"isFocused",{get:function(){return document.activeElement===this.textarea},enumerable:true,configurable:true});Terminal.prototype.getOption=function(key){if(!(key in DEFAULT_OPTIONS)){throw new Error('No option with key "'+key+'"')}if(typeof this.options[key]!=="undefined"){return this.options[key]}return this[key]};Terminal.prototype.setOption=function(key,value){if(!(key in DEFAULT_OPTIONS)){throw new Error('No option with key "'+key+'"')}switch(key){case"bellStyle":if(!value){value="none"}break;case"cursorStyle":if(!value){value="block"}break;case"fontWeight":if(!value){value="normal"}break;case"fontWeightBold":if(!value){value="bold"}break;case"lineHeight":if(value<1){console.warn(key+" cannot be less than 1, value: "+value);return}case"tabStopWidth":if(value<1){console.warn(key+" cannot be less than 1, value: "+value);return}break;case"theme":if(this.renderer){this._setTheme(value);return}break;case"scrollback":value=Math.min(value,Buffer_1.MAX_BUFFER_SIZE);if(value<0){console.warn(key+" cannot be less than 0, value: "+value);return}if(this.options[key]!==value){var newBufferLength=this.rows+value;if(this.buffer.lines.length>newBufferLength){var amountToTrim=this.buffer.lines.length-newBufferLength;var needsRefresh=this.buffer.ydisp-amountToTrim<0;this.buffer.lines.trimStart(amountToTrim);this.buffer.ybase=Math.max(this.buffer.ybase-amountToTrim,0);this.buffer.ydisp=Math.max(this.buffer.ydisp-amountToTrim,0);if(needsRefresh){this.refresh(0,this.rows-1)}}}break}this[key]=value;this.options[key]=value;switch(key){case"fontFamily":case"fontSize":this.renderer.clear();this.charMeasure.measure(this.options);break;case"enableBold":case"letterSpacing":case"lineHeight":case"fontWeight":case"fontWeightBold":this.renderer.clear();this.renderer.onResize(this.cols,this.rows);this.refresh(0,this.rows-1);case"scrollback":this.buffers.resize(this.cols,this.rows);this.viewport.syncScrollArea();break;case"screenReaderMode":if(value){if(!this._accessibilityManager){this._accessibilityManager=new AccessibilityManager_1.AccessibilityManager(this)}}else{if(this._accessibilityManager){this._accessibilityManager.dispose();this._accessibilityManager=null}}break;case"tabStopWidth":this.buffers.setupTabStops();break}if(this.renderer){this.renderer.onOptionsChanged()}};Terminal.prototype._onTextAreaFocus=function(){if(this.sendFocus){this.send(EscapeSequences_1.C0.ESC+"[I")}this.element.classList.add("focus");this.showCursor();this.emit("focus")};Terminal.prototype.blur=function(){return this.textarea.blur()};Terminal.prototype._onTextAreaBlur=function(){this.textarea.value="";this.refresh(this.buffer.y,this.buffer.y);if(this.sendFocus){this.send(EscapeSequences_1.C0.ESC+"[O")}this.element.classList.remove("focus");this.emit("blur")};Terminal.prototype._initGlobal=function(){var _this=this;this._bindKeys();on(this.element,"copy",function(event){if(!_this.hasSelection()){return}Clipboard_1.copyHandler(event,_this,_this.selectionManager)});var pasteHandlerWrapper=function(event){return Clipboard_1.pasteHandler(event,_this)};on(this.textarea,"paste",pasteHandlerWrapper);on(this.element,"paste",pasteHandlerWrapper);if(Browser.isFirefox){on(this.element,"mousedown",function(event){if(event.button===2){Clipboard_1.rightClickHandler(event,_this.textarea,_this.selectionManager,_this.options.rightClickSelectsWord)}})}else{on(this.element,"contextmenu",function(event){Clipboard_1.rightClickHandler(event,_this.textarea,_this.selectionManager,_this.options.rightClickSelectsWord)})}if(Browser.isLinux){on(this.element,"auxclick",function(event){if(event.button===1){Clipboard_1.moveTextAreaUnderMouseCursor(event,_this.textarea)}})}};Terminal.prototype._bindKeys=function(){var _this=this;var self=this;on(this.element,"keydown",function(ev){if(document.activeElement!==this){return}self._keyDown(ev)},true);on(this.element,"keypress",function(ev){if(document.activeElement!==this){return}self._keyPress(ev)},true);on(this.element,"keyup",function(ev){if(!wasMondifierKeyOnlyEvent(ev)){_this.focus()}},true);on(this.textarea,"keydown",function(ev){return _this._keyDown(ev)},true);on(this.textarea,"keypress",function(ev){return _this._keyPress(ev)},true);on(this.textarea,"compositionstart",function(){return _this._compositionHelper.compositionstart()});on(this.textarea,"compositionupdate",function(e){return _this._compositionHelper.compositionupdate(e)});on(this.textarea,"compositionend",function(){return _this._compositionHelper.compositionend()});this.on("refresh",function(){return _this._compositionHelper.updateCompositionElements()});this.on("refresh",function(data){return _this._queueLinkification(data.start,data.end)})};Terminal.prototype.open=function(parent){var _this=this;this._parent=parent||this._parent;if(!this._parent){throw new Error("Terminal requires a parent element.")}this._context=this._parent.ownerDocument.defaultView;this._document=this._parent.ownerDocument;this._screenDprMonitor=new ScreenDprMonitor_1.ScreenDprMonitor;this._screenDprMonitor.setListener(function(){return _this.emit("dprchange",window.devicePixelRatio)});this.element=this._document.createElement("div");this.element.dir="ltr";this.element.classList.add("terminal");this.element.classList.add("xterm");this.element.setAttribute("tabindex","0");this._parent.appendChild(this.element);var fragment=document.createDocumentFragment();this._viewportElement=document.createElement("div");this._viewportElement.classList.add("xterm-viewport");fragment.appendChild(this._viewportElement);this._viewportScrollArea=document.createElement("div");this._viewportScrollArea.classList.add("xterm-scroll-area");this._viewportElement.appendChild(this._viewportScrollArea);this.screenElement=document.createElement("div");this.screenElement.classList.add("xterm-screen");this._helperContainer=document.createElement("div");this._helperContainer.classList.add("xterm-helpers");this.screenElement.appendChild(this._helperContainer);fragment.appendChild(this.screenElement);this._mouseZoneManager=new MouseZoneManager_1.MouseZoneManager(this);this.on("scroll",function(){return _this._mouseZoneManager.clearAll()});this.linkifier.attachToDom(this._mouseZoneManager);this.textarea=document.createElement("textarea");this.textarea.classList.add("xterm-helper-textarea");this.textarea.setAttribute("aria-label",Strings.promptLabel);this.textarea.setAttribute("aria-multiline","false");this.textarea.setAttribute("autocorrect","off");this.textarea.setAttribute("autocapitalize","off");this.textarea.setAttribute("spellcheck","false");this.textarea.tabIndex=0;this.textarea.addEventListener("focus",function(){return _this._onTextAreaFocus()});this.textarea.addEventListener("blur",function(){return _this._onTextAreaBlur()});this._helperContainer.appendChild(this.textarea);this._compositionView=document.createElement("div");this._compositionView.classList.add("composition-view");this._compositionHelper=new CompositionHelper_1.CompositionHelper(this.textarea,this._compositionView,this);this._helperContainer.appendChild(this._compositionView);this.charMeasure=new CharMeasure_1.CharMeasure(document,this._helperContainer);this.element.appendChild(fragment);this.renderer=new Renderer_1.Renderer(this,this.options.theme);this.options.theme=null;this.viewport=new Viewport_1.Viewport(this,this._viewportElement,this._viewportScrollArea,this.charMeasure);this.viewport.onThemeChanged(this.renderer.colorManager.colors);this.on("cursormove",function(){return _this.renderer.onCursorMove()});this.on("resize",function(){return _this.renderer.onResize(_this.cols,_this.rows)});this.on("blur",function(){return _this.renderer.onBlur()});this.on("focus",function(){return _this.renderer.onFocus()});this.on("dprchange",function(){return _this.renderer.onWindowResize(window.devicePixelRatio)});window.addEventListener("resize",function(){return _this.renderer.onWindowResize(window.devicePixelRatio)});this.charMeasure.on("charsizechanged",function(){return _this.renderer.onResize(_this.cols,_this.rows)});this.renderer.on("resize",function(dimensions){return _this.viewport.syncScrollArea()});this.selectionManager=new SelectionManager_1.SelectionManager(this,this.charMeasure);this.element.addEventListener("mousedown",function(e){return _this.selectionManager.onMouseDown(e)});this.selectionManager.on("refresh",function(data){return _this.renderer.onSelectionChanged(data.start,data.end)});this.selectionManager.on("newselection",function(text){_this.textarea.value=text;_this.textarea.focus();_this.textarea.select()});this.on("scroll",function(){_this.viewport.syncScrollArea();_this.selectionManager.refresh()});this._viewportElement.addEventListener("scroll",function(){return _this.selectionManager.refresh()});this.mouseHelper=new MouseHelper_1.MouseHelper(this.renderer);if(this.options.screenReaderMode){this._accessibilityManager=new AccessibilityManager_1.AccessibilityManager(this)}this.charMeasure.measure(this.options);this.refresh(0,this.rows-1);this._initGlobal();this.bindMouse()};Terminal.prototype._setTheme=function(theme){var colors=this.renderer.setTheme(theme);if(this.viewport){this.viewport.onThemeChanged(colors)}};Terminal.applyAddon=function(addon){addon.apply(Terminal)};Terminal.prototype.bindMouse=function(){var _this=this;var el=this.element;var self=this;var pressed=32;function sendButton(ev){var button;var pos;button=getButton(ev);pos=self.mouseHelper.getRawByteCoords(ev,self.screenElement,self.charMeasure,self.options.lineHeight,self.cols,self.rows);if(!pos)return;sendEvent(button,pos);switch(ev.overrideType||ev.type){case"mousedown":pressed=button;break;case"mouseup":pressed=32;break;case"wheel":break}}function sendMove(ev){var button=pressed;var pos=self.mouseHelper.getRawByteCoords(ev,self.screenElement,self.charMeasure,self.options.lineHeight,self.cols,self.rows);if(!pos)return;button+=32;sendEvent(button,pos)}function encode(data,ch){if(!self.utfMouse){if(ch===255){data.push(0);return}if(ch>127)ch=127;data.push(ch)}else{if(ch===2047){data.push(0);return}if(ch<127){data.push(ch)}else{if(ch>2047)ch=2047;data.push(192|ch>>6);data.push(128|ch&63)}}}function sendEvent(button,pos){if(self._vt300Mouse){button&=3;pos.x-=32;pos.y-=32;var data_1=EscapeSequences_1.C0.ESC+"[24";if(button===0)data_1+="1";else if(button===1)data_1+="3";else if(button===2)data_1+="5";else if(button===3)return;else data_1+="0";data_1+="~["+pos.x+","+pos.y+"]\r";self.send(data_1);return}if(self._decLocator){button&=3;pos.x-=32;pos.y-=32;if(button===0)button=2;else if(button===1)button=4;else if(button===2)button=6;else if(button===3)button=3;self.send(EscapeSequences_1.C0.ESC+"["+button+";"+(button===3?4:0)+";"+pos.y+";"+pos.x+";"+pos.page||0+"&w");return}if(self.urxvtMouse){pos.x-=32;pos.y-=32;pos.x++;pos.y++;self.send(EscapeSequences_1.C0.ESC+"["+button+";"+pos.x+";"+pos.y+"M");return}if(self.sgrMouse){pos.x-=32;pos.y-=32;self.send(EscapeSequences_1.C0.ESC+"[<"+(((button&3)===3?button&~3:button)-32)+";"+pos.x+";"+pos.y+((button&3)===3?"m":"M"));return}var data=[];encode(data,button);encode(data,pos.x);encode(data,pos.y);self.send(EscapeSequences_1.C0.ESC+"[M"+String.fromCharCode.apply(String,data))}function getButton(ev){var button;var shift;var meta;var ctrl;var mod;switch(ev.overrideType||ev.type){case"mousedown":button=ev.button!=null?+ev.button:ev.which!=null?ev.which-1:null;if(Browser.isMSIE){button=button===1?0:button===4?1:button}break;case"mouseup":button=3;break;case"DOMMouseScroll":button=ev.detail<0?64:65;break;case"wheel":button=ev.wheelDeltaY>0?64:65;break}shift=ev.shiftKey?4:0;meta=ev.metaKey?8:0;ctrl=ev.ctrlKey?16:0;mod=shift|meta|ctrl;if(self.vt200Mouse){mod&=ctrl}else if(!self.normalMouse){mod=0}button=32+(mod<<2)+button;return button}on(el,"mousedown",function(ev){ev.preventDefault();_this.focus();if(!_this.mouseEvents||_this.selectionManager.shouldForceSelection(ev)){return}sendButton(ev);if(_this.vt200Mouse){ev.overrideType="mouseup";sendButton(ev);return _this.cancel(ev)}if(_this.normalMouse)on(_this._document,"mousemove",sendMove);if(!_this.x10Mouse){var handler_1=function(ev){sendButton(ev);if(_this.normalMouse)off(_this._document,"mousemove",sendMove);off(_this._document,"mouseup",handler_1);return _this.cancel(ev)};on(_this._document,"mouseup",handler_1)}return _this.cancel(ev)});on(el,"wheel",function(ev){if(!_this.mouseEvents){if(!_this.buffer.hasScrollback){var amount=_this.viewport.getLinesScrolled(ev);if(amount===0){return}var sequence=EscapeSequences_1.C0.ESC+(_this.applicationCursor?"O":"[")+(ev.deltaY<0?"A":"B");var data="";for(var i=0;i<Math.abs(amount);i++){data+=sequence}_this.send(data)}return}if(_this.x10Mouse||_this._vt300Mouse||_this._decLocator)return;sendButton(ev);ev.preventDefault()});on(el,"wheel",function(ev){if(_this.mouseEvents)return;_this.viewport.onWheel(ev);return _this.cancel(ev)});on(el,"touchstart",function(ev){if(_this.mouseEvents)return;_this.viewport.onTouchStart(ev);return _this.cancel(ev)});on(el,"touchmove",function(ev){if(_this.mouseEvents)return;_this.viewport.onTouchMove(ev);return _this.cancel(ev)})};Terminal.prototype.destroy=function(){_super.prototype.destroy.call(this);this.handler=function(){};this.write=function(){};if(this.element&&this.element.parentNode){this.element.parentNode.removeChild(this.element)}};Terminal.prototype.refresh=function(start,end){if(this.renderer){this.renderer.refreshRows(start,end)}};Terminal.prototype._queueLinkification=function(start,end){if(this.linkifier){this.linkifier.linkifyRows(start,end)}};Terminal.prototype.showCursor=function(){if(!this.cursorState){this.cursorState=1;this.refresh(this.buffer.y,this.buffer.y)}};Terminal.prototype.scroll=function(isWrapped){var newLine=this.blankLine(undefined,isWrapped);var topRow=this.buffer.ybase+this.buffer.scrollTop;var bottomRow=this.buffer.ybase+this.buffer.scrollBottom;if(this.buffer.scrollTop===0){var willBufferBeTrimmed=this.buffer.lines.length===this.buffer.lines.maxLength;if(bottomRow===this.buffer.lines.length-1){this.buffer.lines.push(newLine)}else{this.buffer.lines.splice(bottomRow+1,0,newLine)}if(!willBufferBeTrimmed){this.buffer.ybase++;if(!this._userScrolling){this.buffer.ydisp++}}else{if(this._userScrolling){this.buffer.ydisp=Math.max(this.buffer.ydisp-1,0)}}}else{var scrollRegionHeight=bottomRow-topRow+1;this.buffer.lines.shiftElements(topRow+1,scrollRegionHeight-1,-1);this.buffer.lines.set(bottomRow,newLine)}if(!this._userScrolling){this.buffer.ydisp=this.buffer.ybase}this.updateRange(this.buffer.scrollTop);this.updateRange(this.buffer.scrollBottom);this.emit("scroll",this.buffer.ydisp)};Terminal.prototype.scrollLines=function(disp,suppressScrollEvent){if(disp<0){if(this.buffer.ydisp===0){return}this._userScrolling=true}else if(disp+this.buffer.ydisp>=this.buffer.ybase){this._userScrolling=false}var oldYdisp=this.buffer.ydisp;this.buffer.ydisp=Math.max(Math.min(this.buffer.ydisp+disp,this.buffer.ybase),0);if(oldYdisp===this.buffer.ydisp){return}if(!suppressScrollEvent){this.emit("scroll",this.buffer.ydisp)}this.refresh(0,this.rows-1)};Terminal.prototype.scrollPages=function(pageCount){this.scrollLines(pageCount*(this.rows-1))};Terminal.prototype.scrollToTop=function(){this.scrollLines(-this.buffer.ydisp)};Terminal.prototype.scrollToBottom=function(){this.scrollLines(this.buffer.ybase-this.buffer.ydisp)};Terminal.prototype.scrollToLine=function(line){var scrollAmount=line-this.buffer.ydisp;if(scrollAmount!==0){this.scrollLines(scrollAmount)}};Terminal.prototype.write=function(data){var _this=this;if(!data){return}this.writeBuffer.push(data);if(this.options.useFlowControl&&!this._xoffSentToCatchUp&&this.writeBuffer.length>=WRITE_BUFFER_PAUSE_THRESHOLD){this.send(EscapeSequences_1.C0.DC3);this._xoffSentToCatchUp=true}if(!this._writeInProgress&&this.writeBuffer.length>0){this._writeInProgress=true;setTimeout(function(){_this._innerWrite()})}};Terminal.prototype._innerWrite=function(){var _this=this;var writeBatch=this.writeBuffer.splice(0,WRITE_BATCH_SIZE);while(writeBatch.length>0){var data=writeBatch.shift();if(this._xoffSentToCatchUp&&writeBatch.length===0&&this.writeBuffer.length===0){this.send(EscapeSequences_1.C0.DC1);this._xoffSentToCatchUp=false}this._refreshStart=this.buffer.y;this._refreshEnd=this.buffer.y;var state=this._parser.parse(data);this._parser.setState(state);this.updateRange(this.buffer.y);this.refresh(this._refreshStart,this._refreshEnd)}if(this.writeBuffer.length>0){setTimeout(function(){return _this._innerWrite()},0)}else{this._writeInProgress=false}};Terminal.prototype.writeln=function(data){this.write(data+"\r\n")};Terminal.prototype.attachCustomKeyEventHandler=function(customKeyEventHandler){this._customKeyEventHandler=customKeyEventHandler};Terminal.prototype.registerLinkMatcher=function(regex,handler,options){var matcherId=this.linkifier.registerLinkMatcher(regex,handler,options);this.refresh(0,this.rows-1);return matcherId};Terminal.prototype.deregisterLinkMatcher=function(matcherId){if(this.linkifier.deregisterLinkMatcher(matcherId)){this.refresh(0,this.rows-1)}};Object.defineProperty(Terminal.prototype,"markers",{get:function(){return this.buffer.markers},enumerable:true,configurable:true});Terminal.prototype.addMarker=function(cursorYOffset){if(this.buffer!==this.buffers.normal){return}return this.buffer.addMarker(this.buffer.ybase+this.buffer.y+cursorYOffset)};Terminal.prototype.hasSelection=function(){return this.selectionManager?this.selectionManager.hasSelection:false};Terminal.prototype.getSelection=function(){return this.selectionManager?this.selectionManager.selectionText:""};Terminal.prototype.clearSelection=function(){if(this.selectionManager){this.selectionManager.clearSelection()}};Terminal.prototype.selectAll=function(){if(this.selectionManager){this.selectionManager.selectAll()}};Terminal.prototype.selectLines=function(start,end){if(this.selectionManager){this.selectionManager.selectLines(start,end)}};Terminal.prototype._keyDown=function(ev){if(this._customKeyEventHandler&&this._customKeyEventHandler(ev)===false){return false}if(!this._compositionHelper.keydown(ev)){if(this.buffer.ybase!==this.buffer.ydisp){this.scrollToBottom()}return false}var result=this._evaluateKeyEscapeSequence(ev);if(result.scrollLines){this.scrollLines(result.scrollLines);return this.cancel(ev,true)}if(this._isThirdLevelShift(this.browser,ev)){return true}if(result.cancel){this.cancel(ev,true)}if(!result.key){return true}this.emit("keydown",ev);this.emit("key",result.key,ev);this.showCursor();this.handler(result.key);return this.cancel(ev,true)};Terminal.prototype._isThirdLevelShift=function(browser,ev){var thirdLevelKey=browser.isMac&&!this.options.macOptionIsMeta&&ev.altKey&&!ev.ctrlKey&&!ev.metaKey||browser.isMSWindows&&ev.altKey&&ev.ctrlKey&&!ev.metaKey;if(ev.type==="keypress"){return thirdLevelKey}return thirdLevelKey&&(!ev.keyCode||ev.keyCode>47)};Terminal.prototype._evaluateKeyEscapeSequence=function(ev){var result={cancel:false,key:undefined,scrollLines:undefined};var modifiers=(ev.shiftKey?1:0)|(ev.altKey?2:0)|(ev.ctrlKey?4:0)|(ev.metaKey?8:0);switch(ev.keyCode){case 0:if(ev.key==="UIKeyInputUpArrow"){if(this.applicationCursor){result.key=EscapeSequences_1.C0.ESC+"OA"}else{result.key=EscapeSequences_1.C0.ESC+"[A"}}else if(ev.key==="UIKeyInputLeftArrow"){if(this.applicationCursor){result.key=EscapeSequences_1.C0.ESC+"OD"}else{result.key=EscapeSequences_1.C0.ESC+"[D"}}else if(ev.key==="UIKeyInputRightArrow"){if(this.applicationCursor){result.key=EscapeSequences_1.C0.ESC+"OC"}else{result.key=EscapeSequences_1.C0.ESC+"[C"}}else if(ev.key==="UIKeyInputDownArrow"){if(this.applicationCursor){result.key=EscapeSequences_1.C0.ESC+"OB"}else{result.key=EscapeSequences_1.C0.ESC+"[B"}}break;case 8:if(ev.shiftKey){result.key=EscapeSequences_1.C0.BS;break}else if(ev.altKey){result.key=EscapeSequences_1.C0.ESC+EscapeSequences_1.C0.DEL;break}result.key=EscapeSequences_1.C0.DEL;break;case 9:if(ev.shiftKey){result.key=EscapeSequences_1.C0.ESC+"[Z";break}result.key=EscapeSequences_1.C0.HT;result.cancel=true;break;case 13:result.key=EscapeSequences_1.C0.CR;result.cancel=true;break;case 27:result.key=EscapeSequences_1.C0.ESC;result.cancel=true;break;case 37:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"D";if(result.key===EscapeSequences_1.C0.ESC+"[1;3D"){result.key=this.browser.isMac?EscapeSequences_1.C0.ESC+"b":EscapeSequences_1.C0.ESC+"[1;5D"}}else if(this.applicationCursor){result.key=EscapeSequences_1.C0.ESC+"OD"}else{result.key=EscapeSequences_1.C0.ESC+"[D"}break;case 39:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"C";if(result.key===EscapeSequences_1.C0.ESC+"[1;3C"){result.key=this.browser.isMac?EscapeSequences_1.C0.ESC+"f":EscapeSequences_1.C0.ESC+"[1;5C"}}else if(this.applicationCursor){result.key=EscapeSequences_1.C0.ESC+"OC"}else{result.key=EscapeSequences_1.C0.ESC+"[C"}break;case 38:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"A";if(result.key===EscapeSequences_1.C0.ESC+"[1;3A"){result.key=EscapeSequences_1.C0.ESC+"[1;5A"}}else if(this.applicationCursor){result.key=EscapeSequences_1.C0.ESC+"OA"}else{result.key=EscapeSequences_1.C0.ESC+"[A"}break;case 40:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"B";if(result.key===EscapeSequences_1.C0.ESC+"[1;3B"){result.key=EscapeSequences_1.C0.ESC+"[1;5B"}}else if(this.applicationCursor){result.key=EscapeSequences_1.C0.ESC+"OB"}else{result.key=EscapeSequences_1.C0.ESC+"[B"}break;case 45:if(!ev.shiftKey&&!ev.ctrlKey){result.key=EscapeSequences_1.C0.ESC+"[2~"}break;case 46:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[3;"+(modifiers+1)+"~"}else{result.key=EscapeSequences_1.C0.ESC+"[3~"}break;case 36:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"H"}else if(this.applicationCursor){result.key=EscapeSequences_1.C0.ESC+"OH"}else{result.key=EscapeSequences_1.C0.ESC+"[H"}break;case 35:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"F"}else if(this.applicationCursor){result.key=EscapeSequences_1.C0.ESC+"OF"}else{result.key=EscapeSequences_1.C0.ESC+"[F"}break;case 33:if(ev.shiftKey){result.scrollLines=-(this.rows-1)}else{result.key=EscapeSequences_1.C0.ESC+"[5~"}break;case 34:if(ev.shiftKey){result.scrollLines=this.rows-1}else{result.key=EscapeSequences_1.C0.ESC+"[6~"}break;case 112:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"P"}else{result.key=EscapeSequences_1.C0.ESC+"OP"}break;case 113:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"Q"}else{result.key=EscapeSequences_1.C0.ESC+"OQ"}break;case 114:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"R"}else{result.key=EscapeSequences_1.C0.ESC+"OR"}break;case 115:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"S"}else{result.key=EscapeSequences_1.C0.ESC+"OS"}break;case 116:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[15;"+(modifiers+1)+"~"}else{result.key=EscapeSequences_1.C0.ESC+"[15~"}break;case 117:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[17;"+(modifiers+1)+"~"}else{result.key=EscapeSequences_1.C0.ESC+"[17~"}break;case 118:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[18;"+(modifiers+1)+"~"}else{result.key=EscapeSequences_1.C0.ESC+"[18~"}break;case 119:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[19;"+(modifiers+1)+"~"}else{result.key=EscapeSequences_1.C0.ESC+"[19~"}break;case 120:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[20;"+(modifiers+1)+"~"}else{result.key=EscapeSequences_1.C0.ESC+"[20~"}break;case 121:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[21;"+(modifiers+1)+"~"}else{result.key=EscapeSequences_1.C0.ESC+"[21~"}break;case 122:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[23;"+(modifiers+1)+"~"}else{result.key=EscapeSequences_1.C0.ESC+"[23~"}break;case 123:if(modifiers){result.key=EscapeSequences_1.C0.ESC+"[24;"+(modifiers+1)+"~"}else{result.key=EscapeSequences_1.C0.ESC+"[24~"}break;default:if(ev.ctrlKey&&!ev.shiftKey&&!ev.altKey&&!ev.metaKey){if(ev.keyCode>=65&&ev.keyCode<=90){result.key=String.fromCharCode(ev.keyCode-64)}else if(ev.keyCode===32){result.key=String.fromCharCode(0)}else if(ev.keyCode>=51&&ev.keyCode<=55){result.key=String.fromCharCode(ev.keyCode-51+27)}else if(ev.keyCode===56){result.key=String.fromCharCode(127)}else if(ev.keyCode===219){result.key=String.fromCharCode(27)}else if(ev.keyCode===220){result.key=String.fromCharCode(28)}else if(ev.keyCode===221){result.key=String.fromCharCode(29)}}else if((!this.browser.isMac||this.options.macOptionIsMeta)&&ev.altKey&&!ev.metaKey){var keyMapping=KEYCODE_KEY_MAPPINGS[ev.keyCode];var key=keyMapping&&keyMapping[!ev.shiftKey?0:1];if(key){result.key=EscapeSequences_1.C0.ESC+key}else if(ev.keyCode>=65&&ev.keyCode<=90){var keyCode=ev.ctrlKey?ev.keyCode-64:ev.keyCode+32;result.key=EscapeSequences_1.C0.ESC+String.fromCharCode(keyCode)}}else if(this.browser.isMac&&!ev.altKey&&!ev.ctrlKey&&ev.metaKey){if(ev.keyCode===65){this.selectAll()}}break}return result};Terminal.prototype.setgLevel=function(g){this.glevel=g;this.charset=this.charsets[g]};Terminal.prototype.setgCharset=function(g,charset){this.charsets[g]=charset;if(this.glevel===g){this.charset=charset}};Terminal.prototype._keyPress=function(ev){var key;if(this._customKeyEventHandler&&this._customKeyEventHandler(ev)===false){return false}this.cancel(ev);if(ev.charCode){key=ev.charCode}else if(ev.which==null){key=ev.keyCode}else if(ev.which!==0&&ev.charCode!==0){key=ev.which}else{return false}if(!key||(ev.altKey||ev.ctrlKey||ev.metaKey)&&!this._isThirdLevelShift(this.browser,ev)){return false}key=String.fromCharCode(key);this.emit("keypress",key,ev);this.emit("key",key,ev);this.showCursor();this.handler(key);return true};Terminal.prototype.send=function(data){var _this=this;if(!this._sendDataQueue){setTimeout(function(){_this.handler(_this._sendDataQueue);_this._sendDataQueue=""},1)}this._sendDataQueue+=data};Terminal.prototype.bell=function(){var _this=this;this.emit("bell");if(this._soundBell()){this.soundManager.playBellSound()}if(this._visualBell()){this.element.classList.add("visual-bell-active");clearTimeout(this._visualBellTimer);this._visualBellTimer=window.setTimeout(function(){_this.element.classList.remove("visual-bell-active")},200)}};Terminal.prototype.log=function(text,data){if(!this.options.debug)return;if(!this._context.console||!this._context.console.log)return;this._context.console.log(text,data)};Terminal.prototype.error=function(text,data){if(!this.options.debug)return;if(!this._context.console||!this._context.console.error)return;this._context.console.error(text,data)};Terminal.prototype.resize=function(x,y){if(isNaN(x)||isNaN(y)){return}if(x===this.cols&&y===this.rows){if(!this.charMeasure.width||!this.charMeasure.height){this.charMeasure.measure(this.options)}return}if(x<1)x=1;if(y<1)y=1;this.buffers.resize(x,y);this.cols=x;this.rows=y;this.buffers.setupTabStops(this.cols);if(this.charMeasure){this.charMeasure.measure(this.options)}this.refresh(0,this.rows-1);this.emit("resize",{cols:x,rows:y})};Terminal.prototype.updateRange=function(y){if(y<this._refreshStart)this._refreshStart=y;if(y>this._refreshEnd)this._refreshEnd=y};Terminal.prototype.maxRange=function(){this._refreshStart=0;this._refreshEnd=this.rows-1};Terminal.prototype.eraseRight=function(x,y){var line=this.buffer.lines.get(this.buffer.ybase+y);if(!line){return}var ch=[this.eraseAttr()," ",1,32];for(;x<this.cols;x++){line[x]=ch}this.updateRange(y)};Terminal.prototype.eraseLeft=function(x,y){var line=this.buffer.lines.get(this.buffer.ybase+y);if(!line){return}var ch=[this.eraseAttr()," ",1,32];x++;while(x--){line[x]=ch}this.updateRange(y)};Terminal.prototype.clear=function(){if(this.buffer.ybase===0&&this.buffer.y===0){return}this.buffer.lines.set(0,this.buffer.lines.get(this.buffer.ybase+this.buffer.y));this.buffer.lines.length=1;this.buffer.ydisp=0;this.buffer.ybase=0;this.buffer.y=0;for(var i=1;i<this.rows;i++){this.buffer.lines.push(this.blankLine())}this.refresh(0,this.rows-1);this.emit("scroll",this.buffer.ydisp)};Terminal.prototype.eraseLine=function(y){this.eraseRight(0,y)};Terminal.prototype.blankLine=function(cur,isWrapped,cols){var attr=cur?this.eraseAttr():this.defAttr;var ch=[attr," ",1,32];var line=[];if(isWrapped){line.isWrapped=isWrapped}cols=cols||this.cols;for(var i=0;i<cols;i++){line[i]=ch}return line};Terminal.prototype.ch=function(cur){if(cur){return[this.eraseAttr()," ",1,32]}return[this.defAttr," ",1,32]};Terminal.prototype.is=function(term){return(this.options.termName+"").indexOf(term)===0};Terminal.prototype.handler=function(data){if(this.options.disableStdin){return}if(this.selectionManager&&this.selectionManager.hasSelection){this.selectionManager.clearSelection()}if(this.buffer.ybase!==this.buffer.ydisp){this.scrollToBottom()}this.emit("data",data)};Terminal.prototype.handleTitle=function(title){this.emit("title",title)};Terminal.prototype.index=function(){this.buffer.y++;if(this.buffer.y>this.buffer.scrollBottom){this.buffer.y--;this.scroll()}if(this.buffer.x>=this.cols){this.buffer.x--}};Terminal.prototype.reverseIndex=function(){if(this.buffer.y===this.buffer.scrollTop){var scrollRegionHeight=this.buffer.scrollBottom-this.buffer.scrollTop;this.buffer.lines.shiftElements(this.buffer.y+this.buffer.ybase,scrollRegionHeight,1);this.buffer.lines.set(this.buffer.y+this.buffer.ybase,this.blankLine(true));this.updateRange(this.buffer.scrollTop);this.updateRange(this.buffer.scrollBottom)}else{this.buffer.y--}};Terminal.prototype.reset=function(){this.options.rows=this.rows;this.options.cols=this.cols;var customKeyEventHandler=this._customKeyEventHandler;var inputHandler=this._inputHandler;this._setup();this._customKeyEventHandler=customKeyEventHandler;this._inputHandler=inputHandler;this.refresh(0,this.rows-1);if(this.viewport){this.viewport.syncScrollArea()}};Terminal.prototype.tabSet=function(){this.buffer.tabs[this.buffer.x]=true};Terminal.prototype.cancel=function(ev,force){if(!this.options.cancelEvents&&!force){return}ev.preventDefault();ev.stopPropagation();return false};Terminal.prototype.matchColor=function(r1,g1,b1){return matchColor_(r1,g1,b1)};Terminal.prototype._visualBell=function(){return false};Terminal.prototype._soundBell=function(){return this.options.bellStyle==="sound"};return Terminal}(EventEmitter_1.EventEmitter);exports.Terminal=Terminal;function globalOn(el,type,handler,capture){if(!Array.isArray(el)){el=[el]}el.forEach(function(element){element.addEventListener(type,handler,capture||false)})}var on=globalOn;function off(el,type,handler,capture){if(capture===void 0){capture=false}el.removeEventListener(type,handler,capture)}function wasMondifierKeyOnlyEvent(ev){return ev.keyCode===16||ev.keyCode===17||ev.keyCode===18}var matchColorCache={};function matchColorDistance(r1,g1,b1,r2,g2,b2){return Math.pow(30*(r1-r2),2)+Math.pow(59*(g1-g2),2)+Math.pow(11*(b1-b2),2)}function matchColor_(r1,g1,b1){var hash=r1<<16|g1<<8|b1;if(matchColorCache[hash]!=null){return matchColorCache[hash]}var ldiff=Infinity;var li=-1;var i=0;var c;var r2;var g2;var b2;var diff;for(;i<ColorManager_1.DEFAULT_ANSI_COLORS.length;i++){c=ColorManager_1.DEFAULT_ANSI_COLORS[i].rgba;r2=c>>>24;g2=c>>>16&255;b2=c>>>8&255;diff=matchColorDistance(r1,g1,b1,r2,g2,b2);if(diff===0){li=i;break}if(diff<ldiff){ldiff=diff;li=i}}return matchColorCache[hash]=li}},{"./AccessibilityManager":1,"./Buffer":2,"./BufferSet":3,"./CompositionHelper":6,"./EscapeSequences":7,"./EventEmitter":8,"./InputHandler":9,"./Linkifier":10,"./Parser":11,"./SelectionManager":12,"./SoundManager":14,"./Strings":15,"./Viewport":18,"./handlers/Clipboard":20,"./input/MouseZoneManager":21,"./renderer/ColorManager":23,"./renderer/Renderer":27,"./shared/utils/Browser":36,"./utils/CharMeasure":37,"./utils/Clone":39,"./utils/MouseHelper":41,"./utils/ScreenDprMonitor":43}],17:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var LinkHoverEventTypes;(function(LinkHoverEventTypes){LinkHoverEventTypes["HOVER"]="linkhover";LinkHoverEventTypes["TOOLTIP"]="linktooltip";LinkHoverEventTypes["LEAVE"]="linkleave"})(LinkHoverEventTypes=exports.LinkHoverEventTypes||(exports.LinkHoverEventTypes={}))},{}],18:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var FALLBACK_SCROLL_BAR_WIDTH=15;var Viewport=function(){function Viewport(_terminal,_viewportElement,_scrollArea,_charMeasure){var _this=this;this._terminal=_terminal;this._viewportElement=_viewportElement;this._scrollArea=_scrollArea;this._charMeasure=_charMeasure;this.scrollBarWidth=0;this._currentRowHeight=0;this._lastRecordedBufferLength=0;this._lastRecordedViewportHeight=0;this._lastRecordedBufferHeight=0;this._wheelPartialScroll=0;this.scrollBarWidth=this._viewportElement.offsetWidth-this._scrollArea.offsetWidth||FALLBACK_SCROLL_BAR_WIDTH;this._viewportElement.addEventListener("scroll",this._onScroll.bind(this));setTimeout(function(){return _this.syncScrollArea()},0)}Viewport.prototype.onThemeChanged=function(colors){this._viewportElement.style.backgroundColor=colors.background.css};Viewport.prototype._refresh=function(){if(this._charMeasure.height>0){this._currentRowHeight=this._terminal.renderer.dimensions.scaledCellHeight/window.devicePixelRatio;this._lastRecordedViewportHeight=this._viewportElement.offsetHeight;var newBufferHeight=Math.round(this._currentRowHeight*this._lastRecordedBufferLength)+(this._lastRecordedViewportHeight-this._terminal.renderer.dimensions.canvasHeight);if(this._lastRecordedBufferHeight!==newBufferHeight){this._lastRecordedBufferHeight=newBufferHeight;this._scrollArea.style.height=this._lastRecordedBufferHeight+"px"}}};Viewport.prototype.syncScrollArea=function(){if(this._lastRecordedBufferLength!==this._terminal.buffer.lines.length){this._lastRecordedBufferLength=this._terminal.buffer.lines.length;this._refresh()}else if(this._lastRecordedViewportHeight!==this._terminal.renderer.dimensions.canvasHeight){this._refresh()}else{if(this._terminal.renderer.dimensions.scaledCellHeight/window.devicePixelRatio!==this._currentRowHeight){this._refresh()}}var scrollTop=this._terminal.buffer.ydisp*this._currentRowHeight;if(this._viewportElement.scrollTop!==scrollTop){this._viewportElement.scrollTop=scrollTop}};Viewport.prototype._onScroll=function(ev){if(!this._viewportElement.offsetParent){return}var newRow=Math.round(this._viewportElement.scrollTop/this._currentRowHeight);var diff=newRow-this._terminal.buffer.ydisp;this._terminal.scrollLines(diff,true)};Viewport.prototype.onWheel=function(ev){var amount=this._getPixelsScrolled(ev);if(amount===0){return}this._viewportElement.scrollTop+=amount;ev.preventDefault()};Viewport.prototype._getPixelsScrolled=function(ev){if(ev.deltaY===0){return 0}var amount=ev.deltaY;if(ev.deltaMode===WheelEvent.DOM_DELTA_LINE){amount*=this._currentRowHeight}else if(ev.deltaMode===WheelEvent.DOM_DELTA_PAGE){amount*=this._currentRowHeight*this._terminal.rows}return amount};Viewport.prototype.getLinesScrolled=function(ev){if(ev.deltaY===0){return 0}var amount=ev.deltaY;if(ev.deltaMode===WheelEvent.DOM_DELTA_PIXEL){amount/=this._currentRowHeight+0;this._wheelPartialScroll+=amount;amount=Math.floor(Math.abs(this._wheelPartialScroll))*(this._wheelPartialScroll>0?1:-1);this._wheelPartialScroll%=1}else if(ev.deltaMode===WheelEvent.DOM_DELTA_PAGE){amount*=this._terminal.rows}return amount};Viewport.prototype.onTouchStart=function(ev){this._lastTouchY=ev.touches[0].pageY};Viewport.prototype.onTouchMove=function(ev){var deltaY=this._lastTouchY-ev.touches[0].pageY;this._lastTouchY=ev.touches[0].pageY;if(deltaY===0){return}this._viewportElement.scrollTop+=deltaY;ev.preventDefault()};return Viewport}();exports.Viewport=Viewport},{}],19:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var EscapeSequences_1=require("../EscapeSequences");var Direction;(function(Direction){Direction["Up"]="A";Direction["Down"]="B";Direction["Right"]="C";Direction["Left"]="D"})(Direction||(Direction={}));var AltClickHandler=function(){function AltClickHandler(_mouseEvent,_terminal){this._mouseEvent=_mouseEvent;this._terminal=_terminal;this._lines=this._terminal.buffer.lines;this._startCol=this._terminal.buffer.x;this._startRow=this._terminal.buffer.y;_a=this._terminal.mouseHelper.getCoords(this._mouseEvent,this._terminal.element,this._terminal.charMeasure,this._terminal.options.lineHeight,this._terminal.cols,this._terminal.rows,false).map(function(coordinate){return coordinate-1}),this._endCol=_a[0],this._endRow=_a[1];var _a}AltClickHandler.prototype.move=function(){if(this._mouseEvent.altKey){this._terminal.send(this._arrowSequences())}};AltClickHandler.prototype._arrowSequences=function(){if(!this._terminal.buffer.hasScrollback){return this._resetStartingRow()+this._moveToRequestedRow()+this._moveToRequestedCol()}return this._moveHorizontallyOnly()};AltClickHandler.prototype._resetStartingRow=function(){if(this._moveToRequestedRow().length===0){return""}else{return repeat(this._bufferLine(this._startCol,this._startRow,this._startCol,this._startRow-this._wrappedRowsForRow(this._startRow),false).length,this._sequence(Direction.Left))}};AltClickHandler.prototype._moveToRequestedRow=function(){var startRow=this._startRow-this._wrappedRowsForRow(this._startRow);var endRow=this._endRow-this._wrappedRowsForRow(this._endRow);var rowsToMove=Math.abs(startRow-endRow)-this._wrappedRowsCount();return repeat(rowsToMove,this._sequence(this._verticalDirection()))};AltClickHandler.prototype._moveToRequestedCol=function(){var startRow;if(this._moveToRequestedRow().length>0){startRow=this._endRow-this._wrappedRowsForRow(this._endRow)}else{startRow=this._startRow}var endRow=this._endRow;var direction=this._horizontalDirection();return repeat(this._bufferLine(this._startCol,startRow,this._endCol,endRow,direction===Direction.Right).length,this._sequence(direction))};AltClickHandler.prototype._moveHorizontallyOnly=function(){var direction=this._horizontalDirection();return repeat(Math.abs(this._startCol-this._endCol),this._sequence(direction))};AltClickHandler.prototype._wrappedRowsCount=function(){var wrappedRows=0;var startRow=this._startRow-this._wrappedRowsForRow(this._startRow);var endRow=this._endRow-this._wrappedRowsForRow(this._endRow);for(var i=0;i<Math.abs(startRow-endRow);i++){var direction=this._verticalDirection()===Direction.Up?-1:1;if(this._lines.get(startRow+direction*i).isWrapped){wrappedRows++}}return wrappedRows};AltClickHandler.prototype._wrappedRowsForRow=function(currentRow){var rowCount=0;var lineWraps=this._lines.get(currentRow).isWrapped;while(lineWraps&&currentRow>=0&&currentRow<this._terminal.rows){rowCount++;currentRow--;lineWraps=this._lines.get(currentRow).isWrapped}return rowCount};AltClickHandler.prototype._horizontalDirection=function(){var startRow;if(this._moveToRequestedRow().length>0){startRow=this._endRow-this._wrappedRowsForRow(this._endRow)}else{startRow=this._startRow}if(this._startCol<this._endCol&&startRow<=this._endRow||this._startCol>=this._endCol&&startRow<this._endRow){return Direction.Right}else{return Direction.Left}};AltClickHandler.prototype._verticalDirection=function(){if(this._startRow>this._endRow){return Direction.Up}else{return Direction.Down}};AltClickHandler.prototype._bufferLine=function(startCol,startRow,endCol,endRow,forward){var currentCol=startCol;var currentRow=startRow;var bufferStr="";while(currentCol!==endCol||currentRow!==endRow){currentCol+=forward?1:-1;if(forward&&currentCol>this._terminal.cols-1){bufferStr+=this._terminal.buffer.translateBufferLineToString(currentRow,false,startCol,currentCol);currentCol=0;startCol=0;currentRow++}else if(!forward&&currentCol<0){bufferStr+=this._terminal.buffer.translateBufferLineToString(currentRow,false,0,startCol+1);currentCol=this._terminal.cols-1;startCol=currentCol;currentRow--}}return bufferStr+this._terminal.buffer.translateBufferLineToString(currentRow,false,startCol,currentCol)};AltClickHandler.prototype._sequence=function(direction){var mod=this._terminal.applicationCursor?"O":"[";return EscapeSequences_1.C0.ESC+mod+direction};return AltClickHandler}();exports.AltClickHandler=AltClickHandler;function repeat(count,str){count=Math.floor(count);var rpt="";for(var i=0;i<count;i++){rpt+=str}return rpt}},{"../EscapeSequences":7}],20:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function prepareTextForTerminal(text){return text.replace(/\r?\n/g,"\r")}exports.prepareTextForTerminal=prepareTextForTerminal;function bracketTextForPaste(text,bracketedPasteMode){if(bracketedPasteMode){return"[200~"+text+"[201~"}return text}exports.bracketTextForPaste=bracketTextForPaste;function copyHandler(ev,term,selectionManager){if(term.browser.isMSIE){window.clipboardData.setData("Text",selectionManager.selectionText)}else{ev.clipboardData.setData("text/plain",selectionManager.selectionText)}ev.preventDefault()}exports.copyHandler=copyHandler;function pasteHandler(ev,term){ev.stopPropagation();var text;var dispatchPaste=function(text){text=prepareTextForTerminal(text);text=bracketTextForPaste(text,term.bracketedPasteMode);term.handler(text);term.textarea.value="";term.emit("paste",text);term.cancel(ev)};if(term.browser.isMSIE){if(window.clipboardData){text=window.clipboardData.getData("Text");dispatchPaste(text)}}else{if(ev.clipboardData){text=ev.clipboardData.getData("text/plain");dispatchPaste(text)}}}exports.pasteHandler=pasteHandler;function moveTextAreaUnderMouseCursor(ev,textarea){textarea.style.position="fixed";textarea.style.width="20px";textarea.style.height="20px";textarea.style.left=ev.clientX-10+"px";textarea.style.top=ev.clientY-10+"px";textarea.style.zIndex="1000";textarea.focus();setTimeout(function(){textarea.style.position=null;textarea.style.width=null;textarea.style.height=null;textarea.style.left=null;textarea.style.top=null;textarea.style.zIndex=null},200)}exports.moveTextAreaUnderMouseCursor=moveTextAreaUnderMouseCursor;function rightClickHandler(ev,textarea,selectionManager,shouldSelectWord){moveTextAreaUnderMouseCursor(ev,textarea);if(shouldSelectWord&&!selectionManager.isClickInSelection(ev)){selectionManager.selectWordAtCursor(ev)}textarea.value=selectionManager.selectionText;textarea.select()}exports.rightClickHandler=rightClickHandler},{}],21:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var HOVER_DURATION=500;var MouseZoneManager=function(){function MouseZoneManager(_terminal){var _this=this;this._terminal=_terminal;this._zones=[];this._areZonesActive=false;this._tooltipTimeout=null;this._currentZone=null;this._lastHoverCoords=[null,null];this._terminal.element.addEventListener("mousedown",function(e){return _this._onMouseDown(e)});this._mouseMoveListener=function(e){return _this._onMouseMove(e)};this._clickListener=function(e){return _this._onClick(e)}}MouseZoneManager.prototype.add=function(zone){this._zones.push(zone);if(this._zones.length===1){this._activate()}};MouseZoneManager.prototype.clearAll=function(start,end){if(this._zones.length===0){return}if(!end){start=0;end=this._terminal.rows-1}for(var i=0;i<this._zones.length;i++){var zone=this._zones[i];if(zone.y1>start&&zone.y1<=end+1||zone.y2>start&&zone.y2<=end+1||zone.y1<start&&zone.y2>end+1){if(this._currentZone&&this._currentZone===zone){this._currentZone.leaveCallback();this._currentZone=null}this._zones.splice(i--,1)}}if(this._zones.length===0){this._deactivate()}};MouseZoneManager.prototype._activate=function(){if(!this._areZonesActive){this._areZonesActive=true;this._terminal.element.addEventListener("mousemove",this._mouseMoveListener);this._terminal.element.addEventListener("click",this._clickListener)}};MouseZoneManager.prototype._deactivate=function(){if(this._areZonesActive){this._areZonesActive=false;this._terminal.element.removeEventListener("mousemove",this._mouseMoveListener);this._terminal.element.removeEventListener("click",this._clickListener)}};MouseZoneManager.prototype._onMouseMove=function(e){if(this._lastHoverCoords[0]!==e.pageX||this._lastHoverCoords[1]!==e.pageY){this._onHover(e);this._lastHoverCoords=[e.pageX,e.pageY]}};MouseZoneManager.prototype._onHover=function(e){var _this=this;var zone=this._findZoneEventAt(e);if(zone===this._currentZone){return}if(this._currentZone){this._currentZone.leaveCallback();this._currentZone=null;if(this._tooltipTimeout){clearTimeout(this._tooltipTimeout)}}if(!zone){return}this._currentZone=zone;if(zone.hoverCallback){zone.hoverCallback(e)}this._tooltipTimeout=setTimeout(function(){return _this._onTooltip(e)},HOVER_DURATION)};MouseZoneManager.prototype._onTooltip=function(e){this._tooltipTimeout=null;var zone=this._findZoneEventAt(e);if(zone&&zone.tooltipCallback){zone.tooltipCallback(e)}};MouseZoneManager.prototype._onMouseDown=function(e){if(!this._areZonesActive){return}var zone=this._findZoneEventAt(e);if(zone){if(zone.willLinkActivate(e)){e.preventDefault();e.stopImmediatePropagation()}}};MouseZoneManager.prototype._onClick=function(e){var zone=this._findZoneEventAt(e);if(zone){zone.clickCallback(e);e.preventDefault();e.stopImmediatePropagation()}};MouseZoneManager.prototype._findZoneEventAt=function(e){var coords=this._terminal.mouseHelper.getCoords(e,this._terminal.screenElement,this._terminal.charMeasure,this._terminal.options.lineHeight,this._terminal.cols,this._terminal.rows);if(!coords){return null}var x=coords[0];var y=coords[1];for(var i=0;i<this._zones.length;i++){var zone=this._zones[i];if(zone.y1===zone.y2){if(y===zone.y1&&x>=zone.x1&&x<zone.x2){return zone}}else{if(y===zone.y1&&x>=zone.x1||y===zone.y2&&x<zone.x2||y>zone.y1&&y<zone.y2){return zone}}}return null};return MouseZoneManager}();exports.MouseZoneManager=MouseZoneManager;var MouseZone=function(){function MouseZone(x1,y1,x2,y2,clickCallback,hoverCallback,tooltipCallback,leaveCallback,willLinkActivate){this.x1=x1;this.y1=y1;this.x2=x2;this.y2=y2;this.clickCallback=clickCallback;this.hoverCallback=hoverCallback;this.tooltipCallback=tooltipCallback;this.leaveCallback=leaveCallback;this.willLinkActivate=willLinkActivate}return MouseZone}();exports.MouseZone=MouseZone},{}],22:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var Types_1=require("./atlas/Types");var Types_2=require("../shared/atlas/Types");var CharAtlas_1=require("./atlas/CharAtlas");var Buffer_1=require("../Buffer");var BaseRenderLayer=function(){function BaseRenderLayer(_container,id,zIndex,_alpha,_colors){this._container=_container;this._alpha=_alpha;this._colors=_colors;this._scaledCharWidth=0;this._scaledCharHeight=0;this._scaledCellWidth=0;this._scaledCellHeight=0;this._scaledCharLeft=0;this._scaledCharTop=0;this._canvas=document.createElement("canvas");this._canvas.classList.add("xterm-"+id+"-layer");this._canvas.style.zIndex=zIndex.toString();this._initCanvas();this._container.appendChild(this._canvas)}BaseRenderLayer.prototype._initCanvas=function(){this._ctx=this._canvas.getContext("2d",{alpha:this._alpha});if(!this._alpha){this.clearAll()}};BaseRenderLayer.prototype.onOptionsChanged=function(terminal){};BaseRenderLayer.prototype.onBlur=function(terminal){};BaseRenderLayer.prototype.onFocus=function(terminal){};BaseRenderLayer.prototype.onCursorMove=function(terminal){};BaseRenderLayer.prototype.onGridChanged=function(terminal,startRow,endRow){};BaseRenderLayer.prototype.onSelectionChanged=function(terminal,start,end){};BaseRenderLayer.prototype.onThemeChanged=function(terminal,colorSet){this._refreshCharAtlas(terminal,colorSet)};BaseRenderLayer.prototype.setTransparency=function(terminal,alpha){if(alpha===this._alpha){return}var oldCanvas=this._canvas;this._alpha=alpha;this._canvas=this._canvas.cloneNode();this._initCanvas();this._container.replaceChild(this._canvas,oldCanvas);this._refreshCharAtlas(terminal,this._colors);this.onGridChanged(terminal,0,terminal.rows-1)};BaseRenderLayer.prototype._refreshCharAtlas=function(terminal,colorSet){var _this=this;if(this._scaledCharWidth<=0&&this._scaledCharHeight<=0){return}this._charAtlas=null;var result=CharAtlas_1.acquireCharAtlas(terminal,colorSet,this._scaledCharWidth,this._scaledCharHeight);if(result instanceof HTMLCanvasElement){this._charAtlas=result}else{result.then(function(bitmap){return _this._charAtlas=bitmap})}};BaseRenderLayer.prototype.resize=function(terminal,dim){this._scaledCellWidth=dim.scaledCellWidth;this._scaledCellHeight=dim.scaledCellHeight;this._scaledCharWidth=dim.scaledCharWidth;this._scaledCharHeight=dim.scaledCharHeight;this._scaledCharLeft=dim.scaledCharLeft;this._scaledCharTop=dim.scaledCharTop;this._canvas.width=dim.scaledCanvasWidth;this._canvas.height=dim.scaledCanvasHeight;this._canvas.style.width=dim.canvasWidth+"px";this._canvas.style.height=dim.canvasHeight+"px";if(!this._alpha){this.clearAll()}this._refreshCharAtlas(terminal,this._colors)};BaseRenderLayer.prototype.fillCells=function(x,y,width,height){this._ctx.fillRect(x*this._scaledCellWidth,y*this._scaledCellHeight,width*this._scaledCellWidth,height*this._scaledCellHeight)};BaseRenderLayer.prototype.fillBottomLineAtCells=function(x,y,width){if(width===void 0){width=1}this._ctx.fillRect(x*this._scaledCellWidth,(y+1)*this._scaledCellHeight-window.devicePixelRatio-1,width*this._scaledCellWidth,window.devicePixelRatio)};BaseRenderLayer.prototype.fillLeftLineAtCell=function(x,y){this._ctx.fillRect(x*this._scaledCellWidth,y*this._scaledCellHeight,window.devicePixelRatio,this._scaledCellHeight)};BaseRenderLayer.prototype.strokeRectAtCell=function(x,y,width,height){this._ctx.lineWidth=window.devicePixelRatio;this._ctx.strokeRect(x*this._scaledCellWidth+window.devicePixelRatio/2,y*this._scaledCellHeight+window.devicePixelRatio/2,width*this._scaledCellWidth-window.devicePixelRatio,height*this._scaledCellHeight-window.devicePixelRatio)};BaseRenderLayer.prototype.clearAll=function(){if(this._alpha){this._ctx.clearRect(0,0,this._canvas.width,this._canvas.height)}else{this._ctx.fillStyle=this._colors.background.css;this._ctx.fillRect(0,0,this._canvas.width,this._canvas.height)}};BaseRenderLayer.prototype.clearCells=function(x,y,width,height){if(this._alpha){this._ctx.clearRect(x*this._scaledCellWidth,y*this._scaledCellHeight,width*this._scaledCellWidth,height*this._scaledCellHeight)}else{this._ctx.fillStyle=this._colors.background.css;this._ctx.fillRect(x*this._scaledCellWidth,y*this._scaledCellHeight,width*this._scaledCellWidth,height*this._scaledCellHeight)}};BaseRenderLayer.prototype.fillCharTrueColor=function(terminal,charData,x,y){this._ctx.font=this._getFont(terminal,false);this._ctx.textBaseline="top";this._clipRow(terminal,y);this._ctx.fillText(charData[Buffer_1.CHAR_DATA_CHAR_INDEX],x*this._scaledCellWidth+this._scaledCharLeft,y*this._scaledCellHeight+this._scaledCharTop)};BaseRenderLayer.prototype.drawChar=function(terminal,char,code,width,x,y,fg,bg,bold,dim){var colorIndex=0;if(fg<256){colorIndex=fg+2}else{if(bold&&terminal.options.enableBold){colorIndex=1}}var isAscii=code<256;var isBasicColor=colorIndex>1&&fg<16&&(fg<8||bold);var isDefaultColor=fg>=256;var isDefaultBackground=bg>=256;if(this._charAtlas&&isAscii&&(isBasicColor||isDefaultColor)&&isDefaultBackground){var charAtlasCellWidth=this._scaledCharWidth+Types_2.CHAR_ATLAS_CELL_SPACING;var charAtlasCellHeight=this._scaledCharHeight+Types_2.CHAR_ATLAS_CELL_SPACING;if(dim){this._ctx.globalAlpha=Types_1.DIM_OPACITY}if(bold&&!terminal.options.enableBold){if(colorIndex>1){colorIndex-=8}}this._ctx.drawImage(this._charAtlas,code*charAtlasCellWidth,colorIndex*charAtlasCellHeight,charAtlasCellWidth,this._scaledCharHeight,x*this._scaledCellWidth+this._scaledCharLeft,y*this._scaledCellHeight+this._scaledCharTop,charAtlasCellWidth,this._scaledCharHeight)}else{this._drawUncachedChar(terminal,char,width,fg,x,y,bold&&terminal.options.enableBold,dim)}};BaseRenderLayer.prototype._drawUncachedChar=function(terminal,char,width,fg,x,y,bold,dim){this._ctx.save();this._ctx.font=this._getFont(terminal,bold);this._ctx.textBaseline="top";if(fg===Types_1.INVERTED_DEFAULT_COLOR){this._ctx.fillStyle=this._colors.background.css}else if(fg<256){this._ctx.fillStyle=this._colors.ansi[fg].css}else{this._ctx.fillStyle=this._colors.foreground.css}this._clipRow(terminal,y);if(dim){this._ctx.globalAlpha=Types_1.DIM_OPACITY}this._ctx.fillText(char,x*this._scaledCellWidth+this._scaledCharLeft,y*this._scaledCellHeight+this._scaledCharTop);this._ctx.restore()};BaseRenderLayer.prototype._clipRow=function(terminal,y){this._ctx.beginPath();this._ctx.rect(0,y*this._scaledCellHeight,terminal.cols*this._scaledCellWidth,this._scaledCellHeight);this._ctx.clip()};BaseRenderLayer.prototype._getFont=function(terminal,isBold){var fontWeight=isBold?terminal.options.fontWeightBold:terminal.options.fontWeight;return fontWeight+" "+terminal.options.fontSize*window.devicePixelRatio+"px "+terminal.options.fontFamily};return BaseRenderLayer}();exports.BaseRenderLayer=BaseRenderLayer},{"../Buffer":2,"../shared/atlas/Types":35,"./atlas/CharAtlas":31,"./atlas/Types":33}],23:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var DEFAULT_FOREGROUND=fromHex("#ffffff");var DEFAULT_BACKGROUND=fromHex("#000000");var DEFAULT_CURSOR=fromHex("#ffffff");var DEFAULT_CURSOR_ACCENT=fromHex("#000000");var DEFAULT_SELECTION={css:"rgba(255, 255, 255, 0.3)",rgba:4294967159};exports.DEFAULT_ANSI_COLORS=function(){var colors=[fromHex("#2e3436"),fromHex("#cc0000"),fromHex("#4e9a06"),fromHex("#c4a000"),fromHex("#3465a4"),fromHex("#75507b"),fromHex("#06989a"),fromHex("#d3d7cf"),fromHex("#555753"),fromHex("#ef2929"),fromHex("#8ae234"),fromHex("#fce94f"),fromHex("#729fcf"),fromHex("#ad7fa8"),fromHex("#34e2e2"),fromHex("#eeeeec")];var v=[0,95,135,175,215,255];for(var i=0;i<216;i++){var r=v[i/36%6|0];var g=v[i/6%6|0];var b=v[i%6];colors.push({css:"#"+toPaddedHex(r)+toPaddedHex(g)+toPaddedHex(b),rgba:(r<<24|g<<16|b<<8|255)>>>0})}for(var i=0;i<24;i++){var c=8+i*10;var ch=toPaddedHex(c);colors.push({css:"#"+ch+ch+ch,rgba:(c<<24|c<<16|c<<8|255)>>>0})}return colors}();function fromHex(css){return{css:css,rgba:parseInt(css.slice(1),16)<<8|255}}function toPaddedHex(c){var s=c.toString(16);return s.length<2?"0"+s:s}var ColorManager=function(){function ColorManager(document,allowTransparency){this.allowTransparency=allowTransparency;var canvas=document.createElement("canvas");canvas.width=1;canvas.height=1;this._ctx=canvas.getContext("2d");this._ctx.globalCompositeOperation="copy";this._litmusColor=this._ctx.createLinearGradient(0,0,1,1);this.colors={foreground:DEFAULT_FOREGROUND,background:DEFAULT_BACKGROUND,cursor:DEFAULT_CURSOR,cursorAccent:DEFAULT_CURSOR_ACCENT,selection:DEFAULT_SELECTION,ansi:exports.DEFAULT_ANSI_COLORS.slice()}}ColorManager.prototype.setTheme=function(theme){this.colors.foreground=this._parseColor(theme.foreground,DEFAULT_FOREGROUND);this.colors.background=this._parseColor(theme.background,DEFAULT_BACKGROUND);this.colors.cursor=this._parseColor(theme.cursor,DEFAULT_CURSOR,true);this.colors.cursorAccent=this._parseColor(theme.cursorAccent,DEFAULT_CURSOR_ACCENT,true);this.colors.selection=this._parseColor(theme.selection,DEFAULT_SELECTION,true);this.colors.ansi[0]=this._parseColor(theme.black,exports.DEFAULT_ANSI_COLORS[0]);this.colors.ansi[1]=this._parseColor(theme.red,exports.DEFAULT_ANSI_COLORS[1]);this.colors.ansi[2]=this._parseColor(theme.green,exports.DEFAULT_ANSI_COLORS[2]);this.colors.ansi[3]=this._parseColor(theme.yellow,exports.DEFAULT_ANSI_COLORS[3]);this.colors.ansi[4]=this._parseColor(theme.blue,exports.DEFAULT_ANSI_COLORS[4]);this.colors.ansi[5]=this._parseColor(theme.magenta,exports.DEFAULT_ANSI_COLORS[5]);this.colors.ansi[6]=this._parseColor(theme.cyan,exports.DEFAULT_ANSI_COLORS[6]);this.colors.ansi[7]=this._parseColor(theme.white,exports.DEFAULT_ANSI_COLORS[7]);this.colors.ansi[8]=this._parseColor(theme.brightBlack,exports.DEFAULT_ANSI_COLORS[8]);this.colors.ansi[9]=this._parseColor(theme.brightRed,exports.DEFAULT_ANSI_COLORS[9]);this.colors.ansi[10]=this._parseColor(theme.brightGreen,exports.DEFAULT_ANSI_COLORS[10]);this.colors.ansi[11]=this._parseColor(theme.brightYellow,exports.DEFAULT_ANSI_COLORS[11]);this.colors.ansi[12]=this._parseColor(theme.brightBlue,exports.DEFAULT_ANSI_COLORS[12]);this.colors.ansi[13]=this._parseColor(theme.brightMagenta,exports.DEFAULT_ANSI_COLORS[13]);this.colors.ansi[14]=this._parseColor(theme.brightCyan,exports.DEFAULT_ANSI_COLORS[14]);this.colors.ansi[15]=this._parseColor(theme.brightWhite,exports.DEFAULT_ANSI_COLORS[15])};ColorManager.prototype._parseColor=function(css,fallback,allowTransparency){if(allowTransparency===void 0){allowTransparency=this.allowTransparency}if(!css){return fallback}this._ctx.fillStyle=this._litmusColor;this._ctx.fillStyle=css;if(typeof this._ctx.fillStyle!=="string"){console.warn("Color: "+css+" is invalid using fallback "+fallback.css);return fallback}this._ctx.fillRect(0,0,1,1);var data=this._ctx.getImageData(0,0,1,1).data;if(!allowTransparency&&data[3]!==255){console.warn("Color: "+css+" is using transparency, but allowTransparency is false. "+("Using fallback "+fallback.css+"."));return fallback}return{css:css,rgba:(data[0]<<24|data[1]<<16|data[2]<<8|data[3])>>>0}};return ColorManager}();exports.ColorManager=ColorManager},{}],24:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:true});var Buffer_1=require("../Buffer");var BaseRenderLayer_1=require("./BaseRenderLayer");var BLINK_INTERVAL=600;var CursorRenderLayer=function(_super){__extends(CursorRenderLayer,_super);function CursorRenderLayer(container,zIndex,colors){var _this=_super.call(this,container,"cursor",zIndex,true,colors)||this;_this._state={x:null,y:null,isFocused:null,style:null,width:null};_this._cursorRenderers={bar:_this._renderBarCursor.bind(_this),block:_this._renderBlockCursor.bind(_this),underline:_this._renderUnderlineCursor.bind(_this)};return _this}CursorRenderLayer.prototype.resize=function(terminal,dim){_super.prototype.resize.call(this,terminal,dim);this._state={x:null,y:null,isFocused:null,style:null,width:null}};CursorRenderLayer.prototype.reset=function(terminal){this._clearCursor();if(this._cursorBlinkStateManager){this._cursorBlinkStateManager.dispose();this._cursorBlinkStateManager=null;this.onOptionsChanged(terminal)}};CursorRenderLayer.prototype.onBlur=function(terminal){if(this._cursorBlinkStateManager){this._cursorBlinkStateManager.pause()}terminal.refresh(terminal.buffer.y,terminal.buffer.y)};CursorRenderLayer.prototype.onFocus=function(terminal){if(this._cursorBlinkStateManager){this._cursorBlinkStateManager.resume(terminal)}else{terminal.refresh(terminal.buffer.y,terminal.buffer.y)}};CursorRenderLayer.prototype.onOptionsChanged=function(terminal){var _this=this;if(terminal.options.cursorBlink){if(!this._cursorBlinkStateManager){this._cursorBlinkStateManager=new CursorBlinkStateManager(terminal,function(){_this._render(terminal,true)})}}else{if(this._cursorBlinkStateManager){this._cursorBlinkStateManager.dispose();this._cursorBlinkStateManager=null}terminal.refresh(terminal.buffer.y,terminal.buffer.y)}};CursorRenderLayer.prototype.onCursorMove=function(terminal){if(this._cursorBlinkStateManager){this._cursorBlinkStateManager.restartBlinkAnimation(terminal)}};CursorRenderLayer.prototype.onGridChanged=function(terminal,startRow,endRow){if(!this._cursorBlinkStateManager||this._cursorBlinkStateManager.isPaused){this._render(terminal,false)}else{this._cursorBlinkStateManager.restartBlinkAnimation(terminal)}};CursorRenderLayer.prototype._render=function(terminal,triggeredByAnimationFrame){if(!terminal.cursorState||terminal.cursorHidden){this._clearCursor();return}var cursorY=terminal.buffer.ybase+terminal.buffer.y;var viewportRelativeCursorY=cursorY-terminal.buffer.ydisp;if(viewportRelativeCursorY<0||viewportRelativeCursorY>=terminal.rows){this._clearCursor();return}var charData=terminal.buffer.lines.get(cursorY)[terminal.buffer.x];if(!charData){return}if(!terminal.isFocused){this._clearCursor();this._ctx.save();this._ctx.fillStyle=this._colors.cursor.css;this._renderBlurCursor(terminal,terminal.buffer.x,viewportRelativeCursorY,charData);this._ctx.restore();this._state.x=terminal.buffer.x;this._state.y=viewportRelativeCursorY;this._state.isFocused=false;this._state.style=terminal.options.cursorStyle;this._state.width=charData[Buffer_1.CHAR_DATA_WIDTH_INDEX];return}if(this._cursorBlinkStateManager&&!this._cursorBlinkStateManager.isCursorVisible){this._clearCursor();return}if(this._state){if(this._state.x===terminal.buffer.x&&this._state.y===viewportRelativeCursorY&&this._state.isFocused===terminal.isFocused&&this._state.style===terminal.options.cursorStyle&&this._state.width===charData[Buffer_1.CHAR_DATA_WIDTH_INDEX]){return}this._clearCursor()}this._ctx.save();this._cursorRenderers[terminal.options.cursorStyle||"block"](terminal,terminal.buffer.x,viewportRelativeCursorY,charData);this._ctx.restore();this._state.x=terminal.buffer.x;this._state.y=viewportRelativeCursorY;this._state.isFocused=false;this._state.style=terminal.options.cursorStyle;this._state.width=charData[Buffer_1.CHAR_DATA_WIDTH_INDEX]};CursorRenderLayer.prototype._clearCursor=function(){if(this._state){this.clearCells(this._state.x,this._state.y,this._state.width,1);this._state={x:null,y:null,isFocused:null,style:null,width:null}}};CursorRenderLayer.prototype._renderBarCursor=function(terminal,x,y,charData){this._ctx.save();this._ctx.fillStyle=this._colors.cursor.css;this.fillLeftLineAtCell(x,y);this._ctx.restore()};CursorRenderLayer.prototype._renderBlockCursor=function(terminal,x,y,charData){this._ctx.save();this._ctx.fillStyle=this._colors.cursor.css;this.fillCells(x,y,charData[Buffer_1.CHAR_DATA_WIDTH_INDEX],1);this._ctx.fillStyle=this._colors.cursorAccent.css;this.fillCharTrueColor(terminal,charData,x,y);this._ctx.restore()};CursorRenderLayer.prototype._renderUnderlineCursor=function(terminal,x,y,charData){this._ctx.save();this._ctx.fillStyle=this._colors.cursor.css;this.fillBottomLineAtCells(x,y);this._ctx.restore()};CursorRenderLayer.prototype._renderBlurCursor=function(terminal,x,y,charData){this._ctx.save();this._ctx.strokeStyle=this._colors.cursor.css;this.strokeRectAtCell(x,y,charData[Buffer_1.CHAR_DATA_WIDTH_INDEX],1);this._ctx.restore()};return CursorRenderLayer}(BaseRenderLayer_1.BaseRenderLayer);exports.CursorRenderLayer=CursorRenderLayer;var CursorBlinkStateManager=function(){function CursorBlinkStateManager(terminal,_renderCallback){this._renderCallback=_renderCallback;this.isCursorVisible=true;if(terminal.isFocused){this._restartInterval()}}Object.defineProperty(CursorBlinkStateManager.prototype,"isPaused",{get:function(){return!(this._blinkStartTimeout||this._blinkInterval)},enumerable:true,configurable:true});CursorBlinkStateManager.prototype.dispose=function(){if(this._blinkInterval){window.clearInterval(this._blinkInterval);this._blinkInterval=null}if(this._blinkStartTimeout){window.clearTimeout(this._blinkStartTimeout);this._blinkStartTimeout=null}if(this._animationFrame){window.cancelAnimationFrame(this._animationFrame);this._animationFrame=null}};CursorBlinkStateManager.prototype.restartBlinkAnimation=function(terminal){var _this=this;if(this.isPaused){return}this._animationTimeRestarted=Date.now();this.isCursorVisible=true;if(!this._animationFrame){this._animationFrame=window.requestAnimationFrame(function(){_this._renderCallback();_this._animationFrame=null})}};CursorBlinkStateManager.prototype._restartInterval=function(timeToStart){var _this=this;if(timeToStart===void 0){timeToStart=BLINK_INTERVAL}if(this._blinkInterval){window.clearInterval(this._blinkInterval)}this._blinkStartTimeout=setTimeout(function(){if(_this._animationTimeRestarted){var time=BLINK_INTERVAL-(Date.now()-_this._animationTimeRestarted);_this._animationTimeRestarted=null;if(time>0){_this._restartInterval(time);return}}_this.isCursorVisible=false;_this._animationFrame=window.requestAnimationFrame(function(){_this._renderCallback();_this._animationFrame=null});_this._blinkInterval=setInterval(function(){if(_this._animationTimeRestarted){var time=BLINK_INTERVAL-(Date.now()-_this._animationTimeRestarted);_this._animationTimeRestarted=null;_this._restartInterval(time);return}_this.isCursorVisible=!_this.isCursorVisible;_this._animationFrame=window.requestAnimationFrame(function(){_this._renderCallback();_this._animationFrame=null})},BLINK_INTERVAL)},timeToStart)};CursorBlinkStateManager.prototype.pause=function(){this.isCursorVisible=true;if(this._blinkInterval){window.clearInterval(this._blinkInterval);this._blinkInterval=null}if(this._blinkStartTimeout){window.clearTimeout(this._blinkStartTimeout);this._blinkStartTimeout=null}if(this._animationFrame){window.cancelAnimationFrame(this._animationFrame);this._animationFrame=null}};CursorBlinkStateManager.prototype.resume=function(terminal){this._animationTimeRestarted=null;this._restartInterval();this.restartBlinkAnimation(terminal)};return CursorBlinkStateManager}()},{"../Buffer":2,"./BaseRenderLayer":22}],25:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var GridCache=function(){function GridCache(){this.cache=[]}GridCache.prototype.resize=function(width,height){for(var x=0;x<width;x++){if(this.cache.length<=x){this.cache.push([])}for(var y=this.cache[x].length;y<height;y++){this.cache[x].push(null)}this.cache[x].length=height}this.cache.length=width};GridCache.prototype.clear=function(){for(var x=0;x<this.cache.length;x++){for(var y=0;y<this.cache[x].length;y++){this.cache[x][y]=null}}};return GridCache}();exports.GridCache=GridCache},{}],26:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:true});var Types_1=require("../Types");var BaseRenderLayer_1=require("./BaseRenderLayer");var LinkRenderLayer=function(_super){__extends(LinkRenderLayer,_super);function LinkRenderLayer(container,zIndex,colors,terminal){var _this=_super.call(this,container,"link",zIndex,true,colors)||this;_this._state=null;terminal.linkifier.on(Types_1.LinkHoverEventTypes.HOVER,function(e){return _this._onLinkHover(e)});terminal.linkifier.on(Types_1.LinkHoverEventTypes.LEAVE,function(e){return _this._onLinkLeave(e)});return _this}LinkRenderLayer.prototype.resize=function(terminal,dim){_super.prototype.resize.call(this,terminal,dim);this._state=null};LinkRenderLayer.prototype.reset=function(terminal){this._clearCurrentLink()};LinkRenderLayer.prototype._clearCurrentLink=function(){if(this._state){this.clearCells(this._state.x1,this._state.y1,this._state.cols-this._state.x1,1);var middleRowCount=this._state.y2-this._state.y1-1;if(middleRowCount>0){this.clearCells(0,this._state.y1+1,this._state.cols,middleRowCount)}this.clearCells(0,this._state.y2,this._state.x2,1);this._state=null}};LinkRenderLayer.prototype._onLinkHover=function(e){this._ctx.fillStyle=this._colors.foreground.css;if(e.y1===e.y2){this.fillBottomLineAtCells(e.x1,e.y1,e.x2-e.x1)}else{this.fillBottomLineAtCells(e.x1,e.y1,e.cols-e.x1);for(var y=e.y1+1;y<e.y2;y++){this.fillBottomLineAtCells(0,y,e.cols)}this.fillBottomLineAtCells(0,e.y2,e.x2)}this._state=e};LinkRenderLayer.prototype._onLinkLeave=function(e){this._clearCurrentLink()};return LinkRenderLayer}(BaseRenderLayer_1.BaseRenderLayer);exports.LinkRenderLayer=LinkRenderLayer},{"../Types":17,"./BaseRenderLayer":22}],27:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:true});var TextRenderLayer_1=require("./TextRenderLayer");var SelectionRenderLayer_1=require("./SelectionRenderLayer");var CursorRenderLayer_1=require("./CursorRenderLayer");var ColorManager_1=require("./ColorManager");var LinkRenderLayer_1=require("./LinkRenderLayer");var EventEmitter_1=require("../EventEmitter");var RenderDebouncer_1=require("../utils/RenderDebouncer");var ScreenDprMonitor_1=require("../utils/ScreenDprMonitor");var Renderer=function(_super){__extends(Renderer,_super);function Renderer(_terminal,theme){var _this=_super.call(this)||this;_this._terminal=_terminal;_this._isPaused=false;_this._needsFullRefresh=false;var allowTransparency=_this._terminal.options.allowTransparency;_this.colorManager=new ColorManager_1.ColorManager(document,allowTransparency);if(theme){_this.colorManager.setTheme(theme)}_this._renderLayers=[new TextRenderLayer_1.TextRenderLayer(_this._terminal.screenElement,0,_this.colorManager.colors,allowTransparency),new SelectionRenderLayer_1.SelectionRenderLayer(_this._terminal.screenElement,1,_this.colorManager.colors),new LinkRenderLayer_1.LinkRenderLayer(_this._terminal.screenElement,2,_this.colorManager.colors,_this._terminal),new CursorRenderLayer_1.CursorRenderLayer(_this._terminal.screenElement,3,_this.colorManager.colors)];_this.dimensions={scaledCharWidth:null,scaledCharHeight:null,scaledCellWidth:null,scaledCellHeight:null,scaledCharLeft:null,scaledCharTop:null,scaledCanvasWidth:null,scaledCanvasHeight:null,canvasWidth:null,canvasHeight:null,actualCellWidth:null,actualCellHeight:null};_this._devicePixelRatio=window.devicePixelRatio;_this._updateDimensions();_this.onOptionsChanged();_this._renderDebouncer=new RenderDebouncer_1.RenderDebouncer(_this._terminal,_this._renderRows.bind(_this));_this._screenDprMonitor=new ScreenDprMonitor_1.ScreenDprMonitor;_this._screenDprMonitor.setListener(function(){return _this.onWindowResize(window.devicePixelRatio)});if("IntersectionObserver"in window){var observer=new IntersectionObserver(function(e){return _this.onIntersectionChange(e[0])},{threshold:0});observer.observe(_this._terminal.element)}return _this}Renderer.prototype.onIntersectionChange=function(entry){this._isPaused=entry.intersectionRatio===0;if(!this._isPaused&&this._needsFullRefresh){this._terminal.refresh(0,this._terminal.rows-1)}};Renderer.prototype.onWindowResize=function(devicePixelRatio){if(this._devicePixelRatio!==devicePixelRatio){this._devicePixelRatio=devicePixelRatio;this.onResize(this._terminal.cols,this._terminal.rows)}};Renderer.prototype.setTheme=function(theme){var _this=this;this.colorManager.setTheme(theme);this._renderLayers.forEach(function(l){l.onThemeChanged(_this._terminal,_this.colorManager.colors);l.reset(_this._terminal)});if(this._isPaused){this._needsFullRefresh=true}else{this._terminal.refresh(0,this._terminal.rows-1)}return this.colorManager.colors};Renderer.prototype.onResize=function(cols,rows){var _this=this;this._updateDimensions();this._renderLayers.forEach(function(l){return l.resize(_this._terminal,_this.dimensions)});if(this._isPaused){this._needsFullRefresh=true}else{this._terminal.refresh(0,this._terminal.rows-1)}this._terminal.screenElement.style.width=this.dimensions.canvasWidth+"px";this._terminal.screenElement.style.height=this.dimensions.canvasHeight+"px";this.emit("resize",{width:this.dimensions.canvasWidth,height:this.dimensions.canvasHeight})};Renderer.prototype.onCharSizeChanged=function(){this.onResize(this._terminal.cols,this._terminal.rows)};Renderer.prototype.onBlur=function(){var _this=this;this._runOperation(function(l){return l.onBlur(_this._terminal)})};Renderer.prototype.onFocus=function(){var _this=this;this._runOperation(function(l){return l.onFocus(_this._terminal)})};Renderer.prototype.onSelectionChanged=function(start,end){var _this=this;this._runOperation(function(l){return l.onSelectionChanged(_this._terminal,start,end)})};Renderer.prototype.onCursorMove=function(){var _this=this;this._runOperation(function(l){return l.onCursorMove(_this._terminal)})};Renderer.prototype.onOptionsChanged=function(){var _this=this;this._runOperation(function(l){return l.onOptionsChanged(_this._terminal)})};Renderer.prototype.clear=function(){var _this=this;this._runOperation(function(l){return l.reset(_this._terminal)})};Renderer.prototype._runOperation=function(operation){if(this._isPaused){this._needsFullRefresh=true}else{this._renderLayers.forEach(function(l){return operation(l)})}};Renderer.prototype.refreshRows=function(start,end){if(this._isPaused){this._needsFullRefresh=true;return}this._renderDebouncer.refresh(start,end)};Renderer.prototype._renderRows=function(start,end){var _this=this;this._renderLayers.forEach(function(l){return l.onGridChanged(_this._terminal,start,end)});this._terminal.emit("refresh",{start:start,end:end})};Renderer.prototype._updateDimensions=function(){if(!this._terminal.charMeasure.width||!this._terminal.charMeasure.height){return}this.dimensions.scaledCharWidth=Math.floor(this._terminal.charMeasure.width*window.devicePixelRatio);this.dimensions.scaledCharHeight=Math.ceil(this._terminal.charMeasure.height*window.devicePixelRatio);this.dimensions.scaledCellHeight=Math.floor(this.dimensions.scaledCharHeight*this._terminal.options.lineHeight);this.dimensions.scaledCharTop=this._terminal.options.lineHeight===1?0:Math.round((this.dimensions.scaledCellHeight-this.dimensions.scaledCharHeight)/2);this.dimensions.scaledCellWidth=this.dimensions.scaledCharWidth+Math.round(this._terminal.options.letterSpacing);this.dimensions.scaledCharLeft=Math.floor(this._terminal.options.letterSpacing/2);this.dimensions.scaledCanvasHeight=this._terminal.rows*this.dimensions.scaledCellHeight;this.dimensions.scaledCanvasWidth=this._terminal.cols*this.dimensions.scaledCellWidth;this.dimensions.canvasHeight=Math.round(this.dimensions.scaledCanvasHeight/window.devicePixelRatio);this.dimensions.canvasWidth=Math.round(this.dimensions.scaledCanvasWidth/window.devicePixelRatio);this.dimensions.actualCellHeight=this.dimensions.canvasHeight/this._terminal.rows;this.dimensions.actualCellWidth=this.dimensions.canvasWidth/this._terminal.cols};return Renderer}(EventEmitter_1.EventEmitter);exports.Renderer=Renderer},{"../EventEmitter":8,"../utils/RenderDebouncer":42,"../utils/ScreenDprMonitor":43,"./ColorManager":23,"./CursorRenderLayer":24,"./LinkRenderLayer":26,"./SelectionRenderLayer":28,"./TextRenderLayer":29}],28:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:true});var BaseRenderLayer_1=require("./BaseRenderLayer");var SelectionRenderLayer=function(_super){__extends(SelectionRenderLayer,_super);function SelectionRenderLayer(container,zIndex,colors){var _this=_super.call(this,container,"selection",zIndex,true,colors)||this;_this._state={start:null,end:null};return _this}SelectionRenderLayer.prototype.resize=function(terminal,dim){_super.prototype.resize.call(this,terminal,dim);this._state={start:null,end:null}};SelectionRenderLayer.prototype.reset=function(terminal){if(this._state.start&&this._state.end){this._state={start:null,end:null};this.clearAll()}};SelectionRenderLayer.prototype.onSelectionChanged=function(terminal,start,end){if(this._state.start===start||this._state.end===end){return}this.clearAll();if(!start||!end){return}var viewportStartRow=start[1]-terminal.buffer.ydisp;var viewportEndRow=end[1]-terminal.buffer.ydisp;var viewportCappedStartRow=Math.max(viewportStartRow,0);var viewportCappedEndRow=Math.min(viewportEndRow,terminal.rows-1);if(viewportCappedStartRow>=terminal.rows||viewportCappedEndRow<0){return}var startCol=viewportStartRow===viewportCappedStartRow?start[0]:0;var startRowEndCol=viewportCappedStartRow===viewportCappedEndRow?end[0]:terminal.cols;this._ctx.fillStyle=this._colors.selection.css;this.fillCells(startCol,viewportCappedStartRow,startRowEndCol-startCol,1);var middleRowsCount=Math.max(viewportCappedEndRow-viewportCappedStartRow-1,0);this.fillCells(0,viewportCappedStartRow+1,terminal.cols,middleRowsCount);if(viewportCappedStartRow!==viewportCappedEndRow){var endCol=viewportEndRow===viewportCappedEndRow?end[0]:terminal.cols;this.fillCells(0,viewportCappedEndRow,endCol,1)}this._state.start=[start[0],start[1]];this._state.end=[end[0],end[1]]};return SelectionRenderLayer}(BaseRenderLayer_1.BaseRenderLayer);exports.SelectionRenderLayer=SelectionRenderLayer},{"./BaseRenderLayer":22}],29:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:true});var Buffer_1=require("../Buffer");var Types_1=require("./Types");var Types_2=require("./atlas/Types");var GridCache_1=require("./GridCache");var BaseRenderLayer_1=require("./BaseRenderLayer");var TextRenderLayer=function(_super){__extends(TextRenderLayer,_super);function TextRenderLayer(container,zIndex,colors,alpha){var _this=_super.call(this,container,"text",zIndex,alpha,colors)||this;_this._characterOverlapCache={};_this._state=new GridCache_1.GridCache;return _this}TextRenderLayer.prototype.resize=function(terminal,dim){_super.prototype.resize.call(this,terminal,dim);var terminalFont=this._getFont(terminal,false);if(this._characterWidth!==dim.scaledCharWidth||this._characterFont!==terminalFont){this._characterWidth=dim.scaledCharWidth;this._characterFont=terminalFont;this._characterOverlapCache={}}this._state.clear();this._state.resize(terminal.cols,terminal.rows)};TextRenderLayer.prototype.reset=function(terminal){this._state.clear();this.clearAll()};TextRenderLayer.prototype.onGridChanged=function(terminal,startRow,endRow){if(this._state.cache.length===0){return}for(var y=startRow;y<=endRow;y++){var row=y+terminal.buffer.ydisp;var line=terminal.buffer.lines.get(row);this.clearCells(0,y,terminal.cols,1);for(var x=0;x<terminal.cols;x++){var charData=line[x];var code=charData[Buffer_1.CHAR_DATA_CODE_INDEX];var char=charData[Buffer_1.CHAR_DATA_CHAR_INDEX];var attr=charData[Buffer_1.CHAR_DATA_ATTR_INDEX];var width=charData[Buffer_1.CHAR_DATA_WIDTH_INDEX];if(width===0){continue}if(code===32){if(x>0){var previousChar=line[x-1];if(this._isOverlapping(previousChar)){continue}}}var flags=attr>>18;var bg=attr&511;var isDefaultBackground=bg>=256;var isInvisible=flags&Types_1.FLAGS.INVISIBLE;var isInverted=flags&Types_1.FLAGS.INVERSE;if(!code||code===32&&isDefaultBackground&&!isInverted||isInvisible){continue}if(width!==0&&this._isOverlapping(charData)){if(x<line.length-1&&line[x+1][Buffer_1.CHAR_DATA_CODE_INDEX]===32){width=2}}var fg=attr>>9&511;if(isInverted){var temp=bg;bg=fg;fg=temp;if(fg===256){fg=Types_2.INVERTED_DEFAULT_COLOR}if(bg===257){bg=Types_2.INVERTED_DEFAULT_COLOR}}if(width===2){}if(bg<256){this._ctx.save();this._ctx.fillStyle=bg===Types_2.INVERTED_DEFAULT_COLOR?this._colors.foreground.css:this._colors.ansi[bg].css;this.fillCells(x,y,width,1);this._ctx.restore()}this._ctx.save();if(flags&Types_1.FLAGS.BOLD){this._ctx.font=this._getFont(terminal,true);if(fg<8){fg+=8}}if(flags&Types_1.FLAGS.UNDERLINE){if(fg===Types_2.INVERTED_DEFAULT_COLOR){this._ctx.fillStyle=this._colors.background.css}else if(fg<256){this._ctx.fillStyle=this._colors.ansi[fg].css}else{this._ctx.fillStyle=this._colors.foreground.css}this.fillBottomLineAtCells(x,y)}this.drawChar(terminal,char,code,width,x,y,fg,bg,!!(flags&Types_1.FLAGS.BOLD),!!(flags&Types_1.FLAGS.DIM));this._ctx.restore()}}};TextRenderLayer.prototype.onOptionsChanged=function(terminal){this.setTransparency(terminal,terminal.options.allowTransparency)};TextRenderLayer.prototype._isOverlapping=function(charData){if(charData[Buffer_1.CHAR_DATA_WIDTH_INDEX]!==1){return false}var code=charData[Buffer_1.CHAR_DATA_CODE_INDEX];if(code<256){return false}var char=charData[Buffer_1.CHAR_DATA_CHAR_INDEX];if(this._characterOverlapCache.hasOwnProperty(char)){return this._characterOverlapCache[char]}this._ctx.save();this._ctx.font=this._characterFont;var overlaps=Math.floor(this._ctx.measureText(char).width)>this._characterWidth;this._ctx.restore();this._characterOverlapCache[char]=overlaps;return overlaps};return TextRenderLayer}(BaseRenderLayer_1.BaseRenderLayer);exports.TextRenderLayer=TextRenderLayer},{"../Buffer":2,"./BaseRenderLayer":22,"./GridCache":25,"./Types":30,"./atlas/Types":33}],30:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var FLAGS;(function(FLAGS){FLAGS[FLAGS["BOLD"]=1]="BOLD";FLAGS[FLAGS["UNDERLINE"]=2]="UNDERLINE";FLAGS[FLAGS["BLINK"]=4]="BLINK";FLAGS[FLAGS["INVERSE"]=8]="INVERSE";FLAGS[FLAGS["INVISIBLE"]=16]="INVISIBLE";FLAGS[FLAGS["DIM"]=32]="DIM"})(FLAGS=exports.FLAGS||(exports.FLAGS={}))},{}],31:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var CharAtlasGenerator_1=require("../../shared/atlas/CharAtlasGenerator");var CharAtlasUtils_1=require("./CharAtlasUtils");var charAtlasCache=[];function acquireCharAtlas(terminal,colors,scaledCharWidth,scaledCharHeight){var newConfig=CharAtlasUtils_1.generateConfig(scaledCharWidth,scaledCharHeight,terminal,colors);for(var i=0;i<charAtlasCache.length;i++){var entry=charAtlasCache[i];var ownedByIndex=entry.ownedBy.indexOf(terminal);if(ownedByIndex>=0){if(CharAtlasUtils_1.configEquals(entry.config,newConfig)){return entry.bitmap}else{if(entry.ownedBy.length===1){charAtlasCache.splice(i,1)}else{entry.ownedBy.splice(ownedByIndex,1)}break}}}for(var i=0;i<charAtlasCache.length;i++){var entry=charAtlasCache[i];if(CharAtlasUtils_1.configEquals(entry.config,newConfig)){entry.ownedBy.push(terminal);return entry.bitmap}}var canvasFactory=function(width,height){var canvas=document.createElement("canvas");canvas.width=width;canvas.height=height;return canvas};var newEntry={bitmap:CharAtlasGenerator_1.generateCharAtlas(window,canvasFactory,newConfig),config:newConfig,ownedBy:[terminal]};charAtlasCache.push(newEntry);return newEntry.bitmap}exports.acquireCharAtlas=acquireCharAtlas},{"../../shared/atlas/CharAtlasGenerator":34,"./CharAtlasUtils":32}],32:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function generateConfig(scaledCharWidth,scaledCharHeight,terminal,colors){var clonedColors={foreground:colors.foreground,background:colors.background,cursor:null,cursorAccent:null,selection:null,ansi:colors.ansi.slice(0,16)};return{devicePixelRatio:window.devicePixelRatio,scaledCharWidth:scaledCharWidth,scaledCharHeight:scaledCharHeight,fontFamily:terminal.options.fontFamily,fontSize:terminal.options.fontSize,fontWeight:terminal.options.fontWeight,fontWeightBold:terminal.options.fontWeightBold,allowTransparency:terminal.options.allowTransparency,colors:clonedColors}}exports.generateConfig=generateConfig;function configEquals(a,b){for(var i=0;i<a.colors.ansi.length;i++){if(a.colors.ansi[i].rgba!==b.colors.ansi[i].rgba){return false}}return a.devicePixelRatio===b.devicePixelRatio&&a.fontFamily===b.fontFamily&&a.fontSize===b.fontSize&&a.fontWeight===b.fontWeight&&a.fontWeightBold===b.fontWeightBold&&a.allowTransparency===b.allowTransparency&&a.scaledCharWidth===b.scaledCharWidth&&a.scaledCharHeight===b.scaledCharHeight&&a.colors.foreground===b.colors.foreground&&a.colors.background===b.colors.background}exports.configEquals=configEquals},{}],33:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.INVERTED_DEFAULT_COLOR=-1;exports.DIM_OPACITY=.5},{}],34:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var Types_1=require("./Types");var Browser_1=require("../utils/Browser");function generateCharAtlas(context,canvasFactory,config){var cellWidth=config.scaledCharWidth+Types_1.CHAR_ATLAS_CELL_SPACING;var cellHeight=config.scaledCharHeight+Types_1.CHAR_ATLAS_CELL_SPACING;var canvas=canvasFactory(255*cellWidth,(2+16)*cellHeight);var ctx=canvas.getContext("2d",{alpha:config.allowTransparency});ctx.fillStyle=config.colors.background.css;ctx.fillRect(0,0,canvas.width,canvas.height);ctx.save();ctx.fillStyle=config.colors.foreground.css;ctx.font=getFont(config.fontWeight,config);ctx.textBaseline="top";for(var i=0;i<256;i++){ctx.save();ctx.beginPath();ctx.rect(i*cellWidth,0,cellWidth,cellHeight);ctx.clip();ctx.fillText(String.fromCharCode(i),i*cellWidth,0);ctx.restore()}ctx.save();ctx.font=getFont(config.fontWeightBold,config);for(var i=0;i<256;i++){ctx.save();ctx.beginPath();ctx.rect(i*cellWidth,cellHeight,cellWidth,cellHeight);ctx.clip();ctx.fillText(String.fromCharCode(i),i*cellWidth,cellHeight);ctx.restore()}ctx.restore();ctx.font=getFont(config.fontWeight,config);for(var colorIndex=0;colorIndex<16;colorIndex++){if(colorIndex===8){ctx.font=getFont(config.fontWeightBold,config)}var y=(colorIndex+2)*cellHeight;for(var i=0;i<256;i++){ctx.save();ctx.beginPath();ctx.rect(i*cellWidth,y,cellWidth,cellHeight);ctx.clip();ctx.fillStyle=config.colors.ansi[colorIndex].css;ctx.fillText(String.fromCharCode(i),i*cellWidth,y);ctx.restore()}}ctx.restore();if(!("createImageBitmap"in context)||Browser_1.isFirefox){if(canvas instanceof HTMLCanvasElement){return canvas}else{return new Promise(function(r){return r(canvas.transferToImageBitmap())})}}var charAtlasImageData=ctx.getImageData(0,0,canvas.width,canvas.height);var r=config.colors.background.rgba>>>24;var g=config.colors.background.rgba>>>16&255;var b=config.colors.background.rgba>>>8&255;clearColor(charAtlasImageData,r,g,b);return context.createImageBitmap(charAtlasImageData)}exports.generateCharAtlas=generateCharAtlas;function clearColor(imageData,r,g,b){for(var offset=0;offset<imageData.data.length;offset+=4){if(imageData.data[offset]===r&&imageData.data[offset+1]===g&&imageData.data[offset+2]===b){imageData.data[offset+3]=0}}}function getFont(fontWeight,config){return fontWeight+" "+config.fontSize*config.devicePixelRatio+"px "+config.fontFamily}},{"../utils/Browser":36,"./Types":35}],35:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.CHAR_ATLAS_CELL_SPACING=1},{}],36:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var isNode=typeof navigator==="undefined"?true:false;var userAgent=isNode?"node":navigator.userAgent;var platform=isNode?"node":navigator.platform;exports.isFirefox=!!~userAgent.indexOf("Firefox");exports.isMSIE=!!~userAgent.indexOf("MSIE")||!!~userAgent.indexOf("Trident");exports.isMac=contains(["Macintosh","MacIntel","MacPPC","Mac68K"],platform);exports.isIpad=platform==="iPad";exports.isIphone=platform==="iPhone";exports.isMSWindows=contains(["Windows","Win16","Win32","WinCE"],platform);exports.isLinux=platform.indexOf("Linux")>=0;function contains(arr,el){return arr.indexOf(el)>=0}},{}],37:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:true});var EventEmitter_1=require("../EventEmitter");var CharMeasure=function(_super){__extends(CharMeasure,_super);function CharMeasure(document,parentElement){var _this=_super.call(this)||this;_this._document=document;_this._parentElement=parentElement;_this._measureElement=_this._document.createElement("span");_this._measureElement.classList.add("xterm-char-measure-element");_this._measureElement.textContent="W";_this._measureElement.setAttribute("aria-hidden","true");_this._parentElement.appendChild(_this._measureElement);return _this}Object.defineProperty(CharMeasure.prototype,"width",{get:function(){return this._width},enumerable:true,configurable:true});Object.defineProperty(CharMeasure.prototype,"height",{get:function(){return this._height},enumerable:true,configurable:true});CharMeasure.prototype.measure=function(options){this._measureElement.style.fontFamily=options.fontFamily;this._measureElement.style.fontSize=options.fontSize+"px";var geometry=this._measureElement.getBoundingClientRect();if(geometry.width===0||geometry.height===0){return}if(this._width!==geometry.width||this._height!==geometry.height){this._width=geometry.width;this._height=Math.ceil(geometry.height);this.emit("charsizechanged")}};return CharMeasure}(EventEmitter_1.EventEmitter);exports.CharMeasure=CharMeasure},{"../EventEmitter":8}],38:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:true});var EventEmitter_1=require("../EventEmitter");var CircularList=function(_super){__extends(CircularList,_super);function CircularList(_maxLength){var _this=_super.call(this)||this;_this._maxLength=_maxLength;_this._array=new Array(_this._maxLength);_this._startIndex=0;_this._length=0;return _this}Object.defineProperty(CircularList.prototype,"maxLength",{get:function(){return this._maxLength},set:function(newMaxLength){if(this._maxLength===newMaxLength){return}var newArray=new Array(newMaxLength);for(var i=0;i<Math.min(newMaxLength,this.length);i++){newArray[i]=this._array[this._getCyclicIndex(i)]}this._array=newArray;this._maxLength=newMaxLength;this._startIndex=0},enumerable:true,configurable:true});Object.defineProperty(CircularList.prototype,"length",{get:function(){return this._length},set:function(newLength){if(newLength>this._length){for(var i=this._length;i<newLength;i++){this._array[i]=undefined}}this._length=newLength},enumerable:true,configurable:true});CircularList.prototype.get=function(index){return this._array[this._getCyclicIndex(index)]};CircularList.prototype.set=function(index,value){this._array[this._getCyclicIndex(index)]=value};CircularList.prototype.push=function(value){this._array[this._getCyclicIndex(this._length)]=value;if(this._length===this._maxLength){this._startIndex++;if(this._startIndex===this._maxLength){this._startIndex=0}this.emit("trim",1)}else{this._length++}};CircularList.prototype.pop=function(){return this._array[this._getCyclicIndex(this._length---1)]};CircularList.prototype.splice=function(start,deleteCount){var items=[];for(var _i=2;_i<arguments.length;_i++){items[_i-2]=arguments[_i]}if(deleteCount){for(var i=start;i<this._length-deleteCount;i++){this._array[this._getCyclicIndex(i)]=this._array[this._getCyclicIndex(i+deleteCount)]}this._length-=deleteCount}if(items&&items.length){for(var i=this._length-1;i>=start;i--){this._array[this._getCyclicIndex(i+items.length)]=this._array[this._getCyclicIndex(i)]}for(var i=0;i<items.length;i++){this._array[this._getCyclicIndex(start+i)]=items[i]}if(this._length+items.length>this.maxLength){var countToTrim=this._length+items.length-this.maxLength;this._startIndex+=countToTrim;this._length=this.maxLength;this.emit("trim",countToTrim)}else{this._length+=items.length}}};CircularList.prototype.trimStart=function(count){if(count>this._length){count=this._length}this._startIndex+=count;this._length-=count;this.emit("trim",count)};CircularList.prototype.shiftElements=function(start,count,offset){if(count<=0){return}if(start<0||start>=this._length){throw new Error("start argument out of range")}if(start+offset<0){throw new Error("Cannot shift elements in list beyond index 0")}if(offset>0){for(var i=count-1;i>=0;i--){this.set(start+i+offset,this.get(start+i))}var expandListBy=start+count+offset-this._length;if(expandListBy>0){this._length+=expandListBy;while(this._length>this.maxLength){this._length--;this._startIndex++;this.emit("trim",1)}}}else{for(var i=0;i<count;i++){this.set(start+i+offset,this.get(start+i))}}};CircularList.prototype._getCyclicIndex=function(index){return(this._startIndex+index)%this.maxLength};return CircularList}(EventEmitter_1.EventEmitter);exports.CircularList=CircularList},{"../EventEmitter":8}],39:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.clone=function(val,depth){if(depth===void 0){depth=5}if(typeof val!=="object"){return val}if(val===null){return null}var clonedObject=Array.isArray(val)?[]:{};for(var key in val){clonedObject[key]=depth<=1?val[key]:exports.clone(val[key],depth-1)}return clonedObject}},{}],40:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function addDisposableListener(node,type,handler,useCapture){node.addEventListener(type,handler,useCapture);return{dispose:function(){if(!handler){return}node.removeEventListener(type,handler,useCapture);node=null;handler=null}}}exports.addDisposableListener=addDisposableListener},{}],41:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var MouseHelper=function(){function MouseHelper(_renderer){this._renderer=_renderer}MouseHelper.getCoordsRelativeToElement=function(event,element){if(event.pageX==null){return null}var originalElement=element;var x=event.pageX;var y=event.pageY;while(element){x-=element.offsetLeft;y-=element.offsetTop;element=element.offsetParent}element=originalElement;while(element&&element!==element.ownerDocument.body){x+=element.scrollLeft;y+=element.scrollTop;element=element.parentElement}return[x,y]};MouseHelper.prototype.getCoords=function(event,element,charMeasure,lineHeight,colCount,rowCount,isSelection){if(!charMeasure.width||!charMeasure.height){return null}var coords=MouseHelper.getCoordsRelativeToElement(event,element);if(!coords){return null}coords[0]=Math.ceil((coords[0]+(isSelection?this._renderer.dimensions.actualCellWidth/2:0))/this._renderer.dimensions.actualCellWidth);coords[1]=Math.ceil(coords[1]/this._renderer.dimensions.actualCellHeight);coords[0]=Math.min(Math.max(coords[0],1),colCount+(isSelection?1:0));coords[1]=Math.min(Math.max(coords[1],1),rowCount);return coords};MouseHelper.prototype.getRawByteCoords=function(event,element,charMeasure,lineHeight,colCount,rowCount){var coords=this.getCoords(event,element,charMeasure,lineHeight,colCount,rowCount);var x=coords[0];var y=coords[1];x+=32;y+=32;return{x:x,y:y}};return MouseHelper}();exports.MouseHelper=MouseHelper},{}],42:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var RenderDebouncer=function(){function RenderDebouncer(_terminal,_callback){this._terminal=_terminal;this._callback=_callback;this._animationFrame=null}RenderDebouncer.prototype.dispose=function(){if(this._animationFrame){window.cancelAnimationFrame(this._animationFrame);this._animationFrame=null}};RenderDebouncer.prototype.refresh=function(rowStart,rowEnd){var _this=this;rowStart=rowStart||0;rowEnd=rowEnd||this._terminal.rows-1;this._rowStart=this._rowStart!==undefined?Math.min(this._rowStart,rowStart):rowStart;this._rowEnd=this._rowEnd!==undefined?Math.max(this._rowEnd,rowEnd):rowEnd;if(this._animationFrame){return}this._animationFrame=window.requestAnimationFrame(function(){return _this._innerRefresh()})};RenderDebouncer.prototype._innerRefresh=function(){this._rowStart=Math.max(this._rowStart,0);this._rowEnd=Math.min(this._rowEnd,this._terminal.rows-1);this._callback(this._rowStart,this._rowEnd);this._rowStart=null;this._rowEnd=null;this._animationFrame=null};return RenderDebouncer}();exports.RenderDebouncer=RenderDebouncer},{}],43:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var ScreenDprMonitor=function(){function ScreenDprMonitor(){}ScreenDprMonitor.prototype.setListener=function(listener){var _this=this;if(this._listener){this.clearListener()}this._listener=listener;this._outerListener=function(){_this._listener(window.devicePixelRatio,_this._currentDevicePixelRatio);_this._updateDpr()};this._updateDpr()};ScreenDprMonitor.prototype._updateDpr=function(){if(this._resolutionMediaMatchList){this._resolutionMediaMatchList.removeListener(this._outerListener)}this._currentDevicePixelRatio=window.devicePixelRatio;this._resolutionMediaMatchList=window.matchMedia("screen and (resolution: "+window.devicePixelRatio+"dppx)");this._resolutionMediaMatchList.addListener(this._outerListener)};ScreenDprMonitor.prototype.clearListener=function(){if(!this._listener){return}this._resolutionMediaMatchList.removeListener(this._outerListener);this._listener=null;this._outerListener=null};return ScreenDprMonitor}();exports.ScreenDprMonitor=ScreenDprMonitor},{}],44:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var Terminal_1=require("./Terminal");module.exports=Terminal_1.Terminal},{"./Terminal":16}]},{},[44])(44)});
/*! https://mths.be/punycode v1.4.1 by @mathias */
!function(a){function b(a){throw new RangeError(E[a])}function c(a,b){for(var c=a.length,d=[];c--;)d[c]=b(a[c]);return d}function d(a,b){var d=a.split("@"),e="";d.length>1&&(e=d[0]+"@",a=d[1]),a=a.replace(D,".");var f=a.split("."),g=c(f,b).join(".");return e+g}function e(a){for(var b,c,d=[],e=0,f=a.length;f>e;)b=a.charCodeAt(e++),b>=55296&&56319>=b&&f>e?(c=a.charCodeAt(e++),56320==(64512&c)?d.push(((1023&b)<<10)+(1023&c)+65536):(d.push(b),e--)):d.push(b);return d}function f(a){return c(a,function(a){var b="";return a>65535&&(a-=65536,b+=H(a>>>10&1023|55296),a=56320|1023&a),b+=H(a)}).join("")}function g(a){return 10>a-48?a-22:26>a-65?a-65:26>a-97?a-97:t}function h(a,b){return a+22+75*(26>a)-((0!=b)<<5)}function i(a,b,c){var d=0;for(a=c?G(a/x):a>>1,a+=G(a/b);a>F*v>>1;d+=t)a=G(a/F);return G(d+(F+1)*a/(a+w))}function j(a){var c,d,e,h,j,k,l,m,n,o,p=[],q=a.length,r=0,w=z,x=y;for(d=a.lastIndexOf(A),0>d&&(d=0),e=0;d>e;++e)a.charCodeAt(e)>=128&&b("not-basic"),p.push(a.charCodeAt(e));for(h=d>0?d+1:0;q>h;){for(j=r,k=1,l=t;h>=q&&b("invalid-input"),m=g(a.charCodeAt(h++)),(m>=t||m>G((s-r)/k))&&b("overflow"),r+=m*k,n=x>=l?u:l>=x+v?v:l-x,!(n>m);l+=t)o=t-n,k>G(s/o)&&b("overflow"),k*=o;c=p.length+1,x=i(r-j,c,0==j),G(r/c)>s-w&&b("overflow"),w+=G(r/c),r%=c,p.splice(r++,0,w)}return f(p)}function k(a){var c,d,f,g,j,k,l,m,n,o,p,q,r,w,x,B=[];for(a=e(a),q=a.length,c=z,d=0,j=y,k=0;q>k;++k)p=a[k],128>p&&B.push(H(p));for(f=g=B.length,g&&B.push(A);q>f;){for(l=s,k=0;q>k;++k)p=a[k],p>=c&&l>p&&(l=p);for(r=f+1,l-c>G((s-d)/r)&&b("overflow"),d+=(l-c)*r,c=l,k=0;q>k;++k)if(p=a[k],c>p&&++d>s&&b("overflow"),p==c){for(m=d,n=t;o=j>=n?u:n>=j+v?v:n-j,!(o>m);n+=t)x=m-o,w=t-o,B.push(H(h(o+x%w,0))),m=G(x/w);B.push(H(h(m,0))),j=i(d,r,f==g),d=0,++f}++d,++c}return B.join("")}function l(a){return d(a,function(a){return B.test(a)?j(a.slice(4).toLowerCase()):a})}function m(a){return d(a,function(a){return C.test(a)?"xn--"+k(a):a})}var n="object"==typeof exports&&exports&&!exports.nodeType&&exports,o="object"==typeof module&&module&&!module.nodeType&&module,p="object"==typeof global&&global;(p.global===p||p.window===p||p.self===p)&&(a=p);var q,r,s=2147483647,t=36,u=1,v=26,w=38,x=700,y=72,z=128,A="-",B=/^xn--/,C=/[^\x20-\x7E]/,D=/[\x2E\u3002\uFF0E\uFF61]/g,E={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},F=t-u,G=Math.floor,H=String.fromCharCode;if(q={version:"1.4.1",ucs2:{decode:e,encode:f},decode:j,encode:k,toASCII:m,toUnicode:l},"function"==typeof define&&"object"==typeof define.amd&&define.amd)define("punycode",[],function(){return q});else if(n&&o)if(module.exports==n)o.exports=q;else for(r in q)q.hasOwnProperty(r)&&(n[r]=q[r]);else a.punycode=q}(this);

define("frameworks.cmb", function(){});
}());