/*
 * tools/views/sslStatus.js                                Copyright 2022 cPanel, L.L.C.
 *                                                                 All rights reserved.
 * copyright@cpanel.net                                               http://cpanel.net
 * This code is subject to the cPanel license. Unauthorized copying is prohibited
 */

/* global define: false */

define(
    'app/views/sslStatus',[
        "angular",
        "cjt/util/locale",
        "cjt/modules",
        "cjt/services/cpanel/SSLStatus",
        "uiBootstrap",
    ],
    function(angular, LOCALE, modules, SSLStatus) {

        "use strict";

        var MODULE_NAMESPACE = "cpanel.tools.views.sslStatus";
        var MODULE_DEPENDANCIES = [
            "cjt2.cpanel",
            SSLStatus.namespace,
        ];

        var CONTROLLER_NAME = "sslStatusController";
        var CONTROLLER_INJECTABLES = ["$scope", SSLStatus.serviceName, "$timeout"];

        var CONTROLLER = function SSLStatusController($scope, $service, $timeout) {

            $scope.sslStatusString = null;
            $scope.sslStatusLoaded = false;
            $scope.sslValidationIconClasses = "fas fa-spinner fa-spin";
            $scope.statusColorClasses = "";
            $scope.certErrorsMessage = "";
            $scope.domainLink = "#";

            $scope._setSSLCertificate = function _setSSLCertificate(sslCertificate) {
                $scope.sslStatusLoaded = true;
                $scope.sslStatusString = sslCertificate.getTypeName();
                $scope.expandedSslStatusString = sslCertificate.getTypeName({ stripMarkup: true });
                $scope.sslValidationIconClasses = sslCertificate.getIconClasses() === "fas fa-unlock-alt" ? "ri-lock-unlock-line" : "ri-lock-line";
                $scope.statusColorClasses = sslCertificate.getStatusColorClass();
                $scope.sslSecured = $scope.statusColorClasses !== "text-danger";
                $scope.certHasErrors = sslCertificate.hasErrors;
                $scope.certErrorsMessage = LOCALE.maketext("The certificate has the following errors: [list_and,_1]", sslCertificate.getErrors());

                // since a cert is always returned, if it has any kind of validation type, display it as ssl
                $scope.domainLink = sslCertificate.validationType ? "https://" + $scope.primaryDomain : "http://" + $scope.primaryDomain;
            };

            $scope._domainNotSet = function _domainNotSet() {
                throw "primaryDomain must be set on init";
            };

            // return this for testing
            return $timeout(function() {
                if (!$scope.primaryDomain) {
                    $scope._domainNotSet();
                    return;
                }
                $scope.domainLink = "http://" + $scope.primaryDomain;
                return $service.getDomainSSLCertificate($scope.primaryDomain, true).then($scope._setSSLCertificate.bind($scope));
            }, 1);

        };

        CONTROLLER_INJECTABLES.push(CONTROLLER);

        var app = angular.module(MODULE_NAMESPACE, MODULE_DEPENDANCIES);
        app.controller(CONTROLLER_NAME, CONTROLLER_INJECTABLES);

        return {
            "controller": CONTROLLER_NAME,
            "class": CONTROLLER,
            "namespace": MODULE_NAMESPACE,
        };
    }
);

(function(root) {
define("jquery-chosen", ["jquery"], function() {
  return (function() {
/*!
Chosen, a Select Box Enhancer for jQuery and Prototype
by Patrick Filler for Harvest, http://getharvest.com

Version 1.5.1
Full source at https://github.com/harvesthq/chosen
Copyright (c) 2011-2016 Harvest http://getharvest.com

MIT License, https://github.com/harvesthq/chosen/blob/master/LICENSE.md
This file is generated by `grunt build`, do not edit it by hand.
*/

(function() {
  var $, AbstractChosen, Chosen, SelectParser, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  SelectParser = (function() {
    function SelectParser() {
      this.options_index = 0;
      this.parsed = [];
    }

    SelectParser.prototype.add_node = function(child) {
      if (child.nodeName.toUpperCase() === "OPTGROUP") {
        return this.add_group(child);
      } else {
        return this.add_option(child);
      }
    };

    SelectParser.prototype.add_group = function(group) {
      var group_position, option, _i, _len, _ref, _results;
      group_position = this.parsed.length;
      this.parsed.push({
        array_index: group_position,
        group: true,
        label: this.escapeExpression(group.label),
        title: group.title ? group.title : void 0,
        children: 0,
        disabled: group.disabled,
        classes: group.className
      });
      _ref = group.childNodes;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        option = _ref[_i];
        _results.push(this.add_option(option, group_position, group.disabled));
      }
      return _results;
    };

    SelectParser.prototype.add_option = function(option, group_position, group_disabled) {
      if (option.nodeName.toUpperCase() === "OPTION") {
        if (option.text !== "") {
          if (group_position != null) {
            this.parsed[group_position].children += 1;
          }
          this.parsed.push({
            array_index: this.parsed.length,
            options_index: this.options_index,
            value: option.value,
            text: option.text,
            html: option.innerHTML,
            title: option.title ? option.title : void 0,
            selected: option.selected,
            disabled: group_disabled === true ? group_disabled : option.disabled,
            group_array_index: group_position,
            group_label: group_position != null ? this.parsed[group_position].label : null,
            classes: option.className,
            style: option.style.cssText
          });
        } else {
          this.parsed.push({
            array_index: this.parsed.length,
            options_index: this.options_index,
            empty: true
          });
        }
        return this.options_index += 1;
      }
    };

    SelectParser.prototype.escapeExpression = function(text) {
      var map, unsafe_chars;
      if ((text == null) || text === false) {
        return "";
      }
      if (!/[\&\<\>\"\'\`]/.test(text)) {
        return text;
      }
      map = {
        "<": "&lt;",
        ">": "&gt;",
        '"': "&quot;",
        "'": "&#x27;",
        "`": "&#x60;"
      };
      unsafe_chars = /&(?!\w+;)|[\<\>\"\'\`]/g;
      return text.replace(unsafe_chars, function(chr) {
        return map[chr] || "&amp;";
      });
    };

    return SelectParser;

  })();

  SelectParser.select_to_array = function(select) {
    var child, parser, _i, _len, _ref;
    parser = new SelectParser();
    _ref = select.childNodes;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      child = _ref[_i];
      parser.add_node(child);
    }
    return parser.parsed;
  };

  AbstractChosen = (function() {
    function AbstractChosen(form_field, options) {
      this.form_field = form_field;
      this.options = options != null ? options : {};
      if (!AbstractChosen.browser_is_supported()) {
        return;
      }
      this.is_multiple = this.form_field.multiple;
      this.set_default_text();
      this.set_default_values();
      this.setup();
      this.set_up_html();
      this.register_observers();
      this.on_ready();
    }

    AbstractChosen.prototype.set_default_values = function() {
      var _this = this;
      this.click_test_action = function(evt) {
        return _this.test_active_click(evt);
      };
      this.activate_action = function(evt) {
        return _this.activate_field(evt);
      };
      this.active_field = false;
      this.mouse_on_container = false;
      this.results_showing = false;
      this.result_highlighted = null;
      this.allow_single_deselect = (this.options.allow_single_deselect != null) && (this.form_field.options[0] != null) && this.form_field.options[0].text === "" ? this.options.allow_single_deselect : false;
      this.disable_search_threshold = this.options.disable_search_threshold || 0;
      this.disable_search = this.options.disable_search || false;
      this.enable_split_word_search = this.options.enable_split_word_search != null ? this.options.enable_split_word_search : true;
      this.group_search = this.options.group_search != null ? this.options.group_search : true;
      this.search_contains = this.options.search_contains || false;
      this.single_backstroke_delete = this.options.single_backstroke_delete != null ? this.options.single_backstroke_delete : true;
      this.max_selected_options = this.options.max_selected_options || Infinity;
      this.inherit_select_classes = this.options.inherit_select_classes || false;
      this.display_selected_options = this.options.display_selected_options != null ? this.options.display_selected_options : true;
      this.display_disabled_options = this.options.display_disabled_options != null ? this.options.display_disabled_options : true;
      this.include_group_label_in_selected = this.options.include_group_label_in_selected || false;
      return this.max_shown_results = this.options.max_shown_results || Number.POSITIVE_INFINITY;
    };

    AbstractChosen.prototype.set_default_text = function() {
      if (this.form_field.getAttribute("data-placeholder")) {
        this.default_text = this.form_field.getAttribute("data-placeholder");
      } else if (this.is_multiple) {
        this.default_text = this.options.placeholder_text_multiple || this.options.placeholder_text || AbstractChosen.default_multiple_text;
      } else {
        this.default_text = this.options.placeholder_text_single || this.options.placeholder_text || AbstractChosen.default_single_text;
      }
      return this.results_none_found = this.form_field.getAttribute("data-no_results_text") || this.options.no_results_text || AbstractChosen.default_no_result_text;
    };

    AbstractChosen.prototype.choice_label = function(item) {
      if (this.include_group_label_in_selected && (item.group_label != null)) {
        return "<b class='group-name'>" + item.group_label + "</b>" + item.html;
      } else {
        return item.html;
      }
    };

    AbstractChosen.prototype.mouse_enter = function() {
      return this.mouse_on_container = true;
    };

    AbstractChosen.prototype.mouse_leave = function() {
      return this.mouse_on_container = false;
    };

    AbstractChosen.prototype.input_focus = function(evt) {
      var _this = this;
      if (this.is_multiple) {
        if (!this.active_field) {
          return setTimeout((function() {
            return _this.container_mousedown();
          }), 50);
        }
      } else {
        if (!this.active_field) {
          return this.activate_field();
        }
      }
    };

    AbstractChosen.prototype.input_blur = function(evt) {
      var _this = this;
      if (!this.mouse_on_container) {
        this.active_field = false;
        return setTimeout((function() {
          return _this.blur_test();
        }), 100);
      }
    };

    AbstractChosen.prototype.results_option_build = function(options) {
      var content, data, data_content, shown_results, _i, _len, _ref;
      content = '';
      shown_results = 0;
      _ref = this.results_data;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        data = _ref[_i];
        data_content = '';
        if (data.group) {
          data_content = this.result_add_group(data);
        } else {
          data_content = this.result_add_option(data);
        }
        if (data_content !== '') {
          shown_results++;
          content += data_content;
        }
        if (options != null ? options.first : void 0) {
          if (data.selected && this.is_multiple) {
            this.choice_build(data);
          } else if (data.selected && !this.is_multiple) {
            this.single_set_selected_text(this.choice_label(data));
          }
        }
        if (shown_results >= this.max_shown_results) {
          break;
        }
      }
      return content;
    };

    AbstractChosen.prototype.result_add_option = function(option) {
      var classes, option_el;
      if (!option.search_match) {
        return '';
      }
      if (!this.include_option_in_results(option)) {
        return '';
      }
      classes = [];
      if (!option.disabled && !(option.selected && this.is_multiple)) {
        classes.push("active-result");
      }
      if (option.disabled && !(option.selected && this.is_multiple)) {
        classes.push("disabled-result");
      }
      if (option.selected) {
        classes.push("result-selected");
      }
      if (option.group_array_index != null) {
        classes.push("group-option");
      }
      if (option.classes !== "") {
        classes.push(option.classes);
      }
      option_el = document.createElement("li");
      option_el.className = classes.join(" ");
      option_el.style.cssText = option.style;
      option_el.setAttribute("data-option-array-index", option.array_index);
      option_el.innerHTML = option.search_text;
      if (option.title) {
        option_el.title = option.title;
      }
      return this.outerHTML(option_el);
    };

    AbstractChosen.prototype.result_add_group = function(group) {
      var classes, group_el;
      if (!(group.search_match || group.group_match)) {
        return '';
      }
      if (!(group.active_options > 0)) {
        return '';
      }
      classes = [];
      classes.push("group-result");
      if (group.classes) {
        classes.push(group.classes);
      }
      group_el = document.createElement("li");
      group_el.className = classes.join(" ");
      group_el.innerHTML = group.search_text;
      if (group.title) {
        group_el.title = group.title;
      }
      return this.outerHTML(group_el);
    };

    AbstractChosen.prototype.results_update_field = function() {
      this.set_default_text();
      if (!this.is_multiple) {
        this.results_reset_cleanup();
      }
      this.result_clear_highlight();
      this.results_build();
      if (this.results_showing) {
        return this.winnow_results();
      }
    };

    AbstractChosen.prototype.reset_single_select_options = function() {
      var result, _i, _len, _ref, _results;
      _ref = this.results_data;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        result = _ref[_i];
        if (result.selected) {
          _results.push(result.selected = false);
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    AbstractChosen.prototype.results_toggle = function() {
      if (this.results_showing) {
        return this.results_hide();
      } else {
        return this.results_show();
      }
    };

    AbstractChosen.prototype.results_search = function(evt) {
      if (this.results_showing) {
        return this.winnow_results();
      } else {
        return this.results_show();
      }
    };

    AbstractChosen.prototype.winnow_results = function() {
      var escapedSearchText, option, regex, results, results_group, searchText, startpos, text, zregex, _i, _len, _ref;
      this.no_results_clear();
      results = 0;
      searchText = this.get_search_text();
      escapedSearchText = searchText.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
      zregex = new RegExp(escapedSearchText, 'i');
      regex = this.get_search_regex(escapedSearchText);
      _ref = this.results_data;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        option = _ref[_i];
        option.search_match = false;
        results_group = null;
        if (this.include_option_in_results(option)) {
          if (option.group) {
            option.group_match = false;
            option.active_options = 0;
          }
          if ((option.group_array_index != null) && this.results_data[option.group_array_index]) {
            results_group = this.results_data[option.group_array_index];
            if (results_group.active_options === 0 && results_group.search_match) {
              results += 1;
            }
            results_group.active_options += 1;
          }
          option.search_text = option.group ? option.label : option.html;
          if (!(option.group && !this.group_search)) {
            option.search_match = this.search_string_match(option.search_text, regex);
            if (option.search_match && !option.group) {
              results += 1;
            }
            if (option.search_match) {
              if (searchText.length) {
                startpos = option.search_text.search(zregex);
                text = option.search_text.substr(0, startpos + searchText.length) + '</em>' + option.search_text.substr(startpos + searchText.length);
                option.search_text = text.substr(0, startpos) + '<em>' + text.substr(startpos);
              }
              if (results_group != null) {
                results_group.group_match = true;
              }
            } else if ((option.group_array_index != null) && this.results_data[option.group_array_index].search_match) {
              option.search_match = true;
            }
          }
        }
      }
      this.result_clear_highlight();
      if (results < 1 && searchText.length) {
        this.update_results_content("");
        return this.no_results(searchText);
      } else {
        this.update_results_content(this.results_option_build());
        return this.winnow_results_set_highlight();
      }
    };

    AbstractChosen.prototype.get_search_regex = function(escaped_search_string) {
      var regex_anchor;
      regex_anchor = this.search_contains ? "" : "^";
      return new RegExp(regex_anchor + escaped_search_string, 'i');
    };

    AbstractChosen.prototype.search_string_match = function(search_string, regex) {
      var part, parts, _i, _len;
      if (regex.test(search_string)) {
        return true;
      } else if (this.enable_split_word_search && (search_string.indexOf(" ") >= 0 || search_string.indexOf("[") === 0)) {
        parts = search_string.replace(/\[|\]/g, "").split(" ");
        if (parts.length) {
          for (_i = 0, _len = parts.length; _i < _len; _i++) {
            part = parts[_i];
            if (regex.test(part)) {
              return true;
            }
          }
        }
      }
    };

    AbstractChosen.prototype.choices_count = function() {
      var option, _i, _len, _ref;
      if (this.selected_option_count != null) {
        return this.selected_option_count;
      }
      this.selected_option_count = 0;
      _ref = this.form_field.options;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        option = _ref[_i];
        if (option.selected) {
          this.selected_option_count += 1;
        }
      }
      return this.selected_option_count;
    };

    AbstractChosen.prototype.choices_click = function(evt) {
      evt.preventDefault();
      if (!(this.results_showing || this.is_disabled)) {
        return this.results_show();
      }
    };

    AbstractChosen.prototype.keyup_checker = function(evt) {
      var stroke, _ref;
      stroke = (_ref = evt.which) != null ? _ref : evt.keyCode;
      this.search_field_scale();
      switch (stroke) {
        case 8:
          if (this.is_multiple && this.backstroke_length < 1 && this.choices_count() > 0) {
            return this.keydown_backstroke();
          } else if (!this.pending_backstroke) {
            this.result_clear_highlight();
            return this.results_search();
          }
          break;
        case 13:
          evt.preventDefault();
          if (this.results_showing) {
            return this.result_select(evt);
          }
          break;
        case 27:
          if (this.results_showing) {
            this.results_hide();
          }
          return true;
        case 9:
        case 38:
        case 40:
        case 16:
        case 91:
        case 17:
        case 18:
          break;
        default:
          return this.results_search();
      }
    };

    AbstractChosen.prototype.clipboard_event_checker = function(evt) {
      var _this = this;
      return setTimeout((function() {
        return _this.results_search();
      }), 50);
    };

    AbstractChosen.prototype.container_width = function() {
      if (this.options.width != null) {
        return this.options.width;
      } else {
        return "" + this.form_field.offsetWidth + "px";
      }
    };

    AbstractChosen.prototype.include_option_in_results = function(option) {
      if (this.is_multiple && (!this.display_selected_options && option.selected)) {
        return false;
      }
      if (!this.display_disabled_options && option.disabled) {
        return false;
      }
      if (option.empty) {
        return false;
      }
      return true;
    };

    AbstractChosen.prototype.search_results_touchstart = function(evt) {
      this.touch_started = true;
      return this.search_results_mouseover(evt);
    };

    AbstractChosen.prototype.search_results_touchmove = function(evt) {
      this.touch_started = false;
      return this.search_results_mouseout(evt);
    };

    AbstractChosen.prototype.search_results_touchend = function(evt) {
      if (this.touch_started) {
        return this.search_results_mouseup(evt);
      }
    };

    AbstractChosen.prototype.outerHTML = function(element) {
      var tmp;
      if (element.outerHTML) {
        return element.outerHTML;
      }
      tmp = document.createElement("div");
      tmp.appendChild(element);
      return tmp.innerHTML;
    };

    AbstractChosen.browser_is_supported = function() {
      if (/iP(od|hone)/i.test(window.navigator.userAgent)) {
        return false;
      }
      if (/Android/i.test(window.navigator.userAgent)) {
        if (/Mobile/i.test(window.navigator.userAgent)) {
          return false;
        }
      }
      if (/IEMobile/i.test(window.navigator.userAgent)) {
        return false;
      }
      if (/Windows Phone/i.test(window.navigator.userAgent)) {
        return false;
      }
      if (/BlackBerry/i.test(window.navigator.userAgent)) {
        return false;
      }
      if (/BB10/i.test(window.navigator.userAgent)) {
        return false;
      }
      if (window.navigator.appName === "Microsoft Internet Explorer") {
        return document.documentMode >= 8;
      }
      return true;
    };

    AbstractChosen.default_multiple_text = "Select Some Options";

    AbstractChosen.default_single_text = "Select an Option";

    AbstractChosen.default_no_result_text = "No results match";

    return AbstractChosen;

  })();

  $ = jQuery;

  $.fn.extend({
    chosen: function(options) {
      if (!AbstractChosen.browser_is_supported()) {
        return this;
      }
      return this.each(function(input_field) {
        var $this, chosen;
        $this = $(this);
        chosen = $this.data('chosen');
        if (options === 'destroy') {
          if (chosen instanceof Chosen) {
            chosen.destroy();
          }
          return;
        }
        if (!(chosen instanceof Chosen)) {
          $this.data('chosen', new Chosen(this, options));
        }
      });
    }
  });

  Chosen = (function(_super) {
    __extends(Chosen, _super);

    function Chosen() {
      _ref = Chosen.__super__.constructor.apply(this, arguments);
      return _ref;
    }

    Chosen.prototype.setup = function() {
      this.form_field_jq = $(this.form_field);
      this.current_selectedIndex = this.form_field.selectedIndex;
      return this.is_rtl = this.form_field_jq.hasClass("chosen-rtl");
    };

    Chosen.prototype.set_up_html = function() {
      var container_classes, container_props;
      container_classes = ["chosen-container"];
      container_classes.push("chosen-container-" + (this.is_multiple ? "multi" : "single"));
      if (this.inherit_select_classes && this.form_field.className) {
        container_classes.push(this.form_field.className);
      }
      if (this.is_rtl) {
        container_classes.push("chosen-rtl");
      }
      container_props = {
        'class': container_classes.join(' '),
        'style': "width: " + (this.container_width()) + ";",
        'title': this.form_field.title
      };
      if (this.form_field.id.length) {
        container_props.id = this.form_field.id.replace(/[^\w]/g, '_') + "_chosen";
      }
      this.container = $("<div />", container_props);
      if (this.is_multiple) {
        this.container.html('<ul class="chosen-choices"><li class="search-field"><input type="text" value="' + this.default_text + '" class="default" autocomplete="off" style="width:25px;" /></li></ul><div class="chosen-drop"><ul class="chosen-results"></ul></div>');
      } else {
        this.container.html('<a class="chosen-single chosen-default"><span>' + this.default_text + '</span><div><b></b></div></a><div class="chosen-drop"><div class="chosen-search"><input type="text" autocomplete="off" /></div><ul class="chosen-results"></ul></div>');
      }
      this.form_field_jq.hide().after(this.container);
      this.dropdown = this.container.find('div.chosen-drop').first();
      this.search_field = this.container.find('input').first();
      this.search_results = this.container.find('ul.chosen-results').first();
      this.search_field_scale();
      this.search_no_results = this.container.find('li.no-results').first();
      if (this.is_multiple) {
        this.search_choices = this.container.find('ul.chosen-choices').first();
        this.search_container = this.container.find('li.search-field').first();
      } else {
        this.search_container = this.container.find('div.chosen-search').first();
        this.selected_item = this.container.find('.chosen-single').first();
      }
      this.results_build();
      this.set_tab_index();
      return this.set_label_behavior();
    };

    Chosen.prototype.on_ready = function() {
      return this.form_field_jq.trigger("chosen:ready", {
        chosen: this
      });
    };

    Chosen.prototype.register_observers = function() {
      var _this = this;
      this.container.bind('touchstart.chosen', function(evt) {
        _this.container_mousedown(evt);
        return evt.preventDefault();
      });
      this.container.bind('touchend.chosen', function(evt) {
        _this.container_mouseup(evt);
        return evt.preventDefault();
      });
      this.container.bind('mousedown.chosen', function(evt) {
        _this.container_mousedown(evt);
      });
      this.container.bind('mouseup.chosen', function(evt) {
        _this.container_mouseup(evt);
      });
      this.container.bind('mouseenter.chosen', function(evt) {
        _this.mouse_enter(evt);
      });
      this.container.bind('mouseleave.chosen', function(evt) {
        _this.mouse_leave(evt);
      });
      this.search_results.bind('mouseup.chosen', function(evt) {
        _this.search_results_mouseup(evt);
      });
      this.search_results.bind('mouseover.chosen', function(evt) {
        _this.search_results_mouseover(evt);
      });
      this.search_results.bind('mouseout.chosen', function(evt) {
        _this.search_results_mouseout(evt);
      });
      this.search_results.bind('mousewheel.chosen DOMMouseScroll.chosen', function(evt) {
        _this.search_results_mousewheel(evt);
      });
      this.search_results.bind('touchstart.chosen', function(evt) {
        _this.search_results_touchstart(evt);
      });
      this.search_results.bind('touchmove.chosen', function(evt) {
        _this.search_results_touchmove(evt);
      });
      this.search_results.bind('touchend.chosen', function(evt) {
        _this.search_results_touchend(evt);
      });
      this.form_field_jq.bind("chosen:updated.chosen", function(evt) {
        _this.results_update_field(evt);
      });
      this.form_field_jq.bind("chosen:activate.chosen", function(evt) {
        _this.activate_field(evt);
      });
      this.form_field_jq.bind("chosen:open.chosen", function(evt) {
        _this.container_mousedown(evt);
      });
      this.form_field_jq.bind("chosen:close.chosen", function(evt) {
        _this.input_blur(evt);
      });
      this.search_field.bind('blur.chosen', function(evt) {
        _this.input_blur(evt);
      });
      this.search_field.bind('keyup.chosen', function(evt) {
        _this.keyup_checker(evt);
      });
      this.search_field.bind('keydown.chosen', function(evt) {
        _this.keydown_checker(evt);
      });
      this.search_field.bind('focus.chosen', function(evt) {
        _this.input_focus(evt);
      });
      this.search_field.bind('cut.chosen', function(evt) {
        _this.clipboard_event_checker(evt);
      });
      this.search_field.bind('paste.chosen', function(evt) {
        _this.clipboard_event_checker(evt);
      });
      if (this.is_multiple) {
        return this.search_choices.bind('click.chosen', function(evt) {
          _this.choices_click(evt);
        });
      } else {
        return this.container.bind('click.chosen', function(evt) {
          evt.preventDefault();
        });
      }
    };

    Chosen.prototype.destroy = function() {
      $(this.container[0].ownerDocument).unbind("click.chosen", this.click_test_action);
      if (this.search_field[0].tabIndex) {
        this.form_field_jq[0].tabIndex = this.search_field[0].tabIndex;
      }
      this.container.remove();
      this.form_field_jq.removeData('chosen');
      return this.form_field_jq.show();
    };

    Chosen.prototype.search_field_disabled = function() {
      this.is_disabled = this.form_field_jq[0].disabled;
      if (this.is_disabled) {
        this.container.addClass('chosen-disabled');
        this.search_field[0].disabled = true;
        if (!this.is_multiple) {
          this.selected_item.unbind("focus.chosen", this.activate_action);
        }
        return this.close_field();
      } else {
        this.container.removeClass('chosen-disabled');
        this.search_field[0].disabled = false;
        if (!this.is_multiple) {
          return this.selected_item.bind("focus.chosen", this.activate_action);
        }
      }
    };

    Chosen.prototype.container_mousedown = function(evt) {
      if (!this.is_disabled) {
        if (evt && evt.type === "mousedown" && !this.results_showing) {
          evt.preventDefault();
        }
        if (!((evt != null) && ($(evt.target)).hasClass("search-choice-close"))) {
          if (!this.active_field) {
            if (this.is_multiple) {
              this.search_field.val("");
            }
            $(this.container[0].ownerDocument).bind('click.chosen', this.click_test_action);
            this.results_show();
          } else if (!this.is_multiple && evt && (($(evt.target)[0] === this.selected_item[0]) || $(evt.target).parents("a.chosen-single").length)) {
            evt.preventDefault();
            this.results_toggle();
          }
          return this.activate_field();
        }
      }
    };

    Chosen.prototype.container_mouseup = function(evt) {
      if (evt.target.nodeName === "ABBR" && !this.is_disabled) {
        return this.results_reset(evt);
      }
    };

    Chosen.prototype.search_results_mousewheel = function(evt) {
      var delta;
      if (evt.originalEvent) {
        delta = evt.originalEvent.deltaY || -evt.originalEvent.wheelDelta || evt.originalEvent.detail;
      }
      if (delta != null) {
        evt.preventDefault();
        if (evt.type === 'DOMMouseScroll') {
          delta = delta * 40;
        }
        return this.search_results.scrollTop(delta + this.search_results.scrollTop());
      }
    };

    Chosen.prototype.blur_test = function(evt) {
      if (!this.active_field && this.container.hasClass("chosen-container-active")) {
        return this.close_field();
      }
    };

    Chosen.prototype.close_field = function() {
      $(this.container[0].ownerDocument).unbind("click.chosen", this.click_test_action);
      this.active_field = false;
      this.results_hide();
      this.container.removeClass("chosen-container-active");
      this.clear_backstroke();
      this.show_search_field_default();
      return this.search_field_scale();
    };

    Chosen.prototype.activate_field = function() {
      this.container.addClass("chosen-container-active");
      this.active_field = true;
      this.search_field.val(this.search_field.val());
      return this.search_field.focus();
    };

    Chosen.prototype.test_active_click = function(evt) {
      var active_container;
      active_container = $(evt.target).closest('.chosen-container');
      if (active_container.length && this.container[0] === active_container[0]) {
        return this.active_field = true;
      } else {
        return this.close_field();
      }
    };

    Chosen.prototype.results_build = function() {
      this.parsing = true;
      this.selected_option_count = null;
      this.results_data = SelectParser.select_to_array(this.form_field);
      if (this.is_multiple) {
        this.search_choices.find("li.search-choice").remove();
      } else if (!this.is_multiple) {
        this.single_set_selected_text();
        if (this.disable_search || this.form_field.options.length <= this.disable_search_threshold) {
          this.search_field[0].readOnly = true;
          this.container.addClass("chosen-container-single-nosearch");
        } else {
          this.search_field[0].readOnly = false;
          this.container.removeClass("chosen-container-single-nosearch");
        }
      }
      this.update_results_content(this.results_option_build({
        first: true
      }));
      this.search_field_disabled();
      this.show_search_field_default();
      this.search_field_scale();
      return this.parsing = false;
    };

    Chosen.prototype.result_do_highlight = function(el) {
      var high_bottom, high_top, maxHeight, visible_bottom, visible_top;
      if (el.length) {
        this.result_clear_highlight();
        this.result_highlight = el;
        this.result_highlight.addClass("highlighted");
        maxHeight = parseInt(this.search_results.css("maxHeight"), 10);
        visible_top = this.search_results.scrollTop();
        visible_bottom = maxHeight + visible_top;
        high_top = this.result_highlight.position().top + this.search_results.scrollTop();
        high_bottom = high_top + this.result_highlight.outerHeight();
        if (high_bottom >= visible_bottom) {
          return this.search_results.scrollTop((high_bottom - maxHeight) > 0 ? high_bottom - maxHeight : 0);
        } else if (high_top < visible_top) {
          return this.search_results.scrollTop(high_top);
        }
      }
    };

    Chosen.prototype.result_clear_highlight = function() {
      if (this.result_highlight) {
        this.result_highlight.removeClass("highlighted");
      }
      return this.result_highlight = null;
    };

    Chosen.prototype.results_show = function() {
      if (this.is_multiple && this.max_selected_options <= this.choices_count()) {
        this.form_field_jq.trigger("chosen:maxselected", {
          chosen: this
        });
        return false;
      }
      this.container.addClass("chosen-with-drop");
      this.results_showing = true;
      this.search_field.focus();
      this.search_field.val(this.search_field.val());
      this.winnow_results();
      return this.form_field_jq.trigger("chosen:showing_dropdown", {
        chosen: this
      });
    };

    Chosen.prototype.update_results_content = function(content) {
      return this.search_results.html(content);
    };

    Chosen.prototype.results_hide = function() {
      if (this.results_showing) {
        this.result_clear_highlight();
        this.container.removeClass("chosen-with-drop");
        this.form_field_jq.trigger("chosen:hiding_dropdown", {
          chosen: this
        });
      }
      return this.results_showing = false;
    };

    Chosen.prototype.set_tab_index = function(el) {
      var ti;
      if (this.form_field.tabIndex) {
        ti = this.form_field.tabIndex;
        this.form_field.tabIndex = -1;
        return this.search_field[0].tabIndex = ti;
      }
    };

    Chosen.prototype.set_label_behavior = function() {
      var _this = this;
      this.form_field_label = this.form_field_jq.parents("label");
      if (!this.form_field_label.length && this.form_field.id.length) {
        this.form_field_label = $("label[for='" + this.form_field.id + "']");
      }
      if (this.form_field_label.length > 0) {
        return this.form_field_label.bind('click.chosen', function(evt) {
          if (_this.is_multiple) {
            return _this.container_mousedown(evt);
          } else {
            return _this.activate_field();
          }
        });
      }
    };

    Chosen.prototype.show_search_field_default = function() {
      if (this.is_multiple && this.choices_count() < 1 && !this.active_field) {
        this.search_field.val(this.default_text);
        return this.search_field.addClass("default");
      } else {
        this.search_field.val("");
        return this.search_field.removeClass("default");
      }
    };

    Chosen.prototype.search_results_mouseup = function(evt) {
      var target;
      target = $(evt.target).hasClass("active-result") ? $(evt.target) : $(evt.target).parents(".active-result").first();
      if (target.length) {
        this.result_highlight = target;
        this.result_select(evt);
        return this.search_field.focus();
      }
    };

    Chosen.prototype.search_results_mouseover = function(evt) {
      var target;
      target = $(evt.target).hasClass("active-result") ? $(evt.target) : $(evt.target).parents(".active-result").first();
      if (target) {
        return this.result_do_highlight(target);
      }
    };

    Chosen.prototype.search_results_mouseout = function(evt) {
      if ($(evt.target).hasClass("active-result" || $(evt.target).parents('.active-result').first())) {
        return this.result_clear_highlight();
      }
    };

    Chosen.prototype.choice_build = function(item) {
      var choice, close_link,
        _this = this;
      choice = $('<li />', {
        "class": "search-choice"
      }).html("<span>" + (this.choice_label(item)) + "</span>");
      if (item.disabled) {
        choice.addClass('search-choice-disabled');
      } else {
        close_link = $('<a />', {
          "class": 'search-choice-close',
          'data-option-array-index': item.array_index
        });
        close_link.bind('click.chosen', function(evt) {
          return _this.choice_destroy_link_click(evt);
        });
        choice.append(close_link);
      }
      return this.search_container.before(choice);
    };

    Chosen.prototype.choice_destroy_link_click = function(evt) {
      evt.preventDefault();
      evt.stopPropagation();
      if (!this.is_disabled) {
        return this.choice_destroy($(evt.target));
      }
    };

    Chosen.prototype.choice_destroy = function(link) {
      if (this.result_deselect(link[0].getAttribute("data-option-array-index"))) {
        this.show_search_field_default();
        if (this.is_multiple && this.choices_count() > 0 && this.search_field.val().length < 1) {
          this.results_hide();
        }
        link.parents('li').first().remove();
        return this.search_field_scale();
      }
    };

    Chosen.prototype.results_reset = function() {
      this.reset_single_select_options();
      this.form_field.options[0].selected = true;
      this.single_set_selected_text();
      this.show_search_field_default();
      this.results_reset_cleanup();
      this.form_field_jq.trigger("change");
      if (this.active_field) {
        return this.results_hide();
      }
    };

    Chosen.prototype.results_reset_cleanup = function() {
      this.current_selectedIndex = this.form_field.selectedIndex;
      return this.selected_item.find("abbr").remove();
    };

    Chosen.prototype.result_select = function(evt) {
      var high, item;
      if (this.result_highlight) {
        high = this.result_highlight;
        this.result_clear_highlight();
        if (this.is_multiple && this.max_selected_options <= this.choices_count()) {
          this.form_field_jq.trigger("chosen:maxselected", {
            chosen: this
          });
          return false;
        }
        if (this.is_multiple) {
          high.removeClass("active-result");
        } else {
          this.reset_single_select_options();
        }
        high.addClass("result-selected");
        item = this.results_data[high[0].getAttribute("data-option-array-index")];
        item.selected = true;
        this.form_field.options[item.options_index].selected = true;
        this.selected_option_count = null;
        if (this.is_multiple) {
          this.choice_build(item);
        } else {
          this.single_set_selected_text(this.choice_label(item));
        }
        if (!((evt.metaKey || evt.ctrlKey) && this.is_multiple)) {
          this.results_hide();
        }
        this.show_search_field_default();
        if (this.is_multiple || this.form_field.selectedIndex !== this.current_selectedIndex) {
          this.form_field_jq.trigger("change", {
            'selected': this.form_field.options[item.options_index].value
          });
        }
        this.current_selectedIndex = this.form_field.selectedIndex;
        evt.preventDefault();
        return this.search_field_scale();
      }
    };

    Chosen.prototype.single_set_selected_text = function(text) {
      if (text == null) {
        text = this.default_text;
      }
      if (text === this.default_text) {
        this.selected_item.addClass("chosen-default");
      } else {
        this.single_deselect_control_build();
        this.selected_item.removeClass("chosen-default");
      }
      return this.selected_item.find("span").html(text);
    };

    Chosen.prototype.result_deselect = function(pos) {
      var result_data;
      result_data = this.results_data[pos];
      if (!this.form_field.options[result_data.options_index].disabled) {
        result_data.selected = false;
        this.form_field.options[result_data.options_index].selected = false;
        this.selected_option_count = null;
        this.result_clear_highlight();
        if (this.results_showing) {
          this.winnow_results();
        }
        this.form_field_jq.trigger("change", {
          deselected: this.form_field.options[result_data.options_index].value
        });
        this.search_field_scale();
        return true;
      } else {
        return false;
      }
    };

    Chosen.prototype.single_deselect_control_build = function() {
      if (!this.allow_single_deselect) {
        return;
      }
      if (!this.selected_item.find("abbr").length) {
        this.selected_item.find("span").first().after("<abbr class=\"search-choice-close\"></abbr>");
      }
      return this.selected_item.addClass("chosen-single-with-deselect");
    };

    Chosen.prototype.get_search_text = function() {
      return $('<div/>').text($.trim(this.search_field.val())).html();
    };

    Chosen.prototype.winnow_results_set_highlight = function() {
      var do_high, selected_results;
      selected_results = !this.is_multiple ? this.search_results.find(".result-selected.active-result") : [];
      do_high = selected_results.length ? selected_results.first() : this.search_results.find(".active-result").first();
      if (do_high != null) {
        return this.result_do_highlight(do_high);
      }
    };

    Chosen.prototype.no_results = function(terms) {
      var no_results_html;
      no_results_html = $('<li class="no-results">' + this.results_none_found + ' "<span></span>"</li>');
      no_results_html.find("span").first().html(terms);
      this.search_results.append(no_results_html);
      return this.form_field_jq.trigger("chosen:no_results", {
        chosen: this
      });
    };

    Chosen.prototype.no_results_clear = function() {
      return this.search_results.find(".no-results").remove();
    };

    Chosen.prototype.keydown_arrow = function() {
      var next_sib;
      if (this.results_showing && this.result_highlight) {
        next_sib = this.result_highlight.nextAll("li.active-result").first();
        if (next_sib) {
          return this.result_do_highlight(next_sib);
        }
      } else {
        return this.results_show();
      }
    };

    Chosen.prototype.keyup_arrow = function() {
      var prev_sibs;
      if (!this.results_showing && !this.is_multiple) {
        return this.results_show();
      } else if (this.result_highlight) {
        prev_sibs = this.result_highlight.prevAll("li.active-result");
        if (prev_sibs.length) {
          return this.result_do_highlight(prev_sibs.first());
        } else {
          if (this.choices_count() > 0) {
            this.results_hide();
          }
          return this.result_clear_highlight();
        }
      }
    };

    Chosen.prototype.keydown_backstroke = function() {
      var next_available_destroy;
      if (this.pending_backstroke) {
        this.choice_destroy(this.pending_backstroke.find("a").first());
        return this.clear_backstroke();
      } else {
        next_available_destroy = this.search_container.siblings("li.search-choice").last();
        if (next_available_destroy.length && !next_available_destroy.hasClass("search-choice-disabled")) {
          this.pending_backstroke = next_available_destroy;
          if (this.single_backstroke_delete) {
            return this.keydown_backstroke();
          } else {
            return this.pending_backstroke.addClass("search-choice-focus");
          }
        }
      }
    };

    Chosen.prototype.clear_backstroke = function() {
      if (this.pending_backstroke) {
        this.pending_backstroke.removeClass("search-choice-focus");
      }
      return this.pending_backstroke = null;
    };

    Chosen.prototype.keydown_checker = function(evt) {
      var stroke, _ref1;
      stroke = (_ref1 = evt.which) != null ? _ref1 : evt.keyCode;
      this.search_field_scale();
      if (stroke !== 8 && this.pending_backstroke) {
        this.clear_backstroke();
      }
      switch (stroke) {
        case 8:
          this.backstroke_length = this.search_field.val().length;
          break;
        case 9:
          if (this.results_showing && !this.is_multiple) {
            this.result_select(evt);
          }
          this.mouse_on_container = false;
          break;
        case 13:
          if (this.results_showing) {
            evt.preventDefault();
          }
          break;
        case 32:
          if (this.disable_search) {
            evt.preventDefault();
          }
          break;
        case 38:
          evt.preventDefault();
          this.keyup_arrow();
          break;
        case 40:
          evt.preventDefault();
          this.keydown_arrow();
          break;
      }
    };

    Chosen.prototype.search_field_scale = function() {
      var div, f_width, h, style, style_block, styles, w, _i, _len;
      if (this.is_multiple) {
        h = 0;
        w = 0;
        style_block = "position:absolute; left: -1000px; top: -1000px; display:none;";
        styles = ['font-size', 'font-style', 'font-weight', 'font-family', 'line-height', 'text-transform', 'letter-spacing'];
        for (_i = 0, _len = styles.length; _i < _len; _i++) {
          style = styles[_i];
          style_block += style + ":" + this.search_field.css(style) + ";";
        }
        div = $('<div />', {
          'style': style_block
        });
        div.text(this.search_field.val());
        $('body').append(div);
        w = div.width() + 25;
        div.remove();
        f_width = this.container.outerWidth();
        if (w > f_width - 10) {
          w = f_width - 10;
        }
        return this.search_field.css({
          'width': w + 'px'
        });
      }
    };

    return Chosen;

  })(AbstractChosen);

}).call(this);


  }).apply(root, arguments);
});
}(this));

(function(root) {
define("angular-chosen", ["angular","jquery-chosen"], function() {
  return (function() {
/**
 * angular-chosen-localytics - Angular Chosen directive is an AngularJS Directive that brings the Chosen jQuery in a Angular way
 * @version v1.3.0
 * @link http://github.com/leocaseiro/angular-chosen
 * @license MIT
 */
(function() {
  var indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  angular.module('localytics.directives', []);

  angular.module('localytics.directives').directive('chosen', [
    '$timeout', function($timeout) {
      var CHOSEN_OPTION_WHITELIST, NG_OPTIONS_REGEXP, isEmpty, snakeCase;
      NG_OPTIONS_REGEXP = /^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+group\s+by\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w]*)|(?:\(\s*([\$\w][\$\w]*)\s*,\s*([\$\w][\$\w]*)\s*\)))\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?$/;
      CHOSEN_OPTION_WHITELIST = ['persistentCreateOption', 'createOptionText', 'createOption', 'skipNoResults', 'noResultsText', 'allowSingleDeselect', 'disableSearchThreshold', 'disableSearch', 'enableSplitWordSearch', 'inheritSelectClasses', 'maxSelectedOptions', 'placeholderTextMultiple', 'placeholderTextSingle', 'searchContains', 'singleBackstrokeDelete', 'displayDisabledOptions', 'displaySelectedOptions', 'width', 'includeGroupLabelInSelected', 'maxShownResults'];
      snakeCase = function(input) {
        return input.replace(/[A-Z]/g, function($1) {
          return "_" + ($1.toLowerCase());
        });
      };
      isEmpty = function(value) {
        var key;
        if (angular.isArray(value)) {
          return value.length === 0;
        } else if (angular.isObject(value)) {
          for (key in value) {
            if (value.hasOwnProperty(key)) {
              return false;
            }
          }
        }
        return true;
      };
      return {
        restrict: 'A',
        require: '?ngModel',
        priority: 1,
        link: function(scope, element, attr, ngModel) {
          var chosen, empty, initOrUpdate, match, options, origRender, startLoading, stopLoading, updateMessage, valuesExpr, viewWatch;
          scope.disabledValuesHistory = scope.disabledValuesHistory ? scope.disabledValuesHistory : [];
          element = $(element);
          element.addClass('localytics-chosen');
          options = scope.$eval(attr.chosen) || {};
          angular.forEach(attr, function(value, key) {
            if (indexOf.call(CHOSEN_OPTION_WHITELIST, key) >= 0) {
              return attr.$observe(key, function(value) {
                options[snakeCase(key)] = String(element.attr(attr.$attr[key])).slice(0, 2) === '{{' ? value : scope.$eval(value);
                return updateMessage();
              });
            }
          });
          startLoading = function() {
            return element.addClass('loading').attr('disabled', true).trigger('chosen:updated');
          };
          stopLoading = function() {
            element.removeClass('loading');
            if (angular.isDefined(attr.disabled)) {
              element.attr('disabled', attr.disabled);
            } else {
              element.attr('disabled', false);
            }
            return element.trigger('chosen:updated');
          };
          chosen = null;
          empty = false;
          initOrUpdate = function() {
            var defaultText;
            if (chosen) {
              return element.trigger('chosen:updated');
            } else {
              $timeout(function() {
                chosen = element.chosen(options).data('chosen');
              });
              if (angular.isObject(chosen)) {
                return defaultText = chosen.default_text;
              }
            }
          };
          updateMessage = function() {
            if (empty) {
              element.attr('data-placeholder', chosen.results_none_found).attr('disabled', true);
            } else {
              element.removeAttr('data-placeholder');
            }
            return element.trigger('chosen:updated');
          };
          if (ngModel) {
            origRender = ngModel.$render;
            ngModel.$render = function() {
              origRender();
              return initOrUpdate();
            };
            element.on('chosen:hiding_dropdown', function() {
              return scope.$apply(function() {
                return ngModel.$setTouched();
              });
            });
            if (attr.multiple) {
              viewWatch = function() {
                return ngModel.$viewValue;
              };
              scope.$watch(viewWatch, ngModel.$render, true);
            }
          } else {
            initOrUpdate();
          }
          attr.$observe('disabled', function() {
            return element.trigger('chosen:updated');
          });
          if (attr.ngOptions && ngModel) {
            match = attr.ngOptions.match(NG_OPTIONS_REGEXP);
            valuesExpr = match[7];
            scope.$watchCollection(valuesExpr, function(newVal, oldVal) {
              var timer;
              return timer = $timeout(function() {
                if (angular.isUndefined(newVal)) {
                  return startLoading();
                } else {
                  empty = isEmpty(newVal);
                  stopLoading();
                  return updateMessage();
                }
              });
            });
            return scope.$on('$destroy', function(event) {
              if (typeof timer !== "undefined" && timer !== null) {
                return $timeout.cancel(timer);
              }
            });
          }
        }
      };
    }
  ]);

}).call(this);


  }).apply(root, arguments);
});
}(this));

/*
# tools/directives/draggableDirective.js        Copyright(c) 2022 cPanel, L.L.C.
#                                                           All rights reserved.
# copyright@cpanel.net                                         http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited
*/

/* global define: false */

define(
    'app/directives/draggableDirective',[
        "angular",
    ],
    function(angular) {
        "use strict";

        // Retrieve the current application
        var app;
        try {
            app = angular.module("App"); // For runtime
        } catch (e) {
            app = angular.module("App", []); // Fall-back for unit testing
        }

        /**
         * Directive that adds HTML5 draggable functionality to DOM objects
         */
        app.directive("draggable", [ function() {
            return {
                restrict: "A",
                scope: {
                    drag: "&",
                    dragEnd: "&",
                },
                link: function(scope, element) {

                    var dragElement = element[0];
                    dragElement.draggable = true;

                    dragElement.addEventListener("dragstart", function(e) {
                        e.dataTransfer.effectAllowed = "move";
                        e.dataTransfer.setData("text", this.id);
                        angular.element(this).addClass("drag");

                        var element = this;
                        scope.$apply(function(scope) {
                            var action = scope.drag();
                            if ( angular.isDefined(action) ) {
                                action(element.id);
                            }
                        });
                        return false;
                    }, false);

                    dragElement.addEventListener("dragend", function() {
                        angular.element(this).removeClass("drag");

                        var element = this;
                        scope.$apply(function(scope) {
                            var action = scope.dragEnd();
                            if ( angular.isDefined(action) ) {
                                action(element.id);
                            }
                        });

                        return false;
                    }, false);
                },
            };
        }]);
    }
);

/*
# tools/directives/dropDirective.js             Copyright(c) 2022 cPanel, L.L.C.
#                                                           All rights reserved.
# copyright@cpanel.net                                         http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited
*/

/* global define: false */

define(
    'app/directives/dropDirective',[
        "angular",
    ],
    function(angular) {
        "use strict";

        // Retrieve the current application
        var app;
        try {
            app = angular.module("App"); // For runtime
        } catch (e) {
            app = angular.module("App", []); // Fall-back for unit testing
        }

        /**
         * Directive that adds HTML5 drop functionality to DOM objects
         */
        app.directive("dropArea", [ function() {
            return {
                scope: {
                    drop: "&",
                },
                link: function(scope, element) {
                    var dropAreaElement = element[0];
                    dropAreaElement.addEventListener("dragover", function(e) {
                        e.dataTransfer.dropEffect = "move";
                        if (e.preventDefault) {
                            e.preventDefault();
                        }
                        angular.element(this).addClass("drag-over");
                        return false;
                    }, false);

                    dropAreaElement.addEventListener("dragenter", function() {
                        angular.element(this).addClass("drag-over");
                        return false;
                    }, false);

                    dropAreaElement.addEventListener("dragleave", function() {
                        angular.element(this).removeClass("drag-over");
                        return false;
                    }, false);

                    dropAreaElement.addEventListener("drop", function(e) {
                        if (e.stopPropagation) {
                            e.stopPropagation();
                        }
                        if (e.preventDefault) {
                            e.preventDefault();
                        }
                        angular.element(this).removeClass("drag-over");

                        var dropTarget = this,
                            element = document.getElementById(e.dataTransfer.getData("text"));

                        scope.$apply(function(scope) {
                            var action = scope.drop();
                            if ( angular.isDefined(action) ) {
                                action(element, dropTarget);
                            }
                        });
                        return false;
                    }, false);
                },
            };
        }]);
    }
);

// Copyright 2023 cPanel, L.L.C. - All rights reserved.
// copyright@cpanel.net
// https://cpanel.net
// This code is subject to the cPanel license. Unauthorized copying is prohibited

define(
    'app/views/applicationListController',[
        "angular",
        "lodash",
        "cjt/util/locale",
        "cjt/services/cpanel/nvDataService",

        // application related
        "app/directives/draggableDirective",
        "app/directives/dropDirective",
    ],
    function(angular, _, LOCALE) {

        "use strict";

        // Retrieve the current application
        var app = angular.module("App");

        var controller = app.controller(
            "applicationListController", ["$scope", "nvDataService",
                function($scope, nvDataService) {

                    var applicationList = PAGE.appGroups;
                    var collapsedGroupsList = PAGE.collapsedGroups.split("|");

                    // Binding it to the scope so that
                    $scope.collapsedGroups = PAGE.collapsedGroups;

                    /* Updating the searchText model with the value in
                     * search Field if typed before angular bootstrap.
                     * Hack to ensure delayed search is preformed on the
                     * text in the search box, if user types in before angular
                     * bootstrap completes
                     */
                    var searchBox = document.querySelector("#quickjump");
                    if (searchBox && $scope.searchText !== searchBox.value) {
                        $scope.searchText = searchBox.value;
                    }

                    init();

                    function init() {
                        trackAppLinkClicks();
                    }

                    function trackAppLinkClicks() {
                        var querySelForAppLinks = "#boxes [id*='-container'] > [id*='-group'] > [id*='-body'] > .icon-container-body > a";
                        var appLinkEls = document.querySelectorAll(querySelForAppLinks);

                        if (appLinkEls && appLinkEls.length && window["mixpanel"]) {
                            window["mixpanel"].track_links(appLinkEls, "cPanel-Tools-Nav-Link", (linkEl) => {
                                return { "nav-link-id": linkEl.id };
                            });
                        }
                    }

                    /**
                    * Clears search on Esc
                    *
                    * @method clearSearch
                    * @param {Event} event Event
                    */
                    $scope.clearSearch = function(event) {

                        // clear the search when pressing the Esc key
                        if (event.keyCode === 27) {
                            $scope.searchText = "";
                        }
                    };

                    var searchCache = {};

                    /**
                    * Search Groups
                    *
                    * @method searchGroup
                    * @param {Object} group Group
                    * @return {Boolean}  If the group needs to be displayed
                    */
                    $scope.searchGroup = function(group) {
                        if (!$scope.searchText) {
                            return 1;
                        }
                        if (!searchCache[$scope.searchText]) {
                            searchCache[$scope.searchText] = new RegExp($scope.searchText, "i");
                        }
                        var regex = searchCache[$scope.searchText];
                        var found = false;

                        var groupInfo = _.find(applicationList, function(app) {
                            return app.group === group;
                        });

                        var items = groupInfo.length ? groupInfo.items : [];

                        for (var i = 0, len = items.length; i < len; i++) {
                            found = regex.test(items[i].searchtext);
                            if (found) {
                                return found;
                            }
                        }
                    };

                    /**
                    * Search Item
                    *
                    * @method searchItem
                    * @param {Object} Item Item
                    * @return {Boolean} If the item searchtext matches the searchtext
                    */
                    $scope.searchItem = function(item) {
                        if (!$scope.searchText) {
                            return 1;
                        }
                        if (!searchCache[$scope.searchText]) {
                            searchCache[$scope.searchText] = new RegExp($scope.searchText, "i");
                        }
                        var regex = searchCache[$scope.searchText];

                        return regex.test(item.searchtext);
                    };

                    /**
                     * Sends the ordered list of application groups to the server to retain
                     * user preferences in the page's NVData object
                     * @param {String} groups - The | delimited list of group order
                     */
                    var setGroupsOrder = function(groups) {
                        nvDataService.setObject(
                            {
                                xmaingroupsorder: groups,
                            })
                            .catch(function(error) {
                                console.error(error);
                            });
                    };

                    /**
                     * Sends the list of collapsed menu groups to the server to retain
                     * user preferences in the page's NVData object
                     * @param {String} groups - The | delimited list of collapsed menu groups
                     */
                    var setCollapsedGroupsList = function(groups) {
                        nvDataService.setObject(
                            {
                                xmainrollstatus: groups,
                            })
                            .catch(function(error) {
                                console.error(error);
                            });
                    };

                    /**
                    * Toggles group and saves state in NvData
                    *
                    * @method toggleGroup
                    * @param {Object} group Group
                    */
                    $scope.toggleGroup = function(group) {
                        var groupBody = angular.element(document.querySelector("#" + group + "-body"));
                        var groupCollapseIndicator = angular.element(document.querySelector("#" + group + "-collapsed-indicator"));

                        group = group + "=0";

                        var index = collapsedGroupsList.indexOf(group);
                        if (index === -1) {
                            groupBody.removeClass("maximize");
                            collapsedGroupsList.push(group);
                            groupBody.addClass("minimized ng-hide");

                            groupCollapseIndicator.removeClass("fa-minus");
                            groupCollapseIndicator.addClass("fa-plus");
                        } else {
                            groupBody.removeClass("minimized ng-hide");
                            collapsedGroupsList.splice(index, 1);
                            groupBody.addClass("maximize");

                            groupCollapseIndicator.removeClass("fa-plus");
                            groupCollapseIndicator.addClass("fa-minus");
                        }

                        var groupList = collapsedGroupsList.join("|");

                        // updating the collapseGroups model with new changes
                        $scope.collapsedGroups = groupList;

                        // Save the changes to NvData
                        setCollapsedGroupsList(groupList);
                    };

                    /**
                    * Handles drag event
                    *
                    * @method handleDrag
                    * @param {String} itemID ID of the item thats being dragged.
                    */
                    $scope.handleDrag = function(itemID) {
                        var groupName = itemID.replace("-group", ""),
                            groupBody = angular.element(document.querySelector("#" + groupName + "-body"));

                        groupBody.removeClass("minimize maximize");

                        var startingPosition = _.findIndex(applicationList, function(group) {
                            return group.group === groupName;
                        });

                        var previousDropAreaId = "#top-drop-area";
                        if (startingPosition > 0) {
                            previousDropAreaId = "#" + applicationList[startingPosition - 1].group + "-drop-area";
                        }

                        // Hidding the DropArea of the group right above the item being moved. We dont want to
                        // drop the group in the same place
                        var hiddenDropArea = angular.element(document.querySelector(previousDropAreaId));
                        hiddenDropArea.addClass("drag-hidden");
                    };

                    /**
                    * Handles the case when a drag event is started but the item is never dropped into a dropArea
                    *
                    * @method handleDragEnd
                    */
                    $scope.handleDragEnd = function() {
                        var hiddenDropArea = angular.element(document.querySelectorAll(".drag-hidden"));

                        // On DragEnd ensures none of the dragAreas are hidden
                        hiddenDropArea.removeClass("drag-hidden");
                    };

                    /**
                    * Handles the drop of group in dropArea
                    *
                    * @method handleDrop
                    * @param {Object} item The item thats being moved
                    * @param {Object} dropArea The area where the item is dropped
                    */
                    $scope.handleDrop = function(item, dropArea) {

                        var groupToMove = item.getAttribute("data-group-name");
                        var moveAfter = dropArea.getAttribute("data-group-name");

                        var boxes = document.querySelector("#boxes");
                        var groupToMoveContainer, moveAfterContainer;

                        if (moveAfter) {
                            groupToMoveContainer = document.querySelector("#" + groupToMove + "-container");
                            moveAfterContainer = document.querySelector("#" + moveAfter + "-container");
                        } else {
                            groupToMoveContainer = document.querySelector("#" + groupToMove + "-container");
                            moveAfterContainer = document.querySelector("#top-drop-area");
                        }

                        // Moving DOM elements
                        if (boxes && groupToMoveContainer && moveAfterContainer) {
                            boxes.insertBefore(groupToMoveContainer, moveAfterContainer.nextSibling);
                        }

                        var oldPosition = _.findIndex(applicationList, function(group) {
                            return group.group === item.id.replace("-group", "");
                        });

                        var movedGroup = applicationList[oldPosition];
                        var newPosition = _.findIndex(applicationList, function(group) {
                            return group.group === dropArea.id.replace("-drop-area", "");
                        });

                        if (oldPosition > newPosition) {
                            newPosition += 1;
                        }

                        applicationList.splice(oldPosition, 1);
                        applicationList.splice(newPosition, 0, movedGroup);

                        var newOrder = _.map(applicationList, "group").join("|");
                        setGroupsOrder(newOrder);

                    };
                },
            ]);

        return controller;
    }
);

/*
 * tools/services/statisticsService.js           Copyright(c) 2022 cPanel, L.L.C.
 *                                                           All rights reserved.
 * copyright@cpanel.net                                         http://cpanel.net
 * This code is subject to the cPanel license. Unauthorized copying is prohibited
 */

/* global define: false */

define(
    'app/services/statisticsService',[

        // Libraries
        "lodash",
        "angular",
        "cjt/io/uapi-request",
        "cjt/services/APICatcher",
    ],
    function(_, angular, APIREQUEST) {
        "use strict";

        // Fetch the current application
        var app = angular.module("App");

        /**
         * Setup the account list model's API service
         */
        app.factory("statisticsService", ["APICatcher",
            function(api) {

                var idsToShowWarningsInGlass = ["disk_usage", "cachedmysqldiskusage", "bandwidth"];

                function _mungeData(data) {
                    for (var i = 0; i < data.length; i++) {
                        var item = data[i];

                        item.maximum = item.maximum && parseInt( item.maximum, 10 );

                        var isLimited = (item.maximum !== null);
                        var percent = isLimited ? parseFloat((100 * item.usage / item.maximum).toFixed(2)) : 0;

                        var isWarningShown = false;
                        var isActionButtonShown = false;

                        if (percent >= 80) {
                            isActionButtonShown = true;
                            if (idsToShowWarningsInGlass.includes(item.id)) {
                                isWarningShown = true;
                            }
                        }

                        _.assign(
                            item,
                            {
                                isLimited: isLimited,
                                percent: percent,
                                needFix: percent >= 60,
                                showWarning: isWarningShown,
                                showActionButton: isActionButtonShown,
                            }
                        );
                    }

                    return data;
                }

                // return the factory interface
                return {

                    /**
                     * Get extended stats.
                     * @return {Promise} - Promise that will fulfill the request.
                     */
                    fetchExtendedStats: function() {
                        var apicall = new APIREQUEST.Class().initialize("ResourceUsage", "get_usages");
                        return api.promise(apicall).then( function(resp) {
                            _mungeData(resp.data);
                            return resp.data;
                        } );
                    },
                };
            },
        ]);
    }
);

/*
 * tools/views/statisticsController.js           Copyright(c) 2022 cPanel, L.L.C.
 *                                                           All rights reserved.
 * copyright@cpanel.net                                         http://cpanel.net
 * This code is subject to the cPanel license. Unauthorized copying is prohibited
 */

/* global define: false */

define(
    'app/views/statisticsController',[
        "lodash",
        "angular",
        "cjt/util/locale",
        "app/services/statisticsService",
        "cjt/directives/spinnerDirective",
        "cjt/decorators/growlDecorator",
        "cjt/decorators/growlAPIReporter",
    ],
    function(_, angular, LOCALE) {
        "use strict";

        var USE_BYTES = {
            format_bytes: true,
            format_bytes_per_second: true, // for CloudLinux
        };

        function _massageStatsDataForDisplay(data) {
            for (var i = 0; i < data.length; i++) {
                var item = data[i];

                var isBytes = !!USE_BYTES[item.formatter];

                var formattedUsage = isBytes ? LOCALE.format_bytes(item.usage) : LOCALE.numf(item.usage);

                var formattedMax = null;
                if (item.formatter === "format_bytes_per_second") {
                    formattedUsage += "/s";

                    // Leave formattedMax null for the unlimited per-second items.
                    if (item.isLimited) {
                        formattedMax = LOCALE.format_bytes(item.maximum) + "/s";
                    }
                } else {
                    formattedMax = !item.isLimited ? "∞" : isBytes ? LOCALE.format_bytes(item.maximum) : LOCALE.numf(item.maximum);
                }

                var warningMessage = null;
                if (item.showWarning) {
                    if (item.percent >= 100) {
                        warningMessage = LOCALE.maketext("[_1] limit exceeded.", item.description);
                    } else {
                        warningMessage = LOCALE.maketext("[_1] is nearing its limit.", item.description);
                    }
                }

                _.assign(
                    item,
                    {
                        showPercent: !!(item.isLimited && item.maximum),
                        formattedPercent: LOCALE.numf(item.percent),
                        formattedMaximum: formattedMax,
                        formattedUsage: formattedUsage,
                        warningTooltip: warningMessage,
                    }
                );
            }

            return data;
        }

        // Retrieve the current application
        var app = angular.module("App");

        var controller = app.controller(
            "statisticsController", [
                "$scope",
                "spinnerAPI",
                "statisticsService",
                "growl",
                "$timeout",
                function(
                    $scope,
                    spinnerAPI,
                    statisticsService,
                    growl,
                    $timeout) {

                    spinnerAPI.start("loadingStatsSpinner");

                    /** We are running into browser limits on the number of
                     *  concurrent HTTP connections. We want these AJAX
                     *  calls to be low priority so that CSS/sprites/etc.
                     *  will load first; otherwise, the UI takes longer to
                     *  be usable.
                     *
                     *  We need to reduce the number of concurrent
                     *  HTTP calls, but for now this stop-gap will
                     *  ensure that AJAX post-back calls don’t delay the
                     *  loading of critical UI resources.
                     */
                    $timeout(function() {
                        statisticsService.fetchExtendedStats().then(function(response) {
                            $scope.statistics = _massageStatsDataForDisplay(response);
                        }).finally(function() {
                            spinnerAPI.stop("loadingStatsSpinner");
                        });
                    });

                    $scope.appUpgradeUrl = PAGE.appUpgradeUrl && ((PAGE.dprefix || "") + PAGE.appUpgradeUrl);

                    $scope.getStatStatus = function(percentage, error) {

                        if (error) {
                            return "warning";
                        }

                        if (percentage >= 80) {
                            return "danger";
                        }

                        if (percentage >= 60) {
                            return "warning";
                        }

                        if (percentage >= 40) {
                            return "info";
                        }

                        if (percentage >= 0) {
                            return "success";
                        }
                    };

                    /**
                     * Used to determine the class of an element based on the percentage of quota usage.
                     * @param {number} percentage - amount of quota used.
                     * @returns {string} bootstrap class to style an element.
                     */
                    $scope.glassGetStatStatus = function(percentage) {
                        if (percentage >= 100) {
                            return "danger";
                        }

                        if (percentage >= 80) {
                            return "warning";
                        }
                    };
                },
            ]);

        return controller;
    }
);

/*
 * tools/services/themesService.js               Copyright(c) 2022 cPanel, L.L.C.
 *                                                           All rights reserved.
 * copyright@cpanel.net                                         http://cpanel.net
 * This code is subject to the cPanel license. Unauthorized copying is prohibited
 */

/* global define: false */

define(
    'app/services/themesService',[

        // Libraries
        "angular",

        // CJT
        "cjt/io/api",
        "cjt/io/uapi-request",
        "cjt/io/uapi", // IMPORTANT: Load the driver so its ready
    ],
    function(angular, API, APIREQUEST, APIDRIVER) {

        // Fetch the current application
        var app = angular.module("App");

        /**
         * Setup the account list model's API service
         */
        app.factory("themesService", ["$q",
            function($q) {

                // return the factory interface
                return {

                    /**
                     * Get available themes list
                     * @return {Promise} - Promise that will fulfill the request.
                     */
                    getAvailableThemes: function() {

                        // make a promise
                        var deferred = $q.defer();

                        var apiCall = new APIREQUEST.Class();

                        apiCall.initialize("Themes", "list", {
                            show_mail_themes: 0,
                        });

                        API.promise(apiCall.getRunArguments())
                            .done(function(response) {

                                // Create items from the response
                                response = response.parsedResponse;
                                if (response.status) {

                                    // Keep the promise
                                    deferred.resolve(response.data);
                                } else {

                                    // Pass the error along
                                    deferred.reject(response.error);
                                }
                            });

                        // Pass the promise back to the controller
                        return deferred.promise;
                    },

                    /**
                     * Set theme
                     * @param {String} theme - Theme Name
                     * @return {Promise} - Promise that will fulfill the request
                    **/
                    setTheme: function(themeName) {

                        var deferred = $q.defer();

                        var apiCall = new APIREQUEST.Class();

                        apiCall.initialize("Themes", "update", {
                            theme: themeName,
                        });

                        API.promise(apiCall.getRunArguments())
                            .done(function(response) {

                                // Create items from the response
                                response = response.parsedResponse;
                                if (response.status) {

                                    // Keep the promise
                                    deferred.resolve(response.data);
                                } else {

                                    // Pass the error along
                                    deferred.reject(response.error);
                                }
                            });

                        // pass the promise back to the controller
                        return deferred.promise;
                    },
                };
            },
        ]);
    }
);

/*
 * tools/views/themesController.js               Copyright(c) 2022 cPanel, L.L.C.
 *                                                           All rights reserved.
 * copyright@cpanel.net                                         http://cpanel.net
 * This code is subject to the cPanel license. Unauthorized copying is prohibited
 */

/* global define: false, PAGE: true */

define(
    'app/views/themesController',[
        "angular",
        "jquery",
        "app/services/themesService",
        "cjt/decorators/growlDecorator",
        "jquery-chosen",
        "angular-chosen",
    ],
    function(angular) {
        "use strict";

        // Retrieve the current application
        var app = angular.module("App");

        var controller = app.controller(
            "themesController", [
                "$scope",
                "$window",
                "themesService",
                "growl",
                "$timeout",
                function(
                    $scope,
                    $window,
                    themesService,
                    growl,
                    $timeout) {

                    $scope.isRTL = PAGE.isRTL || false;
                    $scope.updated = true;

                    /** We are running into browser limits on the number of
                     *  concurrent HTTP connections. We want these AJAX
                     *  calls to be low priority so that CSS/sprites/etc.
                     *  will load first; otherwise, the UI takes longer to
                     *  be usable.
                     *
                     *  We need to reduce the number of concurrent
                     *  HTTP calls, but for now this stop-gap will
                     *  ensure that AJAX post-back calls don’t delay the
                     *  loading of critical UI resources.
                     */
                    $timeout(function() {
                        themesService.getAvailableThemes().then(function(response) {
                            if (response && response.length > 0) {

                                $scope.themes = response;

                                // selects current theme
                                if (PAGE.currentTheme) {
                                    $scope.selectedTheme = PAGE.currentTheme;
                                }
                            }
                        }, function(error) {
                            growl.error(error);
                        }).finally(function() {
                            $scope.updated = true;
                        });
                    });

                    /**
                     * Set theme of the account
                     * Note: Transfers the page
                     */
                    $scope.themeChanged = function() {
                        if ($scope.selectedTheme !== "") {
                            themesService.setTheme($scope.selectedTheme).then(function() {
                                if (PAGE && PAGE.securityToken && PAGE.userName) {
                                    $window.location.href = PAGE.securityToken + "/xfercpanel/" + PAGE.userName + "?theme=" + $scope.selectedTheme;
                                }
                            }).catch(function(err) {
                                growl.error(err);
                            });
                        }
                    };
                },
            ]);

        return controller;
    }
);

/*
# cpanel - base/frontend/jupiter/tools/services/nginxService.js
#                                                  Copyright 2022 cPanel, L.L.C.
#                                                           All rights reserved.
# copyright@cpanel.net                                         http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited
*/

define(
    'app/services/nginxService',[

        // Libraries
        "angular",

        // CJT
        "cjt/io/api",
        "cjt/io/uapi-request",
        "cjt/io/uapi", // IMPORTANT: Load the driver so its ready
        "cjt/services/APICatcher",
    ],
    function(angular, API, APIREQUEST, APIDRIVER) {
        "use strict";

        // Fetch the current application
        var app = angular.module("cpanel.tools.service.nginxService", []);

        /**
         * Setup the account list model's API service
         */
        app.factory("nginxService", ["$q", "APICatcher",
            function($q, apiCatcher) {

                // return the factory interface
                return {

                    /**
                     * Clear NGINX caching for the cPanel user.
                     * @return {Promise} - Promise that will fulfill the request.
                     */
                    clearCache: function() {
                        var apiCall = new APIREQUEST.Class();

                        apiCall.initialize("NginxCaching", "clear_cache", {});
                        return apiCatcher.promise(apiCall);
                    },

                    /**
                     * Enable NGINX caching for the cPanel user.
                     * @return {Promise} - Promise that will fulfill the request.
                     */
                    enableCaching: function() {
                        var apiCall = new APIREQUEST.Class();

                        apiCall.initialize("NginxCaching", "enable_cache", {});
                        return apiCatcher.promise(apiCall);
                    },

                    /**
                     * Disable NGINX caching for the cPanel user.
                     * @return {Promise} - Promise that will fulfill the request.
                     */
                    disableCaching: function() {
                        var apiCall = new APIREQUEST.Class();

                        apiCall.initialize("NginxCaching", "disable_cache", {});
                        return apiCatcher.promise(apiCall);
                    },
                };
            },
        ]);
    }
);

/*
# cpanel - base/frontend/jupiter/tools/views/nginxController.js
#                                                  Copyright 2022 cPanel, L.L.C.
#                                                           All rights reserved.
# copyright@cpanel.net                                         http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited
*/

define(
    'app/views/nginxController',[
        "angular",
        "cjt/util/locale",
        "jquery",

        // CJT
        "cjt/services/alertService",
        "cjt/directives/alert",
        "cjt/directives/alertList",
        "app/services/nginxService",
    ],
    function(angular, LOCALE) {
        "use strict";

        // Retrieve the current application
        var app = angular.module("App");

        var controller = app.controller(
            "nginxController", [
                "$scope",
                "alertService",
                "nginxService",
                function(
                    $scope,
                    alertService,
                    nginxService) {

                    $scope.isRTL = PAGE.isRTL || false;
                    $scope.nginxCachingIsEnabled = PAGE.isNginxCachingEnabled || false;

                    $scope.nginxClearCache = function() {
                        return nginxService.clearCache().then(function() {
                            alertService.add({
                                type: "success",
                                message: LOCALE.maketext("NGINX cache cleared."),
                                closeable: true,
                                replace: true,
                                autoClose: 10000,
                            });
                        });
                    };

                    $scope.toggleNginxCachingStatus = function() {
                        if ($scope.nginxCachingIsEnabled) {
                            return nginxService.disableCaching().then(function() {
                                $scope.nginxCachingIsEnabled = false;
                                alertService.add({
                                    type: "success",
                                    message: LOCALE.maketext("[asis,NGINX] cache is inactive."),
                                    closeable: true,
                                    replace: true,
                                    autoClose: 10000,
                                });
                            });
                        } else {
                            return nginxService.enableCaching().then(function() {
                                $scope.nginxCachingIsEnabled = true;
                                alertService.add({
                                    type: "success",
                                    message: LOCALE.maketext("[asis,NGINX] cache is active."),
                                    closeable: true,
                                    replace: true,
                                    autoClose: 10000,
                                });
                            });
                        }
                    };

                    $scope.showClearCacheButton = function() {
                        if ($scope.nginxCachingIsEnabled) {
                            return "ng-show";
                        } else {
                            return "ng-hide";
                        }
                    };
                },
            ]);

        return controller;
    }
);

/*
 * tools/services/accountsService.js             Copyright(c) 2022 cPanel, L.L.C.
 *                                                           All rights reserved.
 * copyright@cpanel.net                                         http://cpanel.net
 * This code is subject to the cPanel license. Unauthorized copying is prohibited
 */

/* global define: false */

define(
    'app/services/accountsService',[

        // Libraries
        "angular",

        // CJT
        "cjt/io/api",
        "cjt/io/uapi-request",
        "cjt/io/uapi", // IMPORTANT: Load the driver so its ready
    ],
    function(angular, API, APIREQUEST, APIDRIVER) {

        // Fetch the current application
        var app = angular.module("App");

        /**
         * Setup the account list model's API service
         */
        app.factory("accountsService", ["$q",
            function($q) {

                // return the factory interface
                return {

                    /**
                     * Get available accounts list
                     * @param {Boolean} [isRTL] - Optional flag denoting that the interface is in RTL
                     * @return {Promise} - Promise that will fulfill the request.
                     */
                    getAvailableAccounts: function(isRTL) {

                        // make a promise
                        var deferred = $q.defer();

                        var apiCall = new APIREQUEST.Class();

                        apiCall.initialize("Resellers", "list_accounts");

                        API.promise(apiCall.getRunArguments())
                            .done(function(response) {

                                // Create items from the response
                                response = response.parsedResponse;
                                if (response.status) {

                                    // set RTL friendly account label
                                    isRTL = isRTL || false;
                                    var currentAccount;
                                    for (var i = 0, length = response.data.length; i < length; i++) {
                                        currentAccount = response.data[i];
                                        if ( isRTL ) {
                                            currentAccount.accountLabel = "\u200e(" + currentAccount.domain + ") " + currentAccount.user;
                                        } else {
                                            currentAccount.accountLabel = currentAccount.user + " (" + currentAccount.domain + ")";
                                        }
                                    }

                                    // Keep the promise
                                    deferred.resolve(response.data);
                                } else {

                                    // Pass the error along
                                    deferred.reject(response.error);
                                }
                            });

                        // Pass the promise back to the controller
                        return deferred.promise;
                    },
                };
            },
        ]);
    }
);

/*
 * tools/views/accountsController.js             Copyright(c) 2022 cPanel, L.L.C.
 *                                                           All rights reserved.
 * copyright@cpanel.net                                         http://cpanel.net
 * This code is subject to the cPanel license. Unauthorized copying is prohibited
 */

/* global define: false, PAGE: true */

define(
    'app/views/accountsController',[
        "angular",
        "lodash",
        "jquery",
        "app/services/accountsService",
        "cjt/decorators/growlDecorator",
        "jquery-chosen",
        "angular-chosen",
    ],
    function(angular, _) {
        "use strict";

        // Retrieve the current application
        var app = angular.module("App");

        var controller = app.controller(
            "accountsController", [
                "$scope",
                "$window",
                "accountsService",
                "growl",
                "$timeout",
                function(
                    $scope,
                    $window,
                    accountsService,
                    growl,
                    $timeout) {

                    $scope.isRTL = PAGE.isRTL || false;
                    $scope.updated = true;

                    /** We are running into browser limits on the number of
                     *  concurrent HTTP connections. We want these AJAX
                     *  calls to be low priority so that CSS/sprites/etc.
                     *  will load first; otherwise, the UI takes longer to
                     *  be usable.
                     *
                     *  We need to reduce the number of concurrent
                     *  HTTP calls, but for now this stop-gap will
                     *  ensure that AJAX post-back calls don’t delay the
                     *  loading of critical UI resources.
                     */
                    $timeout(function() {
                        accountsService.getAvailableAccounts($scope.isRTL).then(function(response) {
                            if (response && response.length >= 1) {
                                $scope.accounts = response;

                                // helps select current user
                                if (PAGE.userName) {
                                    $scope.selectedAccount = _.find(response, ["user", PAGE.userName]);
                                }
                            }
                        }, function(error) {
                            growl.error(error);
                        }).finally(function() {
                            $scope.updated = true;
                        });
                    });

                    /**
                     * Switches Account
                     * Note: Transfers the page
                     */
                    $scope.accountChanged = function() {
                        if ($scope.selectedAccount && PAGE && PAGE.securityToken) {
                            $window.location.href = PAGE.securityToken + "/xfercpanel/" + $scope.selectedAccount.user;
                        }
                    };
                },
            ]);

        return controller;
    }
);

/*
# cpanel - base/frontend/jupiter/tools/services/wordPressService.js
#                                                  Copyright 2022 cPanel, L.L.C.
#                                                           All rights reserved.
# copyright@cpanel.net                                         http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited
*/

define(
    'app/services/wordPressService',[

        // Libraries
        "angular",

        // CJT
        "cjt/io/api",
        "cjt/io/uapi-request",
        "cjt/io/uapi", // IMPORTANT: Load the driver so its ready
        "cjt/services/APICatcher",
    ],
    function(angular, API, APIREQUEST) {
        "use strict";

        // Fetch the current application
        var app = angular.module("cpanel.tools.service.wordPressService", []);

        /**
         * Setup the WordPress polling service.
         */
        app.factory("wordPressService", ["$q", "APICatcher",
            function($q, apiCatcher) {

                // return the factory interface
                return {
                    startPolling: function() {
                        var apiCall = new APIREQUEST.Class();

                        apiCall.initialize("WordPressSite", "retrieve", {});
                        return apiCatcher.promise(apiCall);
                    },
                };
            },
        ]);
    }
);

/*
# cpanel - base/frontend/jupiter/tools/index.js     Copyright 2022 cPanel, L.L.C.
#                                                           All rights reserved.
# copyright@cpanel.net                                         http://cpanel.net
# This code is subject to the cPanel license. Unauthorized copying is prohibited
*/

define(
    'app/index',[
        "angular",
        "cjt/core",
        "cjt/modules",
        "ngSanitize",
        "cjt/modules",
        "app/views/sslStatus",
        "uiBootstrap",
        "angular-chosen",
        "cjt/services/alertService",
    ],
    function(angular, CJT) {

        "use strict";

        return function() {

            // First create the application
            angular.module("App", ["ngSanitize", "ui.bootstrap", "cjt2.cpanel", "angular-growl", "localytics.directives", "cpanel.tools.views.sslStatus", "cpanel.tools.service.nginxService", "cpanel.tools.service.wordPressService"]);

            // Then load the application dependencies
            var app = require(
                [

                    // Application Modules
                    "cjt/bootstrap",
                    "cjt/util/locale",
                    "app/views/applicationListController",
                    "app/views/statisticsController",
                    "app/views/themesController",
                    "app/views/nginxController",
                    "app/views/accountsController",
                    "app/services/wordPressService",
                ], function(BOOTSTRAP, LOCALE) {
                    var app = angular.module("App");
                    app.value("PAGE", PAGE);

                    app.config(["$httpProvider", function($httpProvider) {
                        $httpProvider.useApplyAsync(true);
                    }]);
                    app.run(["wordPressService", "alertService", "PAGE", "$rootScope", function(wordPressService, alertService, PAGE, $rootScope) {

                        // This event comes from the welcome modal web component.
                        document.addEventListener("wordPressInstallPoll", function() {
                            $rootScope.$apply(function() {
                                alertService.add({
                                    type: "info",
                                    message: LOCALE.maketext("Your WordPress site is being created."),
                                    closeable: true,
                                    replace: true,
                                });
                                pollForWordPressInstall();
                            });
                        });

                        function pollForWordPressInstall() {

                            // Let the users know the install is continuing
                            var pollingIntervalId;
                            pollingIntervalId = setInterval(function() {
                                wordPressService.startPolling().then(function(uapiResponse) {
                                    if (uapiResponse.data.install_status === "success") {
                                        clearInterval(pollingIntervalId);
                                        pollingIntervalId = null;
                                        alertService.add({
                                            type: "success",
                                            message: LOCALE.maketext("Your website is ready. Start adding content and personalizing “[output,strong,_1]” using [output,url,_2,WP Toolkit,title,WP Toolkit interface].", PAGE.domain, PAGE.wpToolkitUrl),
                                            closeable: true,
                                            replace: true,
                                            autoClose: 10000,
                                        });
                                    }
                                })
                                    .catch(function(errors) {
                                        clearInterval(pollingIntervalId);
                                        pollingIntervalId = null;
                                        alertService.add({
                                            type: "danger",
                                            message: LOCALE.maketext("Something went wrong. Your website failed to create. Try creating your website manually using [output,url,_1,WP Toolkit,title,WP Toolkit interface].", PAGE.wpToolkitUrl),
                                            closeable: true,
                                            replace: true,
                                        });
                                    });
                            }, 5000);
                        }

                        // Account UUID copy event handler.
                        var copyUuidLinkEl = document.getElementById("linkCopyUuid");
                        var copyUuidIconEl = document.getElementById("iconCopyUuid");
                        copyUuidLinkEl.addEventListener("click", copyUuidHandler);
                        copyUuidIconEl.addEventListener("click", copyUuidHandler);

                        function copyUuidHandler() {

                            var uuidTxtEl = document.getElementById("txtAcctUuid");
                            var copyMsgEl = document.getElementById("copyMsgContainer");
                            const copyText = uuidTxtEl.textContent;

                            navigator.clipboard
                                .writeText(copyText)
                                .then(() => {
                                    copyMsgEl.classList.add("show-copy-success");
                                    window.setTimeout(function() {
                                        copyMsgEl.classList.remove("show-copy-success");
                                    }, 3000);
                                },
                                (err) => {
                                    console.error(err);
                                });


                        }
                    }]);
                    BOOTSTRAP("#content", "App");
                });
            return app;
        };
    }
);

