define("app/directives/issueList",["angular","cjt/util/locale"],(function(e,i){e.module("App").directive("cpIssueList",[function(){var t=0;return{templateUrl:"directives/issueList.phtml",scope:{issues:"=",idPrefix:"@"},link:function(s,n,r){if(e.isDefined(s.issues)&&!e.isArray(s.issues))throw new TypeError("The issues attribute should evaluate to an array of issue objects.");s.$watch("idPrefix",(function(e){e||0===e||(s.idPrefix=t++)})),s.getIssueTitle=function(e){if(e.title)return e.title;if("quota"!==e.area)return"error"===e.type?i.maketext("Error:"):i.maketext("Warning:");switch(e.service){case"email":return"error"===e.type?i.maketext("Mail Quota Reached:"):i.maketext("Mail Quota Warning:");case"ftp":return"error"===e.type?i.maketext("[asis,FTP] Quota Reached:"):i.maketext("[asis,FTP] Quota Warning:")}}}}}])})),define("app/directives/modelToLowerCase",["angular"],(function(e){e.module("App").directive("modelToLowerCase",[function(){return{restrict:"A",require:"ngModel",link:function(e,i,t,s){s.$parsers.unshift((function(e){return e.toLocaleLowerCase()}))}}}])})),define("app/services/userService",["angular","lodash","jquery","cjt/util/locale","cjt/io/api","cjt/io/uapi-request","cjt/io/uapi","cjt/util/parse","cjt/util/flatObject","cjt/services/APIService"],(function(e,i,t,s,n,r,a,o,u){var l;e.module("App").factory("userService",["$q","APIService","emailDaemonInfo","ftpDaemonInfo","webdiskDaemonInfo","features","defaultInfo",function(n,a,c,d,m,f,p){var v={email:{supports:{serviceRunning:c.enabled,allowed:f.email,createable:f.email&&c.enabled,editable:f.email,deletable:f.email,viewable:!0},name:"email"},ftp:{supports:{serviceRunning:d.enabled,allowed:f.ftp,createable:f.ftp&&d.enabled,editable:f.ftp,deletable:f.ftp,viewable:!0},name:"ftp"},webdisk:{supports:{serviceRunning:m.enabled,allowed:f.webdisk,createable:f.webdisk&&m.enabled,editable:f.webdisk,deletable:f.webdisk,viewable:!0},name:"webdisk"}};function g(e){e.ui={},e.typeLabel=h[e.type]}var h={service:s.maketext("Service Account"),hypothetical:s.maketext("Hypothetical Subaccount"),sub:s.maketext("Subaccount"),cpanel:s.maketext("cPanel Account")},w={ftp:s.maketext("FTP"),email:s.maketext("Email"),webdisk:s.maketext("Web Disk")};function b(e){var i=[];return e.services.email.enabled&&i.push("email"),e.services.ftp.enabled&&i.push("ftp"),e.services.webdisk.enabled&&i.push("webdisk webdav"),i.join(" ")}function _(e){return e.service?e.full_username+":"+e.service:e.full_username+":"+e.type}function k(t,s){t.enabled=o.parsePerlBoolean(t.enabled),t.isNew=!t.enabled,i.extend(t,i.cloneDeep(s)),e.isString(t.quota)&&(t.quota=o.parseInteger(t.quota)),e.isUndefined(t.enabledigest)||(t.enabledigest=o.parsePerlBoolean(t.enabledigest))}function y(t){var s=i.keys(t.services);if(i.each(s,(function(e){k(t.services[e],v[e])})),t.can_delete=o.parsePerlBoolean(t.can_delete),t.can_set_quota=o.parsePerlBoolean(t.can_set_quota),t.can_set_password=o.parsePerlBoolean(t.can_set_password),t.special=o.parsePerlBoolean(t.special),t.synced_password=o.parsePerlBoolean(t.synced_password),t.sub_account_exists=o.parsePerlBoolean(t.sub_account_exists),t.has_siblings=o.parsePerlBoolean(t.has_siblings),t.dismissed=o.parsePerlBoolean(t.dismissed),t.has_invite=o.parsePerlBoolean(t.has_invite),t.has_expired_invite=o.parsePerlBoolean(t.has_expired_invite),t.typeLabel=h[t.type],"hypothetical"===t.type||"sub"===t.type){t.candidate_issues_count=0,t.serviceSearch=[],t.dismissed_merge_candidates&&t.dismissed_merge_candidates.forEach((function(i){e.forEach(i.services,(function(e,t){k(e,v[t]),e.enabled&&(i.service=t)}))}));for(var n=0,r=t.merge_candidates.length;n<r;n++){var a=t.merge_candidates[n];for(var u in a.can_delete=o.parsePerlBoolean(a.can_delete),a.can_set_quota=o.parsePerlBoolean(a.can_set_quota),a.can_set_password=o.parsePerlBoolean(a.can_set_password),a.sub_account_exists=o.parsePerlBoolean(a.sub_account_exists),a.has_siblings=o.parsePerlBoolean(a.has_siblings),a.dismissed=o.parsePerlBoolean(a.dismissed),a.services)a.services.hasOwnProperty(u)&&(k(a.services[u],v[u]),a.services[u].enabled&&(t.services[u].enabledInCandidate=!0,a.service=u));a.issues.length>0&&t.candidate_issues_count++,a.typeLabel=h[a.type],a.serviceLabel=w[a.service],a.serviceSearch=b(a),t.serviceSearch.push(a.serviceSearch),a.guid=_(a)}}else"service"===t.type&&s.some((function(e){if(t.services[e].enabled)return t.service=e,!0}));return null===t.guid&&(t.guid=_(t)),t.serviceSearch?(t.serviceSearch.push(b(t)),t.serviceSearch=t.serviceSearch.join(" ")):t.serviceSearch=b(t),g(t),t.merge_candidates&&t.merge_candidates.forEach(g),t}function S(e,i,t){return Object.keys(i).some((function(s){if(i[s].enabled)return e[s]=i[s],e[s].isCandidate=!0,t&&(e[s].isDismissed=!0),!0})),e}function A(e,i){var t={};return e.merge_candidates.forEach((function(e){S(t,e.services)})),i&&e.dismissed_merge_candidates.forEach((function(e){S(t,e.services,!0)})),t}function C(e){var i=[];if(e.data){for(var t=e.data,s=0,n=t.length;s<n;s++){var r=y(t[s]);i.push(r)}return{items:i,totalItems:e.meta&&e.meta.paginate&&e.meta.paginate.is_paged?e.meta.paginate.total_records:t.length}}return{items:[],totalItems:0}}var D=["can_delete","can_set_quota","can_set_password","candidate_issues_count","issues","serviceSearch","merge_candidates","special","synced_password","sub_account_exists","has_siblings","parent_type","dismissed","dismissed_merge_candidates","has_invite","has_expired_invite","name","isNew"];function L(){return{username:"",domain:"",real_name:"",alternate_email:"",phone_number:"",avatar_url:"",services:{email:{name:v.name,enabled:!1,isNew:!0,quota:p.email.default_value,quotaUnit:"MB",supports:v.email.supports},ftp:{name:v.name,enabled:!1,isNew:!0,quota:p.ftp.default_value,quotaUnit:"MB",homedir:"public_html/",supports:v.ftp.supports},webdisk:{name:v.name,enabled:!1,isNew:!0,homedir:"public_html/",perms:"rw",supports:v.webdisk.supports,enabledigest:!1}}}}function I(e){var i=L();return t.extend(!0,i,e),i.services.ftp.enabled||(i.services.ftp.homedir+=i.domain+"/"+i.username),i.services.webdisk.enabled||(i.services.webdisk.homedir+=i.domain+"/"+i.username),i}var x=function(){};return x.prototype=new a,e.extend(x.prototype,{emptyUser:L,backfillUser:I,fetchList:function(e,i){i=i||{};var t=new r.Class;return t.initialize("UserManager","list_users"),t.addArgument("flat",e?1:0),i.sortBy&&(i.sortDirection=i.sortDirection||"asc",t.addSorting(i.sortBy,i.sortDirection,i.sortType)),this.deferred(t,{transformAPISuccess:C}).promise},fetchUser:function(e){var i=new r.Class;return i.initialize("UserManager","lookup_user"),i.addArgument("guid",e),this.deferred(i,{transformAPISuccess:function(e){return e.data=I(y(e.data)),e.data.candidate_services=A(e.data,!0),e.data}}).promise},fetchService:function(e,i){var t=new r.Class;return t.initialize("UserManager","lookup_service_account"),t.addArgument("type",e),t.addArgument("full_username",i),this.deferred(t,{transformAPISuccess:function(e){return I(y(e.data))}}).promise},delete:function(e){var i,t;"sub"===e.type?((i=new r.Class).initialize("UserManager","delete_user"),i.addArgument("username",e.username),i.addArgument("domain",e.domain),t=this.deferred(i,{transformAPISuccess:function(e){return e.data&&(e.data=y(e.data)),e}}).promise):"service"===e.type?e.services.email.enabled?((i=new r.Class).initialize("Email","delete_pop"),i.addArgument("email",e.full_username),t=this.deferred(i).promise):e.services.ftp.enabled?((i=new r.Class).initialize("Ftp","delete_ftp"),i.addArgument("user",e.full_username),i.addArgument("destroy",0),t=this.deferred(i).promise):e.services.webdisk.enabled?((i=new r.Class).initialize("WebDisk","delete_user"),i.addArgument("user",e.full_username),i.addArgument("destroy",0),t=this.deferred(i).promise):t=n((function(i,t){t(s.maketext("The system could not determine the service type for the “[_1]” service account.",e.full_username))})):t=n((function(i,t){t(s.maketext("The system could not delete the “[_1]” account. You cannot delete the “[_2]” account type.",e.full_username,e.type))}));return t},linkAndDismiss:function(i,t){var s,a,o=[],u=[];e.forEach(t||i.services,(function(e,i){if(e.isCandidate){if(e.willLink&&e.willDismiss)throw"Developer Error: You cannot link and dismiss the same service account.";e.willLink?u.push(i):e.willDismiss&&o.push(i)}}));var l=[];u.length&&((s=new r.Class).initialize("UserManager","merge_service_account"),s.addArgument("username",i.username),s.addArgument("domain",i.domain),u.forEach((function(e){s.addArgument("services."+e+".merge",1)})),a=this.deferred(s,{transformAPISuccess:function(e){return y(e.data)},transformAPIFailure:function(e){return{error:e.error,call:"link"}}}).promise,l.push(a)),o.length&&((s=new r.Class).initialize("UserManager","dismiss_merge"),s.addArgument("username",i.username),s.addArgument("domain",i.domain),o.forEach((function(e){s.addArgument("services."+e+".dismiss",1)})),a=this.deferred(s,{transformAPISuccess:function(e){return e.data},transformAPIFailure:function(e){return{error:e.error,call:"link"}}}).promise,l.push(a));var c=this;return n.all(l).then((function(e){return e.length?c.fetchUser(i.guid).then((function(e){return e.dismissed_services=o,e.linked_services=u,e})):i})).catch((function(e){return n((function(t,s){c.fetchUser(i.guid).then((function(i){e.user=i,s(e)}))}))}))},create:function(e){var i=new r.Class;i.initialize("UserManager","create_user"),i.addArgument("username",e.username),i.addArgument("domain",e.domain),i.addArgument("real_name",e.fullName),i.addArgument("alternate_email",e.recoveryEmail),e.sendInvite?i.addArgument("send_invite",1):i.addArgument("password",e.password),f.email&&!e.services.email.isCandidate&&(i.addArgument("services.email.enabled",e.services.email.enabled?1:0),i.addArgument("services.email.quota",e.services.email.quota)),f.ftp&&!e.services.ftp.isCandidate&&(i.addArgument("services.ftp.enabled",e.services.ftp.enabled?1:0),d.supports.quota&&i.addArgument("services.ftp.quota",e.services.ftp.quota),i.addArgument("services.ftp.homedir",e.services.ftp.homedir)),f.webdisk&&!e.services.webdisk.isCandidate&&(i.addArgument("services.webdisk.enabled",e.services.webdisk.enabled?1:0),i.addArgument("services.webdisk.homedir",e.services.webdisk.homedir),i.addArgument("services.webdisk.perms",e.services.webdisk.perms),i.addArgument("services.webdisk.enabledigest",e.services.webdisk.enabledigest?1:0));var t=this;return this.deferred(i,{transformAPISuccess:function(e){return y(e.data)}}).promise.then((function(i){return t.linkAndDismiss(i,e.services)}))},edit:function(t){var s=new r.Class;s.initialize("UserManager","edit_user");var n=function(t){var s=JSON.parse(JSON.stringify(t));D.forEach((function(e){delete s[e]}));var n=i.keys(s.services);return i.each(n,(function(i){s.services[i].isCandidate?delete s.services[i]:(s.services[i].enabled=s.services[i].enabled?1:0,e.isUndefined(s.services[i].enabledigest)||(s.services[i].enabledigest=s.services[i].enabledigest?1:0),delete s.services[i].supports)})),u.flatten(s)}(t);for(var a in n)n.hasOwnProperty(a)&&s.addArgument(a,n[a]);return this.deferred(s,{transformAPISuccess:function(e){return y(e.data)}}).promise},editService:function(e,i){var t,a,o=[];return e.services.email.enabled?(e.services.email.quota!==i.quota&&((t=new r.Class).initialize("Email","edit_pop_quota"),t.addArgument("email",e.username),t.addArgument("domain",e.domain),t.addArgument("quota",e.services.email.quota),a=this.deferred(t).promise,o.push(a)),e.password&&((t=new r.Class).initialize("Email","passwd_pop"),t.addArgument("email",e.username),t.addArgument("domain",e.domain),t.addArgument("password",e.password),a=this.deferred(t).promise,o.push(a))):e.services.ftp.enabled?(e.services.ftp.quota!==i.quota&&((t=new r.Class).initialize("Ftp","set_quota"),t.addArgument("user",e.username),t.addArgument("domain",e.domain),t.addArgument("quota",e.services.ftp.quota),a=this.deferred(t).promise,o.push(a)),e.services.ftp.homedir!==i.homedir&&((t=new r.Class).initialize("Ftp","set_homedir"),t.addArgument("user",e.username),t.addArgument("domain",e.domain),t.addArgument("homedir",e.services.ftp.homedir),a=this.deferred(t).promise,o.push(a)),e.password&&((t=new r.Class).initialize("Ftp","passwd"),t.addArgument("user",e.username),t.addArgument("domain",e.domain),t.addArgument("pass",e.password),a=this.deferred(t).promise,o.push(a))):e.services.webdisk.enabled?(e.services.webdisk.homedir!==i.homedir&&((t=new r.Class).initialize("WebDisk","set_homedir"),t.addArgument("user",e.full_username),t.addArgument("homedir",e.services.webdisk.homedir),a=this.deferred(t).promise,o.push(a)),e.services.webdisk.perms!==i.perms&&((t=new r.Class).initialize("WebDisk","set_permissions"),t.addArgument("user",e.full_username),t.addArgument("perms",e.services.webdisk.perms),a=this.deferred(t).promise,o.push(a)),e.password&&((t=new r.Class).initialize("WebDisk","set_password"),t.addArgument("user",e.full_username),t.addArgument("password",e.password),t.addArgument("enabledigest",e.services.webdisk.enabledigest?1:0),a=this.deferred(t).promise,o.push(a)),e.password||e.services.webdisk.enabledigest===i.enabledigest||(t=new r.Class)):(a=n((function(i,t){t(s.maketext("The system detected an unknown service for the “[_1]” service account.",e.full_username))})),o.push(a)),n.all(o)},prepareList:function(e){if(e.status)return C(e);throw e.errors},link:function(e,i,t){var s=new r.Class;if(s.initialize("UserManager","merge_service_account"),s.addArgument("username",e.username),s.addArgument("domain",e.domain),i)(e.services[i].enabled||t)&&s.addArgument("services."+i+".merge",1);else for(var n in e.services)e.services.hasOwnProperty(n)&&e.services[n].enabled&&s.addArgument("services."+n+".merge",1);return this.deferred(s,{transformAPISuccess:function(e){return y(e.data)}}).promise},unlink:function(e,i){var t=new r.Class;return t.initialize("UserManager","unlink_service_account"),t.addArgument("username",e.username),t.addArgument("domain",e.domain),t.addArgument("service",i),t.addArgument("dismiss",!0),this.deferred(t,{transformAPISuccess:C}).promise},linkAll:function(e){var i=new r.Class;i.initialize("UserManager","merge_service_account"),i.addArgument("username",e.username),i.addArgument("domain",e.domain);for(var t=0,s=e.merge_candidates.length;t<s;t++){var n=e.merge_candidates[t];for(var a in n.services)if(n.services.hasOwnProperty(a)&&n.services[a].enabled){var o="services."+a+".merge";i.addArgument(o,!0)}}return this.deferred(i,{transformAPISuccess:function(e){return y(e.data)}}).promise},dismissLink:function(e){var i=new r.Class;for(var t in i.initialize("UserManager","dismiss_merge"),i.addArgument("username",e.username),i.addArgument("domain",e.domain),e.services)if(e.services.hasOwnProperty(t)&&e.services[t].enabled){var s="services."+t+".dismiss";i.addArgument(s,!0)}return this.deferred(i,{transformAPISuccess:function(e){return e.data}}).promise},dismissAll:function(e){var i=new r.Class;i.initialize("UserManager","dismiss_merge"),i.addArgument("username",e.username),i.addArgument("domain",e.domain);for(var t=0,s=e.merge_candidates.length;t<s;t++){var n=e.merge_candidates[t];for(var a in n.services)if(n.services.hasOwnProperty(a)&&n.services[a].enabled){var o="services."+a+".dismiss";i.addArgument(o,!0)}}return this.deferred(i,{transformAPISuccess:function(e){return e.data}}).promise},checkAccountConflicts:function(e){l&&l.abort();var i=new r.Class;i.initialize("UserManager","check_account_conflicts"),i.addArgument("full_username",e);var t=this.deferred(i,{transformAPISuccess:function(e){return e.data.accounts&&(e.data.accounts=y(e.data.accounts),e.data.accounts.candidate_services=A(e.data.accounts,!0)),e.data}});return n((function(e,i){t.promise.then((function(t){t.conflict?i(s.maketext("The username is not available.")):e(t)}),(function(e){i(s.maketext("The system failed to determine whether the username is available: [_1]",e))}))}))},integrateCandidateServices:function(i,t){var s=t&&t.candidate_services||{},n=i.services,r=this;return e.forEach(n,(function(e,i){s[i]?n[i]=s[i]:n[i].isCandidate&&(n[i]=r.emptyUser().services[i])})),i},expandDismissed:function(i,t){var s=t?[]:[i];if(e.isArray(i.dismissed_merge_candidates))return s.concat(i.dismissed_merge_candidates.map(y));throw new TypeError("Developer Error: dismissed_merge_candidates must be an array.")},sendRequest:function(e,i,t){return e=new a.AngularAPICall(e,i,t),l=e.jqXHR,e.deferred},addInvitationIssues:function(e){e.has_invite&&(e.has_expired_invite?e.issues.unshift({type:"error",title:s.maketext("Invite Expired")+":",message:s.maketext("This user did not respond to the invitation before it expired. Please delete and re-create the user to send another invitation or set the user’s password yourself.")}):e.issues.unshift({type:"info",title:s.maketext("Invite Pending")+":",message:s.maketext("This user has not used the invitation to set a password.")}))}}),new x}])})),define("app/views/listController",["angular","lodash","cjt/util/locale","uiBootstrap","cjt/directives/alertList","cjt/services/alertService","cjt/directives/disableAnimations","cjt/directives/toggleSortDirective","cjt/directives/validationItemDirective","cjt/directives/spinnerDirective","cjt/directives/autoFocus","cjt/directives/lastItem","cjt/filters/wrapFilter","cjt/filters/breakFilter","cjt/services/dataCacheService","app/directives/issueList","app/directives/modelToLowerCase","app/services/userService"],(function(e,i,t){var s=e.module("App");return s.controller("listController",["$scope","$routeParams","$q","$location","$filter","$timeout","userService","spinnerAPI","alertService","wrapFilter","dataCache","features","quotaInfo",function(i,n,r,a,o,u,l,c,d,m,f,p,v){function g(e){i.userList&&(c.start("loadingSpinner"),u((function(){var t;if(i.totalItems=i.userList.length,e){var s=o("filter");t=s(i.userList,i.filterText),t=s(t,i.filterAdvanced),i.filteredData=!0}else t=i.filteredData?i.filteredUsers:i.userList;var n=i.meta.pageSize*(i.meta.pageNumber-1),r=i.meta.pageSize*i.meta.pageNumber,a=!1;r>t.length&&(a=!0),i.filteredTotalItems=t.length,i.filteredUsers=t,t.length<i.meta.pageSize?i.pagedFilteredUser=t:i.pagedFilteredUser=a?t.slice(n):t.slice(n,r);var u=i.pageTotalItems;i.pageTotalItems=t.length,0!==i.pageTotalItems&&u!==t.length||c.stop("loadingSpinner"),i.hideViewLoadingPanel()}),5))}i.doneRendering=function(e){c.stop("loadingSpinner")},i.edit=function(e){if(i.isOverQuota)return!1;if("sub"===e.type)i.loadView("edit/subaccount/"+e.guid,{},{clearAlerts:!0});else{if("service"!==e.type)return d.clear(),void d.add({type:"danger",message:t.maketext("You cannot edit the account."),id:"errorAccountNotValid"});var s;if(e.services.email&&e.services.email.enabled)s="email";else if(e.services.ftp&&e.services.ftp.enabled)s="ftp";else{if(!e.services.webdisk||!e.services.webdisk.enabled)return d.clear(),void d.add({type:"danger",message:t.maketext("The service account is invalid."),id:"errorServiceAccountNotValid"});s="webdisk"}i.loadView("edit/service/"+s+"/"+e.full_username,{},{clearAlerts:!0})}},i.filterText=function(e){return!i.meta.filterValue||["full_username","real_name","alternate_email","type","typeLabel","serviceSearch"].some((function(t){var s=e[t];if(s&&-1!==s.toLocaleLowerCase().indexOf(i.meta.filterValue))return!0}))},i.hasAdvancedSearch=function(){return"all"!==i.advancedFilters.services||"both"!==i.advancedFilters.issues},i.filterAdvanced=function(e){var t=function(e){var t=e.merge_candidates;return i.meta.filterValue&&(t=o("filter")(t,i.filterText)),!!(t=o("filter")(t,i.filterAdvanced)).length};if("noissues"===i.advancedFilters.issues)switch(e.type){case"hypothetical":if(!t(e))return!1;if(e.candidate_issues_count===e.merge_candidates.length)return!1;break;case"sub":if(e.issues.length>0||e.has_expired_invite||t(e)&&e.candidate_issues_count)return!1;break;default:if(e.issues.length>0)return!1}if("issues"===i.advancedFilters.issues)switch(e.type){case"hypothetical":if(!t(e))return!1;if(!e.candidate_issues_count)return!1;break;case"sub":if(!(0!==e.issues.length||e.has_expired_invite||t(e)&&e.candidate_issues_count))return!1;break;default:if(0===e.issues.length)return!1}return"all"===i.advancedFilters.services||(!("email"!==i.advancedFilters.services||!e.services.email.enabled&&!e.services.email.enabledInCandidate)||(!("ftp"!==i.advancedFilters.services||!e.services.ftp.enabled&&!e.services.ftp.enabledInCandidate)||!("webdisk"!==i.advancedFilters.services||!e.services.webdisk.enabled&&!e.services.webdisk.enabledInCandidate)))},i.sortList=function(e,t){if(i.selectedRow=-1,!t){var s=!i.advancedFilters.showLinkable;i.fetch(s)}},i.triggerClearSearch=function(e){27===e.keyCode&&i.clearSearch()},i.clearSearch=function(){i.meta.filterValue=""},i.fetch=function(){i.filteredUsers=[],i.filteredData=!1,i.showViewLoadingPanel();var e=!i.advancedFilters.showLinkable;return c.start("loadingSpinner"),l.fetchList(e,i.meta).then((function(e){f.set("userList",e.items),i.userList=f.get("userList"),i.totalItems=i.userList.length,i.pageNumber=1,g(!0)}),(function(e){d.add({type:"danger",message:e,id:"fetchError"})})).finally((function(){c.stop("loadingSpinner")}))},i.showDeleteConfirm=function(e){e.ui.showDeleteConfirm=!0},i.hideDeleteConfirm=function(e){e.ui.showDeleteConfirm=!1},i.canShowDeleteConfirm=function(e){return e.ui.showDeleteConfirm},i.isDeleting=function(e){return e.ui.deleting},i.deleteUser=function(e,t){return c.start("loadingSpinner"),e.ui.deleting=!0,l.delete(e).then((function(s){var n=t?t.merge_candidates:i.userList,r=n.indexOf(e);if(-1!==r){if(s.data)n.splice(r,1,s.data);else if(n.splice(r,1),t&&"hypothetical"===t.type&&1===t.merge_candidates.length){var a=i.userList.indexOf(t);-1!==a&&i.userList.splice(a,1,t.merge_candidates.pop())}f.set("userList",i.userList),g(!0)}}),(function(e){d.add({type:"danger",message:e,id:"deleteError"})})).finally((function(){e.ui.deleting=!1,c.stop("loadingSpinner")}))},i.wrappedDeleteText=function(e){var i=m(e.full_username,"[@.]",5);return t.maketext("Do you wish to remove the “[_1]” user from your system?",i)},i.linkUser=function(e,s){return c.start("loadingSpinner"),e.ui.linking=!0,w(e,s),l.link(e).then((function(e){var n=i.userList,r=n.indexOf(s);-1!==r&&(n.splice(r,1,e),f.set("userList",n),g(!0),d.add({type:"success",message:e.synced_password?t.maketext("The system successfully linked the service account to the “[_1]” user’s [asis,subaccount]. The service account passwords have not changed.",e.full_username):t.maketext("The system successfully linked the service account to the “[_1]” user’s [asis,subaccount]. The service account passwords did not change. You must provide a new password if you wish to enable any additional [asis,subaccount] services.",e.full_username),id:"link-user-success",replace:!1}))}),(function(e){d.add({type:"danger",message:e,id:"linkError"})})).finally((function(){c.stop("loadingSpinner"),e.ui.linking=!1,w(e,s)}))},i.dismissLink=function(e,t){return c.start("loadingSpinner"),e.ui.linking=!0,w(e,t),l.dismissLink(e).then((function(s){var n=i.userList,r=n.indexOf(t),a=n[r].merge_candidates.indexOf(e);if(-1!==a){var o=n[r].merge_candidates[a];if(n[r].merge_candidates.splice(a,1),h(n,o),"hypothetical"===n[r].type&&1===n[r].merge_candidates.length){var u=n[r].merge_candidates.pop();h(n,u),n.splice(r,1)}f.set("userList",n),g(!0)}}),(function(e){d.add({type:"danger",message:e,id:"dismissError"})})).finally((function(){c.stop("loadingSpinner"),e.ui.linking=!1,w(e,t)}))};var h=function(e,i){for(var t=0,s=e.length;t<s;t++){if(e[t].full_username>i.full_username)return void e.splice(t,0,i)}e.push(i)};i.linkAll=function(e){return c.start("loadingSpinner"),e.ui.linkingAny=e.ui.linkingAll=!0,l.linkAll(e).then((function(s){var n=i.userList,r=n.indexOf(e);-1!==r&&(n.splice(r,1,s),f.set("userList",n),g(!0)),d.add({type:"success",message:s.synced_password?t.maketext("The system successfully linked all of the service accounts for the “[_1]” user to the [asis,subaccount]. The service account passwords did not change.",s.full_username):t.maketext("The system successfully linked all of the service accounts for the “[_1]” user to the [asis,subaccount]. The service account passwords did not change. You must provide a new password if you wish to enable any additional [asis,subaccount] services.",s.full_username),id:"link-all-success",replace:!1})}),(function(e){d.add({type:"danger",message:e,id:"dismissError"})})).finally((function(){c.stop("loadingSpinner"),e.ui.linkingAny=e.ui.linkingAll=!1}))},i.dismissAll=function(e){return c.start("loadingSpinner"),e.ui.linkingAny=e.ui.linkingAll=!0,l.dismissAll(e).then((function(t){var s=i.userList,n=s.indexOf(e);if(-1!==n){for(var r=s[n].merge_candidates.shift();r;)h(s,r),r=s[n].merge_candidates.shift();"hypothetical"===e.type&&s.splice(n,1),f.set("userList",s),g(!0)}}),(function(e){d.add({type:"danger",message:e,id:"linkError"})})).finally((function(){c.stop("loadingSpinner"),e.ui.linkingAny=e.ui.linkingAll=!1}))};var w=function(e,i){i.ui.linkingAll=!0,i.ui.linkingAny=!1;for(var t=0,s=i.merge_candidates.length;t<s;t++)i.merge_candidates[t].ui.linking?i.ui.linkingAny=!0:i.ui.linkingAll=!1};i.showAdvancedSettings=!1,i.alerts=d.getAlerts(),i.isOverQuota=!v.under_quota_overall,i.openConfirmation=null,i.advancedFilters={services:"all",issues:"both",showLinkable:!0},i.hasFeature=PAGE.hasFeature,i.hasFeature&&(i.userList=[],i.filteredUserList=[],i.totalItems=0,i.meta={sortDirection:n.sortDirection||"asc",sortBy:n.sortBy||"full_username",sortType:n.sortType,pageSize:n.pageSize||50,pageNumber:n.pageNumber||1,pageSizes:[10,50,100,200]},i.features=p,i.filteredTotalItems=0,i.filteredUsers=[]),function(){var n;if(i.isOverQuota&&(d.clear(),d.add({message:t.maketext("Your [asis,cPanel] account exceeds its disk quota. You cannot add or edit users."),type:"danger",id:"over-quota-warning",replace:!1,counter:!1})),s.firstLoad.userList&&PAGE.userList){s.firstLoad.userList=!1;try{n=l.prepareList(PAGE.userList),PAGE.userList=null,f.set("userList",n.items),i.userList=f.get("userList"),i.totalItems=i.userList.length}catch(i){d.clear();var r=i;e.isArray(r)||(r=[r]),r.forEach((function(e){d.add({type:"danger",message:e.toString(),id:"fetchError"})}))}}else a.search().loadFromCache&&(i.userList=f.get("userList"))?(i.totalItems=i.userList.length,i.filteredTotalItems=i.userList.length):i.fetch(!i.advancedFilters.showLinkable);return i.filteredData=!1,u((function(){g(!0)}),5)}().finally((function(){i.$watchGroup(["meta.filterValue","advancedFilters.services","advancedFilters.issues"],(function(e,i){g(!0)})),i.$watchGroup(["meta.pageSize","meta.pageNumber"],(function(e,i){g()}))}))}])})),define("app/directives/validateUsernameWithDomain",["angular","cjt/util/locale","cjt/validator/validator-utils","cjt/validator/validateDirectiveFactory","app/services/userService"],(function(e,i,t,s,n){"use strict";var r=e.module("App");r.directive("usernameWithDomainWrapper",[function(){var i=function(e){this.username=this.domain="",this.$attrs=e};return e.extend(i.prototype,{setDomain:function(e){return void 0!==e&&(this.domain=e),this.getTotalLength()},setUsername:function(e){return void 0!==e&&(this.username=e),this.getTotalLength()},getUsernameAndDomain:function(){return this.username+"@"+this.domain},getTotalLength:function(){return this.getUsernameAndDomain().length}}),{restrict:"A",scope:!1,controller:["$attrs",i]}}]),r.directive("usernameWithDomain",["userService","$q",function(e,n){return{restrict:"A",scope:!1,require:["^^usernameWithDomainWrapper","ngModel"],link:function(r,a,o,u){var l=u[0],c=u[1],d=o.usernameWithDomain;if("username"===d){l.validateUsername=c.$validate;var m=a.controller("form");t.initializeExtendedReporting(c,m);var f=function(e){var s=t.initializeValidationResult();return e>254&&s.addError("maxLength",i.maketext("The combined length of the username, [asis,@] character, and domain cannot exceed [numf,_1] characters.",254)),s};c.$validators.usernameWithDomain=function(e){var i=l.setUsername(e);return s.run("usernameWithDomain",c,m,f,i)};var p=function(i){return e.checkAccountConflicts(i).then((function(e){return r.$eval(l.$attrs.lookupCallback,{responseData:e}),e})).then((function(){return t.initializeValidationResult()}),(function(e){var i=t.initializeValidationResult(!0);return i.addError("usernameIsAvailable",e),i}))};c.$asyncValidators.usernameIsAvailable=function(e,i){var t=l.getUsernameAndDomain();return s.runAsync(n,"usernameIsAvailable",c,m,p,t)}}else{if("domain"!==d)throw new Error("The value for the username-with-domain directive needs to be set to 'username' or 'domain'.");c.$formatters.push((function(e){return l.setDomain(c.$modelValue),e})),c.$viewChangeListeners.push((function(){l.setDomain(c.$modelValue),l.validateUsername()}))}}}}])})),define("app/directives/selectOnFocus",["angular"],(function(e){e.module("App").directive("selectOnFocus",["$timeout",function(e){return{restrict:"A",link:function(i,t,s){var n,r=null;1===(n="input"===t[0].tagName?t:t.find("input")).length&&(n.on("focus",(function(){var i=this;r!==i&&(r=i,e((function(){i.select&&i.select()}),10))})),n.on("blur",(function(){r=null})))}}}])})),define("app/directives/limit",["angular","lodash","cjt/core","cjt/util/locale","cjt/directives/bytesInput","app/directives/selectOnFocus"],(function(e,i,t,s){function n(i,t){return e.isString(i)&&(i=parseInt(i,10)),isNaN(i)?t:i}e.module("App").directive("appLimit",["$timeout","$templateCache","$document",function(i,s,r){var a=1,o="directives/limit.phtml";return{restrict:"E",templateUrl:t.config.debug?t.buildFullPath("user_manager/directives/limit.phtml"):o,replace:!0,require:"ngModel",scope:{id:"@?id",unitsLabel:"@?unitsLabel",unlimitedLabel:"@?unlimitedLabel",unlimitedValue:"=unlimitedValue",minimumValue:"=minimumValue",maximumValue:"=maximumValue",isDisabled:"=ngDisabled",defaultValue:"=defaultValue",maximumLength:"=maximumLength",selectedUnit:"="},compile:function(t,s){return{pre:function(i,t,s){e.isUndefined(s.unlimitedLabel)&&(s.unlimitedLabel="Unlimited"),s.id||(s.id="ctrlLimit_"+a++)},post:function(t,s,a,o){e.isUndefined(t.unlimitedValue)&&(t.unlimitedValue=0),e.isUndefined(t.minimumValue)&&(t.minimumValue=1),t.maximumLength=n(t.maximumLength,null),t.unlimitedValue=n(t.unlimitedValue,0),t.minimumValue=n(t.minimumValue,1),t.maximumValue=n(t.maximumValue,null),t.defaultValue=n(t.defaultValue,null),t.selectedUnit=t.selectedUnit||"MB";var u=s.find(".textbox");o.$formatters.push((function(e){var i=e===t.unlimitedValue;return{unlimitedChecked:i,value:i?"":e}})),o.$render=function(){t.unlimitedChecked=o.$viewValue.unlimitedChecked,t.value=o.$viewValue.value},o.$parsers.push((function(e){return e.unlimitedChecked?t.unlimitedValue:e.value})),t.$watch("unlimitedChecked + value",(function(e,i){e!==i&&o.$setViewValue({unlimitedChecked:t.unlimitedChecked,value:t.unlimitedChecked?"":t.value})})),t.maximumLength&&t.maximumLength>0&&u.on("input",(function(e){this.value.length>t.maximumLength&&(this.value=this.value.slice(0,t.maximumLength))})),t.makeUnlimited=function(){""!==t.value?t.lastValue=t.value:t.defaultValue?t.lastValue=t.defaultValue:t.lastValue=t.minimumValue,t.unlimitedChecked=!0,t.value=""},t.enableLimit=function(){var n,a;t.isDisabled||(t.unlimitedChecked&&(""===t.value&&(""!==t.lastValue?t.value=t.lastValue:t.defaultValue?t.value=t.defaultValue:t.value=t.minimumValue),t.unlimitedChecked=!1),0===u.length&&(u=s.find(".textbox")),a=0,(n=u)&&(r.activeElement?r.activeElement:null)!==n&&(e.isUndefined(a)?n.focus():i((function(){n.focus()}),a)))},t.defaultValue?t.lastValue=t.defaultValue:t.lastValue=t.minimumValue}}}}}])})),define("app/directives/serviceConfigController",["angular","cjt/util/test"],(function(e,i){e.module("App").controller("serviceConfigController",["$scope","$attrs",function(e,t){e.needsConflictResolution=function(){return e.hasConflict()&&!e.isResolved()},e.hasConflict=function(){return e.service&&e.service.isCandidate},e.isResolved=function(){return e.service.willLink||e.service.willDismiss},e.hasLinkAction=function(){return!!t.linkAction},e.setDismiss=function(){e.service.willDismiss=!0,e.service.enabled=!1,e.validateConflictResolution()},e.setLink=function(){e.service.willLink=!0,e.service.enabled=!0,e.validateConflictResolution()},e.clearConflictResolution=function(){e.service.willLink=e.service.willDismiss=!1,e.validateConflictResolution()},e.runLinkAction=function(){if(e.isLinking=!0,e.setLink(),e.hasLinkAction()){var t=e.linkAction({service:e.service});return i.isQPromise(t)?t.finally((function(){e.isLinking=!1})):e.isLinking=!1,t}e.isLinking=!1},e.validateConflictResolution=function(){e.conflictResolutionRequired&&e.ngModel.$setValidity("conflictCleared",!e.needsConflictResolution())},e.toggleConflictSummary=function(){e.isSummaryCollapsed=!e.isSummaryCollapsed},e.isSummaryCollapsed=!0}])})),define("app/directives/emailServiceConfig",["angular","lodash","cjt/core","cjt/util/locale","cjt/directives/toggleSwitchDirective","cjt/filters/wrapFilter","app/directives/limit","app/directives/serviceConfigController"],(function(e,i,t,s){e.module("App").directive("emailConfig",["defaultInfo",function(i){var n="directives/emailServiceConfig.ptt";return{restrict:"AE",templateUrl:t.config.debug?t.buildFullPath("user_manager/directives/emailServiceConfig.ptt"):n,replace:!0,require:"ngModel",scope:{toggleService:"&toggleService",isDisabled:"=ngDisabled",showToggle:"=showToggle",showUnlink:"=showUnlink",unlinkService:"&unlinkService",isInProgress:"&isInProgress",showInfo:"=showInfo",infoMessage:"@infoMessage",showWarning:"=showWarning",warningMessage:"@warningMessage",showConflictDismiss:"=?",conflictResolutionRequired:"=?",linkAction:"&?"},controller:"serviceConfigController",link:function(t,n,r,a){t.ngModel=a,(e.isUndefined(t.showWarning)||e.isUndefined(t.warningMessage)||""===t.warningMessage)&&(t.showWarning=!1),(e.isUndefined(t.showInfo)||e.isUndefined(t.infoMessage)||""===t.infoMessage)&&(t.showInfo=!1),e.isUndefined(t.showToggle)&&(t.showToggle=!0),e.isUndefined(t.showUnlink)&&(t.showUnlink=!1),a.$render=function(){t.service=a.$modelValue,t.validateConflictResolution()},t.defaults=i,t.maxMessage=s.maketext("Quotas cannot exceed [format_bytes,_1].",1048576*i.email.max_quota)}}}])})),define("app/services/directoryLookupService",["angular","lodash","cjt/core","cjt/util/locale","cjt/io/api","cjt/io/uapi-request","cjt/io/uapi","cjt/util/parse"],(function(e,i,t,s,n,r,a,o){"use strict";var u=e.module("cpanel.services.directoryLookup",[]),l=null;u.factory("directoryLookupService",["$q","APIService",function(i,t){var s=function(){};return s.prototype=new t,e.extend(s.prototype,{complete:function(e){l&&l.abort();var i=new r.Class;return i.initialize("Fileman","autocompletedir"),i.addArgument("path",e),i.addArgument("dirsonly",!0),i.addArgument("skipreserved",!0),i.addArgument("html",0),"/"===e.charAt(e.length-1)&&i.addArgument("list_all",!0),this.deferred(i,{transformAPISuccess:function(e){for(var i=[],t=0,s=e.data.length;t<s;t++)i.push(e.data[t].file);return i}}).promise},sendRequest:function(e,i,s){return e=new t.AngularAPICall(e,i,s),l=e.jqXHR,e.deferred}}),new s}])})),define("app/directives/ftpServiceConfig",["angular","lodash","cjt/core","cjt/util/locale","cjt/directives/toggleSwitchDirective","cjt/filters/wrapFilter","cjt/filters/htmlFilter","app/services/directoryLookupService","app/directives/limit","app/directives/serviceConfigController"],(function(e,i,t,s){e.module("App").directive("ftpConfig",["defaultInfo","ftpDaemonInfo","directoryLookupService",function(i,s,n){var r="directives/ftpServiceConfig.ptt";return{restrict:"AE",templateUrl:t.config.debug?t.buildFullPath("user_manager/directives/ftpServiceConfig.ptt"):r,replace:!0,require:"ngModel",scope:{toggleService:"&toggleService",isDisabled:"=ngDisabled",showToggle:"=showToggle",showUnlink:"=showUnlink",unlinkService:"&unlinkService",isInProgress:"&isInProgress",showInfo:"=showInfo",infoMessage:"@infoMessage",showWarning:"=showWarning",warningMessage:"@warningMessage",showConflictDismiss:"=?",conflictResolutionRequired:"=?",linkAction:"&?"},controller:"serviceConfigController",link:function(t,r,a,o){t.ngModel=o,(e.isUndefined(t.showWarning)||e.isUndefined(t.warningMessage)||""===t.warningMessage)&&(t.showWarning=!1),(e.isUndefined(t.showInfo)||e.isUndefined(t.infoMessage)||""===t.infoMessage)&&(t.showInfo=!1),e.isUndefined(t.showToggle)&&(t.showToggle=!0),e.isUndefined(t.showUnlink)&&(t.showUnlink=!1),o.$render=function(){t.service=o.$modelValue,t.validateConflictResolution()},t.daemon=s,t.defaults=i,t.completeDirectory=function(e){return n.complete(e)}}}}])})),define("app/directives/webdiskServiceConfig",["angular","lodash","cjt/core","cjt/util/locale","cjt/directives/toggleSwitchDirective","cjt/filters/wrapFilter","cjt/filters/htmlFilter","app/services/directoryLookupService","app/directives/limit","app/directives/serviceConfigController"],(function(e,i,t,s){e.module("App").directive("webdiskConfig",["defaultInfo","sslInfo","directoryLookupService",function(i,s,n){var r="directives/webdiskServiceConfig.ptt";return{restrict:"AE",templateUrl:t.config.debug?t.buildFullPath("user_manager/directives/webdiskServiceConfig.ptt"):r,replace:!0,require:"ngModel",scope:{toggleService:"&toggleService",isDisabled:"=ngDisabled",showToggle:"=showToggle",showUnlink:"=showUnlink",unlinkService:"&unlinkService",isInProgress:"&isInProgress",enableDigestControls:"=enableDigestControls",showDigestWarning:"=showDigestWarning",showInfo:"=showInfo",infoMessage:"@infoMessage",showWarning:"=showWarning",warningMessage:"@warningMessage",showConflictDismiss:"=?",conflictResolutionRequired:"=?",linkAction:"&?"},controller:"serviceConfigController",link:function(t,r,a,o){t.ngModel=o,e.isUndefined(t.showDigestWarning)&&(t.showDigestWarning=!1),(e.isUndefined(t.showWarning)||e.isUndefined(t.warningMessage)||""===t.warningMessage)&&(t.showWarning=!1),(e.isUndefined(t.showInfo)||e.isUndefined(t.infoMessage)||""===t.infoMessage)&&(t.showInfo=!1),e.isUndefined(t.showToggle)&&(t.showToggle=!0),e.isUndefined(t.showUnlink)&&(t.showUnlink=!1),e.isUndefined(t.enableDigestControls)&&(t.enableDigestControls=!0),o.$render=function(){t.service=o.$modelValue,t.validateConflictResolution()},t.defaults=i,t.allowDigestAuth=s.is_self_signed,t.completeDirectory=function(e){return n.complete(e)}}}}])})),define("app/views/addEditController",["angular","lodash","cjt/util/locale","cjt/validator/email-validator","cjt/directives/validationItemDirective","cjt/directives/validationContainerDirective","cjt/directives/validateEqualsDirective","cjt/directives/passwordFieldDirective","cjt/directives/actionButtonDirective","app/directives/validateUsernameWithDomain","app/directives/emailServiceConfig","app/directives/ftpServiceConfig","app/directives/webdiskServiceConfig","uiBootstrap"],(function(e,i,t){var s=e.module("App");return function(n,r,a,o,u,l,c,d,m){return{initializeScope:function(){n.ui={docrootByDomain:PAGE.docrootByDomain,domainList:Object.keys(PAGE.docrootByDomain),user:r.emptyUser()},n.isOverQuota=!d.under_quota_overall,n.ui.user.domain=PAGE.primaryDomain,n.ui.user.services.ftp.homedir=PAGE.docrootByDomain[PAGE.primaryDomain]+"/",n.ui.user.services.webdisk.homedir=PAGE.docrootByDomain[PAGE.primaryDomain]+"/",n.inProgress=!1,n.minimumPasswordStrength=e.isDefined(PAGE.minimumPasswordStrength)?parseInt(PAGE.minimumPasswordStrength,10):10,n.emailDaemon=a,n.ftpDaemon=o,n.webdiskDaemon=u,n.features=l,n.defaults=c,n.quotaInfo=d,n.useCandidateServices=this.useCandidateServices,n.insertSubAndRemoveDupes=this.insertSubAndRemoveDupes},initializeView:function(){m.clear(),this.showCpanelOverQuotaWarning()},clearPrefetch:function(){s.firstLoad.userList=!1},useCandidateServices:function(e,i){r.integrateCandidateServices(e,i)},insertSubAndRemoveDupes:function(t,s){var n=i.sortedIndexBy(s,t,"full_username"),a=[];e.forEach(t.services,(function(e,i){e.enabled&&a.push(i)})),t.dismissed_merge_candidates&&t.dismissed_merge_candidates.forEach((function(e){a.push(e.service)}));for(var o,u,l,c=n;s[c]&&s[c].full_username===t.full_username;){if("service"!==(u=s[c]).type)o=!0;else for(var d=0,m=a.length;d<m;d++)if(l=a[d],u.services[l].enabled){o=!0;break}o?s.splice(c,1):c++}var f=r.expandDismissed(t);s.splice.apply(s,[n,0].concat(f))},showCpanelOverQuotaWarning:function(){n.isOverQuota&&m.add({message:t.maketext("Your [asis,cPanel] account exceeds its disk quota. You cannot add or edit users."),type:"danger",id:"over-quota-warning",replace:!1,counter:!1})}}}})),define("app/views/addController",["angular","lodash","cjt/util/locale","app/views/addEditController","cjt/directives/alertList","cjt/directives/bytesInput","cjt/directives/toggleLabelInfoDirective","cjt/directives/toggleSwitchDirective","cjt/directives/labelSuffixDirective","cjt/services/alertService","app/services/userService","cjt/services/dataCacheService"],(function(e,i,t,s){return e.module("App").controller("addController",["$scope","$routeParams","$timeout","$location","$anchorScroll","userService","alertService","directoryLookupService","dataCache","defaultInfo","quotaInfo","emailDaemonInfo","ftpDaemonInfo","webdiskDaemonInfo","features","spinnerAPI",function(i,n,r,a,o,u,l,c,d,m,f,p,v,g,h,w){var b=s(i,u,p,v,g,h,m,f,l),_=function(){b.initializeScope(),i.ui.user.sendInvite=i.ui.isInviteSubEnabled=!!window.PAGE.isInviteSubEnabled};_(),b.initializeView(),i.toggleService=function(e){e.enabled=!e.enabled},i.create=function(s,n){return i.inProgress=!0,l.clear(),o("btn-create"),u.create(s).then((function(s){var a,u=d.get("userList");if(u?(i.insertSubAndRemoveDupes(s,u),d.set("userList",u),a={loadFromCache:!0}):a={loadFromCache:!1},b.clearPrefetch(),l.add({type:"success",message:t.maketext("You successfully created the following user: [_1]",s.real_name||s.full_username),id:"createSuccess",autoClose:1e4}),n)i.loadView("list/rows",a);else{var c=i.ui.user.domain;_(),i.ui.user.domain=c,i.form.$setPristine(),o("top"),r((function(){var i=e.element("#full-name");i&&i.focus()}),10)}}),(function(e){var n=s.real_name||s.username+"@"+s.domain;e=e.error||e,l.add({type:"danger",message:t.maketext("The system failed to create the “[_1]” user with the following error: [_2]",n,e),id:"createError"}),o("top");var r=d.get("userList");e.user&&r&&(i.insertSubAndRemoveDupes(e.user,r),d.set("userList",r)),b.clearPrefetch()})).finally((function(){i.inProgress=!1}))},i.$watch("ui.user.services.ftp.homedir",(function(){i.ui.user.services.ftp.homedir||!i.form.txtFtpHomeDirectory||i.form.txtFtpHomeDirectory.$pristine||i.form.txtFtpHomeDirectory.$setViewValue("/")})),i.$watch("ui.user.services.webdisk.homedir",(function(){i.ui.user.services.webdisk.homedir||!i.form.txtWebDiskHomeDirectory||i.form.txtWebDiskHomeDirectory.$pristine||i.form.txtWebDiskHomeDirectory.$setViewValue("/")})),i.$watch("ui.user.username + '@' + ui.user.domain",(function(e,t){var s=e.split("@");!i.ui.user.services.ftp.isCandidate&&i.form.txtFtpHomeDirectory&&i.form.txtFtpHomeDirectory.$pristine&&(i.ui.user.services.ftp.homedir=i.ui.docrootByDomain[s[1]]+"/"+s[0]),!i.ui.user.services.webdisk.isCandidate&&i.form.txtWebDiskHomeDirectory&&i.form.txtWebDiskHomeDirectory.$pristine&&(i.ui.user.services.webdisk.homedir=i.ui.docrootByDomain[s[1]]+"/"+s[0])}))}])})),define("app/views/editController",["angular","lodash","cjt/util/locale","app/views/addEditController","cjt/directives/alertList","cjt/directives/toggleLabelInfoDirective","cjt/directives/toggleSwitchDirective","cjt/services/alertService","cjt/directives/spinnerDirective","app/directives/issueList","app/services/userService","cjt/services/dataCacheService"],(function(e,i,t,s){return e.module("App").controller("editController",["$scope","$route","$routeParams","$timeout","$location","$anchorScroll","userService","alertService","spinnerAPI","dataCache","defaultInfo","quotaInfo","emailDaemonInfo","ftpDaemonInfo","webdiskDaemonInfo","features",function(e,n,r,a,o,u,l,c,d,m,f,p,v,g,h,w){var b=s(e,l,v,g,h,w,f,p,c);function _(i){return d.start("loadingSpinner"),e.ui.isSaving=!0,l.edit(i).then((function(i){var s=m.get("userList"),n=!1;s&&(e.insertSubAndRemoveDupes(i,s),m.set("userList",s),n=!0),d.stop("loadingSpinner"),e.ui.isSaving=!1,e.loadView("list/rows",{loadFromCache:n}),c.add({type:"success",message:t.maketext("The system successfully updated the following user: [_1]",i.full_username),id:"updateUserSuccess",autoClose:1e4})}),(function(s){s=s.error||s,c.clear(),c.add({type:"danger",message:t.maketext("The system failed to update the “[_1]” user with the following error: [_2]",i.full_username,s),id:"updateFailedErrorServer"}),d.stop("loadingSpinner"),e.ui.isSaving=!1,u("top")}))}function k(e,i){return"service"===e.type&&(!1===i.enabled||!1===i.enabledigest)||"sub"===e.type&&(!1===i.enabled||!1===i.enabledigest)}function y(s){if(s)return e.ui.isLoading=!0,e.ui.user=null,d.start("loadingSpinner"),e.ui.user=l.emptyUser(),l.fetchUser(r.guid).then((function(t){e.ui.user=t,e.ui.originalServices=i.cloneDeep(t.services),e.useCandidateServices(t,t),l.addInvitationIssues(t),d.stop("loadingSpinner"),e.ui.isLoading=!1}),(function(i){c.clear(),c.add({type:"warn",message:t.maketext("The system could not load the [asis,subaccount] with the following error: [_1]",i),id:"missingUserWarning"}),e.loadView("list/rows",{loadFromCache:!0})}));c.clear(),c.add({type:"warn",message:t.maketext("You did not select a [asis,subaccount]."),id:"missingUserWarning"}),e.loadView("list/rows",{loadFromCache:!0})}function S(){e.ui.user.synced_password||c.add({type:"warn",message:t.maketext("You cannot enable additional services for this [asis,subaccount] until you set its password. When you set the password, all of your services will utilize the same password."),id:"unsyncedPasswordWarning",replace:!1,counter:!1})}b.initializeScope(),b.initializeView(),e.toggleService=function(e){e.enabled=!e.enabled},e.update=function(i){switch(u("btn-save"),e.mode){case"subaccount":return _(i);case"service":return function(i){return d.start("loadingSpinner"),e.ui.isSaving=!0,e.canPromote(i)?l.link(i,e.ui.originalServiceType,!0).then((function(t){var s=m.get("userList");return e.insertSubAndRemoveDupes(i,s),m.set("userList",s),i.type="sub",i.guid=t.guid,_(i)}),(function(e){c.clear(),c.add({type:"danger",message:t.maketext("The system failed to upgrade the “[_1]” service account to a [asis,subaccount] with the following error: [_2]",i.full_username,e),id:"updateFailedErrorServer"}),u("top")})).finally((function(){d.stop("loadingSpinner"),e.ui.isSaving=!1})):l.editService(i,e.ui.originalService).then((function(){e.loadView("list/rows",{loadFromCache:!1}),c.add({type:"success",message:t.maketext("The system successfully modified the service account: [_1]",i.full_username),id:"updateServiceSuccess",autoClose:1e4})})).catch((function(e){c.add({type:"danger",message:t.maketext("The system failed to modify the service account for “[_1]”: [_2]",i.full_username,e),id:"updateServiceFailed"}),u("top")})).finally((function(){d.stop("loadingSpinner"),e.ui.isSaving=!1}))}(i);default:return c.clear(),void c.add({type:"danger",message:t.maketext("The system did not recognize the update mode: [_1]",e.mode),id:"updateUnrecognizedMode"})}},e.isInProgress=function(){return e.ui.isSaving||e.ui.isLoading},e.unlinkService=function(i,s){return d.start("loadingSpinner"),e.ui.isSaving=!0,l.unlink(i,s).then((function(){return m.remove("userList"),y(i.guid).then((function(){d.stop("loadingSpinner"),e.ui.isSaving=!1,c.add({type:"success",message:t.maketext("The system successfully unlinked the “[_1]” service.",s),id:"unlinkServiceSuccess",autoClose:1e4})}))}),(function(i){c.clear(),c.add({type:"danger",message:t.maketext("The system failed to unlink the “[_1]” service with the following error: [_2]",s,i),id:"unlinkServiceFailed"}),d.stop("loadingSpinner"),e.ui.isSaving=!1,u("top")}))},e.isAllowed=function(i,t){return e.canPromote(i)||t.enabled},e.canEnableDigest=function(i){return!k(i,e.ui.originalServices.webdisk)||!!i.password},e.showDigestRequiresPasswordWarning=function(i){return k(i,e.ui.originalServices.webdisk)&&i.services.webdisk.enabled},e.showUnlink=function(e,i){return!e.synced_password&&!e.services[i].isNew&&!e.services[i].isCandidate},e.canPromote=function(e){return"sub"===e.type||("service"===e.type?!e.has_siblings&&!e.sub_account_exists:void 0)},e.$watch("ui.user.services.ftp.homedir",(function(){e.ui.user.services.ftp.homedir||!e.form.txtFtpHomeDirectory||e.form.txtFtpHomeDirectory.$pristine||e.form.txtFtpHomeDirectory.$setViewValue("/")})),e.$watch("ui.user.services.webdisk.homedir",(function(){e.ui.user.services.webdisk.homedir||!e.form.txtWebDiskHomeDirectory||e.form.txtWebDiskHomeDirectory.$pristine||e.form.txtWebDiskHomeDirectory.$setViewValue("/")})),e.$watch("ui.user.password",(function(i){""!==i||e.canAddServices(e.ui.user)||["email","ftp","webdisk"].forEach((function(i){e.ui.user.services[i].enabled=e.ui.originalServices[i].enabled}))})),e.canAddServices=function(e){return!!e.synced_password||!!e.password},e.linkServices=function(s){return d.start("loadingSpinner"),e.ui.isSaving=!0,l.linkAndDismiss(s).then((function(s){var n=m.get("userList");n&&(e.insertSubAndRemoveDupes(s,n),m.set("userList",n)),e.ui.user.synced_password=s.synced_password,s.linked_services.forEach((function(t){e.ui.user.services[t]=s.services[t],e.ui.originalServices[t]=i.cloneDeep(s.services[t])})),c.add({type:"success",message:s.synced_password?t.maketext("The system successfully linked the service account to the “[_1]” user’s [asis,subaccount]. The service account passwords have not changed.",s.full_username):t.maketext("The system successfully linked the service account to the “[_1]” user’s [asis,subaccount]. The service account passwords have not changed. You must provide a new password if you enable any additional [asis,subaccount] services.",s.full_username),id:"link-user-success",replace:!1})})).catch((function(e){c.add({type:"danger",message:e.error?e.error:e,id:"link"===e.call?"link-error":"link-and-dismiss-error"}),u("top")})).finally((function(){e.ui.isSaving=!1,d.stop("loadingSpinner")}))},/^\/edit\/subaccount/.test(n.current.originalPath)?(e.mode="subaccount",y(r.guid).finally(S)):/^\/edit\/service/.test(n.current.originalPath)&&(e.mode="service",function(s,n){if(s&&n)return e.ui.isLoading=!0,e.ui.user=null,d.start("loadingSpinner"),e.ui.user=l.emptyUser(),l.fetchService(s,n).then((function(t){e.ui.user=t,"email"===s&&0===t.services.email.quota&&0!==e.defaults.email.unlimitedValue&&(t.services.email.quota=e.defaults.email.unlimitedValue),e.ui.originalService=i.cloneDeep(t.services[s]),e.ui.originalServiceType=s,e.ui.originalServices=i.cloneDeep(t.services),e.ui.user.synced_password=!0,d.stop("loadingSpinner"),e.ui.isLoading=!1}),(function(i){c.clear(),c.add({type:"warn",message:t.maketext("The system could not load the service account with the following error: [_1]",i),id:"missingServiceWarning"}),e.loadView("list/rows",{loadFromCache:!0})})).finally((function(){e.ui.user&&!e.canPromote(e.ui.user)&&c.add({type:"warn",message:t.maketext("The system cannot upgrade this service account to a [asis,subaccount]. To access all the features within this interface, you must delete any accounts that share the same username or link this service account to a [asis,subaccount]."),id:"cannotPromoteWarning"})}));c.clear(),c.add({type:"warn",message:t.maketext("You did not select a valid service account."),id:"missingUserWarning"}),e.loadView("list/rows",{loadFromCache:!0})}(r.type,r.user).finally(S))}])})),define("app/services/serverInfoService",["angular","lodash","cjt/util/parse"],(function(e,i,t){e.module("App").factory("serverInfoService",[function(){var s={prepareSslInfo:function(e){return e.cert_valid_not_after=new Date(1e3*e.cert_valid_not_after),e.cert_valid=new Date<e.cert_valid_not_after,e.is_self_signed=t.parsePerlBoolean(e.is_self_signed),e.is_wild_card=t.parsePerlBoolean(e.is_wild_card),e.ssldomain_matches_cert=t.parsePerlBoolean(e.ssldomain_matches_cert),e},prepareFtpDaemonInfo:function(e){return e.enabled=t.parsePerlBoolean(e.enabled),e.supports.quota=t.parsePerlBoolean(e.supports.quota),e.supports.login_without_domain=t.parsePerlBoolean(e.supports.login_without_domain),e},prepareDefaultInfo:function(e){return i.each(["email","ftp","webdisk"],(function(s){var n=e[s];i.each(["default_quota","default_value","max_quota","unlimitedValue"],(function(e){n[e]=parseInt(n[e],10),isNaN(n[e])&&(n[e]=0)})),n.select_unlimited=t.parsePerlBoolean(n.select_unlimited)})),e},prepareQuotaInfo:function(e){return s.parseObj(e,{under_megabyte_limit:t.parsePerlBoolean,under_inode_limit:t.parsePerlBoolean,under_quota_overall:t.parsePerlBoolean,inodes_used:t.parseInteger,inode_limit:t.parseInteger,inodes_remain:t.parseInteger,megabytes_used:t.parseNumber,megabyte_limit:t.parseNumber,megabytes_remain:t.parseNumber})},parseObj:function(i,t){return e.forEach(t,(function(e,t){i[t]=e(i[t])})),i}};return s}])})),define("app/index",["angular","jquery","cjt/core","cjt/modules","ngRoute","uiBootstrap"],(function(e,i,t){return function(){return e.module("App",["ngRoute","ui.bootstrap","cjt2.cpanel","cpanel.services.directoryLookup"]),require(["cjt/bootstrap","cjt/views/applicationController","cjt/services/autoTopService","app/views/listController","app/views/addController","app/views/editController","app/services/serverInfoService"],(function(i){var s=e.module("App");s.firstLoad={userList:!0},s.factory("emailDaemonInfo",(function(){return{enabled:PAGE.isEmailRunning,name:"exim",supports:{quota:!0}}})),s.factory("ftpDaemonInfo",["serverInfoService",function(e){return e.prepareFtpDaemonInfo(PAGE.ftpDaemonInfo)}]),s.factory("webdiskDaemonInfo",(function(){return{enabled:PAGE.isWebdavRunning,name:"cpdavd",supports:{quota:!1}}})),s.factory("sslInfo",["serverInfoService",function(e){return e.prepareSslInfo(PAGE.sslInfo)}]),s.factory("quotaInfo",["serverInfoService",function(e){return e.prepareQuotaInfo(PAGE.quotaInfo)}]),s.factory("defaultInfo",["serverInfoService",function(e){return e.prepareDefaultInfo(PAGE.serviceDefaults)}]),s.value("features",PAGE.features),s.config(["$routeProvider",function(e){e.when("/list/cards",{controller:"listController",templateUrl:t.buildFullPath("user_manager/views/listCardsView.phtml")}),e.when("/list/rows",{controller:"listController",templateUrl:"user_manager/views/listRowsView.ptt"}),e.when("/add",{controller:"addController",templateUrl:"user_manager/views/addEditView.ptt"}),e.when("/edit/subaccount/:guid",{controller:"editController",templateUrl:"user_manager/views/editView.ptt"}),e.when("/edit/service/:type/:user",{controller:"editController",templateUrl:"user_manager/views/editView.ptt"}),e.otherwise({redirectTo:"/list/rows"})}]),s.run(["autoTopService",function(e){e.initialize()}]),i("#content","App")}))}}));